/* valacodecontext.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACODECONTEXT_H__
#define __VALACODECONTEXT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContextPrivate ValaCodeContextPrivate;

/**
 * The root of the code tree.
 */
struct _ValaCodeContext {
	GObject parent;
	ValaCodeContextPrivate * priv;
};
struct _ValaCodeContextClass {
	GObjectClass parent;
};

ValaSymbol* vala_code_context_get_root (ValaCodeContext* self);
GList* vala_code_context_get_source_files (ValaCodeContext* self);
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_code_context_find_header_cycles (ValaCodeContext* self);
char* vala_code_context_get_library (ValaCodeContext* self);
void vala_code_context_set_library (ValaCodeContext* self, const char* value);
ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self);
void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value);
GType vala_code_context_get_type ();

G_END_DECLS

#endif
