/* valaccodeswitchstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODESWITCHSTATEMENT_H__
#define __VALACCODESWITCHSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_SWITCH_STATEMENT (vala_ccode_switch_statement_get_type ())
#define VALA_CCODE_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_SWITCH_STATEMENT, ValaCCodeSwitchStatement))
#define VALA_CCODE_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_SWITCH_STATEMENT, ValaCCodeSwitchStatementClass))
#define VALA_IS_CCODE_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_SWITCH_STATEMENT))
#define VALA_IS_CCODE_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_SWITCH_STATEMENT))
#define VALA_CCODE_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_SWITCH_STATEMENT, ValaCCodeSwitchStatementClass))

typedef struct _ValaCCodeSwitchStatement ValaCCodeSwitchStatement;
typedef struct _ValaCCodeSwitchStatementClass ValaCCodeSwitchStatementClass;
typedef struct _ValaCCodeSwitchStatementPrivate ValaCCodeSwitchStatementPrivate;

/**
 * Represents a switch selection statement in the C code.
 */
struct _ValaCCodeSwitchStatement {
	ValaCCodeStatement parent;
	ValaCCodeSwitchStatementPrivate * priv;
};
struct _ValaCCodeSwitchStatementClass {
	ValaCCodeStatementClass parent;
};

ValaCCodeSwitchStatement* vala_ccode_switch_statement_new (ValaCCodeExpression* expr);
void vala_ccode_switch_statement_add_case (ValaCCodeSwitchStatement* self, ValaCCodeCaseStatement* case_stmt);
ValaCCodeExpression* vala_ccode_switch_statement_get_expression (ValaCCodeSwitchStatement* self);
void vala_ccode_switch_statement_set_expression (ValaCCodeSwitchStatement* self, ValaCCodeExpression* value);
GType vala_ccode_switch_statement_get_type ();

G_END_DECLS

#endif
