/* valaccodeblock.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODEBLOCK_H__
#define __VALACCODEBLOCK_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_BLOCK (vala_ccode_block_get_type ())
#define VALA_CCODE_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlock))
#define VALA_CCODE_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlockClass))
#define VALA_IS_CCODE_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BLOCK))
#define VALA_IS_CCODE_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BLOCK))
#define VALA_CCODE_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlockClass))

typedef struct _ValaCCodeBlock ValaCCodeBlock;
typedef struct _ValaCCodeBlockClass ValaCCodeBlockClass;
typedef struct _ValaCCodeBlockPrivate ValaCCodeBlockPrivate;

/**
 * Represents a C code block.
 */
struct _ValaCCodeBlock {
	ValaCCodeStatement parent;
	ValaCCodeBlockPrivate * priv;
};
struct _ValaCCodeBlockClass {
	ValaCCodeStatementClass parent;
};

void vala_ccode_block_prepend_statement (ValaCCodeBlock* self, ValaCCodeNode* statement);
void vala_ccode_block_add_statement (ValaCCodeBlock* self, ValaCCodeNode* statement);
gboolean vala_ccode_block_get_suppress_newline (ValaCCodeBlock* self);
void vala_ccode_block_set_suppress_newline (ValaCCodeBlock* self, gboolean value);
GType vala_ccode_block_get_type ();

G_END_DECLS

#endif
