/* valasymbolresolver.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valasymbolresolver.h"
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <vala/valasymbolresolver.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valadatatype.h>
#include <vala/valatypeparameter.h>

struct _ValaSymbolResolverPrivate {
	ValaSymbol* root_symbol;
	ValaSymbol* current_scope;
	GList* current_using_directives;
	ValaClass* object_class;
};
#define VALA_SYMBOL_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverPrivate))
enum  {
	VALA_SYMBOL_RESOLVER_DUMMY_PROPERTY,
};
static void vala_symbol_resolver_real_visit_begin_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
static void vala_symbol_resolver_real_visit_end_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
static void vala_symbol_resolver_real_visit_begin_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_symbol_resolver_real_visit_end_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_symbol_resolver_real_visit_begin_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_symbol_resolver_real_visit_end_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_symbol_resolver_real_visit_begin_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_symbol_resolver_real_visit_end_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_symbol_resolver_real_visit_begin_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_symbol_resolver_real_visit_end_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_symbol_resolver_real_visit_begin_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_symbol_resolver_real_visit_end_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_symbol_resolver_real_visit_namespace_reference (ValaCodeVisitor* base, ValaNamespaceReference* ns);
static void vala_symbol_resolver_real_visit_type_reference (ValaCodeVisitor* base, ValaTypeReference* type);
static gpointer vala_symbol_resolver_parent_class = NULL;
static void vala_symbol_resolver_dispose (GObject * obj);


/**
 * Resolve symbol names in the specified code context.
 *
 * @param context a code context
 */
void vala_symbol_resolver_resolve (ValaSymbolResolver* self, ValaCodeContext* context)
{
	g_return_if_fail (VALA_IS_SYMBOL_RESOLVER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	ValaSymbol* __temp0 = NULL;
	self->priv->root_symbol = (__temp0 = vala_code_context_get_root (context), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), __temp0);
	ValaSymbol* __temp2 = NULL;
	ValaSymbol* __temp1 = NULL;
	self->priv->current_scope = (__temp2 = (__temp1 = self->priv->root_symbol, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp2);
	/* TODO: don't require GLib namespace in symbol resolver*/
	ValaSymbol* glib_ns = vala_symbol_lookup (self->priv->root_symbol, "GLib");
	if (glib_ns != NULL) {
		ValaClass* __temp5 = NULL;
		ValaClass* __temp4 = NULL;
		ValaSymbol* __temp3 = NULL;
		self->priv->object_class = (__temp5 = (__temp4 = VALA_CLASS (vala_symbol_get_node ((__temp3 = vala_symbol_lookup (glib_ns, "Object")))), (__temp4 == NULL ? NULL : g_object_ref (__temp4))), (self->priv->object_class == NULL ? NULL : (self->priv->object_class = (g_object_unref (self->priv->object_class), NULL))), __temp5);
		(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	}
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
}


static void vala_symbol_resolver_real_visit_begin_source_file (ValaCodeVisitor* base, ValaSourceFile* file)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (file));
	GList* __temp6 = NULL;
	self->priv->current_using_directives = (__temp6 = vala_source_file_get_using_directives (file), (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_list_free (self->priv->current_using_directives), NULL))), __temp6);
}


static void vala_symbol_resolver_real_visit_end_source_file (ValaCodeVisitor* base, ValaSourceFile* file)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (file));
	GList* __temp7 = NULL;
	self->priv->current_using_directives = (__temp7 = NULL, (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_list_free (self->priv->current_using_directives), NULL))), __temp7);
}


static void vala_symbol_resolver_real_visit_begin_namespace (ValaCodeVisitor* base, ValaNamespace* ns)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	ValaSymbol* __temp9 = NULL;
	ValaSymbol* __temp8 = NULL;
	self->priv->current_scope = (__temp9 = (__temp8 = vala_code_node_get_symbol (VALA_CODE_NODE (ns)), (__temp8 == NULL ? NULL : g_object_ref (__temp8))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp9);
}


static void vala_symbol_resolver_real_visit_end_namespace (ValaCodeVisitor* base, ValaNamespace* ns)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	/* don't use current_scope.parent_symbol as that would be null
	 if the current namespace is SourceFile.global_namespace*/
	ValaSymbol* __temp11 = NULL;
	ValaSymbol* __temp10 = NULL;
	self->priv->current_scope = (__temp11 = (__temp10 = self->priv->root_symbol, (__temp10 == NULL ? NULL : g_object_ref (__temp10))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp11);
}


static void vala_symbol_resolver_real_visit_begin_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	ValaSymbol* __temp13 = NULL;
	ValaSymbol* __temp12 = NULL;
	self->priv->current_scope = (__temp13 = (__temp12 = vala_code_node_get_symbol (VALA_CODE_NODE (cl)), (__temp12 == NULL ? NULL : g_object_ref (__temp12))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp13);
}


static void vala_symbol_resolver_real_visit_end_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	{
		GList* __temp18 = NULL;
		__temp18 = vala_class_get_base_types (cl);
		GList* type_it;
		for (type_it = __temp18; type_it != NULL; type_it = type_it->next) {
			ValaTypeReference* type = type_it->data;
			{
				if (VALA_IS_CLASS (vala_type_reference_get_data_type (type))) {
					if (vala_class_get_base_class (cl) != NULL) {
						char* __temp17 = NULL;
						char* __temp16 = NULL;
						char* __temp15 = NULL;
						char* __temp14 = NULL;
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp17 = g_strdup_printf ("%s: Classes cannot have multiple base classes (`%s' and `%s')", (__temp14 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (cl)))), (__temp15 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (vala_class_get_base_class (cl))))), (__temp16 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (type))))))));
						(__temp17 = (g_free (__temp17), NULL));
						(__temp16 = (g_free (__temp16), NULL));
						(__temp15 = (g_free (__temp15), NULL));
						(__temp14 = (g_free (__temp14), NULL));
						return;
					}
					(vala_class_set_base_class (cl, VALA_CLASS (vala_type_reference_get_data_type (type))), vala_class_get_base_class (cl));
				}
			}
		}
		(__temp18 == NULL ? NULL : (__temp18 = (g_list_free (__temp18), NULL)));
	}
	if (vala_class_get_base_class (cl) == NULL && cl != self->priv->object_class) {
		ValaTypeReference* object_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (object_type, VALA_DATA_TYPE (self->priv->object_class)), vala_type_reference_get_data_type (object_type));
		vala_class_add_base_type (cl, object_type);
		(vala_class_set_base_class (cl, self->priv->object_class), vala_class_get_base_class (cl));
		(object_type == NULL ? NULL : (object_type = (g_object_unref (object_type), NULL)));
	}
	ValaSymbol* __temp20 = NULL;
	ValaSymbol* __temp19 = NULL;
	self->priv->current_scope = (__temp20 = (__temp19 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp19 == NULL ? NULL : g_object_ref (__temp19))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp20);
}


static void vala_symbol_resolver_real_visit_begin_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	ValaSymbol* __temp22 = NULL;
	ValaSymbol* __temp21 = NULL;
	self->priv->current_scope = (__temp22 = (__temp21 = vala_code_node_get_symbol (VALA_CODE_NODE (st)), (__temp21 == NULL ? NULL : g_object_ref (__temp21))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp22);
}


static void vala_symbol_resolver_real_visit_end_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	ValaSymbol* __temp24 = NULL;
	ValaSymbol* __temp23 = NULL;
	self->priv->current_scope = (__temp24 = (__temp23 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp23 == NULL ? NULL : g_object_ref (__temp23))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp24);
}


static void vala_symbol_resolver_real_visit_begin_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	ValaSymbol* __temp26 = NULL;
	ValaSymbol* __temp25 = NULL;
	self->priv->current_scope = (__temp26 = (__temp25 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp25 == NULL ? NULL : g_object_ref (__temp25))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp26);
}


static void vala_symbol_resolver_real_visit_end_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	ValaSymbol* __temp28 = NULL;
	ValaSymbol* __temp27 = NULL;
	self->priv->current_scope = (__temp28 = (__temp27 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp27 == NULL ? NULL : g_object_ref (__temp27))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp28);
}


static void vala_symbol_resolver_real_visit_begin_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	ValaSymbol* __temp30 = NULL;
	ValaSymbol* __temp29 = NULL;
	self->priv->current_scope = (__temp30 = (__temp29 = vala_code_node_get_symbol (VALA_CODE_NODE (cb)), (__temp29 == NULL ? NULL : g_object_ref (__temp29))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp30);
}


static void vala_symbol_resolver_real_visit_end_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	ValaSymbol* __temp32 = NULL;
	ValaSymbol* __temp31 = NULL;
	self->priv->current_scope = (__temp32 = (__temp31 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp31 == NULL ? NULL : g_object_ref (__temp31))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp32);
}


static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	if (!vala_formal_parameter_get_ellipsis (p) && vala_type_reference_get_is_ref (vala_formal_parameter_get_type_reference (p))) {
		if ((vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (p)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (p)))) || vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (p)) != NULL) {
			(vala_type_reference_set_takes_ownership (vala_formal_parameter_get_type_reference (p), TRUE), vala_type_reference_get_takes_ownership (vala_formal_parameter_get_type_reference (p)));
		} else {
			(vala_type_reference_set_reference_to_value_type (vala_formal_parameter_get_type_reference (p), TRUE), vala_type_reference_get_reference_to_value_type (vala_formal_parameter_get_type_reference (p)));
		}
	}
}


static void vala_symbol_resolver_real_visit_namespace_reference (ValaCodeVisitor* base, ValaNamespaceReference* ns)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_NAMESPACE_REFERENCE (ns));
	ValaSymbol* __temp33 = NULL;
	(vala_namespace_reference_set_namespace_symbol (ns, (__temp33 = vala_symbol_lookup (self->priv->current_scope, vala_namespace_reference_get_name (ns)))), vala_namespace_reference_get_namespace_symbol (ns));
	(__temp33 == NULL ? NULL : (__temp33 = (g_object_unref (__temp33), NULL)));
	if (vala_namespace_reference_get_namespace_symbol (ns) == NULL) {
		(vala_code_node_set_error (VALA_CODE_NODE (ns), TRUE), vala_code_node_get_error (VALA_CODE_NODE (ns)));
		char* __temp34 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (ns)), (__temp34 = g_strdup_printf ("The namespace name `%s' could not be found", vala_namespace_reference_get_name (ns))));
		(__temp34 = (g_free (__temp34), NULL));
		return;
	}
}


static void vala_symbol_resolver_real_visit_type_reference (ValaCodeVisitor* base, ValaTypeReference* type)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (type));
	if (vala_type_reference_get_type_name (type) == NULL || g_utf8_collate (vala_type_reference_get_type_name (type), "void") == 0) {
		/* reset transfers_ownership*/
		(vala_type_reference_set_transfers_ownership (type, FALSE), vala_type_reference_get_transfers_ownership (type));
		return;
	}
	if (vala_type_reference_get_namespace_name (type) == NULL) {
		ValaSymbol* sym = NULL;
		ValaSymbol* __temp35 = NULL;
		ValaSymbol* scope = (__temp35 = self->priv->current_scope, (__temp35 == NULL ? NULL : g_object_ref (__temp35)));
		while (sym == NULL && scope != NULL) {
			ValaSymbol* __temp36 = NULL;
			sym = (__temp36 = vala_symbol_lookup (scope, vala_type_reference_get_type_name (type)), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp36);
			ValaSymbol* __temp38 = NULL;
			ValaSymbol* __temp37 = NULL;
			scope = (__temp38 = (__temp37 = vala_symbol_get_parent_symbol (scope), (__temp37 == NULL ? NULL : g_object_ref (__temp37))), (scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL))), __temp38);
			if (sym != NULL && !(VALA_IS_DATA_TYPE (vala_symbol_get_node (sym))) && !(VALA_IS_TYPE_PARAMETER (vala_symbol_get_node (sym)))) {
				/* ignore non-type symbols*/
				ValaSymbol* __temp39 = NULL;
				sym = (__temp39 = NULL, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp39);
			}
		}
		if (sym == NULL) {
			{
				GList* __temp45 = NULL;
				__temp45 = self->priv->current_using_directives;
				GList* ns_it;
				for (ns_it = __temp45; ns_it != NULL; ns_it = ns_it->next) {
					ValaNamespaceReference* ns = ns_it->data;
					{
						if (vala_code_node_get_error (VALA_CODE_NODE (ns))) {
							continue;
						}
						ValaSymbol* local_sym = vala_symbol_lookup (vala_namespace_reference_get_namespace_symbol (ns), vala_type_reference_get_type_name (type));
						if (local_sym != NULL) {
							if (sym != NULL) {
								char* __temp42 = NULL;
								char* __temp41 = NULL;
								char* __temp40 = NULL;
								vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp42 = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", vala_type_reference_get_type_name (type), (__temp40 = vala_symbol_get_full_name (sym)), (__temp41 = vala_symbol_get_full_name (local_sym)))));
								(__temp42 = (g_free (__temp42), NULL));
								(__temp41 = (g_free (__temp41), NULL));
								(__temp40 = (g_free (__temp40), NULL));
								(local_sym == NULL ? NULL : (local_sym = (g_object_unref (local_sym), NULL)));
								(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
								(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
								return;
							}
							ValaSymbol* __temp44 = NULL;
							ValaSymbol* __temp43 = NULL;
							sym = (__temp44 = (__temp43 = local_sym, (__temp43 == NULL ? NULL : g_object_ref (__temp43))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp44);
						}
						(local_sym == NULL ? NULL : (local_sym = (g_object_unref (local_sym), NULL)));
					}
				}
			}
		}
		if (sym == NULL) {
			char* __temp46 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp46 = g_strdup_printf ("The type name `%s' could not be found", vala_type_reference_get_type_name (type))));
			(__temp46 = (g_free (__temp46), NULL));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
			return;
		}
		if (VALA_IS_TYPE_PARAMETER (vala_symbol_get_node (sym))) {
			(vala_type_reference_set_type_parameter (type, VALA_TYPE_PARAMETER (vala_symbol_get_node (sym))), vala_type_reference_get_type_parameter (type));
		} else {
			(vala_type_reference_set_data_type (type, VALA_DATA_TYPE (vala_symbol_get_node (sym))), vala_type_reference_get_data_type (type));
		}
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
		(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
	} else {
		ValaSymbol* ns_symbol = vala_symbol_lookup (self->priv->root_symbol, vala_type_reference_get_namespace_name (type));
		if (ns_symbol == NULL) {
			(vala_code_node_set_error (VALA_CODE_NODE (type), TRUE), vala_code_node_get_error (VALA_CODE_NODE (type)));
			char* __temp47 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp47 = g_strdup_printf ("The namespace name `%s' could not be found", vala_type_reference_get_namespace_name (type))));
			(__temp47 = (g_free (__temp47), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			return;
		}
		ValaSymbol* sym = vala_symbol_lookup (ns_symbol, vala_type_reference_get_type_name (type));
		if (sym == NULL) {
			char* __temp48 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp48 = g_strdup_printf ("The type name `%s' does not exist in the namespace `%s'", vala_type_reference_get_type_name (type), vala_type_reference_get_namespace_name (type))));
			(__temp48 = (g_free (__temp48), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			return;
		}
		(vala_type_reference_set_data_type (type, VALA_DATA_TYPE (vala_symbol_get_node (sym))), vala_type_reference_get_data_type (type));
		(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
	}
	if (vala_type_reference_get_pointer_level (type) > 0) {
		if (vala_type_reference_get_data_type (type) == NULL) {
			(vala_code_node_set_error (VALA_CODE_NODE (type), TRUE), vala_code_node_get_error (VALA_CODE_NODE (type)));
			char* __temp49 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp49 = g_strdup_printf ("Pointer to `%s' not supported", vala_type_reference_get_type_name (type))));
			(__temp49 = (g_free (__temp49), NULL));
			return;
		}
		ValaTypeReference* referent_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (referent_type, vala_type_reference_get_data_type (type)), vala_type_reference_get_data_type (referent_type));
		(vala_type_reference_set_pointer_level (referent_type, vala_type_reference_get_pointer_level (type) - 1), vala_type_reference_get_pointer_level (referent_type));
		if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
			(vala_type_reference_set_takes_ownership (referent_type, vala_type_reference_get_takes_ownership (type)), vala_type_reference_get_takes_ownership (referent_type));
		}
		ValaPointer* __temp50 = NULL;
		(vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp50 = vala_data_type_get_pointer (vala_type_reference_get_data_type (referent_type))))), vala_type_reference_get_data_type (type));
		(__temp50 = (g_object_unref (__temp50), NULL));
		vala_type_reference_add_type_argument (type, referent_type);
		vala_code_visitor_visit_type_reference (VALA_CODE_VISITOR (self), referent_type);
		(referent_type == NULL ? NULL : (referent_type = (g_object_unref (referent_type), NULL)));
	}
	/* check for array */
	if (vala_type_reference_get_array_rank (type) > 0) {
		ValaTypeReference* element_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (element_type, vala_type_reference_get_data_type (type)), vala_type_reference_get_data_type (element_type));
		(vala_type_reference_set_type_parameter (element_type, vala_type_reference_get_type_parameter (type)), vala_type_reference_get_type_parameter (element_type));
		{
			GList* __temp51 = NULL;
			__temp51 = vala_type_reference_get_type_arguments (type);
			GList* type_arg_it;
			for (type_arg_it = __temp51; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
				ValaTypeReference* type_arg = type_arg_it->data;
				{
					vala_type_reference_add_type_argument (element_type, type_arg);
				}
			}
			(__temp51 == NULL ? NULL : (__temp51 = (g_list_free (__temp51), NULL)));
		}
		vala_type_reference_remove_all_type_arguments (type);
		if (vala_type_reference_get_data_type (type) != NULL) {
			if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
				(vala_type_reference_set_takes_ownership (element_type, vala_type_reference_get_takes_ownership (type)), vala_type_reference_get_takes_ownership (element_type));
			}
			ValaArray* __temp52 = NULL;
			(vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp52 = vala_data_type_get_array (vala_type_reference_get_data_type (element_type), vala_type_reference_get_array_rank (type))))), vala_type_reference_get_data_type (type));
			(__temp52 = (g_object_unref (__temp52), NULL));
		} else {
			ValaArray* __temp53 = NULL;
			(vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp53 = vala_type_parameter_get_array (vala_type_reference_get_type_parameter (element_type), vala_type_reference_get_array_rank (type))))), vala_type_reference_get_data_type (type));
			(__temp53 = (g_object_unref (__temp53), NULL));
			(vala_type_reference_set_type_parameter (type, NULL), vala_type_reference_get_type_parameter (type));
		}
		vala_type_reference_add_type_argument (type, element_type);
		(element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL)));
	}
	if (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
		/* reset takes_ownership and transfers_ownership of
		 * value-types for contexts where types are ref by
		 * default (field declarations and method return types)
		 */
		(vala_type_reference_set_takes_ownership (type, FALSE), vala_type_reference_get_takes_ownership (type));
		(vala_type_reference_set_transfers_ownership (type, FALSE), vala_type_reference_get_transfers_ownership (type));
	}
}


static void vala_symbol_resolver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (object);
	switch (property_id) {
	}
}


static void vala_symbol_resolver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (object);
	switch (property_id) {
	}
}


static void vala_symbol_resolver_class_init (ValaSymbolResolverClass * klass)
{
	vala_symbol_resolver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSymbolResolverPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_symbol_resolver_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_symbol_resolver_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_symbol_resolver_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_source_file = vala_symbol_resolver_real_visit_begin_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_source_file = vala_symbol_resolver_real_visit_end_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_namespace = vala_symbol_resolver_real_visit_begin_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_namespace = vala_symbol_resolver_real_visit_end_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_class = vala_symbol_resolver_real_visit_begin_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_class = vala_symbol_resolver_real_visit_end_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_struct = vala_symbol_resolver_real_visit_begin_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_struct = vala_symbol_resolver_real_visit_end_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_interface = vala_symbol_resolver_real_visit_begin_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_interface = vala_symbol_resolver_real_visit_end_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_callback = vala_symbol_resolver_real_visit_begin_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_callback = vala_symbol_resolver_real_visit_end_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_symbol_resolver_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace_reference = vala_symbol_resolver_real_visit_namespace_reference;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_reference = vala_symbol_resolver_real_visit_type_reference;
}


static void vala_symbol_resolver_init (ValaSymbolResolver * self)
{
	self->priv = VALA_SYMBOL_RESOLVER_GET_PRIVATE (self);
}


static void vala_symbol_resolver_dispose (GObject * obj)
{
	ValaSymbolResolver * self = VALA_SYMBOL_RESOLVER (obj);
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL)));
	(self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_list_free (self->priv->current_using_directives), NULL)));
	(self->priv->object_class == NULL ? NULL : (self->priv->object_class = (g_object_unref (self->priv->object_class), NULL)));
	ValaSymbolResolverClass * klass;
	GObjectClass * parent_class;
	klass = VALA_SYMBOL_RESOLVER_CLASS (g_type_class_peek (VALA_TYPE_SYMBOL_RESOLVER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_symbol_resolver_get_type ()
{
	static GType vala_symbol_resolver_type_id = 0;
	if (G_UNLIKELY (vala_symbol_resolver_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbolResolver), 0, (GInstanceInitFunc) vala_symbol_resolver_init };
		vala_symbol_resolver_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSymbolResolver", &g_define_type_info, 0);
	}
	return vala_symbol_resolver_type_id;
}




