/* valaswitchsection.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaswitchsection.h"
#include <vala/valasourcereference.h>
#include <vala/valaswitchlabel.h>
#include <vala/valaswitchsection.h>
#include <vala/valastatement.h>
#include <vala/valacodevisitor.h>

struct _ValaSwitchSectionPrivate {
	GList* labels;
	GList* statement_list;
};
#define VALA_SWITCH_SECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionPrivate))
enum  {
	VALA_SWITCH_SECTION_DUMMY_PROPERTY,
};
static void vala_switch_section_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_switch_section_parent_class = NULL;
static void vala_switch_section_dispose (GObject * obj);


/**
 * Creates a new switch section.
 *
 * @param source reference to source code
 * @return       newly created switch section
 */
ValaSwitchSection* vala_switch_section_new (ValaSourceReference* source)
{
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaSwitchSection * self = g_object_newv (VALA_TYPE_SWITCH_SECTION, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified label to the list of switch labels.
 *
 * @param label a switch label
 */
void vala_switch_section_add_label (ValaSwitchSection* self, ValaSwitchLabel* label)
{
	g_return_if_fail (VALA_IS_SWITCH_SECTION (self));
	g_return_if_fail (VALA_IS_SWITCH_LABEL (label));
	self->priv->labels = g_list_append (self->priv->labels, g_object_ref (label));
}


/**
 * Returns a copy of the list of switch labels.
 *
 * @return switch label list
 */
GList* vala_switch_section_get_labels (ValaSwitchSection* self)
{
	g_return_val_if_fail (VALA_IS_SWITCH_SECTION (self), NULL);
	return g_list_copy (self->priv->labels);
}


gboolean vala_switch_section_has_default_label (ValaSwitchSection* self)
{
	g_return_val_if_fail (VALA_IS_SWITCH_SECTION (self), FALSE);
	{
		GList* __temp2 = NULL;
		__temp2 = self->priv->labels;
		GList* label_it;
		for (label_it = __temp2; label_it != NULL; label_it = label_it->next) {
			ValaSwitchLabel* label = label_it->data;
			{
				if (vala_switch_label_get_expression (label) == NULL) {
					return TRUE;
				}
			}
		}
	}
	return FALSE;
}


/**
 * Appends the specified statement to this switch section.
 *
 * @param stmt a statement
 */
void vala_switch_section_add_statement (ValaSwitchSection* self, ValaStatement* stmt)
{
	g_return_if_fail (VALA_IS_SWITCH_SECTION (self));
	g_return_if_fail (VALA_IS_STATEMENT (stmt));
	self->priv->statement_list = g_list_append (self->priv->statement_list, g_object_ref (stmt));
}


/**
 * Returns a copy of the list of statements.
 *
 * @return statement list
 */
GList* vala_switch_section_get_statements (ValaSwitchSection* self)
{
	g_return_val_if_fail (VALA_IS_SWITCH_SECTION (self), NULL);
	return g_list_copy (self->priv->statement_list);
}


static void vala_switch_section_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaSwitchSection * self = VALA_SWITCH_SECTION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	{
		GList* __temp5 = NULL;
		__temp5 = self->priv->labels;
		GList* label_it;
		for (label_it = __temp5; label_it != NULL; label_it = label_it->next) {
			ValaSwitchLabel* label = label_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (label), visitor);
			}
		}
	}
	{
		GList* __temp6 = NULL;
		__temp6 = self->priv->statement_list;
		GList* st_it;
		for (st_it = __temp6; st_it != NULL; st_it = st_it->next) {
			ValaStatement* st = st_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (st), visitor);
			}
		}
	}
	vala_code_visitor_visit_switch_section (visitor, self);
}


static void vala_switch_section_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaSwitchSection * self = VALA_SWITCH_SECTION (object);
	switch (property_id) {
	}
}


static void vala_switch_section_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaSwitchSection * self = VALA_SWITCH_SECTION (object);
	switch (property_id) {
	}
}


static void vala_switch_section_class_init (ValaSwitchSectionClass * klass)
{
	vala_switch_section_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSwitchSectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_switch_section_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_switch_section_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_switch_section_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_switch_section_real_accept;
}


static void vala_switch_section_init (ValaSwitchSection * self)
{
	self->priv = VALA_SWITCH_SECTION_GET_PRIVATE (self);
}


static void vala_switch_section_dispose (GObject * obj)
{
	ValaSwitchSection * self = VALA_SWITCH_SECTION (obj);
	(self->priv->labels == NULL ? NULL : (self->priv->labels = (g_list_foreach (self->priv->labels, (GFunc) g_object_unref, NULL), g_list_free (self->priv->labels), NULL)));
	(self->priv->statement_list == NULL ? NULL : (self->priv->statement_list = (g_list_foreach (self->priv->statement_list, (GFunc) g_object_unref, NULL), g_list_free (self->priv->statement_list), NULL)));
	ValaSwitchSectionClass * klass;
	GObjectClass * parent_class;
	klass = VALA_SWITCH_SECTION_CLASS (g_type_class_peek (VALA_TYPE_SWITCH_SECTION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_switch_section_get_type ()
{
	static GType vala_switch_section_type_id = 0;
	if (G_UNLIKELY (vala_switch_section_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchSection), 0, (GInstanceInitFunc) vala_switch_section_init };
		vala_switch_section_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSwitchSection", &g_define_type_info, 0);
	}
	return vala_switch_section_type_id;
}




