/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAPROPERTYACCESSOR_H__
#define __VALAPROPERTYACCESSOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessorPrivate ValaPropertyAccessorPrivate;

/**
 * Represents a get or set accessor of a property in the source code.
 */
struct _ValaPropertyAccessor {
	ValaCodeNode parent;
	ValaPropertyAccessorPrivate * priv;
};
struct _ValaPropertyAccessorClass {
	ValaCodeNodeClass parent;
};

ValaPropertyAccessor* vala_property_accessor_new (gboolean _readable, gboolean _writable, gboolean _construction, ValaStatement* _body, ValaSourceReference* source);
gboolean vala_property_accessor_get_readable (ValaPropertyAccessor* self);
void vala_property_accessor_set_readable (ValaPropertyAccessor* self, gboolean value);
gboolean vala_property_accessor_get_writable (ValaPropertyAccessor* self);
void vala_property_accessor_set_writable (ValaPropertyAccessor* self, gboolean value);
gboolean vala_property_accessor_get_construction (ValaPropertyAccessor* self);
void vala_property_accessor_set_construction (ValaPropertyAccessor* self, gboolean value);
ValaStatement* vala_property_accessor_get_body (ValaPropertyAccessor* self);
void vala_property_accessor_set_body (ValaPropertyAccessor* self, ValaStatement* value);
ValaFormalParameter* vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self);
void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self, ValaFormalParameter* value);
GType vala_property_accessor_get_type ();

G_END_DECLS

#endif
