/* valapointer.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valapointer.h"
#include <vala/valasourcereference.h>
#include <vala/valapointer.h>

struct _ValaPointerPrivate {
	ValaDataType* _referent_type;
	char* cname;
};
#define VALA_POINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_POINTER, ValaPointerPrivate))
enum  {
	VALA_POINTER_DUMMY_PROPERTY,
	VALA_POINTER_REFERENT_TYPE,
};
static char* vala_pointer_real_get_cname (ValaDataType* base, gboolean const_type);
static gboolean vala_pointer_real_is_reference_type (ValaDataType* base);
static char* vala_pointer_real_get_upper_case_cname (ValaDataType* base, const char* infix);
static char* vala_pointer_real_get_lower_case_cname (ValaDataType* base, const char* infix);
static char* vala_pointer_real_get_free_function (ValaDataType* base);
static GList* vala_pointer_real_get_cheader_filenames (ValaDataType* base);
static char* vala_pointer_real_get_type_id (ValaDataType* base);
static char* vala_pointer_real_get_marshaller_type_name (ValaDataType* base);
static char* vala_pointer_real_get_get_value_function (ValaDataType* base);
static char* vala_pointer_real_get_set_value_function (ValaDataType* base);
static GObject * vala_pointer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_pointer_parent_class = NULL;
static void vala_pointer_dispose (GObject * obj);


ValaPointer* vala_pointer_new (ValaDataType* referent_type, ValaSourceReference* source_reference)
{
	g_return_val_if_fail (VALA_IS_DATA_TYPE (referent_type), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "referent-type", g_value_init (&__params_it->value, VALA_TYPE_DATA_TYPE), g_value_set_object (&__params_it->value, referent_type), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source_reference), __params_it++);
	ValaPointer * self = g_object_newv (VALA_TYPE_POINTER, __params_it - __params, __params);
	return self;
}


static char* vala_pointer_real_get_cname (ValaDataType* base, gboolean const_type)
{
	ValaPointer * self = VALA_POINTER (base);
	if (self->priv->cname == NULL) {
		if (vala_data_type_is_reference_type (vala_pointer_get_referent_type (self))) {
			char* __temp1 = NULL;
			char* __temp0 = NULL;
			self->priv->cname = (__temp1 = g_strdup_printf ("%s**", (__temp0 = vala_data_type_get_cname (vala_pointer_get_referent_type (self), FALSE))), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp1);
			(__temp0 = (g_free (__temp0), NULL));
		} else {
			char* __temp3 = NULL;
			char* __temp2 = NULL;
			self->priv->cname = (__temp3 = g_strdup_printf ("%s*", (__temp2 = vala_data_type_get_cname (vala_pointer_get_referent_type (self), FALSE))), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp3);
			(__temp2 = (g_free (__temp2), NULL));
		}
	}
	const char* __temp4 = NULL;
	return (__temp4 = self->priv->cname, (__temp4 == NULL ? NULL : g_strdup (__temp4)));
}


static gboolean vala_pointer_real_is_reference_type (ValaDataType* base)
{
	ValaPointer * self = VALA_POINTER (base);
	return FALSE;
}


static char* vala_pointer_real_get_upper_case_cname (ValaDataType* base, const char* infix)
{
	ValaPointer * self = VALA_POINTER (base);
	return NULL;
}


static char* vala_pointer_real_get_lower_case_cname (ValaDataType* base, const char* infix)
{
	ValaPointer * self = VALA_POINTER (base);
	return NULL;
}


static char* vala_pointer_real_get_free_function (ValaDataType* base)
{
	ValaPointer * self = VALA_POINTER (base);
	return NULL;
}


static GList* vala_pointer_real_get_cheader_filenames (ValaDataType* base)
{
	ValaPointer * self = VALA_POINTER (base);
	return vala_data_type_get_cheader_filenames (vala_pointer_get_referent_type (self));
}


static char* vala_pointer_real_get_type_id (ValaDataType* base)
{
	ValaPointer * self = VALA_POINTER (base);
	return g_strdup ("G_TYPE_POINTER");
}


static char* vala_pointer_real_get_marshaller_type_name (ValaDataType* base)
{
	ValaPointer * self = VALA_POINTER (base);
	return g_strdup ("POINTER");
}


static char* vala_pointer_real_get_get_value_function (ValaDataType* base)
{
	ValaPointer * self = VALA_POINTER (base);
	return g_strdup ("g_value_get_pointer");
}


static char* vala_pointer_real_get_set_value_function (ValaDataType* base)
{
	ValaPointer * self = VALA_POINTER (base);
	return g_strdup ("g_value_set_pointer");
}


ValaDataType* vala_pointer_get_referent_type (ValaPointer* self)
{
	g_return_val_if_fail (VALA_IS_POINTER (self), NULL);
	return self->priv->_referent_type;
}


void vala_pointer_set_referent_type (ValaPointer* self, ValaDataType* value)
{
	g_return_if_fail (VALA_IS_POINTER (self));
	ValaDataType* __temp16 = NULL;
	self->priv->_referent_type = (__temp16 = g_object_ref (value), (self->priv->_referent_type == NULL ? NULL : (self->priv->_referent_type = (g_object_unref (self->priv->_referent_type), NULL))), __temp16);
}


static GObject * vala_pointer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaPointerClass * klass;
	GObjectClass * parent_class;
	klass = VALA_POINTER_CLASS (g_type_class_peek (VALA_TYPE_POINTER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	ValaPointer * self = VALA_POINTER (obj);
	{
		char* __temp17 = NULL;
		(vala_data_type_set_name (VALA_DATA_TYPE (self), (__temp17 = g_strconcat (vala_data_type_get_name (vala_pointer_get_referent_type (self)), "*", NULL))), vala_data_type_get_name (VALA_DATA_TYPE (self)));
		(__temp17 = (g_free (__temp17), NULL));
	}
	return obj;
}


static void vala_pointer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaPointer * self = VALA_POINTER (object);
	switch (property_id) {
		case VALA_POINTER_REFERENT_TYPE:
		g_value_set_object (value, vala_pointer_get_referent_type (self));
		break;
	}
}


static void vala_pointer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaPointer * self = VALA_POINTER (object);
	switch (property_id) {
		case VALA_POINTER_REFERENT_TYPE:
		vala_pointer_set_referent_type (self, g_value_get_object (value));
		break;
	}
}


static void vala_pointer_class_init (ValaPointerClass * klass)
{
	vala_pointer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPointerPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_pointer_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_pointer_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_pointer_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_pointer_dispose;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_pointer_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type = vala_pointer_real_is_reference_type;
	VALA_DATA_TYPE_CLASS (klass)->get_upper_case_cname = vala_pointer_real_get_upper_case_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_lower_case_cname = vala_pointer_real_get_lower_case_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_free_function = vala_pointer_real_get_free_function;
	VALA_DATA_TYPE_CLASS (klass)->get_cheader_filenames = vala_pointer_real_get_cheader_filenames;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_pointer_real_get_type_id;
	VALA_DATA_TYPE_CLASS (klass)->get_marshaller_type_name = vala_pointer_real_get_marshaller_type_name;
	VALA_DATA_TYPE_CLASS (klass)->get_get_value_function = vala_pointer_real_get_get_value_function;
	VALA_DATA_TYPE_CLASS (klass)->get_set_value_function = vala_pointer_real_get_set_value_function;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_POINTER_REFERENT_TYPE, g_param_spec_object ("referent-type", "foo", "bar", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_pointer_init (ValaPointer * self)
{
	self->priv = VALA_POINTER_GET_PRIVATE (self);
}


static void vala_pointer_dispose (GObject * obj)
{
	ValaPointer * self = VALA_POINTER (obj);
	(self->priv->_referent_type == NULL ? NULL : (self->priv->_referent_type = (g_object_unref (self->priv->_referent_type), NULL)));
	(self->priv->cname = (g_free (self->priv->cname), NULL));
	ValaPointerClass * klass;
	GObjectClass * parent_class;
	klass = VALA_POINTER_CLASS (g_type_class_peek (VALA_TYPE_POINTER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_pointer_get_type ()
{
	static GType vala_pointer_type_id = 0;
	if (G_UNLIKELY (vala_pointer_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPointerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_pointer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPointer), 0, (GInstanceInitFunc) vala_pointer_init };
		vala_pointer_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaPointer", &g_define_type_info, 0);
	}
	return vala_pointer_type_id;
}




