/* valaliteralexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALALITERALEXPRESSION_H__
#define __VALALITERALEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_LITERAL_EXPRESSION (vala_literal_expression_get_type ())
#define VALA_LITERAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL_EXPRESSION, ValaLiteralExpression))
#define VALA_LITERAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL_EXPRESSION, ValaLiteralExpressionClass))
#define VALA_IS_LITERAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL_EXPRESSION))
#define VALA_IS_LITERAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL_EXPRESSION))
#define VALA_LITERAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL_EXPRESSION, ValaLiteralExpressionClass))

typedef struct _ValaLiteralExpressionPrivate ValaLiteralExpressionPrivate;

/**
 * Represents a literal expression in the source code.
 */
struct _ValaLiteralExpression {
	ValaExpression parent;
	ValaLiteralExpressionPrivate * priv;
};
struct _ValaLiteralExpressionClass {
	ValaExpressionClass parent;
};

ValaLiteralExpression* vala_literal_expression_new (ValaLiteral* _literal, ValaSourceReference* source);
ValaLiteral* vala_literal_expression_get_literal (ValaLiteralExpression* self);
void vala_literal_expression_set_literal (ValaLiteralExpression* self, ValaLiteral* value);
GType vala_literal_expression_get_type ();

G_END_DECLS

#endif
