/* valainvocationexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valainvocationexpression.h"
#include <vala/valasourcereference.h>
#include <vala/valainvocationexpression.h>
#include <vala/valacodevisitor.h>

struct _ValaInvocationExpressionPrivate {
	GList* argument_list;
};
#define VALA_INVOCATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INVOCATION_EXPRESSION, ValaInvocationExpressionPrivate))
enum  {
	VALA_INVOCATION_EXPRESSION_DUMMY_PROPERTY,
	VALA_INVOCATION_EXPRESSION_CALL,
};
static void vala_invocation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_invocation_expression_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_invocation_expression_parent_class = NULL;
static void vala_invocation_expression_dispose (GObject * obj);


/**
 * Creates a new invocation expression.
 *
 * @param call   method to call
 * @param source reference to source code
 * @return       newly created invocation expression
 */
ValaInvocationExpression* vala_invocation_expression_new (ValaExpression* _call, ValaSourceReference* source)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (_call), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "call", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, _call), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaInvocationExpression * self = g_object_newv (VALA_TYPE_INVOCATION_EXPRESSION, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void vala_invocation_expression_add_argument (ValaInvocationExpression* self, ValaExpression* arg)
{
	g_return_if_fail (VALA_IS_INVOCATION_EXPRESSION (self));
	g_return_if_fail (VALA_IS_EXPRESSION (arg));
	self->priv->argument_list = g_list_append (self->priv->argument_list, g_object_ref (arg));
	(vala_code_node_set_parent_node (VALA_CODE_NODE (arg), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (arg)));
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
GList* vala_invocation_expression_get_argument_list (ValaInvocationExpression* self)
{
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (self), NULL);
	return g_list_copy (self->priv->argument_list);
}


static void vala_invocation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaInvocationExpression * self = VALA_INVOCATION_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_invocation_expression_get_call (self)), visitor);
	vala_code_visitor_visit_begin_invocation_expression (visitor, self);
	{
		GList* __temp1 = NULL;
		__temp1 = g_list_copy (self->priv->argument_list);
		GList* expr_it;
		for (expr_it = __temp1; expr_it != NULL; expr_it = expr_it->next) {
			ValaExpression* expr = expr_it->data;
			{
				/* iterate over list copy as list may change in loop body*/
				vala_code_node_accept (VALA_CODE_NODE (expr), visitor);
			}
		}
		(__temp1 == NULL ? NULL : (__temp1 = (g_list_free (__temp1), NULL)));
	}
	vala_code_visitor_visit_end_invocation_expression (visitor, self);
}


static void vala_invocation_expression_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaInvocationExpression * self = VALA_INVOCATION_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_invocation_expression_get_call (self)) == old_node) {
		(vala_invocation_expression_set_call (self, VALA_EXPRESSION (new_node)), vala_invocation_expression_get_call (self));
	}
	GList* l = g_list_find (self->priv->argument_list, old_node);
	if (l != NULL) {
		if (vala_code_node_get_parent_node (new_node) != NULL) {
			return;
		}
		self->priv->argument_list = g_list_insert_before (self->priv->argument_list, l, g_object_ref (new_node));
		self->priv->argument_list = g_list_remove_link (self->priv->argument_list, l);
		(vala_code_node_set_parent_node (new_node, VALA_CODE_NODE (self)), vala_code_node_get_parent_node (new_node));
	}
}


ValaExpression* vala_invocation_expression_get_call (ValaInvocationExpression* self)
{
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (self), NULL);
	return self->_call;
}


void vala_invocation_expression_set_call (ValaInvocationExpression* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_INVOCATION_EXPRESSION (self));
	ValaExpression* __temp3 = NULL;
	self->_call = (__temp3 = g_object_ref (value), (self->_call == NULL ? NULL : (self->_call = (g_object_unref (self->_call), NULL))), __temp3);
	(vala_code_node_set_parent_node (VALA_CODE_NODE (self->_call), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->_call)));
}


static void vala_invocation_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaInvocationExpression * self = VALA_INVOCATION_EXPRESSION (object);
	switch (property_id) {
		case VALA_INVOCATION_EXPRESSION_CALL:
		g_value_set_object (value, vala_invocation_expression_get_call (self));
		break;
	}
}


static void vala_invocation_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaInvocationExpression * self = VALA_INVOCATION_EXPRESSION (object);
	switch (property_id) {
		case VALA_INVOCATION_EXPRESSION_CALL:
		vala_invocation_expression_set_call (self, g_value_get_object (value));
		break;
	}
}


static void vala_invocation_expression_class_init (ValaInvocationExpressionClass * klass)
{
	vala_invocation_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaInvocationExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_invocation_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_invocation_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_invocation_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_invocation_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_invocation_expression_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_INVOCATION_EXPRESSION_CALL, g_param_spec_object ("call", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_invocation_expression_init (ValaInvocationExpression * self)
{
	self->priv = VALA_INVOCATION_EXPRESSION_GET_PRIVATE (self);
}


static void vala_invocation_expression_dispose (GObject * obj)
{
	ValaInvocationExpression * self = VALA_INVOCATION_EXPRESSION (obj);
	(self->_call == NULL ? NULL : (self->_call = (g_object_unref (self->_call), NULL)));
	(self->priv->argument_list == NULL ? NULL : (self->priv->argument_list = (g_list_foreach (self->priv->argument_list, (GFunc) g_object_unref, NULL), g_list_free (self->priv->argument_list), NULL)));
	ValaInvocationExpressionClass * klass;
	GObjectClass * parent_class;
	klass = VALA_INVOCATION_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_INVOCATION_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_invocation_expression_get_type ()
{
	static GType vala_invocation_expression_type_id = 0;
	if (G_UNLIKELY (vala_invocation_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInvocationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_invocation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInvocationExpression), 0, (GInstanceInitFunc) vala_invocation_expression_init };
		vala_invocation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInvocationExpression", &g_define_type_info, 0);
	}
	return vala_invocation_expression_type_id;
}




