/* valaccodevariabledeclarator.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodevariabledeclarator.h"
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeVariableDeclaratorPrivate {
	char* _name;
	ValaCCodeExpression* _initializer;
};
#define VALA_CCODE_VARIABLE_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorPrivate))
enum  {
	VALA_CCODE_VARIABLE_DECLARATOR_DUMMY_PROPERTY,
	VALA_CCODE_VARIABLE_DECLARATOR_NAME,
	VALA_CCODE_VARIABLE_DECLARATOR_INITIALIZER,
};
static void vala_ccode_variable_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_variable_declarator_parent_class = NULL;
static void vala_ccode_variable_declarator_dispose (GObject * obj);


ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new (const char* _name)
{
	g_return_val_if_fail (_name != NULL, NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	ValaCCodeVariableDeclarator * self = g_object_newv (VALA_TYPE_CCODE_VARIABLE_DECLARATOR, __params_it - __params, __params);
	return self;
}


ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new_with_initializer (const char* _name, ValaCCodeExpression* init)
{
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (init == NULL || VALA_IS_CCODE_EXPRESSION (init), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	(__params_it->name = "initializer", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, init), __params_it++);
	ValaCCodeVariableDeclarator * self = g_object_newv (VALA_TYPE_CCODE_VARIABLE_DECLARATOR, __params_it - __params, __params);
	return self;
}


static void vala_ccode_variable_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeVariableDeclarator * self = VALA_CCODE_VARIABLE_DECLARATOR (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, vala_ccode_variable_declarator_get_name (self));
	if (vala_ccode_variable_declarator_get_initializer (self) != NULL) {
		vala_ccode_writer_write_string (writer, " = ");
		vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_variable_declarator_get_initializer (self)), writer);
	}
}


char* vala_ccode_variable_declarator_get_name (ValaCCodeVariableDeclarator* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_VARIABLE_DECLARATOR (self), NULL);
	return self->priv->_name;
}


void vala_ccode_variable_declarator_set_name (ValaCCodeVariableDeclarator* self, const char* value)
{
	g_return_if_fail (VALA_IS_CCODE_VARIABLE_DECLARATOR (self));
	char* __temp1 = NULL;
	self->priv->_name = (__temp1 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp1);
}


ValaCCodeExpression* vala_ccode_variable_declarator_get_initializer (ValaCCodeVariableDeclarator* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_VARIABLE_DECLARATOR (self), NULL);
	return self->priv->_initializer;
}


void vala_ccode_variable_declarator_set_initializer (ValaCCodeVariableDeclarator* self, ValaCCodeExpression* value)
{
	g_return_if_fail (VALA_IS_CCODE_VARIABLE_DECLARATOR (self));
	ValaCCodeExpression* __temp4 = NULL;
	ValaCCodeExpression* __temp3 = NULL;
	self->priv->_initializer = (__temp4 = (__temp3 = value, (__temp3 == NULL ? NULL : g_object_ref (__temp3))), (self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL))), __temp4);
}


static void vala_ccode_variable_declarator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeVariableDeclarator * self = VALA_CCODE_VARIABLE_DECLARATOR (object);
	switch (property_id) {
		case VALA_CCODE_VARIABLE_DECLARATOR_NAME:
		g_value_set_string (value, vala_ccode_variable_declarator_get_name (self));
		break;
		case VALA_CCODE_VARIABLE_DECLARATOR_INITIALIZER:
		g_value_set_object (value, vala_ccode_variable_declarator_get_initializer (self));
		break;
	}
}


static void vala_ccode_variable_declarator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeVariableDeclarator * self = VALA_CCODE_VARIABLE_DECLARATOR (object);
	switch (property_id) {
		case VALA_CCODE_VARIABLE_DECLARATOR_NAME:
		vala_ccode_variable_declarator_set_name (self, g_value_get_string (value));
		break;
		case VALA_CCODE_VARIABLE_DECLARATOR_INITIALIZER:
		vala_ccode_variable_declarator_set_initializer (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_variable_declarator_class_init (ValaCCodeVariableDeclaratorClass * klass)
{
	vala_ccode_variable_declarator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeVariableDeclaratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_variable_declarator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_variable_declarator_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_variable_declarator_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_variable_declarator_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_VARIABLE_DECLARATOR_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_VARIABLE_DECLARATOR_INITIALIZER, g_param_spec_object ("initializer", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_variable_declarator_init (ValaCCodeVariableDeclarator * self)
{
	self->priv = VALA_CCODE_VARIABLE_DECLARATOR_GET_PRIVATE (self);
}


static void vala_ccode_variable_declarator_dispose (GObject * obj)
{
	ValaCCodeVariableDeclarator * self = VALA_CCODE_VARIABLE_DECLARATOR (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL)));
	ValaCCodeVariableDeclaratorClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CCODE_VARIABLE_DECLARATOR_CLASS (g_type_class_peek (VALA_TYPE_CCODE_VARIABLE_DECLARATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_variable_declarator_get_type ()
{
	static GType vala_ccode_variable_declarator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_variable_declarator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeVariableDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_variable_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeVariableDeclarator), 0, (GInstanceInitFunc) vala_ccode_variable_declarator_init };
		vala_ccode_variable_declarator_type_id = g_type_register_static (VALA_TYPE_CCODE_DECLARATOR, "ValaCCodeVariableDeclarator", &g_define_type_info, 0);
	}
	return vala_ccode_variable_declarator_type_id;
}




