/* valaccodenode.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodenode.h"
#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeNodePrivate {
	ValaCCodeLineDirective* _line;
};
#define VALA_CCODE_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_NODE, ValaCCodeNodePrivate))
enum  {
	VALA_CCODE_NODE_DUMMY_PROPERTY,
	VALA_CCODE_NODE_LINE,
};
static gpointer vala_ccode_node_parent_class = NULL;
static void vala_ccode_node_dispose (GObject * obj);


void vala_ccode_node_write (ValaCCodeNode* self, ValaCCodeWriter* writer)
{
	VALA_CCODE_NODE_GET_CLASS (self)->write (self, writer);
}


ValaCCodeLineDirective* vala_ccode_node_get_line (ValaCCodeNode* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_NODE (self), NULL);
	return self->priv->_line;
}


void vala_ccode_node_set_line (ValaCCodeNode* self, ValaCCodeLineDirective* value)
{
	g_return_if_fail (VALA_IS_CCODE_NODE (self));
	ValaCCodeLineDirective* __temp2 = NULL;
	ValaCCodeLineDirective* __temp1 = NULL;
	self->priv->_line = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->_line == NULL ? NULL : (self->priv->_line = (g_object_unref (self->priv->_line), NULL))), __temp2);
}


static void vala_ccode_node_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeNode * self = VALA_CCODE_NODE (object);
	switch (property_id) {
		case VALA_CCODE_NODE_LINE:
		g_value_set_object (value, vala_ccode_node_get_line (self));
		break;
	}
}


static void vala_ccode_node_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeNode * self = VALA_CCODE_NODE (object);
	switch (property_id) {
		case VALA_CCODE_NODE_LINE:
		vala_ccode_node_set_line (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_node_class_init (ValaCCodeNodeClass * klass)
{
	vala_ccode_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeNodePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_node_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_node_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_node_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_NODE_LINE, g_param_spec_object ("line", "foo", "bar", VALA_TYPE_CCODE_LINE_DIRECTIVE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_node_init (ValaCCodeNode * self)
{
	self->priv = VALA_CCODE_NODE_GET_PRIVATE (self);
}


static void vala_ccode_node_dispose (GObject * obj)
{
	ValaCCodeNode * self = VALA_CCODE_NODE (obj);
	(self->priv->_line == NULL ? NULL : (self->priv->_line = (g_object_unref (self->priv->_line), NULL)));
	ValaCCodeNodeClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CCODE_NODE_CLASS (g_type_class_peek (VALA_TYPE_CCODE_NODE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_node_get_type ()
{
	static GType vala_ccode_node_type_id = 0;
	if (G_UNLIKELY (vala_ccode_node_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeNode), 0, (GInstanceInitFunc) vala_ccode_node_init };
		vala_ccode_node_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaCCodeNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_node_type_id;
}




