/* valaccodemacroreplacement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODEMACROREPLACEMENT_H__
#define __VALACCODEMACROREPLACEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_MACRO_REPLACEMENT (vala_ccode_macro_replacement_get_type ())
#define VALA_CCODE_MACRO_REPLACEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MACRO_REPLACEMENT, ValaCCodeMacroReplacement))
#define VALA_CCODE_MACRO_REPLACEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MACRO_REPLACEMENT, ValaCCodeMacroReplacementClass))
#define VALA_IS_CCODE_MACRO_REPLACEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MACRO_REPLACEMENT))
#define VALA_IS_CCODE_MACRO_REPLACEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MACRO_REPLACEMENT))
#define VALA_CCODE_MACRO_REPLACEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MACRO_REPLACEMENT, ValaCCodeMacroReplacementClass))

typedef struct _ValaCCodeMacroReplacement ValaCCodeMacroReplacement;
typedef struct _ValaCCodeMacroReplacementClass ValaCCodeMacroReplacementClass;
typedef struct _ValaCCodeMacroReplacementPrivate ValaCCodeMacroReplacementPrivate;

/**
 * Represents a preprocessor macro replacement definition in the C code.
 */
struct _ValaCCodeMacroReplacement {
	ValaCCodeNode parent;
	ValaCCodeMacroReplacementPrivate * priv;
};
struct _ValaCCodeMacroReplacementClass {
	ValaCCodeNodeClass parent;
};

ValaCCodeMacroReplacement* vala_ccode_macro_replacement_new (const char* n, const char* replace);
char* vala_ccode_macro_replacement_get_name (ValaCCodeMacroReplacement* self);
void vala_ccode_macro_replacement_set_name (ValaCCodeMacroReplacement* self, const char* value);
char* vala_ccode_macro_replacement_get_replacement (ValaCCodeMacroReplacement* self);
void vala_ccode_macro_replacement_set_replacement (ValaCCodeMacroReplacement* self, const char* value);
GType vala_ccode_macro_replacement_get_type ();

G_END_DECLS

#endif
