/* valaccodedeclaration.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodedeclaration.h"
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeDeclarationPrivate {
	char* _type_name;
	ValaCCodeModifiers _modifiers;
	GList* declarators;
};
#define VALA_CCODE_DECLARATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationPrivate))
enum  {
	VALA_CCODE_DECLARATION_DUMMY_PROPERTY,
	VALA_CCODE_DECLARATION_TYPE_NAME,
	VALA_CCODE_DECLARATION_MODIFIERS,
};
static void vala_ccode_declaration_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_declaration_parent_class = NULL;
static void vala_ccode_declaration_dispose (GObject * obj);


ValaCCodeDeclaration* vala_ccode_declaration_new (const char* _type_name)
{
	g_return_val_if_fail (_type_name != NULL, NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "type-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _type_name), __params_it++);
	ValaCCodeDeclaration * self = g_object_newv (VALA_TYPE_CCODE_DECLARATION, __params_it - __params, __params);
	return self;
}


/**
 * Adds the specified declarator to this declaration.
 *
 * @param decl a declarator
 */
void vala_ccode_declaration_add_declarator (ValaCCodeDeclaration* self, ValaCCodeDeclarator* decl)
{
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (self));
	g_return_if_fail (VALA_IS_CCODE_DECLARATOR (decl));
	self->priv->declarators = g_list_append (self->priv->declarators, g_object_ref (decl));
}


static void vala_ccode_declaration_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeDeclaration * self = VALA_CCODE_DECLARATION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer);
	if ((vala_ccode_declaration_get_modifiers (self) & VALA_CCODE_MODIFIERS_STATIC) == VALA_CCODE_MODIFIERS_STATIC) {
		vala_ccode_writer_write_string (writer, "static ");
	}
	if ((vala_ccode_declaration_get_modifiers (self) & VALA_CCODE_MODIFIERS_REGISTER) == VALA_CCODE_MODIFIERS_REGISTER) {
		vala_ccode_writer_write_string (writer, "register ");
	}
	vala_ccode_writer_write_string (writer, vala_ccode_declaration_get_type_name (self));
	vala_ccode_writer_write_string (writer, " ");
	gboolean first = TRUE;
	{
		GList* __temp0 = NULL;
		__temp0 = self->priv->declarators;
		GList* decl_it;
		for (decl_it = __temp0; decl_it != NULL; decl_it = decl_it->next) {
			ValaCCodeDeclarator* decl = decl_it->data;
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				vala_ccode_node_write (VALA_CCODE_NODE (decl), writer);
			}
		}
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_declaration_get_type_name (ValaCCodeDeclaration* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_DECLARATION (self), NULL);
	return self->priv->_type_name;
}


void vala_ccode_declaration_set_type_name (ValaCCodeDeclaration* self, const char* value)
{
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (self));
	char* __temp2 = NULL;
	self->priv->_type_name = (__temp2 = g_strdup (value), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), __temp2);
}


ValaCCodeModifiers vala_ccode_declaration_get_modifiers (ValaCCodeDeclaration* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_DECLARATION (self), 0);
	return self->priv->_modifiers;
}


void vala_ccode_declaration_set_modifiers (ValaCCodeDeclaration* self, ValaCCodeModifiers value)
{
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (self));
	self->priv->_modifiers = value;
}


static void vala_ccode_declaration_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeDeclaration * self = VALA_CCODE_DECLARATION (object);
	switch (property_id) {
		case VALA_CCODE_DECLARATION_TYPE_NAME:
		g_value_set_string (value, vala_ccode_declaration_get_type_name (self));
		break;
		case VALA_CCODE_DECLARATION_MODIFIERS:
		g_value_set_int (value, vala_ccode_declaration_get_modifiers (self));
		break;
	}
}


static void vala_ccode_declaration_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeDeclaration * self = VALA_CCODE_DECLARATION (object);
	switch (property_id) {
		case VALA_CCODE_DECLARATION_TYPE_NAME:
		vala_ccode_declaration_set_type_name (self, g_value_get_string (value));
		break;
		case VALA_CCODE_DECLARATION_MODIFIERS:
		vala_ccode_declaration_set_modifiers (self, g_value_get_int (value));
		break;
	}
}


static void vala_ccode_declaration_class_init (ValaCCodeDeclarationClass * klass)
{
	vala_ccode_declaration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeDeclarationPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_declaration_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_declaration_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_declaration_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_declaration_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DECLARATION_TYPE_NAME, g_param_spec_string ("type-name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DECLARATION_MODIFIERS, g_param_spec_int ("modifiers", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_declaration_init (ValaCCodeDeclaration * self)
{
	self->priv = VALA_CCODE_DECLARATION_GET_PRIVATE (self);
}


static void vala_ccode_declaration_dispose (GObject * obj)
{
	ValaCCodeDeclaration * self = VALA_CCODE_DECLARATION (obj);
	(self->priv->_type_name = (g_free (self->priv->_type_name), NULL));
	(self->priv->declarators == NULL ? NULL : (self->priv->declarators = (g_list_foreach (self->priv->declarators, (GFunc) g_object_unref, NULL), g_list_free (self->priv->declarators), NULL)));
	ValaCCodeDeclarationClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CCODE_DECLARATION_CLASS (g_type_class_peek (VALA_TYPE_CCODE_DECLARATION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_declaration_get_type ()
{
	static GType vala_ccode_declaration_type_id = 0;
	if (G_UNLIKELY (vala_ccode_declaration_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDeclarationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_declaration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDeclaration), 0, (GInstanceInitFunc) vala_ccode_declaration_init };
		vala_ccode_declaration_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeDeclaration", &g_define_type_info, 0);
	}
	return vala_ccode_declaration_type_id;
}




