/* tracker-utils.c generated by valac 0.43.90, the Vala compiler
 * generated from tracker-utils.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdarg.h>

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

gchar* tracker_sparql_escape_uri_vprintf (const gchar* format,
                                          va_list args);
gchar* tracker_sparql_escape_uri_printf (const gchar* format,
                                         ...);
gchar* tracker_sparql_escape_uri (const gchar* uri);
gchar* tracker_sparql_escape_string (const gchar* literal);
void uuid_generate (guchar* uuid);
void uuid_unparse_lower (guchar* uuid,
                         gchar* out);
gchar* tracker_sparql_get_uuid_urn (void);

/**
 * SECTION: tracker-misc
 * @short_description: General purpose utilities provided by the library
 * @title: Utilities
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <para>
 * The libtracker-sparql utilities help in the creation of proper SPARQL queries.
 * </para>
 */
/**
 * tracker_sparql_escape_string:
 * @literal: a string to escape
 *
 * Escapes a string so that it can be used in a SPARQL query.
 *
 * Returns: a newly-allocated string with the escaped version of @literal.
 * The returned string should be freed with g_free() when no longer needed.
 *
 * Since: 0.10
 */
gchar*
tracker_sparql_escape_string (const gchar* literal)
{
	gchar* result = NULL;
	GString* str = NULL;
	GString* _tmp0_;
	gchar* p = NULL;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
#line 49 "tracker-utils.vala"
	g_return_val_if_fail (literal != NULL, NULL);
#line 50 "tracker-utils.vala"
	_tmp0_ = g_string_new ("");
#line 50 "tracker-utils.vala"
	str = _tmp0_;
#line 56 "tracker-utils.vala"
	p = (gchar*) literal;
#line 58 "tracker-utils.vala"
	while (TRUE) {
#line 85 "tracker-utils.c"
		gchar* _tmp1_;
		gsize len = 0UL;
		gchar* _tmp2_;
		GString* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp14_;
#line 58 "tracker-utils.vala"
		_tmp1_ = p;
#line 58 "tracker-utils.vala"
		if (!((*_tmp1_) != '\0')) {
#line 58 "tracker-utils.vala"
			break;
#line 100 "tracker-utils.c"
		}
#line 59 "tracker-utils.vala"
		_tmp2_ = p;
#line 59 "tracker-utils.vala"
		len = strcspn ((const gchar*) _tmp2_, "\t\n\r\b\f\"\\");
#line 60 "tracker-utils.vala"
		_tmp3_ = str;
#line 60 "tracker-utils.vala"
		_tmp4_ = p;
#line 60 "tracker-utils.vala"
		g_string_append_len (_tmp3_, (const gchar*) _tmp4_, (gssize) ((glong) len));
#line 61 "tracker-utils.vala"
		_tmp5_ = p;
#line 61 "tracker-utils.vala"
		p = _tmp5_ + len;
#line 63 "tracker-utils.vala"
		_tmp6_ = p;
#line 63 "tracker-utils.vala"
		switch (*_tmp6_) {
#line 63 "tracker-utils.vala"
			case '\t':
#line 122 "tracker-utils.c"
			{
				GString* _tmp7_;
#line 65 "tracker-utils.vala"
				_tmp7_ = str;
#line 65 "tracker-utils.vala"
				g_string_append (_tmp7_, "\\t");
#line 66 "tracker-utils.vala"
				break;
#line 131 "tracker-utils.c"
			}
#line 63 "tracker-utils.vala"
			case '\n':
#line 135 "tracker-utils.c"
			{
				GString* _tmp8_;
#line 68 "tracker-utils.vala"
				_tmp8_ = str;
#line 68 "tracker-utils.vala"
				g_string_append (_tmp8_, "\\n");
#line 69 "tracker-utils.vala"
				break;
#line 144 "tracker-utils.c"
			}
#line 63 "tracker-utils.vala"
			case '\r':
#line 148 "tracker-utils.c"
			{
				GString* _tmp9_;
#line 71 "tracker-utils.vala"
				_tmp9_ = str;
#line 71 "tracker-utils.vala"
				g_string_append (_tmp9_, "\\r");
#line 72 "tracker-utils.vala"
				break;
#line 157 "tracker-utils.c"
			}
#line 63 "tracker-utils.vala"
			case '\b':
#line 161 "tracker-utils.c"
			{
				GString* _tmp10_;
#line 74 "tracker-utils.vala"
				_tmp10_ = str;
#line 74 "tracker-utils.vala"
				g_string_append (_tmp10_, "\\b");
#line 75 "tracker-utils.vala"
				break;
#line 170 "tracker-utils.c"
			}
#line 63 "tracker-utils.vala"
			case '\f':
#line 174 "tracker-utils.c"
			{
				GString* _tmp11_;
#line 77 "tracker-utils.vala"
				_tmp11_ = str;
#line 77 "tracker-utils.vala"
				g_string_append (_tmp11_, "\\f");
#line 78 "tracker-utils.vala"
				break;
#line 183 "tracker-utils.c"
			}
#line 63 "tracker-utils.vala"
			case '"':
#line 187 "tracker-utils.c"
			{
				GString* _tmp12_;
#line 80 "tracker-utils.vala"
				_tmp12_ = str;
#line 80 "tracker-utils.vala"
				g_string_append (_tmp12_, "\\\"");
#line 81 "tracker-utils.vala"
				break;
#line 196 "tracker-utils.c"
			}
#line 63 "tracker-utils.vala"
			case '\\':
#line 200 "tracker-utils.c"
			{
				GString* _tmp13_;
#line 83 "tracker-utils.vala"
				_tmp13_ = str;
#line 83 "tracker-utils.vala"
				g_string_append (_tmp13_, "\\\\");
#line 84 "tracker-utils.vala"
				break;
#line 209 "tracker-utils.c"
			}
			default:
			{
#line 86 "tracker-utils.vala"
				continue;
#line 215 "tracker-utils.c"
			}
		}
#line 89 "tracker-utils.vala"
		_tmp14_ = p;
#line 89 "tracker-utils.vala"
		p = _tmp14_ + 1;
#line 222 "tracker-utils.c"
	}
#line 92 "tracker-utils.vala"
	_tmp15_ = str;
#line 92 "tracker-utils.vala"
	_tmp16_ = _tmp15_->str;
#line 92 "tracker-utils.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 92 "tracker-utils.vala"
	result = _tmp17_;
#line 92 "tracker-utils.vala"
	_g_string_free0 (str);
#line 92 "tracker-utils.vala"
	return result;
#line 236 "tracker-utils.c"
}

/**
 * tracker_sparql_get_uuid_urn:
 *
 * Generates a unique universal identifier to be used for urns
 * when inserting SPARQL into the database. The string returned is
 * in lower case and has the format "urn:uuid:&percnt;s" where
 * &percnt;s is the uuid generated.
 *
 * Returns: a newly-allocated string. The returned string should
 * be freed with g_free() when no longer needed.
 *
 * Since: 0.10
 */
gchar*
tracker_sparql_get_uuid_urn (void)
{
	gchar* result = NULL;
	guchar* base_uuid = NULL;
	guchar* _tmp0_;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	gchar* lower = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 115 "tracker-utils.vala"
	_tmp0_ = g_new0 (guchar, 16);
#line 115 "tracker-utils.vala"
	base_uuid = _tmp0_;
#line 115 "tracker-utils.vala"
	base_uuid_length1 = 16;
#line 115 "tracker-utils.vala"
	_base_uuid_size_ = base_uuid_length1;
#line 116 "tracker-utils.vala"
	_tmp1_ = g_new0 (gchar, 37);
#line 116 "tracker-utils.vala"
	lower = (gchar*) _tmp1_;
#line 118 "tracker-utils.vala"
	uuid_generate (base_uuid);
#line 119 "tracker-utils.vala"
	uuid_unparse_lower (base_uuid, (gchar*) lower);
#line 122 "tracker-utils.vala"
	_tmp2_ = g_strdup_printf ("urn:uuid:%s", lower);
#line 122 "tracker-utils.vala"
	result = _tmp2_;
#line 122 "tracker-utils.vala"
	_g_free0 (lower);
#line 122 "tracker-utils.vala"
	base_uuid = (g_free (base_uuid), NULL);
#line 122 "tracker-utils.vala"
	return result;
#line 289 "tracker-utils.c"
}

