/* test-busy-handling.c generated by valac 0.34.4, the Vala compiler
 * generated from test-busy-handling.vala, do not modify */

/*
 * Copyright (C) 2008, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/* To run this test:*/
/* -===-------------*/
/**/
/* tracker daemon -k*/
/* rm ~/.cache/tracker/meta.db*/
/* export TRACKER_DEBUG_MAKE_JOURNAL_READER_GO_VERY_SLOW=yes*/
/* tracker-store*/
/* ./busy-handling-test*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;

#define TYPE_RESOURCES_PROXY (resources_proxy_get_type ())
typedef GDBusProxy ResourcesProxy;
typedef GDBusProxyClass ResourcesProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_STATUS (status_get_type ())
#define STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS, Status))
#define IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS))
#define STATUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_STATUS, StatusIface))

typedef struct _Status Status;
typedef struct _StatusIface StatusIface;

#define TYPE_STATUS_PROXY (status_proxy_get_type ())
typedef GDBusProxy StatusProxy;
typedef GDBusProxyClass StatusProxyClass;

#define TYPE_TEST_APP (test_app_get_type ())
#define TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_APP, TestApp))
#define TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_APP, TestAppClass))
#define IS_TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_APP))
#define IS_TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_APP))
#define TEST_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_APP, TestAppClass))

typedef struct _TestApp TestApp;
typedef struct _TestAppClass TestAppClass;
typedef struct _TestAppPrivate TestAppPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _test_app_unref0(var) ((var == NULL) ? NULL : (var = (test_app_unref (var), NULL)))
typedef struct _TestAppDoQueryTestsAsyncData TestAppDoQueryTestsAsyncData;
typedef struct _TestAppDoAsyncQueryTestsData TestAppDoAsyncQueryTestsData;
typedef struct _TestAppJumperAsyncData TestAppJumperAsyncData;
typedef struct _ParamSpecTestApp ParamSpecTestApp;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ResourcesIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*sparql_query_finish) (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _StatusIface {
	GTypeInterface parent_iface;
	gdouble (*get_progress) (Status* self, GError** error);
	gchar* (*get_status) (Status* self, GError** error);
};

struct _TestApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestAppPrivate * priv;
};

struct _TestAppClass {
	GTypeClass parent_class;
	void (*finalize) (TestApp *self);
};

struct _TestAppPrivate {
	gint res;
	gint users;
	GMainLoop* loop;
	gboolean initialized;
	gboolean ready;
};

struct _TestAppDoQueryTestsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
	gchar* test_name;
	gint cnt;
	gchar** results;
	Resources* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_;
	gint results_length1;
	gint results_length2;
	gchar** res_collection;
	gint res_collection_length1;
	gint res_collection_length2;
	gint res_it;
	gchar* _tmp4_;
	gchar* res;
	gint _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError * _inner_error_;
};

struct _TestAppDoAsyncQueryTestsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
	gint _tmp0_;
};

struct _TestAppJumperAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
};

struct _ParamSpecTestApp {
	GParamSpec parent_instance;
};


static gpointer test_app_parent_class = NULL;
static Resources* test_app_resources_object;
static Resources* test_app_resources_object = NULL;
static Status* test_app_status_object;
static Status* test_app_status_object = NULL;

GType resources_proxy_get_type (void) G_GNUC_CONST;
guint resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType resources_get_type (void) G_GNUC_CONST;
void resources_sparql_query (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** resources_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void resources_proxy_sparql_query_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** resources_proxy_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void resources_proxy_resources_interface_init (ResourcesIface* iface);
static void _dbus_resources_sparql_query (Resources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _resources_unregister_object (gpointer user_data);
GType status_proxy_get_type (void) G_GNUC_CONST;
guint status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType status_get_type (void) G_GNUC_CONST;
gdouble status_get_progress (Status* self, GError** error);
gchar* status_get_status (Status* self, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void status_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_status_progress (Status* self, GVariant* parameters);
static gdouble status_proxy_get_progress (Status* self, GError** error);
static gchar* status_proxy_get_status (Status* self, GError** error);
static void status_proxy_status_interface_init (StatusIface* iface);
static void _dbus_status_get_progress (Status* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_status_get_status (Status* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_status_progress (GObject* _sender, const gchar* status, gdouble progress, gpointer* _data);
static void _status_unregister_object (gpointer user_data);
gpointer test_app_ref (gpointer instance);
void test_app_unref (gpointer instance);
GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_app (GValue* value, gpointer v_object);
void value_take_test_app (GValue* value, gpointer v_object);
gpointer value_get_test_app (const GValue* value);
GType test_app_get_type (void) G_GNUC_CONST;
#define TEST_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_APP, TestAppPrivate))
enum  {
	TEST_APP_DUMMY_PROPERTY
};
TestApp* test_app_new (void);
TestApp* test_app_construct (GType object_type);
static void test_app_on_status_cb (TestApp* self, const gchar* status, gdouble progress);
static void _test_app_on_status_cb_status_progress (Status* _sender, const gchar* status, gdouble progress, gpointer self);
static void test_app_do_query_tests_async_data_free (gpointer _data);
static void test_app_do_query_tests_async (TestApp* self, const gchar* test_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_do_query_tests_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_do_query_tests_async_co (TestAppDoQueryTestsAsyncData* _data_);
static void test_app_do_query_tests_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_check_shutdown (TestApp* self);
static void test_app_do_async_query_tests_data_free (gpointer _data);
static void test_app_do_async_query_tests (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_do_async_query_tests_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_do_async_query_tests_co (TestAppDoAsyncQueryTestsData* _data_);
static void test_app_do_async_query_tests_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_jumper_async_data_free (gpointer _data);
static void test_app_jumper_async (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_jumper_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_jumper_async_co (TestAppJumperAsyncData* _data_);
static void test_app_jumper_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean test_app_test_ready (TestApp* self);
static gboolean test_app_in_mainloop (TestApp* self);
static gboolean _test_app_test_ready_gsource_func (gpointer self);
gint test_app_run (TestApp* self);
static gboolean _test_app_in_mainloop_gsource_func (gpointer self);
static void test_app_finalize (TestApp* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _resources_dbus_arg_info_sparql_query_query = {-1, "query", "s"};
static const GDBusArgInfo _resources_dbus_arg_info_sparql_query_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _resources_dbus_arg_info_sparql_query_in[] = {&_resources_dbus_arg_info_sparql_query_query, NULL};
static const GDBusArgInfo * const _resources_dbus_arg_info_sparql_query_out[] = {&_resources_dbus_arg_info_sparql_query_result, NULL};
static const GDBusMethodInfo _resources_dbus_method_info_sparql_query = {-1, "SparqlQuery", (GDBusArgInfo **) (&_resources_dbus_arg_info_sparql_query_in), (GDBusArgInfo **) (&_resources_dbus_arg_info_sparql_query_out)};
static const GDBusMethodInfo * const _resources_dbus_method_info[] = {&_resources_dbus_method_info_sparql_query, NULL};
static const GDBusSignalInfo * const _resources_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_resources_dbus_method_info), (GDBusSignalInfo **) (&_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_resources_dbus_property_info)};
static const GDBusInterfaceVTable _resources_dbus_interface_vtable = {resources_dbus_interface_method_call, resources_dbus_interface_get_property, resources_dbus_interface_set_property};
static const GDBusArgInfo _status_dbus_arg_info_get_progress_result = {-1, "result", "d"};
static const GDBusArgInfo * const _status_dbus_arg_info_get_progress_in[] = {NULL};
static const GDBusArgInfo * const _status_dbus_arg_info_get_progress_out[] = {&_status_dbus_arg_info_get_progress_result, NULL};
static const GDBusMethodInfo _status_dbus_method_info_get_progress = {-1, "GetProgress", (GDBusArgInfo **) (&_status_dbus_arg_info_get_progress_in), (GDBusArgInfo **) (&_status_dbus_arg_info_get_progress_out)};
static const GDBusArgInfo _status_dbus_arg_info_get_status_result = {-1, "result", "s"};
static const GDBusArgInfo * const _status_dbus_arg_info_get_status_in[] = {NULL};
static const GDBusArgInfo * const _status_dbus_arg_info_get_status_out[] = {&_status_dbus_arg_info_get_status_result, NULL};
static const GDBusMethodInfo _status_dbus_method_info_get_status = {-1, "GetStatus", (GDBusArgInfo **) (&_status_dbus_arg_info_get_status_in), (GDBusArgInfo **) (&_status_dbus_arg_info_get_status_out)};
static const GDBusMethodInfo * const _status_dbus_method_info[] = {&_status_dbus_method_info_get_progress, &_status_dbus_method_info_get_status, NULL};
static const GDBusArgInfo _status_dbus_arg_info_progress_status = {-1, "status", "s"};
static const GDBusArgInfo _status_dbus_arg_info_progress_progress = {-1, "progress", "d"};
static const GDBusArgInfo * const _status_dbus_arg_info_progress[] = {&_status_dbus_arg_info_progress_status, &_status_dbus_arg_info_progress_progress, NULL};
static const GDBusSignalInfo _status_dbus_signal_info_progress = {-1, "Progress", (GDBusArgInfo **) (&_status_dbus_arg_info_progress)};
static const GDBusSignalInfo * const _status_dbus_signal_info[] = {&_status_dbus_signal_info_progress, NULL};
static const GDBusPropertyInfo * const _status_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _status_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Status", (GDBusMethodInfo **) (&_status_dbus_method_info), (GDBusSignalInfo **) (&_status_dbus_signal_info), (GDBusPropertyInfo **) (&_status_dbus_property_info)};
static const GDBusInterfaceVTable _status_dbus_interface_vtable = {status_dbus_interface_method_call, status_dbus_interface_get_property, status_dbus_interface_set_property};

void resources_sparql_query (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 30 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	RESOURCES_GET_INTERFACE (self)->sparql_query (self, query, _callback_, _user_data_);
#line 285 "test-busy-handling.c"
}


gchar** resources_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
#line 30 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return RESOURCES_GET_INTERFACE (self)->sparql_query_finish (self, _res_, result_length1, result_length2, error);
#line 292 "test-busy-handling.c"
}


static void resources_base_init (ResourcesIface * iface) {
#line 30 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	static gboolean initialized = FALSE;
#line 30 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (!initialized) {
#line 30 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		initialized = TRUE;
#line 303 "test-busy-handling.c"
	}
}


GType resources_get_type (void) {
	static volatile gsize resources_type_id__volatile = 0;
	if (g_once_init_enter (&resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType resources_type_id;
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) resources_proxy_get_type);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Resources");
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_resources_dbus_interface_info));
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) resources_register_object);
		g_once_init_leave (&resources_type_id__volatile, resources_type_id);
	}
	return resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ResourcesProxy, resources_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_proxy_resources_interface_init) )
static void resources_proxy_class_init (ResourcesProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = resources_proxy_g_signal;
}


static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void resources_proxy_init (ResourcesProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void resources_proxy_sparql_query_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, 1215752191, NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static gchar** resources_proxy_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	int _result_length2;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		int _tmp1__length2;
		GVariantIter _tmp4_;
		GVariant* _tmp5_;
		_tmp1__length2 = 0;
		g_variant_iter_init (&_tmp4_, _tmp3_);
		for (; (_tmp5_ = g_variant_iter_next_value (&_tmp4_)) != NULL; _tmp1__length2++) {
			if (_tmp1__size == _tmp1__length) {
				_tmp1__size = 2 * _tmp1__size;
				_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
			}
			_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp5_, NULL);
			g_variant_unref (_tmp5_);
		}
		_result_length2 = _tmp1__length2;
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	g_object_unref (_reply_message);
	return _result;
}


static void resources_proxy_resources_interface_init (ResourcesIface* iface) {
	iface->sparql_query = resources_proxy_sparql_query_async;
	iface->sparql_query_finish = resources_proxy_sparql_query_finish;
}


static void _dbus_resources_sparql_query (Resources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	resources_sparql_query (self, query, (GAsyncReadyCallback) _dbus_resources_sparql_query_ready, invocation);
	_g_free0 (query);
}


static void _dbus_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	int result_length2 = 0;
	gchar** _tmp7_;
	GVariantBuilder _tmp8_;
	int _tmp9_;
	invocation = _user_data_;
	result = resources_sparql_query_finish ((Resources*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp7_ = result;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("aas"));
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		GVariantBuilder _tmp10_;
		int _tmp11_;
		g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("aas"));
		for (_tmp11_ = 0; _tmp11_ < result_length2; _tmp11_++) {
			g_variant_builder_add_value (&_tmp10_, g_variant_new_string (*_tmp7_));
			_tmp7_++;
		}
		g_variant_builder_add_value (&_tmp8_, g_variant_builder_end (&_tmp10_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp8_));
	result = (_vala_array_free (result, result_length1 * result_length2, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_resources_sparql_query (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint resources_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_resources_dbus_interface_info), &_resources_dbus_interface_vtable, data, _resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _resources_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gdouble status_get_progress (Status* self, GError** error) {
#line 38 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 38 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return STATUS_GET_INTERFACE (self)->get_progress (self, error);
#line 543 "test-busy-handling.c"
}


gchar* status_get_status (Status* self, GError** error) {
#line 39 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return STATUS_GET_INTERFACE (self)->get_status (self, error);
#line 552 "test-busy-handling.c"
}


static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_DOUBLE) (gpointer data1, const char* arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_if_fail (n_param_values == 3);
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		data1 = closure->data;
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		data2 = param_values->data[0].v_pointer;
#line 571 "test-busy-handling.c"
	} else {
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		data1 = param_values->data[0].v_pointer;
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		data2 = closure->data;
#line 577 "test-busy-handling.c"
	}
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	callback = (GMarshalFunc_VOID__STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_double (param_values + 2), data2);
#line 583 "test-busy-handling.c"
}


static void status_base_init (StatusIface * iface) {
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	static gboolean initialized = FALSE;
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (!initialized) {
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		initialized = TRUE;
#line 36 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_signal_new ("progress", TYPE_STATUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_DOUBLE, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_DOUBLE);
#line 596 "test-busy-handling.c"
	}
}


GType status_get_type (void) {
	static volatile gsize status_type_id__volatile = 0;
	if (g_once_init_enter (&status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatusIface), (GBaseInitFunc) status_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType status_type_id;
		status_type_id = g_type_register_static (G_TYPE_INTERFACE, "Status", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (status_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (status_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) status_proxy_get_type);
		g_type_set_qdata (status_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Status");
		g_type_set_qdata (status_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_status_dbus_interface_info));
		g_type_set_qdata (status_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) status_register_object);
		g_once_init_leave (&status_type_id__volatile, status_type_id);
	}
	return status_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (StatusProxy, status_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_STATUS, status_proxy_status_interface_init) )
static void status_proxy_class_init (StatusProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = status_proxy_g_signal;
}


static void _dbus_handle_status_progress (Status* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* status = NULL;
	GVariant* _tmp12_;
	gdouble progress = 0.0;
	GVariant* _tmp13_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	status = g_variant_dup_string (_tmp12_, NULL);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	progress = g_variant_get_double (_tmp13_);
	g_variant_unref (_tmp13_);
	g_signal_emit_by_name (self, "progress", status, progress);
	_g_free0 (status);
}


static void status_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Progress") == 0) {
		_dbus_handle_status_progress ((Status*) proxy, parameters);
	}
}


static void status_proxy_init (StatusProxy* self) {
}


static gdouble status_proxy_get_progress (Status* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gdouble _result;
	GVariant* _tmp14_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Status", "GetProgress");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return 0.0;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return 0.0;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp14_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_double (_tmp14_);
	g_variant_unref (_tmp14_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* status_proxy_get_status (Status* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp15_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Status", "GetStatus");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp15_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	g_object_unref (_reply_message);
	return _result;
}


static void status_proxy_status_interface_init (StatusIface* iface) {
	iface->get_progress = status_proxy_get_progress;
	iface->get_status = status_proxy_get_status;
}


static void _dbus_status_get_progress (Status* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gdouble result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = status_get_progress (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_double (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_status_get_status (Status* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = status_get_status (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetProgress") == 0) {
		_dbus_status_get_progress (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStatus") == 0) {
		_dbus_status_get_status (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_status_progress (GObject* _sender, const gchar* status, gdouble progress, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Status", "Progress", _arguments, NULL);
}


guint status_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_status_dbus_interface_info), &_status_dbus_interface_vtable, data, _status_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "progress", (GCallback) _dbus_status_progress, data);
	return result;
}


static void _status_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_status_progress, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _test_app_on_status_cb_status_progress (Status* _sender, const gchar* status, gdouble progress, gpointer self) {
#line 67 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_on_status_cb ((TestApp*) self, status, progress);
#line 852 "test-busy-handling.c"
}


TestApp* test_app_construct (GType object_type) {
	TestApp* self = NULL;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 51 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self = (TestApp*) g_type_create_instance (object_type);
#line 51 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = self->priv->initialized;
#line 51 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_vala_return_val_if_fail (!_tmp0_, "!initialized", NULL);
#line 866 "test-busy-handling.c"
	{
		gdouble progress = 0.0;
		gchar* status = NULL;
		Resources* _tmp1_ = NULL;
		Resources* _tmp2_ = NULL;
		Resources* _tmp3_ = NULL;
		Status* _tmp4_ = NULL;
		Status* _tmp5_ = NULL;
		Status* _tmp6_ = NULL;
		Status* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		Status* _tmp9_ = NULL;
		gdouble _tmp10_ = 0.0;
		gchar* _tmp11_ = NULL;
		Status* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gdouble _tmp16_ = 0.0;
#line 57 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp2_ = g_initable_new (TYPE_RESOURCES_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Tracker1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Tracker1/Resources", "g-interface-name", "org.freedesktop.Tracker1.Resources", "g-interface-info", g_type_get_qdata (TYPE_RESOURCES, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 57 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp1_ = (Resources*) _tmp2_;
#line 57 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 57 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_free0 (status);
#line 894 "test-busy-handling.c"
			goto __catch0_g_error;
		}
#line 57 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp3_ = _tmp1_;
#line 57 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp1_ = NULL;
#line 57 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_object_unref0 (test_app_resources_object);
#line 57 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		test_app_resources_object = _tmp3_;
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp5_ = g_initable_new (TYPE_STATUS_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Tracker1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Tracker1/Status", "g-interface-name", "org.freedesktop.Tracker1.Status", "g-interface-info", g_type_get_qdata (TYPE_STATUS, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp4_ = (Status*) _tmp5_;
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_object_unref0 (_tmp1_);
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_free0 (status);
#line 915 "test-busy-handling.c"
			goto __catch0_g_error;
		}
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp6_ = _tmp4_;
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp4_ = NULL;
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_object_unref0 (test_app_status_object);
#line 62 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		test_app_status_object = _tmp6_;
#line 67 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp7_ = test_app_status_object;
#line 67 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_signal_connect (_tmp7_, "progress", (GCallback) _test_app_on_status_cb_status_progress, self);
#line 68 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp9_ = test_app_status_object;
#line 68 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp10_ = status_get_progress (_tmp9_, &_inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp8_ = _tmp10_;
#line 68 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_object_unref0 (_tmp4_);
#line 68 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_object_unref0 (_tmp1_);
#line 68 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_free0 (status);
#line 944 "test-busy-handling.c"
			goto __catch0_g_error;
		}
#line 68 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		progress = _tmp8_;
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp12_ = test_app_status_object;
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp13_ = status_get_status (_tmp12_, &_inner_error_);
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp11_ = _tmp13_;
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_object_unref0 (_tmp4_);
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_object_unref0 (_tmp1_);
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_g_free0 (status);
#line 963 "test-busy-handling.c"
			goto __catch0_g_error;
		}
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp14_ = _tmp11_;
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp11_ = NULL;
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_free0 (status);
#line 69 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		status = _tmp14_;
#line 71 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp16_ = progress;
#line 71 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		if (_tmp16_ == 1.0) {
#line 978 "test-busy-handling.c"
			const gchar* _tmp17_ = NULL;
#line 71 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_tmp17_ = status;
#line 71 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_tmp15_ = g_strcmp0 (_tmp17_, "Idle") == 0;
#line 984 "test-busy-handling.c"
		} else {
#line 71 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_tmp15_ = FALSE;
#line 988 "test-busy-handling.c"
		}
#line 71 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		self->priv->ready = _tmp15_;
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_free0 (_tmp11_);
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_object_unref0 (_tmp4_);
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_object_unref0 (_tmp1_);
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_free0 (status);
#line 1000 "test-busy-handling.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		e = _inner_error_;
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_inner_error_ = NULL;
#line 74 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp18_ = e;
#line 74 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp19_ = _tmp18_->message;
#line 74 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_warning ("test-busy-handling.vala:74: Could not connect to D-Bus service: %s", _tmp19_);
#line 75 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		self->priv->initialized = FALSE;
#line 76 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		self->priv->res = -1;
#line 77 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_error_free0 (e);
#line 77 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		return self;
#line 1026 "test-busy-handling.c"
	}
	__finally0:
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_clear_error (&_inner_error_);
#line 53 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		return NULL;
#line 1037 "test-busy-handling.c"
	}
#line 79 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv->initialized = TRUE;
#line 51 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return self;
#line 1043 "test-busy-handling.c"
}


TestApp* test_app_new (void) {
#line 51 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return test_app_construct (TYPE_TEST_APP);
#line 1050 "test-busy-handling.c"
}


static void test_app_on_status_cb (TestApp* self, const gchar* status, gdouble progress) {
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 82 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_if_fail (status != NULL);
#line 83 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = status;
#line 83 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp1_ = progress;
#line 83 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_print ("%s: %f\n", _tmp0_, _tmp1_);
#line 85 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp2_ = progress;
#line 85 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (_tmp2_ == 1.0) {
#line 86 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		self->priv->ready = TRUE;
#line 1074 "test-busy-handling.c"
	}
}


static void test_app_do_query_tests_async_data_free (gpointer _data) {
	TestAppDoQueryTestsAsyncData* _data_;
	_data_ = _data;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_g_free0 (_data_->test_name);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_test_app_unref0 (_data_->self);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_slice_free (TestAppDoQueryTestsAsyncData, _data_);
#line 1088 "test-busy-handling.c"
}


static gpointer _test_app_ref0 (gpointer self) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return self ? test_app_ref (self) : NULL;
#line 1095 "test-busy-handling.c"
}


static void test_app_do_query_tests_async (TestApp* self, const gchar* test_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppDoQueryTestsAsyncData* _data_;
	TestApp* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = g_slice_new0 (TestAppDoQueryTestsAsyncData);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, test_app_do_query_tests_async);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_do_query_tests_async_data_free);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = _test_app_ref0 (self);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->self = _tmp0_;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp1_ = test_name;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_g_free0 (_data_->test_name);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->test_name = _tmp2_;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_query_tests_async_co (_data_);
#line 1124 "test-busy-handling.c"
}


static void test_app_do_query_tests_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppDoQueryTestsAsyncData* _data_;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1132 "test-busy-handling.c"
}


static void test_app_do_query_tests_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppDoQueryTestsAsyncData* _data_;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = _user_data_;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_source_object_ = source_object;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_res_ = _res_;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_query_tests_async_co (_data_);
#line 1146 "test-busy-handling.c"
}


static gboolean test_app_do_query_tests_async_co (TestAppDoQueryTestsAsyncData* _data_) {
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	switch (_data_->_state_) {
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		case 0:
#line 1155 "test-busy-handling.c"
		goto _state_0;
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		case 1:
#line 1159 "test-busy-handling.c"
		goto _state_1;
		default:
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_assert_not_reached ();
#line 1164 "test-busy-handling.c"
	}
	_state_0:
	{
#line 92 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->cnt = 0;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp0_ = NULL;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp0_ = test_app_resources_object;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp1_ = 0;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp2_ = 0;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_state_ = 1;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		resources_sparql_query (_data_->_tmp0_, "SELECT ?u { ?u a rdfs:Resource }", test_app_do_query_tests_async_ready, _data_);
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		return FALSE;
#line 1184 "test-busy-handling.c"
		_state_1:
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp3_ = NULL;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp3_ = resources_sparql_query_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_tmp2_, &_data_->_inner_error_);
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->results_length1 = 0;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->results_length2 = 0;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->results = _data_->_tmp3_;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->results_length1 = _data_->_tmp1_;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->results_length2 = _data_->_tmp2_;
#line 93 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1202 "test-busy-handling.c"
			goto __catch1_g_error;
		}
		{
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_data_->res_collection_length1 = 0;
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_data_->res_collection_length2 = 0;
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_data_->res_collection = _data_->results;
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			_data_->res_collection_length1 = _data_->results_length1 * _data_->results_length2;
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			for (_data_->res_it = 0; _data_->res_it < (_data_->results_length1 * _data_->results_length2); _data_->res_it = _data_->res_it + 1) {
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
				_data_->_tmp4_ = NULL;
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
				_data_->_tmp4_ = g_strdup (_data_->res_collection[_data_->res_it]);
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
				_data_->res = _data_->_tmp4_;
#line 1222 "test-busy-handling.c"
				{
#line 95 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
					_data_->_tmp5_ = 0;
#line 95 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
					_data_->_tmp5_ = _data_->cnt;
#line 95 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
					_data_->cnt = _data_->_tmp5_ + 1;
#line 94 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
					_g_free0 (_data_->res);
#line 1232 "test-busy-handling.c"
				}
			}
		}
#line 97 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp6_ = NULL;
#line 97 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp6_ = _data_->test_name;
#line 97 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp7_ = 0;
#line 97 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp7_ = _data_->cnt;
#line 97 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_print ("%s: Saw %d strings in result\n", _data_->_tmp6_, _data_->_tmp7_);
#line 91 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->results = (_vala_array_free (_data_->results, _data_->results_length1 * _data_->results_length2, (GDestroyNotify) g_free), NULL);
#line 1248 "test-busy-handling.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 91 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->e = _data_->_inner_error_;
#line 91 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_inner_error_ = NULL;
#line 99 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp8_ = NULL;
#line 99 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp8_ = _data_->e;
#line 99 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp9_ = NULL;
#line 99 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->_tmp9_ = _data_->_tmp8_->message;
#line 99 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_print ("Fail: %s\n", _data_->_tmp9_);
#line 100 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_data_->self->priv->res = -1;
#line 91 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_g_error_free0 (_data_->e);
#line 1271 "test-busy-handling.c"
	}
	__finally1:
#line 91 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 91 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 91 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_clear_error (&_data_->_inner_error_);
#line 91 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		return FALSE;
#line 1282 "test-busy-handling.c"
	}
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (_data_->_state_ == 0) {
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1288 "test-busy-handling.c"
	} else {
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1292 "test-busy-handling.c"
	}
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_object_unref (_data_->_async_result);
#line 90 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return FALSE;
#line 1298 "test-busy-handling.c"
}


static void test_app_check_shutdown (TestApp* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 104 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_if_fail (self != NULL);
#line 105 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = self->priv->users;
#line 105 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv->users = _tmp0_ - 1;
#line 106 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp1_ = self->priv->users;
#line 106 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (_tmp1_ == 0) {
#line 1315 "test-busy-handling.c"
		GMainLoop* _tmp2_ = NULL;
#line 107 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_print ("Async tests done, now I can quit the mainloop\n");
#line 108 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		_tmp2_ = self->priv->loop;
#line 108 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_main_loop_quit (_tmp2_);
#line 1323 "test-busy-handling.c"
	}
}


static void test_app_do_async_query_tests_data_free (gpointer _data) {
	TestAppDoAsyncQueryTestsData* _data_;
	_data_ = _data;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_test_app_unref0 (_data_->self);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_slice_free (TestAppDoAsyncQueryTestsData, _data_);
#line 1335 "test-busy-handling.c"
}


static void test_app_do_async_query_tests (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppDoAsyncQueryTestsData* _data_;
	TestApp* _tmp0_ = NULL;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = g_slice_new0 (TestAppDoAsyncQueryTestsData);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, test_app_do_async_query_tests);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_do_async_query_tests_data_free);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = _test_app_ref0 (self);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->self = _tmp0_;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_async_query_tests_co (_data_);
#line 1354 "test-busy-handling.c"
}


static void test_app_do_async_query_tests_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppDoAsyncQueryTestsData* _data_;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1362 "test-busy-handling.c"
}


static void test_app_do_async_query_tests_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppDoAsyncQueryTestsData* _data_;
#line 115 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = _user_data_;
#line 115 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_source_object_ = source_object;
#line 115 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_res_ = _res_;
#line 115 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_async_query_tests_co (_data_);
#line 1376 "test-busy-handling.c"
}


static gboolean test_app_do_async_query_tests_co (TestAppDoAsyncQueryTestsData* _data_) {
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	switch (_data_->_state_) {
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		case 0:
#line 1385 "test-busy-handling.c"
		goto _state_0;
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		case 1:
#line 1389 "test-busy-handling.c"
		goto _state_1;
		default:
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_assert_not_reached ();
#line 1394 "test-busy-handling.c"
	}
	_state_0:
#line 113 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_print ("Test 1: Just launch the query and let it wait\n" \
"Test 1: query launches immediately\n");
#line 114 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_tmp0_ = 0;
#line 114 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_tmp0_ = _data_->self->priv->users;
#line 114 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->self->priv->users = _data_->_tmp0_ + 1;
#line 115 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_state_ = 1;
#line 115 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_query_tests_async (_data_->self, "Test 1", test_app_do_async_query_tests_ready, _data_);
#line 115 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return FALSE;
#line 1411 "test-busy-handling.c"
	_state_1:
#line 115 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_query_tests_finish (_data_->self, _data_->_res_);
#line 117 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_check_shutdown (_data_->self);
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (_data_->_state_ == 0) {
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1421 "test-busy-handling.c"
	} else {
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1425 "test-busy-handling.c"
	}
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_object_unref (_data_->_async_result);
#line 112 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return FALSE;
#line 1431 "test-busy-handling.c"
}


static void test_app_jumper_async_data_free (gpointer _data) {
	TestAppJumperAsyncData* _data_;
	_data_ = _data;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_test_app_unref0 (_data_->self);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_slice_free (TestAppJumperAsyncData, _data_);
#line 1442 "test-busy-handling.c"
}


static void test_app_jumper_async (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppJumperAsyncData* _data_;
	TestApp* _tmp0_ = NULL;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = g_slice_new0 (TestAppJumperAsyncData);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, test_app_jumper_async);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_jumper_async_data_free);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = _test_app_ref0 (self);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->self = _tmp0_;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_jumper_async_co (_data_);
#line 1461 "test-busy-handling.c"
}


static void test_app_jumper_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppJumperAsyncData* _data_;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1469 "test-busy-handling.c"
}


static void test_app_jumper_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppJumperAsyncData* _data_;
#line 121 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_ = _user_data_;
#line 121 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_source_object_ = source_object;
#line 121 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_res_ = _res_;
#line 121 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_jumper_async_co (_data_);
#line 1483 "test-busy-handling.c"
}


static gboolean test_app_jumper_async_co (TestAppJumperAsyncData* _data_) {
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	switch (_data_->_state_) {
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		case 0:
#line 1492 "test-busy-handling.c"
		goto _state_0;
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		case 1:
#line 1496 "test-busy-handling.c"
		goto _state_1;
		default:
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_assert_not_reached ();
#line 1501 "test-busy-handling.c"
	}
	_state_0:
#line 121 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_data_->_state_ = 1;
#line 121 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_query_tests_async (_data_->self, "Test 2", test_app_jumper_async_ready, _data_);
#line 121 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return FALSE;
#line 1510 "test-busy-handling.c"
	_state_1:
#line 121 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_query_tests_finish (_data_->self, _data_->_res_);
#line 122 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_check_shutdown (_data_->self);
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (_data_->_state_ == 0) {
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1520 "test-busy-handling.c"
	} else {
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1524 "test-busy-handling.c"
	}
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_object_unref (_data_->_async_result);
#line 120 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return FALSE;
#line 1530 "test-busy-handling.c"
}


static gboolean test_app_test_ready (TestApp* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 125 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 127 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = self->priv->ready;
#line 127 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (_tmp0_) {
#line 128 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_print ("Test 2: query launches now\n");
#line 129 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		test_app_jumper_async (self, NULL, NULL);
#line 1548 "test-busy-handling.c"
	}
#line 132 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp1_ = self->priv->ready;
#line 132 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	result = !_tmp1_;
#line 132 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return result;
#line 1556 "test-busy-handling.c"
}


static gboolean _test_app_test_ready_gsource_func (gpointer self) {
	gboolean result;
	result = test_app_test_ready ((TestApp*) self);
#line 142 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return result;
#line 1565 "test-busy-handling.c"
}


static gboolean test_app_in_mainloop (TestApp* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 135 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 136 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_do_async_query_tests (self, NULL, NULL);
#line 138 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_print ("Test 2: Wait for the status signal to indicate readyness\n");
#line 139 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = self->priv->users;
#line 139 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv->users = _tmp0_ + 1;
#line 141 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp1_ = self->priv->ready;
#line 141 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (!_tmp1_) {
#line 142 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1, _test_app_test_ready_gsource_func, test_app_ref (self), test_app_unref);
#line 1589 "test-busy-handling.c"
	} else {
#line 144 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		test_app_test_ready (self);
#line 1593 "test-busy-handling.c"
	}
#line 147 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	result = FALSE;
#line 147 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return result;
#line 1599 "test-busy-handling.c"
}


static gboolean _test_app_in_mainloop_gsource_func (gpointer self) {
	gboolean result;
	result = test_app_in_mainloop ((TestApp*) self);
#line 153 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return result;
#line 1608 "test-busy-handling.c"
}


gint test_app_run (TestApp* self) {
	gint result = 0;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 150 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 151 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 151 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_g_main_loop_unref0 (self->priv->loop);
#line 151 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv->loop = _tmp0_;
#line 153 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _test_app_in_mainloop_gsource_func, test_app_ref (self), test_app_unref);
#line 155 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp1_ = self->priv->loop;
#line 155 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_main_loop_run (_tmp1_);
#line 157 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp2_ = self->priv->res;
#line 157 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	result = _tmp2_;
#line 157 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return result;
#line 1637 "test-busy-handling.c"
}


static void value_test_app_init (GValue* value) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	value->data[0].v_pointer = NULL;
#line 1644 "test-busy-handling.c"
}


static void value_test_app_free_value (GValue* value) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (value->data[0].v_pointer) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		test_app_unref (value->data[0].v_pointer);
#line 1653 "test-busy-handling.c"
	}
}


static void value_test_app_copy_value (const GValue* src_value, GValue* dest_value) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (src_value->data[0].v_pointer) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		dest_value->data[0].v_pointer = test_app_ref (src_value->data[0].v_pointer);
#line 1663 "test-busy-handling.c"
	} else {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1667 "test-busy-handling.c"
	}
}


static gpointer value_test_app_peek_pointer (const GValue* value) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return value->data[0].v_pointer;
#line 1675 "test-busy-handling.c"
}


static gchar* value_test_app_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (collect_values[0].v_pointer) {
#line 1682 "test-busy-handling.c"
		TestApp* object;
		object = collect_values[0].v_pointer;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		if (object->parent_instance.g_class == NULL) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1689 "test-busy-handling.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1693 "test-busy-handling.c"
		}
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		value->data[0].v_pointer = test_app_ref (object);
#line 1697 "test-busy-handling.c"
	} else {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		value->data[0].v_pointer = NULL;
#line 1701 "test-busy-handling.c"
	}
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return NULL;
#line 1705 "test-busy-handling.c"
}


static gchar* value_test_app_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestApp** object_p;
	object_p = collect_values[0].v_pointer;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (!object_p) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1716 "test-busy-handling.c"
	}
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (!value->data[0].v_pointer) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		*object_p = NULL;
#line 1722 "test-busy-handling.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		*object_p = value->data[0].v_pointer;
#line 1726 "test-busy-handling.c"
	} else {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		*object_p = test_app_ref (value->data[0].v_pointer);
#line 1730 "test-busy-handling.c"
	}
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return NULL;
#line 1734 "test-busy-handling.c"
}


GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestApp* spec;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_APP), NULL);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return G_PARAM_SPEC (spec);
#line 1748 "test-busy-handling.c"
}


gpointer value_get_test_app (const GValue* value) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP), NULL);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return value->data[0].v_pointer;
#line 1757 "test-busy-handling.c"
}


void value_set_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	old = value->data[0].v_pointer;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (v_object) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		value->data[0].v_pointer = v_object;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		test_app_ref (value->data[0].v_pointer);
#line 1777 "test-busy-handling.c"
	} else {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		value->data[0].v_pointer = NULL;
#line 1781 "test-busy-handling.c"
	}
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (old) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		test_app_unref (old);
#line 1787 "test-busy-handling.c"
	}
}


void value_take_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	old = value->data[0].v_pointer;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (v_object) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		value->data[0].v_pointer = v_object;
#line 1806 "test-busy-handling.c"
	} else {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		value->data[0].v_pointer = NULL;
#line 1810 "test-busy-handling.c"
	}
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (old) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		test_app_unref (old);
#line 1816 "test-busy-handling.c"
	}
}


static void test_app_class_init (TestAppClass * klass) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	test_app_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	((TestAppClass *) klass)->finalize = test_app_finalize;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_type_class_add_private (klass, sizeof (TestAppPrivate));
#line 1828 "test-busy-handling.c"
}


static void test_app_instance_init (TestApp * self) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv = TEST_APP_GET_PRIVATE (self);
#line 45 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv->res = -1;
#line 46 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv->users = 0;
#line 48 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv->initialized = FALSE;
#line 49 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->priv->ready = FALSE;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self->ref_count = 1;
#line 1845 "test-busy-handling.c"
}


static void test_app_finalize (TestApp* obj) {
	TestApp * self;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEST_APP, TestApp);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_signal_handlers_destroy (self);
#line 47 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_g_main_loop_unref0 (self->priv->loop);
#line 1857 "test-busy-handling.c"
}


GType test_app_get_type (void) {
	static volatile gsize test_app_type_id__volatile = 0;
	if (g_once_init_enter (&test_app_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_test_app_init, value_test_app_free_value, value_test_app_copy_value, value_test_app_peek_pointer, "p", value_test_app_collect_value, "p", value_test_app_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestApp), 0, (GInstanceInitFunc) test_app_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType test_app_type_id;
		test_app_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestApp", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&test_app_type_id__volatile, test_app_type_id);
	}
	return test_app_type_id__volatile;
}


gpointer test_app_ref (gpointer instance) {
	TestApp* self;
	self = instance;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	g_atomic_int_inc (&self->ref_count);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return instance;
#line 1882 "test-busy-handling.c"
}


void test_app_unref (gpointer instance) {
	TestApp* self;
	self = instance;
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		TEST_APP_GET_CLASS (self)->finalize (self);
#line 42 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1895 "test-busy-handling.c"
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	TestApp* app = NULL;
	TestApp* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 162 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp0_ = test_app_new ();
#line 162 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	app = _tmp0_;
#line 164 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_tmp1_ = test_app_run (app);
#line 164 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	result = _tmp1_;
#line 164 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	_test_app_unref0 (app);
#line 164 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return result;
#line 1917 "test-busy-handling.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 161 "/home/carlos/Source/gnome/tracker/tests/functional-tests/ipc/test-busy-handling.vala"
	return _vala_main (argv, argc);
#line 1927 "test-busy-handling.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



