/* tracker-backend.c generated by valac 0.11.1, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <gio/gio.h>
#include <string.h>
#include <dbus/dbus.h>
#include <stdlib.h>
#include <gmodule.h>


#define TRACKER_BACKEND_TYPE_STATUS (tracker_backend_status_get_type ())
#define TRACKER_BACKEND_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BACKEND_TYPE_STATUS, TrackerBackendStatus))
#define TRACKER_BACKEND_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BACKEND_TYPE_STATUS))
#define TRACKER_BACKEND_STATUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TRACKER_BACKEND_TYPE_STATUS, TrackerBackendStatusIface))

typedef struct _TrackerBackendStatus TrackerBackendStatus;
typedef struct _TrackerBackendStatusIface TrackerBackendStatusIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
typedef struct _TrackerBackendStatusDBusProxy TrackerBackendStatusDBusProxy;
typedef DBusGProxyClass TrackerBackendStatusDBusProxyClass;
typedef struct _TrackerBackendStatusDBusProxyWaitAsyncData TrackerBackendStatusDBusProxyWaitAsyncData;

#define TRACKER_SPARQL_TYPE_CONNECTION (tracker_sparql_connection_get_type ())
#define TRACKER_SPARQL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection))
#define TRACKER_SPARQL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))
#define TRACKER_SPARQL_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))

typedef struct _TrackerSparqlConnection TrackerSparqlConnection;
typedef struct _TrackerSparqlConnectionClass TrackerSparqlConnectionClass;
typedef struct _TrackerSparqlConnectionPrivate TrackerSparqlConnectionPrivate;

#define TRACKER_SPARQL_TYPE_CURSOR (tracker_sparql_cursor_get_type ())
#define TRACKER_SPARQL_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor))
#define TRACKER_SPARQL_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))
#define TRACKER_SPARQL_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))

typedef struct _TrackerSparqlCursor TrackerSparqlCursor;
typedef struct _TrackerSparqlCursorClass TrackerSparqlCursorClass;

#define TRACKER_SPARQL_TYPE_BACKEND (tracker_sparql_backend_get_type ())
#define TRACKER_SPARQL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend))
#define TRACKER_SPARQL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))
#define TRACKER_SPARQL_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))

typedef struct _TrackerSparqlBackend TrackerSparqlBackend;
typedef struct _TrackerSparqlBackendClass TrackerSparqlBackendClass;
typedef struct _TrackerSparqlBackendPrivate TrackerSparqlBackendPrivate;

#define TRACKER_SPARQL_BACKEND_TYPE_BACKEND (tracker_sparql_backend_backend_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
typedef struct _TrackerSparqlBackendInitAsyncData TrackerSparqlBackendInitAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerSparqlBackendQueryAsyncData TrackerSparqlBackendQueryAsyncData;
typedef struct _TrackerSparqlBackendUpdateAsyncData TrackerSparqlBackendUpdateAsyncData;
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlBackendUpdateArrayAsyncData TrackerSparqlBackendUpdateArrayAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateBlankAsyncData TrackerSparqlBackendUpdateBlankAsyncData;
typedef struct _TrackerSparqlBackendLoadAsyncData TrackerSparqlBackendLoadAsyncData;
typedef struct _TrackerSparqlBackendStatisticsAsyncData TrackerSparqlBackendStatisticsAsyncData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

struct _TrackerBackendStatusIface {
	GTypeInterface parent_iface;
	void (*wait) (TrackerBackendStatus* self, GError** error);
	void (*wait_async) (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*wait_finish) (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _TrackerBackendStatusDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TrackerBackendStatusDBusProxyWaitAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_CONSTRAINT,
	TRACKER_SPARQL_ERROR_NO_SPACE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
struct _TrackerSparqlConnection {
	GObject parent_instance;
	TrackerSparqlConnectionPrivate * priv;
};

struct _TrackerSparqlConnectionClass {
	GObjectClass parent_class;
	void (*init) (TrackerSparqlConnection* self, GError** error);
	void (*init_async) (TrackerSparqlConnection* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*init_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	TrackerSparqlCursor* (*query) (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
	void (*query_async) (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*query_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_async) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update_array_async) (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GPtrArray* (*update_array_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	GVariant* (*update_blank) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_blank_async) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*update_blank_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*load) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
	void (*load_async) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*load_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	TrackerSparqlCursor* (*statistics) (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
	void (*statistics_async) (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*statistics_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
};

struct _TrackerSparqlBackend {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlBackendPrivate * priv;
};

struct _TrackerSparqlBackendClass {
	TrackerSparqlConnectionClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_BACKEND_BACKEND_AUTO,
	TRACKER_SPARQL_BACKEND_BACKEND_DIRECT,
	TRACKER_SPARQL_BACKEND_BACKEND_BUS
} TrackerSparqlBackendBackend;

struct _TrackerSparqlBackendInitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	DBusGConnection* _tmp0_;
	DBusGConnection* connection;
	DBusGProxy* _tmp1_;
	TrackerBackendStatus* status;
	GError * e;
	GError* _tmp2_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GFile* file;
	GCancellable* cancellable;
	gchar* _tmp0_;
	gchar* uri;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	GError * _inner_error_;
};

typedef TrackerSparqlConnection* (*TrackerSparqlBackendModuleInitFunc) (void* user_data);

static gpointer tracker_sparql_backend_parent_class = NULL;
static gboolean tracker_sparql_backend_is_constructed;
static gboolean tracker_sparql_backend_is_constructed = FALSE;
static gboolean tracker_sparql_backend_is_initialized;
static gboolean tracker_sparql_backend_is_initialized = FALSE;
static TrackerSparqlConnection* tracker_sparql_backend_direct;
static TrackerSparqlConnection* tracker_sparql_backend_direct = NULL;
static TrackerSparqlConnection* tracker_sparql_backend_bus;
static TrackerSparqlConnection* tracker_sparql_backend_bus = NULL;

TrackerBackendStatus* tracker_backend_status_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType tracker_backend_status_get_type (void) G_GNUC_CONST;
void tracker_backend_status_wait (TrackerBackendStatus* self, GError** error);
void tracker_backend_status_wait_async (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_backend_status_wait_finish (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void tracker_backend_status_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _tracker_backend_status_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult tracker_backend_status_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_tracker_backend_status_introspect (TrackerBackendStatus* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_backend_status_property_get_all (TrackerBackendStatus* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_backend_status_wait (TrackerBackendStatus* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_backend_status_wait_async (TrackerBackendStatus* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_backend_status_wait_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType tracker_backend_status_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult tracker_backend_status_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	TRACKER_BACKEND_STATUS_DBUS_PROXY_DUMMY_PROPERTY
};
static void tracker_backend_status_dbus_proxy_wait (TrackerBackendStatus* self, GError** error);
static void tracker_backend_status_dbus_proxy_wait_async_async (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_backend_status_dbus_proxy_wait_async_ready (DBusPendingCall* pending, void* user_data);
static void tracker_backend_status_dbus_proxy_wait_async_finish (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error);
static void tracker_backend_status_dbus_proxy_tracker_backend_status__interface_init (TrackerBackendStatusIface* iface);
static void _vala_tracker_backend_status_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_backend_status_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_sparql_connection_get_type (void) G_GNUC_CONST;
GQuark tracker_sparql_error_quark (void);
GType tracker_sparql_cursor_get_type (void) G_GNUC_CONST;
GType tracker_sparql_backend_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_BACKEND_DUMMY_PROPERTY
};
static GType tracker_sparql_backend_backend_get_type (void) G_GNUC_UNUSED;
TrackerSparqlBackend* tracker_sparql_backend_new (gboolean direct_only, GError** error);
TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, gboolean direct_only, GError** error);
TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type);
static gboolean tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, gboolean direct_only, GError** error);
static void tracker_sparql_backend_real_init (TrackerSparqlConnection* base, GError** error);
#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
#define TRACKER_DBUS_OBJECT_STATUS "/org/freedesktop/Tracker1/Status"
#define TRACKER_DBUS_INTERFACE_STATUS TRACKER_DBUS_SERVICE ".Status"
#define TRACKER_DBUS_INTERFACE_RESOURCES TRACKER_DBUS_SERVICE ".Resources"
static void tracker_sparql_backend_real_init_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_init_async (TrackerSparqlConnection* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_backend_init_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_init_async_co (TrackerSparqlBackendInitAsyncData* data);
static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_query_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* data);
void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
void tracker_sparql_connection_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_update_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* data);
void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* data);
void tracker_sparql_connection_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GPtrArray* tracker_sparql_connection_update_array_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* data);
void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_load_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* data);
void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* data);
void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static TrackerSparqlConnection* tracker_sparql_backend_load_plugins_from_path (TrackerSparqlBackend* self, const gchar* path, gboolean required, GError** error);
static void tracker_sparql_backend_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _tracker_backend_status_dbus_path_vtable = {_tracker_backend_status_dbus_unregister, tracker_backend_status_dbus_message};
static const _DBusObjectVTable _tracker_backend_status_dbus_vtable = {tracker_backend_status_dbus_register_object};

void tracker_backend_status_real_wait (TrackerBackendStatus* self, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `tracker_backend_status_wait'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void tracker_backend_status_wait (TrackerBackendStatus* self, GError** error) {
	TRACKER_BACKEND_STATUS_GET_INTERFACE (self)->wait (self, error);
}


void tracker_backend_status_wait_async (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BACKEND_STATUS_GET_INTERFACE (self)->wait_async (self, _callback_, _user_data_);
}


void tracker_backend_status_wait_finish (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error) {
	TRACKER_BACKEND_STATUS_GET_INTERFACE (self)->wait_finish (self, _res_, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _tracker_backend_status_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_tracker_backend_status_introspect (TrackerBackendStatus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Status\">\n  <method name=\"Wait\">\n  </method>\n  <method name=\"Wait\">\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_backend_status_property_get_all (TrackerBackendStatus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Status") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_backend_status_wait (TrackerBackendStatus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	tracker_backend_status_wait (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_backend_status_wait_async (TrackerBackendStatus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_backend_status_wait_async (self, (GAsyncReadyCallback) _dbus_tracker_backend_status_wait_async_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_backend_status_wait_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	tracker_backend_status_wait_finish ((TrackerBackendStatus*) source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult tracker_backend_status_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_tracker_backend_status_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_tracker_backend_status_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Status", "Wait")) {
		result = _dbus_tracker_backend_status_wait (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Status", "Wait")) {
		result = _dbus_tracker_backend_status_wait_async (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void tracker_backend_status_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_tracker_backend_status_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void tracker_backend_status_base_init (TrackerBackendStatusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TRACKER_BACKEND_TYPE_STATUS, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_tracker_backend_status_dbus_vtable));
	}
}


GType tracker_backend_status_get_type (void) {
	static volatile gsize tracker_backend_status_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_backend_status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBackendStatusIface), (GBaseInitFunc) tracker_backend_status_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tracker_backend_status_type_id;
		tracker_backend_status_type_id = g_type_register_static (G_TYPE_INTERFACE, "TrackerBackendStatus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tracker_backend_status_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (tracker_backend_status_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &tracker_backend_status_dbus_proxy_get_type);
		g_once_init_leave (&tracker_backend_status_type_id__volatile, tracker_backend_status_type_id);
	}
	return tracker_backend_status_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TrackerBackendStatusDBusProxy, tracker_backend_status_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TRACKER_BACKEND_TYPE_STATUS, tracker_backend_status_dbus_proxy_tracker_backend_status__interface_init) );
TrackerBackendStatus* tracker_backend_status_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	TrackerBackendStatus* self;
	self = g_object_new (tracker_backend_status_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Status", NULL);
	return self;
}


static GObject* tracker_backend_status_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (tracker_backend_status_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), tracker_backend_status_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult tracker_backend_status_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void tracker_backend_status_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((TrackerBackendStatusDBusProxy*) self)->disposed) {
		return;
	}
	((TrackerBackendStatusDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), tracker_backend_status_dbus_proxy_filter, self);
	G_OBJECT_CLASS (tracker_backend_status_dbus_proxy_parent_class)->dispose (self);
}


static void tracker_backend_status_dbus_proxy_class_init (TrackerBackendStatusDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = tracker_backend_status_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = tracker_backend_status_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_backend_status_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_backend_status_dbus_proxy_set_property;
}


static void tracker_backend_status_dbus_proxy_init (TrackerBackendStatusDBusProxy* self) {
}


static void tracker_backend_status_dbus_proxy_wait (TrackerBackendStatus* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((TrackerBackendStatusDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Status", "Wait");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, 2147483647, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp0_;
			_edomain = DBUS_GERROR;
			_tmp0_ = _dbus_error.name + 27;
			if (strcmp (_tmp0_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp0_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp0_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp0_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp0_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp0_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp0_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp0_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp0_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp0_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp0_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp0_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp0_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp0_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp0_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp0_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp0_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp0_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp0_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp0_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp0_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp0_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp0_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp0_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp0_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp0_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp0_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp0_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp0_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp0_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp0_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp0_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp0_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_backend_status_dbus_proxy_wait_async_async (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	TrackerBackendStatusDBusProxyWaitAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Status", "Wait");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, 2147483647);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBackendStatusDBusProxyWaitAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_backend_status_dbus_proxy_wait_async_ready, _data_, NULL);
}


static void tracker_backend_status_dbus_proxy_wait_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBackendStatusDBusProxyWaitAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBackendStatusDBusProxyWaitAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static void tracker_backend_status_dbus_proxy_wait_async_finish (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error) {
	TrackerBackendStatusDBusProxyWaitAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp1_;
			_edomain = DBUS_GERROR;
			_tmp1_ = _dbus_error.name + 27;
			if (strcmp (_tmp1_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp1_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp1_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp1_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp1_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp1_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp1_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp1_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp1_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp1_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp1_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp1_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp1_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp1_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp1_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp1_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp1_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp1_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp1_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp1_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp1_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp1_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp1_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp1_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp1_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp1_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp1_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp1_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp1_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp1_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp1_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp1_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp1_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_backend_status_dbus_proxy_tracker_backend_status__interface_init (TrackerBackendStatusIface* iface) {
	iface->wait = tracker_backend_status_dbus_proxy_wait;
	iface->wait_async = tracker_backend_status_dbus_proxy_wait_async_async;
	iface->wait_finish = tracker_backend_status_dbus_proxy_wait_async_finish;
}


static void _vala_tracker_backend_status_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_tracker_backend_status_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static GType tracker_sparql_backend_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_backend_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BACKEND_BACKEND_AUTO, "TRACKER_SPARQL_BACKEND_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_BACKEND_BACKEND_DIRECT, "TRACKER_SPARQL_BACKEND_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_BACKEND_BACKEND_BUS, "TRACKER_SPARQL_BACKEND_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
		GType tracker_sparql_backend_backend_type_id;
		tracker_sparql_backend_backend_type_id = g_enum_register_static ("TrackerSparqlBackendBackend", values);
		g_once_init_leave (&tracker_sparql_backend_backend_type_id__volatile, tracker_sparql_backend_backend_type_id);
	}
	return tracker_sparql_backend_backend_type_id__volatile;
}


TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, gboolean direct_only, GError** error) {
	TrackerSparqlBackend * self = NULL;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_module_supported ();
	g_return_val_if_fail (_tmp0_, NULL);
	self = (TrackerSparqlBackend*) tracker_sparql_connection_construct (object_type);
	if (tracker_sparql_backend_is_constructed) {
		return self;
	}
	_tmp1_ = NULL;
	if (direct_only) {
		_tmp1_ = "true";
	} else {
		_tmp1_ = "false";
	}
	g_debug ("tracker-backend.vala:51: Constructing connection, direct_only=%s", _tmp1_);
	tracker_sparql_backend_load_plugins (self, direct_only, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		GError* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
		_inner_error_ = _tmp2_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	tracker_sparql_backend_is_constructed = TRUE;
	return self;
}


TrackerSparqlBackend* tracker_sparql_backend_new (gboolean direct_only, GError** error) {
	return tracker_sparql_backend_construct (TRACKER_SPARQL_TYPE_BACKEND, direct_only, error);
}


static void tracker_sparql_backend_real_init (TrackerSparqlConnection* base, GError** error) {
	TrackerSparqlBackend * self;
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* connection;
	DBusGProxy* _tmp1_ = NULL;
	TrackerBackendStatus* status;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (tracker_sparql_backend_is_constructed);
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	connection = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch1_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = dbus_g_proxy_new_for_name (connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATUS, TRACKER_DBUS_INTERFACE_STATUS);
	status = tracker_backend_status_dbus_proxy_new (connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATUS);
	g_debug ("tracker-backend.vala:69: Waiting for service to become available synch" \
"ronously...");
	tracker_backend_status_wait (status, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (status);
		_dbus_g_connection_unref0 (connection);
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch1_dbus_gerror;
		}
		_g_object_unref0 (status);
		_dbus_g_connection_unref0 (connection);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_debug ("tracker-backend.vala:71: Service is ready");
	_g_object_unref0 (status);
	_dbus_g_connection_unref0 (connection);
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * e;
		GError* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("tracker-backend.vala:73: Could not connect to D-Bus service:'%s': %s", TRACKER_DBUS_INTERFACE_RESOURCES, e->message);
		_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
		_inner_error_ = _tmp2_;
		_g_error_free0 (e);
		goto __finally1;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_backend_is_initialized = TRUE;
}


static void tracker_sparql_backend_real_init_async_data_free (gpointer _data) {
	TrackerSparqlBackendInitAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendInitAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_sparql_backend_real_init_async (TrackerSparqlConnection* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendInitAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendInitAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_init_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_init_async_data_free);
	_data_->self = _g_object_ref0 (self);
	tracker_sparql_backend_real_init_async_co (_data_);
}


static void tracker_sparql_backend_real_init_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendInitAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_backend_init_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendInitAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_init_async_co (data);
}


static gboolean tracker_sparql_backend_real_init_async_co (TrackerSparqlBackendInitAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (tracker_sparql_backend_is_constructed, FALSE);
	data->_tmp0_ = NULL;
	data->_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &data->_inner_error_);
	data->connection = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			goto __catch2_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = dbus_g_proxy_new_for_name (data->connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATUS, TRACKER_DBUS_INTERFACE_STATUS);
	data->status = tracker_backend_status_dbus_proxy_new (data->connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATUS);
	g_debug ("tracker-backend.vala:89: Waiting for service to become available async" \
"hronously...");
	data->_state_ = 1;
	tracker_backend_status_wait_async (data->status, tracker_sparql_backend_init_async_ready, data);
	return FALSE;
	_state_1:
	tracker_backend_status_wait_finish (data->status, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->status);
		_dbus_g_connection_unref0 (data->connection);
		if (data->_inner_error_->domain == DBUS_GERROR) {
			goto __catch2_dbus_gerror;
		}
		_g_object_unref0 (data->status);
		_dbus_g_connection_unref0 (data->connection);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_debug ("tracker-backend.vala:91: Service is ready");
	_g_object_unref0 (data->status);
	_dbus_g_connection_unref0 (data->connection);
	goto __finally2;
	__catch2_dbus_gerror:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("tracker-backend.vala:93: Could not connect to D-Bus service:'%s': %s", TRACKER_DBUS_INTERFACE_RESOURCES, data->e->message);
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
		data->_inner_error_ = data->_tmp2_;
		_g_error_free0 (data->e);
		goto __finally2;
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	tracker_sparql_backend_is_initialized = TRUE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_return_val_if_fail ((tracker_sparql_backend_bus != NULL) || (tracker_sparql_backend_direct != NULL), NULL);
	g_debug ("tracker-backend.vala:102: %s(): '%s'", "Tracker.Sparql.Backend.query", sparql);
	if (tracker_sparql_backend_direct != NULL) {
		TrackerSparqlCursor* _tmp0_ = NULL;
		TrackerSparqlCursor* _tmp1_;
		_tmp0_ = tracker_sparql_connection_query (tracker_sparql_backend_direct, sparql, cancellable, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp1_;
		return result;
	} else {
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlCursor* _tmp3_;
		_tmp2_ = tracker_sparql_connection_query (tracker_sparql_backend_bus, sparql, cancellable, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp3_;
		return result;
	}
}


static void tracker_sparql_backend_real_query_async_data_free (gpointer _data) {
	TrackerSparqlBackendQueryAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendQueryAsyncData, data);
}


static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendQueryAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendQueryAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_query_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_query_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_query_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendQueryAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendQueryAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_query_async_co (data);
}


static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail ((tracker_sparql_backend_bus != NULL) || (tracker_sparql_backend_direct != NULL), FALSE);
	g_debug ("tracker-backend.vala:112: %s(): '%s'", "Tracker.Sparql.Backend.query_async", data->sparql);
	if (tracker_sparql_backend_direct != NULL) {
		data->_state_ = 1;
		tracker_sparql_connection_query_async (tracker_sparql_backend_direct, data->sparql, data->cancellable, tracker_sparql_backend_query_async_ready, data);
		return FALSE;
		_state_1:
		data->_tmp0_ = NULL;
		data->_tmp0_ = tracker_sparql_connection_query_finish (tracker_sparql_backend_direct, data->_res_, &data->_inner_error_);
		data->_tmp1_ = data->_tmp0_;
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp1_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_state_ = 2;
		tracker_sparql_connection_query_async (tracker_sparql_backend_bus, data->sparql, data->cancellable, tracker_sparql_backend_query_async_ready, data);
		return FALSE;
		_state_2:
		data->_tmp2_ = NULL;
		data->_tmp2_ = tracker_sparql_connection_query_finish (tracker_sparql_backend_bus, data->_res_, &data->_inner_error_);
		data->_tmp3_ = data->_tmp2_;
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp3_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (sparql != NULL);
	g_return_if_fail (tracker_sparql_backend_bus != NULL);
	g_debug ("tracker-backend.vala:122: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update", priority, sparql);
	tracker_sparql_connection_update (tracker_sparql_backend_bus, sparql, priority, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GVariant* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_return_val_if_fail (tracker_sparql_backend_bus != NULL, NULL);
	g_debug ("tracker-backend.vala:128: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank", priority, sparql);
	_tmp0_ = tracker_sparql_connection_update_blank (tracker_sparql_backend_bus, sparql, priority, cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_backend_real_update_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateAsyncData, data);
}


static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_async_co (_data_);
}


static void tracker_sparql_backend_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (tracker_sparql_backend_bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:134: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_async", data->priority, data->sparql);
	data->_state_ = 1;
	tracker_sparql_connection_update_async (tracker_sparql_backend_bus, data->sparql, data->priority, data->cancellable, tracker_sparql_backend_update_async_ready, data);
	return FALSE;
	_state_1:
	tracker_sparql_connection_update_finish (tracker_sparql_backend_bus, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateArrayAsyncData* data;
	data = _data;
	data->sparql = (_vala_array_free (data->sparql, data->sparql_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->cancellable);
	_g_ptr_array_free0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateArrayAsyncData, data);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	gchar** _tmp0_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateArrayAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_array_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_array_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = (_tmp0_ = sparql, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup2 (_tmp0_, sparql_length1));
	_data_->sparql_length1 = sparql_length1;
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_array_async_co (_data_);
}


static GPtrArray* tracker_sparql_backend_real_update_array_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateArrayAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_array_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (tracker_sparql_backend_bus != NULL, FALSE);
	data->_state_ = 1;
	tracker_sparql_connection_update_array_async (tracker_sparql_backend_bus, data->sparql, data->sparql_length1, data->priority, data->cancellable, tracker_sparql_backend_update_array_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_update_array_finish (tracker_sparql_backend_bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateBlankAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateBlankAsyncData, data);
}


static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateBlankAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_blank_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_blank_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_blank_async_co (_data_);
}


static GVariant* tracker_sparql_backend_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateBlankAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_blank_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (tracker_sparql_backend_bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:145: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank_async", data->priority, data->sparql);
	data->_state_ = 1;
	tracker_sparql_connection_update_blank_async (tracker_sparql_backend_bus, data->sparql, data->priority, data->cancellable, tracker_sparql_backend_update_blank_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_update_blank_finish (tracker_sparql_backend_bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gchar* _tmp0_ = NULL;
	gchar* uri;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (tracker_sparql_backend_bus != NULL);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	g_debug ("tracker-backend.vala:152: %s(): '%s'", "Tracker.Sparql.Backend.load", uri);
	tracker_sparql_connection_load (tracker_sparql_backend_bus, file, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (uri);
			return;
		} else {
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (uri);
}


static void tracker_sparql_backend_real_load_async_data_free (gpointer _data) {
	TrackerSparqlBackendLoadAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendLoadAsyncData, data);
}


static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendLoadAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_load_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_load_async_co (_data_);
}


static void tracker_sparql_backend_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendLoadAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendLoadAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_load_async_co (data);
}


static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (tracker_sparql_backend_bus != NULL, FALSE);
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_get_uri (data->file);
	data->uri = data->_tmp0_;
	g_debug ("tracker-backend.vala:159: %s(): '%s'", "Tracker.Sparql.Backend.load_async", data->uri);
	data->_state_ = 1;
	tracker_sparql_connection_load_async (tracker_sparql_backend_bus, data->file, data->cancellable, tracker_sparql_backend_load_async_ready, data);
	return FALSE;
	_state_1:
	tracker_sparql_connection_load_finish (tracker_sparql_backend_bus, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->uri);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_free0 (data->uri);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	TrackerSparqlCursor* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (tracker_sparql_backend_bus != NULL, NULL);
	g_debug ("tracker-backend.vala:165: %s()", "Tracker.Sparql.Backend.statistics");
	_tmp0_ = tracker_sparql_connection_statistics (tracker_sparql_backend_bus, cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlBackendStatisticsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendStatisticsAsyncData, data);
}


static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendStatisticsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_statistics_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_statistics_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_statistics_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendStatisticsAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_statistics_async_co (data);
}


static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (tracker_sparql_backend_bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:171: %s()", "Tracker.Sparql.Backend.statistics_async");
	data->_state_ = 1;
	tracker_sparql_connection_statistics_async (tracker_sparql_backend_bus, data->cancellable, tracker_sparql_backend_statistics_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_statistics_finish (tracker_sparql_backend_bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, gboolean direct_only, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* env_path;
	gchar* path;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp8_ = NULL;
	GFile* dir;
	gchar* _tmp9_ = NULL;
	gchar* dir_path;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* env_backend;
	TrackerSparqlBackendBackend backend;
	gboolean _tmp15_ = FALSE;
	TrackerSparqlConnection* connection;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_getenv ("TRACKER_SPARQL_MODULE_PATH");
	_tmp1_ = g_strdup (_tmp0_);
	env_path = _tmp1_;
	path = NULL;
	if (env_path != NULL) {
		glong _tmp3_;
		_tmp3_ = strlen (env_path);
		_tmp2_ = _tmp3_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup (env_path);
		_tmp5_ = _tmp4_;
		_g_free0 (path);
		path = _tmp5_;
	} else {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup (SPARQL_MODULES_DIR);
		_tmp7_ = _tmp6_;
		_g_free0 (path);
		path = _tmp7_;
	}
	_tmp8_ = g_file_new_for_path (path);
	dir = _tmp8_;
	_tmp9_ = g_file_get_path (dir);
	dir_path = _tmp9_;
	_tmp10_ = g_getenv ("TRACKER_SPARQL_BACKEND");
	_tmp11_ = g_strdup (_tmp10_);
	env_backend = _tmp11_;
	backend = TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
	if (env_backend != NULL) {
		gint _tmp12_;
		_tmp12_ = g_ascii_strcasecmp (env_backend, "direct");
		if (_tmp12_ == 0) {
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
			g_debug ("tracker-backend.vala:195: Using backend = 'DIRECT'");
		} else {
			gint _tmp13_;
			_tmp13_ = g_ascii_strcasecmp (env_backend, "bus");
			if (_tmp13_ == 0) {
				backend = TRACKER_SPARQL_BACKEND_BACKEND_BUS;
				g_debug ("tracker-backend.vala:198: Using backend = 'BUS'");
			} else {
				g_warning ("tracker-backend.vala:200: Environment variable TRACKER_SPARQL_BACKEND " \
"set to unknown value '%s'", env_backend);
			}
		}
	}
	if (backend == TRACKER_SPARQL_BACKEND_BACKEND_AUTO) {
		gboolean _tmp14_ = FALSE;
		if (direct_only) {
			_tmp14_ = backend == TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
			g_debug ("tracker-backend.vala:207: Using backend = 'DIRECT'");
		} else {
			g_debug ("tracker-backend.vala:209: Using backend = 'AUTO'");
		}
	}
	if (direct_only) {
		_tmp15_ = backend == TRACKER_SPARQL_BACKEND_BACKEND_BUS;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		g_debug ("tracker-backend.vala:214: Backend set in environment contradicts reque" \
"sted connection type, using environment to override");
	}
	g_debug ("tracker-backend.vala:217: Searching for modules in folder '%s' ..", dir_path);
	connection = NULL;
	switch (backend) {
		case TRACKER_SPARQL_BACKEND_BACKEND_AUTO:
		{
			gchar* _tmp16_ = NULL;
			gchar* direct_path;
			TrackerSparqlConnection* _tmp17_ = NULL;
			TrackerSparqlConnection* _tmp18_;
			TrackerSparqlConnection* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* bus_path;
			TrackerSparqlConnection* _tmp21_ = NULL;
			TrackerSparqlConnection* _tmp22_;
			TrackerSparqlConnection* _tmp23_;
			TrackerSparqlConnection* _tmp24_;
			TrackerSparqlConnection* _tmp25_;
			_tmp16_ = g_module_build_path (dir_path, "tracker-direct");
			direct_path = _tmp16_;
			_tmp17_ = tracker_sparql_backend_load_plugins_from_path (self, direct_path, FALSE, &_inner_error_);
			_tmp18_ = _tmp17_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			_tmp19_ = _tmp18_;
			_g_object_unref0 (tracker_sparql_backend_direct);
			tracker_sparql_backend_direct = _tmp19_;
			_tmp20_ = g_module_build_path (dir_path, "tracker-bus");
			bus_path = _tmp20_;
			_tmp21_ = tracker_sparql_backend_load_plugins_from_path (self, bus_path, TRUE, &_inner_error_);
			_tmp22_ = _tmp21_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (bus_path);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			_tmp23_ = _tmp22_;
			_g_object_unref0 (tracker_sparql_backend_bus);
			tracker_sparql_backend_bus = _tmp23_;
			_tmp24_ = _g_object_ref0 (tracker_sparql_backend_bus);
			_tmp25_ = _tmp24_;
			_g_object_unref0 (connection);
			connection = _tmp25_;
			_g_free0 (bus_path);
			_g_free0 (direct_path);
			break;
		}
		case TRACKER_SPARQL_BACKEND_BACKEND_DIRECT:
		{
			gchar* _tmp26_ = NULL;
			gchar* direct_path;
			TrackerSparqlConnection* _tmp27_ = NULL;
			TrackerSparqlConnection* _tmp28_;
			TrackerSparqlConnection* _tmp29_;
			TrackerSparqlConnection* _tmp30_;
			TrackerSparqlConnection* _tmp31_;
			_tmp26_ = g_module_build_path (dir_path, "tracker-direct");
			direct_path = _tmp26_;
			_tmp27_ = tracker_sparql_backend_load_plugins_from_path (self, direct_path, TRUE, &_inner_error_);
			_tmp28_ = _tmp27_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			_tmp29_ = _tmp28_;
			_g_object_unref0 (tracker_sparql_backend_direct);
			tracker_sparql_backend_direct = _tmp29_;
			_tmp30_ = _g_object_ref0 (tracker_sparql_backend_direct);
			_tmp31_ = _tmp30_;
			_g_object_unref0 (connection);
			connection = _tmp31_;
			_g_free0 (direct_path);
			break;
		}
		case TRACKER_SPARQL_BACKEND_BACKEND_BUS:
		{
			gchar* _tmp32_ = NULL;
			gchar* bus_path;
			TrackerSparqlConnection* _tmp33_ = NULL;
			TrackerSparqlConnection* _tmp34_;
			TrackerSparqlConnection* _tmp35_;
			TrackerSparqlConnection* _tmp36_;
			TrackerSparqlConnection* _tmp37_;
			_tmp32_ = g_module_build_path (dir_path, "tracker-bus");
			bus_path = _tmp32_;
			_tmp33_ = tracker_sparql_backend_load_plugins_from_path (self, bus_path, TRUE, &_inner_error_);
			_tmp34_ = _tmp33_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (bus_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			_tmp35_ = _tmp34_;
			_g_object_unref0 (tracker_sparql_backend_bus);
			tracker_sparql_backend_bus = _tmp35_;
			_tmp36_ = _g_object_ref0 (tracker_sparql_backend_bus);
			_tmp37_ = _tmp36_;
			_g_object_unref0 (connection);
			connection = _tmp37_;
			_g_free0 (bus_path);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	g_debug ("tracker-backend.vala:246: Finished searching for modules");
	result = connection != NULL;
	_g_object_unref0 (connection);
	_g_free0 (env_backend);
	_g_free0 (dir_path);
	_g_object_unref0 (dir);
	_g_free0 (path);
	_g_free0 (env_path);
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static TrackerSparqlConnection* tracker_sparql_backend_load_plugins_from_path (TrackerSparqlBackend* self, const gchar* path, gboolean required, GError** error) {
	TrackerSparqlConnection* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* file;
	GFileInfo* info;
	gchar* _tmp1_;
	gchar* attributes;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* content_type;
	gchar* _tmp7_ = NULL;
	gchar* mime;
	gchar* _tmp8_;
	gchar* expected_mime;
	GModule* _tmp10_ = NULL;
	GModule* module;
	void* function = NULL;
	void* _tmp13_ = NULL;
	gboolean _tmp14_;
	TrackerSparqlBackendModuleInitFunc _tmp17_;
	void* module_init_target = NULL;
	GDestroyNotify module_init_target_destroy_notify = NULL;
	TrackerSparqlBackendModuleInitFunc _tmp18_;
	TrackerSparqlBackendModuleInitFunc module_init;
	TrackerSparqlConnection* _tmp19_ = NULL;
	TrackerSparqlConnection* c;
	const gchar* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_file_new_for_path (path);
	file = _tmp0_;
	g_assert (file != NULL);
	info = NULL;
	_tmp1_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	attributes = _tmp1_;
	_tmp2_ = g_file_query_info (file, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_free0 (attributes);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		goto __catch3_g_error;
	}
	_tmp4_ = _tmp3_;
	_g_object_unref0 (info);
	info = _tmp4_;
	_tmp5_ = g_file_info_get_content_type (info);
	_tmp6_ = g_strdup (_tmp5_);
	content_type = _tmp6_;
	_tmp7_ = g_content_type_get_mime_type (content_type);
	mime = _tmp7_;
	_tmp8_ = g_strdup ("application/x-sharedlib");
	expected_mime = _tmp8_;
	if (g_strcmp0 (mime, expected_mime) != 0) {
		GError* _tmp9_ = NULL;
		_tmp9_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not load plugin, mime type was '%s', expected:'%s'", mime, expected_mime);
		_inner_error_ = _tmp9_;
		_g_free0 (expected_mime);
		_g_free0 (mime);
		_g_free0 (content_type);
		_g_free0 (attributes);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		goto __catch3_g_error;
	}
	_tmp10_ = g_module_open (path, G_MODULE_BIND_LOCAL | G_MODULE_BIND_LAZY);
	module = _tmp10_;
	if (module == NULL) {
		const gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		_tmp11_ = g_module_error ();
		_tmp12_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to load module from path '%s': %s", path, _tmp11_);
		_inner_error_ = _tmp12_;
		_g_module_close0 (module);
		_g_free0 (expected_mime);
		_g_free0 (mime);
		_g_free0 (content_type);
		_g_free0 (attributes);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		goto __catch3_g_error;
	}
	_tmp14_ = g_module_symbol (module, "module_init", &_tmp13_);
	function = _tmp13_;
	if (!_tmp14_) {
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		_tmp15_ = g_module_error ();
		_tmp16_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to find entry point function '%s' in '%s': %s", "module_init", path, _tmp15_);
		_inner_error_ = _tmp16_;
		_g_module_close0 (module);
		_g_free0 (expected_mime);
		_g_free0 (mime);
		_g_free0 (content_type);
		_g_free0 (attributes);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		goto __catch3_g_error;
	}
	_tmp17_ = (TrackerSparqlBackendModuleInitFunc) function;
	_tmp18_ = _tmp17_;
	module_init_target = NULL;
	module_init_target_destroy_notify = NULL;
	module_init = _tmp18_;
	g_assert (module_init != NULL);
	g_module_make_resident (module);
	_tmp19_ = module_init (module_init_target);
	c = _tmp19_;
	_tmp20_ = g_module_name (module);
	g_debug ("tracker-backend.vala:303: Loaded module source: '%s'", _tmp20_);
	result = c;
	(module_init_target_destroy_notify == NULL) ? NULL : (module_init_target_destroy_notify (module_init_target), NULL);
	module_init = NULL;
	module_init_target = NULL;
	module_init_target_destroy_notify = NULL;
	_g_module_close0 (module);
	_g_free0 (expected_mime);
	_g_free0 (mime);
	_g_free0 (content_type);
	_g_free0 (attributes);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	return result;
	_g_object_unref0 (c);
	(module_init_target_destroy_notify == NULL) ? NULL : (module_init_target_destroy_notify (module_init_target), NULL);
	module_init = NULL;
	module_init_target = NULL;
	module_init_target_destroy_notify = NULL;
	_g_module_close0 (module);
	_g_free0 (expected_mime);
	_g_free0 (mime);
	_g_free0 (content_type);
	_g_free0 (attributes);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (required) {
			GError* _tmp21_;
			_tmp21_ = _g_error_copy0 (e);
			_inner_error_ = _tmp21_;
			_g_error_free0 (e);
			goto __finally3;
		} else {
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		_g_error_free0 (e);
	}
	__finally3:
	g_propagate_error (error, _inner_error_);
	return NULL;
}


static void tracker_sparql_backend_class_init (TrackerSparqlBackendClass * klass) {
	tracker_sparql_backend_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->init = tracker_sparql_backend_real_init;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->init_async = tracker_sparql_backend_real_init_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->init_finish = tracker_sparql_backend_real_init_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_sparql_backend_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_sparql_backend_real_query_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_sparql_backend_real_query_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_sparql_backend_real_update;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_sparql_backend_real_update_blank;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_sparql_backend_real_update_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_sparql_backend_real_update_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_async = tracker_sparql_backend_real_update_array_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_finish = tracker_sparql_backend_real_update_array_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_sparql_backend_real_update_blank_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_sparql_backend_real_update_blank_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_sparql_backend_real_load;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_sparql_backend_real_load_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_sparql_backend_real_load_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_sparql_backend_real_statistics;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_sparql_backend_real_statistics_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_sparql_backend_real_statistics_finish;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_backend_finalize;
}


static void tracker_sparql_backend_instance_init (TrackerSparqlBackend * self) {
}


static void tracker_sparql_backend_finalize (GObject* obj) {
	TrackerSparqlBackend * self;
	self = TRACKER_SPARQL_BACKEND (obj);
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->finalize (obj);
}


GType tracker_sparql_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBackend), 0, (GInstanceInitFunc) tracker_sparql_backend_instance_init, NULL };
		GType tracker_sparql_backend_type_id;
		tracker_sparql_backend_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlBackend", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_backend_type_id__volatile, tracker_sparql_backend_type_id);
	}
	return tracker_sparql_backend_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



