/* tracker-sparql-pattern.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from tracker-sparql-pattern.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-data/tracker-db-manager.h>
#include <libtracker-data/tracker-ontologies.h>
#include <libtracker-data/tracker-property.h>
#include <tracker-sparql.h>


#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlPredicateVariablePrivate TrackerSparqlPredicateVariablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;

#define TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT (tracker_sparql_pattern_triple_context_get_type ())
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))

typedef struct _TrackerSparqlPatternTripleContext TrackerSparqlPatternTripleContext;
typedef struct _TrackerSparqlPatternTripleContextClass TrackerSparqlPatternTripleContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlPatternTripleContextPrivate TrackerSparqlPatternTripleContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _TrackerSparqlPredicateVariable {
	GObject parent_instance;
	TrackerSparqlPredicateVariablePrivate * priv;
	char* subject;
	char* object;
	gboolean return_graph;
	TrackerClass* domain;
};

struct _TrackerSparqlPredicateVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	char* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	char* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPatternPrivate {
	TrackerSparqlQuery* query;
	TrackerSparqlExpression* expression;
	gint counter;
	gint next_table_index;
	char* current_graph;
	gboolean current_graph_is_var;
	char* current_subject;
	gboolean current_subject_is_var;
	char* current_predicate;
	gboolean current_predicate_is_var;
	TrackerSparqlPatternTripleContext* triple_context;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	char** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlPatternTripleContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlPatternTripleContextPrivate * priv;
	GList* tables;
	GHashTable* table_map;
	GList* bindings;
	GList* variables;
	GHashTable* var_bindings;
};

struct _TrackerSparqlPatternTripleContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	char* sql_db_tablename;
	char* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};


static gpointer tracker_sparql_predicate_variable_parent_class = NULL;
static gpointer tracker_sparql_pattern_triple_context_parent_class = NULL;
static gpointer tracker_sparql_pattern_parent_class = NULL;

GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_PREDICATE_VARIABLE_DUMMY_PROPERTY
};
void tracker_sparql_expression_append_expression_as_string (GString* sql, const char* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const char* msg);
char* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (void);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type);
static void tracker_sparql_predicate_variable_finalize (GObject* obj);
static GType tracker_sparql_pattern_triple_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_SPARQL_PATTERN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternPrivate))
enum  {
	TRACKER_SPARQL_PATTERN_DUMMY_PROPERTY
};
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const char* msg);
static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const char* msg);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location);
char* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static char* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value);
static void _g_list_free_g_object_unref (GList* self);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const char* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const char* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
static void _vala_array_add3 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value);
static void _vala_array_add4 (char*** array, int* length, int* size, char* value);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
static void _vala_array_add5 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value);
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
char* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const char* prefix, const char* local_name, GError** error);
char* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const char* user_bnodeid);
char* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
char* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error);
static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
const char* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error);
static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error);
static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const char* name);
static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self);
guint tracker_sparql_variable_hash (void* variable);
static guint _tracker_sparql_variable_hash_ghash_func (void* key);
gboolean tracker_sparql_variable_equal (void* a, void* b);
static gboolean _tracker_sparql_variable_equal_gequal_func (void* a, void* b);
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
static void _vala_array_add6 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value);
static void _vala_array_add7 (glong** array, int* length, int* size, glong value);
static void _vala_array_add8 (TrackerSparqlContext*** array, int* length, int* size, TrackerSparqlContext* value);
static void _vala_array_add9 (TrackerSparqlVariable*** array, int* length, int* size, TrackerSparqlVariable* value);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const char* value);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable);
char* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const char* suffix);
char* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const char* suffix);
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const char* subject, const char* db_table, gboolean share_table, gboolean* newtable);
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
enum  {
	TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_DUMMY_PROPERTY
};
static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext* obj);
static void tracker_sparql_pattern_finalize (GObject* obj);
static void tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


char* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_inner_error_ = NULL;
	{
		GString* sql;
		sql = g_string_new ("");
		if (self->subject != NULL) {
			gint subject_id;
			TrackerDBResultSet* result_set;
			subject_id = tracker_data_query_resource_id (self->subject);
			result_set = NULL;
			if (subject_id > 0) {
				TrackerDBInterface* iface;
				TrackerDBStatement* stmt;
				TrackerDBResultSet* _tmp0_;
				TrackerDBResultSet* _tmp1_;
				iface = _g_object_ref0 (tracker_db_manager_get_db_interface ());
				stmt = tracker_db_interface_create_statement (iface, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
				if (_inner_error_ != NULL) {
					_g_object_unref0 (iface);
					_g_object_unref0 (result_set);
					_g_string_free0 (sql);
					if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
						goto __catch0_tracker_db_interface_error;
					}
					_g_object_unref0 (iface);
					_g_object_unref0 (result_set);
					_g_string_free0 (sql);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				tracker_db_statement_bind_int (stmt, 0, subject_id);
				_tmp0_ = tracker_db_statement_execute (stmt, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (stmt);
					_g_object_unref0 (iface);
					_g_object_unref0 (result_set);
					_g_string_free0 (sql);
					if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
						goto __catch0_tracker_db_interface_error;
					}
					_g_object_unref0 (stmt);
					_g_object_unref0 (iface);
					_g_object_unref0 (result_set);
					_g_string_free0 (sql);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				result_set = (_tmp1_ = _tmp0_, _g_object_unref0 (result_set), _tmp1_);
				_g_object_unref0 (stmt);
				_g_object_unref0 (iface);
			}
			if (result_set != NULL) {
				gboolean first;
				first = TRUE;
				{
					gboolean _tmp2_;
					_tmp2_ = TRUE;
					while (TRUE) {
						GValue value = {0};
						GValue _tmp3_ = {0};
						GValue _tmp4_;
						TrackerClass* domain;
						if (!_tmp2_) {
							if (!tracker_db_result_set_iter_next (result_set)) {
								break;
							}
						}
						_tmp2_ = FALSE;
						_tracker_db_result_set_get_value (result_set, (guint) 0, &_tmp3_);
						value = (_tmp4_ = _tmp3_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp4_);
						domain = _g_object_ref0 (tracker_ontologies_get_class_by_uri (g_value_get_string (&value)));
						{
							gint _tmp5_;
							TrackerProperty** prop_collection;
							int prop_collection_length1;
							int prop_it;
							prop_collection = tracker_ontologies_get_properties (&_tmp5_);
							prop_collection_length1 = _tmp5_;
							for (prop_it = 0; prop_it < _tmp5_; prop_it = prop_it + 1) {
								TrackerProperty* prop;
								prop = _g_object_ref0 (prop_collection[prop_it]);
								{
									if (tracker_property_get_domain (prop) == domain) {
										char* _tmp6_;
										TrackerSparqlLiteralBinding* binding;
										char* _tmp7_;
										if (first) {
											first = FALSE;
										} else {
											g_string_append (sql, " UNION ALL ");
										}
										g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", tracker_property_get_uri (prop));
										tracker_sparql_expression_append_expression_as_string (sql, _tmp6_ = g_strdup_printf ("\"%s\"", tracker_property_get_name (prop)), tracker_property_get_data_type (prop));
										_g_free0 (_tmp6_);
										g_string_append (sql, " AS \"object\"");
										if (self->return_graph) {
											g_string_append_printf (sql, ", \"%s:graph\" AS \"graph\"", tracker_property_get_name (prop));
										}
										g_string_append_printf (sql, " FROM \"%s\"", tracker_property_get_table_name (prop));
										g_string_append (sql, " WHERE ID = ?");
										binding = tracker_sparql_literal_binding_new ();
										binding->literal = (_tmp7_ = g_strdup_printf ("%i", subject_id), _g_free0 (binding->literal), _tmp7_);
										((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
										query->bindings = g_list_append (query->bindings, _g_object_ref0 (binding));
										_g_object_unref0 (binding);
									}
									_g_object_unref0 (prop);
								}
							}
						}
						_g_object_unref0 (domain);
						G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
					}
				}
			} else {
				g_string_append (sql, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
			}
			_g_object_unref0 (result_set);
		} else {
			if (self->object != NULL) {
				gint object_id;
				TrackerDBInterface* iface;
				TrackerDBStatement* stmt;
				TrackerDBResultSet* result_set;
				gboolean first;
				object_id = tracker_data_query_resource_id (self->object);
				iface = _g_object_ref0 (tracker_db_manager_get_db_interface ());
				stmt = tracker_db_interface_create_statement (iface, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
				if (_inner_error_ != NULL) {
					_g_object_unref0 (iface);
					_g_string_free0 (sql);
					if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
						goto __catch0_tracker_db_interface_error;
					}
					_g_object_unref0 (iface);
					_g_string_free0 (sql);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				tracker_db_statement_bind_int (stmt, 0, object_id);
				result_set = tracker_db_statement_execute (stmt, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (stmt);
					_g_object_unref0 (iface);
					_g_string_free0 (sql);
					if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
						goto __catch0_tracker_db_interface_error;
					}
					_g_object_unref0 (stmt);
					_g_object_unref0 (iface);
					_g_string_free0 (sql);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				first = TRUE;
				if (result_set != NULL) {
					{
						gboolean _tmp8_;
						_tmp8_ = TRUE;
						while (TRUE) {
							GValue value = {0};
							GValue _tmp9_ = {0};
							GValue _tmp10_;
							TrackerClass* range;
							if (!_tmp8_) {
								if (!tracker_db_result_set_iter_next (result_set)) {
									break;
								}
							}
							_tmp8_ = FALSE;
							_tracker_db_result_set_get_value (result_set, (guint) 0, &_tmp9_);
							value = (_tmp10_ = _tmp9_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp10_);
							range = _g_object_ref0 (tracker_ontologies_get_class_by_uri (g_value_get_string (&value)));
							{
								gint _tmp11_;
								TrackerProperty** prop_collection;
								int prop_collection_length1;
								int prop_it;
								prop_collection = tracker_ontologies_get_properties (&_tmp11_);
								prop_collection_length1 = _tmp11_;
								for (prop_it = 0; prop_it < _tmp11_; prop_it = prop_it + 1) {
									TrackerProperty* prop;
									prop = _g_object_ref0 (prop_collection[prop_it]);
									{
										if (tracker_property_get_range (prop) == range) {
											char* _tmp12_;
											if (first) {
												first = FALSE;
											} else {
												g_string_append (sql, " UNION ALL ");
											}
											g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", tracker_property_get_uri (prop));
											tracker_sparql_expression_append_expression_as_string (sql, _tmp12_ = g_strdup_printf ("\"%s\"", tracker_property_get_name (prop)), tracker_property_get_data_type (prop));
											_g_free0 (_tmp12_);
											g_string_append (sql, " AS \"object\"");
											if (self->return_graph) {
												g_string_append_printf (sql, ", \"%s:graph\" AS \"graph\"", tracker_property_get_name (prop));
											}
											g_string_append_printf (sql, " FROM \"%s\"", tracker_property_get_table_name (prop));
										}
										_g_object_unref0 (prop);
									}
								}
							}
							_g_object_unref0 (range);
							G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
						}
					}
				} else {
					g_string_append (sql, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
				}
				_g_object_unref0 (result_set);
				_g_object_unref0 (stmt);
				_g_object_unref0 (iface);
			} else {
				if (self->domain != NULL) {
					gboolean first;
					first = TRUE;
					{
						gint _tmp13_;
						TrackerProperty** prop_collection;
						int prop_collection_length1;
						int prop_it;
						prop_collection = tracker_ontologies_get_properties (&_tmp13_);
						prop_collection_length1 = _tmp13_;
						for (prop_it = 0; prop_it < _tmp13_; prop_it = prop_it + 1) {
							TrackerProperty* prop;
							prop = _g_object_ref0 (prop_collection[prop_it]);
							{
								if (tracker_property_get_domain (prop) == self->domain) {
									char* _tmp14_;
									if (first) {
										first = FALSE;
									} else {
										g_string_append (sql, " UNION ALL ");
									}
									g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", tracker_property_get_uri (prop));
									tracker_sparql_expression_append_expression_as_string (sql, _tmp14_ = g_strdup_printf ("\"%s\"", tracker_property_get_name (prop)), tracker_property_get_data_type (prop));
									_g_free0 (_tmp14_);
									g_string_append (sql, " AS \"object\"");
									if (self->return_graph) {
										g_string_append_printf (sql, ", \"%s:graph\" AS \"graph\"", tracker_property_get_name (prop));
									}
									g_string_append_printf (sql, " FROM \"%s\"", tracker_property_get_table_name (prop));
								}
								_g_object_unref0 (prop);
							}
						}
					}
				} else {
					_inner_error_ = tracker_sparql_query_get_internal_error (query, "Unrestricted predicate variables not supported");
					{
						_g_string_free0 (sql);
						if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
							goto __catch0_tracker_db_interface_error;
						}
						goto __finally0;
					}
				}
			}
		}
		result = g_strdup (sql->str);
		_g_string_free0 (sql);
		return result;
	}
	goto __finally0;
	__catch0_tracker_db_interface_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally0;
			}
			_g_error_free0 (e);
		}
	}
	__finally0:
	{
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type) {
	TrackerSparqlPredicateVariable * self;
	self = (TrackerSparqlPredicateVariable*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (void) {
	return tracker_sparql_predicate_variable_construct (TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE);
}


static void tracker_sparql_predicate_variable_class_init (TrackerSparqlPredicateVariableClass * klass) {
	tracker_sparql_predicate_variable_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_predicate_variable_finalize;
}


static void tracker_sparql_predicate_variable_instance_init (TrackerSparqlPredicateVariable * self) {
}


static void tracker_sparql_predicate_variable_finalize (GObject* obj) {
	TrackerSparqlPredicateVariable * self;
	self = TRACKER_SPARQL_PREDICATE_VARIABLE (obj);
	_g_free0 (self->subject);
	_g_free0 (self->object);
	_g_object_unref0 (self->domain);
	G_OBJECT_CLASS (tracker_sparql_predicate_variable_parent_class)->finalize (obj);
}


GType tracker_sparql_predicate_variable_get_type (void) {
	static volatile gsize tracker_sparql_predicate_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_predicate_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPredicateVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_predicate_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPredicateVariable), 0, (GInstanceInitFunc) tracker_sparql_predicate_variable_instance_init, NULL };
		GType tracker_sparql_predicate_variable_type_id;
		tracker_sparql_predicate_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPredicateVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_predicate_variable_type_id__volatile, tracker_sparql_predicate_variable_type_id);
	}
	return tracker_sparql_predicate_variable_type_id__volatile;
}


TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlPattern * self;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlPattern*) g_object_new (object_type, NULL);
	self->priv->query = query;
	self->priv->expression = query->expression;
	return self;
}


TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query) {
	return tracker_sparql_pattern_construct (TRACKER_SPARQL_TYPE_PATTERN, query);
}


static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_next (self->priv->query, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self) {
	TrackerSparqlTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = tracker_sparql_query_current (self->priv->query);
	return result;
}


static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self->priv->query, type, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const char* msg) {
	GError* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	result = tracker_sparql_query_get_error (self->priv->query, msg);
	return result;
}


static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_expect (self->priv->query, type, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result) {
	TrackerSourceLocation _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	*result = (tracker_sparql_query_get_location (self->priv->query, &_tmp0_), _tmp0_);
	return;
}


static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location) {
	g_return_if_fail (self != NULL);
	tracker_sparql_query_set_location (self->priv->query, location);
}


static char* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = tracker_sparql_query_get_last_string (self->priv->query, strip);
	return result;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void _vala_array_add3 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerPropertyType, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add4 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerPropertyType, *array, *size);
	}
	(*array)[(*length)++] = value;
}


TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error) {
	TrackerSparqlSelectContext* result = NULL;
	GError * _inner_error_;
	TrackerSparqlSelectContext* _result_;
	TrackerPropertyType type;
	GString* pattern_sql;
	GList* _tmp2_;
	GList* old_bindings;
	gboolean _tmp3_;
	TrackerSourceLocation _tmp5_ = {0};
	TrackerSourceLocation select_variables_location;
	gboolean _tmp6_;
	TrackerSparqlContext* pattern;
	TrackerSourceLocation _tmp7_ = {0};
	TrackerSourceLocation after_where;
	GList* _tmp10_;
	GList* where_bindings;
	GList* _tmp11_;
	GList* _tmp12_;
	gboolean first;
	gboolean _tmp13_;
	gboolean _tmp16_;
	gboolean _tmp23_;
	gint limit;
	gint offset;
	gboolean _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = NULL;
	if (scalar_subquery) {
		TrackerSparqlSelectContext* _tmp0_;
		_result_ = (_tmp0_ = tracker_sparql_select_context_new_subquery (self->priv->query, tracker_sparql_pattern_get_context (self)), _tracker_sparql_context_unref0 (_result_), _tmp0_);
	} else {
		TrackerSparqlSelectContext* _tmp1_;
		_result_ = (_tmp1_ = tracker_sparql_select_context_new (self->priv->query, tracker_sparql_pattern_get_context (self)), _tracker_sparql_context_unref0 (_result_), _tmp1_);
	}
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _result_);
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
	pattern_sql = g_string_new ("");
	old_bindings = (_tmp2_ = self->priv->query->bindings, self->priv->query->bindings = NULL, _tmp2_);
	g_string_append (sql, "SELECT ");
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_SELECT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp3_) {
		g_string_append (sql, "DISTINCT ");
	} else {
		gboolean _tmp4_;
		_tmp4_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_REDUCED, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp4_) {
		}
	}
	select_variables_location = (tracker_sparql_pattern_get_location (self, &_tmp5_), _tmp5_);
	tracker_sparql_expression_skip_select_variables (self->priv->expression, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp6_) {
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NAMED, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	pattern = tracker_sparql_pattern_translate_group_graph_pattern (self, pattern_sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GList* key_collection;
		GList* key_it;
		key_collection = g_hash_table_get_keys (pattern->var_set);
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			TrackerSparqlVariable* key;
			key = (TrackerSparqlVariable*) key_it->data;
			{
				g_hash_table_insert (tracker_sparql_pattern_get_context (self)->var_set, _g_object_ref0 (key), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
			}
		}
		_g_list_free0 (key_collection);
	}
	after_where = (tracker_sparql_pattern_get_location (self, &_tmp7_), _tmp7_);
	tracker_sparql_pattern_set_location (self, &select_variables_location);
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = g_hash_table_get_keys (tracker_sparql_pattern_get_context (self)->var_set);
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* variable;
			variable = (TrackerSparqlVariable*) variable_it->data;
			{
				if (variable->binding == NULL) {
					char* _tmp8_;
					GError* _tmp9_;
					_inner_error_ = (_tmp9_ = tracker_sparql_pattern_get_error (self, _tmp8_ = g_strdup_printf ("use of undefined variable `%s'", tracker_sparql_variable_get_name (variable))), _g_free0 (_tmp8_), _tmp9_);
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_list_free0 (variable_collection);
							_tracker_sparql_context_unref0 (pattern);
							__g_list_free_g_object_unref0 (old_bindings);
							_g_string_free0 (pattern_sql);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							_g_list_free0 (variable_collection);
							_tracker_sparql_context_unref0 (pattern);
							__g_list_free_g_object_unref0 (old_bindings);
							_g_string_free0 (pattern_sql);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
		}
		_g_list_free0 (variable_collection);
	}
	where_bindings = (_tmp10_ = self->priv->query->bindings, self->priv->query->bindings = NULL, _tmp10_);
	self->priv->query->bindings = (_tmp12_ = (_tmp11_ = old_bindings, old_bindings = NULL, _tmp11_), __g_list_free_g_object_unref0 (self->priv->query->bindings), _tmp12_);
	first = TRUE;
	_tmp13_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp13_) {
		{
			GList* variable_collection;
			GList* variable_it;
			variable_collection = g_hash_table_get_keys (tracker_sparql_pattern_get_context (self)->var_set);
			for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
				TrackerSparqlVariable* variable;
				variable = (TrackerSparqlVariable*) variable_it->data;
				{
					if (!first) {
						g_string_append (sql, ", ");
					} else {
						first = FALSE;
					}
					if (subquery) {
						g_string_append (sql, tracker_sparql_variable_get_sql_expression (variable));
					} else {
						tracker_sparql_expression_append_expression_as_string (sql, tracker_sparql_variable_get_sql_expression (variable), ((TrackerSparqlDataBinding*) variable->binding)->data_type);
						g_string_append_printf (sql, " AS \"%s\"", tracker_sparql_variable_get_name (variable));
					}
					_vala_array_add3 (&_result_->types, &_result_->types_length1, &_result_->_types_size_, ((TrackerSparqlDataBinding*) variable->binding)->data_type);
					_vala_array_add4 (&_result_->variable_names, &_result_->variable_names_length1, &_result_->_variable_names_size_, g_strdup (tracker_sparql_variable_get_name (variable)));
				}
			}
			_g_list_free0 (variable_collection);
		}
	} else {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp14_;
				_tmp14_ = TRUE;
				while (TRUE) {
					TrackerPropertyType _tmp15_;
					if (!_tmp14_) {
						i++;
					}
					_tmp14_ = FALSE;
					if (i > 0) {
						g_string_append (sql, ", ");
					}
					_tmp15_ = tracker_sparql_expression_translate_select_expression (self->priv->expression, sql, subquery, i, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							__g_list_free_g_object_unref0 (where_bindings);
							_tracker_sparql_context_unref0 (pattern);
							__g_list_free_g_object_unref0 (old_bindings);
							_g_string_free0 (pattern_sql);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							__g_list_free_g_object_unref0 (where_bindings);
							_tracker_sparql_context_unref0 (pattern);
							__g_list_free_g_object_unref0 (old_bindings);
							_g_string_free0 (pattern_sql);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					type = _tmp15_;
					_vala_array_add5 (&_result_->types, &_result_->types_length1, &_result_->_types_size_, type);
					switch (tracker_sparql_pattern_current (self)) {
						case TRACKER_SPARQL_TOKEN_TYPE_FROM:
						case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
						case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
						case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
						case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
						case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
						case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
						case TRACKER_SPARQL_TOKEN_TYPE_EOF:
						{
							break;
						}
						default:
						{
							continue;
						}
					}
					break;
				}
			}
		}
	}
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = where_bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlLiteralBinding* binding;
			binding = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
			{
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
				_g_object_unref0 (binding);
			}
		}
	}
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	tracker_sparql_pattern_set_location (self, &after_where);
	_tmp16_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp16_) {
		gboolean first_group;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		g_string_append (sql, " GROUP BY ");
		first_group = TRUE;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				if (!_tmp17_) {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					gboolean _tmp20_ = FALSE;
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					if (tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_ORDER) {
						_tmp22_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
					} else {
						_tmp22_ = FALSE;
					}
					if (_tmp22_) {
						_tmp21_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						_tmp20_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						_tmp19_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						_tmp18_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_EOF;
					} else {
						_tmp18_ = FALSE;
					}
					if (!_tmp18_) {
						break;
					}
				}
				_tmp17_ = FALSE;
				if (first_group) {
					first_group = FALSE;
				} else {
					g_string_append (sql, ", ");
				}
				tracker_sparql_expression_translate_expression (self->priv->expression, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free_g_object_unref0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free_g_object_unref0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free_g_object_unref0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free_g_object_unref0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	_tmp23_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp23_) {
		gboolean first_order;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		g_string_append (sql, " ORDER BY ");
		first_order = TRUE;
		{
			gboolean _tmp24_;
			_tmp24_ = TRUE;
			while (TRUE) {
				if (!_tmp24_) {
					gboolean _tmp25_ = FALSE;
					gboolean _tmp26_ = FALSE;
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_ = FALSE;
					if (tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_LIMIT) {
						_tmp28_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						_tmp27_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						_tmp26_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						_tmp25_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_EOF;
					} else {
						_tmp25_ = FALSE;
					}
					if (!_tmp25_) {
						break;
					}
				}
				_tmp24_ = FALSE;
				if (first_order) {
					first_order = FALSE;
				} else {
					g_string_append (sql, ", ");
				}
				tracker_sparql_expression_translate_order_condition (self->priv->expression, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free_g_object_unref0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free_g_object_unref0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free_g_object_unref0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free_g_object_unref0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	limit = -1;
	offset = -1;
	_tmp29_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free_g_object_unref0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free_g_object_unref0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free_g_object_unref0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp29_) {
		char* _tmp30_;
		gboolean _tmp31_;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		limit = atoi (_tmp30_ = tracker_sparql_pattern_get_last_string (self, 0));
		_g_free0 (_tmp30_);
		_tmp31_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp31_) {
			char* _tmp32_;
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free_g_object_unref0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free_g_object_unref0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free_g_object_unref0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free_g_object_unref0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			offset = atoi (_tmp32_ = tracker_sparql_pattern_get_last_string (self, 0));
			_g_free0 (_tmp32_);
		}
	} else {
		gboolean _tmp33_;
		_tmp33_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free_g_object_unref0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free_g_object_unref0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp33_) {
			char* _tmp34_;
			gboolean _tmp35_;
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free_g_object_unref0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free_g_object_unref0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free_g_object_unref0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free_g_object_unref0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			offset = atoi (_tmp34_ = tracker_sparql_pattern_get_last_string (self, 0));
			_g_free0 (_tmp34_);
			_tmp35_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free_g_object_unref0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free_g_object_unref0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free_g_object_unref0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free_g_object_unref0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp35_) {
				char* _tmp36_;
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free_g_object_unref0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free_g_object_unref0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free_g_object_unref0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free_g_object_unref0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				limit = atoi (_tmp36_ = tracker_sparql_pattern_get_last_string (self, 0));
				_g_free0 (_tmp36_);
			}
		}
	}
	if (limit >= 0) {
		TrackerSparqlLiteralBinding* binding;
		char* _tmp37_;
		g_string_append (sql, " LIMIT ?");
		binding = tracker_sparql_literal_binding_new ();
		binding->literal = (_tmp37_ = g_strdup_printf ("%i", limit), _g_free0 (binding->literal), _tmp37_);
		((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
		if (offset >= 0) {
			TrackerSparqlLiteralBinding* _tmp38_;
			char* _tmp39_;
			g_string_append (sql, " OFFSET ?");
			binding = (_tmp38_ = tracker_sparql_literal_binding_new (), _g_object_unref0 (binding), _tmp38_);
			binding->literal = (_tmp39_ = g_strdup_printf ("%i", offset), _g_free0 (binding->literal), _tmp39_);
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
		}
		_g_object_unref0 (binding);
	} else {
		if (offset >= 0) {
			TrackerSparqlLiteralBinding* binding;
			char* _tmp40_;
			g_string_append (sql, " LIMIT -1 OFFSET ?");
			binding = tracker_sparql_literal_binding_new ();
			binding->literal = (_tmp40_ = g_strdup_printf ("%i", offset), _g_free0 (binding->literal), _tmp40_);
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
			_g_object_unref0 (binding);
		}
	}
	tracker_sparql_pattern_set_context (self, tracker_sparql_pattern_get_context (self)->parent_context);
	_result_->type = type;
	result = _result_;
	__g_list_free_g_object_unref0 (where_bindings);
	_tracker_sparql_context_unref0 (pattern);
	__g_list_free_g_object_unref0 (old_bindings);
	_g_string_free0 (pattern_sql);
	return result;
}


void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean not;
	TrackerSparqlSelectContext* _result_;
	TrackerSparqlSelectContext* _tmp0_;
	GString* pattern_sql;
	TrackerSparqlContext* pattern;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	not = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EXISTS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_result_ = NULL;
	_result_ = (_tmp0_ = tracker_sparql_select_context_new_subquery (self->priv->query, tracker_sparql_pattern_get_context (self)), _tracker_sparql_context_unref0 (_result_), _tmp0_);
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _result_);
	pattern_sql = g_string_new ("");
	g_string_append (sql, "SELECT ");
	pattern = tracker_sparql_pattern_translate_group_graph_pattern (self, pattern_sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return;
		} else {
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		GList* key_collection;
		GList* key_it;
		key_collection = g_hash_table_get_keys (pattern->var_set);
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			TrackerSparqlVariable* key;
			key = (TrackerSparqlVariable*) key_it->data;
			{
				g_hash_table_insert (tracker_sparql_pattern_get_context (self)->var_set, _g_object_ref0 (key), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
			}
		}
		_g_list_free0 (key_collection);
	}
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = g_hash_table_get_keys (tracker_sparql_pattern_get_context (self)->var_set);
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* variable;
			variable = (TrackerSparqlVariable*) variable_it->data;
			{
				if (variable->binding == NULL) {
					char* _tmp1_;
					GError* _tmp2_;
					_inner_error_ = (_tmp2_ = tracker_sparql_pattern_get_error (self, _tmp1_ = g_strdup_printf ("use of undefined variable `%s'", tracker_sparql_variable_get_name (variable))), _g_free0 (_tmp1_), _tmp2_);
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_list_free0 (variable_collection);
							_tracker_sparql_context_unref0 (pattern);
							_g_string_free0 (pattern_sql);
							_tracker_sparql_context_unref0 (_result_);
							return;
						} else {
							_g_list_free0 (variable_collection);
							_tracker_sparql_context_unref0 (pattern);
							_g_string_free0 (pattern_sql);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
		_g_list_free0 (variable_collection);
	}
	if (not) {
		g_string_append (sql, "COUNT(1) = 0");
	} else {
		g_string_append (sql, "COUNT(1) > 0");
	}
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	tracker_sparql_pattern_set_context (self, tracker_sparql_pattern_get_context (self)->parent_context);
	_tracker_sparql_context_unref0 (pattern);
	_g_string_free0 (pattern_sql);
	_tracker_sparql_context_unref0 (_result_);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


char* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = g_strdup ("");
	*is_var = FALSE;
	if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		char* _tmp0_;
		char* _tmp1_;
		*is_var = TRUE;
		tracker_sparql_pattern_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			} else {
				_g_free0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_result_ = (_tmp1_ = string_substring (_tmp0_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_result_), _tmp1_);
		_g_free0 (_tmp0_);
	} else {
		if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
			char* _tmp2_;
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_result_ = (_tmp2_ = tracker_sparql_pattern_get_last_string (self, 1), _g_free0 (_result_), _tmp2_);
		} else {
			if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
				char* ns;
				char* _tmp3_;
				char* _tmp4_;
				char* _tmp5_;
				char* _tmp6_;
				char* _tmp7_;
				tracker_sparql_pattern_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				ns = tracker_sparql_pattern_get_last_string (self, 0);
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp6_ = (_tmp5_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp4_ = string_substring (_tmp3_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp5_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_result_ = (_tmp7_ = _tmp6_, _g_free0 (_result_), _tmp7_);
				_g_free0 (ns);
			} else {
				if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
					char* _tmp8_;
					char* _tmp9_;
					char* _tmp10_;
					char* _tmp11_;
					char* _tmp12_;
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp11_ = (_tmp10_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp9_ = string_substring (_tmp8_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_result_ = (_tmp12_ = _tmp11_, _g_free0 (_result_), _tmp12_);
				} else {
					gboolean _tmp13_;
					_tmp13_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					if (_tmp13_) {
						char* _tmp14_;
						char* _tmp15_;
						char* _tmp16_;
						tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (_result_);
								return NULL;
							} else {
								_g_free0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_result_ = (_tmp16_ = tracker_sparql_query_generate_bnodeid (self->priv->query, _tmp15_ = string_substring (_tmp14_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1)), _g_free0 (_result_), _tmp16_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp14_);
					} else {
						if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
							char* _tmp17_;
							char* _tmp18_;
							_tmp17_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_result_);
									return NULL;
								} else {
									_g_free0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_result_ = (_tmp18_ = _tmp17_, _g_free0 (_result_), _tmp18_);
						} else {
							if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
								char* _tmp19_;
								char* _tmp20_;
								_tmp19_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_result_ = (_tmp20_ = _tmp19_, _g_free0 (_result_), _tmp20_);
							} else {
								if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
									char* _tmp21_;
									char* _tmp22_;
									_tmp21_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (_result_);
											return NULL;
										} else {
											_g_free0 (_result_);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_result_ = (_tmp22_ = _tmp21_, _g_free0 (_result_), _tmp22_);
								} else {
									if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
										char* _tmp23_;
										char* _tmp24_;
										_tmp23_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (_result_);
												return NULL;
											} else {
												_g_free0 (_result_);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_result_ = (_tmp24_ = _tmp23_, _g_free0 (_result_), _tmp24_);
									} else {
										if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
											char* _tmp25_;
											tracker_sparql_pattern_next (self, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													_g_free0 (_result_);
													return NULL;
												} else {
													_g_free0 (_result_);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return NULL;
												}
											}
											_result_ = (_tmp25_ = tracker_sparql_pattern_get_last_string (self, 0), _g_free0 (_result_), _tmp25_);
										} else {
											if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
												char* _tmp26_;
												tracker_sparql_pattern_next (self, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (_result_);
														return NULL;
													} else {
														_g_free0 (_result_);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_result_ = (_tmp26_ = tracker_sparql_pattern_get_last_string (self, 0), _g_free0 (_result_), _tmp26_);
											} else {
												if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
													char* _tmp27_;
													tracker_sparql_pattern_next (self, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (_result_);
															return NULL;
														} else {
															_g_free0 (_result_);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													_result_ = (_tmp27_ = tracker_sparql_pattern_get_last_string (self, 0), _g_free0 (_result_), _tmp27_);
												} else {
													if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
														char* _tmp28_;
														tracker_sparql_pattern_next (self, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																_g_free0 (_result_);
																return NULL;
															} else {
																_g_free0 (_result_);
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return NULL;
															}
														}
														_result_ = (_tmp28_ = g_strdup ("true"), _g_free0 (_result_), _tmp28_);
													} else {
														if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
															char* _tmp29_;
															tracker_sparql_pattern_next (self, &_inner_error_);
															if (_inner_error_ != NULL) {
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
															_result_ = (_tmp29_ = g_strdup ("false"), _g_free0 (_result_), _tmp29_);
														} else {
															if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
																char* _tmp30_;
																char* old_subject;
																gboolean old_subject_is_var;
																char* _tmp31_;
																char* _tmp32_;
																tracker_sparql_pattern_next (self, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_result_ = (_tmp30_ = tracker_sparql_query_generate_bnodeid (self->priv->query, NULL), _g_free0 (_result_), _tmp30_);
																old_subject = g_strdup (self->priv->current_subject);
																old_subject_is_var = self->priv->current_subject_is_var;
																self->priv->current_subject = (_tmp31_ = g_strdup (_result_), _g_free0 (self->priv->current_subject), _tmp31_);
																self->priv->current_subject_is_var = TRUE;
																tracker_sparql_pattern_parse_property_list_not_empty (self, sql, FALSE, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																self->priv->current_subject = (_tmp32_ = g_strdup (old_subject), _g_free0 (self->priv->current_subject), _tmp32_);
																self->priv->current_subject_is_var = old_subject_is_var;
																*is_var = TRUE;
																_g_free0 (old_subject);
															} else {
																_inner_error_ = tracker_sparql_pattern_get_error (self, "expected variable or term");
																{
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		gboolean _tmp0_;
		tracker_sparql_pattern_parse_object (self, sql, in_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp0_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			continue;
		}
		break;
	}
}


static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		char* old_predicate;
		gboolean old_predicate_is_var;
		char* _tmp0_;
		char* _tmp15_;
		gboolean _tmp16_;
		old_predicate = g_strdup (self->priv->current_predicate);
		old_predicate_is_var = self->priv->current_predicate_is_var;
		self->priv->current_predicate = (_tmp0_ = NULL, _g_free0 (self->priv->current_predicate), _tmp0_);
		self->priv->current_predicate_is_var = FALSE;
		if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			char* _tmp1_;
			char* _tmp2_;
			self->priv->current_predicate_is_var = TRUE;
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_predicate);
					return;
				} else {
					_g_free0 (old_predicate);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_predicate = (_tmp2_ = string_substring (_tmp1_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1), _g_free0 (self->priv->current_predicate), _tmp2_);
			_g_free0 (_tmp1_);
		} else {
			if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
				char* _tmp3_;
				tracker_sparql_pattern_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_predicate);
						return;
					} else {
						_g_free0 (old_predicate);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->current_predicate = (_tmp3_ = tracker_sparql_pattern_get_last_string (self, 1), _g_free0 (self->priv->current_predicate), _tmp3_);
			} else {
				if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
					char* ns;
					char* _tmp4_;
					char* _tmp5_;
					char* _tmp6_;
					char* _tmp7_;
					char* _tmp8_;
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					ns = tracker_sparql_pattern_get_last_string (self, 0);
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp7_ = (_tmp6_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp5_ = string_substring (_tmp4_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp6_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					self->priv->current_predicate = (_tmp8_ = _tmp7_, _g_free0 (self->priv->current_predicate), _tmp8_);
					_g_free0 (ns);
				} else {
					if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
						char* _tmp9_;
						char* _tmp10_;
						char* _tmp11_;
						char* _tmp12_;
						char* _tmp13_;
						tracker_sparql_pattern_next (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp12_ = (_tmp11_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp10_ = string_substring (_tmp9_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp11_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						self->priv->current_predicate = (_tmp13_ = _tmp12_, _g_free0 (self->priv->current_predicate), _tmp13_);
					} else {
						if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_A) {
							char* _tmp14_;
							tracker_sparql_pattern_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							self->priv->current_predicate = (_tmp14_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), _g_free0 (self->priv->current_predicate), _tmp14_);
						} else {
							_inner_error_ = tracker_sparql_pattern_get_error (self, "expected non-empty property list");
							{
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
				}
			}
		}
		tracker_sparql_pattern_parse_object_list (self, sql, in_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->current_predicate = (_tmp15_ = g_strdup (old_predicate), _g_free0 (self->priv->current_predicate), _tmp15_);
		self->priv->current_predicate_is_var = old_predicate_is_var;
		_tmp16_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp16_) {
			if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DOT) {
				_g_free0 (old_predicate);
				break;
			}
			_g_free0 (old_predicate);
			continue;
		}
		_g_free0 (old_predicate);
		break;
	}
}


static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_translate_constraint (self->priv->expression, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error) {
	GError * _inner_error_;
	gint n_parens;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	switch (tracker_sparql_pattern_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	n_parens = 1;
	while (TRUE) {
		gboolean _tmp0_;
		if (!(n_parens > 0)) {
			break;
		}
		_tmp0_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			n_parens++;
		} else {
			gboolean _tmp1_;
			_tmp1_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp1_) {
				n_parens--;
			} else {
				if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
					_inner_error_ = tracker_sparql_pattern_get_error (self, "unexpected end of query, expected )");
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlPatternTripleContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) (self->priv->triple_context = (_tmp0_ = tracker_sparql_pattern_triple_context_new (self->priv->query, tracker_sparql_pattern_get_context (self)), _tracker_sparql_context_unref0 (self->priv->triple_context), _tmp0_)));
	g_string_append (sql, "SELECT ");
}


static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error) {
	GError * _inner_error_;
	gboolean first;
	TrackerSparqlPatternTripleContext* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	g_string_truncate (sql, (gsize) (sql->len - 2));
	g_string_append (sql, " FROM ");
	first = TRUE;
	{
		GList* table_collection;
		GList* table_it;
		table_collection = self->priv->triple_context->tables;
		for (table_it = table_collection; table_it != NULL; table_it = table_it->next) {
			TrackerSparqlDataTable* table;
			table = _g_object_ref0 ((TrackerSparqlDataTable*) table_it->data);
			{
				if (!first) {
					g_string_append (sql, ", ");
				} else {
					first = FALSE;
				}
				if (table->sql_db_tablename != NULL) {
					g_string_append_printf (sql, "\"%s\"", table->sql_db_tablename);
				} else {
					char* _tmp0_;
					char* _tmp1_;
					_tmp0_ = tracker_sparql_predicate_variable_get_sql_query (table->predicate_variable, self->priv->query, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (table);
							return;
						} else {
							_g_object_unref0 (table);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					g_string_append_printf (sql, "(%s)", _tmp1_ = _tmp0_);
					_g_free0 (_tmp1_);
				}
				g_string_append_printf (sql, " AS \"%s\"", table->sql_query_tablename);
				_g_object_unref0 (table);
			}
		}
	}
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = self->priv->triple_context->variables;
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* variable;
			variable = _g_object_ref0 ((TrackerSparqlVariable*) variable_it->data);
			{
				gboolean maybe_null;
				gboolean in_simple_optional;
				char* last_name;
				gboolean _tmp5_ = FALSE;
				maybe_null = TRUE;
				in_simple_optional = FALSE;
				last_name = NULL;
				{
					GList* binding_collection;
					GList* binding_it;
					binding_collection = ((TrackerSparqlVariableBindingList*) g_hash_table_lookup (self->priv->triple_context->var_bindings, variable))->list;
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
						TrackerSparqlVariableBinding* binding;
						binding = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
						{
							char* name;
							char* _tmp4_;
							name = NULL;
							if (((TrackerSparqlDataBinding*) binding)->table != NULL) {
								char* _tmp2_;
								name = (_tmp2_ = g_strdup (tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding)), _g_free0 (name), _tmp2_);
							} else {
								char* _tmp3_;
								name = (_tmp3_ = g_strdup (tracker_sparql_variable_get_sql_expression (variable)), _g_free0 (name), _tmp3_);
							}
							if (last_name != NULL) {
								if (!(*first_where)) {
									g_string_append (sql, " AND ");
								} else {
									g_string_append (sql, " WHERE ");
									*first_where = FALSE;
								}
								g_string_append (sql, last_name);
								g_string_append (sql, " = ");
								g_string_append (sql, name);
							}
							last_name = (_tmp4_ = g_strdup (name), _g_free0 (last_name), _tmp4_);
							if (!binding->maybe_null) {
								maybe_null = FALSE;
							}
							in_simple_optional = binding->in_simple_optional;
							_g_free0 (name);
							_g_object_unref0 (binding);
						}
					}
				}
				if (maybe_null) {
					_tmp5_ = !in_simple_optional;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					if (!(*first_where)) {
						g_string_append (sql, " AND ");
					} else {
						g_string_append (sql, " WHERE ");
						*first_where = FALSE;
					}
					g_string_append_printf (sql, "%s IS NOT NULL", tracker_sparql_variable_get_sql_expression (variable));
				}
				_g_free0 (last_name);
				_g_object_unref0 (variable);
			}
		}
	}
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = self->priv->triple_context->bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlLiteralBinding* binding;
			binding = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
			{
				if (!(*first_where)) {
					g_string_append (sql, " AND ");
				} else {
					g_string_append (sql, " WHERE ");
					*first_where = FALSE;
				}
				g_string_append (sql, tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding));
				if (binding->is_fts_match) {
					char** _tmp6_;
					char** _tmp7_;
					gint _tmp7__length1;
					char* _tmp8_;
					char* escaped_literal;
					escaped_literal = (_tmp8_ = g_strjoinv ("''", (_tmp7_ = _tmp6_ = g_strsplit (binding->literal, "'", 0), _tmp7__length1 = _vala_array_length (_tmp6_), _tmp7_)), _tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL), _tmp8_);
					g_string_append_printf (sql, " MATCH '%s'", escaped_literal);
					_g_free0 (escaped_literal);
				} else {
					g_string_append (sql, " = ");
					if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
						g_string_append (sql, "(SELECT ID FROM Resource WHERE Uri = ?)");
					} else {
						g_string_append (sql, "?");
					}
					self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
				}
				_g_object_unref0 (binding);
			}
		}
	}
	if (in_group_graph_pattern) {
		g_string_append (sql, ")");
	}
	{
		GList* v_collection;
		GList* v_it;
		v_collection = g_hash_table_get_keys (tracker_sparql_pattern_get_context (self)->var_set);
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			TrackerSparqlVariable* v;
			v = (TrackerSparqlVariable*) v_it->data;
			{
				g_hash_table_insert (tracker_sparql_pattern_get_context (self)->parent_context->var_set, _g_object_ref0 (v), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
			}
		}
		_g_list_free0 (v_collection);
	}
	self->priv->triple_context = (_tmp9_ = NULL, _tracker_sparql_context_unref0 (self->priv->triple_context), _tmp9_);
	tracker_sparql_pattern_set_context (self, tracker_sparql_pattern_get_context (self)->parent_context);
}


static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		char* _tmp6_;
		char* _tmp7_;
		gboolean _tmp8_;
		if (tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			_tmp3_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_COLON;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = tracker_sparql_pattern_current (self) != TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			break;
		}
		if (*in_triples_block) {
			_tmp5_ = !(*in_group_graph_pattern);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = found_simple_optional;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			tracker_sparql_pattern_end_triples_block (self, sql, first_where, *in_group_graph_pattern, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			*in_triples_block = FALSE;
			*in_group_graph_pattern = TRUE;
		}
		if (!(*in_triples_block)) {
			if (*in_group_graph_pattern) {
				g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
				g_string_append (sql, ") NATURAL INNER JOIN (");
			}
			*in_triples_block = TRUE;
			*first_where = TRUE;
			tracker_sparql_pattern_start_triples_block (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		_tmp6_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &self->priv->current_subject_is_var, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->current_subject = (_tmp7_ = _tmp6_, _g_free0 (self->priv->current_subject), _tmp7_);
		tracker_sparql_pattern_parse_property_list_not_empty (self, sql, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp8_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp8_) {
			break;
		}
	}
}


static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (class1 != NULL, FALSE);
	g_return_val_if_fail (class2 != NULL, FALSE);
	if (class1 == class2) {
		result = TRUE;
		return result;
	}
	{
		TrackerClass** _tmp0_;
		TrackerClass** superclass_collection;
		int superclass_collection_length1;
		int superclass_it;
		superclass_collection = _tmp0_ = tracker_class_get_super_classes (class1);
		superclass_collection_length1 = _vala_array_length (_tmp0_);
		for (superclass_it = 0; superclass_it < _vala_array_length (_tmp0_); superclass_it = superclass_it + 1) {
			TrackerClass* superclass;
			superclass = _g_object_ref0 (superclass_collection[superclass_it]);
			{
				if (tracker_sparql_pattern_is_subclass (self, superclass, class2)) {
					result = TRUE;
					_g_object_unref0 (superclass);
					return result;
				}
				_g_object_unref0 (superclass);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self) {
	gboolean result = FALSE;
	GError * _inner_error_;
	TrackerSourceLocation _tmp0_ = {0};
	TrackerSourceLocation optional_start;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	optional_start = (tracker_sparql_pattern_get_location (self, &_tmp0_), _tmp0_);
	{
		gboolean _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		TrackerSparqlVariable* _tmp4_;
		TrackerSparqlVariable* left_variable;
		gint left_variable_state;
		char* predicate;
		gboolean _tmp5_;
		TrackerProperty* prop;
		gboolean _tmp19_;
		char* _tmp20_;
		char* _tmp21_;
		TrackerSparqlVariable* _tmp22_;
		TrackerSparqlVariable* right_variable;
		gint right_variable_state;
		gboolean _tmp23_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp1_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (!_tmp1_) {
			result = FALSE;
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			return result;
		}
		left_variable = (_tmp4_ = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), _tmp3_ = string_substring (_tmp2_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1))), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _tmp4_);
		left_variable_state = GPOINTER_TO_INT (g_hash_table_lookup (tracker_sparql_pattern_get_context (self)->var_set, left_variable));
		predicate = NULL;
		_tmp5_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (_tmp5_) {
			char* _tmp6_;
			predicate = (_tmp6_ = tracker_sparql_pattern_get_last_string (self, 1), _g_free0 (predicate), _tmp6_);
		} else {
			gboolean _tmp7_;
			_tmp7_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch1_tracker_sparql_error;
				}
				{
					tracker_sparql_pattern_set_location (self, &optional_start);
				}
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp7_) {
				char* ns;
				char* _tmp8_;
				char* _tmp9_;
				char* _tmp10_;
				char* _tmp11_;
				char* _tmp12_;
				ns = tracker_sparql_pattern_get_last_string (self, 0);
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (ns);
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						goto __catch1_tracker_sparql_error;
					}
					_g_free0 (ns);
					{
						tracker_sparql_pattern_set_location (self, &optional_start);
					}
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_tmp11_ = (_tmp10_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp9_ = string_substring (_tmp8_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
				if (_inner_error_ != NULL) {
					_g_free0 (ns);
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						goto __catch1_tracker_sparql_error;
					}
					_g_free0 (ns);
					{
						tracker_sparql_pattern_set_location (self, &optional_start);
					}
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				predicate = (_tmp12_ = _tmp11_, _g_free0 (predicate), _tmp12_);
				_g_free0 (ns);
			} else {
				gboolean _tmp13_;
				_tmp13_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						goto __catch1_tracker_sparql_error;
					}
					{
						tracker_sparql_pattern_set_location (self, &optional_start);
					}
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				if (_tmp13_) {
					char* _tmp14_;
					char* _tmp15_;
					char* _tmp16_;
					char* _tmp17_;
					char* _tmp18_;
					_tmp17_ = (_tmp16_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp15_ = string_substring (_tmp14_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp15_), _g_free0 (_tmp14_), _tmp16_);
					if (_inner_error_ != NULL) {
						_g_free0 (predicate);
						_g_object_unref0 (left_variable);
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							goto __catch1_tracker_sparql_error;
						}
						{
							tracker_sparql_pattern_set_location (self, &optional_start);
						}
						_g_free0 (predicate);
						_g_object_unref0 (left_variable);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					predicate = (_tmp18_ = _tmp17_, _g_free0 (predicate), _tmp18_);
				} else {
					result = FALSE;
					{
						tracker_sparql_pattern_set_location (self, &optional_start);
					}
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					return result;
				}
			}
		}
		prop = _g_object_ref0 (tracker_ontologies_get_property_by_uri (predicate));
		if (prop == NULL) {
			result = FALSE;
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			return result;
		}
		_tmp19_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (!_tmp19_) {
			result = FALSE;
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			return result;
		}
		right_variable = (_tmp22_ = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), _tmp21_ = string_substring (_tmp20_ = tracker_sparql_pattern_get_last_string (self, 0), (glong) 1, -1))), _g_free0 (_tmp21_), _g_free0 (_tmp20_), _tmp22_);
		right_variable_state = GPOINTER_TO_INT (g_hash_table_lookup (tracker_sparql_pattern_get_context (self)->var_set, right_variable));
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp23_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (!_tmp23_) {
			result = FALSE;
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			return result;
		}
		if (left_variable_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND) {
			_tmp25_ = !tracker_property_get_multiple_values (prop);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			_tmp24_ = right_variable_state == 0;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			gboolean in_domain;
			in_domain = FALSE;
			{
				GList* binding_collection;
				GList* binding_it;
				binding_collection = ((TrackerSparqlVariableBindingList*) g_hash_table_lookup (self->priv->triple_context->var_bindings, left_variable))->list;
				for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
					TrackerSparqlVariableBinding* binding;
					binding = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
					{
						gboolean _tmp26_ = FALSE;
						if (binding->type != NULL) {
							_tmp26_ = tracker_sparql_pattern_is_subclass (self, binding->type, tracker_property_get_domain (prop));
						} else {
							_tmp26_ = FALSE;
						}
						if (_tmp26_) {
							in_domain = TRUE;
							_g_object_unref0 (binding);
							break;
						}
						_g_object_unref0 (binding);
					}
				}
			}
			if (in_domain) {
				result = TRUE;
				{
					tracker_sparql_pattern_set_location (self, &optional_start);
				}
				_g_object_unref0 (right_variable);
				_g_object_unref0 (prop);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				return result;
			}
		} else {
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			if (left_variable_state == 0) {
				_tmp28_ = tracker_property_get_is_inverse_functional_property (prop);
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				_tmp27_ = right_variable_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				result = TRUE;
				{
					tracker_sparql_pattern_set_location (self, &optional_start);
				}
				_g_object_unref0 (right_variable);
				_g_object_unref0 (prop);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				return result;
			}
		}
		result = FALSE;
		{
			tracker_sparql_pattern_set_location (self, &optional_start);
		}
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		return result;
	}
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = FALSE;
			{
				tracker_sparql_pattern_set_location (self, &optional_start);
			}
			_g_error_free0 (e);
			return result;
		}
	}
	__finally1:
	{
		tracker_sparql_pattern_set_location (self, &optional_start);
	}
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static guint _tracker_sparql_variable_hash_ghash_func (void* key) {
	guint result;
	result = tracker_sparql_variable_hash (key);
	return result;
}


static gboolean _tracker_sparql_variable_equal_gequal_func (void* a, void* b) {
	gboolean result;
	result = tracker_sparql_variable_equal (a, b);
	return result;
}


static void _vala_array_add6 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSourceLocation, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlContext* result = NULL;
	GError * _inner_error_;
	TrackerSparqlContext* _result_;
	gint filters_length1;
	gint _filters_size_;
	TrackerSourceLocation* _tmp5_;
	TrackerSourceLocation* _tmp4_ = NULL;
	TrackerSourceLocation* filters;
	gboolean in_triples_block;
	gboolean in_group_graph_pattern;
	gboolean first_where;
	gboolean found_simple_optional;
	glong group_graph_pattern_start;
	gboolean _tmp21_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_inner_error_ = NULL;
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
		TrackerSparqlSelectContext* _result_;
		GHashTable* *_tmp0_;
		GHashTable* _tmp1_;
		GHashTable* *_tmp2_;
		GHashTable* _tmp3_;
		_result_ = tracker_sparql_pattern_translate_select (self, sql, TRUE, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _result_);
		_tmp0_ = &tracker_sparql_pattern_get_context (self)->var_set;
		(*_tmp0_) = (_tmp1_ = _g_hash_table_ref0 (tracker_sparql_pattern_get_context (self)->select_var_set), _g_hash_table_unref0 ((*_tmp0_)), _tmp1_);
		_tmp2_ = &tracker_sparql_pattern_get_context (self)->select_var_set;
		(*_tmp2_) = (_tmp3_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, NULL), _g_hash_table_unref0 ((*_tmp2_)), _tmp3_);
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_set_context (self, tracker_sparql_pattern_get_context (self)->parent_context);
		result = (TrackerSparqlContext*) _result_;
		return result;
	}
	_result_ = tracker_sparql_context_new (self->priv->query, tracker_sparql_pattern_get_context (self));
	tracker_sparql_pattern_set_context (self, _result_);
	filters = (_tmp5_ = (_tmp4_ = g_new0 (TrackerSourceLocation, 0), _tmp4_), filters_length1 = 0, _filters_size_ = filters_length1, _tmp5_);
	in_triples_block = FALSE;
	in_group_graph_pattern = FALSE;
	first_where = TRUE;
	found_simple_optional = FALSE;
	group_graph_pattern_start = (glong) sql->len;
	tracker_sparql_pattern_parse_triples (self, sql, group_graph_pattern_start, &in_triples_block, &first_where, &in_group_graph_pattern, found_simple_optional, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp6_;
		_tmp6_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp6_) {
			gboolean _tmp7_ = FALSE;
			if (!in_group_graph_pattern) {
				_tmp7_ = tracker_sparql_pattern_is_simple_optional (self);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				char* _tmp8_;
				char* _tmp9_;
				found_simple_optional = TRUE;
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp8_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &self->priv->current_subject_is_var, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				self->priv->current_subject = (_tmp9_ = _tmp8_, _g_free0 (self->priv->current_subject), _tmp9_);
				tracker_sparql_pattern_parse_property_list_not_empty (self, sql, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			} else {
				gboolean _tmp10_ = FALSE;
				GString* select;
				gint left_index;
				gint right_index;
				TrackerSparqlContext* _tmp11_;
				TrackerSparqlContext* _tmp12_;
				gboolean first;
				gboolean first_common;
				if (!in_triples_block) {
					_tmp10_ = !in_group_graph_pattern;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					g_string_append (sql, "SELECT 1");
				} else {
					if (in_triples_block) {
						tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						in_triples_block = FALSE;
					}
				}
				if (!in_group_graph_pattern) {
					in_group_graph_pattern = TRUE;
				}
				select = g_string_new ("SELECT ");
				left_index = self->priv->next_table_index = self->priv->next_table_index + 1;
				right_index = self->priv->next_table_index = self->priv->next_table_index + 1;
				g_string_append_printf (sql, ") AS t%d_g LEFT JOIN (", left_index);
				_tmp11_ = tracker_sparql_pattern_translate_group_graph_pattern (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (select);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						_g_string_free0 (select);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tracker_sparql_pattern_set_context (self, _tmp12_ = _tmp11_);
				_tracker_sparql_context_unref0 (_tmp12_);
				g_string_append_printf (sql, ") AS t%d_g", right_index);
				first = TRUE;
				first_common = TRUE;
				{
					GList* v_collection;
					GList* v_it;
					v_collection = g_hash_table_get_keys (tracker_sparql_pattern_get_context (self)->var_set);
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
						TrackerSparqlVariable* v;
						v = (TrackerSparqlVariable*) v_it->data;
						{
							gint old_state;
							if (first) {
								first = FALSE;
							} else {
								g_string_append (select, ", ");
							}
							old_state = GPOINTER_TO_INT (g_hash_table_lookup (tracker_sparql_pattern_get_context (self)->parent_context->var_set, v));
							if (old_state == 0) {
								g_hash_table_insert (tracker_sparql_pattern_get_context (self)->parent_context->var_set, _g_object_ref0 (v), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL));
								g_string_append_printf (select, "t%d_g.%s", right_index, tracker_sparql_variable_get_sql_expression (v));
							} else {
								if (first_common) {
									g_string_append (sql, " ON ");
									first_common = FALSE;
								} else {
									g_string_append (sql, " AND ");
								}
								if (old_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND) {
									g_string_append_printf (sql, "t%d_g.%s = t%d_g.%s", left_index, tracker_sparql_variable_get_sql_expression (v), right_index, tracker_sparql_variable_get_sql_expression (v));
									g_string_append_printf (select, "t%d_g.%s", left_index, tracker_sparql_variable_get_sql_expression (v));
								} else {
									if (old_state == TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL) {
										g_string_append_printf (sql, "(t%d_g.%s IS NULL OR t%d_g.%s = t%d_g.%s)", left_index, tracker_sparql_variable_get_sql_expression (v), left_index, tracker_sparql_variable_get_sql_expression (v), right_index, tracker_sparql_variable_get_sql_expression (v));
										g_string_append_printf (select, "COALESCE (t%d_g.%s, t%d_g.%s) AS %s", left_index, tracker_sparql_variable_get_sql_expression (v), right_index, tracker_sparql_variable_get_sql_expression (v), tracker_sparql_variable_get_sql_expression (v));
									}
								}
							}
						}
					}
					_g_list_free0 (v_collection);
				}
				{
					GList* v_collection;
					GList* v_it;
					v_collection = g_hash_table_get_keys (tracker_sparql_pattern_get_context (self)->parent_context->var_set);
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
						TrackerSparqlVariable* v;
						v = (TrackerSparqlVariable*) v_it->data;
						{
							if (GPOINTER_TO_INT (g_hash_table_lookup (tracker_sparql_pattern_get_context (self)->var_set, v)) == 0) {
								if (first) {
									first = FALSE;
								} else {
									g_string_append (select, ", ");
								}
								g_string_append_printf (select, "t%d_g.%s", left_index, tracker_sparql_variable_get_sql_expression (v));
							}
						}
					}
					_g_list_free0 (v_collection);
				}
				if (first) {
					g_string_append (select, "1");
				}
				tracker_sparql_pattern_set_context (self, tracker_sparql_pattern_get_context (self)->parent_context);
				g_string_append (select, " FROM (");
				g_string_insert (sql, (gssize) group_graph_pattern_start, select->str);
				g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
				g_string_append (sql, ")");
				_g_string_free0 (select);
			}
		} else {
			gboolean _tmp13_;
			_tmp13_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp13_) {
				char* old_graph;
				gboolean old_graph_is_var;
				char* _tmp14_;
				char* _tmp15_;
				gboolean _tmp16_ = FALSE;
				char* _tmp17_;
				old_graph = g_strdup (self->priv->current_graph);
				old_graph_is_var = self->priv->current_graph_is_var;
				_tmp14_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &self->priv->current_graph_is_var, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						_g_free0 (old_graph);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				self->priv->current_graph = (_tmp15_ = _tmp14_, _g_free0 (self->priv->current_graph), _tmp15_);
				if (!in_triples_block) {
					_tmp16_ = !in_group_graph_pattern;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					in_group_graph_pattern = TRUE;
					g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					g_string_append (sql, ")");
				} else {
					if (in_triples_block) {
						tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_graph);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								_g_free0 (old_graph);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						in_triples_block = FALSE;
					}
					if (!in_group_graph_pattern) {
						in_group_graph_pattern = TRUE;
					}
					g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
					g_string_append (sql, ") NATURAL INNER JOIN (");
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					g_string_append (sql, ")");
				}
				self->priv->current_graph = (_tmp17_ = g_strdup (old_graph), _g_free0 (self->priv->current_graph), _tmp17_);
				self->priv->current_graph_is_var = old_graph_is_var;
				_g_free0 (old_graph);
			} else {
				if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE) {
					gboolean _tmp18_ = FALSE;
					if (!in_triples_block) {
						_tmp18_ = !in_group_graph_pattern;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						in_group_graph_pattern = TRUE;
						g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
						tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						g_string_append (sql, ")");
					} else {
						if (in_triples_block) {
							tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									filters = (g_free (filters), NULL);
									_tracker_sparql_context_unref0 (_result_);
									return NULL;
								} else {
									filters = (g_free (filters), NULL);
									_tracker_sparql_context_unref0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							in_triples_block = FALSE;
						}
						if (!in_group_graph_pattern) {
							in_group_graph_pattern = TRUE;
						}
						g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
						g_string_append (sql, ") NATURAL INNER JOIN (");
						tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						g_string_append (sql, ")");
					}
				} else {
					if (tracker_sparql_pattern_current (self) == TRACKER_SPARQL_TOKEN_TYPE_FILTER) {
						TrackerSourceLocation _tmp19_ = {0};
						TrackerSourceLocation _tmp20_;
						_vala_array_add6 (&filters, &filters_length1, &_filters_size_, (_tmp20_ = (tracker_sparql_pattern_get_location (self, &_tmp19_), _tmp19_), &_tmp20_));
						tracker_sparql_pattern_skip_filter (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					} else {
						break;
					}
				}
			}
		}
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_parse_triples (self, sql, group_graph_pattern_start, &in_triples_block, &first_where, &in_group_graph_pattern, found_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (!in_triples_block) {
		_tmp21_ = !in_group_graph_pattern;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		g_string_append (sql, "SELECT 1");
	} else {
		if (in_triples_block) {
			tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			in_triples_block = FALSE;
		}
	}
	if (in_group_graph_pattern) {
		first_where = TRUE;
	}
	if (filters_length1 > 0) {
		TrackerSourceLocation _tmp22_ = {0};
		TrackerSourceLocation end;
		end = (tracker_sparql_pattern_get_location (self, &_tmp22_), _tmp22_);
		{
			TrackerSourceLocation* filter_location_collection;
			int filter_location_collection_length1;
			int filter_location_it;
			filter_location_collection = filters;
			filter_location_collection_length1 = filters_length1;
			for (filter_location_it = 0; filter_location_it < filters_length1; filter_location_it = filter_location_it + 1) {
				TrackerSourceLocation filter_location;
				filter_location = filter_location_collection[filter_location_it];
				{
					if (!first_where) {
						g_string_append (sql, " AND ");
					} else {
						g_string_append (sql, " WHERE ");
						first_where = FALSE;
					}
					tracker_sparql_pattern_set_location (self, &filter_location);
					tracker_sparql_pattern_translate_filter (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
		}
		tracker_sparql_pattern_set_location (self, &end);
	}
	tracker_sparql_pattern_set_context (self, tracker_sparql_pattern_get_context (self)->parent_context);
	result = _result_;
	filters = (g_free (filters), NULL);
	return result;
}


static void _vala_array_add7 (glong** array, int* length, int* size, glong value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (glong, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add8 (TrackerSparqlContext*** array, int* length, int* size, TrackerSparqlContext* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlContext*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (TrackerSparqlVariable*** array, int* length, int* size, TrackerSparqlVariable* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlVariable*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
	return self ? tracker_sparql_context_ref (self) : NULL;
}


static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gint all_vars_length1;
	gint _all_vars_size_;
	TrackerSparqlVariable** _tmp1_;
	TrackerSparqlVariable** _tmp0_ = NULL;
	TrackerSparqlVariable** all_vars;
	GHashTable* all_var_set;
	gint contexts_length1;
	gint _contexts_size_;
	TrackerSparqlContext** _tmp3_;
	TrackerSparqlContext** _tmp2_ = NULL;
	TrackerSparqlContext** contexts;
	gint offsets_length1;
	gint _offsets_size_;
	glong* _tmp5_;
	glong* _tmp4_ = NULL;
	glong* offsets;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	all_vars = (_tmp1_ = (_tmp0_ = g_new0 (TrackerSparqlVariable*, 0 + 1), _tmp0_), all_vars_length1 = 0, _all_vars_size_ = all_vars_length1, _tmp1_);
	all_var_set = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, NULL);
	contexts = (_tmp3_ = (_tmp2_ = g_new0 (TrackerSparqlContext*, 0 + 1), _tmp2_), contexts_length1 = 0, _contexts_size_ = contexts_length1, _tmp3_);
	offsets = (_tmp5_ = (_tmp4_ = g_new0 (glong, 0), _tmp4_), offsets_length1 = 0, _offsets_size_ = offsets_length1, _tmp5_);
	{
		gboolean _tmp6_;
		_tmp6_ = TRUE;
		while (TRUE) {
			TrackerSparqlContext* _tmp8_;
			if (!_tmp6_) {
				gboolean _tmp7_;
				_tmp7_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_UNION, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						offsets = (g_free (offsets), NULL);
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
						_g_hash_table_unref0 (all_var_set);
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
						return;
					} else {
						offsets = (g_free (offsets), NULL);
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
						_g_hash_table_unref0 (all_var_set);
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (!_tmp7_) {
					break;
				}
			}
			_tmp6_ = FALSE;
			_vala_array_add7 (&offsets, &offsets_length1, &_offsets_size_, (glong) sql->len);
			_tmp8_ = tracker_sparql_pattern_translate_group_graph_pattern (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					offsets = (g_free (offsets), NULL);
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
					_g_hash_table_unref0 (all_var_set);
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
					return;
				} else {
					offsets = (g_free (offsets), NULL);
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
					_g_hash_table_unref0 (all_var_set);
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_vala_array_add8 (&contexts, &contexts_length1, &_contexts_size_, _tmp8_);
		}
	}
	if (contexts_length1 > 1) {
		glong extra_offset;
		{
			TrackerSparqlContext** sub_context_collection;
			int sub_context_collection_length1;
			int sub_context_it;
			sub_context_collection = contexts;
			sub_context_collection_length1 = contexts_length1;
			for (sub_context_it = 0; sub_context_it < contexts_length1; sub_context_it = sub_context_it + 1) {
				TrackerSparqlContext* sub_context;
				sub_context = _tracker_sparql_context_ref0 (sub_context_collection[sub_context_it]);
				{
					{
						GList* v_collection;
						GList* v_it;
						v_collection = g_hash_table_get_keys (sub_context->var_set);
						for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
							TrackerSparqlVariable* v;
							v = (TrackerSparqlVariable*) v_it->data;
							{
								if (GPOINTER_TO_INT (g_hash_table_lookup (all_var_set, v)) == 0) {
									_vala_array_add9 (&all_vars, &all_vars_length1, &_all_vars_size_, _g_object_ref0 (v));
									g_hash_table_insert (all_var_set, _g_object_ref0 (v), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
									g_hash_table_insert (tracker_sparql_pattern_get_context (self)->var_set, _g_object_ref0 (v), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
								}
							}
						}
						_g_list_free0 (v_collection);
					}
					_tracker_sparql_context_unref0 (sub_context);
				}
			}
		}
		extra_offset = (glong) 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					GString* projection;
					if (!_tmp9_) {
						i++;
					}
					_tmp9_ = FALSE;
					if (!(i < contexts_length1)) {
						break;
					}
					projection = g_string_new ("");
					if (i > 0) {
						g_string_append (projection, ") UNION ALL ");
					}
					g_string_append (projection, "SELECT ");
					{
						TrackerSparqlVariable** v_collection;
						int v_collection_length1;
						int v_it;
						v_collection = all_vars;
						v_collection_length1 = all_vars_length1;
						for (v_it = 0; v_it < all_vars_length1; v_it = v_it + 1) {
							TrackerSparqlVariable* v;
							v = _g_object_ref0 (v_collection[v_it]);
							{
								if (GPOINTER_TO_INT (g_hash_table_lookup (contexts[i]->var_set, v)) == 0) {
									g_string_append (projection, "NULL AS ");
								}
								g_string_append_printf (projection, "%s, ", tracker_sparql_variable_get_sql_expression (v));
								_g_object_unref0 (v);
							}
						}
					}
					g_string_truncate (projection, (gsize) (projection->len - 2));
					g_string_append (projection, " FROM (");
					g_string_insert (sql, (gssize) (offsets[i] + extra_offset), projection->str);
					extra_offset = extra_offset + ((glong) projection->len);
					_g_string_free0 (projection);
				}
			}
		}
		g_string_append (sql, ")");
	} else {
		{
			GList* key_collection;
			GList* key_it;
			key_collection = g_hash_table_get_keys (contexts[0]->var_set);
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				TrackerSparqlVariable* key;
				key = (TrackerSparqlVariable*) key_it->data;
				{
					g_hash_table_insert (tracker_sparql_pattern_get_context (self)->var_set, _g_object_ref0 (key), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
				}
			}
			_g_list_free0 (key_collection);
		}
	}
	offsets = (g_free (offsets), NULL);
	contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
	_g_hash_table_unref0 (all_var_set);
	all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
}


static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable) {
	TrackerSparqlVariableBindingList* result = NULL;
	TrackerSparqlVariableBindingList* binding_list;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable != NULL, NULL);
	binding_list = NULL;
	if (self->priv->triple_context != NULL) {
		TrackerSparqlVariableBindingList* _tmp0_;
		binding_list = (_tmp0_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) g_hash_table_lookup (self->priv->triple_context->var_bindings, variable)), _g_object_unref0 (binding_list), _tmp0_);
	}
	if (binding_list == NULL) {
		_tmp1_ = variable->binding != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		TrackerSparqlContext* current_context;
		current_context = _tracker_sparql_context_ref0 (tracker_sparql_pattern_get_context (self));
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			TrackerSparqlContext* _tmp5_;
			if (!(current_context != NULL)) {
				break;
			}
			if (current_context->scalar_subquery) {
				_tmp2_ = GPOINTER_TO_INT (g_hash_table_lookup (current_context->parent_context->var_set, variable)) != 0;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				TrackerSparqlVariableBinding* binding;
				TrackerClass* _tmp3_;
				TrackerSparqlVariableBindingList* _tmp4_;
				binding = tracker_sparql_variable_binding_new ();
				((TrackerSparqlDataBinding*) binding)->data_type = ((TrackerSparqlDataBinding*) variable->binding)->data_type;
				binding->variable = tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), tracker_sparql_variable_get_name (variable));
				binding->type = (_tmp3_ = _g_object_ref0 (variable->binding->type), _g_object_unref0 (binding->type), _tmp3_);
				tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) binding, tracker_sparql_variable_get_sql_expression (variable));
				binding_list = (_tmp4_ = tracker_sparql_variable_binding_list_new (), _g_object_unref0 (binding_list), _tmp4_);
				if (self->priv->triple_context != NULL) {
					self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _g_object_ref0 (variable));
					g_hash_table_insert (self->priv->triple_context->var_bindings, _g_object_ref0 (variable), _g_object_ref0 (binding_list));
				}
				g_hash_table_insert (tracker_sparql_pattern_get_context (self)->var_set, _g_object_ref0 (variable), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
				binding_list->list = g_list_append (binding_list->list, _g_object_ref0 (binding));
				_g_object_unref0 (binding);
				break;
			}
			current_context = (_tmp5_ = _tracker_sparql_context_ref0 (current_context->parent_context), _tracker_sparql_context_unref0 (current_context), _tmp5_);
		}
		_tracker_sparql_context_unref0 (current_context);
	}
	result = binding_list;
	return result;
}


void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state) {
	TrackerSparqlVariableBindingList* binding_list;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_return_if_fail (binding != NULL);
	binding_list = tracker_sparql_pattern_get_variable_binding_list (self, binding->variable);
	if (binding_list == NULL) {
		TrackerSparqlVariableBindingList* _tmp0_;
		binding_list = (_tmp0_ = tracker_sparql_variable_binding_list_new (), _g_object_unref0 (binding_list), _tmp0_);
		if (self->priv->triple_context != NULL) {
			self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _g_object_ref0 (binding->variable));
			g_hash_table_insert (self->priv->triple_context->var_bindings, _g_object_ref0 (binding->variable), _g_object_ref0 (binding_list));
		}
		g_string_append_printf (sql, "%s AS %s, ", tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding), tracker_sparql_variable_get_sql_expression (binding->variable));
		if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_DATETIME) {
			char* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			char* _tmp4_;
			g_string_append_printf (sql, "%s AS %s, ", _tmp1_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) binding, "localDate"), _tmp2_ = tracker_sparql_variable_get_extra_sql_expression (binding->variable, "localDate"));
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
			g_string_append_printf (sql, "%s AS %s, ", _tmp3_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) binding, "localTime"), _tmp4_ = tracker_sparql_variable_get_extra_sql_expression (binding->variable, "localTime"));
			_g_free0 (_tmp4_);
			_g_free0 (_tmp3_);
		}
		g_hash_table_insert (tracker_sparql_pattern_get_context (self)->var_set, _g_object_ref0 (binding->variable), GINT_TO_POINTER ((gint) variable_state));
	}
	binding_list->list = g_list_append (binding_list->list, _g_object_ref0 (binding));
	if (binding->variable->binding == NULL) {
		TrackerSparqlVariableBinding* _tmp5_;
		binding->variable->binding = (_tmp5_ = _g_object_ref0 (binding), _g_object_unref0 (binding->variable->binding), _tmp5_);
	}
	_g_object_unref0 (binding_list);
}


static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_;
	glong begin_sql_len;
	gboolean object_is_var = FALSE;
	char* object;
	char* db_table;
	gboolean rdftype;
	gboolean share_table;
	gboolean is_fts_match;
	gboolean newtable = FALSE;
	TrackerSparqlDataTable* table;
	TrackerProperty* prop;
	TrackerClass* subject_type;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	begin_sql_len = (glong) sql->len;
	object = tracker_sparql_pattern_parse_var_or_term (self, sql, &object_is_var, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	db_table = NULL;
	rdftype = FALSE;
	share_table = TRUE;
	is_fts_match = FALSE;
	table = NULL;
	prop = NULL;
	subject_type = NULL;
	if (!self->priv->current_predicate_is_var) {
		TrackerProperty* _tmp0_;
		gboolean _tmp1_ = FALSE;
		TrackerSparqlDataTable* _tmp22_;
		prop = (_tmp0_ = _g_object_ref0 (tracker_ontologies_get_property_by_uri (self->priv->current_predicate)), _g_object_unref0 (prop), _tmp0_);
		if (_vala_strcmp0 (self->priv->current_predicate, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type") == 0) {
			_tmp1_ = !object_is_var;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			TrackerClass* cl;
			char* _tmp4_;
			TrackerClass* _tmp5_;
			rdftype = TRUE;
			cl = _g_object_ref0 (tracker_ontologies_get_class_by_uri (object));
			if (cl == NULL) {
				char* _tmp2_;
				GError* _tmp3_;
				_inner_error_ = (_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp2_ = g_strdup_printf ("Unknown class `%s'", object)), _g_free0 (_tmp2_), _tmp3_);
				{
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (cl);
						_g_object_unref0 (subject_type);
						_g_object_unref0 (prop);
						_g_object_unref0 (table);
						_g_free0 (db_table);
						_g_free0 (object);
						return;
					} else {
						_g_object_unref0 (cl);
						_g_object_unref0 (subject_type);
						_g_object_unref0 (prop);
						_g_object_unref0 (table);
						_g_free0 (db_table);
						_g_free0 (object);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			db_table = (_tmp4_ = g_strdup (tracker_class_get_name (cl)), _g_free0 (db_table), _tmp4_);
			subject_type = (_tmp5_ = _g_object_ref0 (cl), _g_object_unref0 (subject_type), _tmp5_);
			_g_object_unref0 (cl);
		} else {
			if (prop == NULL) {
				if (_vala_strcmp0 (self->priv->current_predicate, "http://www.tracker-project.org/ontologies/fts#match") == 0) {
					char* _tmp6_;
					db_table = (_tmp6_ = g_strdup ("fts"), _g_free0 (db_table), _tmp6_);
					share_table = FALSE;
					is_fts_match = TRUE;
				} else {
					char* _tmp7_;
					GError* _tmp8_;
					_inner_error_ = (_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, _tmp7_ = g_strdup_printf ("Unknown property `%s'", self->priv->current_predicate)), _g_free0 (_tmp7_), _tmp8_);
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_type);
							_g_object_unref0 (prop);
							_g_object_unref0 (table);
							_g_free0 (db_table);
							_g_free0 (object);
							return;
						} else {
							_g_object_unref0 (subject_type);
							_g_object_unref0 (prop);
							_g_object_unref0 (table);
							_g_free0 (db_table);
							_g_free0 (object);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			} else {
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				TrackerClass* _tmp19_;
				gboolean _tmp20_ = FALSE;
				if (_vala_strcmp0 (self->priv->current_predicate, "http://www.w3.org/2000/01/rdf-schema#domain") == 0) {
					_tmp10_ = self->priv->current_subject_is_var;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_tmp9_ = !object_is_var;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					TrackerClass* domain;
					TrackerSparqlPredicateVariable* pv;
					TrackerClass* _tmp14_;
					domain = _g_object_ref0 (tracker_ontologies_get_class_by_uri (object));
					if (domain == NULL) {
						char* _tmp11_;
						GError* _tmp12_;
						_inner_error_ = (_tmp12_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp11_ = g_strdup_printf ("Unknown class `%s'", object)), _g_free0 (_tmp11_), _tmp12_);
						{
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (domain);
								_g_object_unref0 (subject_type);
								_g_object_unref0 (prop);
								_g_object_unref0 (table);
								_g_free0 (db_table);
								_g_free0 (object);
								return;
							} else {
								_g_object_unref0 (domain);
								_g_object_unref0 (subject_type);
								_g_object_unref0 (prop);
								_g_object_unref0 (table);
								_g_free0 (db_table);
								_g_free0 (object);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
					pv = _g_object_ref0 ((TrackerSparqlPredicateVariable*) g_hash_table_lookup (tracker_sparql_pattern_get_context (self)->predicate_variable_map, tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_subject)));
					if (pv == NULL) {
						TrackerSparqlPredicateVariable* _tmp13_;
						pv = (_tmp13_ = tracker_sparql_predicate_variable_new (), _g_object_unref0 (pv), _tmp13_);
						g_hash_table_insert (tracker_sparql_pattern_get_context (self)->predicate_variable_map, _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_subject)), _g_object_ref0 (pv));
					}
					pv->domain = (_tmp14_ = _g_object_ref0 (domain), _g_object_unref0 (pv->domain), _tmp14_);
					_g_object_unref0 (pv);
					_g_object_unref0 (domain);
				}
				if (self->priv->current_subject_is_var) {
					TrackerSparqlVariable* v;
					TrackerSparqlVariableBindingList* list;
					gboolean _tmp15_ = FALSE;
					v = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_subject));
					list = _g_object_ref0 ((TrackerSparqlVariableBindingList*) g_hash_table_lookup (self->priv->triple_context->var_bindings, v));
					if (list != NULL) {
						_tmp15_ = list->list != NULL;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						gboolean stop;
						stop = FALSE;
						{
							TrackerClass** _tmp16_;
							TrackerClass** cl_collection;
							int cl_collection_length1;
							int cl_it;
							cl_collection = _tmp16_ = tracker_property_get_domain_indexes (prop);
							cl_collection_length1 = _vala_array_length (_tmp16_);
							for (cl_it = 0; cl_it < _vala_array_length (_tmp16_); cl_it = cl_it + 1) {
								TrackerClass* cl;
								cl = _g_object_ref0 (cl_collection[cl_it]);
								{
									{
										GList* b_collection;
										GList* b_it;
										b_collection = list->list;
										for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
											TrackerSparqlVariableBinding* b;
											b = _g_object_ref0 ((TrackerSparqlVariableBinding*) b_it->data);
											{
												if (b->type == cl) {
													char* _tmp17_;
													db_table = (_tmp17_ = g_strdup (tracker_class_get_name (cl)), _g_free0 (db_table), _tmp17_);
													stop = TRUE;
													_g_object_unref0 (b);
													break;
												}
												_g_object_unref0 (b);
											}
										}
									}
									if (stop) {
										_g_object_unref0 (cl);
										break;
									}
									_g_object_unref0 (cl);
								}
							}
						}
					}
					_g_object_unref0 (list);
					_g_object_unref0 (v);
				}
				if (db_table == NULL) {
					char* _tmp18_;
					db_table = (_tmp18_ = g_strdup (tracker_property_get_table_name (prop)), _g_free0 (db_table), _tmp18_);
				}
				if (tracker_property_get_multiple_values (prop)) {
					share_table = FALSE;
				}
				subject_type = (_tmp19_ = _g_object_ref0 (tracker_property_get_domain (prop)), _g_object_unref0 (subject_type), _tmp19_);
				if (in_simple_optional) {
					_tmp20_ = GPOINTER_TO_INT (g_hash_table_lookup (tracker_sparql_pattern_get_context (self)->var_set, tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_subject))) == 0;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					TrackerSparqlVariableBinding* binding;
					TrackerSparqlVariableBindingList* binding_list;
					TrackerSparqlVariableBinding* object_binding;
					TrackerSparqlVariableBinding* _tmp21_;
					binding = tracker_sparql_variable_binding_new ();
					((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
					binding->variable = tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_subject);
					g_assert (((TrackerSparqlVariableBindingList*) g_hash_table_lookup (self->priv->triple_context->var_bindings, binding->variable)) == NULL);
					binding_list = tracker_sparql_variable_binding_list_new ();
					self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _g_object_ref0 (binding->variable));
					g_hash_table_insert (self->priv->triple_context->var_bindings, _g_object_ref0 (binding->variable), _g_object_ref0 (binding_list));
					object_binding = _g_object_ref0 ((TrackerSparqlVariableBinding*) ((TrackerSparqlVariableBindingList*) g_hash_table_lookup (self->priv->triple_context->var_bindings, tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), object)))->list->data);
					g_string_append_printf (sql, "(SELECT ID FROM \"%s\" WHERE \"%s\" = %s) AS %s, ", db_table, tracker_property_get_name (prop), tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) object_binding), tracker_sparql_variable_get_sql_expression (binding->variable));
					g_hash_table_insert (tracker_sparql_pattern_get_context (self)->var_set, _g_object_ref0 (binding->variable), GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL));
					binding_list->list = g_list_append (binding_list->list, _g_object_ref0 (binding));
					g_assert (binding->variable->binding == NULL);
					binding->variable->binding = (_tmp21_ = _g_object_ref0 (binding), _g_object_unref0 (binding->variable->binding), _tmp21_);
					_g_object_unref0 (object_binding);
					_g_object_unref0 (binding_list);
					_g_object_unref0 (binding);
					_g_object_unref0 (subject_type);
					_g_object_unref0 (prop);
					_g_object_unref0 (table);
					_g_free0 (db_table);
					_g_free0 (object);
					return;
				}
			}
		}
		table = (_tmp22_ = tracker_sparql_pattern_get_table (self, self->priv->current_subject, db_table, share_table, &newtable), _g_object_unref0 (table), _tmp22_);
	} else {
		TrackerSparqlDataTable* _tmp23_;
		TrackerSparqlPredicateVariable* _tmp24_;
		char* _tmp28_;
		char* _tmp29_;
		TrackerSparqlVariableBinding* binding;
		TrackerSparqlDataTable* _tmp30_;
		char* _tmp31_;
		newtable = TRUE;
		table = (_tmp23_ = tracker_sparql_data_table_new (), _g_object_unref0 (table), _tmp23_);
		table->predicate_variable = (_tmp24_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) g_hash_table_lookup (tracker_sparql_pattern_get_context (self)->predicate_variable_map, tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_predicate))), _g_object_unref0 (table->predicate_variable), _tmp24_);
		if (table->predicate_variable == NULL) {
			TrackerSparqlPredicateVariable* _tmp25_;
			table->predicate_variable = (_tmp25_ = tracker_sparql_predicate_variable_new (), _g_object_unref0 (table->predicate_variable), _tmp25_);
			g_hash_table_insert (tracker_sparql_pattern_get_context (self)->predicate_variable_map, _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_predicate)), _g_object_ref0 (table->predicate_variable));
		}
		if (!self->priv->current_subject_is_var) {
			char* _tmp26_;
			table->predicate_variable->subject = (_tmp26_ = g_strdup (self->priv->current_subject), _g_free0 (table->predicate_variable->subject), _tmp26_);
		}
		if (!object_is_var) {
			char* _tmp27_;
			table->predicate_variable->object = (_tmp27_ = g_strdup (object), _g_free0 (table->predicate_variable->object), _tmp27_);
		}
		if (self->priv->current_graph != NULL) {
			table->predicate_variable->return_graph = TRUE;
		}
		table->sql_query_tablename = (_tmp29_ = g_strconcat (self->priv->current_predicate, _tmp28_ = g_strdup_printf ("%i", self->priv->counter = self->priv->counter + 1), NULL), _g_free0 (table->sql_query_tablename), _tmp29_);
		_g_free0 (_tmp28_);
		self->priv->triple_context->tables = g_list_append (self->priv->triple_context->tables, _g_object_ref0 (table));
		binding = tracker_sparql_variable_binding_new ();
		((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
		binding->variable = tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_predicate);
		((TrackerSparqlDataBinding*) binding)->table = (_tmp30_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table), _tmp30_);
		((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp31_ = g_strdup ("predicate"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp31_);
		tracker_sparql_pattern_add_variable_binding (self, sql, binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
		_g_object_unref0 (binding);
	}
	if (newtable) {
		if (self->priv->current_subject_is_var) {
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlDataTable* _tmp32_;
			TrackerClass* _tmp33_;
			binding = tracker_sparql_variable_binding_new ();
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
			binding->variable = tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_subject);
			((TrackerSparqlDataBinding*) binding)->table = (_tmp32_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table), _tmp32_);
			binding->type = (_tmp33_ = _g_object_ref0 (subject_type), _g_object_unref0 (binding->type), _tmp33_);
			if (is_fts_match) {
				char* _tmp34_;
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp34_ = g_strdup ("rowid"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp34_);
			} else {
				char* _tmp35_;
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp35_ = g_strdup ("ID"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp35_);
			}
			tracker_sparql_pattern_add_variable_binding (self, sql, binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
			_g_object_unref0 (binding);
		} else {
			TrackerSparqlLiteralBinding* binding;
			char* _tmp36_;
			TrackerSparqlDataTable* _tmp37_;
			char* _tmp38_;
			binding = tracker_sparql_literal_binding_new ();
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
			binding->literal = (_tmp36_ = g_strdup (self->priv->current_subject), _g_free0 (binding->literal), _tmp36_);
			((TrackerSparqlDataBinding*) binding)->table = (_tmp37_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table), _tmp37_);
			((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp38_ = g_strdup ("ID"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp38_);
			self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _g_object_ref0 (binding));
			_g_object_unref0 (binding);
		}
	}
	if (!rdftype) {
		if (object_is_var) {
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlDataTable* _tmp39_;
			TrackerSparqlVariableState state = 0;
			binding = tracker_sparql_variable_binding_new ();
			binding->variable = tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), object);
			((TrackerSparqlDataBinding*) binding)->table = (_tmp39_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table), _tmp39_);
			if (prop != NULL) {
				TrackerClass* _tmp40_;
				char* _tmp41_;
				binding->type = (_tmp40_ = _g_object_ref0 (tracker_property_get_range (prop)), _g_object_unref0 (binding->type), _tmp40_);
				((TrackerSparqlDataBinding*) binding)->data_type = tracker_property_get_data_type (prop);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp41_ = g_strdup (tracker_property_get_name (prop)), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp41_);
				if (!tracker_property_get_multiple_values (prop)) {
					binding->maybe_null = TRUE;
					binding->in_simple_optional = in_simple_optional;
				}
			} else {
				char* _tmp42_;
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp42_ = g_strdup ("object"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp42_);
				binding->maybe_null = TRUE;
			}
			if (in_simple_optional) {
				state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
			} else {
				state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
			}
			tracker_sparql_pattern_add_variable_binding (self, sql, binding, state);
			_g_object_unref0 (binding);
		} else {
			if (is_fts_match) {
				TrackerSparqlLiteralBinding* binding;
				char* _tmp43_;
				TrackerSparqlDataTable* _tmp44_;
				char* _tmp45_;
				binding = tracker_sparql_literal_binding_new ();
				binding->is_fts_match = TRUE;
				binding->literal = (_tmp43_ = g_strdup (object), _g_free0 (binding->literal), _tmp43_);
				((TrackerSparqlDataBinding*) binding)->table = (_tmp44_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table), _tmp44_);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp45_ = g_strdup ("fts"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp45_);
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _g_object_ref0 (binding));
				g_string_append_printf (sql, "rank(\"%s\".\"fts\") AS \"%s_u_rank\", ", ((TrackerSparqlDataBinding*) binding)->table->sql_query_tablename, tracker_sparql_variable_get_name (tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_subject)));
				g_string_append_printf (sql, "offsets(\"%s\".\"fts\") AS \"%s_u_offsets\", ", ((TrackerSparqlDataBinding*) binding)->table->sql_query_tablename, tracker_sparql_variable_get_name (tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_subject)));
				_g_object_unref0 (binding);
			} else {
				TrackerSparqlLiteralBinding* binding;
				char* _tmp46_;
				TrackerSparqlDataTable* _tmp47_;
				binding = tracker_sparql_literal_binding_new ();
				binding->literal = (_tmp46_ = g_strdup (object), _g_free0 (binding->literal), _tmp46_);
				((TrackerSparqlDataBinding*) binding)->table = (_tmp47_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table), _tmp47_);
				if (prop != NULL) {
					char* _tmp48_;
					((TrackerSparqlDataBinding*) binding)->data_type = tracker_property_get_data_type (prop);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp48_ = g_strdup (tracker_property_get_name (prop)), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp48_);
				} else {
					char* _tmp49_;
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp49_ = g_strdup ("object"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp49_);
				}
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _g_object_ref0 (binding));
				_g_object_unref0 (binding);
			}
		}
		if (self->priv->current_graph != NULL) {
			if (self->priv->current_graph_is_var) {
				TrackerSparqlVariableBinding* binding;
				TrackerSparqlDataTable* _tmp50_;
				TrackerSparqlVariableState state = 0;
				binding = tracker_sparql_variable_binding_new ();
				binding->variable = tracker_sparql_context_get_variable (tracker_sparql_pattern_get_context (self), self->priv->current_graph);
				((TrackerSparqlDataBinding*) binding)->table = (_tmp50_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table), _tmp50_);
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
				if (prop != NULL) {
					char* _tmp51_;
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp51_ = g_strconcat (tracker_property_get_name (prop), ":graph", NULL), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp51_);
				} else {
					char* _tmp52_;
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp52_ = g_strdup ("graph"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp52_);
				}
				binding->maybe_null = TRUE;
				binding->in_simple_optional = in_simple_optional;
				if (in_simple_optional) {
					state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
				} else {
					state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
				}
				tracker_sparql_pattern_add_variable_binding (self, sql, binding, state);
				_g_object_unref0 (binding);
			} else {
				TrackerSparqlLiteralBinding* binding;
				char* _tmp53_;
				TrackerSparqlDataTable* _tmp54_;
				binding = tracker_sparql_literal_binding_new ();
				binding->literal = (_tmp53_ = g_strdup (self->priv->current_graph), _g_free0 (binding->literal), _tmp53_);
				((TrackerSparqlDataBinding*) binding)->table = (_tmp54_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table), _tmp54_);
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
				if (prop != NULL) {
					char* _tmp55_;
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp55_ = g_strconcat (tracker_property_get_name (prop), ":graph", NULL), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp55_);
				} else {
					char* _tmp56_;
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = (_tmp56_ = g_strdup ("graph"), _g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name), _tmp56_);
				}
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _g_object_ref0 (binding));
				_g_object_unref0 (binding);
			}
		}
	}
	if (sql->len == begin_sql_len) {
		g_string_append (sql, "1, ");
	}
	_g_object_unref0 (subject_type);
	_g_object_unref0 (prop);
	_g_object_unref0 (table);
	_g_free0 (db_table);
	_g_free0 (object);
}


static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const char* subject, const char* db_table, gboolean share_table, gboolean* newtable) {
	TrackerSparqlDataTable* result = NULL;
	char* tablestring;
	TrackerSparqlDataTable* table;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subject != NULL, NULL);
	g_return_val_if_fail (db_table != NULL, NULL);
	tablestring = g_strdup_printf ("%s.%s", subject, db_table);
	table = NULL;
	*newtable = FALSE;
	if (share_table) {
		TrackerSparqlDataTable* _tmp0_;
		table = (_tmp0_ = _g_object_ref0 ((TrackerSparqlDataTable*) g_hash_table_lookup (self->priv->triple_context->table_map, tablestring)), _g_object_unref0 (table), _tmp0_);
	}
	if (table == NULL) {
		TrackerSparqlDataTable* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
		*newtable = TRUE;
		table = (_tmp1_ = tracker_sparql_data_table_new (), _g_object_unref0 (table), _tmp1_);
		table->sql_db_tablename = (_tmp2_ = g_strdup (db_table), _g_free0 (table->sql_db_tablename), _tmp2_);
		table->sql_query_tablename = (_tmp4_ = g_strconcat (db_table, _tmp3_ = g_strdup_printf ("%i", self->priv->counter = self->priv->counter + 1), NULL), _g_free0 (table->sql_query_tablename), _tmp4_);
		_g_free0 (_tmp3_);
		self->priv->triple_context->tables = g_list_append (self->priv->triple_context->tables, _g_object_ref0 (table));
		g_hash_table_insert (self->priv->triple_context->table_map, g_strdup (tablestring), _g_object_ref0 (table));
	}
	result = table;
	_g_free0 (tablestring);
	return result;
}


static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self) {
	TrackerSparqlContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->context;
	return result;
}


static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value) {
	TrackerSparqlContext* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->query->context = (_tmp0_ = _tracker_sparql_context_ref0 (value), _tracker_sparql_context_unref0 (self->priv->query->context), _tmp0_);
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlPatternTripleContext* self;
	GList* _tmp0_;
	GHashTable* _tmp1_;
	GList* _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	g_return_val_if_fail (query != NULL, NULL);
	g_return_val_if_fail (parent_context != NULL, NULL);
	self = (TrackerSparqlPatternTripleContext*) tracker_sparql_context_construct (object_type, query, parent_context);
	self->tables = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->tables), _tmp0_);
	self->table_map = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->table_map), _tmp1_);
	self->variables = (_tmp2_ = NULL, __g_list_free_g_object_unref0 (self->variables), _tmp2_);
	self->var_bindings = (_tmp3_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, g_object_unref), _g_hash_table_unref0 (self->var_bindings), _tmp3_);
	self->bindings = (_tmp4_ = NULL, __g_list_free_g_object_unref0 (self->bindings), _tmp4_);
	return self;
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	return tracker_sparql_pattern_triple_context_construct (TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, query, parent_context);
}


static void tracker_sparql_pattern_triple_context_class_init (TrackerSparqlPatternTripleContextClass * klass) {
	tracker_sparql_pattern_triple_context_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONTEXT_CLASS (klass)->finalize = tracker_sparql_pattern_triple_context_finalize;
}


static void tracker_sparql_pattern_triple_context_instance_init (TrackerSparqlPatternTripleContext * self) {
}


static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlPatternTripleContext * self;
	self = TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT (obj);
	__g_list_free_g_object_unref0 (self->tables);
	_g_hash_table_unref0 (self->table_map);
	__g_list_free_g_object_unref0 (self->bindings);
	__g_list_free_g_object_unref0 (self->variables);
	_g_hash_table_unref0 (self->var_bindings);
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_pattern_triple_context_parent_class)->finalize (obj);
}


static GType tracker_sparql_pattern_triple_context_get_type (void) {
	static volatile gsize tracker_sparql_pattern_triple_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_triple_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternTripleContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_triple_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPatternTripleContext), 0, (GInstanceInitFunc) tracker_sparql_pattern_triple_context_instance_init, NULL };
		GType tracker_sparql_pattern_triple_context_type_id;
		tracker_sparql_pattern_triple_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlPatternTripleContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_triple_context_type_id__volatile, tracker_sparql_pattern_triple_context_type_id);
	}
	return tracker_sparql_pattern_triple_context_type_id__volatile;
}


static void tracker_sparql_pattern_class_init (TrackerSparqlPatternClass * klass) {
	tracker_sparql_pattern_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlPatternPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_sparql_pattern_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_sparql_pattern_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_pattern_finalize;
}


static void tracker_sparql_pattern_instance_init (TrackerSparqlPattern * self) {
	self->priv = TRACKER_SPARQL_PATTERN_GET_PRIVATE (self);
}


static void tracker_sparql_pattern_finalize (GObject* obj) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (obj);
	_g_free0 (self->priv->current_graph);
	_g_free0 (self->priv->current_subject);
	_g_free0 (self->priv->current_predicate);
	_tracker_sparql_context_unref0 (self->priv->triple_context);
	G_OBJECT_CLASS (tracker_sparql_pattern_parent_class)->finalize (obj);
}


GType tracker_sparql_pattern_get_type (void) {
	static volatile gsize tracker_sparql_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPattern), 0, (GInstanceInitFunc) tracker_sparql_pattern_instance_init, NULL };
		GType tracker_sparql_pattern_type_id;
		tracker_sparql_pattern_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPattern", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_type_id__volatile, tracker_sparql_pattern_type_id);
	}
	return tracker_sparql_pattern_type_id__volatile;
}


static void tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




