/* tracker-cursor.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from tracker-cursor.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * SECTION: tracker-sparql-cursor
 * @short_description: Iteration of the query results
 * @title: TrackerSparqlCursor
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <para>
 * #TrackerSparqlCursor is an object which provides methods to iterate the
 * results of a query to the Tracker Store.
 * </para>
 */
/**
 * tracker_sparql_cursor_next_async:
 * @self: a #TrackerSparqlCursor
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 * @cancellable: a #GCancellable used to cancel the operation
 *
 * Iterates, asynchronously, to the next result.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TRACKER_SPARQL_TYPE_CURSOR (tracker_sparql_cursor_get_type ())
#define TRACKER_SPARQL_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor))
#define TRACKER_SPARQL_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))
#define TRACKER_SPARQL_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))

typedef struct _TrackerSparqlCursor TrackerSparqlCursor;
typedef struct _TrackerSparqlCursorClass TrackerSparqlCursorClass;
typedef struct _TrackerSparqlCursorPrivate TrackerSparqlCursorPrivate;

#define TRACKER_SPARQL_TYPE_CONNECTION (tracker_sparql_connection_get_type ())
#define TRACKER_SPARQL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection))
#define TRACKER_SPARQL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))
#define TRACKER_SPARQL_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))

typedef struct _TrackerSparqlConnection TrackerSparqlConnection;
typedef struct _TrackerSparqlConnectionClass TrackerSparqlConnectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TrackerSparqlCursor {
	GObject parent_instance;
	TrackerSparqlCursorPrivate * priv;
};

struct _TrackerSparqlCursorClass {
	GObjectClass parent_class;
	const char* (*get_string) (TrackerSparqlCursor* self, gint column, glong* length);
	gboolean (*next) (TrackerSparqlCursor* self, GCancellable* cancellable, GError** error);
	void (*next_async) (TrackerSparqlCursor* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*next_finish) (TrackerSparqlCursor* self, GAsyncResult* _res_, GError** error);
	void (*rewind) (TrackerSparqlCursor* self);
	gint (*get_n_columns) (TrackerSparqlCursor* self);
};

struct _TrackerSparqlCursorPrivate {
	TrackerSparqlConnection* _connection;
};


static gpointer tracker_sparql_cursor_parent_class = NULL;

GType tracker_sparql_cursor_get_type (void) G_GNUC_CONST;
GType tracker_sparql_connection_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_CURSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorPrivate))
enum  {
	TRACKER_SPARQL_CURSOR_DUMMY_PROPERTY,
	TRACKER_SPARQL_CURSOR_CONNECTION,
	TRACKER_SPARQL_CURSOR_N_COLUMNS
};
const char* tracker_sparql_cursor_get_string (TrackerSparqlCursor* self, gint column, glong* length);
static const char* tracker_sparql_cursor_real_get_string (TrackerSparqlCursor* self, gint column, glong* length);
gboolean tracker_sparql_cursor_next (TrackerSparqlCursor* self, GCancellable* cancellable, GError** error);
static gboolean tracker_sparql_cursor_real_next (TrackerSparqlCursor* self, GCancellable* cancellable, GError** error);
void tracker_sparql_cursor_next_async (TrackerSparqlCursor* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean tracker_sparql_cursor_next_finish (TrackerSparqlCursor* self, GAsyncResult* _res_, GError** error);
void tracker_sparql_cursor_rewind (TrackerSparqlCursor* self);
static void tracker_sparql_cursor_real_rewind (TrackerSparqlCursor* self);
TrackerSparqlCursor* tracker_sparql_cursor_construct (GType object_type);
TrackerSparqlConnection* tracker_sparql_cursor_get_connection (TrackerSparqlCursor* self);
void tracker_sparql_cursor_set_connection (TrackerSparqlCursor* self, TrackerSparqlConnection* value);
gint tracker_sparql_cursor_get_n_columns (TrackerSparqlCursor* self);
static void tracker_sparql_cursor_finalize (GObject* obj);
static void tracker_sparql_cursor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_sparql_cursor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * tracker_sparql_cursor_get_string:
 * @self: a #TrackerSparqlCursor
 * @column: column number to retrieve (first one is 0)
 * @length: length of the returned string
 *
 * Returns the string at @column in the current row being iterated.
 *
 * Returns: a string, which should not be freed by the caller. #NULL
 * is returned if the column number is in the [0,#n_columns] range.
 */
static const char* tracker_sparql_cursor_real_get_string (TrackerSparqlCursor* self, gint column, glong* length) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_cursor_get_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


const char* tracker_sparql_cursor_get_string (TrackerSparqlCursor* self, gint column, glong* length) {
	return TRACKER_SPARQL_CURSOR_GET_CLASS (self)->get_string (self, column, length);
}


/**
 * tracker_sparql_cursor_next:
 * @self: a #TrackerSparqlCursor
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Iterates to the next result. The API call is completely synchronous, so
 * it may block.
 *
 * Returns: #FALSE if no more results found, #TRUE otherwise.
 */
static gboolean tracker_sparql_cursor_real_next (TrackerSparqlCursor* self, GCancellable* cancellable, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_cursor_next'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean tracker_sparql_cursor_next (TrackerSparqlCursor* self, GCancellable* cancellable, GError** error) {
	return TRACKER_SPARQL_CURSOR_GET_CLASS (self)->next (self, cancellable, error);
}


void tracker_sparql_cursor_next_async (TrackerSparqlCursor* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CURSOR_GET_CLASS (self)->next_async (self, cancellable, _callback_, _user_data_);
}


gboolean tracker_sparql_cursor_next_finish (TrackerSparqlCursor* self, GAsyncResult* _res_, GError** error) {
	return TRACKER_SPARQL_CURSOR_GET_CLASS (self)->next_finish (self, _res_, error);
}


/**
 * tracker_sparql_cursor_rewind:
 * @self: a #TrackerSparqlCursor
 *
 * Resets the iterator to point back to the first result.
 */
static void tracker_sparql_cursor_real_rewind (TrackerSparqlCursor* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_cursor_rewind'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void tracker_sparql_cursor_rewind (TrackerSparqlCursor* self) {
	TRACKER_SPARQL_CURSOR_GET_CLASS (self)->rewind (self);
}


TrackerSparqlCursor* tracker_sparql_cursor_construct (GType object_type) {
	TrackerSparqlCursor * self;
	self = (TrackerSparqlCursor*) g_object_new (object_type, NULL);
	return self;
}


/**
 * tracker_sparql_cursor_get_connection:
 * @self: a #TrackerSparqlCursor
 *
 * Returns the connection used to retrieve the results.
 *
 * Returns: a #TrackerSparqlConnection. The returned object must not
 * be freed by the caller.
 */
TrackerSparqlConnection* tracker_sparql_cursor_get_connection (TrackerSparqlCursor* self) {
	TrackerSparqlConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_connection;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tracker_sparql_cursor_set_connection (TrackerSparqlCursor* self, TrackerSparqlConnection* value) {
	TrackerSparqlConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_connection = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_connection), _tmp0_);
	g_object_notify ((GObject *) self, "connection");
}


/**
 * tracker_sparql_cursor_get_n_columns:
 * @self: a #TrackerSparqlCursor
 *
 * Returns the number of columns available in the results to iterate.
 * This method should only be called after a successful
 * tracker_sparql_cursor_next(); otherwise its return value will be
 * undefined.
 *
 * Returns: a #gint with the number of columns.
 */
gint tracker_sparql_cursor_get_n_columns (TrackerSparqlCursor* self) {
	return TRACKER_SPARQL_CURSOR_GET_CLASS (self)->get_n_columns (self);
}


static void tracker_sparql_cursor_class_init (TrackerSparqlCursorClass * klass) {
	tracker_sparql_cursor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlCursorPrivate));
	TRACKER_SPARQL_CURSOR_CLASS (klass)->get_string = tracker_sparql_cursor_real_get_string;
	TRACKER_SPARQL_CURSOR_CLASS (klass)->next = tracker_sparql_cursor_real_next;
	TRACKER_SPARQL_CURSOR_CLASS (klass)->rewind = tracker_sparql_cursor_real_rewind;
	G_OBJECT_CLASS (klass)->get_property = tracker_sparql_cursor_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_sparql_cursor_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_cursor_finalize;
	/**
	 * TrackerSparqlCursor:connection:
	 *
	 * The #TrackerSparqlConnection used to retrieve the results.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_CURSOR_CONNECTION, g_param_spec_object ("connection", "connection", "connection", TRACKER_SPARQL_TYPE_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * TrackerSparqlCursor:n_columns:
	 *
	 * Number of columns available in the results to iterate.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_CURSOR_N_COLUMNS, g_param_spec_int ("n-columns", "n-columns", "n-columns", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_sparql_cursor_instance_init (TrackerSparqlCursor * self) {
	self->priv = TRACKER_SPARQL_CURSOR_GET_PRIVATE (self);
}


static void tracker_sparql_cursor_finalize (GObject* obj) {
	TrackerSparqlCursor * self;
	self = TRACKER_SPARQL_CURSOR (obj);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (tracker_sparql_cursor_parent_class)->finalize (obj);
}


/**
 * TrackerSparqlCursor:
 *
 * The <structname>TrackerSparqlCursor</structname> object represents an
 * iterator of results.
 */
GType tracker_sparql_cursor_get_type (void) {
	static volatile gsize tracker_sparql_cursor_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_cursor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlCursor), 0, (GInstanceInitFunc) tracker_sparql_cursor_instance_init, NULL };
		GType tracker_sparql_cursor_type_id;
		tracker_sparql_cursor_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlCursor", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_sparql_cursor_type_id__volatile, tracker_sparql_cursor_type_id);
	}
	return tracker_sparql_cursor_type_id__volatile;
}


static void tracker_sparql_cursor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlCursor * self;
	self = TRACKER_SPARQL_CURSOR (object);
	switch (property_id) {
		case TRACKER_SPARQL_CURSOR_CONNECTION:
		g_value_set_object (value, tracker_sparql_cursor_get_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_sparql_cursor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlCursor * self;
	self = TRACKER_SPARQL_CURSOR (object);
	switch (property_id) {
		case TRACKER_SPARQL_CURSOR_CONNECTION:
		tracker_sparql_cursor_set_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




