/* tracker-utils.c generated by valac, the Vala compiler
 * generated from tracker-utils.gs, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CATEGORIES (categories_get_type ())

#define TYPE_TRACKER_UTILS (tracker_utils_get_type ())
#define TRACKER_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_UTILS, TrackerUtils))
#define TRACKER_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_UTILS, TrackerUtilsClass))
#define IS_TRACKER_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_UTILS))
#define IS_TRACKER_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_UTILS))
#define TRACKER_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_UTILS, TrackerUtilsClass))

typedef struct _TrackerUtils TrackerUtils;
typedef struct _TrackerUtilsClass TrackerUtilsClass;
typedef struct _TrackerUtilsPrivate TrackerUtilsPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _ParamSpecTrackerUtils ParamSpecTrackerUtils;

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Audio,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;

struct _TrackerUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerUtilsPrivate * priv;
};

struct _TrackerUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerUtils *self);
};

struct _ParamSpecTrackerUtils {
	GParamSpec parent_instance;
};


static gpointer tracker_utils_parent_class = NULL;

GType categories_get_type (void);
gpointer tracker_utils_ref (gpointer instance);
void tracker_utils_unref (gpointer instance);
GParamSpec* param_spec_tracker_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tracker_utils (GValue* value, gpointer v_object);
void value_take_tracker_utils (GValue* value, gpointer v_object);
gpointer value_get_tracker_utils (const GValue* value);
GType tracker_utils_get_type (void);
enum  {
	TRACKER_UTILS_DUMMY_PROPERTY
};
char* tracker_utils_EscapeSparql (const char* sparql, gboolean add_wildcard);
gboolean tracker_utils_OpenUri (const char* uri, gboolean is_dir);
gboolean tracker_utils_LaunchApp (const char* uri);
GdkPixbuf* tracker_utils_GetThemeIconPixbuf (GIcon* icon, gint size, GdkScreen* screen);
GdkPixbuf* tracker_utils_GetThemePixbufByName (const char* icon_name, gint size, GdkScreen* screen);
GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen);
char* tracker_utils_FormatFileSize (gint64 size);
TrackerUtils* tracker_utils_new (void);
TrackerUtils* tracker_utils_construct (GType object_type);
static void tracker_utils_finalize (TrackerUtils* obj);



GType categories_get_type (void) {
	static volatile gsize categories_type_id__volatile = 0;
	if (g_once_init_enter (&categories_type_id__volatile)) {
		static const GEnumValue values[] = {{CATEGORIES_Application, "CATEGORIES_Application", "application"}, {CATEGORIES_Contact, "CATEGORIES_Contact", "contact"}, {CATEGORIES_Email, "CATEGORIES_Email", "email"}, {CATEGORIES_EmailAttachment, "CATEGORIES_EmailAttachment", "emailattachment"}, {CATEGORIES_File, "CATEGORIES_File", "file"}, {CATEGORIES_Folder, "CATEGORIES_Folder", "folder"}, {CATEGORIES_Audio, "CATEGORIES_Audio", "audio"}, {CATEGORIES_Video, "CATEGORIES_Video", "video"}, {CATEGORIES_Image, "CATEGORIES_Image", "image"}, {CATEGORIES_Document, "CATEGORIES_Document", "document"}, {CATEGORIES_Text, "CATEGORIES_Text", "text"}, {CATEGORIES_Development, "CATEGORIES_Development", "development"}, {CATEGORIES_Web, "CATEGORIES_Web", "web"}, {CATEGORIES_WebHistory, "CATEGORIES_WebHistory", "webhistory"}, {0, NULL, NULL}};
		GType categories_type_id;
		categories_type_id = g_enum_register_static ("Categories", values);
		g_once_init_leave (&categories_type_id__volatile, categories_type_id);
	}
	return categories_type_id__volatile;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
#line 1164 "glib-2.0.vapi"
	return result;
#line 117 "tracker-utils.c"
}


#line 54 "tracker-utils.gs"
char* tracker_utils_EscapeSparql (const char* sparql, gboolean add_wildcard) {
#line 123 "tracker-utils.c"
	char* result = NULL;
	GString* str;
	glong len;
	gchar* p;
#line 54 "tracker-utils.gs"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 55 "tracker-utils.gs"
	str = g_string_new ("");
#line 57 "tracker-utils.gs"
	if (sparql == NULL) {
#line 134 "tracker-utils.c"
		result = g_strdup ("");
		_g_string_free0 (str);
#line 58 "tracker-utils.gs"
		return result;
#line 139 "tracker-utils.c"
	}
#line 60 "tracker-utils.gs"
	len = string_get_length (sparql);
#line 62 "tracker-utils.gs"
	if (len < 3) {
#line 145 "tracker-utils.c"
		result = g_strdup (sparql);
		_g_string_free0 (str);
#line 63 "tracker-utils.gs"
		return result;
#line 150 "tracker-utils.c"
	}
#line 65 "tracker-utils.gs"
	p = sparql;
#line 67 "tracker-utils.gs"
	while (TRUE) {
#line 67 "tracker-utils.gs"
		if (!((*p) != '\0')) {
#line 67 "tracker-utils.gs"
			break;
#line 160 "tracker-utils.c"
		}
#line 68 "tracker-utils.gs"
		if ((*p) == '"') {
#line 69 "tracker-utils.gs"
			g_string_append (str, "\\\"");
#line 166 "tracker-utils.c"
		} else {
#line 70 "tracker-utils.gs"
			if ((*p) == '\\') {
#line 71 "tracker-utils.gs"
				g_string_append (str, "\\\\");
#line 172 "tracker-utils.c"
			} else {
#line 73 "tracker-utils.gs"
				g_string_append_c (str, *p);
#line 176 "tracker-utils.c"
			}
		}
#line 74 "tracker-utils.gs"
		p++;
#line 181 "tracker-utils.c"
	}
#line 76 "tracker-utils.gs"
	if (add_wildcard) {
#line 77 "tracker-utils.gs"
		p--;
#line 78 "tracker-utils.gs"
		if ((*p) != ' ') {
#line 79 "tracker-utils.gs"
			g_string_append_c (str, '*');
#line 191 "tracker-utils.c"
		}
	}
	result = g_strdup (str->str);
	_g_string_free0 (str);
#line 82 "tracker-utils.gs"
	return result;
#line 198 "tracker-utils.c"
}


#line 86 "tracker-utils.gs"
gboolean tracker_utils_LaunchApp (const char* uri) {
#line 204 "tracker-utils.c"
	gboolean result = FALSE;
	GError * _inner_error_;
	GAppInfo* app_info;
	GAppLaunchContext* context;
	GFile* file;
	GAppInfo* _tmp1_;
	char* _tmp0_;
	GAppLaunchContext* _tmp2_;
#line 86 "tracker-utils.gs"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 215 "tracker-utils.c"
	_inner_error_ = NULL;
	app_info = NULL;
	context = NULL;
#line 90 "tracker-utils.gs"
	file = g_file_new_for_uri (uri);
#line 92 "tracker-utils.gs"
	app_info = (_tmp1_ = (GAppInfo*) g_desktop_app_info_new_from_filename (_tmp0_ = g_file_get_path (file)), _g_object_unref0 (app_info), _tmp1_);
#line 223 "tracker-utils.c"
	_g_free0 (_tmp0_);
#line 93 "tracker-utils.gs"
	if (app_info == NULL) {
#line 227 "tracker-utils.c"
		result = tracker_utils_OpenUri (uri, FALSE);
		_g_object_unref0 (app_info);
		_g_object_unref0 (context);
		_g_object_unref0 (file);
#line 94 "tracker-utils.gs"
		return result;
#line 234 "tracker-utils.c"
	}
#line 96 "tracker-utils.gs"
	context = (_tmp2_ = (GAppLaunchContext*) gdk_app_launch_context_new (), _g_object_unref0 (context), _tmp2_);
#line 238 "tracker-utils.c"
	{
#line 98 "tracker-utils.gs"
		g_app_info_launch (app_info, NULL, context, &_inner_error_);
#line 242 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
#line 100 "tracker-utils.gs"
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Could not launch \"%s\"\nError: %s\n"), g_app_info_get_display_name (app_info), e->message));
#line 102 "tracker-utils.gs"
			gtk_dialog_run ((GtkDialog*) msg);
#line 259 "tracker-utils.c"
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (msg);
			_g_object_unref0 (app_info);
			_g_object_unref0 (context);
			_g_object_unref0 (file);
#line 103 "tracker-utils.gs"
			return result;
#line 268 "tracker-utils.c"
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app_info);
		_g_object_unref0 (context);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (app_info);
	_g_object_unref0 (context);
	_g_object_unref0 (file);
#line 105 "tracker-utils.gs"
	return result;
#line 286 "tracker-utils.c"
}


#line 108 "tracker-utils.gs"
gboolean tracker_utils_OpenUri (const char* uri, gboolean is_dir) {
#line 292 "tracker-utils.c"
	gboolean result = FALSE;
	GError * _inner_error_;
	GAppInfo* app_info;
	GFile* file;
#line 108 "tracker-utils.gs"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 299 "tracker-utils.c"
	_inner_error_ = NULL;
	app_info = NULL;
#line 111 "tracker-utils.gs"
	file = g_file_new_for_uri (uri);
#line 304 "tracker-utils.c"
	{
		GAppInfo* _tmp0_;
		GAppInfo* _tmp1_;
#line 114 "tracker-utils.gs"
		_tmp0_ = g_file_query_default_handler (file, NULL, &_inner_error_);
#line 310 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 114 "tracker-utils.gs"
		app_info = (_tmp1_ = _tmp0_, _g_object_unref0 (app_info), _tmp1_);
#line 316 "tracker-utils.c"
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
#line 116 "tracker-utils.gs"
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Could not get application info for %s\nError: %s\n"), uri, e->message));
#line 118 "tracker-utils.gs"
			gtk_dialog_run ((GtkDialog*) msg);
#line 330 "tracker-utils.c"
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (msg);
			_g_object_unref0 (app_info);
			_g_object_unref0 (file);
#line 119 "tracker-utils.gs"
			return result;
#line 338 "tracker-utils.c"
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app_info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
#line 122 "tracker-utils.gs"
		g_app_info_launch_default_for_uri (uri, NULL, &_inner_error_);
#line 352 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
#line 124 "tracker-utils.gs"
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Could not lauch %s\nError: %s\n"), uri, e->message));
#line 126 "tracker-utils.gs"
			gtk_dialog_run ((GtkDialog*) msg);
#line 369 "tracker-utils.c"
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (msg);
			_g_object_unref0 (app_info);
			_g_object_unref0 (file);
#line 127 "tracker-utils.gs"
			return result;
#line 377 "tracker-utils.c"
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app_info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (app_info);
	_g_object_unref0 (file);
#line 129 "tracker-utils.gs"
	return result;
#line 393 "tracker-utils.c"
}


#line 132 "tracker-utils.gs"
inline GdkPixbuf* tracker_utils_GetThemePixbufByName (const char* icon_name, gint size, GdkScreen* screen) {
#line 399 "tracker-utils.c"
	GdkPixbuf* result = NULL;
	GThemedIcon* icon;
#line 132 "tracker-utils.gs"
	g_return_val_if_fail (icon_name != NULL, NULL);
#line 132 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 134 "tracker-utils.gs"
	icon = (GThemedIcon*) g_themed_icon_new (icon_name);
#line 408 "tracker-utils.c"
	result = tracker_utils_GetThemeIconPixbuf ((GIcon*) icon, size, screen);
	_g_object_unref0 (icon);
#line 136 "tracker-utils.gs"
	return result;
#line 413 "tracker-utils.c"
}


#line 139 "tracker-utils.gs"
GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen) {
#line 419 "tracker-utils.c"
	GdkPixbuf* result = NULL;
	GError * _inner_error_;
	GdkPixbuf* pixbuf;
#line 139 "tracker-utils.gs"
	g_return_val_if_fail (info != NULL, NULL);
#line 139 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 427 "tracker-utils.c"
	_inner_error_ = NULL;
#line 141 "tracker-utils.gs"
	pixbuf = NULL;
#line 431 "tracker-utils.c"
	{
		char* thumbpath;
#line 144 "tracker-utils.gs"
		thumbpath = g_strdup (g_file_info_get_attribute_byte_string (info, G_FILE_ATTRIBUTE_THUMBNAIL_PATH));
#line 146 "tracker-utils.gs"
		if (thumbpath != NULL) {
#line 438 "tracker-utils.c"
			GdkPixbuf* _tmp0_;
			GdkPixbuf* _tmp1_;
#line 147 "tracker-utils.gs"
			_tmp0_ = gdk_pixbuf_new_from_file_at_size (thumbpath, thumb_size, thumb_size, &_inner_error_);
#line 443 "tracker-utils.c"
			if (_inner_error_ != NULL) {
				_g_free0 (thumbpath);
				goto __catch13_g_error;
			}
#line 147 "tracker-utils.gs"
			pixbuf = (_tmp1_ = _tmp0_, _g_object_unref0 (pixbuf), _tmp1_);
#line 450 "tracker-utils.c"
		}
		_g_free0 (thumbpath);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			;
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 151 "tracker-utils.gs"
	if (pixbuf == NULL) {
#line 474 "tracker-utils.c"
		GdkPixbuf* _tmp2_;
#line 152 "tracker-utils.gs"
		pixbuf = (_tmp2_ = tracker_utils_GetThemeIconPixbuf (g_file_info_get_icon (info), icon_size, screen), _g_object_unref0 (pixbuf), _tmp2_);
#line 478 "tracker-utils.c"
	}
#line 154 "tracker-utils.gs"
	if (pixbuf == NULL) {
#line 482 "tracker-utils.c"
		GdkPixbuf* _tmp3_;
#line 155 "tracker-utils.gs"
		pixbuf = (_tmp3_ = tracker_utils_GetThemePixbufByName ("text-x-generic", icon_size, screen), _g_object_unref0 (pixbuf), _tmp3_);
#line 486 "tracker-utils.c"
	}
	result = pixbuf;
#line 157 "tracker-utils.gs"
	return result;
#line 491 "tracker-utils.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 160 "tracker-utils.gs"
GdkPixbuf* tracker_utils_GetThemeIconPixbuf (GIcon* icon, gint size, GdkScreen* screen) {
#line 502 "tracker-utils.c"
	GdkPixbuf* result = NULL;
	GError * _inner_error_;
	GtkIconInfo* icon_info;
	GtkIconTheme* theme;
	GtkIconInfo* _tmp0_;
#line 160 "tracker-utils.gs"
	g_return_val_if_fail (icon != NULL, NULL);
#line 160 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 512 "tracker-utils.c"
	_inner_error_ = NULL;
	icon_info = NULL;
#line 164 "tracker-utils.gs"
	theme = _g_object_ref0 (gtk_icon_theme_get_for_screen (screen));
#line 166 "tracker-utils.gs"
	icon_info = (_tmp0_ = gtk_icon_theme_lookup_by_gicon (theme, icon, size, GTK_ICON_LOOKUP_USE_BUILTIN), _gtk_icon_info_free0 (icon_info), _tmp0_);
#line 519 "tracker-utils.c"
	{
		GdkPixbuf* _tmp1_;
#line 169 "tracker-utils.gs"
		_tmp1_ = gtk_icon_info_load_icon (icon_info, &_inner_error_);
#line 524 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		result = _tmp1_;
		_gtk_icon_info_free0 (icon_info);
		_g_object_unref0 (theme);
#line 169 "tracker-utils.gs"
		return result;
#line 533 "tracker-utils.c"
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = NULL;
			_g_error_free0 (e);
			_gtk_icon_info_free0 (icon_info);
			_g_object_unref0 (theme);
#line 171 "tracker-utils.gs"
			return result;
#line 548 "tracker-utils.c"
		}
	}
	__finally14:
	{
		_gtk_icon_info_free0 (icon_info);
		_g_object_unref0 (theme);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_gtk_icon_info_free0 (icon_info);
	_g_object_unref0 (theme);
}


#line 175 "tracker-utils.gs"
char* tracker_utils_FormatFileSize (gint64 size) {
#line 566 "tracker-utils.c"
	char* result = NULL;
	double displayed_size = 0.0;
#line 178 "tracker-utils.gs"
	if (size < 1024) {
#line 571 "tracker-utils.c"
		result = g_strdup_printf ("%u bytes", (guint) size);
#line 179 "tracker-utils.gs"
		return result;
#line 575 "tracker-utils.c"
	}
#line 181 "tracker-utils.gs"
	if (size < 1048576) {
#line 182 "tracker-utils.gs"
		displayed_size = ((double) size) / 1024;
#line 581 "tracker-utils.c"
		result = g_strdup_printf ("%.1f KB", displayed_size);
#line 183 "tracker-utils.gs"
		return result;
#line 585 "tracker-utils.c"
	}
#line 185 "tracker-utils.gs"
	if (size < 1073741824) {
#line 186 "tracker-utils.gs"
		displayed_size = ((double) size) / 1048576;
#line 591 "tracker-utils.c"
		result = g_strdup_printf ("%.1f MB", displayed_size);
#line 187 "tracker-utils.gs"
		return result;
#line 595 "tracker-utils.c"
	}
#line 189 "tracker-utils.gs"
	displayed_size = ((double) size) / 1073741824;
#line 599 "tracker-utils.c"
	result = g_strdup_printf ("%.1f GB", displayed_size);
#line 190 "tracker-utils.gs"
	return result;
#line 603 "tracker-utils.c"
}


#line 51 "tracker-utils.gs"
TrackerUtils* tracker_utils_construct (GType object_type) {
#line 609 "tracker-utils.c"
	TrackerUtils* self;
	self = (TrackerUtils*) g_type_create_instance (object_type);
	return self;
}


#line 51 "tracker-utils.gs"
TrackerUtils* tracker_utils_new (void) {
#line 51 "tracker-utils.gs"
	return tracker_utils_construct (TYPE_TRACKER_UTILS);
#line 620 "tracker-utils.c"
}


static void value_tracker_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_tracker_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_utils_unref (value->data[0].v_pointer);
	}
}


static void value_tracker_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_tracker_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_tracker_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_tracker_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_tracker_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTrackerUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TRACKER_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_tracker_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRACKER_UTILS), NULL);
	return value->data[0].v_pointer;
}


void value_set_tracker_utils (GValue* value, gpointer v_object) {
	TrackerUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRACKER_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRACKER_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_utils_unref (old);
	}
}


void value_take_tracker_utils (GValue* value, gpointer v_object) {
	TrackerUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRACKER_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRACKER_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_utils_unref (old);
	}
}


static void tracker_utils_class_init (TrackerUtilsClass * klass) {
	tracker_utils_parent_class = g_type_class_peek_parent (klass);
	TRACKER_UTILS_CLASS (klass)->finalize = tracker_utils_finalize;
}


static void tracker_utils_instance_init (TrackerUtils * self) {
	self->ref_count = 1;
}


static void tracker_utils_finalize (TrackerUtils* obj) {
	TrackerUtils * self;
	self = TRACKER_UTILS (obj);
}


GType tracker_utils_get_type (void) {
	static volatile gsize tracker_utils_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tracker_utils_init, value_tracker_utils_free_value, value_tracker_utils_copy_value, value_tracker_utils_peek_pointer, "p", value_tracker_utils_collect_value, "p", value_tracker_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerUtils), 0, (GInstanceInitFunc) tracker_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_utils_type_id;
		tracker_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_utils_type_id__volatile, tracker_utils_type_id);
	}
	return tracker_utils_type_id__volatile;
}


gpointer tracker_utils_ref (gpointer instance) {
	TrackerUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_utils_unref (gpointer instance) {
	TrackerUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




