/* tracker-sparql-pattern.c generated by valac 0.12.0, the Vala compiler
 * generated from tracker-sparql-pattern.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-db/tracker-db-interface.h>
#include <libtracker-db/tracker-db-manager.h>
#include <libtracker-data/tracker-ontologies.h>
#include <libtracker-data/tracker-property.h>


#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlPredicateVariablePrivate TrackerSparqlPredicateVariablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;

#define TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT (tracker_sparql_pattern_triple_context_get_type ())
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))

typedef struct _TrackerSparqlPatternTripleContext TrackerSparqlPatternTripleContext;
typedef struct _TrackerSparqlPatternTripleContextClass TrackerSparqlPatternTripleContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlPatternTripleContextPrivate TrackerSparqlPatternTripleContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _TrackerSparqlPredicateVariable {
	GObject parent_instance;
	TrackerSparqlPredicateVariablePrivate * priv;
	gchar* subject;
	gchar* object;
	TrackerClass* domain;
};

struct _TrackerSparqlPredicateVariableClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPatternPrivate {
	TrackerSparqlQuery* query;
	TrackerSparqlExpression* expression;
	gint counter;
	gint next_table_index;
	gchar* current_graph;
	gboolean current_graph_is_var;
	gchar* current_subject;
	gboolean current_subject_is_var;
	gchar* current_predicate;
	gboolean current_predicate_is_var;
	TrackerSparqlPatternTripleContext* triple_context;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	GHashTable* used_sql_identifiers;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlPatternTripleContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlPatternTripleContextPrivate * priv;
	GList* tables;
	GHashTable* table_map;
	GList* bindings;
	GList* variables;
	GHashTable* var_bindings;
};

struct _TrackerSparqlPatternTripleContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	gchar* sql_db_tablename;
	gchar* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};


static gpointer tracker_sparql_predicate_variable_parent_class = NULL;
static gpointer tracker_sparql_pattern_parent_class = NULL;
static gpointer tracker_sparql_pattern_triple_context_parent_class = NULL;

GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_PREDICATE_VARIABLE_DUMMY_PROPERTY
};
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
GQuark tracker_sparql_error_quark (void);
gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (void);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type);
static void tracker_sparql_predicate_variable_finalize (GObject* obj);
static GType tracker_sparql_pattern_triple_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_SPARQL_PATTERN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternPrivate))
enum  {
	TRACKER_SPARQL_PATTERN_DUMMY_PROPERTY
};
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error);
static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlContext* parent_context);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error);
static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2);
static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
static void _vala_array_add1 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value);
static void _vala_array_add2 (glong** array, int* length, int* size, glong value);
static void _vala_array_add3 (TrackerSparqlContext*** array, int* length, int* size, TrackerSparqlContext* value);
static void _vala_array_add4 (TrackerSparqlVariable*** array, int* length, int* size, TrackerSparqlVariable* value);
static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable);
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
enum  {
	TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_DUMMY_PROPERTY
};
static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext* obj);
static void tracker_sparql_pattern_finalize (GObject* obj);
static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* sql;
	gchar* _tmp58_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sql = _tmp0_;
	if (self->subject != NULL) {
		gint _tmp1_;
		gint subject_id;
		TrackerDBResultSet* result_set;
		_tmp1_ = tracker_data_query_resource_id (self->subject);
		subject_id = _tmp1_;
		result_set = NULL;
		if (subject_id > 0) {
			TrackerDBInterface* _tmp2_ = NULL;
			TrackerDBInterface* _tmp3_;
			TrackerDBInterface* iface;
			TrackerDBStatement* _tmp4_ = NULL;
			TrackerDBStatement* stmt;
			TrackerDBResultSet* _tmp5_ = NULL;
			TrackerDBResultSet* _tmp6_;
			_tmp2_ = tracker_db_manager_get_db_interface ();
			_tmp3_ = _g_object_ref0 (_tmp2_);
			iface = _tmp3_;
			_tmp4_ = tracker_db_interface_create_statement (iface, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") FROM \"rdfs:" \
"Resource_rdf:type\" WHERE ID = ?");
			stmt = _tmp4_;
			tracker_db_statement_bind_int (stmt, 0, subject_id);
			_tmp5_ = tracker_db_statement_execute (stmt, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (stmt);
				_g_object_unref0 (iface);
				_g_object_unref0 (result_set);
				_g_string_free0 (sql);
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
					goto __catch0_tracker_db_interface_error;
				}
				_g_object_unref0 (stmt);
				_g_object_unref0 (iface);
				_g_object_unref0 (result_set);
				_g_string_free0 (sql);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (result_set);
			result_set = _tmp6_;
			_g_object_unref0 (stmt);
			_g_object_unref0 (iface);
		}
		if (result_set != NULL) {
			gboolean first;
			first = TRUE;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
				while (TRUE) {
					GValue value = {0};
					GValue _tmp9_ = {0};
					const gchar* _tmp10_ = NULL;
					TrackerClass* _tmp11_ = NULL;
					TrackerClass* _tmp12_;
					TrackerClass* domain;
					gint _tmp13_;
					TrackerProperty** _tmp14_ = NULL;
					if (!_tmp7_) {
						gboolean _tmp8_;
						_tmp8_ = tracker_db_result_set_iter_next (result_set);
						if (!_tmp8_) {
							break;
						}
					}
					_tmp7_ = FALSE;
					_tracker_db_result_set_get_value (result_set, (guint) 0, &_tmp9_);
					G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
					value = _tmp9_;
					_tmp10_ = g_value_get_string (&value);
					_tmp11_ = tracker_ontologies_get_class_by_uri (_tmp10_);
					_tmp12_ = _g_object_ref0 (_tmp11_);
					domain = _tmp12_;
					_tmp14_ = tracker_ontologies_get_properties (&_tmp13_);
					{
						TrackerProperty** prop_collection;
						int prop_collection_length1;
						int prop_it;
						prop_collection = _tmp14_;
						prop_collection_length1 = _tmp13_;
						for (prop_it = 0; prop_it < _tmp13_; prop_it = prop_it + 1) {
							TrackerProperty* _tmp15_;
							TrackerProperty* prop;
							_tmp15_ = _g_object_ref0 (prop_collection[prop_it]);
							prop = _tmp15_;
							{
								TrackerClass* _tmp16_ = NULL;
								_tmp16_ = tracker_property_get_domain (prop);
								if (_tmp16_ == domain) {
									const gchar* _tmp17_ = NULL;
									const gchar* _tmp18_ = NULL;
									gchar* _tmp19_ = NULL;
									gchar* _tmp20_;
									TrackerPropertyType _tmp21_;
									const gchar* _tmp22_ = NULL;
									TrackerSparqlLiteralBinding* _tmp23_ = NULL;
									TrackerSparqlLiteralBinding* binding;
									gchar* _tmp24_ = NULL;
									TrackerSparqlLiteralBinding* _tmp25_;
									if (first) {
										first = FALSE;
									} else {
										g_string_append (sql, " UNION ALL ");
									}
									_tmp17_ = tracker_property_get_uri (prop);
									g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp17_);
									_tmp18_ = tracker_property_get_name (prop);
									_tmp19_ = g_strdup_printf ("\"%s\"", _tmp18_);
									_tmp20_ = _tmp19_;
									_tmp21_ = tracker_property_get_data_type (prop);
									tracker_sparql_expression_append_expression_as_string (sql, _tmp20_, _tmp21_);
									_g_free0 (_tmp20_);
									g_string_append (sql, " AS \"object\" FROM ");
									_tmp22_ = tracker_property_get_table_name (prop);
									g_string_append_printf (sql, "\"%s\"", _tmp22_);
									g_string_append (sql, " WHERE ID = ?");
									_tmp23_ = tracker_sparql_literal_binding_new ();
									binding = _tmp23_;
									_tmp24_ = g_strdup_printf ("%i", subject_id);
									_g_free0 (binding->literal);
									binding->literal = _tmp24_;
									((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
									_tmp25_ = _g_object_ref0 (binding);
									query->bindings = g_list_append (query->bindings, _tmp25_);
									_g_object_unref0 (binding);
								}
								_g_object_unref0 (prop);
							}
						}
					}
					_g_object_unref0 (domain);
					G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
				}
			}
		} else {
			g_string_append (sql, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\"");
		}
		_g_object_unref0 (result_set);
	} else {
		if (self->object != NULL) {
			gint _tmp26_;
			gint object_id;
			TrackerDBInterface* _tmp27_ = NULL;
			TrackerDBInterface* _tmp28_;
			TrackerDBInterface* iface;
			TrackerDBStatement* _tmp29_ = NULL;
			TrackerDBStatement* stmt;
			TrackerDBResultSet* _tmp30_ = NULL;
			TrackerDBResultSet* result_set;
			gboolean first;
			_tmp26_ = tracker_data_query_resource_id (self->object);
			object_id = _tmp26_;
			_tmp27_ = tracker_db_manager_get_db_interface ();
			_tmp28_ = _g_object_ref0 (_tmp27_);
			iface = _tmp28_;
			_tmp29_ = tracker_db_interface_create_statement (iface, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") FROM \"rdfs:" \
"Resource_rdf:type\" WHERE ID = ?");
			stmt = _tmp29_;
			tracker_db_statement_bind_int (stmt, 0, object_id);
			_tmp30_ = tracker_db_statement_execute (stmt, &_inner_error_);
			result_set = _tmp30_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (stmt);
				_g_object_unref0 (iface);
				_g_string_free0 (sql);
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
					goto __catch0_tracker_db_interface_error;
				}
				_g_object_unref0 (stmt);
				_g_object_unref0 (iface);
				_g_string_free0 (sql);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			first = TRUE;
			if (result_set != NULL) {
				{
					gboolean _tmp31_;
					_tmp31_ = TRUE;
					while (TRUE) {
						GValue value = {0};
						GValue _tmp33_ = {0};
						const gchar* _tmp34_ = NULL;
						TrackerClass* _tmp35_ = NULL;
						TrackerClass* _tmp36_;
						TrackerClass* range;
						gint _tmp37_;
						TrackerProperty** _tmp38_ = NULL;
						if (!_tmp31_) {
							gboolean _tmp32_;
							_tmp32_ = tracker_db_result_set_iter_next (result_set);
							if (!_tmp32_) {
								break;
							}
						}
						_tmp31_ = FALSE;
						_tracker_db_result_set_get_value (result_set, (guint) 0, &_tmp33_);
						G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
						value = _tmp33_;
						_tmp34_ = g_value_get_string (&value);
						_tmp35_ = tracker_ontologies_get_class_by_uri (_tmp34_);
						_tmp36_ = _g_object_ref0 (_tmp35_);
						range = _tmp36_;
						_tmp38_ = tracker_ontologies_get_properties (&_tmp37_);
						{
							TrackerProperty** prop_collection;
							int prop_collection_length1;
							int prop_it;
							prop_collection = _tmp38_;
							prop_collection_length1 = _tmp37_;
							for (prop_it = 0; prop_it < _tmp37_; prop_it = prop_it + 1) {
								TrackerProperty* _tmp39_;
								TrackerProperty* prop;
								_tmp39_ = _g_object_ref0 (prop_collection[prop_it]);
								prop = _tmp39_;
								{
									TrackerClass* _tmp40_ = NULL;
									_tmp40_ = tracker_property_get_range (prop);
									if (_tmp40_ == range) {
										const gchar* _tmp41_ = NULL;
										const gchar* _tmp42_ = NULL;
										gchar* _tmp43_ = NULL;
										gchar* _tmp44_;
										TrackerPropertyType _tmp45_;
										const gchar* _tmp46_ = NULL;
										if (first) {
											first = FALSE;
										} else {
											g_string_append (sql, " UNION ALL ");
										}
										_tmp41_ = tracker_property_get_uri (prop);
										g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp41_);
										_tmp42_ = tracker_property_get_name (prop);
										_tmp43_ = g_strdup_printf ("\"%s\"", _tmp42_);
										_tmp44_ = _tmp43_;
										_tmp45_ = tracker_property_get_data_type (prop);
										tracker_sparql_expression_append_expression_as_string (sql, _tmp44_, _tmp45_);
										_g_free0 (_tmp44_);
										g_string_append (sql, " AS \"object\" FROM ");
										_tmp46_ = tracker_property_get_table_name (prop);
										g_string_append_printf (sql, "\"%s\"", _tmp46_);
									}
									_g_object_unref0 (prop);
								}
							}
						}
						_g_object_unref0 (range);
						G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
					}
				}
			} else {
				g_string_append (sql, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\"");
			}
			_g_object_unref0 (result_set);
			_g_object_unref0 (stmt);
			_g_object_unref0 (iface);
		} else {
			if (self->domain != NULL) {
				gboolean first;
				gint _tmp47_;
				TrackerProperty** _tmp48_ = NULL;
				first = TRUE;
				_tmp48_ = tracker_ontologies_get_properties (&_tmp47_);
				{
					TrackerProperty** prop_collection;
					int prop_collection_length1;
					int prop_it;
					prop_collection = _tmp48_;
					prop_collection_length1 = _tmp47_;
					for (prop_it = 0; prop_it < _tmp47_; prop_it = prop_it + 1) {
						TrackerProperty* _tmp49_;
						TrackerProperty* prop;
						_tmp49_ = _g_object_ref0 (prop_collection[prop_it]);
						prop = _tmp49_;
						{
							TrackerClass* _tmp50_ = NULL;
							_tmp50_ = tracker_property_get_domain (prop);
							if (_tmp50_ == self->domain) {
								const gchar* _tmp51_ = NULL;
								const gchar* _tmp52_ = NULL;
								gchar* _tmp53_ = NULL;
								gchar* _tmp54_;
								TrackerPropertyType _tmp55_;
								const gchar* _tmp56_ = NULL;
								if (first) {
									first = FALSE;
								} else {
									g_string_append (sql, " UNION ALL ");
								}
								_tmp51_ = tracker_property_get_uri (prop);
								g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp51_);
								_tmp52_ = tracker_property_get_name (prop);
								_tmp53_ = g_strdup_printf ("\"%s\"", _tmp52_);
								_tmp54_ = _tmp53_;
								_tmp55_ = tracker_property_get_data_type (prop);
								tracker_sparql_expression_append_expression_as_string (sql, _tmp54_, _tmp55_);
								_g_free0 (_tmp54_);
								g_string_append (sql, " AS \"object\" FROM ");
								_tmp56_ = tracker_property_get_table_name (prop);
								g_string_append_printf (sql, "\"%s\"", _tmp56_);
							}
							_g_object_unref0 (prop);
						}
					}
				}
			} else {
				GError* _tmp57_ = NULL;
				_tmp57_ = tracker_sparql_query_get_internal_error (query, "Unrestricted predicate variables not supported");
				_inner_error_ = _tmp57_;
				_g_string_free0 (sql);
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
					goto __catch0_tracker_db_interface_error;
				}
				goto __finally0;
			}
		}
	}
	_tmp58_ = g_strdup (sql->str);
	result = _tmp58_;
	_g_string_free0 (sql);
	return result;
	_g_string_free0 (sql);
	goto __finally0;
	__catch0_tracker_db_interface_error:
	{
		GError * e;
		GError* _tmp59_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp59_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
		_inner_error_ = _tmp59_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type) {
	TrackerSparqlPredicateVariable * self = NULL;
	self = (TrackerSparqlPredicateVariable*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (void) {
	return tracker_sparql_predicate_variable_construct (TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE);
}


static void tracker_sparql_predicate_variable_class_init (TrackerSparqlPredicateVariableClass * klass) {
	tracker_sparql_predicate_variable_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_predicate_variable_finalize;
}


static void tracker_sparql_predicate_variable_instance_init (TrackerSparqlPredicateVariable * self) {
}


static void tracker_sparql_predicate_variable_finalize (GObject* obj) {
	TrackerSparqlPredicateVariable * self;
	self = TRACKER_SPARQL_PREDICATE_VARIABLE (obj);
	_g_free0 (self->subject);
	_g_free0 (self->object);
	_g_object_unref0 (self->domain);
	G_OBJECT_CLASS (tracker_sparql_predicate_variable_parent_class)->finalize (obj);
}


GType tracker_sparql_predicate_variable_get_type (void) {
	static volatile gsize tracker_sparql_predicate_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_predicate_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPredicateVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_predicate_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPredicateVariable), 0, (GInstanceInitFunc) tracker_sparql_predicate_variable_instance_init, NULL };
		GType tracker_sparql_predicate_variable_type_id;
		tracker_sparql_predicate_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPredicateVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_predicate_variable_type_id__volatile, tracker_sparql_predicate_variable_type_id);
	}
	return tracker_sparql_predicate_variable_type_id__volatile;
}


TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlPattern * self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlPattern*) g_object_new (object_type, NULL);
	self->priv->query = query;
	self->priv->expression = query->expression;
	return self;
}


TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query) {
	return tracker_sparql_pattern_construct (TRACKER_SPARQL_TYPE_PATTERN, query);
}


static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_next (self->priv->query, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = tracker_sparql_query_current (self->priv->query);
	result = _tmp0_;
	return result;
}


static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_accept (self->priv->query, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg) {
	GError* result = NULL;
	GError* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_error (self->priv->query, msg);
	result = _tmp0_;
	return result;
}


static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_expect (self->priv->query, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result) {
	TrackerSourceLocation _tmp0_ = {0};
	TrackerSourceLocation _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	tracker_sparql_query_get_location (self->priv->query, &_tmp0_);
	_tmp1_ = _tmp0_;
	*result = _tmp1_;
	return;
}


static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location) {
	g_return_if_fail (self != NULL);
	tracker_sparql_query_set_location (self->priv->query, location);
}


static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_last_string (self->priv->query, strip);
	result = _tmp0_;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error) {
	TrackerSparqlSelectContext* result = NULL;
	TrackerSparqlSelectContext* _result_ = NULL;
	TrackerPropertyType type;
	GString* _tmp4_ = NULL;
	GString* pattern_sql;
	GList* _tmp5_;
	GList* old_bindings;
	gboolean _tmp6_;
	gboolean _tmp7_;
	TrackerSourceLocation _tmp10_ = {0};
	TrackerSourceLocation _tmp11_ = {0};
	TrackerSourceLocation select_variables_location;
	gboolean _tmp12_;
	gboolean _tmp13_;
	TrackerSparqlContext* _tmp14_ = NULL;
	TrackerSparqlContext* pattern;
	GList* _tmp15_ = NULL;
	TrackerSourceLocation _tmp18_ = {0};
	TrackerSourceLocation _tmp19_ = {0};
	TrackerSourceLocation after_where;
	TrackerSparqlContext* _tmp20_ = NULL;
	GList* _tmp21_ = NULL;
	GList* _tmp27_;
	GList* where_bindings;
	GList* _tmp28_;
	gboolean first;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp54_;
	gboolean _tmp55_;
	gint limit;
	gint offset;
	gboolean _tmp66_;
	gboolean _tmp67_;
	TrackerSparqlContext* _tmp95_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	if (scalar_subquery) {
		TrackerSparqlContext* _tmp0_ = NULL;
		TrackerSparqlSelectContext* _tmp1_ = NULL;
		_tmp0_ = tracker_sparql_pattern_get_context (self);
		_tmp1_ = tracker_sparql_select_context_new_subquery (_tmp0_);
		_tracker_sparql_context_unref0 (_result_);
		_result_ = _tmp1_;
	} else {
		TrackerSparqlContext* _tmp2_ = NULL;
		TrackerSparqlSelectContext* _tmp3_ = NULL;
		_tmp2_ = tracker_sparql_pattern_get_context (self);
		_tmp3_ = tracker_sparql_select_context_new (_tmp2_);
		_tracker_sparql_context_unref0 (_result_);
		_result_ = _tmp3_;
	}
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _result_);
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
	_tmp4_ = g_string_new ("");
	pattern_sql = _tmp4_;
	_tmp5_ = self->priv->query->bindings;
	self->priv->query->bindings = NULL;
	old_bindings = _tmp5_;
	g_string_append (sql, "SELECT ");
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_SELECT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp7_) {
		g_string_append (sql, "DISTINCT ");
	} else {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_REDUCED, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp9_) {
		}
	}
	tracker_sparql_pattern_get_location (self, &_tmp10_);
	_tmp11_ = _tmp10_;
	select_variables_location = _tmp11_;
	tracker_sparql_expression_skip_select_variables (self->priv->expression, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp13_) {
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NAMED, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = tracker_sparql_pattern_translate_group_graph_pattern (self, pattern_sql, &_inner_error_);
	pattern = _tmp14_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp15_ = g_hash_table_get_keys (pattern->var_set);
	{
		GList* key_collection;
		GList* key_it;
		key_collection = _tmp15_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			TrackerSparqlVariable* key;
			key = (TrackerSparqlVariable*) key_it->data;
			{
				TrackerSparqlContext* _tmp16_ = NULL;
				TrackerSparqlVariable* _tmp17_;
				_tmp16_ = tracker_sparql_pattern_get_context (self);
				_tmp17_ = _g_object_ref0 (key);
				g_hash_table_insert (_tmp16_->var_set, _tmp17_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
			}
		}
		_g_list_free0 (key_collection);
	}
	tracker_sparql_pattern_get_location (self, &_tmp18_);
	_tmp19_ = _tmp18_;
	after_where = _tmp19_;
	tracker_sparql_pattern_set_location (self, &select_variables_location);
	_tmp20_ = tracker_sparql_pattern_get_context (self);
	_tmp21_ = g_hash_table_get_keys (_tmp20_->var_set);
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = _tmp21_;
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* variable;
			variable = (TrackerSparqlVariable*) variable_it->data;
			{
				if (variable->binding == NULL) {
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					GError* _tmp25_ = NULL;
					GError* _tmp26_;
					_tmp22_ = tracker_sparql_variable_get_name (variable);
					_tmp23_ = g_strdup_printf ("use of undefined variable `%s'", _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = tracker_sparql_pattern_get_error (self, _tmp24_);
					_tmp26_ = _tmp25_;
					_g_free0 (_tmp24_);
					_inner_error_ = _tmp26_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_list_free0 (variable_collection);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						_g_list_free0 (variable_collection);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
		_g_list_free0 (variable_collection);
	}
	_tmp27_ = self->priv->query->bindings;
	self->priv->query->bindings = NULL;
	where_bindings = _tmp27_;
	_tmp28_ = old_bindings;
	old_bindings = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->query->bindings);
	self->priv->query->bindings = _tmp28_;
	first = TRUE;
	_tmp29_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
	_tmp30_ = _tmp29_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp30_) {
		TrackerSparqlContext* _tmp31_ = NULL;
		GList* _tmp32_ = NULL;
		_tmp31_ = tracker_sparql_pattern_get_context (self);
		_tmp32_ = g_hash_table_get_keys (_tmp31_->var_set);
		{
			GList* variable_collection;
			GList* variable_it;
			variable_collection = _tmp32_;
			for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
				TrackerSparqlVariable* variable;
				variable = (TrackerSparqlVariable*) variable_it->data;
				{
					if (!first) {
						g_string_append (sql, ", ");
					} else {
						first = FALSE;
					}
					if (subquery) {
						const gchar* _tmp33_ = NULL;
						_tmp33_ = tracker_sparql_variable_get_sql_expression (variable);
						g_string_append (sql, _tmp33_);
					} else {
						const gchar* _tmp34_ = NULL;
						_tmp34_ = tracker_sparql_variable_get_sql_expression (variable);
						tracker_sparql_expression_append_expression_as_string (sql, _tmp34_, ((TrackerSparqlDataBinding*) variable->binding)->data_type);
					}
				}
			}
			_g_list_free0 (variable_collection);
		}
	} else {
		while (TRUE) {
			TrackerPropertyType _tmp35_;
			TrackerPropertyType _tmp36_;
			TrackerSparqlTokenType _tmp37_;
			if (!first) {
				g_string_append (sql, ", ");
			} else {
				first = FALSE;
			}
			_tmp35_ = tracker_sparql_expression_translate_select_expression (self->priv->expression, sql, subquery, &_inner_error_);
			_tmp36_ = _tmp35_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			type = _tmp36_;
			_tmp37_ = tracker_sparql_pattern_current (self);
			switch (_tmp37_) {
				case TRACKER_SPARQL_TOKEN_TYPE_FROM:
				case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
				case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
				case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
				case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
				case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
				case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
				case TRACKER_SPARQL_TOKEN_TYPE_EOF:
				{
					break;
				}
				default:
				{
					continue;
				}
			}
			break;
		}
	}
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = where_bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlLiteralBinding* _tmp38_;
			TrackerSparqlLiteralBinding* binding;
			_tmp38_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
			binding = _tmp38_;
			{
				TrackerSparqlLiteralBinding* _tmp39_;
				_tmp39_ = _g_object_ref0 (binding);
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp39_);
				_g_object_unref0 (binding);
			}
		}
	}
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	tracker_sparql_pattern_set_location (self, &after_where);
	_tmp40_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
	_tmp41_ = _tmp40_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp41_) {
		gboolean first_group;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		g_string_append (sql, " GROUP BY ");
		first_group = TRUE;
		{
			gboolean _tmp42_;
			_tmp42_ = TRUE;
			while (TRUE) {
				if (!_tmp42_) {
					gboolean _tmp43_ = FALSE;
					gboolean _tmp44_ = FALSE;
					gboolean _tmp45_ = FALSE;
					gboolean _tmp46_ = FALSE;
					gboolean _tmp47_ = FALSE;
					TrackerSparqlTokenType _tmp48_;
					_tmp48_ = tracker_sparql_pattern_current (self);
					if (_tmp48_ != TRACKER_SPARQL_TOKEN_TYPE_ORDER) {
						TrackerSparqlTokenType _tmp49_;
						_tmp49_ = tracker_sparql_pattern_current (self);
						_tmp47_ = _tmp49_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
					} else {
						_tmp47_ = FALSE;
					}
					if (_tmp47_) {
						TrackerSparqlTokenType _tmp50_;
						_tmp50_ = tracker_sparql_pattern_current (self);
						_tmp46_ = _tmp50_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
					} else {
						_tmp46_ = FALSE;
					}
					if (_tmp46_) {
						TrackerSparqlTokenType _tmp51_;
						_tmp51_ = tracker_sparql_pattern_current (self);
						_tmp45_ = _tmp51_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						TrackerSparqlTokenType _tmp52_;
						_tmp52_ = tracker_sparql_pattern_current (self);
						_tmp44_ = _tmp52_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						TrackerSparqlTokenType _tmp53_;
						_tmp53_ = tracker_sparql_pattern_current (self);
						_tmp43_ = _tmp53_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
					} else {
						_tmp43_ = FALSE;
					}
					if (!_tmp43_) {
						break;
					}
				}
				_tmp42_ = FALSE;
				if (first_group) {
					first_group = FALSE;
				} else {
					g_string_append (sql, ", ");
				}
				tracker_sparql_expression_translate_expression (self->priv->expression, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	_tmp54_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
	_tmp55_ = _tmp54_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp55_) {
		gboolean first_order;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		g_string_append (sql, " ORDER BY ");
		first_order = TRUE;
		{
			gboolean _tmp56_;
			_tmp56_ = TRUE;
			while (TRUE) {
				if (!_tmp56_) {
					gboolean _tmp57_ = FALSE;
					gboolean _tmp58_ = FALSE;
					gboolean _tmp59_ = FALSE;
					gboolean _tmp60_ = FALSE;
					TrackerSparqlTokenType _tmp61_;
					_tmp61_ = tracker_sparql_pattern_current (self);
					if (_tmp61_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT) {
						TrackerSparqlTokenType _tmp62_;
						_tmp62_ = tracker_sparql_pattern_current (self);
						_tmp60_ = _tmp62_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
					} else {
						_tmp60_ = FALSE;
					}
					if (_tmp60_) {
						TrackerSparqlTokenType _tmp63_;
						_tmp63_ = tracker_sparql_pattern_current (self);
						_tmp59_ = _tmp63_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
					} else {
						_tmp59_ = FALSE;
					}
					if (_tmp59_) {
						TrackerSparqlTokenType _tmp64_;
						_tmp64_ = tracker_sparql_pattern_current (self);
						_tmp58_ = _tmp64_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
					} else {
						_tmp58_ = FALSE;
					}
					if (_tmp58_) {
						TrackerSparqlTokenType _tmp65_;
						_tmp65_ = tracker_sparql_pattern_current (self);
						_tmp57_ = _tmp65_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
					} else {
						_tmp57_ = FALSE;
					}
					if (!_tmp57_) {
						break;
					}
				}
				_tmp56_ = FALSE;
				if (first_order) {
					first_order = FALSE;
				} else {
					g_string_append (sql, ", ");
				}
				tracker_sparql_expression_translate_order_condition (self->priv->expression, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	limit = -1;
	offset = -1;
	_tmp66_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
	_tmp67_ = _tmp66_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp67_) {
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_;
		gint _tmp70_;
		gboolean _tmp71_;
		gboolean _tmp72_;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp68_ = tracker_sparql_pattern_get_last_string (self, 0);
		_tmp69_ = _tmp68_;
		_tmp70_ = atoi (_tmp69_);
		limit = _tmp70_;
		_g_free0 (_tmp69_);
		_tmp71_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
		_tmp72_ = _tmp71_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp72_) {
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_;
			gint _tmp75_;
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp73_ = tracker_sparql_pattern_get_last_string (self, 0);
			_tmp74_ = _tmp73_;
			_tmp75_ = atoi (_tmp74_);
			offset = _tmp75_;
			_g_free0 (_tmp74_);
		}
	} else {
		gboolean _tmp76_;
		gboolean _tmp77_;
		_tmp76_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
		_tmp77_ = _tmp76_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp77_) {
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_;
			gint _tmp80_;
			gboolean _tmp81_;
			gboolean _tmp82_;
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp78_ = tracker_sparql_pattern_get_last_string (self, 0);
			_tmp79_ = _tmp78_;
			_tmp80_ = atoi (_tmp79_);
			offset = _tmp80_;
			_g_free0 (_tmp79_);
			_tmp81_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
			_tmp82_ = _tmp81_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp82_) {
				gchar* _tmp83_ = NULL;
				gchar* _tmp84_;
				gint _tmp85_;
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp83_ = tracker_sparql_pattern_get_last_string (self, 0);
				_tmp84_ = _tmp83_;
				_tmp85_ = atoi (_tmp84_);
				limit = _tmp85_;
				_g_free0 (_tmp84_);
			}
		}
	}
	if (limit >= 0) {
		TrackerSparqlLiteralBinding* _tmp86_ = NULL;
		TrackerSparqlLiteralBinding* binding;
		gchar* _tmp87_ = NULL;
		TrackerSparqlLiteralBinding* _tmp88_;
		g_string_append (sql, " LIMIT ?");
		_tmp86_ = tracker_sparql_literal_binding_new ();
		binding = _tmp86_;
		_tmp87_ = g_strdup_printf ("%i", limit);
		_g_free0 (binding->literal);
		binding->literal = _tmp87_;
		((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
		_tmp88_ = _g_object_ref0 (binding);
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp88_);
		if (offset >= 0) {
			TrackerSparqlLiteralBinding* _tmp89_ = NULL;
			gchar* _tmp90_ = NULL;
			TrackerSparqlLiteralBinding* _tmp91_;
			g_string_append (sql, " OFFSET ?");
			_tmp89_ = tracker_sparql_literal_binding_new ();
			_g_object_unref0 (binding);
			binding = _tmp89_;
			_tmp90_ = g_strdup_printf ("%i", offset);
			_g_free0 (binding->literal);
			binding->literal = _tmp90_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			_tmp91_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp91_);
		}
		_g_object_unref0 (binding);
	} else {
		if (offset >= 0) {
			TrackerSparqlLiteralBinding* _tmp92_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gchar* _tmp93_ = NULL;
			TrackerSparqlLiteralBinding* _tmp94_;
			g_string_append (sql, " LIMIT -1 OFFSET ?");
			_tmp92_ = tracker_sparql_literal_binding_new ();
			binding = _tmp92_;
			_tmp93_ = g_strdup_printf ("%i", offset);
			_g_free0 (binding->literal);
			binding->literal = _tmp93_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			_tmp94_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp94_);
			_g_object_unref0 (binding);
		}
	}
	_tmp95_ = tracker_sparql_pattern_get_context (self);
	tracker_sparql_pattern_set_context (self, _tmp95_->parent_context);
	_result_->type = type;
	result = _result_;
	__g_list_free__g_object_unref0_0 (where_bindings);
	_tracker_sparql_context_unref0 (pattern);
	__g_list_free__g_object_unref0_0 (old_bindings);
	_g_string_free0 (pattern_sql);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error) {
	gboolean _is_var = FALSE;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	_is_var = FALSE;
	_tmp1_ = tracker_sparql_pattern_current (self);
	if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_is_var = TRUE;
		tracker_sparql_pattern_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			} else {
				_g_free0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = tracker_sparql_pattern_get_last_string (self, 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
		_g_free0 (_result_);
		_result_ = _tmp4_;
		_g_free0 (_tmp3_);
	} else {
		TrackerSparqlTokenType _tmp5_;
		_tmp5_ = tracker_sparql_pattern_current (self);
		if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
			gchar* _tmp6_ = NULL;
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp6_ = tracker_sparql_pattern_get_last_string (self, 1);
			_g_free0 (_result_);
			_result_ = _tmp6_;
		} else {
			TrackerSparqlTokenType _tmp7_;
			_tmp7_ = tracker_sparql_pattern_current (self);
			if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
				gchar* _tmp8_ = NULL;
				gchar* ns;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_;
				tracker_sparql_pattern_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp8_ = tracker_sparql_pattern_get_last_string (self, 0);
				ns = _tmp8_;
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp9_ = tracker_sparql_pattern_get_last_string (self, 0);
				_tmp10_ = _tmp9_;
				_tmp11_ = string_substring (_tmp10_, (glong) 1, (glong) (-1));
				_tmp12_ = _tmp11_;
				_tmp13_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp12_, &_inner_error_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				_tmp15_ = _tmp14_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (_result_);
				_result_ = _tmp15_;
				_g_free0 (ns);
			} else {
				TrackerSparqlTokenType _tmp16_;
				_tmp16_ = tracker_sparql_pattern_current (self);
				if (_tmp16_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					gchar* _tmp21_ = NULL;
					gchar* _tmp22_;
					gchar* _tmp23_;
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp17_ = tracker_sparql_pattern_get_last_string (self, 0);
					_tmp18_ = _tmp17_;
					_tmp19_ = string_substring (_tmp18_, (glong) 1, (glong) (-1));
					_tmp20_ = _tmp19_;
					_tmp21_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp20_, &_inner_error_);
					_tmp22_ = _tmp21_;
					_g_free0 (_tmp20_);
					_g_free0 (_tmp18_);
					_tmp23_ = _tmp22_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_free0 (_result_);
					_result_ = _tmp23_;
				} else {
					gboolean _tmp24_;
					gboolean _tmp25_;
					_tmp24_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
					_tmp25_ = _tmp24_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					if (_tmp25_) {
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						gchar* _tmp30_ = NULL;
						tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (_result_);
								return NULL;
							} else {
								_g_free0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp26_ = tracker_sparql_pattern_get_last_string (self, 0);
						_tmp27_ = _tmp26_;
						_tmp28_ = string_substring (_tmp27_, (glong) 1, (glong) (-1));
						_tmp29_ = _tmp28_;
						_tmp30_ = tracker_sparql_query_generate_bnodeid (self->priv->query, _tmp29_);
						_g_free0 (_result_);
						_result_ = _tmp30_;
						_g_free0 (_tmp29_);
						_g_free0 (_tmp27_);
					} else {
						TrackerSparqlTokenType _tmp31_;
						_tmp31_ = tracker_sparql_pattern_current (self);
						if (_tmp31_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
							gchar* _tmp32_ = NULL;
							gchar* _tmp33_;
							_tmp32_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
							_tmp33_ = _tmp32_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_result_);
									return NULL;
								} else {
									_g_free0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_g_free0 (_result_);
							_result_ = _tmp33_;
						} else {
							TrackerSparqlTokenType _tmp34_;
							_tmp34_ = tracker_sparql_pattern_current (self);
							if (_tmp34_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_;
								_tmp35_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
								_tmp36_ = _tmp35_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_g_free0 (_result_);
								_result_ = _tmp36_;
							} else {
								TrackerSparqlTokenType _tmp37_;
								_tmp37_ = tracker_sparql_pattern_current (self);
								if (_tmp37_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
									gchar* _tmp38_ = NULL;
									gchar* _tmp39_;
									_tmp38_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
									_tmp39_ = _tmp38_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (_result_);
											return NULL;
										} else {
											_g_free0 (_result_);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_g_free0 (_result_);
									_result_ = _tmp39_;
								} else {
									TrackerSparqlTokenType _tmp40_;
									_tmp40_ = tracker_sparql_pattern_current (self);
									if (_tmp40_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
										gchar* _tmp41_ = NULL;
										gchar* _tmp42_;
										_tmp41_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
										_tmp42_ = _tmp41_;
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (_result_);
												return NULL;
											} else {
												_g_free0 (_result_);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_g_free0 (_result_);
										_result_ = _tmp42_;
									} else {
										TrackerSparqlTokenType _tmp43_;
										_tmp43_ = tracker_sparql_pattern_current (self);
										if (_tmp43_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
											gchar* _tmp44_ = NULL;
											tracker_sparql_pattern_next (self, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													_g_free0 (_result_);
													return NULL;
												} else {
													_g_free0 (_result_);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return NULL;
												}
											}
											_tmp44_ = tracker_sparql_pattern_get_last_string (self, 0);
											_g_free0 (_result_);
											_result_ = _tmp44_;
										} else {
											TrackerSparqlTokenType _tmp45_;
											_tmp45_ = tracker_sparql_pattern_current (self);
											if (_tmp45_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
												gchar* _tmp46_ = NULL;
												tracker_sparql_pattern_next (self, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (_result_);
														return NULL;
													} else {
														_g_free0 (_result_);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_tmp46_ = tracker_sparql_pattern_get_last_string (self, 0);
												_g_free0 (_result_);
												_result_ = _tmp46_;
											} else {
												TrackerSparqlTokenType _tmp47_;
												_tmp47_ = tracker_sparql_pattern_current (self);
												if (_tmp47_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
													gchar* _tmp48_ = NULL;
													tracker_sparql_pattern_next (self, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (_result_);
															return NULL;
														} else {
															_g_free0 (_result_);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													_tmp48_ = tracker_sparql_pattern_get_last_string (self, 0);
													_g_free0 (_result_);
													_result_ = _tmp48_;
												} else {
													TrackerSparqlTokenType _tmp49_;
													_tmp49_ = tracker_sparql_pattern_current (self);
													if (_tmp49_ == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
														gchar* _tmp50_;
														tracker_sparql_pattern_next (self, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																_g_free0 (_result_);
																return NULL;
															} else {
																_g_free0 (_result_);
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return NULL;
															}
														}
														_tmp50_ = g_strdup ("true");
														_g_free0 (_result_);
														_result_ = _tmp50_;
													} else {
														TrackerSparqlTokenType _tmp51_;
														_tmp51_ = tracker_sparql_pattern_current (self);
														if (_tmp51_ == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
															gchar* _tmp52_;
															tracker_sparql_pattern_next (self, &_inner_error_);
															if (_inner_error_ != NULL) {
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
															_tmp52_ = g_strdup ("false");
															_g_free0 (_result_);
															_result_ = _tmp52_;
														} else {
															TrackerSparqlTokenType _tmp53_;
															_tmp53_ = tracker_sparql_pattern_current (self);
															if (_tmp53_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
																gchar* _tmp54_ = NULL;
																gchar* _tmp55_;
																gchar* old_subject;
																gboolean old_subject_is_var;
																gchar* _tmp56_;
																gchar* _tmp57_;
																tracker_sparql_pattern_next (self, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_tmp54_ = tracker_sparql_query_generate_bnodeid (self->priv->query, NULL);
																_g_free0 (_result_);
																_result_ = _tmp54_;
																_tmp55_ = g_strdup (self->priv->current_subject);
																old_subject = _tmp55_;
																old_subject_is_var = self->priv->current_subject_is_var;
																_tmp56_ = g_strdup (_result_);
																_g_free0 (self->priv->current_subject);
																self->priv->current_subject = _tmp56_;
																self->priv->current_subject_is_var = TRUE;
																tracker_sparql_pattern_parse_property_list_not_empty (self, sql, FALSE, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_tmp57_ = g_strdup (old_subject);
																_g_free0 (self->priv->current_subject);
																self->priv->current_subject = _tmp57_;
																self->priv->current_subject_is_var = old_subject_is_var;
																_is_var = TRUE;
																_g_free0 (old_subject);
															} else {
																GError* _tmp58_ = NULL;
																_tmp58_ = tracker_sparql_pattern_get_error (self, "expected variable or term");
																_inner_error_ = _tmp58_;
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	if (is_var) {
		*is_var = _is_var;
	}
	return result;
}


static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		tracker_sparql_pattern_parse_object (self, sql, in_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp0_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp1_) {
			continue;
		}
		break;
	}
}


static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	while (TRUE) {
		gchar* _tmp0_;
		gchar* old_predicate;
		gboolean old_predicate_is_var;
		TrackerSparqlTokenType _tmp1_;
		gchar* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp0_ = g_strdup (self->priv->current_predicate);
		old_predicate = _tmp0_;
		old_predicate_is_var = self->priv->current_predicate_is_var;
		_g_free0 (self->priv->current_predicate);
		self->priv->current_predicate = NULL;
		self->priv->current_predicate_is_var = FALSE;
		_tmp1_ = tracker_sparql_pattern_current (self);
		if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			self->priv->current_predicate_is_var = TRUE;
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_predicate);
					return;
				} else {
					_g_free0 (old_predicate);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp2_ = tracker_sparql_pattern_get_last_string (self, 0);
			_tmp3_ = _tmp2_;
			_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
			_g_free0 (self->priv->current_predicate);
			self->priv->current_predicate = _tmp4_;
			_g_free0 (_tmp3_);
		} else {
			TrackerSparqlTokenType _tmp5_;
			_tmp5_ = tracker_sparql_pattern_current (self);
			if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
				gchar* _tmp6_ = NULL;
				tracker_sparql_pattern_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_predicate);
						return;
					} else {
						_g_free0 (old_predicate);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp6_ = tracker_sparql_pattern_get_last_string (self, 1);
				_g_free0 (self->priv->current_predicate);
				self->priv->current_predicate = _tmp6_;
			} else {
				TrackerSparqlTokenType _tmp7_;
				_tmp7_ = tracker_sparql_pattern_current (self);
				if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
					gchar* _tmp8_ = NULL;
					gchar* ns;
					gchar* _tmp9_ = NULL;
					gchar* _tmp10_;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					gchar* _tmp15_;
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp8_ = tracker_sparql_pattern_get_last_string (self, 0);
					ns = _tmp8_;
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp9_ = tracker_sparql_pattern_get_last_string (self, 0);
					_tmp10_ = _tmp9_;
					_tmp11_ = string_substring (_tmp10_, (glong) 1, (glong) (-1));
					_tmp12_ = _tmp11_;
					_tmp13_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp12_, &_inner_error_);
					_tmp14_ = _tmp13_;
					_g_free0 (_tmp12_);
					_g_free0 (_tmp10_);
					_tmp15_ = _tmp14_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_g_free0 (self->priv->current_predicate);
					self->priv->current_predicate = _tmp15_;
					_g_free0 (ns);
				} else {
					TrackerSparqlTokenType _tmp16_;
					_tmp16_ = tracker_sparql_pattern_current (self);
					if (_tmp16_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
						gchar* _tmp17_ = NULL;
						gchar* _tmp18_;
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_;
						gchar* _tmp23_;
						tracker_sparql_pattern_next (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp17_ = tracker_sparql_pattern_get_last_string (self, 0);
						_tmp18_ = _tmp17_;
						_tmp19_ = string_substring (_tmp18_, (glong) 1, (glong) (-1));
						_tmp20_ = _tmp19_;
						_tmp21_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp20_, &_inner_error_);
						_tmp22_ = _tmp21_;
						_g_free0 (_tmp20_);
						_g_free0 (_tmp18_);
						_tmp23_ = _tmp22_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_g_free0 (self->priv->current_predicate);
						self->priv->current_predicate = _tmp23_;
					} else {
						TrackerSparqlTokenType _tmp24_;
						_tmp24_ = tracker_sparql_pattern_current (self);
						if (_tmp24_ == TRACKER_SPARQL_TOKEN_TYPE_A) {
							gchar* _tmp25_;
							tracker_sparql_pattern_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp25_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
							_g_free0 (self->priv->current_predicate);
							self->priv->current_predicate = _tmp25_;
						} else {
							GError* _tmp26_ = NULL;
							_tmp26_ = tracker_sparql_pattern_get_error (self, "expected non-empty property list");
							_inner_error_ = _tmp26_;
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
		tracker_sparql_pattern_parse_object_list (self, sql, in_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp27_ = g_strdup (old_predicate);
		_g_free0 (self->priv->current_predicate);
		self->priv->current_predicate = _tmp27_;
		self->priv->current_predicate_is_var = old_predicate_is_var;
		_tmp28_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		_tmp29_ = _tmp28_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp29_) {
			TrackerSparqlTokenType _tmp30_;
			_tmp30_ = tracker_sparql_pattern_current (self);
			if (_tmp30_ == TRACKER_SPARQL_TOKEN_TYPE_DOT) {
				_g_free0 (old_predicate);
				break;
			}
			_g_free0 (old_predicate);
			continue;
		}
		_g_free0 (old_predicate);
		break;
	}
}


static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_translate_constraint (self->priv->expression, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error) {
	TrackerSparqlTokenType _tmp0_;
	gint n_parens;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_pattern_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	n_parens = 1;
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		if (!(n_parens > 0)) {
			break;
		}
		_tmp1_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp2_) {
			n_parens++;
		} else {
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp3_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp4_) {
				n_parens--;
			} else {
				TrackerSparqlTokenType _tmp5_;
				_tmp5_ = tracker_sparql_pattern_current (self);
				if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
					GError* _tmp6_ = NULL;
					_tmp6_ = tracker_sparql_pattern_get_error (self, "unexpected end of query, expected )");
					_inner_error_ = _tmp6_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlContext* _tmp0_ = NULL;
	TrackerSparqlPatternTripleContext* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_pattern_get_context (self);
	_tmp1_ = tracker_sparql_pattern_triple_context_new (_tmp0_);
	_tracker_sparql_context_unref0 (self->priv->triple_context);
	self->priv->triple_context = _tmp1_;
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) self->priv->triple_context);
	g_string_append (sql, "SELECT ");
}


static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error) {
	gboolean first;
	TrackerSparqlContext* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	TrackerSparqlContext* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_string_truncate (sql, (gsize) (sql->len - 2));
	g_string_append (sql, " FROM ");
	first = TRUE;
	{
		GList* table_collection;
		GList* table_it;
		table_collection = self->priv->triple_context->tables;
		for (table_it = table_collection; table_it != NULL; table_it = table_it->next) {
			TrackerSparqlDataTable* _tmp0_;
			TrackerSparqlDataTable* table;
			_tmp0_ = _g_object_ref0 ((TrackerSparqlDataTable*) table_it->data);
			table = _tmp0_;
			{
				if (!first) {
					g_string_append (sql, ", ");
				} else {
					first = FALSE;
				}
				if (table->sql_db_tablename != NULL) {
					g_string_append_printf (sql, "\"%s\"", table->sql_db_tablename);
				} else {
					gchar* _tmp1_ = NULL;
					gchar* _tmp2_;
					gchar* _tmp3_;
					_tmp1_ = tracker_sparql_predicate_variable_get_sql_query (table->predicate_variable, self->priv->query, &_inner_error_);
					_tmp2_ = _tmp1_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (table);
							return;
						} else {
							_g_object_unref0 (table);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp3_ = _tmp2_;
					g_string_append_printf (sql, "(%s)", _tmp3_);
					_g_free0 (_tmp3_);
				}
				g_string_append_printf (sql, " AS \"%s\"", table->sql_query_tablename);
				_g_object_unref0 (table);
			}
		}
	}
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = self->priv->triple_context->variables;
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* _tmp4_;
			TrackerSparqlVariable* variable;
			_tmp4_ = _g_object_ref0 ((TrackerSparqlVariable*) variable_it->data);
			variable = _tmp4_;
			{
				gboolean maybe_null;
				gboolean in_simple_optional;
				gchar* last_name;
				gconstpointer _tmp5_ = NULL;
				gboolean _tmp12_ = FALSE;
				maybe_null = TRUE;
				in_simple_optional = FALSE;
				last_name = NULL;
				_tmp5_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, variable);
				{
					GList* binding_collection;
					GList* binding_it;
					binding_collection = ((TrackerSparqlVariableBindingList*) _tmp5_)->list;
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
						TrackerSparqlVariableBinding* _tmp6_;
						TrackerSparqlVariableBinding* binding;
						_tmp6_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
						binding = _tmp6_;
						{
							gchar* name = NULL;
							gchar* _tmp11_;
							if (((TrackerSparqlDataBinding*) binding)->table != NULL) {
								const gchar* _tmp7_ = NULL;
								gchar* _tmp8_;
								_tmp7_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding);
								_tmp8_ = g_strdup (_tmp7_);
								_g_free0 (name);
								name = _tmp8_;
							} else {
								const gchar* _tmp9_ = NULL;
								gchar* _tmp10_;
								_tmp9_ = tracker_sparql_variable_get_sql_expression (variable);
								_tmp10_ = g_strdup (_tmp9_);
								_g_free0 (name);
								name = _tmp10_;
							}
							if (last_name != NULL) {
								if (!(*first_where)) {
									g_string_append (sql, " AND ");
								} else {
									g_string_append (sql, " WHERE ");
									*first_where = FALSE;
								}
								g_string_append (sql, last_name);
								g_string_append (sql, " = ");
								g_string_append (sql, name);
							}
							_tmp11_ = g_strdup (name);
							_g_free0 (last_name);
							last_name = _tmp11_;
							if (!binding->maybe_null) {
								maybe_null = FALSE;
							}
							in_simple_optional = binding->in_simple_optional;
							_g_free0 (name);
							_g_object_unref0 (binding);
						}
					}
				}
				if (maybe_null) {
					_tmp12_ = !in_simple_optional;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					const gchar* _tmp13_ = NULL;
					if (!(*first_where)) {
						g_string_append (sql, " AND ");
					} else {
						g_string_append (sql, " WHERE ");
						*first_where = FALSE;
					}
					_tmp13_ = tracker_sparql_variable_get_sql_expression (variable);
					g_string_append_printf (sql, "%s IS NOT NULL", _tmp13_);
				}
				_g_free0 (last_name);
				_g_object_unref0 (variable);
			}
		}
	}
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = self->priv->triple_context->bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlLiteralBinding* _tmp14_;
			TrackerSparqlLiteralBinding* binding;
			_tmp14_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
			binding = _tmp14_;
			{
				const gchar* _tmp15_ = NULL;
				if (!(*first_where)) {
					g_string_append (sql, " AND ");
				} else {
					g_string_append (sql, " WHERE ");
					*first_where = FALSE;
				}
				_tmp15_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding);
				g_string_append (sql, _tmp15_);
				if (binding->is_fts_match) {
					gchar** _tmp16_;
					gchar** _tmp17_ = NULL;
					gchar** _tmp18_;
					gint _tmp18__length1;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					gchar* escaped_literal;
					_tmp17_ = _tmp16_ = g_strsplit (binding->literal, "'", 0);
					_tmp18_ = _tmp17_;
					_tmp18__length1 = _vala_array_length (_tmp16_);
					_tmp19_ = g_strjoinv ("''", _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
					escaped_literal = _tmp20_;
					g_string_append_printf (sql, " MATCH '%s'", escaped_literal);
					_g_free0 (escaped_literal);
				} else {
					TrackerSparqlLiteralBinding* _tmp21_;
					g_string_append (sql, " = ");
					if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
						g_string_append (sql, "(SELECT ID FROM Resource WHERE Uri = ?)");
					} else {
						g_string_append (sql, "?");
					}
					_tmp21_ = _g_object_ref0 (binding);
					self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp21_);
				}
				_g_object_unref0 (binding);
			}
		}
	}
	if (in_group_graph_pattern) {
		g_string_append (sql, ")");
	}
	_tmp22_ = tracker_sparql_pattern_get_context (self);
	_tmp23_ = g_hash_table_get_keys (_tmp22_->var_set);
	{
		GList* v_collection;
		GList* v_it;
		v_collection = _tmp23_;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			TrackerSparqlVariable* v;
			v = (TrackerSparqlVariable*) v_it->data;
			{
				TrackerSparqlContext* _tmp24_ = NULL;
				TrackerSparqlVariable* _tmp25_;
				_tmp24_ = tracker_sparql_pattern_get_context (self);
				_tmp25_ = _g_object_ref0 (v);
				g_hash_table_insert (_tmp24_->parent_context->var_set, _tmp25_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
			}
		}
		_g_list_free0 (v_collection);
	}
	_tracker_sparql_context_unref0 (self->priv->triple_context);
	self->priv->triple_context = NULL;
	_tmp26_ = tracker_sparql_pattern_get_context (self);
	tracker_sparql_pattern_set_context (self, _tmp26_->parent_context);
}


static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		TrackerSparqlTokenType _tmp4_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp4_ = tracker_sparql_pattern_current (self);
		if (_tmp4_ != TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			TrackerSparqlTokenType _tmp5_;
			_tmp5_ = tracker_sparql_pattern_current (self);
			_tmp3_ = _tmp5_ != TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			TrackerSparqlTokenType _tmp6_;
			_tmp6_ = tracker_sparql_pattern_current (self);
			_tmp2_ = _tmp6_ != TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			TrackerSparqlTokenType _tmp7_;
			_tmp7_ = tracker_sparql_pattern_current (self);
			_tmp1_ = _tmp7_ != TRACKER_SPARQL_TOKEN_TYPE_COLON;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			TrackerSparqlTokenType _tmp8_;
			_tmp8_ = tracker_sparql_pattern_current (self);
			_tmp0_ = _tmp8_ != TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			break;
		}
		if (*in_triples_block) {
			_tmp10_ = !(*in_group_graph_pattern);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = found_simple_optional;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			tracker_sparql_pattern_end_triples_block (self, sql, first_where, *in_group_graph_pattern, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			*in_triples_block = FALSE;
			*in_group_graph_pattern = TRUE;
		}
		if (!(*in_triples_block)) {
			if (*in_group_graph_pattern) {
				g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
				g_string_append (sql, ") NATURAL INNER JOIN (");
			}
			*in_triples_block = TRUE;
			*first_where = TRUE;
			tracker_sparql_pattern_start_triples_block (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		_tmp12_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &_tmp11_, &_inner_error_);
		self->priv->current_subject_is_var = _tmp11_;
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (self->priv->current_subject);
		self->priv->current_subject = _tmp13_;
		tracker_sparql_pattern_parse_property_list_not_empty (self, sql, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp14_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp15_) {
			break;
		}
	}
}


static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2) {
	gboolean result = FALSE;
	TrackerClass** _tmp0_;
	TrackerClass** _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (class1 != NULL, FALSE);
	g_return_val_if_fail (class2 != NULL, FALSE);
	if (class1 == class2) {
		result = TRUE;
		return result;
	}
	_tmp1_ = _tmp0_ = tracker_class_get_super_classes (class1);
	{
		TrackerClass** superclass_collection;
		int superclass_collection_length1;
		int superclass_it;
		superclass_collection = _tmp1_;
		superclass_collection_length1 = _vala_array_length (_tmp0_);
		for (superclass_it = 0; superclass_it < _vala_array_length (_tmp0_); superclass_it = superclass_it + 1) {
			TrackerClass* _tmp2_;
			TrackerClass* superclass;
			_tmp2_ = _g_object_ref0 (superclass_collection[superclass_it]);
			superclass = _tmp2_;
			{
				gboolean _tmp3_;
				_tmp3_ = tracker_sparql_pattern_is_subclass (self, superclass, class2);
				if (_tmp3_) {
					result = TRUE;
					_g_object_unref0 (superclass);
					return result;
				}
				_g_object_unref0 (superclass);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self) {
	gboolean result = FALSE;
	TrackerSourceLocation _tmp0_ = {0};
	TrackerSourceLocation _tmp1_ = {0};
	TrackerSourceLocation optional_start;
	gboolean _tmp2_;
	gboolean _tmp3_;
	TrackerSparqlContext* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	TrackerSparqlVariable* _tmp9_ = NULL;
	TrackerSparqlVariable* _tmp10_;
	TrackerSparqlVariable* _tmp11_;
	TrackerSparqlVariable* left_variable;
	TrackerSparqlContext* _tmp12_ = NULL;
	gconstpointer _tmp13_ = NULL;
	gint left_variable_state;
	gchar* predicate = NULL;
	gboolean _tmp14_;
	gboolean _tmp15_;
	TrackerProperty* _tmp36_ = NULL;
	TrackerProperty* _tmp37_;
	TrackerProperty* prop;
	gboolean _tmp38_;
	gboolean _tmp39_;
	TrackerSparqlContext* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	TrackerSparqlVariable* _tmp45_ = NULL;
	TrackerSparqlVariable* _tmp46_;
	TrackerSparqlVariable* _tmp47_;
	TrackerSparqlVariable* right_variable;
	TrackerSparqlContext* _tmp48_ = NULL;
	gconstpointer _tmp49_ = NULL;
	gint right_variable_state;
	gboolean _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	tracker_sparql_pattern_get_location (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	optional_start = _tmp1_;
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (!_tmp3_) {
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		return result;
	}
	_tmp4_ = tracker_sparql_pattern_get_context (self);
	_tmp5_ = tracker_sparql_pattern_get_last_string (self, 0);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_substring (_tmp6_, (glong) 1, (glong) (-1));
	_tmp8_ = _tmp7_;
	_tmp9_ = tracker_sparql_context_get_variable (_tmp4_, _tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	left_variable = _tmp11_;
	_tmp12_ = tracker_sparql_pattern_get_context (self);
	_tmp13_ = g_hash_table_lookup (_tmp12_->var_set, left_variable);
	left_variable_state = GPOINTER_TO_INT (_tmp13_);
	_tmp14_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (_tmp15_) {
		gchar* _tmp16_ = NULL;
		_tmp16_ = tracker_sparql_pattern_get_last_string (self, 1);
		_g_free0 (predicate);
		predicate = _tmp16_;
	} else {
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp17_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		_tmp18_ = _tmp17_;
		if (_inner_error_ != NULL) {
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			tracker_sparql_pattern_set_location (self, &optional_start);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (_tmp18_) {
			gchar* _tmp19_ = NULL;
			gchar* ns;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp19_ = tracker_sparql_pattern_get_last_string (self, 0);
			ns = _tmp19_;
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (ns);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch1_tracker_sparql_error;
				}
				_g_free0 (ns);
				tracker_sparql_pattern_set_location (self, &optional_start);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp20_ = tracker_sparql_pattern_get_last_string (self, 0);
			_tmp21_ = _tmp20_;
			_tmp22_ = string_substring (_tmp21_, (glong) 1, (glong) (-1));
			_tmp23_ = _tmp22_;
			_tmp24_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp23_, &_inner_error_);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			_g_free0 (_tmp21_);
			_tmp26_ = _tmp25_;
			if (_inner_error_ != NULL) {
				_g_free0 (ns);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch1_tracker_sparql_error;
				}
				_g_free0 (ns);
				tracker_sparql_pattern_set_location (self, &optional_start);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_g_free0 (predicate);
			predicate = _tmp26_;
			_g_free0 (ns);
		} else {
			gboolean _tmp27_;
			gboolean _tmp28_;
			_tmp27_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			_tmp28_ = _tmp27_;
			if (_inner_error_ != NULL) {
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch1_tracker_sparql_error;
				}
				tracker_sparql_pattern_set_location (self, &optional_start);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp28_) {
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp29_ = tracker_sparql_pattern_get_last_string (self, 0);
				_tmp30_ = _tmp29_;
				_tmp31_ = string_substring (_tmp30_, (glong) 1, (glong) (-1));
				_tmp32_ = _tmp31_;
				_tmp33_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp32_, &_inner_error_);
				_tmp34_ = _tmp33_;
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				_tmp35_ = _tmp34_;
				if (_inner_error_ != NULL) {
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						goto __catch1_tracker_sparql_error;
					}
					tracker_sparql_pattern_set_location (self, &optional_start);
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_g_free0 (predicate);
				predicate = _tmp35_;
			} else {
				result = FALSE;
				tracker_sparql_pattern_set_location (self, &optional_start);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				return result;
			}
		}
	}
	_tmp36_ = tracker_ontologies_get_property_by_uri (predicate);
	_tmp37_ = _g_object_ref0 (_tmp36_);
	prop = _tmp37_;
	if (prop == NULL) {
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		return result;
	}
	_tmp38_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
	_tmp39_ = _tmp38_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (!_tmp39_) {
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		return result;
	}
	_tmp40_ = tracker_sparql_pattern_get_context (self);
	_tmp41_ = tracker_sparql_pattern_get_last_string (self, 0);
	_tmp42_ = _tmp41_;
	_tmp43_ = string_substring (_tmp42_, (glong) 1, (glong) (-1));
	_tmp44_ = _tmp43_;
	_tmp45_ = tracker_sparql_context_get_variable (_tmp40_, _tmp44_);
	_tmp46_ = _g_object_ref0 (_tmp45_);
	_tmp47_ = _tmp46_;
	_g_free0 (_tmp44_);
	_g_free0 (_tmp42_);
	right_variable = _tmp47_;
	_tmp48_ = tracker_sparql_pattern_get_context (self);
	_tmp49_ = g_hash_table_lookup (_tmp48_->var_set, right_variable);
	right_variable_state = GPOINTER_TO_INT (_tmp49_);
	tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp50_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	_tmp51_ = _tmp50_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (!_tmp51_) {
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		return result;
	}
	if (left_variable_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND) {
		gboolean _tmp54_;
		_tmp54_ = tracker_property_get_multiple_values (prop);
		_tmp53_ = !_tmp54_;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		_tmp52_ = right_variable_state == 0;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		gboolean in_domain;
		gconstpointer _tmp55_ = NULL;
		in_domain = FALSE;
		_tmp55_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, left_variable);
		{
			GList* binding_collection;
			GList* binding_it;
			binding_collection = ((TrackerSparqlVariableBindingList*) _tmp55_)->list;
			for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
				TrackerSparqlVariableBinding* _tmp56_;
				TrackerSparqlVariableBinding* binding;
				_tmp56_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
				binding = _tmp56_;
				{
					gboolean _tmp57_ = FALSE;
					if (binding->type != NULL) {
						TrackerClass* _tmp58_ = NULL;
						gboolean _tmp59_;
						_tmp58_ = tracker_property_get_domain (prop);
						_tmp59_ = tracker_sparql_pattern_is_subclass (self, binding->type, _tmp58_);
						_tmp57_ = _tmp59_;
					} else {
						_tmp57_ = FALSE;
					}
					if (_tmp57_) {
						in_domain = TRUE;
						_g_object_unref0 (binding);
						break;
					}
					_g_object_unref0 (binding);
				}
			}
		}
		if (in_domain) {
			result = TRUE;
			tracker_sparql_pattern_set_location (self, &optional_start);
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			return result;
		}
	} else {
		gboolean _tmp60_ = FALSE;
		gboolean _tmp61_ = FALSE;
		if (left_variable_state == 0) {
			gboolean _tmp62_;
			_tmp62_ = tracker_property_get_is_inverse_functional_property (prop);
			_tmp61_ = _tmp62_;
		} else {
			_tmp61_ = FALSE;
		}
		if (_tmp61_) {
			_tmp60_ = right_variable_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND;
		} else {
			_tmp60_ = FALSE;
		}
		if (_tmp60_) {
			result = TRUE;
			tracker_sparql_pattern_set_location (self, &optional_start);
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			return result;
		}
	}
	result = FALSE;
	tracker_sparql_pattern_set_location (self, &optional_start);
	_g_object_unref0 (right_variable);
	_g_object_unref0 (prop);
	_g_free0 (predicate);
	_g_object_unref0 (left_variable);
	return result;
	_g_object_unref0 (right_variable);
	_g_object_unref0 (prop);
	_g_free0 (predicate);
	_g_object_unref0 (left_variable);
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	tracker_sparql_pattern_set_location (self, &optional_start);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _vala_array_add1 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSourceLocation, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlContext* result = NULL;
	TrackerSparqlTokenType _tmp0_;
	TrackerSparqlContext* _tmp8_ = NULL;
	TrackerSparqlContext* _tmp9_ = NULL;
	TrackerSparqlContext* _result_;
	TrackerSourceLocation* _tmp10_ = NULL;
	TrackerSourceLocation* filters;
	gint filters_length1;
	gint _filters_size_;
	gboolean in_triples_block;
	gboolean in_group_graph_pattern;
	gboolean first_where;
	gboolean found_simple_optional;
	glong group_graph_pattern_start;
	gboolean _tmp58_ = FALSE;
	TrackerSparqlContext* _tmp61_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = tracker_sparql_pattern_current (self);
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
		TrackerSparqlSelectContext* _tmp1_ = NULL;
		TrackerSparqlSelectContext* _result_;
		TrackerSparqlContext* _tmp2_ = NULL;
		TrackerSparqlContext* _tmp3_ = NULL;
		GHashTable* _tmp4_;
		TrackerSparqlContext* _tmp5_ = NULL;
		GHashTable* _tmp6_ = NULL;
		TrackerSparqlContext* _tmp7_ = NULL;
		_tmp1_ = tracker_sparql_pattern_translate_select (self, sql, TRUE, FALSE, &_inner_error_);
		_result_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _result_);
		_tmp2_ = tracker_sparql_pattern_get_context (self);
		_tmp3_ = tracker_sparql_pattern_get_context (self);
		_tmp4_ = _g_hash_table_ref0 (_tmp3_->select_var_set);
		_g_hash_table_unref0 (_tmp2_->var_set);
		_tmp2_->var_set = _tmp4_;
		_tmp5_ = tracker_sparql_pattern_get_context (self);
		_tmp6_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, NULL);
		_g_hash_table_unref0 (_tmp5_->select_var_set);
		_tmp5_->select_var_set = _tmp6_;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp7_ = tracker_sparql_pattern_get_context (self);
		tracker_sparql_pattern_set_context (self, _tmp7_->parent_context);
		result = (TrackerSparqlContext*) _result_;
		return result;
	}
	_tmp8_ = tracker_sparql_pattern_get_context (self);
	_tmp9_ = tracker_sparql_context_new (_tmp8_);
	_result_ = _tmp9_;
	tracker_sparql_pattern_set_context (self, _result_);
	_tmp10_ = g_new0 (TrackerSourceLocation, 0);
	filters = _tmp10_;
	filters_length1 = 0;
	_filters_size_ = 0;
	in_triples_block = FALSE;
	in_group_graph_pattern = FALSE;
	first_where = TRUE;
	found_simple_optional = FALSE;
	group_graph_pattern_start = (glong) sql->len;
	tracker_sparql_pattern_parse_triples (self, sql, group_graph_pattern_start, &in_triples_block, &first_where, &in_group_graph_pattern, found_simple_optional, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, &_inner_error_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp12_) {
			gboolean _tmp13_ = FALSE;
			if (!in_group_graph_pattern) {
				gboolean _tmp14_;
				_tmp14_ = tracker_sparql_pattern_is_simple_optional (self);
				_tmp13_ = _tmp14_;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				gboolean _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				found_simple_optional = TRUE;
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp16_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &_tmp15_, &_inner_error_);
				self->priv->current_subject_is_var = _tmp15_;
				_tmp17_ = _tmp16_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (self->priv->current_subject);
				self->priv->current_subject = _tmp17_;
				tracker_sparql_pattern_parse_property_list_not_empty (self, sql, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			} else {
				gboolean _tmp18_ = FALSE;
				GString* _tmp19_ = NULL;
				GString* select;
				gint left_index;
				gint right_index;
				TrackerSparqlContext* _tmp20_ = NULL;
				TrackerSparqlContext* _tmp21_;
				TrackerSparqlContext* _tmp22_;
				gboolean first;
				gboolean first_common;
				TrackerSparqlContext* _tmp23_ = NULL;
				GList* _tmp24_ = NULL;
				TrackerSparqlContext* _tmp39_ = NULL;
				GList* _tmp40_ = NULL;
				TrackerSparqlContext* _tmp44_ = NULL;
				if (!in_triples_block) {
					_tmp18_ = !in_group_graph_pattern;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					g_string_append (sql, "SELECT 1");
				} else {
					if (in_triples_block) {
						tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						in_triples_block = FALSE;
					}
				}
				if (!in_group_graph_pattern) {
					in_group_graph_pattern = TRUE;
				}
				_tmp19_ = g_string_new ("SELECT ");
				select = _tmp19_;
				self->priv->next_table_index = self->priv->next_table_index + 1;
				left_index = self->priv->next_table_index;
				self->priv->next_table_index = self->priv->next_table_index + 1;
				right_index = self->priv->next_table_index;
				g_string_append_printf (sql, ") AS t%d_g LEFT JOIN (", left_index);
				_tmp20_ = tracker_sparql_pattern_translate_group_graph_pattern (self, sql, &_inner_error_);
				_tmp21_ = _tmp20_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (select);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						_g_string_free0 (select);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp22_ = _tmp21_;
				tracker_sparql_pattern_set_context (self, _tmp22_);
				_tracker_sparql_context_unref0 (_tmp22_);
				g_string_append_printf (sql, ") AS t%d_g", right_index);
				first = TRUE;
				first_common = TRUE;
				_tmp23_ = tracker_sparql_pattern_get_context (self);
				_tmp24_ = g_hash_table_get_keys (_tmp23_->var_set);
				{
					GList* v_collection;
					GList* v_it;
					v_collection = _tmp24_;
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
						TrackerSparqlVariable* v;
						v = (TrackerSparqlVariable*) v_it->data;
						{
							TrackerSparqlContext* _tmp25_ = NULL;
							gconstpointer _tmp26_ = NULL;
							gint old_state;
							if (first) {
								first = FALSE;
							} else {
								g_string_append (select, ", ");
							}
							_tmp25_ = tracker_sparql_pattern_get_context (self);
							_tmp26_ = g_hash_table_lookup (_tmp25_->parent_context->var_set, v);
							old_state = GPOINTER_TO_INT (_tmp26_);
							if (old_state == 0) {
								TrackerSparqlContext* _tmp27_ = NULL;
								TrackerSparqlVariable* _tmp28_;
								const gchar* _tmp29_ = NULL;
								_tmp27_ = tracker_sparql_pattern_get_context (self);
								_tmp28_ = _g_object_ref0 (v);
								g_hash_table_insert (_tmp27_->parent_context->var_set, _tmp28_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL));
								_tmp29_ = tracker_sparql_variable_get_sql_expression (v);
								g_string_append_printf (select, "t%d_g.%s", right_index, _tmp29_);
							} else {
								if (first_common) {
									g_string_append (sql, " ON ");
									first_common = FALSE;
								} else {
									g_string_append (sql, " AND ");
								}
								if (old_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND) {
									const gchar* _tmp30_ = NULL;
									const gchar* _tmp31_ = NULL;
									const gchar* _tmp32_ = NULL;
									_tmp30_ = tracker_sparql_variable_get_sql_expression (v);
									_tmp31_ = tracker_sparql_variable_get_sql_expression (v);
									g_string_append_printf (sql, "t%d_g.%s = t%d_g.%s", left_index, _tmp30_, right_index, _tmp31_);
									_tmp32_ = tracker_sparql_variable_get_sql_expression (v);
									g_string_append_printf (select, "t%d_g.%s", left_index, _tmp32_);
								} else {
									if (old_state == TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL) {
										const gchar* _tmp33_ = NULL;
										const gchar* _tmp34_ = NULL;
										const gchar* _tmp35_ = NULL;
										const gchar* _tmp36_ = NULL;
										const gchar* _tmp37_ = NULL;
										const gchar* _tmp38_ = NULL;
										_tmp33_ = tracker_sparql_variable_get_sql_expression (v);
										_tmp34_ = tracker_sparql_variable_get_sql_expression (v);
										_tmp35_ = tracker_sparql_variable_get_sql_expression (v);
										g_string_append_printf (sql, "(t%d_g.%s IS NULL OR t%d_g.%s = t%d_g.%s)", left_index, _tmp33_, left_index, _tmp34_, right_index, _tmp35_);
										_tmp36_ = tracker_sparql_variable_get_sql_expression (v);
										_tmp37_ = tracker_sparql_variable_get_sql_expression (v);
										_tmp38_ = tracker_sparql_variable_get_sql_expression (v);
										g_string_append_printf (select, "COALESCE (t%d_g.%s, t%d_g.%s) AS %s", left_index, _tmp36_, right_index, _tmp37_, _tmp38_);
									}
								}
							}
						}
					}
					_g_list_free0 (v_collection);
				}
				_tmp39_ = tracker_sparql_pattern_get_context (self);
				_tmp40_ = g_hash_table_get_keys (_tmp39_->parent_context->var_set);
				{
					GList* v_collection;
					GList* v_it;
					v_collection = _tmp40_;
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
						TrackerSparqlVariable* v;
						v = (TrackerSparqlVariable*) v_it->data;
						{
							TrackerSparqlContext* _tmp41_ = NULL;
							gconstpointer _tmp42_ = NULL;
							_tmp41_ = tracker_sparql_pattern_get_context (self);
							_tmp42_ = g_hash_table_lookup (_tmp41_->var_set, v);
							if (GPOINTER_TO_INT (_tmp42_) == 0) {
								const gchar* _tmp43_ = NULL;
								if (first) {
									first = FALSE;
								} else {
									g_string_append (select, ", ");
								}
								_tmp43_ = tracker_sparql_variable_get_sql_expression (v);
								g_string_append_printf (select, "t%d_g.%s", left_index, _tmp43_);
							}
						}
					}
					_g_list_free0 (v_collection);
				}
				if (first) {
					g_string_append (select, "1");
				}
				_tmp44_ = tracker_sparql_pattern_get_context (self);
				tracker_sparql_pattern_set_context (self, _tmp44_->parent_context);
				g_string_append (select, " FROM (");
				g_string_insert (sql, (gssize) group_graph_pattern_start, select->str);
				g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
				g_string_append (sql, ")");
				_g_string_free0 (select);
			}
		} else {
			gboolean _tmp45_;
			gboolean _tmp46_;
			_tmp45_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
			_tmp46_ = _tmp45_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp46_) {
				gchar* _tmp47_;
				gchar* old_graph;
				gboolean old_graph_is_var;
				gboolean _tmp48_;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				gboolean _tmp51_ = FALSE;
				gchar* _tmp52_;
				_tmp47_ = g_strdup (self->priv->current_graph);
				old_graph = _tmp47_;
				old_graph_is_var = self->priv->current_graph_is_var;
				_tmp49_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &_tmp48_, &_inner_error_);
				self->priv->current_graph_is_var = _tmp48_;
				_tmp50_ = _tmp49_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						_g_free0 (old_graph);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (self->priv->current_graph);
				self->priv->current_graph = _tmp50_;
				if (!in_triples_block) {
					_tmp51_ = !in_group_graph_pattern;
				} else {
					_tmp51_ = FALSE;
				}
				if (_tmp51_) {
					in_group_graph_pattern = TRUE;
					g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					g_string_append (sql, ")");
				} else {
					if (in_triples_block) {
						tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_graph);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								_g_free0 (old_graph);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						in_triples_block = FALSE;
					}
					if (!in_group_graph_pattern) {
						in_group_graph_pattern = TRUE;
					}
					g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
					g_string_append (sql, ") NATURAL INNER JOIN (");
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					g_string_append (sql, ")");
				}
				_tmp52_ = g_strdup (old_graph);
				_g_free0 (self->priv->current_graph);
				self->priv->current_graph = _tmp52_;
				self->priv->current_graph_is_var = old_graph_is_var;
				_g_free0 (old_graph);
			} else {
				TrackerSparqlTokenType _tmp53_;
				_tmp53_ = tracker_sparql_pattern_current (self);
				if (_tmp53_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE) {
					gboolean _tmp54_ = FALSE;
					if (!in_triples_block) {
						_tmp54_ = !in_group_graph_pattern;
					} else {
						_tmp54_ = FALSE;
					}
					if (_tmp54_) {
						in_group_graph_pattern = TRUE;
						g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
						tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						g_string_append (sql, ")");
					} else {
						if (in_triples_block) {
							tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									filters = (g_free (filters), NULL);
									_tracker_sparql_context_unref0 (_result_);
									return NULL;
								} else {
									filters = (g_free (filters), NULL);
									_tracker_sparql_context_unref0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							in_triples_block = FALSE;
						}
						if (!in_group_graph_pattern) {
							in_group_graph_pattern = TRUE;
						}
						g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
						g_string_append (sql, ") NATURAL INNER JOIN (");
						tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						g_string_append (sql, ")");
					}
				} else {
					TrackerSparqlTokenType _tmp55_;
					_tmp55_ = tracker_sparql_pattern_current (self);
					if (_tmp55_ == TRACKER_SPARQL_TOKEN_TYPE_FILTER) {
						TrackerSourceLocation _tmp56_ = {0};
						TrackerSourceLocation _tmp57_ = {0};
						tracker_sparql_pattern_get_location (self, &_tmp56_);
						_tmp57_ = _tmp56_;
						_vala_array_add1 (&filters, &filters_length1, &_filters_size_, &_tmp57_);
						tracker_sparql_pattern_skip_filter (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					} else {
						break;
					}
				}
			}
		}
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_parse_triples (self, sql, group_graph_pattern_start, &in_triples_block, &first_where, &in_group_graph_pattern, found_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (!in_triples_block) {
		_tmp58_ = !in_group_graph_pattern;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		g_string_append (sql, "SELECT 1");
	} else {
		if (in_triples_block) {
			tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			in_triples_block = FALSE;
		}
	}
	if (in_group_graph_pattern) {
		first_where = TRUE;
	}
	if (filters_length1 > 0) {
		TrackerSourceLocation _tmp59_ = {0};
		TrackerSourceLocation _tmp60_ = {0};
		TrackerSourceLocation end;
		tracker_sparql_pattern_get_location (self, &_tmp59_);
		_tmp60_ = _tmp59_;
		end = _tmp60_;
		{
			TrackerSourceLocation* filter_location_collection;
			int filter_location_collection_length1;
			int filter_location_it;
			filter_location_collection = filters;
			filter_location_collection_length1 = filters_length1;
			for (filter_location_it = 0; filter_location_it < filters_length1; filter_location_it = filter_location_it + 1) {
				TrackerSourceLocation filter_location;
				filter_location = filter_location_collection[filter_location_it];
				{
					if (!first_where) {
						g_string_append (sql, " AND ");
					} else {
						g_string_append (sql, " WHERE ");
						first_where = FALSE;
					}
					tracker_sparql_pattern_set_location (self, &filter_location);
					tracker_sparql_pattern_translate_filter (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
		}
		tracker_sparql_pattern_set_location (self, &end);
	}
	_tmp61_ = tracker_sparql_pattern_get_context (self);
	tracker_sparql_pattern_set_context (self, _tmp61_->parent_context);
	result = _result_;
	filters = (g_free (filters), NULL);
	return result;
}


static void _vala_array_add2 (glong** array, int* length, int* size, glong value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (glong, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add3 (TrackerSparqlContext*** array, int* length, int* size, TrackerSparqlContext* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlContext*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
	return self ? tracker_sparql_context_ref (self) : NULL;
}


static void _vala_array_add4 (TrackerSparqlVariable*** array, int* length, int* size, TrackerSparqlVariable* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlVariable*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlVariable** _tmp0_ = NULL;
	TrackerSparqlVariable** all_vars;
	gint all_vars_length1;
	gint _all_vars_size_;
	GHashTable* _tmp1_ = NULL;
	GHashTable* all_var_set;
	TrackerSparqlContext** _tmp2_ = NULL;
	TrackerSparqlContext** contexts;
	gint contexts_length1;
	gint _contexts_size_;
	glong* _tmp3_ = NULL;
	glong* offsets;
	gint offsets_length1;
	gint _offsets_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = g_new0 (TrackerSparqlVariable*, 0 + 1);
	all_vars = _tmp0_;
	all_vars_length1 = 0;
	_all_vars_size_ = 0;
	_tmp1_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, NULL);
	all_var_set = _tmp1_;
	_tmp2_ = g_new0 (TrackerSparqlContext*, 0 + 1);
	contexts = _tmp2_;
	contexts_length1 = 0;
	_contexts_size_ = 0;
	_tmp3_ = g_new0 (glong, 0);
	offsets = _tmp3_;
	offsets_length1 = 0;
	_offsets_size_ = 0;
	{
		gboolean _tmp4_;
		_tmp4_ = TRUE;
		while (TRUE) {
			TrackerSparqlContext* _tmp7_ = NULL;
			TrackerSparqlContext* _tmp8_;
			if (!_tmp4_) {
				gboolean _tmp5_;
				gboolean _tmp6_;
				_tmp5_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_UNION, &_inner_error_);
				_tmp6_ = _tmp5_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						offsets = (g_free (offsets), NULL);
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
						_g_hash_table_unref0 (all_var_set);
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
						return;
					} else {
						offsets = (g_free (offsets), NULL);
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
						_g_hash_table_unref0 (all_var_set);
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (!_tmp6_) {
					break;
				}
			}
			_tmp4_ = FALSE;
			_vala_array_add2 (&offsets, &offsets_length1, &_offsets_size_, (glong) sql->len);
			_tmp7_ = tracker_sparql_pattern_translate_group_graph_pattern (self, sql, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					offsets = (g_free (offsets), NULL);
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
					_g_hash_table_unref0 (all_var_set);
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
					return;
				} else {
					offsets = (g_free (offsets), NULL);
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
					_g_hash_table_unref0 (all_var_set);
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_vala_array_add3 (&contexts, &contexts_length1, &_contexts_size_, _tmp8_);
		}
	}
	if (contexts_length1 > 1) {
		glong extra_offset;
		{
			TrackerSparqlContext** sub_context_collection;
			int sub_context_collection_length1;
			int sub_context_it;
			sub_context_collection = contexts;
			sub_context_collection_length1 = contexts_length1;
			for (sub_context_it = 0; sub_context_it < contexts_length1; sub_context_it = sub_context_it + 1) {
				TrackerSparqlContext* _tmp9_;
				TrackerSparqlContext* sub_context;
				_tmp9_ = _tracker_sparql_context_ref0 (sub_context_collection[sub_context_it]);
				sub_context = _tmp9_;
				{
					GList* _tmp10_ = NULL;
					_tmp10_ = g_hash_table_get_keys (sub_context->var_set);
					{
						GList* v_collection;
						GList* v_it;
						v_collection = _tmp10_;
						for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
							TrackerSparqlVariable* v;
							v = (TrackerSparqlVariable*) v_it->data;
							{
								gconstpointer _tmp11_ = NULL;
								_tmp11_ = g_hash_table_lookup (all_var_set, v);
								if (GPOINTER_TO_INT (_tmp11_) == 0) {
									TrackerSparqlVariable* _tmp12_;
									TrackerSparqlVariable* _tmp13_;
									TrackerSparqlContext* _tmp14_ = NULL;
									TrackerSparqlVariable* _tmp15_;
									_tmp12_ = _g_object_ref0 (v);
									_vala_array_add4 (&all_vars, &all_vars_length1, &_all_vars_size_, _tmp12_);
									_tmp13_ = _g_object_ref0 (v);
									g_hash_table_insert (all_var_set, _tmp13_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
									_tmp14_ = tracker_sparql_pattern_get_context (self);
									_tmp15_ = _g_object_ref0 (v);
									g_hash_table_insert (_tmp14_->var_set, _tmp15_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
								}
							}
						}
						_g_list_free0 (v_collection);
					}
					_tracker_sparql_context_unref0 (sub_context);
				}
			}
		}
		extra_offset = (glong) 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp16_;
				_tmp16_ = TRUE;
				while (TRUE) {
					GString* _tmp17_ = NULL;
					GString* projection;
					if (!_tmp16_) {
						i++;
					}
					_tmp16_ = FALSE;
					if (!(i < contexts_length1)) {
						break;
					}
					_tmp17_ = g_string_new ("");
					projection = _tmp17_;
					if (i > 0) {
						g_string_append (projection, ") UNION ALL ");
					}
					g_string_append (projection, "SELECT ");
					{
						TrackerSparqlVariable** v_collection;
						int v_collection_length1;
						int v_it;
						v_collection = all_vars;
						v_collection_length1 = all_vars_length1;
						for (v_it = 0; v_it < all_vars_length1; v_it = v_it + 1) {
							TrackerSparqlVariable* _tmp18_;
							TrackerSparqlVariable* v;
							_tmp18_ = _g_object_ref0 (v_collection[v_it]);
							v = _tmp18_;
							{
								gconstpointer _tmp19_ = NULL;
								const gchar* _tmp20_ = NULL;
								_tmp19_ = g_hash_table_lookup (contexts[i]->var_set, v);
								if (GPOINTER_TO_INT (_tmp19_) == 0) {
									g_string_append (projection, "NULL AS ");
								}
								_tmp20_ = tracker_sparql_variable_get_sql_expression (v);
								g_string_append_printf (projection, "%s, ", _tmp20_);
								_g_object_unref0 (v);
							}
						}
					}
					g_string_truncate (projection, (gsize) (projection->len - 2));
					g_string_append (projection, " FROM (");
					g_string_insert (sql, (gssize) (offsets[i] + extra_offset), projection->str);
					extra_offset = extra_offset + ((glong) projection->len);
					_g_string_free0 (projection);
				}
			}
		}
		g_string_append (sql, ")");
	} else {
		GList* _tmp21_ = NULL;
		_tmp21_ = g_hash_table_get_keys (contexts[0]->var_set);
		{
			GList* key_collection;
			GList* key_it;
			key_collection = _tmp21_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				TrackerSparqlVariable* key;
				key = (TrackerSparqlVariable*) key_it->data;
				{
					TrackerSparqlContext* _tmp22_ = NULL;
					TrackerSparqlVariable* _tmp23_;
					_tmp22_ = tracker_sparql_pattern_get_context (self);
					_tmp23_ = _g_object_ref0 (key);
					g_hash_table_insert (_tmp22_->var_set, _tmp23_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
				}
			}
			_g_list_free0 (key_collection);
		}
	}
	offsets = (g_free (offsets), NULL);
	contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
	_g_hash_table_unref0 (all_var_set);
	all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
}


static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable) {
	TrackerSparqlVariableBindingList* result = NULL;
	TrackerSparqlVariableBindingList* binding_list;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable != NULL, NULL);
	binding_list = NULL;
	if (self->priv->triple_context != NULL) {
		gconstpointer _tmp0_ = NULL;
		TrackerSparqlVariableBindingList* _tmp1_;
		_tmp0_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, variable);
		_tmp1_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp0_);
		_g_object_unref0 (binding_list);
		binding_list = _tmp1_;
	}
	if (binding_list == NULL) {
		_tmp2_ = variable->binding != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		TrackerSparqlContext* _tmp3_ = NULL;
		TrackerSparqlContext* _tmp4_;
		TrackerSparqlContext* current_context;
		_tmp3_ = tracker_sparql_pattern_get_context (self);
		_tmp4_ = _tracker_sparql_context_ref0 (_tmp3_);
		current_context = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			TrackerSparqlContext* _tmp20_;
			if (!(current_context != NULL)) {
				break;
			}
			if (current_context->scalar_subquery) {
				gconstpointer _tmp6_ = NULL;
				_tmp6_ = g_hash_table_lookup (current_context->parent_context->var_set, variable);
				_tmp5_ = GPOINTER_TO_INT (_tmp6_) != 0;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				TrackerSparqlVariableBinding* _tmp7_ = NULL;
				TrackerSparqlVariableBinding* binding;
				TrackerSparqlContext* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				TrackerSparqlVariable* _tmp10_ = NULL;
				TrackerClass* _tmp11_;
				const gchar* _tmp12_ = NULL;
				TrackerSparqlVariableBindingList* _tmp13_ = NULL;
				TrackerSparqlContext* _tmp17_ = NULL;
				TrackerSparqlVariable* _tmp18_;
				TrackerSparqlVariableBinding* _tmp19_;
				_tmp7_ = tracker_sparql_variable_binding_new ();
				binding = _tmp7_;
				((TrackerSparqlDataBinding*) binding)->data_type = ((TrackerSparqlDataBinding*) variable->binding)->data_type;
				_tmp8_ = tracker_sparql_pattern_get_context (self);
				_tmp9_ = tracker_sparql_variable_get_name (variable);
				_tmp10_ = tracker_sparql_context_get_variable (_tmp8_, _tmp9_);
				binding->variable = _tmp10_;
				_tmp11_ = _g_object_ref0 (variable->binding->type);
				_g_object_unref0 (binding->type);
				binding->type = _tmp11_;
				_tmp12_ = tracker_sparql_variable_get_sql_expression (variable);
				tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) binding, _tmp12_);
				_tmp13_ = tracker_sparql_variable_binding_list_new ();
				_g_object_unref0 (binding_list);
				binding_list = _tmp13_;
				if (self->priv->triple_context != NULL) {
					TrackerSparqlVariable* _tmp14_;
					TrackerSparqlVariable* _tmp15_;
					TrackerSparqlVariableBindingList* _tmp16_;
					_tmp14_ = _g_object_ref0 (variable);
					self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _tmp14_);
					_tmp15_ = _g_object_ref0 (variable);
					_tmp16_ = _g_object_ref0 (binding_list);
					g_hash_table_insert (self->priv->triple_context->var_bindings, _tmp15_, _tmp16_);
				}
				_tmp17_ = tracker_sparql_pattern_get_context (self);
				_tmp18_ = _g_object_ref0 (variable);
				g_hash_table_insert (_tmp17_->var_set, _tmp18_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
				_tmp19_ = _g_object_ref0 (binding);
				binding_list->list = g_list_append (binding_list->list, _tmp19_);
				_g_object_unref0 (binding);
				break;
			}
			_tmp20_ = _tracker_sparql_context_ref0 (current_context->parent_context);
			_tracker_sparql_context_unref0 (current_context);
			current_context = _tmp20_;
		}
		_tracker_sparql_context_unref0 (current_context);
	}
	result = binding_list;
	return result;
}


void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state) {
	TrackerSparqlVariableBindingList* _tmp0_ = NULL;
	TrackerSparqlVariableBindingList* binding_list;
	TrackerSparqlVariableBinding* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = tracker_sparql_pattern_get_variable_binding_list (self, binding->variable);
	binding_list = _tmp0_;
	if (binding_list == NULL) {
		TrackerSparqlVariableBindingList* _tmp1_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		TrackerSparqlContext* _tmp15_ = NULL;
		TrackerSparqlVariable* _tmp16_;
		_tmp1_ = tracker_sparql_variable_binding_list_new ();
		_g_object_unref0 (binding_list);
		binding_list = _tmp1_;
		if (self->priv->triple_context != NULL) {
			TrackerSparqlVariable* _tmp2_;
			TrackerSparqlVariable* _tmp3_;
			TrackerSparqlVariableBindingList* _tmp4_;
			_tmp2_ = _g_object_ref0 (binding->variable);
			self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _tmp2_);
			_tmp3_ = _g_object_ref0 (binding->variable);
			_tmp4_ = _g_object_ref0 (binding_list);
			g_hash_table_insert (self->priv->triple_context->var_bindings, _tmp3_, _tmp4_);
		}
		_tmp5_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding);
		_tmp6_ = tracker_sparql_variable_get_sql_expression (binding->variable);
		g_string_append_printf (sql, "%s AS %s, ", _tmp5_, _tmp6_);
		if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_DATETIME) {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp7_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) binding, "localDate");
			_tmp8_ = _tmp7_;
			_tmp9_ = tracker_sparql_variable_get_extra_sql_expression (binding->variable, "localDate");
			_tmp10_ = _tmp9_;
			g_string_append_printf (sql, "%s AS %s, ", _tmp8_, _tmp10_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			_tmp11_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) binding, "localTime");
			_tmp12_ = _tmp11_;
			_tmp13_ = tracker_sparql_variable_get_extra_sql_expression (binding->variable, "localTime");
			_tmp14_ = _tmp13_;
			g_string_append_printf (sql, "%s AS %s, ", _tmp12_, _tmp14_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
		}
		_tmp15_ = tracker_sparql_pattern_get_context (self);
		_tmp16_ = _g_object_ref0 (binding->variable);
		g_hash_table_insert (_tmp15_->var_set, _tmp16_, GINT_TO_POINTER ((gint) variable_state));
	}
	_tmp17_ = _g_object_ref0 (binding);
	binding_list->list = g_list_append (binding_list->list, _tmp17_);
	if (binding->variable->binding == NULL) {
		TrackerSparqlVariableBinding* _tmp18_;
		_tmp18_ = _g_object_ref0 (binding);
		_g_object_unref0 (binding->variable->binding);
		binding->variable->binding = _tmp18_;
	}
	_g_object_unref0 (binding_list);
}


static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	glong begin_sql_len;
	gboolean object_is_var = FALSE;
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* object;
	gchar* db_table = NULL;
	gboolean rdftype;
	gboolean share_table;
	gboolean is_fts_match;
	gboolean newtable = FALSE;
	TrackerSparqlDataTable* table = NULL;
	TrackerProperty* prop;
	TrackerClass* subject_type;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	begin_sql_len = (glong) sql->len;
	_tmp1_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &_tmp0_, &_inner_error_);
	object_is_var = _tmp0_;
	object = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	rdftype = FALSE;
	share_table = TRUE;
	is_fts_match = FALSE;
	prop = NULL;
	subject_type = NULL;
	if (!self->priv->current_predicate_is_var) {
		TrackerProperty* _tmp2_ = NULL;
		TrackerProperty* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp68_;
		TrackerSparqlDataTable* _tmp69_ = NULL;
		_tmp2_ = tracker_ontologies_get_property_by_uri (self->priv->current_predicate);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (prop);
		prop = _tmp3_;
		if (g_strcmp0 (self->priv->current_predicate, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type") == 0) {
			_tmp4_ = !object_is_var;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			TrackerClass* _tmp5_ = NULL;
			TrackerClass* _tmp6_;
			TrackerClass* cl;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			TrackerClass* _tmp13_;
			rdftype = TRUE;
			_tmp5_ = tracker_ontologies_get_class_by_uri (object);
			_tmp6_ = _g_object_ref0 (_tmp5_);
			cl = _tmp6_;
			if (cl == NULL) {
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				GError* _tmp9_ = NULL;
				GError* _tmp10_;
				_tmp7_ = g_strdup_printf ("Unknown class `%s'", object);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp8_);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				_inner_error_ = _tmp10_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (cl);
					_g_object_unref0 (subject_type);
					_g_object_unref0 (prop);
					_g_object_unref0 (table);
					_g_free0 (db_table);
					_g_free0 (object);
					return;
				} else {
					_g_object_unref0 (cl);
					_g_object_unref0 (subject_type);
					_g_object_unref0 (prop);
					_g_object_unref0 (table);
					_g_free0 (db_table);
					_g_free0 (object);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp11_ = tracker_class_get_name (cl);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (db_table);
			db_table = _tmp12_;
			_tmp13_ = _g_object_ref0 (cl);
			_g_object_unref0 (subject_type);
			subject_type = _tmp13_;
			_g_object_unref0 (cl);
		} else {
			if (prop == NULL) {
				if (g_strcmp0 (self->priv->current_predicate, "http://www.tracker-project.org/ontologies/fts#match") == 0) {
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("fts");
					_g_free0 (db_table);
					db_table = _tmp14_;
					share_table = FALSE;
					is_fts_match = TRUE;
				} else {
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					GError* _tmp17_ = NULL;
					GError* _tmp18_;
					_tmp15_ = g_strdup_printf ("Unknown property `%s'", self->priv->current_predicate);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, _tmp16_);
					_tmp18_ = _tmp17_;
					_g_free0 (_tmp16_);
					_inner_error_ = _tmp18_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (subject_type);
						_g_object_unref0 (prop);
						_g_object_unref0 (table);
						_g_free0 (db_table);
						_g_free0 (object);
						return;
					} else {
						_g_object_unref0 (subject_type);
						_g_object_unref0 (prop);
						_g_object_unref0 (table);
						_g_free0 (db_table);
						_g_free0 (object);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} else {
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_;
				gboolean _tmp41_;
				TrackerClass* _tmp42_ = NULL;
				TrackerClass* _tmp43_;
				gboolean _tmp44_ = FALSE;
				if (g_strcmp0 (self->priv->current_predicate, "http://www.w3.org/2000/01/rdf-schema#domain") == 0) {
					_tmp20_ = self->priv->current_subject_is_var;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					_tmp19_ = !object_is_var;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					TrackerClass* _tmp21_ = NULL;
					TrackerClass* _tmp22_;
					TrackerClass* domain;
					TrackerSparqlContext* _tmp27_ = NULL;
					TrackerSparqlContext* _tmp28_ = NULL;
					TrackerSparqlVariable* _tmp29_ = NULL;
					gconstpointer _tmp30_ = NULL;
					TrackerSparqlPredicateVariable* _tmp31_;
					TrackerSparqlPredicateVariable* pv;
					TrackerClass* _tmp38_;
					_tmp21_ = tracker_ontologies_get_class_by_uri (object);
					_tmp22_ = _g_object_ref0 (_tmp21_);
					domain = _tmp22_;
					if (domain == NULL) {
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_;
						GError* _tmp25_ = NULL;
						GError* _tmp26_;
						_tmp23_ = g_strdup_printf ("Unknown class `%s'", object);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp24_);
						_tmp26_ = _tmp25_;
						_g_free0 (_tmp24_);
						_inner_error_ = _tmp26_;
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (domain);
							_g_object_unref0 (subject_type);
							_g_object_unref0 (prop);
							_g_object_unref0 (table);
							_g_free0 (db_table);
							_g_free0 (object);
							return;
						} else {
							_g_object_unref0 (domain);
							_g_object_unref0 (subject_type);
							_g_object_unref0 (prop);
							_g_object_unref0 (table);
							_g_free0 (db_table);
							_g_free0 (object);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp27_ = tracker_sparql_pattern_get_context (self);
					_tmp28_ = tracker_sparql_pattern_get_context (self);
					_tmp29_ = tracker_sparql_context_get_variable (_tmp28_, self->priv->current_subject);
					_tmp30_ = g_hash_table_lookup (_tmp27_->predicate_variable_map, _tmp29_);
					_tmp31_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp30_);
					pv = _tmp31_;
					if (pv == NULL) {
						TrackerSparqlPredicateVariable* _tmp32_ = NULL;
						TrackerSparqlContext* _tmp33_ = NULL;
						TrackerSparqlContext* _tmp34_ = NULL;
						TrackerSparqlVariable* _tmp35_ = NULL;
						TrackerSparqlVariable* _tmp36_;
						TrackerSparqlPredicateVariable* _tmp37_;
						_tmp32_ = tracker_sparql_predicate_variable_new ();
						_g_object_unref0 (pv);
						pv = _tmp32_;
						_tmp33_ = tracker_sparql_pattern_get_context (self);
						_tmp34_ = tracker_sparql_pattern_get_context (self);
						_tmp35_ = tracker_sparql_context_get_variable (_tmp34_, self->priv->current_subject);
						_tmp36_ = _g_object_ref0 (_tmp35_);
						_tmp37_ = _g_object_ref0 (pv);
						g_hash_table_insert (_tmp33_->predicate_variable_map, _tmp36_, _tmp37_);
					}
					_tmp38_ = _g_object_ref0 (domain);
					_g_object_unref0 (pv->domain);
					pv->domain = _tmp38_;
					_g_object_unref0 (pv);
					_g_object_unref0 (domain);
				}
				_tmp39_ = tracker_property_get_table_name (prop);
				_tmp40_ = g_strdup (_tmp39_);
				_g_free0 (db_table);
				db_table = _tmp40_;
				_tmp41_ = tracker_property_get_multiple_values (prop);
				if (_tmp41_) {
					share_table = FALSE;
				}
				_tmp42_ = tracker_property_get_domain (prop);
				_tmp43_ = _g_object_ref0 (_tmp42_);
				_g_object_unref0 (subject_type);
				subject_type = _tmp43_;
				if (in_simple_optional) {
					TrackerSparqlContext* _tmp45_ = NULL;
					TrackerSparqlContext* _tmp46_ = NULL;
					TrackerSparqlVariable* _tmp47_ = NULL;
					gconstpointer _tmp48_ = NULL;
					_tmp45_ = tracker_sparql_pattern_get_context (self);
					_tmp46_ = tracker_sparql_pattern_get_context (self);
					_tmp47_ = tracker_sparql_context_get_variable (_tmp46_, self->priv->current_subject);
					_tmp48_ = g_hash_table_lookup (_tmp45_->var_set, _tmp47_);
					_tmp44_ = GPOINTER_TO_INT (_tmp48_) == 0;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					TrackerSparqlVariableBinding* _tmp49_ = NULL;
					TrackerSparqlVariableBinding* binding;
					TrackerSparqlContext* _tmp50_ = NULL;
					TrackerSparqlVariable* _tmp51_ = NULL;
					gconstpointer _tmp52_ = NULL;
					TrackerSparqlVariableBindingList* _tmp53_ = NULL;
					TrackerSparqlVariableBindingList* binding_list;
					TrackerSparqlVariable* _tmp54_;
					TrackerSparqlVariable* _tmp55_;
					TrackerSparqlVariableBindingList* _tmp56_;
					TrackerSparqlContext* _tmp57_ = NULL;
					TrackerSparqlVariable* _tmp58_ = NULL;
					gconstpointer _tmp59_ = NULL;
					TrackerSparqlVariableBinding* _tmp60_;
					TrackerSparqlVariableBinding* object_binding;
					const gchar* _tmp61_ = NULL;
					const gchar* _tmp62_ = NULL;
					const gchar* _tmp63_ = NULL;
					TrackerSparqlContext* _tmp64_ = NULL;
					TrackerSparqlVariable* _tmp65_;
					TrackerSparqlVariableBinding* _tmp66_;
					TrackerSparqlVariableBinding* _tmp67_;
					_tmp49_ = tracker_sparql_variable_binding_new ();
					binding = _tmp49_;
					((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
					_tmp50_ = tracker_sparql_pattern_get_context (self);
					_tmp51_ = tracker_sparql_context_get_variable (_tmp50_, self->priv->current_subject);
					binding->variable = _tmp51_;
					_tmp52_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, binding->variable);
					g_assert (((TrackerSparqlVariableBindingList*) _tmp52_) == NULL);
					_tmp53_ = tracker_sparql_variable_binding_list_new ();
					binding_list = _tmp53_;
					_tmp54_ = _g_object_ref0 (binding->variable);
					self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _tmp54_);
					_tmp55_ = _g_object_ref0 (binding->variable);
					_tmp56_ = _g_object_ref0 (binding_list);
					g_hash_table_insert (self->priv->triple_context->var_bindings, _tmp55_, _tmp56_);
					_tmp57_ = tracker_sparql_pattern_get_context (self);
					_tmp58_ = tracker_sparql_context_get_variable (_tmp57_, object);
					_tmp59_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, _tmp58_);
					_tmp60_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) ((TrackerSparqlVariableBindingList*) _tmp59_)->list->data);
					object_binding = _tmp60_;
					_tmp61_ = tracker_property_get_name (prop);
					_tmp62_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) object_binding);
					_tmp63_ = tracker_sparql_variable_get_sql_expression (binding->variable);
					g_string_append_printf (sql, "(SELECT ID FROM \"%s\" WHERE \"%s\" = %s) AS %s, ", db_table, _tmp61_, _tmp62_, _tmp63_);
					_tmp64_ = tracker_sparql_pattern_get_context (self);
					_tmp65_ = _g_object_ref0 (binding->variable);
					g_hash_table_insert (_tmp64_->var_set, _tmp65_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL));
					_tmp66_ = _g_object_ref0 (binding);
					binding_list->list = g_list_append (binding_list->list, _tmp66_);
					g_assert (binding->variable->binding == NULL);
					_tmp67_ = _g_object_ref0 (binding);
					_g_object_unref0 (binding->variable->binding);
					binding->variable->binding = _tmp67_;
					_g_object_unref0 (object_binding);
					_g_object_unref0 (binding_list);
					_g_object_unref0 (binding);
					_g_object_unref0 (subject_type);
					_g_object_unref0 (prop);
					_g_object_unref0 (table);
					_g_free0 (db_table);
					_g_free0 (object);
					return;
				}
			}
		}
		_tmp69_ = tracker_sparql_pattern_get_table (self, self->priv->current_subject, db_table, share_table, &_tmp68_);
		newtable = _tmp68_;
		_g_object_unref0 (table);
		table = _tmp69_;
	} else {
		TrackerSparqlDataTable* _tmp70_ = NULL;
		TrackerSparqlContext* _tmp71_ = NULL;
		TrackerSparqlContext* _tmp72_ = NULL;
		TrackerSparqlVariable* _tmp73_ = NULL;
		gconstpointer _tmp74_ = NULL;
		TrackerSparqlPredicateVariable* _tmp75_;
		gchar* _tmp84_ = NULL;
		gchar* _tmp85_;
		gchar* _tmp86_;
		TrackerSparqlDataTable* _tmp87_;
		TrackerSparqlVariableBinding* _tmp88_ = NULL;
		TrackerSparqlVariableBinding* binding;
		TrackerSparqlContext* _tmp89_ = NULL;
		TrackerSparqlVariable* _tmp90_ = NULL;
		TrackerSparqlDataTable* _tmp91_;
		gchar* _tmp92_;
		newtable = TRUE;
		_tmp70_ = tracker_sparql_data_table_new ();
		_g_object_unref0 (table);
		table = _tmp70_;
		_tmp71_ = tracker_sparql_pattern_get_context (self);
		_tmp72_ = tracker_sparql_pattern_get_context (self);
		_tmp73_ = tracker_sparql_context_get_variable (_tmp72_, self->priv->current_predicate);
		_tmp74_ = g_hash_table_lookup (_tmp71_->predicate_variable_map, _tmp73_);
		_tmp75_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp74_);
		_g_object_unref0 (table->predicate_variable);
		table->predicate_variable = _tmp75_;
		if (table->predicate_variable == NULL) {
			TrackerSparqlPredicateVariable* _tmp76_ = NULL;
			TrackerSparqlContext* _tmp77_ = NULL;
			TrackerSparqlContext* _tmp78_ = NULL;
			TrackerSparqlVariable* _tmp79_ = NULL;
			TrackerSparqlVariable* _tmp80_;
			TrackerSparqlPredicateVariable* _tmp81_;
			_tmp76_ = tracker_sparql_predicate_variable_new ();
			_g_object_unref0 (table->predicate_variable);
			table->predicate_variable = _tmp76_;
			_tmp77_ = tracker_sparql_pattern_get_context (self);
			_tmp78_ = tracker_sparql_pattern_get_context (self);
			_tmp79_ = tracker_sparql_context_get_variable (_tmp78_, self->priv->current_predicate);
			_tmp80_ = _g_object_ref0 (_tmp79_);
			_tmp81_ = _g_object_ref0 (table->predicate_variable);
			g_hash_table_insert (_tmp77_->predicate_variable_map, _tmp80_, _tmp81_);
		}
		if (!self->priv->current_subject_is_var) {
			gchar* _tmp82_;
			_tmp82_ = g_strdup (self->priv->current_subject);
			_g_free0 (table->predicate_variable->subject);
			table->predicate_variable->subject = _tmp82_;
		}
		if (!object_is_var) {
			gchar* _tmp83_;
			_tmp83_ = g_strdup (object);
			_g_free0 (table->predicate_variable->object);
			table->predicate_variable->object = _tmp83_;
		}
		self->priv->counter = self->priv->counter + 1;
		_tmp84_ = g_strdup_printf ("%i", self->priv->counter);
		_tmp85_ = _tmp84_;
		_tmp86_ = g_strconcat (self->priv->current_predicate, _tmp85_, NULL);
		_g_free0 (table->sql_query_tablename);
		table->sql_query_tablename = _tmp86_;
		_g_free0 (_tmp85_);
		_tmp87_ = _g_object_ref0 (table);
		self->priv->triple_context->tables = g_list_append (self->priv->triple_context->tables, _tmp87_);
		_tmp88_ = tracker_sparql_variable_binding_new ();
		binding = _tmp88_;
		((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
		_tmp89_ = tracker_sparql_pattern_get_context (self);
		_tmp90_ = tracker_sparql_context_get_variable (_tmp89_, self->priv->current_predicate);
		binding->variable = _tmp90_;
		_tmp91_ = _g_object_ref0 (table);
		_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
		((TrackerSparqlDataBinding*) binding)->table = _tmp91_;
		_tmp92_ = g_strdup ("predicate");
		_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
		((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp92_;
		tracker_sparql_pattern_add_variable_binding (self, sql, binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
		_g_object_unref0 (binding);
	}
	if (newtable) {
		if (self->priv->current_subject_is_var) {
			TrackerSparqlVariableBinding* _tmp93_ = NULL;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlContext* _tmp94_ = NULL;
			TrackerSparqlVariable* _tmp95_ = NULL;
			TrackerSparqlDataTable* _tmp96_;
			TrackerClass* _tmp97_;
			_tmp93_ = tracker_sparql_variable_binding_new ();
			binding = _tmp93_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
			_tmp94_ = tracker_sparql_pattern_get_context (self);
			_tmp95_ = tracker_sparql_context_get_variable (_tmp94_, self->priv->current_subject);
			binding->variable = _tmp95_;
			_tmp96_ = _g_object_ref0 (table);
			_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
			((TrackerSparqlDataBinding*) binding)->table = _tmp96_;
			_tmp97_ = _g_object_ref0 (subject_type);
			_g_object_unref0 (binding->type);
			binding->type = _tmp97_;
			if (is_fts_match) {
				gchar* _tmp98_;
				_tmp98_ = g_strdup ("rowid");
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp98_;
			} else {
				gchar* _tmp99_;
				_tmp99_ = g_strdup ("ID");
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp99_;
			}
			tracker_sparql_pattern_add_variable_binding (self, sql, binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
			_g_object_unref0 (binding);
		} else {
			TrackerSparqlLiteralBinding* _tmp100_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gchar* _tmp101_;
			TrackerSparqlDataTable* _tmp102_;
			gchar* _tmp103_;
			TrackerSparqlLiteralBinding* _tmp104_;
			_tmp100_ = tracker_sparql_literal_binding_new ();
			binding = _tmp100_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
			_tmp101_ = g_strdup (self->priv->current_subject);
			_g_free0 (binding->literal);
			binding->literal = _tmp101_;
			_tmp102_ = _g_object_ref0 (table);
			_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
			((TrackerSparqlDataBinding*) binding)->table = _tmp102_;
			_tmp103_ = g_strdup ("ID");
			_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
			((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp103_;
			_tmp104_ = _g_object_ref0 (binding);
			self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _tmp104_);
			_g_object_unref0 (binding);
		}
	}
	if (!rdftype) {
		gboolean _tmp135_ = FALSE;
		if (object_is_var) {
			TrackerSparqlVariableBinding* _tmp105_ = NULL;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlContext* _tmp106_ = NULL;
			TrackerSparqlVariable* _tmp107_ = NULL;
			TrackerSparqlDataTable* _tmp108_;
			TrackerSparqlVariableState state = 0;
			_tmp105_ = tracker_sparql_variable_binding_new ();
			binding = _tmp105_;
			_tmp106_ = tracker_sparql_pattern_get_context (self);
			_tmp107_ = tracker_sparql_context_get_variable (_tmp106_, object);
			binding->variable = _tmp107_;
			_tmp108_ = _g_object_ref0 (table);
			_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
			((TrackerSparqlDataBinding*) binding)->table = _tmp108_;
			if (prop != NULL) {
				TrackerClass* _tmp109_ = NULL;
				TrackerClass* _tmp110_;
				TrackerPropertyType _tmp111_;
				const gchar* _tmp112_ = NULL;
				gchar* _tmp113_;
				gboolean _tmp114_;
				_tmp109_ = tracker_property_get_range (prop);
				_tmp110_ = _g_object_ref0 (_tmp109_);
				_g_object_unref0 (binding->type);
				binding->type = _tmp110_;
				_tmp111_ = tracker_property_get_data_type (prop);
				((TrackerSparqlDataBinding*) binding)->data_type = _tmp111_;
				_tmp112_ = tracker_property_get_name (prop);
				_tmp113_ = g_strdup (_tmp112_);
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp113_;
				_tmp114_ = tracker_property_get_multiple_values (prop);
				if (!_tmp114_) {
					binding->maybe_null = TRUE;
					binding->in_simple_optional = in_simple_optional;
				}
			} else {
				gchar* _tmp115_;
				_tmp115_ = g_strdup ("object");
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp115_;
				binding->maybe_null = TRUE;
			}
			if (in_simple_optional) {
				state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
			} else {
				state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
			}
			tracker_sparql_pattern_add_variable_binding (self, sql, binding, state);
			_g_object_unref0 (binding);
		} else {
			if (is_fts_match) {
				TrackerSparqlLiteralBinding* _tmp116_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp117_;
				TrackerSparqlDataTable* _tmp118_;
				gchar* _tmp119_;
				TrackerSparqlLiteralBinding* _tmp120_;
				TrackerSparqlContext* _tmp121_ = NULL;
				TrackerSparqlVariable* _tmp122_ = NULL;
				const gchar* _tmp123_ = NULL;
				TrackerSparqlContext* _tmp124_ = NULL;
				TrackerSparqlVariable* _tmp125_ = NULL;
				const gchar* _tmp126_ = NULL;
				_tmp116_ = tracker_sparql_literal_binding_new ();
				binding = _tmp116_;
				binding->is_fts_match = TRUE;
				_tmp117_ = g_strdup (object);
				_g_free0 (binding->literal);
				binding->literal = _tmp117_;
				_tmp118_ = _g_object_ref0 (table);
				_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
				((TrackerSparqlDataBinding*) binding)->table = _tmp118_;
				_tmp119_ = g_strdup ("fts");
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp119_;
				_tmp120_ = _g_object_ref0 (binding);
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _tmp120_);
				_tmp121_ = tracker_sparql_pattern_get_context (self);
				_tmp122_ = tracker_sparql_context_get_variable (_tmp121_, self->priv->current_subject);
				_tmp123_ = tracker_sparql_variable_get_name (_tmp122_);
				g_string_append_printf (sql, "rank(\"%s\".\"fts\") AS \"%s_u_rank\", ", ((TrackerSparqlDataBinding*) binding)->table->sql_query_tablename, _tmp123_);
				_tmp124_ = tracker_sparql_pattern_get_context (self);
				_tmp125_ = tracker_sparql_context_get_variable (_tmp124_, self->priv->current_subject);
				_tmp126_ = tracker_sparql_variable_get_name (_tmp125_);
				g_string_append_printf (sql, "offsets(\"%s\".\"fts\") AS \"%s_u_offsets\", ", ((TrackerSparqlDataBinding*) binding)->table->sql_query_tablename, _tmp126_);
				_g_object_unref0 (binding);
			} else {
				TrackerSparqlLiteralBinding* _tmp127_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp128_;
				TrackerSparqlDataTable* _tmp129_;
				TrackerSparqlLiteralBinding* _tmp134_;
				_tmp127_ = tracker_sparql_literal_binding_new ();
				binding = _tmp127_;
				_tmp128_ = g_strdup (object);
				_g_free0 (binding->literal);
				binding->literal = _tmp128_;
				_tmp129_ = _g_object_ref0 (table);
				_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
				((TrackerSparqlDataBinding*) binding)->table = _tmp129_;
				if (prop != NULL) {
					TrackerPropertyType _tmp130_;
					const gchar* _tmp131_ = NULL;
					gchar* _tmp132_;
					_tmp130_ = tracker_property_get_data_type (prop);
					((TrackerSparqlDataBinding*) binding)->data_type = _tmp130_;
					_tmp131_ = tracker_property_get_name (prop);
					_tmp132_ = g_strdup (_tmp131_);
					_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp132_;
				} else {
					gchar* _tmp133_;
					_tmp133_ = g_strdup ("object");
					_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp133_;
				}
				_tmp134_ = _g_object_ref0 (binding);
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _tmp134_);
				_g_object_unref0 (binding);
			}
		}
		if (self->priv->current_graph != NULL) {
			_tmp135_ = prop != NULL;
		} else {
			_tmp135_ = FALSE;
		}
		if (_tmp135_) {
			if (self->priv->current_graph_is_var) {
				TrackerSparqlVariableBinding* _tmp136_ = NULL;
				TrackerSparqlVariableBinding* binding;
				TrackerSparqlContext* _tmp137_ = NULL;
				TrackerSparqlVariable* _tmp138_ = NULL;
				TrackerSparqlDataTable* _tmp139_;
				const gchar* _tmp140_ = NULL;
				gchar* _tmp141_;
				TrackerSparqlVariableState state = 0;
				_tmp136_ = tracker_sparql_variable_binding_new ();
				binding = _tmp136_;
				_tmp137_ = tracker_sparql_pattern_get_context (self);
				_tmp138_ = tracker_sparql_context_get_variable (_tmp137_, self->priv->current_graph);
				binding->variable = _tmp138_;
				_tmp139_ = _g_object_ref0 (table);
				_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
				((TrackerSparqlDataBinding*) binding)->table = _tmp139_;
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
				_tmp140_ = tracker_property_get_name (prop);
				_tmp141_ = g_strconcat (_tmp140_, ":graph", NULL);
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp141_;
				binding->maybe_null = TRUE;
				binding->in_simple_optional = in_simple_optional;
				if (in_simple_optional) {
					state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
				} else {
					state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
				}
				tracker_sparql_pattern_add_variable_binding (self, sql, binding, state);
				_g_object_unref0 (binding);
			} else {
				TrackerSparqlLiteralBinding* _tmp142_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp143_;
				TrackerSparqlDataTable* _tmp144_;
				const gchar* _tmp145_ = NULL;
				gchar* _tmp146_;
				TrackerSparqlLiteralBinding* _tmp147_;
				_tmp142_ = tracker_sparql_literal_binding_new ();
				binding = _tmp142_;
				_tmp143_ = g_strdup (self->priv->current_graph);
				_g_free0 (binding->literal);
				binding->literal = _tmp143_;
				_tmp144_ = _g_object_ref0 (table);
				_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
				((TrackerSparqlDataBinding*) binding)->table = _tmp144_;
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
				_tmp145_ = tracker_property_get_name (prop);
				_tmp146_ = g_strconcat (_tmp145_, ":graph", NULL);
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp146_;
				_tmp147_ = _g_object_ref0 (binding);
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _tmp147_);
				_g_object_unref0 (binding);
			}
		}
	}
	if (sql->len == begin_sql_len) {
		g_string_append (sql, "1, ");
	}
	_g_object_unref0 (subject_type);
	_g_object_unref0 (prop);
	_g_object_unref0 (table);
	_g_free0 (db_table);
	_g_free0 (object);
}


static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable) {
	gboolean _newtable = FALSE;
	TrackerSparqlDataTable* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* tablestring;
	TrackerSparqlDataTable* table;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subject != NULL, NULL);
	g_return_val_if_fail (db_table != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s.%s", subject, db_table);
	tablestring = _tmp0_;
	table = NULL;
	_newtable = FALSE;
	if (share_table) {
		gconstpointer _tmp1_ = NULL;
		TrackerSparqlDataTable* _tmp2_;
		_tmp1_ = g_hash_table_lookup (self->priv->triple_context->table_map, tablestring);
		_tmp2_ = _g_object_ref0 ((TrackerSparqlDataTable*) _tmp1_);
		_g_object_unref0 (table);
		table = _tmp2_;
	}
	if (table == NULL) {
		TrackerSparqlDataTable* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		TrackerSparqlDataTable* _tmp8_;
		gchar* _tmp9_;
		TrackerSparqlDataTable* _tmp10_;
		_newtable = TRUE;
		_tmp3_ = tracker_sparql_data_table_new ();
		_g_object_unref0 (table);
		table = _tmp3_;
		_tmp4_ = g_strdup (db_table);
		_g_free0 (table->sql_db_tablename);
		table->sql_db_tablename = _tmp4_;
		self->priv->counter = self->priv->counter + 1;
		_tmp5_ = g_strdup_printf ("%i", self->priv->counter);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (db_table, _tmp6_, NULL);
		_g_free0 (table->sql_query_tablename);
		table->sql_query_tablename = _tmp7_;
		_g_free0 (_tmp6_);
		_tmp8_ = _g_object_ref0 (table);
		self->priv->triple_context->tables = g_list_append (self->priv->triple_context->tables, _tmp8_);
		_tmp9_ = g_strdup (tablestring);
		_tmp10_ = _g_object_ref0 (table);
		g_hash_table_insert (self->priv->triple_context->table_map, _tmp9_, _tmp10_);
	}
	result = table;
	_g_free0 (tablestring);
	if (newtable) {
		*newtable = _newtable;
	}
	return result;
}


static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self) {
	TrackerSparqlContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->context;
	return result;
}


static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value) {
	TrackerSparqlContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _tracker_sparql_context_ref0 (value);
	_tracker_sparql_context_unref0 (self->priv->query->context);
	self->priv->query->context = _tmp0_;
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlContext* parent_context) {
	TrackerSparqlPatternTripleContext* self = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	g_return_val_if_fail (parent_context != NULL, NULL);
	self = (TrackerSparqlPatternTripleContext*) tracker_sparql_context_construct (object_type, parent_context);
	__g_list_free__g_object_unref0_0 (self->tables);
	self->tables = NULL;
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref);
	_g_hash_table_unref0 (self->table_map);
	self->table_map = _tmp0_;
	__g_list_free__g_object_unref0_0 (self->variables);
	self->variables = NULL;
	_tmp1_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, g_object_unref);
	_g_hash_table_unref0 (self->var_bindings);
	self->var_bindings = _tmp1_;
	__g_list_free__g_object_unref0_0 (self->bindings);
	self->bindings = NULL;
	return self;
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlContext* parent_context) {
	return tracker_sparql_pattern_triple_context_construct (TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, parent_context);
}


static void tracker_sparql_pattern_triple_context_class_init (TrackerSparqlPatternTripleContextClass * klass) {
	tracker_sparql_pattern_triple_context_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONTEXT_CLASS (klass)->finalize = tracker_sparql_pattern_triple_context_finalize;
}


static void tracker_sparql_pattern_triple_context_instance_init (TrackerSparqlPatternTripleContext * self) {
}


static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlPatternTripleContext * self;
	self = TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT (obj);
	__g_list_free__g_object_unref0_0 (self->tables);
	_g_hash_table_unref0 (self->table_map);
	__g_list_free__g_object_unref0_0 (self->bindings);
	__g_list_free__g_object_unref0_0 (self->variables);
	_g_hash_table_unref0 (self->var_bindings);
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_pattern_triple_context_parent_class)->finalize (obj);
}


static GType tracker_sparql_pattern_triple_context_get_type (void) {
	static volatile gsize tracker_sparql_pattern_triple_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_triple_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternTripleContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_triple_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPatternTripleContext), 0, (GInstanceInitFunc) tracker_sparql_pattern_triple_context_instance_init, NULL };
		GType tracker_sparql_pattern_triple_context_type_id;
		tracker_sparql_pattern_triple_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlPatternTripleContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_triple_context_type_id__volatile, tracker_sparql_pattern_triple_context_type_id);
	}
	return tracker_sparql_pattern_triple_context_type_id__volatile;
}


static void tracker_sparql_pattern_class_init (TrackerSparqlPatternClass * klass) {
	tracker_sparql_pattern_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlPatternPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_pattern_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_pattern_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_pattern_finalize;
}


static void tracker_sparql_pattern_instance_init (TrackerSparqlPattern * self) {
	self->priv = TRACKER_SPARQL_PATTERN_GET_PRIVATE (self);
}


static void tracker_sparql_pattern_finalize (GObject* obj) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (obj);
	_g_free0 (self->priv->current_graph);
	_g_free0 (self->priv->current_subject);
	_g_free0 (self->priv->current_predicate);
	_tracker_sparql_context_unref0 (self->priv->triple_context);
	G_OBJECT_CLASS (tracker_sparql_pattern_parent_class)->finalize (obj);
}


GType tracker_sparql_pattern_get_type (void) {
	static volatile gsize tracker_sparql_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPattern), 0, (GInstanceInitFunc) tracker_sparql_pattern_instance_init, NULL };
		GType tracker_sparql_pattern_type_id;
		tracker_sparql_pattern_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPattern", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_type_id__volatile, tracker_sparql_pattern_type_id);
	}
	return tracker_sparql_pattern_type_id__volatile;
}


static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



