/* tracker-sparql-expression.c generated by valac 0.20.1, the Vala compiler
 * generated from tracker-sparql-expression.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-property.h"
#include "libtracker-data/tracker-db-interface-sqlite.h"
#include "libtracker-data/tracker-class.h"
#include "libtracker-data/tracker-collation.h"
#include "libtracker-data/tracker-ontologies.h"


#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;
typedef struct _TrackerSparqlExpressionPrivate TrackerSparqlExpressionPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

struct _TrackerSparqlExpression {
	GObject parent_instance;
	TrackerSparqlExpressionPrivate * priv;
};

struct _TrackerSparqlExpressionClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlExpressionPrivate {
	TrackerSparqlQuery* query;
	gchar* fts_sql;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
	TrackerSparqlVariable* fts_subject;
	gchar** fts_variables;
	gint fts_variables_length1;
	gint _fts_variables_size_;
	GString* match_str;
	gboolean queries_fts_data;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_expression_parent_class = NULL;

GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionPrivate))
enum  {
	TRACKER_SPARQL_EXPRESSION_DUMMY_PROPERTY
};
#define TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN 20
#define TRACKER_SPARQL_EXPRESSION_XSD_NS "http://www.w3.org/2001/XMLSchema#"
#define TRACKER_SPARQL_EXPRESSION_FN_NS "http://www.w3.org/2005/xpath-functions#"
#define TRACKER_SPARQL_EXPRESSION_FTS_NS "http://www.tracker-project.org/ontologies/fts#"
#define TRACKER_SPARQL_EXPRESSION_TRACKER_NS "http://www.tracker-project.org/ontologies/tracker#"
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal);
static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type);
static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql);
static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value);
static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_finalize (GObject* obj);
static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlExpression * self = NULL;
	TrackerSparqlQuery* _tmp0_;
#line 31 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 31 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self = (TrackerSparqlExpression*) g_object_new (object_type, NULL);
#line 32 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = query;
#line 32 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv->query = _tmp0_;
#line 31 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return self;
#line 520 "tracker-sparql-expression.c"
}


TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query) {
#line 31 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return tracker_sparql_expression_construct (TRACKER_SPARQL_TYPE_EXPRESSION, query);
#line 527 "tracker-sparql-expression.c"
}


static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 43 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_next (_tmp0_, &_inner_error_);
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 553 "tracker-sparql-expression.c"
		} else {
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 561 "tracker-sparql-expression.c"
		}
	}
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 44 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 568 "tracker-sparql-expression.c"
}


static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 47 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 48 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 48 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_current (_tmp0_);
#line 48 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 48 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 586 "tracker-sparql-expression.c"
}


static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 51 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 52 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 52 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_last (_tmp0_);
#line 52 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 52 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 604 "tracker-sparql-expression.c"
}


static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 55 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = type;
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_accept (_tmp0_, _tmp1_, &_inner_error_);
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 633 "tracker-sparql-expression.c"
		} else {
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 641 "tracker-sparql-expression.c"
		}
	}
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp3_;
#line 56 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 648 "tracker-sparql-expression.c"
}


static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_ = NULL;
#line 59 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 60 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 60 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = msg;
#line 60 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_get_error (_tmp0_, _tmp1_);
#line 60 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 60 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 671 "tracker-sparql-expression.c"
}


static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 63 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = type;
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_expect (_tmp0_, _tmp1_, &_inner_error_);
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 700 "tracker-sparql-expression.c"
		} else {
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 708 "tracker-sparql-expression.c"
		}
	}
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp3_;
#line 64 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 715 "tracker-sparql-expression.c"
}


static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip) {
	gchar* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
#line 67 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 68 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = strip;
#line 68 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_get_last_string (_tmp0_, _tmp1_);
#line 68 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 68 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 736 "tracker-sparql-expression.c"
}


static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
#line 71 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (literal != NULL, NULL);
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = literal;
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "'", 0);
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = g_strjoinv ("''", _tmp3_);
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = _tmp4_;
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = g_strdup_printf ("'%s'", _tmp5_);
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = _tmp6_;
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp5_);
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp7_;
#line 72 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 779 "tracker-sparql-expression.c"
}


static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	TrackerPropertyType _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_;
	gboolean _tmp12_;
#line 75 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = type;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp4_ == TRACKER_PROPERTY_TYPE_INTEGER) {
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = TRUE;
#line 802 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp5_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = type;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp5_ == TRACKER_PROPERTY_TYPE_DOUBLE;
#line 809 "tracker-sparql-expression.c"
	}
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = _tmp3_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp6_) {
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = TRUE;
#line 817 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp7_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = type;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = _tmp7_ == TRACKER_PROPERTY_TYPE_DATE;
#line 824 "tracker-sparql-expression.c"
	}
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp2_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp8_) {
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = TRUE;
#line 832 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp9_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = type;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = _tmp9_ == TRACKER_PROPERTY_TYPE_DATETIME;
#line 839 "tracker-sparql-expression.c"
	}
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = _tmp1_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp10_) {
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = TRUE;
#line 847 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp11_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = type;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = _tmp11_ == TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 854 "tracker-sparql-expression.c"
	}
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp12_ = _tmp0_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp12_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 862 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql) {
	GString* _tmp0_;
#line 79 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 80 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 80 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append_printf (_tmp0_, " COLLATE %s", TRACKER_COLLATION_NAME);
#line 876 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 83 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 894 "tracker-sparql-expression.c"
		} else {
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 902 "tracker-sparql-expression.c"
		}
	}
#line 85 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 907 "tracker-sparql-expression.c"
		TrackerSparqlTokenType _tmp0_ = 0;
#line 86 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_current (self);
#line 86 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		switch (_tmp0_) {
#line 86 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 915 "tracker-sparql-expression.c"
			{
#line 89 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
#line 89 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 89 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 89 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 89 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 927 "tracker-sparql-expression.c"
					} else {
#line 89 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 89 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 935 "tracker-sparql-expression.c"
					}
				}
#line 90 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 940 "tracker-sparql-expression.c"
			}
#line 86 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 86 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 946 "tracker-sparql-expression.c"
			{
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 950 "tracker-sparql-expression.c"
			}
			default:
			{
#line 95 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error_);
#line 95 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 95 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 95 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 95 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 964 "tracker-sparql-expression.c"
					} else {
#line 95 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 95 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 972 "tracker-sparql-expression.c"
					}
				}
#line 96 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 977 "tracker-sparql-expression.c"
			}
		}
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 982 "tracker-sparql-expression.c"
	}
#line 100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 994 "tracker-sparql-expression.c"
		} else {
#line 100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 1002 "tracker-sparql-expression.c"
		}
	}
}


void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 1014 "tracker-sparql-expression.c"
		TrackerSparqlTokenType _tmp0_ = 0;
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_current (self);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		switch (_tmp0_) {
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 1022 "tracker-sparql-expression.c"
			{
#line 107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
#line 107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1034 "tracker-sparql-expression.c"
					} else {
#line 107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1042 "tracker-sparql-expression.c"
					}
				}
#line 108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 1047 "tracker-sparql-expression.c"
			}
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 1065 "tracker-sparql-expression.c"
			{
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 1069 "tracker-sparql-expression.c"
			}
			default:
			{
#line 119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error_);
#line 119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1083 "tracker-sparql-expression.c"
					} else {
#line 119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1091 "tracker-sparql-expression.c"
					}
				}
#line 120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 1096 "tracker-sparql-expression.c"
			}
		}
#line 122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 1101 "tracker-sparql-expression.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1125 "tracker-sparql-expression.c"
		glong _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1133 "tracker-sparql-expression.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1145 "tracker-sparql-expression.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1168 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1170 "tracker-sparql-expression.c"
		glong _tmp2_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1176 "tracker-sparql-expression.c"
	} else {
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1180 "tracker-sparql-expression.c"
	}
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1186 "tracker-sparql-expression.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1198 "tracker-sparql-expression.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1208 "tracker-sparql-expression.c"
	}
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1214 "tracker-sparql-expression.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1228 "tracker-sparql-expression.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1238 "tracker-sparql-expression.c"
	}
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1244 "tracker-sparql-expression.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1253 "tracker-sparql-expression.c"
	}
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1273 "tracker-sparql-expression.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return self ? g_object_ref (self) : NULL;
#line 1280 "tracker-sparql-expression.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1291 "tracker-sparql-expression.c"
	}
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1297 "tracker-sparql-expression.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1308 "tracker-sparql-expression.c"
	}
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1314 "tracker-sparql-expression.c"
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1325 "tracker-sparql-expression.c"
	}
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1331 "tracker-sparql-expression.c"
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1342 "tracker-sparql-expression.c"
	}
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1348 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlVariable* variable;
	gboolean expect_close_parens;
	gboolean as_handled;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	TrackerPropertyType type;
	TrackerSparqlTokenType _tmp2_ = 0;
	gboolean _tmp42_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_;
	TrackerSparqlPattern* _tmp83_;
	TrackerSparqlPattern* _tmp84_;
	TrackerSparqlVariable* _tmp85_;
	gboolean _tmp118_;
	TrackerSparqlVariable* _tmp119_;
	GError * _inner_error_ = NULL;
#line 126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	variable = NULL;
#line 128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	expect_close_parens = FALSE;
#line 129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	as_handled = FALSE;
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_expression_current (self);
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp2_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 1393 "tracker-sparql-expression.c"
		GString* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		TrackerSparqlVariable* _tmp12_ = NULL;
		TrackerSparqlVariable* _tmp13_;
		TrackerSparqlVariable* _tmp14_;
		TrackerSparqlVariableBinding* _tmp15_;
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1423 "tracker-sparql-expression.c"
			} else {
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1433 "tracker-sparql-expression.c"
			}
		}
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = _tmp5_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_get_context (self);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_context_get_variable (_tmp7_, _tmp11_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable = _tmp13_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp11_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp9_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = variable;
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = _tmp14_->binding;
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ == NULL) {
#line 1468 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			GError* _tmp21_ = NULL;
			GError* _tmp22_;
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = variable;
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = tracker_sparql_variable_get_name (_tmp16_);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = _tmp17_;
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = g_strdup_printf ("use of undefined variable `%s'", _tmp18_);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp19_;
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = tracker_sparql_expression_get_error (self, _tmp20_);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp20_);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp22_;
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1502 "tracker-sparql-expression.c"
			} else {
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1512 "tracker-sparql-expression.c"
			}
		}
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp23_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp24_ = _tmp23_;
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1532 "tracker-sparql-expression.c"
			} else {
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1542 "tracker-sparql-expression.c"
			}
		}
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp24_) {
#line 1547 "tracker-sparql-expression.c"
			TrackerSparqlTokenType _tmp25_ = 0;
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = tracker_sparql_expression_current (self);
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp25_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 1553 "tracker-sparql-expression.c"
				GString* _tmp26_;
				TrackerSparqlPattern* _tmp27_;
				TrackerSparqlPattern* _tmp28_;
				GString* _tmp29_;
				TrackerSparqlSelectContext* _tmp30_ = NULL;
				TrackerSparqlSelectContext* select_context;
				GString* _tmp31_;
				TrackerSparqlSelectContext* _tmp32_;
				TrackerPropertyType _tmp33_;
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp26_, "(");
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_get_pattern (self);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = sql;
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = tracker_sparql_pattern_translate_select (_tmp28_, _tmp29_, TRUE, TRUE, &_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				select_context = _tmp30_;
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1587 "tracker-sparql-expression.c"
					} else {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1597 "tracker-sparql-expression.c"
					}
				}
#line 147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tracker_sparql_context_unref0 (select_context);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1618 "tracker-sparql-expression.c"
					} else {
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tracker_sparql_context_unref0 (select_context);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1630 "tracker-sparql-expression.c"
					}
				}
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = select_context;
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp33_ = _tmp32_->type;
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp33_;
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1641 "tracker-sparql-expression.c"
			} else {
				GString* _tmp34_;
				TrackerPropertyType _tmp35_ = 0;
				TrackerPropertyType _tmp36_;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_;
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp34_ = sql;
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp35_ = tracker_sparql_expression_translate_expression (self, _tmp34_, &_inner_error_);
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp36_ = _tmp35_;
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1664 "tracker-sparql-expression.c"
					} else {
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1674 "tracker-sparql-expression.c"
					}
				}
#line 152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp36_;
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp37_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = _tmp37_;
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1693 "tracker-sparql-expression.c"
					} else {
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1703 "tracker-sparql-expression.c"
					}
				}
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp38_) {
#line 1708 "tracker-sparql-expression.c"
				} else {
#line 159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					expect_close_parens = TRUE;
#line 1712 "tracker-sparql-expression.c"
				}
			}
		} else {
			GString* _tmp39_;
			TrackerPropertyType _tmp40_ = 0;
			TrackerPropertyType _tmp41_;
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp39_ = sql;
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp40_ = tracker_sparql_expression_translate_expression (self, _tmp39_, &_inner_error_);
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp41_ = _tmp40_;
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1735 "tracker-sparql-expression.c"
				} else {
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1745 "tracker-sparql-expression.c"
				}
			}
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp41_;
#line 1750 "tracker-sparql-expression.c"
		}
	}
#line 168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp42_ = subquery;
#line 168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp42_) {
#line 1757 "tracker-sparql-expression.c"
		GString* _tmp43_;
		TrackerPropertyType _tmp44_;
		glong _tmp45_;
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp43_ = sql;
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp44_ = type;
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp45_ = begin;
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_convert_expression_to_string (_tmp43_, _tmp44_, _tmp45_);
#line 1769 "tracker-sparql-expression.c"
	}
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp46_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp47_ = _tmp46_;
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 1785 "tracker-sparql-expression.c"
		} else {
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 1795 "tracker-sparql-expression.c"
		}
	}
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp47_) {
#line 1800 "tracker-sparql-expression.c"
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_;
		GString* _tmp64_;
		TrackerSparqlVariable* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		gboolean _tmp68_;
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp48_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp49_ = _tmp48_;
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1822 "tracker-sparql-expression.c"
			} else {
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1832 "tracker-sparql-expression.c"
			}
		}
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp49_) {
#line 1837 "tracker-sparql-expression.c"
			TrackerSparqlContext* _tmp50_;
			TrackerSparqlContext* _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			TrackerSparqlVariable* _tmp54_ = NULL;
			TrackerSparqlVariable* _tmp55_;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp50_ = tracker_sparql_expression_get_context (self);
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = _tmp50_;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp52_ = tracker_sparql_expression_get_last_string (self, 0);
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp53_ = _tmp52_;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp54_ = tracker_sparql_context_get_variable (_tmp51_, _tmp53_);
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = _g_object_ref0 (_tmp54_);
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp55_;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp53_);
#line 1862 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlContext* _tmp56_;
			TrackerSparqlContext* _tmp57_;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_;
			TrackerSparqlVariable* _tmp62_ = NULL;
			TrackerSparqlVariable* _tmp63_;
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1884 "tracker-sparql-expression.c"
				} else {
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1894 "tracker-sparql-expression.c"
				}
			}
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_ = tracker_sparql_expression_get_context (self);
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = _tmp56_;
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp58_ = tracker_sparql_expression_get_last_string (self, 0);
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = _tmp58_;
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp60_ = string_substring (_tmp59_, (glong) 1, (glong) (-1));
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp61_ = _tmp60_;
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_context_get_variable (_tmp57_, _tmp61_);
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp63_ = _g_object_ref0 (_tmp62_);
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp63_;
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp61_);
#line 181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp59_);
#line 1921 "tracker-sparql-expression.c"
		}
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp64_ = sql;
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp65_ = variable;
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp66_ = tracker_sparql_variable_get_sql_expression (_tmp65_);
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp67_ = _tmp66_;
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append_printf (_tmp64_, " AS %s", _tmp67_);
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		as_handled = TRUE;
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp68_ = subquery;
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp68_) {
#line 1939 "tracker-sparql-expression.c"
			TrackerSparqlVariableBinding* _tmp69_;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlVariableBinding* _tmp70_;
			TrackerPropertyType _tmp71_;
			TrackerSparqlVariableBinding* _tmp72_;
			TrackerSparqlVariable* _tmp73_;
			TrackerSparqlVariableBinding* _tmp74_;
			TrackerSparqlVariable* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			TrackerSparqlPattern* _tmp78_;
			TrackerSparqlPattern* _tmp79_;
			GString* _tmp80_;
			GString* _tmp81_;
			TrackerSparqlVariableBinding* _tmp82_;
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp69_ = tracker_sparql_variable_binding_new ();
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			binding = _tmp69_;
#line 188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp70_ = binding;
#line 188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp71_ = type;
#line 188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) _tmp70_)->data_type = _tmp71_;
#line 189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp72_ = binding;
#line 189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp73_ = variable;
#line 189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp72_->variable = _tmp73_;
#line 190 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp74_ = binding;
#line 190 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp75_ = variable;
#line 190 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp76_ = tracker_sparql_variable_get_sql_expression (_tmp75_);
#line 190 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp77_ = _tmp76_;
#line 190 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp74_, _tmp77_);
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp78_ = tracker_sparql_expression_get_pattern (self);
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp79_ = _tmp78_;
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp80_ = g_string_new ("");
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp81_ = _tmp80_;
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp82_ = binding;
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_pattern_add_variable_binding (_tmp79_, _tmp81_, _tmp82_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_string_free0 (_tmp81_);
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 1997 "tracker-sparql-expression.c"
		}
	}
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp83_ = tracker_sparql_expression_get_pattern (self);
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp84_ = _tmp83_;
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp85_ = _tmp84_->fts_subject;
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp85_ != NULL) {
#line 2008 "tracker-sparql-expression.c"
		TrackerSparqlVariable* _tmp86_;
		const gchar* _tmp94_;
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp86_ = variable;
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp86_ == NULL) {
#line 2015 "tracker-sparql-expression.c"
			TrackerSparqlContext* _tmp87_;
			TrackerSparqlContext* _tmp88_;
			gint _tmp89_;
			gchar* _tmp90_ = NULL;
			gchar* _tmp91_;
			TrackerSparqlVariable* _tmp92_ = NULL;
			TrackerSparqlVariable* _tmp93_;
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp87_ = tracker_sparql_expression_get_context (self);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp88_ = _tmp87_;
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp89_ = variable_index;
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp90_ = g_strdup_printf ("var%d", _tmp89_ + 1);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp91_ = _tmp90_;
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp92_ = tracker_sparql_context_get_variable (_tmp88_, _tmp91_);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp93_ = _g_object_ref0 (_tmp92_);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp93_;
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp91_);
#line 2043 "tracker-sparql-expression.c"
		}
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp94_ = self->priv->fts_sql;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp94_ == NULL) {
#line 2049 "tracker-sparql-expression.c"
			TrackerSparqlPattern* _tmp95_;
			TrackerSparqlPattern* _tmp96_;
			TrackerSparqlPattern* _tmp97_;
			TrackerSparqlPattern* _tmp98_;
			gchar** _tmp99_;
			gint _tmp99__length1;
			TrackerSparqlVariable* _tmp100_;
			const gchar* _tmp101_;
			const gchar* _tmp102_;
			gchar* _tmp103_;
			gboolean _tmp104_;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp95_ = tracker_sparql_expression_get_pattern (self);
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp96_ = _tmp95_;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp97_ = tracker_sparql_expression_get_pattern (self);
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp98_ = _tmp97_;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp99_ = _tmp98_->fts_variables;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp99__length1 = _tmp98_->fts_variables_length1;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp100_ = variable;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp101_ = tracker_sparql_variable_get_sql_expression (_tmp100_);
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp102_ = _tmp101_;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp103_ = g_strdup (_tmp102_);
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_vala_array_add1 (&_tmp96_->fts_variables, &_tmp96_->fts_variables_length1, &_tmp96_->_fts_variables_size_, _tmp103_);
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp104_ = as_handled;
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp104_ == FALSE) {
#line 2087 "tracker-sparql-expression.c"
				GString* _tmp105_;
				TrackerSparqlVariable* _tmp106_;
				const gchar* _tmp107_;
				const gchar* _tmp108_;
#line 206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp105_ = sql;
#line 206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp106_ = variable;
#line 206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp107_ = tracker_sparql_variable_get_sql_expression (_tmp106_);
#line 206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp108_ = _tmp107_;
#line 206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append_printf (_tmp105_, " AS %s", _tmp108_);
#line 2102 "tracker-sparql-expression.c"
			}
		} else {
			TrackerSparqlPattern* _tmp109_;
			TrackerSparqlPattern* _tmp110_;
			TrackerSparqlPattern* _tmp111_;
			TrackerSparqlPattern* _tmp112_;
			gchar** _tmp113_;
			gint _tmp113__length1;
			const gchar* _tmp114_;
			gchar* _tmp115_;
			TrackerSparqlPattern* _tmp116_;
			TrackerSparqlPattern* _tmp117_;
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp109_ = tracker_sparql_expression_get_pattern (self);
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp110_ = _tmp109_;
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp111_ = tracker_sparql_expression_get_pattern (self);
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp112_ = _tmp111_;
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp113_ = _tmp112_->fts_variables;
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp113__length1 = _tmp112_->fts_variables_length1;
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp114_ = self->priv->fts_sql;
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp115_ = g_strdup (_tmp114_);
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_vala_array_add2 (&_tmp110_->fts_variables, &_tmp110_->fts_variables_length1, &_tmp110_->_fts_variables_size_, _tmp115_);
#line 210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp116_ = tracker_sparql_expression_get_pattern (self);
#line 210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp117_ = _tmp116_;
#line 210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp117_->queries_fts_data = TRUE;
#line 2139 "tracker-sparql-expression.c"
		}
	}
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp118_ = expect_close_parens;
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp118_) {
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 2158 "tracker-sparql-expression.c"
			} else {
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 2168 "tracker-sparql-expression.c"
			}
		}
	}
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp119_ = variable;
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp119_ != NULL) {
#line 2176 "tracker-sparql-expression.c"
		TrackerSparqlContext* _tmp120_;
		TrackerSparqlContext* _tmp121_;
		GHashTable* _tmp122_;
		TrackerSparqlVariable* _tmp123_;
		gconstpointer _tmp124_ = NULL;
		gint state;
		gint _tmp125_;
		TrackerSparqlContext* _tmp126_;
		TrackerSparqlContext* _tmp127_;
		GHashTable* _tmp128_;
		TrackerSparqlVariable* _tmp129_;
		TrackerSparqlVariable* _tmp130_;
		gint _tmp131_;
		TrackerSparqlContext* _tmp132_;
		TrackerSparqlContext* _tmp133_;
		TrackerSparqlContext* _tmp134_;
		TrackerSparqlContext* _tmp135_;
		gchar** _tmp136_;
		gint _tmp136__length1;
		TrackerSparqlVariable* _tmp137_;
		const gchar* _tmp138_;
		const gchar* _tmp139_;
		gchar* _tmp140_;
#line 219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp120_ = tracker_sparql_expression_get_context (self);
#line 219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp121_ = _tmp120_;
#line 219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp122_ = _tmp121_->var_set;
#line 219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp123_ = variable;
#line 219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp124_ = g_hash_table_lookup (_tmp122_, _tmp123_);
#line 219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		state = (gint) ((gintptr) _tmp124_);
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp125_ = state;
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp125_ == 0) {
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			state = (gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 2218 "tracker-sparql-expression.c"
		}
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp126_ = tracker_sparql_expression_get_context (self);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp127_ = _tmp126_;
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp128_ = _tmp127_->select_var_set;
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp129_ = variable;
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp130_ = _g_object_ref0 (_tmp129_);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp131_ = state;
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_hash_table_insert (_tmp128_, _tmp130_, (gpointer) ((gintptr) _tmp131_));
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp132_ = tracker_sparql_expression_get_context (self);
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp133_ = _tmp132_;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp134_ = tracker_sparql_expression_get_context (self);
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp135_ = _tmp134_;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp136_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp136__length1 = G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp137_ = variable;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp138_ = tracker_sparql_variable_get_name (_tmp137_);
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp139_ = _tmp138_;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp140_ = g_strdup (_tmp139_);
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_vala_array_add3 (&G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names, &G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1, &G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->_variable_names_size_, _tmp140_);
#line 2256 "tracker-sparql-expression.c"
	} else {
		TrackerSparqlContext* _tmp141_;
		TrackerSparqlContext* _tmp142_;
		TrackerSparqlContext* _tmp143_;
		TrackerSparqlContext* _tmp144_;
		gchar** _tmp145_;
		gint _tmp145__length1;
		gint _tmp146_;
		gchar* _tmp147_ = NULL;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp141_ = tracker_sparql_expression_get_context (self);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp142_ = _tmp141_;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp143_ = tracker_sparql_expression_get_context (self);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp144_ = _tmp143_;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp145_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp145__length1 = G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp146_ = variable_index;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp147_ = g_strdup_printf ("var%d", _tmp146_ + 1);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_vala_array_add4 (&G_TYPE_CHECK_INSTANCE_CAST (_tmp142_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names, &G_TYPE_CHECK_INSTANCE_CAST (_tmp142_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1, &G_TYPE_CHECK_INSTANCE_CAST (_tmp142_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->_variable_names_size_, _tmp147_);
#line 2284 "tracker-sparql-expression.c"
	}
#line 230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (self->priv->fts_sql);
#line 230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv->fts_sql = NULL;
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_object_unref0 (variable);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 2296 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType _tmp4_;
	GError * _inner_error_ = NULL;
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 236 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 236 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 236 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_expression (self, _tmp2_, &_inner_error_);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2332 "tracker-sparql-expression.c"
		} else {
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2340 "tracker-sparql-expression.c"
		}
	}
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp4_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 2345 "tracker-sparql-expression.c"
		GString* _tmp5_;
		GString* _tmp6_;
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp5_, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
#line 240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp6_, ")");
#line 2356 "tracker-sparql-expression.c"
	}
}


void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error_);
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2381 "tracker-sparql-expression.c"
		} else {
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2389 "tracker-sparql-expression.c"
		}
	}
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 2394 "tracker-sparql-expression.c"
		GString* _tmp2_;
		GString* _tmp3_;
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp2_, &_inner_error_);
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2409 "tracker-sparql-expression.c"
			} else {
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2417 "tracker-sparql-expression.c"
			}
		}
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp3_, " ASC");
#line 2424 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error_);
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2440 "tracker-sparql-expression.c"
			} else {
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2448 "tracker-sparql-expression.c"
			}
		}
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 2453 "tracker-sparql-expression.c"
			GString* _tmp6_;
			GString* _tmp7_;
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = sql;
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp6_, &_inner_error_);
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2468 "tracker-sparql-expression.c"
				} else {
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2476 "tracker-sparql-expression.c"
				}
			}
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = sql;
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp7_, " DESC");
#line 2483 "tracker-sparql-expression.c"
		} else {
			GString* _tmp8_;
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = sql;
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp8_, &_inner_error_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2498 "tracker-sparql-expression.c"
				} else {
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2506 "tracker-sparql-expression.c"
				}
			}
		}
	}
}


static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GError * _inner_error_ = NULL;
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error_);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2533 "tracker-sparql-expression.c"
		} else {
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2541 "tracker-sparql-expression.c"
		}
	}
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2554 "tracker-sparql-expression.c"
		} else {
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2562 "tracker-sparql-expression.c"
		}
	}
#line 259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(");
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp1_, &_inner_error_);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2581 "tracker-sparql-expression.c"
		} else {
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2589 "tracker-sparql-expression.c"
		}
	}
#line 261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " IS NOT NULL)");
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2606 "tracker-sparql-expression.c"
		} else {
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2614 "tracker-sparql-expression.c"
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	TrackerPropertyType _tmp4_ = 0;
	TrackerPropertyType type;
	GString* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	GError * _inner_error_ = NULL;
#line 265 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 265 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IF, &_inner_error_);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2646 "tracker-sparql-expression.c"
		} else {
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2654 "tracker-sparql-expression.c"
		}
	}
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2667 "tracker-sparql-expression.c"
		} else {
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2675 "tracker-sparql-expression.c"
		}
	}
#line 270 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 270 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(CASE ");
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp1_, &_inner_error_);
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2694 "tracker-sparql-expression.c"
		} else {
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2702 "tracker-sparql-expression.c"
		}
	}
#line 274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " WHEN 1 THEN ");
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2719 "tracker-sparql-expression.c"
		} else {
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2727 "tracker-sparql-expression.c"
		}
	}
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	type = _tmp4_;
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2744 "tracker-sparql-expression.c"
		} else {
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2752 "tracker-sparql-expression.c"
		}
	}
#line 279 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 279 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp5_, " WHEN 0 THEN ");
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2769 "tracker-sparql-expression.c"
		} else {
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2777 "tracker-sparql-expression.c"
		}
	}
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = sql;
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2792 "tracker-sparql-expression.c"
		} else {
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2800 "tracker-sparql-expression.c"
		}
	}
#line 283 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = sql;
#line 283 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp7_, " ELSE NULL END)");
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2817 "tracker-sparql-expression.c"
		} else {
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2825 "tracker-sparql-expression.c"
		}
	}
#line 287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 2832 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	GString* _tmp19_;
	GError * _inner_error_ = NULL;
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error_);
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2865 "tracker-sparql-expression.c"
		} else {
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2873 "tracker-sparql-expression.c"
		}
	}
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2886 "tracker-sparql-expression.c"
		} else {
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2894 "tracker-sparql-expression.c"
		}
	}
#line 293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "SparqlRegex(");
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, _tmp1_, &_inner_error_);
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2913 "tracker-sparql-expression.c"
		} else {
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2921 "tracker-sparql-expression.c"
		}
	}
#line 295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, ", ");
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2938 "tracker-sparql-expression.c"
		} else {
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2946 "tracker-sparql-expression.c"
		}
	}
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2961 "tracker-sparql-expression.c"
		} else {
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2969 "tracker-sparql-expression.c"
		}
	}
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = _tmp4_;
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp6_);
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp7_;
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp5_, _tmp8_);
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp8_);
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp6_);
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = sql;
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp9_, ", ");
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp11_ = _tmp10_;
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3002 "tracker-sparql-expression.c"
		} else {
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3010 "tracker-sparql-expression.c"
		}
	}
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp11_) {
#line 3015 "tracker-sparql-expression.c"
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GString* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3034 "tracker-sparql-expression.c"
			} else {
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3042 "tracker-sparql-expression.c"
			}
		}
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = _tmp13_;
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp15_);
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp17_ = _tmp16_;
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, _tmp17_);
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp17_);
#line 305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp15_);
#line 3059 "tracker-sparql-expression.c"
	} else {
		GString* _tmp18_;
#line 307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp18_ = sql;
#line 307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp18_, "''");
#line 3066 "tracker-sparql-expression.c"
	}
#line 309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp19_, ")");
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3082 "tracker-sparql-expression.c"
		} else {
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3090 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
	TrackerSparqlPattern* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GError * _inner_error_ = NULL;
#line 313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(");
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_get_pattern (self);
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_pattern_translate_exists (_tmp2_, _tmp3_, &_inner_error_);
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3127 "tracker-sparql-expression.c"
		} else {
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3135 "tracker-sparql-expression.c"
		}
	}
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp4_, ")");
#line 3142 "tracker-sparql-expression.c"
}


void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp4_;
	TrackerPropertyType _tmp5_;
#line 319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (expression != NULL);
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = expression;
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = type;
#line 322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_convert_expression_to_string (_tmp4_, _tmp5_, begin);
#line 3176 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin) {
	TrackerPropertyType _tmp0_;
#line 325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = type;
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_STRING:
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_INTEGER:
#line 3192 "tracker-sparql-expression.c"
		{
#line 332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3196 "tracker-sparql-expression.c"
		}
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_RESOURCE:
#line 3200 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			glong _tmp2_;
			GString* _tmp3_;
#line 335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = begin;
#line 335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp1_, (gssize) _tmp2_, "(SELECT Uri FROM Resource WHERE ID = ");
#line 336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = sql;
#line 336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp3_, ")");
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3217 "tracker-sparql-expression.c"
		}
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 3221 "tracker-sparql-expression.c"
		{
			GString* _tmp4_;
			glong _tmp5_;
			GString* _tmp6_;
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = begin;
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp4_, (gssize) _tmp5_, "CASE ");
#line 341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = sql;
#line 341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp6_, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3238 "tracker-sparql-expression.c"
		}
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATE:
#line 3242 "tracker-sparql-expression.c"
		{
			GString* _tmp7_;
			glong _tmp8_;
			GString* _tmp9_;
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = sql;
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = begin;
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp7_, (gssize) _tmp8_, "strftime (\"%Y-%m-%d\", ");
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp9_, ", \"unixepoch\")");
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3259 "tracker-sparql-expression.c"
		}
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATETIME:
#line 3263 "tracker-sparql-expression.c"
		{
			GString* _tmp10_;
			glong _tmp11_;
			GString* _tmp12_;
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = sql;
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = begin;
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp10_, (gssize) _tmp11_, "SparqlFormatTime (");
#line 351 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 351 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp12_, ")");
#line 352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3280 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp13_;
			glong _tmp14_;
			GString* _tmp15_;
#line 355 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = sql;
#line 355 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = begin;
#line 355 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp13_, (gssize) _tmp14_, "CAST (");
#line 356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = sql;
#line 356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp15_, " AS TEXT)");
#line 357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3299 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 3322 "tracker-sparql-expression.c"
		{
			TrackerSparqlLiteralBinding* _tmp1_;
			TrackerSparqlLiteralBinding* binding;
			gboolean is_var = FALSE;
			TrackerSparqlPattern* _tmp2_;
			TrackerSparqlPattern* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			TrackerSparqlLiteralBinding* _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_;
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = tracker_sparql_literal_binding_new ();
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			binding = _tmp1_;
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_pattern_parse_var_or_term (_tmp3_, NULL, &_tmp4_, &_inner_error_);
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			is_var = _tmp4_;
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3359 "tracker-sparql-expression.c"
				} else {
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3369 "tracker-sparql-expression.c"
				}
			}
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = binding;
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp7_->literal);
#line 369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_->literal = _tmp6_;
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3392 "tracker-sparql-expression.c"
				} else {
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3402 "tracker-sparql-expression.c"
				}
			}
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp9_) {
#line 3407 "tracker-sparql-expression.c"
				GString* _tmp10_;
				gssize _tmp11_;
				glong begin;
				GString* _tmp12_;
				TrackerSparqlLiteralBinding* _tmp13_;
				const gchar* _tmp14_;
				TrackerPropertyType _tmp15_ = 0;
				TrackerPropertyType type;
				GString* _tmp16_;
				TrackerPropertyType _tmp17_;
				glong _tmp18_;
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = sql;
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = _tmp10_->len;
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				begin = (glong) _tmp11_;
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp12_ = sql;
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = binding;
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = _tmp13_->literal;
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = tracker_sparql_expression_translate_function (self, _tmp12_, _tmp14_, &_inner_error_);
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp15_;
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3445 "tracker-sparql-expression.c"
					} else {
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3455 "tracker-sparql-expression.c"
					}
				}
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3470 "tracker-sparql-expression.c"
					} else {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3480 "tracker-sparql-expression.c"
					}
				}
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = type;
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = begin;
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_convert_expression_to_string (_tmp16_, _tmp17_, _tmp18_);
#line 3491 "tracker-sparql-expression.c"
			} else {
				GString* _tmp19_;
				TrackerSparqlQuery* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
#line 377 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp19_ = sql;
#line 377 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp19_, "?");
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = self->priv->query;
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = binding;
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_->bindings = g_list_append (_tmp20_->bindings, _tmp22_);
#line 3509 "tracker-sparql-expression.c"
			}
#line 380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3515 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp23_;
			gssize _tmp24_;
			glong begin;
			GString* _tmp25_;
			TrackerPropertyType _tmp26_ = 0;
			TrackerPropertyType type;
			GString* _tmp27_;
			TrackerPropertyType _tmp28_;
			glong _tmp29_;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = sql;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_->len;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			begin = (glong) _tmp24_;
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = sql;
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = tracker_sparql_expression_translate_expression (self, _tmp25_, &_inner_error_);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp26_;
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3548 "tracker-sparql-expression.c"
				} else {
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3556 "tracker-sparql-expression.c"
				}
			}
#line 384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = sql;
#line 384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = type;
#line 384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = begin;
#line 384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_convert_expression_to_string (_tmp27_, _tmp28_, _tmp29_);
#line 385 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3569 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GError * _inner_error_ = NULL;
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error_);
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3592 "tracker-sparql-expression.c"
		} else {
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3600 "tracker-sparql-expression.c"
		}
	}
#line 391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3613 "tracker-sparql-expression.c"
		} else {
#line 391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3621 "tracker-sparql-expression.c"
		}
	}
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, _tmp0_, &_inner_error_);
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3636 "tracker-sparql-expression.c"
		} else {
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3644 "tracker-sparql-expression.c"
		}
	}
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3657 "tracker-sparql-expression.c"
		} else {
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3665 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp2_;
	TrackerSparqlLiteralBinding* _tmp3_;
	TrackerSparqlLiteralBinding* new_binding;
	TrackerSparqlLiteralBinding* _tmp4_;
	TrackerSparqlTokenType _tmp5_ = 0;
	TrackerSparqlQuery* _tmp17_;
	TrackerSparqlLiteralBinding* _tmp18_;
	TrackerSparqlLiteralBinding* _tmp19_;
	GError * _inner_error_ = NULL;
#line 398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error_);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3699 "tracker-sparql-expression.c"
		} else {
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3707 "tracker-sparql-expression.c"
		}
	}
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp1_) {
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error_);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3722 "tracker-sparql-expression.c"
			} else {
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3730 "tracker-sparql-expression.c"
			}
		}
	}
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3744 "tracker-sparql-expression.c"
		} else {
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3752 "tracker-sparql-expression.c"
		}
	}
#line 405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, "?");
#line 406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_literal_binding_new ();
#line 406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	new_binding = _tmp3_;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = new_binding;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	((TrackerSparqlDataBinding*) _tmp4_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = tracker_sparql_expression_current (self);
#line 409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 3771 "tracker-sparql-expression.c"
		TrackerSparqlLiteralBinding* _tmp6_;
		gchar* _tmp7_;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = new_binding;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = g_strdup ("1");
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp6_->literal);
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_->literal = _tmp7_;
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_next (self, &_inner_error_);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3794 "tracker-sparql-expression.c"
			} else {
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3804 "tracker-sparql-expression.c"
			}
		}
	} else {
		GString* _tmp8_;
		GString* _tmp9_;
		TrackerPropertyType _tmp10_ = 0;
		TrackerPropertyType _tmp11_;
		TrackerPropertyType _tmp12_;
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = g_string_new ("");
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = tracker_sparql_expression_translate_expression (self, _tmp9_, &_inner_error_);
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_;
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_string_free0 (_tmp9_);
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_;
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3835 "tracker-sparql-expression.c"
			} else {
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3845 "tracker-sparql-expression.c"
			}
		}
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 3850 "tracker-sparql-expression.c"
			TrackerSparqlLiteralBinding* _tmp13_;
			gchar* _tmp14_;
#line 413 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = new_binding;
#line 413 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = g_strdup ("1");
#line 413 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp13_->literal);
#line 413 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_->literal = _tmp14_;
#line 3861 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlLiteralBinding* _tmp15_;
			gchar* _tmp16_;
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = new_binding;
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = g_strdup ("0");
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp15_->literal);
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_->literal = _tmp16_;
#line 3873 "tracker-sparql-expression.c"
		}
	}
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp17_ = self->priv->query;
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp18_ = new_binding;
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp17_->bindings = g_list_append (_tmp17_->bindings, _tmp19_);
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3896 "tracker-sparql-expression.c"
		} else {
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3906 "tracker-sparql-expression.c"
		}
	}
#line 398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_object_unref0 (new_binding);
#line 3911 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error_);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3933 "tracker-sparql-expression.c"
		} else {
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3941 "tracker-sparql-expression.c"
		}
	}
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3954 "tracker-sparql-expression.c"
		} else {
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3962 "tracker-sparql-expression.c"
		}
	}
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3977 "tracker-sparql-expression.c"
		} else {
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3985 "tracker-sparql-expression.c"
		}
	}
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 3990 "tracker-sparql-expression.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* variable_name;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		const gchar* _tmp8_;
		TrackerSparqlVariable* _tmp9_ = NULL;
		TrackerSparqlVariable* _tmp10_;
		TrackerSparqlVariable* variable;
		TrackerSparqlVariable* _tmp11_;
		TrackerSparqlVariableBinding* _tmp12_;
		gboolean _tmp20_ = FALSE;
		TrackerSparqlVariable* _tmp21_;
		TrackerSparqlVariableBinding* _tmp22_;
		TrackerPropertyType _tmp23_;
		gboolean _tmp27_;
		GString* _tmp29_;
		TrackerSparqlLiteralBinding* _tmp30_;
		TrackerSparqlLiteralBinding* new_binding;
		TrackerSparqlLiteralBinding* _tmp31_;
		TrackerSparqlVariable* _tmp32_;
		TrackerSparqlVariableBinding* _tmp33_;
		TrackerClass* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		TrackerSparqlQuery* _tmp38_;
		TrackerSparqlLiteralBinding* _tmp39_;
		TrackerSparqlLiteralBinding* _tmp40_;
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 0);
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp2_;
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp3_);
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable_name = _tmp5_;
#line 429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_get_context (self);
#line 429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = variable_name;
#line 429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = tracker_sparql_context_get_variable (_tmp7_, _tmp8_);
#line 429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable = _tmp10_;
#line 431 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = variable;
#line 431 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_->binding;
#line 431 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == NULL) {
#line 4052 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			GError* _tmp18_ = NULL;
			GError* _tmp19_;
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = variable;
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = tracker_sparql_variable_get_name (_tmp13_);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = _tmp14_;
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = g_strdup_printf ("`%s' is not a valid variable", _tmp15_);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_get_error (self, _tmp17_);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp19_;
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 4088 "tracker-sparql-expression.c"
			} else {
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 4100 "tracker-sparql-expression.c"
			}
		}
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp21_ = variable;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp22_ = _tmp21_->binding;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp23_ = ((TrackerSparqlDataBinding*) _tmp22_)->data_type;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp23_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = TRUE;
#line 4113 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlVariable* _tmp24_;
			TrackerSparqlVariableBinding* _tmp25_;
			TrackerClass* _tmp26_;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = variable;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_->binding;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = _tmp25_->type;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp26_ == NULL;
#line 4126 "tracker-sparql-expression.c"
		}
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp27_ = _tmp20_;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp27_) {
#line 4132 "tracker-sparql-expression.c"
			GError* _tmp28_ = NULL;
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp28_;
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 4148 "tracker-sparql-expression.c"
			} else {
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 4160 "tracker-sparql-expression.c"
			}
		}
#line 439 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp29_ = sql;
#line 439 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp29_, "(SELECT ID FROM Resource WHERE Uri = ?)");
#line 441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp30_ = tracker_sparql_literal_binding_new ();
#line 441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		new_binding = _tmp30_;
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp31_ = new_binding;
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp32_ = variable;
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp33_ = _tmp32_->binding;
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp34_ = _tmp33_->type;
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp35_ = tracker_class_get_uri (_tmp34_);
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp36_ = _tmp35_;
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp31_->literal);
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp31_->literal = _tmp37_;
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_ = self->priv->query;
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp39_ = new_binding;
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp40_ = _g_object_ref0 (_tmp39_);
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_->bindings = g_list_append (_tmp38_->bindings, _tmp40_);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (new_binding);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (variable_name);
#line 4203 "tracker-sparql-expression.c"
	} else {
		GError* _tmp41_ = NULL;
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp41_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_inner_error_ = _tmp41_;
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4216 "tracker-sparql-expression.c"
		} else {
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4224 "tracker-sparql-expression.c"
		}
	}
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4237 "tracker-sparql-expression.c"
		} else {
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4245 "tracker-sparql-expression.c"
		}
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
#line 855 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 855 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 856 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 856 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 857 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = str;
#line 857 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 4268 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
#line 452 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 452 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 452 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 453 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = uri;
#line 453 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp0_, TRACKER_SPARQL_EXPRESSION_XSD_NS "string") == 0) {
#line 4286 "tracker-sparql-expression.c"
		GString* _tmp1_;
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_string (self, _tmp1_, &_inner_error_);
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 4300 "tracker-sparql-expression.c"
			} else {
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 4308 "tracker-sparql-expression.c"
			}
		}
#line 457 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_STRING;
#line 457 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 4315 "tracker-sparql-expression.c"
	} else {
		const gchar* _tmp2_;
#line 458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = uri;
#line 458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp2_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 4322 "tracker-sparql-expression.c"
			GString* _tmp3_;
			GString* _tmp4_;
			GString* _tmp5_;
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = sql;
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp3_, "CAST (");
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, _tmp4_, &_inner_error_);
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 4342 "tracker-sparql-expression.c"
				} else {
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 4350 "tracker-sparql-expression.c"
				}
			}
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = sql;
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp5_, " AS INTEGER)");
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 4361 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp6_;
#line 465 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = uri;
#line 465 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp6_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 4368 "tracker-sparql-expression.c"
				GString* _tmp7_;
				GString* _tmp8_;
				GString* _tmp9_;
#line 467 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp7_ = sql;
#line 467 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp7_, "CAST (");
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = sql;
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_translate_expression_as_string (self, _tmp8_, &_inner_error_);
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 4388 "tracker-sparql-expression.c"
					} else {
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 4396 "tracker-sparql-expression.c"
					}
				}
#line 469 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp9_ = sql;
#line 469 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp9_, " AS REAL)");
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 4407 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp10_;
#line 472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = uri;
#line 472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp10_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "case-fold") == 0) {
#line 4414 "tracker-sparql-expression.c"
					GString* _tmp11_;
					GString* _tmp12_;
					GString* _tmp13_;
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp11_ = sql;
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append (_tmp11_, "SparqlCaseFold (");
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp12_ = sql;
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_translate_expression_as_string (self, _tmp12_, &_inner_error_);
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 4434 "tracker-sparql-expression.c"
						} else {
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 4442 "tracker-sparql-expression.c"
						}
					}
#line 476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp13_ = sql;
#line 476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append (_tmp13_, ")");
#line 477 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 477 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 4453 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp14_;
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp14_ = uri;
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp14_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "ascii-lower-case") == 0) {
#line 4460 "tracker-sparql-expression.c"
						GString* _tmp15_;
						GString* _tmp16_;
						GString* _tmp17_;
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp15_ = sql;
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp15_, "lower (");
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp16_ = sql;
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						tracker_sparql_expression_translate_expression_as_string (self, _tmp16_, &_inner_error_);
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 4480 "tracker-sparql-expression.c"
							} else {
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 4488 "tracker-sparql-expression.c"
							}
						}
#line 482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp17_ = sql;
#line 482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp17_, ")");
#line 483 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						result = TRACKER_PROPERTY_TYPE_STRING;
#line 483 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return result;
#line 4499 "tracker-sparql-expression.c"
					} else {
						const gchar* _tmp18_;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp18_ = uri;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (g_strcmp0 (_tmp18_, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case") == 0) {
#line 4506 "tracker-sparql-expression.c"
							GString* _tmp19_;
							GString* _tmp20_;
							GString* _tmp21_;
#line 486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp19_ = sql;
#line 486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append (_tmp19_, "SparqlLowerCase (");
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp20_ = sql;
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							tracker_sparql_expression_translate_expression_as_string (self, _tmp20_, &_inner_error_);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 4526 "tracker-sparql-expression.c"
								} else {
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 4534 "tracker-sparql-expression.c"
								}
							}
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp21_ = sql;
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append (_tmp21_, ")");
#line 489 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							result = TRACKER_PROPERTY_TYPE_STRING;
#line 489 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return result;
#line 4545 "tracker-sparql-expression.c"
						} else {
							const gchar* _tmp22_;
#line 490 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp22_ = uri;
#line 490 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (g_strcmp0 (_tmp22_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "normalize") == 0) {
#line 4552 "tracker-sparql-expression.c"
								GString* _tmp23_;
								GString* _tmp24_;
								GString* _tmp25_;
								GString* _tmp26_;
								GString* _tmp27_;
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp23_ = sql;
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp23_, "SparqlNormalize (");
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp24_ = sql;
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_translate_expression_as_string (self, _tmp24_, &_inner_error_);
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4574 "tracker-sparql-expression.c"
									} else {
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4582 "tracker-sparql-expression.c"
									}
								}
#line 494 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp25_ = sql;
#line 494 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp25_, ", ");
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4599 "tracker-sparql-expression.c"
									} else {
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4607 "tracker-sparql-expression.c"
									}
								}
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp26_ = sql;
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_translate_expression_as_string (self, _tmp26_, &_inner_error_);
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4622 "tracker-sparql-expression.c"
									} else {
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4630 "tracker-sparql-expression.c"
									}
								}
#line 497 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp27_ = sql;
#line 497 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp27_, ")");
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								result = TRACKER_PROPERTY_TYPE_STRING;
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return result;
#line 4641 "tracker-sparql-expression.c"
							} else {
								const gchar* _tmp28_;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp28_ = uri;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (g_strcmp0 (_tmp28_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "unaccent") == 0) {
#line 4648 "tracker-sparql-expression.c"
									GString* _tmp29_;
									GString* _tmp30_;
									GString* _tmp31_;
#line 501 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp29_ = sql;
#line 501 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp29_, "SparqlUnaccent (");
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp30_ = sql;
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_translate_expression_as_string (self, _tmp30_, &_inner_error_);
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4668 "tracker-sparql-expression.c"
										} else {
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4676 "tracker-sparql-expression.c"
										}
									}
#line 503 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp31_ = sql;
#line 503 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp31_, ")");
#line 504 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									result = TRACKER_PROPERTY_TYPE_STRING;
#line 504 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return result;
#line 4687 "tracker-sparql-expression.c"
								} else {
									const gchar* _tmp32_;
#line 505 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp32_ = uri;
#line 505 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (g_strcmp0 (_tmp32_, TRACKER_SPARQL_EXPRESSION_FN_NS "contains") == 0) {
#line 4694 "tracker-sparql-expression.c"
										GString* _tmp33_;
										GString* _tmp34_;
										GString* _tmp35_;
										GString* _tmp36_;
										TrackerSparqlLiteralBinding* _tmp37_;
										TrackerSparqlLiteralBinding* binding;
										gchar* _tmp38_ = NULL;
										gchar* _tmp39_;
										TrackerSparqlLiteralBinding* _tmp40_;
										gchar* _tmp41_;
										gchar* _tmp42_ = NULL;
										TrackerSparqlQuery* _tmp43_;
										TrackerSparqlLiteralBinding* _tmp44_;
										TrackerSparqlLiteralBinding* _tmp45_;
										GString* _tmp46_;
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp33_ = sql;
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp33_, "(");
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp34_ = sql;
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										tracker_sparql_expression_translate_expression_as_string (self, _tmp34_, &_inner_error_);
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4726 "tracker-sparql-expression.c"
											} else {
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4734 "tracker-sparql-expression.c"
											}
										}
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp35_ = sql;
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp35_, " GLOB ");
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4751 "tracker-sparql-expression.c"
											} else {
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4759 "tracker-sparql-expression.c"
											}
										}
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp36_ = sql;
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp36_, "?");
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp37_ = tracker_sparql_literal_binding_new ();
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										binding = _tmp37_;
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp38_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp39_ = _tmp38_;
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4784 "tracker-sparql-expression.c"
											} else {
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4794 "tracker-sparql-expression.c"
											}
										}
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp40_ = binding;
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp41_ = _tmp39_;
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp42_ = g_strdup_printf ("*%s*", _tmp41_);
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_free0 (_tmp40_->literal);
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp40_->literal = _tmp42_;
#line 514 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_free0 (_tmp41_);
#line 515 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp43_ = self->priv->query;
#line 515 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp44_ = binding;
#line 515 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp45_ = _g_object_ref0 (_tmp44_);
#line 515 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp43_->bindings = g_list_append (_tmp43_->bindings, _tmp45_);
#line 517 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp46_ = sql;
#line 517 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp46_, ")");
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return result;
#line 4827 "tracker-sparql-expression.c"
									} else {
										const gchar* _tmp47_;
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp47_ = uri;
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (g_strcmp0 (_tmp47_, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with") == 0) {
#line 4834 "tracker-sparql-expression.c"
											GString* _tmp48_;
											GString* _tmp49_;
											gchar* _tmp50_ = NULL;
											gchar* prefix;
											GString* _tmp51_;
											TrackerSparqlLiteralBinding* _tmp52_;
											TrackerSparqlLiteralBinding* binding;
											TrackerSparqlLiteralBinding* _tmp53_;
											const gchar* _tmp54_;
											gchar* _tmp55_;
											TrackerSparqlQuery* _tmp56_;
											TrackerSparqlLiteralBinding* _tmp57_;
											TrackerSparqlLiteralBinding* _tmp58_;
											GString* _tmp59_;
											GString* _tmp60_;
											TrackerSparqlLiteralBinding* _tmp61_;
											TrackerSparqlLiteralBinding* _tmp62_;
											const gchar* _tmp63_;
											gchar* _tmp64_ = NULL;
											gchar* _tmp65_;
											gchar* _tmp66_;
											TrackerSparqlQuery* _tmp67_;
											TrackerSparqlLiteralBinding* _tmp68_;
											TrackerSparqlLiteralBinding* _tmp69_;
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp48_ = sql;
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_translate_expression_as_string (self, _tmp48_, &_inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4871 "tracker-sparql-expression.c"
												} else {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4879 "tracker-sparql-expression.c"
												}
											}
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp49_ = sql;
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp49_, " BETWEEN ");
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4896 "tracker-sparql-expression.c"
												} else {
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4904 "tracker-sparql-expression.c"
												}
											}
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp50_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											prefix = _tmp50_;
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4919 "tracker-sparql-expression.c"
												} else {
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4927 "tracker-sparql-expression.c"
												}
											}
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp51_ = sql;
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp51_, "?");
#line 531 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp52_ = tracker_sparql_literal_binding_new ();
#line 531 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											binding = _tmp52_;
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp53_ = binding;
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp54_ = prefix;
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp55_ = g_strdup (_tmp54_);
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_g_free0 (_tmp53_->literal);
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp53_->literal = _tmp55_;
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp56_ = self->priv->query;
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp57_ = binding;
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp58_ = _g_object_ref0 (_tmp57_);
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp56_->bindings = g_list_append (_tmp56_->bindings, _tmp58_);
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp59_ = sql;
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp59_, " AND ");
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp60_ = sql;
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp60_, "?");
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp61_ = tracker_sparql_literal_binding_new ();
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_g_object_unref0 (binding);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											binding = _tmp61_;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp62_ = binding;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp63_ = prefix;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp64_ = g_unichar_to_string (TRACKER_COLLATION_LAST_CHAR);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp65_ = _tmp64_;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp66_ = g_strconcat (_tmp63_, _tmp65_, NULL);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_g_free0 (_tmp62_->literal);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp62_->literal = _tmp66_;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_g_free0 (_tmp65_);
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp67_ = self->priv->query;
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp68_ = binding;
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp69_ = _g_object_ref0 (_tmp68_);
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp67_->bindings = g_list_append (_tmp67_->bindings, _tmp69_);
#line 542 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 542 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_g_object_unref0 (binding);
#line 542 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_g_free0 (prefix);
#line 542 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return result;
#line 5002 "tracker-sparql-expression.c"
										} else {
											const gchar* _tmp70_;
#line 543 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp70_ = uri;
#line 543 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (g_strcmp0 (_tmp70_, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with") == 0) {
#line 5009 "tracker-sparql-expression.c"
												GString* _tmp71_;
												GString* _tmp72_;
												GString* _tmp73_;
												GString* _tmp74_;
												TrackerSparqlLiteralBinding* _tmp75_;
												TrackerSparqlLiteralBinding* binding;
												gchar* _tmp76_ = NULL;
												gchar* _tmp77_;
												TrackerSparqlLiteralBinding* _tmp78_;
												gchar* _tmp79_;
												gchar* _tmp80_ = NULL;
												TrackerSparqlQuery* _tmp81_;
												TrackerSparqlLiteralBinding* _tmp82_;
												TrackerSparqlLiteralBinding* _tmp83_;
												GString* _tmp84_;
#line 545 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp71_ = sql;
#line 545 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp71_, "(");
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp72_ = sql;
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp72_, &_inner_error_);
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5041 "tracker-sparql-expression.c"
													} else {
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5049 "tracker-sparql-expression.c"
													}
												}
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp73_ = sql;
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp73_, " GLOB ");
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5066 "tracker-sparql-expression.c"
													} else {
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5074 "tracker-sparql-expression.c"
													}
												}
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp74_ = sql;
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp74_, "?");
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp75_ = tracker_sparql_literal_binding_new ();
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												binding = _tmp75_;
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp76_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp77_ = _tmp76_;
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_object_unref0 (binding);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5099 "tracker-sparql-expression.c"
													} else {
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_object_unref0 (binding);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5109 "tracker-sparql-expression.c"
													}
												}
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp78_ = binding;
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp79_ = _tmp77_;
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp80_ = g_strdup_printf ("*%s", _tmp79_);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_free0 (_tmp78_->literal);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp78_->literal = _tmp80_;
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_free0 (_tmp79_);
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp81_ = self->priv->query;
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp82_ = binding;
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp83_ = _g_object_ref0 (_tmp82_);
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp81_->bindings = g_list_append (_tmp81_->bindings, _tmp83_);
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp84_ = sql;
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp84_, ")");
#line 557 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 557 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 557 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return result;
#line 5142 "tracker-sparql-expression.c"
											} else {
												const gchar* _tmp85_;
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp85_ = uri;
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (g_strcmp0 (_tmp85_, TRACKER_SPARQL_EXPRESSION_FN_NS "substring") == 0) {
#line 5149 "tracker-sparql-expression.c"
													GString* _tmp86_;
													GString* _tmp87_;
													GString* _tmp88_;
													GString* _tmp89_;
													gboolean _tmp90_ = FALSE;
													gboolean _tmp91_;
													GString* _tmp94_;
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp86_ = sql;
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp86_, "substr(");
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp87_ = sql;
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp87_, &_inner_error_);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5173 "tracker-sparql-expression.c"
														} else {
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5181 "tracker-sparql-expression.c"
														}
													}
#line 562 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp88_ = sql;
#line 562 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp88_, ", ");
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5198 "tracker-sparql-expression.c"
														} else {
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5206 "tracker-sparql-expression.c"
														}
													}
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp89_ = sql;
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp89_, &_inner_error_);
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5221 "tracker-sparql-expression.c"
														} else {
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5229 "tracker-sparql-expression.c"
														}
													}
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp90_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp91_ = _tmp90_;
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5244 "tracker-sparql-expression.c"
														} else {
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5252 "tracker-sparql-expression.c"
														}
													}
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_tmp91_) {
#line 5257 "tracker-sparql-expression.c"
														GString* _tmp92_;
														GString* _tmp93_;
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp92_ = sql;
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp92_, ", ");
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp93_ = sql;
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_translate_expression_as_string (self, _tmp93_, &_inner_error_);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5276 "tracker-sparql-expression.c"
															} else {
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5284 "tracker-sparql-expression.c"
															}
														}
													}
#line 571 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp94_ = sql;
#line 571 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp94_, ")");
#line 573 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													result = TRACKER_PROPERTY_TYPE_STRING;
#line 573 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return result;
#line 5296 "tracker-sparql-expression.c"
												} else {
													const gchar* _tmp95_;
#line 574 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp95_ = uri;
#line 574 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (g_strcmp0 (_tmp95_, TRACKER_SPARQL_EXPRESSION_FN_NS "concat") == 0) {
#line 5303 "tracker-sparql-expression.c"
														GString* _tmp96_;
														GString* _tmp97_;
														GString* _tmp98_;
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp96_ = sql;
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_translate_expression_as_string (self, _tmp96_, &_inner_error_);
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5319 "tracker-sparql-expression.c"
															} else {
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5327 "tracker-sparql-expression.c"
															}
														}
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp97_ = sql;
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp97_, "||");
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5344 "tracker-sparql-expression.c"
															} else {
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5352 "tracker-sparql-expression.c"
															}
														}
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp98_ = sql;
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_translate_expression_as_string (self, _tmp98_, &_inner_error_);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5367 "tracker-sparql-expression.c"
															} else {
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5375 "tracker-sparql-expression.c"
															}
														}
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														while (TRUE) {
#line 5380 "tracker-sparql-expression.c"
															gboolean _tmp99_ = FALSE;
															gboolean _tmp100_;
															GString* _tmp101_;
															GString* _tmp102_;
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp99_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp100_ = _tmp99_;
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5397 "tracker-sparql-expression.c"
																} else {
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5405 "tracker-sparql-expression.c"
																}
															}
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (!_tmp100_) {
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																break;
#line 5412 "tracker-sparql-expression.c"
															}
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp101_ = sql;
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp101_, "||");
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp102_ = sql;
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_translate_expression_as_string (self, _tmp102_, &_inner_error_);
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5430 "tracker-sparql-expression.c"
																} else {
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5438 "tracker-sparql-expression.c"
																}
															}
														}
#line 584 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														result = TRACKER_PROPERTY_TYPE_STRING;
#line 584 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return result;
#line 5446 "tracker-sparql-expression.c"
													} else {
														const gchar* _tmp103_;
#line 585 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp103_ = uri;
#line 585 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (g_strcmp0 (_tmp103_, TRACKER_SPARQL_EXPRESSION_FN_NS "string-join") == 0) {
#line 5453 "tracker-sparql-expression.c"
															GString* _tmp104_;
															GString* _tmp105_;
															GString* _tmp106_;
															GString* _tmp107_;
															GString* _tmp112_;
															GString* _tmp113_;
															GString* _tmp114_;
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp104_ = sql;
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp104_, "SparqlStringJoin(");
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5475 "tracker-sparql-expression.c"
																} else {
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5483 "tracker-sparql-expression.c"
																}
															}
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp105_ = sql;
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_translate_expression_as_string (self, _tmp105_, &_inner_error_);
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5498 "tracker-sparql-expression.c"
																} else {
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5506 "tracker-sparql-expression.c"
																}
															}
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp106_ = sql;
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp106_, ", ");
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5523 "tracker-sparql-expression.c"
																} else {
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5531 "tracker-sparql-expression.c"
																}
															}
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp107_ = sql;
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_translate_expression_as_string (self, _tmp107_, &_inner_error_);
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5546 "tracker-sparql-expression.c"
																} else {
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5554 "tracker-sparql-expression.c"
																}
															}
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															while (TRUE) {
#line 5559 "tracker-sparql-expression.c"
																gboolean _tmp108_ = FALSE;
																gboolean _tmp109_;
																GString* _tmp110_;
																GString* _tmp111_;
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp108_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp109_ = _tmp108_;
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_ != NULL) {
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error_);
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5576 "tracker-sparql-expression.c"
																	} else {
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error_);
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5584 "tracker-sparql-expression.c"
																	}
																}
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (!_tmp109_) {
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	break;
#line 5591 "tracker-sparql-expression.c"
																}
#line 594 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp110_ = sql;
#line 594 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp110_, ", ");
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp111_ = sql;
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																tracker_sparql_expression_translate_expression_as_string (self, _tmp111_, &_inner_error_);
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_ != NULL) {
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error_);
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5609 "tracker-sparql-expression.c"
																	} else {
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error_);
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5617 "tracker-sparql-expression.c"
																	}
																}
															}
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5631 "tracker-sparql-expression.c"
																} else {
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5639 "tracker-sparql-expression.c"
																}
															}
#line 599 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp112_ = sql;
#line 599 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp112_, ",");
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5656 "tracker-sparql-expression.c"
																} else {
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5664 "tracker-sparql-expression.c"
																}
															}
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp113_ = sql;
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_translate_expression (self, _tmp113_, &_inner_error_);
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5679 "tracker-sparql-expression.c"
																} else {
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5687 "tracker-sparql-expression.c"
																}
															}
#line 602 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp114_ = sql;
#line 602 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp114_, ")");
#line 604 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															result = TRACKER_PROPERTY_TYPE_STRING;
#line 604 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return result;
#line 5698 "tracker-sparql-expression.c"
														} else {
															const gchar* _tmp115_;
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp115_ = uri;
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (g_strcmp0 (_tmp115_, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime") == 0) {
#line 5705 "tracker-sparql-expression.c"
																gchar* _tmp116_ = NULL;
																gchar* _tmp117_;
																gchar* _tmp118_ = NULL;
																gchar* _tmp119_;
																gchar* variable_name;
																TrackerSparqlContext* _tmp120_;
																TrackerSparqlContext* _tmp121_;
																const gchar* _tmp122_;
																TrackerSparqlVariable* _tmp123_ = NULL;
																TrackerSparqlVariable* _tmp124_;
																TrackerSparqlVariable* variable;
																GString* _tmp125_;
																GString* _tmp126_;
																TrackerSparqlVariable* _tmp127_;
																gchar* _tmp128_ = NULL;
																gchar* _tmp129_;
																GString* _tmp130_;
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_ != NULL) {
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error_);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5733 "tracker-sparql-expression.c"
																	} else {
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error_);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5741 "tracker-sparql-expression.c"
																	}
																}
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp116_ = tracker_sparql_expression_get_last_string (self, 0);
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp117_ = _tmp116_;
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp118_ = string_substring (_tmp117_, (glong) 1, (glong) (-1));
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp119_ = _tmp118_;
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (_tmp117_);
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																variable_name = _tmp119_;
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp120_ = tracker_sparql_expression_get_context (self);
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp121_ = _tmp120_;
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp122_ = variable_name;
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp123_ = tracker_sparql_context_get_variable (_tmp121_, _tmp122_);
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp124_ = _g_object_ref0 (_tmp123_);
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																variable = _tmp124_;
#line 610 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp125_ = sql;
#line 610 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp125_, "strftime (\"%Y\", ");
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp126_ = sql;
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp127_ = variable;
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp128_ = tracker_sparql_variable_get_extra_sql_expression (_tmp127_, "localDate");
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp129_ = _tmp128_;
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp126_, _tmp129_);
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (_tmp129_);
#line 612 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp130_ = sql;
#line 612 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp130_, " * 24 * 3600, \"unixepoch\")");
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_object_unref0 (variable);
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (variable_name);
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return result;
#line 5796 "tracker-sparql-expression.c"
															} else {
																const gchar* _tmp131_;
#line 615 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp131_ = uri;
#line 615 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (g_strcmp0 (_tmp131_, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime") == 0) {
#line 5803 "tracker-sparql-expression.c"
																	gchar* _tmp132_ = NULL;
																	gchar* _tmp133_;
																	gchar* _tmp134_ = NULL;
																	gchar* _tmp135_;
																	gchar* variable_name;
																	TrackerSparqlContext* _tmp136_;
																	TrackerSparqlContext* _tmp137_;
																	const gchar* _tmp138_;
																	TrackerSparqlVariable* _tmp139_ = NULL;
																	TrackerSparqlVariable* _tmp140_;
																	TrackerSparqlVariable* variable;
																	GString* _tmp141_;
																	GString* _tmp142_;
																	TrackerSparqlVariable* _tmp143_;
																	gchar* _tmp144_ = NULL;
																	gchar* _tmp145_;
																	GString* _tmp146_;
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_ != NULL) {
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error_);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return 0;
#line 5831 "tracker-sparql-expression.c"
																		} else {
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error_);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return 0;
#line 5839 "tracker-sparql-expression.c"
																		}
																	}
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp132_ = tracker_sparql_expression_get_last_string (self, 0);
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp133_ = _tmp132_;
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp134_ = string_substring (_tmp133_, (glong) 1, (glong) (-1));
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp135_ = _tmp134_;
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (_tmp133_);
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	variable_name = _tmp135_;
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp136_ = tracker_sparql_expression_get_context (self);
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp137_ = _tmp136_;
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp138_ = variable_name;
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp139_ = tracker_sparql_context_get_variable (_tmp137_, _tmp138_);
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp140_ = _g_object_ref0 (_tmp139_);
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	variable = _tmp140_;
#line 620 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp141_ = sql;
#line 620 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp141_, "strftime (\"%m\", ");
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp142_ = sql;
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp143_ = variable;
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp144_ = tracker_sparql_variable_get_extra_sql_expression (_tmp143_, "localDate");
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp145_ = _tmp144_;
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp142_, _tmp145_);
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (_tmp145_);
#line 622 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp146_ = sql;
#line 622 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp146_, " * 24 * 3600, \"unixepoch\")");
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_object_unref0 (variable);
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (variable_name);
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return result;
#line 5894 "tracker-sparql-expression.c"
																} else {
																	const gchar* _tmp147_;
#line 625 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp147_ = uri;
#line 625 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (g_strcmp0 (_tmp147_, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime") == 0) {
#line 5901 "tracker-sparql-expression.c"
																		gchar* _tmp148_ = NULL;
																		gchar* _tmp149_;
																		gchar* _tmp150_ = NULL;
																		gchar* _tmp151_;
																		gchar* variable_name;
																		TrackerSparqlContext* _tmp152_;
																		TrackerSparqlContext* _tmp153_;
																		const gchar* _tmp154_;
																		TrackerSparqlVariable* _tmp155_ = NULL;
																		TrackerSparqlVariable* _tmp156_;
																		TrackerSparqlVariable* variable;
																		GString* _tmp157_;
																		GString* _tmp158_;
																		TrackerSparqlVariable* _tmp159_;
																		gchar* _tmp160_ = NULL;
																		gchar* _tmp161_;
																		GString* _tmp162_;
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (_inner_error_ != NULL) {
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_propagate_error (error, _inner_error_);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return 0;
#line 5929 "tracker-sparql-expression.c"
																			} else {
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_clear_error (&_inner_error_);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return 0;
#line 5937 "tracker-sparql-expression.c"
																			}
																		}
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp148_ = tracker_sparql_expression_get_last_string (self, 0);
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp149_ = _tmp148_;
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp150_ = string_substring (_tmp149_, (glong) 1, (glong) (-1));
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp151_ = _tmp150_;
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (_tmp149_);
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		variable_name = _tmp151_;
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp152_ = tracker_sparql_expression_get_context (self);
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp153_ = _tmp152_;
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp154_ = variable_name;
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp155_ = tracker_sparql_context_get_variable (_tmp153_, _tmp154_);
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp156_ = _g_object_ref0 (_tmp155_);
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		variable = _tmp156_;
#line 630 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp157_ = sql;
#line 630 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp157_, "strftime (\"%d\", ");
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp158_ = sql;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp159_ = variable;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp160_ = tracker_sparql_variable_get_extra_sql_expression (_tmp159_, "localDate");
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp161_ = _tmp160_;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp158_, _tmp161_);
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (_tmp161_);
#line 632 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp162_ = sql;
#line 632 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp162_, " * 24 * 3600, \"unixepoch\")");
#line 634 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 634 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_object_unref0 (variable);
#line 634 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (variable_name);
#line 634 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return result;
#line 5992 "tracker-sparql-expression.c"
																	} else {
																		const gchar* _tmp163_;
#line 635 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp163_ = uri;
#line 635 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (g_strcmp0 (_tmp163_, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime") == 0) {
#line 5999 "tracker-sparql-expression.c"
																			gchar* _tmp164_ = NULL;
																			gchar* _tmp165_;
																			gchar* _tmp166_ = NULL;
																			gchar* _tmp167_;
																			gchar* variable_name;
																			TrackerSparqlContext* _tmp168_;
																			TrackerSparqlContext* _tmp169_;
																			const gchar* _tmp170_;
																			TrackerSparqlVariable* _tmp171_ = NULL;
																			TrackerSparqlVariable* _tmp172_;
																			TrackerSparqlVariable* variable;
																			GString* _tmp173_;
																			GString* _tmp174_;
																			TrackerSparqlVariable* _tmp175_;
																			gchar* _tmp176_ = NULL;
																			gchar* _tmp177_;
																			GString* _tmp178_;
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (_inner_error_ != NULL) {
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_propagate_error (error, _inner_error_);
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return 0;
#line 6027 "tracker-sparql-expression.c"
																				} else {
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_clear_error (&_inner_error_);
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return 0;
#line 6035 "tracker-sparql-expression.c"
																				}
																			}
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp164_ = tracker_sparql_expression_get_last_string (self, 0);
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp165_ = _tmp164_;
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp166_ = string_substring (_tmp165_, (glong) 1, (glong) (-1));
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp167_ = _tmp166_;
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (_tmp165_);
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			variable_name = _tmp167_;
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp168_ = tracker_sparql_expression_get_context (self);
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp169_ = _tmp168_;
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp170_ = variable_name;
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp171_ = tracker_sparql_context_get_variable (_tmp169_, _tmp170_);
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp172_ = _g_object_ref0 (_tmp171_);
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			variable = _tmp172_;
#line 640 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp173_ = sql;
#line 640 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp173_, "(");
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp174_ = sql;
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp175_ = variable;
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp176_ = tracker_sparql_variable_get_extra_sql_expression (_tmp175_, "localTime");
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp177_ = _tmp176_;
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp174_, _tmp177_);
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (_tmp177_);
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp178_ = sql;
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp178_, " / 3600)");
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_object_unref0 (variable);
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (variable_name);
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return result;
#line 6090 "tracker-sparql-expression.c"
																		} else {
																			const gchar* _tmp179_;
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp179_ = uri;
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (g_strcmp0 (_tmp179_, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime") == 0) {
#line 6097 "tracker-sparql-expression.c"
																				gchar* _tmp180_ = NULL;
																				gchar* _tmp181_;
																				gchar* _tmp182_ = NULL;
																				gchar* _tmp183_;
																				gchar* variable_name;
																				TrackerSparqlContext* _tmp184_;
																				TrackerSparqlContext* _tmp185_;
																				const gchar* _tmp186_;
																				TrackerSparqlVariable* _tmp187_ = NULL;
																				TrackerSparqlVariable* _tmp188_;
																				TrackerSparqlVariable* variable;
																				GString* _tmp189_;
																				GString* _tmp190_;
																				TrackerSparqlVariable* _tmp191_;
																				gchar* _tmp192_ = NULL;
																				gchar* _tmp193_;
																				GString* _tmp194_;
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (_inner_error_ != NULL) {
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_propagate_error (error, _inner_error_);
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return 0;
#line 6125 "tracker-sparql-expression.c"
																					} else {
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_clear_error (&_inner_error_);
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return 0;
#line 6133 "tracker-sparql-expression.c"
																					}
																				}
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp180_ = tracker_sparql_expression_get_last_string (self, 0);
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp181_ = _tmp180_;
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp182_ = string_substring (_tmp181_, (glong) 1, (glong) (-1));
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp183_ = _tmp182_;
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp181_);
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				variable_name = _tmp183_;
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp184_ = tracker_sparql_expression_get_context (self);
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp185_ = _tmp184_;
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp186_ = variable_name;
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp187_ = tracker_sparql_context_get_variable (_tmp185_, _tmp186_);
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp188_ = _g_object_ref0 (_tmp187_);
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				variable = _tmp188_;
#line 650 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp189_ = sql;
#line 650 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp189_, "(");
#line 651 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp190_ = sql;
#line 651 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp191_ = variable;
#line 651 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp192_ = tracker_sparql_variable_get_extra_sql_expression (_tmp191_, "localTime");
#line 651 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp193_ = _tmp192_;
#line 651 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp190_, _tmp193_);
#line 651 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp193_);
#line 652 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp194_ = sql;
#line 652 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp194_, " / 60 % 60)");
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_object_unref0 (variable);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (variable_name);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return result;
#line 6188 "tracker-sparql-expression.c"
																			} else {
																				const gchar* _tmp195_;
#line 655 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp195_ = uri;
#line 655 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (g_strcmp0 (_tmp195_, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime") == 0) {
#line 6195 "tracker-sparql-expression.c"
																					gchar* _tmp196_ = NULL;
																					gchar* _tmp197_;
																					gchar* _tmp198_ = NULL;
																					gchar* _tmp199_;
																					gchar* variable_name;
																					TrackerSparqlContext* _tmp200_;
																					TrackerSparqlContext* _tmp201_;
																					const gchar* _tmp202_;
																					TrackerSparqlVariable* _tmp203_ = NULL;
																					TrackerSparqlVariable* _tmp204_;
																					TrackerSparqlVariable* variable;
																					GString* _tmp205_;
																					GString* _tmp206_;
																					TrackerSparqlVariable* _tmp207_;
																					gchar* _tmp208_ = NULL;
																					gchar* _tmp209_;
																					GString* _tmp210_;
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (_inner_error_ != NULL) {
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_propagate_error (error, _inner_error_);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return 0;
#line 6223 "tracker-sparql-expression.c"
																						} else {
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_clear_error (&_inner_error_);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return 0;
#line 6231 "tracker-sparql-expression.c"
																						}
																					}
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp196_ = tracker_sparql_expression_get_last_string (self, 0);
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp197_ = _tmp196_;
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp198_ = string_substring (_tmp197_, (glong) 1, (glong) (-1));
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp199_ = _tmp198_;
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_g_free0 (_tmp197_);
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					variable_name = _tmp199_;
#line 658 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp200_ = tracker_sparql_expression_get_context (self);
#line 658 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp201_ = _tmp200_;
#line 658 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp202_ = variable_name;
#line 658 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp203_ = tracker_sparql_context_get_variable (_tmp201_, _tmp202_);
#line 658 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp204_ = _g_object_ref0 (_tmp203_);
#line 658 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					variable = _tmp204_;
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp205_ = sql;
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_string_append (_tmp205_, "(");
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp206_ = sql;
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp207_ = variable;
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp208_ = tracker_sparql_variable_get_extra_sql_expression (_tmp207_, "localTime");
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp209_ = _tmp208_;
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_string_append (_tmp206_, _tmp209_);
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_g_free0 (_tmp209_);
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp210_ = sql;
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_string_append (_tmp210_, "% 60)");
#line 664 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 664 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_g_object_unref0 (variable);
#line 664 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_g_free0 (variable_name);
#line 664 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return result;
#line 6286 "tracker-sparql-expression.c"
																				} else {
																					const gchar* _tmp211_;
#line 665 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp211_ = uri;
#line 665 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (g_strcmp0 (_tmp211_, TRACKER_SPARQL_EXPRESSION_FN_NS "timezone-from-dateTime") == 0) {
#line 6293 "tracker-sparql-expression.c"
																						gchar* _tmp212_ = NULL;
																						gchar* _tmp213_;
																						gchar* _tmp214_ = NULL;
																						gchar* _tmp215_;
																						gchar* variable_name;
																						TrackerSparqlContext* _tmp216_;
																						TrackerSparqlContext* _tmp217_;
																						const gchar* _tmp218_;
																						TrackerSparqlVariable* _tmp219_ = NULL;
																						TrackerSparqlVariable* _tmp220_;
																						TrackerSparqlVariable* variable;
																						GString* _tmp221_;
																						GString* _tmp222_;
																						TrackerSparqlVariable* _tmp223_;
																						gchar* _tmp224_ = NULL;
																						gchar* _tmp225_;
																						GString* _tmp226_;
																						GString* _tmp227_;
																						TrackerSparqlVariable* _tmp228_;
																						gchar* _tmp229_ = NULL;
																						gchar* _tmp230_;
																						GString* _tmp231_;
																						GString* _tmp232_;
																						GString* _tmp233_;
																						TrackerSparqlVariable* _tmp234_;
																						const gchar* _tmp235_;
																						const gchar* _tmp236_;
																						GString* _tmp237_;
																						GString* _tmp238_;
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (_inner_error_ != NULL) {
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_propagate_error (error, _inner_error_);
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return 0;
#line 6333 "tracker-sparql-expression.c"
																							} else {
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_clear_error (&_inner_error_);
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return 0;
#line 6341 "tracker-sparql-expression.c"
																							}
																						}
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp212_ = tracker_sparql_expression_get_last_string (self, 0);
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp213_ = _tmp212_;
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp214_ = string_substring (_tmp213_, (glong) 1, (glong) (-1));
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp215_ = _tmp214_;
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_free0 (_tmp213_);
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						variable_name = _tmp215_;
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp216_ = tracker_sparql_expression_get_context (self);
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp217_ = _tmp216_;
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp218_ = variable_name;
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp219_ = tracker_sparql_context_get_variable (_tmp217_, _tmp218_);
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp220_ = _g_object_ref0 (_tmp219_);
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						variable = _tmp220_;
#line 670 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp221_ = sql;
#line 670 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp221_, "(");
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp222_ = sql;
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp223_ = variable;
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp224_ = tracker_sparql_variable_get_extra_sql_expression (_tmp223_, "localDate");
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp225_ = _tmp224_;
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp222_, _tmp225_);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_free0 (_tmp225_);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp226_ = sql;
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp226_, " * 24 * 3600 + ");
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp227_ = sql;
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp228_ = variable;
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp229_ = tracker_sparql_variable_get_extra_sql_expression (_tmp228_, "localTime");
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp230_ = _tmp229_;
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp227_, _tmp230_);
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_free0 (_tmp230_);
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp231_ = sql;
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp231_, "- ");
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp232_ = sql;
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp232_, "CAST (");
#line 676 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp233_ = sql;
#line 676 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp234_ = variable;
#line 676 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp235_ = tracker_sparql_variable_get_sql_expression (_tmp234_);
#line 676 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp236_ = _tmp235_;
#line 676 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp233_, _tmp236_);
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp237_ = sql;
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp237_, " AS INTEGER)");
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp238_ = sql;
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp238_, ")");
#line 680 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 680 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_object_unref0 (variable);
#line 680 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_free0 (variable_name);
#line 680 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return result;
#line 6434 "tracker-sparql-expression.c"
																					} else {
																						const gchar* _tmp239_;
#line 681 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp239_ = uri;
#line 681 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (g_strcmp0 (_tmp239_, TRACKER_SPARQL_EXPRESSION_FTS_NS "rank") == 0) {
#line 6441 "tracker-sparql-expression.c"
																							gboolean is_var = FALSE;
																							TrackerSparqlPattern* _tmp240_;
																							TrackerSparqlPattern* _tmp241_;
																							gboolean _tmp242_ = FALSE;
																							gchar* _tmp243_ = NULL;
																							gchar* v;
																							GString* _tmp244_;
																							const gchar* _tmp245_;
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp240_ = tracker_sparql_expression_get_pattern (self);
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp241_ = _tmp240_;
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp243_ = tracker_sparql_pattern_parse_var_or_term (_tmp241_, NULL, &_tmp242_, &_inner_error_);
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							is_var = _tmp242_;
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							v = _tmp243_;
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_ != NULL) {
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6468 "tracker-sparql-expression.c"
																								} else {
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6476 "tracker-sparql-expression.c"
																								}
																							}
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp244_ = sql;
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp245_ = v;
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_string_append_printf (_tmp244_, "\"%s_u_rank\"", _tmp245_);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_g_free0 (v);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return result;
#line 6491 "tracker-sparql-expression.c"
																						} else {
																							const gchar* _tmp246_;
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp246_ = uri;
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (g_strcmp0 (_tmp246_, TRACKER_SPARQL_EXPRESSION_FTS_NS "offsets") == 0) {
#line 6498 "tracker-sparql-expression.c"
																								gboolean is_var = FALSE;
																								TrackerSparqlPattern* _tmp247_;
																								TrackerSparqlPattern* _tmp248_;
																								gboolean _tmp249_ = FALSE;
																								gchar* _tmp250_ = NULL;
																								gchar* v;
																								TrackerSparqlContext* _tmp251_;
																								TrackerSparqlContext* _tmp252_;
																								const gchar* _tmp253_;
																								TrackerSparqlVariable* _tmp254_ = NULL;
																								TrackerSparqlVariable* _tmp255_;
																								TrackerSparqlVariable* variable;
																								GString* _tmp256_;
																								TrackerSparqlVariable* _tmp257_;
																								const gchar* _tmp258_;
																								const gchar* _tmp259_;
																								gchar* _tmp260_;
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp247_ = tracker_sparql_expression_get_pattern (self);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp248_ = _tmp247_;
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp250_ = tracker_sparql_pattern_parse_var_or_term (_tmp248_, NULL, &_tmp249_, &_inner_error_);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								is_var = _tmp249_;
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								v = _tmp250_;
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6534 "tracker-sparql-expression.c"
																									} else {
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6542 "tracker-sparql-expression.c"
																									}
																								}
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp251_ = tracker_sparql_expression_get_context (self);
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp252_ = _tmp251_;
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp253_ = v;
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp254_ = tracker_sparql_context_get_variable (_tmp252_, _tmp253_);
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp255_ = _g_object_ref0 (_tmp254_);
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								variable = _tmp255_;
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp256_ = sql;
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp257_ = variable;
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp258_ = tracker_sparql_variable_get_sql_expression (_tmp257_);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp259_ = _tmp258_;
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_string_append (_tmp256_, _tmp259_);
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp260_ = g_strdup ("tracker_offsets(offsets(\"fts\"),fts_property_names())");
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_g_free0 (self->priv->fts_sql);
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								self->priv->fts_sql = _tmp260_;
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								result = TRACKER_PROPERTY_TYPE_STRING;
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_g_object_unref0 (variable);
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_g_free0 (v);
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return result;
#line 6581 "tracker-sparql-expression.c"
																							} else {
																								const gchar* _tmp261_;
#line 695 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp261_ = uri;
#line 695 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (g_strcmp0 (_tmp261_, TRACKER_SPARQL_EXPRESSION_FTS_NS "snippet") == 0) {
#line 6588 "tracker-sparql-expression.c"
																									gboolean is_var = FALSE;
																									TrackerSparqlPattern* _tmp262_;
																									TrackerSparqlPattern* _tmp263_;
																									gboolean _tmp264_ = FALSE;
																									gchar* _tmp265_ = NULL;
																									gchar* v;
																									TrackerSparqlContext* _tmp266_;
																									TrackerSparqlContext* _tmp267_;
																									const gchar* _tmp268_;
																									TrackerSparqlVariable* _tmp269_ = NULL;
																									TrackerSparqlVariable* _tmp270_;
																									TrackerSparqlVariable* variable;
																									GString* _tmp271_;
																									GString* fts;
																									GString* _tmp272_;
																									gboolean _tmp273_ = FALSE;
																									gboolean _tmp274_;
																									gboolean _tmp280_ = FALSE;
																									gboolean _tmp281_;
																									GString* _tmp285_;
																									gboolean _tmp286_ = FALSE;
																									gboolean _tmp287_;
																									GString* _tmp291_;
																									GString* _tmp292_;
																									const gchar* _tmp293_;
																									gchar* _tmp294_;
																									GString* _tmp295_;
																									TrackerSparqlVariable* _tmp296_;
																									const gchar* _tmp297_;
																									const gchar* _tmp298_;
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp262_ = tracker_sparql_expression_get_pattern (self);
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp263_ = _tmp262_;
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp265_ = tracker_sparql_pattern_parse_var_or_term (_tmp263_, NULL, &_tmp264_, &_inner_error_);
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									is_var = _tmp264_;
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									v = _tmp265_;
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6637 "tracker-sparql-expression.c"
																										} else {
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6645 "tracker-sparql-expression.c"
																										}
																									}
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp266_ = tracker_sparql_expression_get_context (self);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp267_ = _tmp266_;
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp268_ = v;
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp269_ = tracker_sparql_context_get_variable (_tmp267_, _tmp268_);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp270_ = _g_object_ref0 (_tmp269_);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									variable = _tmp270_;
#line 700 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp271_ = g_string_new ("");
#line 700 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									fts = _tmp271_;
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp272_ = fts;
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append_printf (_tmp272_, "snippet(\"fts\"");
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp273_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp274_ = _tmp273_;
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_string_free0 (fts);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_object_unref0 (variable);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_free0 (v);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6686 "tracker-sparql-expression.c"
																										} else {
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_string_free0 (fts);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_object_unref0 (variable);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_free0 (v);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6700 "tracker-sparql-expression.c"
																										}
																									}
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_tmp274_) {
#line 6705 "tracker-sparql-expression.c"
																										GString* _tmp275_;
																										GString* _tmp276_;
																										GString* _tmp277_;
																										GString* _tmp278_;
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp275_ = fts;
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp275_, ", ");
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp276_ = fts;
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression_as_string (self, _tmp276_, &_inner_error_);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6732 "tracker-sparql-expression.c"
																											} else {
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6746 "tracker-sparql-expression.c"
																											}
																										}
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6765 "tracker-sparql-expression.c"
																											} else {
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6779 "tracker-sparql-expression.c"
																											}
																										}
#line 711 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp277_ = fts;
#line 711 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp277_, ", ");
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp278_ = fts;
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression_as_string (self, _tmp278_, &_inner_error_);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6804 "tracker-sparql-expression.c"
																											} else {
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6818 "tracker-sparql-expression.c"
																											}
																										}
																									} else {
																										GString* _tmp279_;
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp279_ = fts;
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp279_, ",'',''");
#line 6827 "tracker-sparql-expression.c"
																									}
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp280_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp281_ = _tmp280_;
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_string_free0 (fts);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_object_unref0 (variable);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_free0 (v);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6847 "tracker-sparql-expression.c"
																										} else {
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_string_free0 (fts);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_object_unref0 (variable);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_free0 (v);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6861 "tracker-sparql-expression.c"
																										}
																									}
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_tmp281_) {
#line 6866 "tracker-sparql-expression.c"
																										GString* _tmp282_;
																										GString* _tmp283_;
#line 719 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp282_ = fts;
#line 719 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp282_, ", ");
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp283_ = fts;
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression_as_string (self, _tmp283_, &_inner_error_);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6891 "tracker-sparql-expression.c"
																											} else {
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6905 "tracker-sparql-expression.c"
																											}
																										}
																									} else {
																										GString* _tmp284_;
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp284_ = fts;
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp284_, ", '...'");
#line 6914 "tracker-sparql-expression.c"
																									}
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp285_ = fts;
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp285_, ", -1");
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp286_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp287_ = _tmp286_;
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_string_free0 (fts);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_object_unref0 (variable);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_free0 (v);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6938 "tracker-sparql-expression.c"
																										} else {
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_string_free0 (fts);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_object_unref0 (variable);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_g_free0 (v);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6952 "tracker-sparql-expression.c"
																										}
																									}
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_tmp287_) {
#line 6957 "tracker-sparql-expression.c"
																										GString* _tmp288_;
																										GString* _tmp289_;
#line 730 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp288_ = fts;
#line 730 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp288_, ", ");
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp289_ = fts;
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression_as_string (self, _tmp289_, &_inner_error_);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6982 "tracker-sparql-expression.c"
																											} else {
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6996 "tracker-sparql-expression.c"
																											}
																										}
																									} else {
																										GString* _tmp290_;
#line 733 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp290_ = fts;
#line 733 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp290_, ", 5");
#line 7005 "tracker-sparql-expression.c"
																									}
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp291_ = fts;
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp291_, ")");
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp292_ = fts;
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp293_ = _tmp292_->str;
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp294_ = g_strdup (_tmp293_);
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_free0 (self->priv->fts_sql);
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									self->priv->fts_sql = _tmp294_;
#line 739 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp295_ = sql;
#line 739 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp296_ = variable;
#line 739 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp297_ = tracker_sparql_variable_get_sql_expression (_tmp296_);
#line 739 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp298_ = _tmp297_;
#line 739 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp295_, _tmp298_);
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									result = TRACKER_PROPERTY_TYPE_STRING;
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_string_free0 (fts);
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_object_unref0 (variable);
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_free0 (v);
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return result;
#line 7041 "tracker-sparql-expression.c"
																								} else {
																									const gchar* _tmp299_;
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp299_ = uri;
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (g_strcmp0 (_tmp299_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "id") == 0) {
#line 7048 "tracker-sparql-expression.c"
																										GString* _tmp300_;
																										TrackerPropertyType _tmp301_ = 0;
																										TrackerPropertyType type;
																										TrackerPropertyType _tmp302_;
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp300_ = sql;
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp301_ = tracker_sparql_expression_translate_expression (self, _tmp300_, &_inner_error_);
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										type = _tmp301_;
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7067 "tracker-sparql-expression.c"
																											} else {
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7075 "tracker-sparql-expression.c"
																											}
																										}
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp302_ = type;
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_tmp302_ != TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 7082 "tracker-sparql-expression.c"
																											GError* _tmp303_ = NULL;
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp303_ = tracker_sparql_expression_get_error (self, "expected resource");
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_inner_error_ = _tmp303_;
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7094 "tracker-sparql-expression.c"
																											} else {
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7102 "tracker-sparql-expression.c"
																											}
																										}
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return result;
#line 7109 "tracker-sparql-expression.c"
																									} else {
																										const gchar* _tmp304_;
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp304_ = uri;
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (g_strcmp0 (_tmp304_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri") == 0) {
#line 7116 "tracker-sparql-expression.c"
																											GString* _tmp305_;
																											TrackerPropertyType _tmp306_ = 0;
																											TrackerPropertyType type;
																											TrackerPropertyType _tmp307_;
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp305_ = sql;
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp306_ = tracker_sparql_expression_translate_expression (self, _tmp305_, &_inner_error_);
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											type = _tmp306_;
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7135 "tracker-sparql-expression.c"
																												} else {
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7143 "tracker-sparql-expression.c"
																												}
																											}
#line 750 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp307_ = type;
#line 750 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_tmp307_ != TRACKER_PROPERTY_TYPE_INTEGER) {
#line 7150 "tracker-sparql-expression.c"
																												GError* _tmp308_ = NULL;
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp308_ = tracker_sparql_expression_get_error (self, "expected integer ID");
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_inner_error_ = _tmp308_;
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7162 "tracker-sparql-expression.c"
																												} else {
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7170 "tracker-sparql-expression.c"
																												}
																											}
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return result;
#line 7177 "tracker-sparql-expression.c"
																										} else {
																											const gchar* _tmp309_;
#line 755 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp309_ = uri;
#line 755 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (g_strcmp0 (_tmp309_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "cartesian-distance") == 0) {
#line 7184 "tracker-sparql-expression.c"
																												GString* _tmp310_;
																												GString* _tmp311_;
																												GString* _tmp312_;
																												GString* _tmp313_;
																												GString* _tmp314_;
																												GString* _tmp315_;
																												GString* _tmp316_;
																												GString* _tmp317_;
																												GString* _tmp318_;
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp310_ = sql;
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp310_, "SparqlCartesianDistance(");
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp311_ = sql;
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression (self, _tmp311_, &_inner_error_);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7210 "tracker-sparql-expression.c"
																													} else {
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7218 "tracker-sparql-expression.c"
																													}
																												}
#line 758 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp312_ = sql;
#line 758 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp312_, ", ");
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7235 "tracker-sparql-expression.c"
																													} else {
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7243 "tracker-sparql-expression.c"
																													}
																												}
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp313_ = sql;
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression (self, _tmp313_, &_inner_error_);
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7258 "tracker-sparql-expression.c"
																													} else {
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7266 "tracker-sparql-expression.c"
																													}
																												}
#line 761 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp314_ = sql;
#line 761 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp314_, ", ");
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7283 "tracker-sparql-expression.c"
																													} else {
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7291 "tracker-sparql-expression.c"
																													}
																												}
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp315_ = sql;
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression (self, _tmp315_, &_inner_error_);
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7306 "tracker-sparql-expression.c"
																													} else {
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7314 "tracker-sparql-expression.c"
																													}
																												}
#line 764 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp316_ = sql;
#line 764 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp316_, ", ");
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7331 "tracker-sparql-expression.c"
																													} else {
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7339 "tracker-sparql-expression.c"
																													}
																												}
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp317_ = sql;
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression (self, _tmp317_, &_inner_error_);
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7354 "tracker-sparql-expression.c"
																													} else {
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7362 "tracker-sparql-expression.c"
																													}
																												}
#line 767 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp318_ = sql;
#line 767 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp318_, ")");
#line 769 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 769 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return result;
#line 7373 "tracker-sparql-expression.c"
																											} else {
																												const gchar* _tmp319_;
#line 770 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp319_ = uri;
#line 770 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (g_strcmp0 (_tmp319_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "haversine-distance") == 0) {
#line 7380 "tracker-sparql-expression.c"
																													GString* _tmp320_;
																													GString* _tmp321_;
																													GString* _tmp322_;
																													GString* _tmp323_;
																													GString* _tmp324_;
																													GString* _tmp325_;
																													GString* _tmp326_;
																													GString* _tmp327_;
																													GString* _tmp328_;
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp320_ = sql;
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp320_, "SparqlHaversineDistance(");
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp321_ = sql;
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression (self, _tmp321_, &_inner_error_);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7406 "tracker-sparql-expression.c"
																														} else {
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7414 "tracker-sparql-expression.c"
																														}
																													}
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp322_ = sql;
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp322_, ", ");
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7431 "tracker-sparql-expression.c"
																														} else {
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7439 "tracker-sparql-expression.c"
																														}
																													}
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp323_ = sql;
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression (self, _tmp323_, &_inner_error_);
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7454 "tracker-sparql-expression.c"
																														} else {
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7462 "tracker-sparql-expression.c"
																														}
																													}
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp324_ = sql;
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp324_, ", ");
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7479 "tracker-sparql-expression.c"
																														} else {
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7487 "tracker-sparql-expression.c"
																														}
																													}
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp325_ = sql;
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression (self, _tmp325_, &_inner_error_);
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7502 "tracker-sparql-expression.c"
																														} else {
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 778 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7510 "tracker-sparql-expression.c"
																														}
																													}
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp326_ = sql;
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp326_, ", ");
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7527 "tracker-sparql-expression.c"
																														} else {
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7535 "tracker-sparql-expression.c"
																														}
																													}
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp327_ = sql;
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression (self, _tmp327_, &_inner_error_);
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7550 "tracker-sparql-expression.c"
																														} else {
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 781 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7558 "tracker-sparql-expression.c"
																														}
																													}
#line 782 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp328_ = sql;
#line 782 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp328_, ")");
#line 784 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 784 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return result;
#line 7569 "tracker-sparql-expression.c"
																												} else {
																													const gchar* _tmp329_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp329_ = uri;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (g_strcmp0 (_tmp329_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce") == 0) {
#line 7576 "tracker-sparql-expression.c"
																														GString* _tmp330_;
																														GString* _tmp331_;
																														GString* _tmp332_;
																														GString* _tmp333_;
																														GString* _tmp338_;
#line 786 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp330_ = sql;
#line 786 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp330_, "COALESCE(");
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp331_ = sql;
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression_as_string (self, _tmp331_, &_inner_error_);
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7598 "tracker-sparql-expression.c"
																															} else {
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7606 "tracker-sparql-expression.c"
																															}
																														}
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp332_ = sql;
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp332_, ", ");
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7623 "tracker-sparql-expression.c"
																															} else {
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7631 "tracker-sparql-expression.c"
																															}
																														}
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp333_ = sql;
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression_as_string (self, _tmp333_, &_inner_error_);
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7646 "tracker-sparql-expression.c"
																															} else {
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7654 "tracker-sparql-expression.c"
																															}
																														}
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														while (TRUE) {
#line 7659 "tracker-sparql-expression.c"
																															gboolean _tmp334_ = FALSE;
																															gboolean _tmp335_;
																															GString* _tmp336_;
																															GString* _tmp337_;
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp334_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp335_ = _tmp334_;
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7676 "tracker-sparql-expression.c"
																																} else {
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7684 "tracker-sparql-expression.c"
																																}
																															}
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (!_tmp335_) {
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																break;
#line 7691 "tracker-sparql-expression.c"
																															}
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp336_ = sql;
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp336_, ", ");
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp337_ = sql;
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression_as_string (self, _tmp337_, &_inner_error_);
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7709 "tracker-sparql-expression.c"
																																} else {
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7717 "tracker-sparql-expression.c"
																																}
																															}
																														}
#line 795 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp338_ = sql;
#line 795 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp338_, ")");
#line 797 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														result = TRACKER_PROPERTY_TYPE_STRING;
#line 797 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return result;
#line 7729 "tracker-sparql-expression.c"
																													} else {
																														const gchar* _tmp339_;
#line 798 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp339_ = uri;
#line 798 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (g_strcmp0 (_tmp339_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-parent") == 0) {
#line 7736 "tracker-sparql-expression.c"
																															GString* _tmp340_;
																															GString* _tmp341_;
																															GString* _tmp342_;
																															GString* _tmp343_;
																															GString* _tmp344_;
#line 799 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp340_ = sql;
#line 799 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp340_, "SparqlUriIsParent(");
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp341_ = sql;
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression_as_string (self, _tmp341_, &_inner_error_);
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7758 "tracker-sparql-expression.c"
																																} else {
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7766 "tracker-sparql-expression.c"
																																}
																															}
#line 801 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp342_ = sql;
#line 801 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp342_, ", ");
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7783 "tracker-sparql-expression.c"
																																} else {
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7791 "tracker-sparql-expression.c"
																																}
																															}
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp343_ = sql;
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression_as_string (self, _tmp343_, &_inner_error_);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7806 "tracker-sparql-expression.c"
																																} else {
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7814 "tracker-sparql-expression.c"
																																}
																															}
#line 805 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp344_ = sql;
#line 805 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp344_, ")");
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return result;
#line 7825 "tracker-sparql-expression.c"
																														} else {
																															const gchar* _tmp345_;
#line 808 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp345_ = uri;
#line 808 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (g_strcmp0 (_tmp345_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-descendant") == 0) {
#line 7832 "tracker-sparql-expression.c"
																																GString* _tmp346_;
																																GString* _tmp347_;
																																GString* _tmp348_;
																																GString* _tmp349_;
																																GString* _tmp354_;
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp346_ = sql;
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append (_tmp346_, "SparqlUriIsDescendant(");
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp347_ = sql;
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																tracker_sparql_expression_translate_expression_as_string (self, _tmp347_, &_inner_error_);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_ != NULL) {
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error_);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7854 "tracker-sparql-expression.c"
																																	} else {
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error_);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7862 "tracker-sparql-expression.c"
																																	}
																																}
#line 811 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp348_ = sql;
#line 811 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append (_tmp348_, ", ");
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_ != NULL) {
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error_);
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7879 "tracker-sparql-expression.c"
																																	} else {
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error_);
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7887 "tracker-sparql-expression.c"
																																	}
																																}
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp349_ = sql;
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																tracker_sparql_expression_translate_expression_as_string (self, _tmp349_, &_inner_error_);
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_ != NULL) {
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error_);
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7902 "tracker-sparql-expression.c"
																																	} else {
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error_);
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7910 "tracker-sparql-expression.c"
																																	}
																																}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																while (TRUE) {
#line 7915 "tracker-sparql-expression.c"
																																	gboolean _tmp350_ = FALSE;
																																	gboolean _tmp351_;
																																	GString* _tmp352_;
																																	GString* _tmp353_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp350_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp351_ = _tmp350_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_ != NULL) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error_);
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 7932 "tracker-sparql-expression.c"
																																		} else {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error_);
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 7940 "tracker-sparql-expression.c"
																																		}
																																	}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (!_tmp351_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		break;
#line 7947 "tracker-sparql-expression.c"
																																	}
#line 816 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp352_ = sql;
#line 816 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append (_tmp352_, ", ");
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp353_ = sql;
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	tracker_sparql_expression_translate_expression_as_string (self, _tmp353_, &_inner_error_);
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_ != NULL) {
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error_);
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 7965 "tracker-sparql-expression.c"
																																		} else {
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error_);
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 7973 "tracker-sparql-expression.c"
																																		}
																																	}
																																}
#line 819 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp354_ = sql;
#line 819 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append (_tmp354_, ")");
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return result;
#line 7985 "tracker-sparql-expression.c"
																															} else {
																																const gchar* _tmp355_;
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp355_ = uri;
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (g_strcmp0 (_tmp355_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "string-from-filename") == 0) {
#line 7992 "tracker-sparql-expression.c"
																																	GString* _tmp356_;
																																	GString* _tmp357_;
																																	GString* _tmp358_;
#line 823 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp356_ = sql;
#line 823 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append (_tmp356_, "SparqlStringFromFilename(");
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp357_ = sql;
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	tracker_sparql_expression_translate_expression_as_string (self, _tmp357_, &_inner_error_);
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_ != NULL) {
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error_);
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8012 "tracker-sparql-expression.c"
																																		} else {
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error_);
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8020 "tracker-sparql-expression.c"
																																		}
																																	}
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp358_ = sql;
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append (_tmp358_, ")");
#line 827 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	result = TRACKER_PROPERTY_TYPE_STRING;
#line 827 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return result;
#line 8031 "tracker-sparql-expression.c"
																																} else {
																																	const gchar* _tmp359_;
																																	TrackerProperty* _tmp360_ = NULL;
																																	TrackerProperty* _tmp361_;
																																	TrackerProperty* prop;
																																	TrackerProperty* _tmp362_;
																																	GString* _tmp364_;
																																	GString* expr;
																																	GString* _tmp365_;
																																	gchar* _tmp366_;
																																	gchar* value_separator;
																																	gchar* graph_separator;
																																	gboolean _tmp367_ = FALSE;
																																	gboolean _tmp368_;
																																	TrackerProperty* _tmp375_;
																																	gboolean _tmp376_;
																																	gboolean _tmp377_;
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp359_ = uri;
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp360_ = tracker_ontologies_get_property_by_uri (_tmp359_);
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp361_ = _g_object_ref0 (_tmp360_);
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	prop = _tmp361_;
#line 831 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp362_ = prop;
#line 831 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_tmp362_ == NULL) {
#line 8061 "tracker-sparql-expression.c"
																																		GError* _tmp363_ = NULL;
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp363_ = tracker_sparql_expression_get_error (self, "Unknown function");
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_inner_error_ = _tmp363_;
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error_);
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8075 "tracker-sparql-expression.c"
																																		} else {
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error_);
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8085 "tracker-sparql-expression.c"
																																		}
																																	}
#line 835 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp364_ = g_string_new ("");
#line 835 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	expr = _tmp364_;
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp365_ = expr;
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	tracker_sparql_expression_translate_expression (self, _tmp365_, &_inner_error_);
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_ != NULL) {
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error_);
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_string_free0 (expr);
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8108 "tracker-sparql-expression.c"
																																		} else {
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_string_free0 (expr);
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error_);
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8120 "tracker-sparql-expression.c"
																																		}
																																	}
#line 838 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp366_ = g_strdup (",");
#line 838 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	value_separator = _tmp366_;
#line 839 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	graph_separator = NULL;
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp367_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp368_ = _tmp367_;
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_ != NULL) {
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error_);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (graph_separator);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (value_separator);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_string_free0 (expr);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8149 "tracker-sparql-expression.c"
																																		} else {
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (graph_separator);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (value_separator);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_string_free0 (expr);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error_);
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8165 "tracker-sparql-expression.c"
																																		}
																																	}
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_tmp368_) {
#line 8170 "tracker-sparql-expression.c"
																																		gchar* _tmp369_ = NULL;
																																		gchar* _tmp370_;
																																		gboolean _tmp371_ = FALSE;
																																		gboolean _tmp372_;
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp369_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp370_ = _tmp369_;
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_ != NULL) {
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				g_propagate_error (error, _inner_error_);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_free0 (graph_separator);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_free0 (value_separator);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_string_free0 (expr);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_object_unref0 (prop);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				return 0;
#line 8195 "tracker-sparql-expression.c"
																																			} else {
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_free0 (graph_separator);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_free0 (value_separator);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_string_free0 (expr);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_object_unref0 (prop);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				g_clear_error (&_inner_error_);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				return 0;
#line 8211 "tracker-sparql-expression.c"
																																			}
																																		}
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		value_separator = _tmp370_;
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp371_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp372_ = _tmp371_;
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_ != NULL) {
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				g_propagate_error (error, _inner_error_);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_free0 (graph_separator);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_free0 (value_separator);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_string_free0 (expr);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_object_unref0 (prop);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				return 0;
#line 8238 "tracker-sparql-expression.c"
																																			} else {
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_free0 (graph_separator);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_free0 (value_separator);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_string_free0 (expr);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_g_object_unref0 (prop);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				g_clear_error (&_inner_error_);
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				return 0;
#line 8254 "tracker-sparql-expression.c"
																																			}
																																		}
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_tmp372_) {
#line 8259 "tracker-sparql-expression.c"
																																			gchar* _tmp373_ = NULL;
																																			gchar* _tmp374_;
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp373_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp374_ = _tmp373_;
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			if (_inner_error_ != NULL) {
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					g_propagate_error (error, _inner_error_);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					_g_free0 (graph_separator);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					_g_free0 (value_separator);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					_g_string_free0 (expr);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					_g_object_unref0 (prop);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					return 0;
#line 8282 "tracker-sparql-expression.c"
																																				} else {
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					_g_free0 (graph_separator);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					_g_free0 (value_separator);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					_g_string_free0 (expr);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					_g_object_unref0 (prop);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					g_clear_error (&_inner_error_);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																					return 0;
#line 8298 "tracker-sparql-expression.c"
																																				}
																																			}
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (graph_separator);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			graph_separator = _tmp374_;
#line 8305 "tracker-sparql-expression.c"
																																		}
																																	}
#line 849 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp375_ = prop;
#line 849 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp376_ = tracker_property_get_multiple_values (_tmp375_);
#line 849 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp377_ = _tmp376_;
#line 849 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_tmp377_) {
#line 8316 "tracker-sparql-expression.c"
																																		GString* _tmp378_;
																																		GString* _tmp379_;
																																		gssize _tmp380_;
																																		glong begin;
																																		GString* _tmp381_;
																																		TrackerProperty* _tmp382_;
																																		const gchar* _tmp383_;
																																		const gchar* _tmp384_;
																																		GString* _tmp385_;
																																		TrackerProperty* _tmp386_;
																																		TrackerPropertyType _tmp387_;
																																		TrackerPropertyType _tmp388_;
																																		glong _tmp389_;
																																		const gchar* _tmp390_;
																																		GString* _tmp398_;
																																		const gchar* _tmp399_;
																																		gchar* _tmp400_ = NULL;
																																		gchar* _tmp401_;
																																		GString* _tmp402_;
																																		TrackerProperty* _tmp403_;
																																		const gchar* _tmp404_;
																																		const gchar* _tmp405_;
																																		GString* _tmp406_;
																																		const gchar* _tmp407_;
#line 851 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp378_ = sql;
#line 851 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_string_append (_tmp378_, "(SELECT GROUP_CONCAT(");
#line 852 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp379_ = sql;
#line 852 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp380_ = _tmp379_->len;
#line 852 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		begin = (glong) _tmp380_;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp381_ = sql;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp382_ = prop;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp383_ = tracker_property_get_name (_tmp382_);
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp384_ = _tmp383_;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_string_append_printf (_tmp381_, "\"%s\"", _tmp384_);
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp385_ = sql;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp386_ = prop;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp387_ = tracker_property_get_data_type (_tmp386_);
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp388_ = _tmp387_;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp389_ = begin;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		tracker_sparql_expression_convert_expression_to_string (_tmp385_, _tmp388_, _tmp389_);
#line 855 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp390_ = graph_separator;
#line 855 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_tmp390_ != NULL) {
#line 8377 "tracker-sparql-expression.c"
																																			GString* _tmp391_;
																																			const gchar* _tmp392_;
																																			gchar* _tmp393_ = NULL;
																																			gchar* _tmp394_;
																																			TrackerProperty* _tmp395_;
																																			const gchar* _tmp396_;
																																			const gchar* _tmp397_;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp391_ = sql;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp392_ = graph_separator;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp393_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp392_);
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp394_ = _tmp393_;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp395_ = prop;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp396_ = tracker_property_get_name (_tmp395_);
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp397_ = _tmp396_;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_string_append_printf (_tmp391_, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp394_, _tmp397_);
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (_tmp394_);
#line 8403 "tracker-sparql-expression.c"
																																		}
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp398_ = sql;
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp399_ = value_separator;
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp400_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp399_);
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp401_ = _tmp400_;
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_string_append_printf (_tmp398_, ",%s)", _tmp401_);
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (_tmp401_);
#line 859 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp402_ = sql;
#line 859 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp403_ = prop;
#line 859 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp404_ = tracker_property_get_table_name (_tmp403_);
#line 859 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp405_ = _tmp404_;
#line 859 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp406_ = expr;
#line 859 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp407_ = _tmp406_->str;
#line 859 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_string_append_printf (_tmp402_, " FROM \"%s\" WHERE ID = %s)", _tmp405_, _tmp407_);
#line 861 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		result = TRACKER_PROPERTY_TYPE_STRING;
#line 861 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 861 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 861 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 861 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 861 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return result;
#line 8443 "tracker-sparql-expression.c"
																																	} else {
																																		const gchar* _tmp408_;
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp408_ = graph_separator;
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_tmp408_ == NULL) {
#line 8450 "tracker-sparql-expression.c"
																																			GString* _tmp409_;
																																			TrackerProperty* _tmp410_;
																																			const gchar* _tmp411_;
																																			const gchar* _tmp412_;
																																			TrackerProperty* _tmp413_;
																																			const gchar* _tmp414_;
																																			const gchar* _tmp415_;
																																			GString* _tmp416_;
																																			const gchar* _tmp417_;
																																			TrackerProperty* _tmp418_;
																																			TrackerPropertyType _tmp419_;
																																			TrackerPropertyType _tmp420_;
																																			TrackerProperty* _tmp422_;
																																			TrackerPropertyType _tmp423_;
																																			TrackerPropertyType _tmp424_;
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp409_ = sql;
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp410_ = prop;
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp411_ = tracker_property_get_name (_tmp410_);
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp412_ = _tmp411_;
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp413_ = prop;
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp414_ = tracker_property_get_table_name (_tmp413_);
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp415_ = _tmp414_;
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp416_ = expr;
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp417_ = _tmp416_->str;
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_string_append_printf (_tmp409_, "(SELECT \"%s\" FROM \"%s\" WHERE ID = %s)", _tmp412_, _tmp415_, _tmp417_);
#line 867 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp418_ = prop;
#line 867 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp419_ = tracker_property_get_data_type (_tmp418_);
#line 867 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp420_ = _tmp419_;
#line 867 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			if (_tmp420_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 8494 "tracker-sparql-expression.c"
																																				GString* _tmp421_;
#line 868 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				_tmp421_ = sql;
#line 868 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																				tracker_sparql_expression_append_collate (self, _tmp421_);
#line 8500 "tracker-sparql-expression.c"
																																			}
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp422_ = prop;
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp423_ = tracker_property_get_data_type (_tmp422_);
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp424_ = _tmp423_;
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			result = _tmp424_;
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (graph_separator);
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (value_separator);
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_string_free0 (expr);
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 871 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return result;
#line 8520 "tracker-sparql-expression.c"
																																		} else {
																																			GString* _tmp425_;
																																			GString* _tmp426_;
																																			gssize _tmp427_;
																																			glong begin;
																																			GString* _tmp428_;
																																			TrackerProperty* _tmp429_;
																																			const gchar* _tmp430_;
																																			const gchar* _tmp431_;
																																			GString* _tmp432_;
																																			TrackerProperty* _tmp433_;
																																			TrackerPropertyType _tmp434_;
																																			TrackerPropertyType _tmp435_;
																																			glong _tmp436_;
																																			GString* _tmp437_;
																																			const gchar* _tmp438_;
																																			gchar* _tmp439_ = NULL;
																																			gchar* _tmp440_;
																																			TrackerProperty* _tmp441_;
																																			const gchar* _tmp442_;
																																			const gchar* _tmp443_;
																																			GString* _tmp444_;
																																			TrackerProperty* _tmp445_;
																																			const gchar* _tmp446_;
																																			const gchar* _tmp447_;
																																			GString* _tmp448_;
																																			const gchar* _tmp449_;
#line 873 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp425_ = sql;
#line 873 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_string_append (_tmp425_, "(SELECT ");
#line 874 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp426_ = sql;
#line 874 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp427_ = _tmp426_->len;
#line 874 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			begin = (glong) _tmp427_;
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp428_ = sql;
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp429_ = prop;
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp430_ = tracker_property_get_name (_tmp429_);
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp431_ = _tmp430_;
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_string_append_printf (_tmp428_, "\"%s\"", _tmp431_);
#line 876 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp432_ = sql;
#line 876 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp433_ = prop;
#line 876 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp434_ = tracker_property_get_data_type (_tmp433_);
#line 876 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp435_ = _tmp434_;
#line 876 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp436_ = begin;
#line 876 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			tracker_sparql_expression_convert_expression_to_string (_tmp432_, _tmp435_, _tmp436_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp437_ = sql;
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp438_ = graph_separator;
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp439_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp438_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp440_ = _tmp439_;
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp441_ = prop;
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp442_ = tracker_property_get_name (_tmp441_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp443_ = _tmp442_;
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_string_append_printf (_tmp437_, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp440_, _tmp443_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (_tmp440_);
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp444_ = sql;
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp445_ = prop;
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp446_ = tracker_property_get_table_name (_tmp445_);
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp447_ = _tmp446_;
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp448_ = expr;
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_tmp449_ = _tmp448_->str;
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_string_append_printf (_tmp444_, " FROM \"%s\" WHERE ID = %s)", _tmp447_, _tmp449_);
#line 880 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			result = TRACKER_PROPERTY_TYPE_STRING;
#line 880 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (graph_separator);
#line 880 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (value_separator);
#line 880 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_string_free0 (expr);
#line 880 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 880 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return result;
#line 8624 "tracker-sparql-expression.c"
																																		}
																																	}
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 8635 "tracker-sparql-expression.c"
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error) {
	TrackerPropertyType result = 0;
	gchar* type_iri = NULL;
	TrackerPropertyType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
#line 886 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 8695 "tracker-sparql-expression.c"
		} else {
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 8705 "tracker-sparql-expression.c"
		}
	}
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 8710 "tracker-sparql-expression.c"
		gchar* _tmp2_ = NULL;
#line 891 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 891 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (type_iri);
#line 891 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type_iri = _tmp2_;
#line 8718 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8736 "tracker-sparql-expression.c"
			} else {
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8746 "tracker-sparql-expression.c"
			}
		}
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp4_) {
#line 8751 "tracker-sparql-expression.c"
			gchar* _tmp5_ = NULL;
			gchar* ns;
			TrackerSparqlQuery* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 893 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 0);
#line 893 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			ns = _tmp5_;
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8781 "tracker-sparql-expression.c"
				} else {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8793 "tracker-sparql-expression.c"
				}
			}
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = self->priv->query;
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = ns;
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = _tmp10_;
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = tracker_sparql_query_resolve_prefixed_name (_tmp6_, _tmp7_, _tmp11_, &_inner_error_);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = _tmp12_;
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp11_);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp9_);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8830 "tracker-sparql-expression.c"
				} else {
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8842 "tracker-sparql-expression.c"
				}
			}
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 895 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type_iri = _tmp14_;
#line 892 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 8851 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlQuery* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8873 "tracker-sparql-expression.c"
				} else {
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8883 "tracker-sparql-expression.c"
				}
			}
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = self->priv->query;
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_last_string (self, 0);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = string_substring (_tmp17_, (glong) 1, (glong) (-1));
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = tracker_sparql_query_resolve_prefixed_name (_tmp15_, "", _tmp19_, &_inner_error_);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = _tmp20_;
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp19_);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8916 "tracker-sparql-expression.c"
				} else {
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8926 "tracker-sparql-expression.c"
				}
			}
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type_iri = _tmp22_;
#line 8933 "tracker-sparql-expression.c"
		}
	}
#line 901 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp23_ = type_iri;
#line 901 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp23_, TRACKER_SPARQL_EXPRESSION_XSD_NS "boolean") == 0) {
#line 902 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 8942 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_;
		gboolean _tmp38_;
		gboolean _tmp40_;
		gboolean _tmp42_;
		gboolean _tmp44_;
		gboolean _tmp46_;
		gboolean _tmp48_;
		gboolean _tmp50_;
		gboolean _tmp52_;
		gboolean _tmp54_;
		gboolean _tmp56_;
		gboolean _tmp58_;
		gboolean _tmp60_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp36_ = type_iri;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp36_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = TRUE;
#line 8975 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp37_;
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = type_iri;
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = g_strcmp0 (_tmp37_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonPositiveInteger") == 0;
#line 8982 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_ = _tmp35_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp38_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = TRUE;
#line 8990 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp39_;
#line 905 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp39_ = type_iri;
#line 905 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = g_strcmp0 (_tmp39_, TRACKER_SPARQL_EXPRESSION_XSD_NS "negativeInteger") == 0;
#line 8997 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp40_ = _tmp34_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp40_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = TRUE;
#line 9005 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp41_;
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp41_ = type_iri;
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = g_strcmp0 (_tmp41_, TRACKER_SPARQL_EXPRESSION_XSD_NS "long") == 0;
#line 9012 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp42_ = _tmp33_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp42_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = TRUE;
#line 9020 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp43_;
#line 907 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp43_ = type_iri;
#line 907 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = g_strcmp0 (_tmp43_, TRACKER_SPARQL_EXPRESSION_XSD_NS "int") == 0;
#line 9027 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp44_ = _tmp32_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp44_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = TRUE;
#line 9035 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp45_;
#line 908 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp45_ = type_iri;
#line 908 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = g_strcmp0 (_tmp45_, TRACKER_SPARQL_EXPRESSION_XSD_NS "short") == 0;
#line 9042 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp46_ = _tmp31_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp46_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp30_ = TRUE;
#line 9050 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp47_;
#line 909 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp47_ = type_iri;
#line 909 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp30_ = g_strcmp0 (_tmp47_, TRACKER_SPARQL_EXPRESSION_XSD_NS "byte") == 0;
#line 9057 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp48_ = _tmp30_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp48_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = TRUE;
#line 9065 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp49_;
#line 910 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp49_ = type_iri;
#line 910 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = g_strcmp0 (_tmp49_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonNegativeInteger") == 0;
#line 9072 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp50_ = _tmp29_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp50_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = TRUE;
#line 9080 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp51_;
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = type_iri;
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = g_strcmp0 (_tmp51_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedLong") == 0;
#line 9087 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp52_ = _tmp28_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp52_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = TRUE;
#line 9095 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp53_;
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp53_ = type_iri;
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = g_strcmp0 (_tmp53_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedInt") == 0;
#line 9102 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp54_ = _tmp27_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp54_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = TRUE;
#line 9110 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp55_;
#line 913 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = type_iri;
#line 913 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = g_strcmp0 (_tmp55_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedShort") == 0;
#line 9117 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp56_ = _tmp26_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp56_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = TRUE;
#line 9125 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp57_;
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = type_iri;
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = g_strcmp0 (_tmp57_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedByte") == 0;
#line 9132 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp58_ = _tmp25_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp58_) {
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = TRUE;
#line 9140 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp59_;
#line 915 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = type_iri;
#line 915 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = g_strcmp0 (_tmp59_, TRACKER_SPARQL_EXPRESSION_XSD_NS "positiveInteger") == 0;
#line 9147 "tracker-sparql-expression.c"
		}
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp60_ = _tmp24_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp60_) {
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 9155 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp61_;
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp61_ = type_iri;
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp61_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 9164 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp62_;
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp62_ = type_iri;
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp62_, TRACKER_SPARQL_EXPRESSION_XSD_NS "date") == 0) {
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					type = TRACKER_PROPERTY_TYPE_DATE;
#line 9173 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp63_;
#line 921 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp63_ = type_iri;
#line 921 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp63_, TRACKER_SPARQL_EXPRESSION_XSD_NS "dateTime") == 0) {
#line 922 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 9182 "tracker-sparql-expression.c"
					} else {
#line 924 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_STRING;
#line 9186 "tracker-sparql-expression.c"
					}
				}
			}
		}
	}
#line 927 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 927 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (type_iri);
#line 927 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 9198 "tracker-sparql-expression.c"
}


gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error) {
	TrackerPropertyType _vala_type = 0;
	gchar* result = NULL;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 930 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 931 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_vala_type = TRACKER_PROPERTY_TYPE_STRING;
#line 933 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_next (self, &_inner_error_);
#line 933 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 933 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 933 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 933 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return NULL;
#line 9221 "tracker-sparql-expression.c"
		} else {
#line 933 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 933 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 933 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return NULL;
#line 9229 "tracker-sparql-expression.c"
		}
	}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_last (self);
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 9240 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			GString* sb;
			gchar* _tmp2_ = NULL;
			gchar* s;
			const gchar* _tmp3_;
			const gchar* p;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			const gchar* end;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_;
			GString* _tmp54_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
#line 937 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = g_string_new ("");
#line 937 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			sb = _tmp1_;
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			s = _tmp2_;
#line 940 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = s;
#line 940 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			p = _tmp3_;
#line 941 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = p;
#line 941 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = s;
#line 941 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = strlen (_tmp5_);
#line 941 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = _tmp6_;
#line 941 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			end = _tmp4_ + _tmp7_;
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			while (TRUE) {
#line 9282 "tracker-sparql-expression.c"
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_ = NULL;
				const gchar* q;
				const gchar* _tmp12_;
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = p;
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp9_ = end;
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!(((glong) _tmp8_) < ((glong) _tmp9_))) {
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					break;
#line 9297 "tracker-sparql-expression.c"
				}
#line 943 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = p;
#line 943 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = strchr (_tmp10_, (gint) '\\');
#line 943 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				q = _tmp11_;
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp12_ = q;
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp12_ == NULL) {
#line 9309 "tracker-sparql-expression.c"
					GString* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp13_ = sb;
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp14_ = p;
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp15_ = end;
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp16_ = p;
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append_len (_tmp13_, _tmp14_, (gssize) ((glong) (_tmp15_ - _tmp16_)));
#line 946 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp17_ = end;
#line 946 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp17_;
#line 9329 "tracker-sparql-expression.c"
				} else {
					GString* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar _tmp24_;
					const gchar* _tmp49_;
#line 948 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp18_ = sb;
#line 948 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp19_ = p;
#line 948 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp20_ = q;
#line 948 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp21_ = p;
#line 948 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append_len (_tmp18_, _tmp19_, (gssize) ((glong) (_tmp20_ - _tmp21_)));
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = q;
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp22_ + 1;
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp23_ = p;
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp24_ = ((gchar*) _tmp23_)[0];
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					switch (_tmp24_) {
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '\'':
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '"':
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '\\':
#line 9365 "tracker-sparql-expression.c"
						{
							GString* _tmp25_;
							const gchar* _tmp26_;
							gchar _tmp27_;
#line 954 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp25_ = sb;
#line 954 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp26_ = p;
#line 954 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp27_ = ((gchar*) _tmp26_)[0];
#line 954 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp25_, _tmp27_);
#line 955 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9380 "tracker-sparql-expression.c"
						}
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'b':
#line 9384 "tracker-sparql-expression.c"
						{
							GString* _tmp28_;
#line 957 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp28_ = sb;
#line 957 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp28_, '\b');
#line 958 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9393 "tracker-sparql-expression.c"
						}
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'f':
#line 9397 "tracker-sparql-expression.c"
						{
							GString* _tmp29_;
#line 960 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp29_ = sb;
#line 960 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp29_, '\f');
#line 961 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9406 "tracker-sparql-expression.c"
						}
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'n':
#line 9410 "tracker-sparql-expression.c"
						{
							GString* _tmp30_;
#line 963 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp30_ = sb;
#line 963 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp30_, '\n');
#line 964 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9419 "tracker-sparql-expression.c"
						}
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'r':
#line 9423 "tracker-sparql-expression.c"
						{
							GString* _tmp31_;
#line 966 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp31_ = sb;
#line 966 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp31_, '\r');
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9432 "tracker-sparql-expression.c"
						}
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 't':
#line 9436 "tracker-sparql-expression.c"
						{
							GString* _tmp32_;
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp32_ = sb;
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp32_, '\t');
#line 970 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9445 "tracker-sparql-expression.c"
						}
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'u':
#line 9449 "tracker-sparql-expression.c"
						{
							const gchar* _tmp33_;
							gchar* ptr;
							gchar* _tmp34_;
							gchar _tmp35_;
							gint _tmp36_ = 0;
							gchar* _tmp37_;
							gchar _tmp38_;
							gint _tmp39_ = 0;
							gchar* _tmp40_;
							gchar _tmp41_;
							gint _tmp42_ = 0;
							gchar* _tmp43_;
							gchar _tmp44_;
							gint _tmp45_ = 0;
							gunichar c;
							GString* _tmp46_;
							gunichar _tmp47_;
							const gchar* _tmp48_;
#line 972 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp33_ = p;
#line 972 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							ptr = ((gchar*) _tmp33_) + 1;
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp34_ = ptr;
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp35_ = _tmp34_[0];
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp36_ = g_ascii_xdigit_value (_tmp35_);
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp37_ = ptr;
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp38_ = _tmp37_[1];
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp39_ = g_ascii_xdigit_value (_tmp38_);
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp40_ = ptr;
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp41_ = _tmp40_[2];
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp42_ = g_ascii_xdigit_value (_tmp41_);
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp43_ = ptr;
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp44_ = _tmp43_[3];
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp45_ = g_ascii_xdigit_value (_tmp44_);
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							c = (((((((gunichar) _tmp36_) * 16) + _tmp39_) * 16) + _tmp42_) * 16) + _tmp45_;
#line 974 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp46_ = sb;
#line 974 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp47_ = c;
#line 974 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_unichar (_tmp46_, _tmp47_);
#line 975 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp48_ = p;
#line 975 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							p = _tmp48_ + 4;
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9511 "tracker-sparql-expression.c"
						}
						default:
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						break;
#line 9516 "tracker-sparql-expression.c"
					}
#line 978 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp49_ = p;
#line 978 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp49_ + 1;
#line 9522 "tracker-sparql-expression.c"
				}
			}
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp50_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = _tmp50_;
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (s);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 9541 "tracker-sparql-expression.c"
				} else {
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (s);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 9553 "tracker-sparql-expression.c"
				}
			}
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp51_) {
#line 9558 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp52_ = 0;
				TrackerPropertyType _tmp53_;
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp52_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp53_ = _tmp52_;
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (s);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 9577 "tracker-sparql-expression.c"
					} else {
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (s);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 9589 "tracker-sparql-expression.c"
					}
				}
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_vala_type = _tmp53_;
#line 9594 "tracker-sparql-expression.c"
			}
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp54_ = sb;
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = _tmp54_->str;
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_ = g_strdup (_tmp55_);
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp56_;
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (s);
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_string_free0 (sb);
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (type) {
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				*type = _vala_type;
#line 9612 "tracker-sparql-expression.c"
			}
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9616 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 9622 "tracker-sparql-expression.c"
		{
			gchar* _tmp57_ = NULL;
			gchar* _result_;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_;
#line 990 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = tracker_sparql_expression_get_last_string (self, 3);
#line 990 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_result_ = _tmp57_;
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp58_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = _tmp58_;
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 9646 "tracker-sparql-expression.c"
				} else {
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 9656 "tracker-sparql-expression.c"
				}
			}
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp59_) {
#line 9661 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp60_ = 0;
				TrackerPropertyType _tmp61_;
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp60_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp61_ = _tmp60_;
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 9678 "tracker-sparql-expression.c"
					} else {
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 9688 "tracker-sparql-expression.c"
					}
				}
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_vala_type = _tmp61_;
#line 9693 "tracker-sparql-expression.c"
			}
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _result_;
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (type) {
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				*type = _vala_type;
#line 9701 "tracker-sparql-expression.c"
			}
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9705 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp62_ = NULL;
#line 999 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_expression_get_error (self, "expected string literal");
#line 999 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp62_;
#line 999 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 999 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 999 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return NULL;
#line 9720 "tracker-sparql-expression.c"
			} else {
#line 999 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 999 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 999 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return NULL;
#line 9728 "tracker-sparql-expression.c"
			}
		}
	}
#line 930 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (type) {
#line 930 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*type = _vala_type;
#line 9736 "tracker-sparql-expression.c"
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 9764 "tracker-sparql-expression.c"
		} else {
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 9772 "tracker-sparql-expression.c"
		}
	}
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 9777 "tracker-sparql-expression.c"
		GString* _tmp2_;
		const gchar* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType _result_;
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = uri;
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_function (self, _tmp2_, _tmp3_, &_inner_error_);
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_result_ = _tmp4_;
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 9798 "tracker-sparql-expression.c"
			} else {
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 9806 "tracker-sparql-expression.c"
			}
		}
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 9819 "tracker-sparql-expression.c"
			} else {
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 9827 "tracker-sparql-expression.c"
			}
		}
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _result_;
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 9834 "tracker-sparql-expression.c"
	} else {
		GString* _tmp5_;
		TrackerSparqlLiteralBinding* _tmp6_;
		TrackerSparqlLiteralBinding* binding;
		TrackerSparqlLiteralBinding* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		TrackerSparqlQuery* _tmp10_;
		TrackerSparqlLiteralBinding* _tmp11_;
		TrackerSparqlLiteralBinding* _tmp12_;
#line 1011 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 1011 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp5_, "COALESCE((SELECT ID FROM Resource WHERE Uri = ?), 0)");
#line 1012 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_literal_binding_new ();
#line 1012 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		binding = _tmp6_;
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = binding;
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = uri;
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp7_->literal);
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_->literal = _tmp9_;
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = self->priv->query;
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = binding;
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_->bindings = g_list_append (_tmp10_->bindings, _tmp12_);
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (binding);
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 9877 "tracker-sparql-expression.c"
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType type = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 1019 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1019 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 9897 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			TrackerPropertyType _tmp2_ = 0;
			TrackerPropertyType _tmp3_;
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_translate_bracketted_expression (self, _tmp1_, &_inner_error_);
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9916 "tracker-sparql-expression.c"
				} else {
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9924 "tracker-sparql-expression.c"
				}
			}
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp3_;
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9931 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 9935 "tracker-sparql-expression.c"
		{
			GString* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			TrackerPropertyType _tmp7_ = 0;
			TrackerPropertyType _tmp8_;
			TrackerPropertyType _tmp9_;
#line 1026 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1026 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1026 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1026 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1026 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9953 "tracker-sparql-expression.c"
				} else {
#line 1026 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1026 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1026 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9961 "tracker-sparql-expression.c"
				}
			}
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 1);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_translate_uri_expression (self, _tmp4_, _tmp6_, &_inner_error_);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp6_);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9986 "tracker-sparql-expression.c"
				} else {
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9994 "tracker-sparql-expression.c"
				}
			}
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp9_;
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10001 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 10007 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10022 "tracker-sparql-expression.c"
				} else {
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10030 "tracker-sparql-expression.c"
				}
			}
#line 1032 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = self->priv->query;
#line 1032 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_query_get_no_cache (_tmp10_);
#line 1032 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 1032 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp12_) {
#line 10041 "tracker-sparql-expression.c"
				GString* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
#line 1033 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = sql;
#line 1033 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1033 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_;
#line 1033 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp13_, _tmp15_);
#line 1033 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp15_);
#line 10055 "tracker-sparql-expression.c"
			} else {
				GString* _tmp16_;
				TrackerSparqlLiteralBinding* _tmp17_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp18_;
				gchar* _tmp19_ = NULL;
				TrackerSparqlQuery* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp16_, "?");
#line 1037 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = tracker_sparql_literal_binding_new ();
#line 1037 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp17_;
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = binding;
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp19_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp18_->literal);
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_->literal = _tmp19_;
#line 1039 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = self->priv->query;
#line 1039 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = binding;
#line 1039 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 1039 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_->bindings = g_list_append (_tmp20_->bindings, _tmp22_);
#line 1032 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 10091 "tracker-sparql-expression.c"
			}
#line 1042 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 1042 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10097 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 10101 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10116 "tracker-sparql-expression.c"
				} else {
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10124 "tracker-sparql-expression.c"
				}
			}
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = self->priv->query;
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = tracker_sparql_query_get_no_cache (_tmp23_);
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_;
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp25_) {
#line 10135 "tracker-sparql-expression.c"
				GString* _tmp26_;
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp26_, "1");
#line 10141 "tracker-sparql-expression.c"
			} else {
				GString* _tmp27_;
				TrackerSparqlLiteralBinding* _tmp28_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp29_;
				gchar* _tmp30_;
				TrackerSparqlLiteralBinding* _tmp31_;
				TrackerSparqlQuery* _tmp32_;
				TrackerSparqlLiteralBinding* _tmp33_;
				TrackerSparqlLiteralBinding* _tmp34_;
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = sql;
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp27_, "?");
#line 1051 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = tracker_sparql_literal_binding_new ();
#line 1051 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp28_;
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = binding;
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = g_strdup ("1");
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp29_->literal);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_->literal = _tmp30_;
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = binding;
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp31_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1054 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = self->priv->query;
#line 1054 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp33_ = binding;
#line 1054 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp34_ = _g_object_ref0 (_tmp33_);
#line 1054 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_->bindings = g_list_append (_tmp32_->bindings, _tmp34_);
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 10182 "tracker-sparql-expression.c"
			}
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10188 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 10192 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10207 "tracker-sparql-expression.c"
				} else {
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10215 "tracker-sparql-expression.c"
				}
			}
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = self->priv->query;
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp36_ = tracker_sparql_query_get_no_cache (_tmp35_);
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = _tmp36_;
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp37_) {
#line 10226 "tracker-sparql-expression.c"
				GString* _tmp38_;
#line 1062 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = sql;
#line 1062 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp38_, "0");
#line 10232 "tracker-sparql-expression.c"
			} else {
				GString* _tmp39_;
				TrackerSparqlLiteralBinding* _tmp40_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp41_;
				gchar* _tmp42_;
				TrackerSparqlLiteralBinding* _tmp43_;
				TrackerSparqlQuery* _tmp44_;
				TrackerSparqlLiteralBinding* _tmp45_;
				TrackerSparqlLiteralBinding* _tmp46_;
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp39_ = sql;
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp39_, "?");
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp40_ = tracker_sparql_literal_binding_new ();
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp40_;
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp41_ = binding;
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp42_ = g_strdup ("0");
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp41_->literal);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp41_->literal = _tmp42_;
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp43_ = binding;
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp43_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp44_ = self->priv->query;
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp45_ = binding;
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp46_ = _g_object_ref0 (_tmp45_);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp44_->bindings = g_list_append (_tmp44_->bindings, _tmp46_);
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 10273 "tracker-sparql-expression.c"
			}
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10279 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 10289 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp47_ = 0;
			gchar* _tmp48_ = NULL;
			gchar* literal;
			TrackerPropertyType _tmp49_;
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp48_ = tracker_sparql_expression_parse_string_literal (self, &_tmp47_, &_inner_error_);
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp47_;
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			literal = _tmp48_;
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10309 "tracker-sparql-expression.c"
				} else {
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10317 "tracker-sparql-expression.c"
				}
			}
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp49_ = type;
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			switch (_tmp49_) {
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_INTEGER:
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DOUBLE:
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATE:
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATETIME:
#line 10334 "tracker-sparql-expression.c"
				{
					TrackerSparqlQuery* _tmp50_;
					gboolean _tmp51_;
					gboolean _tmp52_;
#line 1085 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp50_ = self->priv->query;
#line 1085 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp51_ = tracker_sparql_query_get_no_cache (_tmp50_);
#line 1085 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp52_ = _tmp51_;
#line 1085 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp52_) {
#line 10347 "tracker-sparql-expression.c"
						GString* _tmp53_;
						const gchar* _tmp54_;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_;
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp53_ = sql;
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp54_ = literal;
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp55_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp54_);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp56_ = _tmp55_;
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp53_, _tmp56_);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp56_);
#line 10364 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp57_;
						TrackerSparqlLiteralBinding* binding;
						TrackerSparqlLiteralBinding* _tmp58_;
						const gchar* _tmp59_;
						gchar* _tmp60_;
						TrackerSparqlLiteralBinding* _tmp61_;
						TrackerPropertyType _tmp62_;
						TrackerSparqlQuery* _tmp63_;
						TrackerSparqlLiteralBinding* _tmp64_;
						TrackerSparqlLiteralBinding* _tmp65_;
						GString* _tmp66_;
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp57_ = tracker_sparql_literal_binding_new ();
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						binding = _tmp57_;
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp58_ = binding;
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp59_ = literal;
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp60_ = g_strdup (_tmp59_);
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp58_->literal);
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp58_->literal = _tmp60_;
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp61_ = binding;
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp62_ = type;
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						((TrackerSparqlDataBinding*) _tmp61_)->data_type = _tmp62_;
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp63_ = self->priv->query;
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp64_ = binding;
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp65_ = _g_object_ref0 (_tmp64_);
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp63_->bindings = g_list_append (_tmp63_->bindings, _tmp65_);
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp66_ = sql;
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp66_, "?");
#line 1085 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 10411 "tracker-sparql-expression.c"
					}
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = type;
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 10419 "tracker-sparql-expression.c"
				}
				default:
				{
					TrackerSparqlQuery* _tmp67_;
					gboolean _tmp68_;
					gboolean _tmp69_;
					GString* _tmp82_;
#line 1096 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp67_ = self->priv->query;
#line 1096 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp68_ = tracker_sparql_query_get_no_cache (_tmp67_);
#line 1096 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp69_ = _tmp68_;
#line 1096 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp69_) {
#line 10435 "tracker-sparql-expression.c"
						GString* _tmp70_;
						const gchar* _tmp71_;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_;
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp70_ = sql;
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp71_ = literal;
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp72_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp71_);
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp73_ = _tmp72_;
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp70_, _tmp73_);
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp73_);
#line 10452 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp74_;
						TrackerSparqlLiteralBinding* binding;
						TrackerSparqlLiteralBinding* _tmp75_;
						const gchar* _tmp76_;
						gchar* _tmp77_;
						TrackerSparqlQuery* _tmp78_;
						TrackerSparqlLiteralBinding* _tmp79_;
						TrackerSparqlLiteralBinding* _tmp80_;
						GString* _tmp81_;
#line 1099 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp74_ = tracker_sparql_literal_binding_new ();
#line 1099 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						binding = _tmp74_;
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp75_ = binding;
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp76_ = literal;
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp77_ = g_strdup (_tmp76_);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp75_->literal);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp75_->literal = _tmp77_;
#line 1101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp78_ = self->priv->query;
#line 1101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp79_ = binding;
#line 1101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp80_ = _g_object_ref0 (_tmp79_);
#line 1101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp78_->bindings = g_list_append (_tmp78_->bindings, _tmp80_);
#line 1102 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp81_ = sql;
#line 1102 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp81_, "?");
#line 1096 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 10491 "tracker-sparql-expression.c"
					}
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp82_ = sql;
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, _tmp82_);
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 10503 "tracker-sparql-expression.c"
				}
			}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (literal);
#line 10508 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 10512 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10527 "tracker-sparql-expression.c"
				} else {
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10535 "tracker-sparql-expression.c"
				}
			}
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp83_ = self->priv->query;
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp84_ = tracker_sparql_query_get_no_cache (_tmp83_);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp85_ = _tmp84_;
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp85_) {
#line 10546 "tracker-sparql-expression.c"
				GString* _tmp86_;
				gchar* _tmp87_ = NULL;
				gchar* _tmp88_;
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp86_ = sql;
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp87_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp88_ = _tmp87_;
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp86_, _tmp88_);
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp88_);
#line 10560 "tracker-sparql-expression.c"
			} else {
				GString* _tmp89_;
				TrackerSparqlLiteralBinding* _tmp90_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp91_;
				gchar* _tmp92_ = NULL;
				TrackerSparqlLiteralBinding* _tmp93_;
				TrackerSparqlQuery* _tmp94_;
				TrackerSparqlLiteralBinding* _tmp95_;
				TrackerSparqlLiteralBinding* _tmp96_;
#line 1113 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp89_ = sql;
#line 1113 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp89_, "?");
#line 1115 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp90_ = tracker_sparql_literal_binding_new ();
#line 1115 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp90_;
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp91_ = binding;
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp92_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp91_->literal);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp91_->literal = _tmp92_;
#line 1117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp93_ = binding;
#line 1117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp93_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp94_ = self->priv->query;
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp95_ = binding;
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp96_ = _g_object_ref0 (_tmp95_);
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp94_->bindings = g_list_append (_tmp94_->bindings, _tmp96_);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 10601 "tracker-sparql-expression.c"
			}
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10607 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 10611 "tracker-sparql-expression.c"
		{
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_;
			gchar* variable_name;
			TrackerSparqlContext* _tmp101_;
			TrackerSparqlContext* _tmp102_;
			const gchar* _tmp103_;
			TrackerSparqlVariable* _tmp104_ = NULL;
			TrackerSparqlVariable* _tmp105_;
			TrackerSparqlVariable* variable;
			GString* _tmp106_;
			TrackerSparqlVariable* _tmp107_;
			const gchar* _tmp108_;
			const gchar* _tmp109_;
			TrackerSparqlVariable* _tmp110_;
			TrackerSparqlVariableBinding* _tmp111_;
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10640 "tracker-sparql-expression.c"
				} else {
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10648 "tracker-sparql-expression.c"
				}
			}
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp97_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp98_ = _tmp97_;
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp99_ = string_substring (_tmp98_, (glong) 1, (glong) (-1));
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp100_ = _tmp99_;
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp98_);
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable_name = _tmp100_;
#line 1125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp101_ = tracker_sparql_expression_get_context (self);
#line 1125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp102_ = _tmp101_;
#line 1125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp103_ = variable_name;
#line 1125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp104_ = tracker_sparql_context_get_variable (_tmp102_, _tmp103_);
#line 1125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp105_ = _g_object_ref0 (_tmp104_);
#line 1125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp105_;
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp106_ = sql;
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp107_ = variable;
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp108_ = tracker_sparql_variable_get_sql_expression (_tmp107_);
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp109_ = _tmp108_;
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp106_, _tmp109_);
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp110_ = variable;
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp111_ = _tmp110_->binding;
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp111_ == NULL) {
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 10699 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlVariable* _tmp112_;
				TrackerSparqlVariableBinding* _tmp113_;
				TrackerPropertyType _tmp114_;
				TrackerSparqlVariable* _tmp116_;
				TrackerSparqlVariableBinding* _tmp117_;
				TrackerPropertyType _tmp118_;
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp112_ = variable;
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp113_ = _tmp112_->binding;
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp114_ = ((TrackerSparqlDataBinding*) _tmp113_)->data_type;
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp114_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 10715 "tracker-sparql-expression.c"
					GString* _tmp115_;
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp115_ = sql;
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, _tmp115_);
#line 10721 "tracker-sparql-expression.c"
				}
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp116_ = variable;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp117_ = _tmp116_->binding;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp118_ = ((TrackerSparqlDataBinding*) _tmp117_)->data_type;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = _tmp118_;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 10737 "tracker-sparql-expression.c"
			}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (variable_name);
#line 10743 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 10747 "tracker-sparql-expression.c"
		{
			GString* _tmp119_;
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp119_ = sql;
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_str (self, _tmp119_, &_inner_error_);
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10762 "tracker-sparql-expression.c"
				} else {
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10770 "tracker-sparql-expression.c"
				}
			}
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10777 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 10781 "tracker-sparql-expression.c"
		{
			GString* _tmp120_;
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10794 "tracker-sparql-expression.c"
				} else {
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10802 "tracker-sparql-expression.c"
				}
			}
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp120_ = sql;
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp120_, "''");
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10813 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 10817 "tracker-sparql-expression.c"
		{
			GString* _tmp121_;
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10830 "tracker-sparql-expression.c"
				} else {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10838 "tracker-sparql-expression.c"
				}
			}
#line 1145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp121_ = sql;
#line 1145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp121_, "0");
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10849 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 10853 "tracker-sparql-expression.c"
		{
			GString* _tmp122_;
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp122_ = sql;
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_datatype (self, _tmp122_, &_inner_error_);
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10868 "tracker-sparql-expression.c"
				} else {
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1148 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10876 "tracker-sparql-expression.c"
				}
			}
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10883 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 10887 "tracker-sparql-expression.c"
		{
			GString* _tmp123_;
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp123_ = sql;
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_bound_call (self, _tmp123_, &_inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10902 "tracker-sparql-expression.c"
				} else {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10910 "tracker-sparql-expression.c"
				}
			}
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10917 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 10921 "tracker-sparql-expression.c"
		{
			GString* _tmp124_;
			TrackerPropertyType _tmp125_ = 0;
			TrackerPropertyType _result_;
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10936 "tracker-sparql-expression.c"
				} else {
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10944 "tracker-sparql-expression.c"
				}
			}
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10957 "tracker-sparql-expression.c"
				} else {
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10965 "tracker-sparql-expression.c"
				}
			}
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp124_ = sql;
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp125_ = tracker_sparql_expression_translate_function (self, _tmp124_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce", &_inner_error_);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_result_ = _tmp125_;
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10982 "tracker-sparql-expression.c"
				} else {
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10990 "tracker-sparql-expression.c"
				}
			}
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11003 "tracker-sparql-expression.c"
				} else {
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11011 "tracker-sparql-expression.c"
				}
			}
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _result_;
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11018 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 11022 "tracker-sparql-expression.c"
		{
			GString* _tmp126_;
			TrackerPropertyType _tmp127_ = 0;
			TrackerPropertyType _tmp128_;
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp126_ = sql;
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp127_ = tracker_sparql_expression_translate_if_call (self, _tmp126_, &_inner_error_);
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp128_ = _tmp127_;
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11041 "tracker-sparql-expression.c"
				} else {
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11049 "tracker-sparql-expression.c"
				}
			}
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp128_;
#line 1160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11056 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 11060 "tracker-sparql-expression.c"
		{
			GString* _tmp129_;
			GString* _tmp130_;
			GString* _tmp131_;
			GString* _tmp132_;
			GString* _tmp133_;
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11077 "tracker-sparql-expression.c"
				} else {
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11085 "tracker-sparql-expression.c"
				}
			}
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11098 "tracker-sparql-expression.c"
				} else {
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11106 "tracker-sparql-expression.c"
				}
			}
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp129_ = sql;
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp129_, "(");
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp130_ = sql;
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp130_, &_inner_error_);
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11125 "tracker-sparql-expression.c"
				} else {
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11133 "tracker-sparql-expression.c"
				}
			}
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp131_ = sql;
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp131_, " = ");
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11150 "tracker-sparql-expression.c"
				} else {
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11158 "tracker-sparql-expression.c"
				}
			}
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp132_ = sql;
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp132_, &_inner_error_);
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11173 "tracker-sparql-expression.c"
				} else {
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11181 "tracker-sparql-expression.c"
				}
			}
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp133_ = sql;
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp133_, ")");
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11198 "tracker-sparql-expression.c"
				} else {
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11206 "tracker-sparql-expression.c"
				}
			}
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11213 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 11219 "tracker-sparql-expression.c"
		{
			GString* _tmp134_;
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp134_ = sql;
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_isuri (self, _tmp134_, &_inner_error_);
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11234 "tracker-sparql-expression.c"
				} else {
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11242 "tracker-sparql-expression.c"
				}
			}
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11249 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 11253 "tracker-sparql-expression.c"
		{
			GString* _tmp135_;
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11266 "tracker-sparql-expression.c"
				} else {
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11274 "tracker-sparql-expression.c"
				}
			}
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11287 "tracker-sparql-expression.c"
				} else {
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11295 "tracker-sparql-expression.c"
				}
			}
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11308 "tracker-sparql-expression.c"
				} else {
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11316 "tracker-sparql-expression.c"
				}
			}
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp135_ = sql;
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp135_, "0");
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11333 "tracker-sparql-expression.c"
				} else {
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11341 "tracker-sparql-expression.c"
				}
			}
#line 1183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11348 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 11352 "tracker-sparql-expression.c"
		{
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11364 "tracker-sparql-expression.c"
				} else {
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11372 "tracker-sparql-expression.c"
				}
			}
#line 1186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11379 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 11383 "tracker-sparql-expression.c"
		{
			GString* _tmp136_;
			TrackerSparqlQuery* _tmp137_;
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp136_ = sql;
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_regex (self, _tmp136_, &_inner_error_);
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11399 "tracker-sparql-expression.c"
				} else {
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11407 "tracker-sparql-expression.c"
				}
			}
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp137_ = self->priv->query;
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_query_set_no_cache (_tmp137_, TRUE);
#line 1190 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1190 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11418 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 11424 "tracker-sparql-expression.c"
		{
			GString* _tmp138_;
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp138_ = sql;
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_exists (self, _tmp138_, &_inner_error_);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11439 "tracker-sparql-expression.c"
				} else {
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11447 "tracker-sparql-expression.c"
				}
			}
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11454 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 11458 "tracker-sparql-expression.c"
		{
			GString* _tmp139_;
			GString* _tmp140_;
			GString* _tmp141_;
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11473 "tracker-sparql-expression.c"
				} else {
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11481 "tracker-sparql-expression.c"
				}
			}
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp139_ = sql;
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp139_, "COUNT(");
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp140_ = sql;
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_aggregate_expression (self, _tmp140_, &_inner_error_);
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11500 "tracker-sparql-expression.c"
				} else {
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11508 "tracker-sparql-expression.c"
				}
			}
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp141_ = sql;
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp141_, ")");
#line 1200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11519 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 11523 "tracker-sparql-expression.c"
		{
			GString* _tmp142_;
			GString* _tmp143_;
			TrackerPropertyType _tmp144_ = 0;
			TrackerPropertyType _tmp145_;
			GString* _tmp146_;
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11540 "tracker-sparql-expression.c"
				} else {
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11548 "tracker-sparql-expression.c"
				}
			}
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp142_ = sql;
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp142_, "SUM(");
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp143_ = sql;
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp144_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp143_, &_inner_error_);
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp145_ = _tmp144_;
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11569 "tracker-sparql-expression.c"
				} else {
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11577 "tracker-sparql-expression.c"
				}
			}
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp145_;
#line 1205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp146_ = sql;
#line 1205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp146_, ")");
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11590 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 11594 "tracker-sparql-expression.c"
		{
			GString* _tmp147_;
			GString* _tmp148_;
			TrackerPropertyType _tmp149_ = 0;
			TrackerPropertyType _tmp150_;
			GString* _tmp151_;
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11611 "tracker-sparql-expression.c"
				} else {
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11619 "tracker-sparql-expression.c"
				}
			}
#line 1209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp147_ = sql;
#line 1209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp147_, "AVG(");
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp148_ = sql;
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp149_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp148_, &_inner_error_);
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp150_ = _tmp149_;
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11640 "tracker-sparql-expression.c"
				} else {
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11648 "tracker-sparql-expression.c"
				}
			}
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp150_;
#line 1211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp151_ = sql;
#line 1211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp151_, ")");
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11661 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 11665 "tracker-sparql-expression.c"
		{
			GString* _tmp152_;
			GString* _tmp153_;
			TrackerPropertyType _tmp154_ = 0;
			TrackerPropertyType _tmp155_;
			GString* _tmp156_;
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11682 "tracker-sparql-expression.c"
				} else {
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11690 "tracker-sparql-expression.c"
				}
			}
#line 1215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp152_ = sql;
#line 1215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp152_, "MIN(");
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp153_ = sql;
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp154_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp153_, &_inner_error_);
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp155_ = _tmp154_;
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11711 "tracker-sparql-expression.c"
				} else {
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11719 "tracker-sparql-expression.c"
				}
			}
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp155_;
#line 1217 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp156_ = sql;
#line 1217 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp156_, ")");
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11732 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 11736 "tracker-sparql-expression.c"
		{
			GString* _tmp157_;
			GString* _tmp158_;
			TrackerPropertyType _tmp159_ = 0;
			TrackerPropertyType _tmp160_;
			GString* _tmp161_;
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11753 "tracker-sparql-expression.c"
				} else {
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11761 "tracker-sparql-expression.c"
				}
			}
#line 1221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp157_ = sql;
#line 1221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp157_, "MAX(");
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp158_ = sql;
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp159_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp158_, &_inner_error_);
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp160_ = _tmp159_;
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11782 "tracker-sparql-expression.c"
				} else {
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11790 "tracker-sparql-expression.c"
				}
			}
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp160_;
#line 1223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp161_ = sql;
#line 1223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp161_, ")");
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11803 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 11807 "tracker-sparql-expression.c"
		{
			GString* _tmp162_;
			GString* _tmp163_;
			GString* _tmp164_;
			gchar* _tmp165_ = NULL;
			gchar* _tmp166_;
			GString* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_ = NULL;
			gchar* _tmp170_;
			GString* _tmp171_;
#line 1226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11829 "tracker-sparql-expression.c"
				} else {
#line 1226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11837 "tracker-sparql-expression.c"
				}
			}
#line 1227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp162_ = sql;
#line 1227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp162_, "GROUP_CONCAT(");
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11854 "tracker-sparql-expression.c"
				} else {
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11862 "tracker-sparql-expression.c"
				}
			}
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp163_ = sql;
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, _tmp163_, &_inner_error_);
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11877 "tracker-sparql-expression.c"
				} else {
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11885 "tracker-sparql-expression.c"
				}
			}
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp164_ = sql;
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp164_, ", ");
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11902 "tracker-sparql-expression.c"
				} else {
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11910 "tracker-sparql-expression.c"
				}
			}
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp165_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp166_ = _tmp165_;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11925 "tracker-sparql-expression.c"
				} else {
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11933 "tracker-sparql-expression.c"
				}
			}
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp167_ = sql;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp168_ = _tmp166_;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp169_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp168_);
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp170_ = _tmp169_;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp167_, _tmp170_);
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp170_);
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp168_);
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp171_ = sql;
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp171_, ")");
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11964 "tracker-sparql-expression.c"
				} else {
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11972 "tracker-sparql-expression.c"
				}
			}
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11979 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 11983 "tracker-sparql-expression.c"
		{
			gchar* _tmp172_ = NULL;
			gchar* ns;
			TrackerSparqlQuery* _tmp173_;
			const gchar* _tmp174_;
			gchar* _tmp175_ = NULL;
			gchar* _tmp176_;
			gchar* _tmp177_ = NULL;
			gchar* _tmp178_;
			gchar* _tmp179_ = NULL;
			gchar* _tmp180_;
			gchar* uri;
			GString* _tmp181_;
			const gchar* _tmp182_;
			TrackerPropertyType _tmp183_ = 0;
			TrackerPropertyType _tmp184_;
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12010 "tracker-sparql-expression.c"
				} else {
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12018 "tracker-sparql-expression.c"
				}
			}
#line 1238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp172_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			ns = _tmp172_;
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12037 "tracker-sparql-expression.c"
				} else {
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12047 "tracker-sparql-expression.c"
				}
			}
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp173_ = self->priv->query;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp174_ = ns;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp175_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp176_ = _tmp175_;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp177_ = string_substring (_tmp176_, (glong) 1, (glong) (-1));
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp178_ = _tmp177_;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp179_ = tracker_sparql_query_resolve_prefixed_name (_tmp173_, _tmp174_, _tmp178_, &_inner_error_);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp180_ = _tmp179_;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp178_);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp176_);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			uri = _tmp180_;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12082 "tracker-sparql-expression.c"
				} else {
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12092 "tracker-sparql-expression.c"
				}
			}
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp181_ = sql;
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp182_ = uri;
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp183_ = tracker_sparql_expression_translate_uri_expression (self, _tmp181_, _tmp182_, &_inner_error_);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp184_ = _tmp183_;
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12115 "tracker-sparql-expression.c"
				} else {
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12127 "tracker-sparql-expression.c"
				}
			}
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp184_;
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 1241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 12138 "tracker-sparql-expression.c"
		}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 12142 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp185_;
			gchar* _tmp186_ = NULL;
			gchar* _tmp187_;
			gchar* _tmp188_ = NULL;
			gchar* _tmp189_;
			gchar* _tmp190_ = NULL;
			gchar* _tmp191_;
			gchar* uri;
			GString* _tmp192_;
			const gchar* _tmp193_;
			TrackerPropertyType _tmp194_ = 0;
			TrackerPropertyType _tmp195_;
#line 1243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12166 "tracker-sparql-expression.c"
				} else {
#line 1243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12174 "tracker-sparql-expression.c"
				}
			}
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp185_ = self->priv->query;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp186_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp187_ = _tmp186_;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp188_ = string_substring (_tmp187_, (glong) 1, (glong) (-1));
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp189_ = _tmp188_;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp190_ = tracker_sparql_query_resolve_prefixed_name (_tmp185_, "", _tmp189_, &_inner_error_);
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp191_ = _tmp190_;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp189_);
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp187_);
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			uri = _tmp191_;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12205 "tracker-sparql-expression.c"
				} else {
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12213 "tracker-sparql-expression.c"
				}
			}
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp192_ = sql;
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp193_ = uri;
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp194_ = tracker_sparql_expression_translate_uri_expression (self, _tmp192_, _tmp193_, &_inner_error_);
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp195_ = _tmp194_;
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12234 "tracker-sparql-expression.c"
				} else {
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12244 "tracker-sparql-expression.c"
				}
			}
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp195_;
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 12253 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp196_ = NULL;
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp196_ = tracker_sparql_expression_get_error (self, "expected primary expression");
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp196_;
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12268 "tracker-sparql-expression.c"
			} else {
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12276 "tracker-sparql-expression.c"
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp19_;
	TrackerPropertyType _tmp20_ = 0;
	TrackerPropertyType _tmp21_;
	GError * _inner_error_ = NULL;
#line 1251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error_);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12307 "tracker-sparql-expression.c"
		} else {
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12315 "tracker-sparql-expression.c"
		}
	}
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 12320 "tracker-sparql-expression.c"
		GString* _tmp2_;
		GString* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType optype;
		GString* _tmp5_;
		TrackerPropertyType _tmp6_;
#line 1253 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1253 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp2_, "NOT (");
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_primary_expression (self, _tmp3_, &_inner_error_);
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp4_;
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12345 "tracker-sparql-expression.c"
			} else {
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12353 "tracker-sparql-expression.c"
			}
		}
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp5_, ")");
#line 1256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 12364 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12376 "tracker-sparql-expression.c"
			} else {
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12384 "tracker-sparql-expression.c"
			}
		}
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 12391 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12407 "tracker-sparql-expression.c"
			} else {
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12415 "tracker-sparql-expression.c"
			}
		}
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp9_) {
#line 12420 "tracker-sparql-expression.c"
			GString* _tmp10_;
			TrackerPropertyType _tmp11_ = 0;
			TrackerPropertyType _tmp12_;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = sql;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_expression_translate_primary_expression (self, _tmp10_, &_inner_error_);
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12438 "tracker-sparql-expression.c"
				} else {
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12446 "tracker-sparql-expression.c"
				}
			}
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp12_;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 12453 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12469 "tracker-sparql-expression.c"
				} else {
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12477 "tracker-sparql-expression.c"
				}
			}
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp14_) {
#line 12482 "tracker-sparql-expression.c"
				GString* _tmp15_;
				GString* _tmp16_;
				TrackerPropertyType _tmp17_ = 0;
				TrackerPropertyType optype;
				GString* _tmp18_;
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = sql;
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp15_, "-(");
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = tracker_sparql_expression_translate_primary_expression (self, _tmp16_, &_inner_error_);
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				optype = _tmp17_;
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12506 "tracker-sparql-expression.c"
					} else {
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12514 "tracker-sparql-expression.c"
					}
				}
#line 1265 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = sql;
#line 1265 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp18_, ")");
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = optype;
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 12525 "tracker-sparql-expression.c"
			}
		}
	}
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp20_ = tracker_sparql_expression_translate_primary_expression (self, _tmp19_, &_inner_error_);
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp21_ = _tmp20_;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12543 "tracker-sparql-expression.c"
		} else {
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12551 "tracker-sparql-expression.c"
		}
	}
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp21_;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12558 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_unary_expression (self, _tmp2_, &_inner_error_);
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12595 "tracker-sparql-expression.c"
		} else {
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12603 "tracker-sparql-expression.c"
		}
	}
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 12608 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12623 "tracker-sparql-expression.c"
			} else {
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12631 "tracker-sparql-expression.c"
			}
		}
#line 1275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 12636 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_ = FALSE;
			GString* _tmp9_;
			glong _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			TrackerPropertyType _tmp13_ = 0;
			TrackerPropertyType _tmp14_;
			gboolean _tmp15_ = FALSE;
			GString* _tmp17_;
#line 1276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = optype;
#line 1276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
#line 1276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp7_) {
#line 12653 "tracker-sparql-expression.c"
				GError* _tmp8_ = NULL;
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp8_;
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12665 "tracker-sparql-expression.c"
				} else {
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12673 "tracker-sparql-expression.c"
				}
			}
#line 1279 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1279 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = begin;
#line 1279 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp9_, (gssize) _tmp10_, "(");
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = sql;
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp11_, " * ");
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_translate_unary_expression (self, _tmp12_, &_inner_error_);
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12700 "tracker-sparql-expression.c"
				} else {
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12708 "tracker-sparql-expression.c"
				}
			}
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp15_) {
#line 12715 "tracker-sparql-expression.c"
				GError* _tmp16_ = NULL;
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp16_;
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12727 "tracker-sparql-expression.c"
				} else {
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12735 "tracker-sparql-expression.c"
				}
			}
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp17_, ")");
#line 12742 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12758 "tracker-sparql-expression.c"
				} else {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12766 "tracker-sparql-expression.c"
				}
			}
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp19_) {
#line 12771 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp20_;
				gboolean _tmp21_ = FALSE;
				GString* _tmp23_;
				glong _tmp24_;
				GString* _tmp25_;
				GString* _tmp26_;
				TrackerPropertyType _tmp27_ = 0;
				TrackerPropertyType _tmp28_;
				gboolean _tmp29_ = FALSE;
				GString* _tmp31_;
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = optype;
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_expression_maybe_numeric (self, _tmp20_);
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp21_) {
#line 12788 "tracker-sparql-expression.c"
					GError* _tmp22_ = NULL;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp22_;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12800 "tracker-sparql-expression.c"
					} else {
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12808 "tracker-sparql-expression.c"
					}
				}
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp23_ = sql;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp24_ = begin;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_insert (_tmp23_, (gssize) _tmp24_, "(");
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp25_, " / ");
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_translate_unary_expression (self, _tmp26_, &_inner_error_);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12835 "tracker-sparql-expression.c"
					} else {
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12843 "tracker-sparql-expression.c"
					}
				}
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_maybe_numeric (self, _tmp28_);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp29_) {
#line 12850 "tracker-sparql-expression.c"
					GError* _tmp30_ = NULL;
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp30_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp30_;
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12862 "tracker-sparql-expression.c"
					} else {
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12870 "tracker-sparql-expression.c"
					}
				}
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 12877 "tracker-sparql-expression.c"
			} else {
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 12881 "tracker-sparql-expression.c"
			}
		}
	}
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12889 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1303 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1303 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1303 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp2_, &_inner_error_);
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12926 "tracker-sparql-expression.c"
		} else {
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12934 "tracker-sparql-expression.c"
		}
	}
#line 1305 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 12939 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12954 "tracker-sparql-expression.c"
			} else {
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12962 "tracker-sparql-expression.c"
			}
		}
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 12967 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_ = FALSE;
			GString* _tmp9_;
			glong _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			TrackerPropertyType _tmp13_ = 0;
			TrackerPropertyType _tmp14_;
			gboolean _tmp15_ = FALSE;
			GString* _tmp17_;
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = optype;
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp7_) {
#line 12984 "tracker-sparql-expression.c"
				GError* _tmp8_ = NULL;
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp8_;
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12996 "tracker-sparql-expression.c"
				} else {
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13004 "tracker-sparql-expression.c"
				}
			}
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = begin;
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp9_, (gssize) _tmp10_, "(");
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = sql;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp11_, " + ");
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp12_, &_inner_error_);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13031 "tracker-sparql-expression.c"
				} else {
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13039 "tracker-sparql-expression.c"
				}
			}
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp15_) {
#line 13046 "tracker-sparql-expression.c"
				GError* _tmp16_ = NULL;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp16_;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13058 "tracker-sparql-expression.c"
				} else {
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13066 "tracker-sparql-expression.c"
				}
			}
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp17_, ")");
#line 13073 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13089 "tracker-sparql-expression.c"
				} else {
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13097 "tracker-sparql-expression.c"
				}
			}
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp19_) {
#line 13102 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp20_;
				gboolean _tmp21_ = FALSE;
				GString* _tmp23_;
				glong _tmp24_;
				GString* _tmp25_;
				GString* _tmp26_;
				TrackerPropertyType _tmp27_ = 0;
				TrackerPropertyType _tmp28_;
				gboolean _tmp29_ = FALSE;
				GString* _tmp31_;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = optype;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_expression_maybe_numeric (self, _tmp20_);
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp21_) {
#line 13119 "tracker-sparql-expression.c"
					GError* _tmp22_ = NULL;
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp22_;
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13131 "tracker-sparql-expression.c"
					} else {
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13139 "tracker-sparql-expression.c"
					}
				}
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp23_ = sql;
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp24_ = begin;
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_insert (_tmp23_, (gssize) _tmp24_, "(");
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp25_, " - ");
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp26_, &_inner_error_);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13166 "tracker-sparql-expression.c"
					} else {
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13174 "tracker-sparql-expression.c"
					}
				}
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_maybe_numeric (self, _tmp28_);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp29_) {
#line 13181 "tracker-sparql-expression.c"
					GError* _tmp30_ = NULL;
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp30_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp30_;
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13193 "tracker-sparql-expression.c"
					} else {
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13201 "tracker-sparql-expression.c"
					}
				}
#line 1325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 1325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 13208 "tracker-sparql-expression.c"
			} else {
#line 1327 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 13212 "tracker-sparql-expression.c"
			}
		}
	}
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13220 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1333 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1333 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_additive_expression (self, _tmp0_, &_inner_error_);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13248 "tracker-sparql-expression.c"
		} else {
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13256 "tracker-sparql-expression.c"
		}
	}
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13263 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	glong _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp4_;
	TrackerPropertyType _tmp5_ = 0;
	TrackerPropertyType op2type;
	GString* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	TrackerPropertyType _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
#line 1337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (operator != NULL, 0);
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = begin;
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_insert (_tmp0_, (gssize) _tmp1_, "(");
#line 1339 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1339 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = operator;
#line 1339 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = tracker_sparql_expression_translate_numeric_expression (self, _tmp4_, &_inner_error_);
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	op2type = _tmp5_;
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13315 "tracker-sparql-expression.c"
		} else {
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13323 "tracker-sparql-expression.c"
		}
	}
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = sql;
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp6_, ")");
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = op1type;
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp9_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 13336 "tracker-sparql-expression.c"
	} else {
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = FALSE;
#line 13340 "tracker-sparql-expression.c"
	}
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = _tmp8_;
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp10_) {
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = TRUE;
#line 13348 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp11_ = FALSE;
		TrackerPropertyType _tmp12_;
		gboolean _tmp13_;
#line 1343 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = op1type;
#line 1343 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1343 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
#line 13359 "tracker-sparql-expression.c"
		} else {
#line 1343 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = FALSE;
#line 13363 "tracker-sparql-expression.c"
		}
#line 1343 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp11_;
#line 1343 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp13_;
#line 13369 "tracker-sparql-expression.c"
	}
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp14_ = _tmp7_;
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp14_) {
#line 13375 "tracker-sparql-expression.c"
		TrackerSparqlQuery* _tmp15_;
		GList* _tmp16_;
		guint _tmp17_ = 0U;
		guint _tmp18_;
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = self->priv->query;
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = _tmp15_->bindings;
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp17_ = g_list_length (_tmp16_);
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp18_ = n_bindings;
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp17_ == (_tmp18_ + 1)) {
#line 13390 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp19_;
			GList* _tmp20_;
			GList* _tmp21_ = NULL;
			gconstpointer _tmp22_;
#line 1347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = self->priv->query;
#line 1347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp19_->bindings;
#line 1347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = g_list_last (_tmp20_);
#line 1347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_->data;
#line 1347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp22_))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 13405 "tracker-sparql-expression.c"
		}
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		TrackerPropertyType _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp30_;
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp25_ = op1type;
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp25_ == TRACKER_PROPERTY_TYPE_DATE) {
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 13419 "tracker-sparql-expression.c"
		} else {
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = FALSE;
#line 13423 "tracker-sparql-expression.c"
		}
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp26_ = _tmp24_;
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp26_) {
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = TRUE;
#line 13431 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp27_ = FALSE;
			TrackerPropertyType _tmp28_;
			gboolean _tmp29_;
#line 1350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = op1type;
#line 1350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp28_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = op2type == TRACKER_PROPERTY_TYPE_DATE;
#line 13442 "tracker-sparql-expression.c"
			} else {
#line 1350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = FALSE;
#line 13446 "tracker-sparql-expression.c"
			}
#line 1350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = _tmp27_;
#line 1350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = _tmp29_;
#line 13452 "tracker-sparql-expression.c"
		}
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp30_ = _tmp23_;
#line 1349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp30_) {
#line 13458 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp31_;
			GList* _tmp32_;
			guint _tmp33_ = 0U;
			guint _tmp34_;
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = self->priv->query;
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = _tmp31_->bindings;
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = g_list_length (_tmp32_);
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = n_bindings;
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp33_ == (_tmp34_ + 1)) {
#line 13473 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp35_;
				GList* _tmp36_;
				GList* _tmp37_ = NULL;
				gconstpointer _tmp38_;
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp35_ = self->priv->query;
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp36_ = _tmp35_->bindings;
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp37_ = g_list_last (_tmp36_);
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = _tmp37_->data;
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp38_))->data_type = TRACKER_PROPERTY_TYPE_DATE;
#line 13488 "tracker-sparql-expression.c"
			}
		}
	}
#line 1357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13496 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error) {
	TrackerPropertyType result = 0;
	gint in_variable_count;
	gboolean _tmp0_;
	GString* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GString* _tmp19_;
	GError * _inner_error_ = NULL;
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	in_variable_count = 0;
#line 1364 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = not;
#line 1364 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 13519 "tracker-sparql-expression.c"
		GString* _tmp1_;
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp1_, " NOT");
#line 13525 "tracker-sparql-expression.c"
	}
#line 1368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13537 "tracker-sparql-expression.c"
		} else {
#line 1368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13545 "tracker-sparql-expression.c"
		}
	}
#line 1369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " IN (");
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13564 "tracker-sparql-expression.c"
		} else {
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13572 "tracker-sparql-expression.c"
		}
	}
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp4_) {
#line 13577 "tracker-sparql-expression.c"
		gint _tmp5_;
		GString* _tmp6_;
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = in_variable_count;
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		in_variable_count = _tmp5_ + 1;
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13596 "tracker-sparql-expression.c"
			} else {
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13604 "tracker-sparql-expression.c"
			}
		}
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		while (TRUE) {
#line 13609 "tracker-sparql-expression.c"
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			GString* _tmp9_;
			gint _tmp10_;
			gboolean _tmp11_ = FALSE;
			gint _tmp12_;
			gboolean _tmp16_;
			GString* _tmp18_;
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13630 "tracker-sparql-expression.c"
				} else {
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13638 "tracker-sparql-expression.c"
				}
			}
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp8_) {
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 13645 "tracker-sparql-expression.c"
			}
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp9_, ", ");
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = in_variable_count;
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			in_variable_count = _tmp10_ + 1;
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = in_variable_count;
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp12_ > TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN) {
#line 13659 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = self->priv->query;
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = tracker_sparql_query_get_no_cache (_tmp13_);
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_;
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = !_tmp15_;
#line 13671 "tracker-sparql-expression.c"
			} else {
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = FALSE;
#line 13675 "tracker-sparql-expression.c"
			}
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = _tmp11_;
#line 1378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp16_) {
#line 13681 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp17_;
#line 1379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = self->priv->query;
#line 1379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_query_set_no_cache (_tmp17_, TRUE);
#line 13687 "tracker-sparql-expression.c"
			}
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = sql;
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp18_, &_inner_error_);
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13701 "tracker-sparql-expression.c"
				} else {
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13709 "tracker-sparql-expression.c"
				}
			}
		}
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13723 "tracker-sparql-expression.c"
			} else {
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13731 "tracker-sparql-expression.c"
			}
		}
	}
#line 1386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 1386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp19_, ")");
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13743 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	TrackerSparqlQuery* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_ = 0U;
	guint n_bindings;
	GString* _tmp5_;
	TrackerPropertyType _tmp6_ = 0;
	TrackerPropertyType optype;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
#line 1391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1391 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1392 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1392 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1392 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = self->priv->query;
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_->bindings;
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = g_list_length (_tmp3_);
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	n_bindings = _tmp4_;
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = tracker_sparql_expression_translate_numeric_expression (self, _tmp5_, &_inner_error_);
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp6_;
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13794 "tracker-sparql-expression.c"
		} else {
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13802 "tracker-sparql-expression.c"
		}
	}
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error_);
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp7_;
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13817 "tracker-sparql-expression.c"
		} else {
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13825 "tracker-sparql-expression.c"
		}
	}
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp8_) {
#line 13830 "tracker-sparql-expression.c"
		GString* _tmp9_;
		glong _tmp10_;
		guint _tmp11_;
		TrackerPropertyType _tmp12_;
		TrackerPropertyType _tmp13_ = 0;
		TrackerPropertyType _tmp14_;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = sql;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = begin;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = n_bindings;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = optype;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = tracker_sparql_expression_process_relational_expression (self, _tmp9_, _tmp10_, _tmp11_, _tmp12_, " >= ", &_inner_error_);
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = _tmp13_;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13857 "tracker-sparql-expression.c"
			} else {
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13865 "tracker-sparql-expression.c"
			}
		}
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _tmp14_;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 13872 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = _tmp15_;
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13888 "tracker-sparql-expression.c"
			} else {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13896 "tracker-sparql-expression.c"
			}
		}
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp16_) {
#line 13901 "tracker-sparql-expression.c"
			GString* _tmp17_;
			glong _tmp18_;
			guint _tmp19_;
			TrackerPropertyType _tmp20_;
			TrackerPropertyType _tmp21_ = 0;
			TrackerPropertyType _tmp22_;
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = begin;
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = n_bindings;
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = optype;
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = tracker_sparql_expression_process_relational_expression (self, _tmp17_, _tmp18_, _tmp19_, _tmp20_, " = ", &_inner_error_);
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13928 "tracker-sparql-expression.c"
				} else {
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13936 "tracker-sparql-expression.c"
				}
			}
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp22_;
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 13943 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_;
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error_);
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_;
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13959 "tracker-sparql-expression.c"
				} else {
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13967 "tracker-sparql-expression.c"
				}
			}
#line 1400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp24_) {
#line 13972 "tracker-sparql-expression.c"
				GString* _tmp25_;
				glong _tmp26_;
				guint _tmp27_;
				TrackerPropertyType _tmp28_;
				TrackerPropertyType _tmp29_ = 0;
				TrackerPropertyType _tmp30_;
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = begin;
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = n_bindings;
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = optype;
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_process_relational_expression (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_, " <> ", &_inner_error_);
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = _tmp29_;
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13999 "tracker-sparql-expression.c"
					} else {
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 14007 "tracker-sparql-expression.c"
					}
				}
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = _tmp30_;
#line 1401 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 14014 "tracker-sparql-expression.c"
			} else {
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_;
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error_);
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = _tmp31_;
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 14030 "tracker-sparql-expression.c"
					} else {
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 14038 "tracker-sparql-expression.c"
					}
				}
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp32_) {
#line 14043 "tracker-sparql-expression.c"
					GString* _tmp33_;
					glong _tmp34_;
					guint _tmp35_;
					TrackerPropertyType _tmp36_;
					TrackerPropertyType _tmp37_ = 0;
					TrackerPropertyType _tmp38_;
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp33_ = sql;
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp34_ = begin;
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp35_ = n_bindings;
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp36_ = optype;
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp37_ = tracker_sparql_expression_process_relational_expression (self, _tmp33_, _tmp34_, _tmp35_, _tmp36_, " < ", &_inner_error_);
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp38_ = _tmp37_;
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 14070 "tracker-sparql-expression.c"
						} else {
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 14078 "tracker-sparql-expression.c"
						}
					}
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = _tmp38_;
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 14085 "tracker-sparql-expression.c"
				} else {
					gboolean _tmp39_ = FALSE;
					gboolean _tmp40_;
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp39_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error_);
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp40_ = _tmp39_;
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 14101 "tracker-sparql-expression.c"
						} else {
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 14109 "tracker-sparql-expression.c"
						}
					}
#line 1404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp40_) {
#line 14114 "tracker-sparql-expression.c"
						GString* _tmp41_;
						glong _tmp42_;
						guint _tmp43_;
						TrackerPropertyType _tmp44_;
						TrackerPropertyType _tmp45_ = 0;
						TrackerPropertyType _tmp46_;
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp41_ = sql;
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp42_ = begin;
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp43_ = n_bindings;
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp44_ = optype;
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp45_ = tracker_sparql_expression_process_relational_expression (self, _tmp41_, _tmp42_, _tmp43_, _tmp44_, " <= ", &_inner_error_);
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp46_ = _tmp45_;
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 14141 "tracker-sparql-expression.c"
							} else {
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 14149 "tracker-sparql-expression.c"
							}
						}
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						result = _tmp46_;
#line 1405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return result;
#line 14156 "tracker-sparql-expression.c"
					} else {
						gboolean _tmp47_ = FALSE;
						gboolean _tmp48_;
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp47_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error_);
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp48_ = _tmp47_;
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 14172 "tracker-sparql-expression.c"
							} else {
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 14180 "tracker-sparql-expression.c"
							}
						}
#line 1406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_tmp48_) {
#line 14185 "tracker-sparql-expression.c"
							GString* _tmp49_;
							glong _tmp50_;
							guint _tmp51_;
							TrackerPropertyType _tmp52_;
							TrackerPropertyType _tmp53_ = 0;
							TrackerPropertyType _tmp54_;
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp49_ = sql;
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp50_ = begin;
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp51_ = n_bindings;
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp52_ = optype;
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp53_ = tracker_sparql_expression_process_relational_expression (self, _tmp49_, _tmp50_, _tmp51_, _tmp52_, " > ", &_inner_error_);
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp54_ = _tmp53_;
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 14212 "tracker-sparql-expression.c"
								} else {
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 14220 "tracker-sparql-expression.c"
								}
							}
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							result = _tmp54_;
#line 1407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return result;
#line 14227 "tracker-sparql-expression.c"
						} else {
							gboolean _tmp55_ = FALSE;
							gboolean _tmp56_;
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp55_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp56_ = _tmp55_;
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 14243 "tracker-sparql-expression.c"
								} else {
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 14251 "tracker-sparql-expression.c"
								}
							}
#line 1408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_tmp56_) {
#line 14256 "tracker-sparql-expression.c"
								GString* _tmp57_;
								TrackerPropertyType _tmp58_ = 0;
								TrackerPropertyType _tmp59_;
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp57_ = sql;
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp58_ = tracker_sparql_expression_translate_in (self, _tmp57_, FALSE, &_inner_error_);
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp59_ = _tmp58_;
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 14274 "tracker-sparql-expression.c"
									} else {
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 14282 "tracker-sparql-expression.c"
									}
								}
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								result = _tmp59_;
#line 1409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return result;
#line 14289 "tracker-sparql-expression.c"
							} else {
								gboolean _tmp60_ = FALSE;
								gboolean _tmp61_;
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp60_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp61_ = _tmp60_;
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 14305 "tracker-sparql-expression.c"
									} else {
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 14313 "tracker-sparql-expression.c"
									}
								}
#line 1410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_tmp61_) {
#line 14318 "tracker-sparql-expression.c"
									GString* _tmp62_;
									TrackerPropertyType _tmp63_ = 0;
									TrackerPropertyType _tmp64_;
#line 1411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
#line 1411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 1411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 1411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 14332 "tracker-sparql-expression.c"
										} else {
#line 1411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 1411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 14340 "tracker-sparql-expression.c"
										}
									}
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp62_ = sql;
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp63_ = tracker_sparql_expression_translate_in (self, _tmp62_, TRUE, &_inner_error_);
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp64_ = _tmp63_;
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 14357 "tracker-sparql-expression.c"
										} else {
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 14365 "tracker-sparql-expression.c"
										}
									}
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									result = _tmp64_;
#line 1412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return result;
#line 14372 "tracker-sparql-expression.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 1414 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1414 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14385 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_relational_expression (self, _tmp0_, &_inner_error_);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14413 "tracker-sparql-expression.c"
		} else {
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14421 "tracker-sparql-expression.c"
		}
	}
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14428 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_value_logical (self, _tmp2_, &_inner_error_);
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14465 "tracker-sparql-expression.c"
		} else {
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14473 "tracker-sparql-expression.c"
		}
	}
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 14478 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		TrackerPropertyType _tmp6_;
		GString* _tmp8_;
		glong _tmp9_;
		GString* _tmp10_;
		GString* _tmp11_;
		TrackerPropertyType _tmp12_ = 0;
		TrackerPropertyType _tmp13_;
		GString* _tmp14_;
		TrackerPropertyType _tmp15_;
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error_);
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14502 "tracker-sparql-expression.c"
			} else {
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14510 "tracker-sparql-expression.c"
			}
		}
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (!_tmp5_) {
#line 1424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 14517 "tracker-sparql-expression.c"
		}
#line 1425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14523 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1426 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1426 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1426 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1426 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1426 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14535 "tracker-sparql-expression.c"
			} else {
#line 1426 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1426 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14543 "tracker-sparql-expression.c"
			}
		}
#line 1428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = sql;
#line 1428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = begin;
#line 1428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp8_, (gssize) _tmp9_, "(");
#line 1429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = sql;
#line 1429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp10_, " AND ");
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = sql;
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_translate_value_logical (self, _tmp11_, &_inner_error_);
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14570 "tracker-sparql-expression.c"
			} else {
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14578 "tracker-sparql-expression.c"
			}
		}
#line 1430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp13_;
#line 1431 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 1431 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, ")");
#line 1432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = optype;
#line 1432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14591 "tracker-sparql-expression.c"
			GError* _tmp16_ = NULL;
#line 1433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp16_;
#line 1433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14603 "tracker-sparql-expression.c"
			} else {
#line 1433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14611 "tracker-sparql-expression.c"
			}
		}
	}
#line 1436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14619 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1439 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1439 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_conditional_and_expression (self, _tmp2_, &_inner_error_);
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14656 "tracker-sparql-expression.c"
		} else {
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14664 "tracker-sparql-expression.c"
		}
	}
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 14669 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		TrackerPropertyType _tmp6_;
		GString* _tmp8_;
		glong _tmp9_;
		GString* _tmp10_;
		GString* _tmp11_;
		TrackerPropertyType _tmp12_ = 0;
		TrackerPropertyType _tmp13_;
		GString* _tmp14_;
		TrackerPropertyType _tmp15_;
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error_);
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14693 "tracker-sparql-expression.c"
			} else {
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14701 "tracker-sparql-expression.c"
			}
		}
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (!_tmp5_) {
#line 1442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 14708 "tracker-sparql-expression.c"
		}
#line 1443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14714 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14726 "tracker-sparql-expression.c"
			} else {
#line 1444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14734 "tracker-sparql-expression.c"
			}
		}
#line 1446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = sql;
#line 1446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = begin;
#line 1446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp8_, (gssize) _tmp9_, "(");
#line 1447 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = sql;
#line 1447 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp10_, " OR ");
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = sql;
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_translate_conditional_and_expression (self, _tmp11_, &_inner_error_);
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14761 "tracker-sparql-expression.c"
			} else {
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14769 "tracker-sparql-expression.c"
			}
		}
#line 1448 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp13_;
#line 1449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 1449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, ")");
#line 1450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = optype;
#line 1450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14782 "tracker-sparql-expression.c"
			GError* _tmp16_ = NULL;
#line 1451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp16_;
#line 1451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14794 "tracker-sparql-expression.c"
			} else {
#line 1451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14802 "tracker-sparql-expression.c"
			}
		}
	}
#line 1454 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1454 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14810 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1457 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1457 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_conditional_or_expression (self, _tmp0_, &_inner_error_);
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14838 "tracker-sparql-expression.c"
		} else {
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14846 "tracker-sparql-expression.c"
		}
	}
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14853 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GString* _tmp9_;
	TrackerPropertyType _tmp10_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14878 "tracker-sparql-expression.c"
		} else {
#line 1462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14886 "tracker-sparql-expression.c"
		}
	}
#line 1464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 14893 "tracker-sparql-expression.c"
		GString* _tmp1_;
		TrackerSparqlPattern* _tmp2_;
		TrackerSparqlPattern* _tmp3_;
		GString* _tmp4_;
		TrackerSparqlSelectContext* _tmp5_ = NULL;
		TrackerSparqlSelectContext* select_context;
		GString* _tmp6_;
		TrackerSparqlSelectContext* _tmp7_;
		TrackerPropertyType _tmp8_;
#line 1467 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 1467 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp1_, "(");
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp2_;
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = sql;
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = tracker_sparql_pattern_translate_select (_tmp3_, _tmp4_, TRUE, TRUE, &_inner_error_);
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		select_context = _tmp5_;
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14925 "tracker-sparql-expression.c"
			} else {
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14933 "tracker-sparql-expression.c"
			}
		}
#line 1469 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 1469 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp6_, ")");
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14952 "tracker-sparql-expression.c"
			} else {
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14962 "tracker-sparql-expression.c"
			}
		}
#line 1472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = select_context;
#line 1472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = _tmp7_->type;
#line 1472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _tmp8_;
#line 1472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tracker_sparql_context_unref0 (select_context);
#line 1472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 14975 "tracker-sparql-expression.c"
	}
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = sql;
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = tracker_sparql_expression_translate_expression (self, _tmp9_, &_inner_error_);
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp10_;
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14991 "tracker-sparql-expression.c"
		} else {
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14999 "tracker-sparql-expression.c"
		}
	}
#line 1476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15012 "tracker-sparql-expression.c"
		} else {
#line 1476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1476 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15020 "tracker-sparql-expression.c"
		}
	}
#line 1477 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1477 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 15027 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp3_;
	TrackerPropertyType _tmp4_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15053 "tracker-sparql-expression.c"
		} else {
#line 1481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1481 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15061 "tracker-sparql-expression.c"
		}
	}
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15076 "tracker-sparql-expression.c"
		} else {
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15084 "tracker-sparql-expression.c"
		}
	}
#line 1482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 15089 "tracker-sparql-expression.c"
		GString* _tmp2_;
#line 1483 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1483 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp2_, "DISTINCT ");
#line 15095 "tracker-sparql-expression.c"
	}
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp4_;
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15111 "tracker-sparql-expression.c"
		} else {
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15119 "tracker-sparql-expression.c"
		}
	}
#line 1486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15132 "tracker-sparql-expression.c"
		} else {
#line 1486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1486 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 15140 "tracker-sparql-expression.c"
		}
	}
#line 1487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 15147 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 1490 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1490 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 1491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 15191 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			TrackerPropertyType _tmp2_ = 0;
			TrackerPropertyType _tmp3_;
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_translate_primary_expression (self, _tmp1_, &_inner_error_);
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 15210 "tracker-sparql-expression.c"
				} else {
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 15218 "tracker-sparql-expression.c"
				}
			}
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp3_;
#line 1506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 15225 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp4_;
			TrackerPropertyType _tmp5_ = 0;
			TrackerPropertyType _tmp6_;
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_translate_bracketted_expression (self, _tmp4_, &_inner_error_);
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 15246 "tracker-sparql-expression.c"
				} else {
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 15254 "tracker-sparql-expression.c"
				}
			}
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp6_;
#line 1508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 15261 "tracker-sparql-expression.c"
		}
	}
}


static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self) {
	TrackerSparqlContext* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 36 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 36 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->context;
#line 36 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 36 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 15281 "tracker-sparql-expression.c"
}


static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self) {
	TrackerSparqlPattern* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
#line 40 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 40 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->pattern;
#line 40 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 40 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 15299 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_class_init (TrackerSparqlExpressionClass * klass) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlExpressionPrivate));
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_expression_get_property;
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_expression_finalize;
#line 15312 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_instance_init (TrackerSparqlExpression * self) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv = TRACKER_SPARQL_EXPRESSION_GET_PRIVATE (self);
#line 15319 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_finalize (GObject* obj) {
	TrackerSparqlExpression * self;
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression);
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (self->priv->fts_sql);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (tracker_sparql_expression_parent_class)->finalize (obj);
#line 15331 "tracker-sparql-expression.c"
}


GType tracker_sparql_expression_get_type (void) {
	static volatile gsize tracker_sparql_expression_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlExpression), 0, (GInstanceInitFunc) tracker_sparql_expression_instance_init, NULL };
		GType tracker_sparql_expression_type_id;
		tracker_sparql_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlExpression", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_expression_type_id__volatile, tracker_sparql_expression_type_id);
	}
	return tracker_sparql_expression_type_id__volatile;
}


static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (property_id) {
#line 15352 "tracker-sparql-expression.c"
		default:
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 15358 "tracker-sparql-expression.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



