/* tracker-sparql-scanner.c generated by valac 0.11.4, the Vala compiler
 * generated from tracker-sparql-scanner.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdlib.h>
#include <string.h>


#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;
typedef struct _TrackerSparqlScannerPrivate TrackerSparqlScannerPrivate;

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

struct _TrackerSparqlScanner {
	GObject parent_instance;
	TrackerSparqlScannerPrivate * priv;
};

struct _TrackerSparqlScannerClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlScannerPrivate {
	gchar* current;
	gchar* end;
	gint line;
	gint column;
};

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;


static gpointer tracker_sparql_scanner_parent_class = NULL;

GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerPrivate))
enum  {
	TRACKER_SPARQL_SCANNER_DUMMY_PROPERTY
};
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self, gchar* begin, gint len);
static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self, gchar* begin, const gchar* keyword);
static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self, gchar c);
static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self, gchar c);
static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self, gchar c);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
static void tracker_sparql_scanner_space (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self);
static void tracker_sparql_scanner_finalize (GObject* obj);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);


TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len) {
	TrackerSparqlScanner * self = NULL;
	gchar* begin;
	self = (TrackerSparqlScanner*) g_object_new (object_type, NULL);
	begin = input;
	self->priv->end = begin + len;
	self->priv->current = begin;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}


TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len) {
	return tracker_sparql_scanner_construct (TRACKER_TYPE_SPARQL_SCANNER, input, len);
}


void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location) {
	g_return_if_fail (self != NULL);
	self->priv->current = (*location).pos;
	self->priv->line = (*location).line;
	self->priv->column = (*location).column;
}


static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self, gchar* begin, gint len) {
	TrackerSparqlTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (len) {
		case 1:
		{
			switch (begin[0]) {
				case 'A':
				case 'a':
				{
					result = TRACKER_SPARQL_TOKEN_TYPE_A;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 2:
		{
			switch (begin[0]) {
				case 'A':
				case 'a':
				{
					gboolean _tmp0_;
					_tmp0_ = tracker_sparql_scanner_matches (self, begin, "AS");
					if (_tmp0_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'B':
				case 'b':
				{
					gboolean _tmp1_;
					_tmp1_ = tracker_sparql_scanner_matches (self, begin, "BY");
					if (_tmp1_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_BY;
						return result;
					}
					break;
				}
				case 'i':
				case 'I':
				{
					switch (begin[1]) {
						case 'F':
						case 'f':
						{
							gboolean _tmp2_;
							_tmp2_ = tracker_sparql_scanner_matches (self, begin, "IF");
							if (_tmp2_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_IF;
								return result;
							}
							break;
						}
						case 'N':
						case 'n':
						{
							gboolean _tmp3_;
							_tmp3_ = tracker_sparql_scanner_matches (self, begin, "IN");
							if (_tmp3_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_OP_IN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'O':
				case 'o':
				{
					gboolean _tmp4_;
					_tmp4_ = tracker_sparql_scanner_matches (self, begin, "OR");
					if (_tmp4_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_OR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			switch (begin[0]) {
				case 'A':
				case 'a':
				{
					switch (begin[1]) {
						case 'S':
						case 's':
						{
							switch (begin[2]) {
								case 'C':
								case 'c':
								{
									gboolean _tmp5_;
									_tmp5_ = tracker_sparql_scanner_matches (self, begin, "ASC");
									if (_tmp5_) {
										result = TRACKER_SPARQL_TOKEN_TYPE_ASC;
										return result;
									}
									break;
								}
								case 'K':
								case 'k':
								{
									gboolean _tmp6_;
									_tmp6_ = tracker_sparql_scanner_matches (self, begin, "ASK");
									if (_tmp6_) {
										result = TRACKER_SPARQL_TOKEN_TYPE_ASK;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 'V':
						case 'v':
						{
							gboolean _tmp7_;
							_tmp7_ = tracker_sparql_scanner_matches (self, begin, "AVG");
							if (_tmp7_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_AVG;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'M':
				case 'm':
				{
					switch (begin[1]) {
						case 'A':
						case 'a':
						{
							gboolean _tmp8_;
							_tmp8_ = tracker_sparql_scanner_matches (self, begin, "MAX");
							if (_tmp8_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_MAX;
								return result;
							}
							break;
						}
						case 'I':
						case 'i':
						{
							gboolean _tmp9_;
							_tmp9_ = tracker_sparql_scanner_matches (self, begin, "MIN");
							if (_tmp9_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_MIN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'N':
				case 'n':
				{
					gboolean _tmp10_;
					_tmp10_ = tracker_sparql_scanner_matches (self, begin, "NOT");
					if (_tmp10_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_NOT;
						return result;
					}
					break;
				}
				case 'S':
				case 's':
				{
					switch (begin[1]) {
						case 'T':
						case 't':
						{
							gboolean _tmp11_;
							_tmp11_ = tracker_sparql_scanner_matches (self, begin, "STR");
							if (_tmp11_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_STR;
								return result;
							}
							break;
						}
						case 'U':
						case 'u':
						{
							gboolean _tmp12_;
							_tmp12_ = tracker_sparql_scanner_matches (self, begin, "SUM");
							if (_tmp12_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_SUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			switch (begin[0]) {
				case 'B':
				case 'b':
				{
					gboolean _tmp13_;
					_tmp13_ = tracker_sparql_scanner_matches (self, begin, "BASE");
					if (_tmp13_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_BASE;
						return result;
					}
					break;
				}
				case 'D':
				case 'd':
				{
					switch (begin[1]) {
						case 'A':
						case 'a':
						{
							gboolean _tmp14_;
							_tmp14_ = tracker_sparql_scanner_matches (self, begin, "DATA");
							if (_tmp14_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_DATA;
								return result;
							}
							break;
						}
						case 'E':
						case 'e':
						{
							gboolean _tmp15_;
							_tmp15_ = tracker_sparql_scanner_matches (self, begin, "DESC");
							if (_tmp15_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_DESC;
								return result;
							}
							break;
						}
						case 'R':
						case 'r':
						{
							gboolean _tmp16_;
							_tmp16_ = tracker_sparql_scanner_matches (self, begin, "DROP");
							if (_tmp16_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_DROP;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'F':
				case 'f':
				{
					gboolean _tmp17_;
					_tmp17_ = tracker_sparql_scanner_matches (self, begin, "FROM");
					if (_tmp17_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_FROM;
						return result;
					}
					break;
				}
				case 'I':
				case 'i':
				{
					gboolean _tmp18_;
					_tmp18_ = tracker_sparql_scanner_matches (self, begin, "INTO");
					if (_tmp18_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_INTO;
						return result;
					}
					break;
				}
				case 'L':
				case 'l':
				{
					gboolean _tmp19_;
					_tmp19_ = tracker_sparql_scanner_matches (self, begin, "LANG");
					if (_tmp19_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_LANG;
						return result;
					}
					break;
				}
				case 'T':
				case 't':
				{
					gboolean _tmp20_;
					_tmp20_ = tracker_sparql_scanner_matches (self, begin, "TRUE");
					if (_tmp20_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_TRUE;
						return result;
					}
					break;
				}
				case 'W':
				case 'w':
				{
					gboolean _tmp21_;
					_tmp21_ = tracker_sparql_scanner_matches (self, begin, "WITH");
					if (_tmp21_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_WITH;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			switch (begin[0]) {
				case 'B':
				case 'b':
				{
					gboolean _tmp22_;
					_tmp22_ = tracker_sparql_scanner_matches (self, begin, "BOUND");
					if (_tmp22_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_BOUND;
						return result;
					}
					break;
				}
				case 'C':
				case 'c':
				{
					gboolean _tmp23_;
					_tmp23_ = tracker_sparql_scanner_matches (self, begin, "COUNT");
					if (_tmp23_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_COUNT;
						return result;
					}
					break;
				}
				case 'G':
				case 'g':
				{
					switch (begin[2]) {
						case 'A':
						case 'a':
						{
							gboolean _tmp24_;
							_tmp24_ = tracker_sparql_scanner_matches (self, begin, "GRAPH");
							if (_tmp24_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
								return result;
							}
							break;
						}
						case 'O':
						case 'o':
						{
							gboolean _tmp25_;
							_tmp25_ = tracker_sparql_scanner_matches (self, begin, "GROUP");
							if (_tmp25_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_GROUP;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'L':
				case 'l':
				{
					gboolean _tmp26_;
					_tmp26_ = tracker_sparql_scanner_matches (self, begin, "LIMIT");
					if (_tmp26_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
						return result;
					}
					break;
				}
				case 'N':
				case 'n':
				{
					gboolean _tmp27_;
					_tmp27_ = tracker_sparql_scanner_matches (self, begin, "NAMED");
					if (_tmp27_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_NAMED;
						return result;
					}
					break;
				}
				case 'O':
				case 'o':
				{
					gboolean _tmp28_;
					_tmp28_ = tracker_sparql_scanner_matches (self, begin, "ORDER");
					if (_tmp28_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_ORDER;
						return result;
					}
					break;
				}
				case 'R':
				case 'r':
				{
					gboolean _tmp29_;
					_tmp29_ = tracker_sparql_scanner_matches (self, begin, "REGEX");
					if (_tmp29_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_REGEX;
						return result;
					}
					break;
				}
				case 'U':
				case 'u':
				{
					gboolean _tmp30_;
					_tmp30_ = tracker_sparql_scanner_matches (self, begin, "UNION");
					if (_tmp30_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_UNION;
						return result;
					}
					break;
				}
				case 'W':
				case 'w':
				{
					gboolean _tmp31_;
					_tmp31_ = tracker_sparql_scanner_matches (self, begin, "WHERE");
					if (_tmp31_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_WHERE;
						return result;
					}
					break;
				}
				case 'F':
				case 'f':
				{
					gboolean _tmp32_;
					_tmp32_ = tracker_sparql_scanner_matches (self, begin, "FALSE");
					if (_tmp32_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_FALSE;
						return result;
					}
					break;
				}
				case 'I':
				case 'i':
				{
					switch (begin[1]) {
						case 'S':
						case 's':
						{
							switch (begin[2]) {
								case 'I':
								case 'i':
								{
									gboolean _tmp33_;
									_tmp33_ = tracker_sparql_scanner_matches (self, begin, "ISIRI");
									if (_tmp33_) {
										result = TRACKER_SPARQL_TOKEN_TYPE_ISIRI;
										return result;
									}
									break;
								}
								case 'U':
								case 'u':
								{
									gboolean _tmp34_;
									_tmp34_ = tracker_sparql_scanner_matches (self, begin, "ISURI");
									if (_tmp34_) {
										result = TRACKER_SPARQL_TOKEN_TYPE_ISURI;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			switch (begin[0]) {
				case 'D':
				case 'd':
				{
					gboolean _tmp35_;
					_tmp35_ = tracker_sparql_scanner_matches (self, begin, "DELETE");
					if (_tmp35_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_DELETE;
						return result;
					}
					break;
				}
				case 'E':
				case 'e':
				{
					gboolean _tmp36_;
					_tmp36_ = tracker_sparql_scanner_matches (self, begin, "EXISTS");
					if (_tmp36_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_EXISTS;
						return result;
					}
					break;
				}
				case 'F':
				case 'f':
				{
					gboolean _tmp37_;
					_tmp37_ = tracker_sparql_scanner_matches (self, begin, "FILTER");
					if (_tmp37_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_FILTER;
						return result;
					}
					break;
				}
				case 'I':
				case 'i':
				{
					gboolean _tmp38_;
					_tmp38_ = tracker_sparql_scanner_matches (self, begin, "INSERT");
					if (_tmp38_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_INSERT;
						return result;
					}
					break;
				}
				case 'O':
				case 'o':
				{
					gboolean _tmp39_;
					_tmp39_ = tracker_sparql_scanner_matches (self, begin, "OFFSET");
					if (_tmp39_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
						return result;
					}
					break;
				}
				case 'P':
				case 'p':
				{
					gboolean _tmp40_;
					_tmp40_ = tracker_sparql_scanner_matches (self, begin, "PREFIX");
					if (_tmp40_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_PREFIX;
						return result;
					}
					break;
				}
				case 'S':
				case 's':
				{
					switch (begin[1]) {
						case 'E':
						case 'e':
						{
							gboolean _tmp41_;
							_tmp41_ = tracker_sparql_scanner_matches (self, begin, "SELECT");
							if (_tmp41_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_SELECT;
								return result;
							}
							break;
						}
						case 'I':
						case 'i':
						{
							gboolean _tmp42_;
							_tmp42_ = tracker_sparql_scanner_matches (self, begin, "SILENT");
							if (_tmp42_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_SILENT;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			switch (begin[0]) {
				case 'R':
				case 'r':
				{
					switch (begin[2]) {
						case 'D':
						case 'd':
						{
							gboolean _tmp43_;
							_tmp43_ = tracker_sparql_scanner_matches (self, begin, "REDUCED");
							if (_tmp43_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_REDUCED;
								return result;
							}
							break;
						}
						case 'P':
						case 'p':
						{
							gboolean _tmp44_;
							_tmp44_ = tracker_sparql_scanner_matches (self, begin, "REPLACE");
							if (_tmp44_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_REPLACE;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'I':
				case 'i':
				{
					gboolean _tmp45_;
					_tmp45_ = tracker_sparql_scanner_matches (self, begin, "ISBLANK");
					if (_tmp45_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_ISBLANK;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			switch (begin[0]) {
				case 'D':
				case 'd':
				{
					switch (begin[1]) {
						case 'A':
						case 'a':
						{
							gboolean _tmp46_;
							_tmp46_ = tracker_sparql_scanner_matches (self, begin, "DATATYPE");
							if (_tmp46_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_DATATYPE;
								return result;
							}
							break;
						}
						case 'E':
						case 'e':
						{
							gboolean _tmp47_;
							_tmp47_ = tracker_sparql_scanner_matches (self, begin, "DESCRIBE");
							if (_tmp47_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE;
								return result;
							}
							break;
						}
						case 'I':
						case 'i':
						{
							gboolean _tmp48_;
							_tmp48_ = tracker_sparql_scanner_matches (self, begin, "DISTINCT");
							if (_tmp48_) {
								result = TRACKER_SPARQL_TOKEN_TYPE_DISTINCT;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'O':
				case 'o':
				{
					gboolean _tmp49_;
					_tmp49_ = tracker_sparql_scanner_matches (self, begin, "OPTIONAL");
					if (_tmp49_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL;
						return result;
					}
					break;
				}
				case 'S':
				case 's':
				{
					gboolean _tmp50_;
					_tmp50_ = tracker_sparql_scanner_matches (self, begin, "SAMETERM");
					if (_tmp50_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_SAMETERM;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			switch (begin[0]) {
				case 'C':
				case 'c':
				{
					gboolean _tmp51_;
					_tmp51_ = tracker_sparql_scanner_matches (self, begin, "CONSTRUCT");
					if (_tmp51_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'I':
				case 'i':
				{
					gboolean _tmp52_;
					_tmp52_ = tracker_sparql_scanner_matches (self, begin, "ISLITERAL");
					if (_tmp52_) {
						result = TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 11:
		{
			gboolean _tmp53_;
			_tmp53_ = tracker_sparql_scanner_matches (self, begin, "LANGMATCHES");
			if (_tmp53_) {
				result = TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES;
				return result;
			}
			break;
		}
		case 12:
		{
			gboolean _tmp54_;
			_tmp54_ = tracker_sparql_scanner_matches (self, begin, "GROUP_CONCAT");
			if (_tmp54_) {
				result = TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
	return result;
}


static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	type = TRACKER_SPARQL_TOKEN_TYPE_INTEGER;
	if (self->priv->current < (self->priv->end - 2)) {
		_tmp2_ = self->priv->current[0] == '0';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->current[1] == 'x';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp3_;
		_tmp3_ = g_ascii_isxdigit (self->priv->current[2]);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->current = self->priv->current + 2;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			if (self->priv->current < self->priv->end) {
				gboolean _tmp5_;
				_tmp5_ = g_ascii_isxdigit (self->priv->current[0]);
				_tmp4_ = _tmp5_;
			} else {
				_tmp4_ = FALSE;
			}
			if (!_tmp4_) {
				break;
			}
			self->priv->current++;
		}
	} else {
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			if (self->priv->current < self->priv->end) {
				gboolean _tmp7_;
				_tmp7_ = g_ascii_isdigit (self->priv->current[0]);
				_tmp6_ = _tmp7_;
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
			self->priv->current++;
		}
	}
	if (self->priv->current < (self->priv->end - 1)) {
		_tmp9_ = self->priv->current[0] == '.';
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp10_;
		_tmp10_ = g_ascii_isdigit (self->priv->current[1]);
		_tmp8_ = _tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
		self->priv->current++;
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			if (self->priv->current < self->priv->end) {
				gboolean _tmp12_;
				_tmp12_ = g_ascii_isdigit (self->priv->current[0]);
				_tmp11_ = _tmp12_;
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			self->priv->current++;
		}
	}
	if (self->priv->current < self->priv->end) {
		gchar _tmp14_;
		_tmp14_ = g_ascii_tolower (self->priv->current[0]);
		_tmp13_ = _tmp14_ == 'e';
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gboolean _tmp15_ = FALSE;
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
		self->priv->current++;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp16_ = FALSE;
			if (self->priv->current[0] == '+') {
				_tmp16_ = TRUE;
			} else {
				_tmp16_ = self->priv->current[0] == '-';
			}
			_tmp15_ = _tmp16_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			self->priv->current++;
		}
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			if (self->priv->current < self->priv->end) {
				gboolean _tmp18_;
				_tmp18_ = g_ascii_isdigit (self->priv->current[0]);
				_tmp17_ = _tmp18_;
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			self->priv->current++;
		}
	}
	if (self->priv->current < self->priv->end) {
		switch (self->priv->current[0]) {
			case 'l':
			case 'L':
			{
				if (type == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
					gboolean _tmp19_ = FALSE;
					self->priv->current++;
					if (self->priv->current < self->priv->end) {
						gchar _tmp20_;
						_tmp20_ = g_ascii_tolower (self->priv->current[0]);
						_tmp19_ = _tmp20_ == 'l';
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						self->priv->current++;
					}
				}
				break;
			}
			case 'u':
			case 'U':
			{
				if (type == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
					gboolean _tmp21_ = FALSE;
					self->priv->current++;
					if (self->priv->current < self->priv->end) {
						gchar _tmp22_;
						_tmp22_ = g_ascii_tolower (self->priv->current[0]);
						_tmp21_ = _tmp22_ == 'l';
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						gboolean _tmp23_ = FALSE;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							gchar _tmp24_;
							_tmp24_ = g_ascii_tolower (self->priv->current[0]);
							_tmp23_ = _tmp24_ == 'l';
						} else {
							_tmp23_ = FALSE;
						}
						if (_tmp23_) {
							self->priv->current++;
						}
					}
				}
				break;
			}
			case 'f':
			case 'F':
			case 'd':
			case 'D':
			{
				type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
				self->priv->current++;
				break;
			}
			default:
			break;
		}
	}
	result = type;
	return result;
}


static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = g_ascii_isalnum (c);
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = c == '_';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '-';
	}
	result = _tmp0_;
	return result;
}


static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = g_ascii_isalnum (c);
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = c == '_';
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = c == '-';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '.';
	}
	result = _tmp0_;
	return result;
}


static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = g_ascii_isalnum (c);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}


TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error) {
	TrackerSourceLocation _token_begin = {0};
	TrackerSourceLocation _token_end = {0};
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type = 0;
	gchar* begin;
	gint token_length_in_chars;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	tracker_sparql_scanner_space (self);
	begin = self->priv->current;
	_token_begin.pos = begin;
	_token_begin.line = self->priv->line;
	_token_begin.column = self->priv->column;
	token_length_in_chars = -1;
	if (self->priv->current >= self->priv->end) {
		type = TRACKER_SPARQL_TOKEN_TYPE_EOF;
	} else {
		gboolean _tmp0_;
		_tmp0_ = g_ascii_isalpha (self->priv->current[0]);
		if (_tmp0_) {
			gint len;
			TrackerSparqlTokenType _tmp3_;
			len = 0;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				if (self->priv->current < self->priv->end) {
					gboolean _tmp2_;
					_tmp2_ = tracker_sparql_scanner_is_pn_char (self, self->priv->current[0]);
					_tmp1_ = _tmp2_;
				} else {
					_tmp1_ = FALSE;
				}
				if (!_tmp1_) {
					break;
				}
				self->priv->current++;
				len++;
			}
			_tmp3_ = tracker_sparql_scanner_get_identifier_or_keyword (self, begin, len);
			type = _tmp3_;
		} else {
			gboolean _tmp4_;
			_tmp4_ = g_ascii_isdigit (self->priv->current[0]);
			if (_tmp4_) {
				TrackerSparqlTokenType _tmp5_;
				_tmp5_ = tracker_sparql_scanner_read_number (self);
				type = _tmp5_;
			} else {
				switch (self->priv->current[0]) {
					case '{':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE;
						self->priv->current++;
						break;
					}
					case '}':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
						self->priv->current++;
						break;
					}
					case '(':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS;
						self->priv->current++;
						break;
					}
					case ')':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
						self->priv->current++;
						break;
					}
					case '[':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
						self->priv->current++;
						break;
					}
					case ']':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET;
						self->priv->current++;
						break;
					}
					case '.':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_DOT;
						self->priv->current++;
						break;
					}
					case ':':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_COLON;
						self->priv->current++;
						while (TRUE) {
							gboolean _tmp6_ = FALSE;
							if (self->priv->current < self->priv->end) {
								gboolean _tmp7_;
								_tmp7_ = tracker_sparql_scanner_is_pn_local_char (self, self->priv->current[0]);
								_tmp6_ = _tmp7_;
							} else {
								_tmp6_ = FALSE;
							}
							if (!_tmp6_) {
								break;
							}
							self->priv->current++;
						}
						if (self->priv->current[-1] == '.') {
							self->priv->current--;
						}
						break;
					}
					case ',':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_COMMA;
						self->priv->current++;
						break;
					}
					case ';':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON;
						self->priv->current++;
						break;
					}
					case '?':
					case '$':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
						self->priv->current++;
						while (TRUE) {
							gboolean _tmp8_ = FALSE;
							if (self->priv->current < self->priv->end) {
								gboolean _tmp9_;
								_tmp9_ = tracker_sparql_scanner_is_varname_char (self, self->priv->current[0]);
								_tmp8_ = _tmp9_;
							} else {
								_tmp8_ = FALSE;
							}
							if (!_tmp8_) {
								break;
							}
							type = TRACKER_SPARQL_TOKEN_TYPE_VAR;
							self->priv->current++;
						}
						break;
					}
					case '@':
					{
						gboolean _tmp10_ = FALSE;
						gint _tmp11_;
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
						self->priv->current++;
						_tmp11_ = strlen ("prefix");
						if (self->priv->current < (self->priv->end - _tmp11_)) {
							gboolean _tmp12_;
							_tmp12_ = tracker_sparql_scanner_matches (self, self->priv->current, "PREFIX");
							_tmp10_ = _tmp12_;
						} else {
							_tmp10_ = FALSE;
						}
						if (_tmp10_) {
							gint _tmp13_;
							type = TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX;
							_tmp13_ = strlen ("prefix");
							self->priv->current = self->priv->current + _tmp13_;
						} else {
							gboolean _tmp14_ = FALSE;
							gint _tmp15_;
							_tmp15_ = strlen ("base");
							if (self->priv->current < (self->priv->end - _tmp15_)) {
								gboolean _tmp16_;
								_tmp16_ = tracker_sparql_scanner_matches (self, self->priv->current, "BASE");
								_tmp14_ = _tmp16_;
							} else {
								_tmp14_ = FALSE;
							}
							if (_tmp14_) {
								gint _tmp17_;
								type = TRACKER_SPARQL_TOKEN_TYPE_ATBASE;
								_tmp17_ = strlen ("base");
								self->priv->current = self->priv->current + _tmp17_;
							}
						}
						break;
					}
					case '|':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							switch (self->priv->current[0]) {
								case '|':
								{
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_OR;
									self->priv->current++;
									break;
								}
								default:
								break;
							}
						}
						break;
					}
					case '&':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							switch (self->priv->current[0]) {
								case '&':
								{
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_AND;
									self->priv->current++;
									break;
								}
								default:
								break;
							}
						}
						break;
					}
					case '=':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_EQ;
						self->priv->current++;
						break;
					}
					case '<':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_LT;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							gboolean _tmp20_ = FALSE;
							while (TRUE) {
								gboolean _tmp18_ = FALSE;
								gboolean _tmp19_ = FALSE;
								if (self->priv->current < self->priv->end) {
									_tmp18_ = self->priv->current[0] != '>';
								} else {
									_tmp18_ = FALSE;
								}
								if (!_tmp18_) {
									break;
								}
								if (self->priv->current[0] >= 0x00) {
									_tmp19_ = self->priv->current[0] < 0x20;
								} else {
									_tmp19_ = FALSE;
								}
								if (_tmp19_) {
									break;
								}
								switch (self->priv->current[0]) {
									case '<':
									case '>':
									case '"':
									case ' ':
									case '{':
									case '}':
									case '|':
									case '^':
									case '`':
									case '\\':
									{
										break;
									}
									default:
									{
										self->priv->current++;
										continue;
									}
								}
								break;
							}
							if (self->priv->current < self->priv->end) {
								_tmp20_ = self->priv->current[0] == '>';
							} else {
								_tmp20_ = FALSE;
							}
							if (_tmp20_) {
								type = TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
								self->priv->current++;
								break;
							} else {
								self->priv->current = begin + 1;
							}
							switch (self->priv->current[0]) {
								case '=':
								{
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_LE;
									self->priv->current++;
									break;
								}
								default:
								break;
							}
						}
						break;
					}
					case '>':
					{
						gboolean _tmp21_ = FALSE;
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_GT;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							_tmp21_ = self->priv->current[0] == '=';
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_GE;
							self->priv->current++;
						}
						break;
					}
					case '!':
					{
						gboolean _tmp22_ = FALSE;
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_NEG;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							_tmp22_ = self->priv->current[0] == '=';
						} else {
							_tmp22_ = FALSE;
						}
						if (_tmp22_) {
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_NE;
							self->priv->current++;
						}
						break;
					}
					case '+':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_PLUS;
						self->priv->current++;
						break;
					}
					case '-':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_MINUS;
						self->priv->current++;
						break;
					}
					case '*':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_STAR;
						self->priv->current++;
						break;
					}
					case '/':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_DIV;
						self->priv->current++;
						break;
					}
					case '\'':
					case '"':
					{
						gboolean _tmp23_ = FALSE;
						gboolean _tmp24_ = FALSE;
						gboolean _tmp42_ = FALSE;
						if (self->priv->current < (self->priv->end - 6)) {
							_tmp24_ = begin[1] == begin[0];
						} else {
							_tmp24_ = FALSE;
						}
						if (_tmp24_) {
							_tmp23_ = begin[2] == begin[0];
						} else {
							_tmp23_ = FALSE;
						}
						if (_tmp23_) {
							gboolean _tmp30_ = FALSE;
							gboolean _tmp31_ = FALSE;
							if (begin[0] == '\'') {
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1;
							} else {
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2;
							}
							token_length_in_chars = 6;
							self->priv->current = self->priv->current + 3;
							while (TRUE) {
								gboolean _tmp25_ = FALSE;
								gboolean _tmp26_ = FALSE;
								if (!(self->priv->current < (self->priv->end - 4))) {
									break;
								}
								if (self->priv->current[0] == begin[0]) {
									_tmp26_ = self->priv->current[1] == begin[0];
								} else {
									_tmp26_ = FALSE;
								}
								if (_tmp26_) {
									_tmp25_ = self->priv->current[2] == begin[0];
								} else {
									_tmp25_ = FALSE;
								}
								if (_tmp25_) {
									break;
								} else {
									if (self->priv->current[0] == '\n') {
										self->priv->current++;
										self->priv->line++;
										self->priv->column = 1;
										token_length_in_chars = 3;
									} else {
										if (((guchar) self->priv->current[0]) <= 0x7f) {
											self->priv->current++;
											token_length_in_chars++;
										} else {
											gunichar _tmp27_;
											gunichar u;
											_tmp27_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
											u = _tmp27_;
											if (u != ((gunichar) (-1))) {
												gint _tmp28_;
												_tmp28_ = g_unichar_to_utf8 (u, NULL);
												self->priv->current = self->priv->current + _tmp28_;
												token_length_in_chars++;
											} else {
												GError* _tmp29_ = NULL;
												_tmp29_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", self->priv->line, self->priv->column + token_length_in_chars);
												_inner_error_ = _tmp29_;
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
										}
									}
								}
							}
							if (self->priv->current[0] == begin[0]) {
								_tmp31_ = self->priv->current[1] == begin[0];
							} else {
								_tmp31_ = FALSE;
							}
							if (_tmp31_) {
								_tmp30_ = self->priv->current[2] == begin[0];
							} else {
								_tmp30_ = FALSE;
							}
							if (_tmp30_) {
								self->priv->current = self->priv->current + 3;
							} else {
								GError* _tmp32_ = NULL;
								_tmp32_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected \"\"\"", self->priv->line, self->priv->column + token_length_in_chars);
								_inner_error_ = _tmp32_;
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							break;
						}
						if (begin[0] == '\'') {
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1;
						} else {
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2;
						}
						token_length_in_chars = 2;
						self->priv->current++;
						while (TRUE) {
							gboolean _tmp33_ = FALSE;
							if (self->priv->current < self->priv->end) {
								_tmp33_ = self->priv->current[0] != begin[0];
							} else {
								_tmp33_ = FALSE;
							}
							if (!_tmp33_) {
								break;
							}
							if (self->priv->current[0] == '\\') {
								self->priv->current++;
								token_length_in_chars++;
								if (self->priv->current >= self->priv->end) {
									break;
								}
								switch (self->priv->current[0]) {
									case '\'':
									case '"':
									case '\\':
									case 'b':
									case 'f':
									case 'n':
									case 'r':
									case 't':
									{
										self->priv->current++;
										token_length_in_chars++;
										break;
									}
									case 'u':
									{
										{
											gint i;
											i = 0;
											{
												gboolean _tmp34_;
												_tmp34_ = TRUE;
												while (TRUE) {
													gboolean _tmp35_ = FALSE;
													if (!_tmp34_) {
														i++;
													}
													_tmp34_ = FALSE;
													if (!(i < 4)) {
														break;
													}
													if (((self->priv->current + i) + 1) >= self->priv->end) {
														_tmp35_ = TRUE;
													} else {
														gboolean _tmp36_;
														_tmp36_ = g_ascii_isxdigit (self->priv->current[i + 1]);
														_tmp35_ = !_tmp36_;
													}
													if (_tmp35_) {
														GError* _tmp37_ = NULL;
														_tmp37_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", self->priv->line, self->priv->column + token_length_in_chars);
														_inner_error_ = _tmp37_;
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
												}
											}
										}
										self->priv->current = self->priv->current + 5;
										token_length_in_chars = token_length_in_chars + 5;
										break;
									}
									default:
									{
										GError* _tmp38_ = NULL;
										_tmp38_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", self->priv->line, self->priv->column + token_length_in_chars);
										_inner_error_ = _tmp38_;
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
								}
							} else {
								if (self->priv->current[0] == '\n') {
									break;
								} else {
									if (((guchar) self->priv->current[0]) <= 0x7f) {
										self->priv->current++;
										token_length_in_chars++;
									} else {
										gunichar _tmp39_;
										gunichar u;
										_tmp39_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
										u = _tmp39_;
										if (u != ((gunichar) (-1))) {
											gint _tmp40_;
											_tmp40_ = g_unichar_to_utf8 (u, NULL);
											self->priv->current = self->priv->current + _tmp40_;
											token_length_in_chars++;
										} else {
											GError* _tmp41_ = NULL;
											self->priv->current++;
											_tmp41_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", self->priv->line, self->priv->column + token_length_in_chars);
											_inner_error_ = _tmp41_;
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
									}
								}
							}
						}
						if (self->priv->current < self->priv->end) {
							_tmp42_ = self->priv->current[0] != '\n';
						} else {
							_tmp42_ = FALSE;
						}
						if (_tmp42_) {
							self->priv->current++;
						} else {
							GError* _tmp43_ = NULL;
							_tmp43_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected %c", self->priv->line, self->priv->column + token_length_in_chars, begin[0]);
							_inner_error_ = _tmp43_;
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						break;
					}
					case '^':
					{
						gboolean _tmp44_ = FALSE;
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
						if (self->priv->current < (self->priv->end - 2)) {
							_tmp44_ = self->priv->current[0] == self->priv->current[1];
						} else {
							_tmp44_ = FALSE;
						}
						if (_tmp44_) {
							type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX;
							self->priv->current = self->priv->current + 2;
						} else {
							GError* _tmp45_ = NULL;
							_tmp45_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", self->priv->line, self->priv->column);
							_inner_error_ = _tmp45_;
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						break;
					}
					case '_':
					{
						type = TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE;
						self->priv->current++;
						break;
					}
					default:
					{
						gunichar _tmp46_;
						gunichar u;
						_tmp46_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
						u = _tmp46_;
						if (u != ((gunichar) (-1))) {
							GError* _tmp47_ = NULL;
							_tmp47_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", self->priv->line, self->priv->column);
							_inner_error_ = _tmp47_;
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						} else {
							GError* _tmp48_ = NULL;
							_tmp48_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", self->priv->line, self->priv->column);
							_inner_error_ = _tmp48_;
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
					}
				}
			}
		}
	}
	if (token_length_in_chars < 0) {
		self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_token_end.pos = self->priv->current;
	_token_end.line = self->priv->line;
	_token_end.column = self->priv->column - 1;
	result = type;
	if (token_begin) {
		*token_begin = _token_begin;
	}
	if (token_end) {
		*token_end = _token_end;
	}
	return result;
}


static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self, gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	gchar* keyword_array;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = keyword;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(keyword_array[i] != 0)) {
					break;
				}
				_tmp1_ = g_ascii_toupper (begin[i]);
				if (_tmp1_ != keyword_array[i]) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp1_;
			_tmp1_ = g_ascii_isspace (self->priv->current[0]);
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		if (self->priv->current[0] == '\n') {
			self->priv->line++;
			self->priv->column = 0;
		}
		found = TRUE;
		self->priv->current++;
		self->priv->column++;
	}
	result = found;
	return result;
}


static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current >= self->priv->end) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current[0] != '#';
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp1_ = self->priv->current[0] != '\n';
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		self->priv->current++;
	}
	result = TRUE;
	return result;
}


static void tracker_sparql_scanner_space (TrackerSparqlScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = tracker_sparql_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = tracker_sparql_scanner_comment (self);
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static void tracker_sparql_scanner_class_init (TrackerSparqlScannerClass * klass) {
	tracker_sparql_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlScannerPrivate));
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_scanner_finalize;
}


static void tracker_sparql_scanner_instance_init (TrackerSparqlScanner * self) {
	self->priv = TRACKER_SPARQL_SCANNER_GET_PRIVATE (self);
}


static void tracker_sparql_scanner_finalize (GObject* obj) {
	TrackerSparqlScanner * self;
	self = TRACKER_SPARQL_SCANNER (obj);
	G_OBJECT_CLASS (tracker_sparql_scanner_parent_class)->finalize (obj);
}


GType tracker_sparql_scanner_get_type (void) {
	static volatile gsize tracker_sparql_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlScanner), 0, (GInstanceInitFunc) tracker_sparql_scanner_instance_init, NULL };
		GType tracker_sparql_scanner_type_id;
		tracker_sparql_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlScanner", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_scanner_type_id__volatile, tracker_sparql_scanner_type_id);
	}
	return tracker_sparql_scanner_type_id__volatile;
}


TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self) {
	TrackerSourceLocation* dup;
	dup = g_new0 (TrackerSourceLocation, 1);
	memcpy (dup, self, sizeof (TrackerSourceLocation));
	return dup;
}


void tracker_source_location_free (TrackerSourceLocation* self) {
	g_free (self);
}


GType tracker_source_location_get_type (void) {
	static volatile gsize tracker_source_location_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_source_location_type_id__volatile)) {
		GType tracker_source_location_type_id;
		tracker_source_location_type_id = g_boxed_type_register_static ("TrackerSourceLocation", (GBoxedCopyFunc) tracker_source_location_dup, (GBoxedFreeFunc) tracker_source_location_free);
		g_once_init_leave (&tracker_source_location_type_id__volatile, tracker_source_location_type_id);
	}
	return tracker_source_location_type_id__volatile;
}


const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self) {
	const gchar* result = NULL;
	switch (self) {
		case TRACKER_SPARQL_TOKEN_TYPE_A:
		{
			result = "`a'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_AS:
		{
			result = "`AS'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ASC:
		{
			result = "`ASC'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
		{
			result = "`ASK'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ATBASE:
		{
			result = "`@base'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX:
		{
			result = "`@prefix'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
		{
			result = "`AVG'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_BASE:
		{
			result = "`BASE'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE:
		{
			result = "blank node";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		{
			result = "`BOUND'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_BY:
		{
			result = "`BY'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE:
		{
			result = "`}'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET:
		{
			result = "`]'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
		{
			result = "`)'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			result = "`:'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COMMA:
		{
			result = "`,'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
		{
			result = "`CONSTRUCT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
		{
			result = "`COUNT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		{
			result = "`DATATYPE'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
		{
			result = "`DECIMAL'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
		{
			result = "`DELETE'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DESC:
		{
			result = "`DESC'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
		{
			result = "`DESCRIBE'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DISTINCT:
		{
			result = "`DISTINCT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
		{
			result = "`DOUBLE'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX:
		{
			result = "`^^'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
		{
			result = "`DROP'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_EOF:
		{
			result = "end of file";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
		{
			result = "`EXISTS'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
		{
			result = "`false'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_FILTER:
		{
			result = "`FILTER'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_FROM:
		{
			result = "`FROM'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_GRAPH:
		{
			result = "`GRAPH'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
		{
			result = "`GROUP'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
		{
			result = "`GROUP_CONCAT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
		{
			result = "`IF'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
		{
			result = "`INSERT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
		{
			result = "`INTEGER'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INTO:
		{
			result = "`INTO'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		{
			result = "IRI reference";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		{
			result = "`ISBLANK'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		{
			result = "`ISIRI'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		{
			result = "`ISLITERAL'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		{
			result = "`ISURI'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		{
			result = "`LANG'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		{
			result = "`LANGMATCHES'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
		{
			result = "`LIMIT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
		{
			result = "`MAX'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
		{
			result = "`MIN'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MINUS:
		{
			result = "`-'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_NAMED:
		{
			result = "`NAMED'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
		{
			result = "`NOT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
		{
			result = "`OFFSET'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_AND:
		{
			result = "`&&'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_EQ:
		{
			result = "`='";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GE:
		{
			result = "`>='";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GT:
		{
			result = "`>'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LE:
		{
			result = "`<='";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LT:
		{
			result = "`<'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NE:
		{
			result = "`!='";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NEG:
		{
			result = "`!'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_OR:
		{
			result = "`||'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OP_IN:
		{
			result = "`IN'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
		{
			result = "`{'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET:
		{
			result = "`['";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
		{
			result = "`('";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL:
		{
			result = "`OPTIONAL'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_OR:
		{
			result = "`OR'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
		{
			result = "`ORDER'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_PLUS:
		{
			result = "`+'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		{
			result = "prefixed name";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_PREFIX:
		{
			result = "`PREFIX'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_REDUCED:
		{
			result = "`REDUCED'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			result = "`REGEX'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_REPLACE:
		{
			result = "`REPLACE'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		{
			result = "`SAMETERM'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
		{
			result = "`SELECT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON:
		{
			result = "`;'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SILENT:
		{
			result = "`SILENT'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STAR:
		{
			result = "`*'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		{
			result = "`STR'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		{
			result = "string literal";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		{
			result = "string literal";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		{
			result = "string literal";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			result = "string literal";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
		{
			result = "`SUM'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
		{
			result = "`true'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_UNION:
		{
			result = "`UNION'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
		{
			result = "variable";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
		{
			result = "`WHERE'";
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_WITH:
		{
			result = "`WITH'";
			return result;
		}
		default:
		{
			result = "unknown token";
			return result;
		}
	}
}


GType tracker_sparql_token_type_get_type (void) {
	static volatile gsize tracker_sparql_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_TOKEN_TYPE_NONE, "TRACKER_SPARQL_TOKEN_TYPE_NONE", "none"}, {TRACKER_SPARQL_TOKEN_TYPE_A, "TRACKER_SPARQL_TOKEN_TYPE_A", "a"}, {TRACKER_SPARQL_TOKEN_TYPE_AS, "TRACKER_SPARQL_TOKEN_TYPE_AS", "as"}, {TRACKER_SPARQL_TOKEN_TYPE_ASC, "TRACKER_SPARQL_TOKEN_TYPE_ASC", "asc"}, {TRACKER_SPARQL_TOKEN_TYPE_ASK, "TRACKER_SPARQL_TOKEN_TYPE_ASK", "ask"}, {TRACKER_SPARQL_TOKEN_TYPE_ATBASE, "TRACKER_SPARQL_TOKEN_TYPE_ATBASE", "atbase"}, {TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, "TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX", "atprefix"}, {TRACKER_SPARQL_TOKEN_TYPE_AVG, "TRACKER_SPARQL_TOKEN_TYPE_AVG", "avg"}, {TRACKER_SPARQL_TOKEN_TYPE_BASE, "TRACKER_SPARQL_TOKEN_TYPE_BASE", "base"}, {TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, "TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE", "blank-node"}, {TRACKER_SPARQL_TOKEN_TYPE_BOUND, "TRACKER_SPARQL_TOKEN_TYPE_BOUND", "bound"}, {TRACKER_SPARQL_TOKEN_TYPE_BY, "TRACKER_SPARQL_TOKEN_TYPE_BY", "by"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_COLON, "TRACKER_SPARQL_TOKEN_TYPE_COLON", "colon"}, {TRACKER_SPARQL_TOKEN_TYPE_COMMA, "TRACKER_SPARQL_TOKEN_TYPE_COMMA", "comma"}, {TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT, "TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT", "construct"}, {TRACKER_SPARQL_TOKEN_TYPE_COUNT, "TRACKER_SPARQL_TOKEN_TYPE_COUNT", "count"}, {TRACKER_SPARQL_TOKEN_TYPE_DATA, "TRACKER_SPARQL_TOKEN_TYPE_DATA", "data"}, {TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, "TRACKER_SPARQL_TOKEN_TYPE_DATATYPE", "datatype"}, {TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, "TRACKER_SPARQL_TOKEN_TYPE_DECIMAL", "decimal"}, {TRACKER_SPARQL_TOKEN_TYPE_DELETE, "TRACKER_SPARQL_TOKEN_TYPE_DELETE", "delete"}, {TRACKER_SPARQL_TOKEN_TYPE_DESC, "TRACKER_SPARQL_TOKEN_TYPE_DESC", "desc"}, {TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE, "TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE", "describe"}, {TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, "TRACKER_SPARQL_TOKEN_TYPE_DISTINCT", "distinct"}, {TRACKER_SPARQL_TOKEN_TYPE_DIV, "TRACKER_SPARQL_TOKEN_TYPE_DIV", "div"}, {TRACKER_SPARQL_TOKEN_TYPE_DOT, "TRACKER_SPARQL_TOKEN_TYPE_DOT", "dot"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE", "double"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX", "double-circumflex"}, {TRACKER_SPARQL_TOKEN_TYPE_DROP, "TRACKER_SPARQL_TOKEN_TYPE_DROP", "drop"}, {TRACKER_SPARQL_TOKEN_TYPE_EOF, "TRACKER_SPARQL_TOKEN_TYPE_EOF", "eof"}, {TRACKER_SPARQL_TOKEN_TYPE_EXISTS, "TRACKER_SPARQL_TOKEN_TYPE_EXISTS", "exists"}, {TRACKER_SPARQL_TOKEN_TYPE_FALSE, "TRACKER_SPARQL_TOKEN_TYPE_FALSE", "false"}, {TRACKER_SPARQL_TOKEN_TYPE_FILTER, "TRACKER_SPARQL_TOKEN_TYPE_FILTER", "filter"}, {TRACKER_SPARQL_TOKEN_TYPE_FROM, "TRACKER_SPARQL_TOKEN_TYPE_FROM", "from"}, {TRACKER_SPARQL_TOKEN_TYPE_GRAPH, "TRACKER_SPARQL_TOKEN_TYPE_GRAPH", "graph"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP, "TRACKER_SPARQL_TOKEN_TYPE_GROUP", "group"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT", "group-concat"}, {TRACKER_SPARQL_TOKEN_TYPE_IF, "TRACKER_SPARQL_TOKEN_TYPE_IF", "if"}, {TRACKER_SPARQL_TOKEN_TYPE_INSERT, "TRACKER_SPARQL_TOKEN_TYPE_INSERT", "insert"}, {TRACKER_SPARQL_TOKEN_TYPE_INTEGER, "TRACKER_SPARQL_TOKEN_TYPE_INTEGER", "integer"}, {TRACKER_SPARQL_TOKEN_TYPE_INTO, "TRACKER_SPARQL_TOKEN_TYPE_INTO", "into"}, {TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, "TRACKER_SPARQL_TOKEN_TYPE_IRI_REF", "iri-ref"}, {TRACKER_SPARQL_TOKEN_TYPE_ISBLANK, "TRACKER_SPARQL_TOKEN_TYPE_ISBLANK", "isblank"}, {TRACKER_SPARQL_TOKEN_TYPE_ISIRI, "TRACKER_SPARQL_TOKEN_TYPE_ISIRI", "isiri"}, {TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL, "TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL", "isliteral"}, {TRACKER_SPARQL_TOKEN_TYPE_ISURI, "TRACKER_SPARQL_TOKEN_TYPE_ISURI", "isuri"}, {TRACKER_SPARQL_TOKEN_TYPE_LANG, "TRACKER_SPARQL_TOKEN_TYPE_LANG", "lang"}, {TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES, "TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES", "langmatches"}, {TRACKER_SPARQL_TOKEN_TYPE_LIMIT, "TRACKER_SPARQL_TOKEN_TYPE_LIMIT", "limit"}, {TRACKER_SPARQL_TOKEN_TYPE_MAX, "TRACKER_SPARQL_TOKEN_TYPE_MAX", "max"}, {TRACKER_SPARQL_TOKEN_TYPE_MIN, "TRACKER_SPARQL_TOKEN_TYPE_MIN", "min"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUS, "TRACKER_SPARQL_TOKEN_TYPE_MINUS", "minus"}, {TRACKER_SPARQL_TOKEN_TYPE_NAMED, "TRACKER_SPARQL_TOKEN_TYPE_NAMED", "named"}, {TRACKER_SPARQL_TOKEN_TYPE_NOT, "TRACKER_SPARQL_TOKEN_TYPE_NOT", "not"}, {TRACKER_SPARQL_TOKEN_TYPE_OFFSET, "TRACKER_SPARQL_TOKEN_TYPE_OFFSET", "offset"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_AND, "TRACKER_SPARQL_TOKEN_TYPE_OP_AND", "op-and"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, "TRACKER_SPARQL_TOKEN_TYPE_OP_EQ", "op-eq"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GE, "TRACKER_SPARQL_TOKEN_TYPE_OP_GE", "op-ge"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GT, "TRACKER_SPARQL_TOKEN_TYPE_OP_GT", "op-gt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LE, "TRACKER_SPARQL_TOKEN_TYPE_OP_LE", "op-le"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LT, "TRACKER_SPARQL_TOKEN_TYPE_OP_LT", "op-lt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NE, "TRACKER_SPARQL_TOKEN_TYPE_OP_NE", "op-ne"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, "TRACKER_SPARQL_TOKEN_TYPE_OP_NEG", "op-neg"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_OR, "TRACKER_SPARQL_TOKEN_TYPE_OP_OR", "op-or"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_IN, "TRACKER_SPARQL_TOKEN_TYPE_OP_IN", "op-in"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, "TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL", "optional"}, {TRACKER_SPARQL_TOKEN_TYPE_OR, "TRACKER_SPARQL_TOKEN_TYPE_OR", "or"}, {TRACKER_SPARQL_TOKEN_TYPE_ORDER, "TRACKER_SPARQL_TOKEN_TYPE_ORDER", "order"}, {TRACKER_SPARQL_TOKEN_TYPE_PLUS, "TRACKER_SPARQL_TOKEN_TYPE_PLUS", "plus"}, {TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX", "pn-prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PREFIX", "prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_REDUCED, "TRACKER_SPARQL_TOKEN_TYPE_REDUCED", "reduced"}, {TRACKER_SPARQL_TOKEN_TYPE_REGEX, "TRACKER_SPARQL_TOKEN_TYPE_REGEX", "regex"}, {TRACKER_SPARQL_TOKEN_TYPE_REPLACE, "TRACKER_SPARQL_TOKEN_TYPE_REPLACE", "replace"}, {TRACKER_SPARQL_TOKEN_TYPE_SAMETERM, "TRACKER_SPARQL_TOKEN_TYPE_SAMETERM", "sameterm"}, {TRACKER_SPARQL_TOKEN_TYPE_SELECT, "TRACKER_SPARQL_TOKEN_TYPE_SELECT", "select"}, {TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, "TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON", "semicolon"}, {TRACKER_SPARQL_TOKEN_TYPE_SILENT, "TRACKER_SPARQL_TOKEN_TYPE_SILENT", "silent"}, {TRACKER_SPARQL_TOKEN_TYPE_STAR, "TRACKER_SPARQL_TOKEN_TYPE_STAR", "star"}, {TRACKER_SPARQL_TOKEN_TYPE_STR, "TRACKER_SPARQL_TOKEN_TYPE_STR", "str"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1", "string-literal1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2", "string-literal2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1", "string-literal-long1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2", "string-literal-long2"}, {TRACKER_SPARQL_TOKEN_TYPE_SUM, "TRACKER_SPARQL_TOKEN_TYPE_SUM", "sum"}, {TRACKER_SPARQL_TOKEN_TYPE_TRUE, "TRACKER_SPARQL_TOKEN_TYPE_TRUE", "true"}, {TRACKER_SPARQL_TOKEN_TYPE_UNION, "TRACKER_SPARQL_TOKEN_TYPE_UNION", "union"}, {TRACKER_SPARQL_TOKEN_TYPE_VAR, "TRACKER_SPARQL_TOKEN_TYPE_VAR", "var"}, {TRACKER_SPARQL_TOKEN_TYPE_WHERE, "TRACKER_SPARQL_TOKEN_TYPE_WHERE", "where"}, {TRACKER_SPARQL_TOKEN_TYPE_WITH, "TRACKER_SPARQL_TOKEN_TYPE_WITH", "with"}, {0, NULL, NULL}};
		GType tracker_sparql_token_type_type_id;
		tracker_sparql_token_type_type_id = g_enum_register_static ("TrackerSparqlTokenType", values);
		g_once_init_leave (&tracker_sparql_token_type_type_id__volatile, tracker_sparql_token_type_type_id);
	}
	return tracker_sparql_token_type_type_id__volatile;
}



