/* tracker-dbus.c generated by valac 0.11.5, the Vala compiler
 * generated from tracker-dbus.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_DBUS (tracker_dbus_get_type ())
#define TRACKER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_DBUS, TrackerDBus))
#define TRACKER_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_DBUS, TrackerDBusClass))
#define TRACKER_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_DBUS))
#define TRACKER_IS_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_DBUS))
#define TRACKER_DBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_DBUS, TrackerDBusClass))

typedef struct _TrackerDBus TrackerDBus;
typedef struct _TrackerDBusClass TrackerDBusClass;
typedef struct _TrackerDBusPrivate TrackerDBusPrivate;

#define TRACKER_TYPE_STATISTICS (tracker_statistics_get_type ())
#define TRACKER_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATISTICS, TrackerStatistics))
#define TRACKER_STATISTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATISTICS, TrackerStatisticsClass))
#define TRACKER_IS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATISTICS))
#define TRACKER_IS_STATISTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATISTICS))
#define TRACKER_STATISTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATISTICS, TrackerStatisticsClass))

typedef struct _TrackerStatistics TrackerStatistics;
typedef struct _TrackerStatisticsClass TrackerStatisticsClass;

#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;

#define TRACKER_TYPE_STEROIDS (tracker_steroids_get_type ())
#define TRACKER_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroids))
#define TRACKER_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))
#define TRACKER_IS_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STEROIDS))
#define TRACKER_IS_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STEROIDS))
#define TRACKER_STEROIDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))

typedef struct _TrackerSteroids TrackerSteroids;
typedef struct _TrackerSteroidsClass TrackerSteroidsClass;

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;

#define TRACKER_TYPE_BACKUP (tracker_backup_get_type ())
#define TRACKER_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_BACKUP, TrackerBackup))
#define TRACKER_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_BACKUP, TrackerBackupClass))
#define TRACKER_IS_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_BACKUP))
#define TRACKER_IS_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_BACKUP))
#define TRACKER_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_BACKUP, TrackerBackupClass))

typedef struct _TrackerBackup TrackerBackup;
typedef struct _TrackerBackupClass TrackerBackupClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerParamSpecDBus TrackerParamSpecDBus;

struct _TrackerDBus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerDBusPrivate * priv;
};

struct _TrackerDBusClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerDBus *self);
};

struct _TrackerParamSpecDBus {
	GParamSpec parent_instance;
};


static gpointer tracker_dbus_parent_class = NULL;
static GDBusConnection* tracker_dbus_connection;
static GDBusConnection* tracker_dbus_connection = NULL;
static guint tracker_dbus_name_owner_changed_id;
static guint tracker_dbus_name_owner_changed_id = 0U;
static TrackerStatistics* tracker_dbus_statistics;
static TrackerStatistics* tracker_dbus_statistics = NULL;
static guint tracker_dbus_statistics_id;
static guint tracker_dbus_statistics_id = 0U;
static TrackerResources* tracker_dbus_resources;
static TrackerResources* tracker_dbus_resources = NULL;
static guint tracker_dbus_resources_id;
static guint tracker_dbus_resources_id = 0U;
static TrackerSteroids* tracker_dbus_steroids;
static TrackerSteroids* tracker_dbus_steroids = NULL;
static guint tracker_dbus_steroids_id;
static guint tracker_dbus_steroids_id = 0U;
static TrackerStatus* tracker_dbus_notifier;
static TrackerStatus* tracker_dbus_notifier = NULL;
static guint tracker_dbus_notifier_id;
static guint tracker_dbus_notifier_id = 0U;
static TrackerBackup* tracker_dbus_backup;
static TrackerBackup* tracker_dbus_backup = NULL;
static guint tracker_dbus_backup_id;
static guint tracker_dbus_backup_id = 0U;

gpointer tracker_dbus_ref (gpointer instance);
void tracker_dbus_unref (gpointer instance);
GParamSpec* tracker_param_spec_dbus (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_dbus (GValue* value, gpointer v_object);
void tracker_value_take_dbus (GValue* value, gpointer v_object);
gpointer tracker_value_get_dbus (const GValue* value);
GType tracker_dbus_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_DBUS_DUMMY_PROPERTY
};
GType tracker_statistics_get_type (void) G_GNUC_CONST;
guint tracker_statistics_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_resources_get_type (void) G_GNUC_CONST;
guint tracker_resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_steroids_get_type (void) G_GNUC_CONST;
guint tracker_steroids_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_status_get_type (void) G_GNUC_CONST;
guint tracker_status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_backup_get_type (void) G_GNUC_CONST;
guint tracker_backup_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
static gboolean tracker_dbus_dbus_register_service (const gchar* name);
static guint tracker_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* lconnection, gconstpointer object, const gchar* path);
static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error);
gboolean tracker_dbus_register_names (void);
gboolean tracker_dbus_init (void);
static void tracker_dbus_name_owner_changed_cb (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters);
void tracker_resources_unreg_batches (TrackerResources* self, const gchar* old_owner);
static void tracker_dbus_set_available (gboolean available);
gboolean tracker_dbus_register_objects (void);
void tracker_dbus_shutdown (void);
TrackerStatus* tracker_dbus_register_notifier (void);
TrackerStatus* tracker_status_new (void);
TrackerStatus* tracker_status_construct (GType object_type);
#define TRACKER_STATUS_PATH "/org/freedesktop/Tracker1/Status"
TrackerStatistics* tracker_statistics_new (void);
TrackerStatistics* tracker_statistics_construct (GType object_type);
#define TRACKER_STATISTICS_PATH "/org/freedesktop/Tracker1/Statistics"
TrackerResources* tracker_resources_new (GDBusConnection* connection);
TrackerResources* tracker_resources_construct (GType object_type, GDBusConnection* connection);
static void _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
TrackerSteroids* tracker_steroids_new (void);
TrackerSteroids* tracker_steroids_construct (GType object_type);
#define TRACKER_STEROIDS_PATH "/org/freedesktop/Tracker1/Steroids"
TrackerBackup* tracker_backup_new (void);
TrackerBackup* tracker_backup_construct (GType object_type);
#define TRACKER_BACKUP_PATH "/org/freedesktop/Tracker1/Backup"
gboolean tracker_dbus_register_prepare_class_signal (void);
void tracker_resources_enable_signals (TrackerResources* self);
GObject* tracker_dbus_get_object (GType type);
TrackerDBus* tracker_dbus_new (void);
TrackerDBus* tracker_dbus_construct (GType object_type);
static void tracker_dbus_finalize (TrackerDBus* obj);


static gboolean tracker_dbus_dbus_register_service (const gchar* name) {
	gboolean result = FALSE;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_;
	GVariant* reply;
	guint _result_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, FALSE);
	g_message ("Registering D-Bus service...\n  Name:'%s'", name);
	_tmp0_ = g_variant_new ("(su)", name, 1 << 2, NULL);
	_tmp1_ = g_variant_ref_sink (_tmp0_);
	_tmp2_ = g_dbus_connection_call_sync (tracker_dbus_connection, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "RequestName", _tmp1_, (GVariantType*) "(u)", 0, -1, NULL, &_inner_error_);
	reply = (_tmp3_ = _tmp2_, _g_variant_unref0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	g_variant_get (reply, "(u)", &_result_, NULL);
	if (_result_ != 1) {
		g_critical ("D-Bus service name:'%s' is already taken, " "perhaps the daemon is already running?", name);
		result = FALSE;
		_g_variant_unref0 (reply);
		return result;
	}
	result = TRUE;
	_g_variant_unref0 (reply);
	return result;
	_g_variant_unref0 (reply);
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Could not aquire name:'%s', %s", name, e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error) {
	void *func;
	func = g_type_get_qdata (type, g_quark_from_static_string ("vala-dbus-register-object"));
	if (!func) {
		g_set_error_literal (error, G_IO_ERROR, G_IO_ERROR_FAILED, "The specified type does not support D-Bus registration");
		return 0;
	}
	return ((guint (*) (void *, GDBusConnection *, const gchar *, GError **)) func) (object, connection, path, error);
}


static guint tracker_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* lconnection, gconstpointer object, const gchar* path) {
	guint result = 0U;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_;
	guint id;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (lconnection != NULL, 0U);
	g_return_val_if_fail (path != NULL, 0U);
	g_message ("Registering D-Bus object...");
	g_message ("  Path:'%s'", path);
	_tmp0_ = g_type_name (t_type);
	g_message ("  Type:'%s'", _tmp0_);
	_tmp1_ = _vala_g_dbus_connection_register_object (t_type, object, lconnection, path, &_inner_error_);
	id = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	result = id;
	return result;
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Could not register D-Bus object: %s", e->message);
		result = (guint) 0;
		_g_error_free0 (e);
		return result;
	}
	__finally3:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0U;
}


gboolean tracker_dbus_register_names (void) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	_tmp0_ = tracker_dbus_dbus_register_service (TRACKER_DBUS_SERVICE);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean tracker_dbus_init (void) {
	gboolean result = FALSE;
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp2_;
	GError * _inner_error_ = NULL;
	if (tracker_dbus_connection != NULL) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (tracker_dbus_connection);
	tracker_dbus_connection = _tmp2_;
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Could not connect to the D-Bus session bus, %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void tracker_dbus_name_owner_changed_cb (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters) {
	const gchar* name = NULL;
	const gchar* old_owner = NULL;
	const gchar* new_owner = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_variant_get (parameters, "(&s&s&s)", &name, &old_owner, &new_owner, NULL);
	if (g_strcmp0 (old_owner, "") != 0) {
		_tmp0_ = g_strcmp0 (new_owner, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		tracker_resources_unreg_batches (tracker_dbus_resources, old_owner);
	}
}


static void tracker_dbus_set_available (gboolean available) {
	if (available) {
		if (tracker_dbus_resources_id == 0) {
			tracker_dbus_register_objects ();
		}
	} else {
		if (tracker_dbus_resources_id != 0) {
			TrackerResources* _tmp0_;
			TrackerSteroids* _tmp1_;
			g_dbus_connection_signal_unsubscribe (tracker_dbus_connection, tracker_dbus_name_owner_changed_id);
			tracker_dbus_name_owner_changed_id = (guint) 0;
			g_dbus_connection_unregister_object (tracker_dbus_connection, tracker_dbus_resources_id);
			_tmp0_ = NULL;
			_g_object_unref0 (tracker_dbus_resources);
			tracker_dbus_resources = _tmp0_;
			tracker_dbus_resources_id = (guint) 0;
			g_dbus_connection_unregister_object (tracker_dbus_connection, tracker_dbus_steroids_id);
			_tmp1_ = NULL;
			_g_object_unref0 (tracker_dbus_steroids);
			tracker_dbus_steroids = _tmp1_;
			tracker_dbus_steroids_id = (guint) 0;
		}
	}
}


void tracker_dbus_shutdown (void) {
	GDBusConnection* _tmp2_;
	tracker_dbus_set_available (FALSE);
	if (tracker_dbus_backup != NULL) {
		TrackerBackup* _tmp0_;
		g_dbus_connection_unregister_object (tracker_dbus_connection, tracker_dbus_backup_id);
		_tmp0_ = NULL;
		_g_object_unref0 (tracker_dbus_backup);
		tracker_dbus_backup = _tmp0_;
		tracker_dbus_backup_id = (guint) 0;
	}
	if (tracker_dbus_notifier != NULL) {
		TrackerStatus* _tmp1_;
		g_dbus_connection_unregister_object (tracker_dbus_connection, tracker_dbus_notifier_id);
		_tmp1_ = NULL;
		_g_object_unref0 (tracker_dbus_notifier);
		tracker_dbus_notifier = _tmp1_;
		tracker_dbus_notifier_id = (guint) 0;
	}
	_tmp2_ = NULL;
	_g_object_unref0 (tracker_dbus_connection);
	tracker_dbus_connection = _tmp2_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TrackerStatus* tracker_dbus_register_notifier (void) {
	TrackerStatus* result = NULL;
	TrackerStatus* _tmp0_ = NULL;
	TrackerStatus* _tmp1_;
	guint _tmp2_;
	TrackerStatus* _tmp3_;
	if (tracker_dbus_connection == NULL) {
		g_critical ("D-Bus support must be initialized before registering objects!");
		result = NULL;
		return result;
	}
	_tmp0_ = tracker_status_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (tracker_dbus_notifier);
	tracker_dbus_notifier = _tmp1_;
	if (tracker_dbus_notifier == NULL) {
		g_critical ("Could not create TrackerStatus object to register");
		result = NULL;
		return result;
	}
	_tmp2_ = tracker_dbus_register_object (TRACKER_TYPE_STATUS, (GBoxedCopyFunc) g_object_ref, g_object_unref, tracker_dbus_connection, tracker_dbus_notifier, TRACKER_STATUS_PATH);
	tracker_dbus_notifier_id = _tmp2_;
	_tmp3_ = _g_object_ref0 (tracker_dbus_notifier);
	result = _tmp3_;
	return result;
}


static void _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
	tracker_dbus_name_owner_changed_cb (connection, sender_name, object_path, interface_name, signal_name, parameters);
}


gboolean tracker_dbus_register_objects (void) {
	gboolean result = FALSE;
	TrackerStatistics* _tmp0_ = NULL;
	TrackerStatistics* _tmp1_;
	guint _tmp2_;
	TrackerResources* _tmp3_ = NULL;
	TrackerResources* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	TrackerSteroids* _tmp7_ = NULL;
	TrackerSteroids* _tmp8_;
	guint _tmp9_;
	if (tracker_dbus_connection == NULL) {
		g_critical ("D-Bus support must be initialized before registering objects!");
		result = FALSE;
		return result;
	}
	_tmp0_ = tracker_statistics_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (tracker_dbus_statistics);
	tracker_dbus_statistics = _tmp1_;
	if (tracker_dbus_statistics == NULL) {
		g_critical ("Could not create TrackerStatistics object to register");
		result = FALSE;
		return result;
	}
	_tmp2_ = tracker_dbus_register_object (TRACKER_TYPE_STATISTICS, (GBoxedCopyFunc) g_object_ref, g_object_unref, tracker_dbus_connection, tracker_dbus_statistics, TRACKER_STATISTICS_PATH);
	tracker_dbus_statistics_id = _tmp2_;
	_tmp3_ = tracker_resources_new (tracker_dbus_connection);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (tracker_dbus_resources);
	tracker_dbus_resources = _tmp4_;
	if (tracker_dbus_resources == NULL) {
		g_critical ("Could not create TrackerResources object to register");
		result = FALSE;
		return result;
	}
	_tmp5_ = g_dbus_connection_signal_subscribe (tracker_dbus_connection, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback, NULL, NULL);
	tracker_dbus_name_owner_changed_id = _tmp5_;
	_tmp6_ = tracker_dbus_register_object (TRACKER_TYPE_RESOURCES, (GBoxedCopyFunc) g_object_ref, g_object_unref, tracker_dbus_connection, tracker_dbus_resources, TRACKER_RESOURCES_PATH);
	tracker_dbus_resources_id = _tmp6_;
	_tmp7_ = tracker_steroids_new ();
	_tmp8_ = _tmp7_;
	_g_object_unref0 (tracker_dbus_steroids);
	tracker_dbus_steroids = _tmp8_;
	if (tracker_dbus_steroids == NULL) {
		g_critical ("Could not create TrackerSteroids object to register");
		result = FALSE;
		return result;
	}
	_tmp9_ = tracker_dbus_register_object (TRACKER_TYPE_STEROIDS, (GBoxedCopyFunc) g_object_ref, g_object_unref, tracker_dbus_connection, tracker_dbus_steroids, TRACKER_STEROIDS_PATH);
	tracker_dbus_steroids_id = _tmp9_;
	if (tracker_dbus_backup == NULL) {
		TrackerBackup* _tmp10_ = NULL;
		TrackerBackup* _tmp11_;
		guint _tmp12_;
		_tmp10_ = tracker_backup_new ();
		_tmp11_ = _tmp10_;
		_g_object_unref0 (tracker_dbus_backup);
		tracker_dbus_backup = _tmp11_;
		if (tracker_dbus_backup == NULL) {
			g_critical ("Could not create TrackerBackup object to register");
			result = FALSE;
			return result;
		}
		_tmp12_ = tracker_dbus_register_object (TRACKER_TYPE_BACKUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, tracker_dbus_connection, tracker_dbus_backup, TRACKER_BACKUP_PATH);
		tracker_dbus_backup_id = _tmp12_;
	}
	result = TRUE;
	return result;
}


gboolean tracker_dbus_register_prepare_class_signal (void) {
	gboolean result = FALSE;
	if (tracker_dbus_resources == NULL) {
		g_message ("Error during initialization, Resources DBus object not available");
		result = FALSE;
		return result;
	}
	tracker_resources_enable_signals (tracker_dbus_resources);
	result = TRUE;
	return result;
}


GObject* tracker_dbus_get_object (GType type) {
	GObject* result = NULL;
	if (type == TRACKER_TYPE_RESOURCES) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 ((GObject*) tracker_dbus_resources);
		result = _tmp0_;
		return result;
	}
	if (type == TRACKER_TYPE_STEROIDS) {
		GObject* _tmp1_;
		_tmp1_ = _g_object_ref0 ((GObject*) tracker_dbus_steroids);
		result = _tmp1_;
		return result;
	}
	if (type == TRACKER_TYPE_STATUS) {
		GObject* _tmp2_;
		_tmp2_ = _g_object_ref0 ((GObject*) tracker_dbus_notifier);
		result = _tmp2_;
		return result;
	}
	if (type == TRACKER_TYPE_BACKUP) {
		GObject* _tmp3_;
		_tmp3_ = _g_object_ref0 ((GObject*) tracker_dbus_backup);
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}


TrackerDBus* tracker_dbus_construct (GType object_type) {
	TrackerDBus* self = NULL;
	self = (TrackerDBus*) g_type_create_instance (object_type);
	return self;
}


TrackerDBus* tracker_dbus_new (void) {
	return tracker_dbus_construct (TRACKER_TYPE_DBUS);
}


static void tracker_value_dbus_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_value_dbus_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_dbus_unref (value->data[0].v_pointer);
	}
}


static void tracker_value_dbus_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_dbus_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_value_dbus_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_value_dbus_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerDBus* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_dbus_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_value_dbus_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerDBus** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_dbus_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_param_spec_dbus (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecDBus* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_DBUS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_value_get_dbus (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS), NULL);
	return value->data[0].v_pointer;
}


void tracker_value_set_dbus (GValue* value, gpointer v_object) {
	TrackerDBus* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_DBUS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_dbus_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_dbus_unref (old);
	}
}


void tracker_value_take_dbus (GValue* value, gpointer v_object) {
	TrackerDBus* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_DBUS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_dbus_unref (old);
	}
}


static void tracker_dbus_class_init (TrackerDBusClass * klass) {
	tracker_dbus_parent_class = g_type_class_peek_parent (klass);
	TRACKER_DBUS_CLASS (klass)->finalize = tracker_dbus_finalize;
}


static void tracker_dbus_instance_init (TrackerDBus * self) {
	self->ref_count = 1;
}


static void tracker_dbus_finalize (TrackerDBus* obj) {
	TrackerDBus * self;
	self = TRACKER_DBUS (obj);
}


GType tracker_dbus_get_type (void) {
	static volatile gsize tracker_dbus_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_dbus_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_dbus_init, tracker_value_dbus_free_value, tracker_value_dbus_copy_value, tracker_value_dbus_peek_pointer, "p", tracker_value_dbus_collect_value, "p", tracker_value_dbus_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDBusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_dbus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDBus), 0, (GInstanceInitFunc) tracker_dbus_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_dbus_type_id;
		tracker_dbus_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerDBus", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_dbus_type_id__volatile, tracker_dbus_type_id);
	}
	return tracker_dbus_type_id__volatile;
}


gpointer tracker_dbus_ref (gpointer instance) {
	TrackerDBus* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_dbus_unref (gpointer instance) {
	TrackerDBus* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_DBUS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



