/* tracker-builder.c generated by valac 0.14.0, the Vala compiler
 * generated from tracker-builder.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * SECTION: tracker-sparql-builder
 * @short_description: Creating insertion/update SPARQL queries.
 * @title: TrackerSparqlBuilder
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <para>
 * #TrackerSparqlBuilder is an object what will gather a set of
 * subject/predicate/object triples, together with an optional WHERE clause,
 * in order to create a query that may be issued to tracker-store.
 * </para>
 *
 * <para>
 * When using #TrackerSparqlBuilder, note that you may append several predicates
 * for the same subject, and several objects for the same predicate.
 * </para>
 */
/**
 * TrackerSparqlBuilder:
 *
 * The <structname>TrackerSparqlBuilder</structname> object represents an
 * insertion/update SPARQL query.
 */
/**
 * tracker_sparql_builder_get_result:
 * @self: a #TrackerSparqlBuilder
 *
 * Retrieves a string representation of the constructed SPARQL query.
 *
 * Returns: the created SPARQL query. The string is contained in the
 * #TrackerSparqlBuilder object, and should not be freed by the caller.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_length:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the number of objects added to @self.
 *
 * Returns: the number of objects contained.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_state:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the current state of @self
 *
 * Returns: a #TrackerSparqlBuilderState defining the current state of @self
 *
 * Since: 0.10
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>


#define TRACKER_SPARQL_TYPE_BUILDER (tracker_sparql_builder_get_type ())
#define TRACKER_SPARQL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder))
#define TRACKER_SPARQL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderClass))
#define TRACKER_SPARQL_IS_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BUILDER))
#define TRACKER_SPARQL_IS_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BUILDER))
#define TRACKER_SPARQL_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderClass))

typedef struct _TrackerSparqlBuilder TrackerSparqlBuilder;
typedef struct _TrackerSparqlBuilderClass TrackerSparqlBuilderClass;
typedef struct _TrackerSparqlBuilderPrivate TrackerSparqlBuilderPrivate;

#define TRACKER_SPARQL_BUILDER_TYPE_STATE (tracker_sparql_builder_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TrackerSparqlBuilder {
	GObject parent_instance;
	TrackerSparqlBuilderPrivate * priv;
};

struct _TrackerSparqlBuilderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_BUILDER_STATE_UPDATE,
	TRACKER_SPARQL_BUILDER_STATE_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_DELETE,
	TRACKER_SPARQL_BUILDER_STATE_SUBJECT,
	TRACKER_SPARQL_BUILDER_STATE_PREDICATE,
	TRACKER_SPARQL_BUILDER_STATE_OBJECT,
	TRACKER_SPARQL_BUILDER_STATE_BLANK,
	TRACKER_SPARQL_BUILDER_STATE_WHERE,
	TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_GRAPH
} TrackerSparqlBuilderState;

struct _TrackerSparqlBuilderPrivate {
	gint _length;
	TrackerSparqlBuilderState* states;
	gint states_length1;
	gint _states_size_;
	GString* str;
};


static gpointer tracker_sparql_builder_parent_class = NULL;

GType tracker_sparql_builder_get_type (void) G_GNUC_CONST;
GType tracker_sparql_builder_state_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderPrivate))
enum  {
	TRACKER_SPARQL_BUILDER_DUMMY_PROPERTY,
	TRACKER_SPARQL_BUILDER_RESULT,
	TRACKER_SPARQL_BUILDER_LENGTH,
	TRACKER_SPARQL_BUILDER_STATE
};
TrackerSparqlBuilder* tracker_sparql_builder_new_update (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type);
static void _vala_array_add1 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type);
static void _vala_array_add2 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
static void _vala_array_add3 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
static void _vala_array_add4 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_drop_graph (TrackerSparqlBuilder* self, const gchar* iri);
TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self);
void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const gchar* graph);
static void _vala_array_add5 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self, const gchar* graph);
static void _vala_array_add6 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const gchar* graph);
static void _vala_array_add7 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self, const gchar* graph);
static void _vala_array_add8 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self);
static void _vala_array_add9 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const gchar* var_name);
void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const gchar* s);
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const gchar* var_name);
void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const gchar* s);
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const gchar* iri);
static void _vala_array_add10 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const gchar* iri);
void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const gchar* s);
static void _vala_array_add11 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const gchar* iri);
static void _vala_array_add12 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value);
void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const gchar* literal);
static void _vala_array_add13 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self, const gchar* value);
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal);
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal);
void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal);
void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, gdouble literal);
void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self);
static void _vala_array_add14 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self);
static void _vala_array_add15 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const gchar* raw);
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const gchar* raw);
TrackerSparqlBuilder* tracker_sparql_builder_new (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type);
const gchar* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_finalize (GObject* obj);
static void _vala_tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * TrackerSparqlBuilderState:
 * @TRACKER_SPARQL_BUILDER_STATE_UPDATE: Builder is generating an UPDATE
 * @TRACKER_SPARQL_BUILDER_STATE_INSERT: Builder is generating an INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_DELETE: Builder is generating a DELETE
 * @TRACKER_SPARQL_BUILDER_STATE_SUBJECT: Builder is generating the subject of the query
 * @TRACKER_SPARQL_BUILDER_STATE_PREDICATE: Builder is generating the predicate of the query
 * @TRACKER_SPARQL_BUILDER_STATE_OBJECT: Builder is generating the object of the query
 * @TRACKER_SPARQL_BUILDER_STATE_BLANK: Builder is generating a blank node subject
 * @TRACKER_SPARQL_BUILDER_STATE_WHERE: Builder is generating the WHERE clause contents
 * @TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT: Builder is generating an embedded INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_GRAPH: Builder is generating the GRAPH clause contents
 *
 * Enumeration with the possible states of the SPARQL Builder
 */
GType tracker_sparql_builder_state_get_type (void) {
	static volatile gsize tracker_sparql_builder_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_builder_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BUILDER_STATE_UPDATE, "TRACKER_SPARQL_BUILDER_STATE_UPDATE", "update"}, {TRACKER_SPARQL_BUILDER_STATE_INSERT, "TRACKER_SPARQL_BUILDER_STATE_INSERT", "insert"}, {TRACKER_SPARQL_BUILDER_STATE_DELETE, "TRACKER_SPARQL_BUILDER_STATE_DELETE", "delete"}, {TRACKER_SPARQL_BUILDER_STATE_SUBJECT, "TRACKER_SPARQL_BUILDER_STATE_SUBJECT", "subject"}, {TRACKER_SPARQL_BUILDER_STATE_PREDICATE, "TRACKER_SPARQL_BUILDER_STATE_PREDICATE", "predicate"}, {TRACKER_SPARQL_BUILDER_STATE_OBJECT, "TRACKER_SPARQL_BUILDER_STATE_OBJECT", "object"}, {TRACKER_SPARQL_BUILDER_STATE_BLANK, "TRACKER_SPARQL_BUILDER_STATE_BLANK", "blank"}, {TRACKER_SPARQL_BUILDER_STATE_WHERE, "TRACKER_SPARQL_BUILDER_STATE_WHERE", "where"}, {TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT, "TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT", "embedded-insert"}, {TRACKER_SPARQL_BUILDER_STATE_GRAPH, "TRACKER_SPARQL_BUILDER_STATE_GRAPH", "graph"}, {0, NULL, NULL}};
		GType tracker_sparql_builder_state_type_id;
		tracker_sparql_builder_state_type_id = g_enum_register_static ("TrackerSparqlBuilderState", values);
		g_once_init_leave (&tracker_sparql_builder_state_type_id__volatile, tracker_sparql_builder_state_type_id);
	}
	return tracker_sparql_builder_state_type_id__volatile;
}


/**
 * tracker_sparql_builder_new_update:
 *
 * Creates an empty #TrackerSparqlBuilder for an update query.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void _vala_array_add1 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 246 "tracker-builder.c"
	}
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 250 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	TrackerSparqlBuilderState* _tmp0_;
	gint _tmp0__length1;
#line 170 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add1 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 170 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 268 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new_update (void) {
#line 170 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct_update (TRACKER_SPARQL_TYPE_BUILDER);
#line 275 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_new_embedded_insert:
 *
 * Creates a #TrackerSparqlBuilder ready to be embedded in another query. In embedded
 * inserts, the subject is implied (responsibility of the embedder), so only calls to
 * append predicates and objects for the given subject are allowed.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void _vala_array_add2 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 297 "tracker-builder.c"
	}
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 301 "tracker-builder.c"
}


static void _vala_array_add3 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 187 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 187 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 187 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 312 "tracker-builder.c"
	}
#line 187 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 316 "tracker-builder.c"
}


static void _vala_array_add4 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 327 "tracker-builder.c"
	}
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 331 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	TrackerSparqlBuilderState* _tmp0_;
	gint _tmp0__length1;
	TrackerSparqlBuilderState* _tmp1_;
	gint _tmp1__length1;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
#line 185 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add2 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT);
#line 187 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 187 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 187 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add3 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add4 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
#line 185 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 365 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void) {
#line 185 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct_embedded_insert (TRACKER_SPARQL_TYPE_BUILDER);
#line 372 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_drop_graph:
 * @self: a #TrackerSparqlBuilder
 * @iri: a graph name.
 *
 * Deprecated 0.10.5: There is no replacement for this API.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_drop_graph (TrackerSparqlBuilder* self, const gchar* iri) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
#line 200 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 200 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 200 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 200 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 200 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 203 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_critical ("tracker-builder.vala:203: Use of DROP GRAPH is deprecated");
#line 400 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_insert_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens an insertion statement.
 *
 * Since: 0.10
 */
static void _vala_array_add5 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 218 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 218 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 218 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 420 "tracker-builder.c"
	}
#line 218 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 424 "tracker-builder.c"
}


void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
#line 215 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 215 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 215 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 218 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 218 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 218 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add5 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 219 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 219 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 452 "tracker-builder.c"
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
#line 220 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 220 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 220 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("INSERT INTO <%s> {\n", _tmp5_);
#line 220 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 220 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 220 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 469 "tracker-builder.c"
	} else {
		GString* _tmp8_;
#line 222 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 222 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "INSERT {\n");
#line 476 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_insert_silent_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a silent insertion statement.
 *
 * Since: 0.10
 */
static void _vala_array_add6 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 237 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 237 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 237 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 497 "tracker-builder.c"
	}
#line 237 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 501 "tracker-builder.c"
}


void tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
#line 234 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 234 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 234 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 234 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 237 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 237 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 237 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add6 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 238 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 238 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 529 "tracker-builder.c"
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("INSERT SILENT INTO <%s> {\n", _tmp5_);
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 546 "tracker-builder.c"
	} else {
		GString* _tmp8_;
#line 241 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 241 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "INSERT SILENT {\n");
#line 553 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_insert_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an insertion statement opened with tracker_sparql_builder_insert_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
	TrackerSparqlBuilderState _tmp10_;
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
#line 255 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 255 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 255 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 594 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 256 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 256 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 257 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 257 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 605 "tracker-builder.c"
	}
#line 259 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 259 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = tracker_sparql_builder_get_state (self);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = _tmp9_;
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp10_ != TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT) {
#line 617 "tracker-builder.c"
		GString* _tmp11_;
#line 262 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp11_ = self->priv->str;
#line 262 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp11_, "}\n");
#line 623 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_delete_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a DELETE clause. Data triples may be appended in order to prepare
 * a query to delete them.
 *
 * Since: 0.10
 */
static void _vala_array_add7 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 279 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 279 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 279 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 645 "tracker-builder.c"
	}
#line 279 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 649 "tracker-builder.c"
}


void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
#line 276 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 276 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 276 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 279 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 279 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 279 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add7 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_DELETE);
#line 280 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 280 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 677 "tracker-builder.c"
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
#line 281 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 281 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 281 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("DELETE FROM <%s> {\n", _tmp5_);
#line 281 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 281 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 281 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 694 "tracker-builder.c"
	} else {
		GString* _tmp8_;
#line 283 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 283 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "DELETE {\n");
#line 701 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_delete_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a DELETE clause opened through tracker_sparql_builder_delete_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp8_;
	GString* _tmp9_;
#line 294 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 294 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 294 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 294 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 294 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 294 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_DELETE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
#line 297 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 297 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 297 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 741 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 298 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 298 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 299 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 299 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 752 "tracker-builder.c"
	}
#line 301 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 301 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 303 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 303 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 762 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_graph_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name.
 *
 * Opens a GRAPH clause within INSERT, DELETE, or WHERE.
 *
 * Since: 0.10
 */
static void _vala_array_add8 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 782 "tracker-builder.c"
	}
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 786 "tracker-builder.c"
}


void tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	TrackerSparqlBuilderState _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
	TrackerSparqlBuilderState* _tmp10_;
	gint _tmp10__length1;
	GString* _tmp11_;
	const gchar* _tmp12_;
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (graph != NULL);
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (((((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp9_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH));
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->states;
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10__length1 = self->priv->states_length1;
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add8 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_GRAPH);
#line 319 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->str;
#line 319 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = graph;
#line 319 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append_printf (_tmp11_, "GRAPH <%s> {\n", _tmp12_);
#line 843 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_graph_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a GRAPH clause opened through tracker_sparql_builder_graph_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp8_;
	GString* _tmp9_;
#line 330 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 330 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 330 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 330 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 330 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 330 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
#line 333 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 333 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 333 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 882 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 334 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 334 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 335 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 335 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 893 "tracker-builder.c"
	}
#line 337 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 337 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 339 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 339 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 903 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_where_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens a WHERE clause. Data triples may be appended then to narrow the scope
 * to which the update query applies.
 *
 * Since: 0.10
 */
static void _vala_array_add9 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 354 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 354 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 354 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 923 "tracker-builder.c"
	}
#line 354 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 927 "tracker-builder.c"
}


void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	GString* _tmp3_;
#line 351 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 351 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 351 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 351 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 354 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 354 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 354 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add9 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_WHERE);
#line 355 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->str;
#line 355 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp3_, "WHERE {\n");
#line 955 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_where_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a WHERE clause opened through tracker_sparql_builder_where_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp8_;
	GString* _tmp9_;
#line 366 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 366 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 366 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 366 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 366 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 366 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_WHERE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
#line 369 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 369 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 369 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 994 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 370 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 370 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 371 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 371 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 1005 "tracker-builder.c"
	}
#line 373 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 373 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 374 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 374 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 1015 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends a subject as a SPARQL variable, such as "?urn".
 *
 * Since: 0.10
 */
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const gchar* var_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (var_name != NULL);
#line 387 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = var_name;
#line 387 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("?%s", _tmp0_);
#line 387 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 387 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_subject (self, _tmp2_);
#line 387 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1046 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends an object as a SparQL variable, such as "?urn".
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const gchar* var_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 399 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 399 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (var_name != NULL);
#line 400 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = var_name;
#line 400 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("?%s", _tmp0_);
#line 400 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 400 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 400 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1077 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a subject as an IRI, such as "&lt;urn:file:1234-5678&gt;". IRIs
 * univocally identify a resource in tracker-store.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 413 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 413 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 414 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 414 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 414 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 414 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_subject (self, _tmp2_);
#line 414 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1109 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject:
 * @self: a #TrackerSparqlBuilder
 * @s: subject string
 *
 * Appends a subject.
 *
 * Since: 0.10
 */
static void _vala_array_add10 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 434 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 434 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 434 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1129 "tracker-builder.c"
	}
#line 434 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1133 "tracker-builder.c"
}


void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	TrackerSparqlBuilderState _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
	TrackerSparqlBuilderState _tmp10_;
	TrackerSparqlBuilderState _tmp11_;
	TrackerSparqlBuilderState _tmp12_;
	TrackerSparqlBuilderState _tmp13_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	TrackerSparqlBuilderState* _tmp18_;
	gint _tmp18__length1;
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tracker_sparql_builder_get_state (self);
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_;
#line 426 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((((((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT)) || (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp9_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp11_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH));
#line 429 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = tracker_sparql_builder_get_state (self);
#line 429 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = _tmp12_;
#line 429 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp13_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1192 "tracker-builder.c"
		GString* _tmp14_;
		gint _tmp15_;
#line 430 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp14_ = self->priv->str;
#line 430 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp14_, " .\n");
#line 431 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 431 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp15_ = self->priv->states_length1;
#line 1203 "tracker-builder.c"
	}
#line 433 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp16_ = self->priv->str;
#line 433 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp17_ = s;
#line 433 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp16_, _tmp17_);
#line 434 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp18_ = self->priv->states;
#line 434 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp18__length1 = self->priv->states_length1;
#line 434 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add10 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
#line 1217 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_predicate_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a predicate as an IRI.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 446 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 446 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 447 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 447 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 447 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 447 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_predicate (self, _tmp2_);
#line 447 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1248 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_predicate:
 * @self: a #TrackerSparqlBuilder
 * @s: predicate string
 *
 * Appends a predicate for the previously appended subject.
 *
 * Since: 0.10
 */
static void _vala_array_add11 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 468 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 468 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 468 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1268 "tracker-builder.c"
	}
#line 468 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1272 "tracker-builder.c"
}


void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	GString* _tmp10_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	TrackerSparqlBuilderState* _tmp13_;
	gint _tmp13__length1;
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 459 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_SUBJECT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_BLANK));
#line 462 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 462 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 462 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1314 "tracker-builder.c"
		GString* _tmp8_;
		gint _tmp9_;
#line 463 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 463 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, " ;\n\t");
#line 464 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 2;
#line 464 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp9_ = self->priv->states_length1;
#line 1325 "tracker-builder.c"
	}
#line 466 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->str;
#line 466 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp10_, " ");
#line 467 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->str;
#line 467 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = s;
#line 467 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp11_, _tmp12_);
#line 468 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = self->priv->states;
#line 468 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13__length1 = self->priv->states_length1;
#line 468 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add11 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_PREDICATE);
#line 1343 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends an object as an IRI.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 480 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 480 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 481 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 481 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 481 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 481 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 481 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1374 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object:
 * @self: a #TrackerSparqlBuilder
 * @s: object string
 *
 * Appends a free-form object for the previously appended subject and predicate.
 *
 * Since: 0.10
 */
static void _vala_array_add12 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 502 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 502 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 502 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1394 "tracker-builder.c"
	}
#line 502 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1398 "tracker-builder.c"
}


void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	TrackerSparqlBuilderState* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
#line 493 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 493 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 493 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 493 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 493 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 493 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 493 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
#line 496 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 496 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 496 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1435 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 497 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 497 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 498 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 498 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1446 "tracker-builder.c"
	}
#line 500 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 500 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " ");
#line 501 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 501 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = s;
#line 501 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, _tmp10_);
#line 502 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->states;
#line 502 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11__length1 = self->priv->states_length1;
#line 502 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add12 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 504 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = self->priv->_length;
#line 504 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp12_ + 1);
#line 1468 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_string:
 * @self: a #TrackerSparqlBuilder
 * @literal: string object
 *
 * Appends an object formatted as an string. @literal will be escaped and surrounded
 * by double quotes.
 *
 * Since: 0.10
 */
static void _vala_array_add13 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 556 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 556 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 556 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1489 "tracker-builder.c"
	}
#line 556 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1493 "tracker-builder.c"
}


void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const gchar* literal) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
	const gchar* _tmp9_;
	gchar* p;
	GString* _tmp25_;
	TrackerSparqlBuilderState* _tmp26_;
	gint _tmp26__length1;
	gint _tmp27_;
#line 517 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 517 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (literal != NULL);
#line 517 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 517 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 517 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 517 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 517 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
#line 520 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 520 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 520 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1531 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 521 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 521 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 522 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 522 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1542 "tracker-builder.c"
	}
#line 525 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 525 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " \"");
#line 527 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = literal;
#line 527 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	p = _tmp9_;
#line 528 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	while (TRUE) {
#line 1554 "tracker-builder.c"
		gchar* _tmp10_;
		gchar* _tmp11_;
		gsize _tmp12_ = 0UL;
		gsize len;
		GString* _tmp13_;
		gchar* _tmp14_;
		gsize _tmp15_;
		gchar* _tmp16_;
		gsize _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp24_;
#line 528 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp10_ = p;
#line 528 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		if (!((*_tmp10_) != '\0')) {
#line 528 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			break;
#line 1572 "tracker-builder.c"
		}
#line 529 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp11_ = p;
#line 529 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp12_ = strcspn ((const gchar*) _tmp11_, "\t\n\r\"\\");
#line 529 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		len = _tmp12_;
#line 530 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp13_ = self->priv->str;
#line 530 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp14_ = p;
#line 530 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp15_ = len;
#line 530 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append_len (_tmp13_, (const gchar*) _tmp14_, (gssize) ((glong) _tmp15_));
#line 531 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp16_ = p;
#line 531 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp17_ = len;
#line 531 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		p = _tmp16_ + _tmp17_;
#line 532 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp18_ = p;
#line 532 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		switch (*_tmp18_) {
#line 532 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			case '\t':
#line 1600 "tracker-builder.c"
			{
				GString* _tmp19_;
#line 534 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				_tmp19_ = self->priv->str;
#line 534 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				g_string_append (_tmp19_, "\\t");
#line 535 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				break;
#line 1609 "tracker-builder.c"
			}
#line 532 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			case '\n':
#line 1613 "tracker-builder.c"
			{
				GString* _tmp20_;
#line 537 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				_tmp20_ = self->priv->str;
#line 537 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				g_string_append (_tmp20_, "\\n");
#line 538 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				break;
#line 1622 "tracker-builder.c"
			}
#line 532 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			case '\r':
#line 1626 "tracker-builder.c"
			{
				GString* _tmp21_;
#line 540 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				_tmp21_ = self->priv->str;
#line 540 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				g_string_append (_tmp21_, "\\r");
#line 541 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				break;
#line 1635 "tracker-builder.c"
			}
#line 532 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			case '"':
#line 1639 "tracker-builder.c"
			{
				GString* _tmp22_;
#line 543 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				_tmp22_ = self->priv->str;
#line 543 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				g_string_append (_tmp22_, "\\\"");
#line 544 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				break;
#line 1648 "tracker-builder.c"
			}
#line 532 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			case '\\':
#line 1652 "tracker-builder.c"
			{
				GString* _tmp23_;
#line 546 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				_tmp23_ = self->priv->str;
#line 546 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				g_string_append (_tmp23_, "\\\\");
#line 547 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				break;
#line 1661 "tracker-builder.c"
			}
			default:
			{
#line 549 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
				continue;
#line 1667 "tracker-builder.c"
			}
		}
#line 551 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp24_ = p;
#line 551 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		p = _tmp24_ + 1;
#line 1674 "tracker-builder.c"
	}
#line 554 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp25_ = self->priv->str;
#line 554 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp25_, "\"");
#line 556 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp26_ = self->priv->states;
#line 556 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp26__length1 = self->priv->states_length1;
#line 556 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add13 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 558 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp27_ = self->priv->_length;
#line 558 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp27_ + 1);
#line 1690 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_unvalidated:
 * @self: a #TrackerSparqlBuilder
 * @value: possibly UTF-8 invalid string.
 *
 * Appends a string not validated as UTF-8 as an object.
 *
 * Since: 0.10
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1302 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1302 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1722 "tracker-builder.c"
		glong _tmp4_;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1730 "tracker-builder.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1742 "tracker-builder.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1312 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1767 "tracker-builder.c"
		glong _tmp2_;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1773 "tracker-builder.c"
	} else {
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1777 "tracker-builder.c"
	}
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1783 "tracker-builder.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1795 "tracker-builder.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1805 "tracker-builder.c"
	}
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1811 "tracker-builder.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1323 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1323 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1825 "tracker-builder.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1835 "tracker-builder.c"
	}
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1841 "tracker-builder.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1850 "tracker-builder.c"
	}
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 1870 "tracker-builder.c"
}


void tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self, const gchar* value) {
	gchar* end = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp10_;
#line 570 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 570 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (value != NULL);
#line 573 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = value;
#line 573 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = g_utf8_validate (_tmp0_, (gssize) (-1), &_tmp1_);
#line 573 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	end = _tmp1_;
#line 573 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (!_tmp2_) {
#line 1892 "tracker-builder.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 574 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = value;
#line 574 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = end;
#line 574 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		if (_tmp3_ != _tmp4_) {
#line 1901 "tracker-builder.c"
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
#line 575 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5_ = value;
#line 575 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp6_ = end;
#line 575 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp7_ = value;
#line 575 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp8_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp6_ - ((gchar*) _tmp7_)));
#line 575 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp9_ = _tmp8_;
#line 575 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			tracker_sparql_builder_object_string (self, _tmp9_);
#line 575 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			_g_free0 (_tmp9_);
#line 1921 "tracker-builder.c"
		} else {
#line 577 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
			tracker_sparql_builder_object_string (self, "(invalid data)");
#line 1925 "tracker-builder.c"
		}
#line 580 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		return;
#line 1929 "tracker-builder.c"
	}
#line 583 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = value;
#line 583 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object_string (self, _tmp10_);
#line 1935 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_boolean:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gboolean
 *
 * Appends a #gboolean value as an object.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_;
#line 595 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 596 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = literal;
#line 596 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1_) {
#line 596 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = "true";
#line 1960 "tracker-builder.c"
	} else {
#line 596 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = "false";
#line 1964 "tracker-builder.c"
	}
#line 596 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp0_;
#line 596 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 1970 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_int64:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gint64
 *
 * Appends a #gint64 value as an object.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal) {
	gint64 _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 608 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 609 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = literal;
#line 609 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
#line 609 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 609 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 609 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1999 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_date:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #time_t
 *
 * Appends a #time_t value as an object. @literal will be converted
 * to a string in the date format used by tracker-store.
 *
 * Since: 0.10
 */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2431 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	gmtime_r (&time, &_tmp0_);
#line 2431 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2432 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2432 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return;
#line 2024 "tracker-builder.c"
}


void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal) {
	time_t _tmp0_;
	struct tm _tmp1_ = {0};
	struct tm tm;
	struct tm _tmp2_;
	gint _tmp3_;
	struct tm _tmp4_;
	gint _tmp5_;
	struct tm _tmp6_;
	gint _tmp7_;
	struct tm _tmp8_;
	gint _tmp9_;
	struct tm _tmp10_;
	gint _tmp11_;
	struct tm _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
#line 622 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 623 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = *literal;
#line 623 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_time_gm (_tmp0_, &_tmp1_);
#line 623 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tm = _tmp1_;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tm;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_.tm_year;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tm;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_.tm_mon;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tm;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_.tm_mday;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tm;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_.tm_hour;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tm;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_.tm_min;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = tm;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = _tmp12_.tm_sec;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp14_ = g_strdup_printf ("%04d-%02d-%02dT%02d:%02d:%02dZ", _tmp3_ + 1900, _tmp5_ + 1, _tmp7_, _tmp9_, _tmp11_, _tmp13_);
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp15_ = _tmp14_;
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object_string (self, _tmp15_);
#line 625 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp15_);
#line 2086 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_double:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gdouble
 *
 * Appends a #gdouble value as an object.
 *
 * Since: 0.10
 */
static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = g_strdup (_tmp2_);
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 767 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 2125 "tracker-builder.c"
}


void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, gdouble literal) {
	gdouble _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 637 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 638 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = literal;
#line 638 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = double_to_string (_tmp0_);
#line 638 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 638 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 638 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 2145 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_blank_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens an anonymous blank node. In insertions this can be used to create
 * anonymous nodes for not previously known data without the need of a
 * separate insertion.
 *
 * Since: 0.10
 */
static void _vala_array_add14 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 659 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 659 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 659 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 2166 "tracker-builder.c"
	}
#line 659 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 2170 "tracker-builder.c"
}


void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
	TrackerSparqlBuilderState* _tmp9_;
	gint _tmp9__length1;
#line 651 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 651 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 651 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 651 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 651 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 651 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
#line 654 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 654 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 654 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 2202 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 655 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 655 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 656 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 656 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 2213 "tracker-builder.c"
	}
#line 658 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 658 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " [");
#line 659 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->states;
#line 659 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9__length1 = self->priv->states_length1;
#line 659 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add14 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_BLANK);
#line 2225 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_blank_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an anomymous blank node opened with tracker_sparql_builder_object_blank_open()
 *
 * Since: 0.10
 */
static void _vala_array_add15 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 675 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 675 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 675 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 2244 "tracker-builder.c"
	}
#line 675 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 2248 "tracker-builder.c"
}


void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	TrackerSparqlBuilderState* _tmp3_;
	gint _tmp3__length1;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	GString* _tmp7_;
	gint _tmp8_;
	TrackerSparqlBuilderState* _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->states;
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3__length1 = self->priv->states_length1;
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = _tmp2_[_tmp3__length1 - 3];
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = tracker_sparql_builder_get_state (self);
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = _tmp5_;
#line 670 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) && (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_BLANK));
#line 673 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = self->priv->str;
#line 673 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp7_, "]");
#line 674 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = self->priv->states_length1 - 3;
#line 674 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 675 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->states;
#line 675 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9__length1 = self->priv->states_length1;
#line 675 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add15 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 677 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->_length;
#line 677 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp10_ + 1);
#line 2307 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_prepend:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to prepend.
 *
 * Prepends raw, unvalidated content to @self.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const gchar* raw) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
#line 689 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 689 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (raw != NULL);
#line 691 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->str;
#line 691 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = raw;
#line 691 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = g_strdup_printf ("%s\n", _tmp1_);
#line 691 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 691 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_prepend (_tmp0_, _tmp3_);
#line 691 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp3_);
#line 693 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = self->priv->_length;
#line 693 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp4_ + 1);
#line 2346 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_append:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to append.
 *
 * Appends raw, unvalidated content to @self.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const gchar* raw) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
#line 705 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 705 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (raw != NULL);
#line 707 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 707 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 707 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 2375 "tracker-builder.c"
		GString* _tmp2_;
		gint _tmp3_;
#line 708 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp2_ = self->priv->str;
#line 708 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp2_, " .\n");
#line 709 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 709 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = self->priv->states_length1;
#line 2386 "tracker-builder.c"
	}
#line 712 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = self->priv->str;
#line 712 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = raw;
#line 712 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp4_, _tmp5_);
#line 714 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->_length;
#line 714 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp6_ + 1);
#line 2398 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 2408 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new (void) {
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct (TRACKER_SPARQL_TYPE_BUILDER);
#line 2415 "tracker-builder.c"
}


const gchar* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self) {
	const gchar* result;
	TrackerSparqlBuilderState* _tmp0_;
	gint _tmp0__length1;
	GString* _tmp1_;
	const gchar* _tmp2_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_warn_if_fail (_tmp0__length1 == 1);
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->str;
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_->str;
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp2_;
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2441 "tracker-builder.c"
}


gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self) {
	gint result;
	gint _tmp0_;
#line 132 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 132 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->_length;
#line 132 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp0_;
#line 132 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2456 "tracker-builder.c"
}


static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value) {
	gint _tmp0_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = value;
#line 133 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->_length = _tmp0_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_notify ((GObject *) self, "length");
#line 2470 "tracker-builder.c"
}


TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState result;
	TrackerSparqlBuilderState* _tmp0_;
	gint _tmp0__length1;
	TrackerSparqlBuilderState* _tmp1_;
	gint _tmp1__length1;
	TrackerSparqlBuilderState _tmp2_;
#line 155 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 155 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 155 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 155 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 155 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 155 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp0_[_tmp1__length1 - 1];
#line 155 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp2_;
#line 155 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2497 "tracker-builder.c"
}


static void tracker_sparql_builder_class_init (TrackerSparqlBuilderClass * klass) {
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_parent_class = g_type_class_peek_parent (klass);
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlBuilderPrivate));
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_builder_get_property;
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_builder_set_property;
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_builder_finalize;
#line 2512 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:result:
	 *
	 * String containing the constructed SPARQL in the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_RESULT, g_param_spec_string ("result", "result", "result", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2522 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:length:
	 *
	 * Number of objects added to the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2532 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:state:
	 *
	 * Current state of the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_STATE, g_param_spec_enum ("state", "state", "state", TRACKER_SPARQL_BUILDER_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2542 "tracker-builder.c"
}


static void tracker_sparql_builder_instance_init (TrackerSparqlBuilder * self) {
	GString* _tmp0_;
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv = TRACKER_SPARQL_BUILDER_GET_PRIVATE (self);
#line 159 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_string_new ("");
#line 159 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->str = _tmp0_;
#line 2554 "tracker-builder.c"
}


static void tracker_sparql_builder_finalize (GObject* obj) {
	TrackerSparqlBuilder * self;
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = TRACKER_SPARQL_BUILDER (obj);
#line 158 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states = (g_free (self->priv->states), NULL);
#line 159 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_string_free0 (self->priv->str);
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (tracker_sparql_builder_parent_class)->finalize (obj);
#line 2568 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_new:
 *
 * Creates a stateless #TrackerSparqlBuilder.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
GType tracker_sparql_builder_get_type (void) {
	static volatile gsize tracker_sparql_builder_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_builder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBuilder), 0, (GInstanceInitFunc) tracker_sparql_builder_instance_init, NULL };
		GType tracker_sparql_builder_type_id;
		tracker_sparql_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlBuilder", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_builder_type_id__volatile, tracker_sparql_builder_type_id);
	}
	return tracker_sparql_builder_type_id__volatile;
}


static void _vala_tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = TRACKER_SPARQL_BUILDER (object);
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	switch (property_id) {
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_RESULT:
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_string (value, tracker_sparql_builder_get_result (self));
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_LENGTH:
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_int (value, tracker_sparql_builder_get_length (self));
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_STATE:
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_enum (value, tracker_sparql_builder_get_state (self));
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2616 "tracker-builder.c"
		default:
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2622 "tracker-builder.c"
	}
}


static void _vala_tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = TRACKER_SPARQL_BUILDER (object);
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
	switch (property_id) {
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_LENGTH:
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		tracker_sparql_builder_set_length (self, g_value_get_int (value));
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2638 "tracker-builder.c"
		default:
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 57 "/home/martyn/Source/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2644 "tracker-builder.c"
	}
}



