%define gstreamer_version	0.10.1
%define gstreamer_plugins_base_version	0.10.1
%define gstreamer_plugins_good_version	0.10.0

Summary: Movie player for GNOME 2
Name: totem
Version: 2.16.6
Release: 1
License: GPL
Group: Applications/Multimedia
URL: http://www.hadess.net/totem.php3
Source0: http://ftp.gnome.org/pub/GNOME/sources/totem/0.99/totem-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires(post): GConf2
Requires: gnome-desktop >= 2.6.0
Requires: gstreamer >= %gstreamer_version
Requires: gstreamer-plugins-base >= %gstreamer_plugins_base_version
Requires: gstreamer-plugins-good >= %gstreamer_plugins_good_version

Requires: iso-codes
BuildRequires: gcc-c++, pkgconfig, gettext, scrollkeeper
BuildRequires: gstreamer-devel >= %gstreamer_version
BuildRequires: gstreamer-plugins-base-devel >= %gstreamer_plugins_base_version
BuildRequires: gnome-desktop-devel >= 2.6.0, gnome-vfs2-devel, libglade2-devel
BuildRequires: perl-XML-Parser
BuildRequires: iso-codes-devel
BuildRequires: mozilla-devel
Obsoletes: nautilus-media

%description
Totem is simple movie player for the Gnome desktop. It features a
simple playlist, a full-screen mode, seek and volume controls, as well as
a pretty complete keyboard navigation.

%package mozplugin
Summary: Mozilla plugin for Totem
Group: Applications/Internet

%description mozplugin
Totem is simple movie player for the Gnome desktop. The mozilla plugin
for totem allows totem to be embeded into a web browser. 

%package devel
Summary: Libraries/include files for Totem.
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: gnome-vfs2-devel
Requires: libxml2-devel
Requires: gtk2-devel

%description devel
Totem is simple movie player for the Gnome desktop. It features a
simple playlist, a full-screen mode, seek and volume controls, as well as
a pretty complete keyboard navigation.

This package contains the libraries and includes files necessary to develop
applications with Totem's plparser library.


%prep
%setup -q

%build
export MOZILLA_PLUGINDIR=%{_libdir}/mozilla 
%configure --enable-gstreamer=yes --disable-vanity --enable-mozilla --enable-nvtv

#apparently someone forgot to autogen before disting 0.99.17 :)
#perl -pi -e 's/gstvideowidget.h//g' src/Makefile

make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
make install DESTDIR=$RPM_BUILD_ROOT

#nor vanity
rm -f $RPM_BUILD_ROOT%{_datadir}/pixmaps/vanity.png

# no static libs and libtool archives either
rm -f $RPM_BUILD_ROOT%{_libdir}/*.a
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/nautilus/extensions-1.0/*.a
rm -f $RPM_BUILD_ROOT%{_libdir}/nautilus/extensions-1.0/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/mozilla/plugins/*.a
rm -f $RPM_BUILD_ROOT%{_libdir}/mozilla/plugins/*.la

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
update-desktop-database %{_datadir}/applications
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`

SCHEMAS="totem.schemas totem-handlers.schemas totem-video-thumbnail.schemas" 

for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule \
    %{_sysconfdir}/gconf/schemas/$S \
     >/dev/null || :
done

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%config %{_sysconfdir}/gconf/schemas/*.schemas
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/gnome/help/%{name}/
%{_datadir}/omf/%{name}/
%{_datadir}/%{name}/
%{_datadir}/icons
%{_libdir}/libtotem-plparser.*
%{_libdir}/nautilus/extensions-1.0/*.so*
%{_bindir}/%{name}-video-thumbnailer
%{_mandir}/man1/%{name}.1*
%{_mandir}/man1/totem-video-thumbnailer.1.gz
%{_datadir}/locale
%exclude %{_datadir}/%{name}/vanity.*


%files mozplugin
%defattr(-, root, root)
%{_libdir}/mozilla/plugins/*
%{_libexecdir}/totem-mozilla-viewer

%files devel
%defattr(-, root, root)
%{_includedir}/%{name}/1/plparser
%{_libdir}/pkgconfig/*.pc
%{_libdir}/*so

%changelog
* Mon Feb 13 2006 Matthias Clasen <mclasen@redhat.com> - 1.3.91-1
- Update to 1.3.91

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1.3.90-2.1
- bump again for double-long bug on ppc(64)

* Thu Feb  9 2006 Matthias Clasen <mclasen@redhat.com> - 1.3.90-2
- Rebuild

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 1.3.90-1.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Mon Jan 30 2006 Matthias Clasen <mclasen@redhat.com> - 1.3.90-1
- Update to 1.3.90

* Fri Jan 20 2006 Matthias Clasen <mclasen@redhat.com> - 1.3.1-1
- Update to 1.3.1

* Fri Jan 06 2006 John (J5) Palmieri <johnp@redhat.com> 1.3.0-3
- Build with gstreamer 0.10
- Enable the mozilla plugin

* Thu Jan 05 2006 John (J5) Palmieri <johnp@redhat.com> 1.3.0-2
- GStreamer has been split into gstreamer08 and gstreamer (0.10) packages
  we need gstreamer08 for now

* Thu Dec 20 2005 Matthias Clasen <mclasen@redhat.com> 1.3.0-1
- Update to 1.3.0

* Thu Dec 15 2005 Matthias Clasen <mclasen@redhat.com> 1.2.1-1
- Update to 1.2.1

* Fri Dec 09 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt

* Wed Oct 26 2005 John (J5) Palmieri <johnp@redhat.com> - 1.2.0-1
- Update to 1.2.0

* Tue Oct 25 2005 Matthias Clasen <mclasen@redhat.com> - 1.1.5-1
- Update to 1.1.5

* Tue Aug 18 2005 John (J5) Palmieri <johnp@redhat.com> - 1.1.4-1
- Update to upstream version 1.1.4 and rebuild
- Don't build with nautilus-cd-burner on s390 platforms

* Fri Jul 22 2005 Colin Walters <walters@redhat.com> - 1.1.3-1
- Update to upstream version 1.1.2

* Wed Jun 29 2005 John (J5) Palmieri <johnp@redhat.com> - 1.1.2-1
- Update to upstream version 1.1.2

* Tue May 17 2005 John (J5) Palmieri <johnp@redhat.com> - 1.0.2-1
- Update to upstream version 1.0.2 to fix minor bugs
- Register the thumbnail and handlers schemas

* Tue Feb 29 2005 John (J5) Palmieri <johnp@redhat.com> - 1.0.1-1
- Update to upstream version 1.0.1
- Break out devel package

* Mon Feb 21 2005 Bill Nottingham <notting@redhat.com> - 0.101-4
- fix %%post

* Wed Feb  2 2005 Matthias Clasen <mclasen@redhat.com> - 0.101-3
- Obsolete nautilus-media
- Install property page and thumbnailer

* Wed Feb  2 2005 Matthias Clasen <mclasen@redhat.com> - 0.101-2
- Update to 0.101
 
* Mon Jan 03 2005 Colin Walters <walters@redhat.com> - 0.100-2
- Grab patch totem-0.100-desktopfile.patch from CVS to fix
  missing menu entry (144088)
- Remove workaround for desktop file being misinstalled, fixed
  by above patch

* Mon Jan 03 2005 Colin Walters <walters@redhat.com> - 0.100-1
- New upstream version 0.100

* Sun Dec  5 2004 Bill Nottingham <notting@redhat.com> - 0.99.22-1
- update to 0.99.22

* Thu Oct 28 2004 Colin Walters <walters@redhat.com> - 0.99.19-2
- Add patch to remove removed items from package from help

* Thu Oct 14 2004 Colin Walters <walters@redhat.com> - 0.99.19-1
- New upstream 0.99.19
  - Fixes crasher with CD playback (see NEWS)

* Tue Oct 12 2004 Alexander Larsson <alexl@redhat.com> - 0.99.18-2
- Call update-desktop-database in post

* Tue Oct 12 2004 Alexander Larsson <alexl@redhat.com> - 0.99.18-1
- update to 0.99.18

* Wed Oct  6 2004 Alexander Larsson <alexl@redhat.com> - 
- Initial version, based on specfile by Matthias Saou <http://freshrpms.net/>

