/* autosave-manager.c generated by valac 0.20.1, the Vala compiler
 * generated from autosave-manager.vala, do not modify */

/*
 * Copyright (C) 2011 Timo Kluck
 * Authors: Timo Kluck <tkluck@infty.nl>
 *          Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;
typedef struct _AutosaveManagerPrivate AutosaveManagerPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecAutosaveManager ParamSpecAutosaveManager;

struct _AutosaveManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AutosaveManagerPrivate * priv;
};

struct _AutosaveManagerClass {
	GTypeClass parent_class;
	void (*finalize) (AutosaveManager *self);
};

struct _AutosaveManagerPrivate {
	guint update_timeout;
	GHashTable* page_filenames;
	Book* book_;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ParamSpecAutosaveManager {
	GParamSpec parent_instance;
};


static gpointer autosave_manager_parent_class = NULL;
static gchar* autosave_manager_AUTOSAVE_DIR;
static gchar* autosave_manager_AUTOSAVE_DIR = NULL;
static gchar* autosave_manager_AUTOSAVE_FILENAME;
static gchar* autosave_manager_AUTOSAVE_FILENAME = NULL;
static gchar* autosave_manager_AUTOSAVE_PATH;
static gchar* autosave_manager_AUTOSAVE_PATH = NULL;

gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define AUTOSAVE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AUTOSAVE_MANAGER, AutosaveManagerPrivate))
enum  {
	AUTOSAVE_MANAGER_DUMMY_PROPERTY
};
AutosaveManager* autosave_manager_new (void);
AutosaveManager* autosave_manager_construct (GType object_type);
static void _page_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
void autosave_manager_load (AutosaveManager* self);
Book* autosave_manager_get_book (AutosaveManager* self);
void book_clear (Book* self);
static gchar* autosave_manager_get_value (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, const gchar* _default_);
static gint autosave_manager_get_integer (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gint _default_);
GType scan_direction_get_type (void) G_GNUC_CONST;
static gboolean autosave_manager_get_boolean (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gboolean _default_);
Page* page_new_from_data (gint width, gint n_rows, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
Page* page_construct_from_data (GType object_type, gint width, gint n_rows, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
void book_append_page (Book* self, Page* page);
void autosave_manager_cleanup (AutosaveManager* self);
void autosave_manager_on_page_added (AutosaveManager* self, Page* page);
void autosave_manager_on_scan_finished (AutosaveManager* self, Page* page);
static void _autosave_manager_on_scan_finished_page_scan_finished (Page* _sender, gpointer self);
void autosave_manager_on_changed (AutosaveManager* self);
static void _autosave_manager_on_changed_page_crop_changed (Page* _sender, gpointer self);
void autosave_manager_on_page_removed (AutosaveManager* self, Page* page);
static void autosave_manager_save_pixels (AutosaveManager* self, Page* page);
static void autosave_manager_save (AutosaveManager* self, gboolean do_timeout);
void autosave_manager_on_cleared (AutosaveManager* self);
static gboolean ___lambda2_ (AutosaveManager* self);
static void autosave_manager_real_save (AutosaveManager* self);
static gboolean ____lambda2__gsource_func (gpointer self);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_has_data (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_rowstride (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_depth (Page* self);
gint page_get_dpi (Page* self);
ScanDirection page_get_scan_direction (Page* self);
gchar* page_get_color_profile (Page* self);
gboolean page_has_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
gchar* page_get_named_crop (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_changed_book_reordered (Book* _sender, gpointer self);
static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self);
static void autosave_manager_finalize (AutosaveManager* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _page_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


AutosaveManager* autosave_manager_construct (GType object_type) {
	AutosaveManager* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	self = (AutosaveManager*) g_type_create_instance (object_type);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _page_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->page_filenames);
	self->priv->page_filenames = _tmp2_;
	return self;
}


AutosaveManager* autosave_manager_new (void) {
	return autosave_manager_construct (TYPE_AUTOSAVE_MANAGER);
}


static gpointer _page_ref0 (gpointer self) {
	return self ? page_ref (self) : NULL;
}


void autosave_manager_load (AutosaveManager* self) {
	Book* _tmp0_;
	Book* _tmp1_;
	GHashTable* _tmp2_;
	GKeyFile* _tmp3_;
	GKeyFile* file;
	GKeyFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* pages;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("autosave-manager.vala:64: Loading autosave information");
	_tmp0_ = autosave_manager_get_book (self);
	_tmp1_ = _tmp0_;
	book_clear (_tmp1_);
	_tmp2_ = self->priv->page_filenames;
	g_hash_table_remove_all (_tmp2_);
	_tmp3_ = g_key_file_new ();
	file = _tmp3_;
	{
		GKeyFile* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = file;
		_tmp5_ = autosave_manager_AUTOSAVE_PATH;
		g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("autosave-manager.vala:76: Could not load autosave infomation; not rest" \
"oring any autosaves");
		_g_error_free0 (e);
		_g_key_file_unref0 (file);
		return;
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_key_file_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = file;
	_tmp7_ = autosave_manager_get_value (self, _tmp6_, "simple-scan", "pages", "");
	pages = _tmp7_;
	_tmp8_ = pages;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
	{
		gchar** page_name_collection = NULL;
		gint page_name_collection_length1 = 0;
		gint _page_name_collection_size_ = 0;
		gint page_name_it = 0;
		page_name_collection = _tmp10_;
		page_name_collection_length1 = _vala_array_length (_tmp9_);
		for (page_name_it = 0; page_name_it < _vala_array_length (_tmp9_); page_name_it = page_name_it + 1) {
			gchar* _tmp11_;
			gchar* page_name = NULL;
			_tmp11_ = g_strdup (page_name_collection[page_name_it]);
			page_name = _tmp11_;
			{
				const gchar* _tmp12_;
				GKeyFile* _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_ = 0;
				gint scan_width;
				GKeyFile* _tmp16_;
				const gchar* _tmp17_;
				gint _tmp18_ = 0;
				gint scan_height;
				GKeyFile* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_ = 0;
				gint rowstride;
				GKeyFile* _tmp22_;
				const gchar* _tmp23_;
				gint _tmp24_ = 0;
				gint n_channels;
				GKeyFile* _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_ = 0;
				gint depth;
				GKeyFile* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_ = 0;
				gint dpi;
				GKeyFile* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_ = NULL;
				gchar* scan_direction_name;
				ScanDirection scan_direction;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				GQuark _tmp37_ = 0U;
				static GQuark _tmp36_label0 = 0;
				static GQuark _tmp36_label1 = 0;
				static GQuark _tmp36_label2 = 0;
				static GQuark _tmp36_label3 = 0;
				GKeyFile* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_ = NULL;
				gchar* color_profile;
				const gchar* _tmp41_;
				GKeyFile* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_ = NULL;
				gchar* pixels_filename;
				GKeyFile* _tmp45_;
				const gchar* _tmp46_;
				gboolean _tmp47_ = FALSE;
				gboolean has_crop;
				GKeyFile* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_ = NULL;
				gchar* crop_name;
				const gchar* _tmp51_;
				GKeyFile* _tmp52_;
				const gchar* _tmp53_;
				gint _tmp54_ = 0;
				gint crop_x;
				GKeyFile* _tmp55_;
				const gchar* _tmp56_;
				gint _tmp57_ = 0;
				gint crop_y;
				GKeyFile* _tmp58_;
				const gchar* _tmp59_;
				gint _tmp60_ = 0;
				gint crop_width;
				GKeyFile* _tmp61_;
				const gchar* _tmp62_;
				gint _tmp63_ = 0;
				gint crop_height;
				guchar* pixels;
				gint pixels_length1;
				gint _pixels_size_;
				const gchar* _tmp64_;
				gint _tmp73_;
				gint _tmp74_;
				gint _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
				ScanDirection _tmp79_;
				const gchar* _tmp80_;
				guchar* _tmp81_;
				gint _tmp81__length1;
				gboolean _tmp82_;
				const gchar* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				Page* _tmp88_;
				Page* page;
				GHashTable* _tmp89_;
				Page* _tmp90_;
				Page* _tmp91_;
				const gchar* _tmp92_;
				gchar* _tmp93_;
				Book* _tmp94_;
				Book* _tmp95_;
				Page* _tmp96_;
				_tmp12_ = page_name;
				g_debug ("autosave-manager.vala:82: Loading automatically saved page %s", _tmp12_);
				_tmp13_ = file;
				_tmp14_ = page_name;
				_tmp15_ = autosave_manager_get_integer (self, _tmp13_, _tmp14_, "scan-width", 0);
				scan_width = _tmp15_;
				_tmp16_ = file;
				_tmp17_ = page_name;
				_tmp18_ = autosave_manager_get_integer (self, _tmp16_, _tmp17_, "scan-height", 0);
				scan_height = _tmp18_;
				_tmp19_ = file;
				_tmp20_ = page_name;
				_tmp21_ = autosave_manager_get_integer (self, _tmp19_, _tmp20_, "rowstride", 0);
				rowstride = _tmp21_;
				_tmp22_ = file;
				_tmp23_ = page_name;
				_tmp24_ = autosave_manager_get_integer (self, _tmp22_, _tmp23_, "n-channels", 0);
				n_channels = _tmp24_;
				_tmp25_ = file;
				_tmp26_ = page_name;
				_tmp27_ = autosave_manager_get_integer (self, _tmp25_, _tmp26_, "depth", 0);
				depth = _tmp27_;
				_tmp28_ = file;
				_tmp29_ = page_name;
				_tmp30_ = autosave_manager_get_integer (self, _tmp28_, _tmp29_, "dpi", 0);
				dpi = _tmp30_;
				_tmp31_ = file;
				_tmp32_ = page_name;
				_tmp33_ = autosave_manager_get_value (self, _tmp31_, _tmp32_, "scan-direction", "");
				scan_direction_name = _tmp33_;
				scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
				_tmp34_ = scan_direction_name;
				_tmp35_ = _tmp34_;
				_tmp37_ = (NULL == _tmp35_) ? 0 : g_quark_from_string (_tmp35_);
				if (_tmp37_ == ((0 != _tmp36_label0) ? _tmp36_label0 : (_tmp36_label0 = g_quark_from_static_string ("TOP_TO_BOTTOM")))) {
					switch (0) {
						default:
						{
							scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
							break;
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label1) ? _tmp36_label1 : (_tmp36_label1 = g_quark_from_static_string ("LEFT_TO_RIGHT")))) {
					switch (0) {
						default:
						{
							scan_direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
							break;
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label2) ? _tmp36_label2 : (_tmp36_label2 = g_quark_from_static_string ("BOTTOM_TO_TOP")))) {
					switch (0) {
						default:
						{
							scan_direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
							break;
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label3) ? _tmp36_label3 : (_tmp36_label3 = g_quark_from_static_string ("RIGHT_TO_LEFT")))) {
					switch (0) {
						default:
						{
							scan_direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
							break;
						}
					}
				}
				_tmp38_ = file;
				_tmp39_ = page_name;
				_tmp40_ = autosave_manager_get_value (self, _tmp38_, _tmp39_, "color-profile", "");
				color_profile = _tmp40_;
				_tmp41_ = color_profile;
				if (g_strcmp0 (_tmp41_, "") == 0) {
					_g_free0 (color_profile);
					color_profile = NULL;
				}
				_tmp42_ = file;
				_tmp43_ = page_name;
				_tmp44_ = autosave_manager_get_value (self, _tmp42_, _tmp43_, "pixels-filename", "");
				pixels_filename = _tmp44_;
				_tmp45_ = file;
				_tmp46_ = page_name;
				_tmp47_ = autosave_manager_get_boolean (self, _tmp45_, _tmp46_, "has-crop", FALSE);
				has_crop = _tmp47_;
				_tmp48_ = file;
				_tmp49_ = page_name;
				_tmp50_ = autosave_manager_get_value (self, _tmp48_, _tmp49_, "crop-name", "");
				crop_name = _tmp50_;
				_tmp51_ = crop_name;
				if (g_strcmp0 (_tmp51_, "") == 0) {
					_g_free0 (crop_name);
					crop_name = NULL;
				}
				_tmp52_ = file;
				_tmp53_ = page_name;
				_tmp54_ = autosave_manager_get_integer (self, _tmp52_, _tmp53_, "crop-x", 0);
				crop_x = _tmp54_;
				_tmp55_ = file;
				_tmp56_ = page_name;
				_tmp57_ = autosave_manager_get_integer (self, _tmp55_, _tmp56_, "crop-y", 0);
				crop_y = _tmp57_;
				_tmp58_ = file;
				_tmp59_ = page_name;
				_tmp60_ = autosave_manager_get_integer (self, _tmp58_, _tmp59_, "crop-width", 0);
				crop_width = _tmp60_;
				_tmp61_ = file;
				_tmp62_ = page_name;
				_tmp63_ = autosave_manager_get_integer (self, _tmp61_, _tmp62_, "crop-height", 0);
				crop_height = _tmp63_;
				pixels = NULL;
				pixels_length1 = 0;
				_pixels_size_ = pixels_length1;
				_tmp64_ = pixels_filename;
				if (g_strcmp0 (_tmp64_, "") != 0) {
					const gchar* _tmp65_;
					const gchar* _tmp66_;
					gchar* _tmp67_ = NULL;
					gchar* path;
					const gchar* _tmp68_;
					GFile* _tmp69_ = NULL;
					GFile* f;
					_tmp65_ = autosave_manager_AUTOSAVE_DIR;
					_tmp66_ = pixels_filename;
					_tmp67_ = g_build_filename (_tmp65_, _tmp66_, NULL);
					path = _tmp67_;
					_tmp68_ = path;
					_tmp69_ = g_file_new_for_path (_tmp68_);
					f = _tmp69_;
					{
						GFile* _tmp70_;
						guint8* _tmp71_ = NULL;
						gsize _tmp72_;
						_tmp70_ = f;
						g_file_load_contents (_tmp70_, NULL, &_tmp71_, &_tmp72_, NULL, &_inner_error_);
						pixels = (g_free (pixels), NULL);
						pixels = _tmp71_;
						pixels_length1 = _tmp72_;
						_pixels_size_ = pixels_length1;
						if (_inner_error_ != NULL) {
							goto __catch23_g_error;
						}
					}
					goto __finally23;
					__catch23_g_error:
					{
						GError* e = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						g_warning ("autosave-manager.vala:131: Failed to load pixel information");
						_g_error_free0 (e);
						_g_object_unref0 (f);
						_g_free0 (path);
						pixels = (g_free (pixels), NULL);
						_g_free0 (crop_name);
						_g_free0 (pixels_filename);
						_g_free0 (color_profile);
						_g_free0 (scan_direction_name);
						_g_free0 (page_name);
						continue;
					}
					__finally23:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (f);
						_g_free0 (path);
						pixels = (g_free (pixels), NULL);
						_g_free0 (crop_name);
						_g_free0 (pixels_filename);
						_g_free0 (color_profile);
						_g_free0 (scan_direction_name);
						_g_free0 (page_name);
						page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (pages);
						_g_key_file_unref0 (file);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (f);
					_g_free0 (path);
				}
				_tmp73_ = scan_width;
				_tmp74_ = scan_height;
				_tmp75_ = rowstride;
				_tmp76_ = n_channels;
				_tmp77_ = depth;
				_tmp78_ = dpi;
				_tmp79_ = scan_direction;
				_tmp80_ = color_profile;
				_tmp81_ = pixels;
				_tmp81__length1 = pixels_length1;
				_tmp82_ = has_crop;
				_tmp83_ = crop_name;
				_tmp84_ = crop_x;
				_tmp85_ = crop_y;
				_tmp86_ = crop_width;
				_tmp87_ = crop_height;
				_tmp88_ = page_new_from_data (_tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp77_, _tmp78_, _tmp79_, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_, _tmp83_, _tmp84_, _tmp85_, _tmp86_, _tmp87_);
				page = _tmp88_;
				_tmp89_ = self->priv->page_filenames;
				_tmp90_ = page;
				_tmp91_ = _page_ref0 (_tmp90_);
				_tmp92_ = pixels_filename;
				_tmp93_ = g_strdup (_tmp92_);
				g_hash_table_insert (_tmp89_, _tmp91_, _tmp93_);
				_tmp94_ = autosave_manager_get_book (self);
				_tmp95_ = _tmp94_;
				_tmp96_ = page;
				book_append_page (_tmp95_, _tmp96_);
				_page_unref0 (page);
				pixels = (g_free (pixels), NULL);
				_g_free0 (crop_name);
				_g_free0 (pixels_filename);
				_g_free0 (color_profile);
				_g_free0 (scan_direction_name);
				_g_free0 (page_name);
			}
		}
		page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (pages);
	_g_key_file_unref0 (file);
}


static gchar* autosave_manager_get_value (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, const gchar* _default_) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (_default_ != NULL, NULL);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp0_ = file;
		_tmp1_ = group_name;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_value (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		result = _tmp4_;
		return result;
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _default_;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_error_free0 (e);
		return result;
	}
	__finally24:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gint autosave_manager_get_integer (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gint _default_) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (file != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_;
		_tmp0_ = file;
		_tmp1_ = group_name;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_integer (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
		result = _tmp4_;
		return result;
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		gint _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _default_;
		result = _tmp5_;
		_g_error_free0 (e);
		return result;
	}
	__finally25:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gboolean autosave_manager_get_boolean (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gboolean _default_) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		_tmp0_ = file;
		_tmp1_ = group_name;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_boolean (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		result = _tmp4_;
		return result;
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		gboolean _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _default_;
		result = _tmp5_;
		_g_error_free0 (e);
		return result;
	}
	__finally26:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


void autosave_manager_cleanup (AutosaveManager* self) {
	guint _tmp0_;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("autosave-manager.vala:194: Deleting autosave records");
	_tmp0_ = self->priv->update_timeout;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->update_timeout;
		g_source_remove (_tmp1_);
	}
	self->priv->update_timeout = (guint) 0;
	{
		const gchar* _tmp2_;
		GDir* _tmp3_ = NULL;
		GDir* _tmp4_;
		_tmp2_ = autosave_manager_AUTOSAVE_DIR;
		_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
		_g_dir_close0 (dir);
		dir = _tmp4_;
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("autosave-manager.vala:207: Failed to delete autosaves: %s", _tmp6_);
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return;
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	while (TRUE) {
		GDir* _tmp7_;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* filename;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* path;
		const gchar* _tmp14_;
		_tmp7_ = dir;
		_tmp8_ = g_dir_read_name (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		filename = _tmp9_;
		_tmp10_ = filename;
		if (_tmp10_ == NULL) {
			_g_free0 (filename);
			break;
		}
		_tmp11_ = autosave_manager_AUTOSAVE_DIR;
		_tmp12_ = filename;
		_tmp13_ = g_build_filename (_tmp11_, _tmp12_, NULL);
		path = _tmp13_;
		_tmp14_ = path;
		g_unlink (_tmp14_);
		_g_free0 (path);
		_g_free0 (filename);
	}
	_g_dir_close0 (dir);
}


static void _autosave_manager_on_scan_finished_page_scan_finished (Page* _sender, gpointer self) {
	autosave_manager_on_scan_finished (self, _sender);
}


static void _autosave_manager_on_changed_page_crop_changed (Page* _sender, gpointer self) {
	autosave_manager_on_changed (self);
}


void autosave_manager_on_page_added (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	g_signal_connect (_tmp0_, "scan-finished", (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
	_tmp1_ = page;
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
}


void autosave_manager_on_page_removed (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	GHashTable* _tmp4_;
	Page* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* filename;
	const gchar* _tmp8_;
	GHashTable* _tmp10_;
	Page* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	g_signal_parse_name ("scan-finished", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
	_tmp2_ = page;
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
	_tmp4_ = self->priv->page_filenames;
	_tmp5_ = page;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	filename = _tmp7_;
	_tmp8_ = filename;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		_tmp9_ = filename;
		g_unlink (_tmp9_);
	}
	_tmp10_ = self->priv->page_filenames;
	_tmp11_ = page;
	g_hash_table_remove (_tmp10_, _tmp11_);
	_g_free0 (filename);
}


void autosave_manager_on_scan_finished (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	autosave_manager_save_pixels (self, _tmp0_);
	autosave_manager_save (self, FALSE);
}


void autosave_manager_on_changed (AutosaveManager* self) {
	g_return_if_fail (self != NULL);
	autosave_manager_save (self, TRUE);
}


void autosave_manager_on_cleared (AutosaveManager* self) {
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page_filenames;
	g_hash_table_remove_all (_tmp0_);
	autosave_manager_save (self, TRUE);
}


static gboolean ___lambda2_ (AutosaveManager* self) {
	gboolean result = FALSE;
	autosave_manager_real_save (self);
	self->priv->update_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ____lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda2_ (self);
	return result;
}


static void autosave_manager_save (AutosaveManager* self, gboolean do_timeout) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp3_;
	guint _tmp4_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->update_timeout;
	if (_tmp1_ == ((guint) 0)) {
		gboolean _tmp2_;
		_tmp2_ = do_timeout;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		g_debug ("autosave-manager.vala:258: Waiting to autosave...");
	}
	_tmp4_ = self->priv->update_timeout;
	if (_tmp4_ > ((guint) 0)) {
		guint _tmp5_;
		_tmp5_ = self->priv->update_timeout;
		g_source_remove (_tmp5_);
	}
	self->priv->update_timeout = (guint) 0;
	_tmp6_ = do_timeout;
	if (_tmp6_) {
		guint _tmp7_ = 0U;
		_tmp7_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda2__gsource_func, autosave_manager_ref (self), autosave_manager_unref);
		self->priv->update_timeout = _tmp7_;
	} else {
		autosave_manager_real_save (self);
	}
}


static void autosave_manager_real_save (AutosaveManager* self) {
	GKeyFile* _tmp0_;
	GKeyFile* file;
	gchar* _tmp1_;
	gchar* page_names;
	GKeyFile* _tmp105_;
	const gchar* _tmp106_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("autosave-manager.vala:280: Autosaving book information");
	_tmp0_ = g_key_file_new ();
	file = _tmp0_;
	_tmp1_ = g_strdup ("");
	page_names = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				Book* _tmp6_;
				Book* _tmp7_;
				guint _tmp8_ = 0U;
				Book* _tmp9_;
				Book* _tmp10_;
				gint _tmp11_;
				Page* _tmp12_ = NULL;
				Page* page;
				Page* _tmp13_;
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* page_name;
				const gchar* _tmp17_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				GKeyFile* _tmp24_;
				const gchar* _tmp25_;
				Page* _tmp26_;
				gint _tmp27_ = 0;
				GKeyFile* _tmp28_;
				const gchar* _tmp29_;
				Page* _tmp30_;
				gint _tmp31_ = 0;
				GKeyFile* _tmp32_;
				const gchar* _tmp33_;
				Page* _tmp34_;
				gint _tmp35_ = 0;
				GKeyFile* _tmp36_;
				const gchar* _tmp37_;
				Page* _tmp38_;
				gint _tmp39_ = 0;
				GKeyFile* _tmp40_;
				const gchar* _tmp41_;
				Page* _tmp42_;
				gint _tmp43_ = 0;
				GKeyFile* _tmp44_;
				const gchar* _tmp45_;
				Page* _tmp46_;
				gint _tmp47_ = 0;
				Page* _tmp48_;
				ScanDirection _tmp49_ = 0;
				Page* _tmp58_;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_;
				const gchar* _tmp61_;
				GKeyFile* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				GHashTable* _tmp66_;
				Page* _tmp67_;
				gconstpointer _tmp68_ = NULL;
				gchar* _tmp69_;
				gchar* _tmp70_;
				const gchar* _tmp71_;
				GKeyFile* _tmp73_;
				const gchar* _tmp74_;
				const gchar* _tmp75_;
				GKeyFile* _tmp76_;
				const gchar* _tmp77_;
				Page* _tmp78_;
				gboolean _tmp79_ = FALSE;
				gint cx = 0;
				gint cy = 0;
				gint cw = 0;
				gint ch = 0;
				Page* _tmp80_;
				gint _tmp81_ = 0;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				Page* _tmp85_;
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_;
				const gchar* _tmp88_;
				GKeyFile* _tmp90_;
				const gchar* _tmp91_;
				const gchar* _tmp92_;
				GKeyFile* _tmp93_;
				const gchar* _tmp94_;
				gint _tmp95_;
				GKeyFile* _tmp96_;
				const gchar* _tmp97_;
				gint _tmp98_;
				GKeyFile* _tmp99_;
				const gchar* _tmp100_;
				gint _tmp101_;
				GKeyFile* _tmp102_;
				const gchar* _tmp103_;
				gint _tmp104_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = autosave_manager_get_book (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = book_get_n_pages (_tmp7_);
				if (!(((guint) _tmp5_) < _tmp8_)) {
					break;
				}
				_tmp9_ = autosave_manager_get_book (self);
				_tmp10_ = _tmp9_;
				_tmp11_ = i;
				_tmp12_ = book_get_page (_tmp10_, _tmp11_);
				page = _tmp12_;
				_tmp13_ = page;
				_tmp14_ = page_has_data (_tmp13_);
				if (!_tmp14_) {
					_page_unref0 (page);
					continue;
				}
				_tmp15_ = i;
				_tmp16_ = g_strdup_printf ("page-%d", _tmp15_);
				page_name = _tmp16_;
				_tmp17_ = page_names;
				if (g_strcmp0 (_tmp17_, "") != 0) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp18_ = page_names;
					_tmp19_ = g_strconcat (_tmp18_, " ", NULL);
					_g_free0 (page_names);
					page_names = _tmp19_;
				}
				_tmp20_ = page_names;
				_tmp21_ = page_name;
				_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
				_g_free0 (page_names);
				page_names = _tmp22_;
				_tmp23_ = page_name;
				g_debug ("autosave-manager.vala:297: Autosaving page %s", _tmp23_);
				_tmp24_ = file;
				_tmp25_ = page_name;
				_tmp26_ = page;
				_tmp27_ = page_get_scan_width (_tmp26_);
				g_key_file_set_integer (_tmp24_, _tmp25_, "scan-width", _tmp27_);
				_tmp28_ = file;
				_tmp29_ = page_name;
				_tmp30_ = page;
				_tmp31_ = page_get_scan_height (_tmp30_);
				g_key_file_set_integer (_tmp28_, _tmp29_, "scan-height", _tmp31_);
				_tmp32_ = file;
				_tmp33_ = page_name;
				_tmp34_ = page;
				_tmp35_ = page_get_rowstride (_tmp34_);
				g_key_file_set_integer (_tmp32_, _tmp33_, "rowstride", _tmp35_);
				_tmp36_ = file;
				_tmp37_ = page_name;
				_tmp38_ = page;
				_tmp39_ = page_get_n_channels (_tmp38_);
				g_key_file_set_integer (_tmp36_, _tmp37_, "n-channels", _tmp39_);
				_tmp40_ = file;
				_tmp41_ = page_name;
				_tmp42_ = page;
				_tmp43_ = page_get_depth (_tmp42_);
				g_key_file_set_integer (_tmp40_, _tmp41_, "depth", _tmp43_);
				_tmp44_ = file;
				_tmp45_ = page_name;
				_tmp46_ = page;
				_tmp47_ = page_get_dpi (_tmp46_);
				g_key_file_set_integer (_tmp44_, _tmp45_, "dpi", _tmp47_);
				_tmp48_ = page;
				_tmp49_ = page_get_scan_direction (_tmp48_);
				switch (_tmp49_) {
					case SCAN_DIRECTION_TOP_TO_BOTTOM:
					{
						GKeyFile* _tmp50_;
						const gchar* _tmp51_;
						_tmp50_ = file;
						_tmp51_ = page_name;
						g_key_file_set_value (_tmp50_, _tmp51_, "scan-direction", "TOP_TO_BOTTOM");
						break;
					}
					case SCAN_DIRECTION_LEFT_TO_RIGHT:
					{
						GKeyFile* _tmp52_;
						const gchar* _tmp53_;
						_tmp52_ = file;
						_tmp53_ = page_name;
						g_key_file_set_value (_tmp52_, _tmp53_, "scan-direction", "LEFT_TO_RIGHT");
						break;
					}
					case SCAN_DIRECTION_BOTTOM_TO_TOP:
					{
						GKeyFile* _tmp54_;
						const gchar* _tmp55_;
						_tmp54_ = file;
						_tmp55_ = page_name;
						g_key_file_set_value (_tmp54_, _tmp55_, "scan-direction", "BOTTOM_TO_TOP");
						break;
					}
					case SCAN_DIRECTION_RIGHT_TO_LEFT:
					{
						GKeyFile* _tmp56_;
						const gchar* _tmp57_;
						_tmp56_ = file;
						_tmp57_ = page_name;
						g_key_file_set_value (_tmp56_, _tmp57_, "scan-direction", "RIGHT_TO_LEFT");
						break;
					}
					default:
					break;
				}
				_tmp58_ = page;
				_tmp59_ = page_get_color_profile (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = _tmp60_;
				if (_tmp61_ == NULL) {
					gchar* _tmp62_;
					_tmp62_ = g_strdup ("");
					_g_free0 (_tmp60_);
					_tmp60_ = _tmp62_;
				}
				_tmp63_ = file;
				_tmp64_ = page_name;
				_tmp65_ = _tmp60_;
				g_key_file_set_value (_tmp63_, _tmp64_, "color-profile", _tmp65_);
				_tmp66_ = self->priv->page_filenames;
				_tmp67_ = page;
				_tmp68_ = g_hash_table_lookup (_tmp66_, _tmp67_);
				_tmp69_ = g_strdup ((const gchar*) _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = _tmp70_;
				if (_tmp71_ == NULL) {
					gchar* _tmp72_;
					_tmp72_ = g_strdup ("");
					_g_free0 (_tmp70_);
					_tmp70_ = _tmp72_;
				}
				_tmp73_ = file;
				_tmp74_ = page_name;
				_tmp75_ = _tmp70_;
				g_key_file_set_value (_tmp73_, _tmp74_, "pixels-filename", _tmp75_);
				_tmp76_ = file;
				_tmp77_ = page_name;
				_tmp78_ = page;
				_tmp79_ = page_has_crop (_tmp78_);
				g_key_file_set_boolean (_tmp76_, _tmp77_, "has-crop", _tmp79_);
				_tmp80_ = page;
				page_get_crop (_tmp80_, &_tmp81_, &_tmp82_, &_tmp83_, &_tmp84_);
				cx = _tmp81_;
				cy = _tmp82_;
				cw = _tmp83_;
				ch = _tmp84_;
				_tmp85_ = page;
				_tmp86_ = page_get_named_crop (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = _tmp87_;
				if (_tmp88_ == NULL) {
					gchar* _tmp89_;
					_tmp89_ = g_strdup ("");
					_g_free0 (_tmp87_);
					_tmp87_ = _tmp89_;
				}
				_tmp90_ = file;
				_tmp91_ = page_name;
				_tmp92_ = _tmp87_;
				g_key_file_set_value (_tmp90_, _tmp91_, "crop-name", _tmp92_);
				_tmp93_ = file;
				_tmp94_ = page_name;
				_tmp95_ = cx;
				g_key_file_set_integer (_tmp93_, _tmp94_, "crop-x", _tmp95_);
				_tmp96_ = file;
				_tmp97_ = page_name;
				_tmp98_ = cy;
				g_key_file_set_integer (_tmp96_, _tmp97_, "crop-y", _tmp98_);
				_tmp99_ = file;
				_tmp100_ = page_name;
				_tmp101_ = cw;
				g_key_file_set_integer (_tmp99_, _tmp100_, "crop-width", _tmp101_);
				_tmp102_ = file;
				_tmp103_ = page_name;
				_tmp104_ = ch;
				g_key_file_set_integer (_tmp102_, _tmp103_, "crop-height", _tmp104_);
				_g_free0 (_tmp87_);
				_g_free0 (_tmp70_);
				_g_free0 (_tmp60_);
				_g_free0 (page_name);
				_page_unref0 (page);
			}
		}
	}
	_tmp105_ = file;
	_tmp106_ = page_names;
	g_key_file_set_value (_tmp105_, "simple-scan", "pages", _tmp106_);
	{
		const gchar* _tmp107_;
		const gchar* _tmp108_;
		GKeyFile* _tmp109_;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_;
		_tmp107_ = autosave_manager_AUTOSAVE_DIR;
		g_mkdir_with_parents (_tmp107_, 0777);
		_tmp108_ = autosave_manager_AUTOSAVE_PATH;
		_tmp109_ = file;
		_tmp110_ = g_key_file_to_data (_tmp109_, NULL, NULL);
		_tmp111_ = _tmp110_;
		g_file_set_contents (_tmp108_, _tmp111_, (gssize) (-1), &_inner_error_);
		_g_free0 (_tmp111_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp112_;
		const gchar* _tmp113_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp112_ = e;
		_tmp113_ = _tmp112_->message;
		g_warning ("autosave-manager.vala:340: Failed to write autosave: %s", _tmp113_);
		_g_error_free0 (e);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_free0 (page_names);
		_g_key_file_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (page_names);
	_g_key_file_unref0 (file);
}


static void autosave_manager_save_pixels (AutosaveManager* self, Page* page) {
	GHashFunc _tmp0_;
	Page* _tmp1_;
	guint _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	gchar* filename;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* path;
	GHashTable* _tmp6_;
	Page* _tmp7_;
	Page* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = page;
	_tmp2_ = _tmp0_ (_tmp1_);
	_tmp3_ = g_strdup_printf ("%u.pixels", _tmp2_);
	filename = _tmp3_;
	_tmp4_ = autosave_manager_AUTOSAVE_DIR;
	_tmp5_ = g_build_filename (_tmp4_, filename, NULL);
	path = _tmp5_;
	_tmp6_ = self->priv->page_filenames;
	_tmp7_ = page;
	_tmp8_ = _page_ref0 (_tmp7_);
	_tmp9_ = g_strdup (filename);
	g_hash_table_insert (_tmp6_, _tmp8_, _tmp9_);
	g_debug ("autosave-manager.vala:350: Autosaving page pixels to %s", path);
	_tmp10_ = g_file_new_for_path (path);
	file = _tmp10_;
	{
		Page* _tmp11_;
		gint _tmp12_ = 0;
		guchar* _tmp13_ = NULL;
		_tmp11_ = page;
		_tmp13_ = page_get_pixels (_tmp11_, &_tmp12_);
		g_file_replace_contents (file, _tmp13_, (gsize) _tmp12_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch29_g_error;
		}
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("autosave-manager.vala:359: Failed to autosave page contents: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (path);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (path);
	_g_free0 (filename);
}


Book* autosave_manager_get_book (AutosaveManager* self) {
	Book* result;
	Book* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book_;
	result = _tmp0_;
	return result;
}


static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self) {
	autosave_manager_on_page_added (self, page);
}


static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self) {
	autosave_manager_on_page_removed (self, page);
}


static void _autosave_manager_on_changed_book_reordered (Book* _sender, gpointer self) {
	autosave_manager_on_changed (self);
}


static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self) {
	autosave_manager_on_cleared (self);
}


static gpointer _book_ref0 (gpointer self) {
	return self ? book_ref (self) : NULL;
}


void autosave_manager_set_book (AutosaveManager* self, Book* value) {
	Book* _tmp0_;
	Book* _tmp19_;
	Book* _tmp20_;
	Book* _tmp21_;
	Book* _tmp22_;
	Book* _tmp23_;
	Book* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_;
	if (_tmp0_ != NULL) {
		Book* _tmp11_;
		guint _tmp12_ = 0U;
		Book* _tmp13_;
		guint _tmp14_ = 0U;
		Book* _tmp15_;
		guint _tmp16_ = 0U;
		Book* _tmp17_;
		guint _tmp18_ = 0U;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					gboolean _tmp2_;
					gint _tmp4_;
					Book* _tmp5_;
					guint _tmp6_ = 0U;
					Book* _tmp7_;
					gint _tmp8_;
					Page* _tmp9_ = NULL;
					Page* page;
					Page* _tmp10_;
					_tmp2_ = _tmp1_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp4_ = i;
					_tmp5_ = self->priv->book_;
					_tmp6_ = book_get_n_pages (_tmp5_);
					if (!(((guint) _tmp4_) < _tmp6_)) {
						break;
					}
					_tmp7_ = self->priv->book_;
					_tmp8_ = i;
					_tmp9_ = book_get_page (_tmp7_, _tmp8_);
					page = _tmp9_;
					_tmp10_ = page;
					autosave_manager_on_page_removed (self, _tmp10_);
					_page_unref0 (page);
				}
			}
		}
		_tmp11_ = self->priv->book_;
		g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp12_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _autosave_manager_on_page_added_book_page_added, self);
		_tmp13_ = self->priv->book_;
		g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp14_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
		_tmp15_ = self->priv->book_;
		g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp16_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _autosave_manager_on_changed_book_reordered, self);
		_tmp17_ = self->priv->book_;
		g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp18_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _autosave_manager_on_cleared_book_cleared, self);
	}
	_tmp19_ = value;
	_tmp20_ = _book_ref0 (_tmp19_);
	_book_unref0 (self->priv->book_);
	self->priv->book_ = _tmp20_;
	_tmp21_ = self->priv->book_;
	g_signal_connect (_tmp21_, "page-added", (GCallback) _autosave_manager_on_page_added_book_page_added, self);
	_tmp22_ = self->priv->book_;
	g_signal_connect (_tmp22_, "page-removed", (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
	_tmp23_ = self->priv->book_;
	g_signal_connect (_tmp23_, "reordered", (GCallback) _autosave_manager_on_changed_book_reordered, self);
	_tmp24_ = self->priv->book_;
	g_signal_connect (_tmp24_, "cleared", (GCallback) _autosave_manager_on_cleared_book_cleared, self);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp25_;
			_tmp25_ = TRUE;
			while (TRUE) {
				gboolean _tmp26_;
				gint _tmp28_;
				Book* _tmp29_;
				guint _tmp30_ = 0U;
				Book* _tmp31_;
				gint _tmp32_;
				Page* _tmp33_ = NULL;
				Page* page;
				Page* _tmp34_;
				_tmp26_ = _tmp25_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp28_ = i;
				_tmp29_ = self->priv->book_;
				_tmp30_ = book_get_n_pages (_tmp29_);
				if (!(((guint) _tmp28_) < _tmp30_)) {
					break;
				}
				_tmp31_ = self->priv->book_;
				_tmp32_ = i;
				_tmp33_ = book_get_page (_tmp31_, _tmp32_);
				page = _tmp33_;
				_tmp34_ = page;
				autosave_manager_on_page_added (self, _tmp34_);
				_page_unref0 (page);
			}
		}
	}
}


static void value_autosave_manager_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_autosave_manager_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		autosave_manager_unref (value->data[0].v_pointer);
	}
}


static void value_autosave_manager_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = autosave_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_autosave_manager_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_autosave_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AutosaveManager* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = autosave_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_autosave_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AutosaveManager** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = autosave_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAutosaveManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AUTOSAVE_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_autosave_manager (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER), NULL);
	return value->data[0].v_pointer;
}


void value_set_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		autosave_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		autosave_manager_unref (old);
	}
}


void value_take_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		autosave_manager_unref (old);
	}
}


static void autosave_manager_class_init (AutosaveManagerClass * klass) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	autosave_manager_parent_class = g_type_class_peek_parent (klass);
	AUTOSAVE_MANAGER_CLASS (klass)->finalize = autosave_manager_finalize;
	g_type_class_add_private (klass, sizeof (AutosaveManagerPrivate));
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "autosaves", NULL);
	autosave_manager_AUTOSAVE_DIR = _tmp1_;
	_tmp2_ = g_strdup ("autosave.book");
	autosave_manager_AUTOSAVE_FILENAME = _tmp2_;
	_tmp3_ = autosave_manager_AUTOSAVE_DIR;
	_tmp4_ = autosave_manager_AUTOSAVE_FILENAME;
	_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
	autosave_manager_AUTOSAVE_PATH = _tmp5_;
}


static void autosave_manager_instance_init (AutosaveManager * self) {
	self->priv = AUTOSAVE_MANAGER_GET_PRIVATE (self);
	self->priv->update_timeout = (guint) 0;
	self->priv->book_ = NULL;
	self->ref_count = 1;
}


static void autosave_manager_finalize (AutosaveManager* obj) {
	AutosaveManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTOSAVE_MANAGER, AutosaveManager);
	_g_hash_table_unref0 (self->priv->page_filenames);
	_book_unref0 (self->priv->book_);
}


GType autosave_manager_get_type (void) {
	static volatile gsize autosave_manager_type_id__volatile = 0;
	if (g_once_init_enter (&autosave_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_autosave_manager_init, value_autosave_manager_free_value, value_autosave_manager_copy_value, value_autosave_manager_peek_pointer, "p", value_autosave_manager_collect_value, "p", value_autosave_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AutosaveManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) autosave_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AutosaveManager), 0, (GInstanceInitFunc) autosave_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType autosave_manager_type_id;
		autosave_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AutosaveManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&autosave_manager_type_id__volatile, autosave_manager_type_id);
	}
	return autosave_manager_type_id__volatile;
}


gpointer autosave_manager_ref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void autosave_manager_unref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AUTOSAVE_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



