/* simple-scan.c generated by valac 0.22.1, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gudev/gudev.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include "colord.h"
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include "config.h"


#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _user_interface_unref0(var) ((var == NULL) ? NULL : (var = (user_interface_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _SimpleScan {
	GtkApplication parent_instance;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	GtkApplicationClass parent_class;
};

struct _SimpleScanPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUdevClient* udev_client;
	UserInterface* ui;
	Scanner* scanner;
	Book* book;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};


static gpointer simple_scan_parent_class = NULL;
static gboolean simple_scan_show_version;
static gboolean simple_scan_show_version = FALSE;
static gboolean simple_scan_debug_enabled;
static gboolean simple_scan_debug_enabled = FALSE;
static gchar* simple_scan_fix_pdf_filename;
static gchar* simple_scan_fix_pdf_filename = NULL;
static GTimer* simple_scan_log_timer;
static GTimer* simple_scan_log_timer = NULL;
static FILE* simple_scan_log_file;
static FILE* simple_scan_log_file = NULL;

GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
gpointer user_interface_ref (gpointer instance);
void user_interface_unref (gpointer instance);
GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_interface (GValue* value, gpointer v_object);
void value_take_user_interface (GValue* value, gpointer v_object);
gpointer value_get_user_interface (const GValue* value);
GType user_interface_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define SIMPLE_SCAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_SCAN, SimpleScanPrivate))
enum  {
	SIMPLE_SCAN_DUMMY_PROPERTY
};
SimpleScan* simple_scan_new (ScanDevice* device);
SimpleScan* simple_scan_construct (GType object_type, ScanDevice* device);
static void simple_scan_real_startup (GApplication* base);
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* user_interface_get_book (UserInterface* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static void simple_scan_scan_cb (SimpleScan* self, UserInterface* ui, const gchar* device, ScanOptions* options);
static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender, const gchar* device, ScanOptions* options, gpointer self);
static void simple_scan_cancel_cb (SimpleScan* self, UserInterface* ui);
static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender, gpointer self);
static void simple_scan_email_cb (SimpleScan* self, UserInterface* ui, const gchar* profile);
static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender, const gchar* profile, gpointer self);
Scanner* scanner_get_instance (void);
static void simple_scan_update_scan_devices_cb (SimpleScan* self, Scanner* scanner, GList* devices);
static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self);
static void simple_scan_authorize_cb (SimpleScan* self, Scanner* scanner, const gchar* resource);
static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self);
static void simple_scan_scanner_new_page_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_page_info_cb (SimpleScan* self, Scanner* scanner, ScanPageInfo* info);
static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_line_cb (SimpleScan* self, Scanner* scanner, ScanLine* line);
static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self);
static void simple_scan_scanner_page_done_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self);
static void simple_scan_scanner_document_done_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self);
static void simple_scan_scanner_failed_cb (SimpleScan* self, Scanner* scanner, gint error_code, const gchar* error_string);
static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self);
static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self);
static void simple_scan_on_uevent (SimpleScan* self, GUdevClient* client, const gchar* action, GUdevDevice* device);
static void _simple_scan_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
void user_interface_set_selected_device (UserInterface* self, const gchar* device);
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
static void simple_scan_real_activate (GApplication* base);
void user_interface_start (UserInterface* self);
void scanner_start (Scanner* self);
static void simple_scan_real_shutdown (GApplication* base);
void scanner_free (Scanner* self);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static Page* simple_scan_append_page (SimpleScan* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_has_data (Page* self);
void user_interface_set_selected_page (UserInterface* self, Page* page);
void page_start (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void page_set_named_crop (Page* self, const gchar* name);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
static gchar* simple_scan_get_profile_for_device (SimpleScan* self, const gchar* device_name);
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* color_profile);
guint book_get_n_pages (Book* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
static void simple_scan_remove_empty_page (SimpleScan* self);
void book_delete_page (Book* self, Page* page);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void user_interface_set_scanning (UserInterface* self, gboolean scanning);
gboolean scanner_is_scanning (Scanner* self);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
void user_interface_hide_progress_dialog (UserInterface* self);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void simple_scan_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
void scanner_redetect (Scanner* self);
static void simple_scan_fix_pdf (const gchar* filename, GError** error);
gint simple_scan_main (gchar** args, int args_length1);
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void _simple_scan_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void simple_scan_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry SIMPLE_SCAN_options[4] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &simple_scan_show_version, "Show release version", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &simple_scan_debug_enabled, "Print debugging messages", NULL}, {"fix-pdf", (gchar) 0, 0, G_OPTION_ARG_STRING, &simple_scan_fix_pdf_filename, "Fix PDF files generated with older versions of Simple Scan", "FILENAME..."}, {NULL}};

static gpointer _scan_device_ref0 (gpointer self) {
	return self ? scan_device_ref (self) : NULL;
}


SimpleScan* simple_scan_construct (GType object_type, ScanDevice* device) {
	SimpleScan * self = NULL;
	ScanDevice* _tmp0_ = NULL;
	ScanDevice* _tmp1_ = NULL;
	self = (SimpleScan*) g_object_new (object_type, NULL);
	_tmp0_ = device;
	_tmp1_ = _scan_device_ref0 (_tmp0_);
	_scan_device_unref0 (self->priv->default_device);
	self->priv->default_device = _tmp1_;
	return self;
}


SimpleScan* simple_scan_new (ScanDevice* device) {
	return simple_scan_construct (TYPE_SIMPLE_SCAN, device);
}


static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender, const gchar* device, ScanOptions* options, gpointer self) {
	simple_scan_scan_cb (self, _sender, device, options);
}


static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender, gpointer self) {
	simple_scan_cancel_cb (self, _sender);
}


static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender, const gchar* profile, gpointer self) {
	simple_scan_email_cb (self, _sender, profile);
}


static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self) {
	simple_scan_update_scan_devices_cb (self, _sender, devices);
}


static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self) {
	simple_scan_authorize_cb (self, _sender, resource);
}


static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self) {
	simple_scan_scanner_new_page_cb (self, _sender);
}


static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self) {
	simple_scan_scanner_page_info_cb (self, _sender, info);
}


static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self) {
	simple_scan_scanner_line_cb (self, _sender, line);
}


static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self) {
	simple_scan_scanner_page_done_cb (self, _sender);
}


static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self) {
	simple_scan_scanner_document_done_cb (self, _sender);
}


static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self) {
	simple_scan_scanner_failed_cb (self, _sender, error_code, error_string);
}


static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self) {
	simple_scan_scanner_scanning_changed_cb (self, _sender);
}


static void _simple_scan_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
	simple_scan_on_uevent (self, _sender, action, device);
}


static void _scan_device_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
	g_list_free (self);
}


static void simple_scan_real_startup (GApplication* base) {
	SimpleScan * self;
	UserInterface* _tmp0_ = NULL;
	UserInterface* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	UserInterface* _tmp3_ = NULL;
	UserInterface* _tmp4_ = NULL;
	UserInterface* _tmp5_ = NULL;
	Scanner* _tmp6_ = NULL;
	Scanner* _tmp7_ = NULL;
	Scanner* _tmp8_ = NULL;
	Scanner* _tmp9_ = NULL;
	Scanner* _tmp10_ = NULL;
	Scanner* _tmp11_ = NULL;
	Scanner* _tmp12_ = NULL;
	Scanner* _tmp13_ = NULL;
	Scanner* _tmp14_ = NULL;
	Scanner* _tmp15_ = NULL;
	gchar** subsystems = NULL;
	gchar* _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint subsystems_length1 = 0;
	gint _subsystems_size_ = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	GUdevClient* _tmp19_ = NULL;
	GUdevClient* _tmp20_ = NULL;
	ScanDevice* _tmp21_ = NULL;
	self = (SimpleScan*) base;
	G_APPLICATION_CLASS (simple_scan_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = user_interface_new ();
	_user_interface_unref0 (self->priv->ui);
	self->priv->ui = _tmp0_;
	_tmp1_ = self->priv->ui;
	_tmp2_ = user_interface_get_book (_tmp1_);
	_book_unref0 (self->priv->book);
	self->priv->book = _tmp2_;
	_tmp3_ = self->priv->ui;
	g_signal_connect_object (_tmp3_, "start-scan", (GCallback) _simple_scan_scan_cb_user_interface_start_scan, self, 0);
	_tmp4_ = self->priv->ui;
	g_signal_connect_object (_tmp4_, "stop-scan", (GCallback) _simple_scan_cancel_cb_user_interface_stop_scan, self, 0);
	_tmp5_ = self->priv->ui;
	g_signal_connect_object (_tmp5_, "email", (GCallback) _simple_scan_email_cb_user_interface_email, self, 0);
	_tmp6_ = scanner_get_instance ();
	_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp6_;
	_tmp7_ = self->priv->scanner;
	g_signal_connect_object (_tmp7_, "update-devices", (GCallback) _simple_scan_update_scan_devices_cb_scanner_update_devices, self, 0);
	_tmp8_ = self->priv->scanner;
	g_signal_connect_object (_tmp8_, "request-authorization", (GCallback) _simple_scan_authorize_cb_scanner_request_authorization, self, 0);
	_tmp9_ = self->priv->scanner;
	g_signal_connect_object (_tmp9_, "expect-page", (GCallback) _simple_scan_scanner_new_page_cb_scanner_expect_page, self, 0);
	_tmp10_ = self->priv->scanner;
	g_signal_connect_object (_tmp10_, "got-page-info", (GCallback) _simple_scan_scanner_page_info_cb_scanner_got_page_info, self, 0);
	_tmp11_ = self->priv->scanner;
	g_signal_connect_object (_tmp11_, "got-line", (GCallback) _simple_scan_scanner_line_cb_scanner_got_line, self, 0);
	_tmp12_ = self->priv->scanner;
	g_signal_connect_object (_tmp12_, "page-done", (GCallback) _simple_scan_scanner_page_done_cb_scanner_page_done, self, 0);
	_tmp13_ = self->priv->scanner;
	g_signal_connect_object (_tmp13_, "document-done", (GCallback) _simple_scan_scanner_document_done_cb_scanner_document_done, self, 0);
	_tmp14_ = self->priv->scanner;
	g_signal_connect_object (_tmp14_, "scan-failed", (GCallback) _simple_scan_scanner_failed_cb_scanner_scan_failed, self, 0);
	_tmp15_ = self->priv->scanner;
	g_signal_connect_object (_tmp15_, "scanning-changed", (GCallback) _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed, self, 0);
	_tmp16_ = g_strdup ("usb");
	_tmp17_ = g_new0 (gchar*, 2 + 1);
	_tmp17_[0] = _tmp16_;
	_tmp17_[1] = NULL;
	subsystems = _tmp17_;
	subsystems_length1 = 2;
	_subsystems_size_ = subsystems_length1;
	_tmp18_ = subsystems;
	_tmp18__length1 = subsystems_length1;
	_tmp19_ = g_udev_client_new (_tmp18_);
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = _tmp19_;
	_tmp20_ = self->priv->udev_client;
	g_signal_connect_object (_tmp20_, "uevent", (GCallback) _simple_scan_on_uevent_g_udev_client_uevent, self, 0);
	_tmp21_ = self->priv->default_device;
	if (_tmp21_ != NULL) {
		GList* device_list = NULL;
		ScanDevice* _tmp22_ = NULL;
		ScanDevice* _tmp23_ = NULL;
		UserInterface* _tmp24_ = NULL;
		GList* _tmp25_ = NULL;
		UserInterface* _tmp26_ = NULL;
		ScanDevice* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		device_list = NULL;
		_tmp22_ = self->priv->default_device;
		_tmp23_ = _scan_device_ref0 (_tmp22_);
		device_list = g_list_append (device_list, _tmp23_);
		_tmp24_ = self->priv->ui;
		_tmp25_ = device_list;
		user_interface_set_scan_devices (_tmp24_, _tmp25_);
		_tmp26_ = self->priv->ui;
		_tmp27_ = self->priv->default_device;
		_tmp28_ = _tmp27_->name;
		user_interface_set_selected_device (_tmp26_, _tmp28_);
		__g_list_free__scan_device_unref0_0 (device_list);
	}
	subsystems = (_vala_array_free (subsystems, subsystems_length1, (GDestroyNotify) g_free), NULL);
}


static void simple_scan_real_activate (GApplication* base) {
	SimpleScan * self;
	UserInterface* _tmp0_ = NULL;
	Scanner* _tmp1_ = NULL;
	self = (SimpleScan*) base;
	G_APPLICATION_CLASS (simple_scan_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->ui;
	user_interface_start (_tmp0_);
	_tmp1_ = self->priv->scanner;
	scanner_start (_tmp1_);
}


static void simple_scan_real_shutdown (GApplication* base) {
	SimpleScan * self;
	Scanner* _tmp0_ = NULL;
	self = (SimpleScan*) base;
	G_APPLICATION_CLASS (simple_scan_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_book_unref0 (self->priv->book);
	self->priv->book = NULL;
	_user_interface_unref0 (self->priv->ui);
	self->priv->ui = NULL;
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = NULL;
	_tmp0_ = self->priv->scanner;
	scanner_free (_tmp0_);
}


static void simple_scan_update_scan_devices_cb (SimpleScan* self, Scanner* scanner, GList* devices) {
	GList* devices_copy = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	ScanDevice* _tmp2_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	UserInterface* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = devices;
	_tmp1_ = g_list_copy (_tmp0_);
	devices_copy = _tmp1_;
	_tmp2_ = self->priv->default_device;
	if (_tmp2_ != NULL) {
		gboolean default_in_list = FALSE;
		GList* _tmp3_ = NULL;
		gboolean _tmp8_ = FALSE;
		default_in_list = FALSE;
		_tmp3_ = devices_copy;
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
			device_collection = _tmp3_;
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
				ScanDevice* device = NULL;
				device = (ScanDevice*) device_it->data;
				{
					ScanDevice* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
					ScanDevice* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					_tmp4_ = device;
					_tmp5_ = _tmp4_->name;
					_tmp6_ = self->priv->default_device;
					_tmp7_ = _tmp6_->name;
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
						default_in_list = TRUE;
						break;
					}
				}
			}
		}
		_tmp8_ = default_in_list;
		if (!_tmp8_) {
			ScanDevice* _tmp9_ = NULL;
			_tmp9_ = self->priv->default_device;
			devices_copy = g_list_prepend (devices_copy, _tmp9_);
		}
	}
	_tmp10_ = devices_copy;
	_tmp11_ = g_list_length (_tmp10_);
	self->priv->have_devices = _tmp11_ > ((guint) 0);
	_tmp12_ = self->priv->ui;
	_tmp13_ = devices_copy;
	user_interface_set_scan_devices (_tmp12_, _tmp13_);
	_g_list_free0 (devices_copy);
}


static void simple_scan_authorize_cb (SimpleScan* self, Scanner* scanner, const gchar* resource) {
	gchar* username = NULL;
	gchar* password = NULL;
	UserInterface* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Scanner* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = self->priv->ui;
	_tmp1_ = resource;
	user_interface_authorize (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (username);
	username = _tmp2_;
	_g_free0 (password);
	password = _tmp3_;
	_tmp4_ = scanner;
	scanner_authorize (_tmp4_, username, password);
	_g_free0 (password);
	_g_free0 (username);
}


static Page* simple_scan_append_page (SimpleScan* self) {
	Page* result = NULL;
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Page* _tmp3_ = NULL;
	gboolean _tmp6_ = FALSE;
	ScanDirection scan_direction = 0;
	gboolean do_crop = FALSE;
	gchar* named_crop = NULL;
	gint width = 0;
	gint height = 0;
	gint dpi = 0;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp10_ = NULL;
	Book* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	ScanDirection _tmp33_ = 0;
	Page* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	UserInterface* _tmp45_ = NULL;
	Page* _tmp46_ = NULL;
	Page* _tmp47_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = book_get_page (_tmp0_, -1);
	page = _tmp1_;
	_tmp3_ = page;
	if (_tmp3_ != NULL) {
		Page* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = page;
		_tmp5_ = page_has_data (_tmp4_);
		_tmp2_ = !_tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		UserInterface* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
		Page* _tmp9_ = NULL;
		_tmp7_ = self->priv->ui;
		_tmp8_ = page;
		user_interface_set_selected_page (_tmp7_, _tmp8_);
		_tmp9_ = page;
		page_start (_tmp9_);
		result = page;
		return result;
	}
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
	do_crop = FALSE;
	named_crop = NULL;
	width = 100;
	height = 100;
	dpi = 100;
	cx = 0;
	cy = 0;
	cw = 0;
	ch = 0;
	_tmp10_ = page;
	if (_tmp10_ != NULL) {
		Page* _tmp11_ = NULL;
		ScanDirection _tmp12_ = 0;
		Page* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		Page* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		Page* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		Page* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp11_ = page;
		_tmp12_ = page_get_scan_direction (_tmp11_);
		scan_direction = _tmp12_;
		_tmp13_ = page;
		_tmp14_ = page_get_width (_tmp13_);
		width = _tmp14_;
		_tmp15_ = page;
		_tmp16_ = page_get_height (_tmp15_);
		height = _tmp16_;
		_tmp17_ = page;
		_tmp18_ = page_get_dpi (_tmp17_);
		dpi = _tmp18_;
		_tmp19_ = page;
		_tmp20_ = page_has_crop (_tmp19_);
		do_crop = _tmp20_;
		_tmp21_ = do_crop;
		if (_tmp21_) {
			Page* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			Page* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			_tmp22_ = page;
			_tmp23_ = page_get_named_crop (_tmp22_);
			_g_free0 (named_crop);
			named_crop = _tmp23_;
			_tmp24_ = page;
			page_get_crop (_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
			cx = _tmp25_;
			cy = _tmp26_;
			cw = _tmp27_;
			ch = _tmp28_;
		}
	}
	_tmp29_ = self->priv->book;
	_tmp30_ = width;
	_tmp31_ = height;
	_tmp32_ = dpi;
	_tmp33_ = scan_direction;
	_tmp34_ = book_append_page (_tmp29_, _tmp30_, _tmp31_, _tmp32_, _tmp33_);
	_page_unref0 (page);
	page = _tmp34_;
	_tmp35_ = do_crop;
	if (_tmp35_) {
		const gchar* _tmp36_ = NULL;
		Page* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		_tmp36_ = named_crop;
		if (_tmp36_ != NULL) {
			Page* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			_tmp37_ = page;
			_tmp38_ = named_crop;
			page_set_named_crop (_tmp37_, _tmp38_);
		} else {
			Page* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			_tmp39_ = page;
			_tmp40_ = cw;
			_tmp41_ = ch;
			page_set_custom_crop (_tmp39_, _tmp40_, _tmp41_);
		}
		_tmp42_ = page;
		_tmp43_ = cx;
		_tmp44_ = cy;
		page_move_crop (_tmp42_, _tmp43_, _tmp44_);
	}
	_tmp45_ = self->priv->ui;
	_tmp46_ = page;
	user_interface_set_selected_page (_tmp45_, _tmp46_);
	_tmp47_ = page;
	page_start (_tmp47_);
	result = page;
	_g_free0 (named_crop);
	return result;
}


static void simple_scan_scanner_new_page_cb (SimpleScan* self, Scanner* scanner) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = simple_scan_append_page (self);
	_tmp1_ = _tmp0_;
	_page_unref0 (_tmp1_);
}


static gchar* simple_scan_get_profile_for_device (SimpleScan* self, const gchar* device_name) {
	gchar* result = NULL;
	gchar* device_id = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CdClient* client = NULL;
	CdClient* _tmp3_ = NULL;
	CdDevice* device = NULL;
	CdProfile* profile = NULL;
	CdDevice* _tmp18_ = NULL;
	CdProfile* _tmp19_ = NULL;
	CdProfile* _tmp20_ = NULL;
	CdProfile* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	CdProfile* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	CdProfile* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_name != NULL, NULL);
	_tmp0_ = device_name;
	_tmp1_ = g_strdup_printf ("sane:%s", _tmp0_);
	device_id = _tmp1_;
	_tmp2_ = device_name;
	g_debug ("simple-scan.vala:184: Getting color profile for device %s", _tmp2_);
	_tmp3_ = cd_client_new ();
	client = _tmp3_;
	{
		CdClient* _tmp4_ = NULL;
		_tmp4_ = client;
		cd_client_connect_sync (_tmp4_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("simple-scan.vala:193: Failed to connect to colord: %s", _tmp6_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		CdDevice* _tmp7_ = NULL;
		CdClient* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		CdDevice* _tmp10_ = NULL;
		_tmp8_ = client;
		_tmp9_ = device_id;
		_tmp10_ = cd_client_find_device_by_property_sync (_tmp8_, CD_DEVICE_PROPERTY_SERIAL, _tmp9_, NULL, &_inner_error_);
		_tmp7_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_object_unref0 (device);
		device = _tmp7_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = device_name;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_debug ("simple-scan.vala:204: Unable to find colord device %s: %s", _tmp11_, _tmp13_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		CdDevice* _tmp14_ = NULL;
		_tmp14_ = device;
		cd_device_connect_sync (_tmp14_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = device_name;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_debug ("simple-scan.vala:214: Failed to get properties from the device %s: %s", _tmp15_, _tmp17_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp18_ = device;
	_tmp19_ = cd_device_get_default_profile (_tmp18_);
	profile = _tmp19_;
	_tmp20_ = profile;
	if (_tmp20_ == NULL) {
		const gchar* _tmp21_ = NULL;
		_tmp21_ = device_name;
		g_debug ("simple-scan.vala:221: No default color profile for device: %s", _tmp21_);
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	{
		CdProfile* _tmp22_ = NULL;
		_tmp22_ = profile;
		cd_profile_connect_sync (_tmp22_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = device_name;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_debug ("simple-scan.vala:231: Failed to get properties from the profile %s: %s", _tmp23_, _tmp25_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp26_ = profile;
	_tmp27_ = cd_profile_get_filename (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == NULL) {
		const gchar* _tmp29_ = NULL;
		_tmp29_ = device_name;
		g_debug ("simple-scan.vala:237: No icc color profile for the device %s", _tmp29_);
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	_tmp30_ = profile;
	_tmp31_ = cd_profile_get_filename (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = device_name;
	g_debug ("simple-scan.vala:241: Using color profile %s for device %s", _tmp32_, _tmp33_);
	_tmp34_ = profile;
	_tmp35_ = cd_profile_get_filename (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strdup (_tmp36_);
	result = _tmp37_;
	_g_object_unref0 (profile);
	_g_object_unref0 (device);
	_g_object_unref0 (client);
	_g_free0 (device_id);
	return result;
}


static void simple_scan_scanner_page_info_cb (SimpleScan* self, Scanner* scanner, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ScanPageInfo* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ScanPageInfo* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Page* page = NULL;
	Page* _tmp6_ = NULL;
	ScanPageInfo* _tmp7_ = NULL;
	ScanPageInfo* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = _tmp0_->width;
	_tmp2_ = info;
	_tmp3_ = _tmp2_->height;
	_tmp4_ = info;
	_tmp5_ = _tmp4_->depth;
	g_debug ("simple-scan.vala:250: Page is %d pixels wide, %d pixels high, %d bits " \
"per pixel", _tmp1_, _tmp3_, _tmp5_);
	_tmp6_ = simple_scan_append_page (self);
	page = _tmp6_;
	_tmp7_ = info;
	page_set_page_info (page, _tmp7_);
	_tmp8_ = info;
	_tmp9_ = _tmp8_->device;
	_tmp10_ = simple_scan_get_profile_for_device (self, _tmp9_);
	_tmp11_ = _tmp10_;
	page_set_color_profile (page, _tmp11_);
	_g_free0 (_tmp11_);
	_page_unref0 (page);
}


static void simple_scan_scanner_line_cb (SimpleScan* self, Scanner* scanner, ScanLine* line) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	ScanLine* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
	page = _tmp3_;
	_tmp4_ = line;
	page_parse_scan_line (page, _tmp4_);
	_page_unref0 (page);
}


static void simple_scan_scanner_page_done_cb (SimpleScan* self, Scanner* scanner) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
	page = _tmp3_;
	page_finish (page);
	_page_unref0 (page);
}


static void simple_scan_remove_empty_page (SimpleScan* self) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
	page = _tmp3_;
	_tmp4_ = page;
	_tmp5_ = page_has_data (_tmp4_);
	if (_tmp5_) {
		Page* _tmp6_ = NULL;
		_tmp6_ = page;
		page_finish (_tmp6_);
	} else {
		Book* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
		_tmp7_ = self->priv->book;
		_tmp8_ = page;
		book_delete_page (_tmp7_, _tmp8_);
	}
	_page_unref0 (page);
}


static void simple_scan_scanner_document_done_cb (SimpleScan* self, Scanner* scanner) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	simple_scan_remove_empty_page (self);
}


static void simple_scan_scanner_failed_cb (SimpleScan* self, Scanner* scanner, gint error_code, const gchar* error_string) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (error_string != NULL);
	simple_scan_remove_empty_page (self);
	_tmp0_ = error_code;
	if (_tmp0_ != ((gint) SANE_STATUS_CANCELLED)) {
		UserInterface* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp1_ = self->priv->ui;
		_tmp2_ = _ ("Failed to scan");
		_tmp3_ = error_string;
		_tmp4_ = self->priv->have_devices;
		user_interface_show_error (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	}
}


static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self, Scanner* scanner) {
	UserInterface* _tmp0_ = NULL;
	Scanner* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = self->priv->ui;
	_tmp1_ = scanner;
	_tmp2_ = scanner_is_scanning (_tmp1_);
	user_interface_set_scanning (_tmp0_, _tmp2_);
}


static void simple_scan_scan_cb (SimpleScan* self, UserInterface* ui, const gchar* device, ScanOptions* options) {
	ScanOptions* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	Scanner* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar* filename_prefix = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* extension = NULL;
	ScanOptions* _tmp9_ = NULL;
	ScanMode _tmp10_ = 0;
	gchar* filename = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	UserInterface* _tmp16_ = NULL;
	Scanner* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	ScanOptions* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	g_return_if_fail (options != NULL);
	_tmp0_ = options;
	_tmp1_ = _tmp0_->dpi;
	_tmp2_ = device;
	g_debug ("simple-scan.vala:310: Requesting scan at %d dpi from device '%s'", _tmp1_, _tmp2_);
	_tmp3_ = self->priv->scanner;
	_tmp4_ = scanner_is_scanning (_tmp3_);
	if (!_tmp4_) {
		Page* _tmp5_ = NULL;
		Page* _tmp6_ = NULL;
		_tmp5_ = simple_scan_append_page (self);
		_tmp6_ = _tmp5_;
		_page_unref0 (_tmp6_);
	}
	_tmp7_ = _ ("Scanned Document");
	_tmp8_ = g_strdup (_tmp7_);
	filename_prefix = _tmp8_;
	_tmp9_ = options;
	_tmp10_ = _tmp9_->scan_mode;
	if (_tmp10_ == SCAN_MODE_COLOR) {
		gchar* _tmp11_ = NULL;
		_tmp11_ = g_strdup ("jpg");
		_g_free0 (extension);
		extension = _tmp11_;
	} else {
		gchar* _tmp12_ = NULL;
		_tmp12_ = g_strdup ("pdf");
		_g_free0 (extension);
		extension = _tmp12_;
	}
	_tmp13_ = filename_prefix;
	_tmp14_ = extension;
	_tmp15_ = g_strdup_printf ("%s.%s", _tmp13_, _tmp14_);
	filename = _tmp15_;
	_tmp16_ = ui;
	user_interface_set_default_file_name (_tmp16_, filename);
	_tmp17_ = self->priv->scanner;
	_tmp18_ = device;
	_tmp19_ = options;
	scanner_scan (_tmp17_, _tmp18_, _tmp19_);
	_g_free0 (filename);
	_g_free0 (extension);
	_g_free0 (filename_prefix);
}


static void simple_scan_cancel_cb (SimpleScan* self, UserInterface* ui) {
	Scanner* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	_tmp0_ = self->priv->scanner;
	scanner_cancel (_tmp0_);
}


static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = prefix;
	_tmp1_ = extension;
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
	filename = _tmp2_;
	{
		gint fd = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp3_ = filename;
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
		_g_free0 (path);
		path = _tmp4_;
		fd = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp6_ = fd;
		close (_tmp6_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("simple-scan.vala:346: Error saving email attachment: %s", _tmp8_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		_g_free0 (filename);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = path;
	_g_free0 (filename);
	return result;
}


static void simple_scan_email_cb (SimpleScan* self, UserInterface* ui, const gchar* profile) {
	gboolean saved = FALSE;
	gchar* command_line = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	g_return_if_fail (profile != NULL);
	saved = FALSE;
	_tmp0_ = g_strdup ("xdg-email");
	command_line = _tmp0_;
	_tmp1_ = profile;
	if (g_strcmp0 (_tmp1_, "text") == 0) {
		gchar* path = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = simple_scan_get_temporary_filename (self, "scan", "pdf");
		path = _tmp2_;
		_tmp3_ = path;
		if (_tmp3_ != NULL) {
			GFile* file = NULL;
			const gchar* _tmp4_ = NULL;
			GFile* _tmp5_ = NULL;
			UserInterface* _tmp6_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			_tmp4_ = path;
			_tmp5_ = g_file_new_for_path (_tmp4_);
			file = _tmp5_;
			_tmp6_ = ui;
			user_interface_show_progress_dialog (_tmp6_);
			{
				Book* _tmp7_ = NULL;
				GFile* _tmp8_ = NULL;
				_tmp7_ = self->priv->book;
				_tmp8_ = file;
				book_save (_tmp7_, "pdf", _tmp8_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch8_g_error;
				}
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError* e = NULL;
				UserInterface* _tmp9_ = NULL;
				GError* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp9_ = ui;
				user_interface_hide_progress_dialog (_tmp9_);
				_tmp10_ = e;
				_tmp11_ = _tmp10_->message;
				g_warning ("simple-scan.vala:374: Unable to save email file: %s", _tmp11_);
				_g_error_free0 (e);
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_free0 (command_line);
				return;
			}
			__finally8:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_free0 (command_line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp12_ = command_line;
			_tmp13_ = path;
			_tmp14_ = g_strdup_printf (" --attach %s", _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
			_g_free0 (command_line);
			command_line = _tmp16_;
			_g_free0 (_tmp15_);
			_g_object_unref0 (file);
		}
		_g_free0 (path);
	} else {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					gboolean _tmp18_ = FALSE;
					gint _tmp20_ = 0;
					Book* _tmp21_ = NULL;
					guint _tmp22_ = 0U;
					gchar* path = NULL;
					gchar* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					GFile* file = NULL;
					const gchar* _tmp25_ = NULL;
					GFile* _tmp26_ = NULL;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					gboolean _tmp39_ = FALSE;
					_tmp18_ = _tmp17_;
					if (!_tmp18_) {
						gint _tmp19_ = 0;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp20_ = i;
					_tmp21_ = self->priv->book;
					_tmp22_ = book_get_n_pages (_tmp21_);
					if (!(((guint) _tmp20_) < _tmp22_)) {
						break;
					}
					_tmp23_ = simple_scan_get_temporary_filename (self, "scan", "jpg");
					path = _tmp23_;
					_tmp24_ = path;
					if (_tmp24_ == NULL) {
						saved = FALSE;
						_g_free0 (path);
						break;
					}
					_tmp25_ = path;
					_tmp26_ = g_file_new_for_path (_tmp25_);
					file = _tmp26_;
					{
						Book* _tmp27_ = NULL;
						gint _tmp28_ = 0;
						Page* _tmp29_ = NULL;
						Page* _tmp30_ = NULL;
						GFile* _tmp31_ = NULL;
						_tmp27_ = self->priv->book;
						_tmp28_ = i;
						_tmp29_ = book_get_page (_tmp27_, _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = file;
						page_save (_tmp30_, "jpeg", _tmp31_, &_inner_error_);
						_page_unref0 (_tmp30_);
						if (_inner_error_ != NULL) {
							goto __catch9_g_error;
						}
					}
					goto __finally9;
					__catch9_g_error:
					{
						GError* e = NULL;
						GError* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp32_ = e;
						_tmp33_ = _tmp32_->message;
						g_warning ("simple-scan.vala:398: Unable to save email file: %s", _tmp33_);
						_g_error_free0 (e);
						_g_object_unref0 (file);
						_g_free0 (path);
						_g_free0 (command_line);
						return;
					}
					__finally9:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						_g_free0 (path);
						_g_free0 (command_line);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp34_ = command_line;
					_tmp35_ = path;
					_tmp36_ = g_strdup_printf (" --attach %s", _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
					_g_free0 (command_line);
					command_line = _tmp38_;
					_g_free0 (_tmp37_);
					_tmp39_ = saved;
					if (!_tmp39_) {
						_g_object_unref0 (file);
						_g_free0 (path);
						break;
					}
					_g_object_unref0 (file);
					_g_free0 (path);
				}
			}
		}
	}
	_tmp40_ = command_line;
	g_debug ("simple-scan.vala:408: Launching email client: %s", _tmp40_);
	{
		const gchar* _tmp41_ = NULL;
		_tmp41_ = command_line;
		g_spawn_command_line_async (_tmp41_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_warning ("simple-scan.vala:415: Unable to start email: %s", _tmp43_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (command_line);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (command_line);
}


static void simple_scan_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	gchar* prefix = NULL;
	GLogLevelFlags _tmp0_ = 0;
	FILE* _tmp8_ = NULL;
	GTimer* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (message != NULL);
	_tmp0_ = log_level;
	switch (_tmp0_ & G_LOG_LEVEL_MASK) {
		case G_LOG_LEVEL_ERROR:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("ERROR:");
			_g_free0 (prefix);
			prefix = _tmp1_;
			break;
		}
		case G_LOG_LEVEL_CRITICAL:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("CRITICAL:");
			_g_free0 (prefix);
			prefix = _tmp2_;
			break;
		}
		case G_LOG_LEVEL_WARNING:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("WARNING:");
			_g_free0 (prefix);
			prefix = _tmp3_;
			break;
		}
		case G_LOG_LEVEL_MESSAGE:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("MESSAGE:");
			_g_free0 (prefix);
			prefix = _tmp4_;
			break;
		}
		case G_LOG_LEVEL_INFO:
		{
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("INFO:");
			_g_free0 (prefix);
			prefix = _tmp5_;
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp6_ = NULL;
			_tmp6_ = g_strdup ("DEBUG:");
			_g_free0 (prefix);
			prefix = _tmp6_;
			break;
		}
		default:
		{
			gchar* _tmp7_ = NULL;
			_tmp7_ = g_strdup ("LOG:");
			_g_free0 (prefix);
			prefix = _tmp7_;
			break;
		}
	}
	_tmp8_ = simple_scan_log_file;
	_tmp9_ = simple_scan_log_timer;
	_tmp10_ = g_timer_elapsed (_tmp9_, NULL);
	_tmp11_ = prefix;
	_tmp12_ = message;
	fprintf (_tmp8_, "[%+.2fs] %s %s\n", _tmp10_, _tmp11_, _tmp12_);
	_tmp13_ = simple_scan_debug_enabled;
	if (_tmp13_) {
		FILE* _tmp14_ = NULL;
		GTimer* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp14_ = stderr;
		_tmp15_ = simple_scan_log_timer;
		_tmp16_ = g_timer_elapsed (_tmp15_, NULL);
		_tmp17_ = prefix;
		_tmp18_ = message;
		fprintf (_tmp14_, "[%+.2fs] %s %s\n", _tmp16_, _tmp17_, _tmp18_);
	}
	_g_free0 (prefix);
}


static void simple_scan_on_uevent (SimpleScan* self, GUdevClient* client, const gchar* action, GUdevDevice* device) {
	Scanner* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->scanner;
	scanner_redetect (_tmp0_);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void simple_scan_fix_pdf (const gchar* filename, GError** error) {
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	size_t _tmp2_;
	FILE* fixed_file = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	FILE* _tmp6_ = NULL;
	FILE* _tmp7_ = NULL;
	gint offset = 0;
	gint line_number = 0;
	gint xref_offset = 0;
	gint xref_line = 0;
	gint startxref_line = 0;
	gint fixed_size = 0;
	GString* line = NULL;
	GString* _tmp8_ = NULL;
	const gchar* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	gchar* _tmp111_ = NULL;
	gchar* _tmp112_ = NULL;
	gint _tmp113_ = 0;
	gboolean _tmp114_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (filename != NULL);
	_tmp0_ = filename;
	g_file_get_contents (_tmp0_, (gchar**) (&_tmp1_), &_tmp2_, &_inner_error_);
	data = (g_free (data), NULL);
	data = _tmp1_;
	data_length1 = _tmp2_;
	_data_size_ = data_length1;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		data = (g_free (data), NULL);
		return;
	}
	_tmp3_ = filename;
	_tmp4_ = g_strconcat (_tmp3_, ".fixed", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_fopen (_tmp5_, "w");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	fixed_file = _tmp7_;
	offset = 0;
	line_number = 0;
	xref_offset = 0;
	xref_line = -1;
	startxref_line = -1;
	fixed_size = -1;
	_tmp8_ = g_string_new ("");
	line = _tmp8_;
	while (TRUE) {
		gint _tmp9_ = 0;
		gint end_offset = 0;
		gint _tmp10_ = 0;
		GString* _tmp11_ = NULL;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GString* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gboolean _tmp25_ = FALSE;
		gint _tmp26_ = 0;
		gboolean _tmp30_ = FALSE;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
		_tmp9_ = offset;
		if (!(_tmp9_ < data_length1)) {
			break;
		}
		_tmp10_ = offset;
		end_offset = _tmp10_;
		_tmp11_ = line;
		g_string_assign (_tmp11_, "");
		while (TRUE) {
			gint _tmp12_ = 0;
			guint8 c = 0U;
			gint _tmp13_ = 0;
			guint8 _tmp14_ = 0U;
			GString* _tmp15_ = NULL;
			guint8 _tmp16_ = 0U;
			gint _tmp17_ = 0;
			guint8 _tmp18_ = 0U;
			_tmp12_ = end_offset;
			if (!(_tmp12_ < data_length1)) {
				break;
			}
			_tmp13_ = end_offset;
			_tmp14_ = data[_tmp13_];
			c = _tmp14_;
			_tmp15_ = line;
			_tmp16_ = c;
			g_string_append_c (_tmp15_, (gchar) _tmp16_);
			_tmp17_ = end_offset;
			end_offset = _tmp17_ + 1;
			_tmp18_ = c;
			if (_tmp18_ == ((guint8) '\n')) {
				break;
			}
		}
		_tmp19_ = line;
		_tmp20_ = _tmp19_->str;
		if (g_strcmp0 (_tmp20_, "startxref\n") == 0) {
			gint _tmp21_ = 0;
			_tmp21_ = line_number;
			startxref_line = _tmp21_;
		}
		_tmp22_ = line;
		_tmp23_ = _tmp22_->str;
		if (g_strcmp0 (_tmp23_, "xref\n") == 0) {
			gint _tmp24_ = 0;
			_tmp24_ = line_number;
			xref_line = _tmp24_;
		}
		_tmp26_ = line_number;
		if (_tmp26_ < 2) {
			GString* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp27_ = line;
			_tmp28_ = _tmp27_->str;
			_tmp29_ = g_str_has_prefix (_tmp28_, "%%");
			_tmp25_ = _tmp29_;
		} else {
			_tmp25_ = FALSE;
		}
		_tmp30_ = _tmp25_;
		if (_tmp30_) {
			gint _tmp31_ = 0;
			FILE* _tmp32_ = NULL;
			GString* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			_tmp31_ = xref_offset;
			xref_offset = _tmp31_ - 1;
			_tmp32_ = fixed_file;
			_tmp33_ = line;
			_tmp34_ = _tmp33_->str;
			_tmp35_ = string_substring (_tmp34_, (glong) 1, (glong) (-1));
			_tmp36_ = _tmp35_;
			fprintf (_tmp32_, "%s", _tmp36_);
			_g_free0 (_tmp36_);
		} else {
			gboolean _tmp37_ = FALSE;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			gboolean _tmp43_ = FALSE;
			_tmp38_ = line_number;
			_tmp39_ = xref_line;
			if (_tmp38_ == (_tmp39_ + 1)) {
				GString* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
				_tmp40_ = line;
				_tmp41_ = _tmp40_->str;
				_tmp42_ = g_str_has_prefix (_tmp41_, "1 ");
				_tmp37_ = _tmp42_;
			} else {
				_tmp37_ = FALSE;
			}
			_tmp43_ = _tmp37_;
			if (_tmp43_) {
				GString* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				FILE* _tmp49_ = NULL;
				gint _tmp50_ = 0;
				FILE* _tmp51_ = NULL;
				_tmp44_ = line;
				_tmp45_ = _tmp44_->str;
				_tmp46_ = string_substring (_tmp45_, (glong) 2, (glong) (-1));
				_tmp47_ = _tmp46_;
				_tmp48_ = atoi (_tmp47_);
				fixed_size = _tmp48_ + 1;
				_g_free0 (_tmp47_);
				_tmp49_ = fixed_file;
				_tmp50_ = fixed_size;
				fprintf (_tmp49_, "0 %d\n", _tmp50_);
				_tmp51_ = fixed_file;
				fprintf (_tmp51_, "0000000000 65535 f \n");
			} else {
				gboolean _tmp52_ = FALSE;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				gboolean _tmp58_ = FALSE;
				_tmp53_ = line_number;
				_tmp54_ = xref_line;
				if (_tmp53_ > _tmp54_) {
					GString* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					gboolean _tmp57_ = FALSE;
					_tmp55_ = line;
					_tmp56_ = _tmp55_->str;
					_tmp57_ = g_str_has_suffix (_tmp56_, " 0000 n\n");
					_tmp52_ = _tmp57_;
				} else {
					_tmp52_ = FALSE;
				}
				_tmp58_ = _tmp52_;
				if (_tmp58_) {
					FILE* _tmp59_ = NULL;
					GString* _tmp60_ = NULL;
					const gchar* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					_tmp59_ = fixed_file;
					_tmp60_ = line;
					_tmp61_ = _tmp60_->str;
					_tmp62_ = atoi (_tmp61_);
					_tmp63_ = xref_offset;
					fprintf (_tmp59_, "%010d 00000 n \n", _tmp62_ + _tmp63_);
				} else {
					gboolean _tmp64_ = FALSE;
					gint _tmp65_ = 0;
					gboolean _tmp68_ = FALSE;
					_tmp65_ = startxref_line;
					if (_tmp65_ > 0) {
						gint _tmp66_ = 0;
						gint _tmp67_ = 0;
						_tmp66_ = line_number;
						_tmp67_ = startxref_line;
						_tmp64_ = _tmp66_ == (_tmp67_ + 1);
					} else {
						_tmp64_ = FALSE;
					}
					_tmp68_ = _tmp64_;
					if (_tmp68_) {
						FILE* _tmp69_ = NULL;
						GString* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gint _tmp72_ = 0;
						gint _tmp73_ = 0;
						gchar* _tmp74_ = NULL;
						gchar* _tmp75_ = NULL;
						_tmp69_ = fixed_file;
						_tmp70_ = line;
						_tmp71_ = _tmp70_->str;
						_tmp72_ = atoi (_tmp71_);
						_tmp73_ = xref_offset;
						_tmp74_ = g_strdup_printf ("%d\n", _tmp72_ + _tmp73_);
						_tmp75_ = _tmp74_;
						fprintf (_tmp69_, "%s", _tmp75_);
						_g_free0 (_tmp75_);
					} else {
						gboolean _tmp76_ = FALSE;
						gint _tmp77_ = 0;
						gboolean _tmp81_ = FALSE;
						_tmp77_ = fixed_size;
						if (_tmp77_ > 0) {
							GString* _tmp78_ = NULL;
							const gchar* _tmp79_ = NULL;
							gboolean _tmp80_ = FALSE;
							_tmp78_ = line;
							_tmp79_ = _tmp78_->str;
							_tmp80_ = g_str_has_prefix (_tmp79_, "/Size ");
							_tmp76_ = _tmp80_;
						} else {
							_tmp76_ = FALSE;
						}
						_tmp81_ = _tmp76_;
						if (_tmp81_) {
							FILE* _tmp82_ = NULL;
							gint _tmp83_ = 0;
							gchar* _tmp84_ = NULL;
							gchar* _tmp85_ = NULL;
							_tmp82_ = fixed_file;
							_tmp83_ = fixed_size;
							_tmp84_ = g_strdup_printf ("/Size %d\n", _tmp83_);
							_tmp85_ = _tmp84_;
							fprintf (_tmp82_, "%s", _tmp85_);
							_g_free0 (_tmp85_);
						} else {
							gboolean _tmp86_ = FALSE;
							gint _tmp87_ = 0;
							gint _tmp88_ = 0;
							gboolean _tmp92_ = FALSE;
							_tmp87_ = line_number;
							_tmp88_ = startxref_line;
							if (_tmp87_ == (_tmp88_ + 2)) {
								GString* _tmp89_ = NULL;
								const gchar* _tmp90_ = NULL;
								gboolean _tmp91_ = FALSE;
								_tmp89_ = line;
								_tmp90_ = _tmp89_->str;
								_tmp91_ = g_str_has_prefix (_tmp90_, "%%%%");
								_tmp86_ = _tmp91_;
							} else {
								_tmp86_ = FALSE;
							}
							_tmp92_ = _tmp86_;
							if (_tmp92_) {
								FILE* _tmp93_ = NULL;
								GString* _tmp94_ = NULL;
								const gchar* _tmp95_ = NULL;
								gchar* _tmp96_ = NULL;
								gchar* _tmp97_ = NULL;
								_tmp93_ = fixed_file;
								_tmp94_ = line;
								_tmp95_ = _tmp94_->str;
								_tmp96_ = string_substring (_tmp95_, (glong) 2, (glong) (-1));
								_tmp97_ = _tmp96_;
								fprintf (_tmp93_, "%s", _tmp97_);
								_g_free0 (_tmp97_);
							} else {
								{
									gint i = 0;
									gint _tmp98_ = 0;
									_tmp98_ = offset;
									i = _tmp98_;
									{
										gboolean _tmp99_ = FALSE;
										_tmp99_ = TRUE;
										while (TRUE) {
											gboolean _tmp100_ = FALSE;
											gint _tmp102_ = 0;
											gint _tmp103_ = 0;
											FILE* _tmp104_ = NULL;
											gint _tmp105_ = 0;
											guint8 _tmp106_ = 0U;
											_tmp100_ = _tmp99_;
											if (!_tmp100_) {
												gint _tmp101_ = 0;
												_tmp101_ = i;
												i = _tmp101_ + 1;
											}
											_tmp99_ = FALSE;
											_tmp102_ = i;
											_tmp103_ = end_offset;
											if (!(_tmp102_ < _tmp103_)) {
												break;
											}
											_tmp104_ = fixed_file;
											_tmp105_ = i;
											_tmp106_ = data[_tmp105_];
											fputc ((gchar) _tmp106_, _tmp104_);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp107_ = line_number;
		line_number = _tmp107_ + 1;
		_tmp108_ = end_offset;
		offset = _tmp108_;
	}
	_tmp109_ = filename;
	_tmp110_ = filename;
	_tmp111_ = g_strconcat (_tmp110_, "~", NULL);
	_tmp112_ = _tmp111_;
	_tmp113_ = g_rename (_tmp109_, _tmp112_);
	_tmp114_ = _tmp113_ >= 0;
	_g_free0 (_tmp112_);
	if (_tmp114_) {
		const gchar* _tmp115_ = NULL;
		gchar* _tmp116_ = NULL;
		gchar* _tmp117_ = NULL;
		const gchar* _tmp118_ = NULL;
		_tmp115_ = filename;
		_tmp116_ = g_strconcat (_tmp115_, ".fixed", NULL);
		_tmp117_ = _tmp116_;
		_tmp118_ = filename;
		g_rename (_tmp117_, _tmp118_);
		_g_free0 (_tmp117_);
	}
	_g_string_free0 (line);
	_fclose0 (fixed_file);
	data = (g_free (data), NULL);
}


static void _simple_scan_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	simple_scan_log_cb (log_domain, log_levels, message);
}


gint simple_scan_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* c = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp16_ = NULL;
	ScanDevice* device = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GTimer* _tmp39_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	FILE* _tmp46_ = NULL;
	pid_t _tmp47_ = 0;
	SimpleScan* app = NULL;
	ScanDevice* _tmp48_ = NULL;
	SimpleScan* _tmp49_ = NULL;
	SimpleScan* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	_tmp0_ = _ ("[DEVICE...] - Scanning utility");
	_tmp1_ = g_option_context_new (_tmp0_);
	c = _tmp1_;
	_tmp2_ = c;
	g_option_context_add_main_entries (_tmp2_, SIMPLE_SCAN_options, GETTEXT_PACKAGE);
	_tmp3_ = c;
	_tmp4_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_ = NULL;
		_tmp5_ = c;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		FILE* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		_tmp9_ = stderr;
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = _tmp11_[0];
		fprintf (_tmp9_, _tmp10_, _tmp12_);
		_tmp13_ = stderr;
		fprintf (_tmp13_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		return result;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp14_ = simple_scan_show_version;
	if (_tmp14_) {
		FILE* _tmp15_ = NULL;
		_tmp15_ = stderr;
		fprintf (_tmp15_, "simple-scan %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	_tmp16_ = simple_scan_fix_pdf_filename;
	if (_tmp16_ != NULL) {
		{
			const gchar* _tmp17_ = NULL;
			_tmp17_ = simple_scan_fix_pdf_filename;
			simple_scan_fix_pdf (_tmp17_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			{
				gint i = 0;
				i = 1;
				{
					gboolean _tmp18_ = FALSE;
					_tmp18_ = TRUE;
					while (TRUE) {
						gboolean _tmp19_ = FALSE;
						gint _tmp21_ = 0;
						gchar** _tmp22_ = NULL;
						gint _tmp22__length1 = 0;
						gchar** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gint _tmp24_ = 0;
						const gchar* _tmp25_ = NULL;
						_tmp19_ = _tmp18_;
						if (!_tmp19_) {
							gint _tmp20_ = 0;
							_tmp20_ = i;
							i = _tmp20_ + 1;
						}
						_tmp18_ = FALSE;
						_tmp21_ = i;
						_tmp22_ = args;
						_tmp22__length1 = args_length1;
						if (!(_tmp21_ < _tmp22__length1)) {
							break;
						}
						_tmp23_ = args;
						_tmp23__length1 = args_length1;
						_tmp24_ = i;
						_tmp25_ = _tmp23_[_tmp24_];
						simple_scan_fix_pdf (_tmp25_, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch12_g_error;
						}
					}
				}
			}
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_ = NULL;
			GError* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			fprintf (_tmp26_, "Error fixing PDF file: %s", _tmp28_);
			result = EXIT_FAILURE;
			_g_error_free0 (e);
			_g_option_context_free0 (c);
			return result;
		}
		__finally12:
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	device = NULL;
	_tmp29_ = args;
	_tmp29__length1 = args_length1;
	if (_tmp29__length1 > 1) {
		ScanDevice* _tmp30_ = NULL;
		ScanDevice* _tmp31_ = NULL;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		ScanDevice* _tmp35_ = NULL;
		gchar** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		_tmp30_ = scan_device_new ();
		_scan_device_unref0 (device);
		device = _tmp30_;
		_tmp31_ = device;
		_tmp32_ = args;
		_tmp32__length1 = args_length1;
		_tmp33_ = _tmp32_[1];
		_tmp34_ = g_strdup (_tmp33_);
		_g_free0 (_tmp31_->name);
		_tmp31_->name = _tmp34_;
		_tmp35_ = device;
		_tmp36_ = args;
		_tmp36__length1 = args_length1;
		_tmp37_ = _tmp36_[1];
		_tmp38_ = g_strdup (_tmp37_);
		_g_free0 (_tmp35_->label);
		_tmp35_->label = _tmp38_;
	}
	_tmp39_ = g_timer_new ();
	_g_timer_destroy0 (simple_scan_log_timer);
	simple_scan_log_timer = _tmp39_;
	_tmp40_ = g_get_user_cache_dir ();
	_tmp41_ = g_build_filename (_tmp40_, "simple-scan", NULL, NULL);
	path = _tmp41_;
	_tmp42_ = path;
	g_mkdir_with_parents (_tmp42_, 0700);
	_tmp43_ = g_get_user_cache_dir ();
	_tmp44_ = g_build_filename (_tmp43_, "simple-scan", "simple-scan.log", NULL, NULL);
	_g_free0 (path);
	path = _tmp44_;
	_tmp45_ = path;
	_tmp46_ = g_fopen (_tmp45_, "w");
	_fclose0 (simple_scan_log_file);
	simple_scan_log_file = _tmp46_;
	g_log_set_default_handler (_simple_scan_log_cb_glog_func, NULL);
	_tmp47_ = getpid ();
	g_debug ("simple-scan.vala:596: Starting Simple Scan %s, PID=%i", VERSION, (gint) _tmp47_);
	_tmp48_ = device;
	_tmp49_ = simple_scan_new (_tmp48_);
	app = _tmp49_;
	_tmp50_ = app;
	_tmp51_ = g_application_run ((GApplication*) _tmp50_, 0, NULL);
	result = _tmp51_;
	_g_object_unref0 (app);
	_g_free0 (path);
	_scan_device_unref0 (device);
	_g_option_context_free0 (c);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return simple_scan_main (argv, argc);
}


static void simple_scan_class_init (SimpleScanClass * klass) {
	simple_scan_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SimpleScanPrivate));
	G_APPLICATION_CLASS (klass)->startup = simple_scan_real_startup;
	G_APPLICATION_CLASS (klass)->activate = simple_scan_real_activate;
	G_APPLICATION_CLASS (klass)->shutdown = simple_scan_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = simple_scan_finalize;
}


static void simple_scan_instance_init (SimpleScan * self) {
	self->priv = SIMPLE_SCAN_GET_PRIVATE (self);
	self->priv->default_device = NULL;
	self->priv->have_devices = FALSE;
}


static void simple_scan_finalize (GObject* obj) {
	SimpleScan * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SCAN, SimpleScan);
	_scan_device_unref0 (self->priv->default_device);
	_g_object_unref0 (self->priv->udev_client);
	_user_interface_unref0 (self->priv->ui);
	_scanner_unref0 (self->priv->scanner);
	_book_unref0 (self->priv->book);
	G_OBJECT_CLASS (simple_scan_parent_class)->finalize (obj);
}


GType simple_scan_get_type (void) {
	static volatile gsize simple_scan_type_id__volatile = 0;
	if (g_once_init_enter (&simple_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, NULL };
		GType simple_scan_type_id;
		simple_scan_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "SimpleScan", &g_define_type_info, 0);
		g_once_init_leave (&simple_scan_type_id__volatile, simple_scan_type_id);
	}
	return simple_scan_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



