/* page-view.c generated by valac 0.22.1, the Vala compiler
 * generated from page-view.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CROP_LOCATION (crop_location_get_type ())

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
typedef struct _PageViewPrivate PageViewPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPageView ParamSpecPageView;

typedef enum  {
	CROP_LOCATION_NONE = 0,
	CROP_LOCATION_MIDDLE,
	CROP_LOCATION_TOP,
	CROP_LOCATION_BOTTOM,
	CROP_LOCATION_LEFT,
	CROP_LOCATION_RIGHT,
	CROP_LOCATION_TOP_LEFT,
	CROP_LOCATION_TOP_RIGHT,
	CROP_LOCATION_BOTTOM_LEFT,
	CROP_LOCATION_BOTTOM_RIGHT
} CropLocation;

struct _PageView {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PageViewPrivate * priv;
};

struct _PageViewClass {
	GTypeClass parent_class;
	void (*finalize) (PageView *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PageViewPrivate {
	Page* page;
	GdkPixbuf* image;
	gboolean selected;
	gint border_width;
	gboolean update_image;
	ScanDirection scan_direction;
	gint scan_line;
	gint width;
	gint height;
	gint x_offset;
	gint y_offset;
	CropLocation crop_location;
	gdouble selected_crop_px;
	gdouble selected_crop_py;
	gint selected_crop_x;
	gint selected_crop_y;
	gint selected_crop_w;
	gint selected_crop_h;
	GdkCursorType cursor;
	gint animate_n_segments;
	gint animate_segment;
	guint animate_timeout;
};

struct _ParamSpecPageView {
	GParamSpec parent_instance;
};


static gpointer page_view_parent_class = NULL;

GType crop_location_get_type (void) G_GNUC_CONST;
gpointer page_view_ref (gpointer instance);
void page_view_unref (gpointer instance);
GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page_view (GValue* value, gpointer v_object);
void value_take_page_view (GValue* value, gpointer v_object);
gpointer value_get_page_view (const GValue* value);
GType page_view_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define PAGE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE_VIEW, PageViewPrivate))
enum  {
	PAGE_VIEW_DUMMY_PROPERTY
};
static void page_view_page_pixels_changed_cb (PageView* self, Page* p);
static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void page_view_page_size_changed_cb (PageView* self, Page* p);
static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void page_view_page_overlay_changed_cb (PageView* self, Page* p);
static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender, gpointer self);
static void page_view_scan_direction_changed_cb (PageView* self, Page* p);
static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
PageView* page_view_new (Page* page);
PageView* page_view_construct (GType object_type, Page* page);
Page* page_view_get_page (PageView* self);
void page_view_set_selected (PageView* self, gboolean selected);
gboolean page_view_get_selected (PageView* self);
void page_view_set_x_offset (PageView* self, gint offset);
void page_view_set_y_offset (PageView* self, gint offset);
gint page_view_get_x_offset (PageView* self);
gint page_view_get_y_offset (PageView* self);
static guchar page_view_get_sample (PageView* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint sample);
static void page_view_get_pixel (PageView* self, Page* page, gint x, gint y, guchar* pixel, int pixel_length1);
ScanDirection page_get_scan_direction (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
gint page_get_rowstride (Page* self);
static void page_view_set_pixel (PageView* self, Page* page, gdouble l, gdouble r, gdouble t, gdouble b, guchar* output, int output_length1, gint offset);
static void page_view_update_preview (PageView* self, Page* page, GdkPixbuf** output_image, gint output_width, gint output_height, ScanDirection scan_direction, gint old_scan_line, gint scan_line);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gboolean page_has_data (Page* self);
static gint page_view_get_preview_width (PageView* self);
static gint page_view_get_preview_height (PageView* self);
static void page_view_update_page_view (PageView* self);
gint page_get_scan_line (Page* self);
static gint page_view_page_to_screen_x (PageView* self, gint x);
static gint page_view_page_to_screen_y (PageView* self, gint y);
static gint page_view_screen_to_page_x (PageView* self, gint x);
static gint page_view_screen_to_page_y (PageView* self, gint y);
static CropLocation page_view_get_crop_location (PageView* self, gint x, gint y);
gboolean page_has_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
gchar* page_get_named_crop (Page* self);
void page_view_button_press (PageView* self, gint x, gint y);
void page_view_motion (PageView* self, gint x, gint y);
void page_move_crop (Page* self, gint x, gint y);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_view_button_release (PageView* self, gint x, gint y);
GdkCursorType page_view_get_cursor (PageView* self);
static gboolean page_view_animation_cb (PageView* self);
static void page_view_update_animation (PageView* self);
gboolean page_is_scanning (Page* self);
static gboolean _page_view_animation_cb_gsource_func (gpointer self);
void page_view_render (PageView* self, cairo_t* context);
void page_view_set_width (PageView* self, gint width);
void page_view_set_height (PageView* self, gint height);
gint page_view_get_width (PageView* self);
gint page_view_get_height (PageView* self);
static void page_view_finalize (PageView* obj);


GType crop_location_get_type (void) {
	static volatile gsize crop_location_type_id__volatile = 0;
	if (g_once_init_enter (&crop_location_type_id__volatile)) {
		static const GEnumValue values[] = {{CROP_LOCATION_NONE, "CROP_LOCATION_NONE", "none"}, {CROP_LOCATION_MIDDLE, "CROP_LOCATION_MIDDLE", "middle"}, {CROP_LOCATION_TOP, "CROP_LOCATION_TOP", "top"}, {CROP_LOCATION_BOTTOM, "CROP_LOCATION_BOTTOM", "bottom"}, {CROP_LOCATION_LEFT, "CROP_LOCATION_LEFT", "left"}, {CROP_LOCATION_RIGHT, "CROP_LOCATION_RIGHT", "right"}, {CROP_LOCATION_TOP_LEFT, "CROP_LOCATION_TOP_LEFT", "top-left"}, {CROP_LOCATION_TOP_RIGHT, "CROP_LOCATION_TOP_RIGHT", "top-right"}, {CROP_LOCATION_BOTTOM_LEFT, "CROP_LOCATION_BOTTOM_LEFT", "bottom-left"}, {CROP_LOCATION_BOTTOM_RIGHT, "CROP_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
		GType crop_location_type_id;
		crop_location_type_id = g_enum_register_static ("CropLocation", values);
		g_once_init_leave (&crop_location_type_id__volatile, crop_location_type_id);
	}
	return crop_location_type_id__volatile;
}


static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
	page_view_page_pixels_changed_cb (self, _sender);
}


static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
	page_view_page_size_changed_cb (self, _sender);
}


static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
	page_view_page_overlay_changed_cb (self, _sender);
}


static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender, gpointer self) {
	page_view_page_overlay_changed_cb (self, _sender);
}


static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
	page_view_scan_direction_changed_cb (self, _sender);
}


static gpointer _page_ref0 (gpointer self) {
	return self ? page_ref (self) : NULL;
}


PageView* page_view_construct (GType object_type, Page* page) {
	PageView* self = NULL;
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	Page* _tmp6_ = NULL;
	g_return_val_if_fail (page != NULL, NULL);
	self = (PageView*) g_type_create_instance (object_type);
	_tmp0_ = page;
	_tmp1_ = _page_ref0 (_tmp0_);
	_page_unref0 (self->priv->page);
	self->priv->page = _tmp1_;
	_tmp2_ = page;
	g_signal_connect (_tmp2_, "pixels-changed", (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
	_tmp3_ = page;
	g_signal_connect (_tmp3_, "size-changed", (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
	_tmp4_ = page;
	g_signal_connect (_tmp4_, "crop-changed", (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
	_tmp5_ = page;
	g_signal_connect (_tmp5_, "scan-line-changed", (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
	_tmp6_ = page;
	g_signal_connect (_tmp6_, "scan-direction-changed", (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
	return self;
}


PageView* page_view_new (Page* page) {
	return page_view_construct (TYPE_PAGE_VIEW, page);
}


Page* page_view_get_page (PageView* self) {
	Page* result = NULL;
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->page;
	_tmp1_ = _page_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void page_view_set_selected (PageView* self, gboolean selected) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->selected;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = selected;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = self->priv->selected;
		if (!_tmp6_) {
			gboolean _tmp7_ = FALSE;
			_tmp7_ = selected;
			_tmp5_ = !_tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp8_ = _tmp5_;
		_tmp0_ = _tmp8_;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		return;
	}
	_tmp10_ = selected;
	self->priv->selected = _tmp10_;
	g_signal_emit_by_name (self, "changed");
}


gboolean page_view_get_selected (PageView* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->selected;
	result = _tmp0_;
	return result;
}


void page_view_set_x_offset (PageView* self, gint offset) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = offset;
	self->priv->x_offset = _tmp0_;
}


void page_view_set_y_offset (PageView* self, gint offset) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = offset;
	self->priv->y_offset = _tmp0_;
}


gint page_view_get_x_offset (PageView* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->x_offset;
	result = _tmp0_;
	return result;
}


gint page_view_get_y_offset (PageView* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->y_offset;
	result = _tmp0_;
	return result;
}


static guchar page_view_get_sample (PageView* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint sample) {
	guchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = (guchar) 0xFF;
	return result;
}


static void page_view_get_pixel (PageView* self, Page* page, gint x, gint y, guchar* pixel, int pixel_length1) {
	Page* _tmp0_ = NULL;
	ScanDirection _tmp1_ = 0;
	gint depth = 0;
	Page* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint n_channels = 0;
	Page* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	guchar* pixels = NULL;
	Page* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	guchar* _tmp24_ = NULL;
	gint pixels_length1 = 0;
	gint _pixels_size_ = 0;
	gint offset = 0;
	Page* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_ = 0;
	gboolean _tmp31_ = FALSE;
	guchar* _tmp102_ = NULL;
	gint _tmp102__length1 = 0;
	guchar* _tmp103_ = NULL;
	gint _tmp103__length1 = 0;
	gint _tmp104_ = 0;
	gint _tmp105_ = 0;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
	guchar _tmp109_ = '\0';
	guchar _tmp110_ = '\0';
	guchar* _tmp111_ = NULL;
	gint _tmp111__length1 = 0;
	guchar* _tmp112_ = NULL;
	gint _tmp112__length1 = 0;
	gint _tmp113_ = 0;
	gint _tmp114_ = 0;
	gint _tmp115_ = 0;
	gint _tmp116_ = 0;
	gint _tmp117_ = 0;
	guchar _tmp118_ = '\0';
	guchar _tmp119_ = '\0';
	guchar* _tmp120_ = NULL;
	gint _tmp120__length1 = 0;
	guchar* _tmp121_ = NULL;
	gint _tmp121__length1 = 0;
	gint _tmp122_ = 0;
	gint _tmp123_ = 0;
	gint _tmp124_ = 0;
	gint _tmp125_ = 0;
	gint _tmp126_ = 0;
	guchar _tmp127_ = '\0';
	guchar _tmp128_ = '\0';
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_get_scan_direction (_tmp0_);
	switch (_tmp1_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			Page* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			Page* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			_tmp2_ = page;
			_tmp3_ = page_get_scan_width (_tmp2_);
			_tmp4_ = x;
			x = (_tmp3_ - _tmp4_) - 1;
			_tmp5_ = page;
			_tmp6_ = page_get_scan_height (_tmp5_);
			_tmp7_ = y;
			y = (_tmp6_ - _tmp7_) - 1;
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			gint t = 0;
			gint _tmp8_ = 0;
			Page* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp8_ = x;
			t = _tmp8_;
			_tmp9_ = page;
			_tmp10_ = page_get_scan_width (_tmp9_);
			_tmp11_ = y;
			x = (_tmp10_ - _tmp11_) - 1;
			_tmp12_ = t;
			y = _tmp12_;
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			gint t = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			Page* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			_tmp13_ = x;
			t = _tmp13_;
			_tmp14_ = y;
			x = _tmp14_;
			_tmp15_ = page;
			_tmp16_ = page_get_scan_height (_tmp15_);
			_tmp17_ = t;
			y = (_tmp16_ - _tmp17_) - 1;
			break;
		}
		default:
		break;
	}
	_tmp18_ = page;
	_tmp19_ = page_get_depth (_tmp18_);
	depth = _tmp19_;
	_tmp20_ = page;
	_tmp21_ = page_get_n_channels (_tmp20_);
	n_channels = _tmp21_;
	_tmp22_ = page;
	_tmp24_ = page_get_pixels (_tmp22_, &_tmp23_);
	pixels = _tmp24_;
	pixels_length1 = _tmp23_;
	_pixels_size_ = pixels_length1;
	_tmp25_ = page;
	_tmp26_ = page_get_rowstride (_tmp25_);
	_tmp27_ = y;
	offset = _tmp26_ * _tmp27_;
	_tmp29_ = depth;
	if (_tmp29_ == 8) {
		gint _tmp30_ = 0;
		_tmp30_ = n_channels;
		_tmp28_ = _tmp30_ == 3;
	} else {
		_tmp28_ = FALSE;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		gint o = 0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		guchar* _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		guchar* _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		gint _tmp37_ = 0;
		guchar _tmp38_ = '\0';
		guchar _tmp39_ = '\0';
		guchar* _tmp40_ = NULL;
		gint _tmp40__length1 = 0;
		guchar* _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		gint _tmp42_ = 0;
		guchar _tmp43_ = '\0';
		guchar _tmp44_ = '\0';
		guchar* _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		guchar* _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		gint _tmp47_ = 0;
		guchar _tmp48_ = '\0';
		guchar _tmp49_ = '\0';
		_tmp32_ = offset;
		_tmp33_ = x;
		_tmp34_ = n_channels;
		o = _tmp32_ + (_tmp33_ * _tmp34_);
		_tmp35_ = pixel;
		_tmp35__length1 = pixel_length1;
		_tmp36_ = pixels;
		_tmp36__length1 = pixels_length1;
		_tmp37_ = o;
		_tmp38_ = _tmp36_[_tmp37_];
		_tmp35_[0] = _tmp38_;
		_tmp39_ = _tmp35_[0];
		_tmp40_ = pixel;
		_tmp40__length1 = pixel_length1;
		_tmp41_ = pixels;
		_tmp41__length1 = pixels_length1;
		_tmp42_ = o;
		_tmp43_ = _tmp41_[_tmp42_ + 1];
		_tmp40_[1] = _tmp43_;
		_tmp44_ = _tmp40_[1];
		_tmp45_ = pixel;
		_tmp45__length1 = pixel_length1;
		_tmp46_ = pixels;
		_tmp46__length1 = pixels_length1;
		_tmp47_ = o;
		_tmp48_ = _tmp46_[_tmp47_ + 2];
		_tmp45_[2] = _tmp48_;
		_tmp49_ = _tmp45_[2];
		return;
	} else {
		gboolean _tmp50_ = FALSE;
		gint _tmp51_ = 0;
		gboolean _tmp53_ = FALSE;
		_tmp51_ = depth;
		if (_tmp51_ == 8) {
			gint _tmp52_ = 0;
			_tmp52_ = n_channels;
			_tmp50_ = _tmp52_ == 1;
		} else {
			_tmp50_ = FALSE;
		}
		_tmp53_ = _tmp50_;
		if (_tmp53_) {
			guchar* _tmp54_ = NULL;
			gint _tmp54__length1 = 0;
			guchar* _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			guchar* _tmp56_ = NULL;
			gint _tmp56__length1 = 0;
			guchar* _tmp57_ = NULL;
			gint _tmp57__length1 = 0;
			gint _tmp58_ = 0;
			gint _tmp59_ = 0;
			guchar _tmp60_ = '\0';
			guchar _tmp61_ = '\0';
			guchar _tmp62_ = '\0';
			guchar _tmp63_ = '\0';
			_tmp54_ = pixel;
			_tmp54__length1 = pixel_length1;
			_tmp55_ = pixel;
			_tmp55__length1 = pixel_length1;
			_tmp56_ = pixel;
			_tmp56__length1 = pixel_length1;
			_tmp57_ = pixels;
			_tmp57__length1 = pixels_length1;
			_tmp58_ = offset;
			_tmp59_ = x;
			_tmp60_ = _tmp57_[_tmp58_ + _tmp59_];
			_tmp56_[2] = _tmp60_;
			_tmp61_ = _tmp56_[2];
			_tmp55_[1] = _tmp61_;
			_tmp62_ = _tmp55_[1];
			_tmp54_[0] = _tmp62_;
			_tmp63_ = _tmp54_[0];
			return;
		} else {
			gboolean _tmp64_ = FALSE;
			gint _tmp65_ = 0;
			gboolean _tmp67_ = FALSE;
			_tmp65_ = depth;
			if (_tmp65_ == 1) {
				gint _tmp66_ = 0;
				_tmp66_ = n_channels;
				_tmp64_ = _tmp66_ == 1;
			} else {
				_tmp64_ = FALSE;
			}
			_tmp67_ = _tmp64_;
			if (_tmp67_) {
				gint o = 0;
				gint _tmp68_ = 0;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				guchar* _tmp71_ = NULL;
				gint _tmp71__length1 = 0;
				gint _tmp72_ = 0;
				guchar _tmp73_ = '\0';
				gint _tmp74_ = 0;
				guchar* _tmp75_ = NULL;
				gint _tmp75__length1 = 0;
				guchar* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				guchar* _tmp77_ = NULL;
				gint _tmp77__length1 = 0;
				gint _tmp78_ = 0;
				guchar _tmp79_ = '\0';
				guchar _tmp80_ = '\0';
				guchar _tmp81_ = '\0';
				_tmp68_ = offset;
				_tmp69_ = x;
				o = _tmp68_ + (_tmp69_ / 8);
				_tmp71_ = pixels;
				_tmp71__length1 = pixels_length1;
				_tmp72_ = o;
				_tmp73_ = _tmp71_[_tmp72_];
				_tmp74_ = x;
				if (((gint) (_tmp73_ & (0x80 >> (_tmp74_ % 8)))) != 0) {
					_tmp70_ = 0x00;
				} else {
					_tmp70_ = 0xFF;
				}
				_tmp75_ = pixel;
				_tmp75__length1 = pixel_length1;
				_tmp76_ = pixel;
				_tmp76__length1 = pixel_length1;
				_tmp77_ = pixel;
				_tmp77__length1 = pixel_length1;
				_tmp78_ = _tmp70_;
				_tmp77_[2] = (guchar) _tmp78_;
				_tmp79_ = _tmp77_[2];
				_tmp76_[1] = _tmp79_;
				_tmp80_ = _tmp76_[1];
				_tmp75_[0] = _tmp80_;
				_tmp81_ = _tmp75_[0];
				return;
			} else {
				gboolean _tmp82_ = FALSE;
				gint _tmp83_ = 0;
				gboolean _tmp85_ = FALSE;
				_tmp83_ = depth;
				if (_tmp83_ == 2) {
					gint _tmp84_ = 0;
					_tmp84_ = n_channels;
					_tmp82_ = _tmp84_ == 1;
				} else {
					_tmp82_ = FALSE;
				}
				_tmp85_ = _tmp82_;
				if (_tmp85_) {
					gint block_shift[4] = {0};
					gint _tmp86_[4] = {0};
					gint o = 0;
					gint _tmp87_ = 0;
					gint _tmp88_ = 0;
					gint sample = 0;
					guchar* _tmp89_ = NULL;
					gint _tmp89__length1 = 0;
					gint _tmp90_ = 0;
					guchar _tmp91_ = '\0';
					gint _tmp92_ = 0;
					gint _tmp93_ = 0;
					gint _tmp94_ = 0;
					guchar* _tmp95_ = NULL;
					gint _tmp95__length1 = 0;
					guchar* _tmp96_ = NULL;
					gint _tmp96__length1 = 0;
					guchar* _tmp97_ = NULL;
					gint _tmp97__length1 = 0;
					gint _tmp98_ = 0;
					guchar _tmp99_ = '\0';
					guchar _tmp100_ = '\0';
					guchar _tmp101_ = '\0';
					_tmp86_[0] = 6;
					_tmp86_[1] = 4;
					_tmp86_[2] = 2;
					_tmp86_[3] = 0;
					memcpy (block_shift, _tmp86_, 4 * sizeof (gint));
					_tmp87_ = offset;
					_tmp88_ = x;
					o = _tmp87_ + (_tmp88_ / 4);
					_tmp89_ = pixels;
					_tmp89__length1 = pixels_length1;
					_tmp90_ = o;
					_tmp91_ = _tmp89_[_tmp90_];
					_tmp92_ = x;
					_tmp93_ = block_shift[_tmp92_ % 4];
					sample = (_tmp91_ >> _tmp93_) & 0x3;
					_tmp94_ = sample;
					sample = (_tmp94_ * 255) / 3;
					_tmp95_ = pixel;
					_tmp95__length1 = pixel_length1;
					_tmp96_ = pixel;
					_tmp96__length1 = pixel_length1;
					_tmp97_ = pixel;
					_tmp97__length1 = pixel_length1;
					_tmp98_ = sample;
					_tmp97_[2] = (guchar) _tmp98_;
					_tmp99_ = _tmp97_[2];
					_tmp96_[1] = _tmp99_;
					_tmp100_ = _tmp96_[1];
					_tmp95_[0] = _tmp100_;
					_tmp101_ = _tmp95_[0];
					return;
				}
			}
		}
	}
	_tmp102_ = pixel;
	_tmp102__length1 = pixel_length1;
	_tmp103_ = pixels;
	_tmp103__length1 = pixels_length1;
	_tmp104_ = offset;
	_tmp105_ = x;
	_tmp106_ = depth;
	_tmp107_ = x;
	_tmp108_ = n_channels;
	_tmp109_ = page_view_get_sample (self, _tmp103_, _tmp103__length1, _tmp104_, _tmp105_, _tmp106_, _tmp107_ * _tmp108_);
	_tmp102_[0] = _tmp109_;
	_tmp110_ = _tmp102_[0];
	_tmp111_ = pixel;
	_tmp111__length1 = pixel_length1;
	_tmp112_ = pixels;
	_tmp112__length1 = pixels_length1;
	_tmp113_ = offset;
	_tmp114_ = x;
	_tmp115_ = depth;
	_tmp116_ = x;
	_tmp117_ = n_channels;
	_tmp118_ = page_view_get_sample (self, _tmp112_, _tmp112__length1, _tmp113_, _tmp114_, _tmp115_, (_tmp116_ * _tmp117_) + 1);
	_tmp111_[1] = _tmp118_;
	_tmp119_ = _tmp111_[1];
	_tmp120_ = pixel;
	_tmp120__length1 = pixel_length1;
	_tmp121_ = pixels;
	_tmp121__length1 = pixels_length1;
	_tmp122_ = offset;
	_tmp123_ = x;
	_tmp124_ = depth;
	_tmp125_ = x;
	_tmp126_ = n_channels;
	_tmp127_ = page_view_get_sample (self, _tmp121_, _tmp121__length1, _tmp122_, _tmp123_, _tmp124_, (_tmp125_ * _tmp126_) + 2);
	_tmp120_[2] = _tmp127_;
	_tmp128_ = _tmp120_[2];
}


static void page_view_set_pixel (PageView* self, Page* page, gdouble l, gdouble r, gdouble t, gdouble b, guchar* output, int output_length1, gint offset) {
	gint L = 0;
	gdouble _tmp0_ = 0.0;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gint R = 0;
	gdouble _tmp4_ = 0.0;
	gint T = 0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint B = 0;
	gdouble _tmp9_ = 0.0;
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp293_ = FALSE;
	gdouble _tmp294_ = 0.0;
	gint _tmp295_ = 0;
	gboolean _tmp298_ = FALSE;
	gboolean _tmp320_ = FALSE;
	gdouble _tmp321_ = 0.0;
	gint _tmp322_ = 0;
	gboolean _tmp325_ = FALSE;
	gboolean _tmp347_ = FALSE;
	gdouble _tmp348_ = 0.0;
	gint _tmp349_ = 0;
	gboolean _tmp352_ = FALSE;
	gboolean _tmp374_ = FALSE;
	gdouble _tmp375_ = 0.0;
	gint _tmp376_ = 0;
	gboolean _tmp379_ = FALSE;
	gdouble scale = 0.0;
	gdouble _tmp401_ = 0.0;
	gdouble _tmp402_ = 0.0;
	gdouble _tmp403_ = 0.0;
	gdouble _tmp404_ = 0.0;
	guchar* _tmp405_ = NULL;
	gint _tmp405__length1 = 0;
	gint _tmp406_ = 0;
	gdouble _tmp407_ = 0.0;
	gdouble _tmp408_ = 0.0;
	guchar _tmp409_ = '\0';
	guchar* _tmp410_ = NULL;
	gint _tmp410__length1 = 0;
	gint _tmp411_ = 0;
	gdouble _tmp412_ = 0.0;
	gdouble _tmp413_ = 0.0;
	guchar _tmp414_ = '\0';
	guchar* _tmp415_ = NULL;
	gint _tmp415__length1 = 0;
	gint _tmp416_ = 0;
	gdouble _tmp417_ = 0.0;
	gdouble _tmp418_ = 0.0;
	guchar _tmp419_ = '\0';
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = l;
	L = (gint) _tmp0_;
	_tmp1_ = L;
	_tmp2_ = l;
	if (((gdouble) _tmp1_) != _tmp2_) {
		gint _tmp3_ = 0;
		_tmp3_ = L;
		L = _tmp3_ + 1;
	}
	_tmp4_ = r;
	R = (gint) _tmp4_;
	_tmp5_ = t;
	T = (gint) _tmp5_;
	_tmp6_ = T;
	_tmp7_ = t;
	if (((gdouble) _tmp6_) != _tmp7_) {
		gint _tmp8_ = 0;
		_tmp8_ = T;
		T = _tmp8_ + 1;
	}
	_tmp9_ = b;
	B = (gint) _tmp9_;
	red = 0.0;
	green = 0.0;
	blue = 0.0;
	_tmp12_ = r;
	_tmp13_ = l;
	if ((_tmp12_ - _tmp13_) <= 1.0) {
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		_tmp14_ = r;
		_tmp15_ = l;
		_tmp11_ = ((gint) _tmp14_) == ((gint) _tmp15_);
	} else {
		_tmp11_ = FALSE;
	}
	_tmp16_ = _tmp11_;
	if (_tmp16_) {
		_tmp10_ = TRUE;
	} else {
		gboolean _tmp17_ = FALSE;
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
		gboolean _tmp22_ = FALSE;
		_tmp18_ = b;
		_tmp19_ = t;
		if ((_tmp18_ - _tmp19_) <= 1.0) {
			gdouble _tmp20_ = 0.0;
			gdouble _tmp21_ = 0.0;
			_tmp20_ = b;
			_tmp21_ = t;
			_tmp17_ = ((gint) _tmp20_) == ((gint) _tmp21_);
		} else {
			_tmp17_ = FALSE;
		}
		_tmp22_ = _tmp17_;
		_tmp10_ = _tmp22_;
	}
	_tmp23_ = _tmp10_;
	if (_tmp23_) {
		gboolean _tmp24_ = FALSE;
		gdouble _tmp25_ = 0.0;
		gdouble _tmp26_ = 0.0;
		gboolean _tmp29_ = FALSE;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		gdouble scale = 0.0;
		gdouble _tmp173_ = 0.0;
		gdouble _tmp174_ = 0.0;
		gdouble _tmp175_ = 0.0;
		gdouble _tmp176_ = 0.0;
		guchar* _tmp177_ = NULL;
		gint _tmp177__length1 = 0;
		gint _tmp178_ = 0;
		gdouble _tmp179_ = 0.0;
		gdouble _tmp180_ = 0.0;
		guchar _tmp181_ = '\0';
		guchar* _tmp182_ = NULL;
		gint _tmp182__length1 = 0;
		gint _tmp183_ = 0;
		gdouble _tmp184_ = 0.0;
		gdouble _tmp185_ = 0.0;
		guchar _tmp186_ = '\0';
		guchar* _tmp187_ = NULL;
		gint _tmp187__length1 = 0;
		gint _tmp188_ = 0;
		gdouble _tmp189_ = 0.0;
		gdouble _tmp190_ = 0.0;
		guchar _tmp191_ = '\0';
		_tmp25_ = l;
		_tmp26_ = r;
		if (((gint) _tmp25_) == ((gint) _tmp26_)) {
			_tmp24_ = TRUE;
		} else {
			gdouble _tmp27_ = 0.0;
			gdouble _tmp28_ = 0.0;
			_tmp27_ = t;
			_tmp28_ = b;
			_tmp24_ = ((gint) _tmp27_) == ((gint) _tmp28_);
		}
		_tmp29_ = _tmp24_;
		if (_tmp29_) {
			guchar p[3] = {0};
			Page* _tmp30_ = NULL;
			gdouble _tmp31_ = 0.0;
			gdouble _tmp32_ = 0.0;
			guchar* _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			gint _tmp34_ = 0;
			guchar _tmp35_ = '\0';
			guchar _tmp36_ = '\0';
			guchar* _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp38_ = 0;
			guchar _tmp39_ = '\0';
			guchar _tmp40_ = '\0';
			guchar* _tmp41_ = NULL;
			gint _tmp41__length1 = 0;
			gint _tmp42_ = 0;
			guchar _tmp43_ = '\0';
			guchar _tmp44_ = '\0';
			_tmp30_ = page;
			_tmp31_ = l;
			_tmp32_ = t;
			page_view_get_pixel (self, _tmp30_, (gint) _tmp31_, (gint) _tmp32_, p, 3);
			_tmp33_ = output;
			_tmp33__length1 = output_length1;
			_tmp34_ = offset;
			_tmp35_ = p[0];
			_tmp33_[_tmp34_] = _tmp35_;
			_tmp36_ = _tmp33_[_tmp34_];
			_tmp37_ = output;
			_tmp37__length1 = output_length1;
			_tmp38_ = offset;
			_tmp39_ = p[1];
			_tmp37_[_tmp38_ + 1] = _tmp39_;
			_tmp40_ = _tmp37_[_tmp38_ + 1];
			_tmp41_ = output;
			_tmp41__length1 = output_length1;
			_tmp42_ = offset;
			_tmp43_ = p[2];
			_tmp41_[_tmp42_ + 2] = _tmp43_;
			_tmp44_ = _tmp41_[_tmp42_ + 2];
			return;
		}
		_tmp45_ = L;
		_tmp46_ = R;
		if (_tmp45_ > _tmp46_) {
			guchar p[3] = {0};
			Page* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gdouble _tmp50_ = 0.0;
			guchar _tmp51_ = '\0';
			gdouble _tmp52_ = 0.0;
			gdouble _tmp53_ = 0.0;
			gint _tmp54_ = 0;
			gdouble _tmp55_ = 0.0;
			gdouble _tmp56_ = 0.0;
			guchar _tmp57_ = '\0';
			gdouble _tmp58_ = 0.0;
			gdouble _tmp59_ = 0.0;
			gint _tmp60_ = 0;
			gdouble _tmp61_ = 0.0;
			gdouble _tmp62_ = 0.0;
			guchar _tmp63_ = '\0';
			gdouble _tmp64_ = 0.0;
			gdouble _tmp65_ = 0.0;
			gint _tmp66_ = 0;
			gdouble _tmp67_ = 0.0;
			Page* _tmp89_ = NULL;
			gint _tmp90_ = 0;
			gint _tmp91_ = 0;
			gdouble _tmp92_ = 0.0;
			guchar _tmp93_ = '\0';
			gdouble _tmp94_ = 0.0;
			gdouble _tmp95_ = 0.0;
			gdouble _tmp96_ = 0.0;
			gint _tmp97_ = 0;
			gdouble _tmp98_ = 0.0;
			guchar _tmp99_ = '\0';
			gdouble _tmp100_ = 0.0;
			gdouble _tmp101_ = 0.0;
			gdouble _tmp102_ = 0.0;
			gint _tmp103_ = 0;
			gdouble _tmp104_ = 0.0;
			guchar _tmp105_ = '\0';
			gdouble _tmp106_ = 0.0;
			gdouble _tmp107_ = 0.0;
			gdouble _tmp108_ = 0.0;
			gint _tmp109_ = 0;
			_tmp47_ = page;
			_tmp48_ = R;
			_tmp49_ = T;
			page_view_get_pixel (self, _tmp47_, _tmp48_, _tmp49_ - 1, p, 3);
			_tmp50_ = red;
			_tmp51_ = p[0];
			_tmp52_ = r;
			_tmp53_ = l;
			_tmp54_ = T;
			_tmp55_ = t;
			red = _tmp50_ + ((_tmp51_ * (_tmp52_ - _tmp53_)) * (_tmp54_ - _tmp55_));
			_tmp56_ = green;
			_tmp57_ = p[1];
			_tmp58_ = r;
			_tmp59_ = l;
			_tmp60_ = T;
			_tmp61_ = t;
			green = _tmp56_ + ((_tmp57_ * (_tmp58_ - _tmp59_)) * (_tmp60_ - _tmp61_));
			_tmp62_ = blue;
			_tmp63_ = p[2];
			_tmp64_ = r;
			_tmp65_ = l;
			_tmp66_ = T;
			_tmp67_ = t;
			blue = _tmp62_ + ((_tmp63_ * (_tmp64_ - _tmp65_)) * (_tmp66_ - _tmp67_));
			{
				gint y = 0;
				gint _tmp68_ = 0;
				_tmp68_ = T;
				y = _tmp68_;
				{
					gboolean _tmp69_ = FALSE;
					_tmp69_ = TRUE;
					while (TRUE) {
						gboolean _tmp70_ = FALSE;
						gint _tmp72_ = 0;
						gint _tmp73_ = 0;
						Page* _tmp74_ = NULL;
						gint _tmp75_ = 0;
						gint _tmp76_ = 0;
						gdouble _tmp77_ = 0.0;
						guchar _tmp78_ = '\0';
						gdouble _tmp79_ = 0.0;
						gdouble _tmp80_ = 0.0;
						gdouble _tmp81_ = 0.0;
						guchar _tmp82_ = '\0';
						gdouble _tmp83_ = 0.0;
						gdouble _tmp84_ = 0.0;
						gdouble _tmp85_ = 0.0;
						guchar _tmp86_ = '\0';
						gdouble _tmp87_ = 0.0;
						gdouble _tmp88_ = 0.0;
						_tmp70_ = _tmp69_;
						if (!_tmp70_) {
							gint _tmp71_ = 0;
							_tmp71_ = y;
							y = _tmp71_ + 1;
						}
						_tmp69_ = FALSE;
						_tmp72_ = y;
						_tmp73_ = B;
						if (!(_tmp72_ < _tmp73_)) {
							break;
						}
						_tmp74_ = page;
						_tmp75_ = R;
						_tmp76_ = y;
						page_view_get_pixel (self, _tmp74_, _tmp75_, _tmp76_, p, 3);
						_tmp77_ = red;
						_tmp78_ = p[0];
						_tmp79_ = r;
						_tmp80_ = l;
						red = _tmp77_ + (_tmp78_ * (_tmp79_ - _tmp80_));
						_tmp81_ = green;
						_tmp82_ = p[1];
						_tmp83_ = r;
						_tmp84_ = l;
						green = _tmp81_ + (_tmp82_ * (_tmp83_ - _tmp84_));
						_tmp85_ = blue;
						_tmp86_ = p[2];
						_tmp87_ = r;
						_tmp88_ = l;
						blue = _tmp85_ + (_tmp86_ * (_tmp87_ - _tmp88_));
					}
				}
			}
			_tmp89_ = page;
			_tmp90_ = R;
			_tmp91_ = B;
			page_view_get_pixel (self, _tmp89_, _tmp90_, _tmp91_, p, 3);
			_tmp92_ = red;
			_tmp93_ = p[0];
			_tmp94_ = r;
			_tmp95_ = l;
			_tmp96_ = b;
			_tmp97_ = B;
			red = _tmp92_ + ((_tmp93_ * (_tmp94_ - _tmp95_)) * (_tmp96_ - _tmp97_));
			_tmp98_ = green;
			_tmp99_ = p[1];
			_tmp100_ = r;
			_tmp101_ = l;
			_tmp102_ = b;
			_tmp103_ = B;
			green = _tmp98_ + ((_tmp99_ * (_tmp100_ - _tmp101_)) * (_tmp102_ - _tmp103_));
			_tmp104_ = blue;
			_tmp105_ = p[2];
			_tmp106_ = r;
			_tmp107_ = l;
			_tmp108_ = b;
			_tmp109_ = B;
			blue = _tmp104_ + ((_tmp105_ * (_tmp106_ - _tmp107_)) * (_tmp108_ - _tmp109_));
		} else {
			guchar p[3] = {0};
			Page* _tmp110_ = NULL;
			gint _tmp111_ = 0;
			gint _tmp112_ = 0;
			gdouble _tmp113_ = 0.0;
			guchar _tmp114_ = '\0';
			gdouble _tmp115_ = 0.0;
			gdouble _tmp116_ = 0.0;
			gint _tmp117_ = 0;
			gdouble _tmp118_ = 0.0;
			gdouble _tmp119_ = 0.0;
			guchar _tmp120_ = '\0';
			gdouble _tmp121_ = 0.0;
			gdouble _tmp122_ = 0.0;
			gint _tmp123_ = 0;
			gdouble _tmp124_ = 0.0;
			gdouble _tmp125_ = 0.0;
			guchar _tmp126_ = '\0';
			gdouble _tmp127_ = 0.0;
			gdouble _tmp128_ = 0.0;
			gint _tmp129_ = 0;
			gdouble _tmp130_ = 0.0;
			Page* _tmp152_ = NULL;
			gint _tmp153_ = 0;
			gint _tmp154_ = 0;
			gdouble _tmp155_ = 0.0;
			guchar _tmp156_ = '\0';
			gdouble _tmp157_ = 0.0;
			gdouble _tmp158_ = 0.0;
			gdouble _tmp159_ = 0.0;
			gint _tmp160_ = 0;
			gdouble _tmp161_ = 0.0;
			guchar _tmp162_ = '\0';
			gdouble _tmp163_ = 0.0;
			gdouble _tmp164_ = 0.0;
			gdouble _tmp165_ = 0.0;
			gint _tmp166_ = 0;
			gdouble _tmp167_ = 0.0;
			guchar _tmp168_ = '\0';
			gdouble _tmp169_ = 0.0;
			gdouble _tmp170_ = 0.0;
			gdouble _tmp171_ = 0.0;
			gint _tmp172_ = 0;
			_tmp110_ = page;
			_tmp111_ = L;
			_tmp112_ = B;
			page_view_get_pixel (self, _tmp110_, _tmp111_ - 1, _tmp112_, p, 3);
			_tmp113_ = red;
			_tmp114_ = p[0];
			_tmp115_ = b;
			_tmp116_ = t;
			_tmp117_ = L;
			_tmp118_ = l;
			red = _tmp113_ + ((_tmp114_ * (_tmp115_ - _tmp116_)) * (_tmp117_ - _tmp118_));
			_tmp119_ = green;
			_tmp120_ = p[1];
			_tmp121_ = b;
			_tmp122_ = t;
			_tmp123_ = L;
			_tmp124_ = l;
			green = _tmp119_ + ((_tmp120_ * (_tmp121_ - _tmp122_)) * (_tmp123_ - _tmp124_));
			_tmp125_ = blue;
			_tmp126_ = p[2];
			_tmp127_ = b;
			_tmp128_ = t;
			_tmp129_ = L;
			_tmp130_ = l;
			blue = _tmp125_ + ((_tmp126_ * (_tmp127_ - _tmp128_)) * (_tmp129_ - _tmp130_));
			{
				gint x = 0;
				gint _tmp131_ = 0;
				_tmp131_ = L;
				x = _tmp131_;
				{
					gboolean _tmp132_ = FALSE;
					_tmp132_ = TRUE;
					while (TRUE) {
						gboolean _tmp133_ = FALSE;
						gint _tmp135_ = 0;
						gint _tmp136_ = 0;
						Page* _tmp137_ = NULL;
						gint _tmp138_ = 0;
						gint _tmp139_ = 0;
						gdouble _tmp140_ = 0.0;
						guchar _tmp141_ = '\0';
						gdouble _tmp142_ = 0.0;
						gdouble _tmp143_ = 0.0;
						gdouble _tmp144_ = 0.0;
						guchar _tmp145_ = '\0';
						gdouble _tmp146_ = 0.0;
						gdouble _tmp147_ = 0.0;
						gdouble _tmp148_ = 0.0;
						guchar _tmp149_ = '\0';
						gdouble _tmp150_ = 0.0;
						gdouble _tmp151_ = 0.0;
						_tmp133_ = _tmp132_;
						if (!_tmp133_) {
							gint _tmp134_ = 0;
							_tmp134_ = x;
							x = _tmp134_ + 1;
						}
						_tmp132_ = FALSE;
						_tmp135_ = x;
						_tmp136_ = R;
						if (!(_tmp135_ < _tmp136_)) {
							break;
						}
						_tmp137_ = page;
						_tmp138_ = x;
						_tmp139_ = B;
						page_view_get_pixel (self, _tmp137_, _tmp138_, _tmp139_, p, 3);
						_tmp140_ = red;
						_tmp141_ = p[0];
						_tmp142_ = b;
						_tmp143_ = t;
						red = _tmp140_ + (_tmp141_ * (_tmp142_ - _tmp143_));
						_tmp144_ = green;
						_tmp145_ = p[1];
						_tmp146_ = b;
						_tmp147_ = t;
						green = _tmp144_ + (_tmp145_ * (_tmp146_ - _tmp147_));
						_tmp148_ = blue;
						_tmp149_ = p[2];
						_tmp150_ = b;
						_tmp151_ = t;
						blue = _tmp148_ + (_tmp149_ * (_tmp150_ - _tmp151_));
					}
				}
			}
			_tmp152_ = page;
			_tmp153_ = R;
			_tmp154_ = B;
			page_view_get_pixel (self, _tmp152_, _tmp153_, _tmp154_, p, 3);
			_tmp155_ = red;
			_tmp156_ = p[0];
			_tmp157_ = b;
			_tmp158_ = t;
			_tmp159_ = r;
			_tmp160_ = R;
			red = _tmp155_ + ((_tmp156_ * (_tmp157_ - _tmp158_)) * (_tmp159_ - _tmp160_));
			_tmp161_ = green;
			_tmp162_ = p[1];
			_tmp163_ = b;
			_tmp164_ = t;
			_tmp165_ = r;
			_tmp166_ = R;
			green = _tmp161_ + ((_tmp162_ * (_tmp163_ - _tmp164_)) * (_tmp165_ - _tmp166_));
			_tmp167_ = blue;
			_tmp168_ = p[2];
			_tmp169_ = b;
			_tmp170_ = t;
			_tmp171_ = r;
			_tmp172_ = R;
			blue = _tmp167_ + ((_tmp168_ * (_tmp169_ - _tmp170_)) * (_tmp171_ - _tmp172_));
		}
		_tmp173_ = r;
		_tmp174_ = l;
		_tmp175_ = b;
		_tmp176_ = t;
		scale = 1.0 / ((_tmp173_ - _tmp174_) * (_tmp175_ - _tmp176_));
		_tmp177_ = output;
		_tmp177__length1 = output_length1;
		_tmp178_ = offset;
		_tmp179_ = red;
		_tmp180_ = scale;
		_tmp177_[_tmp178_] = (guchar) ((_tmp179_ * _tmp180_) + 0.5);
		_tmp181_ = _tmp177_[_tmp178_];
		_tmp182_ = output;
		_tmp182__length1 = output_length1;
		_tmp183_ = offset;
		_tmp184_ = green;
		_tmp185_ = scale;
		_tmp182_[_tmp183_ + 1] = (guchar) ((_tmp184_ * _tmp185_) + 0.5);
		_tmp186_ = _tmp182_[_tmp183_ + 1];
		_tmp187_ = output;
		_tmp187__length1 = output_length1;
		_tmp188_ = offset;
		_tmp189_ = blue;
		_tmp190_ = scale;
		_tmp187_[_tmp188_ + 2] = (guchar) ((_tmp189_ * _tmp190_) + 0.5);
		_tmp191_ = _tmp187_[_tmp188_ + 2];
		return;
	}
	{
		gint x = 0;
		gint _tmp192_ = 0;
		_tmp192_ = L;
		x = _tmp192_;
		{
			gboolean _tmp193_ = FALSE;
			_tmp193_ = TRUE;
			while (TRUE) {
				gboolean _tmp194_ = FALSE;
				gint _tmp196_ = 0;
				gint _tmp197_ = 0;
				_tmp194_ = _tmp193_;
				if (!_tmp194_) {
					gint _tmp195_ = 0;
					_tmp195_ = x;
					x = _tmp195_ + 1;
				}
				_tmp193_ = FALSE;
				_tmp196_ = x;
				_tmp197_ = R;
				if (!(_tmp196_ < _tmp197_)) {
					break;
				}
				{
					gint y = 0;
					gint _tmp198_ = 0;
					_tmp198_ = T;
					y = _tmp198_;
					{
						gboolean _tmp199_ = FALSE;
						_tmp199_ = TRUE;
						while (TRUE) {
							gboolean _tmp200_ = FALSE;
							gint _tmp202_ = 0;
							gint _tmp203_ = 0;
							guchar p[3] = {0};
							Page* _tmp204_ = NULL;
							gint _tmp205_ = 0;
							gint _tmp206_ = 0;
							gdouble _tmp207_ = 0.0;
							guchar _tmp208_ = '\0';
							gdouble _tmp209_ = 0.0;
							guchar _tmp210_ = '\0';
							gdouble _tmp211_ = 0.0;
							guchar _tmp212_ = '\0';
							_tmp200_ = _tmp199_;
							if (!_tmp200_) {
								gint _tmp201_ = 0;
								_tmp201_ = y;
								y = _tmp201_ + 1;
							}
							_tmp199_ = FALSE;
							_tmp202_ = y;
							_tmp203_ = B;
							if (!(_tmp202_ < _tmp203_)) {
								break;
							}
							_tmp204_ = page;
							_tmp205_ = x;
							_tmp206_ = y;
							page_view_get_pixel (self, _tmp204_, _tmp205_, _tmp206_, p, 3);
							_tmp207_ = red;
							_tmp208_ = p[0];
							red = _tmp207_ + _tmp208_;
							_tmp209_ = green;
							_tmp210_ = p[1];
							green = _tmp209_ + _tmp210_;
							_tmp211_ = blue;
							_tmp212_ = p[2];
							blue = _tmp211_ + _tmp212_;
						}
					}
				}
			}
		}
	}
	{
		gint x = 0;
		gint _tmp213_ = 0;
		_tmp213_ = L;
		x = _tmp213_;
		{
			gboolean _tmp214_ = FALSE;
			_tmp214_ = TRUE;
			while (TRUE) {
				gboolean _tmp215_ = FALSE;
				gint _tmp217_ = 0;
				gint _tmp218_ = 0;
				gdouble _tmp219_ = 0.0;
				gint _tmp220_ = 0;
				gdouble _tmp236_ = 0.0;
				gint _tmp237_ = 0;
				_tmp215_ = _tmp214_;
				if (!_tmp215_) {
					gint _tmp216_ = 0;
					_tmp216_ = x;
					x = _tmp216_ + 1;
				}
				_tmp214_ = FALSE;
				_tmp217_ = x;
				_tmp218_ = R;
				if (!(_tmp217_ < _tmp218_)) {
					break;
				}
				_tmp219_ = t;
				_tmp220_ = T;
				if (_tmp219_ != ((gdouble) _tmp220_)) {
					guchar p[3] = {0};
					Page* _tmp221_ = NULL;
					gint _tmp222_ = 0;
					gint _tmp223_ = 0;
					gdouble _tmp224_ = 0.0;
					guchar _tmp225_ = '\0';
					gint _tmp226_ = 0;
					gdouble _tmp227_ = 0.0;
					gdouble _tmp228_ = 0.0;
					guchar _tmp229_ = '\0';
					gint _tmp230_ = 0;
					gdouble _tmp231_ = 0.0;
					gdouble _tmp232_ = 0.0;
					guchar _tmp233_ = '\0';
					gint _tmp234_ = 0;
					gdouble _tmp235_ = 0.0;
					_tmp221_ = page;
					_tmp222_ = x;
					_tmp223_ = T;
					page_view_get_pixel (self, _tmp221_, _tmp222_, _tmp223_ - 1, p, 3);
					_tmp224_ = red;
					_tmp225_ = p[0];
					_tmp226_ = T;
					_tmp227_ = t;
					red = _tmp224_ + (_tmp225_ * (_tmp226_ - _tmp227_));
					_tmp228_ = green;
					_tmp229_ = p[1];
					_tmp230_ = T;
					_tmp231_ = t;
					green = _tmp228_ + (_tmp229_ * (_tmp230_ - _tmp231_));
					_tmp232_ = blue;
					_tmp233_ = p[2];
					_tmp234_ = T;
					_tmp235_ = t;
					blue = _tmp232_ + (_tmp233_ * (_tmp234_ - _tmp235_));
				}
				_tmp236_ = b;
				_tmp237_ = B;
				if (_tmp236_ != ((gdouble) _tmp237_)) {
					guchar p[3] = {0};
					Page* _tmp238_ = NULL;
					gint _tmp239_ = 0;
					gint _tmp240_ = 0;
					gdouble _tmp241_ = 0.0;
					guchar _tmp242_ = '\0';
					gdouble _tmp243_ = 0.0;
					gint _tmp244_ = 0;
					gdouble _tmp245_ = 0.0;
					guchar _tmp246_ = '\0';
					gdouble _tmp247_ = 0.0;
					gint _tmp248_ = 0;
					gdouble _tmp249_ = 0.0;
					guchar _tmp250_ = '\0';
					gdouble _tmp251_ = 0.0;
					gint _tmp252_ = 0;
					_tmp238_ = page;
					_tmp239_ = x;
					_tmp240_ = B;
					page_view_get_pixel (self, _tmp238_, _tmp239_, _tmp240_, p, 3);
					_tmp241_ = red;
					_tmp242_ = p[0];
					_tmp243_ = b;
					_tmp244_ = B;
					red = _tmp241_ + (_tmp242_ * (_tmp243_ - _tmp244_));
					_tmp245_ = green;
					_tmp246_ = p[1];
					_tmp247_ = b;
					_tmp248_ = B;
					green = _tmp245_ + (_tmp246_ * (_tmp247_ - _tmp248_));
					_tmp249_ = blue;
					_tmp250_ = p[2];
					_tmp251_ = b;
					_tmp252_ = B;
					blue = _tmp249_ + (_tmp250_ * (_tmp251_ - _tmp252_));
				}
			}
		}
	}
	{
		gint y = 0;
		gint _tmp253_ = 0;
		_tmp253_ = T;
		y = _tmp253_;
		{
			gboolean _tmp254_ = FALSE;
			_tmp254_ = TRUE;
			while (TRUE) {
				gboolean _tmp255_ = FALSE;
				gint _tmp257_ = 0;
				gint _tmp258_ = 0;
				gdouble _tmp259_ = 0.0;
				gint _tmp260_ = 0;
				gdouble _tmp276_ = 0.0;
				gint _tmp277_ = 0;
				_tmp255_ = _tmp254_;
				if (!_tmp255_) {
					gint _tmp256_ = 0;
					_tmp256_ = y;
					y = _tmp256_ + 1;
				}
				_tmp254_ = FALSE;
				_tmp257_ = y;
				_tmp258_ = B;
				if (!(_tmp257_ < _tmp258_)) {
					break;
				}
				_tmp259_ = l;
				_tmp260_ = L;
				if (_tmp259_ != ((gdouble) _tmp260_)) {
					guchar p[3] = {0};
					Page* _tmp261_ = NULL;
					gint _tmp262_ = 0;
					gint _tmp263_ = 0;
					gdouble _tmp264_ = 0.0;
					guchar _tmp265_ = '\0';
					gint _tmp266_ = 0;
					gdouble _tmp267_ = 0.0;
					gdouble _tmp268_ = 0.0;
					guchar _tmp269_ = '\0';
					gint _tmp270_ = 0;
					gdouble _tmp271_ = 0.0;
					gdouble _tmp272_ = 0.0;
					guchar _tmp273_ = '\0';
					gint _tmp274_ = 0;
					gdouble _tmp275_ = 0.0;
					_tmp261_ = page;
					_tmp262_ = L;
					_tmp263_ = y;
					page_view_get_pixel (self, _tmp261_, _tmp262_ - 1, _tmp263_, p, 3);
					_tmp264_ = red;
					_tmp265_ = p[0];
					_tmp266_ = L;
					_tmp267_ = l;
					red = _tmp264_ + (_tmp265_ * (_tmp266_ - _tmp267_));
					_tmp268_ = green;
					_tmp269_ = p[1];
					_tmp270_ = L;
					_tmp271_ = l;
					green = _tmp268_ + (_tmp269_ * (_tmp270_ - _tmp271_));
					_tmp272_ = blue;
					_tmp273_ = p[2];
					_tmp274_ = L;
					_tmp275_ = l;
					blue = _tmp272_ + (_tmp273_ * (_tmp274_ - _tmp275_));
				}
				_tmp276_ = r;
				_tmp277_ = R;
				if (_tmp276_ != ((gdouble) _tmp277_)) {
					guchar p[3] = {0};
					Page* _tmp278_ = NULL;
					gint _tmp279_ = 0;
					gint _tmp280_ = 0;
					gdouble _tmp281_ = 0.0;
					guchar _tmp282_ = '\0';
					gdouble _tmp283_ = 0.0;
					gint _tmp284_ = 0;
					gdouble _tmp285_ = 0.0;
					guchar _tmp286_ = '\0';
					gdouble _tmp287_ = 0.0;
					gint _tmp288_ = 0;
					gdouble _tmp289_ = 0.0;
					guchar _tmp290_ = '\0';
					gdouble _tmp291_ = 0.0;
					gint _tmp292_ = 0;
					_tmp278_ = page;
					_tmp279_ = R;
					_tmp280_ = y;
					page_view_get_pixel (self, _tmp278_, _tmp279_, _tmp280_, p, 3);
					_tmp281_ = red;
					_tmp282_ = p[0];
					_tmp283_ = r;
					_tmp284_ = R;
					red = _tmp281_ + (_tmp282_ * (_tmp283_ - _tmp284_));
					_tmp285_ = green;
					_tmp286_ = p[1];
					_tmp287_ = r;
					_tmp288_ = R;
					green = _tmp285_ + (_tmp286_ * (_tmp287_ - _tmp288_));
					_tmp289_ = blue;
					_tmp290_ = p[2];
					_tmp291_ = r;
					_tmp292_ = R;
					blue = _tmp289_ + (_tmp290_ * (_tmp291_ - _tmp292_));
				}
			}
		}
	}
	_tmp294_ = l;
	_tmp295_ = L;
	if (_tmp294_ != ((gdouble) _tmp295_)) {
		gdouble _tmp296_ = 0.0;
		gint _tmp297_ = 0;
		_tmp296_ = t;
		_tmp297_ = T;
		_tmp293_ = _tmp296_ != ((gdouble) _tmp297_);
	} else {
		_tmp293_ = FALSE;
	}
	_tmp298_ = _tmp293_;
	if (_tmp298_) {
		guchar p[3] = {0};
		Page* _tmp299_ = NULL;
		gint _tmp300_ = 0;
		gint _tmp301_ = 0;
		gdouble _tmp302_ = 0.0;
		guchar _tmp303_ = '\0';
		gint _tmp304_ = 0;
		gdouble _tmp305_ = 0.0;
		gint _tmp306_ = 0;
		gdouble _tmp307_ = 0.0;
		gdouble _tmp308_ = 0.0;
		guchar _tmp309_ = '\0';
		gint _tmp310_ = 0;
		gdouble _tmp311_ = 0.0;
		gint _tmp312_ = 0;
		gdouble _tmp313_ = 0.0;
		gdouble _tmp314_ = 0.0;
		guchar _tmp315_ = '\0';
		gint _tmp316_ = 0;
		gdouble _tmp317_ = 0.0;
		gint _tmp318_ = 0;
		gdouble _tmp319_ = 0.0;
		_tmp299_ = page;
		_tmp300_ = L;
		_tmp301_ = T;
		page_view_get_pixel (self, _tmp299_, _tmp300_ - 1, _tmp301_ - 1, p, 3);
		_tmp302_ = red;
		_tmp303_ = p[0];
		_tmp304_ = L;
		_tmp305_ = l;
		_tmp306_ = T;
		_tmp307_ = t;
		red = _tmp302_ + ((_tmp303_ * (_tmp304_ - _tmp305_)) * (_tmp306_ - _tmp307_));
		_tmp308_ = green;
		_tmp309_ = p[1];
		_tmp310_ = L;
		_tmp311_ = l;
		_tmp312_ = T;
		_tmp313_ = t;
		green = _tmp308_ + ((_tmp309_ * (_tmp310_ - _tmp311_)) * (_tmp312_ - _tmp313_));
		_tmp314_ = blue;
		_tmp315_ = p[2];
		_tmp316_ = L;
		_tmp317_ = l;
		_tmp318_ = T;
		_tmp319_ = t;
		blue = _tmp314_ + ((_tmp315_ * (_tmp316_ - _tmp317_)) * (_tmp318_ - _tmp319_));
	}
	_tmp321_ = r;
	_tmp322_ = R;
	if (_tmp321_ != ((gdouble) _tmp322_)) {
		gdouble _tmp323_ = 0.0;
		gint _tmp324_ = 0;
		_tmp323_ = t;
		_tmp324_ = T;
		_tmp320_ = _tmp323_ != ((gdouble) _tmp324_);
	} else {
		_tmp320_ = FALSE;
	}
	_tmp325_ = _tmp320_;
	if (_tmp325_) {
		guchar p[3] = {0};
		Page* _tmp326_ = NULL;
		gint _tmp327_ = 0;
		gint _tmp328_ = 0;
		gdouble _tmp329_ = 0.0;
		guchar _tmp330_ = '\0';
		gdouble _tmp331_ = 0.0;
		gint _tmp332_ = 0;
		gint _tmp333_ = 0;
		gdouble _tmp334_ = 0.0;
		gdouble _tmp335_ = 0.0;
		guchar _tmp336_ = '\0';
		gdouble _tmp337_ = 0.0;
		gint _tmp338_ = 0;
		gint _tmp339_ = 0;
		gdouble _tmp340_ = 0.0;
		gdouble _tmp341_ = 0.0;
		guchar _tmp342_ = '\0';
		gdouble _tmp343_ = 0.0;
		gint _tmp344_ = 0;
		gint _tmp345_ = 0;
		gdouble _tmp346_ = 0.0;
		_tmp326_ = page;
		_tmp327_ = R;
		_tmp328_ = T;
		page_view_get_pixel (self, _tmp326_, _tmp327_, _tmp328_ - 1, p, 3);
		_tmp329_ = red;
		_tmp330_ = p[0];
		_tmp331_ = r;
		_tmp332_ = R;
		_tmp333_ = T;
		_tmp334_ = t;
		red = _tmp329_ + ((_tmp330_ * (_tmp331_ - _tmp332_)) * (_tmp333_ - _tmp334_));
		_tmp335_ = green;
		_tmp336_ = p[1];
		_tmp337_ = r;
		_tmp338_ = R;
		_tmp339_ = T;
		_tmp340_ = t;
		green = _tmp335_ + ((_tmp336_ * (_tmp337_ - _tmp338_)) * (_tmp339_ - _tmp340_));
		_tmp341_ = blue;
		_tmp342_ = p[2];
		_tmp343_ = r;
		_tmp344_ = R;
		_tmp345_ = T;
		_tmp346_ = t;
		blue = _tmp341_ + ((_tmp342_ * (_tmp343_ - _tmp344_)) * (_tmp345_ - _tmp346_));
	}
	_tmp348_ = r;
	_tmp349_ = R;
	if (_tmp348_ != ((gdouble) _tmp349_)) {
		gdouble _tmp350_ = 0.0;
		gint _tmp351_ = 0;
		_tmp350_ = b;
		_tmp351_ = B;
		_tmp347_ = _tmp350_ != ((gdouble) _tmp351_);
	} else {
		_tmp347_ = FALSE;
	}
	_tmp352_ = _tmp347_;
	if (_tmp352_) {
		guchar p[3] = {0};
		Page* _tmp353_ = NULL;
		gint _tmp354_ = 0;
		gint _tmp355_ = 0;
		gdouble _tmp356_ = 0.0;
		guchar _tmp357_ = '\0';
		gdouble _tmp358_ = 0.0;
		gint _tmp359_ = 0;
		gdouble _tmp360_ = 0.0;
		gint _tmp361_ = 0;
		gdouble _tmp362_ = 0.0;
		guchar _tmp363_ = '\0';
		gdouble _tmp364_ = 0.0;
		gint _tmp365_ = 0;
		gdouble _tmp366_ = 0.0;
		gint _tmp367_ = 0;
		gdouble _tmp368_ = 0.0;
		guchar _tmp369_ = '\0';
		gdouble _tmp370_ = 0.0;
		gint _tmp371_ = 0;
		gdouble _tmp372_ = 0.0;
		gint _tmp373_ = 0;
		_tmp353_ = page;
		_tmp354_ = R;
		_tmp355_ = B;
		page_view_get_pixel (self, _tmp353_, _tmp354_, _tmp355_, p, 3);
		_tmp356_ = red;
		_tmp357_ = p[0];
		_tmp358_ = r;
		_tmp359_ = R;
		_tmp360_ = b;
		_tmp361_ = B;
		red = _tmp356_ + ((_tmp357_ * (_tmp358_ - _tmp359_)) * (_tmp360_ - _tmp361_));
		_tmp362_ = green;
		_tmp363_ = p[1];
		_tmp364_ = r;
		_tmp365_ = R;
		_tmp366_ = b;
		_tmp367_ = B;
		green = _tmp362_ + ((_tmp363_ * (_tmp364_ - _tmp365_)) * (_tmp366_ - _tmp367_));
		_tmp368_ = blue;
		_tmp369_ = p[2];
		_tmp370_ = r;
		_tmp371_ = R;
		_tmp372_ = b;
		_tmp373_ = B;
		blue = _tmp368_ + ((_tmp369_ * (_tmp370_ - _tmp371_)) * (_tmp372_ - _tmp373_));
	}
	_tmp375_ = l;
	_tmp376_ = L;
	if (_tmp375_ != ((gdouble) _tmp376_)) {
		gdouble _tmp377_ = 0.0;
		gint _tmp378_ = 0;
		_tmp377_ = b;
		_tmp378_ = B;
		_tmp374_ = _tmp377_ != ((gdouble) _tmp378_);
	} else {
		_tmp374_ = FALSE;
	}
	_tmp379_ = _tmp374_;
	if (_tmp379_) {
		guchar p[3] = {0};
		Page* _tmp380_ = NULL;
		gint _tmp381_ = 0;
		gint _tmp382_ = 0;
		gdouble _tmp383_ = 0.0;
		guchar _tmp384_ = '\0';
		gint _tmp385_ = 0;
		gdouble _tmp386_ = 0.0;
		gdouble _tmp387_ = 0.0;
		gint _tmp388_ = 0;
		gdouble _tmp389_ = 0.0;
		guchar _tmp390_ = '\0';
		gint _tmp391_ = 0;
		gdouble _tmp392_ = 0.0;
		gdouble _tmp393_ = 0.0;
		gint _tmp394_ = 0;
		gdouble _tmp395_ = 0.0;
		guchar _tmp396_ = '\0';
		gint _tmp397_ = 0;
		gdouble _tmp398_ = 0.0;
		gdouble _tmp399_ = 0.0;
		gint _tmp400_ = 0;
		_tmp380_ = page;
		_tmp381_ = L;
		_tmp382_ = B;
		page_view_get_pixel (self, _tmp380_, _tmp381_ - 1, _tmp382_, p, 3);
		_tmp383_ = red;
		_tmp384_ = p[0];
		_tmp385_ = L;
		_tmp386_ = l;
		_tmp387_ = b;
		_tmp388_ = B;
		red = _tmp383_ + ((_tmp384_ * (_tmp385_ - _tmp386_)) * (_tmp387_ - _tmp388_));
		_tmp389_ = green;
		_tmp390_ = p[1];
		_tmp391_ = L;
		_tmp392_ = l;
		_tmp393_ = b;
		_tmp394_ = B;
		green = _tmp389_ + ((_tmp390_ * (_tmp391_ - _tmp392_)) * (_tmp393_ - _tmp394_));
		_tmp395_ = blue;
		_tmp396_ = p[2];
		_tmp397_ = L;
		_tmp398_ = l;
		_tmp399_ = b;
		_tmp400_ = B;
		blue = _tmp395_ + ((_tmp396_ * (_tmp397_ - _tmp398_)) * (_tmp399_ - _tmp400_));
	}
	_tmp401_ = r;
	_tmp402_ = l;
	_tmp403_ = b;
	_tmp404_ = t;
	scale = 1.0 / ((_tmp401_ - _tmp402_) * (_tmp403_ - _tmp404_));
	_tmp405_ = output;
	_tmp405__length1 = output_length1;
	_tmp406_ = offset;
	_tmp407_ = red;
	_tmp408_ = scale;
	_tmp405_[_tmp406_] = (guchar) ((_tmp407_ * _tmp408_) + 0.5);
	_tmp409_ = _tmp405_[_tmp406_];
	_tmp410_ = output;
	_tmp410__length1 = output_length1;
	_tmp411_ = offset;
	_tmp412_ = green;
	_tmp413_ = scale;
	_tmp410_[_tmp411_ + 1] = (guchar) ((_tmp412_ * _tmp413_) + 0.5);
	_tmp414_ = _tmp410_[_tmp411_ + 1];
	_tmp415_ = output;
	_tmp415__length1 = output_length1;
	_tmp416_ = offset;
	_tmp417_ = blue;
	_tmp418_ = scale;
	_tmp415_[_tmp416_ + 2] = (guchar) ((_tmp417_ * _tmp418_) + 0.5);
	_tmp419_ = _tmp415_[_tmp416_ + 2];
}


static void page_view_update_preview (PageView* self, Page* page, GdkPixbuf** output_image, gint output_width, gint output_height, ScanDirection scan_direction, gint old_scan_line, gint scan_line) {
	gint input_width = 0;
	Page* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint input_height = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GdkPixbuf* _tmp6_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	GdkPixbuf* _tmp68_ = NULL;
	guchar* output = NULL;
	GdkPixbuf* _tmp69_ = NULL;
	guint8* _tmp70_ = NULL;
	gint output_length1 = 0;
	gint _output_size_ = 0;
	gint output_rowstride = 0;
	GdkPixbuf* _tmp71_ = NULL;
	gint _tmp72_ = 0;
	gint output_n_channels = 0;
	GdkPixbuf* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	Page* _tmp75_ = NULL;
	gboolean _tmp76_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_get_width (_tmp0_);
	input_width = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_height (_tmp2_);
	input_height = _tmp3_;
	_tmp6_ = *output_image;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		GdkPixbuf* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp7_ = *output_image;
		_tmp8_ = gdk_pixbuf_get_width (_tmp7_);
		_tmp9_ = output_width;
		_tmp5_ = _tmp8_ != _tmp9_;
	}
	_tmp10_ = _tmp5_;
	if (_tmp10_) {
		_tmp4_ = TRUE;
	} else {
		GdkPixbuf* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp11_ = *output_image;
		_tmp12_ = gdk_pixbuf_get_height (_tmp11_);
		_tmp13_ = output_height;
		_tmp4_ = _tmp12_ != _tmp13_;
	}
	_tmp14_ = _tmp4_;
	if (_tmp14_) {
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GdkPixbuf* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		_tmp15_ = output_width;
		_tmp16_ = output_height;
		_tmp17_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp15_, _tmp16_);
		_g_object_unref0 (*output_image);
		*output_image = _tmp17_;
		L = 0;
		_tmp18_ = output_width;
		R = _tmp18_ - 1;
		T = 0;
		_tmp19_ = output_height;
		B = _tmp19_ - 1;
	} else {
		ScanDirection _tmp20_ = 0;
		_tmp20_ = scan_direction;
		switch (_tmp20_) {
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
			{
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				L = 0;
				_tmp21_ = output_width;
				R = _tmp21_ - 1;
				_tmp22_ = old_scan_line;
				_tmp23_ = output_height;
				_tmp24_ = input_height;
				T = (gint) ((((gdouble) _tmp22_) * _tmp23_) / _tmp24_);
				_tmp25_ = scan_line;
				_tmp26_ = output_height;
				_tmp27_ = input_height;
				B = (gint) (((((gdouble) _tmp25_) * _tmp26_) / _tmp27_) + 0.5);
				break;
			}
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
			{
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				_tmp28_ = old_scan_line;
				_tmp29_ = output_width;
				_tmp30_ = input_width;
				L = (gint) ((((gdouble) _tmp28_) * _tmp29_) / _tmp30_);
				_tmp31_ = scan_line;
				_tmp32_ = output_width;
				_tmp33_ = input_width;
				R = (gint) (((((gdouble) _tmp31_) * _tmp32_) / _tmp33_) + 0.5);
				T = 0;
				_tmp34_ = output_height;
				B = _tmp34_ - 1;
				break;
			}
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
			{
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				L = 0;
				_tmp35_ = output_width;
				R = _tmp35_ - 1;
				_tmp36_ = input_height;
				_tmp37_ = scan_line;
				_tmp38_ = output_height;
				_tmp39_ = input_height;
				T = (gint) ((((gdouble) (_tmp36_ - _tmp37_)) * _tmp38_) / _tmp39_);
				_tmp40_ = input_height;
				_tmp41_ = old_scan_line;
				_tmp42_ = output_height;
				_tmp43_ = input_height;
				B = (gint) (((((gdouble) (_tmp40_ - _tmp41_)) * _tmp42_) / _tmp43_) + 0.5);
				break;
			}
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
			{
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
				_tmp44_ = input_width;
				_tmp45_ = scan_line;
				_tmp46_ = output_width;
				_tmp47_ = input_width;
				L = (gint) ((((gdouble) (_tmp44_ - _tmp45_)) * _tmp46_) / _tmp47_);
				_tmp48_ = input_width;
				_tmp49_ = old_scan_line;
				_tmp50_ = output_width;
				_tmp51_ = input_width;
				R = (gint) (((((gdouble) (_tmp48_ - _tmp49_)) * _tmp50_) / _tmp51_) + 0.5);
				T = 0;
				_tmp52_ = output_height;
				B = _tmp52_ - 1;
				break;
			}
			default:
			{
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				T = 0;
				_tmp53_ = T;
				B = _tmp53_;
				_tmp54_ = B;
				R = _tmp54_;
				_tmp55_ = R;
				L = _tmp55_;
				break;
			}
		}
	}
	_tmp56_ = R;
	_tmp57_ = output_width;
	if (_tmp56_ >= _tmp57_) {
		gint _tmp58_ = 0;
		_tmp58_ = output_width;
		R = _tmp58_ - 1;
	}
	_tmp59_ = B;
	_tmp60_ = output_height;
	if (_tmp59_ >= _tmp60_) {
		gint _tmp61_ = 0;
		_tmp61_ = output_height;
		B = _tmp61_ - 1;
	}
	_tmp62_ = L;
	g_return_if_fail (_tmp62_ >= 0);
	_tmp63_ = R;
	_tmp64_ = output_width;
	g_return_if_fail (_tmp63_ < _tmp64_);
	_tmp65_ = T;
	g_return_if_fail (_tmp65_ >= 0);
	_tmp66_ = B;
	_tmp67_ = output_height;
	g_return_if_fail (_tmp66_ < _tmp67_);
	_tmp68_ = *output_image;
	g_return_if_fail (_tmp68_ != NULL);
	_tmp69_ = *output_image;
	_tmp70_ = gdk_pixbuf_get_pixels (_tmp69_);
	output = _tmp70_;
	output_length1 = -1;
	_output_size_ = output_length1;
	_tmp71_ = *output_image;
	_tmp72_ = gdk_pixbuf_get_rowstride (_tmp71_);
	output_rowstride = _tmp72_;
	_tmp73_ = *output_image;
	_tmp74_ = gdk_pixbuf_get_n_channels (_tmp73_);
	output_n_channels = _tmp74_;
	_tmp75_ = page;
	_tmp76_ = page_has_data (_tmp75_);
	if (!_tmp76_) {
		{
			gint x = 0;
			gint _tmp77_ = 0;
			_tmp77_ = L;
			x = _tmp77_;
			{
				gboolean _tmp78_ = FALSE;
				_tmp78_ = TRUE;
				while (TRUE) {
					gboolean _tmp79_ = FALSE;
					gint _tmp81_ = 0;
					gint _tmp82_ = 0;
					_tmp79_ = _tmp78_;
					if (!_tmp79_) {
						gint _tmp80_ = 0;
						_tmp80_ = x;
						x = _tmp80_ + 1;
					}
					_tmp78_ = FALSE;
					_tmp81_ = x;
					_tmp82_ = R;
					if (!(_tmp81_ <= _tmp82_)) {
						break;
					}
					{
						gint y = 0;
						gint _tmp83_ = 0;
						_tmp83_ = T;
						y = _tmp83_;
						{
							gboolean _tmp84_ = FALSE;
							_tmp84_ = TRUE;
							while (TRUE) {
								gboolean _tmp85_ = FALSE;
								gint _tmp87_ = 0;
								gint _tmp88_ = 0;
								gint o = 0;
								gint _tmp89_ = 0;
								gint _tmp90_ = 0;
								gint _tmp91_ = 0;
								gint _tmp92_ = 0;
								guchar* _tmp93_ = NULL;
								gint _tmp93__length1 = 0;
								gint _tmp94_ = 0;
								guchar* _tmp95_ = NULL;
								gint _tmp95__length1 = 0;
								gint _tmp96_ = 0;
								guchar* _tmp97_ = NULL;
								gint _tmp97__length1 = 0;
								gint _tmp98_ = 0;
								guchar _tmp99_ = '\0';
								guchar _tmp100_ = '\0';
								guchar _tmp101_ = '\0';
								_tmp85_ = _tmp84_;
								if (!_tmp85_) {
									gint _tmp86_ = 0;
									_tmp86_ = y;
									y = _tmp86_ + 1;
								}
								_tmp84_ = FALSE;
								_tmp87_ = y;
								_tmp88_ = B;
								if (!(_tmp87_ <= _tmp88_)) {
									break;
								}
								_tmp89_ = output_rowstride;
								_tmp90_ = y;
								_tmp91_ = x;
								_tmp92_ = output_n_channels;
								o = (_tmp89_ * _tmp90_) + (_tmp91_ * _tmp92_);
								_tmp93_ = output;
								_tmp93__length1 = output_length1;
								_tmp94_ = o;
								_tmp95_ = output;
								_tmp95__length1 = output_length1;
								_tmp96_ = o;
								_tmp97_ = output;
								_tmp97__length1 = output_length1;
								_tmp98_ = o;
								_tmp97_[_tmp98_ + 2] = (guchar) 0xFF;
								_tmp99_ = _tmp97_[_tmp98_ + 2];
								_tmp95_[_tmp96_ + 1] = _tmp99_;
								_tmp100_ = _tmp95_[_tmp96_ + 1];
								_tmp93_[_tmp94_] = _tmp100_;
								_tmp101_ = _tmp93_[_tmp94_];
							}
						}
					}
				}
			}
		}
		return;
	}
	{
		gint x = 0;
		gint _tmp102_ = 0;
		_tmp102_ = L;
		x = _tmp102_;
		{
			gboolean _tmp103_ = FALSE;
			_tmp103_ = TRUE;
			while (TRUE) {
				gboolean _tmp104_ = FALSE;
				gint _tmp106_ = 0;
				gint _tmp107_ = 0;
				gdouble l = 0.0;
				gint _tmp108_ = 0;
				gint _tmp109_ = 0;
				gint _tmp110_ = 0;
				gdouble r = 0.0;
				gint _tmp111_ = 0;
				gint _tmp112_ = 0;
				gint _tmp113_ = 0;
				_tmp104_ = _tmp103_;
				if (!_tmp104_) {
					gint _tmp105_ = 0;
					_tmp105_ = x;
					x = _tmp105_ + 1;
				}
				_tmp103_ = FALSE;
				_tmp106_ = x;
				_tmp107_ = R;
				if (!(_tmp106_ <= _tmp107_)) {
					break;
				}
				_tmp108_ = x;
				_tmp109_ = input_width;
				_tmp110_ = output_width;
				l = (((gdouble) _tmp108_) * _tmp109_) / _tmp110_;
				_tmp111_ = x;
				_tmp112_ = input_width;
				_tmp113_ = output_width;
				r = (((gdouble) (_tmp111_ + 1)) * _tmp112_) / _tmp113_;
				{
					gint y = 0;
					gint _tmp114_ = 0;
					_tmp114_ = T;
					y = _tmp114_;
					{
						gboolean _tmp115_ = FALSE;
						_tmp115_ = TRUE;
						while (TRUE) {
							gboolean _tmp116_ = FALSE;
							gint _tmp118_ = 0;
							gint _tmp119_ = 0;
							gdouble t = 0.0;
							gint _tmp120_ = 0;
							gint _tmp121_ = 0;
							gint _tmp122_ = 0;
							gdouble b = 0.0;
							gint _tmp123_ = 0;
							gint _tmp124_ = 0;
							gint _tmp125_ = 0;
							Page* _tmp126_ = NULL;
							gdouble _tmp127_ = 0.0;
							gdouble _tmp128_ = 0.0;
							gdouble _tmp129_ = 0.0;
							gdouble _tmp130_ = 0.0;
							guchar* _tmp131_ = NULL;
							gint _tmp131__length1 = 0;
							gint _tmp132_ = 0;
							gint _tmp133_ = 0;
							gint _tmp134_ = 0;
							gint _tmp135_ = 0;
							_tmp116_ = _tmp115_;
							if (!_tmp116_) {
								gint _tmp117_ = 0;
								_tmp117_ = y;
								y = _tmp117_ + 1;
							}
							_tmp115_ = FALSE;
							_tmp118_ = y;
							_tmp119_ = B;
							if (!(_tmp118_ <= _tmp119_)) {
								break;
							}
							_tmp120_ = y;
							_tmp121_ = input_height;
							_tmp122_ = output_height;
							t = (((gdouble) _tmp120_) * _tmp121_) / _tmp122_;
							_tmp123_ = y;
							_tmp124_ = input_height;
							_tmp125_ = output_height;
							b = (((gdouble) (_tmp123_ + 1)) * _tmp124_) / _tmp125_;
							_tmp126_ = page;
							_tmp127_ = l;
							_tmp128_ = r;
							_tmp129_ = t;
							_tmp130_ = b;
							_tmp131_ = output;
							_tmp131__length1 = output_length1;
							_tmp132_ = output_rowstride;
							_tmp133_ = y;
							_tmp134_ = x;
							_tmp135_ = output_n_channels;
							page_view_set_pixel (self, _tmp126_, _tmp127_, _tmp128_, _tmp129_, _tmp130_, _tmp131_, _tmp131__length1, (_tmp132_ * _tmp133_) + (_tmp134_ * _tmp135_));
						}
					}
				}
			}
		}
	}
}


static gint page_view_get_preview_width (PageView* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->width;
	_tmp1_ = self->priv->border_width;
	result = _tmp0_ - (_tmp1_ * 2);
	return result;
}


static gint page_view_get_preview_height (PageView* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->height;
	_tmp1_ = self->priv->border_width;
	result = _tmp0_ - (_tmp1_ * 2);
	return result;
}


static void page_view_update_page_view (PageView* self) {
	gboolean _tmp0_ = FALSE;
	gint old_scan_line = 0;
	gint _tmp1_ = 0;
	gint scan_line = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ScanDirection left_steps = 0;
	ScanDirection _tmp4_ = 0;
	Page* _tmp5_ = NULL;
	ScanDirection _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	ScanDirection _tmp8_ = 0;
	gboolean _tmp10_ = FALSE;
	Page* _tmp11_ = NULL;
	ScanDirection _tmp12_ = 0;
	Page* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	Page* _tmp16_ = NULL;
	ScanDirection _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->update_image;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->scan_line;
	old_scan_line = _tmp1_;
	_tmp2_ = self->priv->page;
	_tmp3_ = page_get_scan_line (_tmp2_);
	scan_line = _tmp3_;
	_tmp4_ = self->priv->scan_direction;
	_tmp5_ = self->priv->page;
	_tmp6_ = page_get_scan_direction (_tmp5_);
	left_steps = _tmp4_ - _tmp6_;
	_tmp8_ = left_steps;
	if (_tmp8_ != 0) {
		GdkPixbuf* _tmp9_ = NULL;
		_tmp9_ = self->priv->image;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		_g_object_unref0 (self->priv->image);
		self->priv->image = NULL;
	}
	_tmp11_ = self->priv->page;
	_tmp12_ = page_get_scan_direction (_tmp11_);
	self->priv->scan_direction = _tmp12_;
	_tmp13_ = self->priv->page;
	_tmp14_ = page_view_get_preview_width (self);
	_tmp15_ = page_view_get_preview_height (self);
	_tmp16_ = self->priv->page;
	_tmp17_ = page_get_scan_direction (_tmp16_);
	_tmp18_ = old_scan_line;
	_tmp19_ = scan_line;
	page_view_update_preview (self, _tmp13_, &self->priv->image, _tmp14_, _tmp15_, _tmp17_, _tmp18_, _tmp19_);
	self->priv->update_image = FALSE;
	_tmp20_ = scan_line;
	self->priv->scan_line = _tmp20_;
}


static gint page_view_page_to_screen_x (PageView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = page_view_get_preview_width (self);
	_tmp2_ = self->priv->page;
	_tmp3_ = page_get_width (_tmp2_);
	result = (gint) (((((gdouble) _tmp0_) * _tmp1_) / _tmp3_) + 0.5);
	return result;
}


static gint page_view_page_to_screen_y (PageView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = y;
	_tmp1_ = page_view_get_preview_height (self);
	_tmp2_ = self->priv->page;
	_tmp3_ = page_get_height (_tmp2_);
	result = (gint) (((((gdouble) _tmp0_) * _tmp1_) / _tmp3_) + 0.5);
	return result;
}


static gint page_view_screen_to_page_x (PageView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = self->priv->page;
	_tmp2_ = page_get_width (_tmp1_);
	_tmp3_ = page_view_get_preview_width (self);
	result = (gint) (((((gdouble) _tmp0_) * _tmp2_) / _tmp3_) + 0.5);
	return result;
}


static gint page_view_screen_to_page_y (PageView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = y;
	_tmp1_ = self->priv->page;
	_tmp2_ = page_get_height (_tmp1_);
	_tmp3_ = page_view_get_preview_height (self);
	result = (gint) (((((gdouble) _tmp0_) * _tmp2_) / _tmp3_) + 0.5);
	return result;
}


static CropLocation page_view_get_crop_location (PageView* self, gint x, gint y) {
	CropLocation result = 0;
	Page* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint dx = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint dy = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint dw = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint dh = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint ix = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint iy = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gint _tmp22_ = 0;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gchar* name = NULL;
	Page* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gint crop_border = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean _tmp40_ = FALSE;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	gboolean _tmp67_ = FALSE;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	gint _tmp77_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->page;
	_tmp1_ = page_has_crop (_tmp0_);
	if (!_tmp1_) {
		result = 0;
		return result;
	}
	_tmp2_ = self->priv->page;
	page_get_crop (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	cx = _tmp3_;
	cy = _tmp4_;
	cw = _tmp5_;
	ch = _tmp6_;
	_tmp7_ = cx;
	_tmp8_ = page_view_page_to_screen_x (self, _tmp7_);
	dx = _tmp8_;
	_tmp9_ = cy;
	_tmp10_ = page_view_page_to_screen_y (self, _tmp9_);
	dy = _tmp10_;
	_tmp11_ = cw;
	_tmp12_ = page_view_page_to_screen_x (self, _tmp11_);
	dw = _tmp12_;
	_tmp13_ = ch;
	_tmp14_ = page_view_page_to_screen_y (self, _tmp13_);
	dh = _tmp14_;
	_tmp15_ = x;
	_tmp16_ = dx;
	ix = _tmp15_ - _tmp16_;
	_tmp17_ = y;
	_tmp18_ = dy;
	iy = _tmp17_ - _tmp18_;
	_tmp22_ = ix;
	if (_tmp22_ < 0) {
		_tmp21_ = TRUE;
	} else {
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		_tmp23_ = ix;
		_tmp24_ = dw;
		_tmp21_ = _tmp23_ > _tmp24_;
	}
	_tmp25_ = _tmp21_;
	if (_tmp25_) {
		_tmp20_ = TRUE;
	} else {
		gint _tmp26_ = 0;
		_tmp26_ = iy;
		_tmp20_ = _tmp26_ < 0;
	}
	_tmp27_ = _tmp20_;
	if (_tmp27_) {
		_tmp19_ = TRUE;
	} else {
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		_tmp28_ = iy;
		_tmp29_ = dh;
		_tmp19_ = _tmp28_ > _tmp29_;
	}
	_tmp30_ = _tmp19_;
	if (_tmp30_) {
		result = CROP_LOCATION_NONE;
		return result;
	}
	_tmp31_ = self->priv->page;
	_tmp32_ = page_get_named_crop (_tmp31_);
	name = _tmp32_;
	_tmp33_ = name;
	if (_tmp33_ != NULL) {
		result = CROP_LOCATION_MIDDLE;
		_g_free0 (name);
		return result;
	}
	crop_border = 20;
	_tmp34_ = dw;
	_tmp35_ = crop_border;
	if (_tmp34_ < (_tmp35_ * 3)) {
		gint _tmp36_ = 0;
		_tmp36_ = dw;
		crop_border = _tmp36_ / 3;
	}
	_tmp37_ = dh;
	_tmp38_ = crop_border;
	if (_tmp37_ < (_tmp38_ * 3)) {
		gint _tmp39_ = 0;
		_tmp39_ = dh;
		crop_border = _tmp39_ / 3;
	}
	_tmp41_ = ix;
	_tmp42_ = crop_border;
	if (_tmp41_ < _tmp42_) {
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		_tmp43_ = iy;
		_tmp44_ = crop_border;
		_tmp40_ = _tmp43_ < _tmp44_;
	} else {
		_tmp40_ = FALSE;
	}
	_tmp45_ = _tmp40_;
	if (_tmp45_) {
		result = CROP_LOCATION_TOP_LEFT;
		_g_free0 (name);
		return result;
	}
	_tmp47_ = ix;
	_tmp48_ = dw;
	_tmp49_ = crop_border;
	if (_tmp47_ > (_tmp48_ - _tmp49_)) {
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		_tmp50_ = iy;
		_tmp51_ = crop_border;
		_tmp46_ = _tmp50_ < _tmp51_;
	} else {
		_tmp46_ = FALSE;
	}
	_tmp52_ = _tmp46_;
	if (_tmp52_) {
		result = CROP_LOCATION_TOP_RIGHT;
		_g_free0 (name);
		return result;
	}
	_tmp54_ = ix;
	_tmp55_ = crop_border;
	if (_tmp54_ < _tmp55_) {
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		_tmp56_ = iy;
		_tmp57_ = dh;
		_tmp58_ = crop_border;
		_tmp53_ = _tmp56_ > (_tmp57_ - _tmp58_);
	} else {
		_tmp53_ = FALSE;
	}
	_tmp59_ = _tmp53_;
	if (_tmp59_) {
		result = CROP_LOCATION_BOTTOM_LEFT;
		_g_free0 (name);
		return result;
	}
	_tmp61_ = ix;
	_tmp62_ = dw;
	_tmp63_ = crop_border;
	if (_tmp61_ > (_tmp62_ - _tmp63_)) {
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		_tmp64_ = iy;
		_tmp65_ = dh;
		_tmp66_ = crop_border;
		_tmp60_ = _tmp64_ > (_tmp65_ - _tmp66_);
	} else {
		_tmp60_ = FALSE;
	}
	_tmp67_ = _tmp60_;
	if (_tmp67_) {
		result = CROP_LOCATION_BOTTOM_RIGHT;
		_g_free0 (name);
		return result;
	}
	_tmp68_ = ix;
	_tmp69_ = crop_border;
	if (_tmp68_ < _tmp69_) {
		result = CROP_LOCATION_LEFT;
		_g_free0 (name);
		return result;
	}
	_tmp70_ = ix;
	_tmp71_ = dw;
	_tmp72_ = crop_border;
	if (_tmp70_ > (_tmp71_ - _tmp72_)) {
		result = CROP_LOCATION_RIGHT;
		_g_free0 (name);
		return result;
	}
	_tmp73_ = iy;
	_tmp74_ = crop_border;
	if (_tmp73_ < _tmp74_) {
		result = CROP_LOCATION_TOP;
		_g_free0 (name);
		return result;
	}
	_tmp75_ = iy;
	_tmp76_ = dh;
	_tmp77_ = crop_border;
	if (_tmp75_ > (_tmp76_ - _tmp77_)) {
		result = CROP_LOCATION_BOTTOM;
		_g_free0 (name);
		return result;
	}
	result = CROP_LOCATION_MIDDLE;
	_g_free0 (name);
	return result;
}


void page_view_button_press (PageView* self, gint x, gint y) {
	CropLocation location = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CropLocation _tmp2_ = 0;
	CropLocation _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = page_view_get_crop_location (self, _tmp0_, _tmp1_);
	location = _tmp2_;
	_tmp3_ = location;
	if (_tmp3_ != CROP_LOCATION_NONE) {
		CropLocation _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		Page* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp4_ = location;
		self->priv->crop_location = _tmp4_;
		_tmp5_ = x;
		self->priv->selected_crop_px = (gdouble) _tmp5_;
		_tmp6_ = y;
		self->priv->selected_crop_py = (gdouble) _tmp6_;
		_tmp7_ = self->priv->page;
		page_get_crop (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
		self->priv->selected_crop_x = _tmp8_;
		self->priv->selected_crop_y = _tmp9_;
		self->priv->selected_crop_w = _tmp10_;
		self->priv->selected_crop_h = _tmp11_;
	}
}


void page_view_motion (PageView* self, gint x, gint y) {
	CropLocation location = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CropLocation _tmp2_ = 0;
	GdkCursorType cursor = 0;
	CropLocation _tmp3_ = 0;
	CropLocation _tmp4_ = 0;
	gint pw = 0;
	Page* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint ph = 0;
	Page* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint dx = 0;
	gint _tmp15_ = 0;
	gdouble _tmp16_ = 0.0;
	gint _tmp17_ = 0;
	gint dy = 0;
	gint _tmp18_ = 0;
	gdouble _tmp19_ = 0.0;
	gint _tmp20_ = 0;
	gint new_x = 0;
	gint _tmp21_ = 0;
	gint new_y = 0;
	gint _tmp22_ = 0;
	gint new_w = 0;
	gint _tmp23_ = 0;
	gint new_h = 0;
	gint _tmp24_ = 0;
	gint min_size = 0;
	gint _tmp25_ = 0;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	CropLocation _tmp28_ = 0;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	CropLocation _tmp43_ = 0;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	CropLocation _tmp58_ = 0;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	CropLocation _tmp77_ = 0;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp81_ = FALSE;
	CropLocation _tmp94_ = 0;
	CropLocation _tmp115_ = 0;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp121_ = FALSE;
	CropLocation _tmp122_ = 0;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp126_ = FALSE;
	gboolean _tmp131_ = FALSE;
	gboolean _tmp132_ = FALSE;
	CropLocation _tmp133_ = 0;
	gboolean _tmp135_ = FALSE;
	gboolean _tmp137_ = FALSE;
	gboolean _tmp142_ = FALSE;
	gboolean _tmp143_ = FALSE;
	CropLocation _tmp144_ = 0;
	gboolean _tmp146_ = FALSE;
	gboolean _tmp148_ = FALSE;
	gboolean _tmp151_ = FALSE;
	gboolean _tmp152_ = FALSE;
	CropLocation _tmp153_ = 0;
	gboolean _tmp155_ = FALSE;
	gboolean _tmp157_ = FALSE;
	Page* _tmp160_ = NULL;
	gint _tmp161_ = 0;
	gint _tmp162_ = 0;
	gboolean _tmp163_ = FALSE;
	gint _tmp164_ = 0;
	gint _tmp165_ = 0;
	gboolean _tmp168_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = page_view_get_crop_location (self, _tmp0_, _tmp1_);
	location = _tmp2_;
	_tmp3_ = location;
	switch (_tmp3_) {
		case CROP_LOCATION_MIDDLE:
		{
			cursor = GDK_HAND1;
			break;
		}
		case CROP_LOCATION_TOP:
		{
			cursor = GDK_TOP_SIDE;
			break;
		}
		case CROP_LOCATION_BOTTOM:
		{
			cursor = GDK_BOTTOM_SIDE;
			break;
		}
		case CROP_LOCATION_LEFT:
		{
			cursor = GDK_LEFT_SIDE;
			break;
		}
		case CROP_LOCATION_RIGHT:
		{
			cursor = GDK_RIGHT_SIDE;
			break;
		}
		case CROP_LOCATION_TOP_LEFT:
		{
			cursor = GDK_TOP_LEFT_CORNER;
			break;
		}
		case CROP_LOCATION_TOP_RIGHT:
		{
			cursor = GDK_TOP_RIGHT_CORNER;
			break;
		}
		case CROP_LOCATION_BOTTOM_LEFT:
		{
			cursor = GDK_BOTTOM_LEFT_CORNER;
			break;
		}
		case CROP_LOCATION_BOTTOM_RIGHT:
		{
			cursor = GDK_BOTTOM_RIGHT_CORNER;
			break;
		}
		default:
		{
			cursor = GDK_ARROW;
			break;
		}
	}
	_tmp4_ = self->priv->crop_location;
	if (_tmp4_ == CROP_LOCATION_NONE) {
		GdkCursorType _tmp5_ = 0;
		_tmp5_ = cursor;
		self->priv->cursor = _tmp5_;
		return;
	}
	_tmp6_ = self->priv->page;
	_tmp7_ = page_get_width (_tmp6_);
	pw = _tmp7_;
	_tmp8_ = self->priv->page;
	_tmp9_ = page_get_height (_tmp8_);
	ph = _tmp9_;
	_tmp10_ = self->priv->page;
	page_get_crop (_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	cx = _tmp11_;
	cy = _tmp12_;
	cw = _tmp13_;
	ch = _tmp14_;
	_tmp15_ = x;
	_tmp16_ = self->priv->selected_crop_px;
	_tmp17_ = page_view_screen_to_page_x (self, _tmp15_ - ((gint) _tmp16_));
	dx = _tmp17_;
	_tmp18_ = y;
	_tmp19_ = self->priv->selected_crop_py;
	_tmp20_ = page_view_screen_to_page_y (self, _tmp18_ - ((gint) _tmp19_));
	dy = _tmp20_;
	_tmp21_ = self->priv->selected_crop_x;
	new_x = _tmp21_;
	_tmp22_ = self->priv->selected_crop_y;
	new_y = _tmp22_;
	_tmp23_ = self->priv->selected_crop_w;
	new_w = _tmp23_;
	_tmp24_ = self->priv->selected_crop_h;
	new_h = _tmp24_;
	_tmp25_ = page_view_screen_to_page_x (self, 15);
	min_size = _tmp25_;
	_tmp28_ = self->priv->crop_location;
	if (_tmp28_ == CROP_LOCATION_TOP_LEFT) {
		_tmp27_ = TRUE;
	} else {
		CropLocation _tmp29_ = 0;
		_tmp29_ = self->priv->crop_location;
		_tmp27_ = _tmp29_ == CROP_LOCATION_LEFT;
	}
	_tmp30_ = _tmp27_;
	if (_tmp30_) {
		_tmp26_ = TRUE;
	} else {
		CropLocation _tmp31_ = 0;
		_tmp31_ = self->priv->crop_location;
		_tmp26_ = _tmp31_ == CROP_LOCATION_BOTTOM_LEFT;
	}
	_tmp32_ = _tmp26_;
	if (_tmp32_) {
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		_tmp33_ = dx;
		_tmp34_ = new_w;
		_tmp35_ = min_size;
		if (_tmp33_ > (_tmp34_ - _tmp35_)) {
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			_tmp36_ = new_w;
			_tmp37_ = min_size;
			dx = _tmp36_ - _tmp37_;
		}
		_tmp38_ = new_x;
		_tmp39_ = dx;
		if ((_tmp38_ + _tmp39_) < 0) {
			gint _tmp40_ = 0;
			_tmp40_ = new_x;
			dx = -_tmp40_;
		}
	}
	_tmp43_ = self->priv->crop_location;
	if (_tmp43_ == CROP_LOCATION_TOP_LEFT) {
		_tmp42_ = TRUE;
	} else {
		CropLocation _tmp44_ = 0;
		_tmp44_ = self->priv->crop_location;
		_tmp42_ = _tmp44_ == CROP_LOCATION_TOP;
	}
	_tmp45_ = _tmp42_;
	if (_tmp45_) {
		_tmp41_ = TRUE;
	} else {
		CropLocation _tmp46_ = 0;
		_tmp46_ = self->priv->crop_location;
		_tmp41_ = _tmp46_ == CROP_LOCATION_TOP_RIGHT;
	}
	_tmp47_ = _tmp41_;
	if (_tmp47_) {
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		_tmp48_ = dy;
		_tmp49_ = new_h;
		_tmp50_ = min_size;
		if (_tmp48_ > (_tmp49_ - _tmp50_)) {
			gint _tmp51_ = 0;
			gint _tmp52_ = 0;
			_tmp51_ = new_h;
			_tmp52_ = min_size;
			dy = _tmp51_ - _tmp52_;
		}
		_tmp53_ = new_y;
		_tmp54_ = dy;
		if ((_tmp53_ + _tmp54_) < 0) {
			gint _tmp55_ = 0;
			_tmp55_ = new_y;
			dy = -_tmp55_;
		}
	}
	_tmp58_ = self->priv->crop_location;
	if (_tmp58_ == CROP_LOCATION_TOP_RIGHT) {
		_tmp57_ = TRUE;
	} else {
		CropLocation _tmp59_ = 0;
		_tmp59_ = self->priv->crop_location;
		_tmp57_ = _tmp59_ == CROP_LOCATION_RIGHT;
	}
	_tmp60_ = _tmp57_;
	if (_tmp60_) {
		_tmp56_ = TRUE;
	} else {
		CropLocation _tmp61_ = 0;
		_tmp61_ = self->priv->crop_location;
		_tmp56_ = _tmp61_ == CROP_LOCATION_BOTTOM_RIGHT;
	}
	_tmp62_ = _tmp56_;
	if (_tmp62_) {
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		_tmp63_ = dx;
		_tmp64_ = min_size;
		_tmp65_ = new_w;
		if (_tmp63_ < (_tmp64_ - _tmp65_)) {
			gint _tmp66_ = 0;
			gint _tmp67_ = 0;
			_tmp66_ = min_size;
			_tmp67_ = new_w;
			dx = _tmp66_ - _tmp67_;
		}
		_tmp68_ = new_x;
		_tmp69_ = new_w;
		_tmp70_ = dx;
		_tmp71_ = pw;
		if (((_tmp68_ + _tmp69_) + _tmp70_) > _tmp71_) {
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gint _tmp74_ = 0;
			_tmp72_ = pw;
			_tmp73_ = new_x;
			_tmp74_ = new_w;
			dx = (_tmp72_ - _tmp73_) - _tmp74_;
		}
	}
	_tmp77_ = self->priv->crop_location;
	if (_tmp77_ == CROP_LOCATION_BOTTOM_LEFT) {
		_tmp76_ = TRUE;
	} else {
		CropLocation _tmp78_ = 0;
		_tmp78_ = self->priv->crop_location;
		_tmp76_ = _tmp78_ == CROP_LOCATION_BOTTOM;
	}
	_tmp79_ = _tmp76_;
	if (_tmp79_) {
		_tmp75_ = TRUE;
	} else {
		CropLocation _tmp80_ = 0;
		_tmp80_ = self->priv->crop_location;
		_tmp75_ = _tmp80_ == CROP_LOCATION_BOTTOM_RIGHT;
	}
	_tmp81_ = _tmp75_;
	if (_tmp81_) {
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		gint _tmp84_ = 0;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		gint _tmp89_ = 0;
		gint _tmp90_ = 0;
		_tmp82_ = dy;
		_tmp83_ = min_size;
		_tmp84_ = new_h;
		if (_tmp82_ < (_tmp83_ - _tmp84_)) {
			gint _tmp85_ = 0;
			gint _tmp86_ = 0;
			_tmp85_ = min_size;
			_tmp86_ = new_h;
			dy = _tmp85_ - _tmp86_;
		}
		_tmp87_ = new_y;
		_tmp88_ = new_h;
		_tmp89_ = dy;
		_tmp90_ = ph;
		if (((_tmp87_ + _tmp88_) + _tmp89_) > _tmp90_) {
			gint _tmp91_ = 0;
			gint _tmp92_ = 0;
			gint _tmp93_ = 0;
			_tmp91_ = ph;
			_tmp92_ = new_y;
			_tmp93_ = new_h;
			dy = (_tmp91_ - _tmp92_) - _tmp93_;
		}
	}
	_tmp94_ = self->priv->crop_location;
	if (_tmp94_ == CROP_LOCATION_MIDDLE) {
		gint _tmp95_ = 0;
		gint _tmp96_ = 0;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp102_ = 0;
		gint _tmp103_ = 0;
		gint _tmp105_ = 0;
		gint _tmp106_ = 0;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		_tmp95_ = new_x;
		_tmp96_ = dx;
		_tmp97_ = new_w;
		_tmp98_ = pw;
		if (((_tmp95_ + _tmp96_) + _tmp97_) > _tmp98_) {
			gint _tmp99_ = 0;
			gint _tmp100_ = 0;
			gint _tmp101_ = 0;
			_tmp99_ = pw;
			_tmp100_ = new_x;
			_tmp101_ = new_w;
			dx = (_tmp99_ - _tmp100_) - _tmp101_;
		}
		_tmp102_ = new_x;
		_tmp103_ = dx;
		if ((_tmp102_ + _tmp103_) < 0) {
			gint _tmp104_ = 0;
			_tmp104_ = new_x;
			dx = -_tmp104_;
		}
		_tmp105_ = new_y;
		_tmp106_ = dy;
		_tmp107_ = new_h;
		_tmp108_ = ph;
		if (((_tmp105_ + _tmp106_) + _tmp107_) > _tmp108_) {
			gint _tmp109_ = 0;
			gint _tmp110_ = 0;
			gint _tmp111_ = 0;
			_tmp109_ = ph;
			_tmp110_ = new_y;
			_tmp111_ = new_h;
			dy = (_tmp109_ - _tmp110_) - _tmp111_;
		}
		_tmp112_ = new_y;
		_tmp113_ = dy;
		if ((_tmp112_ + _tmp113_) < 0) {
			gint _tmp114_ = 0;
			_tmp114_ = new_y;
			dy = -_tmp114_;
		}
	}
	_tmp115_ = self->priv->crop_location;
	if (_tmp115_ == CROP_LOCATION_MIDDLE) {
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		_tmp116_ = new_x;
		_tmp117_ = dx;
		new_x = _tmp116_ + _tmp117_;
		_tmp118_ = new_y;
		_tmp119_ = dy;
		new_y = _tmp118_ + _tmp119_;
	}
	_tmp122_ = self->priv->crop_location;
	if (_tmp122_ == CROP_LOCATION_TOP_LEFT) {
		_tmp121_ = TRUE;
	} else {
		CropLocation _tmp123_ = 0;
		_tmp123_ = self->priv->crop_location;
		_tmp121_ = _tmp123_ == CROP_LOCATION_LEFT;
	}
	_tmp124_ = _tmp121_;
	if (_tmp124_) {
		_tmp120_ = TRUE;
	} else {
		CropLocation _tmp125_ = 0;
		_tmp125_ = self->priv->crop_location;
		_tmp120_ = _tmp125_ == CROP_LOCATION_BOTTOM_LEFT;
	}
	_tmp126_ = _tmp120_;
	if (_tmp126_) {
		gint _tmp127_ = 0;
		gint _tmp128_ = 0;
		gint _tmp129_ = 0;
		gint _tmp130_ = 0;
		_tmp127_ = new_x;
		_tmp128_ = dx;
		new_x = _tmp127_ + _tmp128_;
		_tmp129_ = new_w;
		_tmp130_ = dx;
		new_w = _tmp129_ - _tmp130_;
	}
	_tmp133_ = self->priv->crop_location;
	if (_tmp133_ == CROP_LOCATION_TOP_LEFT) {
		_tmp132_ = TRUE;
	} else {
		CropLocation _tmp134_ = 0;
		_tmp134_ = self->priv->crop_location;
		_tmp132_ = _tmp134_ == CROP_LOCATION_TOP;
	}
	_tmp135_ = _tmp132_;
	if (_tmp135_) {
		_tmp131_ = TRUE;
	} else {
		CropLocation _tmp136_ = 0;
		_tmp136_ = self->priv->crop_location;
		_tmp131_ = _tmp136_ == CROP_LOCATION_TOP_RIGHT;
	}
	_tmp137_ = _tmp131_;
	if (_tmp137_) {
		gint _tmp138_ = 0;
		gint _tmp139_ = 0;
		gint _tmp140_ = 0;
		gint _tmp141_ = 0;
		_tmp138_ = new_y;
		_tmp139_ = dy;
		new_y = _tmp138_ + _tmp139_;
		_tmp140_ = new_h;
		_tmp141_ = dy;
		new_h = _tmp140_ - _tmp141_;
	}
	_tmp144_ = self->priv->crop_location;
	if (_tmp144_ == CROP_LOCATION_TOP_RIGHT) {
		_tmp143_ = TRUE;
	} else {
		CropLocation _tmp145_ = 0;
		_tmp145_ = self->priv->crop_location;
		_tmp143_ = _tmp145_ == CROP_LOCATION_RIGHT;
	}
	_tmp146_ = _tmp143_;
	if (_tmp146_) {
		_tmp142_ = TRUE;
	} else {
		CropLocation _tmp147_ = 0;
		_tmp147_ = self->priv->crop_location;
		_tmp142_ = _tmp147_ == CROP_LOCATION_BOTTOM_RIGHT;
	}
	_tmp148_ = _tmp142_;
	if (_tmp148_) {
		gint _tmp149_ = 0;
		gint _tmp150_ = 0;
		_tmp149_ = new_w;
		_tmp150_ = dx;
		new_w = _tmp149_ + _tmp150_;
	}
	_tmp153_ = self->priv->crop_location;
	if (_tmp153_ == CROP_LOCATION_BOTTOM_LEFT) {
		_tmp152_ = TRUE;
	} else {
		CropLocation _tmp154_ = 0;
		_tmp154_ = self->priv->crop_location;
		_tmp152_ = _tmp154_ == CROP_LOCATION_BOTTOM;
	}
	_tmp155_ = _tmp152_;
	if (_tmp155_) {
		_tmp151_ = TRUE;
	} else {
		CropLocation _tmp156_ = 0;
		_tmp156_ = self->priv->crop_location;
		_tmp151_ = _tmp156_ == CROP_LOCATION_BOTTOM_RIGHT;
	}
	_tmp157_ = _tmp151_;
	if (_tmp157_) {
		gint _tmp158_ = 0;
		gint _tmp159_ = 0;
		_tmp158_ = new_h;
		_tmp159_ = dy;
		new_h = _tmp158_ + _tmp159_;
	}
	_tmp160_ = self->priv->page;
	_tmp161_ = new_x;
	_tmp162_ = new_y;
	page_move_crop (_tmp160_, _tmp161_, _tmp162_);
	_tmp164_ = new_w;
	_tmp165_ = cw;
	if (_tmp164_ != _tmp165_) {
		_tmp163_ = TRUE;
	} else {
		gint _tmp166_ = 0;
		gint _tmp167_ = 0;
		_tmp166_ = new_h;
		_tmp167_ = ch;
		_tmp163_ = _tmp166_ != _tmp167_;
	}
	_tmp168_ = _tmp163_;
	if (_tmp168_) {
		Page* _tmp169_ = NULL;
		gint _tmp170_ = 0;
		gint _tmp171_ = 0;
		_tmp169_ = self->priv->page;
		_tmp170_ = new_w;
		_tmp171_ = new_h;
		page_set_custom_crop (_tmp169_, _tmp170_, _tmp171_);
	}
}


void page_view_button_release (PageView* self, gint x, gint y) {
	g_return_if_fail (self != NULL);
	self->priv->crop_location = CROP_LOCATION_NONE;
	g_signal_emit_by_name (self, "changed");
}


GdkCursorType page_view_get_cursor (PageView* self) {
	GdkCursorType result = 0;
	GdkCursorType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->cursor;
	result = _tmp0_;
	return result;
}


static gboolean page_view_animation_cb (PageView* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->animate_segment;
	_tmp1_ = self->priv->animate_n_segments;
	self->priv->animate_segment = (_tmp0_ + 1) % _tmp1_;
	g_signal_emit_by_name (self, "changed");
	result = TRUE;
	return result;
}


static gboolean _page_view_animation_cb_gsource_func (gpointer self) {
	gboolean result;
	result = page_view_animation_cb (self);
	return result;
}


static void page_view_update_animation (PageView* self) {
	gboolean animate = FALSE;
	gboolean is_animating = FALSE;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	guint _tmp6_ = 0U;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->page;
	_tmp2_ = page_is_scanning (_tmp1_);
	if (_tmp2_) {
		Page* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->page;
		_tmp4_ = page_has_data (_tmp3_);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	animate = _tmp5_;
	_tmp6_ = self->priv->animate_timeout;
	is_animating = _tmp6_ != ((guint) 0);
	_tmp7_ = animate;
	_tmp8_ = is_animating;
	if (_tmp7_ == _tmp8_) {
		return;
	}
	_tmp9_ = animate;
	if (_tmp9_) {
		guint _tmp10_ = 0U;
		self->priv->animate_segment = 0;
		_tmp10_ = self->priv->animate_timeout;
		if (_tmp10_ == ((guint) 0)) {
			guint _tmp11_ = 0U;
			_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _page_view_animation_cb_gsource_func, page_view_ref (self), page_view_unref);
			self->priv->animate_timeout = _tmp11_;
		}
	} else {
		guint _tmp12_ = 0U;
		_tmp12_ = self->priv->animate_timeout;
		if (_tmp12_ != ((guint) 0)) {
			guint _tmp13_ = 0U;
			_tmp13_ = self->priv->animate_timeout;
			g_source_remove (_tmp13_);
		}
		self->priv->animate_timeout = (guint) 0;
	}
}


void page_view_render (PageView* self, cairo_t* context) {
	gint w = 0;
	gint _tmp0_ = 0;
	gint h = 0;
	gint _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	cairo_t* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	cairo_t* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	Page* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp70_ = FALSE;
	Page* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp75_ = FALSE;
	Page* _tmp115_ = NULL;
	gboolean _tmp116_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	page_view_update_animation (self);
	page_view_update_page_view (self);
	_tmp0_ = page_view_get_preview_width (self);
	w = _tmp0_;
	_tmp1_ = page_view_get_preview_height (self);
	h = _tmp1_;
	_tmp2_ = context;
	cairo_set_line_width (_tmp2_, (gdouble) 1);
	_tmp3_ = context;
	_tmp4_ = self->priv->x_offset;
	_tmp5_ = self->priv->y_offset;
	cairo_translate (_tmp3_, (gdouble) _tmp4_, (gdouble) _tmp5_);
	_tmp6_ = context;
	cairo_set_source_rgb (_tmp6_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp7_ = context;
	_tmp8_ = self->priv->border_width;
	cairo_set_line_width (_tmp7_, (gdouble) _tmp8_);
	_tmp9_ = context;
	_tmp10_ = self->priv->border_width;
	_tmp11_ = self->priv->border_width;
	_tmp12_ = self->priv->width;
	_tmp13_ = self->priv->border_width;
	_tmp14_ = self->priv->height;
	_tmp15_ = self->priv->border_width;
	cairo_rectangle (_tmp9_, ((gdouble) _tmp10_) / 2, ((gdouble) _tmp11_) / 2, (gdouble) (_tmp12_ - _tmp13_), (gdouble) (_tmp14_ - _tmp15_));
	_tmp16_ = context;
	cairo_stroke (_tmp16_);
	_tmp17_ = context;
	_tmp18_ = self->priv->border_width;
	_tmp19_ = self->priv->border_width;
	cairo_translate (_tmp17_, (gdouble) _tmp18_, (gdouble) _tmp19_);
	_tmp20_ = context;
	_tmp21_ = self->priv->image;
	gdk_cairo_set_source_pixbuf (_tmp20_, _tmp21_, (gdouble) 0, (gdouble) 0);
	_tmp22_ = context;
	cairo_paint (_tmp22_);
	_tmp24_ = self->priv->page;
	_tmp25_ = page_is_scanning (_tmp24_);
	if (_tmp25_) {
		Page* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		_tmp26_ = self->priv->page;
		_tmp27_ = page_has_data (_tmp26_);
		_tmp23_ = !_tmp27_;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp28_ = _tmp23_;
	if (_tmp28_) {
		gdouble outer_radius = 0.0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gdouble arc = 0.0;
		gint _tmp33_ = 0;
		gdouble x = 0.0;
		gdouble _tmp34_ = 0.0;
		gdouble _tmp35_ = 0.0;
		gdouble _tmp36_ = 0.0;
		gdouble y = 0.0;
		gdouble _tmp37_ = 0.0;
		gdouble _tmp38_ = 0.0;
		gdouble _tmp39_ = 0.0;
		gdouble inner_radius = 0.0;
		gdouble _tmp40_ = 0.0;
		gdouble _tmp41_ = 0.0;
		gdouble _tmp42_ = 0.0;
		gdouble _tmp43_ = 0.0;
		gdouble _tmp44_ = 0.0;
		gdouble offset = 0.0;
		_tmp29_ = w;
		_tmp30_ = h;
		if (_tmp29_ > _tmp30_) {
			gint _tmp31_ = 0;
			_tmp31_ = w;
			outer_radius = 0.15 * _tmp31_;
		} else {
			gint _tmp32_ = 0;
			_tmp32_ = h;
			outer_radius = 0.15 * _tmp32_;
		}
		_tmp33_ = self->priv->animate_n_segments;
		arc = G_PI / _tmp33_;
		_tmp34_ = outer_radius;
		_tmp35_ = arc;
		_tmp36_ = sin (_tmp35_);
		x = _tmp34_ * _tmp36_;
		_tmp37_ = outer_radius;
		_tmp38_ = arc;
		_tmp39_ = cos (_tmp38_);
		y = _tmp37_ * (_tmp39_ - 1.0);
		_tmp40_ = x;
		_tmp41_ = x;
		_tmp42_ = y;
		_tmp43_ = y;
		_tmp44_ = sqrt ((_tmp40_ * _tmp41_) + (_tmp42_ * _tmp43_));
		inner_radius = 0.6 * _tmp44_;
		offset = 0.0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp45_ = FALSE;
				_tmp45_ = TRUE;
				while (TRUE) {
					gboolean _tmp46_ = FALSE;
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gdouble _tmp53_ = 0.0;
					gdouble _tmp54_ = 0.0;
					gdouble _tmp55_ = 0.0;
					gint _tmp56_ = 0;
					gdouble _tmp57_ = 0.0;
					gdouble _tmp58_ = 0.0;
					gdouble _tmp59_ = 0.0;
					cairo_t* _tmp60_ = NULL;
					gdouble _tmp61_ = 0.0;
					gdouble _tmp62_ = 0.0;
					gdouble _tmp63_ = 0.0;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					cairo_t* _tmp68_ = NULL;
					cairo_t* _tmp69_ = NULL;
					_tmp46_ = _tmp45_;
					if (!_tmp46_) {
						gint _tmp47_ = 0;
						gdouble _tmp48_ = 0.0;
						gdouble _tmp49_ = 0.0;
						_tmp47_ = i;
						i = _tmp47_ + 1;
						_tmp48_ = offset;
						_tmp49_ = arc;
						offset = _tmp48_ + (_tmp49_ * 2);
					}
					_tmp45_ = FALSE;
					_tmp50_ = i;
					_tmp51_ = self->priv->animate_n_segments;
					if (!(_tmp50_ < _tmp51_)) {
						break;
					}
					_tmp52_ = w;
					_tmp53_ = outer_radius;
					_tmp54_ = offset;
					_tmp55_ = sin (_tmp54_);
					x = (_tmp52_ / 2) + (_tmp53_ * _tmp55_);
					_tmp56_ = h;
					_tmp57_ = outer_radius;
					_tmp58_ = offset;
					_tmp59_ = cos (_tmp58_);
					y = (_tmp56_ / 2) - (_tmp57_ * _tmp59_);
					_tmp60_ = context;
					_tmp61_ = x;
					_tmp62_ = y;
					_tmp63_ = inner_radius;
					cairo_arc (_tmp60_, _tmp61_, _tmp62_, _tmp63_, (gdouble) 0, 2 * G_PI);
					_tmp64_ = i;
					_tmp65_ = self->priv->animate_segment;
					if (_tmp64_ == _tmp65_) {
						cairo_t* _tmp66_ = NULL;
						cairo_t* _tmp67_ = NULL;
						_tmp66_ = context;
						cairo_set_source_rgb (_tmp66_, 0.75, 0.75, 0.75);
						_tmp67_ = context;
						cairo_fill_preserve (_tmp67_);
					}
					_tmp68_ = context;
					cairo_set_source_rgb (_tmp68_, 0.5, 0.5, 0.5);
					_tmp69_ = context;
					cairo_stroke (_tmp69_);
				}
			}
		}
	}
	_tmp71_ = self->priv->page;
	_tmp72_ = page_is_scanning (_tmp71_);
	if (_tmp72_) {
		Page* _tmp73_ = NULL;
		gint _tmp74_ = 0;
		_tmp73_ = self->priv->page;
		_tmp74_ = page_get_scan_line (_tmp73_);
		_tmp70_ = _tmp74_ > 0;
	} else {
		_tmp70_ = FALSE;
	}
	_tmp75_ = _tmp70_;
	if (_tmp75_) {
		gint scan_line = 0;
		Page* _tmp76_ = NULL;
		gint _tmp77_ = 0;
		gdouble s = 0.0;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		Page* _tmp78_ = NULL;
		ScanDirection _tmp79_ = 0;
		cairo_t* _tmp107_ = NULL;
		gdouble _tmp108_ = 0.0;
		gdouble _tmp109_ = 0.0;
		cairo_t* _tmp110_ = NULL;
		gdouble _tmp111_ = 0.0;
		gdouble _tmp112_ = 0.0;
		cairo_t* _tmp113_ = NULL;
		cairo_t* _tmp114_ = NULL;
		_tmp76_ = self->priv->page;
		_tmp77_ = page_get_scan_line (_tmp76_);
		scan_line = _tmp77_;
		_tmp78_ = self->priv->page;
		_tmp79_ = page_get_scan_direction (_tmp78_);
		switch (_tmp79_) {
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
			{
				gint _tmp80_ = 0;
				gint _tmp81_ = 0;
				gdouble _tmp82_ = 0.0;
				gint _tmp83_ = 0;
				gdouble _tmp84_ = 0.0;
				_tmp80_ = scan_line;
				_tmp81_ = page_view_page_to_screen_y (self, _tmp80_);
				s = (gdouble) _tmp81_;
				x1 = (gdouble) 0;
				_tmp82_ = s;
				y1 = _tmp82_ + 0.5;
				_tmp83_ = w;
				x2 = (gdouble) _tmp83_;
				_tmp84_ = s;
				y2 = _tmp84_ + 0.5;
				break;
			}
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
			{
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gint _tmp87_ = 0;
				gdouble _tmp88_ = 0.0;
				gint _tmp89_ = 0;
				gint _tmp90_ = 0;
				gdouble _tmp91_ = 0.0;
				_tmp85_ = scan_line;
				_tmp86_ = page_view_page_to_screen_y (self, _tmp85_);
				s = (gdouble) _tmp86_;
				x1 = (gdouble) 0;
				_tmp87_ = h;
				_tmp88_ = s;
				y1 = (_tmp87_ - _tmp88_) + 0.5;
				_tmp89_ = w;
				x2 = (gdouble) _tmp89_;
				_tmp90_ = h;
				_tmp91_ = s;
				y2 = (_tmp90_ - _tmp91_) + 0.5;
				break;
			}
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
			{
				gint _tmp92_ = 0;
				gint _tmp93_ = 0;
				gdouble _tmp94_ = 0.0;
				gdouble _tmp95_ = 0.0;
				gint _tmp96_ = 0;
				_tmp92_ = scan_line;
				_tmp93_ = page_view_page_to_screen_x (self, _tmp92_);
				s = (gdouble) _tmp93_;
				_tmp94_ = s;
				x1 = _tmp94_ + 0.5;
				y1 = (gdouble) 0;
				_tmp95_ = s;
				x2 = _tmp95_ + 0.5;
				_tmp96_ = h;
				y2 = (gdouble) _tmp96_;
				break;
			}
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
			{
				gint _tmp97_ = 0;
				gint _tmp98_ = 0;
				gint _tmp99_ = 0;
				gdouble _tmp100_ = 0.0;
				gint _tmp101_ = 0;
				gdouble _tmp102_ = 0.0;
				gint _tmp103_ = 0;
				_tmp97_ = scan_line;
				_tmp98_ = page_view_page_to_screen_x (self, _tmp97_);
				s = (gdouble) _tmp98_;
				_tmp99_ = w;
				_tmp100_ = s;
				x1 = (_tmp99_ - _tmp100_) + 0.5;
				y1 = (gdouble) 0;
				_tmp101_ = w;
				_tmp102_ = s;
				x2 = (_tmp101_ - _tmp102_) + 0.5;
				_tmp103_ = h;
				y2 = (gdouble) _tmp103_;
				break;
			}
			default:
			{
				gdouble _tmp104_ = 0.0;
				gdouble _tmp105_ = 0.0;
				gdouble _tmp106_ = 0.0;
				y2 = (gdouble) 0;
				_tmp104_ = y2;
				x2 = _tmp104_;
				_tmp105_ = x2;
				y1 = _tmp105_;
				_tmp106_ = y1;
				x1 = _tmp106_;
				break;
			}
		}
		_tmp107_ = context;
		_tmp108_ = x1;
		_tmp109_ = y1;
		cairo_move_to (_tmp107_, _tmp108_, _tmp109_);
		_tmp110_ = context;
		_tmp111_ = x2;
		_tmp112_ = y2;
		cairo_line_to (_tmp110_, _tmp111_, _tmp112_);
		_tmp113_ = context;
		cairo_set_source_rgb (_tmp113_, 1.0, 0.0, 0.0);
		_tmp114_ = context;
		cairo_stroke (_tmp114_);
	}
	_tmp115_ = self->priv->page;
	_tmp116_ = page_has_crop (_tmp115_);
	if (_tmp116_) {
		gint x = 0;
		gint y = 0;
		gint crop_width = 0;
		gint crop_height = 0;
		Page* _tmp117_ = NULL;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint dx = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint dy = 0;
		gint _tmp124_ = 0;
		gint _tmp125_ = 0;
		gint dw = 0;
		gint _tmp126_ = 0;
		gint _tmp127_ = 0;
		gint dh = 0;
		gint _tmp128_ = 0;
		gint _tmp129_ = 0;
		cairo_t* _tmp130_ = NULL;
		gint _tmp131_ = 0;
		gint _tmp132_ = 0;
		cairo_t* _tmp133_ = NULL;
		cairo_t* _tmp134_ = NULL;
		gint _tmp135_ = 0;
		gint _tmp136_ = 0;
		gint _tmp137_ = 0;
		gint _tmp138_ = 0;
		cairo_t* _tmp139_ = NULL;
		cairo_t* _tmp140_ = NULL;
		cairo_t* _tmp141_ = NULL;
		cairo_t* _tmp142_ = NULL;
		gint _tmp143_ = 0;
		gint _tmp144_ = 0;
		gint _tmp145_ = 0;
		gint _tmp146_ = 0;
		cairo_t* _tmp147_ = NULL;
		cairo_t* _tmp148_ = NULL;
		cairo_t* _tmp149_ = NULL;
		gint _tmp150_ = 0;
		gint _tmp151_ = 0;
		gint _tmp152_ = 0;
		gint _tmp153_ = 0;
		cairo_t* _tmp154_ = NULL;
		cairo_t* _tmp155_ = NULL;
		_tmp117_ = self->priv->page;
		page_get_crop (_tmp117_, &_tmp118_, &_tmp119_, &_tmp120_, &_tmp121_);
		x = _tmp118_;
		y = _tmp119_;
		crop_width = _tmp120_;
		crop_height = _tmp121_;
		_tmp122_ = x;
		_tmp123_ = page_view_page_to_screen_x (self, _tmp122_);
		dx = _tmp123_;
		_tmp124_ = y;
		_tmp125_ = page_view_page_to_screen_y (self, _tmp124_);
		dy = _tmp125_;
		_tmp126_ = crop_width;
		_tmp127_ = page_view_page_to_screen_x (self, _tmp126_);
		dw = _tmp127_;
		_tmp128_ = crop_height;
		_tmp129_ = page_view_page_to_screen_y (self, _tmp128_);
		dh = _tmp129_;
		_tmp130_ = context;
		_tmp131_ = w;
		_tmp132_ = h;
		cairo_rectangle (_tmp130_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp131_, (gdouble) _tmp132_);
		_tmp133_ = context;
		cairo_new_sub_path (_tmp133_);
		_tmp134_ = context;
		_tmp135_ = dx;
		_tmp136_ = dy;
		_tmp137_ = dw;
		_tmp138_ = dh;
		cairo_rectangle (_tmp134_, (gdouble) _tmp135_, (gdouble) _tmp136_, (gdouble) _tmp137_, (gdouble) _tmp138_);
		_tmp139_ = context;
		cairo_set_fill_rule (_tmp139_, CAIRO_FILL_RULE_EVEN_ODD);
		_tmp140_ = context;
		cairo_set_source_rgba (_tmp140_, 0.25, 0.25, 0.25, 0.2);
		_tmp141_ = context;
		cairo_fill (_tmp141_);
		_tmp142_ = context;
		_tmp143_ = dx;
		_tmp144_ = dy;
		_tmp145_ = dw;
		_tmp146_ = dh;
		cairo_rectangle (_tmp142_, _tmp143_ - 1.5, _tmp144_ - 1.5, (gdouble) (_tmp145_ + 3), (gdouble) (_tmp146_ + 3));
		_tmp147_ = context;
		cairo_set_source_rgb (_tmp147_, 1.0, 1.0, 1.0);
		_tmp148_ = context;
		cairo_stroke (_tmp148_);
		_tmp149_ = context;
		_tmp150_ = dx;
		_tmp151_ = dy;
		_tmp152_ = dw;
		_tmp153_ = dh;
		cairo_rectangle (_tmp149_, _tmp150_ - 0.5, _tmp151_ - 0.5, (gdouble) (_tmp152_ + 1), (gdouble) (_tmp153_ + 1));
		_tmp154_ = context;
		cairo_set_source_rgb (_tmp154_, 0.0, 0.0, 0.0);
		_tmp155_ = context;
		cairo_stroke (_tmp155_);
	}
}


void page_view_set_width (PageView* self, gint width) {
	gint height = 0;
	gint _tmp0_ = 0;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Page* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = width;
	_tmp1_ = self->priv->page;
	_tmp2_ = page_get_height (_tmp1_);
	_tmp3_ = self->priv->page;
	_tmp4_ = page_get_width (_tmp3_);
	height = (gint) ((((gdouble) _tmp0_) * _tmp2_) / _tmp4_);
	_tmp6_ = self->priv->width;
	_tmp7_ = width;
	if (_tmp6_ == _tmp7_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = self->priv->height;
		_tmp9_ = height;
		_tmp5_ = _tmp8_ == _tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp10_ = _tmp5_;
	if (_tmp10_) {
		return;
	}
	_tmp11_ = width;
	self->priv->width = _tmp11_;
	_tmp12_ = height;
	self->priv->height = _tmp12_;
	self->priv->update_image = TRUE;
	g_signal_emit_by_name (self, "size-changed");
	g_signal_emit_by_name (self, "changed");
}


void page_view_set_height (PageView* self, gint height) {
	gint width = 0;
	gint _tmp0_ = 0;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Page* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = height;
	_tmp1_ = self->priv->page;
	_tmp2_ = page_get_width (_tmp1_);
	_tmp3_ = self->priv->page;
	_tmp4_ = page_get_height (_tmp3_);
	width = (gint) ((((gdouble) _tmp0_) * _tmp2_) / _tmp4_);
	_tmp6_ = self->priv->width;
	_tmp7_ = width;
	if (_tmp6_ == _tmp7_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = self->priv->height;
		_tmp9_ = height;
		_tmp5_ = _tmp8_ == _tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp10_ = _tmp5_;
	if (_tmp10_) {
		return;
	}
	_tmp11_ = width;
	self->priv->width = _tmp11_;
	_tmp12_ = height;
	self->priv->height = _tmp12_;
	self->priv->update_image = TRUE;
	g_signal_emit_by_name (self, "size-changed");
	g_signal_emit_by_name (self, "changed");
}


gint page_view_get_width (PageView* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->width;
	result = _tmp0_;
	return result;
}


gint page_view_get_height (PageView* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->height;
	result = _tmp0_;
	return result;
}


static void page_view_page_pixels_changed_cb (PageView* self, Page* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	g_signal_emit_by_name (self, "changed");
}


static void page_view_page_size_changed_cb (PageView* self, Page* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	g_signal_emit_by_name (self, "size-changed");
	g_signal_emit_by_name (self, "changed");
}


static void page_view_page_overlay_changed_cb (PageView* self, Page* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_signal_emit_by_name (self, "changed");
}


static void page_view_scan_direction_changed_cb (PageView* self, Page* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	g_signal_emit_by_name (self, "size-changed");
	g_signal_emit_by_name (self, "changed");
}


static void value_page_view_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_page_view_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		page_view_unref (value->data[0].v_pointer);
	}
}


static void value_page_view_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = page_view_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_page_view_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_page_view_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PageView* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = page_view_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_page_view_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PageView** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = page_view_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPageView* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE_VIEW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_page_view (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW), NULL);
	return value->data[0].v_pointer;
}


void value_set_page_view (GValue* value, gpointer v_object) {
	PageView* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		page_view_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		page_view_unref (old);
	}
}


void value_take_page_view (GValue* value, gpointer v_object) {
	PageView* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		page_view_unref (old);
	}
}


static void page_view_class_init (PageViewClass * klass) {
	page_view_parent_class = g_type_class_peek_parent (klass);
	PAGE_VIEW_CLASS (klass)->finalize = page_view_finalize;
	g_type_class_add_private (klass, sizeof (PageViewPrivate));
	g_signal_new ("size_changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void page_view_instance_init (PageView * self) {
	self->priv = PAGE_VIEW_GET_PRIVATE (self);
	self->priv->image = NULL;
	self->priv->border_width = 1;
	self->priv->update_image = TRUE;
	self->priv->cursor = GDK_ARROW;
	self->priv->animate_n_segments = 7;
	self->ref_count = 1;
}


static void page_view_finalize (PageView* obj) {
	PageView * self;
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	Page* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	Page* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_VIEW, PageView);
	_tmp0_ = self->priv->page;
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
	_tmp2_ = self->priv->page;
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
	_tmp4_ = self->priv->page;
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
	_tmp6_ = self->priv->page;
	g_signal_parse_name ("scan-line-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
	_tmp8_ = self->priv->page;
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
	_page_unref0 (self->priv->page);
	_g_object_unref0 (self->priv->image);
}


GType page_view_get_type (void) {
	static volatile gsize page_view_type_id__volatile = 0;
	if (g_once_init_enter (&page_view_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_view_init, value_page_view_free_value, value_page_view_copy_value, value_page_view_peek_pointer, "p", value_page_view_collect_value, "p", value_page_view_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageView), 0, (GInstanceInitFunc) page_view_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_view_type_id;
		page_view_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PageView", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_view_type_id__volatile, page_view_type_id);
	}
	return page_view_type_id__volatile;
}


gpointer page_view_ref (gpointer instance) {
	PageView* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void page_view_unref (gpointer instance) {
	PageView* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PAGE_VIEW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



