/* ui.c generated by valac 0.24.0, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ParamSpecSimpleScan ParamSpecSimpleScan;

struct _SimpleScan {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	GTypeClass parent_class;
	void (*finalize) (SimpleScan *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _SimpleScanPrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkWindow* window;
	GtkVBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkRadioMenuItem* text_toolbar_menuitem;
	GtkRadioMenuItem* text_menu_menuitem;
	GtkRadioMenuItem* photo_toolbar_menuitem;
	GtkRadioMenuItem* photo_menu_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* book;
	gchar* book_uri;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* default_file_name;
	gboolean scanning;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecSimpleScan {
	GParamSpec parent_instance;
};


static gpointer simple_scan_parent_class = NULL;

gpointer simple_scan_ref (gpointer instance);
void simple_scan_unref (gpointer instance);
GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_simple_scan (GValue* value, gpointer v_object);
void value_take_simple_scan (GValue* value, gpointer v_object);
gpointer value_get_simple_scan (const GValue* value);
GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define SIMPLE_SCAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_SCAN, SimpleScanPrivate))
enum  {
	SIMPLE_SCAN_DUMMY_PROPERTY
};
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void simple_scan_page_removed_cb (SimpleScan* self, Book* book, Page* page);
static void _simple_scan_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void simple_scan_page_added_cb (SimpleScan* self, Book* book, Page* page);
static void _simple_scan_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
#define SIMPLE_SCAN_DEFAULT_TEXT_DPI 150
#define SIMPLE_SCAN_DEFAULT_PHOTO_DPI 300
SimpleScan* simple_scan_new (void);
SimpleScan* simple_scan_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
static void simple_scan_load (SimpleScan* self);
static gboolean simple_scan_find_scan_device (SimpleScan* self, const gchar* device, GtkTreeIter* iter);
static void simple_scan_show_error_dialog (SimpleScan* self, const gchar* error_title, const gchar* error_text);
void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name);
void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password);
void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_update_info_bar (SimpleScan* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void simple_scan_set_scan_devices (SimpleScan* self, GList* devices);
static gchar* simple_scan_get_selected_device (SimpleScan* self);
void simple_scan_set_selected_device (SimpleScan* self, const gchar* device);
static void simple_scan_add_default_page (SimpleScan* self);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_view_select_page (BookView* self, Page* page);
static void simple_scan_on_file_type_changed (SimpleScan* self, GtkTreeSelection* selection);
static gchar* simple_scan_choose_file_location (SimpleScan* self);
static void _simple_scan_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean simple_scan_save_document (SimpleScan* self, gboolean force_choose_location);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void book_set_needs_saving (Book* self, gboolean needs_saving);
static gboolean simple_scan_prompt_to_save (SimpleScan* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void simple_scan_clear_document (SimpleScan* self);
void book_clear (Book* self);
void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_set_document_hint (SimpleScan* self, const gchar* document_hint);
void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void simple_scan_set_page_side (SimpleScan* self, ScanType page_side);
static void simple_scan_set_paper_size (SimpleScan* self, gint width, gint height);
static gint simple_scan_get_text_dpi (SimpleScan* self);
static gint simple_scan_get_photo_dpi (SimpleScan* self);
static ScanType simple_scan_get_page_side (SimpleScan* self);
static gboolean simple_scan_get_paper_size (SimpleScan* self, gint* width, gint* height);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* simple_scan_get_scan_options (SimpleScan* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, SimpleScan* self);
static void simple_scan_update_page_menu (SimpleScan* self);
Page* book_view_get_selected (BookView* self);
guint book_get_page_index (Book* self, Page* page);
guint book_get_n_pages (Book* self);
static void simple_scan_page_selected_cb (SimpleScan* self, BookView* view, Page* page);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension);
static void simple_scan_show_page_cb (SimpleScan* self, BookView* view, Page* page);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void simple_scan_show_page_menu_cb (SimpleScan* self, BookView* view);
void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_left (Page* self);
void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_right (Page* self);
static void simple_scan_set_crop (SimpleScan* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, SimpleScan* self);
void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_crop (Page* self);
void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void book_move_page (Book* self, Page* page, guint location);
void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_draw_page (SimpleScan* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
Page* book_get_page (Book* self, gint page_number);
gboolean page_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void _simple_scan_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
static gboolean simple_scan_on_quit (SimpleScan* self);
void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, SimpleScan* self);
static void simple_scan_info_bar_response_cb (SimpleScan* self, GtkInfoBar* widget, gint response_id);
gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, SimpleScan* self);
gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, SimpleScan* self);
static void simple_scan_page_size_changed_cb (SimpleScan* self, Page* page);
static void simple_scan_page_scan_direction_changed_cb (SimpleScan* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _simple_scan_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void simple_scan_set_dpi_combo (SimpleScan* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static void simple_scan_needs_saving_cb (SimpleScan* self, Book* book);
static void _simple_scan_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _simple_scan_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _simple_scan_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _simple_scan_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
static void _simple_scan_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
Book* simple_scan_get_book (SimpleScan* self);
void simple_scan_set_selected_page (SimpleScan* self, Page* page);
Page* simple_scan_get_selected_page (SimpleScan* self);
void simple_scan_set_scanning (SimpleScan* self, gboolean scanning);
void simple_scan_start (SimpleScan* self);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void simple_scan_finalize (SimpleScan* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _simple_scan_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 106 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_page_removed_cb ((SimpleScan*) self, _sender, page);
#line 423 "ui.c"
}


static void _simple_scan_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 107 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_page_added_cb ((SimpleScan*) self, _sender, page);
#line 430 "ui.c"
}


SimpleScan* simple_scan_construct (GType object_type) {
	SimpleScan* self = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
#line 93 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self = (SimpleScan*) g_type_create_instance (object_type);
#line 95 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = book_new ();
#line 95 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_book_unref0 (self->priv->book);
#line 95 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->book = _tmp0_;
#line 96 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 96 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp1_, "page-removed", (GCallback) _simple_scan_page_removed_cb_book_page_removed, self);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp2_, "page-added", (GCallback) _simple_scan_page_added_cb_book_page_added, self);
#line 99 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = g_settings_new ("org.gnome.SimpleScan");
#line 99 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 99 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->settings = _tmp3_;
#line 101 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_load (self);
#line 93 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return self;
#line 466 "ui.c"
}


SimpleScan* simple_scan_new (void) {
#line 93 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return simple_scan_construct (TYPE_SIMPLE_SCAN);
#line 473 "ui.c"
}


static gboolean simple_scan_find_scan_device (SimpleScan* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean have_iter = FALSE;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 110 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (device != NULL, FALSE);
#line 112 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	have_iter = FALSE;
#line 114 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->device_model;
#line 114 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 114 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_vala_iter = _tmp1_;
#line 114 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 498 "ui.c"
		{
			gboolean _tmp3_ = FALSE;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp3_ = TRUE;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			while (TRUE) {
#line 505 "ui.c"
				gchar* d = NULL;
				GtkListStore* _tmp8_ = NULL;
				GtkTreeIter _tmp9_ = {0};
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (!_tmp3_) {
#line 513 "ui.c"
					gboolean _tmp4_ = FALSE;
					gboolean _tmp5_ = FALSE;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp5_ = have_iter;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					if (!_tmp5_) {
#line 520 "ui.c"
						GtkListStore* _tmp6_ = NULL;
						gboolean _tmp7_ = FALSE;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp6_ = self->priv->device_model;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp7_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp6_, &_vala_iter);
#line 122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp4_ = _tmp7_;
#line 529 "ui.c"
					} else {
#line 122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp4_ = FALSE;
#line 533 "ui.c"
					}
#line 122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					if (!_tmp4_) {
#line 122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						break;
#line 539 "ui.c"
					}
				}
#line 116 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp3_ = FALSE;
#line 119 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp8_ = self->priv->device_model;
#line 119 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp9_ = _vala_iter;
#line 119 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 0, &d, -1, -1);
#line 120 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp10_ = d;
#line 120 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp11_ = device;
#line 120 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
#line 121 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					have_iter = TRUE;
#line 558 "ui.c"
				}
#line 116 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_g_free0 (d);
#line 562 "ui.c"
			}
		}
	}
#line 125 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = have_iter;
#line 125 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (iter) {
#line 125 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		*iter = _vala_iter;
#line 572 "ui.c"
	}
#line 125 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 576 "ui.c"
}


static void simple_scan_show_error_dialog (SimpleScan* self, const gchar* error_title, const gchar* error_text) {
	GtkMessageDialog* dialog = NULL;
	GtkWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 128 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 130 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 130 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = error_title;
#line 130 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp1_);
#line 130 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 130 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	dialog = _tmp2_;
#line 135 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_CLOSE, 0);
#line 136 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = error_text;
#line 136 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp3_);
#line 137 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 128 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (dialog);
#line 612 "ui.c"
}


void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 140 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (default_file_name != NULL);
#line 142 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = default_file_name;
#line 142 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 142 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->default_file_name);
#line 142 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_file_name = _tmp1_;
#line 631 "ui.c"
}


void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gchar* description = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkEntry* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (resource != NULL);
#line 148 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = _ ("Username and password required to access '%s'");
#line 148 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = resource;
#line 148 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
#line 148 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	description = _tmp2_;
#line 150 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->username_entry;
#line 150 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_entry_set_text (_tmp3_, "");
#line 151 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = self->priv->password_entry;
#line 151 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_entry_set_text (_tmp4_, "");
#line 152 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = self->priv->authorize_label;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_label_set_text (_tmp5_, description);
#line 154 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = self->priv->authorize_dialog;
#line 154 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 155 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = self->priv->authorize_dialog;
#line 155 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_dialog_run (_tmp7_);
#line 156 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = self->priv->authorize_dialog;
#line 156 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 158 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = self->priv->username_entry;
#line 158 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = gtk_entry_get_text (_tmp9_);
#line 158 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 158 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (_vala_username);
#line 158 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_vala_username = _tmp11_;
#line 159 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp12_ = self->priv->password_entry;
#line 159 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp13_ = gtk_entry_get_text (_tmp12_);
#line 159 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 159 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (_vala_password);
#line 159 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_vala_password = _tmp14_;
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (description);
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (username) {
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		*username = _vala_username;
#line 716 "ui.c"
	} else {
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (_vala_username);
#line 720 "ui.c"
	}
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (password) {
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		*password = _vala_password;
#line 726 "ui.c"
	} else {
#line 145 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (_vala_password);
#line 730 "ui.c"
	}
}


void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean _tmp0_ = FALSE;
#line 163 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 165 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->setting_devices;
#line 165 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_) {
#line 166 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 747 "ui.c"
	}
#line 167 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 751 "ui.c"
}


static void simple_scan_update_info_bar (SimpleScan* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button = FALSE;
	gboolean show_change_scanner_button = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkInfoBar* _tmp15_ = NULL;
	GtkMessageType _tmp16_ = 0;
	GtkImage* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* message = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GtkButton* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	GtkInfoBar* _tmp28_ = NULL;
#line 170 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	show_close_button = FALSE;
#line 175 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	show_change_scanner_button = FALSE;
#line 177 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->have_error;
#line 177 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_) {
#line 788 "ui.c"
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 179 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		type = GTK_MESSAGE_ERROR;
#line 180 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp1_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
#line 180 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (image_id);
#line 180 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		image_id = _tmp1_;
#line 181 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = self->priv->error_title;
#line 181 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 181 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (title);
#line 181 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		title = _tmp3_;
#line 182 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = self->priv->error_text;
#line 182 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 182 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (text);
#line 182 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		text = _tmp5_;
#line 183 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		show_close_button = TRUE;
#line 184 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = self->priv->error_change_scanner_hint;
#line 184 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		show_change_scanner_button = _tmp6_;
#line 825 "ui.c"
	} else {
		GtkListStore* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = self->priv->device_model;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL);
#line 186 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_tmp8_ == 0) {
#line 835 "ui.c"
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 188 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			type = GTK_MESSAGE_WARNING;
#line 189 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp9_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
#line 189 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_free0 (image_id);
#line 189 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			image_id = _tmp9_;
#line 191 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp10_ = _ ("No scanners detected");
#line 191 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 191 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_free0 (title);
#line 191 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			title = _tmp11_;
#line 193 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp12_ = _ ("Please check your scanner is connected and powered on");
#line 193 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 193 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_free0 (text);
#line 193 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			text = _tmp13_;
#line 865 "ui.c"
		} else {
			GtkInfoBar* _tmp14_ = NULL;
#line 197 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp14_ = self->priv->info_bar;
#line 197 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			gtk_widget_hide ((GtkWidget*) _tmp14_);
#line 198 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_free0 (image_id);
#line 198 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_free0 (text);
#line 198 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_free0 (title);
#line 198 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			return;
#line 880 "ui.c"
		}
	}
#line 201 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp15_ = self->priv->info_bar;
#line 201 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp16_ = type;
#line 201 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_info_bar_set_message_type (_tmp15_, _tmp16_);
#line 202 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp17_ = self->priv->info_bar_image;
#line 202 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp18_ = image_id;
#line 202 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_image_set_from_stock (_tmp17_, _tmp18_, GTK_ICON_SIZE_DIALOG);
#line 203 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp19_ = title;
#line 203 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp20_ = text;
#line 203 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp21_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", _tmp19_, _tmp20_);
#line 203 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	message = _tmp21_;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp22_ = self->priv->info_bar_label;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp23_ = message;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_label_set_markup (_tmp22_, _tmp23_);
#line 205 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp24_ = self->priv->info_bar_close_button;
#line 205 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp25_ = show_close_button;
#line 205 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp25_);
#line 206 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp26_ = self->priv->info_bar_change_scanner_button;
#line 206 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp27_ = show_change_scanner_button;
#line 206 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, _tmp27_);
#line 207 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp28_ = self->priv->info_bar;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp28_);
#line 170 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (message);
#line 170 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (image_id);
#line 170 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (text);
#line 170 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (title);
#line 933 "ui.c"
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return self ? scan_device_ref (self) : NULL;
#line 940 "ui.c"
}


void simple_scan_set_scan_devices (SimpleScan* self, GList* devices) {
	gboolean have_selection = FALSE;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp0_ = FALSE;
	GList* _tmp3_ = NULL;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
#line 210 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 212 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	have_selection = FALSE;
#line 216 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->setting_devices = TRUE;
#line 219 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->user_selected_device;
#line 219 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_) {
#line 962 "ui.c"
		GtkComboBox* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 220 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 220 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
#line 220 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		have_selection = _tmp2_ >= 0;
#line 971 "ui.c"
	}
#line 223 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	index = 0;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = devices;
#line 977 "ui.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		device_collection = _tmp3_;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 985 "ui.c"
			ScanDevice* _tmp4_ = NULL;
			ScanDevice* device = NULL;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp4_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
#line 224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			device = _tmp4_;
#line 992 "ui.c"
			{
				gint n_delete = 0;
				GtkListStore* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				GtkTreeIter _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				gint _tmp20_ = 0;
				gint _tmp43_ = 0;
#line 226 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				n_delete = -1;
#line 229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp5_ = self->priv->device_model;
#line 229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp6_ = index;
#line 229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp8_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp5_, &_tmp7_, NULL, _tmp6_);
#line 229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				iter = _tmp7_;
#line 229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (_tmp8_) {
#line 1013 "ui.c"
					gint i = 0;
#line 231 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					i = 0;
#line 1017 "ui.c"
					{
						gboolean _tmp9_ = FALSE;
#line 232 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp9_ = TRUE;
#line 232 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						while (TRUE) {
#line 1024 "ui.c"
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp12_ = NULL;
							GtkTreeIter _tmp13_ = {0};
							const gchar* _tmp14_ = NULL;
							ScanDevice* _tmp15_ = NULL;
							const gchar* _tmp16_ = NULL;
							gboolean _tmp17_ = FALSE;
							gint _tmp19_ = 0;
#line 232 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							if (!_tmp9_) {
#line 1036 "ui.c"
								GtkListStore* _tmp10_ = NULL;
								gboolean _tmp11_ = FALSE;
#line 246 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								_tmp10_ = self->priv->device_model;
#line 246 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								_tmp11_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp10_, &iter);
#line 246 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								if (!_tmp11_) {
#line 246 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
									break;
#line 1047 "ui.c"
								}
							}
#line 232 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp9_ = FALSE;
#line 237 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp12_ = self->priv->device_model;
#line 237 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp13_ = iter;
#line 237 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							gtk_tree_model_get ((GtkTreeModel*) _tmp12_, &_tmp13_, 0, &name, -1, -1);
#line 238 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp14_ = name;
#line 238 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp15_ = device;
#line 238 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp16_ = _tmp15_->name;
#line 238 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							matched = g_strcmp0 (_tmp14_, _tmp16_) == 0;
#line 240 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp17_ = matched;
#line 240 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							if (_tmp17_) {
#line 1070 "ui.c"
								gint _tmp18_ = 0;
#line 242 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								_tmp18_ = i;
#line 242 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								n_delete = _tmp18_;
#line 243 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								_g_free0 (name);
#line 243 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								break;
#line 1080 "ui.c"
							}
#line 245 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp19_ = i;
#line 245 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							i = _tmp19_ + 1;
#line 232 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_g_free0 (name);
#line 1088 "ui.c"
						}
					}
				}
#line 250 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp20_ = n_delete;
#line 250 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (_tmp20_ >= 0) {
#line 1096 "ui.c"
					gint i = 0;
					GtkListStore* _tmp21_ = NULL;
					GtkTreeIter _tmp22_ = {0};
					ScanDevice* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
#line 255 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp21_ = self->priv->device_model;
#line 255 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp22_ = iter;
#line 255 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp23_ = device;
#line 255 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp24_ = _tmp23_->label;
#line 255 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					gtk_list_store_set (_tmp21_, &_tmp22_, 1, _tmp24_, -1, -1);
#line 1112 "ui.c"
					{
						gboolean _tmp25_ = FALSE;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						i = 0;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp25_ = TRUE;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						while (TRUE) {
#line 1121 "ui.c"
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							GtkListStore* _tmp29_ = NULL;
							gint _tmp30_ = 0;
							GtkTreeIter _tmp31_ = {0};
							GtkListStore* _tmp32_ = NULL;
							GtkTreeIter _tmp33_ = {0};
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							if (!_tmp25_) {
#line 1131 "ui.c"
								gint _tmp26_ = 0;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								_tmp26_ = i;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								i = _tmp26_ + 1;
#line 1137 "ui.c"
							}
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp25_ = FALSE;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp27_ = i;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp28_ = n_delete;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							if (!(_tmp27_ < _tmp28_)) {
#line 257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								break;
#line 1149 "ui.c"
							}
#line 259 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp29_ = self->priv->device_model;
#line 259 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp30_ = index;
#line 259 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp29_, &_tmp31_, NULL, _tmp30_);
#line 259 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							iter = _tmp31_;
#line 260 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp32_ = self->priv->device_model;
#line 260 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp33_ = iter;
#line 260 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							gtk_list_store_remove (_tmp32_, &_tmp33_);
#line 1165 "ui.c"
						}
					}
				} else {
					GtkListStore* _tmp34_ = NULL;
					gint _tmp35_ = 0;
					GtkTreeIter _tmp36_ = {0};
					GtkListStore* _tmp37_ = NULL;
					GtkTreeIter _tmp38_ = {0};
					ScanDevice* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					ScanDevice* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
#line 265 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp34_ = self->priv->device_model;
#line 265 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp35_ = index;
#line 265 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					gtk_list_store_insert (_tmp34_, &_tmp36_, _tmp35_);
#line 265 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					iter = _tmp36_;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp37_ = self->priv->device_model;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp38_ = iter;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp39_ = device;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp40_ = _tmp39_->name;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp41_ = device;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp42_ = _tmp41_->label;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					gtk_list_store_set (_tmp37_, &_tmp38_, 0, _tmp40_, 1, _tmp42_, -1, -1);
#line 1200 "ui.c"
				}
#line 268 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp43_ = index;
#line 268 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				index = _tmp43_ + 1;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_scan_device_unref0 (device);
#line 1208 "ui.c"
			}
		}
	}
#line 272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	while (TRUE) {
#line 1214 "ui.c"
		GtkListStore* _tmp44_ = NULL;
		gint _tmp45_ = 0;
		GtkTreeIter _tmp46_ = {0};
		gboolean _tmp47_ = FALSE;
		GtkListStore* _tmp48_ = NULL;
		GtkTreeIter _tmp49_ = {0};
#line 272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp44_ = self->priv->device_model;
#line 272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp45_ = index;
#line 272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp47_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp44_, &_tmp46_, NULL, _tmp45_);
#line 272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		iter = _tmp46_;
#line 272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (!_tmp47_) {
#line 272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			break;
#line 1233 "ui.c"
		}
#line 273 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp48_ = self->priv->device_model;
#line 273 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp49_ = iter;
#line 273 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_list_store_remove (_tmp48_, &_tmp49_);
#line 1241 "ui.c"
	}
#line 276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp51_ = have_selection;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!_tmp51_) {
#line 1247 "ui.c"
		GList* _tmp52_ = NULL;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp52_ = devices;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp50_ = _tmp52_ != NULL;
#line 1253 "ui.c"
	} else {
#line 276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp50_ = FALSE;
#line 1257 "ui.c"
	}
#line 276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp50_) {
#line 1261 "ui.c"
		GtkComboBox* _tmp53_ = NULL;
#line 277 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp53_ = self->priv->device_combo;
#line 277 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_combo_box_set_active (_tmp53_, 0);
#line 1267 "ui.c"
	}
#line 279 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->setting_devices = FALSE;
#line 281 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_update_info_bar (self);
#line 1273 "ui.c"
}


static gchar* simple_scan_get_selected_device (SimpleScan* self) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 284 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->device_combo;
#line 288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp1_;
#line 288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 1293 "ui.c"
		gchar* device = NULL;
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 291 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->device_model;
#line 291 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = iter;
#line 291 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &device, -1, -1);
#line 292 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		result = device;
#line 292 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return result;
#line 1307 "ui.c"
	}
#line 295 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = NULL;
#line 295 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 1313 "ui.c"
}


void simple_scan_set_selected_device (SimpleScan* self, const gchar* device) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
#line 298 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 298 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (device != NULL);
#line 301 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = device;
#line 301 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = simple_scan_find_scan_device (self, _tmp0_, &_tmp1_);
#line 301 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp1_;
#line 301 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!_tmp2_) {
#line 302 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 1338 "ui.c"
	}
#line 304 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->device_combo;
#line 304 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = iter;
#line 304 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_combo_box_set_active_iter (_tmp3_, &_tmp4_);
#line 305 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 1348 "ui.c"
}


static void simple_scan_add_default_page (SimpleScan* self) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	ScanDirection _tmp4_ = 0;
	Page* _tmp5_ = NULL;
	BookView* _tmp6_ = NULL;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->default_page_width;
#line 310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = self->priv->default_page_height;
#line 310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->default_page_dpi;
#line 310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = self->priv->default_page_scan_direction;
#line 310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = book_append_page (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp5_;
#line 314 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = self->priv->book_view;
#line 314 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	book_view_select_page (_tmp6_, page);
#line 308 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 1383 "ui.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return self ? g_object_ref (self) : NULL;
#line 1390 "ui.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1415 "ui.c"
		gchar* _tmp4_ = NULL;
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 1423 "ui.c"
	} else {
#line 936 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 1429 "ui.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1226 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1228 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1228 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1463 "ui.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1472 "ui.c"
	}
#line 1231 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1231 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1478 "ui.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1487 "ui.c"
	}
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1493 "ui.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1502 "ui.c"
	} else {
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1506 "ui.c"
	}
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1514 "ui.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1523 "ui.c"
	} else {
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1527 "ui.c"
	}
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 1549 "ui.c"
}


static void simple_scan_on_file_type_changed (SimpleScan* self, GtkTreeSelection* selection) {
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_ = NULL;
	gchar* extension = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gchar* path = NULL;
	GtkFileChooserDialog* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GtkFileChooserDialog* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
#line 317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (selection != NULL);
#line 321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = selection;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
#line 321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (model);
#line 321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = _g_object_ref0 (_tmp1_);
#line 321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	model = _tmp4_;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp2_;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!_tmp3_) {
#line 322 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (model);
#line 322 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 1601 "ui.c"
	}
#line 325 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = model;
#line 325 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = iter;
#line 325 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &extension, -1, -1);
#line 326 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = self->priv->save_dialog;
#line 326 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp7_);
#line 326 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	path = _tmp8_;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = path;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = g_path_get_basename (_tmp9_);
#line 327 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	filename = _tmp10_;
#line 330 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = filename;
#line 330 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp12_ = string_last_index_of_char (_tmp11_, (gunichar) '.', 0);
#line 330 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	extension_index = _tmp12_;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp13_ = extension_index;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp13_ >= 0) {
#line 1631 "ui.c"
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp14_ = filename;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp15_ = extension_index;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp16_ = string_slice (_tmp14_, (glong) 0, (glong) _tmp15_);
#line 332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (filename);
#line 332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		filename = _tmp16_;
#line 1645 "ui.c"
	}
#line 333 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp17_ = filename;
#line 333 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp18_ = extension;
#line 333 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
#line 333 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (filename);
#line 333 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	filename = _tmp19_;
#line 334 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp20_ = self->priv->save_dialog;
#line 334 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp21_ = filename;
#line 334 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp20_, _tmp21_);
#line 317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (filename);
#line 317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (path);
#line 317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (extension);
#line 317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (model);
#line 1671 "ui.c"
}


static void _simple_scan_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 421 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_on_file_type_changed ((SimpleScan*) self, _sender);
#line 1678 "ui.c"
}


static gchar* simple_scan_choose_file_location (SimpleScan* self) {
	gchar* result = NULL;
	gchar* directory = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkFileChooserDialog* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkFileChooserDialog* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp16_ = NULL;
	GtkFileFilter* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	GtkFileChooserDialog* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	GtkFileFilter* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileFilter* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	GtkFileChooserDialog* _tmp28_ = NULL;
	GtkFileFilter* _tmp29_ = NULL;
	GtkFileFilter* _tmp30_ = NULL;
	GtkExpander* expander = NULL;
	const gchar* _tmp31_ = NULL;
	GtkExpander* _tmp32_ = NULL;
	GtkExpander* _tmp33_ = NULL;
	GtkFileChooserDialog* _tmp34_ = NULL;
	GtkExpander* _tmp35_ = NULL;
	gchar* extension = NULL;
	gchar* _tmp36_ = NULL;
	gint index = 0;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	GtkListStore* file_type_store = NULL;
	GtkListStore* _tmp43_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp44_ = NULL;
	GtkTreeIter _tmp45_ = {0};
	GtkListStore* _tmp46_ = NULL;
	GtkTreeIter _tmp47_ = {0};
	const gchar* _tmp48_ = NULL;
	GtkListStore* _tmp49_ = NULL;
	GtkTreeIter _tmp50_ = {0};
	GtkListStore* _tmp51_ = NULL;
	GtkTreeIter _tmp52_ = {0};
	const gchar* _tmp53_ = NULL;
	GtkListStore* _tmp54_ = NULL;
	GtkTreeIter _tmp55_ = {0};
	GtkListStore* _tmp56_ = NULL;
	GtkTreeIter _tmp57_ = {0};
	const gchar* _tmp58_ = NULL;
	GtkTreeView* file_type_view = NULL;
	GtkListStore* _tmp59_ = NULL;
	GtkTreeView* _tmp60_ = NULL;
	GtkTreeView* _tmp61_ = NULL;
	GtkTreeView* _tmp62_ = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp63_ = NULL;
	GtkCellRendererText* _tmp64_ = NULL;
	GtkTreeViewColumn* _tmp65_ = NULL;
	GtkTreeViewColumn* _tmp66_ = NULL;
	GtkTreeView* _tmp67_ = NULL;
	GtkTreeViewColumn* _tmp68_ = NULL;
	GtkExpander* _tmp69_ = NULL;
	GtkTreeView* _tmp70_ = NULL;
	GtkListStore* _tmp71_ = NULL;
	GtkTreeIter _tmp72_ = {0};
	gboolean _tmp73_ = FALSE;
	GtkTreeView* _tmp84_ = NULL;
	GtkTreeSelection* _tmp85_ = NULL;
	GtkExpander* _tmp86_ = NULL;
	gint response = 0;
	GtkFileChooserDialog* _tmp87_ = NULL;
	gint _tmp88_ = 0;
	gchar* uri = NULL;
	gint _tmp89_ = 0;
	GSettings* _tmp92_ = NULL;
	GtkFileChooserDialog* _tmp93_ = NULL;
	gchar* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	GtkTreeView* _tmp96_ = NULL;
	GtkTreeSelection* _tmp97_ = NULL;
	guint _tmp98_ = 0U;
	GtkFileChooserDialog* _tmp99_ = NULL;
#line 337 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 340 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	directory = NULL;
#line 341 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 341 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
#line 341 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (directory);
#line 341 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	directory = _tmp1_;
#line 343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = directory;
#line 343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp3_ == NULL) {
#line 343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = TRUE;
#line 1795 "ui.c"
	} else {
		const gchar* _tmp4_ = NULL;
#line 343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = directory;
#line 343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
#line 1802 "ui.c"
	}
#line 343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 1806 "ui.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
#line 344 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 344 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (directory);
#line 344 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		directory = _tmp6_;
#line 1817 "ui.c"
	}
#line 346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = _ ("Save As...");
#line 346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = self->priv->window;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp7_, _tmp8_, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp9_);
#line 346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->save_dialog = _tmp9_;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = self->priv->save_dialog;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp10_, TRUE);
#line 354 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = self->priv->save_dialog;
#line 354 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp11_, FALSE);
#line 355 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp12_ = self->priv->save_dialog;
#line 355 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp13_ = directory;
#line 355 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp12_, _tmp13_);
#line 356 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp14_ = self->priv->save_dialog;
#line 356 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp15_ = self->priv->default_file_name;
#line 356 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp14_, _tmp15_);
#line 359 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp16_ = gtk_file_filter_new ();
#line 359 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp16_);
#line 359 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	filter = _tmp16_;
#line 360 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp17_ = filter;
#line 360 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp18_ = _ ("Image Files");
#line 360 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_filter_set_name (_tmp17_, _tmp18_);
#line 362 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp19_ = filter;
#line 362 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_filter_add_pixbuf_formats (_tmp19_);
#line 363 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp20_ = filter;
#line 363 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_filter_add_mime_type (_tmp20_, "application/pdf");
#line 364 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp21_ = self->priv->save_dialog;
#line 364 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp22_ = filter;
#line 364 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp23_ = _g_object_ref0 (_tmp22_);
#line 364 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp21_, _tmp23_);
#line 365 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp24_ = gtk_file_filter_new ();
#line 365 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp24_);
#line 365 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (filter);
#line 365 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	filter = _tmp24_;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp25_ = filter;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp26_ = _ ("All Files");
#line 366 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_filter_set_name (_tmp25_, _tmp26_);
#line 368 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp27_ = filter;
#line 368 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_filter_add_pattern (_tmp27_, "*");
#line 369 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp28_ = self->priv->save_dialog;
#line 369 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp29_ = filter;
#line 369 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp30_ = _g_object_ref0 (_tmp29_);
#line 369 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp28_, _tmp30_);
#line 371 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp31_ = _ ("Select File _Type");
#line 371 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp32_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp31_);
#line 371 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp32_);
#line 371 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	expander = _tmp32_;
#line 373 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp33_ = expander;
#line 373 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_expander_set_spacing (_tmp33_, 5);
#line 374 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp34_ = self->priv->save_dialog;
#line 374 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp35_ = expander;
#line 374 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp34_, (GtkWidget*) _tmp35_);
#line 376 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp36_ = g_strdup ("");
#line 376 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	extension = _tmp36_;
#line 377 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp37_ = self->priv->default_file_name;
#line 377 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp38_ = string_last_index_of_char (_tmp37_, (gunichar) '.', 0);
#line 377 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	index = _tmp38_;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp39_ = index;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp39_ >= 0) {
#line 1937 "ui.c"
		const gchar* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gchar* _tmp42_ = NULL;
#line 379 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp40_ = self->priv->default_file_name;
#line 379 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp41_ = index;
#line 379 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp42_ = string_slice (_tmp40_, (glong) 0, (glong) _tmp41_);
#line 379 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (extension);
#line 379 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		extension = _tmp42_;
#line 1951 "ui.c"
	}
#line 381 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp43_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
#line 381 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	file_type_store = _tmp43_;
#line 383 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp44_ = file_type_store;
#line 383 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp44_, &_tmp45_);
#line 383 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp45_;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp46_ = file_type_store;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp47_ = iter;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp48_ = _ ("PDF (multi-page document)");
#line 384 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp46_, &_tmp47_, 0, _tmp48_, 1, ".pdf", -1, -1);
#line 389 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp49_ = file_type_store;
#line 389 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp49_, &_tmp50_);
#line 389 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp50_;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp51_ = file_type_store;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp52_ = iter;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp53_ = _ ("JPEG (compressed)");
#line 390 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp51_, &_tmp52_, 0, _tmp53_, 1, ".jpg", -1, -1);
#line 395 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp54_ = file_type_store;
#line 395 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp54_, &_tmp55_);
#line 395 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp55_;
#line 396 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp56_ = file_type_store;
#line 396 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp57_ = iter;
#line 396 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp58_ = _ ("PNG (lossless)");
#line 396 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp56_, &_tmp57_, 0, _tmp58_, 1, ".png", -1, -1);
#line 402 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp59_ = file_type_store;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp60_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp59_);
#line 402 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp60_);
#line 402 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	file_type_view = _tmp60_;
#line 403 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp61_ = file_type_view;
#line 403 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_tree_view_set_headers_visible (_tmp61_, FALSE);
#line 404 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp62_ = file_type_view;
#line 404 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_tree_view_set_rules_hint (_tmp62_, TRUE);
#line 405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp63_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp63_);
#line 405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp64_ = _tmp63_;
#line 405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp65_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp64_, "text", 0, NULL, NULL);
#line 405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp65_);
#line 405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp66_ = _tmp65_;
#line 405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (_tmp64_);
#line 405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	column = _tmp66_;
#line 408 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp67_ = file_type_view;
#line 408 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp68_ = column;
#line 408 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_tree_view_append_column (_tmp67_, _tmp68_);
#line 409 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp69_ = expander;
#line 409 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp70_ = file_type_view;
#line 409 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp70_);
#line 411 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp71_ = file_type_store;
#line 411 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp73_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp71_, &_tmp72_);
#line 411 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp72_;
#line 411 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp73_) {
#line 2051 "ui.c"
		{
			gboolean _tmp74_ = FALSE;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp74_ = TRUE;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			while (TRUE) {
#line 2058 "ui.c"
				gchar* e = NULL;
				GtkListStore* _tmp77_ = NULL;
				GtkTreeIter _tmp78_ = {0};
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (!_tmp74_) {
#line 2066 "ui.c"
					GtkListStore* _tmp75_ = NULL;
					gboolean _tmp76_ = FALSE;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp75_ = file_type_store;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp76_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp75_, &iter);
#line 419 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					if (!_tmp76_) {
#line 419 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						break;
#line 2077 "ui.c"
					}
				}
#line 413 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp74_ = FALSE;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp77_ = file_type_store;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp78_ = iter;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp77_, &_tmp78_, 1, &e, -1, -1);
#line 417 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp79_ = extension;
#line 417 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp80_ = e;
#line 417 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (g_strcmp0 (_tmp79_, _tmp80_) == 0) {
#line 2094 "ui.c"
					GtkTreeView* _tmp81_ = NULL;
					GtkTreeSelection* _tmp82_ = NULL;
					GtkTreeIter _tmp83_ = {0};
#line 418 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp81_ = file_type_view;
#line 418 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp82_ = gtk_tree_view_get_selection (_tmp81_);
#line 418 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp83_ = iter;
#line 418 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					gtk_tree_selection_select_iter (_tmp82_, &_tmp83_);
#line 2106 "ui.c"
				}
#line 413 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_g_free0 (e);
#line 2110 "ui.c"
			}
		}
	}
#line 421 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp84_ = file_type_view;
#line 421 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp85_ = gtk_tree_view_get_selection (_tmp84_);
#line 421 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp85_, "changed", (GCallback) _simple_scan_on_file_type_changed_gtk_tree_selection_changed, self);
#line 423 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp86_ = expander;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp86_);
#line 425 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp87_ = self->priv->save_dialog;
#line 425 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp88_ = gtk_dialog_run ((GtkDialog*) _tmp87_);
#line 425 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	response = _tmp88_;
#line 427 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	uri = NULL;
#line 428 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp89_ = response;
#line 428 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp89_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 2136 "ui.c"
		GtkFileChooserDialog* _tmp90_ = NULL;
		gchar* _tmp91_ = NULL;
#line 429 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp90_ = self->priv->save_dialog;
#line 429 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp91_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp90_);
#line 429 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (uri);
#line 429 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		uri = _tmp91_;
#line 2147 "ui.c"
	}
#line 431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp92_ = self->priv->settings;
#line 431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp93_ = self->priv->save_dialog;
#line 431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp94_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp93_);
#line 431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp95_ = _tmp94_;
#line 431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_string (_tmp92_, "save-directory", _tmp95_);
#line 431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (_tmp95_);
#line 433 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp96_ = file_type_view;
#line 433 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp97_ = gtk_tree_view_get_selection (_tmp96_);
#line 433 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_parse_name ("changed", GTK_TYPE_TREE_SELECTION, &_tmp98_, NULL, FALSE);
#line 433 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp97_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp98_, 0, NULL, (GCallback) _simple_scan_on_file_type_changed_gtk_tree_selection_changed, self);
#line 434 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp99_ = self->priv->save_dialog;
#line 434 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp99_);
#line 435 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 435 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->save_dialog = NULL;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = uri;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (column);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (file_type_view);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (file_type_store);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (extension);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (expander);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (filter);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (directory);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 2195 "ui.c"
}


static gboolean simple_scan_save_document (SimpleScan* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp6_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* uri_lower = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* format = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	Book* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
#line 440 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 443 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->book_uri;
#line 443 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_ != NULL) {
#line 2226 "ui.c"
		gboolean _tmp2_ = FALSE;
#line 443 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = force_choose_location;
#line 443 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp0_ = !_tmp2_;
#line 2232 "ui.c"
	} else {
#line 443 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp0_ = FALSE;
#line 2236 "ui.c"
	}
#line 443 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_) {
#line 2240 "ui.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 444 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->book_uri;
#line 444 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 444 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (uri);
#line 444 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		uri = _tmp4_;
#line 2251 "ui.c"
	} else {
		gchar* _tmp5_ = NULL;
#line 446 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = simple_scan_choose_file_location (self);
#line 446 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (uri);
#line 446 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		uri = _tmp5_;
#line 2260 "ui.c"
	}
#line 447 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = uri;
#line 447 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp6_ == NULL) {
#line 448 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		result = FALSE;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (uri);
#line 448 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return result;
#line 2272 "ui.c"
	}
#line 450 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = uri;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = g_file_new_for_uri (_tmp7_);
#line 450 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	file = _tmp8_;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = uri;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_debug ("ui.vala:452: Saving to '%s'", _tmp9_);
#line 454 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = uri;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) (-1));
#line 454 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	uri_lower = _tmp11_;
#line 455 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp12_ = g_strdup ("jpeg");
#line 455 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	format = _tmp12_;
#line 456 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp13_ = uri_lower;
#line 456 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp14_ = g_str_has_suffix (_tmp13_, ".pdf");
#line 456 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp14_) {
#line 2300 "ui.c"
		gchar* _tmp15_ = NULL;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp15_ = g_strdup ("pdf");
#line 457 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (format);
#line 457 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		format = _tmp15_;
#line 2308 "ui.c"
	} else {
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp16_ = uri_lower;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp17_ = g_str_has_suffix (_tmp16_, ".ps");
#line 458 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_tmp17_) {
#line 2318 "ui.c"
			gchar* _tmp18_ = NULL;
#line 459 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp18_ = g_strdup ("ps");
#line 459 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_free0 (format);
#line 459 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			format = _tmp18_;
#line 2326 "ui.c"
		} else {
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp19_ = uri_lower;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp20_ = g_str_has_suffix (_tmp19_, ".png");
#line 460 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			if (_tmp20_) {
#line 2336 "ui.c"
				gchar* _tmp21_ = NULL;
#line 461 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp21_ = g_strdup ("png");
#line 461 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_g_free0 (format);
#line 461 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				format = _tmp21_;
#line 2344 "ui.c"
			} else {
				gboolean _tmp22_ = FALSE;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp23_ = uri_lower;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp24_ = g_str_has_suffix (_tmp23_, ".tif");
#line 462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (_tmp24_) {
#line 462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp22_ = TRUE;
#line 2357 "ui.c"
				} else {
					const gchar* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp25_ = uri_lower;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp26_ = g_str_has_suffix (_tmp25_, ".tiff");
#line 462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp22_ = _tmp26_;
#line 2367 "ui.c"
				}
#line 462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (_tmp22_) {
#line 2371 "ui.c"
					gchar* _tmp27_ = NULL;
#line 463 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp27_ = g_strdup ("tiff");
#line 463 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_g_free0 (format);
#line 463 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					format = _tmp27_;
#line 2379 "ui.c"
				}
			}
		}
	}
	{
		Book* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		GFile* _tmp30_ = NULL;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp28_ = self->priv->book;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp29_ = format;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp30_ = file;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		book_save (_tmp28_, _tmp29_, _tmp30_, &_inner_error_);
#line 467 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 2398 "ui.c"
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		GError* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		e = _inner_error_;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_inner_error_ = NULL;
#line 471 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp31_ = e;
#line 471 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp32_ = _tmp31_->message;
#line 471 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_warning ("ui.vala:471: Error saving file: %s", _tmp32_);
#line 472 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp33_ = _ ("Failed to save file");
#line 472 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp34_ = e;
#line 472 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp35_ = _tmp34_->message;
#line 472 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_show_error (self, _tmp33_, _tmp35_, FALSE);
#line 476 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		result = FALSE;
#line 476 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_error_free0 (e);
#line 476 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (format);
#line 476 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (uri_lower);
#line 476 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (file);
#line 476 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (uri);
#line 476 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return result;
#line 2443 "ui.c"
	}
	__finally15:
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (format);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (uri_lower);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (file);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (uri);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return FALSE;
#line 2462 "ui.c"
	}
#line 479 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp36_ = uri;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp37_ = g_strdup (_tmp36_);
#line 479 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 479 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->book_uri = _tmp37_;
#line 480 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp38_ = self->priv->book;
#line 480 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	book_set_needs_saving (_tmp38_, FALSE);
#line 481 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = TRUE;
#line 481 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (format);
#line 481 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (uri_lower);
#line 481 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (file);
#line 481 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (uri);
#line 481 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 2488 "ui.c"
}


static gboolean simple_scan_prompt_to_save (SimpleScan* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	Book* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkWindow* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkMessageDialog* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkMessageDialog* _tmp9_ = NULL;
	GtkMessageDialog* _tmp10_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkMessageDialog* _tmp13_ = NULL;
	gint _tmp14_ = 0;
#line 484 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 484 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (title != NULL, FALSE);
#line 484 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (discard_label != NULL, FALSE);
#line 486 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 486 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = book_get_needs_saving (_tmp0_);
#line 486 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!_tmp1_) {
#line 487 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		result = TRUE;
#line 487 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return result;
#line 2527 "ui.c"
	}
#line 489 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = self->priv->window;
#line 489 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = title;
#line 489 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp2_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp3_);
#line 489 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp4_);
#line 489 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	dialog = _tmp4_;
#line 494 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = dialog;
#line 494 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = _ ("If you don't save, changes will be permanently lost.");
#line 494 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_message_dialog_format_secondary_text (_tmp5_, "%s", _tmp6_);
#line 497 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = dialog;
#line 497 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = discard_label;
#line 497 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp7_, _tmp8_, (gint) GTK_RESPONSE_NO);
#line 498 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = dialog;
#line 498 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
#line 499 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = dialog;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
#line 501 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = dialog;
#line 501 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp12_ = gtk_dialog_run ((GtkDialog*) _tmp11_);
#line 501 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	response = _tmp12_;
#line 502 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp13_ = dialog;
#line 502 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 504 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp14_ = response;
#line 504 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	switch (_tmp14_) {
#line 504 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		case GTK_RESPONSE_YES:
#line 2575 "ui.c"
		{
			gboolean _tmp15_ = FALSE;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp15_ = simple_scan_save_document (self, FALSE);
#line 507 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			if (_tmp15_) {
#line 508 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				result = TRUE;
#line 508 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_g_object_unref0 (dialog);
#line 508 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				return result;
#line 2588 "ui.c"
			} else {
#line 510 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				result = FALSE;
#line 510 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_g_object_unref0 (dialog);
#line 510 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				return result;
#line 2596 "ui.c"
			}
		}
#line 504 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		case GTK_RESPONSE_CANCEL:
#line 2601 "ui.c"
		{
#line 512 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			result = FALSE;
#line 512 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_object_unref0 (dialog);
#line 512 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			return result;
#line 2609 "ui.c"
		}
		default:
#line 504 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		case GTK_RESPONSE_NO:
#line 2614 "ui.c"
		{
#line 515 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			result = TRUE;
#line 515 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_object_unref0 (dialog);
#line 515 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			return result;
#line 2622 "ui.c"
		}
	}
#line 484 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (dialog);
#line 2627 "ui.c"
}


static void simple_scan_clear_document (SimpleScan* self) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_ = NULL;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	book_clear (_tmp0_);
#line 522 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_add_default_page (self);
#line 523 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 523 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->book_uri = NULL;
#line 524 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 524 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	book_set_needs_saving (_tmp1_, FALSE);
#line 525 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = self->priv->save_as_menuitem;
#line 525 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 2655 "ui.c"
}


void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 529 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 529 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 531 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = _ ("Save current document?");
#line 531 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = _ ("Discard Changes");
#line 531 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = simple_scan_prompt_to_save (self, _tmp0_, _tmp1_);
#line 531 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!_tmp2_) {
#line 535 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 2678 "ui.c"
	}
#line 537 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->scanning;
#line 537 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp3_) {
#line 538 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 2686 "ui.c"
	}
#line 539 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_clear_document (self);
#line 2690 "ui.c"
}


static void simple_scan_set_document_hint (SimpleScan* self, const gchar* document_hint) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 542 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 542 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (document_hint != NULL);
#line 544 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = document_hint;
#line 544 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 544 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 544 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->document_hint = _tmp1_;
#line 546 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = document_hint;
#line 546 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (g_strcmp0 (_tmp2_, "text") == 0) {
#line 2714 "ui.c"
		GtkRadioMenuItem* _tmp3_ = NULL;
		GtkRadioMenuItem* _tmp4_ = NULL;
#line 548 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->text_toolbar_menuitem;
#line 548 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
#line 549 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = self->priv->text_menu_menuitem;
#line 549 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
#line 2725 "ui.c"
	} else {
		const gchar* _tmp5_ = NULL;
#line 551 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = document_hint;
#line 551 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (g_strcmp0 (_tmp5_, "photo") == 0) {
#line 2732 "ui.c"
			GtkRadioMenuItem* _tmp6_ = NULL;
			GtkRadioMenuItem* _tmp7_ = NULL;
#line 553 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp6_ = self->priv->photo_toolbar_menuitem;
#line 553 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp6_, TRUE);
#line 554 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp7_ = self->priv->photo_menu_menuitem;
#line 554 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp7_, TRUE);
#line 2743 "ui.c"
		}
	}
}


void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 559 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 559 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 561 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 561 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 561 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 562 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_document_hint (self, "text");
#line 2764 "ui.c"
	}
}


void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 566 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 566 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 568 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 568 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 568 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 569 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_document_hint (self, "photo");
#line 2784 "ui.c"
	}
}


static void simple_scan_set_page_side (SimpleScan* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 572 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 576 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->page_side_model;
#line 576 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 576 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp1_;
#line 576 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 2804 "ui.c"
		{
			gboolean _tmp3_ = FALSE;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp3_ = TRUE;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			while (TRUE) {
#line 2811 "ui.c"
				gint s = 0;
				GtkListStore* _tmp6_ = NULL;
				GtkTreeIter _tmp7_ = {0};
				gint _tmp8_ = 0;
				ScanType _tmp9_ = 0;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (!_tmp3_) {
#line 2819 "ui.c"
					GtkListStore* _tmp4_ = NULL;
					gboolean _tmp5_ = FALSE;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp4_ = self->priv->page_side_model;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
#line 587 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					if (!_tmp5_) {
#line 587 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						break;
#line 2830 "ui.c"
					}
				}
#line 578 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp3_ = FALSE;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp6_ = self->priv->page_side_model;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp7_ = iter;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, 0, &s, -1, -1);
#line 582 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp8_ = s;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp9_ = page_side;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (_tmp8_ == ((gint) _tmp9_)) {
#line 2847 "ui.c"
					GtkComboBox* _tmp10_ = NULL;
					GtkTreeIter _tmp11_ = {0};
#line 584 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp10_ = self->priv->page_side_combo;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp11_ = iter;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp10_, &_tmp11_);
#line 585 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					return;
#line 2858 "ui.c"
				}
			}
		}
	}
}


static void simple_scan_set_paper_size (SimpleScan* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp18_ = FALSE;
#line 591 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 2873 "ui.c"
	{
		GtkListStore* _tmp0_ = NULL;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 596 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp0_ = self->priv->paper_size_model;
#line 596 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 596 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		iter = _tmp1_;
#line 596 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		have_iter = _tmp2_;
#line 596 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = TRUE;
#line 596 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		while (TRUE) {
#line 2891 "ui.c"
			gboolean _tmp6_ = FALSE;
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			gboolean _tmp9_ = FALSE;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
#line 596 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			if (!_tmp3_) {
#line 2902 "ui.c"
				GtkListStore* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp4_ = self->priv->paper_size_model;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
#line 598 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				have_iter = _tmp5_;
#line 2911 "ui.c"
			}
#line 596 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp3_ = FALSE;
#line 597 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp6_ = have_iter;
#line 597 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			if (!_tmp6_) {
#line 597 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				break;
#line 2921 "ui.c"
			}
#line 601 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp7_ = self->priv->paper_size_model;
#line 601 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp8_ = iter;
#line 601 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &w, 1, &h, -1, -1);
#line 602 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp10_ = w;
#line 602 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp11_ = width;
#line 602 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			if (_tmp10_ == _tmp11_) {
#line 2935 "ui.c"
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
#line 602 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp12_ = h;
#line 602 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp13_ = height;
#line 602 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp9_ = _tmp12_ == _tmp13_;
#line 2944 "ui.c"
			} else {
#line 602 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp9_ = FALSE;
#line 2948 "ui.c"
			}
#line 602 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			if (_tmp9_) {
#line 603 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				break;
#line 2954 "ui.c"
			}
		}
	}
#line 606 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp14_ = have_iter;
#line 606 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!_tmp14_) {
#line 2962 "ui.c"
		GtkListStore* _tmp15_ = NULL;
		GtkTreeIter _tmp16_ = {0};
		gboolean _tmp17_ = FALSE;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp15_ = self->priv->paper_size_model;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp17_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp15_, &_tmp16_);
#line 607 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		iter = _tmp16_;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		have_iter = _tmp17_;
#line 2974 "ui.c"
	}
#line 608 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp18_ = have_iter;
#line 608 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp18_) {
#line 2980 "ui.c"
		GtkComboBox* _tmp19_ = NULL;
		GtkTreeIter _tmp20_ = {0};
#line 609 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp19_ = self->priv->paper_size_combo;
#line 609 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp20_ = iter;
#line 609 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_combo_box_set_active_iter (_tmp19_, &_tmp20_);
#line 2989 "ui.c"
	}
}


static gint simple_scan_get_text_dpi (SimpleScan* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 612 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 615 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	dpi = SIMPLE_SCAN_DEFAULT_TEXT_DPI;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->text_dpi_combo;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 617 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp1_;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 3013 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 618 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->text_dpi_model;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = iter;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3022 "ui.c"
	}
#line 620 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = dpi;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 3028 "ui.c"
}


static gint simple_scan_get_photo_dpi (SimpleScan* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 623 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 626 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	dpi = SIMPLE_SCAN_DEFAULT_PHOTO_DPI;
#line 628 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->photo_dpi_combo;
#line 628 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 628 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp1_;
#line 628 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 3051 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 629 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->photo_dpi_model;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = iter;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3060 "ui.c"
	}
#line 631 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = dpi;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 3066 "ui.c"
}


static ScanType simple_scan_get_page_side (SimpleScan* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint _tmp5_ = 0;
#line 634 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 637 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
#line 639 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->page_side_combo;
#line 639 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 639 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp1_;
#line 639 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 3090 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 640 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->page_side_model;
#line 640 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = iter;
#line 640 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &page_side, -1, -1);
#line 3099 "ui.c"
	}
#line 642 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = page_side;
#line 642 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = (ScanType) _tmp5_;
#line 642 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 3107 "ui.c"
}


static gboolean simple_scan_get_paper_size (SimpleScan* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gint _tmp0_ = 0;
	GtkComboBox* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 645 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 649 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_vala_height = 0;
#line 649 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = _vala_height;
#line 649 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_vala_width = _tmp0_;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->paper_size_combo;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
#line 650 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp2_;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp3_) {
#line 3136 "ui.c"
		GtkListStore* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
#line 652 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = self->priv->paper_size_model;
#line 652 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = iter;
#line 652 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &_vala_width, 1, &_vala_height, -1, -1);
#line 653 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		result = TRUE;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (width) {
#line 653 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			*width = _vala_width;
#line 3151 "ui.c"
		}
#line 653 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (height) {
#line 653 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			*height = _vala_height;
#line 3157 "ui.c"
		}
#line 653 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return result;
#line 3161 "ui.c"
	}
#line 656 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = FALSE;
#line 656 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (width) {
#line 656 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		*width = _vala_width;
#line 3169 "ui.c"
	}
#line 656 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (height) {
#line 656 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		*height = _vala_height;
#line 3175 "ui.c"
	}
#line 656 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 3179 "ui.c"
}


static ScanOptions* simple_scan_get_scan_options (SimpleScan* self) {
	ScanOptions* result = NULL;
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ScanOptions* _tmp10_ = NULL;
	ScanOptions* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 659 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 661 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = scan_options_new ();
#line 661 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	options = _tmp0_;
#line 662 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->document_hint;
#line 662 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 3202 "ui.c"
		ScanOptions* _tmp2_ = NULL;
		ScanOptions* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		ScanOptions* _tmp5_ = NULL;
#line 664 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = options;
#line 664 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
#line 665 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = options;
#line 665 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = simple_scan_get_text_dpi (self);
#line 665 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_->dpi = _tmp4_;
#line 666 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = options;
#line 666 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_->depth = 2;
#line 3221 "ui.c"
	} else {
		ScanOptions* _tmp6_ = NULL;
		ScanOptions* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		ScanOptions* _tmp9_ = NULL;
#line 670 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = options;
#line 670 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
#line 671 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = options;
#line 671 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = simple_scan_get_photo_dpi (self);
#line 671 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_->dpi = _tmp8_;
#line 672 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp9_ = options;
#line 672 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp9_->depth = 8;
#line 3241 "ui.c"
	}
#line 674 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = options;
#line 674 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = options;
#line 674 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_get_paper_size (self, &_tmp12_, &_tmp13_);
#line 674 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_->paper_width = _tmp12_;
#line 674 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_->paper_height = _tmp13_;
#line 676 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = options;
#line 676 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 3257 "ui.c"
}


void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 680 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 680 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 682 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = simple_scan_get_scan_options (self);
#line 682 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	options = _tmp0_;
#line 683 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	options->type = SCAN_TYPE_SINGLE;
#line 684 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = simple_scan_get_selected_device (self);
#line 684 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 684 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_emit_by_name (self, "start-scan", _tmp2_, options);
#line 684 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (_tmp2_);
#line 680 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_scan_options_unref0 (options);
#line 3286 "ui.c"
}


void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
#line 688 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 688 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 690 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_emit_by_name (self, "stop-scan");
#line 3297 "ui.c"
}


void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean _tmp0_ = FALSE;
#line 694 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 694 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 696 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->scanning;
#line 696 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_) {
#line 697 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3313 "ui.c"
	} else {
		ScanOptions* options = NULL;
		ScanOptions* _tmp1_ = NULL;
		ScanOptions* _tmp2_ = NULL;
		ScanType _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		ScanOptions* _tmp6_ = NULL;
#line 700 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp1_ = simple_scan_get_scan_options (self);
#line 700 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		options = _tmp1_;
#line 701 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = options;
#line 701 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = simple_scan_get_page_side (self);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_->type = _tmp3_;
#line 702 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = simple_scan_get_selected_device (self);
#line 702 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = _tmp4_;
#line 702 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = options;
#line 702 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_signal_emit_by_name (self, "start-scan", _tmp5_, _tmp6_);
#line 702 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (_tmp5_);
#line 696 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_scan_options_unref0 (options);
#line 3344 "ui.c"
	}
}


void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	GtkDialog* _tmp0_ = NULL;
#line 707 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 707 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 709 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 3359 "ui.c"
}


gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean result = FALSE;
#line 713 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 713 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 715 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = TRUE;
#line 715 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 3373 "ui.c"
}


void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, SimpleScan* self) {
	GtkDialog* _tmp0_ = NULL;
#line 719 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 719 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 721 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 721 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 3387 "ui.c"
}


static void simple_scan_update_page_menu (SimpleScan* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 726 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 726 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 726 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp1_;
#line 727 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = page;
#line 727 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_ == NULL) {
#line 3408 "ui.c"
		GtkMenuItem* _tmp3_ = NULL;
		GtkMenuItem* _tmp4_ = NULL;
#line 729 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->page_move_left_menuitem;
#line 729 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 730 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = self->priv->page_move_right_menuitem;
#line 730 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
#line 3419 "ui.c"
	} else {
		guint index = 0U;
		Book* _tmp5_ = NULL;
		Page* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		GtkMenuItem* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		GtkMenuItem* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		Book* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
#line 734 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = self->priv->book;
#line 734 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = page;
#line 734 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = book_get_page_index (_tmp5_, _tmp6_);
#line 734 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		index = _tmp7_;
#line 735 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = self->priv->page_move_left_menuitem;
#line 735 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp9_ = index;
#line 735 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp9_ > ((guint) 0));
#line 736 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp10_ = self->priv->page_move_right_menuitem;
#line 736 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp11_ = index;
#line 736 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp12_ = self->priv->book;
#line 736 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp13_ = book_get_n_pages (_tmp12_);
#line 736 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_ < (_tmp13_ - 1));
#line 3455 "ui.c"
	}
#line 724 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 3459 "ui.c"
}


static void simple_scan_page_selected_cb (SimpleScan* self, BookView* view, Page* page) {
	Page* _tmp0_ = NULL;
	gchar* name = NULL;
	Page* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkRadioMenuItem* menuitem = NULL;
	GtkBuilder* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GtkRadioMenuItem* _tmp23_ = NULL;
	GtkRadioMenuItem* _tmp24_ = NULL;
	GtkToggleToolButton* toolbutton = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkToggleToolButton* _tmp27_ = NULL;
	GtkToggleToolButton* _tmp28_ = NULL;
	Page* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
#line 740 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 740 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 742 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = page;
#line 742 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_ == NULL) {
#line 743 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 3491 "ui.c"
	}
#line 745 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->updating_page_menu = TRUE;
#line 747 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_update_page_menu (self);
#line 749 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	name = NULL;
#line 750 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = page;
#line 750 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = page_has_crop (_tmp1_);
#line 750 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 3505 "ui.c"
		gchar* crop_name = NULL;
		Page* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 753 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = page;
#line 753 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = page_get_named_crop (_tmp3_);
#line 753 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		crop_name = _tmp4_;
#line 754 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = crop_name;
#line 754 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_tmp5_ != NULL) {
#line 3520 "ui.c"
			const gchar* _tmp6_ = NULL;
#line 756 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp6_ = crop_name;
#line 756 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			if (g_strcmp0 (_tmp6_, "A4") == 0) {
#line 3526 "ui.c"
				gchar* _tmp7_ = NULL;
#line 757 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp7_ = g_strdup ("a4_menuitem");
#line 757 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_g_free0 (name);
#line 757 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				name = _tmp7_;
#line 3534 "ui.c"
			} else {
				const gchar* _tmp8_ = NULL;
#line 758 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp8_ = crop_name;
#line 758 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (g_strcmp0 (_tmp8_, "A5") == 0) {
#line 3541 "ui.c"
					gchar* _tmp9_ = NULL;
#line 759 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp9_ = g_strdup ("a5_menuitem");
#line 759 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_g_free0 (name);
#line 759 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					name = _tmp9_;
#line 3549 "ui.c"
				} else {
					const gchar* _tmp10_ = NULL;
#line 760 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp10_ = crop_name;
#line 760 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					if (g_strcmp0 (_tmp10_, "A6") == 0) {
#line 3556 "ui.c"
						gchar* _tmp11_ = NULL;
#line 761 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp11_ = g_strdup ("a6_menuitem");
#line 761 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_g_free0 (name);
#line 761 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						name = _tmp11_;
#line 3564 "ui.c"
					} else {
						const gchar* _tmp12_ = NULL;
#line 762 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp12_ = crop_name;
#line 762 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						if (g_strcmp0 (_tmp12_, "letter") == 0) {
#line 3571 "ui.c"
							gchar* _tmp13_ = NULL;
#line 763 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp13_ = g_strdup ("letter_menuitem");
#line 763 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_g_free0 (name);
#line 763 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							name = _tmp13_;
#line 3579 "ui.c"
						} else {
							const gchar* _tmp14_ = NULL;
#line 764 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp14_ = crop_name;
#line 764 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							if (g_strcmp0 (_tmp14_, "legal") == 0) {
#line 3586 "ui.c"
								gchar* _tmp15_ = NULL;
#line 765 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								_tmp15_ = g_strdup ("legal_menuitem");
#line 765 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								_g_free0 (name);
#line 765 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								name = _tmp15_;
#line 3594 "ui.c"
							} else {
								const gchar* _tmp16_ = NULL;
#line 766 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								_tmp16_ = crop_name;
#line 766 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
								if (g_strcmp0 (_tmp16_, "4x6") == 0) {
#line 3601 "ui.c"
									gchar* _tmp17_ = NULL;
#line 767 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
									_tmp17_ = g_strdup ("4x6_menuitem");
#line 767 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
									_g_free0 (name);
#line 767 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
									name = _tmp17_;
#line 3609 "ui.c"
								}
							}
						}
					}
				}
			}
		} else {
			gchar* _tmp18_ = NULL;
#line 770 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp18_ = g_strdup ("custom_crop_menuitem");
#line 770 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_g_free0 (name);
#line 770 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			name = _tmp18_;
#line 3624 "ui.c"
		}
#line 750 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (crop_name);
#line 3628 "ui.c"
	} else {
		gchar* _tmp19_ = NULL;
#line 773 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp19_ = g_strdup ("no_crop_menuitem");
#line 773 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (name);
#line 773 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		name = _tmp19_;
#line 3637 "ui.c"
	}
#line 775 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp20_ = self->priv->builder;
#line 775 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp21_ = name;
#line 775 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp22_ = gtk_builder_get_object (_tmp20_, _tmp21_);
#line 775 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 775 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	menuitem = _tmp23_;
#line 776 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp24_ = menuitem;
#line 776 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp24_, TRUE);
#line 777 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp25_ = self->priv->builder;
#line 777 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp26_ = gtk_builder_get_object (_tmp25_, "crop_toolbutton");
#line 777 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_TOGGLE_TOOL_BUTTON, GtkToggleToolButton));
#line 777 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	toolbutton = _tmp27_;
#line 778 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp28_ = toolbutton;
#line 778 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp29_ = page;
#line 778 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp30_ = page_has_crop (_tmp29_);
#line 778 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_toggle_tool_button_set_active (_tmp28_, _tmp30_);
#line 780 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->updating_page_menu = FALSE;
#line 740 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (toolbutton);
#line 740 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 740 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (name);
#line 3677 "ui.c"
}


static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 784 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 784 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 784 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 789 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = prefix;
#line 789 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = extension;
#line 789 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 789 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	filename = _tmp2_;
#line 3703 "ui.c"
	{
		gint fd = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 793 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = filename;
#line 793 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 793 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (path);
#line 793 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		path = _tmp4_;
#line 793 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		fd = _tmp5_;
#line 793 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 3722 "ui.c"
			goto __catch16_g_error;
		}
#line 794 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = fd;
#line 794 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		close (_tmp6_);
#line 3729 "ui.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 791 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		e = _inner_error_;
#line 791 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_inner_error_ = NULL;
#line 798 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = e;
#line 798 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = _tmp7_->message;
#line 798 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_warning ("ui.vala:798: Error saving email attachment: %s", _tmp8_);
#line 799 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		result = NULL;
#line 799 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_error_free0 (e);
#line 799 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (path);
#line 799 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (filename);
#line 799 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return result;
#line 3757 "ui.c"
	}
	__finally16:
#line 791 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 791 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (path);
#line 791 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (filename);
#line 791 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 791 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 791 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return NULL;
#line 3772 "ui.c"
	}
#line 802 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = path;
#line 802 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (filename);
#line 802 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 3780 "ui.c"
}


static void simple_scan_show_page_cb (SimpleScan* self, BookView* view, Page* page) {
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 805 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 805 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 805 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 807 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = simple_scan_get_temporary_filename (self, "scanned-page", "tiff");
#line 807 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	path = _tmp0_;
#line 808 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = path;
#line 808 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_ == NULL) {
#line 809 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (path);
#line 809 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 3810 "ui.c"
	}
#line 810 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = path;
#line 810 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 810 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	file = _tmp3_;
#line 3818 "ui.c"
	{
		Page* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
#line 814 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = page;
#line 814 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = file;
#line 814 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		page_save (_tmp4_, "tiff", _tmp5_, &_inner_error_);
#line 814 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 3830 "ui.c"
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 812 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		e = _inner_error_;
#line 812 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_inner_error_ = NULL;
#line 818 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = _ ("Unable to save image for preview");
#line 818 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = e;
#line 818 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = _tmp7_->message;
#line 818 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_show_error_dialog (self, _tmp6_, _tmp8_);
#line 821 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_error_free0 (e);
#line 821 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (file);
#line 821 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (path);
#line 821 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 3861 "ui.c"
	}
	__finally17:
#line 812 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 812 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (file);
#line 812 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (path);
#line 812 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 812 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 812 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 3876 "ui.c"
	}
	{
		GtkWindow* _tmp9_ = NULL;
		GdkScreen* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		guint32 _tmp14_ = 0U;
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp9_ = self->priv->window;
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp10_ = gtk_window_get_screen (_tmp9_);
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp11_ = file;
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp12_ = g_file_get_uri (_tmp11_);
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp13_ = _tmp12_;
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp14_ = gtk_get_current_event_time ();
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_show_uri (_tmp10_, _tmp13_, _tmp14_, &_inner_error_);
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (_tmp13_);
#line 826 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 3903 "ui.c"
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		e = _inner_error_;
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_inner_error_ = NULL;
#line 830 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp15_ = _ ("Unable to open image preview application");
#line 830 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp16_ = e;
#line 830 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp17_ = _tmp16_->message;
#line 830 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_show_error_dialog (self, _tmp15_, _tmp17_);
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_error_free0 (e);
#line 3928 "ui.c"
	}
	__finally18:
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (file);
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (path);
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 824 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 3943 "ui.c"
	}
#line 805 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (file);
#line 805 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (path);
#line 3949 "ui.c"
}


static void simple_scan_show_page_menu_cb (SimpleScan* self, BookView* view) {
	GtkMenu* menu = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkMenu* _tmp2_ = NULL;
	guint32 _tmp3_ = 0U;
#line 836 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 836 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 838 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->builder;
#line 838 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_builder_get_object (_tmp0_, "page_menu");
#line 838 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_MENU, GtkMenu));
#line 838 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	menu = _tmp2_;
#line 839 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = gtk_get_current_event_time ();
#line 839 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 3, _tmp3_);
#line 836 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (menu);
#line 3977 "ui.c"
}


void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean _tmp0_ = FALSE;
	Page* page = NULL;
	BookView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
#line 843 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 843 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 845 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 845 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_) {
#line 846 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 3997 "ui.c"
	}
#line 847 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 847 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = book_view_get_selected (_tmp1_);
#line 847 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp2_;
#line 848 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = page;
#line 848 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp3_ != NULL) {
#line 4009 "ui.c"
		Page* _tmp4_ = NULL;
#line 849 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = page;
#line 849 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		page_rotate_left (_tmp4_);
#line 4015 "ui.c"
	}
#line 843 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 4019 "ui.c"
}


void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean _tmp0_ = FALSE;
	Page* page = NULL;
	BookView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
#line 853 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 853 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 855 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 855 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_) {
#line 856 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 4039 "ui.c"
	}
#line 857 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 857 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = book_view_get_selected (_tmp1_);
#line 857 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp2_;
#line 858 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = page;
#line 858 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp3_ != NULL) {
#line 4051 "ui.c"
		Page* _tmp4_ = NULL;
#line 859 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = page;
#line 859 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		page_rotate_right (_tmp4_);
#line 4057 "ui.c"
	}
#line 853 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 4061 "ui.c"
}


static void simple_scan_set_crop (SimpleScan* self, const gchar* crop_name) {
	GtkMenuItem* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Page* page = NULL;
	BookView* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 862 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 864 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->crop_rotate_menuitem;
#line 864 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = crop_name;
#line 864 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
#line 866 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = self->priv->updating_page_menu;
#line 866 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 867 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 4088 "ui.c"
	}
#line 869 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 869 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = book_view_get_selected (_tmp3_);
#line 869 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp4_;
#line 870 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = page;
#line 870 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp5_ == NULL) {
#line 871 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_page_unref0 (page);
#line 871 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 4104 "ui.c"
	}
#line 873 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = crop_name;
#line 873 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp6_ == NULL) {
#line 4110 "ui.c"
		Page* _tmp7_ = NULL;
#line 875 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = page;
#line 875 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		page_set_no_crop (_tmp7_);
#line 876 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_page_unref0 (page);
#line 876 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 4120 "ui.c"
	} else {
		const gchar* _tmp8_ = NULL;
#line 878 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = crop_name;
#line 878 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (g_strcmp0 (_tmp8_, "custom") == 0) {
#line 4127 "ui.c"
			gint width = 0;
			Page* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint height = 0;
			Page* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint crop_width = 0;
			gint _tmp13_ = 0;
			gint crop_height = 0;
			gint _tmp14_ = 0;
			Page* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			Page* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
#line 880 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp9_ = page;
#line 880 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp10_ = page_get_width (_tmp9_);
#line 880 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			width = _tmp10_;
#line 881 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp11_ = page;
#line 881 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp12_ = page_get_height (_tmp11_);
#line 881 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			height = _tmp12_;
#line 882 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp13_ = width;
#line 882 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			crop_width = (gint) ((_tmp13_ * 0.8) + 0.5);
#line 883 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp14_ = height;
#line 883 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			crop_height = (gint) ((_tmp14_ * 0.8) + 0.5);
#line 884 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp15_ = page;
#line 884 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp16_ = crop_width;
#line 884 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp17_ = crop_height;
#line 884 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			page_set_custom_crop (_tmp15_, _tmp16_, _tmp17_);
#line 885 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp18_ = page;
#line 885 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp19_ = width;
#line 885 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp20_ = crop_width;
#line 885 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp21_ = height;
#line 885 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp22_ = crop_height;
#line 885 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			page_move_crop (_tmp18_, (_tmp19_ - _tmp20_) / 2, (_tmp21_ - _tmp22_) / 2);
#line 4186 "ui.c"
		} else {
			Page* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp23_ = page;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp24_ = crop_name;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			page_set_named_crop (_tmp23_, _tmp24_);
#line 4196 "ui.c"
		}
	}
#line 862 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 4201 "ui.c"
}


void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 892 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 892 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 894 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 894 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 894 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 895 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_crop (self, NULL);
#line 4220 "ui.c"
	}
}


void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 899 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 899 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 901 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 901 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 901 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 902 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_crop (self, "custom");
#line 4240 "ui.c"
	}
}


void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, SimpleScan* self) {
	gboolean _tmp0_ = FALSE;
	GtkRadioMenuItem* menuitem = NULL;
	GtkToggleToolButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkRadioMenuItem* _tmp9_ = NULL;
#line 906 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 906 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 908 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 908 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_) {
#line 909 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 4261 "ui.c"
	}
#line 912 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = widget;
#line 912 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = gtk_toggle_tool_button_get_active (_tmp1_);
#line 912 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_) {
#line 4269 "ui.c"
		GtkBuilder* _tmp3_ = NULL;
		GObject* _tmp4_ = NULL;
		GtkRadioMenuItem* _tmp5_ = NULL;
#line 913 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->builder;
#line 913 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = gtk_builder_get_object (_tmp3_, "custom_crop_menuitem");
#line 913 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 913 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 913 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		menuitem = _tmp5_;
#line 4283 "ui.c"
	} else {
		GtkBuilder* _tmp6_ = NULL;
		GObject* _tmp7_ = NULL;
		GtkRadioMenuItem* _tmp8_ = NULL;
#line 915 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = self->priv->builder;
#line 915 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = gtk_builder_get_object (_tmp6_, "no_crop_menuitem");
#line 915 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 915 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 915 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		menuitem = _tmp8_;
#line 4298 "ui.c"
	}
#line 916 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = menuitem;
#line 916 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp9_, TRUE);
#line 906 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 4306 "ui.c"
}


void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 920 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 920 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 922 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 922 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 922 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 923 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_crop (self, "4x6");
#line 4325 "ui.c"
	}
}


void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 927 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 927 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 929 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 929 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 929 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 930 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_crop (self, "legal");
#line 4345 "ui.c"
	}
}


void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 934 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 934 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 936 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 936 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 936 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 937 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_crop (self, "letter");
#line 4365 "ui.c"
	}
}


void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 941 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 941 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 943 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 943 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 943 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 944 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_crop (self, "A6");
#line 4385 "ui.c"
	}
}


void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 948 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 948 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 950 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 950 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 950 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 951 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_crop (self, "A5");
#line 4405 "ui.c"
	}
}


void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 955 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 955 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 957 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = widget;
#line 957 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 957 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp1_) {
#line 958 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_crop (self, "A4");
#line 4425 "ui.c"
	}
}


void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
#line 962 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 962 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 964 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 964 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 964 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp1_;
#line 965 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = page;
#line 965 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp2_ == NULL) {
#line 966 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_page_unref0 (page);
#line 966 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 4454 "ui.c"
	}
#line 967 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = page;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page_rotate_crop (_tmp3_);
#line 962 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 4462 "ui.c"
}


void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	guint index = 0U;
	Book* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
#line 971 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 971 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 973 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 973 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 973 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp1_;
#line 974 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 974 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = page;
#line 974 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
#line 974 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	index = _tmp4_;
#line 975 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = index;
#line 975 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp5_ > ((guint) 0)) {
#line 4497 "ui.c"
		Book* _tmp6_ = NULL;
		Page* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
#line 976 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = self->priv->book;
#line 976 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = page;
#line 976 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = index;
#line 976 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		book_move_page (_tmp6_, _tmp7_, _tmp8_ - 1);
#line 4509 "ui.c"
	}
#line 978 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_update_page_menu (self);
#line 971 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 4515 "ui.c"
}


void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	guint index = 0U;
	Book* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	Book* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
#line 982 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 982 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 984 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 984 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 984 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp1_;
#line 985 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 985 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = page;
#line 985 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
#line 985 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	index = _tmp4_;
#line 986 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = index;
#line 986 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = self->priv->book;
#line 986 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = book_get_n_pages (_tmp6_);
#line 986 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp5_ < (_tmp7_ - 1)) {
#line 4556 "ui.c"
		Book* _tmp8_ = NULL;
		Page* _tmp9_ = NULL;
		Book* _tmp10_ = NULL;
		Page* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
#line 987 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = self->priv->book;
#line 987 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp9_ = page;
#line 987 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp10_ = self->priv->book;
#line 987 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp11_ = page;
#line 987 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp12_ = book_get_page_index (_tmp10_, _tmp11_);
#line 987 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		book_move_page (_tmp8_, _tmp9_, _tmp12_ + 1);
#line 4574 "ui.c"
	}
#line 989 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_update_page_menu (self);
#line 982 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 4580 "ui.c"
}


void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	BookView* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	BookView* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 993 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 993 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = book_view_get_book (_tmp0_);
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = book_view_get_selected (_tmp3_);
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	book_delete_page (_tmp2_, _tmp5_);
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (_tmp5_);
#line 995 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_book_unref0 (_tmp2_);
#line 4613 "ui.c"
}


void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
#line 999 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 999 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1001 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_save_document (self, FALSE);
#line 4624 "ui.c"
}


void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
#line 1005 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1005 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1007 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_save_document (self, TRUE);
#line 4635 "ui.c"
}


static gpointer _cairo_reference0 (gpointer self) {
#line 1014 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return self ? cairo_reference (self) : NULL;
#line 4642 "ui.c"
}


static void simple_scan_draw_page (SimpleScan* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	cairo_t* context = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	Page* page = NULL;
	Book* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Page* _tmp5_ = NULL;
	gboolean is_landscape = FALSE;
	GtkPrintContext* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	GtkPrintContext* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	Page* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	cairo_t* _tmp17_ = NULL;
	GtkPrintContext* _tmp18_ = NULL;
	gdouble _tmp19_ = 0.0;
	Page* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GtkPrintContext* _tmp22_ = NULL;
	gdouble _tmp23_ = 0.0;
	Page* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GdkPixbuf* image = NULL;
	Page* _tmp26_ = NULL;
	GdkPixbuf* _tmp27_ = NULL;
	cairo_t* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (operation != NULL);
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (print_context != NULL);
#line 1014 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = print_context;
#line 1014 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1014 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1014 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	context = _tmp2_;
#line 1015 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->book;
#line 1015 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = page_number;
#line 1015 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = book_get_page (_tmp3_, _tmp4_);
#line 1015 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	page = _tmp5_;
#line 1018 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	is_landscape = FALSE;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = print_context;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = print_context;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp7_ > _tmp9_) {
#line 1020 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		is_landscape = TRUE;
#line 4713 "ui.c"
	}
#line 1021 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = page;
#line 1021 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = page_is_landscape (_tmp10_);
#line 1021 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp12_ = is_landscape;
#line 1021 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp11_ != _tmp12_) {
#line 4723 "ui.c"
		cairo_t* _tmp13_ = NULL;
		GtkPrintContext* _tmp14_ = NULL;
		gdouble _tmp15_ = 0.0;
		cairo_t* _tmp16_ = NULL;
#line 1023 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp13_ = context;
#line 1023 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp14_ = print_context;
#line 1023 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp15_ = gtk_print_context_get_width (_tmp14_);
#line 1023 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		cairo_translate (_tmp13_, _tmp15_, (gdouble) 0);
#line 1024 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp16_ = context;
#line 1024 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		cairo_rotate (_tmp16_, G_PI_2);
#line 4740 "ui.c"
	}
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp17_ = context;
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp18_ = print_context;
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp19_ = gtk_print_context_get_dpi_x (_tmp18_);
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp20_ = page;
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp21_ = page_get_dpi (_tmp20_);
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp22_ = print_context;
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp23_ = gtk_print_context_get_dpi_y (_tmp22_);
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp24_ = page;
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp25_ = page_get_dpi (_tmp24_);
#line 1027 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	cairo_scale (_tmp17_, _tmp19_ / _tmp21_, _tmp23_ / _tmp25_);
#line 1030 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp26_ = page;
#line 1030 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp27_ = page_get_image (_tmp26_, TRUE);
#line 1030 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	image = _tmp27_;
#line 1031 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp28_ = context;
#line 1031 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gdk_cairo_set_source_pixbuf (_tmp28_, image, (gdouble) 0, (gdouble) 0);
#line 1032 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp29_ = context;
#line 1032 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	cairo_paint (_tmp29_);
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (image);
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_page_unref0 (page);
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_cairo_destroy0 (context);
#line 4782 "ui.c"
}


void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	const gchar* _tmp0_ = NULL;
#line 1036 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1036 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1038 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1038 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_);
#line 4796 "ui.c"
}


static void _simple_scan_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 1046 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_draw_page ((SimpleScan*) self, _sender, context, page_nr);
#line 4803 "ui.c"
}


void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	GtkPrintOperation* print = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp6_ = 0U;
	GError * _inner_error_ = NULL;
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1044 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = gtk_print_operation_new ();
#line 1044 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	print = _tmp0_;
#line 1045 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 1045 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1045 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_print_operation_set_n_pages (print, (gint) _tmp2_);
#line 1046 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (print, "draw-page", (GCallback) _simple_scan_draw_page_gtk_print_operation_draw_page, self);
#line 4830 "ui.c"
	{
		GtkWindow* _tmp3_ = NULL;
#line 1050 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->window;
#line 1050 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp3_, &_inner_error_);
#line 1050 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4839 "ui.c"
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 1048 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		e = _inner_error_;
#line 1048 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_inner_error_ = NULL;
#line 1054 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = e;
#line 1054 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1054 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_warning ("ui.vala:1054: Error printing: %s", _tmp5_);
#line 1048 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_error_free0 (e);
#line 4861 "ui.c"
	}
	__finally19:
#line 1048 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1048 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_object_unref0 (print);
#line 1048 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1048 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1048 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 4874 "ui.c"
	}
#line 1057 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_parse_name ("draw-page", GTK_TYPE_PRINT_OPERATION, &_tmp6_, NULL, FALSE);
#line 1057 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _simple_scan_draw_page_gtk_print_operation_draw_page, self);
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (print);
#line 4882 "ui.c"
}


void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	GError * _inner_error_ = NULL;
#line 1061 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1061 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 4892 "ui.c"
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1065 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp0_ = self->priv->window;
#line 1065 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 1065 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1065 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_show_uri (_tmp1_, "help:simple-scan", _tmp2_, &_inner_error_);
#line 1065 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4907 "ui.c"
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		e = _inner_error_;
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_inner_error_ = NULL;
#line 1069 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = _ ("Unable to open help file");
#line 1069 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = e;
#line 1069 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1069 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_show_error_dialog (self, _tmp3_, _tmp5_);
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_error_free0 (e);
#line 4932 "ui.c"
	}
	__finally20:
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 4943 "ui.c"
	}
}


void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar* license = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* title = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* description = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
#line 1076 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1076 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1078 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
#line 1078 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 1078 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_[0] = _tmp0_;
#line 1078 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	authors = _tmp1_;
#line 1078 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	authors_length1 = 1;
#line 1078 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_authors_size_ = authors_length1;
#line 1081 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
#line 1081 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1081 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	license = _tmp3_;
#line 1084 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = _ ("About Simple Scan");
#line 1084 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 1084 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	title = _tmp5_;
#line 1087 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = _ ("Simple document scanning tool");
#line 1087 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 1087 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	description = _tmp7_;
#line 1089 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = self->priv->window;
#line 1089 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = _ ("translator-credits");
#line 1089 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_show_about_dialog (_tmp8_, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp9_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
#line 1076 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (description);
#line 1076 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (title);
#line 1076 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (license);
#line 1076 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 5013 "ui.c"
}


static gboolean simple_scan_on_quit (SimpleScan* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* device = NULL;
	gchar* _tmp3_ = NULL;
	gint paper_width = 0;
	gint paper_height = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	const gchar* _tmp6_ = NULL;
	GSettings* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GSettings* _tmp15_ = NULL;
	ScanType _tmp16_ = 0;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GSettings* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GSettings* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GSettings* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GSettings* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GSettings* _tmp27_ = NULL;
	ScanDirection _tmp28_ = 0;
	GSettings* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	GSettings* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	GSettings* _tmp33_ = NULL;
	gint _tmp34_ = 0;
#line 1104 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1106 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = _ ("Save document before quitting?");
#line 1106 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = _ ("Quit without Saving");
#line 1106 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = simple_scan_prompt_to_save (self, _tmp0_, _tmp1_);
#line 1106 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!_tmp2_) {
#line 1110 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		result = FALSE;
#line 1110 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return result;
#line 5069 "ui.c"
	}
#line 1112 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = simple_scan_get_selected_device (self);
#line 1112 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	device = _tmp3_;
#line 1113 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	paper_width = 0;
#line 1113 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	paper_height = 0;
#line 1114 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_get_paper_size (self, &_tmp4_, &_tmp5_);
#line 1114 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	paper_width = _tmp4_;
#line 1114 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	paper_height = _tmp5_;
#line 1116 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = device;
#line 1116 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp6_ != NULL) {
#line 5089 "ui.c"
		GSettings* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 1117 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = self->priv->settings;
#line 1117 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = device;
#line 1117 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_settings_set_string (_tmp7_, "selected-device", _tmp8_);
#line 5098 "ui.c"
	}
#line 1118 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = self->priv->settings;
#line 1118 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = self->priv->document_hint;
#line 1118 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_string (_tmp9_, "document-type", _tmp10_);
#line 1119 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = self->priv->settings;
#line 1119 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp12_ = simple_scan_get_text_dpi (self);
#line 1119 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp11_, "text-dpi", _tmp12_);
#line 1120 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp13_ = self->priv->settings;
#line 1120 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp14_ = simple_scan_get_photo_dpi (self);
#line 1120 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp13_, "photo-dpi", _tmp14_);
#line 1121 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp15_ = self->priv->settings;
#line 1121 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp16_ = simple_scan_get_page_side (self);
#line 1121 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_enum (_tmp15_, "page-side", (gint) _tmp16_);
#line 1122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp17_ = self->priv->settings;
#line 1122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp18_ = paper_width;
#line 1122 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp17_, "paper-width", _tmp18_);
#line 1123 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp19_ = self->priv->settings;
#line 1123 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp20_ = paper_height;
#line 1123 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp19_, "paper-height", _tmp20_);
#line 1124 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp21_ = self->priv->settings;
#line 1124 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp22_ = self->priv->window_width;
#line 1124 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp21_, "window-width", _tmp22_);
#line 1125 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp23_ = self->priv->settings;
#line 1125 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp24_ = self->priv->window_height;
#line 1125 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp23_, "window-height", _tmp24_);
#line 1126 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp25_ = self->priv->settings;
#line 1126 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp26_ = self->priv->window_is_maximized;
#line 1126 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_boolean (_tmp25_, "window-is-maximized", _tmp26_);
#line 1127 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp27_ = self->priv->settings;
#line 1127 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp28_ = self->priv->default_page_scan_direction;
#line 1127 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_enum (_tmp27_, "scan-direction", (gint) _tmp28_);
#line 1128 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp29_ = self->priv->settings;
#line 1128 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp30_ = self->priv->default_page_width;
#line 1128 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp29_, "page-width", _tmp30_);
#line 1129 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp31_ = self->priv->settings;
#line 1129 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp32_ = self->priv->default_page_height;
#line 1129 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp31_, "page-height", _tmp32_);
#line 1130 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp33_ = self->priv->settings;
#line 1130 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp34_ = self->priv->default_page_dpi;
#line 1130 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_settings_set_int (_tmp33_, "page-dpi", _tmp34_);
#line 1132 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_emit_by_name (self, "quit");
#line 1134 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = TRUE;
#line 1134 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (device);
#line 1134 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 5186 "ui.c"
}


void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
#line 1138 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1138 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1140 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_on_quit (self);
#line 5197 "ui.c"
}


gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, SimpleScan* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1144 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1144 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1144 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1146 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->window_is_maximized;
#line 1146 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!_tmp0_) {
#line 5214 "ui.c"
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 1148 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp1_ = event;
#line 1148 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = _tmp1_->width;
#line 1148 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->window_width = _tmp2_;
#line 1149 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = event;
#line 1149 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = _tmp3_->height;
#line 1149 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->window_height = _tmp4_;
#line 5231 "ui.c"
	}
#line 1152 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = FALSE;
#line 1152 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 5237 "ui.c"
}


static void simple_scan_info_bar_response_cb (SimpleScan* self, GtkInfoBar* widget, gint response_id) {
	gint _tmp0_ = 0;
#line 1155 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1155 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1157 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = response_id;
#line 1157 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp0_ == 1) {
#line 5251 "ui.c"
		GtkComboBox* _tmp1_ = NULL;
		GtkDialog* _tmp2_ = NULL;
#line 1159 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 1159 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 1160 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = self->priv->preferences_dialog;
#line 1160 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 5262 "ui.c"
	} else {
#line 1164 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->have_error = FALSE;
#line 1165 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (self->priv->error_title);
#line 1165 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->error_title = NULL;
#line 1166 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (self->priv->error_text);
#line 1166 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->error_text = NULL;
#line 1167 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_update_info_bar (self);
#line 5276 "ui.c"
	}
}


gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, SimpleScan* self) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 1172 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1172 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1172 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1174 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = event;
#line 1174 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 1174 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 5297 "ui.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 1175 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp2_ = event;
#line 1175 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 1175 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 5306 "ui.c"
	}
#line 1176 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = FALSE;
#line 1176 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 5312 "ui.c"
}


gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, SimpleScan* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1180 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1180 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1180 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1182 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = simple_scan_on_quit (self);
#line 1182 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = !_tmp0_;
#line 1182 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 5331 "ui.c"
}


static void simple_scan_page_size_changed_cb (SimpleScan* self, Page* page) {
	Page* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 1185 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1185 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1187 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = page;
#line 1187 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1187 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_width = _tmp1_;
#line 1188 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = page;
#line 1188 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 1188 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_height = _tmp3_;
#line 1189 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = page;
#line 1189 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = page_get_dpi (_tmp4_);
#line 1189 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_dpi = _tmp5_;
#line 5364 "ui.c"
}


static void simple_scan_page_scan_direction_changed_cb (SimpleScan* self, Page* page) {
	Page* _tmp0_ = NULL;
	ScanDirection _tmp1_ = 0;
#line 1192 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1192 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1194 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = page;
#line 1194 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 1194 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp1_;
#line 5381 "ui.c"
}


static void _simple_scan_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 1203 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_page_size_changed_cb ((SimpleScan*) self, _sender);
#line 5388 "ui.c"
}


static void _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 1204 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_page_scan_direction_changed_cb ((SimpleScan*) self, _sender);
#line 5395 "ui.c"
}


static void simple_scan_page_added_cb (SimpleScan* self, Book* book, Page* page) {
	Page* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Page* _tmp6_ = NULL;
	ScanDirection _tmp7_ = 0;
	Page* _tmp8_ = NULL;
	Page* _tmp9_ = NULL;
#line 1197 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1197 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1197 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = page;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_width = _tmp1_;
#line 1200 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = page;
#line 1200 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 1200 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_height = _tmp3_;
#line 1201 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = page;
#line 1201 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = page_get_dpi (_tmp4_);
#line 1201 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_dpi = _tmp5_;
#line 1202 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = page;
#line 1202 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = page_get_scan_direction (_tmp6_);
#line 1202 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp7_;
#line 1203 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = page;
#line 1203 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp8_, "size-changed", (GCallback) _simple_scan_page_size_changed_cb_page_size_changed, self);
#line 1204 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = page;
#line 1204 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp9_, "scan-direction-changed", (GCallback) _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1206 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_update_page_menu (self);
#line 5450 "ui.c"
}


static void simple_scan_page_removed_cb (SimpleScan* self, Book* book, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Book* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
#line 1209 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1209 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1209 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1211 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = page;
#line 1211 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 1211 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _simple_scan_page_size_changed_cb_page_size_changed, self);
#line 1212 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = page;
#line 1212 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 1212 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = book;
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = book_get_n_pages (_tmp4_);
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp5_ == ((guint) 1)) {
#line 1216 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_add_default_page (self);
#line 5487 "ui.c"
	}
#line 1218 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_update_page_menu (self);
#line 5491 "ui.c"
}


static void simple_scan_set_dpi_combo (SimpleScan* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkListStore* _tmp7_ = NULL;
	gint* scan_resolutions = NULL;
	gint* _tmp8_ = NULL;
	gint scan_resolutions_length1 = 0;
	gint _scan_resolutions_size_ = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (combo != NULL);
#line 1223 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1223 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1223 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	renderer = _tmp0_;
#line 1224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = combo;
#line 1224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = renderer;
#line 1224 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) _tmp2_, TRUE);
#line 1225 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = combo;
#line 1225 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = renderer;
#line 1225 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) _tmp4_, "text", 1);
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = combo;
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	model = _tmp7_;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = g_new0 (gint, 6);
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_[0] = 75;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_[1] = 150;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_[2] = 300;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_[3] = 600;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_[4] = 1200;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_[5] = 2400;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	scan_resolutions = _tmp8_;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	scan_resolutions_length1 = 6;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_scan_resolutions_size_ = scan_resolutions_length1;
#line 1229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = scan_resolutions;
#line 1229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9__length1 = scan_resolutions_length1;
#line 5566 "ui.c"
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
#line 1229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		dpi_collection = _tmp9_;
#line 1229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		dpi_collection_length1 = _tmp9__length1;
#line 1229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		for (dpi_it = 0; dpi_it < _tmp9__length1; dpi_it = dpi_it + 1) {
#line 5578 "ui.c"
			gint dpi = 0;
#line 1229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			dpi = dpi_collection[dpi_it];
#line 5582 "ui.c"
			{
				gchar* label = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp26_ = NULL;
				GtkTreeIter _tmp27_ = {0};
				GtkListStore* _tmp28_ = NULL;
				GtkTreeIter _tmp29_ = {0};
				gint _tmp30_ = 0;
				const gchar* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
#line 1232 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp10_ = dpi;
#line 1232 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp11_ = default_dpi;
#line 1232 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (_tmp10_ == _tmp11_) {
#line 5602 "ui.c"
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gchar* _tmp14_ = NULL;
#line 1234 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp12_ = _ ("%d dpi (default)");
#line 1234 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp13_ = dpi;
#line 1234 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
#line 1234 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_g_free0 (label);
#line 1234 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					label = _tmp14_;
#line 5616 "ui.c"
				} else {
					gint _tmp15_ = 0;
#line 1235 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp15_ = dpi;
#line 1235 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					if (_tmp15_ == 75) {
#line 5623 "ui.c"
						const gchar* _tmp16_ = NULL;
						gint _tmp17_ = 0;
						gchar* _tmp18_ = NULL;
#line 1237 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp16_ = _ ("%d dpi (draft)");
#line 1237 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp17_ = dpi;
#line 1237 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 1237 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_g_free0 (label);
#line 1237 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						label = _tmp18_;
#line 5637 "ui.c"
					} else {
						gint _tmp19_ = 0;
#line 1238 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						_tmp19_ = dpi;
#line 1238 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
						if (_tmp19_ == 1200) {
#line 5644 "ui.c"
							const gchar* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gchar* _tmp22_ = NULL;
#line 1240 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp20_ = _ ("%d dpi (high resolution)");
#line 1240 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp21_ = dpi;
#line 1240 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
#line 1240 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_g_free0 (label);
#line 1240 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							label = _tmp22_;
#line 5658 "ui.c"
						} else {
							const gchar* _tmp23_ = NULL;
							gint _tmp24_ = 0;
							gchar* _tmp25_ = NULL;
#line 1243 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp23_ = _ ("%d dpi");
#line 1243 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp24_ = dpi;
#line 1243 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_tmp25_ = g_strdup_printf (_tmp23_, _tmp24_);
#line 1243 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							_g_free0 (label);
#line 1243 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
							label = _tmp25_;
#line 5673 "ui.c"
						}
					}
				}
#line 1246 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp26_ = model;
#line 1246 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				gtk_list_store_append (_tmp26_, &_tmp27_);
#line 1246 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				iter = _tmp27_;
#line 1247 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp28_ = model;
#line 1247 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp29_ = iter;
#line 1247 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp30_ = dpi;
#line 1247 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp31_ = label;
#line 1247 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, 1, _tmp31_, -1, -1);
#line 1249 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp32_ = dpi;
#line 1249 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_tmp33_ = current_dpi;
#line 1249 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				if (_tmp32_ == _tmp33_) {
#line 5699 "ui.c"
					GtkComboBox* _tmp34_ = NULL;
					GtkTreeIter _tmp35_ = {0};
#line 1250 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp34_ = combo;
#line 1250 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					_tmp35_ = iter;
#line 1250 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp34_, &_tmp35_);
#line 5708 "ui.c"
				}
#line 1229 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
				_g_free0 (label);
#line 5712 "ui.c"
			}
		}
	}
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	scan_resolutions = (g_free (scan_resolutions), NULL);
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (model);
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (renderer);
#line 5722 "ui.c"
}


static void simple_scan_needs_saving_cb (SimpleScan* self, Book* book) {
	GtkMenuItem* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkToolButton* _tmp3_ = NULL;
	Book* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	Book* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 1254 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1254 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1256 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->save_menuitem;
#line 1256 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = book;
#line 1256 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = book_get_needs_saving (_tmp1_);
#line 1256 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_);
#line 1257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->save_toolbutton;
#line 1257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = book;
#line 1257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = book_get_needs_saving (_tmp4_);
#line 1257 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_);
#line 1258 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = book;
#line 1258 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp7_ = book_get_needs_saving (_tmp6_);
#line 1258 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp7_) {
#line 5761 "ui.c"
		GtkMenuItem* _tmp8_ = NULL;
#line 1259 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp8_ = self->priv->save_as_menuitem;
#line 1259 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
#line 5767 "ui.c"
	}
}


static void _simple_scan_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
#line 1321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_info_bar_response_cb ((SimpleScan*) self, _sender, response_id);
#line 5775 "ui.c"
}


static void _simple_scan_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
#line 1398 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_page_selected_cb ((SimpleScan*) self, _sender, page);
#line 5782 "ui.c"
}


static void _simple_scan_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
#line 1399 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_show_page_cb ((SimpleScan*) self, _sender, page);
#line 5789 "ui.c"
}


static void _simple_scan_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
#line 1400 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_show_page_menu_cb ((SimpleScan*) self, _sender);
#line 5796 "ui.c"
}


static void _simple_scan_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
#line 1434 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_needs_saving_cb ((SimpleScan*) self, _sender);
#line 5803 "ui.c"
}


static void simple_scan_load (SimpleScan* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	gchar* filename = NULL;
	gchar* _tmp2_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GtkWindow* _tmp11_ = NULL;
	GtkBuilder* _tmp12_ = NULL;
	GObject* _tmp13_ = NULL;
	GtkVBox* _tmp14_ = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GtkMenuItem* _tmp17_ = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GtkMenuItem* _tmp20_ = NULL;
	GtkBuilder* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GtkMenuItem* _tmp23_ = NULL;
	GtkBuilder* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_ = NULL;
	GtkBuilder* _tmp27_ = NULL;
	GObject* _tmp28_ = NULL;
	GtkMenuItem* _tmp29_ = NULL;
	GtkBuilder* _tmp30_ = NULL;
	GObject* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_ = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkToolButton* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkMenuItem* _tmp38_ = NULL;
	GtkBuilder* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkToolButton* _tmp41_ = NULL;
	GtkBuilder* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkRadioMenuItem* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	GtkRadioMenuItem* _tmp47_ = NULL;
	GtkBuilder* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GtkRadioMenuItem* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GObject* _tmp52_ = NULL;
	GtkRadioMenuItem* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkDialog* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GtkLabel* _tmp59_ = NULL;
	GtkBuilder* _tmp60_ = NULL;
	GObject* _tmp61_ = NULL;
	GtkEntry* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkEntry* _tmp65_ = NULL;
	GtkBuilder* _tmp66_ = NULL;
	GObject* _tmp67_ = NULL;
	GtkDialog* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GObject* _tmp70_ = NULL;
	GtkComboBox* _tmp71_ = NULL;
	GtkComboBox* _tmp72_ = NULL;
	GtkTreeModel* _tmp73_ = NULL;
	GtkListStore* _tmp74_ = NULL;
	GtkBuilder* _tmp75_ = NULL;
	GObject* _tmp76_ = NULL;
	GtkComboBox* _tmp77_ = NULL;
	GtkComboBox* _tmp78_ = NULL;
	GtkTreeModel* _tmp79_ = NULL;
	GtkListStore* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	GObject* _tmp82_ = NULL;
	GtkComboBox* _tmp83_ = NULL;
	GtkComboBox* _tmp84_ = NULL;
	GtkTreeModel* _tmp85_ = NULL;
	GtkListStore* _tmp86_ = NULL;
	GtkBuilder* _tmp87_ = NULL;
	GObject* _tmp88_ = NULL;
	GtkComboBox* _tmp89_ = NULL;
	GtkComboBox* _tmp90_ = NULL;
	GtkTreeModel* _tmp91_ = NULL;
	GtkListStore* _tmp92_ = NULL;
	GtkBuilder* _tmp93_ = NULL;
	GObject* _tmp94_ = NULL;
	GtkComboBox* _tmp95_ = NULL;
	GtkComboBox* _tmp96_ = NULL;
	GtkTreeModel* _tmp97_ = NULL;
	GtkListStore* _tmp98_ = NULL;
	GtkInfoBar* _tmp99_ = NULL;
	GtkInfoBar* _tmp100_ = NULL;
	GtkVBox* _tmp101_ = NULL;
	GtkInfoBar* _tmp102_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp103_ = NULL;
	GtkContainer* content_area = NULL;
	GtkInfoBar* _tmp104_ = NULL;
	GtkContainer* _tmp105_ = NULL;
	GtkContainer* _tmp106_ = NULL;
	GtkContainer* _tmp107_ = NULL;
	GtkBox* _tmp108_ = NULL;
	GtkBox* _tmp109_ = NULL;
	GtkImage* _tmp110_ = NULL;
	GtkBox* _tmp111_ = NULL;
	GtkImage* _tmp112_ = NULL;
	GtkImage* _tmp113_ = NULL;
	GtkLabel* _tmp114_ = NULL;
	GtkLabel* _tmp115_ = NULL;
	GtkBox* _tmp116_ = NULL;
	GtkLabel* _tmp117_ = NULL;
	GtkLabel* _tmp118_ = NULL;
	GtkInfoBar* _tmp119_ = NULL;
	GtkButton* _tmp120_ = NULL;
	GtkButton* _tmp121_ = NULL;
	GtkInfoBar* _tmp122_ = NULL;
	const gchar* _tmp123_ = NULL;
	GtkButton* _tmp124_ = NULL;
	GtkButton* _tmp125_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp126_ = NULL;
	GtkTreeIter _tmp127_ = {0};
	GtkListStore* _tmp128_ = NULL;
	GtkTreeIter _tmp129_ = {0};
	const gchar* _tmp130_ = NULL;
	GtkListStore* _tmp131_ = NULL;
	GtkTreeIter _tmp132_ = {0};
	GtkListStore* _tmp133_ = NULL;
	GtkTreeIter _tmp134_ = {0};
	GtkListStore* _tmp135_ = NULL;
	GtkTreeIter _tmp136_ = {0};
	GtkListStore* _tmp137_ = NULL;
	GtkTreeIter _tmp138_ = {0};
	GtkListStore* _tmp139_ = NULL;
	GtkTreeIter _tmp140_ = {0};
	GtkListStore* _tmp141_ = NULL;
	GtkTreeIter _tmp142_ = {0};
	GtkListStore* _tmp143_ = NULL;
	GtkTreeIter _tmp144_ = {0};
	GtkListStore* _tmp145_ = NULL;
	GtkTreeIter _tmp146_ = {0};
	GtkListStore* _tmp147_ = NULL;
	GtkTreeIter _tmp148_ = {0};
	GtkListStore* _tmp149_ = NULL;
	GtkTreeIter _tmp150_ = {0};
	GtkListStore* _tmp151_ = NULL;
	GtkTreeIter _tmp152_ = {0};
	GtkListStore* _tmp153_ = NULL;
	GtkTreeIter _tmp154_ = {0};
	gint dpi = 0;
	GSettings* _tmp155_ = NULL;
	gint _tmp156_ = 0;
	gint _tmp157_ = 0;
	GtkComboBox* _tmp158_ = NULL;
	gint _tmp159_ = 0;
	GSettings* _tmp160_ = NULL;
	gint _tmp161_ = 0;
	gint _tmp162_ = 0;
	GtkComboBox* _tmp163_ = NULL;
	gint _tmp164_ = 0;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp165_ = NULL;
	GtkComboBox* _tmp166_ = NULL;
	GtkCellRendererText* _tmp167_ = NULL;
	GtkComboBox* _tmp168_ = NULL;
	GtkCellRendererText* _tmp169_ = NULL;
	GtkCellRendererText* _tmp170_ = NULL;
	GtkComboBox* _tmp171_ = NULL;
	GtkCellRendererText* _tmp172_ = NULL;
	GtkComboBox* _tmp173_ = NULL;
	GtkCellRendererText* _tmp174_ = NULL;
	GSettings* _tmp175_ = NULL;
	gint _tmp176_ = 0;
	GtkCellRendererText* _tmp177_ = NULL;
	GtkComboBox* _tmp178_ = NULL;
	GtkCellRendererText* _tmp179_ = NULL;
	GtkComboBox* _tmp180_ = NULL;
	GtkCellRendererText* _tmp181_ = NULL;
	gint paper_width = 0;
	GSettings* _tmp182_ = NULL;
	gint _tmp183_ = 0;
	gint paper_height = 0;
	GSettings* _tmp184_ = NULL;
	gint _tmp185_ = 0;
	gint _tmp186_ = 0;
	gint _tmp187_ = 0;
	gchar* device = NULL;
	GSettings* _tmp188_ = NULL;
	gchar* _tmp189_ = NULL;
	const gchar* _tmp190_ = NULL;
	gchar* document_type = NULL;
	GSettings* _tmp196_ = NULL;
	gchar* _tmp197_ = NULL;
	const gchar* _tmp198_ = NULL;
	Book* _tmp200_ = NULL;
	BookView* _tmp201_ = NULL;
	BookView* _tmp202_ = NULL;
	GtkVBox* _tmp203_ = NULL;
	BookView* _tmp204_ = NULL;
	BookView* _tmp205_ = NULL;
	BookView* _tmp206_ = NULL;
	BookView* _tmp207_ = NULL;
	BookView* _tmp208_ = NULL;
	GSettings* _tmp209_ = NULL;
	gint _tmp210_ = 0;
	GSettings* _tmp211_ = NULL;
	gint _tmp212_ = 0;
	gint _tmp213_ = 0;
	GSettings* _tmp214_ = NULL;
	gint _tmp215_ = 0;
	gint _tmp216_ = 0;
	GSettings* _tmp217_ = NULL;
	gint _tmp218_ = 0;
	gint _tmp219_ = 0;
	GSettings* _tmp220_ = NULL;
	gint _tmp221_ = 0;
	gint _tmp222_ = 0;
	GSettings* _tmp223_ = NULL;
	gint _tmp224_ = 0;
	gint _tmp225_ = 0;
	gint _tmp226_ = 0;
	gint _tmp227_ = 0;
	GtkWindow* _tmp228_ = NULL;
	gint _tmp229_ = 0;
	gint _tmp230_ = 0;
	GSettings* _tmp231_ = NULL;
	gboolean _tmp232_ = FALSE;
	gboolean _tmp233_ = FALSE;
	Book* _tmp235_ = NULL;
	guint _tmp236_ = 0U;
	Book* _tmp237_ = NULL;
	Book* _tmp238_ = NULL;
	GError * _inner_error_ = NULL;
#line 1262 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1264 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 1264 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
#line 1266 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_window_set_default_icon_name ("scanner");
#line 1268 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = gtk_builder_new ();
#line 1268 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 1268 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->builder = _tmp1_;
#line 1269 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = g_build_filename (UI_DIR, "simple-scan.ui", NULL, NULL);
#line 1269 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	filename = _tmp2_;
#line 6064 "ui.c"
	{
		GtkBuilder* _tmp3_ = NULL;
#line 1272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp3_ = self->priv->builder;
#line 1272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_builder_add_from_file (_tmp3_, filename, &_inner_error_);
#line 1272 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 6073 "ui.c"
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		e = _inner_error_;
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_inner_error_ = NULL;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp4_ = e;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_critical ("ui.vala:1276: Unable to load UI %s: %s\n", filename, _tmp5_);
#line 1277 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp6_ = _ ("Files missing");
#line 1277 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp7_ = _ ("Please check your installation");
#line 1277 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_show_error_dialog (self, _tmp6_, _tmp7_);
#line 1281 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		exit (EXIT_FAILURE);
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_error_free0 (e);
#line 6105 "ui.c"
	}
	__finally21:
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_g_free0 (filename);
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return;
#line 6118 "ui.c"
	}
#line 1283 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp8_ = self->priv->builder;
#line 1283 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_builder_connect_signals (_tmp8_, self);
#line 1285 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp9_ = self->priv->builder;
#line 1285 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp10_ = gtk_builder_get_object (_tmp9_, "simple_scan_window");
#line 1285 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_WINDOW, GtkWindow));
#line 1285 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 1285 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->window = _tmp11_;
#line 1286 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp12_ = self->priv->builder;
#line 1286 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp13_ = gtk_builder_get_object (_tmp12_, "main_vbox");
#line 1286 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GTK_TYPE_VBOX, GtkVBox));
#line 1286 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 1286 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->main_vbox = _tmp14_;
#line 1287 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp15_ = self->priv->builder;
#line 1287 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp16_ = gtk_builder_get_object (_tmp15_, "page_move_left_menuitem");
#line 1287 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1287 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 1287 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->page_move_left_menuitem = _tmp17_;
#line 1288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp18_ = self->priv->builder;
#line 1288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "page_move_right_menuitem");
#line 1288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 1288 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->page_move_right_menuitem = _tmp20_;
#line 1289 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp21_ = self->priv->builder;
#line 1289 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp22_ = gtk_builder_get_object (_tmp21_, "page_delete_menuitem");
#line 1289 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1289 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 1289 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->page_delete_menuitem = _tmp23_;
#line 1290 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp24_ = self->priv->builder;
#line 1290 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp25_ = gtk_builder_get_object (_tmp24_, "crop_rotate_menuitem");
#line 1290 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1290 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 1290 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->crop_rotate_menuitem = _tmp26_;
#line 1291 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp27_ = self->priv->builder;
#line 1291 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp28_ = gtk_builder_get_object (_tmp27_, "save_menuitem");
#line 1291 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1291 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 1291 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->save_menuitem = _tmp29_;
#line 1292 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp30_ = self->priv->builder;
#line 1292 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "save_as_menuitem");
#line 1292 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1292 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 1292 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->save_as_menuitem = _tmp32_;
#line 1293 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp33_ = self->priv->builder;
#line 1293 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "save_toolbutton");
#line 1293 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1293 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 1293 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->save_toolbutton = _tmp35_;
#line 1294 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp36_ = self->priv->builder;
#line 1294 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp37_ = gtk_builder_get_object (_tmp36_, "stop_scan_menuitem");
#line 1294 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1294 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 1294 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->stop_menuitem = _tmp38_;
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp39_ = self->priv->builder;
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp40_ = gtk_builder_get_object (_tmp39_, "stop_toolbutton");
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->stop_toolbutton = _tmp41_;
#line 1297 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp42_ = self->priv->builder;
#line 1297 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp43_ = gtk_builder_get_object (_tmp42_, "text_toolbutton_menuitem");
#line 1297 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1297 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 1297 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->text_toolbar_menuitem = _tmp44_;
#line 1298 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp45_ = self->priv->builder;
#line 1298 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp46_ = gtk_builder_get_object (_tmp45_, "text_menuitem");
#line 1298 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1298 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 1298 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->text_menu_menuitem = _tmp47_;
#line 1299 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp48_ = self->priv->builder;
#line 1299 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "photo_toolbutton_menuitem");
#line 1299 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1299 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 1299 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->photo_toolbar_menuitem = _tmp50_;
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp51_ = self->priv->builder;
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp52_ = gtk_builder_get_object (_tmp51_, "photo_menuitem");
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->photo_menu_menuitem = _tmp53_;
#line 1302 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp54_ = self->priv->builder;
#line 1302 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "authorize_dialog");
#line 1302 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GTK_TYPE_DIALOG, GtkDialog));
#line 1302 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 1302 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->authorize_dialog = _tmp56_;
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp57_ = self->priv->builder;
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp58_ = gtk_builder_get_object (_tmp57_, "authorize_label");
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GTK_TYPE_LABEL, GtkLabel));
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->authorize_label = _tmp59_;
#line 1304 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp60_ = self->priv->builder;
#line 1304 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp61_ = gtk_builder_get_object (_tmp60_, "username_entry");
#line 1304 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GTK_TYPE_ENTRY, GtkEntry));
#line 1304 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 1304 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->username_entry = _tmp62_;
#line 1305 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp63_ = self->priv->builder;
#line 1305 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp64_ = gtk_builder_get_object (_tmp63_, "password_entry");
#line 1305 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GTK_TYPE_ENTRY, GtkEntry));
#line 1305 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 1305 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->password_entry = _tmp65_;
#line 1307 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp66_ = self->priv->builder;
#line 1307 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "preferences_dialog");
#line 1307 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GTK_TYPE_DIALOG, GtkDialog));
#line 1307 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1307 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->preferences_dialog = _tmp68_;
#line 1308 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp69_ = self->priv->builder;
#line 1308 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp70_ = gtk_builder_get_object (_tmp69_, "device_combo");
#line 1308 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1308 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 1308 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->device_combo = _tmp71_;
#line 1309 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp72_ = self->priv->device_combo;
#line 1309 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp73_ = gtk_combo_box_get_model (_tmp72_);
#line 1309 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1309 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 1309 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->device_model = _tmp74_;
#line 1310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp75_ = self->priv->builder;
#line 1310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp76_ = gtk_builder_get_object (_tmp75_, "text_dpi_combo");
#line 1310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 1310 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->text_dpi_combo = _tmp77_;
#line 1311 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp78_ = self->priv->text_dpi_combo;
#line 1311 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp79_ = gtk_combo_box_get_model (_tmp78_);
#line 1311 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1311 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 1311 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->text_dpi_model = _tmp80_;
#line 1312 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp81_ = self->priv->builder;
#line 1312 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp82_ = gtk_builder_get_object (_tmp81_, "photo_dpi_combo");
#line 1312 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1312 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 1312 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->photo_dpi_combo = _tmp83_;
#line 1313 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp84_ = self->priv->photo_dpi_combo;
#line 1313 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp85_ = gtk_combo_box_get_model (_tmp84_);
#line 1313 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1313 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 1313 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->photo_dpi_model = _tmp86_;
#line 1314 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp87_ = self->priv->builder;
#line 1314 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp88_ = gtk_builder_get_object (_tmp87_, "page_side_combo");
#line 1314 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp89_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1314 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 1314 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->page_side_combo = _tmp89_;
#line 1315 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp90_ = self->priv->page_side_combo;
#line 1315 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp91_ = gtk_combo_box_get_model (_tmp90_);
#line 1315 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1315 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 1315 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->page_side_model = _tmp92_;
#line 1316 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp93_ = self->priv->builder;
#line 1316 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp94_ = gtk_builder_get_object (_tmp93_, "paper_size_combo");
#line 1316 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1316 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 1316 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->paper_size_combo = _tmp95_;
#line 1317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp96_ = self->priv->paper_size_combo;
#line 1317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp97_ = gtk_combo_box_get_model (_tmp96_);
#line 1317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 1317 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->paper_size_model = _tmp98_;
#line 1320 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp99_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 1320 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp99_);
#line 1320 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 1320 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->info_bar = _tmp99_;
#line 1321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp100_ = self->priv->info_bar;
#line 1321 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp100_, "response", (GCallback) _simple_scan_info_bar_response_cb_gtk_info_bar_response, self);
#line 1322 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp101_ = self->priv->main_vbox;
#line 1322 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp102_ = self->priv->info_bar;
#line 1322 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_box_pack_start ((GtkBox*) _tmp101_, (GtkWidget*) _tmp102_, FALSE, TRUE, (guint) 0);
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp103_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp103_);
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	hbox = _tmp103_;
#line 1324 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp104_ = self->priv->info_bar;
#line 1324 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp105_ = gtk_info_bar_get_content_area (_tmp104_);
#line 1324 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp106_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, GTK_TYPE_CONTAINER, GtkContainer));
#line 1324 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	content_area = _tmp106_;
#line 1325 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp107_ = content_area;
#line 1325 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp108_ = hbox;
#line 1325 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_container_add (_tmp107_, (GtkWidget*) _tmp108_);
#line 1326 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp109_ = hbox;
#line 1326 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp109_);
#line 1328 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp110_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
#line 1328 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp110_);
#line 1328 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 1328 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->info_bar_image = _tmp110_;
#line 1329 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp111_ = hbox;
#line 1329 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp112_ = self->priv->info_bar_image;
#line 1329 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_box_pack_start (_tmp111_, (GtkWidget*) _tmp112_, FALSE, TRUE, (guint) 0);
#line 1330 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp113_ = self->priv->info_bar_image;
#line 1330 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp113_);
#line 1332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp114_ = (GtkLabel*) gtk_label_new (NULL);
#line 1332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp114_);
#line 1332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 1332 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->info_bar_label = _tmp114_;
#line 1333 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp115_ = self->priv->info_bar_label;
#line 1333 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp115_, 0.0f, 0.5f);
#line 1334 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp116_ = hbox;
#line 1334 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp117_ = self->priv->info_bar_label;
#line 1334 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_box_pack_start (_tmp116_, (GtkWidget*) _tmp117_, TRUE, TRUE, (guint) 0);
#line 1335 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp118_ = self->priv->info_bar_label;
#line 1335 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp118_);
#line 1337 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp119_ = self->priv->info_bar;
#line 1337 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp120_ = gtk_info_bar_add_button (_tmp119_, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
#line 1337 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp121_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, GTK_TYPE_BUTTON, GtkButton));
#line 1337 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 1337 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->info_bar_close_button = _tmp121_;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp122_ = self->priv->info_bar;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp123_ = _ ("Change _Scanner");
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp124_ = gtk_info_bar_add_button (_tmp122_, _tmp123_, 1);
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp125_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, GTK_TYPE_BUTTON, GtkButton));
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->info_bar_change_scanner_button = _tmp125_;
#line 1342 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp126_ = self->priv->paper_size_model;
#line 1342 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp126_, &_tmp127_);
#line 1342 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp127_;
#line 1343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp128_ = self->priv->paper_size_model;
#line 1343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp129_ = iter;
#line 1343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp130_ = _ ("Automatic");
#line 1343 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp128_, &_tmp129_, 0, 0, 1, 0, 2, _tmp130_, -1, -1);
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp131_ = self->priv->paper_size_model;
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp131_, &_tmp132_);
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp132_;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp133_ = self->priv->paper_size_model;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp134_ = iter;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp133_, &_tmp134_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
#line 1348 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp135_ = self->priv->paper_size_model;
#line 1348 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp135_, &_tmp136_);
#line 1348 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp136_;
#line 1349 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp137_ = self->priv->paper_size_model;
#line 1349 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp138_ = iter;
#line 1349 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp137_, &_tmp138_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
#line 1350 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp139_ = self->priv->paper_size_model;
#line 1350 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp139_, &_tmp140_);
#line 1350 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp140_;
#line 1351 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp141_ = self->priv->paper_size_model;
#line 1351 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp142_ = iter;
#line 1351 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp141_, &_tmp142_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp143_ = self->priv->paper_size_model;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp143_, &_tmp144_);
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp144_;
#line 1353 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp145_ = self->priv->paper_size_model;
#line 1353 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp146_ = iter;
#line 1353 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp145_, &_tmp146_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
#line 1354 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp147_ = self->priv->paper_size_model;
#line 1354 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp147_, &_tmp148_);
#line 1354 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp148_;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp149_ = self->priv->paper_size_model;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp150_ = iter;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp149_, &_tmp150_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
#line 1356 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp151_ = self->priv->paper_size_model;
#line 1356 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_append (_tmp151_, &_tmp152_);
#line 1356 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	iter = _tmp152_;
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp153_ = self->priv->paper_size_model;
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp154_ = iter;
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_list_store_set (_tmp153_, &_tmp154_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
#line 1359 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp155_ = self->priv->settings;
#line 1359 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp156_ = g_settings_get_int (_tmp155_, "text-dpi");
#line 1359 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	dpi = _tmp156_;
#line 1360 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp157_ = dpi;
#line 1360 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp157_ <= 0) {
#line 1361 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		dpi = SIMPLE_SCAN_DEFAULT_TEXT_DPI;
#line 6626 "ui.c"
	}
#line 1362 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp158_ = self->priv->text_dpi_combo;
#line 1362 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp159_ = dpi;
#line 1362 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_set_dpi_combo (self, _tmp158_, SIMPLE_SCAN_DEFAULT_TEXT_DPI, _tmp159_);
#line 1363 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp160_ = self->priv->settings;
#line 1363 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp161_ = g_settings_get_int (_tmp160_, "photo-dpi");
#line 1363 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	dpi = _tmp161_;
#line 1364 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp162_ = dpi;
#line 1364 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp162_ <= 0) {
#line 1365 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		dpi = SIMPLE_SCAN_DEFAULT_PHOTO_DPI;
#line 6646 "ui.c"
	}
#line 1366 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp163_ = self->priv->photo_dpi_combo;
#line 1366 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp164_ = dpi;
#line 1366 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_set_dpi_combo (self, _tmp163_, SIMPLE_SCAN_DEFAULT_PHOTO_DPI, _tmp164_);
#line 1368 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp165_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1368 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp165_);
#line 1368 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	renderer = _tmp165_;
#line 1369 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp166_ = self->priv->device_combo;
#line 1369 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp167_ = renderer;
#line 1369 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp166_, (GtkCellRenderer*) _tmp167_, TRUE);
#line 1370 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp168_ = self->priv->device_combo;
#line 1370 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp169_ = renderer;
#line 1370 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp168_, (GtkCellRenderer*) _tmp169_, "text", 1);
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp170_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp170_);
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	renderer = _tmp170_;
#line 1373 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp171_ = self->priv->page_side_combo;
#line 1373 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp172_ = renderer;
#line 1373 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp171_, (GtkCellRenderer*) _tmp172_, TRUE);
#line 1374 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp173_ = self->priv->page_side_combo;
#line 1374 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp174_ = renderer;
#line 1374 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp173_, (GtkCellRenderer*) _tmp174_, "text", 1);
#line 1375 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp175_ = self->priv->settings;
#line 1375 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp176_ = g_settings_get_enum (_tmp175_, "page-side");
#line 1375 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_set_page_side (self, (ScanType) _tmp176_);
#line 1377 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp177_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1377 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp177_);
#line 1377 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1377 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	renderer = _tmp177_;
#line 1378 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp178_ = self->priv->paper_size_combo;
#line 1378 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp179_ = renderer;
#line 1378 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp178_, (GtkCellRenderer*) _tmp179_, TRUE);
#line 1379 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp180_ = self->priv->paper_size_combo;
#line 1379 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp181_ = renderer;
#line 1379 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp180_, (GtkCellRenderer*) _tmp181_, "text", 2);
#line 1380 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp182_ = self->priv->settings;
#line 1380 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp183_ = g_settings_get_int (_tmp182_, "paper-width");
#line 1380 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	paper_width = _tmp183_;
#line 1381 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp184_ = self->priv->settings;
#line 1381 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp185_ = g_settings_get_int (_tmp184_, "paper-height");
#line 1381 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	paper_height = _tmp185_;
#line 1382 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp186_ = paper_width;
#line 1382 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp187_ = paper_height;
#line 1382 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_set_paper_size (self, _tmp186_, _tmp187_);
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp188_ = self->priv->settings;
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp189_ = g_settings_get_string (_tmp188_, "selected-device");
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	device = _tmp189_;
#line 1385 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp190_ = device;
#line 1385 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp190_ != NULL) {
#line 6746 "ui.c"
		const gchar* _tmp191_ = NULL;
		GtkTreeIter _tmp192_ = {0};
		gboolean _tmp193_ = FALSE;
#line 1387 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp191_ = device;
#line 1387 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp193_ = simple_scan_find_scan_device (self, _tmp191_, &_tmp192_);
#line 1387 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		iter = _tmp192_;
#line 1387 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (_tmp193_) {
#line 6758 "ui.c"
			GtkComboBox* _tmp194_ = NULL;
			GtkTreeIter _tmp195_ = {0};
#line 1388 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp194_ = self->priv->device_combo;
#line 1388 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			_tmp195_ = iter;
#line 1388 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			gtk_combo_box_set_active_iter (_tmp194_, &_tmp195_);
#line 6767 "ui.c"
		}
	}
#line 1391 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp196_ = self->priv->settings;
#line 1391 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp197_ = g_settings_get_string (_tmp196_, "document-type");
#line 1391 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	document_type = _tmp197_;
#line 1392 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp198_ = document_type;
#line 1392 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp198_ != NULL) {
#line 6780 "ui.c"
		const gchar* _tmp199_ = NULL;
#line 1393 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp199_ = document_type;
#line 1393 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_set_document_hint (self, _tmp199_);
#line 6786 "ui.c"
	}
#line 1395 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp200_ = self->priv->book;
#line 1395 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp201_ = book_view_new (_tmp200_);
#line 1395 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_object_ref_sink (_tmp201_);
#line 1395 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 1395 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->book_view = _tmp201_;
#line 1396 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp202_ = self->priv->book_view;
#line 1396 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp202_, (guint) 18);
#line 1397 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp203_ = self->priv->main_vbox;
#line 1397 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp204_ = self->priv->book_view;
#line 1397 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_box_pack_end ((GtkBox*) _tmp203_, (GtkWidget*) _tmp204_, TRUE, TRUE, (guint) 0);
#line 1398 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp205_ = self->priv->book_view;
#line 1398 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp205_, "page-selected", (GCallback) _simple_scan_page_selected_cb_book_view_page_selected, self);
#line 1399 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp206_ = self->priv->book_view;
#line 1399 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp206_, "show-page", (GCallback) _simple_scan_show_page_cb_book_view_show_page, self);
#line 1400 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp207_ = self->priv->book_view;
#line 1400 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp207_, "show-menu", (GCallback) _simple_scan_show_page_menu_cb_book_view_show_menu, self);
#line 1401 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp208_ = self->priv->book_view;
#line 1401 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp208_);
#line 1404 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp209_ = self->priv->settings;
#line 1404 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp210_ = g_settings_get_enum (_tmp209_, "scan-direction");
#line 1404 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_scan_direction = (ScanDirection) _tmp210_;
#line 1405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp211_ = self->priv->settings;
#line 1405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp212_ = g_settings_get_int (_tmp211_, "page-width");
#line 1405 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_width = _tmp212_;
#line 1406 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp213_ = self->priv->default_page_width;
#line 1406 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp213_ <= 0) {
#line 1407 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->default_page_width = 595;
#line 6842 "ui.c"
	}
#line 1408 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp214_ = self->priv->settings;
#line 1408 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp215_ = g_settings_get_int (_tmp214_, "page-height");
#line 1408 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_height = _tmp215_;
#line 1409 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp216_ = self->priv->default_page_height;
#line 1409 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp216_ <= 0) {
#line 1410 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->default_page_height = 842;
#line 6856 "ui.c"
	}
#line 1411 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp217_ = self->priv->settings;
#line 1411 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp218_ = g_settings_get_int (_tmp217_, "page-dpi");
#line 1411 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_page_dpi = _tmp218_;
#line 1412 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp219_ = self->priv->default_page_dpi;
#line 1412 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp219_ <= 0) {
#line 1413 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->default_page_dpi = 72;
#line 6870 "ui.c"
	}
#line 1416 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp220_ = self->priv->settings;
#line 1416 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp221_ = g_settings_get_int (_tmp220_, "window-width");
#line 1416 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->window_width = _tmp221_;
#line 1417 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp222_ = self->priv->window_width;
#line 1417 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp222_ <= 0) {
#line 1418 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->window_width = 600;
#line 6884 "ui.c"
	}
#line 1419 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp223_ = self->priv->settings;
#line 1419 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp224_ = g_settings_get_int (_tmp223_, "window-height");
#line 1419 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->window_height = _tmp224_;
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp225_ = self->priv->window_height;
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp225_ <= 0) {
#line 1421 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		self->priv->window_height = 400;
#line 6898 "ui.c"
	}
#line 1422 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp226_ = self->priv->window_width;
#line 1422 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp227_ = self->priv->window_height;
#line 1422 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_debug ("ui.vala:1422: Restoring window to %dx%d pixels", _tmp226_, _tmp227_);
#line 1423 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp228_ = self->priv->window;
#line 1423 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp229_ = self->priv->window_width;
#line 1423 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp230_ = self->priv->window_height;
#line 1423 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_window_set_default_size (_tmp228_, _tmp229_, _tmp230_);
#line 1424 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp231_ = self->priv->settings;
#line 1424 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp232_ = g_settings_get_boolean (_tmp231_, "window-is-maximized");
#line 1424 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->window_is_maximized = _tmp232_;
#line 1425 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp233_ = self->priv->window_is_maximized;
#line 1425 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp233_) {
#line 6924 "ui.c"
		GtkWindow* _tmp234_ = NULL;
#line 1427 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_debug ("ui.vala:1427: Restoring window to maximized");
#line 1428 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		_tmp234_ = self->priv->window;
#line 1428 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		gtk_window_maximize (_tmp234_);
#line 6932 "ui.c"
	}
#line 1431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp235_ = self->priv->book;
#line 1431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp236_ = book_get_n_pages (_tmp235_);
#line 1431 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (_tmp236_ == ((guint) 0)) {
#line 1432 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_add_default_page (self);
#line 6942 "ui.c"
	}
#line 1433 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp237_ = self->priv->book;
#line 1433 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	book_set_needs_saving (_tmp237_, FALSE);
#line 1434 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp238_ = self->priv->book;
#line 1434 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_connect (_tmp238_, "needs-saving-changed", (GCallback) _simple_scan_needs_saving_cb_book_needs_saving_changed, self);
#line 1262 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (document_type);
#line 1262 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (device);
#line 1262 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1262 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (content_area);
#line 1262 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1262 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (filename);
#line 6964 "ui.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 1439 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return self ? book_ref (self) : NULL;
#line 6971 "ui.c"
}


Book* simple_scan_get_book (SimpleScan* self) {
	Book* result = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
#line 1437 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1439 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 1439 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = _book_ref0 (_tmp0_);
#line 1439 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = _tmp1_;
#line 1439 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 6989 "ui.c"
}


void simple_scan_set_selected_page (SimpleScan* self, Page* page) {
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 1442 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1442 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1444 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1444 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = page;
#line 1444 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	book_view_select_page (_tmp0_, _tmp1_);
#line 7006 "ui.c"
}


Page* simple_scan_get_selected_page (SimpleScan* self) {
	Page* result = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 1447 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1449 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1449 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1449 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	result = _tmp1_;
#line 1449 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return result;
#line 7024 "ui.c"
}


void simple_scan_set_scanning (SimpleScan* self, gboolean scanning) {
	gboolean _tmp0_ = FALSE;
	GtkMenuItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkMenuItem* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkToolButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 1452 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1454 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = scanning;
#line 1454 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->scanning = _tmp0_;
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = self->priv->page_delete_menuitem;
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = scanning;
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp2_);
#line 1456 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = self->priv->stop_menuitem;
#line 1456 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = scanning;
#line 1456 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp5_ = self->priv->stop_toolbutton;
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp6_ = scanning;
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
#line 7060 "ui.c"
}


void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 1460 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1460 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 1460 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 1462 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->have_error = TRUE;
#line 1463 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = error_title;
#line 1463 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 1463 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 1463 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->error_title = _tmp1_;
#line 1464 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = error_text;
#line 1464 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1464 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 1464 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->error_text = _tmp3_;
#line 1465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp4_ = change_scanner_hint;
#line 1465 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->error_change_scanner_hint = _tmp4_;
#line 1466 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_update_info_bar (self);
#line 7100 "ui.c"
}


void simple_scan_start (SimpleScan* self) {
	GtkWindow* _tmp0_ = NULL;
#line 1469 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1471 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 1471 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 7112 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 7131 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		data2 = closure->data;
#line 7137 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
#line 7143 "ui.c"
}


static void value_simple_scan_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	value->data[0].v_pointer = NULL;
#line 7150 "ui.c"
}


static void value_simple_scan_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_unref (value->data[0].v_pointer);
#line 7159 "ui.c"
	}
}


static void value_simple_scan_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		dest_value->data[0].v_pointer = simple_scan_ref (src_value->data[0].v_pointer);
#line 7169 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7173 "ui.c"
	}
}


static gpointer value_simple_scan_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return value->data[0].v_pointer;
#line 7181 "ui.c"
}


static gchar* value_simple_scan_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (collect_values[0].v_pointer) {
#line 7188 "ui.c"
		SimpleScan* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7195 "ui.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7199 "ui.c"
		}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		value->data[0].v_pointer = simple_scan_ref (object);
#line 7203 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 7207 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return NULL;
#line 7211 "ui.c"
}


static gchar* value_simple_scan_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SimpleScan** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7222 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		*object_p = NULL;
#line 7228 "ui.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		*object_p = value->data[0].v_pointer;
#line 7232 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		*object_p = simple_scan_ref (value->data[0].v_pointer);
#line 7236 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return NULL;
#line 7240 "ui.c"
}


GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSimpleScan* spec;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SIMPLE_SCAN), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return G_PARAM_SPEC (spec);
#line 7254 "ui.c"
}


gpointer value_get_simple_scan (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return value->data[0].v_pointer;
#line 7263 "ui.c"
}


void value_set_simple_scan (GValue* value, gpointer v_object) {
	SimpleScan* old;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SIMPLE_SCAN));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_ref (value->data[0].v_pointer);
#line 7283 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 7287 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_unref (old);
#line 7293 "ui.c"
	}
}


void value_take_simple_scan (GValue* value, gpointer v_object) {
	SimpleScan* old;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SIMPLE_SCAN));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 7312 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 7316 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		simple_scan_unref (old);
#line 7322 "ui.c"
	}
}


static void simple_scan_class_init (SimpleScanClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	simple_scan_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	SIMPLE_SCAN_CLASS (klass)->finalize = simple_scan_finalize;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_type_class_add_private (klass, sizeof (SimpleScanPrivate));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_new ("start_scan", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_new ("stop_scan", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_new ("email", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_new ("quit", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 7342 "ui.c"
}


static void simple_scan_instance_init (SimpleScan * self) {
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv = SIMPLE_SCAN_GET_PRIVATE (self);
#line 70 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->book_uri = NULL;
#line 79 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = g_strdup ("photo");
#line 79 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->document_hint = _tmp0_;
#line 81 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp1_ = _ ("Scanned Document.pdf");
#line 81 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 81 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->default_file_name = _tmp2_;
#line 82 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->priv->scanning = FALSE;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self->ref_count = 1;
#line 7368 "ui.c"
}


static void simple_scan_finalize (SimpleScan* obj) {
	SimpleScan * self;
	Book* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Book* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SCAN, SimpleScan);
#line 106 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 106 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp1_, NULL, FALSE);
#line 106 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _simple_scan_page_removed_cb_book_page_removed, self);
#line 107 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 107 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp3_, NULL, FALSE);
#line 107 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _simple_scan_page_added_cb_book_page_added, self);
#line 17 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 19 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 21 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 22 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 23 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 24 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 25 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 26 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 27 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 28 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 29 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 30 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 31 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 32 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 33 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 34 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 35 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 36 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 38 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 40 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 41 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 43 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 44 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 45 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 46 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 48 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 49 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 50 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 51 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 52 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 53 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 54 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 55 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 56 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 57 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 58 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 62 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 65 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 66 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 69 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_book_unref0 (self->priv->book);
#line 70 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 72 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 79 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 81 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	_g_free0 (self->priv->default_file_name);
#line 7482 "ui.c"
}


GType simple_scan_get_type (void) {
	static volatile gsize simple_scan_type_id__volatile = 0;
	if (g_once_init_enter (&simple_scan_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_simple_scan_init, value_simple_scan_free_value, value_simple_scan_copy_value, value_simple_scan_peek_pointer, "p", value_simple_scan_collect_value, "p", value_simple_scan_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType simple_scan_type_id;
		simple_scan_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SimpleScan", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&simple_scan_type_id__volatile, simple_scan_type_id);
	}
	return simple_scan_type_id__volatile;
}


gpointer simple_scan_ref (gpointer instance) {
	SimpleScan* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	return instance;
#line 7507 "ui.c"
}


void simple_scan_unref (gpointer instance) {
	SimpleScan* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		SIMPLE_SCAN_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/ui.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 7520 "ui.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



