/* simple-scan.c generated by valac 0.24.0, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gudev/gudev.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "colord.h"
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <locale.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _simple_scan_unref0(var) ((var == NULL) ? NULL : (var = (simple_scan_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))
typedef struct _ParamSpecApplication ParamSpecApplication;

struct _Application {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GTypeClass parent_class;
	void (*finalize) (Application *self);
};

struct _ApplicationPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUdevClient* udev_client;
	SimpleScan* ui;
	Scanner* scanner;
	Book* book;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecApplication {
	GParamSpec parent_instance;
};


static gpointer application_parent_class = NULL;
static gboolean application_show_version;
static gboolean application_show_version = FALSE;
static gboolean application_debug_enabled;
static gboolean application_debug_enabled = FALSE;
static gchar* application_fix_pdf_filename;
static gchar* application_fix_pdf_filename = NULL;
static GTimer* application_log_timer;
static GTimer* application_log_timer = NULL;
static FILE* application_log_file;
static FILE* application_log_file = NULL;

gpointer application_ref (gpointer instance);
void application_unref (gpointer instance);
GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_application (GValue* value, gpointer v_object);
void value_take_application (GValue* value, gpointer v_object);
gpointer value_get_application (const GValue* value);
GType application_get_type (void) G_GNUC_CONST;
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
gpointer simple_scan_ref (gpointer instance);
void simple_scan_unref (gpointer instance);
GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_simple_scan (GValue* value, gpointer v_object);
void value_take_simple_scan (GValue* value, gpointer v_object);
gpointer value_get_simple_scan (const GValue* value);
GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
Application* application_new (ScanDevice* device);
Application* application_construct (GType object_type, ScanDevice* device);
SimpleScan* simple_scan_new (void);
SimpleScan* simple_scan_construct (GType object_type);
Book* simple_scan_get_book (SimpleScan* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static void application_scan_cb (Application* self, SimpleScan* ui, const gchar* device, ScanOptions* options);
static void _application_scan_cb_simple_scan_start_scan (SimpleScan* _sender, const gchar* device, ScanOptions* options, gpointer self);
static void application_cancel_cb (Application* self, SimpleScan* ui);
static void _application_cancel_cb_simple_scan_stop_scan (SimpleScan* _sender, gpointer self);
static void application_email_cb (Application* self, SimpleScan* ui, const gchar* profile);
static void _application_email_cb_simple_scan_email (SimpleScan* _sender, const gchar* profile, gpointer self);
static void application_quit_cb (Application* self, SimpleScan* ui);
static void _application_quit_cb_simple_scan_quit (SimpleScan* _sender, gpointer self);
Scanner* scanner_get_instance (void);
static void application_update_scan_devices_cb (Application* self, Scanner* scanner, GList* devices);
static void _application_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self);
static void application_authorize_cb (Application* self, Scanner* scanner, const gchar* resource);
static void _application_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self);
static void application_scanner_new_page_cb (Application* self, Scanner* scanner);
static void _application_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
static void application_scanner_page_info_cb (Application* self, Scanner* scanner, ScanPageInfo* info);
static void _application_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void application_scanner_line_cb (Application* self, Scanner* scanner, ScanLine* line);
static void _application_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self);
static void application_scanner_page_done_cb (Application* self, Scanner* scanner);
static void _application_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self);
static void application_scanner_document_done_cb (Application* self, Scanner* scanner);
static void _application_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self);
static void application_scanner_failed_cb (Application* self, Scanner* scanner, gint error_code, const gchar* error_string);
static void _application_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self);
static void application_scanner_scanning_changed_cb (Application* self, Scanner* scanner);
static void _application_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self);
static void application_on_uevent (Application* self, GUdevClient* client, const gchar* action, GUdevDevice* device);
static void _application_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
void simple_scan_set_scan_devices (SimpleScan* self, GList* devices);
void simple_scan_set_selected_device (SimpleScan* self, const gchar* device);
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
void application_start (Application* self);
void simple_scan_start (SimpleScan* self);
void scanner_start (Scanner* self);
void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static Page* application_append_page (Application* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_has_data (Page* self);
void simple_scan_set_selected_page (SimpleScan* self, Page* page);
void page_start (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void page_set_named_crop (Page* self, const gchar* name);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
static gchar* application_get_profile_for_device (Application* self, const gchar* device_name);
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* color_profile);
guint book_get_n_pages (Book* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
static void application_remove_empty_page (Application* self);
void book_delete_page (Book* self, Page* page);
void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void simple_scan_set_scanning (SimpleScan* self, gboolean scanning);
gboolean scanner_is_scanning (Scanner* self);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
static gchar* application_get_temporary_filename (Application* self, const gchar* prefix, const gchar* extension);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
void scanner_free (Scanner* self);
static void application_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
void scanner_redetect (Scanner* self);
static void application_fix_pdf (const gchar* filename, GError** error);
gint application_main (gchar** args, int args_length1);
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void _application_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void application_finalize (Application* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry APPLICATION_options[4] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &application_show_version, "Show release version", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &application_debug_enabled, "Print debugging messages", NULL}, {"fix-pdf", (gchar) 0, 0, G_OPTION_ARG_STRING, &application_fix_pdf_filename, "Fix PDF files generated with older versions of Simple Scan", "FILENAME..."}, {NULL}};

static gpointer _scan_device_ref0 (gpointer self) {
#line 41 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return self ? scan_device_ref (self) : NULL;
#line 420 "simple-scan.c"
}


static void _application_scan_cb_simple_scan_start_scan (SimpleScan* _sender, const gchar* device, ScanOptions* options, gpointer self) {
#line 45 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_scan_cb ((Application*) self, _sender, device, options);
#line 427 "simple-scan.c"
}


static void _application_cancel_cb_simple_scan_stop_scan (SimpleScan* _sender, gpointer self) {
#line 46 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_cancel_cb ((Application*) self, _sender);
#line 434 "simple-scan.c"
}


static void _application_email_cb_simple_scan_email (SimpleScan* _sender, const gchar* profile, gpointer self) {
#line 47 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_email_cb ((Application*) self, _sender, profile);
#line 441 "simple-scan.c"
}


static void _application_quit_cb_simple_scan_quit (SimpleScan* _sender, gpointer self) {
#line 48 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_quit_cb ((Application*) self, _sender);
#line 448 "simple-scan.c"
}


static void _application_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self) {
#line 51 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_update_scan_devices_cb ((Application*) self, _sender, devices);
#line 455 "simple-scan.c"
}


static void _application_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self) {
#line 52 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_authorize_cb ((Application*) self, _sender, resource);
#line 462 "simple-scan.c"
}


static void _application_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self) {
#line 53 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_scanner_new_page_cb ((Application*) self, _sender);
#line 469 "simple-scan.c"
}


static void _application_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self) {
#line 54 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_scanner_page_info_cb ((Application*) self, _sender, info);
#line 476 "simple-scan.c"
}


static void _application_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self) {
#line 55 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_scanner_line_cb ((Application*) self, _sender, line);
#line 483 "simple-scan.c"
}


static void _application_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self) {
#line 56 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_scanner_page_done_cb ((Application*) self, _sender);
#line 490 "simple-scan.c"
}


static void _application_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self) {
#line 57 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_scanner_document_done_cb ((Application*) self, _sender);
#line 497 "simple-scan.c"
}


static void _application_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self) {
#line 58 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_scanner_failed_cb ((Application*) self, _sender, error_code, error_string);
#line 504 "simple-scan.c"
}


static void _application_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self) {
#line 59 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_scanner_scanning_changed_cb ((Application*) self, _sender);
#line 511 "simple-scan.c"
}


static void _application_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
#line 63 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_on_uevent ((Application*) self, _sender, action, device);
#line 518 "simple-scan.c"
}


static void _scan_device_unref0_ (gpointer var) {
#line 65 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 525 "simple-scan.c"
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
#line 65 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
#line 65 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_list_free (self);
#line 534 "simple-scan.c"
}


Application* application_construct (GType object_type, ScanDevice* device) {
	Application* self = NULL;
	ScanDevice* _tmp0_ = NULL;
	ScanDevice* _tmp1_ = NULL;
	SimpleScan* _tmp2_ = NULL;
	SimpleScan* _tmp3_ = NULL;
	Book* _tmp4_ = NULL;
	SimpleScan* _tmp5_ = NULL;
	SimpleScan* _tmp6_ = NULL;
	SimpleScan* _tmp7_ = NULL;
	SimpleScan* _tmp8_ = NULL;
	Scanner* _tmp9_ = NULL;
	Scanner* _tmp10_ = NULL;
	Scanner* _tmp11_ = NULL;
	Scanner* _tmp12_ = NULL;
	Scanner* _tmp13_ = NULL;
	Scanner* _tmp14_ = NULL;
	Scanner* _tmp15_ = NULL;
	Scanner* _tmp16_ = NULL;
	Scanner* _tmp17_ = NULL;
	Scanner* _tmp18_ = NULL;
	gchar** subsystems = NULL;
	gchar* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint subsystems_length1 = 0;
	gint _subsystems_size_ = 0;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	GUdevClient* _tmp22_ = NULL;
	GUdevClient* _tmp23_ = NULL;
	ScanDevice* _tmp24_ = NULL;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self = (Application*) g_type_create_instance (object_type);
#line 41 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = device;
#line 41 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = _scan_device_ref0 (_tmp0_);
#line 41 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 41 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->default_device = _tmp1_;
#line 43 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = simple_scan_new ();
#line 43 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_simple_scan_unref0 (self->priv->ui);
#line 43 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->ui = _tmp2_;
#line 44 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = self->priv->ui;
#line 44 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp4_ = simple_scan_get_book (_tmp3_);
#line 44 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 44 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->book = _tmp4_;
#line 45 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp5_ = self->priv->ui;
#line 45 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp5_, "start-scan", (GCallback) _application_scan_cb_simple_scan_start_scan, self);
#line 46 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp6_ = self->priv->ui;
#line 46 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp6_, "stop-scan", (GCallback) _application_cancel_cb_simple_scan_stop_scan, self);
#line 47 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp7_ = self->priv->ui;
#line 47 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp7_, "email", (GCallback) _application_email_cb_simple_scan_email, self);
#line 48 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp8_ = self->priv->ui;
#line 48 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp8_, "quit", (GCallback) _application_quit_cb_simple_scan_quit, self);
#line 50 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp9_ = scanner_get_instance ();
#line 50 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 50 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->scanner = _tmp9_;
#line 51 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp10_ = self->priv->scanner;
#line 51 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp10_, "update-devices", (GCallback) _application_update_scan_devices_cb_scanner_update_devices, self);
#line 52 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp11_ = self->priv->scanner;
#line 52 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp11_, "request-authorization", (GCallback) _application_authorize_cb_scanner_request_authorization, self);
#line 53 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp12_ = self->priv->scanner;
#line 53 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp12_, "expect-page", (GCallback) _application_scanner_new_page_cb_scanner_expect_page, self);
#line 54 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp13_ = self->priv->scanner;
#line 54 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp13_, "got-page-info", (GCallback) _application_scanner_page_info_cb_scanner_got_page_info, self);
#line 55 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp14_ = self->priv->scanner;
#line 55 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp14_, "got-line", (GCallback) _application_scanner_line_cb_scanner_got_line, self);
#line 56 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp15_ = self->priv->scanner;
#line 56 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp15_, "page-done", (GCallback) _application_scanner_page_done_cb_scanner_page_done, self);
#line 57 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp16_ = self->priv->scanner;
#line 57 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp16_, "document-done", (GCallback) _application_scanner_document_done_cb_scanner_document_done, self);
#line 58 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp17_ = self->priv->scanner;
#line 58 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp17_, "scan-failed", (GCallback) _application_scanner_failed_cb_scanner_scan_failed, self);
#line 59 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp18_ = self->priv->scanner;
#line 59 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp18_, "scanning-changed", (GCallback) _application_scanner_scanning_changed_cb_scanner_scanning_changed, self);
#line 61 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp19_ = g_strdup ("usb");
#line 61 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp20_ = g_new0 (gchar*, 2 + 1);
#line 61 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp20_[0] = _tmp19_;
#line 61 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp20_[1] = NULL;
#line 61 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	subsystems = _tmp20_;
#line 61 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	subsystems_length1 = 2;
#line 61 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_subsystems_size_ = subsystems_length1;
#line 62 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp21_ = subsystems;
#line 62 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp21__length1 = subsystems_length1;
#line 62 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp22_ = g_udev_client_new (_tmp21_);
#line 62 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 62 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->udev_client = _tmp22_;
#line 63 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp23_ = self->priv->udev_client;
#line 63 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_signal_connect (_tmp23_, "uevent", (GCallback) _application_on_uevent_g_udev_client_uevent, self);
#line 65 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp24_ = self->priv->default_device;
#line 65 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp24_ != NULL) {
#line 683 "simple-scan.c"
		GList* device_list = NULL;
		ScanDevice* _tmp25_ = NULL;
		ScanDevice* _tmp26_ = NULL;
		SimpleScan* _tmp27_ = NULL;
		GList* _tmp28_ = NULL;
		SimpleScan* _tmp29_ = NULL;
		ScanDevice* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
#line 67 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		device_list = NULL;
#line 69 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp25_ = self->priv->default_device;
#line 69 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp26_ = _scan_device_ref0 (_tmp25_);
#line 69 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		device_list = g_list_append (device_list, _tmp26_);
#line 70 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp27_ = self->priv->ui;
#line 70 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp28_ = device_list;
#line 70 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		simple_scan_set_scan_devices (_tmp27_, _tmp28_);
#line 71 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp29_ = self->priv->ui;
#line 71 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp30_ = self->priv->default_device;
#line 71 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp31_ = _tmp30_->name;
#line 71 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		simple_scan_set_selected_device (_tmp29_, _tmp31_);
#line 65 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		__g_list_free__scan_device_unref0_0 (device_list);
#line 716 "simple-scan.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	subsystems = (_vala_array_free (subsystems, subsystems_length1, (GDestroyNotify) g_free), NULL);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return self;
#line 722 "simple-scan.c"
}


Application* application_new (ScanDevice* device) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return application_construct (TYPE_APPLICATION, device);
#line 729 "simple-scan.c"
}


void application_start (Application* self) {
	SimpleScan* _tmp0_ = NULL;
	Scanner* _tmp1_ = NULL;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 77 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	simple_scan_start (_tmp0_);
#line 78 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = self->priv->scanner;
#line 78 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	scanner_start (_tmp1_);
#line 746 "simple-scan.c"
}


static void application_update_scan_devices_cb (Application* self, Scanner* scanner, GList* devices) {
	GList* devices_copy = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	ScanDevice* _tmp2_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	SimpleScan* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
#line 81 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 83 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = devices;
#line 83 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = g_list_copy (_tmp0_);
#line 83 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	devices_copy = _tmp1_;
#line 86 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = self->priv->default_device;
#line 86 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp2_ != NULL) {
#line 773 "simple-scan.c"
		gboolean default_in_list = FALSE;
		GList* _tmp3_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 88 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		default_in_list = FALSE;
#line 89 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp3_ = devices_copy;
#line 781 "simple-scan.c"
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
#line 89 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			device_collection = _tmp3_;
#line 89 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 789 "simple-scan.c"
				ScanDevice* device = NULL;
#line 89 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				device = (ScanDevice*) device_it->data;
#line 793 "simple-scan.c"
				{
					ScanDevice* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
					ScanDevice* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
#line 91 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp4_ = device;
#line 91 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp5_ = _tmp4_->name;
#line 91 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp6_ = self->priv->default_device;
#line 91 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp7_ = _tmp6_->name;
#line 91 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
#line 93 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						default_in_list = TRUE;
#line 94 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						break;
#line 813 "simple-scan.c"
					}
				}
			}
		}
#line 98 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp8_ = default_in_list;
#line 98 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (!_tmp8_) {
#line 822 "simple-scan.c"
			ScanDevice* _tmp9_ = NULL;
#line 99 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp9_ = self->priv->default_device;
#line 99 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			devices_copy = g_list_prepend (devices_copy, _tmp9_);
#line 828 "simple-scan.c"
		}
	}
#line 102 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp10_ = devices_copy;
#line 102 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp11_ = g_list_length (_tmp10_);
#line 102 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->have_devices = _tmp11_ > ((guint) 0);
#line 103 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp12_ = self->priv->ui;
#line 103 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp13_ = devices_copy;
#line 103 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	simple_scan_set_scan_devices (_tmp12_, _tmp13_);
#line 81 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_list_free0 (devices_copy);
#line 845 "simple-scan.c"
}


static void application_authorize_cb (Application* self, Scanner* scanner, const gchar* resource) {
	gchar* username = NULL;
	gchar* password = NULL;
	SimpleScan* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Scanner* _tmp4_ = NULL;
#line 106 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 106 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 106 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (resource != NULL);
#line 109 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 109 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = resource;
#line 109 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	simple_scan_authorize (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 109 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (username);
#line 109 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	username = _tmp2_;
#line 109 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (password);
#line 109 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	password = _tmp3_;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp4_ = scanner;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	scanner_authorize (_tmp4_, username, password);
#line 106 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (password);
#line 106 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (username);
#line 885 "simple-scan.c"
}


static Page* application_append_page (Application* self) {
	Page* result = NULL;
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Page* _tmp3_ = NULL;
	ScanDirection scan_direction = 0;
	gboolean do_crop = FALSE;
	gchar* named_crop = NULL;
	gint width = 0;
	gint height = 0;
	gint dpi = 0;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp9_ = NULL;
	Book* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	ScanDirection _tmp32_ = 0;
	Page* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	SimpleScan* _tmp44_ = NULL;
	Page* _tmp45_ = NULL;
	Page* _tmp46_ = NULL;
#line 113 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = book_get_page (_tmp0_, -1);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page = _tmp1_;
#line 117 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = page;
#line 117 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp3_ != NULL) {
#line 929 "simple-scan.c"
		Page* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 117 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp4_ = page;
#line 117 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp5_ = page_has_data (_tmp4_);
#line 117 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp2_ = !_tmp5_;
#line 938 "simple-scan.c"
	} else {
#line 117 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp2_ = FALSE;
#line 942 "simple-scan.c"
	}
#line 117 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp2_) {
#line 946 "simple-scan.c"
		SimpleScan* _tmp6_ = NULL;
		Page* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
#line 119 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp6_ = self->priv->ui;
#line 119 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp7_ = page;
#line 119 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		simple_scan_set_selected_page (_tmp6_, _tmp7_);
#line 120 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp8_ = page;
#line 120 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		page_start (_tmp8_);
#line 121 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = page;
#line 121 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 964 "simple-scan.c"
	}
#line 125 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 126 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	do_crop = FALSE;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	named_crop = NULL;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	width = 100;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	height = 100;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	dpi = 100;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	cx = 0;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	cy = 0;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	cw = 0;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	ch = 0;
#line 129 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp9_ = page;
#line 129 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp9_ != NULL) {
#line 990 "simple-scan.c"
		Page* _tmp10_ = NULL;
		ScanDirection _tmp11_ = 0;
		Page* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		Page* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		Page* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		Page* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 131 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp10_ = page;
#line 131 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp11_ = page_get_scan_direction (_tmp10_);
#line 131 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		scan_direction = _tmp11_;
#line 132 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp12_ = page;
#line 132 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp13_ = page_get_width (_tmp12_);
#line 132 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		width = _tmp13_;
#line 133 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp14_ = page;
#line 133 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp15_ = page_get_height (_tmp14_);
#line 133 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		height = _tmp15_;
#line 134 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp16_ = page;
#line 134 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp17_ = page_get_dpi (_tmp16_);
#line 134 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		dpi = _tmp17_;
#line 136 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp18_ = page;
#line 136 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp19_ = page_has_crop (_tmp18_);
#line 136 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		do_crop = _tmp19_;
#line 137 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp20_ = do_crop;
#line 137 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_tmp20_) {
#line 1036 "simple-scan.c"
			Page* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			Page* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
#line 139 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp21_ = page;
#line 139 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp22_ = page_get_named_crop (_tmp21_);
#line 139 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_g_free0 (named_crop);
#line 139 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			named_crop = _tmp22_;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp23_ = page;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			page_get_crop (_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_);
#line 140 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			cx = _tmp24_;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			cy = _tmp25_;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			cw = _tmp26_;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			ch = _tmp27_;
#line 1064 "simple-scan.c"
		}
	}
#line 144 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp28_ = self->priv->book;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp29_ = width;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp30_ = height;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp31_ = dpi;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp32_ = scan_direction;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp33_ = book_append_page (_tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_);
#line 144 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_page_unref0 (page);
#line 144 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page = _tmp33_;
#line 145 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp34_ = do_crop;
#line 145 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp34_) {
#line 1087 "simple-scan.c"
		const gchar* _tmp35_ = NULL;
		Page* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
#line 147 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp35_ = named_crop;
#line 147 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_tmp35_ != NULL) {
#line 1096 "simple-scan.c"
			Page* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
#line 149 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp36_ = page;
#line 149 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp37_ = named_crop;
#line 149 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			page_set_named_crop (_tmp36_, _tmp37_);
#line 1105 "simple-scan.c"
		} else {
			Page* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp38_ = page;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp39_ = cw;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp40_ = ch;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			page_set_custom_crop (_tmp38_, _tmp39_, _tmp40_);
#line 1118 "simple-scan.c"
		}
#line 153 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp41_ = page;
#line 153 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp42_ = cx;
#line 153 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp43_ = cy;
#line 153 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		page_move_crop (_tmp41_, _tmp42_, _tmp43_);
#line 1128 "simple-scan.c"
	}
#line 155 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp44_ = self->priv->ui;
#line 155 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp45_ = page;
#line 155 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	simple_scan_set_selected_page (_tmp44_, _tmp45_);
#line 156 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp46_ = page;
#line 156 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page_start (_tmp46_);
#line 158 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	result = page;
#line 158 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (named_crop);
#line 158 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return result;
#line 1146 "simple-scan.c"
}


static void application_scanner_new_page_cb (Application* self, Scanner* scanner) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 163 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = application_append_page (self);
#line 163 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = _tmp0_;
#line 163 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_page_unref0 (_tmp1_);
#line 1163 "simple-scan.c"
}


static gchar* application_get_profile_for_device (Application* self, const gchar* device_name) {
	gchar* result = NULL;
	gchar* device_id = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CdClient* client = NULL;
	CdClient* _tmp3_ = NULL;
	CdDevice* device = NULL;
	CdProfile* profile = NULL;
	CdDevice* _tmp19_ = NULL;
	CdProfile* _tmp20_ = NULL;
	CdProfile* _tmp21_ = NULL;
	CdProfile* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	CdProfile* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	CdProfile* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
#line 166 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 166 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_val_if_fail (device_name != NULL, NULL);
#line 169 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = device_name;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = g_strdup_printf ("sane:%s", _tmp0_);
#line 169 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	device_id = _tmp1_;
#line 170 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = device_name;
#line 170 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_debug ("simple-scan.vala:170: Getting color profile for device %s", _tmp2_);
#line 172 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = cd_client_new ();
#line 172 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	client = _tmp3_;
#line 1210 "simple-scan.c"
	{
		CdClient* _tmp4_ = NULL;
#line 175 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp4_ = client;
#line 175 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		cd_client_connect_sync (_tmp4_, NULL, &_inner_error_);
#line 175 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1219 "simple-scan.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 173 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		e = _inner_error_;
#line 173 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 179 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp5_ = e;
#line 179 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp6_ = _tmp5_->message;
#line 179 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_debug ("simple-scan.vala:179: Failed to connect to colord: %s", _tmp6_);
#line 180 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = NULL;
#line 180 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_error_free0 (e);
#line 180 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 180 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 180 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 1249 "simple-scan.c"
	}
	__finally3:
#line 173 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 173 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 173 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 173 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 173 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 173 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return NULL;
#line 1264 "simple-scan.c"
	}
	{
		CdDevice* _tmp7_ = NULL;
		CdClient* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		CdDevice* _tmp10_ = NULL;
		CdDevice* _tmp11_ = NULL;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp8_ = client;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp9_ = device_id;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp10_ = cd_client_find_device_by_property_sync (_tmp8_, CD_DEVICE_PROPERTY_SERIAL, _tmp9_, NULL, &_inner_error_);
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp7_ = _tmp10_;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1282 "simple-scan.c"
			goto __catch4_g_error;
		}
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp11_ = _tmp7_;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp7_ = NULL;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 186 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		device = _tmp11_;
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (_tmp7_);
#line 1295 "simple-scan.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		e = _inner_error_;
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 190 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp12_ = device_name;
#line 190 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp13_ = e;
#line 190 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp14_ = _tmp13_->message;
#line 190 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_debug ("simple-scan.vala:190: Unable to find colord device %s: %s", _tmp12_, _tmp14_);
#line 191 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = NULL;
#line 191 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_error_free0 (e);
#line 191 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 191 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 191 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 191 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 1328 "simple-scan.c"
	}
	__finally4:
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 184 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return NULL;
#line 1345 "simple-scan.c"
	}
	{
		CdDevice* _tmp15_ = NULL;
#line 196 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp15_ = device;
#line 196 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		cd_device_connect_sync (_tmp15_, NULL, &_inner_error_);
#line 196 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1355 "simple-scan.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		e = _inner_error_;
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 200 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp16_ = device_name;
#line 200 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp17_ = e;
#line 200 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp18_ = _tmp17_->message;
#line 200 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_debug ("simple-scan.vala:200: Failed to get properties from the device %s: %s", _tmp16_, _tmp18_);
#line 201 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = NULL;
#line 201 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_error_free0 (e);
#line 201 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 201 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 201 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 201 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 1390 "simple-scan.c"
	}
	__finally5:
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return NULL;
#line 1407 "simple-scan.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp19_ = device;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp20_ = cd_device_get_default_profile (_tmp19_);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	profile = _tmp20_;
#line 205 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp21_ = profile;
#line 205 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp21_ == NULL) {
#line 1419 "simple-scan.c"
		const gchar* _tmp22_ = NULL;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp22_ = device_name;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_debug ("simple-scan.vala:207: No default color profile for device: %s", _tmp22_);
#line 208 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = NULL;
#line 208 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 208 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 208 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 208 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 208 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 1437 "simple-scan.c"
	}
	{
		CdProfile* _tmp23_ = NULL;
#line 213 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp23_ = profile;
#line 213 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		cd_profile_connect_sync (_tmp23_, NULL, &_inner_error_);
#line 213 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1447 "simple-scan.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		e = _inner_error_;
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 217 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp24_ = device_name;
#line 217 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp25_ = e;
#line 217 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp26_ = _tmp25_->message;
#line 217 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_debug ("simple-scan.vala:217: Failed to get properties from the profile %s: %s", _tmp24_, _tmp26_);
#line 218 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = NULL;
#line 218 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_error_free0 (e);
#line 218 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 218 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 218 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 218 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 218 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 1484 "simple-scan.c"
	}
	__finally6:
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 211 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return NULL;
#line 1503 "simple-scan.c"
	}
#line 221 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp27_ = profile;
#line 221 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp28_ = cd_profile_get_filename (_tmp27_);
#line 221 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp29_ = _tmp28_;
#line 221 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp29_ == NULL) {
#line 1513 "simple-scan.c"
		const gchar* _tmp30_ = NULL;
#line 223 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp30_ = device_name;
#line 223 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_debug ("simple-scan.vala:223: No icc color profile for the device %s", _tmp30_);
#line 224 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = NULL;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 224 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 224 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 224 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (device_id);
#line 224 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 1531 "simple-scan.c"
	}
#line 227 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp31_ = profile;
#line 227 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp32_ = cd_profile_get_filename (_tmp31_);
#line 227 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp33_ = _tmp32_;
#line 227 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp34_ = device_name;
#line 227 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_debug ("simple-scan.vala:227: Using color profile %s for device %s", _tmp33_, _tmp34_);
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp35_ = profile;
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp36_ = cd_profile_get_filename (_tmp35_);
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp37_ = _tmp36_;
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp38_ = g_strdup (_tmp37_);
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	result = _tmp38_;
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_object_unref0 (profile);
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_object_unref0 (device);
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_object_unref0 (client);
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (device_id);
#line 228 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return result;
#line 1563 "simple-scan.c"
}


static void application_scanner_page_info_cb (Application* self, Scanner* scanner, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ScanPageInfo* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ScanPageInfo* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Page* page = NULL;
	Page* _tmp6_ = NULL;
	ScanPageInfo* _tmp7_ = NULL;
	ScanPageInfo* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 234 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 234 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 234 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (info != NULL);
#line 236 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = info;
#line 236 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = _tmp0_->width;
#line 236 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = info;
#line 236 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = _tmp2_->height;
#line 236 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp4_ = info;
#line 236 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp5_ = _tmp4_->depth;
#line 236 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_debug ("simple-scan.vala:236: Page is %d pixels wide, %d pixels high, %d bits " \
"per pixel", _tmp1_, _tmp3_, _tmp5_);
#line 240 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp6_ = application_append_page (self);
#line 240 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page = _tmp6_;
#line 241 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp7_ = info;
#line 241 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page_set_page_info (page, _tmp7_);
#line 246 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp8_ = info;
#line 246 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp9_ = _tmp8_->device;
#line 246 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp10_ = application_get_profile_for_device (self, _tmp9_);
#line 246 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp11_ = _tmp10_;
#line 246 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page_set_color_profile (page, _tmp11_);
#line 246 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (_tmp11_);
#line 234 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_page_unref0 (page);
#line 1623 "simple-scan.c"
}


static void application_scanner_line_cb (Application* self, Scanner* scanner, ScanLine* line) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	ScanLine* _tmp4_ = NULL;
#line 249 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 249 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 249 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (line != NULL);
#line 251 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 251 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 251 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 251 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 251 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page = _tmp3_;
#line 252 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp4_ = line;
#line 252 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page_parse_scan_line (page, _tmp4_);
#line 249 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_page_unref0 (page);
#line 1656 "simple-scan.c"
}


static void application_scanner_page_done_cb (Application* self, Scanner* scanner) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
#line 255 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 255 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 257 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 257 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 257 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 257 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page = _tmp3_;
#line 258 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page_finish (page);
#line 255 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_page_unref0 (page);
#line 1684 "simple-scan.c"
}


static void application_remove_empty_page (Application* self) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 261 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 263 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 263 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 263 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 263 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 263 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	page = _tmp3_;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp4_ = page;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp5_ = page_has_data (_tmp4_);
#line 266 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp5_) {
#line 1714 "simple-scan.c"
		Page* _tmp6_ = NULL;
#line 267 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp6_ = page;
#line 267 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		page_finish (_tmp6_);
#line 1720 "simple-scan.c"
	} else {
		Book* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp7_ = self->priv->book;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp8_ = page;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		book_delete_page (_tmp7_, _tmp8_);
#line 1730 "simple-scan.c"
	}
#line 261 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_page_unref0 (page);
#line 1734 "simple-scan.c"
}


static void application_scanner_document_done_cb (Application* self, Scanner* scanner) {
#line 272 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 272 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 274 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_remove_empty_page (self);
#line 1745 "simple-scan.c"
}


static void application_scanner_failed_cb (Application* self, Scanner* scanner, gint error_code, const gchar* error_string) {
	gint _tmp0_ = 0;
#line 277 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 277 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 277 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (error_string != NULL);
#line 279 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_remove_empty_page (self);
#line 280 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = error_code;
#line 280 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp0_ != ((gint) SANE_STATUS_CANCELLED)) {
#line 1763 "simple-scan.c"
		SimpleScan* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 282 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp1_ = self->priv->ui;
#line 282 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp2_ = _ ("Failed to scan");
#line 282 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp3_ = error_string;
#line 282 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp4_ = self->priv->have_devices;
#line 282 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		simple_scan_show_error (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1778 "simple-scan.c"
	}
}


static void application_scanner_scanning_changed_cb (Application* self, Scanner* scanner) {
	SimpleScan* _tmp0_ = NULL;
	Scanner* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 289 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 289 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 291 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 291 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = scanner;
#line 291 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = scanner_is_scanning (_tmp1_);
#line 291 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	simple_scan_set_scanning (_tmp0_, _tmp2_);
#line 1799 "simple-scan.c"
}


static void application_scan_cb (Application* self, SimpleScan* ui, const gchar* device, ScanOptions* options) {
	ScanOptions* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	Scanner* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar* filename_prefix = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* extension = NULL;
	ScanOptions* _tmp9_ = NULL;
	ScanMode _tmp10_ = 0;
	gchar* filename = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	SimpleScan* _tmp16_ = NULL;
	Scanner* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	ScanOptions* _tmp19_ = NULL;
#line 294 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 294 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 294 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (options != NULL);
#line 296 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = options;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = _tmp0_->dpi;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = device;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_debug ("simple-scan.vala:296: Requesting scan at %d dpi from device '%s'", _tmp1_, _tmp2_);
#line 298 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = self->priv->scanner;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp4_ = scanner_is_scanning (_tmp3_);
#line 298 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (!_tmp4_) {
#line 1843 "simple-scan.c"
		Page* _tmp5_ = NULL;
		Page* _tmp6_ = NULL;
#line 299 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp5_ = application_append_page (self);
#line 299 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp6_ = _tmp5_;
#line 299 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_page_unref0 (_tmp6_);
#line 1852 "simple-scan.c"
	}
#line 302 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp7_ = _ ("Scanned Document");
#line 302 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 302 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	filename_prefix = _tmp8_;
#line 304 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp9_ = options;
#line 304 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp10_ = _tmp9_->scan_mode;
#line 304 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp10_ == SCAN_MODE_COLOR) {
#line 1866 "simple-scan.c"
		gchar* _tmp11_ = NULL;
#line 305 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp11_ = g_strdup ("jpg");
#line 305 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (extension);
#line 305 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		extension = _tmp11_;
#line 1874 "simple-scan.c"
	} else {
		gchar* _tmp12_ = NULL;
#line 307 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp12_ = g_strdup ("pdf");
#line 307 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (extension);
#line 307 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		extension = _tmp12_;
#line 1883 "simple-scan.c"
	}
#line 308 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp13_ = filename_prefix;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp14_ = extension;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp15_ = g_strdup_printf ("%s.%s", _tmp13_, _tmp14_);
#line 308 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	filename = _tmp15_;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp16_ = ui;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	simple_scan_set_default_file_name (_tmp16_, filename);
#line 310 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp17_ = self->priv->scanner;
#line 310 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp18_ = device;
#line 310 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp19_ = options;
#line 310 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	scanner_scan (_tmp17_, _tmp18_, _tmp19_);
#line 294 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (filename);
#line 294 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (extension);
#line 294 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (filename_prefix);
#line 1911 "simple-scan.c"
}


static void application_cancel_cb (Application* self, SimpleScan* ui) {
	Scanner* _tmp0_ = NULL;
#line 313 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 313 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 315 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 315 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	scanner_cancel (_tmp0_);
#line 1925 "simple-scan.c"
}


static gchar* application_get_temporary_filename (Application* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 318 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 318 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 318 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 323 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = prefix;
#line 323 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = extension;
#line 323 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 323 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	filename = _tmp2_;
#line 1951 "simple-scan.c"
	{
		gint fd = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp3_ = filename;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 327 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (path);
#line 327 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		path = _tmp4_;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		fd = _tmp5_;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1970 "simple-scan.c"
			goto __catch7_g_error;
		}
#line 328 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp6_ = fd;
#line 328 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		close (_tmp6_);
#line 1977 "simple-scan.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 325 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		e = _inner_error_;
#line 325 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp7_ = e;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp8_ = _tmp7_->message;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_warning ("simple-scan.vala:332: Error saving email attachment: %s", _tmp8_);
#line 333 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = NULL;
#line 333 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_error_free0 (e);
#line 333 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (path);
#line 333 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (filename);
#line 333 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 2005 "simple-scan.c"
	}
	__finally7:
#line 325 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 325 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (path);
#line 325 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (filename);
#line 325 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 325 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 325 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return NULL;
#line 2020 "simple-scan.c"
	}
#line 336 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	result = path;
#line 336 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (filename);
#line 336 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return result;
#line 2028 "simple-scan.c"
}


static void application_email_cb (Application* self, SimpleScan* ui, const gchar* profile) {
	gboolean saved = FALSE;
	gchar* command_line = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp37_ = NULL;
	GError * _inner_error_ = NULL;
#line 339 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 339 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 339 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (profile != NULL);
#line 341 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	saved = FALSE;
#line 342 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = g_strdup ("xdg-email");
#line 342 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	command_line = _tmp0_;
#line 345 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = profile;
#line 345 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 2055 "simple-scan.c"
		gchar* path = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 348 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp2_ = application_get_temporary_filename (self, "scan", "pdf");
#line 348 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		path = _tmp2_;
#line 349 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp3_ = path;
#line 349 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_tmp3_ != NULL) {
#line 2067 "simple-scan.c"
			GFile* file = NULL;
			const gchar* _tmp4_ = NULL;
			GFile* _tmp5_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 351 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp4_ = path;
#line 351 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp5_ = g_file_new_for_path (_tmp4_);
#line 351 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			file = _tmp5_;
#line 2082 "simple-scan.c"
			{
				Book* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
#line 354 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp6_ = self->priv->book;
#line 354 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp7_ = file;
#line 354 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				book_save (_tmp6_, "pdf", _tmp7_, &_inner_error_);
#line 354 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				if (_inner_error_ != NULL) {
#line 2094 "simple-scan.c"
					goto __catch8_g_error;
				}
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError* e = NULL;
				GError* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				e = _inner_error_;
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_inner_error_ = NULL;
#line 358 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp8_ = e;
#line 358 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp9_ = _tmp8_->message;
#line 358 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				g_warning ("simple-scan.vala:358: Unable to save email file: %s", _tmp9_);
#line 359 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_error_free0 (e);
#line 359 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 359 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (path);
#line 359 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (command_line);
#line 359 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				return;
#line 2124 "simple-scan.c"
			}
			__finally8:
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			if (_inner_error_ != NULL) {
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (path);
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (command_line);
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				g_clear_error (&_inner_error_);
#line 352 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				return;
#line 2141 "simple-scan.c"
			}
#line 361 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp10_ = command_line;
#line 361 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp11_ = path;
#line 361 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp12_ = g_strdup_printf (" --attach %s", _tmp11_);
#line 361 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp13_ = _tmp12_;
#line 361 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
#line 361 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_g_free0 (command_line);
#line 361 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			command_line = _tmp14_;
#line 361 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_g_free0 (_tmp13_);
#line 349 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_g_object_unref0 (file);
#line 2161 "simple-scan.c"
		}
#line 345 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (path);
#line 2165 "simple-scan.c"
	} else {
		{
			gint i = 0;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			i = 0;
#line 2171 "simple-scan.c"
			{
				gboolean _tmp15_ = FALSE;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp15_ = TRUE;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				while (TRUE) {
#line 2178 "simple-scan.c"
					gint _tmp17_ = 0;
					Book* _tmp18_ = NULL;
					guint _tmp19_ = 0U;
					gchar* path = NULL;
					gchar* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					GFile* file = NULL;
					const gchar* _tmp22_ = NULL;
					GFile* _tmp23_ = NULL;
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gboolean _tmp36_ = FALSE;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					if (!_tmp15_) {
#line 2196 "simple-scan.c"
						gint _tmp16_ = 0;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp16_ = i;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						i = _tmp16_ + 1;
#line 2202 "simple-scan.c"
					}
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp15_ = FALSE;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp17_ = i;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp18_ = self->priv->book;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp19_ = book_get_n_pages (_tmp18_);
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					if (!(((guint) _tmp17_) < _tmp19_)) {
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						break;
#line 2216 "simple-scan.c"
					}
#line 368 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp20_ = application_get_temporary_filename (self, "scan", "jpg");
#line 368 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					path = _tmp20_;
#line 369 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp21_ = path;
#line 369 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					if (_tmp21_ == NULL) {
#line 371 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						saved = FALSE;
#line 372 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_free0 (path);
#line 372 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						break;
#line 2232 "simple-scan.c"
					}
#line 375 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp22_ = path;
#line 375 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp23_ = g_file_new_for_path (_tmp22_);
#line 375 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					file = _tmp23_;
#line 2240 "simple-scan.c"
					{
						Book* _tmp24_ = NULL;
						gint _tmp25_ = 0;
						Page* _tmp26_ = NULL;
						Page* _tmp27_ = NULL;
						GFile* _tmp28_ = NULL;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp24_ = self->priv->book;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp25_ = i;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp26_ = book_get_page (_tmp24_, _tmp25_);
#line 378 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp27_ = _tmp26_;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp28_ = file;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						page_save (_tmp27_, "jpeg", _tmp28_, &_inner_error_);
#line 378 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_page_unref0 (_tmp27_);
#line 378 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						if (_inner_error_ != NULL) {
#line 2263 "simple-scan.c"
							goto __catch9_g_error;
						}
					}
					goto __finally9;
					__catch9_g_error:
					{
						GError* e = NULL;
						GError* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						e = _inner_error_;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_inner_error_ = NULL;
#line 382 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp29_ = e;
#line 382 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp30_ = _tmp29_->message;
#line 382 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						g_warning ("simple-scan.vala:382: Unable to save email file: %s", _tmp30_);
#line 383 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_error_free0 (e);
#line 383 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 383 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_free0 (path);
#line 383 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_free0 (command_line);
#line 383 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						return;
#line 2293 "simple-scan.c"
					}
					__finally9:
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					if (_inner_error_ != NULL) {
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_free0 (path);
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_free0 (command_line);
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						g_clear_error (&_inner_error_);
#line 376 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						return;
#line 2310 "simple-scan.c"
					}
#line 385 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp31_ = command_line;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp32_ = path;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp33_ = g_strdup_printf (" --attach %s", _tmp32_);
#line 385 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp34_ = _tmp33_;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp35_ = g_strconcat (_tmp31_, _tmp34_, NULL);
#line 385 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_g_free0 (command_line);
#line 385 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					command_line = _tmp35_;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_g_free0 (_tmp34_);
#line 387 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp36_ = saved;
#line 387 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					if (!_tmp36_) {
#line 388 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 388 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_free0 (path);
#line 388 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						break;
#line 2338 "simple-scan.c"
					}
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_g_object_unref0 (file);
#line 366 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_g_free0 (path);
#line 2344 "simple-scan.c"
				}
			}
		}
	}
#line 392 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp37_ = command_line;
#line 392 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_debug ("simple-scan.vala:392: Launching email client: %s", _tmp37_);
#line 2353 "simple-scan.c"
	{
		const gchar* _tmp38_ = NULL;
#line 395 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp38_ = command_line;
#line 395 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_spawn_command_line_async (_tmp38_, &_inner_error_);
#line 395 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 2362 "simple-scan.c"
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
#line 393 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		e = _inner_error_;
#line 393 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 399 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp39_ = e;
#line 399 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp40_ = _tmp39_->message;
#line 399 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_warning ("simple-scan.vala:399: Unable to start email: %s", _tmp40_);
#line 393 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_error_free0 (e);
#line 2384 "simple-scan.c"
	}
	__finally10:
#line 393 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 393 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (command_line);
#line 393 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 393 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return;
#line 2397 "simple-scan.c"
	}
#line 339 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (command_line);
#line 2401 "simple-scan.c"
}


static void application_quit_cb (Application* self, SimpleScan* ui) {
	Scanner* _tmp0_ = NULL;
#line 403 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 403 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 405 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 405 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->book = NULL;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	ui = NULL;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 407 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->udev_client = NULL;
#line 408 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 408 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	scanner_free (_tmp0_);
#line 409 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	gtk_main_quit ();
#line 2427 "simple-scan.c"
}


static void application_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	FILE* _tmp0_ = NULL;
	GLogLevelFlags _tmp14_ = 0;
#line 412 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (message != NULL);
#line 415 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = application_log_file;
#line 415 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp0_ != NULL) {
#line 2440 "simple-scan.c"
		gchar* prefix = NULL;
		GLogLevelFlags _tmp1_ = 0;
		FILE* _tmp9_ = NULL;
		GTimer* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp1_ = log_level;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		switch (_tmp1_ & G_LOG_LEVEL_MASK) {
#line 419 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			case G_LOG_LEVEL_ERROR:
#line 2454 "simple-scan.c"
			{
				gchar* _tmp2_ = NULL;
#line 422 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp2_ = g_strdup ("ERROR:");
#line 422 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (prefix);
#line 422 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				prefix = _tmp2_;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2465 "simple-scan.c"
			}
#line 419 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			case G_LOG_LEVEL_CRITICAL:
#line 2469 "simple-scan.c"
			{
				gchar* _tmp3_ = NULL;
#line 425 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp3_ = g_strdup ("CRITICAL:");
#line 425 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (prefix);
#line 425 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				prefix = _tmp3_;
#line 426 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2480 "simple-scan.c"
			}
#line 419 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			case G_LOG_LEVEL_WARNING:
#line 2484 "simple-scan.c"
			{
				gchar* _tmp4_ = NULL;
#line 428 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp4_ = g_strdup ("WARNING:");
#line 428 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (prefix);
#line 428 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				prefix = _tmp4_;
#line 429 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2495 "simple-scan.c"
			}
#line 419 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			case G_LOG_LEVEL_MESSAGE:
#line 2499 "simple-scan.c"
			{
				gchar* _tmp5_ = NULL;
#line 431 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp5_ = g_strdup ("MESSAGE:");
#line 431 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (prefix);
#line 431 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				prefix = _tmp5_;
#line 432 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2510 "simple-scan.c"
			}
#line 419 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			case G_LOG_LEVEL_INFO:
#line 2514 "simple-scan.c"
			{
				gchar* _tmp6_ = NULL;
#line 434 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp6_ = g_strdup ("INFO:");
#line 434 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (prefix);
#line 434 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				prefix = _tmp6_;
#line 435 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2525 "simple-scan.c"
			}
#line 419 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			case G_LOG_LEVEL_DEBUG:
#line 2529 "simple-scan.c"
			{
				gchar* _tmp7_ = NULL;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp7_ = g_strdup ("DEBUG:");
#line 437 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (prefix);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				prefix = _tmp7_;
#line 438 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2540 "simple-scan.c"
			}
			default:
			{
				gchar* _tmp8_ = NULL;
#line 440 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp8_ = g_strdup ("LOG:");
#line 440 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (prefix);
#line 440 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				prefix = _tmp8_;
#line 441 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2553 "simple-scan.c"
			}
		}
#line 444 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp9_ = application_log_file;
#line 444 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp10_ = application_log_timer;
#line 444 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp11_ = g_timer_elapsed (_tmp10_, NULL);
#line 444 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp12_ = prefix;
#line 444 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp13_ = message;
#line 444 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		fprintf (_tmp9_, "[%+.2fs] %s %s\n", _tmp11_, _tmp12_, _tmp13_);
#line 415 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (prefix);
#line 2570 "simple-scan.c"
	}
#line 448 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp14_ = log_level;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if ((_tmp14_ & G_LOG_LEVEL_DEBUG) != 0) {
#line 2576 "simple-scan.c"
		gboolean _tmp15_ = FALSE;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp15_ = application_debug_enabled;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_tmp15_) {
#line 2582 "simple-scan.c"
			GLogFunc _tmp16_ = NULL;
			void* _tmp16__target = NULL;
			const gchar* _tmp17_ = NULL;
			GLogLevelFlags _tmp18_ = 0;
			const gchar* _tmp19_ = NULL;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp16_ = g_log_default_handler;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp16__target = NULL;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp17_ = log_domain;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp18_ = log_level;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp19_ = message;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp16_ (_tmp17_, _tmp18_, _tmp19_, _tmp16__target);
#line 2600 "simple-scan.c"
		}
	} else {
		GLogFunc _tmp20_ = NULL;
		void* _tmp20__target = NULL;
		const gchar* _tmp21_ = NULL;
		GLogLevelFlags _tmp22_ = 0;
		const gchar* _tmp23_ = NULL;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp20_ = g_log_default_handler;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp20__target = NULL;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp21_ = log_domain;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp22_ = log_level;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp23_ = message;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp20_ (_tmp21_, _tmp22_, _tmp23_, _tmp20__target);
#line 2620 "simple-scan.c"
	}
}


static void application_on_uevent (Application* self, GUdevClient* client, const gchar* action, GUdevDevice* device) {
	Scanner* _tmp0_ = NULL;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 457 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (client != NULL);
#line 457 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (action != NULL);
#line 457 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (device != NULL);
#line 459 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 459 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	scanner_redetect (_tmp0_);
#line 2639 "simple-scan.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1193 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1193 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1193 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1193 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1194 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1194 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2662 "simple-scan.c"
		glong _tmp4_ = 0L;
#line 1195 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1195 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1195 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 2670 "simple-scan.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1197 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1197 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1197 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1197 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 2682 "simple-scan.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1204 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2706 "simple-scan.c"
		glong _tmp2_ = 0L;
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2712 "simple-scan.c"
	} else {
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2716 "simple-scan.c"
	}
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2720 "simple-scan.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1208 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1208 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1208 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1208 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2732 "simple-scan.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1210 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1210 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1210 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2742 "simple-scan.c"
	}
#line 1213 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1213 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2748 "simple-scan.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1214 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1214 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1214 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1215 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1215 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2762 "simple-scan.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1217 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1217 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1217 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2772 "simple-scan.c"
	}
#line 1219 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1219 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2778 "simple-scan.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1220 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1220 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1220 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2787 "simple-scan.c"
	}
#line 1222 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1222 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1222 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1222 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 2807 "simple-scan.c"
}


static void application_fix_pdf (const gchar* filename, GError** error) {
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	size_t _tmp2_;
	FILE* fixed_file = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	FILE* _tmp6_ = NULL;
	FILE* _tmp7_ = NULL;
	gint offset = 0;
	gint line_number = 0;
	gint xref_offset = 0;
	gint xref_line = 0;
	gint startxref_line = 0;
	gint fixed_size = 0;
	GString* line = NULL;
	GString* _tmp8_ = NULL;
	const gchar* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	gint _tmp106_ = 0;
	gboolean _tmp107_ = FALSE;
	GError * _inner_error_ = NULL;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (filename != NULL);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = filename;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_file_get_contents (_tmp0_, (gchar**) (&_tmp1_), &_tmp2_, &_inner_error_);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	data = _tmp1_;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	data_length1 = _tmp2_;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_data_size_ = data_length1;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_propagate_error (error, _inner_error_);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		data = (g_free (data), NULL);
#line 465 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return;
#line 2861 "simple-scan.c"
	}
#line 467 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = filename;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".fixed", NULL);
#line 467 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp5_ = _tmp4_;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp6_ = g_fopen (_tmp5_, "w");
#line 467 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp7_ = _tmp6_;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (_tmp5_);
#line 467 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	fixed_file = _tmp7_;
#line 469 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	offset = 0;
#line 470 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	line_number = 0;
#line 471 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	xref_offset = 0;
#line 472 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	xref_line = -1;
#line 473 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	startxref_line = -1;
#line 474 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	fixed_size = -1;
#line 475 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp8_ = g_string_new ("");
#line 475 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	line = _tmp8_;
#line 476 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	while (TRUE) {
#line 2895 "simple-scan.c"
		gint _tmp9_ = 0;
		gint end_offset = 0;
		gint _tmp10_ = 0;
		GString* _tmp11_ = NULL;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GString* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gboolean _tmp25_ = FALSE;
		gint _tmp26_ = 0;
		gint _tmp100_ = 0;
		gint _tmp101_ = 0;
#line 476 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp9_ = offset;
#line 476 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (!(_tmp9_ < data_length1)) {
#line 476 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			break;
#line 2914 "simple-scan.c"
		}
#line 478 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp10_ = offset;
#line 478 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		end_offset = _tmp10_;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp11_ = line;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_string_assign (_tmp11_, "");
#line 480 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		while (TRUE) {
#line 2926 "simple-scan.c"
			gint _tmp12_ = 0;
			guint8 c = 0U;
			gint _tmp13_ = 0;
			guint8 _tmp14_ = 0U;
			GString* _tmp15_ = NULL;
			guint8 _tmp16_ = 0U;
			gint _tmp17_ = 0;
			guint8 _tmp18_ = 0U;
#line 480 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp12_ = end_offset;
#line 480 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			if (!(_tmp12_ < data_length1)) {
#line 480 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2941 "simple-scan.c"
			}
#line 482 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp13_ = end_offset;
#line 482 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp14_ = data[_tmp13_];
#line 482 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			c = _tmp14_;
#line 483 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp15_ = line;
#line 483 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp16_ = c;
#line 483 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			g_string_append_c (_tmp15_, (gchar) _tmp16_);
#line 484 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp17_ = end_offset;
#line 484 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			end_offset = _tmp17_ + 1;
#line 485 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp18_ = c;
#line 485 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			if (_tmp18_ == ((guint8) '\n')) {
#line 486 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				break;
#line 2965 "simple-scan.c"
			}
		}
#line 489 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp19_ = line;
#line 489 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp20_ = _tmp19_->str;
#line 489 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (g_strcmp0 (_tmp20_, "startxref\n") == 0) {
#line 2974 "simple-scan.c"
			gint _tmp21_ = 0;
#line 490 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp21_ = line_number;
#line 490 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			startxref_line = _tmp21_;
#line 2980 "simple-scan.c"
		}
#line 492 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp22_ = line;
#line 492 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp23_ = _tmp22_->str;
#line 492 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (g_strcmp0 (_tmp23_, "xref\n") == 0) {
#line 2988 "simple-scan.c"
			gint _tmp24_ = 0;
#line 493 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp24_ = line_number;
#line 493 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			xref_line = _tmp24_;
#line 2994 "simple-scan.c"
		}
#line 496 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp26_ = line_number;
#line 496 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_tmp26_ < 2) {
#line 3000 "simple-scan.c"
			GString* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
#line 496 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp27_ = line;
#line 496 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp28_ = _tmp27_->str;
#line 496 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp29_ = g_str_has_prefix (_tmp28_, "%%");
#line 496 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp25_ = _tmp29_;
#line 3012 "simple-scan.c"
		} else {
#line 496 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp25_ = FALSE;
#line 3016 "simple-scan.c"
		}
#line 496 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_tmp25_) {
#line 3020 "simple-scan.c"
			gint _tmp30_ = 0;
			FILE* _tmp31_ = NULL;
			GString* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
#line 498 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp30_ = xref_offset;
#line 498 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			xref_offset = _tmp30_ - 1;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp31_ = fixed_file;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp32_ = line;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp33_ = _tmp32_->str;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) (-1));
#line 499 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp35_ = _tmp34_;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			fprintf (_tmp31_, "%s", _tmp35_);
#line 499 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_g_free0 (_tmp35_);
#line 3045 "simple-scan.c"
		} else {
			gboolean _tmp36_ = FALSE;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp37_ = line_number;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp38_ = xref_line;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			if (_tmp37_ == (_tmp38_ + 1)) {
#line 3056 "simple-scan.c"
				GString* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp39_ = line;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp40_ = _tmp39_->str;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp41_ = g_str_has_prefix (_tmp40_, "1 ");
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp36_ = _tmp41_;
#line 3068 "simple-scan.c"
			} else {
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp36_ = FALSE;
#line 3072 "simple-scan.c"
			}
#line 503 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			if (_tmp36_) {
#line 3076 "simple-scan.c"
				GString* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				FILE* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				FILE* _tmp49_ = NULL;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp42_ = line;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp43_ = _tmp42_->str;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp44_ = string_substring (_tmp43_, (glong) 2, (glong) (-1));
#line 505 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp45_ = _tmp44_;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp46_ = atoi (_tmp45_);
#line 505 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				fixed_size = _tmp46_ + 1;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_g_free0 (_tmp45_);
#line 506 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp47_ = fixed_file;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp48_ = fixed_size;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				fprintf (_tmp47_, "0 %d\n", _tmp48_);
#line 507 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp49_ = fixed_file;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				fprintf (_tmp49_, "0000000000 65535 f \n");
#line 3109 "simple-scan.c"
			} else {
				gboolean _tmp50_ = FALSE;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp51_ = line_number;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				_tmp52_ = xref_line;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				if (_tmp51_ > _tmp52_) {
#line 3120 "simple-scan.c"
					GString* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
					gboolean _tmp55_ = FALSE;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp53_ = line;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp54_ = _tmp53_->str;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp55_ = g_str_has_suffix (_tmp54_, " 0000 n\n");
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp50_ = _tmp55_;
#line 3132 "simple-scan.c"
				} else {
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp50_ = FALSE;
#line 3136 "simple-scan.c"
				}
#line 511 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				if (_tmp50_) {
#line 3140 "simple-scan.c"
					FILE* _tmp56_ = NULL;
					GString* _tmp57_ = NULL;
					const gchar* _tmp58_ = NULL;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
#line 512 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp56_ = fixed_file;
#line 512 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp57_ = line;
#line 512 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp58_ = _tmp57_->str;
#line 512 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp59_ = atoi (_tmp58_);
#line 512 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp60_ = xref_offset;
#line 512 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					fprintf (_tmp56_, "%010d 00000 n \n", _tmp59_ + _tmp60_);
#line 3158 "simple-scan.c"
				} else {
					gboolean _tmp61_ = FALSE;
					gint _tmp62_ = 0;
#line 515 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp62_ = startxref_line;
#line 515 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					if (_tmp62_ > 0) {
#line 3166 "simple-scan.c"
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
#line 515 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp63_ = line_number;
#line 515 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp64_ = startxref_line;
#line 515 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp61_ = _tmp63_ == (_tmp64_ + 1);
#line 3175 "simple-scan.c"
					} else {
#line 515 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp61_ = FALSE;
#line 3179 "simple-scan.c"
					}
#line 515 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					if (_tmp61_) {
#line 3183 "simple-scan.c"
						FILE* _tmp65_ = NULL;
						GString* _tmp66_ = NULL;
						const gchar* _tmp67_ = NULL;
						gint _tmp68_ = 0;
						gint _tmp69_ = 0;
						gchar* _tmp70_ = NULL;
						gchar* _tmp71_ = NULL;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp65_ = fixed_file;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp66_ = line;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp67_ = _tmp66_->str;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp68_ = atoi (_tmp67_);
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp69_ = xref_offset;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp70_ = g_strdup_printf ("%d\n", _tmp68_ + _tmp69_);
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp71_ = _tmp70_;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						fprintf (_tmp65_, "%s", _tmp71_);
#line 516 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_g_free0 (_tmp71_);
#line 3209 "simple-scan.c"
					} else {
						gboolean _tmp72_ = FALSE;
						gint _tmp73_ = 0;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp73_ = fixed_size;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						if (_tmp73_ > 0) {
#line 3217 "simple-scan.c"
							GString* _tmp74_ = NULL;
							const gchar* _tmp75_ = NULL;
							gboolean _tmp76_ = FALSE;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp74_ = line;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp75_ = _tmp74_->str;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp76_ = g_str_has_prefix (_tmp75_, "/Size ");
#line 518 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp72_ = _tmp76_;
#line 3229 "simple-scan.c"
						} else {
#line 518 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp72_ = FALSE;
#line 3233 "simple-scan.c"
						}
#line 518 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						if (_tmp72_) {
#line 3237 "simple-scan.c"
							FILE* _tmp77_ = NULL;
							gint _tmp78_ = 0;
							gchar* _tmp79_ = NULL;
							gchar* _tmp80_ = NULL;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp77_ = fixed_file;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp78_ = fixed_size;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp79_ = g_strdup_printf ("/Size %d\n", _tmp78_);
#line 519 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp80_ = _tmp79_;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							fprintf (_tmp77_, "%s", _tmp80_);
#line 519 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_g_free0 (_tmp80_);
#line 3254 "simple-scan.c"
						} else {
							gboolean _tmp81_ = FALSE;
							gint _tmp82_ = 0;
							gint _tmp83_ = 0;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp82_ = line_number;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp83_ = startxref_line;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							if (_tmp82_ == (_tmp83_ + 2)) {
#line 3265 "simple-scan.c"
								GString* _tmp84_ = NULL;
								const gchar* _tmp85_ = NULL;
								gboolean _tmp86_ = FALSE;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp84_ = line;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp85_ = _tmp84_->str;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp86_ = g_str_has_prefix (_tmp85_, "%%%%");
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp81_ = _tmp86_;
#line 3277 "simple-scan.c"
							} else {
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp81_ = FALSE;
#line 3281 "simple-scan.c"
							}
#line 522 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							if (_tmp81_) {
#line 3285 "simple-scan.c"
								FILE* _tmp87_ = NULL;
								GString* _tmp88_ = NULL;
								const gchar* _tmp89_ = NULL;
								gchar* _tmp90_ = NULL;
								gchar* _tmp91_ = NULL;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp87_ = fixed_file;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp88_ = line;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp89_ = _tmp88_->str;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp90_ = string_substring (_tmp89_, (glong) 2, (glong) (-1));
#line 523 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_tmp91_ = _tmp90_;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								fprintf (_tmp87_, "%s", _tmp91_);
#line 523 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
								_g_free0 (_tmp91_);
#line 3305 "simple-scan.c"
							} else {
								{
									gint i = 0;
									gint _tmp92_ = 0;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
									_tmp92_ = offset;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
									i = _tmp92_;
#line 3314 "simple-scan.c"
									{
										gboolean _tmp93_ = FALSE;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
										_tmp93_ = TRUE;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
										while (TRUE) {
#line 3321 "simple-scan.c"
											gint _tmp95_ = 0;
											gint _tmp96_ = 0;
											FILE* _tmp97_ = NULL;
											gint _tmp98_ = 0;
											guint8 _tmp99_ = 0U;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											if (!_tmp93_) {
#line 3329 "simple-scan.c"
												gint _tmp94_ = 0;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
												_tmp94_ = i;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
												i = _tmp94_ + 1;
#line 3335 "simple-scan.c"
											}
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											_tmp93_ = FALSE;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											_tmp95_ = i;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											_tmp96_ = end_offset;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											if (!(_tmp95_ < _tmp96_)) {
#line 526 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
												break;
#line 3347 "simple-scan.c"
											}
#line 527 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											_tmp97_ = fixed_file;
#line 527 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											_tmp98_ = i;
#line 527 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											_tmp99_ = data[_tmp98_];
#line 527 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
											fputc ((gchar) _tmp99_, _tmp97_);
#line 3357 "simple-scan.c"
										}
									}
								}
							}
						}
					}
				}
			}
		}
#line 529 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp100_ = line_number;
#line 529 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		line_number = _tmp100_ + 1;
#line 530 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp101_ = end_offset;
#line 530 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		offset = _tmp101_;
#line 3375 "simple-scan.c"
	}
#line 533 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp102_ = filename;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp103_ = filename;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp104_ = g_strconcat (_tmp103_, "~", NULL);
#line 533 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp105_ = _tmp104_;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp106_ = g_rename (_tmp102_, _tmp105_);
#line 533 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp107_ = _tmp106_ >= 0;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (_tmp105_);
#line 533 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp107_) {
#line 3393 "simple-scan.c"
		const gchar* _tmp108_ = NULL;
		gchar* _tmp109_ = NULL;
		gchar* _tmp110_ = NULL;
		const gchar* _tmp111_ = NULL;
#line 534 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp108_ = filename;
#line 534 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp109_ = g_strconcat (_tmp108_, ".fixed", NULL);
#line 534 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp110_ = _tmp109_;
#line 534 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp111_ = filename;
#line 534 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_rename (_tmp110_, _tmp111_);
#line 534 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (_tmp110_);
#line 3410 "simple-scan.c"
	}
#line 462 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_string_free0 (line);
#line 462 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_fclose0 (fixed_file);
#line 462 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 3418 "simple-scan.c"
}


static void _application_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
#line 598 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_log_cb (log_domain, log_levels, message);
#line 3425 "simple-scan.c"
}


gint application_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* c = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp16_ = NULL;
	ScanDevice* device = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	GTimer* _tmp38_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	FILE* _tmp45_ = NULL;
	pid_t _tmp46_ = 0;
	Application* app = NULL;
	ScanDevice* _tmp47_ = NULL;
	Application* _tmp48_ = NULL;
	Application* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
#line 539 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	setlocale (LC_ALL, "");
#line 540 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
#line 541 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 542 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	textdomain (GETTEXT_PACKAGE);
#line 544 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	gtk_init (&args_length1, &args);
#line 546 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp0_ = _ ("[DEVICE...] - Scanning utility");
#line 546 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp1_ = g_option_context_new (_tmp0_);
#line 546 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	c = _tmp1_;
#line 548 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp2_ = c;
#line 548 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_option_context_add_main_entries (_tmp2_, APPLICATION_options, GETTEXT_PACKAGE);
#line 549 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp3_ = c;
#line 549 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp4_ = gtk_get_option_group (TRUE);
#line 549 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 3483 "simple-scan.c"
	{
		GOptionContext* _tmp5_ = NULL;
#line 552 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp5_ = c;
#line 552 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 552 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 3492 "simple-scan.c"
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		FILE* _tmp13_ = NULL;
#line 550 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		e = _inner_error_;
#line 550 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 556 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp6_ = stderr;
#line 556 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp7_ = e;
#line 556 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp8_ = _tmp7_->message;
#line 556 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 557 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp9_ = stderr;
#line 557 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
#line 557 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp11_ = args;
#line 557 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp11__length1 = args_length1;
#line 557 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp12_ = _tmp11_[0];
#line 557 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		fprintf (_tmp9_, _tmp10_, _tmp12_);
#line 559 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp13_ = stderr;
#line 559 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		fprintf (_tmp13_, "\n");
#line 560 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = EXIT_FAILURE;
#line 560 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_error_free0 (e);
#line 560 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 560 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 3545 "simple-scan.c"
	}
	__finally11:
#line 550 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 550 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 550 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 550 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 550 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return 0;
#line 3558 "simple-scan.c"
	}
#line 562 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp14_ = application_show_version;
#line 562 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp14_) {
#line 3564 "simple-scan.c"
		FILE* _tmp15_ = NULL;
#line 565 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp15_ = stderr;
#line 565 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		fprintf (_tmp15_, "simple-scan %s\n", VERSION);
#line 566 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 566 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 566 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 3576 "simple-scan.c"
	}
#line 568 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp16_ = application_fix_pdf_filename;
#line 568 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp16_ != NULL) {
#line 3582 "simple-scan.c"
		{
			const gchar* _tmp17_ = NULL;
#line 572 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp17_ = application_fix_pdf_filename;
#line 572 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			application_fix_pdf (_tmp17_, &_inner_error_);
#line 572 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			if (_inner_error_ != NULL) {
#line 3591 "simple-scan.c"
				goto __catch12_g_error;
			}
			{
				gint i = 0;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
				i = 1;
#line 3598 "simple-scan.c"
				{
					gboolean _tmp18_ = FALSE;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					_tmp18_ = TRUE;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
					while (TRUE) {
#line 3605 "simple-scan.c"
						gint _tmp20_ = 0;
						gchar** _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						gchar** _tmp22_ = NULL;
						gint _tmp22__length1 = 0;
						gint _tmp23_ = 0;
						const gchar* _tmp24_ = NULL;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						if (!_tmp18_) {
#line 3615 "simple-scan.c"
							gint _tmp19_ = 0;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							_tmp19_ = i;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							i = _tmp19_ + 1;
#line 3621 "simple-scan.c"
						}
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp18_ = FALSE;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp20_ = i;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp21_ = args;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp21__length1 = args_length1;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						if (!(_tmp20_ < _tmp21__length1)) {
#line 573 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
							break;
#line 3635 "simple-scan.c"
						}
#line 574 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp22_ = args;
#line 574 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp22__length1 = args_length1;
#line 574 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp23_ = i;
#line 574 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						_tmp24_ = _tmp22_[_tmp23_];
#line 574 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						application_fix_pdf (_tmp24_, &_inner_error_);
#line 574 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
						if (_inner_error_ != NULL) {
#line 3649 "simple-scan.c"
							goto __catch12_g_error;
						}
					}
				}
			}
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* e = NULL;
			FILE* _tmp25_ = NULL;
			GError* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
#line 570 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			e = _inner_error_;
#line 570 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_inner_error_ = NULL;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp25_ = stderr;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp26_ = e;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_tmp27_ = _tmp26_->message;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			fprintf (_tmp25_, "Error fixing PDF file: %s", _tmp27_);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			result = EXIT_FAILURE;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_g_error_free0 (e);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			return result;
#line 3683 "simple-scan.c"
		}
		__finally12:
#line 570 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 570 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 570 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 570 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			g_clear_error (&_inner_error_);
#line 570 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			return 0;
#line 3696 "simple-scan.c"
		}
#line 581 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 581 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return result;
#line 3704 "simple-scan.c"
	}
#line 584 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	device = NULL;
#line 585 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp28_ = args;
#line 585 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp28__length1 = args_length1;
#line 585 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (_tmp28__length1 > 1) {
#line 3714 "simple-scan.c"
		ScanDevice* _tmp29_ = NULL;
		ScanDevice* _tmp30_ = NULL;
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		ScanDevice* _tmp34_ = NULL;
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp29_ = scan_device_new ();
#line 587 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_scan_device_unref0 (device);
#line 587 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		device = _tmp29_;
#line 588 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp30_ = device;
#line 588 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp31_ = args;
#line 588 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp31__length1 = args_length1;
#line 588 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp32_ = _tmp31_[1];
#line 588 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp33_ = g_strdup (_tmp32_);
#line 588 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (_tmp30_->name);
#line 588 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp30_->name = _tmp33_;
#line 589 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp34_ = device;
#line 589 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp35_ = args;
#line 589 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp35__length1 = args_length1;
#line 589 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp36_ = _tmp35_[1];
#line 589 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 589 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_g_free0 (_tmp34_->label);
#line 589 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		_tmp34_->label = _tmp37_;
#line 3760 "simple-scan.c"
	}
#line 593 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp38_ = g_timer_new ();
#line 593 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_timer_destroy0 (application_log_timer);
#line 593 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_log_timer = _tmp38_;
#line 594 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp39_ = g_get_user_cache_dir ();
#line 594 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp40_ = g_build_filename (_tmp39_, "simple-scan", NULL, NULL);
#line 594 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	path = _tmp40_;
#line 595 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp41_ = path;
#line 595 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_mkdir_with_parents (_tmp41_, 0700);
#line 596 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp42_ = g_get_user_cache_dir ();
#line 596 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp43_ = g_build_filename (_tmp42_, "simple-scan", "simple-scan.log", NULL, NULL);
#line 596 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (path);
#line 596 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	path = _tmp43_;
#line 597 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp44_ = path;
#line 597 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp45_ = g_fopen (_tmp44_, "w");
#line 597 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_fclose0 (application_log_file);
#line 597 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_log_file = _tmp45_;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_log_set_default_handler (_application_log_cb_glog_func, NULL);
#line 600 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp46_ = getpid ();
#line 600 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_debug ("simple-scan.vala:600: Starting Simple Scan %s, PID=%i", VERSION, (gint) _tmp46_);
#line 602 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp47_ = device;
#line 602 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp48_ = application_new (_tmp47_);
#line 602 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	app = _tmp48_;
#line 603 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_tmp49_ = app;
#line 603 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_start (_tmp49_);
#line 605 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	gtk_main ();
#line 607 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	result = EXIT_SUCCESS;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_application_unref0 (app);
#line 607 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_free0 (path);
#line 607 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_scan_device_unref0 (device);
#line 607 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_option_context_free0 (c);
#line 607 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return result;
#line 3824 "simple-scan.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 537 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return application_main (argv, argc);
#line 3834 "simple-scan.c"
}


static void value_application_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	value->data[0].v_pointer = NULL;
#line 3841 "simple-scan.c"
}


static void value_application_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		application_unref (value->data[0].v_pointer);
#line 3850 "simple-scan.c"
	}
}


static void value_application_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		dest_value->data[0].v_pointer = application_ref (src_value->data[0].v_pointer);
#line 3860 "simple-scan.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3864 "simple-scan.c"
	}
}


static gpointer value_application_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return value->data[0].v_pointer;
#line 3872 "simple-scan.c"
}


static gchar* value_application_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (collect_values[0].v_pointer) {
#line 3879 "simple-scan.c"
		Application* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3886 "simple-scan.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3890 "simple-scan.c"
		}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		value->data[0].v_pointer = application_ref (object);
#line 3894 "simple-scan.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		value->data[0].v_pointer = NULL;
#line 3898 "simple-scan.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return NULL;
#line 3902 "simple-scan.c"
}


static gchar* value_application_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Application** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3913 "simple-scan.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		*object_p = NULL;
#line 3919 "simple-scan.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		*object_p = value->data[0].v_pointer;
#line 3923 "simple-scan.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		*object_p = application_ref (value->data[0].v_pointer);
#line 3927 "simple-scan.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return NULL;
#line 3931 "simple-scan.c"
}


GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecApplication* spec;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_APPLICATION), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return G_PARAM_SPEC (spec);
#line 3945 "simple-scan.c"
}


gpointer value_get_application (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return value->data[0].v_pointer;
#line 3954 "simple-scan.c"
}


void value_set_application (GValue* value, gpointer v_object) {
	Application* old;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		application_ref (value->data[0].v_pointer);
#line 3974 "simple-scan.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		value->data[0].v_pointer = NULL;
#line 3978 "simple-scan.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		application_unref (old);
#line 3984 "simple-scan.c"
	}
}


void value_take_application (GValue* value, gpointer v_object) {
	Application* old;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		value->data[0].v_pointer = v_object;
#line 4003 "simple-scan.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		value->data[0].v_pointer = NULL;
#line 4007 "simple-scan.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		application_unref (old);
#line 4013 "simple-scan.c"
	}
}


static void application_class_init (ApplicationClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	application_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	APPLICATION_CLASS (klass)->finalize = application_finalize;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
#line 4025 "simple-scan.c"
}


static void application_instance_init (Application * self) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv = APPLICATION_GET_PRIVATE (self);
#line 32 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->default_device = NULL;
#line 33 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->priv->have_devices = FALSE;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self->ref_count = 1;
#line 4038 "simple-scan.c"
}


static void application_finalize (Application* obj) {
	Application * self;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
#line 32 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 34 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 35 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_simple_scan_unref0 (self->priv->ui);
#line 36 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 37 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 4056 "simple-scan.c"
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_application_init, value_application_free_value, value_application_copy_value, value_application_peek_pointer, "p", value_application_collect_value, "p", value_application_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType application_type_id;
		application_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Application", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


gpointer application_ref (gpointer instance) {
	Application* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	return instance;
#line 4081 "simple-scan.c"
}


void application_unref (gpointer instance) {
	Application* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		APPLICATION_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/simple-scan.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4094 "simple-scan.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



