/* page.c generated by valac 0.24.0, the Vala compiler
 * generated from page.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef struct _PagePrivate PagePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PIXBUF_WRITER (pixbuf_writer_get_type ())
#define PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_WRITER, PixbufWriter))
#define PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_WRITER, PixbufWriterClass))
#define IS_PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_WRITER))
#define IS_PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_WRITER))
#define PIXBUF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_WRITER, PixbufWriterClass))

typedef struct _PixbufWriter PixbufWriter;
typedef struct _PixbufWriterClass PixbufWriterClass;
#define _pixbuf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pixbuf_writer_unref (var), NULL)))
typedef struct _ParamSpecPage ParamSpecPage;
typedef struct _PixbufWriterPrivate PixbufWriterPrivate;
typedef struct _ParamSpecPixbufWriter ParamSpecPixbufWriter;

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _Page {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PagePrivate * priv;
};

struct _PageClass {
	GTypeClass parent_class;
	void (*finalize) (Page *self);
};

struct _PagePrivate {
	gint dpi;
	gint expected_rows;
	gint depth;
	gchar* color_profile;
	gint width;
	gint n_rows;
	gint rowstride;
	gint n_channels;
	guchar* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	gboolean scanning;
	gboolean has_data_;
	gint scan_line;
	ScanDirection scan_direction;
	gboolean has_crop_;
	gchar* crop_name;
	gint crop_x;
	gint crop_y;
	gint crop_width;
	gint crop_height;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecPage {
	GParamSpec parent_instance;
};

struct _PixbufWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixbufWriterPrivate * priv;
	GFileOutputStream* stream;
};

struct _PixbufWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PixbufWriter *self);
};

struct _ParamSpecPixbufWriter {
	GParamSpec parent_instance;
};


static gpointer page_parent_class = NULL;
static gpointer pixbuf_writer_parent_class = NULL;

GType scan_direction_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE, PagePrivate))
enum  {
	PAGE_DUMMY_PROPERTY
};
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_start (Page* self);
gboolean page_is_scanning (Page* self);
gboolean page_has_data (Page* self);
gboolean page_is_color (Page* self);
gint page_get_scan_line (Page* self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void page_parse_line (Page* self, ScanLine* line, gint n, gboolean* size_changed);
gint page_get_scan_height (Page* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
ScanDirection page_get_scan_direction (Page* self);
static void page_set_scan_direction (Page* self, ScanDirection direction);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_rotate_left (Page* self);
void page_rotate_right (Page* self);
gint page_get_dpi (Page* self);
gboolean page_is_landscape (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_rowstride (Page* self);
gint page_get_scan_width (Page* self);
void page_set_color_profile (Page* self, const gchar* color_profile);
gchar* page_get_color_profile (Page* self);
void page_set_no_crop (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_set_named_crop (Page* self, const gchar* name);
void page_move_crop (Page* self, gint x, gint y);
void page_rotate_crop (Page* self);
gboolean page_has_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
gchar* page_get_named_crop (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
static guchar page_get_sample (Page* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint n_channels, gint channel);
static void page_get_pixel (Page* self, gint x, gint y, guchar* pixel, int pixel_length1, gint offset);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
static gchar* page_get_icc_data_encoded (Page* self, const gchar* icc_profile_filename);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
gpointer pixbuf_writer_ref (gpointer instance);
void pixbuf_writer_unref (gpointer instance);
GParamSpec* param_spec_pixbuf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixbuf_writer (GValue* value, gpointer v_object);
void value_take_pixbuf_writer (GValue* value, gpointer v_object);
gpointer value_get_pixbuf_writer (const GValue* value);
GType pixbuf_writer_get_type (void) G_GNUC_CONST;
PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream);
PixbufWriter* pixbuf_writer_construct (GType object_type, GFileOutputStream* stream);
void pixbuf_writer_save (PixbufWriter* self, GdkPixbuf* image, const gchar* type, gchar** option_keys, int option_keys_length1, gchar** option_values, int option_values_length1, GError** error);
static void page_finalize (Page* obj);
enum  {
	PIXBUF_WRITER_DUMMY_PROPERTY
};
static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self, guint8* buf, int buf_length1, GError** error);
static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void pixbuf_writer_finalize (PixbufWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType scan_direction_get_type (void) {
	static volatile gsize scan_direction_type_id__volatile = 0;
	if (g_once_init_enter (&scan_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_DIRECTION_TOP_TO_BOTTOM, "SCAN_DIRECTION_TOP_TO_BOTTOM", "top-to-bottom"}, {SCAN_DIRECTION_LEFT_TO_RIGHT, "SCAN_DIRECTION_LEFT_TO_RIGHT", "left-to-right"}, {SCAN_DIRECTION_BOTTOM_TO_TOP, "SCAN_DIRECTION_BOTTOM_TO_TOP", "bottom-to-top"}, {SCAN_DIRECTION_RIGHT_TO_LEFT, "SCAN_DIRECTION_RIGHT_TO_LEFT", "right-to-left"}, {0, NULL, NULL}};
		GType scan_direction_type_id;
		scan_direction_type_id = g_enum_register_static ("ScanDirection", values);
		g_once_init_leave (&scan_direction_type_id__volatile, scan_direction_type_id);
	}
	return scan_direction_type_id__volatile;
}


Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction) {
	Page* self = NULL;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_ = 0;
	gint _tmp7_ = 0;
	ScanDirection _tmp8_ = 0;
#line 67 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self = (Page*) g_type_create_instance (object_type);
#line 69 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = scan_direction;
#line 69 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 69 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = TRUE;
#line 295 "page.c"
	} else {
		ScanDirection _tmp2_ = 0;
#line 69 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp2_ = scan_direction;
#line 69 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 302 "page.c"
	}
#line 69 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp0_) {
#line 306 "page.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 71 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = width;
#line 71 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->width = _tmp3_;
#line 72 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp4_ = height;
#line 72 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->n_rows = _tmp4_;
#line 317 "page.c"
	} else {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 76 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp5_ = height;
#line 76 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->width = _tmp5_;
#line 77 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp6_ = width;
#line 77 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->n_rows = _tmp6_;
#line 329 "page.c"
	}
#line 79 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp7_ = dpi;
#line 79 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->dpi = _tmp7_;
#line 80 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp8_ = scan_direction;
#line 80 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->scan_direction = _tmp8_;
#line 67 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return self;
#line 341 "page.c"
}


Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction) {
#line 67 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return page_construct (TYPE_PAGE, width, height, dpi, scan_direction);
#line 348 "page.c"
}


void page_set_page_info (Page* self, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ScanPageInfo* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	ScanPageInfo* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	ScanPageInfo* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	ScanPageInfo* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	ScanPageInfo* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	guchar* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp21_ = 0;
#line 83 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (info != NULL);
#line 85 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = info;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = _tmp0_->height;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->expected_rows = _tmp1_;
#line 86 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = info;
#line 86 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3_ = _tmp2_->dpi;
#line 86 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->dpi = (gint) _tmp3_;
#line 89 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp4_ = info;
#line 89 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp5_ = _tmp4_->width;
#line 89 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->width = _tmp5_;
#line 90 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp6_ = info;
#line 90 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp7_ = _tmp6_->height;
#line 90 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->n_rows = _tmp7_;
#line 92 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp8_ = self->priv->n_rows;
#line 92 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp8_ < 0) {
#line 407 "page.c"
		gint _tmp9_ = 0;
#line 93 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp9_ = self->priv->width;
#line 93 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->n_rows = _tmp9_ / 2;
#line 413 "page.c"
	}
#line 94 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp10_ = info;
#line 94 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp11_ = _tmp10_->depth;
#line 94 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->depth = _tmp11_;
#line 95 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp12_ = info;
#line 95 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp13_ = _tmp12_->n_channels;
#line 95 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->n_channels = _tmp13_;
#line 96 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp14_ = self->priv->width;
#line 96 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp15_ = self->priv->depth;
#line 96 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp16_ = self->priv->n_channels;
#line 96 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->rowstride = (((_tmp14_ * _tmp15_) * _tmp16_) + 7) / 8;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp17_ = self->priv->n_rows;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp18_ = self->priv->rowstride;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp19_ = _tmp17_ * _tmp18_;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp17_ * _tmp18_);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	(_tmp19_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp19_ - self->priv->pixels_length1)) : NULL;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->pixels_length1 = _tmp19_;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->_pixels_size_ = _tmp19_;
#line 98 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp20_ = self->priv->pixels;
#line 98 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp20__length1 = self->priv->pixels_length1;
#line 98 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (_tmp20_ != NULL);
#line 101 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp21_ = self->priv->depth;
#line 101 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp21_ == 1) {
#line 459 "page.c"
		guchar* _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
#line 102 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp22_ = self->priv->pixels;
#line 102 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp22__length1 = self->priv->pixels_length1;
#line 102 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp23_ = self->priv->n_rows;
#line 102 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp24_ = self->priv->rowstride;
#line 102 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		memset (_tmp22_, 0x00, (gsize) (_tmp23_ * _tmp24_));
#line 474 "page.c"
	} else {
		guchar* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
#line 104 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp25_ = self->priv->pixels;
#line 104 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp25__length1 = self->priv->pixels_length1;
#line 104 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp26_ = self->priv->n_rows;
#line 104 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp27_ = self->priv->rowstride;
#line 104 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		memset (_tmp25_, 0xFF, (gsize) (_tmp26_ * _tmp27_));
#line 490 "page.c"
	}
#line 106 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 107 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "pixels-changed");
#line 496 "page.c"
}


void page_start (Page* self) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->scanning = TRUE;
#line 113 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 507 "page.c"
}


gboolean page_is_scanning (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 118 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->scanning;
#line 118 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 118 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 522 "page.c"
}


gboolean page_has_data (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 121 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 123 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->has_data_;
#line 123 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 123 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 537 "page.c"
}


gboolean page_is_color (Page* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 126 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 128 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->n_channels;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_ > 1;
#line 128 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 552 "page.c"
}


gint page_get_scan_line (Page* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 131 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 133 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->scan_line;
#line 133 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 133 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 567 "page.c"
}


static void page_parse_line (Page* self, ScanLine* line, gint n, gboolean* size_changed) {
	gboolean _vala_size_changed = FALSE;
	gint line_number = 0;
	ScanLine* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint offset = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint line_offset = 0;
	gint _tmp15_ = 0;
	ScanLine* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp32_ = 0;
#line 136 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 136 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (line != NULL);
#line 140 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = line;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = _tmp0_->number;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = n;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	line_number = _tmp1_ + _tmp2_;
#line 143 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_vala_size_changed = FALSE;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	while (TRUE) {
#line 601 "page.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint rows = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = line_number;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp4_ = page_get_scan_height (self);
#line 144 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (!(_tmp3_ >= _tmp4_)) {
#line 144 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 621 "page.c"
		}
#line 149 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp5_ = self->priv->n_rows;
#line 149 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		rows = _tmp5_;
#line 150 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp6_ = rows;
#line 150 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp7_ = self->priv->width;
#line 150 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->n_rows = _tmp6_ + (_tmp7_ / 2);
#line 151 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp8_ = rows;
#line 151 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp9_ = self->priv->n_rows;
#line 151 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_debug ("page.vala:151: Extending image from %d lines to %d lines", _tmp8_, _tmp9_);
#line 152 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp10_ = self->priv->n_rows;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp11_ = self->priv->rowstride;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp12_ = _tmp10_ * _tmp11_;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp10_ * _tmp11_);
#line 152 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		(_tmp12_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp12_ - self->priv->pixels_length1)) : NULL;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->pixels_length1 = _tmp12_;
#line 152 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->_pixels_size_ = _tmp12_;
#line 154 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_vala_size_changed = TRUE;
#line 655 "page.c"
	}
#line 158 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp13_ = line_number;
#line 158 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp14_ = self->priv->rowstride;
#line 158 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	offset = _tmp13_ * _tmp14_;
#line 159 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp15_ = n;
#line 159 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp16_ = line;
#line 159 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp17_ = _tmp16_->data_length;
#line 159 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	line_offset = _tmp15_ * _tmp17_;
#line 671 "page.c"
	{
		gint i = 0;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		i = 0;
#line 676 "page.c"
		{
			gboolean _tmp18_ = FALSE;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp18_ = TRUE;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			while (TRUE) {
#line 683 "page.c"
				gint _tmp20_ = 0;
				ScanLine* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				guchar* _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				ScanLine* _tmp26_ = NULL;
				guchar* _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				guchar _tmp30_ = '\0';
				guchar _tmp31_ = '\0';
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (!_tmp18_) {
#line 700 "page.c"
					gint _tmp19_ = 0;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp19_ = i;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					i = _tmp19_ + 1;
#line 706 "page.c"
				}
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp18_ = FALSE;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp20_ = i;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp21_ = line;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp22_ = _tmp21_->data_length;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (!(_tmp20_ < _tmp22_)) {
#line 160 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					break;
#line 720 "page.c"
				}
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp23_ = self->priv->pixels;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp23__length1 = self->priv->pixels_length1;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp24_ = offset;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp25_ = i;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp26_ = line;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp27_ = _tmp26_->data;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp27__length1 = _tmp26_->data_length1;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp28_ = line_offset;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp29_ = i;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp30_ = _tmp27_[_tmp28_ + _tmp29_];
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp23_[_tmp24_ + _tmp25_] = _tmp30_;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp31_ = _tmp23_[_tmp24_ + _tmp25_];
#line 746 "page.c"
			}
		}
	}
#line 163 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp32_ = line_number;
#line 163 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->scan_line = _tmp32_;
#line 136 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (size_changed) {
#line 136 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*size_changed = _vala_size_changed;
#line 758 "page.c"
	}
}


void page_parse_scan_line (Page* self, ScanLine* line) {
	gboolean size_has_changed = FALSE;
	gboolean _tmp8_ = FALSE;
#line 166 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 166 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (line != NULL);
#line 168 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	size_has_changed = FALSE;
#line 772 "page.c"
	{
		gint i = 0;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		i = 0;
#line 777 "page.c"
		{
			gboolean _tmp0_ = FALSE;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp0_ = TRUE;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			while (TRUE) {
#line 784 "page.c"
				gint _tmp2_ = 0;
				ScanLine* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				ScanLine* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gboolean _tmp7_ = FALSE;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (!_tmp0_) {
#line 793 "page.c"
					gint _tmp1_ = 0;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp1_ = i;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					i = _tmp1_ + 1;
#line 799 "page.c"
				}
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp0_ = FALSE;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp2_ = i;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp3_ = line;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp4_ = _tmp3_->n_lines;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (!(_tmp2_ < _tmp4_)) {
#line 169 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					break;
#line 813 "page.c"
				}
#line 170 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp5_ = line;
#line 170 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp6_ = i;
#line 170 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				page_parse_line (self, _tmp5_, _tmp6_, &_tmp7_);
#line 170 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				size_has_changed = _tmp7_;
#line 823 "page.c"
			}
		}
	}
#line 172 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->has_data_ = TRUE;
#line 174 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp8_ = size_has_changed;
#line 174 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp8_) {
#line 175 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 835 "page.c"
	}
#line 176 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 177 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "pixels-changed");
#line 841 "page.c"
}


void page_finish (Page* self) {
	gboolean size_has_changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp11_ = FALSE;
#line 180 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 182 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	size_has_changed = FALSE;
#line 185 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = self->priv->expected_rows;
#line 185 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp1_ < 0) {
#line 858 "page.c"
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp2_ = self->priv->scan_line;
#line 186 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = page_get_scan_height (self);
#line 186 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = _tmp2_ != _tmp3_;
#line 867 "page.c"
	} else {
#line 185 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = FALSE;
#line 871 "page.c"
	}
#line 185 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp0_) {
#line 875 "page.c"
		gint rows = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 190 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp4_ = self->priv->n_rows;
#line 190 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		rows = _tmp4_;
#line 191 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp5_ = self->priv->scan_line;
#line 191 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->n_rows = _tmp5_;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp6_ = self->priv->n_rows;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp7_ = self->priv->rowstride;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp8_ = _tmp6_ * _tmp7_;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp6_ * _tmp7_);
#line 192 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		(_tmp8_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp8_ - self->priv->pixels_length1)) : NULL;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->pixels_length1 = _tmp8_;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->_pixels_size_ = _tmp8_;
#line 193 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp9_ = rows;
#line 193 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp10_ = self->priv->n_rows;
#line 193 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_debug ("page.vala:193: Trimming page from %d lines to %d lines", _tmp9_, _tmp10_);
#line 195 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		size_has_changed = TRUE;
#line 914 "page.c"
	}
#line 197 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->scanning = FALSE;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp11_ = size_has_changed;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp11_) {
#line 200 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 924 "page.c"
	}
#line 201 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 928 "page.c"
}


ScanDirection page_get_scan_direction (Page* self) {
	ScanDirection result = 0;
	ScanDirection _tmp0_ = 0;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 206 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->scan_direction;
#line 206 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 206 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 943 "page.c"
}


static void page_set_scan_direction (Page* self, ScanDirection direction) {
	gint left_steps = 0;
	gint t = 0;
	gboolean size_has_changed = FALSE;
	gint width = 0;
	gint height = 0;
	ScanDirection _tmp0_ = 0;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	ScanDirection _tmp33_ = 0;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
#line 209 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 212 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	size_has_changed = FALSE;
#line 215 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->scan_direction;
#line 215 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = direction;
#line 215 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp0_ == _tmp1_) {
#line 216 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return;
#line 977 "page.c"
	}
#line 219 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = direction;
#line 219 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3_ = self->priv->scan_direction;
#line 219 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	left_steps = (gint) (_tmp2_ - _tmp3_);
#line 220 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp4_ = left_steps;
#line 220 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp4_ < 0) {
#line 989 "page.c"
		gint _tmp5_ = 0;
#line 221 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp5_ = left_steps;
#line 221 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		left_steps = _tmp5_ + 4;
#line 995 "page.c"
	}
#line 222 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp6_ = left_steps;
#line 222 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp6_ != 2) {
#line 223 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		size_has_changed = TRUE;
#line 1003 "page.c"
	}
#line 225 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp7_ = page_get_width (self);
#line 225 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	width = _tmp7_;
#line 226 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp8_ = page_get_height (self);
#line 226 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	height = _tmp8_;
#line 229 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp9_ = self->priv->has_crop_;
#line 229 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp9_) {
#line 1017 "page.c"
		gint _tmp10_ = 0;
#line 231 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp10_ = left_steps;
#line 231 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		switch (_tmp10_) {
#line 231 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			case 1:
#line 1025 "page.c"
			{
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
#line 235 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp11_ = self->priv->crop_x;
#line 235 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				t = _tmp11_;
#line 236 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp12_ = self->priv->crop_y;
#line 236 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_x = _tmp12_;
#line 237 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp13_ = width;
#line 237 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp14_ = t;
#line 237 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp15_ = self->priv->crop_width;
#line 237 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_y = _tmp13_ - (_tmp14_ + _tmp15_);
#line 238 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp16_ = self->priv->crop_width;
#line 238 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				t = _tmp16_;
#line 239 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp17_ = self->priv->crop_height;
#line 239 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_width = _tmp17_;
#line 240 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp18_ = t;
#line 240 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_height = _tmp18_;
#line 241 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1065 "page.c"
			}
#line 231 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			case 2:
#line 1069 "page.c"
			{
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
#line 244 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp19_ = width;
#line 244 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp20_ = self->priv->crop_x;
#line 244 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp21_ = self->priv->crop_width;
#line 244 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_x = _tmp19_ - (_tmp20_ + _tmp21_);
#line 245 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp22_ = width;
#line 245 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp23_ = self->priv->crop_y;
#line 245 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp24_ = self->priv->crop_height;
#line 245 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_y = _tmp22_ - (_tmp23_ + _tmp24_);
#line 246 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1095 "page.c"
			}
#line 231 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			case 3:
#line 1099 "page.c"
			{
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
#line 249 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp25_ = self->priv->crop_y;
#line 249 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				t = _tmp25_;
#line 250 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp26_ = self->priv->crop_x;
#line 250 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_y = _tmp26_;
#line 251 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp27_ = height;
#line 251 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp28_ = t;
#line 251 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp29_ = self->priv->crop_height;
#line 251 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_x = _tmp27_ - (_tmp28_ + _tmp29_);
#line 252 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp30_ = self->priv->crop_width;
#line 252 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				t = _tmp30_;
#line 253 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp31_ = self->priv->crop_height;
#line 253 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_width = _tmp31_;
#line 254 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp32_ = t;
#line 254 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				self->priv->crop_height = _tmp32_;
#line 255 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1139 "page.c"
			}
			default:
#line 231 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1144 "page.c"
		}
	}
#line 259 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp33_ = direction;
#line 259 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->scan_direction = _tmp33_;
#line 260 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp34_ = size_has_changed;
#line 260 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp34_) {
#line 261 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 1157 "page.c"
	}
#line 262 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "scan-direction-changed");
#line 263 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp35_ = self->priv->has_crop_;
#line 263 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp35_) {
#line 264 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_signal_emit_by_name (self, "crop-changed");
#line 1167 "page.c"
	}
}


void page_rotate_left (Page* self) {
	ScanDirection direction = 0;
	ScanDirection _tmp0_ = 0;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
#line 267 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 269 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->scan_direction;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	direction = _tmp0_;
#line 270 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = direction;
#line 270 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	switch (_tmp1_) {
#line 270 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1189 "page.c"
		{
#line 273 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 274 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1195 "page.c"
		}
#line 270 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1199 "page.c"
		{
#line 276 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 277 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1205 "page.c"
		}
#line 270 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1209 "page.c"
		{
#line 279 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 280 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1215 "page.c"
		}
#line 270 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1219 "page.c"
		{
#line 282 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 283 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1225 "page.c"
		}
		default:
#line 270 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		break;
#line 1230 "page.c"
	}
#line 285 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = direction;
#line 285 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	page_set_scan_direction (self, _tmp2_);
#line 1236 "page.c"
}


void page_rotate_right (Page* self) {
	ScanDirection direction = 0;
	ScanDirection _tmp0_ = 0;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
#line 288 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 290 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->scan_direction;
#line 290 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	direction = _tmp0_;
#line 291 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = direction;
#line 291 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	switch (_tmp1_) {
#line 291 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1257 "page.c"
		{
#line 294 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 295 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1263 "page.c"
		}
#line 291 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1267 "page.c"
		{
#line 297 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1273 "page.c"
		}
#line 291 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1277 "page.c"
		{
#line 300 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 301 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1283 "page.c"
		}
#line 291 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1287 "page.c"
		{
#line 303 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 304 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 1293 "page.c"
		}
		default:
#line 291 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		break;
#line 1298 "page.c"
	}
#line 306 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = direction;
#line 306 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	page_set_scan_direction (self, _tmp2_);
#line 1304 "page.c"
}


gint page_get_dpi (Page* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 311 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->dpi;
#line 311 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 311 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 1319 "page.c"
}


gboolean page_is_landscape (Page* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 314 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 316 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = page_get_width (self);
#line 316 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = page_get_height (self);
#line 316 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_ > _tmp1_;
#line 316 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 1337 "page.c"
}


gint page_get_width (Page* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_ = 0;
#line 319 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 321 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = self->priv->scan_direction;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 321 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = TRUE;
#line 1353 "page.c"
	} else {
		ScanDirection _tmp2_ = 0;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp2_ = self->priv->scan_direction;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 1360 "page.c"
	}
#line 321 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp0_) {
#line 1364 "page.c"
		gint _tmp3_ = 0;
#line 322 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = self->priv->width;
#line 322 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		result = _tmp3_;
#line 322 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return result;
#line 1372 "page.c"
	} else {
		gint _tmp4_ = 0;
#line 324 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp4_ = self->priv->n_rows;
#line 324 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		result = _tmp4_;
#line 324 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return result;
#line 1381 "page.c"
	}
}


gint page_get_height (Page* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_ = 0;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 329 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = self->priv->scan_direction;
#line 329 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 329 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = TRUE;
#line 1398 "page.c"
	} else {
		ScanDirection _tmp2_ = 0;
#line 329 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp2_ = self->priv->scan_direction;
#line 329 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 1405 "page.c"
	}
#line 329 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp0_) {
#line 1409 "page.c"
		gint _tmp3_ = 0;
#line 330 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = self->priv->n_rows;
#line 330 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		result = _tmp3_;
#line 330 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return result;
#line 1417 "page.c"
	} else {
		gint _tmp4_ = 0;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp4_ = self->priv->width;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		result = _tmp4_;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return result;
#line 1426 "page.c"
	}
}


gint page_get_depth (Page* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 335 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 337 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->depth;
#line 337 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 337 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 1442 "page.c"
}


gint page_get_n_channels (Page* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 340 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 342 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->n_channels;
#line 342 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 342 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 1457 "page.c"
}


gint page_get_rowstride (Page* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 345 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 347 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->rowstride;
#line 347 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 347 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 1472 "page.c"
}


gint page_get_scan_width (Page* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 350 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 352 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->width;
#line 352 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 352 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 1487 "page.c"
}


gint page_get_scan_height (Page* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 355 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 357 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->n_rows;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 1502 "page.c"
}


void page_set_color_profile (Page* self, const gchar* color_profile) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 360 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 362 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = color_profile;
#line 362 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 362 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_free0 (self->priv->color_profile);
#line 362 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->color_profile = _tmp1_;
#line 1519 "page.c"
}


gchar* page_get_color_profile (Page* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 365 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 367 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->color_profile;
#line 367 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 367 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp1_;
#line 367 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 1537 "page.c"
}


void page_set_no_crop (Page* self) {
	gboolean _tmp0_ = FALSE;
#line 370 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 372 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->has_crop_;
#line 372 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (!_tmp0_) {
#line 373 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return;
#line 1551 "page.c"
	}
#line 374 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->has_crop_ = FALSE;
#line 375 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1557 "page.c"
}


void page_set_custom_crop (Page* self, gint width, gint height) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 382 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = width;
#line 382 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (_tmp0_ >= 1);
#line 383 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = height;
#line 383 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (_tmp1_ >= 1);
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp5_ = self->priv->crop_name;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp5_ == NULL) {
#line 1584 "page.c"
		gboolean _tmp6_ = FALSE;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp6_ = self->priv->has_crop_;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp4_ = _tmp6_;
#line 1590 "page.c"
	} else {
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp4_ = FALSE;
#line 1594 "page.c"
	}
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp4_) {
#line 1598 "page.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp7_ = self->priv->crop_width;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp8_ = width;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = _tmp7_ == _tmp8_;
#line 1607 "page.c"
	} else {
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = FALSE;
#line 1611 "page.c"
	}
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp3_) {
#line 1615 "page.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp9_ = self->priv->crop_height;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp10_ = height;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp2_ = _tmp9_ == _tmp10_;
#line 1624 "page.c"
	} else {
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp2_ = FALSE;
#line 1628 "page.c"
	}
#line 385 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp2_) {
#line 386 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return;
#line 1634 "page.c"
	}
#line 387 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_free0 (self->priv->crop_name);
#line 387 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_name = NULL;
#line 388 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->has_crop_ = TRUE;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp11_ = width;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_width = _tmp11_;
#line 391 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp12_ = height;
#line 391 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_height = _tmp12_;
#line 404 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1652 "page.c"
}


void page_set_named_crop (Page* self, const gchar* name) {
	gdouble width = 0.0;
	gdouble height = 0.0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	static GQuark _tmp2_label0 = 0;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	static GQuark _tmp2_label1 = 0;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	static GQuark _tmp2_label2 = 0;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	static GQuark _tmp2_label3 = 0;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	static GQuark _tmp2_label4 = 0;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	static GQuark _tmp2_label5 = 0;
#line 1674 "page.c"
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint pw = 0;
	gint _tmp7_ = 0;
	gint ph = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gdouble _tmp14_ = 0.0;
	gint _tmp15_ = 0;
	gdouble _tmp16_ = 0.0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 407 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (name != NULL);
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = name;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = _tmp0_;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("A4")))) {
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		switch (0) {
#line 1705 "page.c"
			default:
			{
#line 413 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				width = 8.3;
#line 414 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				height = 11.7;
#line 415 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1714 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("A5")))) {
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		switch (0) {
#line 1720 "page.c"
			default:
			{
#line 417 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				width = 5.8;
#line 418 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				height = 8.3;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1729 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("A6")))) {
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		switch (0) {
#line 1735 "page.c"
			default:
			{
#line 421 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				width = 4.1;
#line 422 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				height = 5.8;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1744 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("letter")))) {
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		switch (0) {
#line 1750 "page.c"
			default:
			{
#line 425 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				width = 8.5;
#line 426 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				height = (gdouble) 11;
#line 427 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1759 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("legal")))) {
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		switch (0) {
#line 1765 "page.c"
			default:
			{
#line 429 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				width = 8.5;
#line 430 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				height = (gdouble) 14;
#line 431 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1774 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("4x6")))) {
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		switch (0) {
#line 1780 "page.c"
			default:
			{
#line 433 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				width = (gdouble) 4;
#line 434 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				height = (gdouble) 6;
#line 435 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				break;
#line 1789 "page.c"
			}
		}
	} else {
#line 410 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		switch (0) {
#line 1795 "page.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp4_ = name;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				g_warning ("page.vala:437: Unknown paper size '%s'", _tmp4_);
#line 438 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				return;
#line 1805 "page.c"
			}
		}
	}
#line 441 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp5_ = name;
#line 441 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 441 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_free0 (self->priv->crop_name);
#line 441 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_name = _tmp6_;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->has_crop_ = TRUE;
#line 444 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp7_ = page_get_width (self);
#line 444 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	pw = _tmp7_;
#line 445 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp8_ = page_get_height (self);
#line 445 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	ph = _tmp8_;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp9_ = pw;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp10_ = ph;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp9_ > _tmp10_) {
#line 1833 "page.c"
		gdouble t = 0.0;
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp11_ = width;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		t = _tmp11_;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp12_ = height;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		width = _tmp12_;
#line 453 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp13_ = t;
#line 453 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		height = _tmp13_;
#line 1850 "page.c"
	}
#line 457 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp14_ = width;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp15_ = self->priv->dpi;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_width = (gint) ((_tmp14_ * _tmp15_) + 0.5);
#line 458 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp16_ = height;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp17_ = self->priv->dpi;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_height = (gint) ((_tmp16_ * _tmp17_) + 0.5);
#line 460 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp18_ = self->priv->crop_width;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp19_ = pw;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp18_ < _tmp19_) {
#line 1870 "page.c"
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 461 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp20_ = pw;
#line 461 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp21_ = self->priv->crop_width;
#line 461 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->crop_x = (_tmp20_ - _tmp21_) / 2;
#line 1879 "page.c"
	} else {
#line 463 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->crop_x = 0;
#line 1883 "page.c"
	}
#line 464 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp22_ = self->priv->crop_height;
#line 464 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp23_ = ph;
#line 464 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp22_ < _tmp23_) {
#line 1891 "page.c"
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp24_ = ph;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp25_ = self->priv->crop_height;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->crop_y = (_tmp24_ - _tmp25_) / 2;
#line 1900 "page.c"
	} else {
#line 467 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		self->priv->crop_y = 0;
#line 1904 "page.c"
	}
#line 468 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1908 "page.c"
}


void page_move_crop (Page* self, gint x, gint y) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 471 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 473 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = x;
#line 473 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (_tmp0_ >= 0);
#line 474 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = y;
#line 474 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (_tmp1_ >= 0);
#line 475 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = x;
#line 475 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3_ = page_get_width (self);
#line 475 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (_tmp2_ < _tmp3_);
#line 476 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp4_ = y;
#line 476 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp5_ = page_get_height (self);
#line 476 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (_tmp4_ < _tmp5_);
#line 478 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp6_ = x;
#line 478 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_x = _tmp6_;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp7_ = y;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_y = _tmp7_;
#line 480 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1953 "page.c"
}


void page_rotate_crop (Page* self) {
	gint t = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 483 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 487 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->has_crop_;
#line 487 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (!_tmp0_) {
#line 488 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return;
#line 1972 "page.c"
	}
#line 490 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = self->priv->crop_width;
#line 490 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	t = _tmp1_;
#line 491 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = self->priv->crop_height;
#line 491 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_width = _tmp2_;
#line 492 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3_ = t;
#line 492 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->crop_height = _tmp3_;
#line 495 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp4_ = self->priv->crop_name;
#line 495 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp4_ == NULL) {
#line 1990 "page.c"
		gint w = 0;
		gint h = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp12_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp19_ = 0;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp5_ = page_get_width (self);
#line 499 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		w = _tmp5_;
#line 500 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp6_ = page_get_height (self);
#line 500 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		h = _tmp6_;
#line 502 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp7_ = self->priv->crop_x;
#line 502 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp8_ = self->priv->crop_width;
#line 502 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp9_ = w;
#line 502 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if ((_tmp7_ + _tmp8_) > _tmp9_) {
#line 2019 "page.c"
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp10_ = w;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp11_ = self->priv->crop_width;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			self->priv->crop_x = _tmp10_ - _tmp11_;
#line 2028 "page.c"
		}
#line 504 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp12_ = self->priv->crop_x;
#line 504 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp12_ < 0) {
#line 2034 "page.c"
			gint _tmp13_ = 0;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			self->priv->crop_x = 0;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp13_ = w;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			self->priv->crop_width = _tmp13_;
#line 2042 "page.c"
		}
#line 509 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp14_ = self->priv->crop_y;
#line 509 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp15_ = self->priv->crop_height;
#line 509 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp16_ = h;
#line 509 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if ((_tmp14_ + _tmp15_) > _tmp16_) {
#line 2052 "page.c"
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
#line 510 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp17_ = h;
#line 510 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp18_ = self->priv->crop_height;
#line 510 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			self->priv->crop_y = _tmp17_ - _tmp18_;
#line 2061 "page.c"
		}
#line 511 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp19_ = self->priv->crop_y;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp19_ < 0) {
#line 2067 "page.c"
			gint _tmp20_ = 0;
#line 513 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			self->priv->crop_y = 0;
#line 514 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp20_ = h;
#line 514 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			self->priv->crop_height = _tmp20_;
#line 2075 "page.c"
		}
	}
#line 518 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 2080 "page.c"
}


gboolean page_has_crop (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 523 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->has_crop_;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp0_;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 2095 "page.c"
}


void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 528 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->crop_x;
#line 528 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_vala_x = _tmp0_;
#line 529 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = self->priv->crop_y;
#line 529 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_vala_y = _tmp1_;
#line 530 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = self->priv->crop_width;
#line 530 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_vala_width = _tmp2_;
#line 531 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3_ = self->priv->crop_height;
#line 531 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_vala_height = _tmp3_;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (x) {
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*x = _vala_x;
#line 2130 "page.c"
	}
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (y) {
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*y = _vala_y;
#line 2136 "page.c"
	}
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (width) {
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*width = _vala_width;
#line 2142 "page.c"
	}
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (height) {
#line 526 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*height = _vala_height;
#line 2148 "page.c"
	}
}


gchar* page_get_named_crop (Page* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 534 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 536 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->crop_name;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 536 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp1_;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 2167 "page.c"
}


guchar* page_get_pixels (Page* self, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 539 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 541 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->priv->pixels;
#line 541 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0__length1 = self->priv->pixels_length1;
#line 541 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = _tmp0_;
#line 541 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1__length1 = _tmp0__length1;
#line 541 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (result_length1) {
#line 541 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*result_length1 = _tmp1__length1;
#line 2191 "page.c"
	}
#line 541 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp1_;
#line 541 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 2197 "page.c"
}


static guchar page_get_sample (Page* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint n_channels, gint channel) {
	guchar result = '\0';
#line 545 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 548 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = (guchar) 0xFF;
#line 548 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 2209 "page.c"
}


static void page_get_pixel (Page* self, gint x, gint y, guchar* pixel, int pixel_length1, gint offset) {
	ScanDirection _tmp0_ = 0;
	gint depth = 0;
	gint _tmp13_ = 0;
	gint n_channels = 0;
	gint _tmp14_ = 0;
	gint line_offset = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_ = 0;
	guchar* _tmp99_ = NULL;
	gint _tmp99__length1 = 0;
	gint _tmp100_ = 0;
	guchar* _tmp101_ = NULL;
	gint _tmp101__length1 = 0;
	gint _tmp102_ = 0;
	gint _tmp103_ = 0;
	gint _tmp104_ = 0;
	gint _tmp105_ = 0;
	guchar _tmp106_ = '\0';
	guchar _tmp107_ = '\0';
	guchar* _tmp108_ = NULL;
	gint _tmp108__length1 = 0;
	gint _tmp109_ = 0;
	guchar* _tmp110_ = NULL;
	gint _tmp110__length1 = 0;
	gint _tmp111_ = 0;
	gint _tmp112_ = 0;
	gint _tmp113_ = 0;
	gint _tmp114_ = 0;
	guchar _tmp115_ = '\0';
	guchar _tmp116_ = '\0';
	guchar* _tmp117_ = NULL;
	gint _tmp117__length1 = 0;
	gint _tmp118_ = 0;
	guchar* _tmp119_ = NULL;
	gint _tmp119__length1 = 0;
	gint _tmp120_ = 0;
	gint _tmp121_ = 0;
	gint _tmp122_ = 0;
	gint _tmp123_ = 0;
	guchar _tmp124_ = '\0';
	guchar _tmp125_ = '\0';
#line 552 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 554 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = page_get_scan_direction (self);
#line 554 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	switch (_tmp0_) {
#line 554 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 2265 "page.c"
		{
#line 557 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 2269 "page.c"
		}
#line 554 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 2273 "page.c"
		{
			gint _tmp1_ = 0;
			gint _tmp2_ = 0;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
#line 559 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp1_ = page_get_scan_width (self);
#line 559 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp2_ = x;
#line 559 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			x = (_tmp1_ - _tmp2_) - 1;
#line 560 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp3_ = page_get_scan_height (self);
#line 560 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp4_ = y;
#line 560 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			y = (_tmp3_ - _tmp4_) - 1;
#line 561 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 2293 "page.c"
		}
#line 554 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 2297 "page.c"
		{
			gint t = 0;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
#line 563 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp5_ = x;
#line 563 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			t = _tmp5_;
#line 564 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp6_ = page_get_scan_width (self);
#line 564 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp7_ = y;
#line 564 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			x = (_tmp6_ - _tmp7_) - 1;
#line 565 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp8_ = t;
#line 565 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			y = _tmp8_;
#line 566 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 2320 "page.c"
		}
#line 554 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 2324 "page.c"
		{
			gint t = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
#line 568 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp9_ = x;
#line 568 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			t = _tmp9_;
#line 569 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp10_ = y;
#line 569 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			x = _tmp10_;
#line 570 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp11_ = page_get_scan_height (self);
#line 570 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp12_ = t;
#line 570 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			y = (_tmp11_ - _tmp12_) - 1;
#line 571 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			break;
#line 2347 "page.c"
		}
		default:
#line 554 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		break;
#line 2352 "page.c"
	}
#line 574 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp13_ = page_get_depth (self);
#line 574 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	depth = _tmp13_;
#line 575 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp14_ = page_get_n_channels (self);
#line 575 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	n_channels = _tmp14_;
#line 576 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp15_ = page_get_rowstride (self);
#line 576 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp16_ = y;
#line 576 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	line_offset = _tmp15_ * _tmp16_;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp18_ = depth;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp18_ == 8) {
#line 2372 "page.c"
		gint _tmp19_ = 0;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp19_ = n_channels;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp17_ = _tmp19_ == 3;
#line 2378 "page.c"
	} else {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp17_ = FALSE;
#line 2382 "page.c"
	}
#line 579 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp17_) {
#line 2386 "page.c"
		gint o = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		guchar* _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gint _tmp24_ = 0;
		guchar* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp26_ = 0;
		guchar _tmp27_ = '\0';
		guchar _tmp28_ = '\0';
		guchar* _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		gint _tmp30_ = 0;
		guchar* _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gint _tmp32_ = 0;
		guchar _tmp33_ = '\0';
		guchar _tmp34_ = '\0';
		guchar* _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gint _tmp36_ = 0;
		guchar* _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		gint _tmp38_ = 0;
		guchar _tmp39_ = '\0';
		guchar _tmp40_ = '\0';
#line 581 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp20_ = line_offset;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp21_ = x;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp22_ = n_channels;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		o = _tmp20_ + (_tmp21_ * _tmp22_);
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp23_ = pixel;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp23__length1 = pixel_length1;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp24_ = offset;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp25_ = self->priv->pixels;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp25__length1 = self->priv->pixels_length1;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp26_ = o;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp27_ = _tmp25_[_tmp26_];
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp23_[_tmp24_ + 0] = _tmp27_;
#line 582 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp28_ = _tmp23_[_tmp24_ + 0];
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp29_ = pixel;
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp29__length1 = pixel_length1;
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp30_ = offset;
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp31_ = self->priv->pixels;
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp31__length1 = self->priv->pixels_length1;
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp32_ = o;
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp33_ = _tmp31_[_tmp32_ + 1];
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp29_[_tmp30_ + 1] = _tmp33_;
#line 583 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp34_ = _tmp29_[_tmp30_ + 1];
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp35_ = pixel;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp35__length1 = pixel_length1;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp36_ = offset;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp37_ = self->priv->pixels;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp37__length1 = self->priv->pixels_length1;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp38_ = o;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp39_ = _tmp37_[_tmp38_ + 2];
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp35_[_tmp36_ + 2] = _tmp39_;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp40_ = _tmp35_[_tmp36_ + 2];
#line 585 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return;
#line 2479 "page.c"
	} else {
		gboolean _tmp41_ = FALSE;
		gint _tmp42_ = 0;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp42_ = depth;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp42_ == 8) {
#line 2487 "page.c"
			gint _tmp43_ = 0;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp43_ = n_channels;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp41_ = _tmp43_ == 1;
#line 2493 "page.c"
		} else {
#line 587 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp41_ = FALSE;
#line 2497 "page.c"
		}
#line 587 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp41_) {
#line 2501 "page.c"
			guchar p = '\0';
			guchar* _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			guchar _tmp47_ = '\0';
			guchar* _tmp48_ = NULL;
			gint _tmp48__length1 = 0;
			gint _tmp49_ = 0;
			guchar* _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			gint _tmp51_ = 0;
			guchar* _tmp52_ = NULL;
			gint _tmp52__length1 = 0;
			gint _tmp53_ = 0;
			guchar _tmp54_ = '\0';
			guchar _tmp55_ = '\0';
			guchar _tmp56_ = '\0';
			guchar _tmp57_ = '\0';
#line 589 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp44_ = self->priv->pixels;
#line 589 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp44__length1 = self->priv->pixels_length1;
#line 589 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp45_ = line_offset;
#line 589 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp46_ = x;
#line 589 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp47_ = _tmp44_[_tmp45_ + _tmp46_];
#line 589 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			p = _tmp47_;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp48_ = pixel;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp48__length1 = pixel_length1;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp49_ = offset;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp50_ = pixel;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp50__length1 = pixel_length1;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp51_ = offset;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp52_ = pixel;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp52__length1 = pixel_length1;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp53_ = offset;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp54_ = p;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp52_[_tmp53_ + 2] = _tmp54_;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp55_ = _tmp52_[_tmp53_ + 2];
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp50_[_tmp51_ + 1] = _tmp55_;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp56_ = _tmp50_[_tmp51_ + 1];
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp48_[_tmp49_ + 0] = _tmp56_;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp57_ = _tmp48_[_tmp49_ + 0];
#line 591 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			return;
#line 2567 "page.c"
		} else {
			gboolean _tmp58_ = FALSE;
			gint _tmp59_ = 0;
#line 595 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp59_ = depth;
#line 595 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			if (_tmp59_ == 1) {
#line 2575 "page.c"
				gint _tmp60_ = 0;
#line 595 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp60_ = n_channels;
#line 595 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp58_ = _tmp60_ == 1;
#line 2581 "page.c"
			} else {
#line 595 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp58_ = FALSE;
#line 2585 "page.c"
			}
#line 595 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			if (_tmp58_) {
#line 2589 "page.c"
				guchar p = '\0';
				guchar* _tmp61_ = NULL;
				gint _tmp61__length1 = 0;
				gint _tmp62_ = 0;
				gint _tmp63_ = 0;
				guchar _tmp64_ = '\0';
				gint _tmp65_ = 0;
				guchar _tmp66_ = '\0';
				gint _tmp67_ = 0;
				guchar* _tmp68_ = NULL;
				gint _tmp68__length1 = 0;
				gint _tmp69_ = 0;
				guchar* _tmp70_ = NULL;
				gint _tmp70__length1 = 0;
				gint _tmp71_ = 0;
				guchar* _tmp72_ = NULL;
				gint _tmp72__length1 = 0;
				gint _tmp73_ = 0;
				guchar _tmp74_ = '\0';
				guchar _tmp75_ = '\0';
				guchar _tmp76_ = '\0';
#line 597 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp61_ = self->priv->pixels;
#line 597 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp61__length1 = self->priv->pixels_length1;
#line 597 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp62_ = line_offset;
#line 597 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp63_ = x;
#line 597 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp64_ = _tmp61_[_tmp62_ + (_tmp63_ / 8)];
#line 597 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				p = _tmp64_;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp66_ = p;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp67_ = x;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (((gint) (_tmp66_ & (0x80 >> (_tmp67_ % 8)))) != 0) {
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp65_ = 0x00;
#line 2631 "page.c"
				} else {
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp65_ = 0xFF;
#line 2635 "page.c"
				}
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp68_ = pixel;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp68__length1 = pixel_length1;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp69_ = offset;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp70_ = pixel;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp70__length1 = pixel_length1;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp71_ = offset;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp72_ = pixel;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp72__length1 = pixel_length1;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp73_ = offset;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp72_[_tmp73_ + 2] = (guchar) _tmp65_;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp74_ = _tmp72_[_tmp73_ + 2];
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp70_[_tmp71_ + 1] = _tmp74_;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp75_ = _tmp70_[_tmp71_ + 1];
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp68_[_tmp69_ + 0] = _tmp75_;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp76_ = _tmp68_[_tmp69_ + 0];
#line 599 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				return;
#line 2669 "page.c"
			} else {
				gboolean _tmp77_ = FALSE;
				gint _tmp78_ = 0;
#line 603 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp78_ = depth;
#line 603 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (_tmp78_ == 2) {
#line 2677 "page.c"
					gint _tmp79_ = 0;
#line 603 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp79_ = n_channels;
#line 603 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp77_ = _tmp79_ == 1;
#line 2683 "page.c"
				} else {
#line 603 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp77_ = FALSE;
#line 2687 "page.c"
				}
#line 603 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (_tmp77_) {
#line 2691 "page.c"
					gint block_shift[4] = {0};
					gint _tmp80_[4] = {0};
					guchar p = '\0';
					guchar* _tmp81_ = NULL;
					gint _tmp81__length1 = 0;
					gint _tmp82_ = 0;
					gint _tmp83_ = 0;
					guchar _tmp84_ = '\0';
					gint sample = 0;
					guchar _tmp85_ = '\0';
					gint _tmp86_ = 0;
					gint _tmp87_ = 0;
					gint _tmp88_ = 0;
					guchar* _tmp89_ = NULL;
					gint _tmp89__length1 = 0;
					gint _tmp90_ = 0;
					guchar* _tmp91_ = NULL;
					gint _tmp91__length1 = 0;
					gint _tmp92_ = 0;
					guchar* _tmp93_ = NULL;
					gint _tmp93__length1 = 0;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
					guchar _tmp96_ = '\0';
					guchar _tmp97_ = '\0';
					guchar _tmp98_ = '\0';
#line 605 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp80_[0] = 6;
#line 605 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp80_[1] = 4;
#line 605 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp80_[2] = 2;
#line 605 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp80_[3] = 0;
#line 605 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					memcpy (block_shift, _tmp80_, 4 * sizeof (gint));
#line 607 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp81_ = self->priv->pixels;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp81__length1 = self->priv->pixels_length1;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp82_ = line_offset;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp83_ = x;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp84_ = _tmp81_[_tmp82_ + (_tmp83_ / 4)];
#line 607 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					p = _tmp84_;
#line 608 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp85_ = p;
#line 608 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp86_ = x;
#line 608 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp87_ = block_shift[_tmp86_ % 4];
#line 608 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					sample = (_tmp85_ >> _tmp87_) & 0x3;
#line 609 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp88_ = sample;
#line 609 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					sample = (_tmp88_ * 255) / 3;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp89_ = pixel;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp89__length1 = pixel_length1;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp90_ = offset;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp91_ = pixel;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp91__length1 = pixel_length1;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp92_ = offset;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp93_ = pixel;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp93__length1 = pixel_length1;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp94_ = offset;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp95_ = sample;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp93_[_tmp94_ + 2] = (guchar) _tmp95_;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp96_ = _tmp93_[_tmp94_ + 2];
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp91_[_tmp92_ + 1] = _tmp96_;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp97_ = _tmp91_[_tmp92_ + 1];
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp89_[_tmp90_ + 0] = _tmp97_;
#line 611 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp98_ = _tmp89_[_tmp90_ + 0];
#line 612 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					return;
#line 2786 "page.c"
				}
			}
		}
	}
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp99_ = pixel;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp99__length1 = pixel_length1;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp100_ = offset;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp101_ = self->priv->pixels;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp101__length1 = self->priv->pixels_length1;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp102_ = line_offset;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp103_ = x;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp104_ = depth;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp105_ = n_channels;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp106_ = page_get_sample (self, _tmp101_, _tmp101__length1, _tmp102_, _tmp103_, _tmp104_, _tmp105_, 0);
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp99_[_tmp100_ + 0] = _tmp106_;
#line 616 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp107_ = _tmp99_[_tmp100_ + 0];
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp108_ = pixel;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp108__length1 = pixel_length1;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp109_ = offset;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp110_ = self->priv->pixels;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp110__length1 = self->priv->pixels_length1;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp111_ = line_offset;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp112_ = x;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp113_ = depth;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp114_ = n_channels;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp115_ = page_get_sample (self, _tmp110_, _tmp110__length1, _tmp111_, _tmp112_, _tmp113_, _tmp114_, 1);
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp108_[_tmp109_ + 1] = _tmp115_;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp116_ = _tmp108_[_tmp109_ + 1];
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp117_ = pixel;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp117__length1 = pixel_length1;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp118_ = offset;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp119_ = self->priv->pixels;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp119__length1 = self->priv->pixels_length1;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp120_ = line_offset;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp121_ = x;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp122_ = depth;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp123_ = n_channels;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp124_ = page_get_sample (self, _tmp119_, _tmp119__length1, _tmp120_, _tmp121_, _tmp122_, _tmp123_, 2);
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp117_[_tmp118_ + 2] = _tmp124_;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp125_ = _tmp117_[_tmp118_ + 2];
#line 2863 "page.c"
}


GdkPixbuf* page_get_image (Page* self, gboolean apply_crop) {
	GdkPixbuf* result = NULL;
	gint l = 0;
	gint r = 0;
	gint t = 0;
	gint b = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkPixbuf* image = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GdkPixbuf* _tmp23_ = NULL;
	guint8* image_pixels = NULL;
	GdkPixbuf* _tmp24_ = NULL;
	guint8* _tmp25_ = NULL;
	gint image_pixels_length1 = 0;
	gint _image_pixels_size_ = 0;
#line 621 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 624 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = apply_crop;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp1_) {
#line 2892 "page.c"
		gboolean _tmp2_ = FALSE;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp2_ = self->priv->has_crop_;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = _tmp2_;
#line 2898 "page.c"
	} else {
#line 624 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = FALSE;
#line 2902 "page.c"
	}
#line 624 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp0_) {
#line 2906 "page.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 626 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = self->priv->crop_x;
#line 626 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		l = _tmp3_;
#line 627 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp4_ = l;
#line 627 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp5_ = self->priv->crop_width;
#line 627 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		r = _tmp4_ + _tmp5_;
#line 628 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp6_ = self->priv->crop_y;
#line 628 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		t = _tmp6_;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp7_ = t;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp8_ = self->priv->crop_height;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		b = _tmp7_ + _tmp8_;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp9_ = l;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp9_ < 0) {
#line 632 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			l = 0;
#line 2945 "page.c"
		}
#line 633 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp10_ = r;
#line 633 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp11_ = page_get_width (self);
#line 633 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp10_ > _tmp11_) {
#line 2953 "page.c"
			gint _tmp12_ = 0;
#line 634 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp12_ = page_get_width (self);
#line 634 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			r = _tmp12_;
#line 2959 "page.c"
		}
#line 635 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp13_ = t;
#line 635 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp13_ < 0) {
#line 636 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			t = 0;
#line 2967 "page.c"
		}
#line 637 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp14_ = b;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp15_ = page_get_height (self);
#line 637 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp14_ > _tmp15_) {
#line 2975 "page.c"
			gint _tmp16_ = 0;
#line 638 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp16_ = page_get_height (self);
#line 638 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			b = _tmp16_;
#line 2981 "page.c"
		}
	} else {
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
#line 642 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		l = 0;
#line 643 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp17_ = page_get_width (self);
#line 643 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		r = _tmp17_;
#line 644 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		t = 0;
#line 645 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp18_ = page_get_height (self);
#line 645 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		b = _tmp18_;
#line 2998 "page.c"
	}
#line 648 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp19_ = r;
#line 648 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp20_ = l;
#line 648 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp21_ = b;
#line 648 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp22_ = t;
#line 648 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp23_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp19_ - _tmp20_, _tmp21_ - _tmp22_);
#line 648 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	image = _tmp23_;
#line 649 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp24_ = image;
#line 649 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp25_ = gdk_pixbuf_get_pixels (_tmp24_);
#line 649 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	image_pixels = _tmp25_;
#line 649 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	image_pixels_length1 = -1;
#line 649 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_image_pixels_size_ = image_pixels_length1;
#line 3022 "page.c"
	{
		gint y = 0;
		gint _tmp26_ = 0;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp26_ = t;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		y = _tmp26_;
#line 3030 "page.c"
		{
			gboolean _tmp27_ = FALSE;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp27_ = TRUE;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			while (TRUE) {
#line 3037 "page.c"
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint offset = 0;
				GdkPixbuf* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (!_tmp27_) {
#line 3047 "page.c"
					gint _tmp28_ = 0;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp28_ = y;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					y = _tmp28_ + 1;
#line 3053 "page.c"
				}
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp27_ = FALSE;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp29_ = y;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp30_ = b;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (!(_tmp29_ < _tmp30_)) {
#line 650 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					break;
#line 3065 "page.c"
				}
#line 652 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp31_ = image;
#line 652 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp32_ = gdk_pixbuf_get_rowstride (_tmp31_);
#line 652 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp33_ = y;
#line 652 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp34_ = t;
#line 652 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				offset = _tmp32_ * (_tmp33_ - _tmp34_);
#line 3077 "page.c"
				{
					gint x = 0;
					gint _tmp35_ = 0;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp35_ = l;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					x = _tmp35_;
#line 3085 "page.c"
					{
						gboolean _tmp36_ = FALSE;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
						_tmp36_ = TRUE;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
						while (TRUE) {
#line 3092 "page.c"
							gint _tmp38_ = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							guint8* _tmp42_ = NULL;
							gint _tmp42__length1 = 0;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							if (!_tmp36_) {
#line 3104 "page.c"
								gint _tmp37_ = 0;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
								_tmp37_ = x;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
								x = _tmp37_ + 1;
#line 3110 "page.c"
							}
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp36_ = FALSE;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp38_ = x;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp39_ = r;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							if (!(_tmp38_ < _tmp39_)) {
#line 653 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
								break;
#line 3122 "page.c"
							}
#line 654 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp40_ = x;
#line 654 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp41_ = y;
#line 654 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp42_ = image_pixels;
#line 654 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp42__length1 = image_pixels_length1;
#line 654 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp43_ = offset;
#line 654 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp44_ = x;
#line 654 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							_tmp45_ = l;
#line 654 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
							page_get_pixel (self, _tmp40_, _tmp41_, _tmp42_, _tmp42__length1, _tmp43_ + ((_tmp44_ - _tmp45_) * 3));
#line 3140 "page.c"
						}
					}
				}
			}
		}
	}
#line 657 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = image;
#line 657 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 3151 "page.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1303 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1305 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1305 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 3206 "page.c"
	}
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 3212 "page.c"
}


static gchar* page_get_icc_data_encoded (Page* self, const gchar* icc_profile_filename) {
	gchar* result = NULL;
	gchar* contents = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 660 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 660 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (icc_profile_filename != NULL, NULL);
#line 3231 "page.c"
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
#line 666 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp0_ = icc_profile_filename;
#line 666 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
#line 666 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_g_free0 (contents);
#line 666 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		contents = _tmp1_;
#line 666 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_inner_error_ != NULL) {
#line 3245 "page.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 664 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		e = _inner_error_;
#line 664 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_inner_error_ = NULL;
#line 670 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp2_ = e;
#line 670 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp3_ = _tmp2_->message;
#line 670 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_warning ("page.vala:670: failed to get icc profile data: %s", _tmp3_);
#line 671 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		result = NULL;
#line 671 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_g_error_free0 (e);
#line 671 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_g_free0 (contents);
#line 671 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return result;
#line 3273 "page.c"
	}
	__finally2:
#line 664 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_inner_error_ != NULL) {
#line 664 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_g_free0 (contents);
#line 664 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 664 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_clear_error (&_inner_error_);
#line 664 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return NULL;
#line 3286 "page.c"
	}
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp4_ = contents;
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp6_ = string_to_utf8 (_tmp4_, &_tmp5_);
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp7_ = (guchar*) _tmp6_;
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp7__length1 = (_tmp5_ * sizeof (gchar)) / sizeof (guchar);
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp8_ = g_base64_encode (_tmp7_, (_tmp5_ * sizeof (gchar)) / sizeof (guchar));
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp9_ = _tmp8_;
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp7_ = (g_free (_tmp7_), NULL);
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = _tmp9_;
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_free0 (contents);
#line 675 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 3308 "page.c"
}


void page_save (Page* self, const gchar* type, GFile* file, GError** error) {
	GFileOutputStream* stream = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	PixbufWriter* writer = NULL;
	GFileOutputStream* _tmp2_ = NULL;
	PixbufWriter* _tmp3_ = NULL;
	GdkPixbuf* image = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	gchar* icc_profile_data = NULL;
	const gchar* _tmp5_ = NULL;
	GCompareFunc _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GError * _inner_error_ = NULL;
#line 678 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 678 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (type != NULL);
#line 678 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (file != NULL);
#line 680 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = file;
#line 680 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 680 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	stream = _tmp1_;
#line 680 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_inner_error_ != NULL) {
#line 680 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 680 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return;
#line 3345 "page.c"
	}
#line 681 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = stream;
#line 681 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3_ = pixbuf_writer_new (_tmp2_);
#line 681 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	writer = _tmp3_;
#line 682 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp4_ = page_get_image (self, TRUE);
#line 682 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	image = _tmp4_;
#line 684 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	icc_profile_data = NULL;
#line 685 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp5_ = self->priv->color_profile;
#line 685 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp5_ != NULL) {
#line 3363 "page.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 686 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp6_ = self->priv->color_profile;
#line 686 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp7_ = page_get_icc_data_encoded (self, _tmp6_);
#line 686 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_g_free0 (icc_profile_data);
#line 686 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		icc_profile_data = _tmp7_;
#line 3374 "page.c"
	}
#line 688 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp8_ = g_strcmp0;
#line 688 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp9_ = type;
#line 688 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp10_ = _tmp8_ (_tmp9_, "jpeg");
#line 688 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_tmp10_ == 0) {
#line 3384 "page.c"
		gchar** keys = NULL;
		gchar* _tmp11_ = NULL;
		gchar** _tmp12_ = NULL;
		gint keys_length1 = 0;
		gint _keys_size_ = 0;
		gchar** values = NULL;
		gchar* _tmp13_ = NULL;
		gchar** _tmp14_ = NULL;
		gint values_length1 = 0;
		gint _values_size_ = 0;
		PixbufWriter* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
#line 691 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp11_ = g_strdup ("quality");
#line 691 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp12_ = g_new0 (gchar*, 2 + 1);
#line 691 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp12_[0] = _tmp11_;
#line 691 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp12_[1] = NULL;
#line 691 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		keys = _tmp12_;
#line 691 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		keys_length1 = 2;
#line 691 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_keys_size_ = keys_length1;
#line 692 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp13_ = g_strdup ("90");
#line 692 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp14_ = g_new0 (gchar*, 2 + 1);
#line 692 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp14_[0] = _tmp13_;
#line 692 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp14_[1] = NULL;
#line 692 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		values = _tmp14_;
#line 692 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		values_length1 = 2;
#line 692 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_values_size_ = values_length1;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp15_ = writer;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp16_ = image;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp17_ = keys;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp17__length1 = keys_length1;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp18_ = values;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp18__length1 = values_length1;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		pixbuf_writer_save (_tmp15_, _tmp16_, "jpeg", _tmp17_, _tmp17__length1, _tmp18_, _tmp18__length1, &_inner_error_);
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_inner_error_ != NULL) {
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			g_propagate_error (error, _inner_error_);
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_g_free0 (icc_profile_data);
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_g_object_unref0 (image);
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_pixbuf_writer_unref0 (writer);
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_g_object_unref0 (stream);
#line 693 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			return;
#line 3461 "page.c"
		}
#line 688 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 688 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3467 "page.c"
	} else {
		GCompareFunc _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gint _tmp21_ = 0;
#line 695 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp19_ = g_strcmp0;
#line 695 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp20_ = type;
#line 695 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		_tmp21_ = _tmp19_ (_tmp20_, "png");
#line 695 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (_tmp21_ == 0) {
#line 3480 "page.c"
			gchar** keys = NULL;
			gchar* _tmp22_ = NULL;
			gchar** _tmp23_ = NULL;
			gint keys_length1 = 0;
			gint _keys_size_ = 0;
			gchar** values = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gint values_length1 = 0;
			gint _values_size_ = 0;
			const gchar* _tmp27_ = NULL;
			PixbufWriter* _tmp30_ = NULL;
			GdkPixbuf* _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			gchar** _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
#line 697 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp22_ = g_strdup ("icc-profile");
#line 697 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp23_ = g_new0 (gchar*, 2 + 1);
#line 697 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp23_[0] = _tmp22_;
#line 697 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp23_[1] = NULL;
#line 697 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			keys = _tmp23_;
#line 697 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			keys_length1 = 2;
#line 697 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_keys_size_ = keys_length1;
#line 698 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp24_ = icc_profile_data;
#line 698 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp25_ = g_strdup (_tmp24_);
#line 698 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp26_ = g_new0 (gchar*, 2 + 1);
#line 698 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp26_[0] = _tmp25_;
#line 698 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp26_[1] = NULL;
#line 698 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			values = _tmp26_;
#line 698 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			values_length1 = 2;
#line 698 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_values_size_ = values_length1;
#line 699 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp27_ = icc_profile_data;
#line 699 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			if (_tmp27_ == NULL) {
#line 3533 "page.c"
				gchar** _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gchar* _tmp29_ = NULL;
#line 700 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp28_ = keys;
#line 700 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp28__length1 = keys_length1;
#line 700 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_g_free0 (_tmp28_[0]);
#line 700 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp28_[0] = NULL;
#line 700 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp29_ = _tmp28_[0];
#line 3547 "page.c"
			}
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp30_ = writer;
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp31_ = image;
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp32_ = keys;
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp32__length1 = keys_length1;
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp33_ = values;
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp33__length1 = values_length1;
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			pixbuf_writer_save (_tmp30_, _tmp31_, "png", _tmp32_, _tmp32__length1, _tmp33_, _tmp33__length1, &_inner_error_);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			if (_inner_error_ != NULL) {
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				g_propagate_error (error, _inner_error_);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_g_free0 (icc_profile_data);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_g_object_unref0 (image);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_pixbuf_writer_unref0 (writer);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_g_object_unref0 (stream);
#line 701 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				return;
#line 3581 "page.c"
			}
#line 695 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 695 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3587 "page.c"
		} else {
			GCompareFunc _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			gint _tmp36_ = 0;
#line 703 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp34_ = g_strcmp0;
#line 703 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp35_ = type;
#line 703 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			_tmp36_ = _tmp34_ (_tmp35_, "tiff");
#line 703 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			if (_tmp36_ == 0) {
#line 3600 "page.c"
				gchar** keys = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint keys_length1 = 0;
				gint _keys_size_ = 0;
				gchar** values = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar** _tmp43_ = NULL;
				gint values_length1 = 0;
				gint _values_size_ = 0;
				const gchar* _tmp44_ = NULL;
				PixbufWriter* _tmp47_ = NULL;
				GdkPixbuf* _tmp48_ = NULL;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				gchar** _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp37_ = g_strdup ("compression");
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp38_ = g_strdup ("icc-profile");
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp39_ = g_new0 (gchar*, 3 + 1);
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp39_[0] = _tmp37_;
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp39_[1] = _tmp38_;
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp39_[2] = NULL;
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				keys = _tmp39_;
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				keys_length1 = 3;
#line 705 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_keys_size_ = keys_length1;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp40_ = g_strdup ("8");
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp41_ = icc_profile_data;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp42_ = g_strdup (_tmp41_);
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp43_ = g_new0 (gchar*, 3 + 1);
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp43_[0] = _tmp40_;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp43_[1] = _tmp42_;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp43_[2] = NULL;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				values = _tmp43_;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				values_length1 = 3;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_values_size_ = values_length1;
#line 707 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp44_ = icc_profile_data;
#line 707 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (_tmp44_ == NULL) {
#line 3663 "page.c"
					gchar** _tmp45_ = NULL;
					gint _tmp45__length1 = 0;
					gchar* _tmp46_ = NULL;
#line 708 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp45_ = keys;
#line 708 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp45__length1 = keys_length1;
#line 708 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_g_free0 (_tmp45_[1]);
#line 708 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp45_[1] = NULL;
#line 708 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_tmp46_ = _tmp45_[1];
#line 3677 "page.c"
				}
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp47_ = writer;
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp48_ = image;
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp49_ = keys;
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp49__length1 = keys_length1;
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp50_ = values;
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				_tmp50__length1 = values_length1;
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				pixbuf_writer_save (_tmp47_, _tmp48_, "tiff", _tmp49_, _tmp49__length1, _tmp50_, _tmp50__length1, &_inner_error_);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				if (_inner_error_ != NULL) {
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					g_propagate_error (error, _inner_error_);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_g_free0 (icc_profile_data);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_g_object_unref0 (image);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_pixbuf_writer_unref0 (writer);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					_g_object_unref0 (stream);
#line 709 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
					return;
#line 3711 "page.c"
				}
#line 703 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 703 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3717 "page.c"
			} else {
			}
		}
	}
#line 678 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_free0 (icc_profile_data);
#line 678 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_object_unref0 (image);
#line 678 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_pixbuf_writer_unref0 (writer);
#line 678 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_object_unref0 (stream);
#line 3730 "page.c"
}


static void value_page_init (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	value->data[0].v_pointer = NULL;
#line 3737 "page.c"
}


static void value_page_free_value (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		page_unref (value->data[0].v_pointer);
#line 3746 "page.c"
	}
}


static void value_page_copy_value (const GValue* src_value, GValue* dest_value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		dest_value->data[0].v_pointer = page_ref (src_value->data[0].v_pointer);
#line 3756 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3760 "page.c"
	}
}


static gpointer value_page_peek_pointer (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return value->data[0].v_pointer;
#line 3768 "page.c"
}


static gchar* value_page_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (collect_values[0].v_pointer) {
#line 3775 "page.c"
		Page* object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3782 "page.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3786 "page.c"
		}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = page_ref (object);
#line 3790 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 3794 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return NULL;
#line 3798 "page.c"
}


static gchar* value_page_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Page** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (!object_p) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3809 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*object_p = NULL;
#line 3815 "page.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*object_p = value->data[0].v_pointer;
#line 3819 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*object_p = page_ref (value->data[0].v_pointer);
#line 3823 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return NULL;
#line 3827 "page.c"
}


GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPage* spec;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE), NULL);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return G_PARAM_SPEC (spec);
#line 3841 "page.c"
}


gpointer value_get_page (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE), NULL);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return value->data[0].v_pointer;
#line 3850 "page.c"
}


void value_set_page (GValue* value, gpointer v_object) {
	Page* old;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		page_ref (value->data[0].v_pointer);
#line 3870 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 3874 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		page_unref (old);
#line 3880 "page.c"
	}
}


void value_take_page (GValue* value, gpointer v_object) {
	Page* old;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 3899 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 3903 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		page_unref (old);
#line 3909 "page.c"
	}
}


static void page_class_init (PageClass * klass) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	page_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	PAGE_CLASS (klass)->finalize = page_finalize;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_type_class_add_private (klass, sizeof (PagePrivate));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_new ("pixels_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_new ("size_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_new ("scan_line_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_new ("scan_direction_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_signal_new ("crop_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3931 "page.c"
}


static void page_instance_init (Page * self) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv = PAGE_GET_PRIVATE (self);
#line 51 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->ref_count = 1;
#line 3942 "page.c"
}


static void page_finalize (Page* obj) {
	Page * self;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE, Page);
#line 32 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_free0 (self->priv->color_profile);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
#line 55 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_free0 (self->priv->crop_name);
#line 3956 "page.c"
}


GType page_get_type (void) {
	static volatile gsize page_type_id__volatile = 0;
	if (g_once_init_enter (&page_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_init, value_page_free_value, value_page_copy_value, value_page_peek_pointer, "p", value_page_collect_value, "p", value_page_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Page), 0, (GInstanceInitFunc) page_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_type_id;
		page_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Page", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_type_id__volatile, page_type_id);
	}
	return page_type_id__volatile;
}


gpointer page_ref (gpointer instance) {
	Page* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return instance;
#line 3981 "page.c"
}


void page_unref (gpointer instance) {
	Page* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		PAGE_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3994 "page.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 722 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return self ? g_object_ref (self) : NULL;
#line 4002 "page.c"
}


PixbufWriter* pixbuf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PixbufWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
#line 720 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 720 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self = (PixbufWriter*) g_type_create_instance (object_type);
#line 722 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = stream;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 722 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_object_unref0 (self->stream);
#line 722 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->stream = _tmp1_;
#line 720 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return self;
#line 4024 "page.c"
}


PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream) {
#line 720 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return pixbuf_writer_construct (TYPE_PIXBUF_WRITER, stream);
#line 4031 "page.c"
}


static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = pixbuf_writer_write_pixbuf_data ((PixbufWriter*) self, buf, buf_length1, error);
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 4040 "page.c"
}


void pixbuf_writer_save (PixbufWriter* self, GdkPixbuf* image, const gchar* type, gchar** option_keys, int option_keys_length1, gchar** option_values, int option_values_length1, GError** error) {
	GdkPixbuf* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GError * _inner_error_ = NULL;
#line 725 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (self != NULL);
#line 725 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (image != NULL);
#line 725 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (type != NULL);
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = image;
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = type;
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2_ = option_keys;
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp2__length1 = option_keys_length1;
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3_ = option_values;
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp3__length1 = option_values_length1;
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	gdk_pixbuf_save_to_callbackv (_tmp0_, _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func, self, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_inner_error_ != NULL) {
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 727 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return;
#line 4078 "page.c"
	}
}


static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GFileOutputStream* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GError * _inner_error_ = NULL;
#line 730 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 732 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp0_ = self->stream;
#line 732 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1_ = buf;
#line 732 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_tmp1__length1 = buf_length1;
#line 732 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 732 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (_inner_error_ != NULL) {
#line 732 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 732 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return FALSE;
#line 4105 "page.c"
	}
#line 733 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	result = TRUE;
#line 733 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return result;
#line 4111 "page.c"
}


static void value_pixbuf_writer_init (GValue* value) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	value->data[0].v_pointer = NULL;
#line 4118 "page.c"
}


static void value_pixbuf_writer_free_value (GValue* value) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (value->data[0].v_pointer) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		pixbuf_writer_unref (value->data[0].v_pointer);
#line 4127 "page.c"
	}
}


static void value_pixbuf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (src_value->data[0].v_pointer) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		dest_value->data[0].v_pointer = pixbuf_writer_ref (src_value->data[0].v_pointer);
#line 4137 "page.c"
	} else {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4141 "page.c"
	}
}


static gpointer value_pixbuf_writer_peek_pointer (const GValue* value) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return value->data[0].v_pointer;
#line 4149 "page.c"
}


static gchar* value_pixbuf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (collect_values[0].v_pointer) {
#line 4156 "page.c"
		PixbufWriter* object;
		object = collect_values[0].v_pointer;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		if (object->parent_instance.g_class == NULL) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4163 "page.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4167 "page.c"
		}
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = pixbuf_writer_ref (object);
#line 4171 "page.c"
	} else {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4175 "page.c"
	}
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return NULL;
#line 4179 "page.c"
}


static gchar* value_pixbuf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixbufWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (!object_p) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4190 "page.c"
	}
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (!value->data[0].v_pointer) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*object_p = NULL;
#line 4196 "page.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*object_p = value->data[0].v_pointer;
#line 4200 "page.c"
	} else {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		*object_p = pixbuf_writer_ref (value->data[0].v_pointer);
#line 4204 "page.c"
	}
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return NULL;
#line 4208 "page.c"
}


GParamSpec* param_spec_pixbuf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixbufWriter* spec;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXBUF_WRITER), NULL);
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return G_PARAM_SPEC (spec);
#line 4222 "page.c"
}


gpointer value_get_pixbuf_writer (const GValue* value) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER), NULL);
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return value->data[0].v_pointer;
#line 4231 "page.c"
}


void value_set_pixbuf_writer (GValue* value, gpointer v_object) {
	PixbufWriter* old;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	old = value->data[0].v_pointer;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (v_object) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		pixbuf_writer_ref (value->data[0].v_pointer);
#line 4251 "page.c"
	} else {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4255 "page.c"
	}
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (old) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		pixbuf_writer_unref (old);
#line 4261 "page.c"
	}
}


void value_take_pixbuf_writer (GValue* value, gpointer v_object) {
	PixbufWriter* old;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	old = value->data[0].v_pointer;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (v_object) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 4280 "page.c"
	} else {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4284 "page.c"
	}
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (old) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		pixbuf_writer_unref (old);
#line 4290 "page.c"
	}
}


static void pixbuf_writer_class_init (PixbufWriterClass * klass) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	pixbuf_writer_parent_class = g_type_class_peek_parent (klass);
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	PIXBUF_WRITER_CLASS (klass)->finalize = pixbuf_writer_finalize;
#line 4300 "page.c"
}


static void pixbuf_writer_instance_init (PixbufWriter * self) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self->ref_count = 1;
#line 4307 "page.c"
}


static void pixbuf_writer_finalize (PixbufWriter* obj) {
	PixbufWriter * self;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_WRITER, PixbufWriter);
#line 718 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	_g_object_unref0 (self->stream);
#line 4317 "page.c"
}


GType pixbuf_writer_get_type (void) {
	static volatile gsize pixbuf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixbuf_writer_init, value_pixbuf_writer_free_value, value_pixbuf_writer_copy_value, value_pixbuf_writer_peek_pointer, "p", value_pixbuf_writer_collect_value, "p", value_pixbuf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixbufWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufWriter), 0, (GInstanceInitFunc) pixbuf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixbuf_writer_type_id;
		pixbuf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixbufWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixbuf_writer_type_id__volatile, pixbuf_writer_type_id);
	}
	return pixbuf_writer_type_id__volatile;
}


gpointer pixbuf_writer_ref (gpointer instance) {
	PixbufWriter* self;
	self = instance;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	g_atomic_int_inc (&self->ref_count);
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	return instance;
#line 4342 "page.c"
}


void pixbuf_writer_unref (gpointer instance) {
	PixbufWriter* self;
	self = instance;
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		PIXBUF_WRITER_GET_CLASS (self)->finalize (self);
#line 716 "/home/bob/bzr/simple-scan/3.4/src/page.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4355 "page.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



