/* simple-scan.c generated by valac 0.15.2, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gudev/gudev.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "colord.h"
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <locale.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _simple_scan_unref0(var) ((var == NULL) ? NULL : (var = (simple_scan_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))
typedef struct _ParamSpecApplication ParamSpecApplication;

struct _Application {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GTypeClass parent_class;
	void (*finalize) (Application *self);
};

struct _ApplicationPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUdevClient* udev_client;
	SimpleScan* ui;
	Scanner* scanner;
	Book* book;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecApplication {
	GParamSpec parent_instance;
};


static gpointer application_parent_class = NULL;
static gboolean application_show_version;
static gboolean application_show_version = FALSE;
static gboolean application_debug_enabled;
static gboolean application_debug_enabled = FALSE;
static gchar* application_fix_pdf_filename;
static gchar* application_fix_pdf_filename = NULL;
static GTimer* application_log_timer;
static GTimer* application_log_timer = NULL;
static FILE* application_log_file;
static FILE* application_log_file = NULL;

gpointer application_ref (gpointer instance);
void application_unref (gpointer instance);
GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_application (GValue* value, gpointer v_object);
void value_take_application (GValue* value, gpointer v_object);
gpointer value_get_application (const GValue* value);
GType application_get_type (void) G_GNUC_CONST;
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
gpointer simple_scan_ref (gpointer instance);
void simple_scan_unref (gpointer instance);
GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_simple_scan (GValue* value, gpointer v_object);
void value_take_simple_scan (GValue* value, gpointer v_object);
gpointer value_get_simple_scan (const GValue* value);
GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
Application* application_new (ScanDevice* device);
Application* application_construct (GType object_type, ScanDevice* device);
SimpleScan* simple_scan_new (void);
SimpleScan* simple_scan_construct (GType object_type);
Book* simple_scan_get_book (SimpleScan* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static void application_scan_cb (Application* self, SimpleScan* ui, const gchar* device, ScanOptions* options);
static void _application_scan_cb_simple_scan_start_scan (SimpleScan* _sender, const gchar* device, ScanOptions* options, gpointer self);
static void application_cancel_cb (Application* self, SimpleScan* ui);
static void _application_cancel_cb_simple_scan_stop_scan (SimpleScan* _sender, gpointer self);
static void application_email_cb (Application* self, SimpleScan* ui, const gchar* profile);
static void _application_email_cb_simple_scan_email (SimpleScan* _sender, const gchar* profile, gpointer self);
static void application_quit_cb (Application* self, SimpleScan* ui);
static void _application_quit_cb_simple_scan_quit (SimpleScan* _sender, gpointer self);
Scanner* scanner_get_instance (void);
static void application_update_scan_devices_cb (Application* self, Scanner* scanner, GList* devices);
static void _application_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self);
static void application_authorize_cb (Application* self, Scanner* scanner, const gchar* resource);
static void _application_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self);
static void application_scanner_new_page_cb (Application* self, Scanner* scanner);
static void _application_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
static void application_scanner_page_info_cb (Application* self, Scanner* scanner, ScanPageInfo* info);
static void _application_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void application_scanner_line_cb (Application* self, Scanner* scanner, ScanLine* line);
static void _application_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self);
static void application_scanner_page_done_cb (Application* self, Scanner* scanner);
static void _application_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self);
static void application_scanner_document_done_cb (Application* self, Scanner* scanner);
static void _application_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self);
static void application_scanner_failed_cb (Application* self, Scanner* scanner, gint error_code, const gchar* error_string);
static void _application_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self);
static void application_scanner_scanning_changed_cb (Application* self, Scanner* scanner);
static void _application_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self);
static void application_on_uevent (Application* self, GUdevClient* client, const gchar* action, GUdevDevice* device);
static void _application_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
void simple_scan_set_scan_devices (SimpleScan* self, GList* devices);
void simple_scan_set_selected_device (SimpleScan* self, const gchar* device);
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
void application_start (Application* self);
void simple_scan_start (SimpleScan* self);
void scanner_start (Scanner* self);
void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static Page* application_append_page (Application* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_has_data (Page* self);
void simple_scan_set_selected_page (SimpleScan* self, Page* page);
void page_start (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void page_set_named_crop (Page* self, const gchar* name);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
static gchar* application_get_profile_for_device (Application* self, const gchar* device_name);
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* color_profile);
guint book_get_n_pages (Book* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
static void application_remove_empty_page (Application* self);
void book_delete_page (Book* self, Page* page);
void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void simple_scan_set_scanning (SimpleScan* self, gboolean scanning);
gboolean scanner_is_scanning (Scanner* self);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
static gchar* application_get_temporary_filename (Application* self, const gchar* prefix, const gchar* extension);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
void scanner_free (Scanner* self);
static void application_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
void scanner_redetect (Scanner* self);
static void application_fix_pdf (const gchar* filename, GError** error);
gint application_main (gchar** args, int args_length1);
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void _application_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void application_finalize (Application* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry APPLICATION_options[4] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &application_show_version, "Show release version", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &application_debug_enabled, "Print debugging messages", NULL}, {"fix-pdf", (gchar) 0, 0, G_OPTION_ARG_STRING, &application_fix_pdf_filename, "Fix PDF files generated with older versions of Simple Scan", "FILENAME..."}, {NULL}};

static gpointer _scan_device_ref0 (gpointer self) {
	return self ? scan_device_ref (self) : NULL;
}


static void _application_scan_cb_simple_scan_start_scan (SimpleScan* _sender, const gchar* device, ScanOptions* options, gpointer self) {
	application_scan_cb (self, _sender, device, options);
}


static void _application_cancel_cb_simple_scan_stop_scan (SimpleScan* _sender, gpointer self) {
	application_cancel_cb (self, _sender);
}


static void _application_email_cb_simple_scan_email (SimpleScan* _sender, const gchar* profile, gpointer self) {
	application_email_cb (self, _sender, profile);
}


static void _application_quit_cb_simple_scan_quit (SimpleScan* _sender, gpointer self) {
	application_quit_cb (self, _sender);
}


static void _application_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self) {
	application_update_scan_devices_cb (self, _sender, devices);
}


static void _application_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self) {
	application_authorize_cb (self, _sender, resource);
}


static void _application_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self) {
	application_scanner_new_page_cb (self, _sender);
}


static void _application_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self) {
	application_scanner_page_info_cb (self, _sender, info);
}


static void _application_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self) {
	application_scanner_line_cb (self, _sender, line);
}


static void _application_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self) {
	application_scanner_page_done_cb (self, _sender);
}


static void _application_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self) {
	application_scanner_document_done_cb (self, _sender);
}


static void _application_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self) {
	application_scanner_failed_cb (self, _sender, error_code, error_string);
}


static void _application_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self) {
	application_scanner_scanning_changed_cb (self, _sender);
}


static void _application_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
	application_on_uevent (self, _sender, action, device);
}


static void _scan_device_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
	g_list_free (self);
}


Application* application_construct (GType object_type, ScanDevice* device) {
	Application* self = NULL;
	ScanDevice* _tmp0_;
	ScanDevice* _tmp1_;
	SimpleScan* _tmp2_;
	SimpleScan* _tmp3_;
	Book* _tmp4_ = NULL;
	SimpleScan* _tmp5_;
	SimpleScan* _tmp6_;
	SimpleScan* _tmp7_;
	SimpleScan* _tmp8_;
	Scanner* _tmp9_ = NULL;
	Scanner* _tmp10_;
	Scanner* _tmp11_;
	Scanner* _tmp12_;
	Scanner* _tmp13_;
	Scanner* _tmp14_;
	Scanner* _tmp15_;
	Scanner* _tmp16_;
	Scanner* _tmp17_;
	Scanner* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_ = NULL;
	gchar** subsystems;
	gint subsystems_length1;
	gint _subsystems_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	GUdevClient* _tmp22_;
	GUdevClient* _tmp23_;
	ScanDevice* _tmp24_;
	self = (Application*) g_type_create_instance (object_type);
	_tmp0_ = device;
	_tmp1_ = _scan_device_ref0 (_tmp0_);
	_scan_device_unref0 (self->priv->default_device);
	self->priv->default_device = _tmp1_;
	_tmp2_ = simple_scan_new ();
	_simple_scan_unref0 (self->priv->ui);
	self->priv->ui = _tmp2_;
	_tmp3_ = self->priv->ui;
	_tmp4_ = simple_scan_get_book (_tmp3_);
	_book_unref0 (self->priv->book);
	self->priv->book = _tmp4_;
	_tmp5_ = self->priv->ui;
	g_signal_connect (_tmp5_, "start-scan", (GCallback) _application_scan_cb_simple_scan_start_scan, self);
	_tmp6_ = self->priv->ui;
	g_signal_connect (_tmp6_, "stop-scan", (GCallback) _application_cancel_cb_simple_scan_stop_scan, self);
	_tmp7_ = self->priv->ui;
	g_signal_connect (_tmp7_, "email", (GCallback) _application_email_cb_simple_scan_email, self);
	_tmp8_ = self->priv->ui;
	g_signal_connect (_tmp8_, "quit", (GCallback) _application_quit_cb_simple_scan_quit, self);
	_tmp9_ = scanner_get_instance ();
	_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp9_;
	_tmp10_ = self->priv->scanner;
	g_signal_connect (_tmp10_, "update-devices", (GCallback) _application_update_scan_devices_cb_scanner_update_devices, self);
	_tmp11_ = self->priv->scanner;
	g_signal_connect (_tmp11_, "request-authorization", (GCallback) _application_authorize_cb_scanner_request_authorization, self);
	_tmp12_ = self->priv->scanner;
	g_signal_connect (_tmp12_, "expect-page", (GCallback) _application_scanner_new_page_cb_scanner_expect_page, self);
	_tmp13_ = self->priv->scanner;
	g_signal_connect (_tmp13_, "got-page-info", (GCallback) _application_scanner_page_info_cb_scanner_got_page_info, self);
	_tmp14_ = self->priv->scanner;
	g_signal_connect (_tmp14_, "got-line", (GCallback) _application_scanner_line_cb_scanner_got_line, self);
	_tmp15_ = self->priv->scanner;
	g_signal_connect (_tmp15_, "page-done", (GCallback) _application_scanner_page_done_cb_scanner_page_done, self);
	_tmp16_ = self->priv->scanner;
	g_signal_connect (_tmp16_, "document-done", (GCallback) _application_scanner_document_done_cb_scanner_document_done, self);
	_tmp17_ = self->priv->scanner;
	g_signal_connect (_tmp17_, "scan-failed", (GCallback) _application_scanner_failed_cb_scanner_scan_failed, self);
	_tmp18_ = self->priv->scanner;
	g_signal_connect (_tmp18_, "scanning-changed", (GCallback) _application_scanner_scanning_changed_cb_scanner_scanning_changed, self);
	_tmp19_ = g_strdup ("usb");
	_tmp20_ = g_new0 (gchar*, 2 + 1);
	_tmp20_[0] = _tmp19_;
	_tmp20_[1] = NULL;
	subsystems = _tmp20_;
	subsystems_length1 = 2;
	_subsystems_size_ = subsystems_length1;
	_tmp21_ = subsystems;
	_tmp21__length1 = subsystems_length1;
	_tmp22_ = g_udev_client_new (_tmp21_);
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = _tmp22_;
	_tmp23_ = self->priv->udev_client;
	g_signal_connect (_tmp23_, "uevent", (GCallback) _application_on_uevent_g_udev_client_uevent, self);
	_tmp24_ = self->priv->default_device;
	if (_tmp24_ != NULL) {
		GList* device_list;
		ScanDevice* _tmp25_;
		ScanDevice* _tmp26_;
		SimpleScan* _tmp27_;
		GList* _tmp28_;
		SimpleScan* _tmp29_;
		ScanDevice* _tmp30_;
		const gchar* _tmp31_;
		device_list = NULL;
		_tmp25_ = self->priv->default_device;
		_tmp26_ = _scan_device_ref0 (_tmp25_);
		device_list = g_list_append (device_list, _tmp26_);
		_tmp27_ = self->priv->ui;
		_tmp28_ = device_list;
		simple_scan_set_scan_devices (_tmp27_, _tmp28_);
		_tmp29_ = self->priv->ui;
		_tmp30_ = self->priv->default_device;
		_tmp31_ = _tmp30_->name;
		simple_scan_set_selected_device (_tmp29_, _tmp31_);
		__g_list_free__scan_device_unref0_0 (device_list);
	}
	subsystems = (_vala_array_free (subsystems, subsystems_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


Application* application_new (ScanDevice* device) {
	return application_construct (TYPE_APPLICATION, device);
}


void application_start (Application* self) {
	SimpleScan* _tmp0_;
	Scanner* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ui;
	simple_scan_start (_tmp0_);
	_tmp1_ = self->priv->scanner;
	scanner_start (_tmp1_);
}


static void application_update_scan_devices_cb (Application* self, Scanner* scanner, GList* devices) {
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* devices_copy;
	ScanDevice* _tmp2_;
	GList* _tmp10_;
	guint _tmp11_ = 0U;
	SimpleScan* _tmp12_;
	GList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = devices;
	_tmp1_ = g_list_copy (_tmp0_);
	devices_copy = _tmp1_;
	_tmp2_ = self->priv->default_device;
	if (_tmp2_ != NULL) {
		gboolean default_in_list;
		GList* _tmp3_;
		gboolean _tmp8_;
		default_in_list = FALSE;
		_tmp3_ = devices_copy;
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
			device_collection = _tmp3_;
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
				ScanDevice* device = NULL;
				device = (ScanDevice*) device_it->data;
				{
					ScanDevice* _tmp4_;
					const gchar* _tmp5_;
					ScanDevice* _tmp6_;
					const gchar* _tmp7_;
					_tmp4_ = device;
					_tmp5_ = _tmp4_->name;
					_tmp6_ = self->priv->default_device;
					_tmp7_ = _tmp6_->name;
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
						default_in_list = TRUE;
						break;
					}
				}
			}
		}
		_tmp8_ = default_in_list;
		if (!_tmp8_) {
			ScanDevice* _tmp9_;
			_tmp9_ = self->priv->default_device;
			devices_copy = g_list_prepend (devices_copy, _tmp9_);
		}
	}
	_tmp10_ = devices_copy;
	_tmp11_ = g_list_length (_tmp10_);
	self->priv->have_devices = _tmp11_ > ((guint) 0);
	_tmp12_ = self->priv->ui;
	_tmp13_ = devices_copy;
	simple_scan_set_scan_devices (_tmp12_, _tmp13_);
	_g_list_free0 (devices_copy);
}


static void application_authorize_cb (Application* self, Scanner* scanner, const gchar* resource) {
	gchar* username = NULL;
	gchar* password = NULL;
	SimpleScan* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Scanner* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = self->priv->ui;
	_tmp1_ = resource;
	simple_scan_authorize (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (username);
	username = _tmp2_;
	_g_free0 (password);
	password = _tmp3_;
	_tmp4_ = scanner;
	scanner_authorize (_tmp4_, username, password);
	_g_free0 (password);
	_g_free0 (username);
}


static Page* application_append_page (Application* self) {
	Page* result = NULL;
	Book* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	gboolean _tmp2_ = FALSE;
	Page* _tmp3_;
	gboolean _tmp6_;
	ScanDirection scan_direction;
	gboolean do_crop;
	gchar* named_crop;
	gint width;
	gint height;
	gint dpi;
	gint cx;
	gint cy;
	gint cw;
	gint ch;
	Page* _tmp10_;
	Book* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ScanDirection _tmp33_;
	Page* _tmp34_ = NULL;
	gboolean _tmp35_;
	SimpleScan* _tmp45_;
	Page* _tmp46_;
	Page* _tmp47_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = book_get_page (_tmp0_, -1);
	page = _tmp1_;
	_tmp3_ = page;
	if (_tmp3_ != NULL) {
		Page* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = page;
		_tmp5_ = page_has_data (_tmp4_);
		_tmp2_ = !_tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		SimpleScan* _tmp7_;
		Page* _tmp8_;
		Page* _tmp9_;
		_tmp7_ = self->priv->ui;
		_tmp8_ = page;
		simple_scan_set_selected_page (_tmp7_, _tmp8_);
		_tmp9_ = page;
		page_start (_tmp9_);
		result = page;
		return result;
	}
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
	do_crop = FALSE;
	named_crop = NULL;
	width = 100;
	height = 100;
	dpi = 100;
	cx = 0;
	cy = 0;
	cw = 0;
	ch = 0;
	_tmp10_ = page;
	if (_tmp10_ != NULL) {
		Page* _tmp11_;
		ScanDirection _tmp12_ = 0;
		Page* _tmp13_;
		gint _tmp14_ = 0;
		Page* _tmp15_;
		gint _tmp16_ = 0;
		Page* _tmp17_;
		gint _tmp18_ = 0;
		Page* _tmp19_;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_;
		_tmp11_ = page;
		_tmp12_ = page_get_scan_direction (_tmp11_);
		scan_direction = _tmp12_;
		_tmp13_ = page;
		_tmp14_ = page_get_width (_tmp13_);
		width = _tmp14_;
		_tmp15_ = page;
		_tmp16_ = page_get_height (_tmp15_);
		height = _tmp16_;
		_tmp17_ = page;
		_tmp18_ = page_get_dpi (_tmp17_);
		dpi = _tmp18_;
		_tmp19_ = page;
		_tmp20_ = page_has_crop (_tmp19_);
		do_crop = _tmp20_;
		_tmp21_ = do_crop;
		if (_tmp21_) {
			Page* _tmp22_;
			gchar* _tmp23_ = NULL;
			Page* _tmp24_;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			_tmp22_ = page;
			_tmp23_ = page_get_named_crop (_tmp22_);
			_g_free0 (named_crop);
			named_crop = _tmp23_;
			_tmp24_ = page;
			page_get_crop (_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
			cx = _tmp25_;
			cy = _tmp26_;
			cw = _tmp27_;
			ch = _tmp28_;
		}
	}
	_tmp29_ = self->priv->book;
	_tmp30_ = width;
	_tmp31_ = height;
	_tmp32_ = dpi;
	_tmp33_ = scan_direction;
	_tmp34_ = book_append_page (_tmp29_, _tmp30_, _tmp31_, _tmp32_, _tmp33_);
	_page_unref0 (page);
	page = _tmp34_;
	_tmp35_ = do_crop;
	if (_tmp35_) {
		const gchar* _tmp36_;
		Page* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		_tmp36_ = named_crop;
		if (_tmp36_ != NULL) {
			Page* _tmp37_;
			const gchar* _tmp38_;
			_tmp37_ = page;
			_tmp38_ = named_crop;
			page_set_named_crop (_tmp37_, _tmp38_);
		} else {
			Page* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			_tmp39_ = page;
			_tmp40_ = cw;
			_tmp41_ = ch;
			page_set_custom_crop (_tmp39_, _tmp40_, _tmp41_);
		}
		_tmp42_ = page;
		_tmp43_ = cx;
		_tmp44_ = cy;
		page_move_crop (_tmp42_, _tmp43_, _tmp44_);
	}
	_tmp45_ = self->priv->ui;
	_tmp46_ = page;
	simple_scan_set_selected_page (_tmp45_, _tmp46_);
	_tmp47_ = page;
	page_start (_tmp47_);
	result = page;
	_g_free0 (named_crop);
	return result;
}


static void application_scanner_new_page_cb (Application* self, Scanner* scanner) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = application_append_page (self);
	_tmp1_ = _tmp0_;
	_page_unref0 (_tmp1_);
}


static gchar* application_get_profile_for_device (Application* self, const gchar* device_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* device_id;
	const gchar* _tmp2_;
	CdClient* _tmp3_;
	CdClient* client;
	CdDevice* device = NULL;
	CdDevice* _tmp18_;
	CdProfile* _tmp19_ = NULL;
	CdProfile* profile;
	CdProfile* _tmp20_;
	CdProfile* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	CdProfile* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	CdProfile* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_name != NULL, NULL);
	_tmp0_ = device_name;
	_tmp1_ = g_strdup_printf ("sane:%s", _tmp0_);
	device_id = _tmp1_;
	_tmp2_ = device_name;
	g_debug ("simple-scan.vala:170: Getting color profile for device %s", _tmp2_);
	_tmp3_ = cd_client_new ();
	client = _tmp3_;
	{
		CdClient* _tmp4_;
		_tmp4_ = client;
		cd_client_connect_sync (_tmp4_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("simple-scan.vala:179: Failed to connect to colord: %s", _tmp6_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		CdClient* _tmp7_;
		const gchar* _tmp8_;
		CdDevice* _tmp9_ = NULL;
		CdDevice* _tmp10_;
		_tmp7_ = client;
		_tmp8_ = device_id;
		_tmp9_ = cd_client_find_device_by_property_sync (_tmp7_, CD_DEVICE_PROPERTY_SERIAL, _tmp8_, NULL, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_object_unref0 (device);
		device = _tmp10_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = device_name;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_debug ("simple-scan.vala:190: Unable to find colord device %s: %s", _tmp11_, _tmp13_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		CdDevice* _tmp14_;
		_tmp14_ = device;
		cd_device_connect_sync (_tmp14_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = device_name;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_debug ("simple-scan.vala:200: Failed to get properties from the device %s: %s", _tmp15_, _tmp17_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp18_ = device;
	_tmp19_ = cd_device_get_default_profile (_tmp18_);
	profile = _tmp19_;
	_tmp20_ = profile;
	if (_tmp20_ == NULL) {
		const gchar* _tmp21_;
		_tmp21_ = device_name;
		g_debug ("simple-scan.vala:207: No default color profile for device: %s", _tmp21_);
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	{
		CdProfile* _tmp22_;
		_tmp22_ = profile;
		cd_profile_connect_sync (_tmp22_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = device_name;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_debug ("simple-scan.vala:217: Failed to get properties from the profile %s: %s", _tmp23_, _tmp25_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp26_ = profile;
	_tmp27_ = cd_profile_get_filename (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == NULL) {
		const gchar* _tmp29_;
		_tmp29_ = device_name;
		g_debug ("simple-scan.vala:223: No icc color profile for the device %s", _tmp29_);
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	_tmp30_ = profile;
	_tmp31_ = cd_profile_get_filename (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = device_name;
	g_debug ("simple-scan.vala:227: Using color profile %s for device %s", _tmp32_, _tmp33_);
	_tmp34_ = profile;
	_tmp35_ = cd_profile_get_filename (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strdup (_tmp36_);
	result = _tmp37_;
	_g_object_unref0 (profile);
	_g_object_unref0 (device);
	_g_object_unref0 (client);
	_g_free0 (device_id);
	return result;
}


static void application_scanner_page_info_cb (Application* self, Scanner* scanner, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_;
	gint _tmp1_;
	ScanPageInfo* _tmp2_;
	gint _tmp3_;
	ScanPageInfo* _tmp4_;
	gint _tmp5_;
	Page* _tmp6_ = NULL;
	Page* page;
	ScanPageInfo* _tmp7_;
	ScanPageInfo* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = _tmp0_->width;
	_tmp2_ = info;
	_tmp3_ = _tmp2_->height;
	_tmp4_ = info;
	_tmp5_ = _tmp4_->depth;
	g_debug ("simple-scan.vala:236: Page is %d pixels wide, %d pixels high, %d bits " \
"per pixel", _tmp1_, _tmp3_, _tmp5_);
	_tmp6_ = application_append_page (self);
	page = _tmp6_;
	_tmp7_ = info;
	page_set_page_info (page, _tmp7_);
	_tmp8_ = info;
	_tmp9_ = _tmp8_->device;
	_tmp10_ = application_get_profile_for_device (self, _tmp9_);
	_tmp11_ = _tmp10_;
	page_set_color_profile (page, _tmp11_);
	_g_free0 (_tmp11_);
	_page_unref0 (page);
}


static void application_scanner_line_cb (Application* self, Scanner* scanner, ScanLine* line) {
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* page;
	ScanLine* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
	page = _tmp3_;
	_tmp4_ = line;
	page_parse_scan_line (page, _tmp4_);
	_page_unref0 (page);
}


static void application_scanner_page_done_cb (Application* self, Scanner* scanner) {
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
	page = _tmp3_;
	page_finish (page);
	_page_unref0 (page);
}


static void application_remove_empty_page (Application* self) {
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* page;
	Page* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
	page = _tmp3_;
	_tmp4_ = page;
	_tmp5_ = page_has_data (_tmp4_);
	if (_tmp5_) {
		Page* _tmp6_;
		_tmp6_ = page;
		page_finish (_tmp6_);
	} else {
		Book* _tmp7_;
		Page* _tmp8_;
		_tmp7_ = self->priv->book;
		_tmp8_ = page;
		book_delete_page (_tmp7_, _tmp8_);
	}
	_page_unref0 (page);
}


static void application_scanner_document_done_cb (Application* self, Scanner* scanner) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	application_remove_empty_page (self);
}


static void application_scanner_failed_cb (Application* self, Scanner* scanner, gint error_code, const gchar* error_string) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (error_string != NULL);
	application_remove_empty_page (self);
	_tmp0_ = error_code;
	if (_tmp0_ != ((gint) SANE_STATUS_CANCELLED)) {
		SimpleScan* _tmp1_;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->ui;
		_tmp2_ = _ ("Failed to scan");
		_tmp3_ = error_string;
		_tmp4_ = self->priv->have_devices;
		simple_scan_show_error (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	}
}


static void application_scanner_scanning_changed_cb (Application* self, Scanner* scanner) {
	SimpleScan* _tmp0_;
	Scanner* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = self->priv->ui;
	_tmp1_ = scanner;
	_tmp2_ = scanner_is_scanning (_tmp1_);
	simple_scan_set_scanning (_tmp0_, _tmp2_);
}


static void application_scan_cb (Application* self, SimpleScan* ui, const gchar* device, ScanOptions* options) {
	ScanOptions* _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	Scanner* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* filename_prefix;
	gchar* extension = NULL;
	ScanOptions* _tmp9_;
	ScanMode _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* filename;
	SimpleScan* _tmp16_;
	Scanner* _tmp17_;
	const gchar* _tmp18_;
	ScanOptions* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	g_return_if_fail (options != NULL);
	_tmp0_ = options;
	_tmp1_ = _tmp0_->dpi;
	_tmp2_ = device;
	g_debug ("simple-scan.vala:296: Requesting scan at %d dpi from device '%s'", _tmp1_, _tmp2_);
	_tmp3_ = self->priv->scanner;
	_tmp4_ = scanner_is_scanning (_tmp3_);
	if (!_tmp4_) {
		Page* _tmp5_ = NULL;
		Page* _tmp6_;
		_tmp5_ = application_append_page (self);
		_tmp6_ = _tmp5_;
		_page_unref0 (_tmp6_);
	}
	_tmp7_ = _ ("Scanned Document");
	_tmp8_ = g_strdup (_tmp7_);
	filename_prefix = _tmp8_;
	_tmp9_ = options;
	_tmp10_ = _tmp9_->scan_mode;
	if (_tmp10_ == SCAN_MODE_COLOR) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("jpg");
		_g_free0 (extension);
		extension = _tmp11_;
	} else {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("pdf");
		_g_free0 (extension);
		extension = _tmp12_;
	}
	_tmp13_ = filename_prefix;
	_tmp14_ = extension;
	_tmp15_ = g_strdup_printf ("%s.%s", _tmp13_, _tmp14_);
	filename = _tmp15_;
	_tmp16_ = ui;
	simple_scan_set_default_file_name (_tmp16_, filename);
	_tmp17_ = self->priv->scanner;
	_tmp18_ = device;
	_tmp19_ = options;
	scanner_scan (_tmp17_, _tmp18_, _tmp19_);
	_g_free0 (filename);
	_g_free0 (extension);
	_g_free0 (filename_prefix);
}


static void application_cancel_cb (Application* self, SimpleScan* ui) {
	Scanner* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	_tmp0_ = self->priv->scanner;
	scanner_cancel (_tmp0_);
}


static gchar* application_get_temporary_filename (Application* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = prefix;
	_tmp1_ = extension;
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
	filename = _tmp2_;
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint fd;
		gint _tmp6_;
		_tmp3_ = filename;
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
		_g_free0 (path);
		path = _tmp4_;
		fd = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp6_ = fd;
		close (_tmp6_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("simple-scan.vala:332: Error saving email attachment: %s", _tmp8_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		_g_free0 (filename);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = path;
	_g_free0 (filename);
	return result;
}


static void application_email_cb (Application* self, SimpleScan* ui, const gchar* profile) {
	gboolean saved;
	gchar* _tmp0_;
	gchar* command_line;
	const gchar* _tmp1_;
	const gchar* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	g_return_if_fail (profile != NULL);
	saved = FALSE;
	_tmp0_ = g_strdup ("xdg-email");
	command_line = _tmp0_;
	_tmp1_ = profile;
	if (g_strcmp0 (_tmp1_, "text") == 0) {
		gchar* _tmp2_ = NULL;
		gchar* path;
		const gchar* _tmp3_;
		_tmp2_ = application_get_temporary_filename (self, "scan", "pdf");
		path = _tmp2_;
		_tmp3_ = path;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			GFile* _tmp5_ = NULL;
			GFile* file;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp4_ = path;
			_tmp5_ = g_file_new_for_path (_tmp4_);
			file = _tmp5_;
			{
				Book* _tmp6_;
				GFile* _tmp7_;
				_tmp6_ = self->priv->book;
				_tmp7_ = file;
				book_save (_tmp6_, "pdf", _tmp7_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch8_g_error;
				}
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError* e = NULL;
				GError* _tmp8_;
				const gchar* _tmp9_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp8_ = e;
				_tmp9_ = _tmp8_->message;
				g_warning ("simple-scan.vala:358: Unable to save email file: %s", _tmp9_);
				_g_error_free0 (e);
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_free0 (command_line);
				return;
			}
			__finally8:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_free0 (command_line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp10_ = command_line;
			_tmp11_ = path;
			_tmp12_ = g_strdup_printf (" --attach %s", _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
			_g_free0 (command_line);
			command_line = _tmp14_;
			_g_free0 (_tmp13_);
			_g_object_unref0 (file);
		}
		_g_free0 (path);
	} else {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp15_;
				_tmp15_ = TRUE;
				while (TRUE) {
					gboolean _tmp16_;
					gint _tmp18_;
					Book* _tmp19_;
					guint _tmp20_ = 0U;
					gchar* _tmp21_ = NULL;
					gchar* path;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					GFile* _tmp24_ = NULL;
					GFile* file;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gboolean _tmp37_;
					_tmp16_ = _tmp15_;
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp18_ = i;
					_tmp19_ = self->priv->book;
					_tmp20_ = book_get_n_pages (_tmp19_);
					if (!(((guint) _tmp18_) < _tmp20_)) {
						break;
					}
					_tmp21_ = application_get_temporary_filename (self, "scan", "jpg");
					path = _tmp21_;
					_tmp22_ = path;
					if (_tmp22_ == NULL) {
						saved = FALSE;
						_g_free0 (path);
						break;
					}
					_tmp23_ = path;
					_tmp24_ = g_file_new_for_path (_tmp23_);
					file = _tmp24_;
					{
						Book* _tmp25_;
						gint _tmp26_;
						Page* _tmp27_ = NULL;
						Page* _tmp28_;
						GFile* _tmp29_;
						_tmp25_ = self->priv->book;
						_tmp26_ = i;
						_tmp27_ = book_get_page (_tmp25_, _tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = file;
						page_save (_tmp28_, "jpeg", _tmp29_, &_inner_error_);
						_page_unref0 (_tmp28_);
						if (_inner_error_ != NULL) {
							goto __catch9_g_error;
						}
					}
					goto __finally9;
					__catch9_g_error:
					{
						GError* e = NULL;
						GError* _tmp30_;
						const gchar* _tmp31_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp30_ = e;
						_tmp31_ = _tmp30_->message;
						g_warning ("simple-scan.vala:382: Unable to save email file: %s", _tmp31_);
						_g_error_free0 (e);
						_g_object_unref0 (file);
						_g_free0 (path);
						_g_free0 (command_line);
						return;
					}
					__finally9:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						_g_free0 (path);
						_g_free0 (command_line);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp32_ = command_line;
					_tmp33_ = path;
					_tmp34_ = g_strdup_printf (" --attach %s", _tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
					_g_free0 (command_line);
					command_line = _tmp36_;
					_g_free0 (_tmp35_);
					_tmp37_ = saved;
					if (!_tmp37_) {
						_g_object_unref0 (file);
						_g_free0 (path);
						break;
					}
					_g_object_unref0 (file);
					_g_free0 (path);
				}
			}
		}
	}
	_tmp38_ = command_line;
	g_debug ("simple-scan.vala:392: Launching email client: %s", _tmp38_);
	{
		const gchar* _tmp39_;
		_tmp39_ = command_line;
		g_spawn_command_line_async (_tmp39_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		g_warning ("simple-scan.vala:399: Unable to start email: %s", _tmp41_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (command_line);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (command_line);
}


static void application_quit_cb (Application* self, SimpleScan* ui) {
	Scanner* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	_book_unref0 (self->priv->book);
	self->priv->book = NULL;
	ui = NULL;
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = NULL;
	_tmp0_ = self->priv->scanner;
	scanner_free (_tmp0_);
	gtk_main_quit ();
}


static void application_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	FILE* _tmp0_;
	GLogLevelFlags _tmp14_;
	g_return_if_fail (message != NULL);
	_tmp0_ = application_log_file;
	if (_tmp0_ != NULL) {
		gchar* prefix = NULL;
		GLogLevelFlags _tmp1_;
		FILE* _tmp9_;
		GTimer* _tmp10_;
		gdouble _tmp11_ = 0.0;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp1_ = log_level;
		switch (_tmp1_ & G_LOG_LEVEL_MASK) {
			case G_LOG_LEVEL_ERROR:
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("ERROR:");
				_g_free0 (prefix);
				prefix = _tmp2_;
				break;
			}
			case G_LOG_LEVEL_CRITICAL:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("CRITICAL:");
				_g_free0 (prefix);
				prefix = _tmp3_;
				break;
			}
			case G_LOG_LEVEL_WARNING:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("WARNING:");
				_g_free0 (prefix);
				prefix = _tmp4_;
				break;
			}
			case G_LOG_LEVEL_MESSAGE:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("MESSAGE:");
				_g_free0 (prefix);
				prefix = _tmp5_;
				break;
			}
			case G_LOG_LEVEL_INFO:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("INFO:");
				_g_free0 (prefix);
				prefix = _tmp6_;
				break;
			}
			case G_LOG_LEVEL_DEBUG:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("DEBUG:");
				_g_free0 (prefix);
				prefix = _tmp7_;
				break;
			}
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("LOG:");
				_g_free0 (prefix);
				prefix = _tmp8_;
				break;
			}
		}
		_tmp9_ = application_log_file;
		_tmp10_ = application_log_timer;
		_tmp11_ = g_timer_elapsed (_tmp10_, NULL);
		_tmp12_ = prefix;
		_tmp13_ = message;
		fprintf (_tmp9_, "[%+.2fs] %s %s\n", _tmp11_, _tmp12_, _tmp13_);
		_g_free0 (prefix);
	}
	_tmp14_ = log_level;
	if ((_tmp14_ & G_LOG_LEVEL_DEBUG) != 0) {
		gboolean _tmp15_;
		_tmp15_ = application_debug_enabled;
		if (_tmp15_) {
			GLogFunc _tmp16_;
			void* _tmp16__target;
			const gchar* _tmp17_;
			GLogLevelFlags _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = g_log_default_handler;
			_tmp16__target = NULL;
			_tmp17_ = log_domain;
			_tmp18_ = log_level;
			_tmp19_ = message;
			_tmp16_ (_tmp17_, _tmp18_, _tmp19_, _tmp16__target);
		}
	} else {
		GLogFunc _tmp20_;
		void* _tmp20__target;
		const gchar* _tmp21_;
		GLogLevelFlags _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = g_log_default_handler;
		_tmp20__target = NULL;
		_tmp21_ = log_domain;
		_tmp22_ = log_level;
		_tmp23_ = message;
		_tmp20_ (_tmp21_, _tmp22_, _tmp23_, _tmp20__target);
	}
}


static void application_on_uevent (Application* self, GUdevClient* client, const gchar* action, GUdevDevice* device) {
	Scanner* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->scanner;
	scanner_redetect (_tmp0_);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void application_fix_pdf (const gchar* filename, GError** error) {
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_;
	guint8* _tmp1_ = NULL;
	size_t _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FILE* _tmp6_ = NULL;
	FILE* _tmp7_;
	FILE* fixed_file;
	gint offset;
	gint line_number;
	gint xref_offset;
	gint xref_line;
	GRegex* _tmp8_;
	GRegex* xref_regex;
	GMatchInfo* xref_match = NULL;
	GString* _tmp9_;
	GString* line;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gint _tmp88_ = 0;
	gboolean _tmp89_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (filename != NULL);
	_tmp0_ = filename;
	g_file_get_contents (_tmp0_, (gchar**) (&_tmp1_), &_tmp2_, &_inner_error_);
	data = (g_free (data), NULL);
	data = _tmp1_;
	data_length1 = _tmp2_;
	_data_size_ = data_length1;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		data = (g_free (data), NULL);
		return;
	}
	_tmp3_ = filename;
	_tmp4_ = g_strconcat (_tmp3_, ".fixed", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = fopen (_tmp5_, "w");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	fixed_file = _tmp7_;
	offset = 0;
	line_number = 0;
	xref_offset = 0;
	xref_line = -1;
	_tmp8_ = g_regex_new ("^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d 0000 n$", 0, 0, &_inner_error_);
	xref_regex = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_fclose0 (fixed_file);
		data = (g_free (data), NULL);
		return;
	}
	_tmp9_ = g_string_new ("");
	line = _tmp9_;
	while (TRUE) {
		gint _tmp10_;
		guint8* _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_;
		gint end_offset;
		GString* _tmp13_;
		GString* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp26_ = FALSE;
		gint _tmp27_;
		gboolean _tmp31_;
		gint _tmp82_;
		gint _tmp83_;
		_tmp10_ = offset;
		_tmp11_ = data;
		_tmp11__length1 = data_length1;
		if (!(_tmp10_ < _tmp11__length1)) {
			break;
		}
		_tmp12_ = offset;
		end_offset = _tmp12_;
		_tmp13_ = line;
		g_string_assign (_tmp13_, "");
		while (TRUE) {
			gint _tmp14_;
			guint8* _tmp15_;
			gint _tmp15__length1;
			guint8* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			guint8 _tmp18_;
			guint8 c;
			GString* _tmp19_;
			guint8 _tmp20_;
			gint _tmp21_;
			guint8 _tmp22_;
			_tmp14_ = end_offset;
			_tmp15_ = data;
			_tmp15__length1 = data_length1;
			if (!(_tmp14_ < _tmp15__length1)) {
				break;
			}
			_tmp16_ = data;
			_tmp16__length1 = data_length1;
			_tmp17_ = end_offset;
			_tmp18_ = _tmp16_[_tmp17_];
			c = _tmp18_;
			_tmp19_ = line;
			_tmp20_ = c;
			g_string_append_c (_tmp19_, (gchar) _tmp20_);
			_tmp21_ = end_offset;
			end_offset = _tmp21_ + 1;
			_tmp22_ = c;
			if (_tmp22_ == ((guint8) '\n')) {
				break;
			}
		}
		_tmp23_ = line;
		_tmp24_ = _tmp23_->str;
		if (g_strcmp0 (_tmp24_, "startxref\n") == 0) {
			gint _tmp25_;
			_tmp25_ = line_number;
			xref_line = _tmp25_;
		}
		_tmp27_ = line_number;
		if (_tmp27_ < 2) {
			GString* _tmp28_;
			const gchar* _tmp29_;
			gboolean _tmp30_ = FALSE;
			_tmp28_ = line;
			_tmp29_ = _tmp28_->str;
			_tmp30_ = g_str_has_prefix (_tmp29_, "%%");
			_tmp26_ = _tmp30_;
		} else {
			_tmp26_ = FALSE;
		}
		_tmp31_ = _tmp26_;
		if (_tmp31_) {
			gint _tmp32_;
			FILE* _tmp33_;
			GString* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			_tmp32_ = xref_offset;
			xref_offset = _tmp32_ - 1;
			_tmp33_ = fixed_file;
			_tmp34_ = line;
			_tmp35_ = _tmp34_->str;
			_tmp36_ = string_substring (_tmp35_, (glong) 1, (glong) (-1));
			_tmp37_ = _tmp36_;
			fprintf (_tmp33_, "%s", _tmp37_);
			_g_free0 (_tmp37_);
		} else {
			GRegex* _tmp38_;
			GString* _tmp39_;
			const gchar* _tmp40_;
			GMatchInfo* _tmp41_ = NULL;
			gboolean _tmp42_ = FALSE;
			_tmp38_ = xref_regex;
			_tmp39_ = line;
			_tmp40_ = _tmp39_->str;
			_tmp42_ = g_regex_match (_tmp38_, _tmp40_, 0, &_tmp41_);
			_g_match_info_free0 (xref_match);
			xref_match = _tmp41_;
			if (_tmp42_) {
				FILE* _tmp43_;
				GMatchInfo* _tmp44_;
				const gchar* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				gint _tmp47_;
				_tmp43_ = fixed_file;
				_tmp44_ = xref_match;
				_tmp45_ = g_match_info_get_string (_tmp44_);
				_tmp46_ = atoi (_tmp45_);
				_tmp47_ = xref_offset;
				fprintf (_tmp43_, "%010d 00000 n \n", _tmp46_ + _tmp47_);
			} else {
				gboolean _tmp48_ = FALSE;
				gint _tmp49_;
				gboolean _tmp52_;
				_tmp49_ = xref_line;
				if (_tmp49_ > 0) {
					gint _tmp50_;
					gint _tmp51_;
					_tmp50_ = line_number;
					_tmp51_ = xref_line;
					_tmp48_ = _tmp50_ == (_tmp51_ + 1);
				} else {
					_tmp48_ = FALSE;
				}
				_tmp52_ = _tmp48_;
				if (_tmp52_) {
					FILE* _tmp53_;
					GString* _tmp54_;
					const gchar* _tmp55_;
					gint _tmp56_ = 0;
					gint _tmp57_;
					gchar* _tmp58_ = NULL;
					gchar* _tmp59_;
					_tmp53_ = fixed_file;
					_tmp54_ = line;
					_tmp55_ = _tmp54_->str;
					_tmp56_ = atoi (_tmp55_);
					_tmp57_ = xref_offset;
					_tmp58_ = g_strdup_printf ("%d\n", _tmp56_ + _tmp57_);
					_tmp59_ = _tmp58_;
					fprintf (_tmp53_, "%s", _tmp59_);
					_g_free0 (_tmp59_);
				} else {
					gboolean _tmp60_ = FALSE;
					gint _tmp61_;
					gint _tmp62_;
					gboolean _tmp66_;
					_tmp61_ = line_number;
					_tmp62_ = xref_line;
					if (_tmp61_ == (_tmp62_ + 2)) {
						GString* _tmp63_;
						const gchar* _tmp64_;
						gboolean _tmp65_ = FALSE;
						_tmp63_ = line;
						_tmp64_ = _tmp63_->str;
						_tmp65_ = g_str_has_prefix (_tmp64_, "%%%%");
						_tmp60_ = _tmp65_;
					} else {
						_tmp60_ = FALSE;
					}
					_tmp66_ = _tmp60_;
					if (_tmp66_) {
						FILE* _tmp67_;
						GString* _tmp68_;
						const gchar* _tmp69_;
						gchar* _tmp70_ = NULL;
						gchar* _tmp71_;
						_tmp67_ = fixed_file;
						_tmp68_ = line;
						_tmp69_ = _tmp68_->str;
						_tmp70_ = string_substring (_tmp69_, (glong) 2, (glong) (-1));
						_tmp71_ = _tmp70_;
						fprintf (_tmp67_, "%s", _tmp71_);
						_g_free0 (_tmp71_);
					} else {
						{
							gint _tmp72_;
							gint i;
							_tmp72_ = offset;
							i = _tmp72_;
							{
								gboolean _tmp73_;
								_tmp73_ = TRUE;
								while (TRUE) {
									gboolean _tmp74_;
									gint _tmp76_;
									gint _tmp77_;
									FILE* _tmp78_;
									guint8* _tmp79_;
									gint _tmp79__length1;
									gint _tmp80_;
									guint8 _tmp81_;
									_tmp74_ = _tmp73_;
									if (!_tmp74_) {
										gint _tmp75_;
										_tmp75_ = i;
										i = _tmp75_ + 1;
									}
									_tmp73_ = FALSE;
									_tmp76_ = i;
									_tmp77_ = end_offset;
									if (!(_tmp76_ < _tmp77_)) {
										break;
									}
									_tmp78_ = fixed_file;
									_tmp79_ = data;
									_tmp79__length1 = data_length1;
									_tmp80_ = i;
									_tmp81_ = _tmp79_[_tmp80_];
									fputc ((gchar) _tmp81_, _tmp78_);
								}
							}
						}
					}
				}
			}
		}
		_tmp82_ = line_number;
		line_number = _tmp82_ + 1;
		_tmp83_ = end_offset;
		offset = _tmp83_;
	}
	_tmp84_ = filename;
	_tmp85_ = filename;
	_tmp86_ = g_strconcat (_tmp85_, "~", NULL);
	_tmp87_ = _tmp86_;
	_tmp88_ = g_rename (_tmp84_, _tmp87_);
	_tmp89_ = _tmp88_ >= 0;
	_g_free0 (_tmp87_);
	if (_tmp89_) {
		const gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		const gchar* _tmp93_;
		_tmp90_ = filename;
		_tmp91_ = g_strconcat (_tmp90_, ".fixed", NULL);
		_tmp92_ = _tmp91_;
		_tmp93_ = filename;
		g_rename (_tmp92_, _tmp93_);
		_g_free0 (_tmp92_);
	}
	_g_string_free0 (line);
	_g_match_info_free0 (xref_match);
	_g_regex_unref0 (xref_regex);
	_fclose0 (fixed_file);
	data = (g_free (data), NULL);
}


static void _application_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	application_log_cb (log_domain, log_levels, message);
}


gint application_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionContext* c;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_;
	const gchar* _tmp16_;
	ScanDevice* device;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GTimer* _tmp39_;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* path;
	const gchar* _tmp42_;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_;
	FILE* _tmp46_ = NULL;
	pid_t _tmp47_ = 0;
	ScanDevice* _tmp48_;
	Application* _tmp49_;
	Application* app;
	Application* _tmp50_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	_tmp0_ = _ ("[DEVICE...] - Scanning utility");
	_tmp1_ = g_option_context_new (_tmp0_);
	c = _tmp1_;
	_tmp2_ = c;
	g_option_context_add_main_entries (_tmp2_, APPLICATION_options, GETTEXT_PACKAGE);
	_tmp3_ = c;
	_tmp4_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_;
		_tmp5_ = c;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		FILE* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		FILE* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		_tmp9_ = stderr;
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = _tmp11_[0];
		fprintf (_tmp9_, _tmp10_, _tmp12_);
		_tmp13_ = stderr;
		fprintf (_tmp13_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		return result;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp14_ = application_show_version;
	if (_tmp14_) {
		FILE* _tmp15_;
		_tmp15_ = stderr;
		fprintf (_tmp15_, "simple-scan %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	_tmp16_ = application_fix_pdf_filename;
	if (_tmp16_ != NULL) {
		{
			const gchar* _tmp17_;
			_tmp17_ = application_fix_pdf_filename;
			application_fix_pdf (_tmp17_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			{
				gint i;
				i = 1;
				{
					gboolean _tmp18_;
					_tmp18_ = TRUE;
					while (TRUE) {
						gboolean _tmp19_;
						gint _tmp21_;
						gchar** _tmp22_;
						gint _tmp22__length1;
						gchar** _tmp23_;
						gint _tmp23__length1;
						gint _tmp24_;
						const gchar* _tmp25_;
						_tmp19_ = _tmp18_;
						if (!_tmp19_) {
							gint _tmp20_;
							_tmp20_ = i;
							i = _tmp20_ + 1;
						}
						_tmp18_ = FALSE;
						_tmp21_ = i;
						_tmp22_ = args;
						_tmp22__length1 = args_length1;
						if (!(_tmp21_ < _tmp22__length1)) {
							break;
						}
						_tmp23_ = args;
						_tmp23__length1 = args_length1;
						_tmp24_ = i;
						_tmp25_ = _tmp23_[_tmp24_];
						application_fix_pdf (_tmp25_, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch12_g_error;
						}
					}
				}
			}
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			fprintf (_tmp26_, "Error fixing PDF file: %s", _tmp28_);
			result = EXIT_FAILURE;
			_g_error_free0 (e);
			_g_option_context_free0 (c);
			return result;
		}
		__finally12:
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	device = NULL;
	_tmp29_ = args;
	_tmp29__length1 = args_length1;
	if (_tmp29__length1 > 1) {
		ScanDevice* _tmp30_;
		ScanDevice* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		ScanDevice* _tmp35_;
		gchar** _tmp36_;
		gint _tmp36__length1;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp30_ = scan_device_new ();
		_scan_device_unref0 (device);
		device = _tmp30_;
		_tmp31_ = device;
		_tmp32_ = args;
		_tmp32__length1 = args_length1;
		_tmp33_ = _tmp32_[1];
		_tmp34_ = g_strdup (_tmp33_);
		_g_free0 (_tmp31_->name);
		_tmp31_->name = _tmp34_;
		_tmp35_ = device;
		_tmp36_ = args;
		_tmp36__length1 = args_length1;
		_tmp37_ = _tmp36_[1];
		_tmp38_ = g_strdup (_tmp37_);
		_g_free0 (_tmp35_->label);
		_tmp35_->label = _tmp38_;
	}
	_tmp39_ = g_timer_new ();
	_g_timer_destroy0 (application_log_timer);
	application_log_timer = _tmp39_;
	_tmp40_ = g_get_user_cache_dir ();
	_tmp41_ = g_build_filename (_tmp40_, "simple-scan", NULL, NULL);
	path = _tmp41_;
	_tmp42_ = path;
	g_mkdir_with_parents (_tmp42_, 0700);
	_tmp43_ = g_get_user_cache_dir ();
	_tmp44_ = g_build_filename (_tmp43_, "simple-scan", "simple-scan.log", NULL, NULL);
	_g_free0 (path);
	path = _tmp44_;
	_tmp45_ = path;
	_tmp46_ = fopen (_tmp45_, "w");
	_fclose0 (application_log_file);
	application_log_file = _tmp46_;
	g_log_set_default_handler (_application_log_cb_glog_func, NULL);
	_tmp47_ = getpid ();
	g_debug ("simple-scan.vala:586: Starting Simple Scan %s, PID=%i", VERSION, (gint) _tmp47_);
	_tmp48_ = device;
	_tmp49_ = application_new (_tmp48_);
	app = _tmp49_;
	_tmp50_ = app;
	application_start (_tmp50_);
	gtk_main ();
	result = EXIT_SUCCESS;
	_application_unref0 (app);
	_g_free0 (path);
	_scan_device_unref0 (device);
	_g_option_context_free0 (c);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return application_main (argv, argc);
}


static void value_application_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_application_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		application_unref (value->data[0].v_pointer);
	}
}


static void value_application_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = application_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_application_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_application_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Application* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = application_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_application_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Application** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = application_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecApplication* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_APPLICATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_application (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION), NULL);
	return value->data[0].v_pointer;
}


void value_set_application (GValue* value, gpointer v_object) {
	Application* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		application_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}


void value_take_application (GValue* value, gpointer v_object) {
	Application* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}


static void application_class_init (ApplicationClass * klass) {
	application_parent_class = g_type_class_peek_parent (klass);
	APPLICATION_CLASS (klass)->finalize = application_finalize;
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
}


static void application_instance_init (Application * self) {
	self->priv = APPLICATION_GET_PRIVATE (self);
	self->priv->default_device = NULL;
	self->priv->have_devices = FALSE;
	self->ref_count = 1;
}


static void application_finalize (Application* obj) {
	Application * self;
	self = APPLICATION (obj);
	_scan_device_unref0 (self->priv->default_device);
	_g_object_unref0 (self->priv->udev_client);
	_simple_scan_unref0 (self->priv->ui);
	_scanner_unref0 (self->priv->scanner);
	_book_unref0 (self->priv->book);
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_application_init, value_application_free_value, value_application_copy_value, value_application_peek_pointer, "p", value_application_collect_value, "p", value_application_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType application_type_id;
		application_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Application", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


gpointer application_ref (gpointer instance) {
	Application* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void application_unref (gpointer instance) {
	Application* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		APPLICATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



