/* scanner.c generated by valac 0.24.0, the Vala compiler
 * generated from scanner.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* TODO: Could indicate the start of the next page immediately after the last page is received (i.e. before the sane_cancel()) */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include "sane/saneopts.h"
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecScanDevice ParamSpecScanDevice;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ParamSpecScanPageInfo ParamSpecScanPageInfo;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
typedef struct _ParamSpecScanLine ParamSpecScanLine;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef struct _ParamSpecScanOptions ParamSpecScanOptions;

#define TYPE_SCAN_JOB (scan_job_get_type ())
#define SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_JOB, ScanJob))
#define SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_JOB, ScanJobClass))
#define IS_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_JOB))
#define IS_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_JOB))
#define SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_JOB, ScanJobClass))

typedef struct _ScanJob ScanJob;
typedef struct _ScanJobClass ScanJobClass;
typedef struct _ScanJobPrivate ScanJobPrivate;
typedef struct _ParamSpecScanJob ParamSpecScanJob;

#define TYPE_REQUEST (request_get_type ())
#define REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST, Request))
#define REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST, RequestClass))
#define IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST))
#define IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST))
#define REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST, RequestClass))

typedef struct _Request Request;
typedef struct _RequestClass RequestClass;
typedef struct _RequestPrivate RequestPrivate;
typedef struct _ParamSpecRequest ParamSpecRequest;

#define TYPE_REQUEST_REDETECT (request_redetect_get_type ())
#define REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_REDETECT, RequestRedetect))
#define REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_REDETECT, RequestRedetectClass))
#define IS_REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_REDETECT))
#define IS_REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_REDETECT))
#define REQUEST_REDETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_REDETECT, RequestRedetectClass))

typedef struct _RequestRedetect RequestRedetect;
typedef struct _RequestRedetectClass RequestRedetectClass;
typedef struct _RequestRedetectPrivate RequestRedetectPrivate;

#define TYPE_REQUEST_CANCEL (request_cancel_get_type ())
#define REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_CANCEL, RequestCancel))
#define REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_CANCEL, RequestCancelClass))
#define IS_REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_CANCEL))
#define IS_REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_CANCEL))
#define REQUEST_CANCEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_CANCEL, RequestCancelClass))

typedef struct _RequestCancel RequestCancel;
typedef struct _RequestCancelClass RequestCancelClass;
typedef struct _RequestCancelPrivate RequestCancelPrivate;

#define TYPE_REQUEST_START_SCAN (request_start_scan_get_type ())
#define REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_START_SCAN, RequestStartScan))
#define REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_START_SCAN, RequestStartScanClass))
#define IS_REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_START_SCAN))
#define IS_REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_START_SCAN))
#define REQUEST_START_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_START_SCAN, RequestStartScanClass))

typedef struct _RequestStartScan RequestStartScan;
typedef struct _RequestStartScanClass RequestStartScanClass;
typedef struct _RequestStartScanPrivate RequestStartScanPrivate;
#define _scan_job_unref0(var) ((var == NULL) ? NULL : (var = (scan_job_unref (var), NULL)))

#define TYPE_REQUEST_QUIT (request_quit_get_type ())
#define REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_QUIT, RequestQuit))
#define REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_QUIT, RequestQuitClass))
#define IS_REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_QUIT))
#define IS_REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_QUIT))
#define REQUEST_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_QUIT, RequestQuitClass))

typedef struct _RequestQuit RequestQuit;
typedef struct _RequestQuitClass RequestQuitClass;
typedef struct _RequestQuitPrivate RequestQuitPrivate;

#define TYPE_CREDENTIALS (credentials_get_type ())
#define CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREDENTIALS, Credentials))
#define CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREDENTIALS, CredentialsClass))
#define IS_CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREDENTIALS))
#define IS_CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREDENTIALS))
#define CREDENTIALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREDENTIALS, CredentialsClass))

typedef struct _Credentials Credentials;
typedef struct _CredentialsClass CredentialsClass;
typedef struct _CredentialsPrivate CredentialsPrivate;
typedef struct _ParamSpecCredentials ParamSpecCredentials;

#define TYPE_SCAN_STATE (scan_state_get_type ())

#define TYPE_NOTIFY (notify_get_type ())
#define NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY, Notify))
#define NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY, NotifyClass))
#define IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY))
#define IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY))
#define NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY, NotifyClass))

typedef struct _Notify Notify;
typedef struct _NotifyClass NotifyClass;
typedef struct _NotifyPrivate NotifyPrivate;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;
typedef struct _ParamSpecNotify ParamSpecNotify;

#define TYPE_NOTIFY_SCANNING_CHANGED (notify_scanning_changed_get_type ())
#define NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChanged))
#define NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))
#define IS_NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCANNING_CHANGED))
#define IS_NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCANNING_CHANGED))
#define NOTIFY_SCANNING_CHANGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))

typedef struct _NotifyScanningChanged NotifyScanningChanged;
typedef struct _NotifyScanningChangedClass NotifyScanningChangedClass;
typedef struct _NotifyScanningChangedPrivate NotifyScanningChangedPrivate;

#define TYPE_NOTIFY_UPDATE_DEVICES (notify_update_devices_get_type ())
#define NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices))
#define NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))
#define IS_NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_UPDATE_DEVICES))
#define IS_NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_UPDATE_DEVICES))
#define NOTIFY_UPDATE_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))

typedef struct _NotifyUpdateDevices NotifyUpdateDevices;
typedef struct _NotifyUpdateDevicesClass NotifyUpdateDevicesClass;
typedef struct _NotifyUpdateDevicesPrivate NotifyUpdateDevicesPrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))

#define TYPE_NOTIFY_REQUEST_AUTHORIZATION (notify_request_authorization_get_type ())
#define NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization))
#define NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))
#define IS_NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define IS_NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define NOTIFY_REQUEST_AUTHORIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))

typedef struct _NotifyRequestAuthorization NotifyRequestAuthorization;
typedef struct _NotifyRequestAuthorizationClass NotifyRequestAuthorizationClass;
typedef struct _NotifyRequestAuthorizationPrivate NotifyRequestAuthorizationPrivate;

#define TYPE_NOTIFY_SCAN_FAILED (notify_scan_failed_get_type ())
#define NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed))
#define NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))
#define IS_NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCAN_FAILED))
#define IS_NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCAN_FAILED))
#define NOTIFY_SCAN_FAILED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))

typedef struct _NotifyScanFailed NotifyScanFailed;
typedef struct _NotifyScanFailedClass NotifyScanFailedClass;
typedef struct _NotifyScanFailedPrivate NotifyScanFailedPrivate;

#define TYPE_NOTIFY_DOCUMENT_DONE (notify_document_done_get_type ())
#define NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDone))
#define NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))
#define IS_NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_DOCUMENT_DONE))
#define IS_NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_DOCUMENT_DONE))
#define NOTIFY_DOCUMENT_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))

typedef struct _NotifyDocumentDone NotifyDocumentDone;
typedef struct _NotifyDocumentDoneClass NotifyDocumentDoneClass;
typedef struct _NotifyDocumentDonePrivate NotifyDocumentDonePrivate;

#define TYPE_NOTIFY_EXPECT_PAGE (notify_expect_page_get_type ())
#define NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPage))
#define NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))
#define IS_NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_EXPECT_PAGE))
#define IS_NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_EXPECT_PAGE))
#define NOTIFY_EXPECT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))

typedef struct _NotifyExpectPage NotifyExpectPage;
typedef struct _NotifyExpectPageClass NotifyExpectPageClass;
typedef struct _NotifyExpectPagePrivate NotifyExpectPagePrivate;

#define TYPE_NOTIFY_GOT_PAGE_INFO (notify_got_page_info_get_type ())
#define NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo))
#define NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))
#define IS_NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_PAGE_INFO))
#define IS_NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_PAGE_INFO))
#define NOTIFY_GOT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))

typedef struct _NotifyGotPageInfo NotifyGotPageInfo;
typedef struct _NotifyGotPageInfoClass NotifyGotPageInfoClass;
typedef struct _NotifyGotPageInfoPrivate NotifyGotPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))
typedef struct _ScannerPrivate ScannerPrivate;

#define TYPE_NOTIFY_PAGE_DONE (notify_page_done_get_type ())
#define NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDone))
#define NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))
#define IS_NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_PAGE_DONE))
#define IS_NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_PAGE_DONE))
#define NOTIFY_PAGE_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))

typedef struct _NotifyPageDone NotifyPageDone;
typedef struct _NotifyPageDoneClass NotifyPageDoneClass;
typedef struct _NotifyPageDonePrivate NotifyPageDonePrivate;

#define TYPE_NOTIFY_GOT_LINE (notify_got_line_get_type ())
#define NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLine))
#define NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))
#define IS_NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_LINE))
#define IS_NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_LINE))
#define NOTIFY_GOT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))

typedef struct _NotifyGotLine NotifyGotLine;
typedef struct _NotifyGotLineClass NotifyGotLineClass;
typedef struct _NotifyGotLinePrivate NotifyGotLinePrivate;
#define _scan_line_unref0(var) ((var == NULL) ? NULL : (var = (scan_line_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define __g_list_free__scan_job_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_job_unref0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _notify_unref0(var) ((var == NULL) ? NULL : (var = (notify_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _credentials_unref0(var) ((var == NULL) ? NULL : (var = (credentials_unref (var), NULL)))
#define _request_unref0(var) ((var == NULL) ? NULL : (var = (request_unref (var), NULL)))
typedef struct _ParamSpecScanner ParamSpecScanner;

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

struct _ParamSpecScanDevice {
	GParamSpec parent_instance;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecScanPageInfo {
	GParamSpec parent_instance;
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecScanLine {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecScanOptions {
	GParamSpec parent_instance;
};

struct _ScanJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanJobPrivate * priv;
	gint id;
	gchar* device;
	gdouble dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint page_width;
	gint page_height;
	gint brightness;
	gint contrast;
};

struct _ScanJobClass {
	GTypeClass parent_class;
	void (*finalize) (ScanJob *self);
};

struct _ParamSpecScanJob {
	GParamSpec parent_instance;
};

struct _Request {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RequestPrivate * priv;
};

struct _RequestClass {
	GTypeClass parent_class;
	void (*finalize) (Request *self);
};

struct _ParamSpecRequest {
	GParamSpec parent_instance;
};

struct _RequestRedetect {
	Request parent_instance;
	RequestRedetectPrivate * priv;
};

struct _RequestRedetectClass {
	RequestClass parent_class;
};

struct _RequestCancel {
	Request parent_instance;
	RequestCancelPrivate * priv;
};

struct _RequestCancelClass {
	RequestClass parent_class;
};

struct _RequestStartScan {
	Request parent_instance;
	RequestStartScanPrivate * priv;
	ScanJob* job;
};

struct _RequestStartScanClass {
	RequestClass parent_class;
};

struct _RequestQuit {
	Request parent_instance;
	RequestQuitPrivate * priv;
};

struct _RequestQuitClass {
	RequestClass parent_class;
};

struct _Credentials {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CredentialsPrivate * priv;
	gchar* username;
	gchar* password;
};

struct _CredentialsClass {
	GTypeClass parent_class;
	void (*finalize) (Credentials *self);
};

struct _ParamSpecCredentials {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_STATE_IDLE = 0,
	SCAN_STATE_REDETECT,
	SCAN_STATE_OPEN,
	SCAN_STATE_GET_OPTION,
	SCAN_STATE_START,
	SCAN_STATE_GET_PARAMETERS,
	SCAN_STATE_READ
} ScanState;

struct _Notify {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotifyPrivate * priv;
};

struct _NotifyClass {
	GTypeClass parent_class;
	void (*finalize) (Notify *self);
	void (*run) (Notify* self, Scanner* scanner);
};

struct _ParamSpecNotify {
	GParamSpec parent_instance;
};

struct _NotifyScanningChanged {
	Notify parent_instance;
	NotifyScanningChangedPrivate * priv;
};

struct _NotifyScanningChangedClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevices {
	Notify parent_instance;
	NotifyUpdateDevicesPrivate * priv;
};

struct _NotifyUpdateDevicesClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevicesPrivate {
	GList* devices;
};

struct _NotifyRequestAuthorization {
	Notify parent_instance;
	NotifyRequestAuthorizationPrivate * priv;
};

struct _NotifyRequestAuthorizationClass {
	NotifyClass parent_class;
};

struct _NotifyRequestAuthorizationPrivate {
	gchar* resource;
};

struct _NotifyScanFailed {
	Notify parent_instance;
	NotifyScanFailedPrivate * priv;
};

struct _NotifyScanFailedClass {
	NotifyClass parent_class;
};

struct _NotifyScanFailedPrivate {
	gint error_code;
	gchar* error_string;
};

struct _NotifyDocumentDone {
	Notify parent_instance;
	NotifyDocumentDonePrivate * priv;
};

struct _NotifyDocumentDoneClass {
	NotifyClass parent_class;
};

struct _NotifyExpectPage {
	Notify parent_instance;
	NotifyExpectPagePrivate * priv;
};

struct _NotifyExpectPageClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfo {
	Notify parent_instance;
	NotifyGotPageInfoPrivate * priv;
};

struct _NotifyGotPageInfoClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfoPrivate {
	gint job_id;
	ScanPageInfo* info;
};

struct _Scanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScannerPrivate * priv;
	gint first_job_id;
	gint job_id;
};

struct _ScannerClass {
	GTypeClass parent_class;
	void (*finalize) (Scanner *self);
};

struct _NotifyPageDone {
	Notify parent_instance;
	NotifyPageDonePrivate * priv;
};

struct _NotifyPageDoneClass {
	NotifyClass parent_class;
};

struct _NotifyPageDonePrivate {
	gint job_id;
};

struct _NotifyGotLine {
	Notify parent_instance;
	NotifyGotLinePrivate * priv;
};

struct _NotifyGotLineClass {
	NotifyClass parent_class;
};

struct _NotifyGotLinePrivate {
	gint job_id;
	ScanLine* line;
};

struct _ScannerPrivate {
	GThread* thread;
	GAsyncQueue* request_queue;
	GAsyncQueue* notify_queue;
	GAsyncQueue* authorize_queue;
	gchar* default_device;
	ScanState state;
	gboolean need_redetect;
	GList* job_queue;
	SANE_Handle handle;
	gboolean have_handle;
	gchar* current_device;
	SANE_Parameters parameters;
	SANE_Int option_index;
	GHashTable* options;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint n_used;
	gint line_count;
	gint pass_number;
	gint page_number;
	gint notified_page;
	gboolean scanning;
};

struct _ParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer scan_device_parent_class = NULL;
static gpointer scan_page_info_parent_class = NULL;
static gpointer scan_line_parent_class = NULL;
static gpointer scan_options_parent_class = NULL;
static gpointer scan_job_parent_class = NULL;
static gpointer request_parent_class = NULL;
static gpointer request_redetect_parent_class = NULL;
static gpointer request_cancel_parent_class = NULL;
static gpointer request_start_scan_parent_class = NULL;
static gpointer request_quit_parent_class = NULL;
static gpointer credentials_parent_class = NULL;
static gpointer notify_parent_class = NULL;
static gpointer notify_scanning_changed_parent_class = NULL;
static gpointer notify_update_devices_parent_class = NULL;
static gpointer notify_request_authorization_parent_class = NULL;
static gpointer notify_scan_failed_parent_class = NULL;
static gpointer notify_document_done_parent_class = NULL;
static gpointer notify_expect_page_parent_class = NULL;
static gpointer notify_got_page_info_parent_class = NULL;
static gpointer notify_page_done_parent_class = NULL;
static gpointer notify_got_line_parent_class = NULL;
static gpointer scanner_parent_class = NULL;
static Scanner* scanner_scanner_object;
static Scanner* scanner_scanner_object = NULL;

gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_DEVICE_DUMMY_PROPERTY
};
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void scan_device_finalize (ScanDevice* obj);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_PAGE_INFO_DUMMY_PROPERTY
};
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
static void scan_page_info_finalize (ScanPageInfo* obj);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_LINE_DUMMY_PROPERTY
};
ScanLine* scan_line_new (void);
ScanLine* scan_line_construct (GType object_type);
static void scan_line_finalize (ScanLine* obj);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_OPTIONS_DUMMY_PROPERTY
};
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
static void scan_options_finalize (ScanOptions* obj);
gpointer scan_job_ref (gpointer instance);
void scan_job_unref (gpointer instance);
GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_job (GValue* value, gpointer v_object);
void value_take_scan_job (GValue* value, gpointer v_object);
gpointer value_get_scan_job (const GValue* value);
GType scan_job_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_JOB_DUMMY_PROPERTY
};
ScanJob* scan_job_new (void);
ScanJob* scan_job_construct (GType object_type);
static void scan_job_finalize (ScanJob* obj);
gpointer request_ref (gpointer instance);
void request_unref (gpointer instance);
GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_request (GValue* value, gpointer v_object);
void value_take_request (GValue* value, gpointer v_object);
gpointer value_get_request (const GValue* value);
GType request_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_DUMMY_PROPERTY
};
Request* request_new (void);
Request* request_construct (GType object_type);
static void request_finalize (Request* obj);
GType request_redetect_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_REDETECT_DUMMY_PROPERTY
};
RequestRedetect* request_redetect_new (void);
RequestRedetect* request_redetect_construct (GType object_type);
GType request_cancel_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_CANCEL_DUMMY_PROPERTY
};
RequestCancel* request_cancel_new (void);
RequestCancel* request_cancel_construct (GType object_type);
GType request_start_scan_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_START_SCAN_DUMMY_PROPERTY
};
RequestStartScan* request_start_scan_new (void);
RequestStartScan* request_start_scan_construct (GType object_type);
static void request_start_scan_finalize (Request* obj);
GType request_quit_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_QUIT_DUMMY_PROPERTY
};
RequestQuit* request_quit_new (void);
RequestQuit* request_quit_construct (GType object_type);
gpointer credentials_ref (gpointer instance);
void credentials_unref (gpointer instance);
GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_credentials (GValue* value, gpointer v_object);
void value_take_credentials (GValue* value, gpointer v_object);
gpointer value_get_credentials (const GValue* value);
GType credentials_get_type (void) G_GNUC_CONST;
enum  {
	CREDENTIALS_DUMMY_PROPERTY
};
Credentials* credentials_new (void);
Credentials* credentials_construct (GType object_type);
static void credentials_finalize (Credentials* obj);
GType scan_state_get_type (void) G_GNUC_CONST;
gpointer notify_ref (gpointer instance);
void notify_unref (gpointer instance);
GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_notify (GValue* value, gpointer v_object);
void value_take_notify (GValue* value, gpointer v_object);
gpointer value_get_notify (const GValue* value);
GType notify_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DUMMY_PROPERTY
};
void notify_run (Notify* self, Scanner* scanner);
static void notify_real_run (Notify* self, Scanner* scanner);
Notify* notify_new (void);
Notify* notify_construct (GType object_type);
static void notify_finalize (Notify* obj);
GType notify_scanning_changed_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_SCANNING_CHANGED_DUMMY_PROPERTY
};
static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner);
NotifyScanningChanged* notify_scanning_changed_new (void);
NotifyScanningChanged* notify_scanning_changed_construct (GType object_type);
GType notify_update_devices_get_type (void) G_GNUC_CONST;
#define NOTIFY_UPDATE_DEVICES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesPrivate))
enum  {
	NOTIFY_UPDATE_DEVICES_DUMMY_PROPERTY
};
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
NotifyUpdateDevices* notify_update_devices_new (GList* devices);
NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices);
static void notify_update_devices_real_run (Notify* base, Scanner* scanner);
static void notify_update_devices_finalize (Notify* obj);
GType notify_request_authorization_get_type (void) G_GNUC_CONST;
#define NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationPrivate))
enum  {
	NOTIFY_REQUEST_AUTHORIZATION_DUMMY_PROPERTY
};
NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource);
NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource);
static void notify_request_authorization_real_run (Notify* base, Scanner* scanner);
static void notify_request_authorization_finalize (Notify* obj);
GType notify_scan_failed_get_type (void) G_GNUC_CONST;
#define NOTIFY_SCAN_FAILED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedPrivate))
enum  {
	NOTIFY_SCAN_FAILED_DUMMY_PROPERTY
};
NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string);
NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string);
static void notify_scan_failed_real_run (Notify* base, Scanner* scanner);
static void notify_scan_failed_finalize (Notify* obj);
GType notify_document_done_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DOCUMENT_DONE_DUMMY_PROPERTY
};
static void notify_document_done_real_run (Notify* base, Scanner* scanner);
NotifyDocumentDone* notify_document_done_new (void);
NotifyDocumentDone* notify_document_done_construct (GType object_type);
GType notify_expect_page_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_EXPECT_PAGE_DUMMY_PROPERTY
};
static void notify_expect_page_real_run (Notify* base, Scanner* scanner);
NotifyExpectPage* notify_expect_page_new (void);
NotifyExpectPage* notify_expect_page_construct (GType object_type);
GType notify_got_page_info_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_PAGE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoPrivate))
enum  {
	NOTIFY_GOT_PAGE_INFO_DUMMY_PROPERTY
};
NotifyGotPageInfo* notify_got_page_info_new (gint job_id, ScanPageInfo* info);
NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, gint job_id, ScanPageInfo* info);
static void notify_got_page_info_real_run (Notify* base, Scanner* scanner);
static void notify_got_page_info_finalize (Notify* obj);
GType notify_page_done_get_type (void) G_GNUC_CONST;
#define NOTIFY_PAGE_DONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_PAGE_DONE, NotifyPageDonePrivate))
enum  {
	NOTIFY_PAGE_DONE_DUMMY_PROPERTY
};
NotifyPageDone* notify_page_done_new (gint job_id);
NotifyPageDone* notify_page_done_construct (GType object_type, gint job_id);
static void notify_page_done_real_run (Notify* base, Scanner* scanner);
static void notify_page_done_finalize (Notify* obj);
GType notify_got_line_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_LINE, NotifyGotLinePrivate))
enum  {
	NOTIFY_GOT_LINE_DUMMY_PROPERTY
};
NotifyGotLine* notify_got_line_new (gint job_id, ScanLine* line);
NotifyGotLine* notify_got_line_construct (GType object_type, gint job_id, ScanLine* line);
static void notify_got_line_real_run (Notify* base, Scanner* scanner);
static void notify_got_line_finalize (Notify* obj);
#define SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCANNER, ScannerPrivate))
enum  {
	SCANNER_DUMMY_PROPERTY
};
static void _scan_job_unref0_ (gpointer var);
static void _g_list_free__scan_job_unref0_ (GList* self);
static Scanner* scanner_new (void);
static Scanner* scanner_construct (GType object_type);
static void _request_unref0_ (gpointer var);
static void _notify_unref0_ (gpointer var);
static void _credentials_unref0_ (gpointer var);
Scanner* scanner_get_instance (void);
static gboolean scanner_notify_idle_cb (Scanner* self);
static void scanner_notify (Scanner* self, Notify* notification);
static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self);
static void scanner_set_scanning (Scanner* self, gboolean is_scanning);
static gint scanner_get_device_weight (const gchar* device);
static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2);
static void scanner_do_redetect (Scanner* self);
static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b);
static gint scanner_scale_int (Scanner* self, gint source_min, gint source_max, SANE_Option_Descriptor* option, gint value);
static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_);
static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_);
static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static void scanner_set_fixed_or_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static void scanner_set_option_to_max (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_);
static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_);
static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option);
static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
static void scanner_close_device (Scanner* self);
static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string);
static gboolean scanner_handle_requests (Scanner* self);
static void scanner_do_open (Scanner* self);
static void _g_free0_ (gpointer var);
static void scanner_do_get_option (Scanner* self);
static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self, SANE_Handle handle, const gchar* name, gint* index);
static gdouble scanner_convert_page_size (Scanner* self, SANE_Option_Descriptor* option, gdouble size, gdouble dpi);
static void scanner_do_complete_document (Scanner* self);
static void scanner_do_start (Scanner* self);
static void scanner_do_get_parameters (Scanner* self);
static void scanner_do_complete_page (Scanner* self);
static void scanner_do_read (Scanner* self);
static void* scanner_scan_thread (Scanner* self);
static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password);
void scanner_redetect (Scanner* self);
void scanner_start (Scanner* self);
static gpointer _scanner_scan_thread_gthread_func (gpointer self);
gboolean scanner_is_scanning (Scanner* self);
static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode);
static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
void scanner_free (Scanner* self);
static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void scanner_finalize (Scanner* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ScanDevice* scan_device_construct (GType object_type) {
	ScanDevice* self = NULL;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanDevice*) g_type_create_instance (object_type);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 985 "scanner.c"
}


ScanDevice* scan_device_new (void) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_device_construct (TYPE_SCAN_DEVICE);
#line 992 "scanner.c"
}


static void value_scan_device_init (GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 999 "scanner.c"
}


static void value_scan_device_free_value (GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_device_unref (value->data[0].v_pointer);
#line 1008 "scanner.c"
	}
}


static void value_scan_device_copy_value (const GValue* src_value, GValue* dest_value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_device_ref (src_value->data[0].v_pointer);
#line 1018 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1022 "scanner.c"
	}
}


static gpointer value_scan_device_peek_pointer (const GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1030 "scanner.c"
}


static gchar* value_scan_device_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1037 "scanner.c"
		ScanDevice* object;
		object = collect_values[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1044 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1048 "scanner.c"
		}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_device_ref (object);
#line 1052 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1056 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1060 "scanner.c"
}


static gchar* value_scan_device_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanDevice** object_p;
	object_p = collect_values[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1071 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 1077 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1081 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_device_ref (value->data[0].v_pointer);
#line 1085 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1089 "scanner.c"
}


GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanDevice* spec;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1103 "scanner.c"
}


gpointer value_get_scan_device (const GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1112 "scanner.c"
}


void value_set_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_device_ref (value->data[0].v_pointer);
#line 1132 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1136 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_device_unref (old);
#line 1142 "scanner.c"
	}
}


void value_take_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1161 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1165 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_device_unref (old);
#line 1171 "scanner.c"
	}
}


static void scan_device_class_init (ScanDeviceClass * klass) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_device_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	SCAN_DEVICE_CLASS (klass)->finalize = scan_device_finalize;
#line 1181 "scanner.c"
}


static void scan_device_instance_init (ScanDevice * self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 1188 "scanner.c"
}


static void scan_device_finalize (ScanDevice* obj) {
	ScanDevice * self;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_DEVICE, ScanDevice);
#line 16 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->name);
#line 17 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->label);
#line 1200 "scanner.c"
}


GType scan_device_get_type (void) {
	static volatile gsize scan_device_type_id__volatile = 0;
	if (g_once_init_enter (&scan_device_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_device_init, value_scan_device_free_value, value_scan_device_copy_value, value_scan_device_peek_pointer, "p", value_scan_device_collect_value, "p", value_scan_device_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDevice), 0, (GInstanceInitFunc) scan_device_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_device_type_id;
		scan_device_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanDevice", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_device_type_id__volatile, scan_device_type_id);
	}
	return scan_device_type_id__volatile;
}


gpointer scan_device_ref (gpointer instance) {
	ScanDevice* self;
	self = instance;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 1225 "scanner.c"
}


void scan_device_unref (gpointer instance) {
	ScanDevice* self;
	self = instance;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_DEVICE_GET_CLASS (self)->finalize (self);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1238 "scanner.c"
	}
}


ScanPageInfo* scan_page_info_construct (GType object_type) {
	ScanPageInfo* self = NULL;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanPageInfo*) g_type_create_instance (object_type);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 1249 "scanner.c"
}


ScanPageInfo* scan_page_info_new (void) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_page_info_construct (TYPE_SCAN_PAGE_INFO);
#line 1256 "scanner.c"
}


static void value_scan_page_info_init (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1263 "scanner.c"
}


static void value_scan_page_info_free_value (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_page_info_unref (value->data[0].v_pointer);
#line 1272 "scanner.c"
	}
}


static void value_scan_page_info_copy_value (const GValue* src_value, GValue* dest_value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_page_info_ref (src_value->data[0].v_pointer);
#line 1282 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1286 "scanner.c"
	}
}


static gpointer value_scan_page_info_peek_pointer (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1294 "scanner.c"
}


static gchar* value_scan_page_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1301 "scanner.c"
		ScanPageInfo* object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1308 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1312 "scanner.c"
		}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_page_info_ref (object);
#line 1316 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1320 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1324 "scanner.c"
}


static gchar* value_scan_page_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanPageInfo** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1335 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 1341 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1345 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_page_info_ref (value->data[0].v_pointer);
#line 1349 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1353 "scanner.c"
}


GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanPageInfo* spec;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1367 "scanner.c"
}


gpointer value_get_scan_page_info (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1376 "scanner.c"
}


void value_set_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_page_info_ref (value->data[0].v_pointer);
#line 1396 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1400 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_page_info_unref (old);
#line 1406 "scanner.c"
	}
}


void value_take_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1425 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1429 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_page_info_unref (old);
#line 1435 "scanner.c"
	}
}


static void scan_page_info_class_init (ScanPageInfoClass * klass) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_page_info_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	SCAN_PAGE_INFO_CLASS (klass)->finalize = scan_page_info_finalize;
#line 1445 "scanner.c"
}


static void scan_page_info_instance_init (ScanPageInfo * self) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 1452 "scanner.c"
}


static void scan_page_info_finalize (ScanPageInfo* obj) {
	ScanPageInfo * self;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_PAGE_INFO, ScanPageInfo);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->device);
#line 1462 "scanner.c"
}


GType scan_page_info_get_type (void) {
	static volatile gsize scan_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&scan_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_page_info_init, value_scan_page_info_free_value, value_scan_page_info_copy_value, value_scan_page_info_peek_pointer, "p", value_scan_page_info_collect_value, "p", value_scan_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanPageInfo), 0, (GInstanceInitFunc) scan_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_page_info_type_id;
		scan_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_page_info_type_id__volatile, scan_page_info_type_id);
	}
	return scan_page_info_type_id__volatile;
}


gpointer scan_page_info_ref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 1487 "scanner.c"
}


void scan_page_info_unref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_PAGE_INFO_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1500 "scanner.c"
	}
}


ScanLine* scan_line_construct (GType object_type) {
	ScanLine* self = NULL;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanLine*) g_type_create_instance (object_type);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 1511 "scanner.c"
}


ScanLine* scan_line_new (void) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_line_construct (TYPE_SCAN_LINE);
#line 1518 "scanner.c"
}


static void value_scan_line_init (GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1525 "scanner.c"
}


static void value_scan_line_free_value (GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_line_unref (value->data[0].v_pointer);
#line 1534 "scanner.c"
	}
}


static void value_scan_line_copy_value (const GValue* src_value, GValue* dest_value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_line_ref (src_value->data[0].v_pointer);
#line 1544 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1548 "scanner.c"
	}
}


static gpointer value_scan_line_peek_pointer (const GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1556 "scanner.c"
}


static gchar* value_scan_line_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1563 "scanner.c"
		ScanLine* object;
		object = collect_values[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1570 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1574 "scanner.c"
		}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_line_ref (object);
#line 1578 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1582 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1586 "scanner.c"
}


static gchar* value_scan_line_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanLine** object_p;
	object_p = collect_values[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1597 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 1603 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1607 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_line_ref (value->data[0].v_pointer);
#line 1611 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1615 "scanner.c"
}


GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanLine* spec;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1629 "scanner.c"
}


gpointer value_get_scan_line (const GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1638 "scanner.c"
}


void value_set_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_line_ref (value->data[0].v_pointer);
#line 1658 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1662 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_line_unref (old);
#line 1668 "scanner.c"
	}
}


void value_take_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1687 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1691 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_line_unref (old);
#line 1697 "scanner.c"
	}
}


static void scan_line_class_init (ScanLineClass * klass) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_line_parent_class = g_type_class_peek_parent (klass);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	SCAN_LINE_CLASS (klass)->finalize = scan_line_finalize;
#line 1707 "scanner.c"
}


static void scan_line_instance_init (ScanLine * self) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 1714 "scanner.c"
}


static void scan_line_finalize (ScanLine* obj) {
	ScanLine * self;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_LINE, ScanLine);
#line 55 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->data = (g_free (self->data), NULL);
#line 1724 "scanner.c"
}


GType scan_line_get_type (void) {
	static volatile gsize scan_line_type_id__volatile = 0;
	if (g_once_init_enter (&scan_line_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_line_init, value_scan_line_free_value, value_scan_line_copy_value, value_scan_line_peek_pointer, "p", value_scan_line_collect_value, "p", value_scan_line_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanLine), 0, (GInstanceInitFunc) scan_line_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_line_type_id;
		scan_line_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanLine", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_line_type_id__volatile, scan_line_type_id);
	}
	return scan_line_type_id__volatile;
}


gpointer scan_line_ref (gpointer instance) {
	ScanLine* self;
	self = instance;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 1749 "scanner.c"
}


void scan_line_unref (gpointer instance) {
	ScanLine* self;
	self = instance;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_LINE_GET_CLASS (self)->finalize (self);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1762 "scanner.c"
	}
}


GType scan_mode_get_type (void) {
	static volatile gsize scan_mode_type_id__volatile = 0;
	if (g_once_init_enter (&scan_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_MODE_DEFAULT, "SCAN_MODE_DEFAULT", "default"}, {SCAN_MODE_COLOR, "SCAN_MODE_COLOR", "color"}, {SCAN_MODE_GRAY, "SCAN_MODE_GRAY", "gray"}, {SCAN_MODE_LINEART, "SCAN_MODE_LINEART", "lineart"}, {0, NULL, NULL}};
		GType scan_mode_type_id;
		scan_mode_type_id = g_enum_register_static ("ScanMode", values);
		g_once_init_leave (&scan_mode_type_id__volatile, scan_mode_type_id);
	}
	return scan_mode_type_id__volatile;
}


GType scan_type_get_type (void) {
	static volatile gsize scan_type_type_id__volatile = 0;
	if (g_once_init_enter (&scan_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_TYPE_SINGLE, "SCAN_TYPE_SINGLE", "single"}, {SCAN_TYPE_ADF_FRONT, "SCAN_TYPE_ADF_FRONT", "adf-front"}, {SCAN_TYPE_ADF_BACK, "SCAN_TYPE_ADF_BACK", "adf-back"}, {SCAN_TYPE_ADF_BOTH, "SCAN_TYPE_ADF_BOTH", "adf-both"}, {0, NULL, NULL}};
		GType scan_type_type_id;
		scan_type_type_id = g_enum_register_static ("ScanType", values);
		g_once_init_leave (&scan_type_type_id__volatile, scan_type_type_id);
	}
	return scan_type_type_id__volatile;
}


ScanOptions* scan_options_construct (GType object_type) {
	ScanOptions* self = NULL;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanOptions*) g_type_create_instance (object_type);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 1797 "scanner.c"
}


ScanOptions* scan_options_new (void) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_options_construct (TYPE_SCAN_OPTIONS);
#line 1804 "scanner.c"
}


static void value_scan_options_init (GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1811 "scanner.c"
}


static void value_scan_options_free_value (GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_options_unref (value->data[0].v_pointer);
#line 1820 "scanner.c"
	}
}


static void value_scan_options_copy_value (const GValue* src_value, GValue* dest_value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_options_ref (src_value->data[0].v_pointer);
#line 1830 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1834 "scanner.c"
	}
}


static gpointer value_scan_options_peek_pointer (const GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1842 "scanner.c"
}


static gchar* value_scan_options_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1849 "scanner.c"
		ScanOptions* object;
		object = collect_values[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1856 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1860 "scanner.c"
		}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_options_ref (object);
#line 1864 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1868 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1872 "scanner.c"
}


static gchar* value_scan_options_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanOptions** object_p;
	object_p = collect_values[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1883 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 1889 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1893 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_options_ref (value->data[0].v_pointer);
#line 1897 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1901 "scanner.c"
}


GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanOptions* spec;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1915 "scanner.c"
}


gpointer value_get_scan_options (const GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1924 "scanner.c"
}


void value_set_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_options_ref (value->data[0].v_pointer);
#line 1944 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1948 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_options_unref (old);
#line 1954 "scanner.c"
	}
}


void value_take_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1973 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1977 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_options_unref (old);
#line 1983 "scanner.c"
	}
}


static void scan_options_class_init (ScanOptionsClass * klass) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_options_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	SCAN_OPTIONS_CLASS (klass)->finalize = scan_options_finalize;
#line 1993 "scanner.c"
}


static void scan_options_instance_init (ScanOptions * self) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 2000 "scanner.c"
}


static void scan_options_finalize (ScanOptions* obj) {
	ScanOptions * self;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_OPTIONS, ScanOptions);
#line 2008 "scanner.c"
}


GType scan_options_get_type (void) {
	static volatile gsize scan_options_type_id__volatile = 0;
	if (g_once_init_enter (&scan_options_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_options_init, value_scan_options_free_value, value_scan_options_copy_value, value_scan_options_peek_pointer, "p", value_scan_options_collect_value, "p", value_scan_options_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanOptions), 0, (GInstanceInitFunc) scan_options_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_options_type_id;
		scan_options_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanOptions", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_options_type_id__volatile, scan_options_type_id);
	}
	return scan_options_type_id__volatile;
}


gpointer scan_options_ref (gpointer instance) {
	ScanOptions* self;
	self = instance;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 2033 "scanner.c"
}


void scan_options_unref (gpointer instance) {
	ScanOptions* self;
	self = instance;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_OPTIONS_GET_CLASS (self)->finalize (self);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2046 "scanner.c"
	}
}


ScanJob* scan_job_construct (GType object_type) {
	ScanJob* self = NULL;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanJob*) g_type_create_instance (object_type);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2057 "scanner.c"
}


ScanJob* scan_job_new (void) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_job_construct (TYPE_SCAN_JOB);
#line 2064 "scanner.c"
}


static void value_scan_job_init (GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2071 "scanner.c"
}


static void value_scan_job_free_value (GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_job_unref (value->data[0].v_pointer);
#line 2080 "scanner.c"
	}
}


static void value_scan_job_copy_value (const GValue* src_value, GValue* dest_value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_job_ref (src_value->data[0].v_pointer);
#line 2090 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2094 "scanner.c"
	}
}


static gpointer value_scan_job_peek_pointer (const GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2102 "scanner.c"
}


static gchar* value_scan_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2109 "scanner.c"
		ScanJob* object;
		object = collect_values[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2116 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2120 "scanner.c"
		}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_job_ref (object);
#line 2124 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2128 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2132 "scanner.c"
}


static gchar* value_scan_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanJob** object_p;
	object_p = collect_values[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2143 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 2149 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2153 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_job_ref (value->data[0].v_pointer);
#line 2157 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2161 "scanner.c"
}


GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanJob* spec;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_JOB), NULL);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2175 "scanner.c"
}


gpointer value_get_scan_job (const GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB), NULL);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2184 "scanner.c"
}


void value_set_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_job_ref (value->data[0].v_pointer);
#line 2204 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2208 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_job_unref (old);
#line 2214 "scanner.c"
	}
}


void value_take_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2233 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2237 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_job_unref (old);
#line 2243 "scanner.c"
	}
}


static void scan_job_class_init (ScanJobClass * klass) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_job_parent_class = g_type_class_peek_parent (klass);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	SCAN_JOB_CLASS (klass)->finalize = scan_job_finalize;
#line 2253 "scanner.c"
}


static void scan_job_instance_init (ScanJob * self) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 2260 "scanner.c"
}


static void scan_job_finalize (ScanJob* obj) {
	ScanJob * self;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_JOB, ScanJob);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->device);
#line 2270 "scanner.c"
}


GType scan_job_get_type (void) {
	static volatile gsize scan_job_type_id__volatile = 0;
	if (g_once_init_enter (&scan_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_job_init, value_scan_job_free_value, value_scan_job_copy_value, value_scan_job_peek_pointer, "p", value_scan_job_collect_value, "p", value_scan_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanJob), 0, (GInstanceInitFunc) scan_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_job_type_id;
		scan_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_job_type_id__volatile, scan_job_type_id);
	}
	return scan_job_type_id__volatile;
}


gpointer scan_job_ref (gpointer instance) {
	ScanJob* self;
	self = instance;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 2295 "scanner.c"
}


void scan_job_unref (gpointer instance) {
	ScanJob* self;
	self = instance;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_JOB_GET_CLASS (self)->finalize (self);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2308 "scanner.c"
	}
}


Request* request_construct (GType object_type) {
	Request* self = NULL;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (Request*) g_type_create_instance (object_type);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2319 "scanner.c"
}


Request* request_new (void) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_construct (TYPE_REQUEST);
#line 2326 "scanner.c"
}


static void value_request_init (GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2333 "scanner.c"
}


static void value_request_free_value (GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_unref (value->data[0].v_pointer);
#line 2342 "scanner.c"
	}
}


static void value_request_copy_value (const GValue* src_value, GValue* dest_value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = request_ref (src_value->data[0].v_pointer);
#line 2352 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2356 "scanner.c"
	}
}


static gpointer value_request_peek_pointer (const GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2364 "scanner.c"
}


static gchar* value_request_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2371 "scanner.c"
		Request* object;
		object = collect_values[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2378 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2382 "scanner.c"
		}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = request_ref (object);
#line 2386 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2390 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2394 "scanner.c"
}


static gchar* value_request_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Request** object_p;
	object_p = collect_values[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2405 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 2411 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2415 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = request_ref (value->data[0].v_pointer);
#line 2419 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2423 "scanner.c"
}


GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecRequest* spec;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REQUEST), NULL);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2437 "scanner.c"
}


gpointer value_get_request (const GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST), NULL);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2446 "scanner.c"
}


void value_set_request (GValue* value, gpointer v_object) {
	Request* old;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_ref (value->data[0].v_pointer);
#line 2466 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2470 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_unref (old);
#line 2476 "scanner.c"
	}
}


void value_take_request (GValue* value, gpointer v_object) {
	Request* old;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2495 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2499 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_unref (old);
#line 2505 "scanner.c"
	}
}


static void request_class_init (RequestClass * klass) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_parent_class = g_type_class_peek_parent (klass);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	REQUEST_CLASS (klass)->finalize = request_finalize;
#line 2515 "scanner.c"
}


static void request_instance_init (Request * self) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 2522 "scanner.c"
}


static void request_finalize (Request* obj) {
	Request * self;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST, Request);
#line 2530 "scanner.c"
}


GType request_get_type (void) {
	static volatile gsize request_type_id__volatile = 0;
	if (g_once_init_enter (&request_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_request_init, value_request_free_value, value_request_copy_value, value_request_peek_pointer, "p", value_request_collect_value, "p", value_request_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Request), 0, (GInstanceInitFunc) request_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType request_type_id;
		request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Request", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&request_type_id__volatile, request_type_id);
	}
	return request_type_id__volatile;
}


gpointer request_ref (gpointer instance) {
	Request* self;
	self = instance;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 2555 "scanner.c"
}


void request_unref (gpointer instance) {
	Request* self;
	self = instance;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		REQUEST_GET_CLASS (self)->finalize (self);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2568 "scanner.c"
	}
}


RequestRedetect* request_redetect_construct (GType object_type) {
	RequestRedetect* self = NULL;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (RequestRedetect*) request_construct (object_type);
#line 103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2579 "scanner.c"
}


RequestRedetect* request_redetect_new (void) {
#line 103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_redetect_construct (TYPE_REQUEST_REDETECT);
#line 2586 "scanner.c"
}


static void request_redetect_class_init (RequestRedetectClass * klass) {
#line 103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_redetect_parent_class = g_type_class_peek_parent (klass);
#line 2593 "scanner.c"
}


static void request_redetect_instance_init (RequestRedetect * self) {
}


GType request_redetect_get_type (void) {
	static volatile gsize request_redetect_type_id__volatile = 0;
	if (g_once_init_enter (&request_redetect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestRedetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_redetect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestRedetect), 0, (GInstanceInitFunc) request_redetect_instance_init, NULL };
		GType request_redetect_type_id;
		request_redetect_type_id = g_type_register_static (TYPE_REQUEST, "RequestRedetect", &g_define_type_info, 0);
		g_once_init_leave (&request_redetect_type_id__volatile, request_redetect_type_id);
	}
	return request_redetect_type_id__volatile;
}


RequestCancel* request_cancel_construct (GType object_type) {
	RequestCancel* self = NULL;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (RequestCancel*) request_construct (object_type);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2619 "scanner.c"
}


RequestCancel* request_cancel_new (void) {
#line 105 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_cancel_construct (TYPE_REQUEST_CANCEL);
#line 2626 "scanner.c"
}


static void request_cancel_class_init (RequestCancelClass * klass) {
#line 105 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_cancel_parent_class = g_type_class_peek_parent (klass);
#line 2633 "scanner.c"
}


static void request_cancel_instance_init (RequestCancel * self) {
}


GType request_cancel_get_type (void) {
	static volatile gsize request_cancel_type_id__volatile = 0;
	if (g_once_init_enter (&request_cancel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestCancelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_cancel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestCancel), 0, (GInstanceInitFunc) request_cancel_instance_init, NULL };
		GType request_cancel_type_id;
		request_cancel_type_id = g_type_register_static (TYPE_REQUEST, "RequestCancel", &g_define_type_info, 0);
		g_once_init_leave (&request_cancel_type_id__volatile, request_cancel_type_id);
	}
	return request_cancel_type_id__volatile;
}


RequestStartScan* request_start_scan_construct (GType object_type) {
	RequestStartScan* self = NULL;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (RequestStartScan*) request_construct (object_type);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2659 "scanner.c"
}


RequestStartScan* request_start_scan_new (void) {
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_start_scan_construct (TYPE_REQUEST_START_SCAN);
#line 2666 "scanner.c"
}


static void request_start_scan_class_init (RequestStartScanClass * klass) {
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_start_scan_parent_class = g_type_class_peek_parent (klass);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	REQUEST_CLASS (klass)->finalize = request_start_scan_finalize;
#line 2675 "scanner.c"
}


static void request_start_scan_instance_init (RequestStartScan * self) {
}


static void request_start_scan_finalize (Request* obj) {
	RequestStartScan * self;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST_START_SCAN, RequestStartScan);
#line 109 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (self->job);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	REQUEST_CLASS (request_start_scan_parent_class)->finalize (obj);
#line 2691 "scanner.c"
}


GType request_start_scan_get_type (void) {
	static volatile gsize request_start_scan_type_id__volatile = 0;
	if (g_once_init_enter (&request_start_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestStartScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_start_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestStartScan), 0, (GInstanceInitFunc) request_start_scan_instance_init, NULL };
		GType request_start_scan_type_id;
		request_start_scan_type_id = g_type_register_static (TYPE_REQUEST, "RequestStartScan", &g_define_type_info, 0);
		g_once_init_leave (&request_start_scan_type_id__volatile, request_start_scan_type_id);
	}
	return request_start_scan_type_id__volatile;
}


RequestQuit* request_quit_construct (GType object_type) {
	RequestQuit* self = NULL;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (RequestQuit*) request_construct (object_type);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2713 "scanner.c"
}


RequestQuit* request_quit_new (void) {
#line 112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_quit_construct (TYPE_REQUEST_QUIT);
#line 2720 "scanner.c"
}


static void request_quit_class_init (RequestQuitClass * klass) {
#line 112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_quit_parent_class = g_type_class_peek_parent (klass);
#line 2727 "scanner.c"
}


static void request_quit_instance_init (RequestQuit * self) {
}


GType request_quit_get_type (void) {
	static volatile gsize request_quit_type_id__volatile = 0;
	if (g_once_init_enter (&request_quit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestQuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_quit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestQuit), 0, (GInstanceInitFunc) request_quit_instance_init, NULL };
		GType request_quit_type_id;
		request_quit_type_id = g_type_register_static (TYPE_REQUEST, "RequestQuit", &g_define_type_info, 0);
		g_once_init_leave (&request_quit_type_id__volatile, request_quit_type_id);
	}
	return request_quit_type_id__volatile;
}


Credentials* credentials_construct (GType object_type) {
	Credentials* self = NULL;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (Credentials*) g_type_create_instance (object_type);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2753 "scanner.c"
}


Credentials* credentials_new (void) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return credentials_construct (TYPE_CREDENTIALS);
#line 2760 "scanner.c"
}


static void value_credentials_init (GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2767 "scanner.c"
}


static void value_credentials_free_value (GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		credentials_unref (value->data[0].v_pointer);
#line 2776 "scanner.c"
	}
}


static void value_credentials_copy_value (const GValue* src_value, GValue* dest_value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = credentials_ref (src_value->data[0].v_pointer);
#line 2786 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2790 "scanner.c"
	}
}


static gpointer value_credentials_peek_pointer (const GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2798 "scanner.c"
}


static gchar* value_credentials_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2805 "scanner.c"
		Credentials* object;
		object = collect_values[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2812 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2816 "scanner.c"
		}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = credentials_ref (object);
#line 2820 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2824 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2828 "scanner.c"
}


static gchar* value_credentials_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Credentials** object_p;
	object_p = collect_values[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2839 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 2845 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2849 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = credentials_ref (value->data[0].v_pointer);
#line 2853 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2857 "scanner.c"
}


GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCredentials* spec;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CREDENTIALS), NULL);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2871 "scanner.c"
}


gpointer value_get_credentials (const GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS), NULL);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2880 "scanner.c"
}


void value_set_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		credentials_ref (value->data[0].v_pointer);
#line 2900 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2904 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		credentials_unref (old);
#line 2910 "scanner.c"
	}
}


void value_take_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2929 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2933 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		credentials_unref (old);
#line 2939 "scanner.c"
	}
}


static void credentials_class_init (CredentialsClass * klass) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials_parent_class = g_type_class_peek_parent (klass);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	CREDENTIALS_CLASS (klass)->finalize = credentials_finalize;
#line 2949 "scanner.c"
}


static void credentials_instance_init (Credentials * self) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 2956 "scanner.c"
}


static void credentials_finalize (Credentials* obj) {
	Credentials * self;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CREDENTIALS, Credentials);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->username);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->password);
#line 2968 "scanner.c"
}


GType credentials_get_type (void) {
	static volatile gsize credentials_type_id__volatile = 0;
	if (g_once_init_enter (&credentials_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_credentials_init, value_credentials_free_value, value_credentials_copy_value, value_credentials_peek_pointer, "p", value_credentials_collect_value, "p", value_credentials_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Credentials), 0, (GInstanceInitFunc) credentials_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType credentials_type_id;
		credentials_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Credentials", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&credentials_type_id__volatile, credentials_type_id);
	}
	return credentials_type_id__volatile;
}


gpointer credentials_ref (gpointer instance) {
	Credentials* self;
	self = instance;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 2993 "scanner.c"
}


void credentials_unref (gpointer instance) {
	Credentials* self;
	self = instance;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		CREDENTIALS_GET_CLASS (self)->finalize (self);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3006 "scanner.c"
	}
}


GType scan_state_get_type (void) {
	static volatile gsize scan_state_type_id__volatile = 0;
	if (g_once_init_enter (&scan_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_STATE_IDLE, "SCAN_STATE_IDLE", "idle"}, {SCAN_STATE_REDETECT, "SCAN_STATE_REDETECT", "redetect"}, {SCAN_STATE_OPEN, "SCAN_STATE_OPEN", "open"}, {SCAN_STATE_GET_OPTION, "SCAN_STATE_GET_OPTION", "get-option"}, {SCAN_STATE_START, "SCAN_STATE_START", "start"}, {SCAN_STATE_GET_PARAMETERS, "SCAN_STATE_GET_PARAMETERS", "get-parameters"}, {SCAN_STATE_READ, "SCAN_STATE_READ", "read"}, {0, NULL, NULL}};
		GType scan_state_type_id;
		scan_state_type_id = g_enum_register_static ("ScanState", values);
		g_once_init_leave (&scan_state_type_id__volatile, scan_state_type_id);
	}
	return scan_state_type_id__volatile;
}


static void notify_real_run (Notify* self, Scanner* scanner) {
#line 133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 3026 "scanner.c"
}


void notify_run (Notify* self, Scanner* scanner) {
#line 133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_GET_CLASS (self)->run (self, scanner);
#line 3035 "scanner.c"
}


Notify* notify_construct (GType object_type) {
	Notify* self = NULL;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (Notify*) g_type_create_instance (object_type);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3045 "scanner.c"
}


Notify* notify_new (void) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_construct (TYPE_NOTIFY);
#line 3052 "scanner.c"
}


static void value_notify_init (GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 3059 "scanner.c"
}


static void value_notify_free_value (GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		notify_unref (value->data[0].v_pointer);
#line 3068 "scanner.c"
	}
}


static void value_notify_copy_value (const GValue* src_value, GValue* dest_value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = notify_ref (src_value->data[0].v_pointer);
#line 3078 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3082 "scanner.c"
	}
}


static gpointer value_notify_peek_pointer (const GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3090 "scanner.c"
}


static gchar* value_notify_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 3097 "scanner.c"
		Notify* object;
		object = collect_values[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3104 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3108 "scanner.c"
		}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = notify_ref (object);
#line 3112 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3116 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 3120 "scanner.c"
}


static gchar* value_notify_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Notify** object_p;
	object_p = collect_values[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3131 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 3137 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 3141 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = notify_ref (value->data[0].v_pointer);
#line 3145 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 3149 "scanner.c"
}


GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecNotify* spec;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFY), NULL);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 3163 "scanner.c"
}


gpointer value_get_notify (const GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY), NULL);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3172 "scanner.c"
}


void value_set_notify (GValue* value, gpointer v_object) {
	Notify* old;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		notify_ref (value->data[0].v_pointer);
#line 3192 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3196 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		notify_unref (old);
#line 3202 "scanner.c"
	}
}


void value_take_notify (GValue* value, gpointer v_object) {
	Notify* old;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 3221 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3225 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		notify_unref (old);
#line 3231 "scanner.c"
	}
}


static void notify_class_init (NotifyClass * klass) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_parent_class = g_type_class_peek_parent (klass);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_finalize;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_real_run;
#line 3243 "scanner.c"
}


static void notify_instance_init (Notify * self) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 3250 "scanner.c"
}


static void notify_finalize (Notify* obj) {
	Notify * self;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY, Notify);
#line 3258 "scanner.c"
}


GType notify_get_type (void) {
	static volatile gsize notify_type_id__volatile = 0;
	if (g_once_init_enter (&notify_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_notify_init, value_notify_free_value, value_notify_copy_value, value_notify_peek_pointer, "p", value_notify_collect_value, "p", value_notify_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notify), 0, (GInstanceInitFunc) notify_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType notify_type_id;
		notify_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Notify", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&notify_type_id__volatile, notify_type_id);
	}
	return notify_type_id__volatile;
}


gpointer notify_ref (gpointer instance) {
	Notify* self;
	self = instance;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 3283 "scanner.c"
}


void notify_unref (gpointer instance) {
	Notify* self;
	self = instance;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		NOTIFY_GET_CLASS (self)->finalize (self);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3296 "scanner.c"
	}
}


static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanningChanged * self;
	Scanner* _tmp0_ = NULL;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyScanningChanged*) base;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 138 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "scanning-changed");
#line 3312 "scanner.c"
}


NotifyScanningChanged* notify_scanning_changed_construct (GType object_type) {
	NotifyScanningChanged* self = NULL;
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyScanningChanged*) notify_construct (object_type);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3322 "scanner.c"
}


NotifyScanningChanged* notify_scanning_changed_new (void) {
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_scanning_changed_construct (TYPE_NOTIFY_SCANNING_CHANGED);
#line 3329 "scanner.c"
}


static void notify_scanning_changed_class_init (NotifyScanningChangedClass * klass) {
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_scanning_changed_parent_class = g_type_class_peek_parent (klass);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_scanning_changed_real_run;
#line 3338 "scanner.c"
}


static void notify_scanning_changed_instance_init (NotifyScanningChanged * self) {
}


GType notify_scanning_changed_get_type (void) {
	static volatile gsize notify_scanning_changed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scanning_changed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanningChangedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scanning_changed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanningChanged), 0, (GInstanceInitFunc) notify_scanning_changed_instance_init, NULL };
		GType notify_scanning_changed_type_id;
		notify_scanning_changed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanningChanged", &g_define_type_info, 0);
		g_once_init_leave (&notify_scanning_changed_type_id__volatile, notify_scanning_changed_type_id);
	}
	return notify_scanning_changed_type_id__volatile;
}


static void _scan_device_unref0_ (gpointer var) {
#line 144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 3361 "scanner.c"
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
#line 144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
#line 144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_list_free (self);
#line 3370 "scanner.c"
}


NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices) {
	NotifyUpdateDevices* self = NULL;
	GList* _tmp0_ = NULL;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyUpdateDevices*) notify_construct (object_type);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = devices;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	devices = NULL;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->devices = _tmp0_;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (devices);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3391 "scanner.c"
}


NotifyUpdateDevices* notify_update_devices_new (GList* devices) {
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_update_devices_construct (TYPE_NOTIFY_UPDATE_DEVICES, devices);
#line 3398 "scanner.c"
}


static void notify_update_devices_real_run (Notify* base, Scanner* scanner) {
	NotifyUpdateDevices * self;
	Scanner* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyUpdateDevices*) base;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->devices;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "update-devices", _tmp1_);
#line 3416 "scanner.c"
}


static void notify_update_devices_class_init (NotifyUpdateDevicesClass * klass) {
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_update_devices_parent_class = g_type_class_peek_parent (klass);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_update_devices_finalize;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyUpdateDevicesPrivate));
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_update_devices_real_run;
#line 3429 "scanner.c"
}


static void notify_update_devices_instance_init (NotifyUpdateDevices * self) {
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_UPDATE_DEVICES_GET_PRIVATE (self);
#line 3436 "scanner.c"
}


static void notify_update_devices_finalize (Notify* obj) {
	NotifyUpdateDevices * self;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices);
#line 144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_update_devices_parent_class)->finalize (obj);
#line 3448 "scanner.c"
}


GType notify_update_devices_get_type (void) {
	static volatile gsize notify_update_devices_type_id__volatile = 0;
	if (g_once_init_enter (&notify_update_devices_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyUpdateDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_update_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyUpdateDevices), 0, (GInstanceInitFunc) notify_update_devices_instance_init, NULL };
		GType notify_update_devices_type_id;
		notify_update_devices_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyUpdateDevices", &g_define_type_info, 0);
		g_once_init_leave (&notify_update_devices_type_id__volatile, notify_update_devices_type_id);
	}
	return notify_update_devices_type_id__volatile;
}


NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource) {
	NotifyRequestAuthorization* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (resource != NULL, NULL);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyRequestAuthorization*) notify_construct (object_type);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = resource;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->resource = _tmp1_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3482 "scanner.c"
}


NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource) {
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_request_authorization_construct (TYPE_NOTIFY_REQUEST_AUTHORIZATION, resource);
#line 3489 "scanner.c"
}


static void notify_request_authorization_real_run (Notify* base, Scanner* scanner) {
	NotifyRequestAuthorization * self;
	Scanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyRequestAuthorization*) base;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->resource;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "request-authorization", _tmp1_);
#line 3507 "scanner.c"
}


static void notify_request_authorization_class_init (NotifyRequestAuthorizationClass * klass) {
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_request_authorization_parent_class = g_type_class_peek_parent (klass);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_request_authorization_finalize;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyRequestAuthorizationPrivate));
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_request_authorization_real_run;
#line 3520 "scanner.c"
}


static void notify_request_authorization_instance_init (NotifyRequestAuthorization * self) {
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE (self);
#line 3527 "scanner.c"
}


static void notify_request_authorization_finalize (Notify* obj) {
	NotifyRequestAuthorization * self;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization);
#line 151 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_request_authorization_parent_class)->finalize (obj);
#line 3539 "scanner.c"
}


GType notify_request_authorization_get_type (void) {
	static volatile gsize notify_request_authorization_type_id__volatile = 0;
	if (g_once_init_enter (&notify_request_authorization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyRequestAuthorizationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_request_authorization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyRequestAuthorization), 0, (GInstanceInitFunc) notify_request_authorization_instance_init, NULL };
		GType notify_request_authorization_type_id;
		notify_request_authorization_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyRequestAuthorization", &g_define_type_info, 0);
		g_once_init_leave (&notify_request_authorization_type_id__volatile, notify_request_authorization_type_id);
	}
	return notify_request_authorization_type_id__volatile;
}


NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string) {
	NotifyScanFailed* self = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (error_string != NULL, NULL);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyScanFailed*) notify_construct (object_type);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = error_code;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->error_code = _tmp0_;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = error_string;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->error_string = _tmp2_;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3578 "scanner.c"
}


NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string) {
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_scan_failed_construct (TYPE_NOTIFY_SCAN_FAILED, error_code, error_string);
#line 3585 "scanner.c"
}


static void notify_scan_failed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanFailed * self;
	Scanner* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyScanFailed*) base;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->error_code;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->error_string;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "scan-failed", _tmp1_, _tmp2_);
#line 3606 "scanner.c"
}


static void notify_scan_failed_class_init (NotifyScanFailedClass * klass) {
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_scan_failed_parent_class = g_type_class_peek_parent (klass);
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_scan_failed_finalize;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyScanFailedPrivate));
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_scan_failed_real_run;
#line 3619 "scanner.c"
}


static void notify_scan_failed_instance_init (NotifyScanFailed * self) {
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_SCAN_FAILED_GET_PRIVATE (self);
#line 3626 "scanner.c"
}


static void notify_scan_failed_finalize (Notify* obj) {
	NotifyScanFailed * self;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_scan_failed_parent_class)->finalize (obj);
#line 3638 "scanner.c"
}


GType notify_scan_failed_get_type (void) {
	static volatile gsize notify_scan_failed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scan_failed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanFailedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scan_failed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanFailed), 0, (GInstanceInitFunc) notify_scan_failed_instance_init, NULL };
		GType notify_scan_failed_type_id;
		notify_scan_failed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanFailed", &g_define_type_info, 0);
		g_once_init_leave (&notify_scan_failed_type_id__volatile, notify_scan_failed_type_id);
	}
	return notify_scan_failed_type_id__volatile;
}


static void notify_document_done_real_run (Notify* base, Scanner* scanner) {
	NotifyDocumentDone * self;
	Scanner* _tmp0_ = NULL;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyDocumentDone*) base;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "document-done");
#line 3665 "scanner.c"
}


NotifyDocumentDone* notify_document_done_construct (GType object_type) {
	NotifyDocumentDone* self = NULL;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyDocumentDone*) notify_construct (object_type);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3675 "scanner.c"
}


NotifyDocumentDone* notify_document_done_new (void) {
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_document_done_construct (TYPE_NOTIFY_DOCUMENT_DONE);
#line 3682 "scanner.c"
}


static void notify_document_done_class_init (NotifyDocumentDoneClass * klass) {
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_document_done_parent_class = g_type_class_peek_parent (klass);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_document_done_real_run;
#line 3691 "scanner.c"
}


static void notify_document_done_instance_init (NotifyDocumentDone * self) {
}


GType notify_document_done_get_type (void) {
	static volatile gsize notify_document_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_document_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyDocumentDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_document_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyDocumentDone), 0, (GInstanceInitFunc) notify_document_done_instance_init, NULL };
		GType notify_document_done_type_id;
		notify_document_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyDocumentDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_document_done_type_id__volatile, notify_document_done_type_id);
	}
	return notify_document_done_type_id__volatile;
}


static void notify_expect_page_real_run (Notify* base, Scanner* scanner) {
	NotifyExpectPage * self;
	Scanner* _tmp0_ = NULL;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyExpectPage*) base;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "expect-page");
#line 3722 "scanner.c"
}


NotifyExpectPage* notify_expect_page_construct (GType object_type) {
	NotifyExpectPage* self = NULL;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyExpectPage*) notify_construct (object_type);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3732 "scanner.c"
}


NotifyExpectPage* notify_expect_page_new (void) {
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_expect_page_construct (TYPE_NOTIFY_EXPECT_PAGE);
#line 3739 "scanner.c"
}


static void notify_expect_page_class_init (NotifyExpectPageClass * klass) {
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_expect_page_parent_class = g_type_class_peek_parent (klass);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_expect_page_real_run;
#line 3748 "scanner.c"
}


static void notify_expect_page_instance_init (NotifyExpectPage * self) {
}


GType notify_expect_page_get_type (void) {
	static volatile gsize notify_expect_page_type_id__volatile = 0;
	if (g_once_init_enter (&notify_expect_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyExpectPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_expect_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyExpectPage), 0, (GInstanceInitFunc) notify_expect_page_instance_init, NULL };
		GType notify_expect_page_type_id;
		notify_expect_page_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyExpectPage", &g_define_type_info, 0);
		g_once_init_leave (&notify_expect_page_type_id__volatile, notify_expect_page_type_id);
	}
	return notify_expect_page_type_id__volatile;
}


static gpointer _scan_page_info_ref0 (gpointer self) {
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scan_page_info_ref (self) : NULL;
#line 3771 "scanner.c"
}


NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, gint job_id, ScanPageInfo* info) {
	NotifyGotPageInfo* self = NULL;
	gint _tmp0_ = 0;
	ScanPageInfo* _tmp1_ = NULL;
	ScanPageInfo* _tmp2_ = NULL;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyGotPageInfo*) notify_construct (object_type);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = job_id;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = info;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_page_info_ref0 (_tmp1_);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->info = _tmp2_;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3798 "scanner.c"
}


NotifyGotPageInfo* notify_got_page_info_new (gint job_id, ScanPageInfo* info) {
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_got_page_info_construct (TYPE_NOTIFY_GOT_PAGE_INFO, job_id, info);
#line 3805 "scanner.c"
}


static void notify_got_page_info_real_run (Notify* base, Scanner* scanner) {
	NotifyGotPageInfo * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyGotPageInfo*) base;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 3827 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = scanner;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 3839 "scanner.c"
	} else {
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = FALSE;
#line 3843 "scanner.c"
	}
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 3847 "scanner.c"
		Scanner* _tmp7_ = NULL;
		ScanPageInfo* _tmp8_ = NULL;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = scanner;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = self->priv->info;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "got-page-info", _tmp8_);
#line 3856 "scanner.c"
	}
}


static void notify_got_page_info_class_init (NotifyGotPageInfoClass * klass) {
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_got_page_info_parent_class = g_type_class_peek_parent (klass);
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_got_page_info_finalize;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotPageInfoPrivate));
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_got_page_info_real_run;
#line 3870 "scanner.c"
}


static void notify_got_page_info_instance_init (NotifyGotPageInfo * self) {
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_GOT_PAGE_INFO_GET_PRIVATE (self);
#line 3877 "scanner.c"
}


static void notify_got_page_info_finalize (Notify* obj) {
	NotifyGotPageInfo * self;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo);
#line 177 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_got_page_info_parent_class)->finalize (obj);
#line 3889 "scanner.c"
}


GType notify_got_page_info_get_type (void) {
	static volatile gsize notify_got_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_page_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotPageInfo), 0, (GInstanceInitFunc) notify_got_page_info_instance_init, NULL };
		GType notify_got_page_info_type_id;
		notify_got_page_info_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotPageInfo", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_page_info_type_id__volatile, notify_got_page_info_type_id);
	}
	return notify_got_page_info_type_id__volatile;
}


NotifyPageDone* notify_page_done_construct (GType object_type, gint job_id) {
	NotifyPageDone* self = NULL;
	gint _tmp0_ = 0;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyPageDone*) notify_construct (object_type);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = job_id;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3916 "scanner.c"
}


NotifyPageDone* notify_page_done_new (gint job_id) {
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_page_done_construct (TYPE_NOTIFY_PAGE_DONE, job_id);
#line 3923 "scanner.c"
}


static void notify_page_done_real_run (Notify* base, Scanner* scanner) {
	NotifyPageDone * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyPageDone*) base;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 3945 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = scanner;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 3957 "scanner.c"
	} else {
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = FALSE;
#line 3961 "scanner.c"
	}
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 3965 "scanner.c"
		Scanner* _tmp7_ = NULL;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = scanner;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "page-done");
#line 3971 "scanner.c"
	}
}


static void notify_page_done_class_init (NotifyPageDoneClass * klass) {
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_page_done_parent_class = g_type_class_peek_parent (klass);
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_page_done_finalize;
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyPageDonePrivate));
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_page_done_real_run;
#line 3985 "scanner.c"
}


static void notify_page_done_instance_init (NotifyPageDone * self) {
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_PAGE_DONE_GET_PRIVATE (self);
#line 3992 "scanner.c"
}


static void notify_page_done_finalize (Notify* obj) {
	NotifyPageDone * self;
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_PAGE_DONE, NotifyPageDone);
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_page_done_parent_class)->finalize (obj);
#line 4002 "scanner.c"
}


GType notify_page_done_get_type (void) {
	static volatile gsize notify_page_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_page_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyPageDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_page_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyPageDone), 0, (GInstanceInitFunc) notify_page_done_instance_init, NULL };
		GType notify_page_done_type_id;
		notify_page_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyPageDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_page_done_type_id__volatile, notify_page_done_type_id);
	}
	return notify_page_done_type_id__volatile;
}


static gpointer _scan_line_ref0 (gpointer self) {
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scan_line_ref (self) : NULL;
#line 4021 "scanner.c"
}


NotifyGotLine* notify_got_line_construct (GType object_type, gint job_id, ScanLine* line) {
	NotifyGotLine* self = NULL;
	gint _tmp0_ = 0;
	ScanLine* _tmp1_ = NULL;
	ScanLine* _tmp2_ = NULL;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyGotLine*) notify_construct (object_type);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = job_id;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = line;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_line_ref0 (_tmp1_);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->line = _tmp2_;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 4048 "scanner.c"
}


NotifyGotLine* notify_got_line_new (gint job_id, ScanLine* line) {
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_got_line_construct (TYPE_NOTIFY_GOT_LINE, job_id, line);
#line 4055 "scanner.c"
}


static void notify_got_line_real_run (Notify* base, Scanner* scanner) {
	NotifyGotLine * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyGotLine*) base;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 4077 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = scanner;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 4089 "scanner.c"
	} else {
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = FALSE;
#line 4093 "scanner.c"
	}
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 4097 "scanner.c"
		Scanner* _tmp7_ = NULL;
		ScanLine* _tmp8_ = NULL;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = scanner;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = self->priv->line;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "got-line", _tmp8_);
#line 4106 "scanner.c"
	}
}


static void notify_got_line_class_init (NotifyGotLineClass * klass) {
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_got_line_parent_class = g_type_class_peek_parent (klass);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_got_line_finalize;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotLinePrivate));
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_got_line_real_run;
#line 4120 "scanner.c"
}


static void notify_got_line_instance_init (NotifyGotLine * self) {
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_GOT_LINE_GET_PRIVATE (self);
#line 4127 "scanner.c"
}


static void notify_got_line_finalize (Notify* obj) {
	NotifyGotLine * self;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_LINE, NotifyGotLine);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_got_line_parent_class)->finalize (obj);
#line 4139 "scanner.c"
}


GType notify_got_line_get_type (void) {
	static volatile gsize notify_got_line_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotLine), 0, (GInstanceInitFunc) notify_got_line_instance_init, NULL };
		GType notify_got_line_type_id;
		notify_got_line_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotLine", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_line_type_id__volatile, notify_got_line_type_id);
	}
	return notify_got_line_type_id__volatile;
}


static void _scan_job_unref0_ (gpointer var) {
#line 234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_job_unref (var), NULL));
#line 4158 "scanner.c"
}


static void _g_list_free__scan_job_unref0_ (GList* self) {
#line 234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_list_foreach (self, (GFunc) _scan_job_unref0_, NULL);
#line 234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_list_free (self);
#line 4167 "scanner.c"
}


static void _request_unref0_ (gpointer var) {
#line 273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (request_unref (var), NULL));
#line 4174 "scanner.c"
}


static void _notify_unref0_ (gpointer var) {
#line 274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (notify_unref (var), NULL));
#line 4181 "scanner.c"
}


static void _credentials_unref0_ (gpointer var) {
#line 275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (credentials_unref (var), NULL));
#line 4188 "scanner.c"
}


static Scanner* scanner_construct (GType object_type) {
	Scanner* self = NULL;
	GAsyncQueue* _tmp0_ = NULL;
	GAsyncQueue* _tmp1_ = NULL;
	GAsyncQueue* _tmp2_ = NULL;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (Scanner*) g_type_create_instance (object_type);
#line 273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = g_async_queue_new_full (_request_unref0_);
#line 273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->request_queue = _tmp0_;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_async_queue_new_full (_notify_unref0_);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->notify_queue = _tmp1_;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = g_async_queue_new_full (_credentials_unref0_);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->authorize_queue = _tmp2_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 4219 "scanner.c"
}


static Scanner* scanner_new (void) {
#line 271 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scanner_construct (TYPE_SCANNER);
#line 4226 "scanner.c"
}


static gpointer _scanner_ref0 (gpointer self) {
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scanner_ref (self) : NULL;
#line 4233 "scanner.c"
}


Scanner* scanner_get_instance (void) {
	Scanner* result = NULL;
	Scanner* _tmp0_ = NULL;
	Scanner* _tmp2_ = NULL;
	Scanner* _tmp3_ = NULL;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_ == NULL) {
#line 4246 "scanner.c"
		Scanner* _tmp1_ = NULL;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = scanner_new ();
#line 281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scanner_unref0 (scanner_scanner_object);
#line 281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_scanner_object = _tmp1_;
#line 4254 "scanner.c"
	}
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner_scanner_object;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _scanner_ref0 (_tmp2_);
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp3_;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4264 "scanner.c"
}


static gboolean scanner_notify_idle_cb (Scanner* self) {
	gboolean result = FALSE;
	Notify* notification = NULL;
	GAsyncQueue* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 287 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_async_queue_pop (_tmp0_);
#line 287 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notification = (Notify*) _tmp1_;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_run (notification, self);
#line 289 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = FALSE;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (notification);
#line 289 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4289 "scanner.c"
}


static gpointer _notify_ref0 (gpointer self) {
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? notify_ref (self) : NULL;
#line 4296 "scanner.c"
}


static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self) {
	gboolean result;
	result = scanner_notify_idle_cb ((Scanner*) self);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4305 "scanner.c"
}


static void scanner_notify (Scanner* self, Notify* notification) {
	GAsyncQueue* _tmp0_ = NULL;
	Notify* _tmp1_ = NULL;
	Notify* _tmp2_ = NULL;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (notification != NULL);
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = notification;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _notify_ref0 (_tmp1_);
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp0_, _tmp2_);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scanner_notify_idle_cb_gsource_func, scanner_ref (self), scanner_unref);
#line 4327 "scanner.c"
}


static void scanner_set_scanning (Scanner* self, gboolean is_scanning) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 298 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->scanning;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp2_) {
#line 4341 "scanner.c"
		gboolean _tmp3_ = FALSE;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = is_scanning;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = !_tmp3_;
#line 4347 "scanner.c"
	} else {
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = FALSE;
#line 4351 "scanner.c"
	}
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_) {
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = TRUE;
#line 4357 "scanner.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = self->priv->scanning;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (!_tmp5_) {
#line 4365 "scanner.c"
			gboolean _tmp6_ = FALSE;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = is_scanning;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = _tmp6_;
#line 4371 "scanner.c"
		} else {
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = FALSE;
#line 4375 "scanner.c"
		}
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp4_;
#line 4379 "scanner.c"
	}
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 4383 "scanner.c"
		gboolean _tmp7_ = FALSE;
		NotifyScanningChanged* _tmp8_ = NULL;
		NotifyScanningChanged* _tmp9_ = NULL;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = is_scanning;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->scanning = _tmp7_;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = notify_scanning_changed_new ();
#line 303 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = _tmp8_;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp9_);
#line 303 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_notify_unref0 (_tmp9_);
#line 4399 "scanner.c"
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1274 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1274 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 4420 "scanner.c"
}


static gint scanner_get_device_weight (const gchar* device) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (device != NULL, 0);
#line 312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = device;
#line 312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "vfl:");
#line 312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_) {
#line 313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = 2;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 4442 "scanner.c"
	}
#line 316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = device;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = string_contains (_tmp2_, "usb");
#line 316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp3_) {
#line 317 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = 0;
#line 317 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 4454 "scanner.c"
	}
#line 319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = 1;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4460 "scanner.c"
}


static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2) {
	gint result = 0;
	gint weight1 = 0;
	ScanDevice* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint weight2 = 0;
	ScanDevice* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GCompareFunc _tmp10_ = NULL;
	ScanDevice* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	ScanDevice* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (device1 != NULL, 0);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (device2 != NULL, 0);
#line 326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = device1;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->name;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner_get_device_weight (_tmp1_);
#line 326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	weight1 = _tmp2_;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = device2;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->name;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = scanner_get_device_weight (_tmp4_);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	weight2 = _tmp5_;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = weight1;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = weight2;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp6_ != _tmp7_) {
#line 4508 "scanner.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = weight1;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = weight2;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = _tmp8_ - _tmp9_;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 4519 "scanner.c"
	}
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = g_strcmp0;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = device1;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = _tmp11_->label;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = device2;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = _tmp13_->label;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp15_ = _tmp10_ (_tmp12_, _tmp14_);
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp15_;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4537 "scanner.c"
}


static gchar* sane_status_to_string (SANE_Status status) {
	gchar* result = NULL;
	SANE_Status _tmp0_ = 0;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
	_tmp0_ = status;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
	switch (_tmp0_) {
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_GOOD:
#line 4550 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_STATUS_GOOD");
#line 57 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp1_;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4559 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_UNSUPPORTED:
#line 4563 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_STATUS_UNSUPPORTED");
#line 59 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp2_;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4572 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_CANCELLED:
#line 4576 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 61 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_STATUS_CANCELLED");
#line 61 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp3_;
#line 61 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4585 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_DEVICE_BUSY:
#line 4589 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 63 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_STATUS_DEVICE_BUSY");
#line 63 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp4_;
#line 63 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4598 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_INVAL:
#line 4602 "scanner.c"
		{
			gchar* _tmp5_ = NULL;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_STATUS_INVAL");
#line 65 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp5_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4611 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_EOF:
#line 4615 "scanner.c"
		{
			gchar* _tmp6_ = NULL;
#line 67 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp6_ = g_strdup ("SANE_STATUS_EOF");
#line 67 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp6_;
#line 67 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4624 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_JAMMED:
#line 4628 "scanner.c"
		{
			gchar* _tmp7_ = NULL;
#line 69 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp7_ = g_strdup ("SANE_STATUS_JAMMED");
#line 69 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp7_;
#line 69 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4637 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_NO_DOCS:
#line 4641 "scanner.c"
		{
			gchar* _tmp8_ = NULL;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp8_ = g_strdup ("SANE_STATUS_NO_DOCS");
#line 71 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp8_;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4650 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_COVER_OPEN:
#line 4654 "scanner.c"
		{
			gchar* _tmp9_ = NULL;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp9_ = g_strdup ("SANE_STATUS_COVER_OPEN");
#line 73 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp9_;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4663 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_IO_ERROR:
#line 4667 "scanner.c"
		{
			gchar* _tmp10_ = NULL;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp10_ = g_strdup ("SANE_STATUS_IO_ERROR");
#line 75 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp10_;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4676 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_NO_MEM:
#line 4680 "scanner.c"
		{
			gchar* _tmp11_ = NULL;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp11_ = g_strdup ("SANE_STATUS_NO_MEM");
#line 77 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp11_;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4689 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_ACCESS_DENIED:
#line 4693 "scanner.c"
		{
			gchar* _tmp12_ = NULL;
#line 79 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp12_ = g_strdup ("SANE_STATUS_ACCESS_DENIED");
#line 79 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp12_;
#line 79 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4702 "scanner.c"
		}
		default:
		{
			SANE_Status _tmp13_ = 0;
			gchar* _tmp14_ = NULL;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp13_ = status;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp14_ = g_strdup_printf ("SANE_STATUS(%d)", (gint) _tmp13_);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp14_;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4716 "scanner.c"
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1278 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1278 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1278 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 4731 "scanner.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4762 "scanner.c"
				goto __catch14_g_regex_error;
			}
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 4771 "scanner.c"
		}
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4787 "scanner.c"
				goto __catch14_g_regex_error;
			}
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 4798 "scanner.c"
		}
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 4812 "scanner.c"
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1283 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 4826 "scanner.c"
	}
	__finally14:
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return NULL;
#line 4837 "scanner.c"
	}
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scan_device_ref (self) : NULL;
#line 4845 "scanner.c"
}


static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = scanner_compare_devices ((ScanDevice*) a, (ScanDevice*) b);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4854 "scanner.c"
}


static void scanner_do_redetect (Scanner* self) {
	SANE_Device** device_list = NULL;
	gint device_list_length1 = 0;
	gint _device_list_size_ = 0;
	SANE_Status status = 0;
	SANE_Device** _tmp0_ = NULL;
	SANE_Status _tmp1_ = 0;
	SANE_Status _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SANE_Status _tmp5_ = 0;
	GList* devices = NULL;
	GList* _tmp56_ = NULL;
	GList* _tmp63_ = NULL;
	NotifyUpdateDevices* _tmp64_ = NULL;
	NotifyUpdateDevices* _tmp65_ = NULL;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	device_list = NULL;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	device_list_length1 = 0;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = sane_get_devices (&_tmp0_, FALSE);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	device_list = _tmp0_;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	device_list_length1 = -1;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp1_;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = status;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:338: sane_get_devices () -> %s", _tmp4_);
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = status;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 4906 "scanner.c"
		SANE_Status _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = status;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 341 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:341: Unable to get SANE devices: %s", _tmp7_);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->need_redetect = FALSE;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_IDLE;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 4921 "scanner.c"
	}
#line 347 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	devices = NULL;
#line 4925 "scanner.c"
	{
		gint i = 0;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		i = 0;
#line 4930 "scanner.c"
		{
			gboolean _tmp8_ = FALSE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp8_ = TRUE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			while (TRUE) {
#line 4937 "scanner.c"
				SANE_Device** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				SANE_Device* _tmp12_ = NULL;
				SANE_Device** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				SANE_Device* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				SANE_Device** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint _tmp18_ = 0;
				SANE_Device* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				SANE_Device** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				SANE_Device* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				SANE_Device** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				SANE_Device* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				ScanDevice* scan_device = NULL;
				ScanDevice* _tmp29_ = NULL;
				ScanDevice* _tmp30_ = NULL;
				SANE_Device** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				SANE_Device* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* vendor = NULL;
				SANE_Device** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gint _tmp37_ = 0;
				SANE_Device* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				ScanDevice* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				SANE_Device** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				gint _tmp46_ = 0;
				SANE_Device* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				ScanDevice* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_ = NULL;
				ScanDevice* _tmp54_ = NULL;
				ScanDevice* _tmp55_ = NULL;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp8_) {
#line 4995 "scanner.c"
					gint _tmp9_ = 0;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp9_ = i;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					i = _tmp9_ + 1;
#line 5001 "scanner.c"
				}
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp8_ = FALSE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp10_ = device_list;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp10__length1 = device_list_length1;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp11_ = i;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!(_tmp12_ != NULL)) {
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 5017 "scanner.c"
				}
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp13_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp13__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp14_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp15_ = _tmp13_[_tmp14_];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16_ = _tmp15_->name;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp17_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp17__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp18_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp19_ = _tmp17_[_tmp18_];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp20_ = _tmp19_->vendor;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp21_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp21__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp22_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp24_ = _tmp23_->model;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp25_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp25__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp26_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp27_ = _tmp25_[_tmp26_];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp28_ = _tmp27_->type;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				g_debug ("scanner.vala:350: Device: name=\"%s\" vendor=\"%s\" model=\"%s\" type=" \
"\"%s\"", _tmp16_, _tmp20_, _tmp24_, _tmp28_);
#line 353 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp29_ = scan_device_new ();
#line 353 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scan_device = _tmp29_;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp30_ = scan_device;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp31_ = device_list;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp31__length1 = device_list_length1;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp32_ = i;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp34_ = _tmp33_->name;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp35_ = g_strdup (_tmp34_);
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp30_->name);
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp30_->name = _tmp35_;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp36_ = device_list;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp36__length1 = device_list_length1;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp37_ = i;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp38_ = _tmp36_[_tmp37_];
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp39_ = _tmp38_->vendor;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp40_ = g_strdup (_tmp39_);
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				vendor = _tmp40_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp41_ = vendor;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (g_strcmp0 (_tmp41_, "Hewlett-Packard") == 0) {
#line 5101 "scanner.c"
					gchar* _tmp42_ = NULL;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp42_ = g_strdup ("HP");
#line 359 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_g_free0 (vendor);
#line 359 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					vendor = _tmp42_;
#line 5109 "scanner.c"
				}
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp43_ = scan_device;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp44_ = vendor;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp45_ = device_list;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp45__length1 = device_list_length1;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp46_ = i;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp47_ = _tmp45_[_tmp46_];
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp48_ = _tmp47_->model;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp49_ = g_strdup_printf ("%s %s", _tmp44_, _tmp48_);
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp43_->label);
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp43_->label = _tmp49_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp50_ = scan_device;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp51_ = _tmp50_->label;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp52_ = string_replace (_tmp51_, "_", " ");
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp53_ = _tmp52_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp53_);
#line 365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp54_ = scan_device;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp55_ = _scan_device_ref0 (_tmp54_);
#line 365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				devices = g_list_append (devices, _tmp55_);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (vendor);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_scan_device_unref0 (scan_device);
#line 5151 "scanner.c"
			}
		}
	}
#line 369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	devices = g_list_sort (devices, _scanner_compare_devices_gcompare_func);
#line 371 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->need_redetect = FALSE;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp56_ = devices;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp56_ != NULL) {
#line 5165 "scanner.c"
		ScanDevice* device = NULL;
		GList* _tmp57_ = NULL;
		gconstpointer _tmp58_ = NULL;
		ScanDevice* _tmp59_ = NULL;
		ScanDevice* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_ = devices;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp58_ = g_list_nth_data (_tmp57_, (guint) 0);
#line 376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp59_ = _scan_device_ref0 ((ScanDevice*) _tmp58_);
#line 376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		device = _tmp59_;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp60_ = device;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp61_ = _tmp60_->name;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp62_ = g_strdup (_tmp61_);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->default_device = _tmp62_;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_device_unref0 (device);
#line 5193 "scanner.c"
	} else {
#line 380 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 380 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->default_device = NULL;
#line 5199 "scanner.c"
	}
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp63_ = devices;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	devices = NULL;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp64_ = notify_update_devices_new (_tmp63_);
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp65_ = _tmp64_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp65_);
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp65_);
#line 334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (devices);
#line 5215 "scanner.c"
}


static gint scanner_scale_int (Scanner* self, gint source_min, gint source_max, SANE_Option_Descriptor* option, gint value) {
	gint result = 0;
	gint v = 0;
	gint _tmp0_ = 0;
	SANE_Option_Descriptor* _tmp1_ = NULL;
	SANE_Value_Type _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	SANE_Option_Descriptor* _tmp5_ = NULL;
	SANE_Constraint_Type _tmp6_ = 0;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0);
#line 387 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = value;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v = _tmp0_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = option;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = value;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (_tmp2_ == SANE_TYPE_INT, _tmp3_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = option;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = _tmp5_->constraint_type;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp6_ == SANE_CONSTRAINT_RANGE) {
#line 5251 "scanner.c"
		SANE_Option_Descriptor* _tmp7_ = NULL;
		SANE_Range* _tmp8_ = NULL;
		SANE_Word _tmp9_ = {0};
		SANE_Option_Descriptor* _tmp10_ = NULL;
		SANE_Range* _tmp11_ = NULL;
		SANE_Word _tmp12_ = {0};
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = option;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = _tmp7_->constraint.range;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = _tmp8_->max;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = option;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = _tmp10_->constraint.range;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = _tmp11_->min;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = _tmp9_ != _tmp12_;
#line 5272 "scanner.c"
	} else {
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = FALSE;
#line 5276 "scanner.c"
	}
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp4_) {
#line 5280 "scanner.c"
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		SANE_Option_Descriptor* _tmp16_ = NULL;
		SANE_Range* _tmp17_ = NULL;
		SANE_Word _tmp18_ = {0};
		SANE_Option_Descriptor* _tmp19_ = NULL;
		SANE_Range* _tmp20_ = NULL;
		SANE_Word _tmp21_ = {0};
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		SANE_Option_Descriptor* _tmp26_ = NULL;
		SANE_Range* _tmp27_ = NULL;
		SANE_Word _tmp28_ = {0};
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		SANE_Option_Descriptor* _tmp33_ = NULL;
		SANE_Range* _tmp34_ = NULL;
		SANE_Word _tmp35_ = {0};
		SANE_Option_Descriptor* _tmp36_ = NULL;
		SANE_Range* _tmp37_ = NULL;
		SANE_Word _tmp38_ = {0};
#line 393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = v;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = source_min;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		v = _tmp13_ - _tmp14_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = v;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = option;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp17_ = _tmp16_->constraint.range;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp18_ = _tmp17_->max;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp19_ = option;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp20_ = _tmp19_->constraint.range;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp21_ = _tmp20_->min;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		v = _tmp15_ * ((gint) (_tmp18_ - _tmp21_));
#line 395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp22_ = v;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp23_ = source_max;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp24_ = source_min;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		v = _tmp22_ / (_tmp23_ - _tmp24_);
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp25_ = v;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp26_ = option;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp27_ = _tmp26_->constraint.range;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp28_ = _tmp27_->min;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		v = _tmp25_ + ((gint) _tmp28_);
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp29_ = value;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp30_ = source_min;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp31_ = source_max;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp32_ = v;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp33_ = option;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp34_ = _tmp33_->constraint.range;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp35_ = _tmp34_->min;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp36_ = option;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp37_ = _tmp36_->constraint.range;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp38_ = _tmp37_->max;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:397: scale_int: scaling %d [min: %d, max: %d] to %d [min:" \
" %d, max: %d]", _tmp29_, _tmp30_, _tmp31_, _tmp32_, (gint) _tmp35_, (gint) _tmp38_);
#line 5369 "scanner.c"
	}
#line 401 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = v;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 5375 "scanner.c"
}


static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Int _tmp1_ = {0};
	SANE_Status status = 0;
	SANE_Handle _tmp2_ = {0};
	SANE_Int _tmp3_ = {0};
	SANE_Status _tmp4_ = 0;
	SANE_Int _tmp5_ = {0};
	SANE_Status _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	SANE_Status _tmp9_ = 0;
	SANE_Status _tmp14_ = 0;
#line 404 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 404 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 407 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->cap;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if ((_tmp1_ & SANE_CAP_AUTOMATIC) == ((SANE_Int) 0)) {
#line 408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = FALSE;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 5407 "scanner.c"
	}
#line 410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = handle;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option_index;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_AUTO, NULL, NULL);
#line 410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp4_;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = option_index;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = status;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:411: sane_control_option (%d, SANE_ACTION_SET_AUTO) -> %s", (gint) _tmp5_, _tmp8_);
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = status;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp9_ != SANE_STATUS_GOOD) {
#line 5433 "scanner.c"
		SANE_Option_Descriptor* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		SANE_Status _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = option;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = _tmp10_->name;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = status;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = sane_strstatus (_tmp12_);
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:413: Error setting default option %s: %s", _tmp11_, _tmp13_);
#line 5448 "scanner.c"
	}
#line 415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = status;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp14_ == SANE_STATUS_GOOD;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 5456 "scanner.c"
}


static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_) {
	gboolean _vala_result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Bool v = {0};
	gboolean _tmp2_ = FALSE;
	SANE_Status status = 0;
	SANE_Handle _tmp3_ = {0};
	SANE_Int _tmp4_ = {0};
	SANE_Status _tmp5_ = 0;
	SANE_Bool _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	SANE_Int _tmp11_ = {0};
	SANE_Status _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 420 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (_tmp1_ == SANE_TYPE_BOOL);
#line 422 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = value;
#line 422 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v = (SANE_Bool) _tmp2_;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = handle;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = option_index;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = sane_control_option (_tmp3_, _tmp4_, SANE_ACTION_SET_VALUE, &v, NULL);
#line 423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp5_;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = v;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = (gboolean) _tmp6_;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = value;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp8_) {
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = "SANE_TRUE";
#line 5511 "scanner.c"
	} else {
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = "SANE_FALSE";
#line 5515 "scanner.c"
	}
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = _vala_result;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp10_) {
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = "SANE_TRUE";
#line 5523 "scanner.c"
	} else {
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = "SANE_FALSE";
#line 5527 "scanner.c"
	}
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = option_index;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = status;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = sane_status_to_string (_tmp12_);
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = _tmp13_;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:425: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s) " \
"-> (%s, %s)", (gint) _tmp11_, _tmp7_, _tmp14_, _tmp9_);
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp14_);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 5545 "scanner.c"
	}
}


static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_) {
	gint _vala_result = 0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Int v = {0};
	gint _tmp2_ = 0;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Constraint_Type _tmp4_ = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp48_ = {0};
	SANE_Int _tmp49_ = {0};
	SANE_Status _tmp50_ = 0;
	SANE_Int _tmp51_ = {0};
	gint _tmp52_ = 0;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	SANE_Int _tmp55_ = {0};
	SANE_Int _tmp56_ = {0};
#line 428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (_tmp1_ == SANE_TYPE_INT);
#line 432 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = value;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v = (SANE_Int) _tmp2_;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->constraint_type;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
#line 5588 "scanner.c"
		SANE_Option_Descriptor* _tmp5_ = NULL;
		SANE_Range* _tmp6_ = NULL;
		SANE_Word _tmp7_ = {0};
		SANE_Int _tmp12_ = {0};
		SANE_Option_Descriptor* _tmp13_ = NULL;
		SANE_Range* _tmp14_ = NULL;
		SANE_Word _tmp15_ = {0};
		SANE_Int _tmp19_ = {0};
		SANE_Option_Descriptor* _tmp20_ = NULL;
		SANE_Range* _tmp21_ = NULL;
		SANE_Word _tmp22_ = {0};
#line 435 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = option;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->constraint.range;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = _tmp6_->quant;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp7_ != ((SANE_Word) 0)) {
#line 5608 "scanner.c"
			SANE_Int _tmp8_ = {0};
			SANE_Option_Descriptor* _tmp9_ = NULL;
			SANE_Range* _tmp10_ = NULL;
			SANE_Word _tmp11_ = {0};
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp8_ = v;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp9_ = option;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp10_ = _tmp9_->constraint.range;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp11_ = _tmp10_->quant;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = _tmp8_ * _tmp11_;
#line 5623 "scanner.c"
		}
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = v;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = option;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = _tmp13_->constraint.range;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = _tmp14_->min;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp12_ < ((SANE_Int) _tmp15_)) {
#line 5635 "scanner.c"
			SANE_Option_Descriptor* _tmp16_ = NULL;
			SANE_Range* _tmp17_ = NULL;
			SANE_Word _tmp18_ = {0};
#line 438 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp16_ = option;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp17_ = _tmp16_->constraint.range;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = _tmp17_->min;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = (SANE_Int) _tmp18_;
#line 5647 "scanner.c"
		}
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp19_ = v;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp20_ = option;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp21_ = _tmp20_->constraint.range;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp22_ = _tmp21_->max;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp19_ > ((SANE_Int) _tmp22_)) {
#line 5659 "scanner.c"
			SANE_Option_Descriptor* _tmp23_ = NULL;
			SANE_Range* _tmp24_ = NULL;
			SANE_Word _tmp25_ = {0};
#line 440 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = option;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp24_ = _tmp23_->constraint.range;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp25_ = _tmp24_->max;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = (SANE_Int) _tmp25_;
#line 5671 "scanner.c"
		}
	} else {
		SANE_Option_Descriptor* _tmp26_ = NULL;
		SANE_Constraint_Type _tmp27_ = 0;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp26_ = option;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp27_ = _tmp26_->constraint_type;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp27_ == SANE_CONSTRAINT_WORD_LIST) {
#line 5682 "scanner.c"
			gint distance = 0;
			gint _tmp28_ = 0;
			gint nearest = 0;
			gint _tmp47_ = 0;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp28_ = G_MAXINT;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			distance = _tmp28_;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			nearest = 0;
#line 5693 "scanner.c"
			{
				gint i = 0;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 5698 "scanner.c"
				{
					gboolean _tmp29_ = FALSE;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp29_ = TRUE;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 5705 "scanner.c"
						gint _tmp31_ = 0;
						SANE_Option_Descriptor* _tmp32_ = NULL;
						SANE_Word* _tmp33_ = NULL;
						gint _tmp33__length1 = 0;
						SANE_Word _tmp34_ = {0};
						gint x = 0;
						SANE_Option_Descriptor* _tmp35_ = NULL;
						SANE_Word* _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gint _tmp37_ = 0;
						SANE_Word _tmp38_ = {0};
						gint d = 0;
						gint _tmp39_ = 0;
						SANE_Int _tmp40_ = {0};
						gint _tmp41_ = 0;
						gint _tmp42_ = 0;
						gint _tmp43_ = 0;
						gint _tmp44_ = 0;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp29_) {
#line 5726 "scanner.c"
							gint _tmp30_ = 0;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp30_ = i;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp30_ + 1;
#line 5732 "scanner.c"
						}
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp29_ = FALSE;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp31_ = i;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp32_ = option;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp33_ = _tmp32_->constraint.word_list;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp33__length1 = -1;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp34_ = _tmp33_[0];
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(((SANE_Word) _tmp31_) < _tmp34_)) {
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 5750 "scanner.c"
						}
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp35_ = option;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp36_ = _tmp35_->constraint.word_list;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp36__length1 = -1;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp37_ = i;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp38_ = _tmp36_[_tmp37_ + 1];
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						x = (gint) _tmp38_;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp39_ = x;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp40_ = v;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						d = (gint) (_tmp39_ - _tmp40_);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp41_ = d;
#line 451 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp42_ = abs (_tmp41_);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						d = _tmp42_;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp43_ = d;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp44_ = distance;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp43_ < _tmp44_) {
#line 5782 "scanner.c"
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp45_ = d;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							distance = _tmp45_;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp46_ = x;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							nearest = _tmp46_;
#line 5793 "scanner.c"
						}
					}
				}
			}
#line 458 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp47_ = nearest;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = (SANE_Int) _tmp47_;
#line 5802 "scanner.c"
		}
	}
#line 461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp48_ = handle;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp49_ = option_index;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp50_ = sane_control_option (_tmp48_, _tmp49_, SANE_ACTION_SET_VALUE, &v, NULL);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp50_;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp51_ = option_index;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp52_ = value;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp53_ = sane_status_to_string (status);
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp54_ = _tmp53_;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp55_ = v;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:462: sane_control_option (%d, SANE_ACTION_SET_VALUE, %d) " \
"-> (%s, %d)", (gint) _tmp51_, _tmp52_, _tmp54_, (gint) _tmp55_);
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp54_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp56_ = v;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = (gint) _tmp56_;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 5835 "scanner.c"
	}
}


static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	SANE_Fixed v_fixed = {0};
	SANE_Option_Descriptor* _tmp1_ = NULL;
	SANE_Value_Type _tmp2_ = 0;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Constraint_Type _tmp4_ = 0;
	gdouble _tmp42_ = 0.0;
	SANE_Fixed _tmp43_ = {0};
	SANE_Status status = 0;
	SANE_Handle _tmp44_ = {0};
	SANE_Int _tmp45_ = {0};
	SANE_Status _tmp46_ = 0;
	SANE_Int _tmp47_ = {0};
	gdouble _tmp48_ = 0.0;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_ = 0.0;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 468 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = value;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v = _tmp0_;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = option;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (_tmp2_ == SANE_TYPE_FIXED);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->constraint_type;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
#line 5881 "scanner.c"
		gdouble min = 0.0;
		SANE_Option_Descriptor* _tmp5_ = NULL;
		SANE_Range* _tmp6_ = NULL;
		SANE_Word _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
		gdouble max = 0.0;
		SANE_Option_Descriptor* _tmp9_ = NULL;
		SANE_Range* _tmp10_ = NULL;
		SANE_Word _tmp11_ = {0};
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp16_ = 0.0;
		gdouble _tmp17_ = 0.0;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = option;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->constraint.range;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = _tmp6_->min;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = SANE_UNFIX ((SANE_Fixed) _tmp7_);
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		min = _tmp8_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = option;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = _tmp9_->constraint.range;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = _tmp10_->max;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = SANE_UNFIX ((SANE_Fixed) _tmp11_);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		max = _tmp12_;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = v;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = min;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp13_ < _tmp14_) {
#line 5922 "scanner.c"
			gdouble _tmp15_ = 0.0;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = min;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = _tmp15_;
#line 5928 "scanner.c"
		}
#line 480 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = v;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp17_ = max;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp16_ > _tmp17_) {
#line 5936 "scanner.c"
			gdouble _tmp18_ = 0.0;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = max;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = _tmp18_;
#line 5942 "scanner.c"
		}
	} else {
		SANE_Option_Descriptor* _tmp19_ = NULL;
		SANE_Constraint_Type _tmp20_ = 0;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp19_ = option;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp20_ = _tmp19_->constraint_type;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp20_ == SANE_CONSTRAINT_WORD_LIST) {
#line 5953 "scanner.c"
			gdouble distance = 0.0;
			gdouble _tmp21_ = 0.0;
			gdouble nearest = 0.0;
			gdouble _tmp41_ = 0.0;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp21_ = DBL_MAX;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			distance = _tmp21_;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			nearest = 0.0;
#line 5964 "scanner.c"
			{
				gint i = 0;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 5969 "scanner.c"
				{
					gboolean _tmp22_ = FALSE;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp22_ = TRUE;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 5976 "scanner.c"
						gint _tmp24_ = 0;
						SANE_Option_Descriptor* _tmp25_ = NULL;
						SANE_Word* _tmp26_ = NULL;
						gint _tmp26__length1 = 0;
						SANE_Word _tmp27_ = {0};
						gdouble x = 0.0;
						SANE_Option_Descriptor* _tmp28_ = NULL;
						SANE_Word* _tmp29_ = NULL;
						gint _tmp29__length1 = 0;
						gint _tmp30_ = 0;
						SANE_Word _tmp31_ = {0};
						gdouble _tmp32_ = 0.0;
						gdouble _tmp33_ = 0.0;
						gdouble _tmp34_ = 0.0;
						gdouble _tmp35_ = 0.0;
						gdouble _tmp36_ = 0.0;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp22_) {
#line 5995 "scanner.c"
							gint _tmp23_ = 0;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp23_ = i;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp23_ + 1;
#line 6001 "scanner.c"
						}
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp22_ = FALSE;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp24_ = i;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp25_ = option;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp26_ = _tmp25_->constraint.word_list;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp26__length1 = -1;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp27_ = _tmp26_[0];
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(((SANE_Word) _tmp24_) < _tmp27_)) {
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 6019 "scanner.c"
						}
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp28_ = option;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp29_ = _tmp28_->constraint.word_list;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp29__length1 = -1;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp30_ = i;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp31_ = _tmp29_[_tmp30_ + 1];
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp32_ = SANE_UNFIX ((SANE_Fixed) _tmp31_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						x = _tmp32_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp33_ = x;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp34_ = v;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp35_ = fabs (_tmp33_ - _tmp34_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp36_ = distance;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp35_ < _tmp36_) {
#line 6045 "scanner.c"
							gdouble _tmp37_ = 0.0;
							gdouble _tmp38_ = 0.0;
							gdouble _tmp39_ = 0.0;
							gdouble _tmp40_ = 0.0;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp37_ = x;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp38_ = v;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp39_ = fabs (_tmp37_ - _tmp38_);
#line 493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							distance = _tmp39_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp40_ = x;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							nearest = _tmp40_;
#line 6062 "scanner.c"
						}
					}
				}
			}
#line 497 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp41_ = nearest;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = _tmp41_;
#line 6071 "scanner.c"
		}
	}
#line 500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = v;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp43_ = SANE_FIX (_tmp42_);
#line 500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v_fixed = _tmp43_;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp44_ = handle;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp45_ = option_index;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp46_ = sane_control_option (_tmp44_, _tmp45_, SANE_ACTION_SET_VALUE, &v_fixed, NULL);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp46_;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp47_ = option_index;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp48_ = value;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp49_ = sane_status_to_string (status);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp50_ = _tmp49_;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp51_ = SANE_UNFIX (v_fixed);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:502: sane_control_option (%d, SANE_ACTION_SET_VALUE, %f) " \
"-> (%s, %f)", (gint) _tmp47_, _tmp48_, _tmp50_, _tmp51_);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp50_);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp52_ = SANE_UNFIX (v_fixed);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = _tmp52_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 6110 "scanner.c"
	}
}


static void scanner_set_fixed_or_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 509 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ == SANE_TYPE_FIXED) {
#line 6129 "scanner.c"
		SANE_Handle _tmp2_ = {0};
		SANE_Option_Descriptor* _tmp3_ = NULL;
		SANE_Int _tmp4_ = {0};
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = handle;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = option;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = option_index;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = value;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_set_fixed_option (self, _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_tmp6_);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_vala_result = _tmp6_;
#line 6147 "scanner.c"
	} else {
		SANE_Option_Descriptor* _tmp7_ = NULL;
		SANE_Value_Type _tmp8_ = 0;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = option;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = _tmp7_->type;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp8_ == SANE_TYPE_INT) {
#line 6157 "scanner.c"
			gint r = 0;
			SANE_Handle _tmp9_ = {0};
			SANE_Option_Descriptor* _tmp10_ = NULL;
			SANE_Int _tmp11_ = {0};
			gdouble _tmp12_ = 0.0;
			gdouble _tmp13_ = 0.0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp9_ = handle;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp10_ = option;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp11_ = option_index;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp12_ = value;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp13_ = round (_tmp12_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_set_int_option (self, _tmp9_, _tmp10_, _tmp11_, (gint) _tmp13_, &_tmp14_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			r = _tmp14_;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = r;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_vala_result = (gdouble) _tmp15_;
#line 6184 "scanner.c"
		} else {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_vala_result = 0.0;
#line 520 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:520: Unable to set unsupported option type");
#line 6190 "scanner.c"
		}
	}
#line 507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 6197 "scanner.c"
	}
}


static void scanner_set_option_to_max (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Constraint_Type _tmp1_ = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp2_ = {0};
	SANE_Int _tmp3_ = {0};
	SANE_Option_Descriptor* _tmp4_ = NULL;
	SANE_Range* _tmp5_ = NULL;
	SANE_Status _tmp6_ = 0;
	SANE_Int _tmp7_ = {0};
	SANE_Status _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 524 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->constraint_type;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ != SANE_CONSTRAINT_RANGE) {
#line 527 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 6227 "scanner.c"
	}
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = handle;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option_index;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = option;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _tmp4_->constraint.range;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_VALUE, &_tmp5_->max, NULL);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp6_;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = option_index;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = status;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = sane_status_to_string (_tmp8_);
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = _tmp9_;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:530: sane_control_option (%d, SANE_ACTION_SET_VALUE, opti" \
"on.range.max) -> (%s)", (gint) _tmp7_, _tmp10_);
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp10_);
#line 6253 "scanner.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 6271 "scanner.c"
}


static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	SANE_Option_Descriptor* _tmp1_ = NULL;
	SANE_Value_Type _tmp2_ = 0;
	gchar* s = NULL;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Int _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	gint s_length1 = 0;
	gint _s_size_ = 0;
	gint i = 0;
	gchar* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gchar _tmp23_ = '\0';
	SANE_Status status = 0;
	SANE_Handle _tmp24_ = {0};
	SANE_Int _tmp25_ = {0};
	gchar* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	SANE_Status _tmp27_ = 0;
	gchar* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	SANE_Int _tmp30_ = {0};
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (value != NULL, FALSE);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = g_strdup ("");
#line 535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_vala_result);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = _tmp0_;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = option;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (_tmp2_ == SANE_TYPE_STRING, FALSE);
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->size;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = g_new0 (gchar, _tmp4_);
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s = _tmp5_;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s_length1 = _tmp4_;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_s_size_ = s_length1;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	i = 0;
#line 6338 "scanner.c"
	{
		gboolean _tmp6_ = FALSE;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = TRUE;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		while (TRUE) {
#line 6345 "scanner.c"
			gboolean _tmp8_ = FALSE;
			gint _tmp9_ = 0;
			SANE_Option_Descriptor* _tmp10_ = NULL;
			SANE_Int _tmp11_ = {0};
			gchar* _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			gint _tmp16_ = 0;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gchar _tmp19_ = '\0';
			gchar _tmp20_ = '\0';
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (!_tmp6_) {
#line 6359 "scanner.c"
				gint _tmp7_ = 0;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp7_ = i;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = _tmp7_ + 1;
#line 6365 "scanner.c"
			}
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = FALSE;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp9_ = i;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp10_ = option;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp11_ = _tmp10_->size;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (((SANE_Int) _tmp9_) < (_tmp11_ - 1)) {
#line 6377 "scanner.c"
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp12_ = value;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp13_ = i;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp8_ = _tmp14_ != '\0';
#line 6389 "scanner.c"
			} else {
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp8_ = FALSE;
#line 6393 "scanner.c"
			}
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (!_tmp8_) {
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 6399 "scanner.c"
			}
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = s;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15__length1 = s_length1;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp16_ = i;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp17_ = value;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = i;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp19_ = string_get (_tmp17_, (glong) _tmp18_);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_[_tmp16_] = _tmp19_;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp20_ = _tmp15_[_tmp16_];
#line 6417 "scanner.c"
		}
	}
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_ = s;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21__length1 = s_length1;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp22_ = i;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_[_tmp22_] = '\0';
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp23_ = _tmp21_[_tmp22_];
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp24_ = handle;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_ = option_index;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26_ = s;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26__length1 = s_length1;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_ = sane_control_option (_tmp24_, _tmp25_, SANE_ACTION_SET_VALUE, _tmp26_, NULL);
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp27_;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28_ = s;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28__length1 = s_length1;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = g_strdup ((const gchar*) _tmp28_);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_vala_result);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = _tmp29_;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_ = option_index;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp31_ = value;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp32_ = sane_status_to_string (status);
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_ = _tmp32_;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp34_ = _vala_result;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:546: sane_control_option (%d, SANE_ACTION_SET_VALUE, \"%s" \
"\") -> (%s, \"%s\")", (gint) _tmp30_, _tmp31_, _tmp33_, _tmp34_);
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp33_);
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = status == SANE_STATUS_GOOD;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s = (g_free (s), NULL);
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 6474 "scanner.c"
	} else {
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6478 "scanner.c"
	}
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 6482 "scanner.c"
}


static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Option_Descriptor* _tmp2_ = NULL;
	SANE_Constraint_Type _tmp3_ = 0;
	gchar* _tmp34_ = NULL;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 551 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (_tmp1_ == SANE_TYPE_STRING, FALSE);
#line 554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = option;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->constraint_type;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (_tmp3_ == SANE_CONSTRAINT_STRING_LIST, FALSE);
#line 6510 "scanner.c"
	{
		gint i = 0;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		i = 0;
#line 6515 "scanner.c"
		{
			gboolean _tmp4_ = FALSE;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = TRUE;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			while (TRUE) {
#line 6522 "scanner.c"
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				gint j = 0;
				SANE_Option_Descriptor* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint _tmp24_ = 0;
				const gchar* _tmp25_ = NULL;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp4_) {
#line 6535 "scanner.c"
					gint _tmp5_ = 0;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp5_ = i;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					i = _tmp5_ + 1;
#line 6541 "scanner.c"
				}
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp4_ = FALSE;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp6_ = values;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp6__length1 = values_length1;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp7_ = i;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!(_tmp8_ != NULL)) {
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 6557 "scanner.c"
				}
#line 558 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				j = 0;
#line 6561 "scanner.c"
				{
					gboolean _tmp9_ = FALSE;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp9_ = TRUE;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 6568 "scanner.c"
						SANE_Option_Descriptor* _tmp11_ = NULL;
						gchar** _tmp12_ = NULL;
						gint _tmp12__length1 = 0;
						gint _tmp13_ = 0;
						const gchar* _tmp14_ = NULL;
						gchar** _tmp15_ = NULL;
						gint _tmp15__length1 = 0;
						gint _tmp16_ = 0;
						const gchar* _tmp17_ = NULL;
						SANE_Option_Descriptor* _tmp18_ = NULL;
						gchar** _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
						gint _tmp20_ = 0;
						const gchar* _tmp21_ = NULL;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp9_) {
#line 6585 "scanner.c"
							gint _tmp10_ = 0;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp10_ = j;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							j = _tmp10_ + 1;
#line 6591 "scanner.c"
						}
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp9_ = FALSE;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp11_ = option;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp12_ = _tmp11_->constraint.string_list;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp12__length1 = -1;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp13_ = j;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp14_ = _tmp12_[_tmp13_];
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(_tmp14_ != NULL)) {
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 6609 "scanner.c"
						}
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp15_ = values;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp15__length1 = values_length1;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp16_ = i;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp17_ = _tmp15_[_tmp16_];
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp18_ = option;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp19_ = _tmp18_->constraint.string_list;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp19__length1 = -1;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp20_ = j;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp21_ = _tmp19_[_tmp20_];
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (g_strcmp0 (_tmp17_, _tmp21_) == 0) {
#line 562 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 6633 "scanner.c"
						}
					}
				}
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp22_ = option;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp23_ = _tmp22_->constraint.string_list;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp23__length1 = -1;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp24_ = j;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp25_ = _tmp23_[_tmp24_];
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp25_ != NULL) {
#line 6649 "scanner.c"
					SANE_Handle _tmp26_ = {0};
					SANE_Option_Descriptor* _tmp27_ = NULL;
					SANE_Int _tmp28_ = {0};
					gchar** _tmp29_ = NULL;
					gint _tmp29__length1 = 0;
					gint _tmp30_ = 0;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp26_ = handle;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp27_ = option;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp28_ = option_index;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp29_ = values;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp29__length1 = values_length1;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp30_ = i;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp31_ = _tmp29_[_tmp30_];
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp33_ = scanner_set_string_option (self, _tmp26_, _tmp27_, _tmp28_, _tmp31_, &_tmp32_);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_g_free0 (_vala_result);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_vala_result = _tmp32_;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					result = _tmp33_;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (_result_) {
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						*_result_ = _vala_result;
#line 6685 "scanner.c"
					} else {
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_g_free0 (_vala_result);
#line 6689 "scanner.c"
					}
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					return result;
#line 6693 "scanner.c"
				}
			}
		}
	}
#line 569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp34_ = g_strdup ("");
#line 569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_vala_result);
#line 569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = _tmp34_;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = FALSE;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 6710 "scanner.c"
	} else {
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6714 "scanner.c"
	}
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 6718 "scanner.c"
}


static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option) {
	gchar* s = NULL;
	SANE_Int _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	SANE_Option_Descriptor* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	SANE_Option_Descriptor* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	SANE_Option_Descriptor* _tmp18_ = NULL;
	SANE_Value_Type _tmp19_ = 0;
	const gchar* _tmp38_ = NULL;
	SANE_Option_Descriptor* _tmp39_ = NULL;
	SANE_Int _tmp40_ = {0};
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	SANE_Option_Descriptor* _tmp44_ = NULL;
	SANE_Unit _tmp45_ = 0;
	SANE_Option_Descriptor* _tmp64_ = NULL;
	SANE_Constraint_Type _tmp65_ = 0;
	SANE_Int cap = {0};
	SANE_Option_Descriptor* _tmp149_ = NULL;
	SANE_Int _tmp150_ = {0};
	SANE_Int _tmp151_ = {0};
	const gchar* _tmp212_ = NULL;
	SANE_Option_Descriptor* _tmp213_ = NULL;
	const gchar* _tmp214_ = NULL;
#line 573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = index;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_strdup_printf ("Option %d:", (gint) _tmp0_);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s = _tmp1_;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = option;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->name;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_strcmp0 (_tmp3_, "") != 0) {
#line 6765 "scanner.c"
		const gchar* _tmp4_ = NULL;
		SANE_Option_Descriptor* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = s;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = option;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->name;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = g_strdup_printf (" name='%s'", _tmp6_);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = _tmp7_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (s);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		s = _tmp9_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_tmp8_);
#line 6790 "scanner.c"
	}
#line 580 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = option;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = _tmp10_->title;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_strcmp0 (_tmp11_, "") != 0) {
#line 6798 "scanner.c"
		const gchar* _tmp12_ = NULL;
		SANE_Option_Descriptor* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = s;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = option;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = _tmp13_->title;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = g_strdup_printf (" title='%s'", _tmp14_);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (s);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		s = _tmp17_;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_tmp16_);
#line 6823 "scanner.c"
	}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp18_ = option;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp19_ = _tmp18_->type;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp19_) {
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_BOOL:
#line 6833 "scanner.c"
		{
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp20_ = s;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp21_ = g_strconcat (_tmp20_, " type=bool", NULL);
#line 586 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 586 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp21_;
#line 587 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6847 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_INT:
#line 6851 "scanner.c"
		{
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp22_ = s;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = g_strconcat (_tmp22_, " type=int", NULL);
#line 589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp23_;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6865 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_FIXED:
#line 6869 "scanner.c"
		{
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp24_ = s;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp25_ = g_strconcat (_tmp24_, " type=fixed", NULL);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp25_;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6883 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_STRING:
#line 6887 "scanner.c"
		{
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp26_ = s;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp27_ = g_strconcat (_tmp26_, " type=string", NULL);
#line 595 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 595 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp27_;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6901 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_BUTTON:
#line 6905 "scanner.c"
		{
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp28_ = s;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_ = g_strconcat (_tmp28_, " type=button", NULL);
#line 598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp29_;
#line 599 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6919 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_GROUP:
#line 6923 "scanner.c"
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp30_ = s;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp31_ = g_strconcat (_tmp30_, " type=group", NULL);
#line 601 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 601 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp31_;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6937 "scanner.c"
		}
		default:
		{
			const gchar* _tmp32_ = NULL;
			SANE_Option_Descriptor* _tmp33_ = NULL;
			SANE_Value_Type _tmp34_ = 0;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp32_ = s;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp33_ = option;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp34_ = _tmp33_->type;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp35_ = g_strdup_printf (" type=%d", (gint) _tmp34_);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp36_ = _tmp35_;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_ = g_strconcat (_tmp32_, _tmp36_, NULL);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp37_;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (_tmp36_);
#line 605 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6967 "scanner.c"
		}
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp38_ = s;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp39_ = option;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp40_ = _tmp39_->size;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp41_ = g_strdup_printf (" size=%d", (gint) _tmp40_);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = _tmp41_;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp43_ = g_strconcat (_tmp38_, _tmp42_, NULL);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (s);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s = _tmp43_;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp42_);
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp44_ = option;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp45_ = _tmp44_->unit;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp45_) {
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_NONE:
#line 6996 "scanner.c"
		{
#line 613 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7000 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_PIXEL:
#line 7004 "scanner.c"
		{
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp46_ = s;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp47_ = g_strconcat (_tmp46_, " unit=pixels", NULL);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp47_;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7018 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_BIT:
#line 7022 "scanner.c"
		{
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp48_ = s;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp49_ = g_strconcat (_tmp48_, " unit=bits", NULL);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp49_;
#line 619 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7036 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_MM:
#line 7040 "scanner.c"
		{
			const gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp50_ = s;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp51_ = g_strconcat (_tmp50_, " unit=mm", NULL);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp51_;
#line 622 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7054 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_DPI:
#line 7058 "scanner.c"
		{
			const gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp52_ = s;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp53_ = g_strconcat (_tmp52_, " unit=dpi", NULL);
#line 624 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 624 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp53_;
#line 625 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7072 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_PERCENT:
#line 7076 "scanner.c"
		{
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_ = s;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp55_ = g_strconcat (_tmp54_, " unit=percent", NULL);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp55_;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7090 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_MICROSECOND:
#line 7094 "scanner.c"
		{
			const gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
#line 630 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp56_ = s;
#line 630 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp57_ = g_strconcat (_tmp56_, " unit=microseconds", NULL);
#line 630 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 630 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp57_;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7108 "scanner.c"
		}
		default:
		{
			const gchar* _tmp58_ = NULL;
			SANE_Option_Descriptor* _tmp59_ = NULL;
			SANE_Unit _tmp60_ = 0;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp58_ = s;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp59_ = option;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp60_ = _tmp59_->unit;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp61_ = g_strdup_printf (" unit=%d", (gint) _tmp60_);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp62_ = _tmp61_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp63_ = g_strconcat (_tmp58_, _tmp62_, NULL);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp63_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (_tmp62_);
#line 634 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7138 "scanner.c"
		}
	}
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp64_ = option;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp65_ = _tmp64_->constraint_type;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp65_) {
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_CONSTRAINT_RANGE:
#line 7149 "scanner.c"
		{
			SANE_Option_Descriptor* _tmp66_ = NULL;
			SANE_Value_Type _tmp67_ = 0;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp66_ = option;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp67_ = _tmp66_->type;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp67_ == SANE_TYPE_FIXED) {
#line 7159 "scanner.c"
				const gchar* _tmp68_ = NULL;
				SANE_Option_Descriptor* _tmp69_ = NULL;
				SANE_Range* _tmp70_ = NULL;
				SANE_Word _tmp71_ = {0};
				gdouble _tmp72_ = 0.0;
				SANE_Option_Descriptor* _tmp73_ = NULL;
				SANE_Range* _tmp74_ = NULL;
				SANE_Word _tmp75_ = {0};
				gdouble _tmp76_ = 0.0;
				SANE_Option_Descriptor* _tmp77_ = NULL;
				SANE_Range* _tmp78_ = NULL;
				SANE_Word _tmp79_ = {0};
				gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp68_ = s;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp69_ = option;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp70_ = _tmp69_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp71_ = _tmp70_->min;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp72_ = SANE_UNFIX ((SANE_Fixed) _tmp71_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp73_ = option;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp74_ = _tmp73_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp75_ = _tmp74_->max;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp76_ = SANE_UNFIX ((SANE_Fixed) _tmp75_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp77_ = option;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp78_ = _tmp77_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp79_ = _tmp78_->quant;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp80_ = g_strdup_printf (" min=%f, max=%f, quant=%d", _tmp72_, _tmp76_, (gint) _tmp79_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp81_ = _tmp80_;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp82_ = g_strconcat (_tmp68_, _tmp81_, NULL);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp82_;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp81_);
#line 7211 "scanner.c"
			} else {
				const gchar* _tmp83_ = NULL;
				SANE_Option_Descriptor* _tmp84_ = NULL;
				SANE_Range* _tmp85_ = NULL;
				SANE_Word _tmp86_ = {0};
				SANE_Option_Descriptor* _tmp87_ = NULL;
				SANE_Range* _tmp88_ = NULL;
				SANE_Word _tmp89_ = {0};
				SANE_Option_Descriptor* _tmp90_ = NULL;
				SANE_Range* _tmp91_ = NULL;
				SANE_Word _tmp92_ = {0};
				gchar* _tmp93_ = NULL;
				gchar* _tmp94_ = NULL;
				gchar* _tmp95_ = NULL;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp83_ = s;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp84_ = option;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp85_ = _tmp84_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp86_ = _tmp85_->min;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp87_ = option;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp88_ = _tmp87_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp89_ = _tmp88_->max;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp90_ = option;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp91_ = _tmp90_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp92_ = _tmp91_->quant;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp93_ = g_strdup_printf (" min=%d, max=%d, quant=%d", (gint) _tmp86_, (gint) _tmp89_, (gint) _tmp92_);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp94_ = _tmp93_;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp95_ = g_strconcat (_tmp83_, _tmp94_, NULL);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp95_;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp94_);
#line 7258 "scanner.c"
			}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7262 "scanner.c"
		}
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_CONSTRAINT_WORD_LIST:
#line 7266 "scanner.c"
		{
			const gchar* _tmp96_ = NULL;
			gchar* _tmp97_ = NULL;
			const gchar* _tmp126_ = NULL;
			gchar* _tmp127_ = NULL;
#line 646 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp96_ = s;
#line 646 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp97_ = g_strconcat (_tmp96_, " values=[", NULL);
#line 646 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 646 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp97_;
#line 7280 "scanner.c"
			{
				gint i = 0;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 7285 "scanner.c"
				{
					gboolean _tmp98_ = FALSE;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp98_ = TRUE;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 7292 "scanner.c"
						gint _tmp100_ = 0;
						SANE_Option_Descriptor* _tmp101_ = NULL;
						SANE_Word* _tmp102_ = NULL;
						gint _tmp102__length1 = 0;
						SANE_Word _tmp103_ = {0};
						gint _tmp104_ = 0;
						SANE_Option_Descriptor* _tmp107_ = NULL;
						SANE_Value_Type _tmp108_ = 0;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp98_) {
#line 7303 "scanner.c"
							gint _tmp99_ = 0;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp99_ = i;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp99_ + 1;
#line 7309 "scanner.c"
						}
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp98_ = FALSE;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp100_ = i;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp101_ = option;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp102_ = _tmp101_->constraint.word_list;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp102__length1 = -1;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp103_ = _tmp102_[0];
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(((SANE_Word) _tmp100_) < _tmp103_)) {
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 7327 "scanner.c"
						}
#line 649 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp104_ = i;
#line 649 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp104_ != 0) {
#line 7333 "scanner.c"
							const gchar* _tmp105_ = NULL;
							gchar* _tmp106_ = NULL;
#line 650 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp105_ = s;
#line 650 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp106_ = g_strconcat (_tmp105_, ", ", NULL);
#line 650 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (s);
#line 650 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							s = _tmp106_;
#line 7344 "scanner.c"
						}
#line 651 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp107_ = option;
#line 651 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp108_ = _tmp107_->type;
#line 651 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp108_ == SANE_TYPE_INT) {
#line 7352 "scanner.c"
							const gchar* _tmp109_ = NULL;
							SANE_Option_Descriptor* _tmp110_ = NULL;
							SANE_Word* _tmp111_ = NULL;
							gint _tmp111__length1 = 0;
							gint _tmp112_ = 0;
							SANE_Word _tmp113_ = {0};
							gchar* _tmp114_ = NULL;
							gchar* _tmp115_ = NULL;
							gchar* _tmp116_ = NULL;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp109_ = s;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp110_ = option;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp111_ = _tmp110_->constraint.word_list;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp111__length1 = -1;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp112_ = i;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp113_ = _tmp111_[_tmp112_ + 1];
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp114_ = g_strdup_printf ("%d", (gint) _tmp113_);
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp115_ = _tmp114_;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp116_ = g_strconcat (_tmp109_, _tmp115_, NULL);
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (s);
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							s = _tmp116_;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (_tmp115_);
#line 7386 "scanner.c"
						} else {
							const gchar* _tmp117_ = NULL;
							SANE_Option_Descriptor* _tmp118_ = NULL;
							SANE_Word* _tmp119_ = NULL;
							gint _tmp119__length1 = 0;
							gint _tmp120_ = 0;
							SANE_Word _tmp121_ = {0};
							gdouble _tmp122_ = 0.0;
							gchar* _tmp123_ = NULL;
							gchar* _tmp124_ = NULL;
							gchar* _tmp125_ = NULL;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp117_ = s;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp118_ = option;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp119_ = _tmp118_->constraint.word_list;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp119__length1 = -1;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp120_ = i;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp121_ = _tmp119_[_tmp120_ + 1];
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp122_ = SANE_UNFIX ((SANE_Fixed) _tmp121_);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp123_ = g_strdup_printf ("%f", _tmp122_);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp124_ = _tmp123_;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp125_ = g_strconcat (_tmp117_, _tmp124_, NULL);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (s);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							s = _tmp125_;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (_tmp124_);
#line 7424 "scanner.c"
						}
					}
				}
			}
#line 656 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp126_ = s;
#line 656 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp127_ = g_strconcat (_tmp126_, "]", NULL);
#line 656 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 656 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp127_;
#line 657 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7439 "scanner.c"
		}
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_CONSTRAINT_STRING_LIST:
#line 7443 "scanner.c"
		{
			const gchar* _tmp128_ = NULL;
			gchar* _tmp129_ = NULL;
			const gchar* _tmp147_ = NULL;
			gchar* _tmp148_ = NULL;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp128_ = s;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp129_ = g_strconcat (_tmp128_, " values=[", NULL);
#line 659 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 659 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp129_;
#line 7457 "scanner.c"
			{
				gint i = 0;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 7462 "scanner.c"
				{
					gboolean _tmp130_ = FALSE;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp130_ = TRUE;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 7469 "scanner.c"
						SANE_Option_Descriptor* _tmp132_ = NULL;
						gchar** _tmp133_ = NULL;
						gint _tmp133__length1 = 0;
						gint _tmp134_ = 0;
						const gchar* _tmp135_ = NULL;
						gint _tmp136_ = 0;
						const gchar* _tmp139_ = NULL;
						SANE_Option_Descriptor* _tmp140_ = NULL;
						gchar** _tmp141_ = NULL;
						gint _tmp141__length1 = 0;
						gint _tmp142_ = 0;
						const gchar* _tmp143_ = NULL;
						gchar* _tmp144_ = NULL;
						gchar* _tmp145_ = NULL;
						gchar* _tmp146_ = NULL;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp130_) {
#line 7487 "scanner.c"
							gint _tmp131_ = 0;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp131_ = i;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp131_ + 1;
#line 7493 "scanner.c"
						}
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp130_ = FALSE;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp132_ = option;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp133_ = _tmp132_->constraint.string_list;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp133__length1 = -1;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp134_ = i;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp135_ = _tmp133_[_tmp134_];
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(_tmp135_ != NULL)) {
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 7511 "scanner.c"
						}
#line 662 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp136_ = i;
#line 662 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp136_ != 0) {
#line 7517 "scanner.c"
							const gchar* _tmp137_ = NULL;
							gchar* _tmp138_ = NULL;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp137_ = s;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp138_ = g_strconcat (_tmp137_, ", ", NULL);
#line 663 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (s);
#line 663 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							s = _tmp138_;
#line 7528 "scanner.c"
						}
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp139_ = s;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp140_ = option;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp141_ = _tmp140_->constraint.string_list;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp141__length1 = -1;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp142_ = i;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp143_ = _tmp141_[_tmp142_];
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp144_ = g_strdup_printf ("\"%s\"", _tmp143_);
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp145_ = _tmp144_;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp146_ = g_strconcat (_tmp139_, _tmp145_, NULL);
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_g_free0 (s);
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						s = _tmp146_;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_g_free0 (_tmp145_);
#line 7554 "scanner.c"
					}
				}
			}
#line 666 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp147_ = s;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp148_ = g_strconcat (_tmp147_, "]", NULL);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp148_;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7568 "scanner.c"
		}
		default:
		{
#line 669 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7574 "scanner.c"
		}
	}
#line 672 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp149_ = option;
#line 672 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp150_ = _tmp149_->cap;
#line 672 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	cap = _tmp150_;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp151_ = cap;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp151_ != ((SANE_Int) 0)) {
#line 7587 "scanner.c"
		const gchar* _tmp152_ = NULL;
		gchar* _tmp153_ = NULL;
		SANE_Int _tmp154_ = {0};
		SANE_Int _tmp161_ = {0};
		SANE_Int _tmp168_ = {0};
		SANE_Int _tmp175_ = {0};
		SANE_Int _tmp182_ = {0};
		SANE_Int _tmp189_ = {0};
		SANE_Int _tmp196_ = {0};
		SANE_Int _tmp203_ = {0};
#line 675 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp152_ = s;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp153_ = g_strconcat (_tmp152_, " cap=", NULL);
#line 675 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (s);
#line 675 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		s = _tmp153_;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp154_ = cap;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp154_ & SANE_CAP_SOFT_SELECT) != ((SANE_Int) 0)) {
#line 7610 "scanner.c"
			const gchar* _tmp155_ = NULL;
			const gchar* _tmp158_ = NULL;
			gchar* _tmp159_ = NULL;
			SANE_Int _tmp160_ = {0};
#line 678 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp155_ = s;
#line 678 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp155_, "") != 0) {
#line 7619 "scanner.c"
				const gchar* _tmp156_ = NULL;
				gchar* _tmp157_ = NULL;
#line 679 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp156_ = s;
#line 679 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp157_ = g_strconcat (_tmp156_, ",", NULL);
#line 679 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 679 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp157_;
#line 7630 "scanner.c"
			}
#line 680 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp158_ = s;
#line 680 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp159_ = g_strconcat (_tmp158_, "soft-select", NULL);
#line 680 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 680 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp159_;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp160_ = cap;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp160_ & (~SANE_CAP_SOFT_SELECT);
#line 7644 "scanner.c"
		}
#line 683 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp161_ = cap;
#line 683 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp161_ & SANE_CAP_HARD_SELECT) != ((SANE_Int) 0)) {
#line 7650 "scanner.c"
			const gchar* _tmp162_ = NULL;
			const gchar* _tmp165_ = NULL;
			gchar* _tmp166_ = NULL;
			SANE_Int _tmp167_ = {0};
#line 685 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp162_ = s;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp162_, "") != 0) {
#line 7659 "scanner.c"
				const gchar* _tmp163_ = NULL;
				gchar* _tmp164_ = NULL;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp163_ = s;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp164_ = g_strconcat (_tmp163_, ",", NULL);
#line 686 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 686 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp164_;
#line 7670 "scanner.c"
			}
#line 687 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp165_ = s;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp166_ = g_strconcat (_tmp165_, "hard-select", NULL);
#line 687 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 687 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp166_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp167_ = cap;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp167_ & (~SANE_CAP_HARD_SELECT);
#line 7684 "scanner.c"
		}
#line 690 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp168_ = cap;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp168_ & SANE_CAP_SOFT_DETECT) != ((SANE_Int) 0)) {
#line 7690 "scanner.c"
			const gchar* _tmp169_ = NULL;
			const gchar* _tmp172_ = NULL;
			gchar* _tmp173_ = NULL;
			SANE_Int _tmp174_ = {0};
#line 692 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp169_ = s;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp169_, "") != 0) {
#line 7699 "scanner.c"
				const gchar* _tmp170_ = NULL;
				gchar* _tmp171_ = NULL;
#line 693 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp170_ = s;
#line 693 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp171_ = g_strconcat (_tmp170_, ",", NULL);
#line 693 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 693 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp171_;
#line 7710 "scanner.c"
			}
#line 694 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp172_ = s;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp173_ = g_strconcat (_tmp172_, "soft-detect", NULL);
#line 694 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 694 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp173_;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp174_ = cap;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp174_ & (~SANE_CAP_SOFT_DETECT);
#line 7724 "scanner.c"
		}
#line 697 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp175_ = cap;
#line 697 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp175_ & SANE_CAP_EMULATED) != ((SANE_Int) 0)) {
#line 7730 "scanner.c"
			const gchar* _tmp176_ = NULL;
			const gchar* _tmp179_ = NULL;
			gchar* _tmp180_ = NULL;
			SANE_Int _tmp181_ = {0};
#line 699 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp176_ = s;
#line 699 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp176_, "") != 0) {
#line 7739 "scanner.c"
				const gchar* _tmp177_ = NULL;
				gchar* _tmp178_ = NULL;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp177_ = s;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp178_ = g_strconcat (_tmp177_, ",", NULL);
#line 700 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 700 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp178_;
#line 7750 "scanner.c"
			}
#line 701 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp179_ = s;
#line 701 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp180_ = g_strconcat (_tmp179_, "emulated", NULL);
#line 701 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 701 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp180_;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp181_ = cap;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp181_ & (~SANE_CAP_EMULATED);
#line 7764 "scanner.c"
		}
#line 704 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp182_ = cap;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp182_ & SANE_CAP_AUTOMATIC) != ((SANE_Int) 0)) {
#line 7770 "scanner.c"
			const gchar* _tmp183_ = NULL;
			const gchar* _tmp186_ = NULL;
			gchar* _tmp187_ = NULL;
			SANE_Int _tmp188_ = {0};
#line 706 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp183_ = s;
#line 706 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp183_, "") != 0) {
#line 7779 "scanner.c"
				const gchar* _tmp184_ = NULL;
				gchar* _tmp185_ = NULL;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp184_ = s;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp185_ = g_strconcat (_tmp184_, ",", NULL);
#line 707 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 707 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp185_;
#line 7790 "scanner.c"
			}
#line 708 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp186_ = s;
#line 708 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp187_ = g_strconcat (_tmp186_, "automatic", NULL);
#line 708 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 708 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp187_;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp188_ = cap;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp188_ & (~SANE_CAP_AUTOMATIC);
#line 7804 "scanner.c"
		}
#line 711 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp189_ = cap;
#line 711 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp189_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 7810 "scanner.c"
			const gchar* _tmp190_ = NULL;
			const gchar* _tmp193_ = NULL;
			gchar* _tmp194_ = NULL;
			SANE_Int _tmp195_ = {0};
#line 713 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp190_ = s;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp190_, "") != 0) {
#line 7819 "scanner.c"
				const gchar* _tmp191_ = NULL;
				gchar* _tmp192_ = NULL;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp191_ = s;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp192_ = g_strconcat (_tmp191_, ",", NULL);
#line 714 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 714 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp192_;
#line 7830 "scanner.c"
			}
#line 715 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp193_ = s;
#line 715 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp194_ = g_strconcat (_tmp193_, "inactive", NULL);
#line 715 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 715 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp194_;
#line 716 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp195_ = cap;
#line 716 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp195_ & (~SANE_CAP_INACTIVE);
#line 7844 "scanner.c"
		}
#line 718 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp196_ = cap;
#line 718 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp196_ & SANE_CAP_ADVANCED) != ((SANE_Int) 0)) {
#line 7850 "scanner.c"
			const gchar* _tmp197_ = NULL;
			const gchar* _tmp200_ = NULL;
			gchar* _tmp201_ = NULL;
			SANE_Int _tmp202_ = {0};
#line 720 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp197_ = s;
#line 720 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp197_, "") != 0) {
#line 7859 "scanner.c"
				const gchar* _tmp198_ = NULL;
				gchar* _tmp199_ = NULL;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp198_ = s;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp199_ = g_strconcat (_tmp198_, ",", NULL);
#line 721 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 721 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp199_;
#line 7870 "scanner.c"
			}
#line 722 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp200_ = s;
#line 722 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp201_ = g_strconcat (_tmp200_, "advanced", NULL);
#line 722 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 722 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp201_;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp202_ = cap;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp202_ & (~SANE_CAP_ADVANCED);
#line 7884 "scanner.c"
		}
#line 726 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp203_ = cap;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp203_ != ((SANE_Int) 0)) {
#line 7890 "scanner.c"
			const gchar* _tmp204_ = NULL;
			const gchar* _tmp207_ = NULL;
			SANE_Int _tmp208_ = {0};
			gchar* _tmp209_ = NULL;
			gchar* _tmp210_ = NULL;
			gchar* _tmp211_ = NULL;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp204_ = s;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp204_, "") != 0) {
#line 7901 "scanner.c"
				const gchar* _tmp205_ = NULL;
				gchar* _tmp206_ = NULL;
#line 729 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp205_ = s;
#line 729 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp206_ = g_strconcat (_tmp205_, ",", NULL);
#line 729 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 729 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp206_;
#line 7912 "scanner.c"
			}
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp207_ = s;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp208_ = cap;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp209_ = g_strdup_printf ("%x", (guint) ((gint) _tmp208_));
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp210_ = _tmp209_;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp211_ = g_strconcat (_tmp207_, _tmp210_, NULL);
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp211_;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (_tmp210_);
#line 7930 "scanner.c"
		}
	}
#line 734 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp212_ = s;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:734: %s", _tmp212_);
#line 736 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp213_ = option;
#line 736 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp214_ = _tmp213_->desc;
#line 736 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp214_ != NULL) {
#line 7943 "scanner.c"
		SANE_Option_Descriptor* _tmp215_ = NULL;
		const gchar* _tmp216_ = NULL;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp215_ = option;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp216_ = _tmp215_->desc;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:737:   Description: %s", _tmp216_);
#line 7952 "scanner.c"
	}
#line 573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (s);
#line 7956 "scanner.c"
}


static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1) {
	Scanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	NotifyRequestAuthorization* _tmp2_ = NULL;
	NotifyRequestAuthorization* _tmp3_ = NULL;
	Credentials* credentials = NULL;
	Scanner* _tmp4_ = NULL;
	GAsyncQueue* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (resource != NULL);
#line 742 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 742 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = resource;
#line 742 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = notify_request_authorization_new (_tmp1_);
#line 742 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_;
#line 742 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (_tmp0_, (Notify*) _tmp3_);
#line 742 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp3_);
#line 744 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = scanner_scanner_object;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _tmp4_->priv->authorize_queue;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = g_async_queue_pop (_tmp5_);
#line 744 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials = (Credentials*) _tmp6_;
#line 7991 "scanner.c"
	{
		gint i = 0;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		i = 0;
#line 7996 "scanner.c"
		{
			gboolean _tmp7_ = FALSE;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp7_ = TRUE;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			while (TRUE) {
#line 8003 "scanner.c"
				gboolean _tmp9_ = FALSE;
				Credentials* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gchar _tmp13_ = '\0';
				gchar* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				Credentials* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gchar _tmp21_ = '\0';
				gchar _tmp22_ = '\0';
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp7_) {
#line 8019 "scanner.c"
					gint _tmp8_ = 0;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp8_ = i;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					i = _tmp8_ + 1;
#line 8025 "scanner.c"
				}
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp7_ = FALSE;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp10_ = credentials;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp11_ = _tmp10_->username;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp12_ = i;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp13_ != '\0') {
#line 8039 "scanner.c"
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp14_ = i;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp15_ = SANE_MAX_USERNAME_LEN;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp9_ = _tmp14_ < _tmp15_;
#line 8048 "scanner.c"
				} else {
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp9_ = FALSE;
#line 8052 "scanner.c"
				}
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp9_) {
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 8058 "scanner.c"
				}
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16_ = username;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16__length1 = username_length1;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp17_ = i;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp18_ = credentials;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp19_ = _tmp18_->username;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp20_ = i;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp21_ = string_get (_tmp19_, (glong) _tmp20_);
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16_[_tmp17_] = _tmp21_;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp22_ = _tmp16_[_tmp17_];
#line 8078 "scanner.c"
			}
		}
	}
	{
		gint i = 0;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		i = 0;
#line 8086 "scanner.c"
		{
			gboolean _tmp23_ = FALSE;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = TRUE;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			while (TRUE) {
#line 8093 "scanner.c"
				gboolean _tmp25_ = FALSE;
				Credentials* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gchar _tmp29_ = '\0';
				gchar* _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
				Credentials* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				gchar _tmp38_ = '\0';
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp23_) {
#line 8109 "scanner.c"
					gint _tmp24_ = 0;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp24_ = i;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					i = _tmp24_ + 1;
#line 8115 "scanner.c"
				}
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp23_ = FALSE;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp26_ = credentials;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp27_ = _tmp26_->password;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp28_ = i;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp29_ = string_get (_tmp27_, (glong) _tmp28_);
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp29_ != '\0') {
#line 8129 "scanner.c"
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp30_ = i;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp31_ = SANE_MAX_USERNAME_LEN;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp25_ = _tmp30_ < _tmp31_;
#line 8138 "scanner.c"
				} else {
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp25_ = FALSE;
#line 8142 "scanner.c"
				}
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp25_) {
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 8148 "scanner.c"
				}
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp32_ = password;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp32__length1 = password_length1;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp33_ = i;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp34_ = credentials;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp35_ = _tmp34_->password;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp36_ = i;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp32_[_tmp33_] = _tmp37_;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp38_ = _tmp32_[_tmp33_];
#line 8168 "scanner.c"
			}
		}
	}
#line 740 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8174 "scanner.c"
}


static gpointer _credentials_ref0 (gpointer self) {
#line 756 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? credentials_ref (self) : NULL;
#line 8181 "scanner.c"
}


void scanner_authorize (Scanner* self, const gchar* username, const gchar* password) {
	Credentials* credentials = NULL;
	Credentials* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GAsyncQueue* _tmp5_ = NULL;
	Credentials* _tmp6_ = NULL;
#line 751 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 751 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (username != NULL);
#line 751 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (password != NULL);
#line 753 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = credentials_new ();
#line 753 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials = _tmp0_;
#line 754 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = username;
#line 754 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 754 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (credentials->username);
#line 754 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials->username = _tmp2_;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = password;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 755 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (credentials->password);
#line 755 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials->password = _tmp4_;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = self->priv->authorize_queue;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = _credentials_ref0 (credentials);
#line 756 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp5_, _tmp6_);
#line 751 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8228 "scanner.c"
}


static void scanner_close_device (Scanner* self) {
	gboolean _tmp0_ = FALSE;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 761 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->have_handle;
#line 761 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 8240 "scanner.c"
		SANE_Handle _tmp1_ = {0};
		SANE_Handle _tmp2_ = {0};
#line 763 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = self->priv->handle;
#line 763 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		sane_cancel (_tmp1_);
#line 764 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:764: sane_cancel ()");
#line 766 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = self->priv->handle;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		sane_close (_tmp2_);
#line 767 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:767: sane_close ()");
#line 768 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 769 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_hash_table_unref0 (self->priv->options);
#line 769 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->options = NULL;
#line 8261 "scanner.c"
	}
#line 772 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 772 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = NULL;
#line 772 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer_length1 = 0;
#line 772 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
#line 773 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_queue = NULL;
#line 775 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 8277 "scanner.c"
}


static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string) {
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	NotifyScanFailed* _tmp2_ = NULL;
	NotifyScanFailed* _tmp3_ = NULL;
#line 778 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 778 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (error_string != NULL);
#line 780 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_close_device (self);
#line 781 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = error_code;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = error_string;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = notify_scan_failed_new (_tmp0_, _tmp1_);
#line 782 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp3_);
#line 782 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp3_);
#line 8306 "scanner.c"
}


static gpointer _request_ref0 (gpointer self) {
#line 807 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? request_ref (self) : NULL;
#line 8313 "scanner.c"
}


static gpointer _scan_job_ref0 (gpointer self) {
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scan_job_ref (self) : NULL;
#line 8320 "scanner.c"
}


static gboolean scanner_handle_requests (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ScanState _tmp1_ = 0;
	gint request_count = 0;
#line 785 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 788 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->state;
#line 788 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ == SCAN_STATE_IDLE) {
#line 8335 "scanner.c"
		gboolean _tmp2_ = FALSE;
#line 788 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = self->priv->need_redetect;
#line 788 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 8341 "scanner.c"
	} else {
#line 788 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = FALSE;
#line 8345 "scanner.c"
	}
#line 788 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 789 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_REDETECT;
#line 8351 "scanner.c"
	}
#line 792 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_count = 0;
#line 793 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	while (TRUE) {
#line 8357 "scanner.c"
		Request* request = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ScanState _tmp5_ = 0;
		gint _tmp11_ = 0;
		Request* _tmp12_ = NULL;
#line 796 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = self->priv->state;
#line 796 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp5_ == SCAN_STATE_IDLE) {
#line 8368 "scanner.c"
			gint _tmp6_ = 0;
#line 796 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = request_count;
#line 796 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = _tmp6_ == 0;
#line 8374 "scanner.c"
		} else {
#line 796 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = FALSE;
#line 8378 "scanner.c"
		}
#line 796 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp4_) {
#line 796 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp3_ = TRUE;
#line 8384 "scanner.c"
		} else {
			GAsyncQueue* _tmp7_ = NULL;
			gint _tmp8_ = 0;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp7_ = self->priv->request_queue;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp8_ = g_async_queue_length (_tmp7_);
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp3_ = _tmp8_ > 0;
#line 8394 "scanner.c"
		}
#line 796 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp3_) {
#line 8398 "scanner.c"
			GAsyncQueue* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp9_ = self->priv->request_queue;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp10_ = g_async_queue_pop (_tmp9_);
#line 798 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_request_unref0 (request);
#line 798 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			request = (Request*) _tmp10_;
#line 8409 "scanner.c"
		} else {
#line 800 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = TRUE;
#line 800 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_request_unref0 (request);
#line 800 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 8417 "scanner.c"
		}
#line 802 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:802: Processing request");
#line 803 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = request_count;
#line 803 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_count = _tmp11_ + 1;
#line 805 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = request;
#line 805 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_REQUEST_START_SCAN)) {
#line 8429 "scanner.c"
			RequestStartScan* r = NULL;
			Request* _tmp13_ = NULL;
			RequestStartScan* _tmp14_ = NULL;
			RequestStartScan* _tmp15_ = NULL;
			ScanJob* _tmp16_ = NULL;
			ScanJob* _tmp17_ = NULL;
#line 807 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp13_ = request;
#line 807 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp14_ = _request_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_REQUEST_START_SCAN, RequestStartScan));
#line 807 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			r = _tmp14_;
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = r;
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp16_ = _tmp15_->job;
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp17_ = _scan_job_ref0 (_tmp16_);
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			self->priv->job_queue = g_list_append (self->priv->job_queue, _tmp17_);
#line 805 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_request_unref0 (r);
#line 8452 "scanner.c"
		} else {
			Request* _tmp18_ = NULL;
#line 810 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = request;
#line 810 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, TYPE_REQUEST_CANCEL)) {
#line 812 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_fail_scan (self, (gint) SANE_STATUS_CANCELLED, "Scan cancelled - do not report this error");
#line 8461 "scanner.c"
			} else {
				Request* _tmp19_ = NULL;
#line 814 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp19_ = request;
#line 814 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, TYPE_REQUEST_QUIT)) {
#line 816 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					scanner_close_device (self);
#line 817 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					result = FALSE;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_request_unref0 (request);
#line 817 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					return result;
#line 8476 "scanner.c"
				}
			}
		}
#line 793 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_request_unref0 (request);
#line 8482 "scanner.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 861 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	var = (g_free (var), NULL);
#line 8490 "scanner.c"
}


static void scanner_do_open (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	ScanJob* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ScanJob* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp13_ = FALSE;
	GHashFunc _tmp18_ = NULL;
	GEqualFunc _tmp19_ = NULL;
	GHashTable* _tmp20_ = NULL;
	SANE_Status status = 0;
	ScanJob* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	SANE_Handle _tmp23_ = {0};
	SANE_Status _tmp24_ = 0;
	ScanJob* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	SANE_Status _tmp27_ = 0;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	SANE_Status _tmp30_ = 0;
	ScanJob* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
#line 822 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 824 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 824 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 824 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 824 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp2_;
#line 826 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->line_count = 0;
#line 827 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->pass_number = 0;
#line 828 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->page_number = 0;
#line 829 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->notified_page = -1;
#line 830 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->option_index = (SANE_Int) 0;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = job;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _tmp4_->device;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp5_ == NULL) {
#line 8548 "scanner.c"
		const gchar* _tmp6_ = NULL;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = self->priv->default_device;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 8554 "scanner.c"
	} else {
#line 832 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = FALSE;
#line 8558 "scanner.c"
	}
#line 832 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp3_) {
#line 8562 "scanner.c"
		ScanJob* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = job;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = self->priv->default_device;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_tmp7_->device);
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_->device = _tmp9_;
#line 8576 "scanner.c"
	}
#line 835 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = job;
#line 835 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = _tmp10_->device;
#line 835 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp11_ == NULL) {
#line 8584 "scanner.c"
		const gchar* _tmp12_ = NULL;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:837: No scan device available");
#line 838 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = _ ("No scanners available.  Please connect a scanner.");
#line 838 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_fail_scan (self, 0, _tmp12_);
#line 841 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 841 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 8596 "scanner.c"
	}
#line 845 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = self->priv->have_handle;
#line 845 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp13_) {
#line 8602 "scanner.c"
		const gchar* _tmp14_ = NULL;
		ScanJob* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		SANE_Handle _tmp17_ = {0};
#line 847 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = self->priv->current_device;
#line 847 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = job;
#line 847 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = _tmp15_->device;
#line 847 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (g_strcmp0 (_tmp14_, _tmp16_) == 0) {
#line 849 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			self->priv->state = SCAN_STATE_GET_OPTION;
#line 850 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_scan_job_unref0 (job);
#line 850 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return;
#line 8621 "scanner.c"
		}
#line 853 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp17_ = self->priv->handle;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		sane_close (_tmp17_);
#line 854 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:854: sane_close ()");
#line 855 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 8631 "scanner.c"
	}
#line 858 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 858 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->current_device = NULL;
#line 860 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->have_handle = FALSE;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp18_ = g_str_hash;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp19_ = g_str_equal;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, NULL);
#line 861 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 861 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->options = _tmp20_;
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_ = job;
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp22_ = _tmp21_->device;
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp24_ = sane_open (_tmp22_, &_tmp23_);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->handle = _tmp23_;
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp24_;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_ = job;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26_ = _tmp25_->device;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_ = status;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28_ = sane_status_to_string (_tmp27_);
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = _tmp28_;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:863: sane_open (\"%s\") -> %s", _tmp26_, _tmp29_);
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp29_);
#line 865 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_ = status;
#line 865 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp30_ != SANE_STATUS_GOOD) {
#line 8677 "scanner.c"
		SANE_Status _tmp31_ = 0;
		const gchar* _tmp32_ = NULL;
		SANE_Status _tmp33_ = 0;
		const gchar* _tmp34_ = NULL;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp31_ = status;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp32_ = sane_strstatus (_tmp31_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:867: Unable to get open device: %s", _tmp32_);
#line 868 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp33_ = status;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp34_ = _ ("Unable to connect to scanner");
#line 868 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp33_, _tmp34_);
#line 871 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 871 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 8698 "scanner.c"
	}
#line 873 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->have_handle = TRUE;
#line 875 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp35_ = job;
#line 875 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_ = _tmp35_->device;
#line 875 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp37_ = g_strdup (_tmp36_);
#line 875 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 875 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->current_device = _tmp37_;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_GET_OPTION;
#line 822 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 8716 "scanner.c"
}


static void scanner_do_get_option (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	SANE_Option_Descriptor* option = NULL;
	SANE_Handle _tmp3_ = {0};
	SANE_Int _tmp4_ = {0};
	SANE_Option_Descriptor* _tmp5_ = NULL;
	SANE_Int _tmp6_ = {0};
	SANE_Int index = {0};
	SANE_Int _tmp7_ = {0};
	SANE_Int _tmp8_ = {0};
	SANE_Option_Descriptor* _tmp9_ = NULL;
	SANE_Int _tmp353_ = {0};
	SANE_Option_Descriptor* _tmp354_ = NULL;
	SANE_Option_Descriptor* _tmp355_ = NULL;
	SANE_Value_Type _tmp356_ = 0;
	SANE_Option_Descriptor* _tmp357_ = NULL;
	SANE_Int _tmp358_ = {0};
	SANE_Option_Descriptor* _tmp359_ = NULL;
	const gchar* _tmp360_ = NULL;
	GHashTable* _tmp361_ = NULL;
	SANE_Option_Descriptor* _tmp362_ = NULL;
	const gchar* _tmp363_ = NULL;
	gchar* _tmp364_ = NULL;
	SANE_Int _tmp365_ = {0};
#line 879 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 881 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 881 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 881 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 881 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp2_;
#line 883 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = self->priv->handle;
#line 883 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = self->priv->option_index;
#line 883 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = sane_get_option_descriptor (_tmp3_, _tmp4_);
#line 883 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	option = _tmp5_;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = self->priv->option_index;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:884: sane_get_option_descriptor (%d)", (gint) _tmp6_);
#line 885 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = self->priv->option_index;
#line 885 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	index = _tmp7_;
#line 886 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = self->priv->option_index;
#line 886 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->option_index = _tmp8_ + 1;
#line 889 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = option;
#line 889 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp9_ == NULL) {
#line 8781 "scanner.c"
		SANE_Handle _tmp10_ = {0};
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		SANE_Option_Descriptor* _tmp13_ = NULL;
		SANE_Option_Descriptor* _tmp14_ = NULL;
		SANE_Option_Descriptor* _tmp18_ = NULL;
		SANE_Handle _tmp93_ = {0};
		const gchar* _tmp94_ = NULL;
		gint _tmp95_ = 0;
		SANE_Option_Descriptor* _tmp96_ = NULL;
		SANE_Option_Descriptor* _tmp97_ = NULL;
		SANE_Handle _tmp153_ = {0};
		gint _tmp154_ = 0;
		SANE_Option_Descriptor* _tmp155_ = NULL;
		SANE_Option_Descriptor* _tmp156_ = NULL;
		SANE_Handle _tmp164_ = {0};
		gint _tmp165_ = 0;
		SANE_Option_Descriptor* _tmp166_ = NULL;
		SANE_Option_Descriptor* _tmp167_ = NULL;
		SANE_Handle _tmp175_ = {0};
		gint _tmp176_ = 0;
		SANE_Option_Descriptor* _tmp177_ = NULL;
		SANE_Option_Descriptor* _tmp178_ = NULL;
		SANE_Handle _tmp191_ = {0};
		const gchar* _tmp192_ = NULL;
		gint _tmp193_ = 0;
		SANE_Option_Descriptor* _tmp194_ = NULL;
		SANE_Option_Descriptor* _tmp195_ = NULL;
		SANE_Handle _tmp215_ = {0};
		const gchar* _tmp216_ = NULL;
		gint _tmp217_ = 0;
		SANE_Option_Descriptor* _tmp218_ = NULL;
		SANE_Option_Descriptor* _tmp219_ = NULL;
		SANE_Handle _tmp234_ = {0};
		const gchar* _tmp235_ = NULL;
		gint _tmp236_ = 0;
		SANE_Option_Descriptor* _tmp237_ = NULL;
		SANE_Option_Descriptor* _tmp238_ = NULL;
		SANE_Handle _tmp253_ = {0};
		const gchar* _tmp254_ = NULL;
		gint _tmp255_ = 0;
		SANE_Option_Descriptor* _tmp256_ = NULL;
		gboolean _tmp257_ = FALSE;
		SANE_Option_Descriptor* _tmp258_ = NULL;
		SANE_Handle _tmp270_ = {0};
		const gchar* _tmp271_ = NULL;
		gint _tmp272_ = 0;
		SANE_Option_Descriptor* _tmp273_ = NULL;
		gboolean _tmp274_ = FALSE;
		SANE_Option_Descriptor* _tmp275_ = NULL;
		SANE_Handle _tmp287_ = {0};
		const gchar* _tmp288_ = NULL;
		gint _tmp289_ = 0;
		SANE_Option_Descriptor* _tmp290_ = NULL;
		SANE_Option_Descriptor* _tmp291_ = NULL;
		SANE_Handle _tmp302_ = {0};
		const gchar* _tmp303_ = NULL;
		gint _tmp304_ = 0;
		SANE_Option_Descriptor* _tmp305_ = NULL;
		SANE_Option_Descriptor* _tmp306_ = NULL;
		const gchar* _tmp317_ = NULL;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = self->priv->handle;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = SANE_NAME_SCAN_SOURCE;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = scanner_get_option_by_name (self, _tmp10_, _tmp11_, &_tmp12_);
#line 892 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp12_;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp13_;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = option;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp14_ == NULL) {
#line 8857 "scanner.c"
			SANE_Handle _tmp15_ = {0};
			gint _tmp16_ = 0;
			SANE_Option_Descriptor* _tmp17_ = NULL;
#line 895 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_debug ("scanner.vala:895: SCAN_SOURCE not available, trying alternative \"doc-" \
"source\"");
#line 896 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = self->priv->handle;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp17_ = scanner_get_option_by_name (self, _tmp15_, "doc-source", &_tmp16_);
#line 896 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp16_;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp17_;
#line 8871 "scanner.c"
		}
#line 898 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp18_ = option;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp18_ != NULL) {
#line 8877 "scanner.c"
			gchar** flatbed_sources = NULL;
			gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar** _tmp29_ = NULL;
			gint flatbed_sources_length1 = 0;
			gint _flatbed_sources_size_ = 0;
			gchar** adf_sources = NULL;
			gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar** _tmp37_ = NULL;
			gint adf_sources_length1 = 0;
			gint _adf_sources_size_ = 0;
			gchar** adf_front_sources = NULL;
			gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar** _tmp41_ = NULL;
			gint adf_front_sources_length1 = 0;
			gint _adf_front_sources_size_ = 0;
			gchar** adf_back_sources = NULL;
			gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar** _tmp45_ = NULL;
			gint adf_back_sources_length1 = 0;
			gint _adf_back_sources_size_ = 0;
			gchar** adf_duplex_sources = NULL;
			gchar* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gchar** _tmp51_ = NULL;
			gint adf_duplex_sources_length1 = 0;
			gint _adf_duplex_sources_size_ = 0;
			ScanJob* _tmp52_ = NULL;
			ScanType _tmp53_ = 0;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp19_ = g_strdup ("Auto");
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp20_ = SANE_I18N ("Auto");
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp21_ = g_strdup (_tmp20_);
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp22_ = g_strdup ("Flatbed");
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = SANE_I18N ("Flatbed");
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp24_ = g_strdup (_tmp23_);
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp25_ = g_strdup ("FlatBed");
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp26_ = g_strdup ("Normal");
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp27_ = SANE_I18N ("Normal");
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_ = g_new0 (gchar*, 7 + 1);
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[0] = _tmp19_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[1] = _tmp21_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[2] = _tmp22_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[3] = _tmp24_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[4] = _tmp25_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[5] = _tmp26_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[6] = _tmp28_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			flatbed_sources = _tmp29_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			flatbed_sources_length1 = 7;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_flatbed_sources_size_ = flatbed_sources_length1;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp30_ = g_strdup ("Automatic Document Feeder");
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp31_ = SANE_I18N ("Automatic Document Feeder");
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp32_ = g_strdup (_tmp31_);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp33_ = g_strdup ("ADF");
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp34_ = g_strdup ("Automatic Document Feeder(left aligned)");
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp35_ = g_strdup ("Automatic Document Feeder(centrally aligned)");
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp36_ = g_strdup ("ADF Simplex");
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_ = g_new0 (gchar*, 6 + 1);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[0] = _tmp30_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[1] = _tmp32_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[2] = _tmp33_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[3] = _tmp34_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[4] = _tmp35_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[5] = _tmp36_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_sources = _tmp37_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_sources_length1 = 6;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_adf_sources_size_ = adf_sources_length1;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp38_ = g_strdup ("ADF Front");
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp39_ = SANE_I18N ("ADF Front");
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp40_ = g_strdup (_tmp39_);
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp41_ = g_new0 (gchar*, 2 + 1);
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp41_[0] = _tmp38_;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp41_[1] = _tmp40_;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_front_sources = _tmp41_;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_front_sources_length1 = 2;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_adf_front_sources_size_ = adf_front_sources_length1;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp42_ = g_strdup ("ADF Back");
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp43_ = SANE_I18N ("ADF Back");
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp44_ = g_strdup (_tmp43_);
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp45_ = g_new0 (gchar*, 2 + 1);
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp45_[0] = _tmp42_;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp45_[1] = _tmp44_;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_back_sources = _tmp45_;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_back_sources_length1 = 2;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_adf_back_sources_size_ = adf_back_sources_length1;
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp46_ = g_strdup ("ADF Duplex");
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp47_ = SANE_I18N ("ADF Duplex");
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp48_ = g_strdup (_tmp47_);
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp49_ = g_strdup ("ADF Duplex - Long-Edge Binding");
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp50_ = g_strdup ("ADF Duplex - Short-Edge Binding");
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp51_ = g_new0 (gchar*, 4 + 1);
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp51_[0] = _tmp46_;
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp51_[1] = _tmp48_;
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp51_[2] = _tmp49_;
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp51_[3] = _tmp50_;
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_duplex_sources = _tmp51_;
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_duplex_sources_length1 = 4;
#line 933 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_adf_duplex_sources_size_ = adf_duplex_sources_length1;
#line 941 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp52_ = job;
#line 941 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp53_ = _tmp52_->type;
#line 941 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			switch (_tmp53_) {
#line 941 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_TYPE_SINGLE:
#line 9074 "scanner.c"
				{
					SANE_Handle _tmp54_ = {0};
					SANE_Option_Descriptor* _tmp55_ = NULL;
					SANE_Int _tmp56_ = {0};
					gboolean _tmp57_ = FALSE;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp54_ = self->priv->handle;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp55_ = option;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp56_ = index;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp57_ = scanner_set_default_option (self, _tmp54_, _tmp55_, _tmp56_);
#line 944 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp57_) {
#line 9090 "scanner.c"
						SANE_Handle _tmp58_ = {0};
						SANE_Option_Descriptor* _tmp59_ = NULL;
						SANE_Int _tmp60_ = {0};
						gchar** _tmp61_ = NULL;
						gint _tmp61__length1 = 0;
						gboolean _tmp62_ = FALSE;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp58_ = self->priv->handle;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp59_ = option;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp60_ = index;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp61_ = flatbed_sources;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp61__length1 = flatbed_sources_length1;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp62_ = scanner_set_constrained_string_option (self, _tmp58_, _tmp59_, _tmp60_, _tmp61_, _tmp61__length1, NULL);
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp62_) {
#line 946 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							g_warning ("scanner.vala:946: Unable to set single page source, please file a bug");
#line 9113 "scanner.c"
						}
					}
#line 947 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9118 "scanner.c"
				}
#line 941 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_TYPE_ADF_FRONT:
#line 9122 "scanner.c"
				{
					SANE_Handle _tmp63_ = {0};
					SANE_Option_Descriptor* _tmp64_ = NULL;
					SANE_Int _tmp65_ = {0};
					gchar** _tmp66_ = NULL;
					gint _tmp66__length1 = 0;
					gboolean _tmp67_ = FALSE;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp63_ = self->priv->handle;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp64_ = option;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp65_ = index;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp66_ = adf_front_sources;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp66__length1 = adf_front_sources_length1;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp67_ = scanner_set_constrained_string_option (self, _tmp63_, _tmp64_, _tmp65_, _tmp66_, _tmp66__length1, NULL);
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp67_) {
#line 9144 "scanner.c"
						SANE_Handle _tmp68_ = {0};
						SANE_Option_Descriptor* _tmp69_ = NULL;
						SANE_Int _tmp70_ = {0};
						gchar** _tmp71_ = NULL;
						gint _tmp71__length1 = 0;
						gboolean _tmp72_ = FALSE;
#line 950 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp68_ = self->priv->handle;
#line 950 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp69_ = option;
#line 950 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp70_ = index;
#line 950 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp71_ = adf_sources;
#line 950 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp71__length1 = adf_sources_length1;
#line 950 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp72_ = scanner_set_constrained_string_option (self, _tmp68_, _tmp69_, _tmp70_, _tmp71_, _tmp71__length1, NULL);
#line 950 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp72_) {
#line 951 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							g_warning ("scanner.vala:951: Unable to set front ADF source, please file a bug");
#line 9167 "scanner.c"
						}
					}
#line 952 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9172 "scanner.c"
				}
#line 941 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_TYPE_ADF_BACK:
#line 9176 "scanner.c"
				{
					SANE_Handle _tmp73_ = {0};
					SANE_Option_Descriptor* _tmp74_ = NULL;
					SANE_Int _tmp75_ = {0};
					gchar** _tmp76_ = NULL;
					gint _tmp76__length1 = 0;
					gboolean _tmp77_ = FALSE;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp73_ = self->priv->handle;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp74_ = option;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp75_ = index;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp76_ = adf_back_sources;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp76__length1 = adf_back_sources_length1;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp77_ = scanner_set_constrained_string_option (self, _tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp76__length1, NULL);
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp77_) {
#line 9198 "scanner.c"
						SANE_Handle _tmp78_ = {0};
						SANE_Option_Descriptor* _tmp79_ = NULL;
						SANE_Int _tmp80_ = {0};
						gchar** _tmp81_ = NULL;
						gint _tmp81__length1 = 0;
						gboolean _tmp82_ = FALSE;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp78_ = self->priv->handle;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp79_ = option;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp80_ = index;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp81_ = adf_sources;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp81__length1 = adf_sources_length1;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp82_ = scanner_set_constrained_string_option (self, _tmp78_, _tmp79_, _tmp80_, _tmp81_, _tmp81__length1, NULL);
#line 955 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp82_) {
#line 956 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							g_warning ("scanner.vala:956: Unable to set back ADF source, please file a bug");
#line 9221 "scanner.c"
						}
					}
#line 957 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9226 "scanner.c"
				}
#line 941 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_TYPE_ADF_BOTH:
#line 9230 "scanner.c"
				{
					SANE_Handle _tmp83_ = {0};
					SANE_Option_Descriptor* _tmp84_ = NULL;
					SANE_Int _tmp85_ = {0};
					gchar** _tmp86_ = NULL;
					gint _tmp86__length1 = 0;
					gboolean _tmp87_ = FALSE;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp83_ = self->priv->handle;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp84_ = option;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp85_ = index;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp86_ = adf_duplex_sources;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp86__length1 = adf_duplex_sources_length1;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp87_ = scanner_set_constrained_string_option (self, _tmp83_, _tmp84_, _tmp85_, _tmp86_, _tmp86__length1, NULL);
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp87_) {
#line 9252 "scanner.c"
						SANE_Handle _tmp88_ = {0};
						SANE_Option_Descriptor* _tmp89_ = NULL;
						SANE_Int _tmp90_ = {0};
						gchar** _tmp91_ = NULL;
						gint _tmp91__length1 = 0;
						gboolean _tmp92_ = FALSE;
#line 960 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp88_ = self->priv->handle;
#line 960 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp89_ = option;
#line 960 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp90_ = index;
#line 960 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp91_ = adf_sources;
#line 960 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp91__length1 = adf_sources_length1;
#line 960 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp92_ = scanner_set_constrained_string_option (self, _tmp88_, _tmp89_, _tmp90_, _tmp91_, _tmp91__length1, NULL);
#line 960 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp92_) {
#line 961 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							g_warning ("scanner.vala:961: Unable to set duplex ADF source, please file a bug");
#line 9275 "scanner.c"
						}
					}
#line 962 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9280 "scanner.c"
				}
				default:
#line 941 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 9285 "scanner.c"
			}
#line 898 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_duplex_sources = (_vala_array_free (adf_duplex_sources, adf_duplex_sources_length1, (GDestroyNotify) g_free), NULL);
#line 898 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_back_sources = (_vala_array_free (adf_back_sources, adf_back_sources_length1, (GDestroyNotify) g_free), NULL);
#line 898 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_front_sources = (_vala_array_free (adf_front_sources, adf_front_sources_length1, (GDestroyNotify) g_free), NULL);
#line 898 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_sources = (_vala_array_free (adf_sources, adf_sources_length1, (GDestroyNotify) g_free), NULL);
#line 898 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			flatbed_sources = (_vala_array_free (flatbed_sources, flatbed_sources_length1, (GDestroyNotify) g_free), NULL);
#line 9297 "scanner.c"
		}
#line 967 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp93_ = self->priv->handle;
#line 967 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp94_ = SANE_NAME_SCAN_MODE;
#line 967 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp96_ = scanner_get_option_by_name (self, _tmp93_, _tmp94_, &_tmp95_);
#line 967 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp95_;
#line 967 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp96_;
#line 968 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp97_ = option;
#line 968 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp97_ != NULL) {
#line 9313 "scanner.c"
			gchar** color_scan_modes = NULL;
			const gchar* _tmp98_ = NULL;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
			gchar* _tmp101_ = NULL;
			gchar* _tmp102_ = NULL;
			gchar** _tmp103_ = NULL;
			gint color_scan_modes_length1 = 0;
			gint _color_scan_modes_size_ = 0;
			gchar** gray_scan_modes = NULL;
			const gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
			gchar* _tmp106_ = NULL;
			gchar* _tmp107_ = NULL;
			const gchar* _tmp108_ = NULL;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_ = NULL;
			gchar* _tmp111_ = NULL;
			gchar** _tmp112_ = NULL;
			gint gray_scan_modes_length1 = 0;
			gint _gray_scan_modes_size_ = 0;
			gchar** lineart_scan_modes = NULL;
			const gchar* _tmp113_ = NULL;
			gchar* _tmp114_ = NULL;
			gchar* _tmp115_ = NULL;
			gchar* _tmp116_ = NULL;
			const gchar* _tmp117_ = NULL;
			gchar* _tmp118_ = NULL;
			gchar* _tmp119_ = NULL;
			const gchar* _tmp120_ = NULL;
			gchar* _tmp121_ = NULL;
			gchar* _tmp122_ = NULL;
			const gchar* _tmp123_ = NULL;
			gchar* _tmp124_ = NULL;
			gchar* _tmp125_ = NULL;
			const gchar* _tmp126_ = NULL;
			gchar* _tmp127_ = NULL;
			gchar* _tmp128_ = NULL;
			gchar* _tmp129_ = NULL;
			const gchar* _tmp130_ = NULL;
			gchar* _tmp131_ = NULL;
			gchar* _tmp132_ = NULL;
			gchar* _tmp133_ = NULL;
			gchar* _tmp134_ = NULL;
			gchar** _tmp135_ = NULL;
			gint lineart_scan_modes_length1 = 0;
			gint _lineart_scan_modes_size_ = 0;
			ScanJob* _tmp136_ = NULL;
			ScanMode _tmp137_ = 0;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp98_ = SANE_VALUE_SCAN_MODE_COLOR;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp99_ = g_strdup (_tmp98_);
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp100_ = g_strdup ("Color");
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp101_ = g_strdup ("24bit Color");
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp102_ = g_strdup ("Color - 16 Million Colors");
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp103_ = g_new0 (gchar*, 4 + 1);
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp103_[0] = _tmp99_;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp103_[1] = _tmp100_;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp103_[2] = _tmp101_;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp103_[3] = _tmp102_;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			color_scan_modes = _tmp103_;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			color_scan_modes_length1 = 4;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_color_scan_modes_size_ = color_scan_modes_length1;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp104_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp105_ = g_strdup (_tmp104_);
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp106_ = g_strdup ("Gray");
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp107_ = g_strdup ("Grayscale");
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp108_ = SANE_I18N ("Grayscale");
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp109_ = g_strdup (_tmp108_);
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp110_ = g_strdup ("True Gray");
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp111_ = g_strdup ("Grayscale - 256 Levels");
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp112_ = g_new0 (gchar*, 6 + 1);
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp112_[0] = _tmp105_;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp112_[1] = _tmp106_;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp112_[2] = _tmp107_;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp112_[3] = _tmp109_;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp112_[4] = _tmp110_;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp112_[5] = _tmp111_;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			gray_scan_modes = _tmp112_;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			gray_scan_modes_length1 = 6;
#line 978 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_gray_scan_modes_size_ = gray_scan_modes_length1;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp113_ = SANE_VALUE_SCAN_MODE_LINEART;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp114_ = g_strdup (_tmp113_);
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp115_ = g_strdup ("Lineart");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp116_ = g_strdup ("LineArt");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp117_ = SANE_I18N ("LineArt");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp118_ = g_strdup (_tmp117_);
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp119_ = g_strdup ("Black & White");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp120_ = SANE_I18N ("Black & White");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp121_ = g_strdup (_tmp120_);
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp122_ = g_strdup ("Binary");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp123_ = SANE_I18N ("Binary");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp124_ = g_strdup (_tmp123_);
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp125_ = g_strdup ("Thresholded");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp126_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp127_ = g_strdup (_tmp126_);
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp128_ = g_strdup ("Gray");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp129_ = g_strdup ("Grayscale");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp130_ = SANE_I18N ("Grayscale");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp131_ = g_strdup (_tmp130_);
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp132_ = g_strdup ("True Gray");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp133_ = g_strdup ("Black and White - Line Art");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp134_ = g_strdup ("Black and White - Halftone");
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_ = g_new0 (gchar*, 16 + 1);
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[0] = _tmp114_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[1] = _tmp115_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[2] = _tmp116_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[3] = _tmp118_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[4] = _tmp119_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[5] = _tmp121_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[6] = _tmp122_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[7] = _tmp124_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[8] = _tmp125_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[9] = _tmp127_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[10] = _tmp128_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[11] = _tmp129_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[12] = _tmp131_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[13] = _tmp132_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[14] = _tmp133_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_[15] = _tmp134_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			lineart_scan_modes = _tmp135_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			lineart_scan_modes_length1 = 16;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_lineart_scan_modes_size_ = lineart_scan_modes_length1;
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp136_ = job;
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp137_ = _tmp136_->scan_mode;
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			switch (_tmp137_) {
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_MODE_COLOR:
#line 9517 "scanner.c"
				{
					SANE_Handle _tmp138_ = {0};
					SANE_Option_Descriptor* _tmp139_ = NULL;
					SANE_Int _tmp140_ = {0};
					gchar** _tmp141_ = NULL;
					gint _tmp141__length1 = 0;
					gboolean _tmp142_ = FALSE;
#line 1010 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp138_ = self->priv->handle;
#line 1010 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp139_ = option;
#line 1010 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp140_ = index;
#line 1010 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp141_ = color_scan_modes;
#line 1010 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp141__length1 = color_scan_modes_length1;
#line 1010 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp142_ = scanner_set_constrained_string_option (self, _tmp138_, _tmp139_, _tmp140_, _tmp141_, _tmp141__length1, NULL);
#line 1010 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp142_) {
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						g_warning ("scanner.vala:1011: Unable to set Color mode, please file a bug");
#line 9541 "scanner.c"
					}
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9545 "scanner.c"
				}
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_MODE_GRAY:
#line 9549 "scanner.c"
				{
					SANE_Handle _tmp143_ = {0};
					SANE_Option_Descriptor* _tmp144_ = NULL;
					SANE_Int _tmp145_ = {0};
					gchar** _tmp146_ = NULL;
					gint _tmp146__length1 = 0;
					gboolean _tmp147_ = FALSE;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp143_ = self->priv->handle;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp144_ = option;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp145_ = index;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp146_ = gray_scan_modes;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp146__length1 = gray_scan_modes_length1;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp147_ = scanner_set_constrained_string_option (self, _tmp143_, _tmp144_, _tmp145_, _tmp146_, _tmp146__length1, NULL);
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp147_) {
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						g_warning ("scanner.vala:1015: Unable to set Gray mode, please file a bug");
#line 9573 "scanner.c"
					}
#line 1016 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9577 "scanner.c"
				}
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_MODE_LINEART:
#line 9581 "scanner.c"
				{
					SANE_Handle _tmp148_ = {0};
					SANE_Option_Descriptor* _tmp149_ = NULL;
					SANE_Int _tmp150_ = {0};
					gchar** _tmp151_ = NULL;
					gint _tmp151__length1 = 0;
					gboolean _tmp152_ = FALSE;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp148_ = self->priv->handle;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp149_ = option;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp150_ = index;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp151_ = lineart_scan_modes;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp151__length1 = lineart_scan_modes_length1;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp152_ = scanner_set_constrained_string_option (self, _tmp148_, _tmp149_, _tmp150_, _tmp151_, _tmp151__length1, NULL);
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp152_) {
#line 1019 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						g_warning ("scanner.vala:1019: Unable to set Lineart mode, please file a bug");
#line 9605 "scanner.c"
					}
#line 1020 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9609 "scanner.c"
				}
				default:
				{
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9615 "scanner.c"
				}
			}
#line 968 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			lineart_scan_modes = (_vala_array_free (lineart_scan_modes, lineart_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 968 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			gray_scan_modes = (_vala_array_free (gray_scan_modes, gray_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 968 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			color_scan_modes = (_vala_array_free (color_scan_modes, color_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 9624 "scanner.c"
		}
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp153_ = self->priv->handle;
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp155_ = scanner_get_option_by_name (self, _tmp153_, "duplex", &_tmp154_);
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp154_;
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp155_;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp156_ = option;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp156_ != NULL) {
#line 9638 "scanner.c"
			SANE_Option_Descriptor* _tmp157_ = NULL;
			SANE_Value_Type _tmp158_ = 0;
#line 1030 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp157_ = option;
#line 1030 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp158_ = _tmp157_->type;
#line 1030 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp158_ == SANE_TYPE_BOOL) {
#line 9647 "scanner.c"
				SANE_Handle _tmp159_ = {0};
				SANE_Option_Descriptor* _tmp160_ = NULL;
				SANE_Int _tmp161_ = {0};
				ScanJob* _tmp162_ = NULL;
				ScanType _tmp163_ = 0;
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp159_ = self->priv->handle;
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp160_ = option;
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp161_ = index;
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp162_ = job;
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp163_ = _tmp162_->type;
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp159_, _tmp160_, _tmp161_, _tmp163_ == SCAN_TYPE_ADF_BOTH, NULL);
#line 9665 "scanner.c"
			}
		}
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp164_ = self->priv->handle;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp166_ = scanner_get_option_by_name (self, _tmp164_, "batch-scan", &_tmp165_);
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp165_;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp166_;
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp167_ = option;
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp167_ != NULL) {
#line 9680 "scanner.c"
			SANE_Option_Descriptor* _tmp168_ = NULL;
			SANE_Value_Type _tmp169_ = 0;
#line 1038 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp168_ = option;
#line 1038 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp169_ = _tmp168_->type;
#line 1038 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp169_ == SANE_TYPE_BOOL) {
#line 9689 "scanner.c"
				SANE_Handle _tmp170_ = {0};
				SANE_Option_Descriptor* _tmp171_ = NULL;
				SANE_Int _tmp172_ = {0};
				ScanJob* _tmp173_ = NULL;
				ScanType _tmp174_ = 0;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp170_ = self->priv->handle;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp171_ = option;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp172_ = index;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp173_ = job;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp174_ = _tmp173_->type;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp170_, _tmp171_, _tmp172_, _tmp174_ != SCAN_TYPE_SINGLE, NULL);
#line 9707 "scanner.c"
			}
		}
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp175_ = self->priv->handle;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp177_ = scanner_get_option_by_name (self, _tmp175_, "compression", &_tmp176_);
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp176_;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp177_;
#line 1044 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp178_ = option;
#line 1044 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp178_ != NULL) {
#line 9722 "scanner.c"
			gchar** disable_compression_names = NULL;
			const gchar* _tmp179_ = NULL;
			gchar* _tmp180_ = NULL;
			const gchar* _tmp181_ = NULL;
			gchar* _tmp182_ = NULL;
			gchar* _tmp183_ = NULL;
			gchar* _tmp184_ = NULL;
			gchar** _tmp185_ = NULL;
			gint disable_compression_names_length1 = 0;
			gint _disable_compression_names_size_ = 0;
			SANE_Handle _tmp186_ = {0};
			SANE_Option_Descriptor* _tmp187_ = NULL;
			SANE_Int _tmp188_ = {0};
			gchar** _tmp189_ = NULL;
			gint _tmp189__length1 = 0;
			gboolean _tmp190_ = FALSE;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp179_ = SANE_I18N ("None");
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp180_ = g_strdup (_tmp179_);
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp181_ = SANE_I18N ("none");
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp182_ = g_strdup (_tmp181_);
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp183_ = g_strdup ("None");
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp184_ = g_strdup ("none");
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp185_ = g_new0 (gchar*, 4 + 1);
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp185_[0] = _tmp180_;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp185_[1] = _tmp182_;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp185_[2] = _tmp183_;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp185_[3] = _tmp184_;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			disable_compression_names = _tmp185_;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			disable_compression_names_length1 = 4;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_disable_compression_names_size_ = disable_compression_names_length1;
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp186_ = self->priv->handle;
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp187_ = option;
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp188_ = index;
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp189_ = disable_compression_names;
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp189__length1 = disable_compression_names_length1;
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp190_ = scanner_set_constrained_string_option (self, _tmp186_, _tmp187_, _tmp188_, _tmp189_, _tmp189__length1, NULL);
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (!_tmp190_) {
#line 1055 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				g_warning ("scanner.vala:1055: Unable to disable compression, please file a bug");
#line 9783 "scanner.c"
			}
#line 1044 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			disable_compression_names = (_vala_array_free (disable_compression_names, disable_compression_names_length1, (GDestroyNotify) g_free), NULL);
#line 9787 "scanner.c"
		}
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp191_ = self->priv->handle;
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp192_ = SANE_NAME_SCAN_RESOLUTION;
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp194_ = scanner_get_option_by_name (self, _tmp191_, _tmp192_, &_tmp193_);
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp193_;
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp194_;
#line 1060 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp195_ = option;
#line 1060 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp195_ != NULL) {
#line 9803 "scanner.c"
			SANE_Handle _tmp196_ = {0};
			SANE_Option_Descriptor* _tmp197_ = NULL;
			SANE_Int _tmp198_ = {0};
			ScanJob* _tmp199_ = NULL;
			gdouble _tmp200_ = 0.0;
			ScanJob* _tmp201_ = NULL;
			gdouble _tmp202_ = 0.0;
			SANE_Handle _tmp203_ = {0};
			const gchar* _tmp204_ = NULL;
			gint _tmp205_ = 0;
			SANE_Option_Descriptor* _tmp206_ = NULL;
			SANE_Option_Descriptor* _tmp207_ = NULL;
#line 1062 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp196_ = self->priv->handle;
#line 1062 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp197_ = option;
#line 1062 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp198_ = index;
#line 1062 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp199_ = job;
#line 1062 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp200_ = _tmp199_->dpi;
#line 1062 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp201_ = job;
#line 1062 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp196_, _tmp197_, _tmp198_, _tmp200_, &_tmp202_);
#line 1062 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp201_->dpi = _tmp202_;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp203_ = self->priv->handle;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp204_ = SANE_NAME_BIT_DEPTH;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp206_ = scanner_get_option_by_name (self, _tmp203_, _tmp204_, &_tmp205_);
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp205_;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp206_;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp207_ = option;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp207_ != NULL) {
#line 9846 "scanner.c"
				ScanJob* _tmp208_ = NULL;
				gint _tmp209_ = 0;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp208_ = job;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp209_ = _tmp208_->depth;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp209_ > 0) {
#line 9855 "scanner.c"
					SANE_Handle _tmp210_ = {0};
					SANE_Option_Descriptor* _tmp211_ = NULL;
					SANE_Int _tmp212_ = {0};
					ScanJob* _tmp213_ = NULL;
					gint _tmp214_ = 0;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp210_ = self->priv->handle;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp211_ = option;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp212_ = index;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp213_ = job;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp214_ = _tmp213_->depth;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					scanner_set_int_option (self, _tmp210_, _tmp211_, _tmp212_, _tmp214_, NULL);
#line 9873 "scanner.c"
				}
			}
		}
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp215_ = self->priv->handle;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp216_ = SANE_NAME_SCAN_BR_X;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp218_ = scanner_get_option_by_name (self, _tmp215_, _tmp216_, &_tmp217_);
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp217_;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp218_;
#line 1073 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp219_ = option;
#line 1073 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp219_ != NULL) {
#line 9891 "scanner.c"
			ScanJob* _tmp220_ = NULL;
			gint _tmp221_ = 0;
#line 1075 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp220_ = job;
#line 1075 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp221_ = _tmp220_->page_width;
#line 1075 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp221_ > 0) {
#line 9900 "scanner.c"
				SANE_Handle _tmp222_ = {0};
				SANE_Option_Descriptor* _tmp223_ = NULL;
				SANE_Int _tmp224_ = {0};
				SANE_Option_Descriptor* _tmp225_ = NULL;
				ScanJob* _tmp226_ = NULL;
				gint _tmp227_ = 0;
				ScanJob* _tmp228_ = NULL;
				gdouble _tmp229_ = 0.0;
				gdouble _tmp230_ = 0.0;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp222_ = self->priv->handle;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp223_ = option;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp224_ = index;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp225_ = option;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp226_ = job;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp227_ = _tmp226_->page_width;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp228_ = job;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp229_ = _tmp228_->dpi;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp230_ = scanner_convert_page_size (self, _tmp225_, (gdouble) _tmp227_, _tmp229_);
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp222_, _tmp223_, _tmp224_, _tmp230_, NULL);
#line 9930 "scanner.c"
			} else {
				SANE_Handle _tmp231_ = {0};
				SANE_Option_Descriptor* _tmp232_ = NULL;
				SANE_Int _tmp233_ = {0};
#line 1078 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp231_ = self->priv->handle;
#line 1078 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp232_ = option;
#line 1078 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp233_ = index;
#line 1078 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp231_, _tmp232_, _tmp233_);
#line 9943 "scanner.c"
			}
		}
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp234_ = self->priv->handle;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp235_ = SANE_NAME_SCAN_BR_Y;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp237_ = scanner_get_option_by_name (self, _tmp234_, _tmp235_, &_tmp236_);
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp236_;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp237_;
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp238_ = option;
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp238_ != NULL) {
#line 9960 "scanner.c"
			ScanJob* _tmp239_ = NULL;
			gint _tmp240_ = 0;
#line 1083 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp239_ = job;
#line 1083 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp240_ = _tmp239_->page_height;
#line 1083 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp240_ > 0) {
#line 9969 "scanner.c"
				SANE_Handle _tmp241_ = {0};
				SANE_Option_Descriptor* _tmp242_ = NULL;
				SANE_Int _tmp243_ = {0};
				SANE_Option_Descriptor* _tmp244_ = NULL;
				ScanJob* _tmp245_ = NULL;
				gint _tmp246_ = 0;
				ScanJob* _tmp247_ = NULL;
				gdouble _tmp248_ = 0.0;
				gdouble _tmp249_ = 0.0;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp241_ = self->priv->handle;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp242_ = option;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp243_ = index;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp244_ = option;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp245_ = job;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp246_ = _tmp245_->page_height;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp247_ = job;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp248_ = _tmp247_->dpi;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp249_ = scanner_convert_page_size (self, _tmp244_, (gdouble) _tmp246_, _tmp248_);
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp241_, _tmp242_, _tmp243_, _tmp249_, NULL);
#line 9999 "scanner.c"
			} else {
				SANE_Handle _tmp250_ = {0};
				SANE_Option_Descriptor* _tmp251_ = NULL;
				SANE_Int _tmp252_ = {0};
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp250_ = self->priv->handle;
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp251_ = option;
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp252_ = index;
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp250_, _tmp251_, _tmp252_);
#line 10012 "scanner.c"
			}
		}
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp253_ = self->priv->handle;
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp254_ = SANE_NAME_PAGE_WIDTH;
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp256_ = scanner_get_option_by_name (self, _tmp253_, _tmp254_, &_tmp255_);
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp255_;
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp256_;
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp258_ = option;
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp258_ != NULL) {
#line 10029 "scanner.c"
			ScanJob* _tmp259_ = NULL;
			gint _tmp260_ = 0;
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp259_ = job;
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp260_ = _tmp259_->page_width;
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp257_ = ((gdouble) _tmp260_) > 0.0;
#line 10038 "scanner.c"
		} else {
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp257_ = FALSE;
#line 10042 "scanner.c"
		}
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp257_) {
#line 10046 "scanner.c"
			SANE_Handle _tmp261_ = {0};
			SANE_Option_Descriptor* _tmp262_ = NULL;
			SANE_Int _tmp263_ = {0};
			SANE_Option_Descriptor* _tmp264_ = NULL;
			ScanJob* _tmp265_ = NULL;
			gint _tmp266_ = 0;
			ScanJob* _tmp267_ = NULL;
			gdouble _tmp268_ = 0.0;
			gdouble _tmp269_ = 0.0;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp261_ = self->priv->handle;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp262_ = option;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp263_ = index;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp264_ = option;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp265_ = job;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp266_ = _tmp265_->page_width;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp267_ = job;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp268_ = _tmp267_->dpi;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp269_ = scanner_convert_page_size (self, _tmp264_, (gdouble) _tmp266_, _tmp268_);
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp261_, _tmp262_, _tmp263_, _tmp269_, NULL);
#line 10076 "scanner.c"
		}
#line 1093 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp270_ = self->priv->handle;
#line 1093 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp271_ = SANE_NAME_PAGE_HEIGHT;
#line 1093 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp273_ = scanner_get_option_by_name (self, _tmp270_, _tmp271_, &_tmp272_);
#line 1093 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp272_;
#line 1093 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp273_;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp275_ = option;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp275_ != NULL) {
#line 10092 "scanner.c"
			ScanJob* _tmp276_ = NULL;
			gint _tmp277_ = 0;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp276_ = job;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp277_ = _tmp276_->page_height;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp274_ = ((gdouble) _tmp277_) > 0.0;
#line 10101 "scanner.c"
		} else {
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp274_ = FALSE;
#line 10105 "scanner.c"
		}
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp274_) {
#line 10109 "scanner.c"
			SANE_Handle _tmp278_ = {0};
			SANE_Option_Descriptor* _tmp279_ = NULL;
			SANE_Int _tmp280_ = {0};
			SANE_Option_Descriptor* _tmp281_ = NULL;
			ScanJob* _tmp282_ = NULL;
			gint _tmp283_ = 0;
			ScanJob* _tmp284_ = NULL;
			gdouble _tmp285_ = 0.0;
			gdouble _tmp286_ = 0.0;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp278_ = self->priv->handle;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp279_ = option;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp280_ = index;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp281_ = option;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp282_ = job;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp283_ = _tmp282_->page_height;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp284_ = job;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp285_ = _tmp284_->dpi;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp286_ = scanner_convert_page_size (self, _tmp281_, (gdouble) _tmp283_, _tmp285_);
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp278_, _tmp279_, _tmp280_, _tmp286_, NULL);
#line 10139 "scanner.c"
		}
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp287_ = self->priv->handle;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp288_ = SANE_NAME_BRIGHTNESS;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp290_ = scanner_get_option_by_name (self, _tmp287_, _tmp288_, &_tmp289_);
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp289_;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp290_;
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp291_ = option;
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp291_ != NULL) {
#line 10155 "scanner.c"
			ScanJob* _tmp292_ = NULL;
			gint _tmp293_ = 0;
#line 1100 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp292_ = job;
#line 1100 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp293_ = _tmp292_->brightness;
#line 1100 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp293_ != 0) {
#line 10164 "scanner.c"
				gint brightness = 0;
				SANE_Option_Descriptor* _tmp294_ = NULL;
				ScanJob* _tmp295_ = NULL;
				gint _tmp296_ = 0;
				gint _tmp297_ = 0;
				SANE_Handle _tmp298_ = {0};
				SANE_Option_Descriptor* _tmp299_ = NULL;
				SANE_Int _tmp300_ = {0};
				gint _tmp301_ = 0;
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp294_ = option;
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp295_ = job;
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp296_ = _tmp295_->brightness;
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp297_ = scanner_scale_int (self, -100, 100, _tmp294_, _tmp296_);
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				brightness = _tmp297_;
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp298_ = self->priv->handle;
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp299_ = option;
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp300_ = index;
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp301_ = brightness;
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_int_option (self, _tmp298_, _tmp299_, _tmp300_, _tmp301_, NULL);
#line 10194 "scanner.c"
			}
		}
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp302_ = self->priv->handle;
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp303_ = SANE_NAME_CONTRAST;
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp305_ = scanner_get_option_by_name (self, _tmp302_, _tmp303_, &_tmp304_);
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp304_;
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp305_;
#line 1107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp306_ = option;
#line 1107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp306_ != NULL) {
#line 10211 "scanner.c"
			ScanJob* _tmp307_ = NULL;
			gint _tmp308_ = 0;
#line 1109 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp307_ = job;
#line 1109 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp308_ = _tmp307_->contrast;
#line 1109 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp308_ != 0) {
#line 10220 "scanner.c"
				gint contrast = 0;
				SANE_Option_Descriptor* _tmp309_ = NULL;
				ScanJob* _tmp310_ = NULL;
				gint _tmp311_ = 0;
				gint _tmp312_ = 0;
				SANE_Handle _tmp313_ = {0};
				SANE_Option_Descriptor* _tmp314_ = NULL;
				SANE_Int _tmp315_ = {0};
				gint _tmp316_ = 0;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp309_ = option;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp310_ = job;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp311_ = _tmp310_->contrast;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp312_ = scanner_scale_int (self, -100, 100, _tmp309_, _tmp311_);
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				contrast = _tmp312_;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp313_ = self->priv->handle;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp314_ = option;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp315_ = index;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp316_ = contrast;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_int_option (self, _tmp313_, _tmp314_, _tmp315_, _tmp316_, NULL);
#line 10250 "scanner.c"
			}
		}
#line 1117 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp317_ = self->priv->current_device;
#line 1117 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (g_strcmp0 (_tmp317_, "test") == 0) {
#line 10257 "scanner.c"
			SANE_Handle _tmp318_ = {0};
			gint _tmp319_ = 0;
			SANE_Option_Descriptor* _tmp320_ = NULL;
			SANE_Option_Descriptor* _tmp321_ = NULL;
			SANE_Handle _tmp325_ = {0};
			gint _tmp326_ = 0;
			SANE_Option_Descriptor* _tmp327_ = NULL;
			SANE_Option_Descriptor* _tmp328_ = NULL;
			SANE_Handle _tmp332_ = {0};
			gint _tmp333_ = 0;
			SANE_Option_Descriptor* _tmp334_ = NULL;
			SANE_Option_Descriptor* _tmp335_ = NULL;
			SANE_Handle _tmp339_ = {0};
			gint _tmp340_ = 0;
			SANE_Option_Descriptor* _tmp341_ = NULL;
			SANE_Option_Descriptor* _tmp342_ = NULL;
			SANE_Handle _tmp346_ = {0};
			gint _tmp347_ = 0;
			SANE_Option_Descriptor* _tmp348_ = NULL;
			SANE_Option_Descriptor* _tmp349_ = NULL;
#line 1119 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp318_ = self->priv->handle;
#line 1119 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp320_ = scanner_get_option_by_name (self, _tmp318_, "hand-scanner", &_tmp319_);
#line 1119 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp319_;
#line 1119 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp320_;
#line 1120 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp321_ = option;
#line 1120 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp321_ != NULL) {
#line 10290 "scanner.c"
				SANE_Handle _tmp322_ = {0};
				SANE_Option_Descriptor* _tmp323_ = NULL;
				SANE_Int _tmp324_ = {0};
#line 1121 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp322_ = self->priv->handle;
#line 1121 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp323_ = option;
#line 1121 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp324_ = index;
#line 1121 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp322_, _tmp323_, _tmp324_, FALSE, NULL);
#line 10302 "scanner.c"
			}
#line 1122 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp325_ = self->priv->handle;
#line 1122 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp327_ = scanner_get_option_by_name (self, _tmp325_, "three-pass", &_tmp326_);
#line 1122 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp326_;
#line 1122 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp327_;
#line 1123 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp328_ = option;
#line 1123 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp328_ != NULL) {
#line 10316 "scanner.c"
				SANE_Handle _tmp329_ = {0};
				SANE_Option_Descriptor* _tmp330_ = NULL;
				SANE_Int _tmp331_ = {0};
#line 1124 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp329_ = self->priv->handle;
#line 1124 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp330_ = option;
#line 1124 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp331_ = index;
#line 1124 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp329_, _tmp330_, _tmp331_, FALSE, NULL);
#line 10328 "scanner.c"
			}
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp332_ = self->priv->handle;
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp334_ = scanner_get_option_by_name (self, _tmp332_, "test-picture", &_tmp333_);
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp333_;
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp334_;
#line 1126 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp335_ = option;
#line 1126 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp335_ != NULL) {
#line 10342 "scanner.c"
				SANE_Handle _tmp336_ = {0};
				SANE_Option_Descriptor* _tmp337_ = NULL;
				SANE_Int _tmp338_ = {0};
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp336_ = self->priv->handle;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp337_ = option;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp338_ = index;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_string_option (self, _tmp336_, _tmp337_, _tmp338_, "Color pattern", NULL);
#line 10354 "scanner.c"
			}
#line 1128 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp339_ = self->priv->handle;
#line 1128 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp341_ = scanner_get_option_by_name (self, _tmp339_, "read-delay", &_tmp340_);
#line 1128 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp340_;
#line 1128 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp341_;
#line 1129 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp342_ = option;
#line 1129 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp342_ != NULL) {
#line 10368 "scanner.c"
				SANE_Handle _tmp343_ = {0};
				SANE_Option_Descriptor* _tmp344_ = NULL;
				SANE_Int _tmp345_ = {0};
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp343_ = self->priv->handle;
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp344_ = option;
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp345_ = index;
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp343_, _tmp344_, _tmp345_, TRUE, NULL);
#line 10380 "scanner.c"
			}
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp346_ = self->priv->handle;
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp348_ = scanner_get_option_by_name (self, _tmp346_, "read-delay-duration", &_tmp347_);
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp347_;
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp348_;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp349_ = option;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp349_ != NULL) {
#line 10394 "scanner.c"
				SANE_Handle _tmp350_ = {0};
				SANE_Option_Descriptor* _tmp351_ = NULL;
				SANE_Int _tmp352_ = {0};
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp350_ = self->priv->handle;
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp351_ = option;
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp352_ = index;
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_int_option (self, _tmp350_, _tmp351_, _tmp352_, 200000, NULL);
#line 10406 "scanner.c"
			}
		}
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1137 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1137 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10415 "scanner.c"
	}
#line 1140 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp353_ = index;
#line 1140 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp354_ = option;
#line 1140 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_log_option (self, _tmp353_, _tmp354_);
#line 1143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp355_ = option;
#line 1143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp356_ = _tmp355_->type;
#line 1143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp356_ == SANE_TYPE_GROUP) {
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10433 "scanner.c"
	}
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp357_ = option;
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp358_ = _tmp357_->cap;
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if ((_tmp358_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10445 "scanner.c"
	}
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp359_ = option;
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp360_ = _tmp359_->name;
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp360_ == NULL) {
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10457 "scanner.c"
	}
#line 1154 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp361_ = self->priv->options;
#line 1154 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp362_ = option;
#line 1154 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp363_ = _tmp362_->name;
#line 1154 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp364_ = g_strdup (_tmp363_);
#line 1154 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp365_ = index;
#line 1154 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_hash_table_insert (_tmp361_, _tmp364_, (gpointer) ((gintptr) ((gint) _tmp365_)));
#line 879 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 10473 "scanner.c"
}


static gdouble scanner_convert_page_size (Scanner* self, SANE_Option_Descriptor* option, gdouble size, gdouble dpi) {
	gdouble result = 0.0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Unit _tmp1_ = 0;
#line 1157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 1157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0.0);
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->unit;
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ == SANE_UNIT_PIXEL) {
#line 10491 "scanner.c"
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
#line 1160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = dpi;
#line 1160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = size;
#line 1160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = (_tmp2_ * _tmp3_) / 254.0;
#line 1160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 10502 "scanner.c"
	} else {
		SANE_Option_Descriptor* _tmp4_ = NULL;
		SANE_Unit _tmp5_ = 0;
#line 1161 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = option;
#line 1161 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = _tmp4_->unit;
#line 1161 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp5_ == SANE_UNIT_MM) {
#line 10512 "scanner.c"
			gdouble _tmp6_ = 0.0;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = size;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp6_ / 10.0;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 10520 "scanner.c"
		} else {
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:1165: Unable to set unsupported unit type");
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = (gdouble) 0.0f;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 10528 "scanner.c"
		}
	}
}


static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self, SANE_Handle handle, const gchar* name, gint* index) {
	gint _vala_index = 0;
	SANE_Option_Descriptor* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gint _tmp3_ = 0;
	SANE_Handle _tmp4_ = {0};
	gint _tmp5_ = 0;
	SANE_Option_Descriptor* _tmp6_ = NULL;
#line 1170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1172 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->options;
#line 1172 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = name;
#line 1172 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 1172 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_index = (gint) ((gintptr) _tmp2_);
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _vala_index;
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp3_ == 0) {
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = NULL;
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (index) {
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			*index = _vala_index;
#line 10566 "scanner.c"
		}
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 10570 "scanner.c"
	}
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = handle;
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _vala_index;
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = sane_get_option_descriptor (_tmp4_, (SANE_Int) _tmp5_);
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp6_;
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (index) {
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*index = _vala_index;
#line 10584 "scanner.c"
	}
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 10588 "scanner.c"
}


static void scanner_do_complete_document (Scanner* self) {
	SANE_Handle _tmp0_ = {0};
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	NotifyDocumentDone* _tmp3_ = NULL;
	NotifyDocumentDone* _tmp4_ = NULL;
#line 1179 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1181 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1181 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	sane_cancel (_tmp0_);
#line 1182 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1182: sane_cancel ()");
#line 1184 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->job_queue;
#line 1184 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_queue = g_list_remove_link (self->priv->job_queue, _tmp1_);
#line 1186 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1189 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->job_queue;
#line 1189 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 1191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_OPEN;
#line 1192 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10620 "scanner.c"
	}
#line 1198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = notify_document_done_new ();
#line 1198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp4_);
#line 1198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp4_);
#line 1199 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 10632 "scanner.c"
}


static void scanner_do_start (Scanner* self) {
	SANE_Status status = 0;
	NotifyExpectPage* _tmp0_ = NULL;
	NotifyExpectPage* _tmp1_ = NULL;
	SANE_Handle _tmp2_ = {0};
	SANE_Status _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	SANE_Status _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	SANE_Status _tmp9_ = 0;
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1206 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = notify_expect_page_new ();
#line 1206 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_;
#line 1206 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp1_);
#line 1206 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp1_);
#line 1208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->handle;
#line 1208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = sane_start (_tmp2_);
#line 1208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp3_;
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = self->priv->page_number;
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = self->priv->pass_number;
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = status;
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1209: sane_start (page=%d, pass=%d) -> %s", _tmp4_, _tmp5_, _tmp8_);
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 1210 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = status;
#line 1210 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp9_ == SANE_STATUS_GOOD) {
#line 1211 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_GET_PARAMETERS;
#line 10684 "scanner.c"
	} else {
		SANE_Status _tmp10_ = 0;
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = status;
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp10_ == SANE_STATUS_NO_DOCS) {
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_do_complete_document (self);
#line 10693 "scanner.c"
		} else {
			SANE_Status _tmp11_ = 0;
			const gchar* _tmp12_ = NULL;
			SANE_Status _tmp13_ = 0;
			const gchar* _tmp14_ = NULL;
#line 1216 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp11_ = status;
#line 1216 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp12_ = sane_strstatus (_tmp11_);
#line 1216 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:1216: Unable to start device: %s", _tmp12_);
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp13_ = status;
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp14_ = _ ("Unable to start scan");
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_fail_scan (self, (gint) _tmp13_, _tmp14_);
#line 10711 "scanner.c"
		}
	}
}


static gchar* sane_frame_to_string (SANE_Frame frame) {
	gchar* result = NULL;
	SANE_Frame _tmp0_ = 0;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
	_tmp0_ = frame;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
	switch (_tmp0_) {
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_GRAY:
#line 10726 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_FRAME_GRAY");
#line 106 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp1_;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10735 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_RGB:
#line 10739 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_FRAME_RGB");
#line 108 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp2_;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10748 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_RED:
#line 10752 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_FRAME_RED");
#line 110 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp3_;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10761 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_GREEN:
#line 10765 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_FRAME_GREEN");
#line 112 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp4_;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10774 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_BLUE:
#line 10778 "scanner.c"
		{
			gchar* _tmp5_ = NULL;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_FRAME_BLUE");
#line 114 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp5_;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10787 "scanner.c"
		}
		default:
		{
			SANE_Frame _tmp6_ = 0;
			gchar* _tmp7_ = NULL;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp6_ = frame;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp7_ = g_strdup_printf ("SANE_FRAME(%d)", (gint) _tmp6_);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp7_;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10801 "scanner.c"
		}
	}
}


static void scanner_do_get_parameters (Scanner* self) {
	SANE_Status status = 0;
	SANE_Handle _tmp0_ = {0};
	SANE_Parameters _tmp1_ = {0};
	SANE_Status _tmp2_ = 0;
	SANE_Status _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	SANE_Status _tmp6_ = 0;
	ScanJob* job = NULL;
	GList* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	ScanJob* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	SANE_Parameters _tmp15_ = {0};
	gboolean _tmp16_ = FALSE;
	SANE_Parameters _tmp17_ = {0};
	SANE_Frame _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	SANE_Parameters _tmp21_ = {0};
	gint _tmp22_ = 0;
	SANE_Parameters _tmp23_ = {0};
	gint _tmp24_ = 0;
	SANE_Parameters _tmp25_ = {0};
	gint _tmp26_ = 0;
	SANE_Parameters _tmp27_ = {0};
	gint _tmp28_ = 0;
	ScanPageInfo* info = NULL;
	ScanPageInfo* _tmp29_ = NULL;
	ScanPageInfo* _tmp30_ = NULL;
	SANE_Parameters _tmp31_ = {0};
	gint _tmp32_ = 0;
	ScanPageInfo* _tmp33_ = NULL;
	SANE_Parameters _tmp34_ = {0};
	gint _tmp35_ = 0;
	ScanPageInfo* _tmp36_ = NULL;
	SANE_Parameters _tmp37_ = {0};
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	SANE_Parameters _tmp42_ = {0};
	gint _tmp43_ = 0;
	gint _tmp53_ = 0;
	SANE_Parameters _tmp54_ = {0};
	SANE_Frame _tmp55_ = 0;
	ScanPageInfo* _tmp56_ = NULL;
	ScanPageInfo* _tmp57_ = NULL;
	ScanJob* _tmp58_ = NULL;
	gdouble _tmp59_ = 0.0;
	ScanPageInfo* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gint buffer_size = 0;
	SANE_Parameters _tmp71_ = {0};
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	guchar* _tmp74_ = NULL;
#line 1223 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1225 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1225 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = sane_get_parameters (_tmp0_, &_tmp1_);
#line 1225 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->parameters = _tmp1_;
#line 1225 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp2_;
#line 1226 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = status;
#line 1226 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = sane_status_to_string (_tmp3_);
#line 1226 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _tmp4_;
#line 1226 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1226: sane_get_parameters () -> %s", _tmp5_);
#line 1226 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp5_);
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = status;
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp6_ != SANE_STATUS_GOOD) {
#line 10892 "scanner.c"
		SANE_Status _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		SANE_Status _tmp9_ = 0;
		const gchar* _tmp10_ = NULL;
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = status;
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = sane_strstatus (_tmp7_);
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:1229: Unable to get device parameters: %s", _tmp8_);
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = status;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = _ ("Error communicating with scanner");
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp9_, _tmp10_);
#line 1233 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10911 "scanner.c"
	}
#line 1236 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = self->priv->job_queue;
#line 1236 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = _tmp11_->data;
#line 1236 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp12_, TYPE_SCAN_JOB, ScanJob));
#line 1236 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp13_;
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp15_ = self->priv->parameters;
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp16_ = _tmp15_.last_frame;
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp16_) {
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = "SANE_TRUE";
#line 10929 "scanner.c"
	} else {
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = "SANE_FALSE";
#line 10933 "scanner.c"
	}
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp17_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp18_ = _tmp17_.format;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp19_ = sane_frame_to_string (_tmp18_);
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp20_ = _tmp19_;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp22_ = _tmp21_.bytes_per_line;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp23_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp24_ = _tmp23_.pixels_per_line;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26_ = _tmp25_.lines;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28_ = _tmp27_.depth;
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1238: Parameters: format=%s last_frame=%s bytes_per_line=" \
"%d pixels_per_line=%d lines=%d depth=%d", _tmp20_, _tmp14_, _tmp22_, _tmp24_, _tmp26_, _tmp28_);
#line 1238 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp20_);
#line 1246 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = scan_page_info_new ();
#line 1246 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	info = _tmp29_;
#line 1247 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_ = info;
#line 1247 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp31_ = self->priv->parameters;
#line 1247 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp32_ = _tmp31_.pixels_per_line;
#line 1247 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_->width = _tmp32_;
#line 1248 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_ = info;
#line 1248 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp34_ = self->priv->parameters;
#line 1248 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp35_ = _tmp34_.lines;
#line 1248 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_->height = _tmp35_;
#line 1249 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_ = info;
#line 1249 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp37_ = self->priv->parameters;
#line 1249 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp38_ = _tmp37_.depth;
#line 1249 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_->depth = _tmp38_;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = self->priv->parameters;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp43_ = _tmp42_.depth;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp43_ == 8) {
#line 10997 "scanner.c"
		SANE_Parameters _tmp44_ = {0};
		SANE_Frame _tmp45_ = 0;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp44_ = self->priv->parameters;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp45_ = _tmp44_.format;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp41_ = _tmp45_ == SANE_FRAME_GRAY;
#line 11006 "scanner.c"
	} else {
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp41_ = FALSE;
#line 11010 "scanner.c"
	}
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp41_) {
#line 11014 "scanner.c"
		ScanJob* _tmp46_ = NULL;
		gint _tmp47_ = 0;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp46_ = job;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp47_ = _tmp46_->depth;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp40_ = _tmp47_ == 2;
#line 11023 "scanner.c"
	} else {
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp40_ = FALSE;
#line 11027 "scanner.c"
	}
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp40_) {
#line 11031 "scanner.c"
		ScanJob* _tmp48_ = NULL;
		ScanMode _tmp49_ = 0;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp48_ = job;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp49_ = _tmp48_->scan_mode;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp39_ = _tmp49_ == SCAN_MODE_GRAY;
#line 11040 "scanner.c"
	} else {
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp39_ = FALSE;
#line 11044 "scanner.c"
	}
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp39_) {
#line 11048 "scanner.c"
		ScanPageInfo* _tmp50_ = NULL;
		ScanJob* _tmp51_ = NULL;
		gint _tmp52_ = 0;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp50_ = info;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp51_ = job;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp52_ = _tmp51_->depth;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp50_->depth = _tmp52_;
#line 11060 "scanner.c"
	}
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp54_ = self->priv->parameters;
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp55_ = _tmp54_.format;
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp55_ == SANE_FRAME_GRAY) {
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp53_ = 1;
#line 11070 "scanner.c"
	} else {
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp53_ = 3;
#line 11074 "scanner.c"
	}
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp56_ = info;
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp56_->n_channels = _tmp53_;
#line 1255 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp57_ = info;
#line 1255 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp58_ = job;
#line 1255 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp59_ = _tmp58_->dpi;
#line 1255 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp57_->dpi = _tmp59_;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp60_ = info;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp61_ = self->priv->current_device;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp62_ = g_strdup (_tmp61_);
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp60_->device);
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp60_->device = _tmp62_;
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp63_ = self->priv->page_number;
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp64_ = self->priv->notified_page;
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp63_ != _tmp64_) {
#line 11104 "scanner.c"
		ScanJob* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		ScanPageInfo* _tmp67_ = NULL;
		NotifyGotPageInfo* _tmp68_ = NULL;
		NotifyGotPageInfo* _tmp69_ = NULL;
		gint _tmp70_ = 0;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp65_ = job;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp66_ = _tmp65_->id;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp67_ = info;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp68_ = notify_got_page_info_new (_tmp66_, _tmp67_);
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp69_ = _tmp68_;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp69_);
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_notify_unref0 (_tmp69_);
#line 1261 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp70_ = self->priv->page_number;
#line 1261 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->notified_page = _tmp70_;
#line 11129 "scanner.c"
	}
#line 1265 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp71_ = self->priv->parameters;
#line 1265 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp72_ = _tmp71_.bytes_per_line;
#line 1265 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	buffer_size = _tmp72_ + 1;
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp73_ = buffer_size;
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp74_ = g_new0 (guchar, _tmp73_);
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = _tmp74_;
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer_length1 = _tmp73_;
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1267 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->n_used = 0;
#line 1268 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->line_count = 0;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->pass_number = 0;
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_READ;
#line 1223 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_page_info_unref0 (info);
#line 1223 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11161 "scanner.c"
}


static void scanner_do_complete_page (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	ScanJob* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	NotifyPageDone* _tmp5_ = NULL;
	NotifyPageDone* _tmp6_ = NULL;
	SANE_Parameters _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	ScanJob* _tmp10_ = NULL;
	ScanType _tmp11_ = 0;
#line 1273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp2_;
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = job;
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->id;
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = notify_page_done_new (_tmp4_);
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = _tmp5_;
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp6_);
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp6_);
#line 1280 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = self->priv->parameters;
#line 1280 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = _tmp7_.last_frame;
#line 1280 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!_tmp8_) {
#line 11206 "scanner.c"
		gint _tmp9_ = 0;
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = self->priv->pass_number;
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->pass_number = _tmp9_ + 1;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 11218 "scanner.c"
	}
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = job;
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = _tmp10_->type;
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp11_ != SCAN_TYPE_SINGLE) {
#line 11226 "scanner.c"
		gint _tmp12_ = 0;
		ScanJob* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		NotifyPageDone* _tmp15_ = NULL;
		NotifyPageDone* _tmp16_ = NULL;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = self->priv->page_number;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->page_number = _tmp12_ + 1;
#line 1291 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->pass_number = 0;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = job;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = _tmp13_->id;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = notify_page_done_new (_tmp14_);
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp16_);
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_notify_unref0 (_tmp16_);
#line 1293 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 11256 "scanner.c"
	}
#line 1297 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_do_complete_document (self);
#line 1273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11262 "scanner.c"
}


static void scanner_do_read (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	gint n_to_read = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	SANE_Int n_read = {0};
	guchar* b = NULL;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp6_ = {0};
	guchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	SANE_Int _tmp10_ = {0};
	SANE_Status _tmp11_ = 0;
	gint _tmp12_ = 0;
	SANE_Status _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	SANE_Int _tmp16_ = {0};
	SANE_Status _tmp17_ = 0;
	SANE_Status _tmp29_ = 0;
	gboolean full_read = FALSE;
	gboolean _tmp34_ = FALSE;
	gint _tmp35_ = 0;
	gint _tmp38_ = 0;
	SANE_Int _tmp39_ = {0};
	gint _tmp40_ = 0;
	SANE_Parameters _tmp41_ = {0};
	gint _tmp42_ = 0;
#line 1300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp2_;
#line 1305 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = self->priv->buffer;
#line 1305 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3__length1 = self->priv->buffer_length1;
#line 1305 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = self->priv->n_used;
#line 1305 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	n_to_read = _tmp3__length1 - _tmp4_;
#line 1308 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = self->priv->buffer;
#line 1308 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5__length1 = self->priv->buffer_length1;
#line 1308 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	b = (guchar*) _tmp5_;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = self->priv->handle;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = b;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = self->priv->n_used;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = n_to_read;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = sane_read (_tmp6_, (guint8*) (_tmp7_ + _tmp8_), (SANE_Int) _tmp9_, &_tmp10_);
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	n_read = _tmp10_;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp11_;
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = n_to_read;
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = status;
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = sane_status_to_string (_tmp13_);
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp15_ = _tmp14_;
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp16_ = n_read;
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1310: sane_read (%d) -> (%s, %d)", _tmp12_, _tmp15_, (gint) _tmp16_);
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp15_);
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp17_ = status;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp17_ == SANE_STATUS_EOF) {
#line 11357 "scanner.c"
		gboolean _tmp18_ = FALSE;
		SANE_Parameters _tmp19_ = {0};
		gint _tmp20_ = 0;
		gint _tmp27_ = 0;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp19_ = self->priv->parameters;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp20_ = _tmp19_.lines;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp20_ > 0) {
#line 11368 "scanner.c"
			gint _tmp21_ = 0;
			SANE_Parameters _tmp22_ = {0};
			gint _tmp23_ = 0;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp21_ = self->priv->line_count;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp22_ = self->priv->parameters;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = _tmp22_.lines;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = _tmp21_ != _tmp23_;
#line 11380 "scanner.c"
		} else {
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = FALSE;
#line 11384 "scanner.c"
		}
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp18_) {
#line 11388 "scanner.c"
			gint _tmp24_ = 0;
			SANE_Parameters _tmp25_ = {0};
			gint _tmp26_ = 0;
#line 1316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp24_ = self->priv->line_count;
#line 1316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp25_ = self->priv->parameters;
#line 1316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp26_ = _tmp25_.lines;
#line 1316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:1316: Scan completed with %d lines, expected %d lines", _tmp24_, _tmp26_);
#line 11400 "scanner.c"
		}
#line 1317 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp27_ = self->priv->n_used;
#line 1317 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp27_ > 0) {
#line 11406 "scanner.c"
			gint _tmp28_ = 0;
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp28_ = self->priv->n_used;
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:1318: Scan complete with %d bytes of unused data", _tmp28_);
#line 11412 "scanner.c"
		}
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_do_complete_page (self);
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 11420 "scanner.c"
	}
#line 1324 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = status;
#line 1324 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp29_ != SANE_STATUS_GOOD) {
#line 11426 "scanner.c"
		SANE_Status _tmp30_ = 0;
		const gchar* _tmp31_ = NULL;
		SANE_Status _tmp32_ = 0;
		const gchar* _tmp33_ = NULL;
#line 1326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp30_ = status;
#line 1326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp31_ = sane_strstatus (_tmp30_);
#line 1326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:1326: Unable to read frame from device: %s", _tmp31_);
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp32_ = status;
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp33_ = _ ("Error communicating with scanner");
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp32_, _tmp33_);
#line 1330 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1330 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 11447 "scanner.c"
	}
#line 1333 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	full_read = FALSE;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp35_ = self->priv->n_used;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp35_ == 0) {
#line 11455 "scanner.c"
		SANE_Int _tmp36_ = {0};
		guchar* _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp36_ = n_read;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp37_ = self->priv->buffer;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp37__length1 = self->priv->buffer_length1;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp34_ = _tmp36_ == ((SANE_Int) _tmp37__length1);
#line 11467 "scanner.c"
	} else {
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp34_ = FALSE;
#line 11471 "scanner.c"
	}
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp34_) {
#line 1335 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		full_read = TRUE;
#line 11477 "scanner.c"
	}
#line 1336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp38_ = self->priv->n_used;
#line 1336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp39_ = n_read;
#line 1336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->n_used = _tmp38_ + ((gint) _tmp39_);
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp40_ = self->priv->n_used;
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp41_ = self->priv->parameters;
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = _tmp41_.bytes_per_line;
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp40_ >= _tmp42_) {
#line 11493 "scanner.c"
		ScanLine* line = NULL;
		ScanLine* _tmp43_ = NULL;
		SANE_Parameters _tmp44_ = {0};
		SANE_Frame _tmp45_ = 0;
		ScanLine* _tmp51_ = NULL;
		SANE_Parameters _tmp52_ = {0};
		gint _tmp53_ = 0;
		ScanLine* _tmp54_ = NULL;
		SANE_Parameters _tmp55_ = {0};
		gint _tmp56_ = 0;
		ScanLine* _tmp57_ = NULL;
		guchar* _tmp58_ = NULL;
		gint _tmp58__length1 = 0;
		ScanLine* _tmp59_ = NULL;
		SANE_Parameters _tmp60_ = {0};
		gint _tmp61_ = 0;
		ScanLine* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		ScanLine* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		ScanLine* _tmp66_ = NULL;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		ScanLine* _tmp69_ = NULL;
		gint _tmp70_ = 0;
		gint buffer_size = 0;
		guchar* _tmp71_ = NULL;
		gint _tmp71__length1 = 0;
		gboolean _tmp72_ = FALSE;
		gint _tmp76_ = 0;
		guchar* _tmp77_ = NULL;
		gint n_remaining = 0;
		gint _tmp78_ = 0;
		ScanLine* _tmp79_ = NULL;
		gint _tmp80_ = 0;
		ScanLine* _tmp81_ = NULL;
		gint _tmp82_ = 0;
		gboolean _tmp99_ = FALSE;
		gboolean _tmp100_ = FALSE;
		gboolean _tmp101_ = FALSE;
		SANE_Parameters _tmp102_ = {0};
		gint _tmp103_ = 0;
		ScanJob* _tmp152_ = NULL;
		gint _tmp153_ = 0;
		ScanLine* _tmp154_ = NULL;
		NotifyGotLine* _tmp155_ = NULL;
		NotifyGotLine* _tmp156_ = NULL;
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp43_ = scan_line_new ();
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		line = _tmp43_;
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp44_ = self->priv->parameters;
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp45_ = _tmp44_.format;
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		switch (_tmp45_) {
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_GRAY:
#line 11553 "scanner.c"
			{
				ScanLine* _tmp46_ = NULL;
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp46_ = line;
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp46_->channel = 0;
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11562 "scanner.c"
			}
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_RGB:
#line 11566 "scanner.c"
			{
				ScanLine* _tmp47_ = NULL;
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp47_ = line;
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp47_->channel = -1;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11575 "scanner.c"
			}
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_RED:
#line 11579 "scanner.c"
			{
				ScanLine* _tmp48_ = NULL;
#line 1351 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp48_ = line;
#line 1351 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp48_->channel = 0;
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11588 "scanner.c"
			}
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_GREEN:
#line 11592 "scanner.c"
			{
				ScanLine* _tmp49_ = NULL;
#line 1354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp49_ = line;
#line 1354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp49_->channel = 1;
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11601 "scanner.c"
			}
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_BLUE:
#line 11605 "scanner.c"
			{
				ScanLine* _tmp50_ = NULL;
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp50_ = line;
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp50_->channel = 2;
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11614 "scanner.c"
			}
			default:
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 11619 "scanner.c"
		}
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp51_ = line;
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp52_ = self->priv->parameters;
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp53_ = _tmp52_.pixels_per_line;
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp51_->width = _tmp53_;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp54_ = line;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp55_ = self->priv->parameters;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp56_ = _tmp55_.depth;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp54_->depth = _tmp56_;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_ = line;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp58_ = self->priv->buffer;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp58__length1 = self->priv->buffer_length1;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer = NULL;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer_length1 = 0;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_->data = (g_free (_tmp57_->data), NULL);
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_->data = _tmp58_;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_->data_length1 = _tmp58__length1;
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp59_ = line;
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp60_ = self->priv->parameters;
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp61_ = _tmp60_.bytes_per_line;
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp59_->data_length = _tmp61_;
#line 1364 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp62_ = line;
#line 1364 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp63_ = self->priv->line_count;
#line 1364 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp62_->number = _tmp63_;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp64_ = line;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp65_ = self->priv->n_used;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp66_ = line;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp67_ = _tmp66_->data_length;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp64_->n_lines = _tmp65_ / _tmp67_;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp68_ = self->priv->line_count;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp69_ = line;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp70_ = _tmp69_->n_lines;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->line_count = _tmp68_ + _tmp70_;
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp71_ = self->priv->buffer;
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp71__length1 = self->priv->buffer_length1;
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		buffer_size = _tmp71__length1;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp72_ = full_read;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp72_) {
#line 11695 "scanner.c"
			gint _tmp73_ = 0;
			SANE_Parameters _tmp74_ = {0};
			gint _tmp75_ = 0;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp73_ = buffer_size;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp74_ = self->priv->parameters;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp75_ = _tmp74_.bytes_per_line;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			buffer_size = _tmp73_ + _tmp75_;
#line 11707 "scanner.c"
		}
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp76_ = buffer_size;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp77_ = g_new0 (guchar, _tmp76_);
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer = _tmp77_;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer_length1 = _tmp76_;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp78_ = self->priv->n_used;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp79_ = line;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp80_ = _tmp79_->n_lines;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp81_ = line;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp82_ = _tmp81_->data_length;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		n_remaining = _tmp78_ - (_tmp80_ * _tmp82_);
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->n_used = 0;
#line 11735 "scanner.c"
		{
			gint i = 0;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			i = 0;
#line 11740 "scanner.c"
			{
				gboolean _tmp83_ = FALSE;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp83_ = TRUE;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				while (TRUE) {
#line 11747 "scanner.c"
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					guchar* _tmp87_ = NULL;
					gint _tmp87__length1 = 0;
					gint _tmp88_ = 0;
					ScanLine* _tmp89_ = NULL;
					guchar* _tmp90_ = NULL;
					gint _tmp90__length1 = 0;
					gint _tmp91_ = 0;
					ScanLine* _tmp92_ = NULL;
					gint _tmp93_ = 0;
					ScanLine* _tmp94_ = NULL;
					gint _tmp95_ = 0;
					guchar _tmp96_ = '\0';
					guchar _tmp97_ = '\0';
					gint _tmp98_ = 0;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp83_) {
#line 11766 "scanner.c"
						gint _tmp84_ = 0;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp84_ = i;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						i = _tmp84_ + 1;
#line 11772 "scanner.c"
					}
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp83_ = FALSE;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp85_ = i;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp86_ = n_remaining;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!(_tmp85_ < _tmp86_)) {
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						break;
#line 11784 "scanner.c"
					}
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp87_ = self->priv->buffer;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp87__length1 = self->priv->buffer_length1;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp88_ = i;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp89_ = line;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp90_ = _tmp89_->data;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp90__length1 = _tmp89_->data_length1;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp91_ = i;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp92_ = line;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp93_ = _tmp92_->n_lines;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp94_ = line;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp95_ = _tmp94_->data_length;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp96_ = _tmp90_[_tmp91_ + (_tmp93_ * _tmp95_)];
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp87_[_tmp88_] = _tmp96_;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp97_ = _tmp87_[_tmp88_];
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp98_ = self->priv->n_used;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					self->priv->n_used = _tmp98_ + 1;
#line 11818 "scanner.c"
				}
			}
		}
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp102_ = self->priv->parameters;
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp103_ = _tmp102_.depth;
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp103_ == 8) {
#line 11828 "scanner.c"
			SANE_Parameters _tmp104_ = {0};
			SANE_Frame _tmp105_ = 0;
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp104_ = self->priv->parameters;
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp105_ = _tmp104_.format;
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp101_ = _tmp105_ == SANE_FRAME_GRAY;
#line 11837 "scanner.c"
		} else {
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp101_ = FALSE;
#line 11841 "scanner.c"
		}
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp101_) {
#line 11845 "scanner.c"
			ScanJob* _tmp106_ = NULL;
			gint _tmp107_ = 0;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp106_ = job;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp107_ = _tmp106_->depth;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp100_ = _tmp107_ == 2;
#line 11854 "scanner.c"
		} else {
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp100_ = FALSE;
#line 11858 "scanner.c"
		}
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp100_) {
#line 11862 "scanner.c"
			ScanJob* _tmp108_ = NULL;
			ScanMode _tmp109_ = 0;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp108_ = job;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp109_ = _tmp108_->scan_mode;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp99_ = _tmp109_ == SCAN_MODE_GRAY;
#line 11871 "scanner.c"
		} else {
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp99_ = FALSE;
#line 11875 "scanner.c"
		}
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp99_) {
#line 11879 "scanner.c"
			guchar block = '\0';
			gint write_offset = 0;
			gint block_shift = 0;
			ScanLine* _tmp149_ = NULL;
			ScanLine* _tmp150_ = NULL;
			gint _tmp151_ = 0;
#line 1388 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			block = (guchar) 0;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			write_offset = 0;
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			block_shift = 6;
#line 11892 "scanner.c"
			{
				gint i = 0;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 11897 "scanner.c"
				{
					gboolean _tmp110_ = FALSE;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp110_ = TRUE;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 11904 "scanner.c"
						gint _tmp112_ = 0;
						ScanLine* _tmp113_ = NULL;
						gint _tmp114_ = 0;
						gint offset = 0;
						gint _tmp115_ = 0;
						ScanLine* _tmp116_ = NULL;
						gint _tmp117_ = 0;
						gint _tmp142_ = 0;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp110_) {
#line 11915 "scanner.c"
							gint _tmp111_ = 0;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp111_ = i;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp111_ + 1;
#line 11921 "scanner.c"
						}
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp110_ = FALSE;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp112_ = i;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp113_ = line;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp114_ = _tmp113_->n_lines;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(_tmp112_ < _tmp114_)) {
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 11935 "scanner.c"
						}
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp115_ = i;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp116_ = line;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp117_ = _tmp116_->data_length;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						offset = _tmp115_ * _tmp117_;
#line 11945 "scanner.c"
						{
							gint x = 0;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							x = 0;
#line 11950 "scanner.c"
							{
								gboolean _tmp118_ = FALSE;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
								_tmp118_ = TRUE;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
								while (TRUE) {
#line 11957 "scanner.c"
									gint _tmp120_ = 0;
									ScanLine* _tmp121_ = NULL;
									gint _tmp122_ = 0;
									guchar p = '\0';
									ScanLine* _tmp123_ = NULL;
									guchar* _tmp124_ = NULL;
									gint _tmp124__length1 = 0;
									gint _tmp125_ = 0;
									gint _tmp126_ = 0;
									guchar _tmp127_ = '\0';
									guchar sample = '\0';
									guchar _tmp128_ = '\0';
									guchar _tmp131_ = '\0';
									guchar _tmp132_ = '\0';
									gint _tmp133_ = 0;
									gint _tmp134_ = 0;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									if (!_tmp118_) {
#line 11976 "scanner.c"
										gint _tmp119_ = 0;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp119_ = x;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										x = _tmp119_ + 1;
#line 11982 "scanner.c"
									}
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp118_ = FALSE;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp120_ = x;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp121_ = line;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp122_ = _tmp121_->width;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									if (!(_tmp120_ < _tmp122_)) {
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										break;
#line 11996 "scanner.c"
									}
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp123_ = line;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp124_ = _tmp123_->data;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp124__length1 = _tmp123_->data_length1;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp125_ = offset;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp126_ = x;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp127_ = _tmp124_[_tmp125_ + _tmp126_];
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									p = _tmp127_;
#line 1399 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp128_ = p;
#line 1399 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									if (((gint) _tmp128_) >= 192) {
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										sample = (guchar) 3;
#line 12018 "scanner.c"
									} else {
										guchar _tmp129_ = '\0';
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp129_ = p;
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										if (((gint) _tmp129_) >= 128) {
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
											sample = (guchar) 2;
#line 12027 "scanner.c"
										} else {
											guchar _tmp130_ = '\0';
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
											_tmp130_ = p;
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
											if (((gint) _tmp130_) >= 64) {
#line 1404 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
												sample = (guchar) 1;
#line 12036 "scanner.c"
											} else {
#line 1406 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
												sample = (guchar) 0;
#line 12040 "scanner.c"
											}
										}
									}
#line 1408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp131_ = block;
#line 1408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp132_ = sample;
#line 1408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp133_ = block_shift;
#line 1408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									block = _tmp131_ | (_tmp132_ << _tmp133_);
#line 1409 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp134_ = block_shift;
#line 1409 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									if (_tmp134_ == 0) {
#line 12056 "scanner.c"
										ScanLine* _tmp135_ = NULL;
										guchar* _tmp136_ = NULL;
										gint _tmp136__length1 = 0;
										gint _tmp137_ = 0;
										guchar _tmp138_ = '\0';
										guchar _tmp139_ = '\0';
										gint _tmp140_ = 0;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp135_ = line;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp136_ = _tmp135_->data;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp136__length1 = _tmp135_->data_length1;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp137_ = write_offset;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp138_ = block;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp136_[_tmp137_] = _tmp138_;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp139_ = _tmp136_[_tmp137_];
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp140_ = write_offset;
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										write_offset = _tmp140_ + 1;
#line 1413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										block = (guchar) 0;
#line 1414 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										block_shift = 6;
#line 12086 "scanner.c"
									} else {
										gint _tmp141_ = 0;
#line 1417 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp141_ = block_shift;
#line 1417 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										block_shift = _tmp141_ - 2;
#line 12093 "scanner.c"
									}
								}
							}
						}
#line 1421 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp142_ = block_shift;
#line 1421 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp142_ != 6) {
#line 12102 "scanner.c"
							ScanLine* _tmp143_ = NULL;
							guchar* _tmp144_ = NULL;
							gint _tmp144__length1 = 0;
							gint _tmp145_ = 0;
							guchar _tmp146_ = '\0';
							guchar _tmp147_ = '\0';
							gint _tmp148_ = 0;
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp143_ = line;
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp144_ = _tmp143_->data;
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp144__length1 = _tmp143_->data_length1;
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp145_ = write_offset;
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp146_ = block;
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp144_[_tmp145_] = _tmp146_;
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp147_ = _tmp144_[_tmp145_];
#line 1424 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp148_ = write_offset;
#line 1424 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							write_offset = _tmp148_ + 1;
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							block = (guchar) 0;
#line 1426 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							block_shift = 6;
#line 12132 "scanner.c"
						}
					}
				}
			}
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp149_ = line;
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp150_ = line;
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp151_ = _tmp150_->width;
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp149_->data_length = ((_tmp151_ * 2) + 7) / 8;
#line 12145 "scanner.c"
		}
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp152_ = job;
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp153_ = _tmp152_->id;
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp154_ = line;
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp155_ = notify_got_line_new (_tmp153_, _tmp154_);
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp156_ = _tmp155_;
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp156_);
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_notify_unref0 (_tmp156_);
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_line_unref0 (line);
#line 12163 "scanner.c"
	}
#line 1300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 12167 "scanner.c"
}


static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password) {
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_authorization_cb (resource, username, -1, password, -1);
#line 12174 "scanner.c"
}


static void* scanner_scan_thread (Scanner* self) {
	void* result = NULL;
	SANE_Int version_code = {0};
	SANE_Status status = 0;
	SANE_Int _tmp0_ = {0};
	SANE_Status _tmp1_ = 0;
	SANE_Status _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SANE_Status _tmp5_ = 0;
	SANE_Int _tmp8_ = {0};
	gint _tmp9_ = 0;
	SANE_Int _tmp10_ = {0};
	gint _tmp11_ = 0;
	SANE_Int _tmp12_ = {0};
	gint _tmp13_ = 0;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = sane_init (&_tmp0_, _scanner_authorization_cb_sane_authcallback);
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	version_code = _tmp0_;
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp1_;
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = status;
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1443: sane_init () -> %s", _tmp4_);
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 1444 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = status;
#line 1444 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 12218 "scanner.c"
		SANE_Status _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = status;
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:1446: Unable to initialize SANE backend: %s", _tmp7_);
#line 1447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = NULL;
#line 1447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 12231 "scanner.c"
	}
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = version_code;
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = SANE_VERSION_MAJOR (_tmp8_);
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = version_code;
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = SANE_VERSION_MINOR (_tmp10_);
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = version_code;
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = SANE_VERSION_BUILD (_tmp12_);
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1449: SANE version %d.%d.%d", _tmp9_, _tmp11_, _tmp13_);
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_redetect (self);
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	while (TRUE) {
#line 12251 "scanner.c"
		gboolean _tmp14_ = FALSE;
		ScanState _tmp15_ = 0;
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = scanner_handle_requests (self);
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (!_tmp14_) {
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 12260 "scanner.c"
		}
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = self->priv->state;
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		switch (_tmp15_) {
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_IDLE:
#line 12268 "scanner.c"
			{
				GList* _tmp16_ = NULL;
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16_ = self->priv->job_queue;
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp16_ != NULL) {
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					scanner_set_scanning (self, TRUE);
#line 1465 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					self->priv->state = SCAN_STATE_OPEN;
#line 12279 "scanner.c"
				}
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12283 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_REDETECT:
#line 12287 "scanner.c"
			{
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_redetect (self);
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12293 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_OPEN:
#line 12297 "scanner.c"
			{
#line 1472 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_open (self);
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12303 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_GET_OPTION:
#line 12307 "scanner.c"
			{
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_get_option (self);
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12313 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_START:
#line 12317 "scanner.c"
			{
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_start (self);
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12323 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_GET_PARAMETERS:
#line 12327 "scanner.c"
			{
#line 1481 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_get_parameters (self);
#line 1482 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12333 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_READ:
#line 12337 "scanner.c"
			{
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_read (self);
#line 1485 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12343 "scanner.c"
			}
			default:
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 12348 "scanner.c"
		}
	}
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = NULL;
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 12355 "scanner.c"
}


static gpointer _scanner_scan_thread_gthread_func (gpointer self) {
	gpointer result;
	result = scanner_scan_thread ((Scanner*) self);
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_unref (self);
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 12366 "scanner.c"
}


void scanner_start (Scanner* self) {
	GError * _inner_error_ = NULL;
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 12374 "scanner.c"
	{
		GThread* _tmp0_ = NULL;
		GThread* _tmp1_ = NULL;
		GThread* _tmp2_ = NULL;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = g_thread_try_new ("scan-thread", _scanner_scan_thread_gthread_func, scanner_ref (self), &_inner_error_);
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp1_;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_inner_error_ != NULL) {
#line 12385 "scanner.c"
			goto __catch15_g_error;
		}
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = _tmp0_;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = NULL;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->thread = _tmp2_;
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_thread_unref0 (_tmp0_);
#line 12398 "scanner.c"
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		e = _inner_error_;
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_inner_error_ = NULL;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = e;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = _tmp3_->message;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_critical ("scanner.vala:1500: Unable to create thread: %s", _tmp4_);
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_error_free0 (e);
#line 12418 "scanner.c"
	}
	__finally15:
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_inner_error_ != NULL) {
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_clear_error (&_inner_error_);
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 12429 "scanner.c"
	}
}


void scanner_redetect (Scanner* self) {
	gboolean _tmp0_ = FALSE;
	GAsyncQueue* _tmp1_ = NULL;
	RequestRedetect* _tmp2_ = NULL;
#line 1504 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1506 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->need_redetect;
#line 1506 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 12446 "scanner.c"
	}
#line 1508 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->need_redetect = TRUE;
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1510: Requesting redetection of scan devices");
#line 1512 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1512 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = request_redetect_new ();
#line 1512 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12458 "scanner.c"
}


gboolean scanner_is_scanning (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1515 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1517 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->scanning;
#line 1517 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp0_;
#line 1517 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 12473 "scanner.c"
}


static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode) {
	gchar* result = NULL;
	ScanMode _tmp0_ = 0;
#line 1520 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = mode;
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp0_) {
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_MODE_DEFAULT:
#line 12488 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanMode.DEFAULT");
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp1_;
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12497 "scanner.c"
		}
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_MODE_COLOR:
#line 12501 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanMode.COLOR");
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp2_;
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12510 "scanner.c"
		}
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_MODE_GRAY:
#line 12514 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanMode.GRAY");
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp3_;
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12523 "scanner.c"
		}
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_MODE_LINEART:
#line 12527 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = g_strdup ("ScanMode.LINEART");
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp4_;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12536 "scanner.c"
		}
		default:
		{
			ScanMode _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp5_ = mode;
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp6_;
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12550 "scanner.c"
		}
	}
}


static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type) {
	gchar* result = NULL;
	ScanType _tmp0_ = 0;
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = type;
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp0_) {
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_TYPE_SINGLE:
#line 12567 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 1542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanType.SINGLE");
#line 1542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp1_;
#line 1542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12576 "scanner.c"
		}
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_TYPE_ADF_FRONT:
#line 12580 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 1544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanType.ADF_FRONT");
#line 1544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp2_;
#line 1544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12589 "scanner.c"
		}
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_TYPE_ADF_BACK:
#line 12593 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanType.ADF_BACK");
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp3_;
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12602 "scanner.c"
		}
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_TYPE_ADF_BOTH:
#line 12606 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = g_strdup ("ScanType.ADF_BOTH");
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp4_;
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12615 "scanner.c"
		}
		default:
		{
			ScanType _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp5_ = type;
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp6_;
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12629 "scanner.c"
		}
	}
}


void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ScanOptions* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	ScanOptions* _tmp5_ = NULL;
	ScanMode _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	ScanOptions* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	ScanOptions* _tmp11_ = NULL;
	ScanType _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	ScanOptions* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	ScanOptions* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	ScanOptions* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	ScanOptions* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	RequestStartScan* request = NULL;
	RequestStartScan* _tmp23_ = NULL;
	ScanJob* _tmp24_ = NULL;
	ScanJob* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	ScanJob* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	ScanJob* _tmp30_ = NULL;
	ScanOptions* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	ScanJob* _tmp33_ = NULL;
	ScanOptions* _tmp34_ = NULL;
	ScanMode _tmp35_ = 0;
	ScanJob* _tmp36_ = NULL;
	ScanOptions* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	ScanJob* _tmp39_ = NULL;
	ScanOptions* _tmp40_ = NULL;
	ScanType _tmp41_ = 0;
	ScanJob* _tmp42_ = NULL;
	ScanOptions* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	ScanJob* _tmp45_ = NULL;
	ScanOptions* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	ScanJob* _tmp48_ = NULL;
	ScanOptions* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	ScanJob* _tmp51_ = NULL;
	ScanOptions* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	GAsyncQueue* _tmp54_ = NULL;
	Request* _tmp55_ = NULL;
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (options != NULL);
#line 1557 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = device;
#line 1557 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ != NULL) {
#line 12700 "scanner.c"
		const gchar* _tmp2_ = NULL;
#line 1557 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = device;
#line 1557 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 12706 "scanner.c"
	} else {
#line 1557 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = "(null)";
#line 12710 "scanner.c"
	}
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = options;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->dpi;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = options;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = _tmp5_->scan_mode;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = scanner_get_scan_mode_string (self, _tmp6_);
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = options;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = _tmp9_->depth;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = options;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = _tmp11_->type;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = scanner_get_scan_type_string (self, _tmp12_);
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = _tmp13_;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp15_ = options;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp16_ = _tmp15_->paper_width;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp17_ = options;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp18_ = _tmp17_->paper_height;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp19_ = options;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp20_ = _tmp19_->brightness;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_ = options;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp22_ = _tmp21_->contrast;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1556: Scanner.scan (\"%s\", dpi=%d, scan_mode=%s, depth=%" \
"d, type=%s, paper_width=%d, paper_height=%d, brightness=%d, contrast=%" \
"d)", _tmp0_, _tmp4_, _tmp8_, _tmp10_, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_);
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp14_);
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp23_ = request_start_scan_new ();
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request = _tmp23_;
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp24_ = scan_job_new ();
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (request->job);
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request->job = _tmp24_;
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_ = request->job;
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26_ = self->job_id;
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->job_id = _tmp26_ + 1;
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_->id = _tmp26_;
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_ = request->job;
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28_ = device;
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp27_->device);
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_->device = _tmp29_;
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_ = request->job;
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp31_ = options;
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp32_ = _tmp31_->dpi;
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_->dpi = (gdouble) _tmp32_;
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_ = request->job;
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp34_ = options;
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp35_ = _tmp34_->scan_mode;
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_->scan_mode = _tmp35_;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_ = request->job;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp37_ = options;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp38_ = _tmp37_->depth;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_->depth = _tmp38_;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp39_ = request->job;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp40_ = options;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp41_ = _tmp40_->type;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp39_->type = _tmp41_;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = request->job;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp43_ = options;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp44_ = _tmp43_->paper_width;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_->page_width = _tmp44_;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp45_ = request->job;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp46_ = options;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp47_ = _tmp46_->paper_height;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp45_->page_height = _tmp47_;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp48_ = request->job;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp49_ = options;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp50_ = _tmp49_->brightness;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp48_->brightness = _tmp50_;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp51_ = request->job;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp52_ = options;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp53_ = _tmp52_->contrast;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp51_->contrast = _tmp53_;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp54_ = self->priv->request_queue;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp55_ = _request_ref0 ((Request*) request);
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp54_, _tmp55_);
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_request_unref0 (request);
#line 12858 "scanner.c"
}


void scanner_cancel (Scanner* self) {
	gint _tmp0_ = 0;
	GAsyncQueue* _tmp1_ = NULL;
	RequestCancel* _tmp2_ = NULL;
#line 1575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->job_id;
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->first_job_id = _tmp0_;
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = request_cancel_new ();
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12878 "scanner.c"
}


static gpointer _g_thread_ref0 (gpointer self) {
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? g_thread_ref (self) : NULL;
#line 12885 "scanner.c"
}


void scanner_free (Scanner* self) {
	GAsyncQueue* _tmp0_ = NULL;
	RequestQuit* _tmp1_ = NULL;
	GThread* _tmp2_ = NULL;
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1583: Stopping scan thread");
#line 1585 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->request_queue;
#line 1585 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = request_quit_new ();
#line 1585 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->thread;
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 12907 "scanner.c"
		GThread* _tmp3_ = NULL;
		GThread* _tmp4_ = NULL;
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = self->priv->thread;
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = _g_thread_ref0 (_tmp3_);
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_thread_join (_tmp4_);
#line 1590 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1590 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->thread = NULL;
#line 12920 "scanner.c"
	}
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	sane_exit ();
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1594: sane_exit ()");
#line 12926 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_PAGE_INFO) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_PAGE_INFO callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 12945 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = closure->data;
#line 12951 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_PAGE_INFO) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback (data1, value_get_scan_page_info (param_values + 1), data2);
#line 12957 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_LINE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_LINE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 12976 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = closure->data;
#line 12982 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_LINE) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback (data1, value_get_scan_line (param_values + 1), data2);
#line 12988 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (n_param_values == 3);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13007 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = closure->data;
#line 13013 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 13019 "scanner.c"
}


static void value_scanner_init (GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 13026 "scanner.c"
}


static void value_scanner_free_value (GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_unref (value->data[0].v_pointer);
#line 13035 "scanner.c"
	}
}


static void value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scanner_ref (src_value->data[0].v_pointer);
#line 13045 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 13049 "scanner.c"
	}
}


static gpointer value_scanner_peek_pointer (const GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 13057 "scanner.c"
}


static gchar* value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 13064 "scanner.c"
		Scanner* object;
		object = collect_values[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13071 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13075 "scanner.c"
		}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scanner_ref (object);
#line 13079 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13083 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 13087 "scanner.c"
}


static gchar* value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Scanner** object_p;
	object_p = collect_values[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 13098 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 13104 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 13108 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scanner_ref (value->data[0].v_pointer);
#line 13112 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 13116 "scanner.c"
}


GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanner* spec;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCANNER), NULL);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 13130 "scanner.c"
}


gpointer value_get_scanner (const GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER), NULL);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 13139 "scanner.c"
}


void value_set_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_ref (value->data[0].v_pointer);
#line 13159 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13163 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_unref (old);
#line 13169 "scanner.c"
	}
}


void value_take_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 13188 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13192 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_unref (old);
#line 13198 "scanner.c"
	}
}


static void scanner_class_init (ScannerClass * klass) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_parent_class = g_type_class_peek_parent (klass);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	SCANNER_CLASS (klass)->finalize = scanner_finalize;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (ScannerPrivate));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("update_devices", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("request_authorization", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("expect_page", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("got_page_info", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO, G_TYPE_NONE, 1, TYPE_SCAN_PAGE_INFO);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("got_line", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_LINE, G_TYPE_NONE, 1, TYPE_SCAN_LINE);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("scan_failed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("page_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("document_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("scanning_changed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13228 "scanner.c"
}


static void scanner_instance_init (Scanner * self) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = SCANNER_GET_PRIVATE (self);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 13237 "scanner.c"
}


static void scanner_finalize (Scanner* obj) {
	Scanner * self;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCANNER, Scanner);
#line 214 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_thread_unref0 (self->priv->thread);
#line 217 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 220 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 223 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->default_device);
#line 234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
#line 239 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 247 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 250 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 13263 "scanner.c"
}


GType scanner_get_type (void) {
	static volatile gsize scanner_type_id__volatile = 0;
	if (g_once_init_enter (&scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scanner_init, value_scanner_free_value, value_scanner_copy_value, value_scanner_peek_pointer, "p", value_scanner_collect_value, "p", value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scanner), 0, (GInstanceInitFunc) scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scanner_type_id;
		scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Scanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scanner_type_id__volatile, scanner_type_id);
	}
	return scanner_type_id__volatile;
}


gpointer scanner_ref (gpointer instance) {
	Scanner* self;
	self = instance;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 13288 "scanner.c"
}


void scanner_unref (gpointer instance) {
	Scanner* self;
	self = instance;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCANNER_GET_CLASS (self)->finalize (self);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 13301 "scanner.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



