/* page.c generated by valac 0.20.1, the Vala compiler
 * generated from page.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef struct _PagePrivate PagePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PIXBUF_WRITER (pixbuf_writer_get_type ())
#define PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_WRITER, PixbufWriter))
#define PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_WRITER, PixbufWriterClass))
#define IS_PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_WRITER))
#define IS_PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_WRITER))
#define PIXBUF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_WRITER, PixbufWriterClass))

typedef struct _PixbufWriter PixbufWriter;
typedef struct _PixbufWriterClass PixbufWriterClass;
#define _pixbuf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pixbuf_writer_unref (var), NULL)))
typedef struct _ParamSpecPage ParamSpecPage;
typedef struct _PixbufWriterPrivate PixbufWriterPrivate;
typedef struct _ParamSpecPixbufWriter ParamSpecPixbufWriter;

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _Page {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PagePrivate * priv;
};

struct _PageClass {
	GTypeClass parent_class;
	void (*finalize) (Page *self);
};

struct _PagePrivate {
	gint dpi;
	gint expected_rows;
	gint depth;
	gchar* color_profile;
	gint width;
	gint n_rows;
	gint rowstride;
	gint n_channels;
	guchar* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	gboolean scanning;
	gboolean has_data_;
	gint scan_line;
	ScanDirection scan_direction;
	gboolean has_crop_;
	gchar* crop_name;
	gint crop_x;
	gint crop_y;
	gint crop_width;
	gint crop_height;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecPage {
	GParamSpec parent_instance;
};

struct _PixbufWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixbufWriterPrivate * priv;
	GFileOutputStream* stream;
};

struct _PixbufWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PixbufWriter *self);
};

struct _ParamSpecPixbufWriter {
	GParamSpec parent_instance;
};


static gpointer page_parent_class = NULL;
static gpointer pixbuf_writer_parent_class = NULL;

GType scan_direction_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE, PagePrivate))
enum  {
	PAGE_DUMMY_PROPERTY
};
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_new_from_data (gint width, gint n_rows, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
Page* page_construct_from_data (GType object_type, gint width, gint n_rows, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
static guchar* _vala_array_dup3 (guchar* self, int length);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_start (Page* self);
gboolean page_is_scanning (Page* self);
gboolean page_has_data (Page* self);
gboolean page_is_color (Page* self);
gint page_get_scan_line (Page* self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void page_parse_line (Page* self, ScanLine* line, gint n, gboolean* size_changed);
gint page_get_scan_height (Page* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
ScanDirection page_get_scan_direction (Page* self);
static void page_set_scan_direction (Page* self, ScanDirection direction);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_rotate_left (Page* self);
void page_rotate_right (Page* self);
gint page_get_dpi (Page* self);
gboolean page_is_landscape (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_rowstride (Page* self);
gint page_get_scan_width (Page* self);
void page_set_color_profile (Page* self, const gchar* color_profile);
gchar* page_get_color_profile (Page* self);
void page_set_no_crop (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_set_named_crop (Page* self, const gchar* name);
void page_move_crop (Page* self, gint x, gint y);
void page_rotate_crop (Page* self);
gboolean page_has_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
gchar* page_get_named_crop (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
static guchar page_get_sample (Page* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint n_channels, gint channel);
static void page_get_pixel (Page* self, gint x, gint y, guchar* pixel, int pixel_length1, gint offset);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
static gchar* page_get_icc_data_encoded (Page* self, const gchar* icc_profile_filename);
void page_copy_to_clipboard (Page* self, GtkWindow* window);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream);
PixbufWriter* pixbuf_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer pixbuf_writer_ref (gpointer instance);
void pixbuf_writer_unref (gpointer instance);
GParamSpec* param_spec_pixbuf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixbuf_writer (GValue* value, gpointer v_object);
void value_take_pixbuf_writer (GValue* value, gpointer v_object);
gpointer value_get_pixbuf_writer (const GValue* value);
GType pixbuf_writer_get_type (void) G_GNUC_CONST;
void pixbuf_writer_save (PixbufWriter* self, GdkPixbuf* image, const gchar* type, gchar** option_keys, int option_keys_length1, gchar** option_values, int option_values_length1, GError** error);
static void page_finalize (Page* obj);
enum  {
	PIXBUF_WRITER_DUMMY_PROPERTY
};
static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self, guint8* buf, int buf_length1, GError** error);
static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void pixbuf_writer_finalize (PixbufWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType scan_direction_get_type (void) {
	static volatile gsize scan_direction_type_id__volatile = 0;
	if (g_once_init_enter (&scan_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_DIRECTION_TOP_TO_BOTTOM, "SCAN_DIRECTION_TOP_TO_BOTTOM", "top-to-bottom"}, {SCAN_DIRECTION_LEFT_TO_RIGHT, "SCAN_DIRECTION_LEFT_TO_RIGHT", "left-to-right"}, {SCAN_DIRECTION_BOTTOM_TO_TOP, "SCAN_DIRECTION_BOTTOM_TO_TOP", "bottom-to-top"}, {SCAN_DIRECTION_RIGHT_TO_LEFT, "SCAN_DIRECTION_RIGHT_TO_LEFT", "right-to-left"}, {0, NULL, NULL}};
		GType scan_direction_type_id;
		scan_direction_type_id = g_enum_register_static ("ScanDirection", values);
		g_once_init_leave (&scan_direction_type_id__volatile, scan_direction_type_id);
	}
	return scan_direction_type_id__volatile;
}


Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction) {
	Page* self = NULL;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	gboolean _tmp3_;
	gint _tmp8_;
	ScanDirection _tmp9_;
#line 68 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self = (Page*) g_type_create_instance (object_type);
#line 70 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = scan_direction;
#line 70 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 70 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = TRUE;
#line 302 "page.c"
	} else {
		ScanDirection _tmp2_;
#line 70 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp2_ = scan_direction;
#line 70 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 309 "page.c"
	}
#line 70 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = _tmp0_;
#line 70 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp3_) {
#line 315 "page.c"
		gint _tmp4_;
		gint _tmp5_;
#line 72 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp4_ = width;
#line 72 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->width = _tmp4_;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp5_ = height;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->n_rows = _tmp5_;
#line 326 "page.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 77 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp6_ = height;
#line 77 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->width = _tmp6_;
#line 78 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp7_ = width;
#line 78 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->n_rows = _tmp7_;
#line 338 "page.c"
	}
#line 80 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp8_ = dpi;
#line 80 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->dpi = _tmp8_;
#line 81 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp9_ = scan_direction;
#line 81 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->scan_direction = _tmp9_;
#line 68 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return self;
#line 350 "page.c"
}


Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction) {
#line 68 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return page_construct (TYPE_PAGE, width, height, dpi, scan_direction);
#line 357 "page.c"
}


static guchar* _vala_array_dup3 (guchar* self, int length) {
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return g_memdup (self, length * sizeof (guchar));
#line 364 "page.c"
}


Page* page_construct_from_data (GType object_type, gint width, gint n_rows, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height) {
	Page* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ScanDirection _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	guchar* _tmp10_;
	gint _tmp10__length1;
	guchar* _tmp11_;
	gint _tmp11__length1;
	guchar* _tmp12_;
	gint _tmp12__length1;
	gboolean _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
#line 84 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self = (Page*) g_type_create_instance (object_type);
#line 100 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = width;
#line 100 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->width = _tmp0_;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = n_rows;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->n_rows = _tmp1_;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = n_rows;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->expected_rows = _tmp2_;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = rowstride;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->rowstride = _tmp3_;
#line 104 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = n_channels;
#line 104 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->n_channels = _tmp4_;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp5_ = depth;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->depth = _tmp5_;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp6_ = dpi;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->dpi = _tmp6_;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7_ = scan_direction;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->scan_direction = _tmp7_;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp8_ = color_profile;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 108 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (self->priv->color_profile);
#line 108 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->color_profile = _tmp9_;
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp10_ = pixels;
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp10__length1 = pixels_length1;
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp11_ = (_tmp10_ != NULL) ? _vala_array_dup3 (_tmp10_, _tmp10__length1) : ((gpointer) _tmp10_);
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp11__length1 = _tmp10__length1;
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->pixels = _tmp11_;
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->pixels_length1 = _tmp11__length1;
#line 109 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->_pixels_size_ = self->priv->pixels_length1;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp12_ = pixels;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp12__length1 = pixels_length1;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->has_data_ = _tmp12_ != NULL;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp13_ = has_crop;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->has_crop_ = _tmp13_;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp14_ = crop_name;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 112 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (self->priv->crop_name);
#line 112 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_name = _tmp15_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp16_ = crop_x;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_x = _tmp16_;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp17_ = crop_y;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_y = _tmp17_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp18_ = crop_width;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_width = _tmp18_;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp19_ = crop_height;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_height = _tmp19_;
#line 84 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return self;
#line 487 "page.c"
}


Page* page_new_from_data (gint width, gint n_rows, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height) {
#line 84 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return page_construct_from_data (TYPE_PAGE, width, n_rows, rowstride, n_channels, depth, dpi, scan_direction, color_profile, pixels, pixels_length1, has_crop, crop_name, crop_x, crop_y, crop_width, crop_height);
#line 494 "page.c"
}


void page_set_page_info (Page* self, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_;
	gint _tmp1_;
	ScanPageInfo* _tmp2_;
	gdouble _tmp3_;
	ScanPageInfo* _tmp4_;
	gint _tmp5_;
	ScanPageInfo* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ScanPageInfo* _tmp10_;
	gint _tmp11_;
	ScanPageInfo* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_ = 0;
	guchar* _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
#line 119 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (info != NULL);
#line 121 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = info;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = _tmp0_->height;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->expected_rows = _tmp1_;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = info;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = _tmp2_->dpi;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->dpi = (gint) _tmp3_;
#line 125 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = info;
#line 125 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp5_ = _tmp4_->width;
#line 125 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->width = _tmp5_;
#line 126 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp6_ = info;
#line 126 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7_ = _tmp6_->height;
#line 126 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->n_rows = _tmp7_;
#line 128 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp8_ = self->priv->n_rows;
#line 128 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp8_ < 0) {
#line 553 "page.c"
		gint _tmp9_;
#line 129 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp9_ = self->priv->width;
#line 129 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->n_rows = _tmp9_ / 2;
#line 559 "page.c"
	}
#line 130 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp10_ = info;
#line 130 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp11_ = _tmp10_->depth;
#line 130 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->depth = _tmp11_;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp12_ = info;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp13_ = _tmp12_->n_channels;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->n_channels = _tmp13_;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp14_ = self->priv->width;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp15_ = self->priv->depth;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp16_ = self->priv->n_channels;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->rowstride = (((_tmp14_ * _tmp15_) * _tmp16_) + 7) / 8;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp17_ = self->priv->n_rows;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp18_ = self->priv->rowstride;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp19_ = _tmp17_ * _tmp18_;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp17_ * _tmp18_);
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	(_tmp19_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp19_ - self->priv->pixels_length1)) : NULL;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->pixels_length1 = _tmp19_;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->_pixels_size_ = _tmp19_;
#line 134 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp20_ = self->priv->pixels;
#line 134 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp20__length1 = self->priv->pixels_length1;
#line 134 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (_tmp20_ != NULL);
#line 137 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp21_ = self->priv->depth;
#line 137 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp21_ == 1) {
#line 605 "page.c"
		guchar* _tmp22_;
		gint _tmp22__length1;
		gint _tmp23_;
		gint _tmp24_;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp22_ = self->priv->pixels;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp22__length1 = self->priv->pixels_length1;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp23_ = self->priv->n_rows;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp24_ = self->priv->rowstride;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		memset (_tmp22_, 0x00, (gsize) (_tmp23_ * _tmp24_));
#line 620 "page.c"
	} else {
		guchar* _tmp25_;
		gint _tmp25__length1;
		gint _tmp26_;
		gint _tmp27_;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp25_ = self->priv->pixels;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp25__length1 = self->priv->pixels_length1;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_ = self->priv->n_rows;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp27_ = self->priv->rowstride;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		memset (_tmp25_, 0xFF, (gsize) (_tmp26_ * _tmp27_));
#line 636 "page.c"
	}
#line 142 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 143 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "pixels-changed");
#line 642 "page.c"
}


void page_start (Page* self) {
#line 146 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->scanning = TRUE;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 653 "page.c"
}


gboolean page_is_scanning (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 154 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->scanning;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 668 "page.c"
}


gboolean page_has_data (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->has_data_;
#line 159 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 159 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 683 "page.c"
}


gboolean page_is_color (Page* self) {
	gboolean result = FALSE;
	gint _tmp0_;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->n_channels;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_ > 1;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 698 "page.c"
}


gint page_get_scan_line (Page* self) {
	gint result = 0;
	gint _tmp0_;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->scan_line;
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 713 "page.c"
}


static void page_parse_line (Page* self, ScanLine* line, gint n, gboolean* size_changed) {
	gboolean _vala_size_changed = FALSE;
	gint line_number = 0;
	ScanLine* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp13_;
	gint _tmp14_;
	gint offset;
	gint _tmp15_;
	ScanLine* _tmp16_;
	gint _tmp17_;
	gint line_offset;
	gint _tmp33_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (line != NULL);
#line 176 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = line;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = _tmp0_->number;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = n;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	line_number = _tmp1_ + _tmp2_;
#line 179 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_vala_size_changed = FALSE;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	while (TRUE) {
#line 747 "page.c"
		gint _tmp3_;
		gint _tmp4_ = 0;
		gint rows = 0;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_ = 0;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp3_ = line_number;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp4_ = page_get_scan_height (self);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (!(_tmp3_ >= _tmp4_)) {
#line 180 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 767 "page.c"
		}
#line 185 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp5_ = self->priv->n_rows;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		rows = _tmp5_;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp6_ = rows;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp7_ = self->priv->width;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->n_rows = _tmp6_ + (_tmp7_ / 2);
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp8_ = rows;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp9_ = self->priv->n_rows;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_debug ("page.vala:187: Extending image from %d lines to %d lines", _tmp8_, _tmp9_);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp10_ = self->priv->n_rows;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp11_ = self->priv->rowstride;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp12_ = _tmp10_ * _tmp11_;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp10_ * _tmp11_);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		(_tmp12_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp12_ - self->priv->pixels_length1)) : NULL;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->pixels_length1 = _tmp12_;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->_pixels_size_ = _tmp12_;
#line 190 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_vala_size_changed = TRUE;
#line 801 "page.c"
	}
#line 194 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp13_ = line_number;
#line 194 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp14_ = self->priv->rowstride;
#line 194 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	offset = _tmp13_ * _tmp14_;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp15_ = n;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp16_ = line;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp17_ = _tmp16_->data_length;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	line_offset = _tmp15_ * _tmp17_;
#line 817 "page.c"
	{
		gint i;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		i = 0;
#line 822 "page.c"
		{
			gboolean _tmp18_;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp18_ = TRUE;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			while (TRUE) {
#line 829 "page.c"
				gboolean _tmp19_;
				gint _tmp21_;
				ScanLine* _tmp22_;
				gint _tmp23_;
				guchar* _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				gint _tmp26_;
				ScanLine* _tmp27_;
				guchar* _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				gint _tmp30_;
				guchar _tmp31_;
				guchar _tmp32_;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp19_ = _tmp18_;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (!_tmp19_) {
#line 849 "page.c"
					gint _tmp20_;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp20_ = i;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					i = _tmp20_ + 1;
#line 855 "page.c"
				}
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp18_ = FALSE;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp21_ = i;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp22_ = line;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp23_ = _tmp22_->data_length;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (!(_tmp21_ < _tmp23_)) {
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					break;
#line 869 "page.c"
				}
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp24_ = self->priv->pixels;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp24__length1 = self->priv->pixels_length1;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp25_ = offset;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp26_ = i;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp27_ = line;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp28_ = _tmp27_->data;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp28__length1 = _tmp27_->data_length1;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp29_ = line_offset;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp30_ = i;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp31_ = _tmp28_[_tmp29_ + _tmp30_];
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp24_[_tmp25_ + _tmp26_] = _tmp31_;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp32_ = _tmp24_[_tmp25_ + _tmp26_];
#line 895 "page.c"
			}
		}
	}
#line 199 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp33_ = line_number;
#line 199 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->scan_line = _tmp33_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (size_changed) {
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*size_changed = _vala_size_changed;
#line 907 "page.c"
	}
}


void page_parse_scan_line (Page* self, ScanLine* line) {
	gboolean size_has_changed;
	gboolean _tmp9_;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (line != NULL);
#line 204 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	size_has_changed = FALSE;
#line 921 "page.c"
	{
		gint i;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		i = 0;
#line 926 "page.c"
		{
			gboolean _tmp0_;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp0_ = TRUE;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			while (TRUE) {
#line 933 "page.c"
				gboolean _tmp1_;
				gint _tmp3_;
				ScanLine* _tmp4_;
				gint _tmp5_;
				ScanLine* _tmp6_;
				gint _tmp7_;
				gboolean _tmp8_ = FALSE;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp1_ = _tmp0_;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (!_tmp1_) {
#line 945 "page.c"
					gint _tmp2_;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp2_ = i;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					i = _tmp2_ + 1;
#line 951 "page.c"
				}
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp0_ = FALSE;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp3_ = i;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp4_ = line;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp5_ = _tmp4_->n_lines;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (!(_tmp3_ < _tmp5_)) {
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					break;
#line 965 "page.c"
				}
#line 206 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp6_ = line;
#line 206 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp7_ = i;
#line 206 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				page_parse_line (self, _tmp6_, _tmp7_, &_tmp8_);
#line 206 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				size_has_changed = _tmp8_;
#line 975 "page.c"
			}
		}
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->has_data_ = TRUE;
#line 210 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp9_ = size_has_changed;
#line 210 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp9_) {
#line 211 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 987 "page.c"
	}
#line 212 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 213 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "pixels-changed");
#line 993 "page.c"
}


void page_finish (Page* self) {
	gboolean size_has_changed;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp12_;
#line 216 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 218 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	size_has_changed = FALSE;
#line 221 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = self->priv->expected_rows;
#line 221 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp1_ < 0) {
#line 1011 "page.c"
		gint _tmp2_;
		gint _tmp3_ = 0;
#line 222 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp2_ = self->priv->scan_line;
#line 222 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp3_ = page_get_scan_height (self);
#line 222 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = _tmp2_ != _tmp3_;
#line 1020 "page.c"
	} else {
#line 221 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = FALSE;
#line 1024 "page.c"
	}
#line 221 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = _tmp0_;
#line 221 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp4_) {
#line 1030 "page.c"
		gint rows = 0;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_ = 0;
		gint _tmp10_;
		gint _tmp11_;
#line 226 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp5_ = self->priv->n_rows;
#line 226 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		rows = _tmp5_;
#line 227 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp6_ = self->priv->scan_line;
#line 227 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->n_rows = _tmp6_;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp7_ = self->priv->n_rows;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp8_ = self->priv->rowstride;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp9_ = _tmp7_ * _tmp8_;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp7_ * _tmp8_);
#line 228 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		(_tmp9_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp9_ - self->priv->pixels_length1)) : NULL;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->pixels_length1 = _tmp9_;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->_pixels_size_ = _tmp9_;
#line 229 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp10_ = rows;
#line 229 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp11_ = self->priv->n_rows;
#line 229 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_debug ("page.vala:229: Trimming page from %d lines to %d lines", _tmp10_, _tmp11_);
#line 231 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		size_has_changed = TRUE;
#line 1069 "page.c"
	}
#line 233 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->scanning = FALSE;
#line 235 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp12_ = size_has_changed;
#line 235 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp12_) {
#line 236 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 1079 "page.c"
	}
#line 237 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 238 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "scan-finished");
#line 1085 "page.c"
}


ScanDirection page_get_scan_direction (Page* self) {
	ScanDirection result = 0;
	ScanDirection _tmp0_;
#line 241 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->scan_direction;
#line 243 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 243 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1100 "page.c"
}


static void page_set_scan_direction (Page* self, ScanDirection direction) {
	gint left_steps = 0;
	gint t = 0;
	gboolean size_has_changed;
	gint width = 0;
	gint height = 0;
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
	ScanDirection _tmp3_;
	gint _tmp4_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_;
	ScanDirection _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
#line 246 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 249 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	size_has_changed = FALSE;
#line 252 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->scan_direction;
#line 252 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = direction;
#line 252 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp0_ == _tmp1_) {
#line 253 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return;
#line 1134 "page.c"
	}
#line 256 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = direction;
#line 256 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = self->priv->scan_direction;
#line 256 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	left_steps = (gint) (_tmp2_ - _tmp3_);
#line 257 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = left_steps;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp4_ < 0) {
#line 1146 "page.c"
		gint _tmp5_;
#line 258 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp5_ = left_steps;
#line 258 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		left_steps = _tmp5_ + 4;
#line 1152 "page.c"
	}
#line 259 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp6_ = left_steps;
#line 259 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp6_ != 2) {
#line 260 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		size_has_changed = TRUE;
#line 1160 "page.c"
	}
#line 262 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7_ = page_get_width (self);
#line 262 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	width = _tmp7_;
#line 263 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp8_ = page_get_height (self);
#line 263 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	height = _tmp8_;
#line 266 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp9_ = self->priv->has_crop_;
#line 266 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp9_) {
#line 1174 "page.c"
		gint _tmp10_;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp10_ = left_steps;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		switch (_tmp10_) {
#line 268 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			case 1:
#line 1182 "page.c"
			{
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
#line 272 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp11_ = self->priv->crop_x;
#line 272 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				t = _tmp11_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp12_ = self->priv->crop_y;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_x = _tmp12_;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp13_ = width;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp14_ = t;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp15_ = self->priv->crop_width;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_y = _tmp13_ - (_tmp14_ + _tmp15_);
#line 275 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp16_ = self->priv->crop_width;
#line 275 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				t = _tmp16_;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp17_ = self->priv->crop_height;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_width = _tmp17_;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp18_ = t;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_height = _tmp18_;
#line 278 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1222 "page.c"
			}
#line 268 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			case 2:
#line 1226 "page.c"
			{
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp19_ = width;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp20_ = self->priv->crop_x;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp21_ = self->priv->crop_width;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_x = _tmp19_ - (_tmp20_ + _tmp21_);
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp22_ = width;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp23_ = self->priv->crop_y;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp24_ = self->priv->crop_height;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_y = _tmp22_ - (_tmp23_ + _tmp24_);
#line 283 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1252 "page.c"
			}
#line 268 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			case 3:
#line 1256 "page.c"
			{
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp25_ = self->priv->crop_y;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				t = _tmp25_;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp26_ = self->priv->crop_x;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_y = _tmp26_;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp27_ = height;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp28_ = t;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp29_ = self->priv->crop_height;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_x = _tmp27_ - (_tmp28_ + _tmp29_);
#line 289 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp30_ = self->priv->crop_width;
#line 289 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				t = _tmp30_;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp31_ = self->priv->crop_height;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_width = _tmp31_;
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp32_ = t;
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				self->priv->crop_height = _tmp32_;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1296 "page.c"
			}
			default:
#line 268 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1301 "page.c"
		}
	}
#line 296 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp33_ = direction;
#line 296 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->scan_direction = _tmp33_;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp34_ = size_has_changed;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp34_) {
#line 298 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 1314 "page.c"
	}
#line 299 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "scan-direction-changed");
#line 300 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp35_ = self->priv->has_crop_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp35_) {
#line 301 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_signal_emit_by_name (self, "crop-changed");
#line 1324 "page.c"
	}
}


void page_rotate_left (Page* self) {
	ScanDirection _tmp0_;
	ScanDirection direction;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 306 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->scan_direction;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	direction = _tmp0_;
#line 307 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = direction;
#line 307 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	switch (_tmp1_) {
#line 307 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1346 "page.c"
		{
#line 310 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1352 "page.c"
		}
#line 307 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1356 "page.c"
		{
#line 313 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1362 "page.c"
		}
#line 307 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1366 "page.c"
		{
#line 316 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1372 "page.c"
		}
#line 307 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1376 "page.c"
		{
#line 319 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1382 "page.c"
		}
		default:
#line 307 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		break;
#line 1387 "page.c"
	}
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = direction;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	page_set_scan_direction (self, _tmp2_);
#line 1393 "page.c"
}


void page_rotate_right (Page* self) {
	ScanDirection _tmp0_;
	ScanDirection direction;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->scan_direction;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	direction = _tmp0_;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = direction;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	switch (_tmp1_) {
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1414 "page.c"
		{
#line 331 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 332 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1420 "page.c"
		}
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1424 "page.c"
		{
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 335 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1430 "page.c"
		}
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1434 "page.c"
		{
#line 337 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1440 "page.c"
		}
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1444 "page.c"
		{
#line 340 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 341 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 1450 "page.c"
		}
		default:
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		break;
#line 1455 "page.c"
	}
#line 343 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = direction;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	page_set_scan_direction (self, _tmp2_);
#line 1461 "page.c"
}


gint page_get_dpi (Page* self) {
	gint result = 0;
	gint _tmp0_;
#line 346 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 348 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->dpi;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1476 "page.c"
}


gboolean page_is_landscape (Page* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = page_get_width (self);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = page_get_height (self);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_ > _tmp1_;
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1494 "page.c"
}


gint page_get_width (Page* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	gboolean _tmp3_;
#line 356 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = self->priv->scan_direction;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = TRUE;
#line 1511 "page.c"
	} else {
		ScanDirection _tmp2_;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp2_ = self->priv->scan_direction;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 1518 "page.c"
	}
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = _tmp0_;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp3_) {
#line 1524 "page.c"
		gint _tmp4_;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp4_ = self->priv->width;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		result = _tmp4_;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return result;
#line 1532 "page.c"
	} else {
		gint _tmp5_;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp5_ = self->priv->n_rows;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		result = _tmp5_;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return result;
#line 1541 "page.c"
	}
}


gint page_get_height (Page* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	gboolean _tmp3_;
#line 364 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 366 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = self->priv->scan_direction;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 366 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = TRUE;
#line 1559 "page.c"
	} else {
		ScanDirection _tmp2_;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp2_ = self->priv->scan_direction;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 1566 "page.c"
	}
#line 366 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = _tmp0_;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp3_) {
#line 1572 "page.c"
		gint _tmp4_;
#line 367 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp4_ = self->priv->n_rows;
#line 367 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		result = _tmp4_;
#line 367 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return result;
#line 1580 "page.c"
	} else {
		gint _tmp5_;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp5_ = self->priv->width;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		result = _tmp5_;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return result;
#line 1589 "page.c"
	}
}


gint page_get_depth (Page* self) {
	gint result = 0;
	gint _tmp0_;
#line 372 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 374 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->depth;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1605 "page.c"
}


gint page_get_n_channels (Page* self) {
	gint result = 0;
	gint _tmp0_;
#line 377 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 379 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->n_channels;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1620 "page.c"
}


gint page_get_rowstride (Page* self) {
	gint result = 0;
	gint _tmp0_;
#line 382 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 384 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->rowstride;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1635 "page.c"
}


gint page_get_scan_width (Page* self) {
	gint result = 0;
	gint _tmp0_;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 389 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->width;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1650 "page.c"
}


gint page_get_scan_height (Page* self) {
	gint result = 0;
	gint _tmp0_;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 394 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->n_rows;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1665 "page.c"
}


void page_set_color_profile (Page* self, const gchar* color_profile) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = color_profile;
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (self->priv->color_profile);
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->color_profile = _tmp1_;
#line 1682 "page.c"
}


gchar* page_get_color_profile (Page* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 402 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->color_profile;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp1_;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 1700 "page.c"
}


void page_set_no_crop (Page* self) {
	gboolean _tmp0_;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 409 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->has_crop_;
#line 409 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (!_tmp0_) {
#line 410 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return;
#line 1714 "page.c"
	}
#line 411 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->has_crop_ = FALSE;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (self->priv->crop_name);
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_name = NULL;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_x = 0;
#line 414 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_y = 0;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_width = 0;
#line 416 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_height = 0;
#line 417 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1732 "page.c"
}


void page_set_custom_crop (Page* self, gint width, gint height) {
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 424 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = width;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (_tmp0_ >= 1);
#line 425 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = height;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (_tmp1_ >= 1);
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp5_ = self->priv->crop_name;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp5_ == NULL) {
#line 1762 "page.c"
		gboolean _tmp6_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp6_ = self->priv->has_crop_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp4_ = _tmp6_;
#line 1768 "page.c"
	} else {
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp4_ = FALSE;
#line 1772 "page.c"
	}
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7_ = _tmp4_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp7_) {
#line 1778 "page.c"
		gint _tmp8_;
		gint _tmp9_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp8_ = self->priv->crop_width;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp9_ = width;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp3_ = _tmp8_ == _tmp9_;
#line 1787 "page.c"
	} else {
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp3_ = FALSE;
#line 1791 "page.c"
	}
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp10_ = _tmp3_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp10_) {
#line 1797 "page.c"
		gint _tmp11_;
		gint _tmp12_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp11_ = self->priv->crop_height;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp12_ = height;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp2_ = _tmp11_ == _tmp12_;
#line 1806 "page.c"
	} else {
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp2_ = FALSE;
#line 1810 "page.c"
	}
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp13_ = _tmp2_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp13_) {
#line 428 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return;
#line 1818 "page.c"
	}
#line 429 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (self->priv->crop_name);
#line 429 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_name = NULL;
#line 430 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->has_crop_ = TRUE;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp14_ = width;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_width = _tmp14_;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp15_ = height;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_height = _tmp15_;
#line 446 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1836 "page.c"
}


void page_set_named_crop (Page* self, const gchar* name) {
	gdouble width = 0.0;
	gdouble height = 0.0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	static GQuark _tmp2_label0 = 0;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	static GQuark _tmp2_label1 = 0;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	static GQuark _tmp2_label2 = 0;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	static GQuark _tmp2_label3 = 0;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	static GQuark _tmp2_label4 = 0;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	static GQuark _tmp2_label5 = 0;
#line 1858 "page.c"
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_ = 0;
	gint pw;
	gint _tmp8_ = 0;
	gint ph;
	gint _tmp9_;
	gint _tmp10_;
	gdouble _tmp14_;
	gint _tmp15_;
	gdouble _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp22_;
	gint _tmp23_;
#line 449 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 449 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (name != NULL);
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = name;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = _tmp0_;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("A4")))) {
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		switch (0) {
#line 1889 "page.c"
			default:
			{
#line 455 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				width = 8.3;
#line 456 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				height = 11.7;
#line 457 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1898 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("A5")))) {
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		switch (0) {
#line 1904 "page.c"
			default:
			{
#line 459 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				width = 5.8;
#line 460 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				height = 8.3;
#line 461 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1913 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("A6")))) {
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		switch (0) {
#line 1919 "page.c"
			default:
			{
#line 463 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				width = 4.1;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				height = 5.8;
#line 465 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1928 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("letter")))) {
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		switch (0) {
#line 1934 "page.c"
			default:
			{
#line 467 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				width = 8.5;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				height = (gdouble) 11;
#line 469 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1943 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("legal")))) {
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		switch (0) {
#line 1949 "page.c"
			default:
			{
#line 471 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				width = 8.5;
#line 472 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				height = (gdouble) 14;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1958 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("4x6")))) {
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		switch (0) {
#line 1964 "page.c"
			default:
			{
#line 475 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				width = (gdouble) 4;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				height = (gdouble) 6;
#line 477 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				break;
#line 1973 "page.c"
			}
		}
	} else {
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		switch (0) {
#line 1979 "page.c"
			default:
			{
				const gchar* _tmp4_;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp4_ = name;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				g_warning ("page.vala:479: Unknown paper size '%s'", _tmp4_);
#line 480 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				return;
#line 1989 "page.c"
			}
		}
	}
#line 483 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp5_ = name;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 483 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (self->priv->crop_name);
#line 483 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_name = _tmp6_;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->has_crop_ = TRUE;
#line 486 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7_ = page_get_width (self);
#line 486 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	pw = _tmp7_;
#line 487 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp8_ = page_get_height (self);
#line 487 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	ph = _tmp8_;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp9_ = pw;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp10_ = ph;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp9_ > _tmp10_) {
#line 2017 "page.c"
		gdouble t = 0.0;
		gdouble _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp11_ = width;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		t = _tmp11_;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp12_ = height;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		width = _tmp12_;
#line 495 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp13_ = t;
#line 495 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		height = _tmp13_;
#line 2034 "page.c"
	}
#line 499 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp14_ = width;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp15_ = self->priv->dpi;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_width = (gint) ((_tmp14_ * _tmp15_) + 0.5);
#line 500 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp16_ = height;
#line 500 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp17_ = self->priv->dpi;
#line 500 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_height = (gint) ((_tmp16_ * _tmp17_) + 0.5);
#line 502 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp18_ = self->priv->crop_width;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp19_ = pw;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp18_ < _tmp19_) {
#line 2054 "page.c"
		gint _tmp20_;
		gint _tmp21_;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp20_ = pw;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp21_ = self->priv->crop_width;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->crop_x = (_tmp20_ - _tmp21_) / 2;
#line 2063 "page.c"
	} else {
#line 505 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->crop_x = 0;
#line 2067 "page.c"
	}
#line 506 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp22_ = self->priv->crop_height;
#line 506 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp23_ = ph;
#line 506 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp22_ < _tmp23_) {
#line 2075 "page.c"
		gint _tmp24_;
		gint _tmp25_;
#line 507 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp24_ = ph;
#line 507 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp25_ = self->priv->crop_height;
#line 507 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->crop_y = (_tmp24_ - _tmp25_) / 2;
#line 2084 "page.c"
	} else {
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		self->priv->crop_y = 0;
#line 2088 "page.c"
	}
#line 510 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 2092 "page.c"
}


void page_move_crop (Page* self, gint x, gint y) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	gint _tmp7_;
#line 513 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 515 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = x;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (_tmp0_ >= 0);
#line 516 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = y;
#line 516 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (_tmp1_ >= 0);
#line 517 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = x;
#line 517 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = page_get_width (self);
#line 517 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (_tmp2_ < _tmp3_);
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = y;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp5_ = page_get_height (self);
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (_tmp4_ < _tmp5_);
#line 520 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp6_ = x;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_x = _tmp6_;
#line 521 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7_ = y;
#line 521 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_y = _tmp7_;
#line 522 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 2137 "page.c"
}


void page_rotate_crop (Page* self) {
	gint t = 0;
	gboolean _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
#line 525 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 529 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->has_crop_;
#line 529 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (!_tmp0_) {
#line 530 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return;
#line 2156 "page.c"
	}
#line 532 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = self->priv->crop_width;
#line 532 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	t = _tmp1_;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = self->priv->crop_height;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_width = _tmp2_;
#line 534 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = t;
#line 534 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->crop_height = _tmp3_;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = self->priv->crop_name;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp4_ == NULL) {
#line 2174 "page.c"
		gint w = 0;
		gint h = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp12_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp19_;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp5_ = page_get_width (self);
#line 541 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		w = _tmp5_;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp6_ = page_get_height (self);
#line 542 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		h = _tmp6_;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp7_ = self->priv->crop_x;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp8_ = self->priv->crop_width;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp9_ = w;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if ((_tmp7_ + _tmp8_) > _tmp9_) {
#line 2203 "page.c"
			gint _tmp10_;
			gint _tmp11_;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp10_ = w;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp11_ = self->priv->crop_width;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			self->priv->crop_x = _tmp10_ - _tmp11_;
#line 2212 "page.c"
		}
#line 546 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp12_ = self->priv->crop_x;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp12_ < 0) {
#line 2218 "page.c"
			gint _tmp13_;
#line 548 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			self->priv->crop_x = 0;
#line 549 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp13_ = w;
#line 549 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			self->priv->crop_width = _tmp13_;
#line 2226 "page.c"
		}
#line 551 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp14_ = self->priv->crop_y;
#line 551 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp15_ = self->priv->crop_height;
#line 551 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_ = h;
#line 551 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if ((_tmp14_ + _tmp15_) > _tmp16_) {
#line 2236 "page.c"
			gint _tmp17_;
			gint _tmp18_;
#line 552 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp17_ = h;
#line 552 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp18_ = self->priv->crop_height;
#line 552 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			self->priv->crop_y = _tmp17_ - _tmp18_;
#line 2245 "page.c"
		}
#line 553 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp19_ = self->priv->crop_y;
#line 553 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp19_ < 0) {
#line 2251 "page.c"
			gint _tmp20_;
#line 555 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			self->priv->crop_y = 0;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp20_ = h;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			self->priv->crop_height = _tmp20_;
#line 2259 "page.c"
		}
	}
#line 560 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 2264 "page.c"
}


gboolean page_has_crop (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 563 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 565 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->has_crop_;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp0_;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 2279 "page.c"
}


void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 570 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->crop_x;
#line 570 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_vala_x = _tmp0_;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = self->priv->crop_y;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_vala_y = _tmp1_;
#line 572 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = self->priv->crop_width;
#line 572 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_vala_width = _tmp2_;
#line 573 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = self->priv->crop_height;
#line 573 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_vala_height = _tmp3_;
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (x) {
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*x = _vala_x;
#line 2314 "page.c"
	}
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (y) {
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*y = _vala_y;
#line 2320 "page.c"
	}
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (width) {
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*width = _vala_width;
#line 2326 "page.c"
	}
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (height) {
#line 568 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*height = _vala_height;
#line 2332 "page.c"
	}
}


gchar* page_get_named_crop (Page* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 576 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 578 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->crop_name;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 578 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp1_;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 2351 "page.c"
}


guchar* page_get_pixels (Page* self, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 583 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->priv->pixels;
#line 583 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0__length1 = self->priv->pixels_length1;
#line 583 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = _tmp0_;
#line 583 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1__length1 = _tmp0__length1;
#line 583 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (result_length1) {
#line 583 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*result_length1 = _tmp1__length1;
#line 2375 "page.c"
	}
#line 583 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp1_;
#line 583 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 2381 "page.c"
}


static guchar page_get_sample (Page* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint n_channels, gint channel) {
	guchar result = '\0';
#line 587 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 590 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = (guchar) 0xFF;
#line 590 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 2393 "page.c"
}


static void page_get_pixel (Page* self, gint x, gint y, guchar* pixel, int pixel_length1, gint offset) {
	ScanDirection _tmp0_ = 0;
	gint _tmp13_ = 0;
	gint depth;
	gint _tmp14_ = 0;
	gint n_channels;
	gint _tmp15_ = 0;
	gint _tmp16_;
	gint line_offset;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_;
	gboolean _tmp20_;
	guchar* _tmp104_;
	gint _tmp104__length1;
	gint _tmp105_;
	guchar* _tmp106_;
	gint _tmp106__length1;
	gint _tmp107_;
	gint _tmp108_;
	gint _tmp109_;
	gint _tmp110_;
	guchar _tmp111_ = '\0';
	guchar _tmp112_;
	guchar* _tmp113_;
	gint _tmp113__length1;
	gint _tmp114_;
	guchar* _tmp115_;
	gint _tmp115__length1;
	gint _tmp116_;
	gint _tmp117_;
	gint _tmp118_;
	gint _tmp119_;
	guchar _tmp120_ = '\0';
	guchar _tmp121_;
	guchar* _tmp122_;
	gint _tmp122__length1;
	gint _tmp123_;
	guchar* _tmp124_;
	gint _tmp124__length1;
	gint _tmp125_;
	gint _tmp126_;
	gint _tmp127_;
	gint _tmp128_;
	guchar _tmp129_ = '\0';
	guchar _tmp130_;
#line 594 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = page_get_scan_direction (self);
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	switch (_tmp0_) {
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 2450 "page.c"
		{
#line 599 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 2454 "page.c"
		}
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 2458 "page.c"
		{
			gint _tmp1_ = 0;
			gint _tmp2_;
			gint _tmp3_ = 0;
			gint _tmp4_;
#line 601 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp1_ = page_get_scan_width (self);
#line 601 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp2_ = x;
#line 601 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			x = (_tmp1_ - _tmp2_) - 1;
#line 602 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp3_ = page_get_scan_height (self);
#line 602 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp4_ = y;
#line 602 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			y = (_tmp3_ - _tmp4_) - 1;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 2478 "page.c"
		}
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 2482 "page.c"
		{
			gint _tmp5_;
			gint t;
			gint _tmp6_ = 0;
			gint _tmp7_;
			gint _tmp8_;
#line 605 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp5_ = x;
#line 605 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			t = _tmp5_;
#line 606 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp6_ = page_get_scan_width (self);
#line 606 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp7_ = y;
#line 606 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			x = (_tmp6_ - _tmp7_) - 1;
#line 607 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp8_ = t;
#line 607 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			y = _tmp8_;
#line 608 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 2505 "page.c"
		}
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 2509 "page.c"
		{
			gint _tmp9_;
			gint t;
			gint _tmp10_;
			gint _tmp11_ = 0;
			gint _tmp12_;
#line 610 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp9_ = x;
#line 610 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			t = _tmp9_;
#line 611 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp10_ = y;
#line 611 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			x = _tmp10_;
#line 612 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp11_ = page_get_scan_height (self);
#line 612 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp12_ = t;
#line 612 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			y = (_tmp11_ - _tmp12_) - 1;
#line 613 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			break;
#line 2532 "page.c"
		}
		default:
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		break;
#line 2537 "page.c"
	}
#line 616 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp13_ = page_get_depth (self);
#line 616 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	depth = _tmp13_;
#line 617 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp14_ = page_get_n_channels (self);
#line 617 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	n_channels = _tmp14_;
#line 618 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp15_ = page_get_rowstride (self);
#line 618 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp16_ = y;
#line 618 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	line_offset = _tmp15_ * _tmp16_;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp18_ = depth;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp18_ == 8) {
#line 2557 "page.c"
		gint _tmp19_;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp19_ = n_channels;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp17_ = _tmp19_ == 3;
#line 2563 "page.c"
	} else {
#line 621 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp17_ = FALSE;
#line 2567 "page.c"
	}
#line 621 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp20_ = _tmp17_;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp20_) {
#line 2573 "page.c"
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint o;
		guchar* _tmp24_;
		gint _tmp24__length1;
		gint _tmp25_;
		guchar* _tmp26_;
		gint _tmp26__length1;
		gint _tmp27_;
		guchar _tmp28_;
		guchar _tmp29_;
		guchar* _tmp30_;
		gint _tmp30__length1;
		gint _tmp31_;
		guchar* _tmp32_;
		gint _tmp32__length1;
		gint _tmp33_;
		guchar _tmp34_;
		guchar _tmp35_;
		guchar* _tmp36_;
		gint _tmp36__length1;
		gint _tmp37_;
		guchar* _tmp38_;
		gint _tmp38__length1;
		gint _tmp39_;
		guchar _tmp40_;
		guchar _tmp41_;
#line 623 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp21_ = line_offset;
#line 623 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp22_ = x;
#line 623 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp23_ = n_channels;
#line 623 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		o = _tmp21_ + (_tmp22_ * _tmp23_);
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp24_ = pixel;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp24__length1 = pixel_length1;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp25_ = offset;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_ = self->priv->pixels;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26__length1 = self->priv->pixels_length1;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp27_ = o;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp28_ = _tmp26_[_tmp27_];
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp24_[_tmp25_ + 0] = _tmp28_;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp29_ = _tmp24_[_tmp25_ + 0];
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp30_ = pixel;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp30__length1 = pixel_length1;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp31_ = offset;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp32_ = self->priv->pixels;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp32__length1 = self->priv->pixels_length1;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp33_ = o;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp34_ = _tmp32_[_tmp33_ + 1];
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp30_[_tmp31_ + 1] = _tmp34_;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp35_ = _tmp30_[_tmp31_ + 1];
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp36_ = pixel;
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp36__length1 = pixel_length1;
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp37_ = offset;
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp38_ = self->priv->pixels;
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp38__length1 = self->priv->pixels_length1;
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp39_ = o;
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp40_ = _tmp38_[_tmp39_ + 2];
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp36_[_tmp37_ + 2] = _tmp40_;
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp41_ = _tmp36_[_tmp37_ + 2];
#line 627 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return;
#line 2666 "page.c"
	} else {
		gboolean _tmp42_ = FALSE;
		gint _tmp43_;
		gboolean _tmp45_;
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp43_ = depth;
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp43_ == 8) {
#line 2675 "page.c"
			gint _tmp44_;
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp44_ = n_channels;
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp42_ = _tmp44_ == 1;
#line 2681 "page.c"
		} else {
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp42_ = FALSE;
#line 2685 "page.c"
		}
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp45_ = _tmp42_;
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp45_) {
#line 2691 "page.c"
			guchar* _tmp46_;
			gint _tmp46__length1;
			gint _tmp47_;
			gint _tmp48_;
			guchar _tmp49_;
			guchar p;
			guchar* _tmp50_;
			gint _tmp50__length1;
			gint _tmp51_;
			guchar* _tmp52_;
			gint _tmp52__length1;
			gint _tmp53_;
			guchar* _tmp54_;
			gint _tmp54__length1;
			gint _tmp55_;
			guchar _tmp56_;
			guchar _tmp57_;
			guchar _tmp58_;
			guchar _tmp59_;
#line 631 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp46_ = self->priv->pixels;
#line 631 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp46__length1 = self->priv->pixels_length1;
#line 631 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp47_ = line_offset;
#line 631 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp48_ = x;
#line 631 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp49_ = _tmp46_[_tmp47_ + _tmp48_];
#line 631 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			p = _tmp49_;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp50_ = pixel;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp50__length1 = pixel_length1;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp51_ = offset;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp52_ = pixel;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp52__length1 = pixel_length1;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp53_ = offset;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp54_ = pixel;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp54__length1 = pixel_length1;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp55_ = offset;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp56_ = p;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp54_[_tmp55_ + 2] = _tmp56_;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp57_ = _tmp54_[_tmp55_ + 2];
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp52_[_tmp53_ + 1] = _tmp57_;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp58_ = _tmp52_[_tmp53_ + 1];
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp50_[_tmp51_ + 0] = _tmp58_;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp59_ = _tmp50_[_tmp51_ + 0];
#line 633 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			return;
#line 2757 "page.c"
		} else {
			gboolean _tmp60_ = FALSE;
			gint _tmp61_;
			gboolean _tmp63_;
#line 637 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp61_ = depth;
#line 637 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			if (_tmp61_ == 1) {
#line 2766 "page.c"
				gint _tmp62_;
#line 637 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp62_ = n_channels;
#line 637 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp60_ = _tmp62_ == 1;
#line 2772 "page.c"
			} else {
#line 637 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp60_ = FALSE;
#line 2776 "page.c"
			}
#line 637 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp63_ = _tmp60_;
#line 637 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			if (_tmp63_) {
#line 2782 "page.c"
				guchar* _tmp64_;
				gint _tmp64__length1;
				gint _tmp65_;
				gint _tmp66_;
				guchar _tmp67_;
				guchar p;
				gint _tmp68_ = 0;
				guchar _tmp69_;
				gint _tmp70_;
				guchar* _tmp71_;
				gint _tmp71__length1;
				gint _tmp72_;
				guchar* _tmp73_;
				gint _tmp73__length1;
				gint _tmp74_;
				guchar* _tmp75_;
				gint _tmp75__length1;
				gint _tmp76_;
				gint _tmp77_;
				guchar _tmp78_;
				guchar _tmp79_;
				guchar _tmp80_;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp64_ = self->priv->pixels;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp64__length1 = self->priv->pixels_length1;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp65_ = line_offset;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp66_ = x;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp67_ = _tmp64_[_tmp65_ + (_tmp66_ / 8)];
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				p = _tmp67_;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp69_ = p;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp70_ = x;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (((gint) (_tmp69_ & (0x80 >> (_tmp70_ % 8)))) != 0) {
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp68_ = 0x00;
#line 2825 "page.c"
				} else {
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp68_ = 0xFF;
#line 2829 "page.c"
				}
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp71_ = pixel;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp71__length1 = pixel_length1;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp72_ = offset;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp73_ = pixel;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp73__length1 = pixel_length1;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp74_ = offset;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp75_ = pixel;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp75__length1 = pixel_length1;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp76_ = offset;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp77_ = _tmp68_;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp75_[_tmp76_ + 2] = (guchar) _tmp77_;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp78_ = _tmp75_[_tmp76_ + 2];
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp73_[_tmp74_ + 1] = _tmp78_;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp79_ = _tmp73_[_tmp74_ + 1];
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp71_[_tmp72_ + 0] = _tmp79_;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp80_ = _tmp71_[_tmp72_ + 0];
#line 641 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				return;
#line 2865 "page.c"
			} else {
				gboolean _tmp81_ = FALSE;
				gint _tmp82_;
				gboolean _tmp84_;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp82_ = depth;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (_tmp82_ == 2) {
#line 2874 "page.c"
					gint _tmp83_;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp83_ = n_channels;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp81_ = _tmp83_ == 1;
#line 2880 "page.c"
				} else {
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp81_ = FALSE;
#line 2884 "page.c"
				}
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp84_ = _tmp81_;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (_tmp84_) {
#line 2890 "page.c"
					gint _tmp85_[4] = {0};
					gint block_shift[4];
					guchar* _tmp86_;
					gint _tmp86__length1;
					gint _tmp87_;
					gint _tmp88_;
					guchar _tmp89_;
					guchar p;
					guchar _tmp90_;
					gint _tmp91_;
					gint _tmp92_;
					gint sample;
					gint _tmp93_;
					guchar* _tmp94_;
					gint _tmp94__length1;
					gint _tmp95_;
					guchar* _tmp96_;
					gint _tmp96__length1;
					gint _tmp97_;
					guchar* _tmp98_;
					gint _tmp98__length1;
					gint _tmp99_;
					gint _tmp100_;
					guchar _tmp101_;
					guchar _tmp102_;
					guchar _tmp103_;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp85_[0] = 6;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp85_[1] = 4;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp85_[2] = 2;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp85_[3] = 0;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					memcpy (block_shift, _tmp85_, 4 * sizeof (gint));
#line 649 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp86_ = self->priv->pixels;
#line 649 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp86__length1 = self->priv->pixels_length1;
#line 649 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp87_ = line_offset;
#line 649 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp88_ = x;
#line 649 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp89_ = _tmp86_[_tmp87_ + (_tmp88_ / 4)];
#line 649 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					p = _tmp89_;
#line 650 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp90_ = p;
#line 650 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp91_ = x;
#line 650 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp92_ = block_shift[_tmp91_ % 4];
#line 650 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					sample = (_tmp90_ >> _tmp92_) & 0x3;
#line 651 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp93_ = sample;
#line 651 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					sample = (_tmp93_ * 255) / 3;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp94_ = pixel;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp94__length1 = pixel_length1;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp95_ = offset;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp96_ = pixel;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp96__length1 = pixel_length1;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp97_ = offset;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp98_ = pixel;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp98__length1 = pixel_length1;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp99_ = offset;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp100_ = sample;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp98_[_tmp99_ + 2] = (guchar) _tmp100_;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp101_ = _tmp98_[_tmp99_ + 2];
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp96_[_tmp97_ + 1] = _tmp101_;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp102_ = _tmp96_[_tmp97_ + 1];
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp94_[_tmp95_ + 0] = _tmp102_;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp103_ = _tmp94_[_tmp95_ + 0];
#line 654 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					return;
#line 2985 "page.c"
				}
			}
		}
	}
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp104_ = pixel;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp104__length1 = pixel_length1;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp105_ = offset;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp106_ = self->priv->pixels;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp106__length1 = self->priv->pixels_length1;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp107_ = line_offset;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp108_ = x;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp109_ = depth;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp110_ = n_channels;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp111_ = page_get_sample (self, _tmp106_, _tmp106__length1, _tmp107_, _tmp108_, _tmp109_, _tmp110_, 0);
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp104_[_tmp105_ + 0] = _tmp111_;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp112_ = _tmp104_[_tmp105_ + 0];
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp113_ = pixel;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp113__length1 = pixel_length1;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp114_ = offset;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp115_ = self->priv->pixels;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp115__length1 = self->priv->pixels_length1;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp116_ = line_offset;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp117_ = x;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp118_ = depth;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp119_ = n_channels;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp120_ = page_get_sample (self, _tmp115_, _tmp115__length1, _tmp116_, _tmp117_, _tmp118_, _tmp119_, 1);
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp113_[_tmp114_ + 1] = _tmp120_;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp121_ = _tmp113_[_tmp114_ + 1];
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp122_ = pixel;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp122__length1 = pixel_length1;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp123_ = offset;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp124_ = self->priv->pixels;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp124__length1 = self->priv->pixels_length1;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp125_ = line_offset;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp126_ = x;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp127_ = depth;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp128_ = n_channels;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp129_ = page_get_sample (self, _tmp124_, _tmp124__length1, _tmp125_, _tmp126_, _tmp127_, _tmp128_, 2);
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp122_[_tmp123_ + 2] = _tmp129_;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp130_ = _tmp122_[_tmp123_ + 2];
#line 3062 "page.c"
}


GdkPixbuf* page_get_image (Page* self, gboolean apply_crop) {
	GdkPixbuf* result = NULL;
	gint l = 0;
	gint r = 0;
	gint t = 0;
	gint b = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GdkPixbuf* _tmp24_;
	GdkPixbuf* image;
	GdkPixbuf* _tmp25_;
	guint8* _tmp26_ = NULL;
	guint8* image_pixels;
	gint image_pixels_length1;
	gint _image_pixels_size_;
#line 663 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 666 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = apply_crop;
#line 666 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp1_) {
#line 3092 "page.c"
		gboolean _tmp2_;
#line 666 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp2_ = self->priv->has_crop_;
#line 666 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = _tmp2_;
#line 3098 "page.c"
	} else {
#line 666 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = FALSE;
#line 3102 "page.c"
	}
#line 666 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = _tmp0_;
#line 666 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp3_) {
#line 3108 "page.c"
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_ = 0;
#line 668 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp4_ = self->priv->crop_x;
#line 668 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		l = _tmp4_;
#line 669 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp5_ = l;
#line 669 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp6_ = self->priv->crop_width;
#line 669 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		r = _tmp5_ + _tmp6_;
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp7_ = self->priv->crop_y;
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		t = _tmp7_;
#line 671 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp8_ = t;
#line 671 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp9_ = self->priv->crop_height;
#line 671 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		b = _tmp8_ + _tmp9_;
#line 673 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp10_ = l;
#line 673 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp10_ < 0) {
#line 674 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			l = 0;
#line 3147 "page.c"
		}
#line 675 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp11_ = r;
#line 675 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp12_ = page_get_width (self);
#line 675 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp11_ > _tmp12_) {
#line 3155 "page.c"
			gint _tmp13_ = 0;
#line 676 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp13_ = page_get_width (self);
#line 676 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			r = _tmp13_;
#line 3161 "page.c"
		}
#line 677 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp14_ = t;
#line 677 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp14_ < 0) {
#line 678 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			t = 0;
#line 3169 "page.c"
		}
#line 679 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp15_ = b;
#line 679 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_ = page_get_height (self);
#line 679 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp15_ > _tmp16_) {
#line 3177 "page.c"
			gint _tmp17_ = 0;
#line 680 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp17_ = page_get_height (self);
#line 680 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			b = _tmp17_;
#line 3183 "page.c"
		}
	} else {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
#line 684 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		l = 0;
#line 685 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp18_ = page_get_width (self);
#line 685 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		r = _tmp18_;
#line 686 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		t = 0;
#line 687 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp19_ = page_get_height (self);
#line 687 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		b = _tmp19_;
#line 3200 "page.c"
	}
#line 690 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp20_ = r;
#line 690 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp21_ = l;
#line 690 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp22_ = b;
#line 690 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp23_ = t;
#line 690 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp24_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp20_ - _tmp21_, _tmp22_ - _tmp23_);
#line 690 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	image = _tmp24_;
#line 691 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp25_ = image;
#line 691 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp26_ = gdk_pixbuf_get_pixels (_tmp25_);
#line 691 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	image_pixels = _tmp26_;
#line 691 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	image_pixels_length1 = -1;
#line 691 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_image_pixels_size_ = image_pixels_length1;
#line 3224 "page.c"
	{
		gint _tmp27_;
		gint y;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp27_ = t;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		y = _tmp27_;
#line 3232 "page.c"
		{
			gboolean _tmp28_;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp28_ = TRUE;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			while (TRUE) {
#line 3239 "page.c"
				gboolean _tmp29_;
				gint _tmp31_;
				gint _tmp32_;
				GdkPixbuf* _tmp33_;
				gint _tmp34_ = 0;
				gint _tmp35_;
				gint _tmp36_;
				gint offset;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp29_ = _tmp28_;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (!_tmp29_) {
#line 3252 "page.c"
					gint _tmp30_;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp30_ = y;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					y = _tmp30_ + 1;
#line 3258 "page.c"
				}
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp28_ = FALSE;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp31_ = y;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp32_ = b;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (!(_tmp31_ < _tmp32_)) {
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					break;
#line 3270 "page.c"
				}
#line 694 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp33_ = image;
#line 694 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp34_ = gdk_pixbuf_get_rowstride (_tmp33_);
#line 694 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp35_ = y;
#line 694 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp36_ = t;
#line 694 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				offset = _tmp34_ * (_tmp35_ - _tmp36_);
#line 3282 "page.c"
				{
					gint _tmp37_;
					gint x;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp37_ = l;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					x = _tmp37_;
#line 3290 "page.c"
					{
						gboolean _tmp38_;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
						_tmp38_ = TRUE;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
						while (TRUE) {
#line 3297 "page.c"
							gboolean _tmp39_;
							gint _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							guint8* _tmp45_;
							gint _tmp45__length1;
							gint _tmp46_;
							gint _tmp47_;
							gint _tmp48_;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp39_ = _tmp38_;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							if (!_tmp39_) {
#line 3312 "page.c"
								gint _tmp40_;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
								_tmp40_ = x;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
								x = _tmp40_ + 1;
#line 3318 "page.c"
							}
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp38_ = FALSE;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp41_ = x;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp42_ = r;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							if (!(_tmp41_ < _tmp42_)) {
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
								break;
#line 3330 "page.c"
							}
#line 696 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp43_ = x;
#line 696 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp44_ = y;
#line 696 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp45_ = image_pixels;
#line 696 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp45__length1 = image_pixels_length1;
#line 696 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp46_ = offset;
#line 696 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp47_ = x;
#line 696 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							_tmp48_ = l;
#line 696 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
							page_get_pixel (self, _tmp43_, _tmp44_, _tmp45_, _tmp45__length1, _tmp46_ + ((_tmp47_ - _tmp48_) * 3));
#line 3348 "page.c"
						}
					}
				}
			}
		}
	}
#line 699 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = image;
#line 699 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 3359 "page.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1267 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1269 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1269 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 3414 "page.c"
	}
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 3420 "page.c"
}


static gchar* page_get_icc_data_encoded (Page* self, const gchar* icc_profile_filename) {
	gchar* result = NULL;
	gchar* contents = NULL;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
#line 702 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 702 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (icc_profile_filename != NULL, NULL);
#line 3439 "page.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
#line 708 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp0_ = icc_profile_filename;
#line 708 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
#line 708 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_g_free0 (contents);
#line 708 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		contents = _tmp1_;
#line 708 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_inner_error_ != NULL) {
#line 3453 "page.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		e = _inner_error_;
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_inner_error_ = NULL;
#line 712 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp2_ = e;
#line 712 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp3_ = _tmp2_->message;
#line 712 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_warning ("page.vala:712: failed to get icc profile data: %s", _tmp3_);
#line 713 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		result = NULL;
#line 713 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_g_error_free0 (e);
#line 713 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_g_free0 (contents);
#line 713 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return result;
#line 3481 "page.c"
	}
	__finally3:
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_inner_error_ != NULL) {
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_g_free0 (contents);
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_clear_error (&_inner_error_);
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return NULL;
#line 3494 "page.c"
	}
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = contents;
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp6_ = string_to_utf8 (_tmp4_, &_tmp5_);
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7_ = (guchar*) _tmp6_;
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7__length1 = (_tmp5_ * sizeof (gchar)) / sizeof (guchar);
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp8_ = g_base64_encode (_tmp7_, (_tmp5_ * sizeof (gchar)) / sizeof (guchar));
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp9_ = _tmp8_;
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp7_ = (g_free (_tmp7_), NULL);
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = _tmp9_;
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (contents);
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 3516 "page.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 722 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return self ? g_object_ref (self) : NULL;
#line 3523 "page.c"
}


void page_copy_to_clipboard (Page* self, GtkWindow* window) {
	GtkWindow* _tmp0_;
	GdkDisplay* _tmp1_ = NULL;
	GdkDisplay* _tmp2_;
	GdkDisplay* display;
	GtkClipboard* _tmp3_ = NULL;
	GtkClipboard* _tmp4_;
	GtkClipboard* clipboard;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* image;
#line 720 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 720 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (window != NULL);
#line 722 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = window;
#line 722 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = gtk_widget_get_display ((GtkWidget*) _tmp0_);
#line 722 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 722 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	display = _tmp2_;
#line 723 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = gtk_clipboard_get_for_display (display, GDK_SELECTION_CLIPBOARD);
#line 723 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 723 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	clipboard = _tmp4_;
#line 724 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp5_ = page_get_image (self, TRUE);
#line 724 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	image = _tmp5_;
#line 725 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	gtk_clipboard_set_image (clipboard, image);
#line 720 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_object_unref0 (image);
#line 720 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_object_unref0 (clipboard);
#line 720 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_object_unref0 (display);
#line 3567 "page.c"
}


void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	GFileOutputStream* _tmp2_;
	PixbufWriter* _tmp3_;
	PixbufWriter* writer;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* image;
	gchar* icc_profile_data;
	const gchar* _tmp5_;
	GCompareFunc _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	GError * _inner_error_ = NULL;
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (type != NULL);
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (file != NULL);
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = file;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	stream = _tmp1_;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_inner_error_ != NULL) {
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return;
#line 3604 "page.c"
	}
#line 731 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = stream;
#line 731 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = pixbuf_writer_new (_tmp2_);
#line 731 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	writer = _tmp3_;
#line 732 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp4_ = page_get_image (self, TRUE);
#line 732 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	image = _tmp4_;
#line 734 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	icc_profile_data = NULL;
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp5_ = self->priv->color_profile;
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp5_ != NULL) {
#line 3622 "page.c"
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
#line 736 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp6_ = self->priv->color_profile;
#line 736 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp7_ = page_get_icc_data_encoded (self, _tmp6_);
#line 736 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_g_free0 (icc_profile_data);
#line 736 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		icc_profile_data = _tmp7_;
#line 3633 "page.c"
	}
#line 738 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp8_ = g_strcmp0;
#line 738 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp9_ = type;
#line 738 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp10_ = _tmp8_ (_tmp9_, "jpeg");
#line 738 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_tmp10_ == 0) {
#line 3643 "page.c"
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar** _tmp16_ = NULL;
		gchar** keys;
		gint keys_length1;
		gint _keys_size_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gint _tmp22_;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_ = NULL;
		gchar** values;
		gint values_length1;
		gint _values_size_;
		const gchar* _tmp27_;
		PixbufWriter* _tmp30_;
		GdkPixbuf* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar** _tmp33_;
		gint _tmp33__length1;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp11_ = g_strdup ("quality");
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp12_ = g_strdup ("density-unit");
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp13_ = g_strdup ("x-density");
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp14_ = g_strdup ("y-density");
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp15_ = g_strdup ("icc-profile");
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_ = g_new0 (gchar*, 6 + 1);
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_[0] = _tmp11_;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_[1] = _tmp12_;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_[2] = _tmp13_;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_[3] = _tmp14_;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_[4] = _tmp15_;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp16_[5] = NULL;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		keys = _tmp16_;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		keys_length1 = 6;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_keys_size_ = keys_length1;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp17_ = quality;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp18_ = g_strdup_printf ("%d", _tmp17_);
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp19_ = g_strdup ("dots-per-inch");
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp20_ = self->priv->dpi;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp21_ = g_strdup_printf ("%d", _tmp20_);
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp22_ = self->priv->dpi;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp23_ = g_strdup_printf ("%d", _tmp22_);
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp24_ = icc_profile_data;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp25_ = g_strdup (_tmp24_);
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_ = g_new0 (gchar*, 6 + 1);
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_[0] = _tmp18_;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_[1] = _tmp19_;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_[2] = _tmp21_;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_[3] = _tmp23_;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_[4] = _tmp25_;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp26_[5] = NULL;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		values = _tmp26_;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		values_length1 = 6;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_values_size_ = values_length1;
#line 742 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp27_ = icc_profile_data;
#line 742 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp27_ == NULL) {
#line 3745 "page.c"
			gchar** _tmp28_;
			gint _tmp28__length1;
			gchar* _tmp29_;
#line 743 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp28_ = keys;
#line 743 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp28__length1 = keys_length1;
#line 743 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_g_free0 (_tmp28_[4]);
#line 743 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp28_[4] = NULL;
#line 743 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp29_ = _tmp28_[4];
#line 3759 "page.c"
		}
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp30_ = writer;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp31_ = image;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp32_ = keys;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp32__length1 = keys_length1;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp33_ = values;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp33__length1 = values_length1;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		pixbuf_writer_save (_tmp30_, _tmp31_, "jpeg", _tmp32_, _tmp32__length1, _tmp33_, _tmp33__length1, &_inner_error_);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_inner_error_ != NULL) {
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			g_propagate_error (error, _inner_error_);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_g_free0 (icc_profile_data);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_g_object_unref0 (image);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_pixbuf_writer_unref0 (writer);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_g_object_unref0 (stream);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			return;
#line 3793 "page.c"
		}
#line 738 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 738 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3799 "page.c"
	} else {
		GCompareFunc _tmp34_;
		const gchar* _tmp35_;
		gint _tmp36_ = 0;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp34_ = g_strcmp0;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp35_ = type;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		_tmp36_ = _tmp34_ (_tmp35_, "png");
#line 746 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (_tmp36_ == 0) {
#line 3812 "page.c"
			gchar* _tmp37_;
			gchar** _tmp38_ = NULL;
			gchar** keys;
			gint keys_length1;
			gint _keys_size_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar** _tmp41_ = NULL;
			gchar** values;
			gint values_length1;
			gint _values_size_;
			const gchar* _tmp42_;
			PixbufWriter* _tmp45_;
			GdkPixbuf* _tmp46_;
			gchar** _tmp47_;
			gint _tmp47__length1;
			gchar** _tmp48_;
			gint _tmp48__length1;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp37_ = g_strdup ("icc-profile");
#line 748 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp38_ = g_new0 (gchar*, 2 + 1);
#line 748 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp38_[0] = _tmp37_;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp38_[1] = NULL;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			keys = _tmp38_;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			keys_length1 = 2;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_keys_size_ = keys_length1;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp39_ = icc_profile_data;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp40_ = g_strdup (_tmp39_);
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp41_ = g_new0 (gchar*, 2 + 1);
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp41_[0] = _tmp40_;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp41_[1] = NULL;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			values = _tmp41_;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			values_length1 = 2;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_values_size_ = values_length1;
#line 750 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp42_ = icc_profile_data;
#line 750 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			if (_tmp42_ == NULL) {
#line 3865 "page.c"
				gchar** _tmp43_;
				gint _tmp43__length1;
				gchar* _tmp44_;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp43_ = keys;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp43__length1 = keys_length1;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_g_free0 (_tmp43_[0]);
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp43_[0] = NULL;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp44_ = _tmp43_[0];
#line 3879 "page.c"
			}
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp45_ = writer;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp46_ = image;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp47_ = keys;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp47__length1 = keys_length1;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp48_ = values;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp48__length1 = values_length1;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			pixbuf_writer_save (_tmp45_, _tmp46_, "png", _tmp47_, _tmp47__length1, _tmp48_, _tmp48__length1, &_inner_error_);
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			if (_inner_error_ != NULL) {
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				g_propagate_error (error, _inner_error_);
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_g_free0 (icc_profile_data);
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_g_object_unref0 (image);
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_pixbuf_writer_unref0 (writer);
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_g_object_unref0 (stream);
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				return;
#line 3913 "page.c"
			}
#line 746 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 746 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3919 "page.c"
		} else {
			GCompareFunc _tmp49_;
			const gchar* _tmp50_;
			gint _tmp51_ = 0;
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp49_ = g_strcmp0;
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp50_ = type;
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			_tmp51_ = _tmp49_ (_tmp50_, "tiff");
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			if (_tmp51_ == 0) {
#line 3932 "page.c"
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar** _tmp54_ = NULL;
				gchar** keys;
				gint keys_length1;
				gint _keys_size_;
				gchar* _tmp55_;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				gchar** _tmp58_ = NULL;
				gchar** values;
				gint values_length1;
				gint _values_size_;
				const gchar* _tmp59_;
				PixbufWriter* _tmp62_;
				GdkPixbuf* _tmp63_;
				gchar** _tmp64_;
				gint _tmp64__length1;
				gchar** _tmp65_;
				gint _tmp65__length1;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp52_ = g_strdup ("compression");
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp53_ = g_strdup ("icc-profile");
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp54_ = g_new0 (gchar*, 3 + 1);
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp54_[0] = _tmp52_;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp54_[1] = _tmp53_;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp54_[2] = NULL;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				keys = _tmp54_;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				keys_length1 = 3;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_keys_size_ = keys_length1;
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp55_ = g_strdup ("8");
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp56_ = icc_profile_data;
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp57_ = g_strdup (_tmp56_);
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp58_ = g_new0 (gchar*, 3 + 1);
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp58_[0] = _tmp55_;
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp58_[1] = _tmp57_;
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp58_[2] = NULL;
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				values = _tmp58_;
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				values_length1 = 3;
#line 757 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_values_size_ = values_length1;
#line 758 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp59_ = icc_profile_data;
#line 758 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (_tmp59_ == NULL) {
#line 3995 "page.c"
					gchar** _tmp60_;
					gint _tmp60__length1;
					gchar* _tmp61_;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp60_ = keys;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp60__length1 = keys_length1;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_g_free0 (_tmp60_[1]);
#line 759 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp60_[1] = NULL;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_tmp61_ = _tmp60_[1];
#line 4009 "page.c"
				}
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp62_ = writer;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp63_ = image;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp64_ = keys;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp64__length1 = keys_length1;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp65_ = values;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				_tmp65__length1 = values_length1;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				pixbuf_writer_save (_tmp62_, _tmp63_, "tiff", _tmp64_, _tmp64__length1, _tmp65_, _tmp65__length1, &_inner_error_);
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				if (_inner_error_ != NULL) {
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					g_propagate_error (error, _inner_error_);
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_g_free0 (icc_profile_data);
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_g_object_unref0 (image);
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_pixbuf_writer_unref0 (writer);
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					_g_object_unref0 (stream);
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
					return;
#line 4043 "page.c"
				}
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 4049 "page.c"
			} else {
			}
		}
	}
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (icc_profile_data);
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_object_unref0 (image);
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_pixbuf_writer_unref0 (writer);
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_object_unref0 (stream);
#line 4062 "page.c"
}


static void value_page_init (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	value->data[0].v_pointer = NULL;
#line 4069 "page.c"
}


static void value_page_free_value (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		page_unref (value->data[0].v_pointer);
#line 4078 "page.c"
	}
}


static void value_page_copy_value (const GValue* src_value, GValue* dest_value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		dest_value->data[0].v_pointer = page_ref (src_value->data[0].v_pointer);
#line 4088 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4092 "page.c"
	}
}


static gpointer value_page_peek_pointer (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return value->data[0].v_pointer;
#line 4100 "page.c"
}


static gchar* value_page_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (collect_values[0].v_pointer) {
#line 4107 "page.c"
		Page* object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4114 "page.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4118 "page.c"
		}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = page_ref (object);
#line 4122 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4126 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return NULL;
#line 4130 "page.c"
}


static gchar* value_page_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Page** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (!object_p) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4141 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*object_p = NULL;
#line 4147 "page.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*object_p = value->data[0].v_pointer;
#line 4151 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*object_p = page_ref (value->data[0].v_pointer);
#line 4155 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return NULL;
#line 4159 "page.c"
}


GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPage* spec;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE), NULL);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return G_PARAM_SPEC (spec);
#line 4173 "page.c"
}


gpointer value_get_page (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE), NULL);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return value->data[0].v_pointer;
#line 4182 "page.c"
}


void value_set_page (GValue* value, gpointer v_object) {
	Page* old;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		page_ref (value->data[0].v_pointer);
#line 4202 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4206 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		page_unref (old);
#line 4212 "page.c"
	}
}


void value_take_page (GValue* value, gpointer v_object) {
	Page* old;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 4231 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4235 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		page_unref (old);
#line 4241 "page.c"
	}
}


static void page_class_init (PageClass * klass) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	page_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	PAGE_CLASS (klass)->finalize = page_finalize;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_type_class_add_private (klass, sizeof (PagePrivate));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_new ("pixels_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_new ("size_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_new ("scan_line_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_new ("scan_direction_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_new ("crop_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_signal_new ("scan_finished", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4265 "page.c"
}


static void page_instance_init (Page * self) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv = PAGE_GET_PRIVATE (self);
#line 51 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->ref_count = 1;
#line 4276 "page.c"
}


static void page_finalize (Page* obj) {
	Page * self;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE, Page);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (self->priv->color_profile);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
#line 55 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_free0 (self->priv->crop_name);
#line 4290 "page.c"
}


GType page_get_type (void) {
	static volatile gsize page_type_id__volatile = 0;
	if (g_once_init_enter (&page_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_init, value_page_free_value, value_page_copy_value, value_page_peek_pointer, "p", value_page_collect_value, "p", value_page_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Page), 0, (GInstanceInitFunc) page_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_type_id;
		page_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Page", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_type_id__volatile, page_type_id);
	}
	return page_type_id__volatile;
}


gpointer page_ref (gpointer instance) {
	Page* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return instance;
#line 4315 "page.c"
}


void page_unref (gpointer instance) {
	Page* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		PAGE_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4328 "page.c"
	}
}


PixbufWriter* pixbuf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PixbufWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
#line 771 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 771 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self = (PixbufWriter*) g_type_create_instance (object_type);
#line 773 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = stream;
#line 773 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 773 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_object_unref0 (self->stream);
#line 773 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->stream = _tmp1_;
#line 771 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return self;
#line 4351 "page.c"
}


PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream) {
#line 771 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return pixbuf_writer_construct (TYPE_PIXBUF_WRITER, stream);
#line 4358 "page.c"
}


static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = pixbuf_writer_write_pixbuf_data (self, buf, buf_length1, error);
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 4367 "page.c"
}


void pixbuf_writer_save (PixbufWriter* self, GdkPixbuf* image, const gchar* type, gchar** option_keys, int option_keys_length1, gchar** option_values, int option_values_length1, GError** error) {
	GdkPixbuf* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GError * _inner_error_ = NULL;
#line 776 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (self != NULL);
#line 776 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (image != NULL);
#line 776 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (type != NULL);
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = image;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = type;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2_ = option_keys;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp2__length1 = option_keys_length1;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3_ = option_values;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp3__length1 = option_values_length1;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	gdk_pixbuf_save_to_callbackv (_tmp0_, _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func, self, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_inner_error_ != NULL) {
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return;
#line 4405 "page.c"
	}
}


static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GFileOutputStream* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	GError * _inner_error_ = NULL;
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp0_ = self->stream;
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1_ = buf;
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_tmp1__length1 = buf_length1;
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (_inner_error_ != NULL) {
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return FALSE;
#line 4432 "page.c"
	}
#line 784 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	result = TRUE;
#line 784 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return result;
#line 4438 "page.c"
}


static void value_pixbuf_writer_init (GValue* value) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	value->data[0].v_pointer = NULL;
#line 4445 "page.c"
}


static void value_pixbuf_writer_free_value (GValue* value) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (value->data[0].v_pointer) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		pixbuf_writer_unref (value->data[0].v_pointer);
#line 4454 "page.c"
	}
}


static void value_pixbuf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (src_value->data[0].v_pointer) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		dest_value->data[0].v_pointer = pixbuf_writer_ref (src_value->data[0].v_pointer);
#line 4464 "page.c"
	} else {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4468 "page.c"
	}
}


static gpointer value_pixbuf_writer_peek_pointer (const GValue* value) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return value->data[0].v_pointer;
#line 4476 "page.c"
}


static gchar* value_pixbuf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (collect_values[0].v_pointer) {
#line 4483 "page.c"
		PixbufWriter* object;
		object = collect_values[0].v_pointer;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		if (object->parent_instance.g_class == NULL) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4490 "page.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4494 "page.c"
		}
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = pixbuf_writer_ref (object);
#line 4498 "page.c"
	} else {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4502 "page.c"
	}
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return NULL;
#line 4506 "page.c"
}


static gchar* value_pixbuf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixbufWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (!object_p) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4517 "page.c"
	}
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (!value->data[0].v_pointer) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*object_p = NULL;
#line 4523 "page.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*object_p = value->data[0].v_pointer;
#line 4527 "page.c"
	} else {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		*object_p = pixbuf_writer_ref (value->data[0].v_pointer);
#line 4531 "page.c"
	}
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return NULL;
#line 4535 "page.c"
}


GParamSpec* param_spec_pixbuf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixbufWriter* spec;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXBUF_WRITER), NULL);
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return G_PARAM_SPEC (spec);
#line 4549 "page.c"
}


gpointer value_get_pixbuf_writer (const GValue* value) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER), NULL);
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return value->data[0].v_pointer;
#line 4558 "page.c"
}


void value_set_pixbuf_writer (GValue* value, gpointer v_object) {
	PixbufWriter* old;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	old = value->data[0].v_pointer;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (v_object) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		pixbuf_writer_ref (value->data[0].v_pointer);
#line 4578 "page.c"
	} else {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4582 "page.c"
	}
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (old) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		pixbuf_writer_unref (old);
#line 4588 "page.c"
	}
}


void value_take_pixbuf_writer (GValue* value, gpointer v_object) {
	PixbufWriter* old;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	old = value->data[0].v_pointer;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (v_object) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 4607 "page.c"
	} else {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4611 "page.c"
	}
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (old) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		pixbuf_writer_unref (old);
#line 4617 "page.c"
	}
}


static void pixbuf_writer_class_init (PixbufWriterClass * klass) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	pixbuf_writer_parent_class = g_type_class_peek_parent (klass);
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	PIXBUF_WRITER_CLASS (klass)->finalize = pixbuf_writer_finalize;
#line 4627 "page.c"
}


static void pixbuf_writer_instance_init (PixbufWriter * self) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self->ref_count = 1;
#line 4634 "page.c"
}


static void pixbuf_writer_finalize (PixbufWriter* obj) {
	PixbufWriter * self;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_WRITER, PixbufWriter);
#line 769 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	_g_object_unref0 (self->stream);
#line 4644 "page.c"
}


GType pixbuf_writer_get_type (void) {
	static volatile gsize pixbuf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixbuf_writer_init, value_pixbuf_writer_free_value, value_pixbuf_writer_copy_value, value_pixbuf_writer_peek_pointer, "p", value_pixbuf_writer_collect_value, "p", value_pixbuf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixbufWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufWriter), 0, (GInstanceInitFunc) pixbuf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixbuf_writer_type_id;
		pixbuf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixbufWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixbuf_writer_type_id__volatile, pixbuf_writer_type_id);
	}
	return pixbuf_writer_type_id__volatile;
}


gpointer pixbuf_writer_ref (gpointer instance) {
	PixbufWriter* self;
	self = instance;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	g_atomic_int_inc (&self->ref_count);
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	return instance;
#line 4669 "page.c"
}


void pixbuf_writer_unref (gpointer instance) {
	PixbufWriter* self;
	self = instance;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		PIXBUF_WRITER_GET_CLASS (self)->finalize (self);
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4682 "page.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



