/* ui.c generated by valac 0.13.1, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ParamSpecSimpleScan ParamSpecSimpleScan;

struct _SimpleScan {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	GTypeClass parent_class;
	void (*finalize) (SimpleScan *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _SimpleScanPrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkWindow* window;
	GtkVBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkRadioMenuItem* text_toolbar_menuitem;
	GtkRadioMenuItem* text_menu_menuitem;
	GtkRadioMenuItem* photo_toolbar_menuitem;
	GtkRadioMenuItem* photo_menu_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* book;
	gchar* book_uri;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* default_file_name;
	gboolean scanning;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecSimpleScan {
	GParamSpec parent_instance;
};


static gpointer simple_scan_parent_class = NULL;

gpointer simple_scan_ref (gpointer instance);
void simple_scan_unref (gpointer instance);
GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_simple_scan (GValue* value, gpointer v_object);
void value_take_simple_scan (GValue* value, gpointer v_object);
gpointer value_get_simple_scan (const GValue* value);
GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define SIMPLE_SCAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_SCAN, SimpleScanPrivate))
enum  {
	SIMPLE_SCAN_DUMMY_PROPERTY
};
#define SIMPLE_SCAN_DEFAULT_TEXT_DPI 150
#define SIMPLE_SCAN_DEFAULT_PHOTO_DPI 300
SimpleScan* simple_scan_new (void);
SimpleScan* simple_scan_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void simple_scan_page_removed_cb (SimpleScan* self, Book* book, Page* page);
static void _simple_scan_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void simple_scan_page_added_cb (SimpleScan* self, Book* book, Page* page);
static void _simple_scan_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
static void simple_scan_load (SimpleScan* self);
static gboolean simple_scan_find_scan_device (SimpleScan* self, const gchar* device, GtkTreeIter* iter);
static void simple_scan_show_error_dialog (SimpleScan* self, const gchar* error_title, const gchar* error_text);
void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name);
void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password);
void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_update_info_bar (SimpleScan* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void simple_scan_set_scan_devices (SimpleScan* self, GList* devices);
static gchar* simple_scan_get_selected_device (SimpleScan* self);
void simple_scan_set_selected_device (SimpleScan* self, const gchar* device);
static void simple_scan_add_default_page (SimpleScan* self);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_view_select_page (BookView* self, Page* page);
static void simple_scan_on_file_type_changed (SimpleScan* self, GtkTreeSelection* selection);
static gchar* simple_scan_choose_file_location (SimpleScan* self);
static void _simple_scan_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean simple_scan_save_document (SimpleScan* self, gboolean force_choose_location);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void book_set_needs_saving (Book* self, gboolean needs_saving);
static gboolean simple_scan_prompt_to_save (SimpleScan* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void simple_scan_clear_document (SimpleScan* self);
void book_clear (Book* self);
void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_set_document_hint (SimpleScan* self, const gchar* document_hint);
void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void simple_scan_set_page_side (SimpleScan* self, ScanType page_side);
static void simple_scan_set_paper_size (SimpleScan* self, gint width, gint height);
static gint simple_scan_get_text_dpi (SimpleScan* self);
static gint simple_scan_get_photo_dpi (SimpleScan* self);
static ScanType simple_scan_get_page_side (SimpleScan* self);
static gboolean simple_scan_get_paper_size (SimpleScan* self, gint* width, gint* height);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* simple_scan_get_scan_options (SimpleScan* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, SimpleScan* self);
static void simple_scan_update_page_menu (SimpleScan* self);
Page* book_view_get_selected (BookView* self);
guint book_get_page_index (Book* self, Page* page);
guint book_get_n_pages (Book* self);
static void simple_scan_page_selected_cb (SimpleScan* self, BookView* view, Page* page);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension);
static void simple_scan_show_page_cb (SimpleScan* self, BookView* view, Page* page);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void simple_scan_show_page_menu_cb (SimpleScan* self, BookView* view);
void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_left (Page* self);
void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_right (Page* self);
static void simple_scan_set_crop (SimpleScan* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, SimpleScan* self);
void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_crop (Page* self);
void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void book_move_page (Book* self, Page* page, guint location);
void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_draw_page (SimpleScan* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
Page* book_get_page (Book* self, gint page_number);
gboolean page_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void _simple_scan_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
static gboolean simple_scan_on_quit (SimpleScan* self);
void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, SimpleScan* self);
static void simple_scan_info_bar_response_cb (SimpleScan* self, GtkInfoBar* widget, gint response_id);
gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, SimpleScan* self);
gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, SimpleScan* self);
static void simple_scan_page_size_changed_cb (SimpleScan* self, Page* page);
static void simple_scan_page_scan_direction_changed_cb (SimpleScan* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _simple_scan_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void simple_scan_set_dpi_combo (SimpleScan* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static void simple_scan_needs_saving_cb (SimpleScan* self, Book* book);
static void _simple_scan_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _simple_scan_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _simple_scan_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _simple_scan_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
static void _simple_scan_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
Book* simple_scan_get_book (SimpleScan* self);
void simple_scan_set_selected_page (SimpleScan* self, Page* page);
Page* simple_scan_get_selected_page (SimpleScan* self);
void simple_scan_set_scanning (SimpleScan* self, gboolean scanning);
void simple_scan_start (SimpleScan* self);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void simple_scan_finalize (SimpleScan* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _simple_scan_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
	simple_scan_page_removed_cb (self, _sender, page);
}


static void _simple_scan_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
	simple_scan_page_added_cb (self, _sender, page);
}


SimpleScan* simple_scan_construct (GType object_type) {
	SimpleScan* self = NULL;
	Book* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	self = (SimpleScan*) g_type_create_instance (object_type);
	_tmp0_ = book_new ();
	_book_unref0 (self->priv->book);
	self->priv->book = _tmp0_;
	g_signal_connect (self->priv->book, "page-removed", (GCallback) _simple_scan_page_removed_cb_book_page_removed, self);
	g_signal_connect (self->priv->book, "page-added", (GCallback) _simple_scan_page_added_cb_book_page_added, self);
	_tmp1_ = g_settings_new ("org.gnome.SimpleScan");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	simple_scan_load (self);
	return self;
}


SimpleScan* simple_scan_new (void) {
	return simple_scan_construct (TYPE_SIMPLE_SCAN);
}


static gboolean simple_scan_find_scan_device (SimpleScan* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	gboolean have_iter;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	have_iter = FALSE;
	_tmp1_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->device_model, &_tmp0_);
	_iter = _tmp0_;
	if (_tmp1_) {
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar* d = NULL;
				if (!_tmp2_) {
					gboolean _tmp3_ = FALSE;
					if (!have_iter) {
						gboolean _tmp4_;
						_tmp4_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->device_model, &_iter);
						_tmp3_ = _tmp4_;
					} else {
						_tmp3_ = FALSE;
					}
					if (!_tmp3_) {
						break;
					}
				}
				_tmp2_ = FALSE;
				gtk_tree_model_get ((GtkTreeModel*) self->priv->device_model, &_iter, 0, &d, -1, -1);
				if (g_strcmp0 (d, device) == 0) {
					have_iter = TRUE;
				}
				_g_free0 (d);
			}
		}
	}
	result = have_iter;
	if (iter) {
		*iter = _iter;
	}
	return result;
}


static void simple_scan_show_error_dialog (SimpleScan* self, const gchar* error_title, const gchar* error_text) {
	GtkMessageDialog* _tmp0_ = NULL;
	GtkMessageDialog* dialog;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_title != NULL);
	g_return_if_fail (error_text != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (self->priv->window, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", error_title);
	dialog = g_object_ref_sink (_tmp0_);
	gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_CLOSE, 0);
	gtk_message_dialog_format_secondary_text (dialog, "%s", error_text, NULL);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (default_file_name != NULL);
	_tmp0_ = g_strdup (default_file_name);
	_g_free0 (self->priv->default_file_name);
	self->priv->default_file_name = _tmp0_;
}


void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _username = NULL;
	gchar* _password = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* description;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = _ ("Username and password required to access '%s'");
	_tmp1_ = g_strdup_printf (_tmp0_, resource);
	description = _tmp1_;
	gtk_entry_set_text (self->priv->username_entry, "");
	gtk_entry_set_text (self->priv->password_entry, "");
	gtk_label_set_text (self->priv->authorize_label, description);
	gtk_widget_show ((GtkWidget*) self->priv->authorize_dialog);
	gtk_dialog_run (self->priv->authorize_dialog);
	gtk_widget_hide ((GtkWidget*) self->priv->authorize_dialog);
	_tmp2_ = gtk_entry_get_text (self->priv->username_entry);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_username);
	_username = _tmp3_;
	_tmp4_ = gtk_entry_get_text (self->priv->password_entry);
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_password);
	_password = _tmp5_;
	_g_free0 (description);
	if (username) {
		*username = _username;
	} else {
		_g_free0 (_username);
	}
	if (password) {
		*password = _password;
	} else {
		_g_free0 (_password);
	}
}


void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->setting_devices) {
		return;
	}
	self->priv->user_selected_device = TRUE;
}


static void simple_scan_update_info_bar (SimpleScan* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button;
	gboolean show_change_scanner_button;
	gchar* _tmp9_ = NULL;
	gchar* message;
	g_return_if_fail (self != NULL);
	show_close_button = FALSE;
	show_change_scanner_button = FALSE;
	if (self->priv->have_error) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		type = GTK_MESSAGE_ERROR;
		_tmp0_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
		_g_free0 (image_id);
		image_id = _tmp0_;
		_tmp1_ = g_strdup (self->priv->error_title);
		_g_free0 (title);
		title = _tmp1_;
		_tmp2_ = g_strdup (self->priv->error_text);
		_g_free0 (text);
		text = _tmp2_;
		show_close_button = TRUE;
		show_change_scanner_button = self->priv->error_change_scanner_hint;
	} else {
		gint _tmp3_;
		_tmp3_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) self->priv->device_model, NULL);
		if (_tmp3_ == 0) {
			gchar* _tmp4_;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			type = GTK_MESSAGE_WARNING;
			_tmp4_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
			_g_free0 (image_id);
			image_id = _tmp4_;
			_tmp5_ = _ ("No scanners detected");
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (title);
			title = _tmp6_;
			_tmp7_ = _ ("Please check your scanner is connected and powered on");
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (text);
			text = _tmp8_;
		} else {
			gtk_widget_hide ((GtkWidget*) self->priv->info_bar);
			_g_free0 (image_id);
			_g_free0 (text);
			_g_free0 (title);
			return;
		}
	}
	gtk_info_bar_set_message_type (self->priv->info_bar, type);
	gtk_image_set_from_stock (self->priv->info_bar_image, image_id, GTK_ICON_SIZE_DIALOG);
	_tmp9_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", title, text);
	message = _tmp9_;
	gtk_label_set_markup (self->priv->info_bar_label, message);
	gtk_widget_set_visible ((GtkWidget*) self->priv->info_bar_close_button, show_close_button);
	gtk_widget_set_visible ((GtkWidget*) self->priv->info_bar_change_scanner_button, show_change_scanner_button);
	gtk_widget_show ((GtkWidget*) self->priv->info_bar);
	_g_free0 (message);
	_g_free0 (image_id);
	_g_free0 (text);
	_g_free0 (title);
}


static gpointer _scan_device_ref0 (gpointer self) {
	return self ? scan_device_ref (self) : NULL;
}


void simple_scan_set_scan_devices (SimpleScan* self, GList* devices) {
	gboolean have_selection;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	have_selection = FALSE;
	self->priv->setting_devices = TRUE;
	if (self->priv->user_selected_device) {
		gint _tmp0_;
		_tmp0_ = gtk_combo_box_get_active (self->priv->device_combo);
		have_selection = _tmp0_ >= 0;
	}
	index = 0;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = devices;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			ScanDevice* _tmp1_;
			ScanDevice* device = NULL;
			_tmp1_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
			device = _tmp1_;
			{
				gint n_delete;
				GtkTreeIter _tmp2_ = {0};
				gboolean _tmp3_;
				n_delete = -1;
				_tmp3_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self->priv->device_model, &_tmp2_, NULL, index);
				iter = _tmp2_;
				if (_tmp3_) {
					gint i;
					i = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gchar* name = NULL;
							gboolean matched = FALSE;
							if (!_tmp4_) {
								gboolean _tmp5_;
								_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->device_model, &iter);
								if (!_tmp5_) {
									break;
								}
							}
							_tmp4_ = FALSE;
							gtk_tree_model_get ((GtkTreeModel*) self->priv->device_model, &iter, 0, &name, -1, -1);
							matched = g_strcmp0 (name, device->name) == 0;
							if (matched) {
								n_delete = i;
								_g_free0 (name);
								break;
							}
							i++;
							_g_free0 (name);
						}
					}
				}
				if (n_delete >= 0) {
					gint i = 0;
					gtk_list_store_set (self->priv->device_model, &iter, 1, device->label, -1, -1);
					{
						gboolean _tmp6_;
						i = 0;
						_tmp6_ = TRUE;
						while (TRUE) {
							GtkTreeIter _tmp7_ = {0};
							if (!_tmp6_) {
								i++;
							}
							_tmp6_ = FALSE;
							if (!(i < n_delete)) {
								break;
							}
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) self->priv->device_model, &_tmp7_, NULL, index);
							iter = _tmp7_;
							gtk_list_store_remove (self->priv->device_model, &iter);
						}
					}
				} else {
					GtkTreeIter _tmp8_ = {0};
					gtk_list_store_insert (self->priv->device_model, &_tmp8_, index);
					iter = _tmp8_;
					gtk_list_store_set (self->priv->device_model, &iter, 0, device->name, 1, device->label, -1, -1);
				}
				index++;
				_scan_device_unref0 (device);
			}
		}
	}
	while (TRUE) {
		GtkTreeIter _tmp9_ = {0};
		gboolean _tmp10_;
		_tmp10_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self->priv->device_model, &_tmp9_, NULL, index);
		iter = _tmp9_;
		if (!_tmp10_) {
			break;
		}
		gtk_list_store_remove (self->priv->device_model, &iter);
	}
	if (!have_selection) {
		_tmp11_ = devices != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gtk_combo_box_set_active (self->priv->device_combo, 0);
	}
	self->priv->setting_devices = FALSE;
	simple_scan_update_info_bar (self);
}


static gchar* simple_scan_get_selected_device (SimpleScan* self) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->device_combo, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		gchar* device = NULL;
		gtk_tree_model_get ((GtkTreeModel*) self->priv->device_model, &iter, 0, &device, -1, -1);
		result = device;
		return result;
	}
	result = NULL;
	return result;
}


void simple_scan_set_selected_device (SimpleScan* self, const gchar* device) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp1_ = simple_scan_find_scan_device (self, device, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	gtk_combo_box_set_active_iter (self->priv->device_combo, &iter);
	self->priv->user_selected_device = TRUE;
}


static void simple_scan_add_default_page (SimpleScan* self) {
	Page* _tmp0_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = book_append_page (self->priv->book, self->priv->default_page_width, self->priv->default_page_height, self->priv->default_page_dpi, self->priv->default_page_scan_direction);
	page = _tmp0_;
	book_view_select_page (self->priv->book_view, page);
	_page_unref0 (page);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) (-1), c);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= ((glong) 0)) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


static void simple_scan_on_file_type_changed (SimpleScan* self, GtkTreeSelection* selection) {
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreeModel* _tmp3_;
	gchar* extension = NULL;
	gchar* _tmp4_ = NULL;
	gchar* path;
	gchar* _tmp5_ = NULL;
	gchar* filename;
	gint _tmp6_;
	gint extension_index;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	_tmp2_ = gtk_tree_selection_get_selected (selection, &_tmp0_, &_tmp1_);
	_g_object_unref0 (model);
	_tmp3_ = _g_object_ref0 (_tmp0_);
	model = _tmp3_;
	iter = _tmp1_;
	if (!_tmp2_) {
		_g_object_unref0 (model);
		return;
	}
	gtk_tree_model_get (model, &iter, 1, &extension, -1, -1);
	_tmp4_ = gtk_file_chooser_get_filename ((GtkFileChooser*) self->priv->save_dialog);
	path = _tmp4_;
	_tmp5_ = g_path_get_basename (path);
	filename = _tmp5_;
	_tmp6_ = string_last_index_of_char (filename, (gunichar) '.', 0);
	extension_index = _tmp6_;
	if (extension_index >= 0) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = string_slice (filename, (glong) 0, (glong) extension_index);
		_g_free0 (filename);
		filename = _tmp7_;
	}
	_tmp8_ = g_strconcat (filename, extension, NULL);
	_g_free0 (filename);
	filename = _tmp8_;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) self->priv->save_dialog, filename);
	_g_free0 (filename);
	_g_free0 (path);
	_g_free0 (extension);
	_g_object_unref0 (model);
}


static void _simple_scan_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	simple_scan_on_file_type_changed (self, _sender);
}


static gchar* simple_scan_choose_file_location (SimpleScan* self) {
	gchar* result = NULL;
	gchar* directory;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp5_ = NULL;
	GtkFileFilter* _tmp6_ = NULL;
	GtkFileFilter* filter;
	const gchar* _tmp7_ = NULL;
	GtkFileFilter* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkExpander* _tmp11_ = NULL;
	GtkExpander* expander;
	gchar* _tmp12_;
	gchar* extension;
	gint _tmp13_;
	gint index;
	GtkListStore* _tmp15_ = NULL;
	GtkListStore* file_type_store;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp16_ = {0};
	const gchar* _tmp17_ = NULL;
	GtkTreeIter _tmp18_ = {0};
	const gchar* _tmp19_ = NULL;
	GtkTreeIter _tmp20_ = {0};
	const gchar* _tmp21_ = NULL;
	GtkTreeView* _tmp22_ = NULL;
	GtkTreeView* file_type_view;
	GtkCellRendererText* _tmp23_ = NULL;
	GtkCellRendererText* _tmp24_;
	GtkTreeViewColumn* _tmp25_ = NULL;
	GtkTreeViewColumn* _tmp26_;
	GtkTreeViewColumn* column;
	GtkTreeIter _tmp27_ = {0};
	gboolean _tmp28_;
	GtkTreeSelection* _tmp32_ = NULL;
	gint _tmp33_;
	gint response;
	gchar* uri;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_;
	g_return_val_if_fail (self != NULL, NULL);
	directory = NULL;
	_tmp0_ = g_settings_get_string (self->priv->settings, "save-directory");
	_g_free0 (directory);
	directory = _tmp0_;
	if (directory == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (directory, "") == 0;
	}
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (directory);
		directory = _tmp3_;
	}
	_tmp4_ = _ ("Save As...");
	_tmp5_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp4_, self->priv->window, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = g_object_ref_sink (_tmp5_);
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) self->priv->save_dialog, TRUE);
	gtk_file_chooser_set_local_only ((GtkFileChooser*) self->priv->save_dialog, FALSE);
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) self->priv->save_dialog, directory);
	gtk_file_chooser_set_current_name ((GtkFileChooser*) self->priv->save_dialog, self->priv->default_file_name);
	_tmp6_ = gtk_file_filter_new ();
	filter = g_object_ref_sink (_tmp6_);
	_tmp7_ = _ ("Image Files");
	gtk_buildable_set_name ((GtkBuildable*) filter, _tmp7_);
	gtk_file_filter_add_pixbuf_formats (filter);
	gtk_file_filter_add_mime_type (filter, "application/pdf");
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->save_dialog, filter);
	_tmp8_ = gtk_file_filter_new ();
	_g_object_unref0 (filter);
	filter = g_object_ref_sink (_tmp8_);
	_tmp9_ = _ ("All Files");
	gtk_buildable_set_name ((GtkBuildable*) filter, _tmp9_);
	gtk_file_filter_add_pattern (filter, "*");
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->save_dialog, filter);
	_tmp10_ = _ ("Select File _Type");
	_tmp11_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp10_);
	expander = g_object_ref_sink (_tmp11_);
	gtk_expander_set_spacing (expander, 5);
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) self->priv->save_dialog, (GtkWidget*) expander);
	_tmp12_ = g_strdup ("");
	extension = _tmp12_;
	_tmp13_ = string_last_index_of_char (self->priv->default_file_name, (gunichar) '.', 0);
	index = _tmp13_;
	if (index >= 0) {
		gchar* _tmp14_ = NULL;
		_tmp14_ = string_slice (self->priv->default_file_name, (glong) 0, (glong) index);
		_g_free0 (extension);
		extension = _tmp14_;
	}
	_tmp15_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	file_type_store = _tmp15_;
	gtk_list_store_append (file_type_store, &_tmp16_);
	iter = _tmp16_;
	_tmp17_ = _ ("PDF (multi-page document)");
	gtk_list_store_set (file_type_store, &iter, 0, _tmp17_, 1, ".pdf", -1, -1);
	gtk_list_store_append (file_type_store, &_tmp18_);
	iter = _tmp18_;
	_tmp19_ = _ ("JPEG (compressed)");
	gtk_list_store_set (file_type_store, &iter, 0, _tmp19_, 1, ".jpg", -1, -1);
	gtk_list_store_append (file_type_store, &_tmp20_);
	iter = _tmp20_;
	_tmp21_ = _ ("PNG (lossless)");
	gtk_list_store_set (file_type_store, &iter, 0, _tmp21_, 1, ".png", -1, -1);
	_tmp22_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) file_type_store);
	file_type_view = g_object_ref_sink (_tmp22_);
	gtk_tree_view_set_headers_visible (file_type_view, FALSE);
	gtk_tree_view_set_rules_hint (file_type_view, TRUE);
	_tmp23_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp24_ = g_object_ref_sink (_tmp23_);
	_tmp25_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp24_, "text", 0, NULL, NULL);
	_tmp26_ = g_object_ref_sink (_tmp25_);
	_g_object_unref0 (_tmp24_);
	column = _tmp26_;
	gtk_tree_view_append_column (file_type_view, column);
	gtk_container_add ((GtkContainer*) expander, (GtkWidget*) file_type_view);
	_tmp28_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) file_type_store, &_tmp27_);
	iter = _tmp27_;
	if (_tmp28_) {
		{
			gboolean _tmp29_;
			_tmp29_ = TRUE;
			while (TRUE) {
				gchar* e = NULL;
				if (!_tmp29_) {
					gboolean _tmp30_;
					_tmp30_ = gtk_tree_model_iter_next ((GtkTreeModel*) file_type_store, &iter);
					if (!_tmp30_) {
						break;
					}
				}
				_tmp29_ = FALSE;
				gtk_tree_model_get ((GtkTreeModel*) file_type_store, &iter, 1, &e, -1, -1);
				if (g_strcmp0 (extension, e) == 0) {
					GtkTreeSelection* _tmp31_ = NULL;
					_tmp31_ = gtk_tree_view_get_selection (file_type_view);
					gtk_tree_selection_select_iter (_tmp31_, &iter);
				}
				_g_free0 (e);
			}
		}
	}
	_tmp32_ = gtk_tree_view_get_selection (file_type_view);
	g_signal_connect (_tmp32_, "changed", (GCallback) _simple_scan_on_file_type_changed_gtk_tree_selection_changed, self);
	gtk_widget_show_all ((GtkWidget*) expander);
	_tmp33_ = gtk_dialog_run ((GtkDialog*) self->priv->save_dialog);
	response = _tmp33_;
	uri = NULL;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* _tmp34_ = NULL;
		_tmp34_ = gtk_file_chooser_get_uri ((GtkFileChooser*) self->priv->save_dialog);
		_g_free0 (uri);
		uri = _tmp34_;
	}
	_tmp35_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) self->priv->save_dialog);
	_tmp36_ = _tmp35_;
	g_settings_set_string (self->priv->settings, "save-directory", _tmp36_);
	_g_free0 (_tmp36_);
	gtk_widget_destroy ((GtkWidget*) self->priv->save_dialog);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = NULL;
	result = uri;
	_g_object_unref0 (column);
	_g_object_unref0 (file_type_view);
	_g_object_unref0 (file_type_store);
	_g_free0 (extension);
	_g_object_unref0 (expander);
	_g_object_unref0 (filter);
	_g_free0 (directory);
	return result;
}


static gboolean simple_scan_save_document (SimpleScan* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp3_ = NULL;
	GFile* file;
	gchar* _tmp4_ = NULL;
	gchar* uri_lower;
	gchar* _tmp5_;
	gchar* format;
	gboolean _tmp6_;
	gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->book_uri != NULL) {
		_tmp0_ = !force_choose_location;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (self->priv->book_uri);
		_g_free0 (uri);
		uri = _tmp1_;
	} else {
		gchar* _tmp2_ = NULL;
		_tmp2_ = simple_scan_choose_file_location (self);
		_g_free0 (uri);
		uri = _tmp2_;
	}
	if (uri == NULL) {
		result = FALSE;
		_g_free0 (uri);
		return result;
	}
	_tmp3_ = g_file_new_for_uri (uri);
	file = _tmp3_;
	g_debug ("ui.vala:445: Saving to '%s'", uri);
	_tmp4_ = g_utf8_strdown (uri, (gssize) (-1));
	uri_lower = _tmp4_;
	_tmp5_ = g_strdup ("jpeg");
	format = _tmp5_;
	_tmp6_ = g_str_has_suffix (uri_lower, ".pdf");
	if (_tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("pdf");
		_g_free0 (format);
		format = _tmp7_;
	} else {
		gboolean _tmp8_;
		_tmp8_ = g_str_has_suffix (uri_lower, ".ps");
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("ps");
			_g_free0 (format);
			format = _tmp9_;
		} else {
			gboolean _tmp10_;
			_tmp10_ = g_str_has_suffix (uri_lower, ".png");
			if (_tmp10_) {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("png");
				_g_free0 (format);
				format = _tmp11_;
			} else {
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_;
				_tmp13_ = g_str_has_suffix (uri_lower, ".tif");
				if (_tmp13_) {
					_tmp12_ = TRUE;
				} else {
					gboolean _tmp14_;
					_tmp14_ = g_str_has_suffix (uri_lower, ".tiff");
					_tmp12_ = _tmp14_;
				}
				if (_tmp12_) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("tiff");
					_g_free0 (format);
					format = _tmp15_;
				}
			}
		}
	}
	{
		book_save (self->priv->book, format, file, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("ui.vala:464: Error saving file: %s", e->message);
		_tmp16_ = _ ("Failed to save file");
		simple_scan_show_error (self, _tmp16_, e->message, FALSE);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (format);
		_g_free0 (uri_lower);
		_g_object_unref0 (file);
		_g_free0 (uri);
		return result;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (format);
		_g_free0 (uri_lower);
		_g_object_unref0 (file);
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp17_ = g_strdup (uri);
	_g_free0 (self->priv->book_uri);
	self->priv->book_uri = _tmp17_;
	book_set_needs_saving (self->priv->book, FALSE);
	result = TRUE;
	_g_free0 (format);
	_g_free0 (uri_lower);
	_g_object_unref0 (file);
	_g_free0 (uri);
	return result;
}


static gboolean simple_scan_prompt_to_save (SimpleScan* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkMessageDialog* _tmp1_ = NULL;
	GtkMessageDialog* dialog;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_;
	gint response;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	g_return_val_if_fail (discard_label != NULL, FALSE);
	_tmp0_ = book_get_needs_saving (self->priv->book);
	if (!_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (self->priv->window, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", title);
	dialog = g_object_ref_sink (_tmp1_);
	_tmp2_ = _ ("If you don't save, changes will be permanently lost.");
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp2_, NULL);
	gtk_dialog_add_button ((GtkDialog*) dialog, discard_label, (gint) GTK_RESPONSE_NO);
	gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
	_tmp3_ = gtk_dialog_run ((GtkDialog*) dialog);
	response = _tmp3_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	switch (response) {
		case GTK_RESPONSE_YES:
		{
			gboolean _tmp4_;
			_tmp4_ = simple_scan_save_document (self, FALSE);
			if (_tmp4_) {
				result = TRUE;
				_g_object_unref0 (dialog);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (dialog);
				return result;
			}
		}
		case GTK_RESPONSE_CANCEL:
		{
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		default:
		case GTK_RESPONSE_NO:
		{
			result = TRUE;
			_g_object_unref0 (dialog);
			return result;
		}
	}
	_g_object_unref0 (dialog);
}


static void simple_scan_clear_document (SimpleScan* self) {
	g_return_if_fail (self != NULL);
	book_clear (self->priv->book);
	simple_scan_add_default_page (self);
	_g_free0 (self->priv->book_uri);
	self->priv->book_uri = NULL;
	book_set_needs_saving (self->priv->book, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->save_as_menuitem, FALSE);
}


void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _ ("Save current document?");
	_tmp1_ = _ ("Discard Changes");
	_tmp2_ = simple_scan_prompt_to_save (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	simple_scan_clear_document (self);
}


static void simple_scan_set_document_hint (SimpleScan* self, const gchar* document_hint) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document_hint != NULL);
	_tmp0_ = g_strdup (document_hint);
	_g_free0 (self->priv->document_hint);
	self->priv->document_hint = _tmp0_;
	if (g_strcmp0 (document_hint, "text") == 0) {
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) self->priv->text_toolbar_menuitem, TRUE);
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) self->priv->text_menu_menuitem, TRUE);
	} else {
		if (g_strcmp0 (document_hint, "photo") == 0) {
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) self->priv->photo_toolbar_menuitem, TRUE);
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) self->priv->photo_menu_menuitem, TRUE);
		}
	}
}


void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_document_hint (self, "text");
	}
}


void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_document_hint (self, "photo");
	}
}


static void simple_scan_set_page_side (SimpleScan* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->page_side_model, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint s = 0;
				if (!_tmp2_) {
					gboolean _tmp3_;
					_tmp3_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->page_side_model, &iter);
					if (!_tmp3_) {
						break;
					}
				}
				_tmp2_ = FALSE;
				gtk_tree_model_get ((GtkTreeModel*) self->priv->page_side_model, &iter, 0, &s, -1, -1);
				if (s == ((gint) page_side)) {
					gtk_combo_box_set_active_iter (self->priv->page_side_combo, &iter);
					return;
				}
			}
		}
	}
}


static void simple_scan_set_paper_size (SimpleScan* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	g_return_if_fail (self != NULL);
	{
		GtkTreeIter _tmp0_ = {0};
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->paper_size_model, &_tmp0_);
		iter = _tmp0_;
		have_iter = _tmp1_;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint w = 0;
			gint h = 0;
			gboolean _tmp4_ = FALSE;
			if (!_tmp2_) {
				gboolean _tmp3_;
				_tmp3_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->paper_size_model, &iter);
				have_iter = _tmp3_;
			}
			_tmp2_ = FALSE;
			if (!have_iter) {
				break;
			}
			gtk_tree_model_get ((GtkTreeModel*) self->priv->paper_size_model, &iter, 0, &w, 1, &h, -1, -1);
			if (w == width) {
				_tmp4_ = h == height;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				break;
			}
		}
	}
	if (!have_iter) {
		GtkTreeIter _tmp5_ = {0};
		gboolean _tmp6_;
		_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->paper_size_model, &_tmp5_);
		iter = _tmp5_;
		have_iter = _tmp6_;
	}
	if (have_iter) {
		gtk_combo_box_set_active_iter (self->priv->paper_size_combo, &iter);
	}
}


static gint simple_scan_get_text_dpi (SimpleScan* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	dpi = SIMPLE_SCAN_DEFAULT_TEXT_DPI;
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->text_dpi_combo, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		gtk_tree_model_get ((GtkTreeModel*) self->priv->text_dpi_model, &iter, 0, &dpi, -1, -1);
	}
	result = dpi;
	return result;
}


static gint simple_scan_get_photo_dpi (SimpleScan* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	dpi = SIMPLE_SCAN_DEFAULT_PHOTO_DPI;
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->photo_dpi_combo, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		gtk_tree_model_get ((GtkTreeModel*) self->priv->photo_dpi_model, &iter, 0, &dpi, -1, -1);
	}
	result = dpi;
	return result;
}


static ScanType simple_scan_get_page_side (SimpleScan* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->page_side_combo, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		gtk_tree_model_get ((GtkTreeModel*) self->priv->page_side_model, &iter, 0, &page_side, -1, -1);
	}
	result = (ScanType) page_side;
	return result;
}


static gboolean simple_scan_get_paper_size (SimpleScan* self, gint* width, gint* height) {
	gint _width = 0;
	gint _height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->paper_size_combo, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		gtk_tree_model_get ((GtkTreeModel*) self->priv->paper_size_model, &iter, 0, &_width, 1, &_height, -1, -1);
		result = TRUE;
		if (width) {
			*width = _width;
		}
		if (height) {
			*height = _height;
		}
		return result;
	}
	result = FALSE;
	if (width) {
		*width = _width;
	}
	if (height) {
		*height = _height;
	}
	return result;
}


static ScanOptions* simple_scan_get_scan_options (SimpleScan* self) {
	ScanOptions* result = NULL;
	ScanOptions* _tmp0_ = NULL;
	ScanOptions* options;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = scan_options_new ();
	options = _tmp0_;
	if (g_strcmp0 (self->priv->document_hint, "text") == 0) {
		gint _tmp1_;
		options->scan_mode = SCAN_MODE_GRAY;
		_tmp1_ = simple_scan_get_text_dpi (self);
		options->dpi = _tmp1_;
		options->depth = 2;
	} else {
		gint _tmp2_;
		options->scan_mode = SCAN_MODE_COLOR;
		_tmp2_ = simple_scan_get_photo_dpi (self);
		options->dpi = _tmp2_;
		options->depth = 8;
	}
	simple_scan_get_paper_size (self, &_tmp3_, &_tmp4_);
	options->paper_width = _tmp3_;
	options->paper_height = _tmp4_;
	result = options;
	return result;
}


void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	ScanOptions* _tmp0_ = NULL;
	ScanOptions* options;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = simple_scan_get_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_SINGLE;
	_tmp1_ = simple_scan_get_selected_device (self);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (self, "start-scan", _tmp2_, options);
	_g_free0 (_tmp2_);
	_scan_options_unref0 (options);
}


void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_signal_emit_by_name (self, "stop-scan");
}


void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->scanning) {
		g_signal_emit_by_name (self, "stop-scan");
	} else {
		ScanOptions* _tmp0_ = NULL;
		ScanOptions* options;
		ScanType _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = simple_scan_get_scan_options (self);
		options = _tmp0_;
		_tmp1_ = simple_scan_get_page_side (self);
		options->type = _tmp1_;
		_tmp2_ = simple_scan_get_selected_device (self);
		_tmp3_ = _tmp2_;
		g_signal_emit_by_name (self, "start-scan", _tmp3_, options);
		_g_free0 (_tmp3_);
		_scan_options_unref0 (options);
	}
}


void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_window_present ((GtkWindow*) self->priv->preferences_dialog);
}


gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	result = TRUE;
	return result;
}


void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->preferences_dialog);
}


static void simple_scan_update_page_menu (SimpleScan* self) {
	Page* _tmp0_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = book_view_get_selected (self->priv->book_view);
	page = _tmp0_;
	if (page == NULL) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->page_move_left_menuitem, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->page_move_right_menuitem, FALSE);
	} else {
		guint _tmp1_;
		guint index;
		guint _tmp2_;
		_tmp1_ = book_get_page_index (self->priv->book, page);
		index = _tmp1_;
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->page_move_left_menuitem, index > ((guint) 0));
		_tmp2_ = book_get_n_pages (self->priv->book);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->page_move_right_menuitem, index < (_tmp2_ - 1));
	}
	_page_unref0 (page);
}


static void simple_scan_page_selected_cb (SimpleScan* self, BookView* view, Page* page) {
	gchar* name;
	gboolean _tmp0_;
	GObject* _tmp10_ = NULL;
	GtkRadioMenuItem* _tmp11_;
	GtkRadioMenuItem* menuitem;
	GObject* _tmp12_ = NULL;
	GtkToggleToolButton* _tmp13_;
	GtkToggleToolButton* toolbutton;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	if (page == NULL) {
		return;
	}
	self->priv->updating_page_menu = TRUE;
	simple_scan_update_page_menu (self);
	name = NULL;
	_tmp0_ = page_has_crop (page);
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* crop_name;
		_tmp1_ = page_get_named_crop (page);
		crop_name = _tmp1_;
		if (crop_name != NULL) {
			if (g_strcmp0 (crop_name, "A4") == 0) {
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("a4_menuitem");
				_g_free0 (name);
				name = _tmp2_;
			} else {
				if (g_strcmp0 (crop_name, "A5") == 0) {
					gchar* _tmp3_;
					_tmp3_ = g_strdup ("a5_menuitem");
					_g_free0 (name);
					name = _tmp3_;
				} else {
					if (g_strcmp0 (crop_name, "A6") == 0) {
						gchar* _tmp4_;
						_tmp4_ = g_strdup ("a6_menuitem");
						_g_free0 (name);
						name = _tmp4_;
					} else {
						if (g_strcmp0 (crop_name, "letter") == 0) {
							gchar* _tmp5_;
							_tmp5_ = g_strdup ("letter_menuitem");
							_g_free0 (name);
							name = _tmp5_;
						} else {
							if (g_strcmp0 (crop_name, "legal") == 0) {
								gchar* _tmp6_;
								_tmp6_ = g_strdup ("legal_menuitem");
								_g_free0 (name);
								name = _tmp6_;
							} else {
								if (g_strcmp0 (crop_name, "4x6") == 0) {
									gchar* _tmp7_;
									_tmp7_ = g_strdup ("4x6_menuitem");
									_g_free0 (name);
									name = _tmp7_;
								}
							}
						}
					}
				}
			}
		} else {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("custom_crop_menuitem");
			_g_free0 (name);
			name = _tmp8_;
		}
		_g_free0 (crop_name);
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("no_crop_menuitem");
		_g_free0 (name);
		name = _tmp9_;
	}
	_tmp10_ = gtk_builder_get_object (self->priv->builder, name);
	_tmp11_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp10_));
	menuitem = _tmp11_;
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menuitem, TRUE);
	_tmp12_ = gtk_builder_get_object (self->priv->builder, "crop_toolbutton");
	_tmp13_ = _g_object_ref0 (GTK_TOGGLE_TOOL_BUTTON (_tmp12_));
	toolbutton = _tmp13_;
	_tmp14_ = page_has_crop (page);
	gtk_toggle_tool_button_set_active (toolbutton, _tmp14_);
	self->priv->updating_page_menu = FALSE;
	_g_object_unref0 (toolbutton);
	_g_object_unref0 (menuitem);
	_g_free0 (name);
}


static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* filename;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%sXXXXXX.%s", prefix, extension);
	filename = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gint _tmp2_;
		gint fd;
		_tmp2_ = g_file_open_tmp (filename, &_tmp1_, &_inner_error_);
		_g_free0 (path);
		path = _tmp1_;
		fd = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		close (fd);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("ui.vala:788: Error saving email attachment: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		_g_free0 (filename);
		return result;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = path;
	_g_free0 (filename);
	return result;
}


static void simple_scan_show_page_cb (SimpleScan* self, BookView* view, Page* page) {
	gchar* _tmp0_ = NULL;
	gchar* path;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = simple_scan_get_temporary_filename (self, "scanned-page", "tiff");
	path = _tmp0_;
	if (path == NULL) {
		_g_free0 (path);
		return;
	}
	_tmp1_ = g_file_new_for_path (path);
	file = _tmp1_;
	{
		page_save (page, "tiff", file, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Unable to save image for preview");
		simple_scan_show_error_dialog (self, _tmp2_, e->message);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		_g_free0 (path);
		return;
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GdkScreen* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		guint32 _tmp6_;
		_tmp3_ = gtk_window_get_screen (self->priv->window);
		_tmp4_ = g_file_get_uri (file);
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp3_, _tmp5_, _tmp6_, &_inner_error_);
		_g_free0 (_tmp5_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _ ("Unable to open image preview application");
		simple_scan_show_error_dialog (self, _tmp7_, e->message);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (path);
}


static void simple_scan_show_page_menu_cb (SimpleScan* self, BookView* view) {
	GObject* _tmp0_ = NULL;
	GtkMenu* _tmp1_;
	GtkMenu* menu;
	guint32 _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = gtk_builder_get_object (self->priv->builder, "page_menu");
	_tmp1_ = _g_object_ref0 (GTK_MENU (_tmp0_));
	menu = _tmp1_;
	_tmp2_ = gtk_get_current_event_time ();
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 3, _tmp2_);
	_g_object_unref0 (menu);
}


void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	Page* _tmp0_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = book_view_get_selected (self->priv->book_view);
	page = _tmp0_;
	if (page != NULL) {
		page_rotate_left (page);
	}
	_page_unref0 (page);
}


void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	Page* _tmp0_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = book_view_get_selected (self->priv->book_view);
	page = _tmp0_;
	if (page != NULL) {
		page_rotate_right (page);
	}
	_page_unref0 (page);
}


static void simple_scan_set_crop (SimpleScan* self, const gchar* crop_name) {
	Page* _tmp0_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->crop_rotate_menuitem, crop_name != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = book_view_get_selected (self->priv->book_view);
	page = _tmp0_;
	if (page == NULL) {
		_page_unref0 (page);
		return;
	}
	if (crop_name == NULL) {
		page_set_no_crop (page);
		_page_unref0 (page);
		return;
	} else {
		if (g_strcmp0 (crop_name, "custom") == 0) {
			gint _tmp1_;
			gint width;
			gint _tmp2_;
			gint height;
			gint crop_width;
			gint crop_height;
			_tmp1_ = page_get_width (page);
			width = _tmp1_;
			_tmp2_ = page_get_height (page);
			height = _tmp2_;
			crop_width = (gint) ((width * 0.8) + 0.5);
			crop_height = (gint) ((height * 0.8) + 0.5);
			page_set_custom_crop (page, crop_width, crop_height);
			page_move_crop (page, (width - crop_width) / 2, (height - crop_height) / 2);
		} else {
			page_set_named_crop (page, crop_name);
		}
	}
	_page_unref0 (page);
}


void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_crop (self, NULL);
	}
}


void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_crop (self, "custom");
	}
}


void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, SimpleScan* self) {
	GtkRadioMenuItem* menuitem = NULL;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = gtk_toggle_tool_button_get_active (widget);
	if (_tmp0_) {
		GObject* _tmp1_ = NULL;
		GtkRadioMenuItem* _tmp2_;
		_tmp1_ = gtk_builder_get_object (self->priv->builder, "custom_crop_menuitem");
		_tmp2_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp1_));
		_g_object_unref0 (menuitem);
		menuitem = _tmp2_;
	} else {
		GObject* _tmp3_ = NULL;
		GtkRadioMenuItem* _tmp4_;
		_tmp3_ = gtk_builder_get_object (self->priv->builder, "no_crop_menuitem");
		_tmp4_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp3_));
		_g_object_unref0 (menuitem);
		menuitem = _tmp4_;
	}
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menuitem, TRUE);
	_g_object_unref0 (menuitem);
}


void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_crop (self, "4x6");
	}
}


void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_crop (self, "legal");
	}
}


void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_crop (self, "letter");
	}
}


void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_crop (self, "A6");
	}
}


void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_crop (self, "A5");
	}
}


void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	if (_tmp0_) {
		simple_scan_set_crop (self, "A4");
	}
}


void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	Page* _tmp0_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = book_view_get_selected (self->priv->book_view);
	page = _tmp0_;
	if (page == NULL) {
		_page_unref0 (page);
		return;
	}
	page_rotate_crop (page);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	Page* _tmp0_ = NULL;
	Page* page;
	guint _tmp1_;
	guint index;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = book_view_get_selected (self->priv->book_view);
	page = _tmp0_;
	_tmp1_ = book_get_page_index (self->priv->book, page);
	index = _tmp1_;
	if (index > ((guint) 0)) {
		book_move_page (self->priv->book, page, index - 1);
	}
	simple_scan_update_page_menu (self);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	Page* _tmp0_ = NULL;
	Page* page;
	guint _tmp1_;
	guint index;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = book_view_get_selected (self->priv->book_view);
	page = _tmp0_;
	_tmp1_ = book_get_page_index (self->priv->book, page);
	index = _tmp1_;
	_tmp2_ = book_get_n_pages (self->priv->book);
	if (index < (_tmp2_ - 1)) {
		guint _tmp3_;
		_tmp3_ = book_get_page_index (self->priv->book, page);
		book_move_page (self->priv->book, page, _tmp3_ + 1);
	}
	simple_scan_update_page_menu (self);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = book_view_get_book (self->priv->book_view);
	_tmp1_ = _tmp0_;
	_tmp2_ = book_view_get_selected (self->priv->book_view);
	_tmp3_ = _tmp2_;
	book_delete_page (_tmp1_, _tmp3_);
	_page_unref0 (_tmp3_);
	_book_unref0 (_tmp1_);
}


void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	simple_scan_save_document (self, FALSE);
}


void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	simple_scan_save_document (self, TRUE);
}


static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


static void simple_scan_draw_page (SimpleScan* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_;
	cairo_t* context;
	Page* _tmp2_ = NULL;
	Page* page;
	gboolean is_landscape;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gboolean _tmp5_;
	gdouble _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
	gint _tmp10_;
	GdkPixbuf* _tmp11_ = NULL;
	GdkPixbuf* image;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (print_context != NULL);
	_tmp0_ = gtk_print_context_get_cairo_context (print_context);
	_tmp1_ = _cairo_reference0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = book_get_page (self->priv->book, page_number);
	page = _tmp2_;
	is_landscape = FALSE;
	_tmp3_ = gtk_print_context_get_width (print_context);
	_tmp4_ = gtk_print_context_get_height (print_context);
	if (_tmp3_ > _tmp4_) {
		is_landscape = TRUE;
	}
	_tmp5_ = page_is_landscape (page);
	if (_tmp5_ != is_landscape) {
		gdouble _tmp6_;
		_tmp6_ = gtk_print_context_get_width (print_context);
		cairo_translate (context, _tmp6_, (gdouble) 0);
		cairo_rotate (context, G_PI_2);
	}
	_tmp7_ = gtk_print_context_get_dpi_x (print_context);
	_tmp8_ = page_get_dpi (page);
	_tmp9_ = gtk_print_context_get_dpi_y (print_context);
	_tmp10_ = page_get_dpi (page);
	cairo_scale (context, _tmp7_ / _tmp8_, _tmp9_ / _tmp10_);
	_tmp11_ = page_get_image (page, TRUE);
	image = _tmp11_;
	gdk_cairo_set_source_pixbuf (context, image, (gdouble) 0, (gdouble) 0);
	cairo_paint (context);
	_g_object_unref0 (image);
	_page_unref0 (page);
	_cairo_destroy0 (context);
}


void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_signal_emit_by_name (self, "email", self->priv->document_hint);
}


static void _simple_scan_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
	simple_scan_draw_page (self, _sender, context, page_nr);
}


void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	GtkPrintOperation* _tmp0_ = NULL;
	GtkPrintOperation* print;
	guint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_print_operation_new ();
	print = _tmp0_;
	_tmp1_ = book_get_n_pages (self->priv->book);
	gtk_print_operation_set_n_pages (print, (gint) _tmp1_);
	g_signal_connect (print, "draw-page", (GCallback) _simple_scan_draw_page_gtk_print_operation_draw_page, self);
	{
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, self->priv->window, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("ui.vala:1044: Error printing: %s", e->message);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (print);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (print);
}


void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	{
		GdkScreen* _tmp0_ = NULL;
		guint32 _tmp1_;
		_tmp0_ = gtk_window_get_screen (self->priv->window);
		_tmp1_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp0_, "ghelp:simple-scan", _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Unable to open help file");
		simple_scan_show_error_dialog (self, _tmp2_, e->message);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* license;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* title;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* description;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	authors = _tmp1_;
	authors_length1 = 1;
	_authors_size_ = authors_length1;
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
	_tmp3_ = g_strdup (_tmp2_);
	license = _tmp3_;
	_tmp4_ = _ ("About Simple Scan");
	_tmp5_ = g_strdup (_tmp4_);
	title = _tmp5_;
	_tmp6_ = _ ("Simple document scanning tool");
	_tmp7_ = g_strdup (_tmp6_);
	description = _tmp7_;
	_tmp8_ = _ ("translator-credits");
	gtk_show_about_dialog (self->priv->window, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp8_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
	_g_free0 (description);
	_g_free0 (title);
	_g_free0 (license);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean simple_scan_on_quit (SimpleScan* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* device;
	gint paper_width;
	gint paper_height;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	ScanType _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _ ("Save document before quitting?");
	_tmp1_ = _ ("Quit without Saving");
	_tmp2_ = simple_scan_prompt_to_save (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = simple_scan_get_selected_device (self);
	device = _tmp3_;
	paper_width = 0;
	paper_height = 0;
	simple_scan_get_paper_size (self, &_tmp4_, &_tmp5_);
	paper_width = _tmp4_;
	paper_height = _tmp5_;
	if (device != NULL) {
		g_settings_set_string (self->priv->settings, "selected-device", device);
	}
	g_settings_set_string (self->priv->settings, "document-type", self->priv->document_hint);
	_tmp6_ = simple_scan_get_text_dpi (self);
	g_settings_set_int (self->priv->settings, "text-dpi", _tmp6_);
	_tmp7_ = simple_scan_get_photo_dpi (self);
	g_settings_set_int (self->priv->settings, "photo-dpi", _tmp7_);
	_tmp8_ = simple_scan_get_page_side (self);
	g_settings_set_enum (self->priv->settings, "page-side", (gint) _tmp8_);
	g_settings_set_int (self->priv->settings, "paper-width", paper_width);
	g_settings_set_int (self->priv->settings, "paper-height", paper_height);
	g_settings_set_int (self->priv->settings, "window-width", self->priv->window_width);
	g_settings_set_int (self->priv->settings, "window-height", self->priv->window_height);
	g_settings_set_boolean (self->priv->settings, "window-is-maximized", self->priv->window_is_maximized);
	g_settings_set_enum (self->priv->settings, "scan-direction", (gint) self->priv->default_page_scan_direction);
	g_settings_set_int (self->priv->settings, "page-width", self->priv->default_page_width);
	g_settings_set_int (self->priv->settings, "page-height", self->priv->default_page_height);
	g_settings_set_int (self->priv->settings, "page-dpi", self->priv->default_page_dpi);
	g_signal_emit_by_name (self, "quit");
	result = TRUE;
	_g_free0 (device);
	return result;
}


void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	simple_scan_on_quit (self);
}


gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, SimpleScan* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if (!self->priv->window_is_maximized) {
		self->priv->window_width = (*event).width;
		self->priv->window_height = (*event).height;
	}
	result = FALSE;
	return result;
}


static void simple_scan_info_bar_response_cb (SimpleScan* self, GtkInfoBar* widget, gint response_id) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (response_id == 1) {
		gtk_widget_grab_focus ((GtkWidget*) self->priv->device_combo);
		gtk_window_present ((GtkWindow*) self->priv->preferences_dialog);
	} else {
		self->priv->have_error = FALSE;
		_g_free0 (self->priv->error_title);
		self->priv->error_title = NULL;
		_g_free0 (self->priv->error_text);
		self->priv->error_text = NULL;
		simple_scan_update_info_bar (self);
	}
}


gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, SimpleScan* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if (((*event).changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		self->priv->window_is_maximized = ((*event).new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, SimpleScan* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = simple_scan_on_quit (self);
	result = !_tmp0_;
	return result;
}


static void simple_scan_page_size_changed_cb (SimpleScan* self, Page* page) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_width (page);
	self->priv->default_page_width = _tmp0_;
	_tmp1_ = page_get_height (page);
	self->priv->default_page_height = _tmp1_;
	_tmp2_ = page_get_dpi (page);
	self->priv->default_page_dpi = _tmp2_;
}


static void simple_scan_page_scan_direction_changed_cb (SimpleScan* self, Page* page) {
	ScanDirection _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_scan_direction (page);
	self->priv->default_page_scan_direction = _tmp0_;
}


static void _simple_scan_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
	simple_scan_page_size_changed_cb (self, _sender);
}


static void _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
	simple_scan_page_scan_direction_changed_cb (self, _sender);
}


static void simple_scan_page_added_cb (SimpleScan* self, Book* book, Page* page) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ScanDirection _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_width (page);
	self->priv->default_page_width = _tmp0_;
	_tmp1_ = page_get_height (page);
	self->priv->default_page_height = _tmp1_;
	_tmp2_ = page_get_dpi (page);
	self->priv->default_page_dpi = _tmp2_;
	_tmp3_ = page_get_scan_direction (page);
	self->priv->default_page_scan_direction = _tmp3_;
	g_signal_connect (page, "size-changed", (GCallback) _simple_scan_page_size_changed_cb_page_size_changed, self);
	g_signal_connect (page, "scan-direction-changed", (GCallback) _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed, self);
	simple_scan_update_page_menu (self);
}


static void simple_scan_page_removed_cb (SimpleScan* self, Book* book, Page* page) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = book_get_n_pages (book);
	if (_tmp0_ == ((guint) 1)) {
		simple_scan_add_default_page (self);
	}
	simple_scan_update_page_menu (self);
}


static void simple_scan_set_dpi_combo (SimpleScan* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* _tmp0_ = NULL;
	GtkCellRendererText* renderer;
	GtkTreeModel* _tmp1_ = NULL;
	GtkListStore* _tmp2_;
	GtkListStore* model;
	gint* _tmp3_ = NULL;
	gint* scan_resolutions;
	gint scan_resolutions_length1;
	gint _scan_resolutions_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer = g_object_ref_sink (_tmp0_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) combo, (GtkCellRenderer*) renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) combo, (GtkCellRenderer*) renderer, "text", 1);
	_tmp1_ = gtk_combo_box_get_model (combo);
	_tmp2_ = _g_object_ref0 (GTK_LIST_STORE (_tmp1_));
	model = _tmp2_;
	_tmp3_ = g_new0 (gint, 6);
	_tmp3_[0] = 75;
	_tmp3_[1] = 150;
	_tmp3_[2] = 300;
	_tmp3_[3] = 600;
	_tmp3_[4] = 1200;
	_tmp3_[5] = 2400;
	scan_resolutions = _tmp3_;
	scan_resolutions_length1 = 6;
	_scan_resolutions_size_ = scan_resolutions_length1;
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it;
		dpi_collection = scan_resolutions;
		dpi_collection_length1 = scan_resolutions_length1;
		for (dpi_it = 0; dpi_it < scan_resolutions_length1; dpi_it = dpi_it + 1) {
			gint dpi = 0;
			dpi = dpi_collection[dpi_it];
			{
				gchar* label = NULL;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp12_ = {0};
				if (dpi == default_dpi) {
					const gchar* _tmp4_ = NULL;
					gchar* _tmp5_ = NULL;
					_tmp4_ = _ ("%d dpi (default)");
					_tmp5_ = g_strdup_printf (_tmp4_, dpi);
					_g_free0 (label);
					label = _tmp5_;
				} else {
					if (dpi == 75) {
						const gchar* _tmp6_ = NULL;
						gchar* _tmp7_ = NULL;
						_tmp6_ = _ ("%d dpi (draft)");
						_tmp7_ = g_strdup_printf (_tmp6_, dpi);
						_g_free0 (label);
						label = _tmp7_;
					} else {
						if (dpi == 1200) {
							const gchar* _tmp8_ = NULL;
							gchar* _tmp9_ = NULL;
							_tmp8_ = _ ("%d dpi (high resolution)");
							_tmp9_ = g_strdup_printf (_tmp8_, dpi);
							_g_free0 (label);
							label = _tmp9_;
						} else {
							const gchar* _tmp10_ = NULL;
							gchar* _tmp11_ = NULL;
							_tmp10_ = _ ("%d dpi");
							_tmp11_ = g_strdup_printf (_tmp10_, dpi);
							_g_free0 (label);
							label = _tmp11_;
						}
					}
				}
				gtk_list_store_append (model, &_tmp12_);
				iter = _tmp12_;
				gtk_list_store_set (model, &iter, 0, dpi, 1, label, -1, -1);
				if (dpi == current_dpi) {
					gtk_combo_box_set_active_iter (combo, &iter);
				}
				_g_free0 (label);
			}
		}
	}
	scan_resolutions = (g_free (scan_resolutions), NULL);
	_g_object_unref0 (model);
	_g_object_unref0 (renderer);
}


static void simple_scan_needs_saving_cb (SimpleScan* self, Book* book) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	_tmp0_ = book_get_needs_saving (book);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->save_menuitem, _tmp0_);
	_tmp1_ = book_get_needs_saving (book);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->save_toolbutton, _tmp1_);
	_tmp2_ = book_get_needs_saving (book);
	if (_tmp2_) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->save_as_menuitem, TRUE);
	}
}


static void _simple_scan_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	simple_scan_info_bar_response_cb (self, _sender, response_id);
}


static void _simple_scan_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
	simple_scan_page_selected_cb (self, _sender, page);
}


static void _simple_scan_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
	simple_scan_show_page_cb (self, _sender, page);
}


static void _simple_scan_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
	simple_scan_show_page_menu_cb (self, _sender);
}


static void _simple_scan_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
	simple_scan_needs_saving_cb (self, _sender);
}


static void simple_scan_load (SimpleScan* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	GObject* _tmp5_ = NULL;
	GtkWindow* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkVBox* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkMenuItem* _tmp10_;
	GObject* _tmp11_ = NULL;
	GtkMenuItem* _tmp12_;
	GObject* _tmp13_ = NULL;
	GtkMenuItem* _tmp14_;
	GObject* _tmp15_ = NULL;
	GtkMenuItem* _tmp16_;
	GObject* _tmp17_ = NULL;
	GtkMenuItem* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkMenuItem* _tmp20_;
	GObject* _tmp21_ = NULL;
	GtkToolButton* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkMenuItem* _tmp24_;
	GObject* _tmp25_ = NULL;
	GtkToolButton* _tmp26_;
	GObject* _tmp27_ = NULL;
	GtkRadioMenuItem* _tmp28_;
	GObject* _tmp29_ = NULL;
	GtkRadioMenuItem* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkRadioMenuItem* _tmp32_;
	GObject* _tmp33_ = NULL;
	GtkRadioMenuItem* _tmp34_;
	GObject* _tmp35_ = NULL;
	GtkDialog* _tmp36_;
	GObject* _tmp37_ = NULL;
	GtkLabel* _tmp38_;
	GObject* _tmp39_ = NULL;
	GtkEntry* _tmp40_;
	GObject* _tmp41_ = NULL;
	GtkEntry* _tmp42_;
	GObject* _tmp43_ = NULL;
	GtkDialog* _tmp44_;
	GObject* _tmp45_ = NULL;
	GtkComboBox* _tmp46_;
	GtkTreeModel* _tmp47_ = NULL;
	GtkListStore* _tmp48_;
	GObject* _tmp49_ = NULL;
	GtkComboBox* _tmp50_;
	GtkTreeModel* _tmp51_ = NULL;
	GtkListStore* _tmp52_;
	GObject* _tmp53_ = NULL;
	GtkComboBox* _tmp54_;
	GtkTreeModel* _tmp55_ = NULL;
	GtkListStore* _tmp56_;
	GObject* _tmp57_ = NULL;
	GtkComboBox* _tmp58_;
	GtkTreeModel* _tmp59_ = NULL;
	GtkListStore* _tmp60_;
	GObject* _tmp61_ = NULL;
	GtkComboBox* _tmp62_;
	GtkTreeModel* _tmp63_ = NULL;
	GtkListStore* _tmp64_;
	GtkInfoBar* _tmp65_ = NULL;
	GtkHBox* _tmp66_ = NULL;
	GtkHBox* hbox;
	GtkWidget* _tmp67_ = NULL;
	GtkContainer* _tmp68_;
	GtkContainer* content_area;
	GtkImage* _tmp69_ = NULL;
	GtkLabel* _tmp70_ = NULL;
	GtkWidget* _tmp71_ = NULL;
	GtkButton* _tmp72_;
	const gchar* _tmp73_ = NULL;
	GtkWidget* _tmp74_ = NULL;
	GtkButton* _tmp75_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp76_ = {0};
	const gchar* _tmp77_ = NULL;
	GtkTreeIter _tmp78_ = {0};
	GtkTreeIter _tmp79_ = {0};
	GtkTreeIter _tmp80_ = {0};
	GtkTreeIter _tmp81_ = {0};
	GtkTreeIter _tmp82_ = {0};
	GtkTreeIter _tmp83_ = {0};
	gint _tmp84_;
	gint dpi;
	gint _tmp85_;
	GtkCellRendererText* _tmp86_ = NULL;
	GtkCellRendererText* renderer;
	GtkCellRendererText* _tmp87_ = NULL;
	gint _tmp88_;
	GtkCellRendererText* _tmp89_ = NULL;
	gint _tmp90_;
	gint paper_width;
	gint _tmp91_;
	gint paper_height;
	gchar* _tmp92_ = NULL;
	gchar* device;
	gchar* _tmp95_ = NULL;
	gchar* document_type;
	BookView* _tmp96_ = NULL;
	gint _tmp97_;
	gint _tmp98_;
	gint _tmp99_;
	gint _tmp100_;
	gint _tmp101_;
	gint _tmp102_;
	gboolean _tmp103_;
	guint _tmp104_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
	gtk_window_set_default_icon_name ("scanner");
	_tmp1_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp1_;
	_tmp2_ = g_build_filename (UI_DIR, "simple-scan.ui", NULL, NULL);
	filename = _tmp2_;
	{
		gtk_builder_add_from_file (self->priv->builder, filename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("ui.vala:1261: Unable to load UI %s: %s\n", filename, e->message);
		_tmp3_ = _ ("Files missing");
		_tmp4_ = _ ("Please check your installation");
		simple_scan_show_error_dialog (self, _tmp3_, _tmp4_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_builder_connect_signals (self->priv->builder, self);
	_tmp5_ = gtk_builder_get_object (self->priv->builder, "simple_scan_window");
	_tmp6_ = _g_object_ref0 (GTK_WINDOW (_tmp5_));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp6_;
	_tmp7_ = gtk_builder_get_object (self->priv->builder, "main_vbox");
	_tmp8_ = _g_object_ref0 (GTK_VBOX (_tmp7_));
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp8_;
	_tmp9_ = gtk_builder_get_object (self->priv->builder, "page_move_left_menuitem");
	_tmp10_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp9_));
	_g_object_unref0 (self->priv->page_move_left_menuitem);
	self->priv->page_move_left_menuitem = _tmp10_;
	_tmp11_ = gtk_builder_get_object (self->priv->builder, "page_move_right_menuitem");
	_tmp12_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp11_));
	_g_object_unref0 (self->priv->page_move_right_menuitem);
	self->priv->page_move_right_menuitem = _tmp12_;
	_tmp13_ = gtk_builder_get_object (self->priv->builder, "page_delete_menuitem");
	_tmp14_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp13_));
	_g_object_unref0 (self->priv->page_delete_menuitem);
	self->priv->page_delete_menuitem = _tmp14_;
	_tmp15_ = gtk_builder_get_object (self->priv->builder, "crop_rotate_menuitem");
	_tmp16_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp15_));
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
	self->priv->crop_rotate_menuitem = _tmp16_;
	_tmp17_ = gtk_builder_get_object (self->priv->builder, "save_menuitem");
	_tmp18_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp17_));
	_g_object_unref0 (self->priv->save_menuitem);
	self->priv->save_menuitem = _tmp18_;
	_tmp19_ = gtk_builder_get_object (self->priv->builder, "save_as_menuitem");
	_tmp20_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp19_));
	_g_object_unref0 (self->priv->save_as_menuitem);
	self->priv->save_as_menuitem = _tmp20_;
	_tmp21_ = gtk_builder_get_object (self->priv->builder, "save_toolbutton");
	_tmp22_ = _g_object_ref0 (GTK_TOOL_BUTTON (_tmp21_));
	_g_object_unref0 (self->priv->save_toolbutton);
	self->priv->save_toolbutton = _tmp22_;
	_tmp23_ = gtk_builder_get_object (self->priv->builder, "stop_scan_menuitem");
	_tmp24_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp23_));
	_g_object_unref0 (self->priv->stop_menuitem);
	self->priv->stop_menuitem = _tmp24_;
	_tmp25_ = gtk_builder_get_object (self->priv->builder, "stop_toolbutton");
	_tmp26_ = _g_object_ref0 (GTK_TOOL_BUTTON (_tmp25_));
	_g_object_unref0 (self->priv->stop_toolbutton);
	self->priv->stop_toolbutton = _tmp26_;
	_tmp27_ = gtk_builder_get_object (self->priv->builder, "text_toolbutton_menuitem");
	_tmp28_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp27_));
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
	self->priv->text_toolbar_menuitem = _tmp28_;
	_tmp29_ = gtk_builder_get_object (self->priv->builder, "text_menuitem");
	_tmp30_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp29_));
	_g_object_unref0 (self->priv->text_menu_menuitem);
	self->priv->text_menu_menuitem = _tmp30_;
	_tmp31_ = gtk_builder_get_object (self->priv->builder, "photo_toolbutton_menuitem");
	_tmp32_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp31_));
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
	self->priv->photo_toolbar_menuitem = _tmp32_;
	_tmp33_ = gtk_builder_get_object (self->priv->builder, "photo_menuitem");
	_tmp34_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp33_));
	_g_object_unref0 (self->priv->photo_menu_menuitem);
	self->priv->photo_menu_menuitem = _tmp34_;
	_tmp35_ = gtk_builder_get_object (self->priv->builder, "authorize_dialog");
	_tmp36_ = _g_object_ref0 (GTK_DIALOG (_tmp35_));
	_g_object_unref0 (self->priv->authorize_dialog);
	self->priv->authorize_dialog = _tmp36_;
	_tmp37_ = gtk_builder_get_object (self->priv->builder, "authorize_label");
	_tmp38_ = _g_object_ref0 (GTK_LABEL (_tmp37_));
	_g_object_unref0 (self->priv->authorize_label);
	self->priv->authorize_label = _tmp38_;
	_tmp39_ = gtk_builder_get_object (self->priv->builder, "username_entry");
	_tmp40_ = _g_object_ref0 (GTK_ENTRY (_tmp39_));
	_g_object_unref0 (self->priv->username_entry);
	self->priv->username_entry = _tmp40_;
	_tmp41_ = gtk_builder_get_object (self->priv->builder, "password_entry");
	_tmp42_ = _g_object_ref0 (GTK_ENTRY (_tmp41_));
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp42_;
	_tmp43_ = gtk_builder_get_object (self->priv->builder, "preferences_dialog");
	_tmp44_ = _g_object_ref0 (GTK_DIALOG (_tmp43_));
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp44_;
	_tmp45_ = gtk_builder_get_object (self->priv->builder, "device_combo");
	_tmp46_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp45_));
	_g_object_unref0 (self->priv->device_combo);
	self->priv->device_combo = _tmp46_;
	_tmp47_ = gtk_combo_box_get_model (self->priv->device_combo);
	_tmp48_ = _g_object_ref0 (GTK_LIST_STORE (_tmp47_));
	_g_object_unref0 (self->priv->device_model);
	self->priv->device_model = _tmp48_;
	_tmp49_ = gtk_builder_get_object (self->priv->builder, "text_dpi_combo");
	_tmp50_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp49_));
	_g_object_unref0 (self->priv->text_dpi_combo);
	self->priv->text_dpi_combo = _tmp50_;
	_tmp51_ = gtk_combo_box_get_model (self->priv->text_dpi_combo);
	_tmp52_ = _g_object_ref0 (GTK_LIST_STORE (_tmp51_));
	_g_object_unref0 (self->priv->text_dpi_model);
	self->priv->text_dpi_model = _tmp52_;
	_tmp53_ = gtk_builder_get_object (self->priv->builder, "photo_dpi_combo");
	_tmp54_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp53_));
	_g_object_unref0 (self->priv->photo_dpi_combo);
	self->priv->photo_dpi_combo = _tmp54_;
	_tmp55_ = gtk_combo_box_get_model (self->priv->photo_dpi_combo);
	_tmp56_ = _g_object_ref0 (GTK_LIST_STORE (_tmp55_));
	_g_object_unref0 (self->priv->photo_dpi_model);
	self->priv->photo_dpi_model = _tmp56_;
	_tmp57_ = gtk_builder_get_object (self->priv->builder, "page_side_combo");
	_tmp58_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp57_));
	_g_object_unref0 (self->priv->page_side_combo);
	self->priv->page_side_combo = _tmp58_;
	_tmp59_ = gtk_combo_box_get_model (self->priv->page_side_combo);
	_tmp60_ = _g_object_ref0 (GTK_LIST_STORE (_tmp59_));
	_g_object_unref0 (self->priv->page_side_model);
	self->priv->page_side_model = _tmp60_;
	_tmp61_ = gtk_builder_get_object (self->priv->builder, "paper_size_combo");
	_tmp62_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp61_));
	_g_object_unref0 (self->priv->paper_size_combo);
	self->priv->paper_size_combo = _tmp62_;
	_tmp63_ = gtk_combo_box_get_model (self->priv->paper_size_combo);
	_tmp64_ = _g_object_ref0 (GTK_LIST_STORE (_tmp63_));
	_g_object_unref0 (self->priv->paper_size_model);
	self->priv->paper_size_model = _tmp64_;
	_tmp65_ = (GtkInfoBar*) gtk_info_bar_new ();
	_g_object_unref0 (self->priv->info_bar);
	self->priv->info_bar = g_object_ref_sink (_tmp65_);
	g_signal_connect (self->priv->info_bar, "response", (GCallback) _simple_scan_info_bar_response_cb_gtk_info_bar_response, self);
	gtk_box_pack_start ((GtkBox*) self->priv->main_vbox, (GtkWidget*) self->priv->info_bar, FALSE, TRUE, (guint) 0);
	_tmp66_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	hbox = g_object_ref_sink (_tmp66_);
	_tmp67_ = gtk_info_bar_get_content_area (self->priv->info_bar);
	_tmp68_ = _g_object_ref0 (GTK_CONTAINER (_tmp67_));
	content_area = _tmp68_;
	gtk_container_add (content_area, (GtkWidget*) hbox);
	gtk_widget_show ((GtkWidget*) hbox);
	_tmp69_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
	_g_object_unref0 (self->priv->info_bar_image);
	self->priv->info_bar_image = g_object_ref_sink (_tmp69_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->info_bar_image, FALSE, TRUE, (guint) 0);
	gtk_widget_show ((GtkWidget*) self->priv->info_bar_image);
	_tmp70_ = (GtkLabel*) gtk_label_new (NULL);
	_g_object_unref0 (self->priv->info_bar_label);
	self->priv->info_bar_label = g_object_ref_sink (_tmp70_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->info_bar_label, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->info_bar_label, TRUE, TRUE, (guint) 0);
	gtk_widget_show ((GtkWidget*) self->priv->info_bar_label);
	_tmp71_ = gtk_info_bar_add_button (self->priv->info_bar, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	_tmp72_ = _g_object_ref0 (GTK_BUTTON (_tmp71_));
	_g_object_unref0 (self->priv->info_bar_close_button);
	self->priv->info_bar_close_button = _tmp72_;
	_tmp73_ = _ ("Change _Scanner");
	_tmp74_ = gtk_info_bar_add_button (self->priv->info_bar, _tmp73_, 1);
	_tmp75_ = _g_object_ref0 (GTK_BUTTON (_tmp74_));
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
	self->priv->info_bar_change_scanner_button = _tmp75_;
	gtk_list_store_append (self->priv->paper_size_model, &_tmp76_);
	iter = _tmp76_;
	_tmp77_ = _ ("Automatic");
	gtk_list_store_set (self->priv->paper_size_model, &iter, 0, 0, 1, 0, 2, _tmp77_, -1, -1);
	gtk_list_store_append (self->priv->paper_size_model, &_tmp78_);
	iter = _tmp78_;
	gtk_list_store_set (self->priv->paper_size_model, &iter, 0, 1050, 1, 1480, 2, "A6", -1, -1);
	gtk_list_store_append (self->priv->paper_size_model, &_tmp79_);
	iter = _tmp79_;
	gtk_list_store_set (self->priv->paper_size_model, &iter, 0, 1480, 1, 2100, 2, "A5", -1, -1);
	gtk_list_store_append (self->priv->paper_size_model, &_tmp80_);
	iter = _tmp80_;
	gtk_list_store_set (self->priv->paper_size_model, &iter, 0, 2100, 1, 2970, 2, "A4", -1, -1);
	gtk_list_store_append (self->priv->paper_size_model, &_tmp81_);
	iter = _tmp81_;
	gtk_list_store_set (self->priv->paper_size_model, &iter, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
	gtk_list_store_append (self->priv->paper_size_model, &_tmp82_);
	iter = _tmp82_;
	gtk_list_store_set (self->priv->paper_size_model, &iter, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
	gtk_list_store_append (self->priv->paper_size_model, &_tmp83_);
	iter = _tmp83_;
	gtk_list_store_set (self->priv->paper_size_model, &iter, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
	_tmp84_ = g_settings_get_int (self->priv->settings, "text-dpi");
	dpi = _tmp84_;
	if (dpi <= 0) {
		dpi = SIMPLE_SCAN_DEFAULT_TEXT_DPI;
	}
	simple_scan_set_dpi_combo (self, self->priv->text_dpi_combo, SIMPLE_SCAN_DEFAULT_TEXT_DPI, dpi);
	_tmp85_ = g_settings_get_int (self->priv->settings, "photo-dpi");
	dpi = _tmp85_;
	if (dpi <= 0) {
		dpi = SIMPLE_SCAN_DEFAULT_PHOTO_DPI;
	}
	simple_scan_set_dpi_combo (self, self->priv->photo_dpi_combo, SIMPLE_SCAN_DEFAULT_PHOTO_DPI, dpi);
	_tmp86_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer = g_object_ref_sink (_tmp86_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->device_combo, (GtkCellRenderer*) renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->device_combo, (GtkCellRenderer*) renderer, "text", 1);
	_tmp87_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = g_object_ref_sink (_tmp87_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->page_side_combo, (GtkCellRenderer*) renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->page_side_combo, (GtkCellRenderer*) renderer, "text", 1);
	_tmp88_ = g_settings_get_enum (self->priv->settings, "page-side");
	simple_scan_set_page_side (self, (ScanType) _tmp88_);
	_tmp89_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = g_object_ref_sink (_tmp89_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->paper_size_combo, (GtkCellRenderer*) renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->paper_size_combo, (GtkCellRenderer*) renderer, "text", 2);
	_tmp90_ = g_settings_get_int (self->priv->settings, "paper-width");
	paper_width = _tmp90_;
	_tmp91_ = g_settings_get_int (self->priv->settings, "paper-height");
	paper_height = _tmp91_;
	simple_scan_set_paper_size (self, paper_width, paper_height);
	_tmp92_ = g_settings_get_string (self->priv->settings, "selected-device");
	device = _tmp92_;
	if (device != NULL) {
		GtkTreeIter _tmp93_ = {0};
		gboolean _tmp94_;
		_tmp94_ = simple_scan_find_scan_device (self, device, &_tmp93_);
		iter = _tmp93_;
		if (_tmp94_) {
			gtk_combo_box_set_active_iter (self->priv->device_combo, &iter);
		}
	}
	_tmp95_ = g_settings_get_string (self->priv->settings, "document-type");
	document_type = _tmp95_;
	if (document_type != NULL) {
		simple_scan_set_document_hint (self, document_type);
	}
	_tmp96_ = book_view_new (self->priv->book);
	_g_object_unref0 (self->priv->book_view);
	self->priv->book_view = g_object_ref_sink (_tmp96_);
	gtk_container_set_border_width ((GtkContainer*) self->priv->book_view, (guint) 18);
	gtk_box_pack_end ((GtkBox*) self->priv->main_vbox, (GtkWidget*) self->priv->book_view, TRUE, TRUE, (guint) 0);
	g_signal_connect (self->priv->book_view, "page-selected", (GCallback) _simple_scan_page_selected_cb_book_view_page_selected, self);
	g_signal_connect (self->priv->book_view, "show-page", (GCallback) _simple_scan_show_page_cb_book_view_show_page, self);
	g_signal_connect (self->priv->book_view, "show-menu", (GCallback) _simple_scan_show_page_menu_cb_book_view_show_menu, self);
	gtk_widget_show ((GtkWidget*) self->priv->book_view);
	_tmp97_ = g_settings_get_enum (self->priv->settings, "scan-direction");
	self->priv->default_page_scan_direction = (ScanDirection) _tmp97_;
	_tmp98_ = g_settings_get_int (self->priv->settings, "page-width");
	self->priv->default_page_width = _tmp98_;
	if (self->priv->default_page_width <= 0) {
		self->priv->default_page_width = 595;
	}
	_tmp99_ = g_settings_get_int (self->priv->settings, "page-height");
	self->priv->default_page_height = _tmp99_;
	if (self->priv->default_page_height <= 0) {
		self->priv->default_page_height = 842;
	}
	_tmp100_ = g_settings_get_int (self->priv->settings, "page-dpi");
	self->priv->default_page_dpi = _tmp100_;
	if (self->priv->default_page_dpi <= 0) {
		self->priv->default_page_dpi = 72;
	}
	_tmp101_ = g_settings_get_int (self->priv->settings, "window-width");
	self->priv->window_width = _tmp101_;
	if (self->priv->window_width <= 0) {
		self->priv->window_width = 600;
	}
	_tmp102_ = g_settings_get_int (self->priv->settings, "window-height");
	self->priv->window_height = _tmp102_;
	if (self->priv->window_height <= 0) {
		self->priv->window_height = 400;
	}
	g_debug ("ui.vala:1407: Restoring window to %dx%d pixels", self->priv->window_width, self->priv->window_height);
	gtk_window_set_default_size (self->priv->window, self->priv->window_width, self->priv->window_height);
	_tmp103_ = g_settings_get_boolean (self->priv->settings, "window-is-maximized");
	self->priv->window_is_maximized = _tmp103_;
	if (self->priv->window_is_maximized) {
		g_debug ("ui.vala:1412: Restoring window to maximized");
		gtk_window_maximize (self->priv->window);
	}
	_tmp104_ = book_get_n_pages (self->priv->book);
	if (_tmp104_ == ((guint) 0)) {
		simple_scan_add_default_page (self);
	}
	book_set_needs_saving (self->priv->book, FALSE);
	g_signal_connect (self->priv->book, "needs-saving-changed", (GCallback) _simple_scan_needs_saving_cb_book_needs_saving_changed, self);
	_g_free0 (document_type);
	_g_free0 (device);
	_g_object_unref0 (renderer);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hbox);
	_g_free0 (filename);
}


static gpointer _book_ref0 (gpointer self) {
	return self ? book_ref (self) : NULL;
}


Book* simple_scan_get_book (SimpleScan* self) {
	Book* result = NULL;
	Book* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _book_ref0 (self->priv->book);
	result = _tmp0_;
	return result;
}


void simple_scan_set_selected_page (SimpleScan* self, Page* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	book_view_select_page (self->priv->book_view, page);
}


Page* simple_scan_get_selected_page (SimpleScan* self) {
	Page* result = NULL;
	Page* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = book_view_get_selected (self->priv->book_view);
	result = _tmp0_;
	return result;
}


void simple_scan_set_scanning (SimpleScan* self, gboolean scanning) {
	g_return_if_fail (self != NULL);
	self->priv->scanning = scanning;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->page_delete_menuitem, !scanning);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->stop_menuitem, scanning);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->stop_toolbutton, scanning);
}


void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_title != NULL);
	g_return_if_fail (error_text != NULL);
	self->priv->have_error = TRUE;
	_tmp0_ = g_strdup (error_title);
	_g_free0 (self->priv->error_title);
	self->priv->error_title = _tmp0_;
	_tmp1_ = g_strdup (error_text);
	_g_free0 (self->priv->error_text);
	self->priv->error_text = _tmp1_;
	self->priv->error_change_scanner_hint = change_scanner_hint;
	simple_scan_update_info_bar (self);
}


void simple_scan_start (SimpleScan* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show ((GtkWidget*) self->priv->window);
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
}


static void value_simple_scan_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_simple_scan_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		simple_scan_unref (value->data[0].v_pointer);
	}
}


static void value_simple_scan_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = simple_scan_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_simple_scan_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_simple_scan_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SimpleScan* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = simple_scan_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_simple_scan_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SimpleScan** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = simple_scan_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSimpleScan* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SIMPLE_SCAN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_simple_scan (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN), NULL);
	return value->data[0].v_pointer;
}


void value_set_simple_scan (GValue* value, gpointer v_object) {
	SimpleScan* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SIMPLE_SCAN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		simple_scan_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		simple_scan_unref (old);
	}
}


void value_take_simple_scan (GValue* value, gpointer v_object) {
	SimpleScan* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SIMPLE_SCAN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		simple_scan_unref (old);
	}
}


static void simple_scan_class_init (SimpleScanClass * klass) {
	simple_scan_parent_class = g_type_class_peek_parent (klass);
	SIMPLE_SCAN_CLASS (klass)->finalize = simple_scan_finalize;
	g_type_class_add_private (klass, sizeof (SimpleScanPrivate));
	g_signal_new ("start_scan", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
	g_signal_new ("stop_scan", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("email", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("quit", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void simple_scan_instance_init (SimpleScan * self) {
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self->priv = SIMPLE_SCAN_GET_PRIVATE (self);
	self->priv->book_uri = NULL;
	_tmp0_ = g_strdup ("photo");
	self->priv->document_hint = _tmp0_;
	_tmp1_ = _ ("Scanned Document.pdf");
	_tmp2_ = g_strdup (_tmp1_);
	self->priv->default_file_name = _tmp2_;
	self->priv->scanning = FALSE;
	self->ref_count = 1;
}


static void simple_scan_finalize (SimpleScan* obj) {
	SimpleScan * self;
	self = SIMPLE_SCAN (obj);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->info_bar);
	_g_object_unref0 (self->priv->info_bar_image);
	_g_object_unref0 (self->priv->info_bar_label);
	_g_object_unref0 (self->priv->info_bar_close_button);
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
	_g_object_unref0 (self->priv->page_move_left_menuitem);
	_g_object_unref0 (self->priv->page_move_right_menuitem);
	_g_object_unref0 (self->priv->page_delete_menuitem);
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
	_g_object_unref0 (self->priv->save_menuitem);
	_g_object_unref0 (self->priv->save_as_menuitem);
	_g_object_unref0 (self->priv->save_toolbutton);
	_g_object_unref0 (self->priv->stop_menuitem);
	_g_object_unref0 (self->priv->stop_toolbutton);
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
	_g_object_unref0 (self->priv->text_menu_menuitem);
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
	_g_object_unref0 (self->priv->photo_menu_menuitem);
	_g_object_unref0 (self->priv->authorize_dialog);
	_g_object_unref0 (self->priv->authorize_label);
	_g_object_unref0 (self->priv->username_entry);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->device_combo);
	_g_object_unref0 (self->priv->text_dpi_combo);
	_g_object_unref0 (self->priv->photo_dpi_combo);
	_g_object_unref0 (self->priv->page_side_combo);
	_g_object_unref0 (self->priv->paper_size_combo);
	_g_object_unref0 (self->priv->device_model);
	_g_object_unref0 (self->priv->text_dpi_model);
	_g_object_unref0 (self->priv->photo_dpi_model);
	_g_object_unref0 (self->priv->page_side_model);
	_g_object_unref0 (self->priv->paper_size_model);
	_g_object_unref0 (self->priv->save_dialog);
	_g_free0 (self->priv->error_title);
	_g_free0 (self->priv->error_text);
	_book_unref0 (self->priv->book);
	_g_free0 (self->priv->book_uri);
	_g_object_unref0 (self->priv->book_view);
	_g_free0 (self->priv->document_hint);
	_g_free0 (self->priv->default_file_name);
}


GType simple_scan_get_type (void) {
	static volatile gsize simple_scan_type_id__volatile = 0;
	if (g_once_init_enter (&simple_scan_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_simple_scan_init, value_simple_scan_free_value, value_simple_scan_copy_value, value_simple_scan_peek_pointer, "p", value_simple_scan_collect_value, "p", value_simple_scan_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType simple_scan_type_id;
		simple_scan_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SimpleScan", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&simple_scan_type_id__volatile, simple_scan_type_id);
	}
	return simple_scan_type_id__volatile;
}


gpointer simple_scan_ref (gpointer instance) {
	SimpleScan* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void simple_scan_unref (gpointer instance) {
	SimpleScan* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SIMPLE_SCAN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



