/* simple-scan.c generated by valac 0.13.0, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gudev/gudev.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <sane/sane.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <locale.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _simple_scan_unref0(var) ((var == NULL) ? NULL : (var = (simple_scan_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))
typedef struct _ParamSpecApplication ParamSpecApplication;

struct _Application {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GTypeClass parent_class;
	void (*finalize) (Application *self);
};

struct _ApplicationPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUdevClient* udev_client;
	SimpleScan* ui;
	Scanner* scanner;
	Book* book;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecApplication {
	GParamSpec parent_instance;
};


static gpointer application_parent_class = NULL;
static gboolean application_show_version;
static gboolean application_show_version = FALSE;
static gboolean application_debug_enabled;
static gboolean application_debug_enabled = FALSE;
static GTimer* application_log_timer;
static GTimer* application_log_timer = NULL;
static FILE* application_log_file;
static FILE* application_log_file = NULL;

gpointer application_ref (gpointer instance);
void application_unref (gpointer instance);
GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_application (GValue* value, gpointer v_object);
void value_take_application (GValue* value, gpointer v_object);
gpointer value_get_application (const GValue* value);
GType application_get_type (void) G_GNUC_CONST;
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
gpointer simple_scan_ref (gpointer instance);
void simple_scan_unref (gpointer instance);
GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_simple_scan (GValue* value, gpointer v_object);
void value_take_simple_scan (GValue* value, gpointer v_object);
gpointer value_get_simple_scan (const GValue* value);
GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
Application* application_new (ScanDevice* device);
Application* application_construct (GType object_type, ScanDevice* device);
SimpleScan* simple_scan_new (void);
SimpleScan* simple_scan_construct (GType object_type);
Book* simple_scan_get_book (SimpleScan* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static void application_scan_cb (Application* self, SimpleScan* ui, const gchar* device, ScanOptions* options);
static void _application_scan_cb_simple_scan_start_scan (SimpleScan* _sender, const gchar* device, ScanOptions* options, gpointer self);
static void application_cancel_cb (Application* self, SimpleScan* ui);
static void _application_cancel_cb_simple_scan_stop_scan (SimpleScan* _sender, gpointer self);
static void application_email_cb (Application* self, SimpleScan* ui, const gchar* profile);
static void _application_email_cb_simple_scan_email (SimpleScan* _sender, const gchar* profile, gpointer self);
static void application_quit_cb (Application* self, SimpleScan* ui);
static void _application_quit_cb_simple_scan_quit (SimpleScan* _sender, gpointer self);
Scanner* scanner_get_instance (void);
static void application_update_scan_devices_cb (Application* self, Scanner* scanner, GList* devices);
static void _application_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self);
static void application_authorize_cb (Application* self, Scanner* scanner, const gchar* resource);
static void _application_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self);
static void application_scanner_new_page_cb (Application* self, Scanner* scanner);
static void _application_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
static void application_scanner_page_info_cb (Application* self, Scanner* scanner, ScanPageInfo* info);
static void _application_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void application_scanner_line_cb (Application* self, Scanner* scanner, ScanLine* line);
static void _application_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self);
static void application_scanner_page_done_cb (Application* self, Scanner* scanner);
static void _application_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self);
static void application_scanner_document_done_cb (Application* self, Scanner* scanner);
static void _application_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self);
static void application_scanner_failed_cb (Application* self, Scanner* scanner, gint error_code, const gchar* error_string);
static void _application_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self);
static void application_scanner_scanning_changed_cb (Application* self, Scanner* scanner);
static void _application_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self);
static void application_on_uevent (Application* self, GUdevClient* client, const gchar* action, GUdevDevice* device);
static void _application_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
void simple_scan_set_scan_devices (SimpleScan* self, GList* devices);
void simple_scan_set_selected_device (SimpleScan* self, const gchar* device);
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
void application_start (Application* self);
void simple_scan_start (SimpleScan* self);
void scanner_start (Scanner* self);
void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static Page* application_append_page (Application* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_has_data (Page* self);
void simple_scan_set_selected_page (SimpleScan* self, Page* page);
void page_start (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void page_set_named_crop (Page* self, const gchar* name);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
static gchar* application_get_profile_for_device (Application* self, const gchar* device_name);
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* color_profile);
guint book_get_n_pages (Book* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
static void application_remove_empty_page (Application* self);
void book_delete_page (Book* self, Page* page);
void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void simple_scan_set_scanning (SimpleScan* self, gboolean scanning);
gboolean scanner_is_scanning (Scanner* self);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
static gchar* application_get_temporary_filename (Application* self, const gchar* prefix, const gchar* extension);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
void scanner_free (Scanner* self);
static void application_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
void scanner_redetect (Scanner* self);
gint application_main (gchar** args, int args_length1);
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void _application_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void application_finalize (Application* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry APPLICATION_options[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &application_show_version, "Show release version", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &application_debug_enabled, "Print debugging messages", NULL}, {NULL}};

static gpointer _scan_device_ref0 (gpointer self) {
	return self ? scan_device_ref (self) : NULL;
}


static void _application_scan_cb_simple_scan_start_scan (SimpleScan* _sender, const gchar* device, ScanOptions* options, gpointer self) {
	application_scan_cb (self, _sender, device, options);
}


static void _application_cancel_cb_simple_scan_stop_scan (SimpleScan* _sender, gpointer self) {
	application_cancel_cb (self, _sender);
}


static void _application_email_cb_simple_scan_email (SimpleScan* _sender, const gchar* profile, gpointer self) {
	application_email_cb (self, _sender, profile);
}


static void _application_quit_cb_simple_scan_quit (SimpleScan* _sender, gpointer self) {
	application_quit_cb (self, _sender);
}


static void _application_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self) {
	application_update_scan_devices_cb (self, _sender, devices);
}


static void _application_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self) {
	application_authorize_cb (self, _sender, resource);
}


static void _application_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self) {
	application_scanner_new_page_cb (self, _sender);
}


static void _application_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self) {
	application_scanner_page_info_cb (self, _sender, info);
}


static void _application_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self) {
	application_scanner_line_cb (self, _sender, line);
}


static void _application_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self) {
	application_scanner_page_done_cb (self, _sender);
}


static void _application_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self) {
	application_scanner_document_done_cb (self, _sender);
}


static void _application_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self) {
	application_scanner_failed_cb (self, _sender, error_code, error_string);
}


static void _application_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self) {
	application_scanner_scanning_changed_cb (self, _sender);
}


static void _application_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
	application_on_uevent (self, _sender, action, device);
}


static void _scan_device_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
	g_list_free (self);
}


Application* application_construct (GType object_type, ScanDevice* device) {
	Application* self = NULL;
	ScanDevice* _tmp0_;
	SimpleScan* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	Scanner* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** subsystems;
	gint subsystems_length1;
	gint _subsystems_size_;
	GUdevClient* _tmp6_ = NULL;
	self = (Application*) g_type_create_instance (object_type);
	_tmp0_ = _scan_device_ref0 (device);
	_scan_device_unref0 (self->priv->default_device);
	self->priv->default_device = _tmp0_;
	_tmp1_ = simple_scan_new ();
	_simple_scan_unref0 (self->priv->ui);
	self->priv->ui = _tmp1_;
	_tmp2_ = simple_scan_get_book (self->priv->ui);
	_book_unref0 (self->priv->book);
	self->priv->book = _tmp2_;
	g_signal_connect (self->priv->ui, "start-scan", (GCallback) _application_scan_cb_simple_scan_start_scan, self);
	g_signal_connect (self->priv->ui, "stop-scan", (GCallback) _application_cancel_cb_simple_scan_stop_scan, self);
	g_signal_connect (self->priv->ui, "email", (GCallback) _application_email_cb_simple_scan_email, self);
	g_signal_connect (self->priv->ui, "quit", (GCallback) _application_quit_cb_simple_scan_quit, self);
	_tmp3_ = scanner_get_instance ();
	_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp3_;
	g_signal_connect (self->priv->scanner, "update-devices", (GCallback) _application_update_scan_devices_cb_scanner_update_devices, self);
	g_signal_connect (self->priv->scanner, "request-authorization", (GCallback) _application_authorize_cb_scanner_request_authorization, self);
	g_signal_connect (self->priv->scanner, "expect-page", (GCallback) _application_scanner_new_page_cb_scanner_expect_page, self);
	g_signal_connect (self->priv->scanner, "got-page-info", (GCallback) _application_scanner_page_info_cb_scanner_got_page_info, self);
	g_signal_connect (self->priv->scanner, "got-line", (GCallback) _application_scanner_line_cb_scanner_got_line, self);
	g_signal_connect (self->priv->scanner, "page-done", (GCallback) _application_scanner_page_done_cb_scanner_page_done, self);
	g_signal_connect (self->priv->scanner, "document-done", (GCallback) _application_scanner_document_done_cb_scanner_document_done, self);
	g_signal_connect (self->priv->scanner, "scan-failed", (GCallback) _application_scanner_failed_cb_scanner_scan_failed, self);
	g_signal_connect (self->priv->scanner, "scanning-changed", (GCallback) _application_scanner_scanning_changed_cb_scanner_scanning_changed, self);
	_tmp4_ = g_strdup ("usb");
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp5_[1] = NULL;
	subsystems = _tmp5_;
	subsystems_length1 = 2;
	_subsystems_size_ = subsystems_length1;
	_tmp6_ = g_udev_client_new (subsystems);
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = _tmp6_;
	g_signal_connect (self->priv->udev_client, "uevent", (GCallback) _application_on_uevent_g_udev_client_uevent, self);
	if (self->priv->default_device != NULL) {
		GList* device_list;
		ScanDevice* _tmp7_;
		device_list = NULL;
		_tmp7_ = _scan_device_ref0 (self->priv->default_device);
		device_list = g_list_append (device_list, _tmp7_);
		simple_scan_set_scan_devices (self->priv->ui, device_list);
		simple_scan_set_selected_device (self->priv->ui, self->priv->default_device->name);
		__g_list_free__scan_device_unref0_0 (device_list);
	}
	subsystems = (_vala_array_free (subsystems, subsystems_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


Application* application_new (ScanDevice* device) {
	return application_construct (TYPE_APPLICATION, device);
}


void application_start (Application* self) {
	g_return_if_fail (self != NULL);
	simple_scan_start (self->priv->ui);
	scanner_start (self->priv->scanner);
}


static void application_update_scan_devices_cb (Application* self, Scanner* scanner, GList* devices) {
	GList* _tmp0_ = NULL;
	GList* devices_copy;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = g_list_copy (devices);
	devices_copy = _tmp0_;
	if (self->priv->default_device != NULL) {
		gboolean default_in_list;
		default_in_list = FALSE;
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
			device_collection = devices_copy;
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
				ScanDevice* device = NULL;
				device = (ScanDevice*) device_it->data;
				{
					if (g_strcmp0 (device->name, self->priv->default_device->name) == 0) {
						default_in_list = TRUE;
						break;
					}
				}
			}
		}
		if (!default_in_list) {
			devices_copy = g_list_prepend (devices_copy, self->priv->default_device);
		}
	}
	_tmp1_ = g_list_length (devices_copy);
	self->priv->have_devices = _tmp1_ > 0;
	simple_scan_set_scan_devices (self->priv->ui, devices_copy);
	_g_list_free0 (devices_copy);
}


static void application_authorize_cb (Application* self, Scanner* scanner, const gchar* resource) {
	gchar* username = NULL;
	gchar* password = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (resource != NULL);
	simple_scan_authorize (self->priv->ui, resource, &_tmp0_, &_tmp1_);
	_g_free0 (username);
	username = _tmp0_;
	_g_free0 (password);
	password = _tmp1_;
	scanner_authorize (scanner, username, password);
	_g_free0 (password);
	_g_free0 (username);
}


static Page* application_append_page (Application* self) {
	Page* result = NULL;
	Page* _tmp0_ = NULL;
	Page* page;
	gboolean _tmp1_ = FALSE;
	ScanDirection scan_direction;
	gboolean do_crop;
	gchar* named_crop;
	gint width;
	gint height;
	gint dpi;
	gint cx;
	gint cy;
	gint cw;
	gint ch;
	Page* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = book_get_page (self->priv->book, -1);
	page = _tmp0_;
	if (page != NULL) {
		gboolean _tmp2_;
		_tmp2_ = page_has_data (page);
		_tmp1_ = !_tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		simple_scan_set_selected_page (self->priv->ui, page);
		page_start (page);
		result = page;
		return result;
	}
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
	do_crop = FALSE;
	named_crop = NULL;
	width = 100;
	height = 100;
	dpi = 100;
	cx = 0;
	cy = 0;
	cw = 0;
	ch = 0;
	if (page != NULL) {
		ScanDirection _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = page_get_scan_direction (page);
		scan_direction = _tmp3_;
		_tmp4_ = page_get_width (page);
		width = _tmp4_;
		_tmp5_ = page_get_height (page);
		height = _tmp5_;
		_tmp6_ = page_get_dpi (page);
		dpi = _tmp6_;
		_tmp7_ = page_has_crop (page);
		do_crop = _tmp7_;
		if (do_crop) {
			gchar* _tmp8_ = NULL;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp8_ = page_get_named_crop (page);
			_g_free0 (named_crop);
			named_crop = _tmp8_;
			page_get_crop (page, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
			cx = _tmp9_;
			cy = _tmp10_;
			cw = _tmp11_;
			ch = _tmp12_;
		}
	}
	_tmp13_ = book_append_page (self->priv->book, width, height, dpi, scan_direction);
	_page_unref0 (page);
	page = _tmp13_;
	if (do_crop) {
		if (named_crop != NULL) {
			page_set_named_crop (page, named_crop);
		} else {
			page_set_custom_crop (page, cw, ch);
		}
		page_move_crop (page, cx, cy);
	}
	simple_scan_set_selected_page (self->priv->ui, page);
	page_start (page);
	result = page;
	_g_free0 (named_crop);
	return result;
}


static void application_scanner_new_page_cb (Application* self, Scanner* scanner) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = application_append_page (self);
	_tmp1_ = _tmp0_;
	_page_unref0 (_tmp1_);
}


static gchar* application_get_profile_for_device (Application* self, const gchar* device_name) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_name != NULL, NULL);
	result = NULL;
	return result;
}


static void application_scanner_page_info_cb (Application* self, Scanner* scanner, ScanPageInfo* info) {
	Page* _tmp0_ = NULL;
	Page* page;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (info != NULL);
	g_debug ("simple-scan.vala:233: Page is %d pixels wide, %d pixels high, %d bits " \
"per pixel", info->width, info->height, info->depth);
	_tmp0_ = application_append_page (self);
	page = _tmp0_;
	page_set_page_info (page, info);
	_tmp1_ = application_get_profile_for_device (self, info->device);
	_tmp2_ = _tmp1_;
	page_set_color_profile (page, _tmp2_);
	_g_free0 (_tmp2_);
	_page_unref0 (page);
}


static void application_scanner_line_cb (Application* self, Scanner* scanner, ScanLine* line) {
	guint _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = book_get_n_pages (self->priv->book);
	_tmp1_ = book_get_page (self->priv->book, ((gint) _tmp0_) - 1);
	page = _tmp1_;
	page_parse_scan_line (page, line);
	_page_unref0 (page);
}


static void application_scanner_page_done_cb (Application* self, Scanner* scanner) {
	guint _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = book_get_n_pages (self->priv->book);
	_tmp1_ = book_get_page (self->priv->book, ((gint) _tmp0_) - 1);
	page = _tmp1_;
	page_finish (page);
	_page_unref0 (page);
}


static void application_remove_empty_page (Application* self) {
	guint _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = book_get_n_pages (self->priv->book);
	_tmp1_ = book_get_page (self->priv->book, ((gint) _tmp0_) - 1);
	page = _tmp1_;
	_tmp2_ = page_has_data (page);
	if (_tmp2_) {
		page_finish (page);
	} else {
		book_delete_page (self->priv->book, page);
	}
	_page_unref0 (page);
}


static void application_scanner_document_done_cb (Application* self, Scanner* scanner) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	application_remove_empty_page (self);
}


static void application_scanner_failed_cb (Application* self, Scanner* scanner, gint error_code, const gchar* error_string) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (error_string != NULL);
	application_remove_empty_page (self);
	if (error_code != SANE_STATUS_CANCELLED) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("Failed to scan");
		simple_scan_show_error (self->priv->ui, _tmp0_, error_string, self->priv->have_devices);
	}
}


static void application_scanner_scanning_changed_cb (Application* self, Scanner* scanner) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner_is_scanning (scanner);
	simple_scan_set_scanning (self->priv->ui, _tmp0_);
}


static void application_scan_cb (Application* self, SimpleScan* ui, const gchar* device, ScanOptions* options) {
	gboolean _tmp0_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* filename_prefix;
	gchar* extension = NULL;
	gchar* _tmp7_ = NULL;
	gchar* filename;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	g_return_if_fail (options != NULL);
	g_debug ("simple-scan.vala:293: Requesting scan at %d dpi from device '%s'", options->dpi, device);
	_tmp0_ = scanner_is_scanning (self->priv->scanner);
	if (!_tmp0_) {
		Page* _tmp1_ = NULL;
		Page* _tmp2_;
		_tmp1_ = application_append_page (self);
		_tmp2_ = _tmp1_;
		_page_unref0 (_tmp2_);
	}
	_tmp3_ = _ ("Scanned Document");
	_tmp4_ = g_strdup (_tmp3_);
	filename_prefix = _tmp4_;
	if (options->scan_mode == SCAN_MODE_COLOR) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("jpg");
		_g_free0 (extension);
		extension = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("pdf");
		_g_free0 (extension);
		extension = _tmp6_;
	}
	_tmp7_ = g_strdup_printf ("%s.%s", filename_prefix, extension);
	filename = _tmp7_;
	simple_scan_set_default_file_name (ui, filename);
	scanner_scan (self->priv->scanner, device, options);
	_g_free0 (filename);
	_g_free0 (extension);
	_g_free0 (filename_prefix);
}


static void application_cancel_cb (Application* self, SimpleScan* ui) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	scanner_cancel (self->priv->scanner);
}


static gchar* application_get_temporary_filename (Application* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* filename;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%sXXXXXX.%s", prefix, extension);
	filename = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gint _tmp2_;
		gint fd;
		_tmp2_ = g_file_open_tmp (filename, &_tmp1_, &_inner_error_);
		_g_free0 (path);
		path = _tmp1_;
		fd = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		close (fd);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("simple-scan.vala:329: Error saving email attachment: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		_g_free0 (filename);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = path;
	_g_free0 (filename);
	return result;
}


static void application_email_cb (Application* self, SimpleScan* ui, const gchar* profile) {
	gboolean saved;
	gchar* _tmp0_;
	gchar* command_line;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	g_return_if_fail (profile != NULL);
	saved = FALSE;
	_tmp0_ = g_strdup ("xdg-email");
	command_line = _tmp0_;
	if (g_strcmp0 (profile, "text") == 0) {
		gchar* _tmp1_ = NULL;
		gchar* path;
		_tmp1_ = application_get_temporary_filename (self, "scan", "pdf");
		path = _tmp1_;
		if (path != NULL) {
			GFile* _tmp2_ = NULL;
			GFile* file;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp2_ = g_file_new_for_path (path);
			file = _tmp2_;
			{
				book_save (self->priv->book, "pdf", file, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				g_warning ("simple-scan.vala:355: Unable to save email file: %s", e->message);
				_g_error_free0 (e);
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_free0 (command_line);
				return;
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_free0 (command_line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp3_ = g_strdup_printf (" --attach %s", path);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strconcat (command_line, _tmp4_, NULL);
			_g_free0 (command_line);
			command_line = _tmp5_;
			_g_free0 (_tmp4_);
			_g_object_unref0 (file);
		}
		_g_free0 (path);
	} else {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					guint _tmp7_;
					gchar* _tmp8_ = NULL;
					gchar* path;
					GFile* _tmp9_ = NULL;
					GFile* file;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					gchar* _tmp14_;
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					_tmp7_ = book_get_n_pages (self->priv->book);
					if (!(i < _tmp7_)) {
						break;
					}
					_tmp8_ = application_get_temporary_filename (self, "scan", "jpg");
					path = _tmp8_;
					if (path == NULL) {
						saved = FALSE;
						_g_free0 (path);
						break;
					}
					_tmp9_ = g_file_new_for_path (path);
					file = _tmp9_;
					{
						Page* _tmp10_ = NULL;
						Page* _tmp11_;
						_tmp10_ = book_get_page (self->priv->book, i);
						_tmp11_ = _tmp10_;
						page_save (_tmp11_, "jpeg", file, &_inner_error_);
						_page_unref0 (_tmp11_);
						if (_inner_error_ != NULL) {
							goto __catch5_g_error;
						}
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						g_warning ("simple-scan.vala:379: Unable to save email file: %s", e->message);
						_g_error_free0 (e);
						_g_object_unref0 (file);
						_g_free0 (path);
						_g_free0 (command_line);
						return;
					}
					__finally5:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						_g_free0 (path);
						_g_free0 (command_line);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp12_ = g_strdup_printf (" --attach %s", path);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (command_line, _tmp13_, NULL);
					_g_free0 (command_line);
					command_line = _tmp14_;
					_g_free0 (_tmp13_);
					if (!saved) {
						_g_object_unref0 (file);
						_g_free0 (path);
						break;
					}
					_g_object_unref0 (file);
					_g_free0 (path);
				}
			}
		}
	}
	g_debug ("simple-scan.vala:389: Launching email client: %s", command_line);
	{
		g_spawn_command_line_async (command_line, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("simple-scan.vala:396: Unable to start email: %s", e->message);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_free0 (command_line);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (command_line);
}


static void application_quit_cb (Application* self, SimpleScan* ui) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	_book_unref0 (self->priv->book);
	self->priv->book = NULL;
	ui = NULL;
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = NULL;
	scanner_free (self->priv->scanner);
	gtk_main_quit ();
}


static void application_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	g_return_if_fail (message != NULL);
	if (application_log_file != NULL) {
		gchar* prefix = NULL;
		gdouble _tmp7_;
		switch (log_level & G_LOG_LEVEL_MASK) {
			case G_LOG_LEVEL_ERROR:
			{
				gchar* _tmp0_;
				_tmp0_ = g_strdup ("ERROR:");
				_g_free0 (prefix);
				prefix = _tmp0_;
				break;
			}
			case G_LOG_LEVEL_CRITICAL:
			{
				gchar* _tmp1_;
				_tmp1_ = g_strdup ("CRITICAL:");
				_g_free0 (prefix);
				prefix = _tmp1_;
				break;
			}
			case G_LOG_LEVEL_WARNING:
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("WARNING:");
				_g_free0 (prefix);
				prefix = _tmp2_;
				break;
			}
			case G_LOG_LEVEL_MESSAGE:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("MESSAGE:");
				_g_free0 (prefix);
				prefix = _tmp3_;
				break;
			}
			case G_LOG_LEVEL_INFO:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("INFO:");
				_g_free0 (prefix);
				prefix = _tmp4_;
				break;
			}
			case G_LOG_LEVEL_DEBUG:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("DEBUG:");
				_g_free0 (prefix);
				prefix = _tmp5_;
				break;
			}
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("LOG:");
				_g_free0 (prefix);
				prefix = _tmp6_;
				break;
			}
		}
		_tmp7_ = g_timer_elapsed (application_log_timer, NULL);
		fprintf (application_log_file, "[%+.2fs] %s %s\n", _tmp7_, prefix, message);
		_g_free0 (prefix);
	}
	if ((log_level & G_LOG_LEVEL_DEBUG) != 0) {
		if (application_debug_enabled) {
			g_log_default_handler (log_domain, log_level, message, NULL);
		}
	} else {
		g_log_default_handler (log_domain, log_level, message, NULL);
	}
}


static void application_on_uevent (Application* self, GUdevClient* client, const gchar* action, GUdevDevice* device) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	scanner_redetect (self->priv->scanner);
}


static void _application_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	application_log_cb (log_domain, log_levels, message);
}


gint application_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* c;
	GOptionGroup* _tmp2_ = NULL;
	ScanDevice* device;
	GTimer* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* path;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	FILE* _tmp12_ = NULL;
	pid_t _tmp13_;
	Application* _tmp14_ = NULL;
	Application* app;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	_tmp0_ = _ ("[DEVICE...] - Scanning utility");
	_tmp1_ = g_option_context_new (_tmp0_);
	c = _tmp1_;
	g_option_context_add_main_entries (c, APPLICATION_options, GETTEXT_PACKAGE);
	_tmp2_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (c, _tmp2_);
	{
		g_option_context_parse (c, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_tmp3_ = _ ("Run '%s --help' to see a full list of available command line options.");
		fprintf (stderr, _tmp3_, args[0]);
		fprintf (stderr, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (application_show_version) {
		fprintf (stderr, "simple-scan %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	device = NULL;
	if (args_length1 > 1) {
		ScanDevice* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = scan_device_new ();
		_scan_device_unref0 (device);
		device = _tmp4_;
		_tmp5_ = g_strdup (args[1]);
		_g_free0 (device->name);
		device->name = _tmp5_;
		_tmp6_ = g_strdup (args[1]);
		_g_free0 (device->label);
		device->label = _tmp6_;
	}
	_tmp7_ = g_timer_new ();
	_g_timer_destroy0 (application_log_timer);
	application_log_timer = _tmp7_;
	_tmp8_ = g_get_user_cache_dir ();
	_tmp9_ = g_build_filename (_tmp8_, "simple-scan", NULL, NULL);
	path = _tmp9_;
	g_mkdir_with_parents (path, 0700);
	_tmp10_ = g_get_user_cache_dir ();
	_tmp11_ = g_build_filename (_tmp10_, "simple-scan", "simple-scan.log", NULL, NULL);
	_g_free0 (path);
	path = _tmp11_;
	_tmp12_ = fopen (path, "w");
	_fclose0 (application_log_file);
	application_log_file = _tmp12_;
	g_log_set_default_handler (_application_log_cb_glog_func, NULL);
	_tmp13_ = getpid ();
	g_debug ("simple-scan.vala:507: Starting Simple Scan %s, PID=%i", VERSION, (gint) _tmp13_);
	_tmp14_ = application_new (device);
	app = _tmp14_;
	application_start (app);
	gtk_main ();
	result = EXIT_SUCCESS;
	_application_unref0 (app);
	_g_free0 (path);
	_scan_device_unref0 (device);
	_g_option_context_free0 (c);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return application_main (argv, argc);
}


static void value_application_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_application_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		application_unref (value->data[0].v_pointer);
	}
}


static void value_application_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = application_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_application_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_application_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Application* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = application_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_application_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Application** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = application_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecApplication* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_APPLICATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_application (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION), NULL);
	return value->data[0].v_pointer;
}


void value_set_application (GValue* value, gpointer v_object) {
	Application* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		application_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}


void value_take_application (GValue* value, gpointer v_object) {
	Application* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}


static void application_class_init (ApplicationClass * klass) {
	application_parent_class = g_type_class_peek_parent (klass);
	APPLICATION_CLASS (klass)->finalize = application_finalize;
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
}


static void application_instance_init (Application * self) {
	self->priv = APPLICATION_GET_PRIVATE (self);
	self->priv->default_device = NULL;
	self->priv->have_devices = FALSE;
	self->ref_count = 1;
}


static void application_finalize (Application* obj) {
	Application * self;
	self = APPLICATION (obj);
	_scan_device_unref0 (self->priv->default_device);
	_g_object_unref0 (self->priv->udev_client);
	_simple_scan_unref0 (self->priv->ui);
	_scanner_unref0 (self->priv->scanner);
	_book_unref0 (self->priv->book);
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_application_init, value_application_free_value, value_application_copy_value, value_application_peek_pointer, "p", value_application_collect_value, "p", value_application_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType application_type_id;
		application_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Application", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


gpointer application_ref (gpointer instance) {
	Application* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void application_unref (gpointer instance) {
	Application* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		APPLICATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



