/*
 * Text manipulation plugin
 *
 * Author:
 *   JP Rosevear (jpr@arcavia.com)
 */

#include <libscaffold/libscaffold.h>
#include "text-delete.h"

void
text_delete_to_bof(
	GtkWidget*			widget,
	gpointer			data
)
{
	ScaffoldTool*			tool = (ScaffoldTool*)data;

	scaffold_delete_text(tool, 0, scaffold_get_cursor_pos(tool));
}

void
text_delete_to_eof(
	GtkWidget*			widget,
	gpointer			data
)
{
	ScaffoldTool*			tool = (ScaffoldTool*)data;

	scaffold_delete_text(tool, scaffold_get_cursor_pos(tool), scaffold_get_document_length(tool));
}

static glong
get_end_of_line(
	ScaffoldTool*			tool,
	glong				point
)
{
	static glong			eol;

	for(eol = point; eol < scaffold_get_document_length(tool); eol++)
	{
		if(scaffold_get_document_chars(tool, eol, eol + 1 )[0] == '\n' )
		{
			break;
		}
	}

	if(eol < 0)
	{
		eol = 0;
	}
	else if(eol > scaffold_get_document_length(tool))
	{
		eol = scaffold_get_document_length(tool);
	}

	return eol;
}

static glong
get_begin_of_line(
	ScaffoldTool*			tool,
	glong				point
)
{
	static glong			bol;
	gchar*				ch;

	for(bol = point; bol > 0; bol--)
	{
		ch = scaffold_get_document_chars(tool, bol, bol - 1); 
		if(ch[0] == '\n')
		{
			break;
		}
	}

	if(bol < 0)
	{
		bol = 0;
	}
	else if(bol > scaffold_get_document_length(tool))
	{
		bol = scaffold_get_document_length(tool);
	}

	return bol;
}

void
text_delete_to_bol(
	GtkWidget*			widget,
	gpointer			data
)
{
	ScaffoldTool*			tool = (ScaffoldTool*)data;

	scaffold_delete_text(tool, scaffold_get_cursor_pos(tool), get_begin_of_line(tool,
		scaffold_get_cursor_pos(tool)));
}

void
text_delete_to_eol(
	GtkWidget*			widget,
	gpointer			data
)
{
	ScaffoldTool*			tool = (ScaffoldTool*)data;

	scaffold_delete_text(tool, scaffold_get_cursor_pos(tool), get_end_of_line(tool,
		scaffold_get_cursor_pos(tool)));
}
