// $Id: volume.cc,v 1.9 2000/10/31 17:18:22 cactus Exp $

// RadioActive Copyright (C) 1999 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "volume.h"

#include "radioactive.h"

using namespace Gtk;

Volume::Volume():
    Table(1, 2),
    vol_adj(RADIO_VOL_MIN, RADIO_VOL_MIN, RADIO_VOL_MAX, 1, 3),
    btn(_("Mute"))
{
    VScale* vol_scale = new VScale(vol_adj);
    vol_scale->set_draw_value(false);
    vol_scale->set_digits(0);
    vol_scale->set_value_pos(GTK_POS_BOTTOM);
    attach(*manage(vol_scale), 0, 1, 0, 1);

    btn.clicked.connect(slot(this, &Volume::mute_toggle));
    attach(btn, 0, 1, 1, 2, GTK_EXPAND | GTK_FILL,
	   GTK_EXPAND | GTK_FILL, 2, 2);

    vol_adj.value_changed.connect(slot(this, &Volume::volume_changed));
}

void Volume::set_mute(bool state)
{
    btn.set_active(state);
}

void Volume::mute_toggle()
{
    mute(btn.get_active());
}

void Volume::volume_changed()
{
    if (btn.get_active()) {
	btn.clicked();
    }
    change(RADIO_VOL_MAX - (int)vol_adj.get_value());
}

void Volume::set(int val)
{
    vol_adj.set_value(RADIO_VOL_MAX - val);
}

int Volume::get()
{
    return (RADIO_VOL_MAX - (int)vol_adj.get_value());
}
