// $Id: file.cc,v 1.19 2001/02/07 17:05:08 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "file.h"
#include "radioactive.h"

#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <libgnome/gnome-config.h>
#include <locale.h>

namespace arg /* Keep this in sync with common/file.h */
{
    string devfile = DEVFILE;
    float tune_step = 0.1;
    double freq = 0;
    int volume = 0;
    int last_button = 0;
    bool console = false;
    bool mute_exit = false;
    bool mute = false;

    int progbutton_row = 3;
    int progbutton_col = 3;
    
    int pos_x = -1;
    int pos_y = -1;
    bool save_pos = true;
}

void read_config()
{
    gnome_config_push_prefix("/" PROGNAME "/");

    arg::devfile = gnome_config_get_string("general/device=" DEVFILE);
    arg::tune_step = gnome_config_get_float ("general/tune_step=0.1");
    arg::freq = gnome_config_get_float("general/last=0");
    arg::volume = gnome_config_get_int("general/volume=10");
    arg::mute_exit = gnome_config_get_bool("general/mute_exit=false");
    arg::mute = gnome_config_get_bool("general/mute=false");
    arg::last_button = gnome_config_get_int("general/last_button=0");

    arg::progbutton_col = gnome_config_get_int ("wndMain/progbutton_col=3");
    arg::progbutton_row = gnome_config_get_int ("wndMain/progbutton_row=3");

    arg::pos_x = gnome_config_get_int("wndMain/pos_x=-1");
    arg::pos_y = gnome_config_get_int("wndMain/pos_y=-1");
    arg::save_pos = gnome_config_get_bool("wndMain/save_pos=true");

    gnome_config_pop_prefix();
}

void save_config()
{
    gnome_config_push_prefix("/" PROGNAME "/");

    gnome_config_set_string("general/device", arg::devfile.c_str());
    gnome_config_set_float("general/tune_step", arg::tune_step);
    gnome_config_set_float("general/last", arg::freq);
    gnome_config_set_int("general/volume", arg::volume);
    gnome_config_set_bool("general/mute_exit", arg::mute_exit);
    gnome_config_set_bool("general/mute", arg::mute);
    gnome_config_set_int("general/last_button", arg::last_button);

    gnome_config_set_int("wndMain/progbutton_col", arg::progbutton_col);
    gnome_config_set_int("wndMain/progbutton_row", arg::progbutton_row);

    gnome_config_set_bool("wndMain/save_pos", arg::save_pos);
    if (arg::save_pos)
    {
	gnome_config_set_int("wndMain/pos_x", arg::pos_x);
	gnome_config_set_int("wndMain/pos_y", arg::pos_y);
    } else {
	gnome_config_set_int("wndMain/pos_x", -1);
	gnome_config_set_int("wndMain/pos_y", -1);
    }
    
    gnome_config_pop_prefix();
    gnome_config_sync();
}

const char* rc_file(const string& filename)
{
    string retval(getenv("HOME"));
    retval += (string)"/" + RADIO_RCDIR;

    struct stat buf;
    if (stat(retval.c_str(), &buf)){
	cout << "creating " << retval << endl;
	mkdir(retval.c_str(), 7*8*8);
    }

    retval += (string)"/" + filename;
    return strdup(retval.c_str());
}

static vector<pair<float, string> > load_button_values_old (int num)
{
    vector<pair<float, string> > retval(num,
					pair<float, string>((float)0,
							    "Station"));
    ifstream fin(rc_file("speedtuner"));
    
    // This is needed for the decimal delimeter
    char *old_locale = g_strdup (setlocale (LC_NUMERIC, NULL));
    setlocale (LC_NUMERIC, "C");
    
    for (int i = 0; i < num; i++)
    {
	fin >> retval[i].first;
	getline(fin, retval[i].second);
	string::size_type chomp_start;
	if ((chomp_start = retval[i].second.find_first_not_of(" \t"))
	    != string::npos)
	    retval[i].second.erase(0, chomp_start);
    }

    setlocale (LC_NUMERIC, old_locale);
    g_free (old_locale);

    return retval;
}

vector<pair<float, string> > load_button_values(int num)
{
    vector<pair<float, string> > retval (num, pair<float, string> ((float)0, "Station"));
    char *name_str, *value_str;

    int last_version = 0;
    
    char *name_val;
    float value_val;

    int station_num;
    vector <pair <float, string> >::iterator i;

    last_version = gnome_config_get_int ("/" PROGNAME "/general/last_version=0");
    if (last_version < 1)
    {
	// Update station format
	retval = load_button_values_old (num);
	save_button_values (retval);
	gnome_config_set_int ("/" PROGNAME "/general/last_version", 1);
	gnome_config_sync ();
	
	return retval;
    }
    
    gnome_config_push_prefix("/" PROGNAME "/Stations/");

    for (i = retval.begin(), station_num = 0;
	 station_num < num;
	 i++, station_num++)
    {
	name_str = g_strdup_printf ("name_%d", station_num);
	value_str = g_strdup_printf ("freq_%d", station_num);
	
	name_val = gnome_config_get_string (name_str);
	value_val = gnome_config_get_float (value_str);

	if (name_val)
	{
	    i->first = value_val;
	    i->second = name_val;

	    g_free (name_val);
	}
	    
	g_free (name_str);
	g_free (value_str);
    }

    gnome_config_pop_prefix();    
    
    return retval;
}

void save_button_values(vector<pair<float, string> > values)
{
    char *name_str, *value_str;

    int station_num;
    vector <pair <float, string> >::iterator i;
    
    gnome_config_push_prefix("/" PROGNAME "/Stations/");

    for (i = values.begin(), station_num = 0;
	 i != values.end ();
	 i++, station_num++)
    {
	name_str = g_strdup_printf ("name_%d", station_num);
	value_str = g_strdup_printf ("freq_%d", station_num);
	
	gnome_config_set_string (name_str, i->second.c_str ());
	gnome_config_set_float (value_str, i->first);

	g_free (name_str);
	g_free (value_str);
    }

    gnome_config_pop_prefix();
    gnome_config_sync();
}

