// $Id: applet.h,v 1.15 2000/10/31 17:18:22 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIO_APPLET_H
#define RADIO_APPLET_H

#include "radioactive.h"
#include <gtk--.h>
#include <panel--.h>

#include "common/wndMain.h"
#include "common/driver.h"
#include "common/tuner.h"

class RApplet: public Gnome::Applet
{
    Radio& radio;

    Gtk::Label label;
    Gtk::EventBox eventbox;
    wndMain& w;

    int button;
    int cycle_start;
    bool in_cycle;
    vector<pair<float, string> > prog_vals;
public:
    RApplet(Radio& radiodev, wndMain& wnd);
    
    void set_vals(const vector<pair<float, string> >& vals);
    void set_val(int num, const pair<float, string>& val);
    int get_num();
    void set_num(int val);
private:
    void show_wnd();
    void prev();
    void next();
    void update_channel();
};

#endif /* RADIO_APPLET_H */
