/* -*- mode: C; c-basic-offset: 4 -*- */
#ifndef PYORBIT_H
#define PYORBIT_H

#include <Python.h>
#include <orbit/orbit.h>

typedef struct {
    PyObject_HEAD
    CORBA_Object objref;
} PyCORBA_Object;

extern PyTypeObject PyCORBA_Object_Type;
PyObject *pycorba_object_new(CORBA_Object objref);

typedef struct {
    PyObject_HEAD
    CORBA_ORB orb;
} PyCORBA_ORB;

extern PyTypeObject PyCORBA_ORB_Type;
PyObject *pycorba_orb_new(CORBA_ORB orb);

typedef struct {
    PyObject_HEAD
    CORBA_TypeCode tc;
} PyCORBA_TypeCode;

extern PyTypeObject PyCORBA_TypeCode_Type;
PyObject *pycorba_typecode_new(CORBA_TypeCode tc);

typedef struct {
    PyObject_HEAD
    CORBA_any any;
} PyCORBA_Any;

extern PyTypeObject PyCORBA_Any_Type;
PyObject *pycorba_any_new(CORBA_any *any);

PyTypeObject PyCORBA_Struct_Type;
PyTypeObject PyCORBA_Union_Type;

#endif
