/* -*- mode: C; c-basic-offset: 4 -*- */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "pyorbit-private.h"

PyObject *pyorbit_exception;
PyObject *pyorbit_system_exception;
PyObject *pyorbit_user_exception;

gboolean
pyorbit_check_ex(CORBA_Environment *ev)
{
    gboolean ret;
    if (ev->_major != CORBA_NO_EXCEPTION) {
	CORBA_any any;
	PyObject *instance;

	any = ev->_any;
	any._type = pyorbit_lookup_typecode(ev->_id);
	instance = pyorbit_demarshal_any(&any);
	if (instance) {
	    PyObject *stub, *attr;

	    attr = PyString_FromString(ev->_id);
	    PyObject_SetAttrString(instance, "_id", attr);
	    Py_DECREF(attr);
	
	    attr = PyInt_FromLong(ev->_major);
	    PyObject_SetAttrString(instance, "_major", attr);
	    Py_DECREF(attr);

	    stub = PyObject_GetAttrString(instance, "__class__");
	    PyErr_SetObject(stub, instance);
	    Py_DECREF(stub);
	    Py_DECREF(instance);
	} else {
	    PyErr_SetString(pyorbit_exception, ev->_id ? ev->_id : "(null)");
	}
    }

    ret = (ev->_major != CORBA_NO_EXCEPTION);
    CORBA_exception_free(ev);
    return ret;
}

static PyObject *
create_system_exception(CORBA_TypeCode tc, PyObject *corbamod)
{
    PyObject *exc;
    gchar *exc_name;

    exc_name = g_strconcat("CORBA.", tc->name, NULL);
    exc = PyErr_NewException(exc_name, pyorbit_system_exception, NULL);
    g_free(exc_name);

    pyorbit_register_stub(tc, exc);
    PyModule_AddObject(corbamod, tc->name, exc);

    return exc;
}

static PyObject *
pyorbit_exception_init(PyObject *self, PyObject *args)
{
    gint len, i;
    PyObject *pytc;
    CORBA_TypeCode tc;

    /* for the zero argument case, don't do anything */
    len = PyTuple_Size(args);
    if (len == 0) {
	Py_INCREF(Py_None);
	return Py_None;
    }

    pytc = PyObject_GetAttrString(self, "__typecode__");
    if (!pytc)
	return NULL;
    if (!PyObject_TypeCheck(pytc, &PyCORBA_TypeCode_Type)) {
	Py_DECREF(pytc);
	PyErr_SetString(PyExc_TypeError,
			"__typecode__ attribute not a typecode");
	return NULL;
    }
    tc = ((PyCORBA_TypeCode *)pytc)->tc;
    Py_DECREF(pytc);

    if (tc->sub_parts != len) {
	PyErr_Format(PyExc_TypeError, "expected %d arguments, got %d",
		     tc->sub_parts, len);
	return NULL;
    }

    for (i = 0; i < len; i++) {
	PyObject *item  = PyTuple_GetItem(args, i);

	PyObject_SetAttrString(self, tc->subnames[i], item);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef pyorbit_exception_init_methoddef = {
    "__init__", pyorbit_exception_init, METH_VARARGS
};

void
pyorbit_register_exceptions(PyObject *corbamod)
{
    PyObject *init;

    /* base exception classes */
    pyorbit_exception = PyErr_NewException("CORBA.Exception",
					   PyExc_RuntimeError, NULL);
    /* exception constructor */
    init = PyDescr_NewMethod((PyTypeObject *)pyorbit_exception,
			     &pyorbit_exception_init_methoddef);
    PyObject_SetAttrString(pyorbit_exception, "__init__", init);
    Py_DECREF(init);

    PyModule_AddObject(corbamod, "Exception", pyorbit_exception);
    pyorbit_system_exception = PyErr_NewException("CORBA.SystemException",
						  pyorbit_exception, NULL);
    PyModule_AddObject(corbamod, "SystemException", pyorbit_system_exception);
    pyorbit_user_exception = PyErr_NewException("CORBA.UserException",
						pyorbit_exception, NULL);
    PyModule_AddObject(corbamod, "UserException", pyorbit_user_exception);

    create_system_exception(TC_CORBA_UNKNOWN, corbamod);
    create_system_exception(TC_CORBA_BAD_PARAM, corbamod);
    create_system_exception(TC_CORBA_NO_MEMORY, corbamod);
    create_system_exception(TC_CORBA_IMP_LIMIT, corbamod);
    create_system_exception(TC_CORBA_COMM_FAILURE, corbamod);
    create_system_exception(TC_CORBA_INV_OBJREF, corbamod);
    create_system_exception(TC_CORBA_NO_PERMISSION, corbamod);
    create_system_exception(TC_CORBA_INTERNAL, corbamod);
    create_system_exception(TC_CORBA_MARSHAL, corbamod);
    create_system_exception(TC_CORBA_INITIALIZE, corbamod);
    create_system_exception(TC_CORBA_NO_IMPLEMENT, corbamod);
    create_system_exception(TC_CORBA_BAD_TYPECODE, corbamod);
    create_system_exception(TC_CORBA_BAD_OPERATION, corbamod);
    create_system_exception(TC_CORBA_NO_RESOURCES, corbamod);
    create_system_exception(TC_CORBA_NO_RESPONSE, corbamod);
    create_system_exception(TC_CORBA_PERSIST_STORE, corbamod);
    create_system_exception(TC_CORBA_BAD_INV_ORDER, corbamod);
    create_system_exception(TC_CORBA_TRANSIENT, corbamod);
    create_system_exception(TC_CORBA_FREE_MEM, corbamod);
    create_system_exception(TC_CORBA_INV_IDENT, corbamod);
    create_system_exception(TC_CORBA_INV_FLAG, corbamod);
    create_system_exception(TC_CORBA_INTF_REPOS, corbamod);
    create_system_exception(TC_CORBA_BAD_CONTEXT, corbamod);
    create_system_exception(TC_CORBA_OBJ_ADAPTER, corbamod);
    create_system_exception(TC_CORBA_DATA_CONVERSION, corbamod);
    create_system_exception(TC_CORBA_OBJECT_NOT_EXIST, corbamod);
    create_system_exception(TC_CORBA_TRANSACTION_REQUIRED, corbamod);
    create_system_exception(TC_CORBA_TRANSACTION_ROLLEDBACK, corbamod);
    create_system_exception(TC_CORBA_INVALID_TRANSACTION, corbamod);
    create_system_exception(TC_CORBA_INV_POLICY, corbamod);
    create_system_exception(TC_CORBA_CODESET_INCOMPATIBLE, corbamod);
}
