///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "typesetter.hh"
#include "fonts/fontinfo.hh"
#include "fonts/fontmanager.hh"
#include "util/stringutil.h"
#include <stdexcept>

static const std::string w_hdr("xml2ps Warning: "),
  e_hdr("xml2ps ERROR: ");

int main(int argc, char* argv[]) {
  int pagenum = 1;
  bool print_font_info = false;
  try {
    font::FontInfo::FontPaths fontPaths;
    xml2ps::Typesetter typesetter;

    for(int i = 1; i < argc; ++i){
      if(argv[i][0] == '-'){
	if(argv[i] == std::string("-of")){      // output format
	  i++;
	  if(i == argc)
	    throw std::runtime_error("The \"-of\" option needs a format"
				     " argument");
	  if(argv[i] == std::string("ps"))
	    typesetter.setOutputFormat(xml2ps::FORMAT_PS);
	  else if(argv[i] == std::string("pdf"))
	    typesetter.setOutputFormat(xml2ps::FORMAT_PDF);
#ifdef XCANVAS
	  else if(argv[i] == std::string("x"))
	    typesetter.setOutputFormat(xml2ps::FORMAT_X);
#endif
	  else
	    throw std::runtime_error("Unknown output format: "
				     + std::string(argv[i]));
	}
	else if(argv[i] == std::string("-f")){ // Font path
	  i++;
	  if(i<argc)
	    fontPaths.push_back(argv[i]);
	  else
	    throw std::runtime_error("The \"-f\" option needs a path"
				     " argument");
	}
	else if(argv[i] == std::string("-p")){ // Page boundary
	  if(i == argc-1)
	    throw std::runtime_error("The \"-p\" option needs a page format"
				     " argument");
	  typesetter.addPage(xml2ps::PageBoundary(pagenum++, argv[++i]));
	}
	else if(argv[i] == std::string("-rf")){ // print font info
	  print_font_info = true;
	}
	else if(argv[i] == std::string("-s")){ // Substitute font aliases
	  typesetter.setSubstFontAliases(true);
	}
	else if(argv[i] == std::string("-b")){ 
	  // "block" - rectangular obstacle
	  if(i == argc - 1)
	    throw std::runtime_error("The \"-b\" option needs a"
				     " boundary geometry argument");	  
	  typesetter.addObstacle(to<Boundary>(argv[++i]));
	}
	else if(argv[i] == std::string("-e")){
	  typesetter.setExtraPages(false);
	}
	else{
	  throw std::runtime_error(std::string("Unknown argument: ") 
				   + argv[i]);
	}
      }
      else
	std::cerr << w_hdr << "Filename args (" << argv[i]
		  << ") not yet supported.  Sorry." << std::endl;
    }
    
    font::FontInfo::init(&fontPaths);
    if(!print_font_info)
      typesetter.run();
    else
      font::FontInfo::getFontManager()->reportFonts(std::cout);
//     std::cerr << used_fonts.size() << std::endl;
//     for(font::Fonts::const_iterator i = used_fonts.begin();
// 	i != used_fonts.end();
// 	i++) {
//       std::cerr << "% " << *i << std::endl;
//     }

    /// \todo warn about this
    //   } catch (const xml2ps::out_of_pages&) {
    //     std::cerr << w_hdr << "Out of pages, document truncated" << std::endl;
  } catch (const std::exception& err) {
    std::cerr << e_hdr << err.what() << std::endl;
  } catch (...) {
    std::cerr << e_hdr << "Main caught something that "
	      << "wasn't even an exception!"
	      << std::endl;
  }
}
