#ifndef UNDODIALOG_H		// -*- c++ -*-
#define UNDODIALOG_H
///
// Copyright (C) 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "widget/dialogwrap.h"
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include "document/document.h"

namespace Gtk {
  class Button;
};

/**
 * Window showing the undo history.
 * This is a singleton.
 */
class UndoDialog : public DialogWrap {
public:
  static UndoDialog &instance();
  void show_raise();
  void set_document(DocRef _document);

private:
  static UndoDialog *_instance;
  bool locked;
  Gtk::TreeView *action_list;
  Gtk::Button *undo_button, *redo_button;
  Glib::RefPtr<Gtk::ListStore> tree_model;
  DocRef document;

  UndoDialog();
  // no default constructors:
  UndoDialog(const UndoDialog&);
  void operator = (const UndoDialog&);
  // no destructor
  ~UndoDialog();

  bool on_button_release_event(GdkEventButton* event);
  void on_selection_changed();
  void on_response(int response_id);
  //  void on_undo_changed(Document *_document);
  void update(bool only_if_visible = true);
};

#endif
