///
// Copyright (C) 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "textviewent.h"
#include "document/textframe.h"
#include "docview.h"
#include <gdkmm.h>
#include <gtkmm/drawingarea.h>

TextViewent::TextViewent(View& view, const FrameRef cachedframe,
			 int scale_factor)
  : PostscriptViewent(view, cachedframe, scale_factor)
{}

bool TextViewent::draw_content() {
  if(get_frame()
     && dynamic_cast<const TextFrame&>(*get_frame()).is_truncated()) {
    Glib::RefPtr<Gdk::GC> gc = Gdk::GC::create(view.get_win());
    gc->set_foreground(view.get_color(Color::guide));
    const Gdk::Point
      p1(view.pt2scr(get_frame()->get_matrix().transform(Vector(0, 0)))),
      p2(view.pt2scr(get_frame()->get_matrix().transform
		     (Vector(get_frame()->get_width(), 0))));
    view.get_win()->draw_line(gc, p1.get_x(), p1.get_y()-1,
			      p2.get_x(), p2.get_y()-1);
    view.get_win()->draw_line(gc, p1.get_x(), p1.get_y()-2,
			      p2.get_x(), p2.get_y()-2);
    view.get_win()->draw_line(gc, p1.get_x(), p1.get_y()-5,
			      p2.get_x(), p2.get_y()-5);
  }
  return PostscriptViewent::draw_content();
}
