// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 4 -*-

/*
 *  PaperBox - tracker-phone.hh
 *
 *  Copyright (C) 2007 Marko Anastasov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __PAPER_BOX_TRACKER_PHONE__
#define __PAPER_BOX_TRACKER_PHONE__

#include <queue>
#include <stdexcept>
#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>
#include <glibmm/ustring.h>
#include <tracker.h>
#include "document.hh"

namespace paperbox {

    // It's not called TrackerClient because
    // libtracker defines a TrackerClient struct.

    class TrackerPhone : private boost::noncopyable
    {
    public:
        explicit TrackerPhone() throw (std::runtime_error);
        virtual ~TrackerPhone();

        static bool ping_tracker();

        void get_all_document_uris(std::queue<Glib::ustring>& uris);

        void get_document(const Glib::ustring& uri,
                          boost::shared_ptr<Document>& document);

        void add_tags(const Glib::ustring& uri,
                      const std::vector<Glib::ustring> tags);

        void remove_tags(const Glib::ustring& uri,
                         const std::vector<Glib::ustring> tags);

    protected:
        void prepare_document(const Glib::ustring& uri,
                              char** keys,
                              boost::shared_ptr<Document>& document);

        void attach_tags(boost::shared_ptr<Document>& document);

        TrackerClient* tracker_connection_;
    };

} // namespace paperbox

#endif // __PAPER_BOX_TRACKER_PHONE__
