// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 4 -*-

/*
 *  PaperBox - document-tile-view.cc
 *
 *  Copyright (C) 2007 Marko Anastasov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "document-tile-view.hh"

namespace paperbox {

    DocumentTileView::DocumentTileView(bool use_page_view)
        :
        TileView(use_page_view)
    {
    }

    DocumentTileView::~DocumentTileView()
    {
    }

    void
    DocumentTileView::add_tile(Gtk::Util::Tile& tile)
    {
        add_tile(&tile);
    }

    void
    DocumentTileView::add_tile(Gtk::Util::Tile* tile)
    {
        DocumentTile* dtile = dynamic_cast<DocumentTile*>(tile);
        connect_to_extra_signals(dtile);

        TileView::add_tile(tile);
    }

    void
    DocumentTileView::connect_to_extra_signals(DocumentTile* tile)
    {
        tile->signal_tag_clicked().connect(
            sigc::mem_fun(*this, &DocumentTileView::on_tag_selected));
    }

    void
    DocumentTileView::on_tag_selected(const Glib::ustring& tag)
    {
        signal_tag_clicked_.emit(tag); // propagate further
    }

} // namespace paperbox
