enum {
  ENC_ISO_8859_1  = 1 << 0,
  ENC_ISO_8859_2  = 1 << 1,
  ENC_ISO_8859_3  = 1 << 2,
  ENC_ISO_8859_4  = 1 << 3,
  ENC_ISO_8859_5  = 1 << 4,
  ENC_ISO_8859_6  = 1 << 5,
  ENC_ISO_8859_7  = 1 << 6,
  ENC_ISO_8859_8  = 1 << 7,
  ENC_ISO_8859_9  = 1 << 8,
  ENC_ISO_8859_10 = 1 << 9,
  ENC_ISO_8859_13 = 1 << 10,
  ENC_ISO_8859_14 = 1 << 11,
  ENC_ISO_8859_15 = 1 << 12,
  ENC_KOI8_R      = 1 << 13,
  ENC_TIS_620     = 1 << 14,
  ENC_JIS_0208    = 1 << 15,
  ENC_GB_2312     = 1 << 16,
  ENC_KSC_5601    = 1 << 17,
  ENC_JIS_0201    = 1 << 18,
  ENC_JIS_0212    = 1 << 19,
  ENC_BIG5	  = 1 << 20,
  ENC_ISO_10646   = 1 << 21
};

Charset charsets[] = {
  { 0,  "ISO-8859-1",   "iso8859-1",       conv_ucs4 },
  { 1,  "ISO-8859-2",   "iso8859-2",       conv_8bit },
  { 2,  "ISO-8859-3",   "iso8859-3",       conv_8bit },
  { 3,  "ISO-8859-4",   "iso8859-4",       conv_8bit },
  { 4,  "ISO-8859-5",   "iso8859-5",       conv_8bit },
  { 5,  "ISO-8859-6",   "iso8859-6",       conv_8bit },
  { 6,  "ISO-8859-7",   "iso8859-7",       conv_8bit },
  { 7,  "ISO-8859-8",   "iso8859-8",       conv_8bit },
  { 8,  "ISO-8859-9",   "iso8859-9",       conv_8bit },
  { 9,  "ISO-8859-10",  "iso8859-10",      conv_8bit },
  { 10, "ISO-8859-13",  "iso8859-13",      conv_8bit },
  { 11, "ISO-8859-14",  "iso8859-14",      conv_8bit },
  { 12, "ISO-8859-15",  "iso8859-15",      conv_8bit },
  { 13, "KOI8-R",       "koi8-r",          conv_8bit },
  { 14, "TIS-620",      "tis620.2529-1",   conv_8bit },
  { 15, "EUC-JP",       "jisx0208.1983-0", conv_eucjp },
  { 16, "GB2312",       "gb2312.1980-0",   conv_16bit },
  { 17, "EUC-KR",       "ksc5601.1987-0",  conv_16bit },
  { 18, "EUC-JP",       "jisx0201.1976-0", conv_eucjp },
  { 19, "EUC-JP",       "jisx0212.1990-0", conv_eucjp },
  { 20, "BIG5",	        "big5-0",	   conv_16bit },
  { 21, "ISO-10646",    "iso10646-1",      conv_ucs4 }
};

CharsetOrdering charset_orderings[] = {
	{ "zh-cn", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 20, 18, 15, 17, 19, 21} },
	{ "zh-tw", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 20, 16, 18, 15, 19, 17, 21} },
	{ "ja", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 16, 17, 20, 21} },
	{ NULL, { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 21, 15, 16, 17, 18, 19, 20} },
};

const guint32 char_mask_map[] = {
  0,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0201|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_BIG5|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_6|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0201,
  ENC_ISO_8859_13|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KOI8_R,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_BIG5|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_13|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_13|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_15|ENC_ISO_8859_1,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4,
  ENC_ISO_8859_10|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_JIS_0212,
  ENC_ISO_8859_15|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_GB_2312|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312,
  ENC_BIG5,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_BIG5|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_7|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_7|ENC_JIS_0208,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_5|ENC_JIS_0208|ENC_KOI8_R,
  ENC_ISO_8859_5|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_5|ENC_JIS_0208|ENC_KOI8_R,
  ENC_ISO_8859_8,
  ENC_ISO_8859_6,
  ENC_TIS_620,
  ENC_ISO_8859_14,
  ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_7|ENC_JIS_0208,
  ENC_GB_2312|ENC_JIS_0208,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_7|ENC_JIS_0208,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_JIS_0208,
  ENC_ISO_8859_13,
  ENC_BIG5|ENC_JIS_0208,
  ENC_BIG5|ENC_GB_2312|ENC_JIS_0208,
  ENC_BIG5|ENC_JIS_0201,
  ENC_ISO_8859_15,
  ENC_GB_2312|ENC_ISO_8859_5|ENC_JIS_0212,
  ENC_GB_2312,
  ENC_KOI8_R,
  ENC_BIG5|ENC_GB_2312|ENC_JIS_0208|ENC_KOI8_R,
  ENC_GB_2312|ENC_KOI8_R,
  ENC_BIG5|ENC_KOI8_R,
  ENC_BIG5|ENC_GB_2312|ENC_JIS_0212,
  ENC_BIG5|ENC_JIS_0212,
  ENC_JIS_0201,
  ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5,
};

const guchar char_masks[] = {
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  4,  1,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
  1,  6,  7,  8,  9, 10, 11, 12, 13, 14,  6, 15, 16,  5, 17, 18,
 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,  6, 15, 29, 30, 29,  6,
 31, 32, 32, 33, 34, 35, 35, 36, 31, 34, 31, 32, 31, 32, 32, 37,
 38, 31, 31, 39, 32, 35, 34, 40, 35, 31, 32, 41, 34, 42, 43, 34,
 44, 45, 32, 33, 34, 35, 35, 36, 44, 46, 44, 32, 44, 45, 32, 37,
 43, 31, 44, 47, 32, 35, 34, 48, 35, 44, 45, 41, 46, 42, 43, 49,
 50, 51, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 53, 53, 52, 52,
 57, 57, 50, 51,  0,  0, 50, 50, 53, 53, 52, 58, 55, 55, 59, 59,
 56, 56, 50, 60, 55, 55, 55, 55, 61, 61, 50, 51,  0,  0, 50, 50,
 59, 59, 62, 62, 55, 55, 50, 50, 61, 52, 52, 50, 50, 52, 52, 62,
 62, 54, 54, 54, 54, 50, 50, 52, 52, 62, 61, 61, 50, 51,  0,  0,
 52, 52, 63, 63, 52, 52, 64, 64, 52, 52, 54, 54, 55, 55, 65, 65,
 66, 66, 52, 52, 52, 52, 61, 61, 61, 61, 50, 51, 55, 55, 52, 52,
 52, 52, 50, 50, 67, 67, 67, 67, 68, 54, 54, 69, 69, 66, 66,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 62, 70, 62,
 70, 62, 70, 62, 70, 62, 70, 62, 70, 62, 70, 62, 70,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 62,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 71,  0, 72, 73, 73,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 74, 75, 62, 76,  0, 52,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 77, 77, 77,  0, 77, 77, 77,  0, 77,  0, 77, 77,
 77, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78,  0, 78, 78, 78, 78, 78, 78, 78, 77, 77, 77, 77, 77, 77,
 77, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 77, 78, 78, 78, 78, 78, 78, 78, 77, 77, 77, 77, 77,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,  0, 80, 80,
 81, 81, 81, 81, 79, 79, 79, 79, 79, 79, 79, 79, 79, 81, 81, 81,
 81, 81, 81, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
  0, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,  0, 80, 80,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0, 83,
  0, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,  0,  0,  0,  0,  0,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,  0,  0,  0,  0, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 85, 85,  0,  0,  0,  0,  0,  0, 85, 85,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 85, 85,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 85, 85,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 85, 85,  0,  0,  0,  0,  0,  0,  0,  0,
 85, 85,  0,  0,  0,  0,  0,  0,  0,  0, 85, 85,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 85, 85, 85, 85, 85, 85,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 85, 85,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 82, 82,
 86,  0,  0, 73, 73, 87, 88, 82, 78, 89,  0,  0, 90, 90, 91,  0,
 86, 86, 73,  0,  0, 92, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 88,  0, 93, 88,  0, 73,  0,  0,  0,  0,  0, 93,  0,  0, 94,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 93,  0, 73,  0,  0,  0, 73,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 62,  0,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 97, 97,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 93, 93, 93,  0,  0, 73, 73, 73, 73,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 86,  0, 86,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 86,  0, 86, 86,  0,  0,  0, 86, 88,  0,  0, 86,  0,  0,  0, 97,
  0, 97, 86,  0,  0,  0,  0,  0,  0, 98, 99,  0,  0, 88, 93, 73,
 93,  0,  0, 73,  0, 72,  0, 88, 88, 93, 93, 93, 86,  0, 72,  0,
  0,  0,  0,  0, 93, 93, 97, 97,  0,  0,  0,  0, 73, 88,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 100,  0,  0,  0, 97,  0,  0,  0,
  0,  0, 92,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 93,  0,  0, 100, 100, 92, 92,  0,  0, 86, 86,  0,  0, 97, 97,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 86, 86,  0,  0, 86, 86,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 97,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 99, 88, 99, 88, 97, 97, 97, 97, 97, 97, 97, 97, 99, 97, 97, 88,
 99, 97, 97, 88, 99, 97, 97, 88, 99, 97, 97, 88, 99, 88, 97, 97,
 88, 97, 97, 88, 99, 88, 97, 97, 88, 97, 97, 88, 99, 97, 97, 88,
 88, 97, 97, 88, 99, 97, 97, 88, 88, 97, 97, 88, 99, 97, 97, 88,
 97, 97, 88, 97, 97, 97, 97, 97, 97, 97, 97, 88,  0,  0,  0,  0,
 101, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 101, 98,
 98, 101, 98, 98, 98, 98, 98, 98, 98, 98, 101, 98, 98, 73, 73, 73,
 73, 73, 73, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 73, 73, 73, 101, 73, 73, 73, 101, 73, 73, 73, 101, 73, 73, 73,
 98, 98, 98, 98, 73, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 99, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 93, 93,  0,  0,  0,  0,  0,  0,  0,  0, 92, 92,  0,  0,
  0,  0,  0,  0,  0,  0, 93, 93,  0,  0,  0, 93,  0,  0, 93, 93,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 73, 73, 73, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0, 86,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 93, 93,  0,  0, 73,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 73, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0, 86,  0, 86,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 93, 93, 93,  0, 93, 86, 86, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 92, 88, 93, 93, 97, 97,  0,  0,  0,  0, 86, 73, 73,  0,
  0, 73, 73, 73, 73, 73, 73, 73, 73, 73,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93,  0,  0,  0,  0,  0,  0,  0, 86, 86, 92, 92,  0,
  0, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93,  0,  0,  0,  0, 88, 86, 86, 92,  0,
  0,  0,  0,  0,  0, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73, 73,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73, 73, 73,  0,
  0, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73,  0,
  0, 73, 73,  0,  0, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 93, 62, 93, 62, 62,  0, 93, 93, 93, 93, 93, 102, 93, 93, 73,
 93, 93, 62, 97, 93, 93, 93, 86, 93, 93, 97, 97, 97, 97, 93, 103,
  0, 86, 97, 62, 70, 97, 92, 97, 70,  0, 88, 102, 97, 93, 103, 62,
 102, 92, 93, 73, 97, 62, 88,  0, 93, 93, 97, 93, 92, 97, 97, 88,
 62, 62, 92, 93, 62, 93,  0, 102, 72, 97,  0, 93, 97, 93, 93, 93,
 97, 62, 72, 72, 97, 86, 93, 86, 93, 93, 62,  0, 102, 93, 93, 93,
 97, 97, 86, 62,  0,  0, 97,  0, 62, 102,  0,  0,  0,  0,  0,  0,
 97, 88,  0, 93, 62, 62,  0,  0,  0, 62,  0,  0,  0,  0, 93, 103,
 86,  0, 92, 73, 73, 86, 93,  0, 93, 88, 86, 93, 93, 102, 93, 97,
  0, 93, 93, 72, 93, 93, 62, 62, 88, 92, 97, 93, 86, 62, 92, 93,
 88, 93, 93,  0, 93, 93, 93, 97, 93, 97,  0, 93, 93, 93, 93, 62,
 86,  0, 97, 93,  0, 97, 92,  0,  0, 103, 93, 97,  0,  0,  0, 97,
 93, 93, 93, 102, 93, 97, 93, 93, 73, 72, 93, 93,  0, 93, 88, 86,
 62, 97,  0, 97, 93, 93, 93, 93, 93, 93, 103, 62, 73, 93, 93, 93,
 62, 102, 62, 93, 93, 93,  0,  0, 102, 73, 97, 97, 97, 86, 86, 62,
 93, 103, 93, 102, 73, 102, 93, 93,  0,  0,  0, 93,  0, 102, 62, 102,
 103, 93, 103, 62, 73, 73,  0,  0, 103, 93, 93, 103, 62, 93, 93, 93,
 93, 93, 103, 73, 73, 103, 62, 70, 72, 102, 88, 97, 86, 92, 97, 97,
 97,  0, 72,  0, 97, 97, 97, 97,  0,  0, 97, 97, 73, 73, 62, 93,
 93, 62, 97, 103, 93, 62, 93, 62, 93, 62, 93, 103, 93, 93, 103, 73,
 62, 73, 62, 93,  0,  0, 93, 92, 103, 103,  0, 62, 103, 93, 93, 93,
 93, 93, 103, 93, 103, 93, 103, 93, 102, 93, 93, 93, 93, 93, 93, 102,
 102, 73, 73, 102, 72, 97,  0, 72,  0, 93, 103, 73, 102,  0, 103, 93,
 93, 62,  0, 93, 72, 92, 93, 103, 103, 103, 103, 93, 93, 103, 102, 93,
 73, 103, 103, 93, 102, 103, 92, 73, 93, 102, 62, 93, 62, 93, 62, 93,
 103, 93, 103, 62, 102, 73, 92, 102, 92, 62, 103, 93, 73, 93, 103, 62,
 88, 86,  0, 97,  0, 97, 97, 97, 97, 97, 97, 86, 97, 86, 93, 93,
  0,  0, 103, 73,  0, 93, 92, 103,  0, 103, 73, 103, 62, 62, 62, 93,
 103, 103, 92, 93, 93, 102, 62, 73, 62, 103, 93, 103, 62, 103, 93, 102,
 93, 93, 62, 73, 92,  0, 73, 93, 93, 73, 93, 92, 102, 93, 72, 93,
 103, 93, 62, 88, 86, 86, 97,  0, 97, 97, 97,  0, 73, 97, 93, 93,
 62, 72, 62, 93, 73, 92, 92, 73, 93,  0, 93,  0, 62, 62, 93, 62,
 103, 62,  0,  0, 62, 92, 92, 103,  0, 92, 62, 92, 102, 93, 103, 93,
 62, 92, 93, 103, 93, 73, 92, 103, 102, 93, 93, 103, 102, 62, 103, 93,
 73, 93, 103, 92, 86, 93, 93, 103, 93, 93, 93, 92, 93, 93, 70, 73,
 103, 73, 62, 103,  0, 103, 86, 73,  0, 86, 97, 62, 72,  0, 97,  0,
 103, 103, 62, 93,  0, 103, 103, 93, 93, 92, 103, 73, 102, 73, 102, 93,
 86, 103, 62, 103,  0, 93, 86, 103,  0, 62, 93, 73, 93, 73, 73, 103,
 103, 73, 103, 103, 73, 93, 62, 62, 73, 73, 103, 73, 88, 103, 73, 73,
 103, 62, 92, 73, 92, 92, 93, 72, 86,  0, 73, 97,  0, 92, 97, 97,
 93, 62, 73, 103, 62, 93, 62, 73, 97,  0, 62, 73, 73, 93, 103, 62,
 62, 92, 103, 62, 103, 73, 103,  0, 92, 92, 92, 103, 103, 73, 103, 62,
 62, 62, 103, 72,  0, 97,  0, 97, 97, 97, 62,  0, 93, 92, 73, 103,
 103, 73, 93, 92, 92, 92, 73, 92, 73, 62, 102, 72,  0, 103, 92, 73,
 62, 73, 92, 62, 103, 92, 73, 103, 73, 92, 92, 73, 62, 86, 103, 93,
 62, 92,  0, 103, 103, 92, 93, 73, 62,  0, 93, 73, 62, 103, 86, 62,
 73,  0, 62, 92, 103, 92, 102, 93, 103, 103, 73,  0, 72, 93, 93, 103,
 73, 103, 62, 72,  0, 93, 103,  0, 73, 92, 62, 93,  0, 73, 103, 73,
 92, 86, 92, 103, 92, 73, 102, 102, 103, 92, 73, 102, 103, 62, 62,  0,
 103, 73, 93, 73, 92, 92, 86, 103, 92, 62, 92, 62, 103, 62, 62, 92,
 73, 93, 73, 62, 73, 73, 73, 62, 62, 73, 92,  0, 62, 103, 73, 62,
 73, 103, 92, 103, 103, 103,  0, 92, 103, 103, 92, 92, 92, 73,  0, 93,
 93, 93, 62, 93, 93, 93, 93, 92, 93, 93, 62, 93, 92, 93, 86, 62,
 86, 97, 92, 62, 93, 102, 97, 103, 62, 73, 93, 73, 93, 73, 73, 103,
  0, 73, 93, 73, 62, 93, 62, 73, 93, 92, 86, 93, 93, 93, 93,  0,
 97, 93,  0, 97, 97, 93, 93, 93, 93, 97,  0, 97, 93, 97, 62,  0,
 93, 97, 88, 62, 62, 88, 86, 73, 97, 93, 92, 62, 88, 93, 62, 92,
 86, 92, 93, 92, 73, 93, 88, 93, 103, 88,  0, 97, 97, 62, 73,  0,
 93, 62, 93, 62, 93, 93, 86,  0, 86, 86, 92, 88, 93, 62,  0, 97,
 93, 93, 88, 88, 86, 88, 93, 93, 62, 73, 62, 97, 102, 93, 103, 62,
 97,  0, 62,  0, 93, 92, 93, 97, 103, 88, 73, 93, 93, 92, 73, 70,
 73, 70, 62, 62, 73, 62, 86, 73, 103,  0,  0, 88, 92, 93, 103,  0,
 93, 93, 62,  0, 97, 62, 86, 86,  0, 86, 86, 97,  0, 88, 62, 97,
 93, 92, 62, 102, 62, 93, 93, 62, 93, 93, 93, 97, 97, 93, 86, 97,
 93, 102, 70, 93, 86, 62, 93, 93, 93, 73, 93, 86, 73, 97, 93,  0,
 73, 93, 102, 103, 86, 62, 102, 93, 70, 97, 97, 97, 73, 93, 73,  0,
 97, 73, 62,  0, 93, 92,  0, 86, 102, 93, 92, 97,  0, 97, 93,  0,
 93, 103, 103, 93,  0, 103, 93, 93, 93, 88, 93, 93, 62, 97,  0, 97,
 97, 72, 97, 93, 92, 62, 73, 92,  0, 103, 93, 92, 93, 93, 73, 86,
 97, 97, 73,  0, 93, 103, 93, 62, 62,  0, 103, 92, 102, 73, 93, 103,
 62, 102, 73, 86, 86, 88, 62, 97,  0, 93, 93, 73, 73, 73, 103, 93,
 86, 86, 93, 86, 92, 92,  0, 103, 103, 62, 73, 73, 73, 93,  0, 93,
 103, 72, 102, 92, 73, 62,  0, 92, 93, 92, 103, 73, 103, 92,  0,  0,
 97, 92, 86, 102, 86, 62, 103, 103, 103, 73, 62, 93, 62, 97, 97, 93,
 93, 97, 97, 93, 62, 62, 103, 62, 97, 93, 93, 93, 93, 93, 73, 62,
 62, 88, 97, 97, 86, 86, 62, 62, 62, 86, 62, 103, 92, 62, 93, 97,
 103, 92, 73, 93, 62, 86, 62, 93, 62, 93,  0, 97, 62, 92,  0, 62,
 97, 62, 93, 73, 62, 92, 102, 92, 93, 92,  0, 103, 62, 92, 92, 93,
 86, 62, 92, 92, 93, 62, 92, 86, 62, 103, 62, 73, 62,  0,  0, 73,
 102, 103, 86, 92, 103, 92, 62, 103, 92, 88, 93, 73, 73,  0, 93, 93,
 70, 86, 86, 62,  0, 93, 93,  0, 93, 73, 103, 103, 62, 93, 73, 93,
 93, 103, 73, 62,  0, 93, 93, 93, 62, 93, 93, 62, 103, 93, 62, 103,
 93, 93, 73, 93,  0, 62, 97, 62, 62, 62, 93, 62, 62, 103, 97, 92,
 103, 92, 62, 86, 73, 62,  0, 73, 86, 93, 88, 88, 103, 103, 102, 93,
 92, 93, 62, 93, 73, 93, 86, 93, 93, 93, 93, 62, 103, 92, 97, 97,
  0, 93, 93, 93, 92, 97, 97, 93, 86, 62, 93, 62, 93,  0, 93, 97,
 93, 102, 97, 102, 97, 62, 93, 97,  0, 88,  0, 97, 103, 62, 93, 93,
 93, 93, 103, 93, 88, 93,  0, 93, 93, 103, 97, 92, 73,  0, 62, 93,
  0,  0, 93, 62, 93, 97, 97, 62, 62, 97, 73, 97, 97, 97, 103, 73,
  0,  0, 73, 62, 103, 97, 92, 73, 93, 103, 93,  0, 73, 102, 73, 93,
 86, 62, 97, 97, 103, 93, 88, 73, 88, 88, 62, 62, 73, 92, 88, 62,
 86,  0, 103, 86, 103, 62, 88, 62, 62, 73, 62, 93,  0, 62,  0, 97,
 62, 97, 88, 92,  0, 62,  0,  0, 93, 93, 93, 93, 88, 93, 86, 62,
  0, 97, 62, 62, 93, 62, 93, 93, 97, 88, 62, 93,  0, 62, 62, 93,
 70, 92, 92, 93, 93, 93, 102, 62, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93,  0, 102, 88, 88, 93, 97, 86, 72, 72, 97,  0,  0,
  0, 93, 62, 93, 93,  0, 72, 73, 93, 93, 93, 92, 93, 93, 93, 93,
 93, 93, 72, 70,  0, 97, 97, 97, 73, 73, 62, 93, 73, 93, 72, 93,
 93, 70,  0, 97, 73, 73, 93, 102, 102, 93, 103, 93, 93, 93, 93, 70,
 73, 102, 97, 73, 70, 102, 92, 73, 93, 93,  0, 93, 93, 92, 93,  0,
 93, 73, 92, 102, 62, 73, 93, 103, 93, 86, 93, 97,  0, 62, 92, 103,
 97, 86, 97, 97, 72, 97, 97, 97, 97, 97,  0, 97, 97,  0, 62, 86,
 73, 73, 102, 73, 102, 73, 102, 103, 93, 62, 86, 103, 73, 62, 62, 73,
 92, 93, 72, 93, 103, 93, 93, 93, 72,  0, 73, 93, 93, 93, 73, 103,
 93, 103, 72, 62, 93, 62, 93, 73, 103, 62,  0, 93, 93, 103, 93, 88,
 93, 103, 93,  0, 97, 102, 102,  0, 73, 97, 72, 97, 62, 97,  0, 62,
 73, 103, 92, 97, 88, 92, 102, 102, 93, 102, 102, 93, 93, 102, 103, 93,
 73, 102, 86, 93, 97,  0, 73, 103, 93, 62, 103, 102, 92, 93, 92, 102,
 93, 93, 93, 73, 93, 73, 102, 93, 93, 93, 62,  0, 97, 70, 102, 72,
 97, 97, 97, 97, 97, 97, 73, 97, 86, 97, 97,  0, 97, 97, 72, 97,
 103, 92, 92,  0, 73, 93, 93, 72, 93, 93, 102, 73, 62, 93, 93, 62,
  0, 73, 93, 72,  0,  0, 62, 73, 73,  0, 93, 73, 102, 93, 62, 102,
 62, 102,  0, 73, 92, 103, 93, 93, 103, 102, 73, 73, 103, 62, 103, 93,
 93, 72, 73,  0, 93, 62, 86, 73,  0,  0, 73, 97,  0,  0,  0,  0,
 97,  0, 97, 97, 97,  0, 73, 72,  0,  0, 102, 62, 72, 73, 93, 93,
 72, 93, 103, 93, 73, 103, 103, 72, 92, 92,  0, 103, 102, 62, 93, 97,
 92, 102,  0, 72, 93, 92, 93, 62, 73, 70, 102, 73, 86, 103, 73, 92,
 102, 103, 73, 86,  0, 72, 93, 92, 62,  0, 62, 62, 93, 86, 103, 73,
 62, 102, 73, 92, 102, 72, 102, 97,  0,  0, 72,  0, 97, 97, 97,  0,
  0,  0,  0,  0,  0, 72, 72, 72, 97,  0,  0, 93, 93, 73, 93, 103,
 93, 102, 102, 93, 93,  0, 62, 93, 102, 93, 93, 93, 73, 73, 103, 102,
  0, 102, 103, 103, 102, 73,  0, 62, 93, 93, 92,  0, 93, 93, 86, 93,
  0, 73, 73, 103, 103, 73, 73, 93, 92, 86, 92, 92, 92, 103, 92,  0,
 86, 72, 103, 72,  0, 72, 86, 97,  0, 97,  0, 72,  0, 97, 97, 103,
 73, 62, 73, 103, 93, 93, 103, 92, 73, 102, 73, 103, 102, 72, 103, 73,
 73, 102, 102, 102, 93, 73, 72, 62, 62, 73, 92, 103, 93, 72, 62, 93,
  0, 72, 103, 93, 93, 72, 72, 73, 72, 103, 97, 97, 97,  0,  0, 72,
  0,  0, 72, 97,  0, 97, 103, 93,  0, 92, 73,  0, 73, 93, 93, 103,
 72, 72, 73,  0, 73, 62, 92,  0, 102, 93, 62,  0, 72, 103, 102, 102,
 103, 62, 103, 73, 92, 73, 92, 92, 88, 62,  0, 93, 73, 73, 97, 72,
  0,  0,  0, 97, 97,  0,  0, 72,  0, 92, 73,  0, 102, 97, 73, 92,
 103, 88, 93, 103, 93, 103, 93, 62, 92, 102, 73, 102, 62, 103, 73, 102,
 103, 103, 92, 62, 62, 73, 103,  0, 73, 103, 73, 62, 93, 70, 93, 62,
 86,  0,  0, 73, 70,  0,  0, 72, 72, 72, 73, 86, 97,  0, 103,  0,
 103, 62, 102, 103, 93, 73, 103,  0, 93, 102, 93, 93, 93, 103, 73, 103,
 73, 102, 103, 73, 92, 62, 72, 73, 92, 73, 86, 97, 97,  0, 73, 73,
 92, 73, 73, 73, 103, 102, 93, 92, 62,  0, 86, 62, 103, 73, 72, 93,
 73,  0,  0, 72, 86, 103,  0, 73, 73, 103, 103,  0, 73, 103, 62, 62,
 86,  0, 86, 97,  0, 92, 103, 103, 103, 62, 73, 103, 103, 103, 92, 97,
  0, 62, 73, 103, 92, 73, 92, 102,  0,  0,  0,  0, 93, 73, 103,  0,
 92, 92, 92, 92,  0, 103, 73,  0, 92, 103, 102, 103, 103, 103, 86, 62,
 62, 92,  0, 92, 72,  0,  0, 93, 86, 62, 93, 93, 62, 102, 93, 102,
 93, 102, 97, 86, 102, 103, 62, 103, 62,  0, 73, 102,  0, 70, 92,  0,
 93, 70, 86, 86, 97, 97, 62, 103,  0, 93, 93,  0,  0, 88, 97, 93,
 86, 103, 103, 93, 93,  0, 97, 103, 93, 93, 102, 92, 103, 92,  0, 86,
  0, 62, 92, 92, 73, 62, 92,  0, 92,  0, 103, 103, 93, 62, 73, 93,
 103,  0, 103, 102, 62, 62, 86, 86, 93, 102, 102,  0, 102, 93, 102, 102,
 93,  0,  0, 102, 103,  0,  0, 86, 86, 97, 97, 93,  0, 62, 102, 62,
 93, 73, 88,  0,  0, 103, 62, 93,  0, 73, 93, 73, 102, 102, 93, 93,
 93, 93, 103,  0,  0,  0,  0, 97,  0,  0, 97, 97, 97, 97, 97, 97,
 97, 93, 103,  0, 93, 62, 93, 62, 102, 93, 93, 102,  0, 102, 62, 102,
 103, 103, 73, 102, 103, 103, 72, 102,  0, 62, 62, 102, 102, 73, 62, 86,
 73, 62, 93, 102, 97, 97, 97,  0, 86, 86,  0, 93, 102,  0,  0, 73,
  0,  0, 97, 93, 103, 103,  0, 103, 73, 103, 103, 72, 62, 103, 103, 103,
 93, 70, 93, 93, 93, 73, 97, 70, 62, 70, 86, 97, 62, 97, 72,  0,
 86,  0, 97, 86, 97, 73, 73,  0, 102, 73, 73,  0, 73, 103,  0, 73,
 86, 73, 72, 93,  0,  0, 92, 103, 62,  0,  0, 93, 103,  0, 93, 102,
 73,  0, 93, 86, 93, 102, 86,  0, 97, 97, 97,  0, 92, 70, 62, 93,
 93, 103, 73, 92, 102, 73, 62, 103,  0, 103,  0,  0, 73, 102, 73, 97,
 103, 73, 73, 73, 93, 103, 103, 92, 102, 93, 93, 73, 92, 102, 62, 62,
 93, 73, 93, 62, 103, 92, 93, 72, 103, 103, 92, 93, 103, 102, 73,  0,
 73, 97,  0,  0, 73, 88,  0,  0,  0, 93,  0, 103, 73, 92, 102, 62,
 102, 93,  0, 73, 93, 73, 62, 103, 73, 73, 93,  0, 73, 103, 73, 92,
 93, 92, 103, 73, 92, 93, 73, 73, 73, 103, 86, 73,  0, 92,  0, 103,
 86, 86,  0,  0, 97,  0,  0,  0, 73, 103, 92, 92, 102, 102, 73, 103,
 62, 93, 92, 73, 93, 103,  0, 92, 93, 92, 92, 73,  0, 73, 93, 62,
  0, 62, 92, 73, 103, 72,  0, 62, 103, 86,  0, 93, 97, 73,  0, 73,
 86, 73, 86,  0, 73, 92, 73,  0, 62, 92, 73, 73, 103, 73, 93, 103,
 102, 102, 73, 93,  0, 93, 73, 103, 103, 102, 103, 73, 62, 62, 73, 103,
 103, 73, 97, 93, 103,  0, 62, 86, 73, 97, 97,  0, 92, 103, 72, 93,
 103, 103, 62, 73,  0, 73, 103,  0, 93, 102,  0, 92, 73,  0, 92, 73,
  0, 103, 62, 92,  0,  0,  0,  0, 86, 86, 92, 86, 102, 73, 92, 73,
  0, 93, 103,  0, 62, 93, 73, 92, 103, 73, 86,  0, 86, 62, 103, 73,
 62, 93, 103, 92, 103, 93, 103, 86, 92, 92, 103, 73, 86, 103, 92, 92,
  0, 62, 103, 73, 93, 86,  0, 73, 73, 103,  0, 93, 93,  0, 88, 92,
 88, 86, 86, 70, 73,  0, 97, 86,  0, 93, 92, 86, 92, 92, 73, 73,
  0,  0, 88, 73, 97, 62, 103, 97,  0, 86, 86, 62, 103, 72, 73, 93,
 86,  0, 103, 62, 102, 93, 93, 73, 86, 93, 93, 86, 93, 62,  0, 97,
 73, 62, 92, 62, 102, 93,  0, 93, 62, 93, 93, 93, 92, 93, 93, 102,
 62, 93, 86, 62, 97, 62, 62, 93, 93, 97, 97,  0, 72,  0, 92, 62,
 73, 97, 97, 62, 93, 73, 62, 93, 93, 93, 73, 97,  0,  0, 93, 93,
 92, 93, 62, 103, 93, 93, 97, 93, 93, 62, 93, 62, 73, 62, 62, 62,
 93, 103, 93, 62,  0, 88,  0, 92, 86, 92, 92, 103, 86, 103, 92, 62,
 73, 73, 103, 93, 93, 62, 102, 73, 93, 102,  0, 103, 103, 93, 73, 73,
 73, 93, 93, 93, 93, 73, 97, 97, 97,  0, 93, 62, 62, 93, 103, 73,
 73,  0, 102, 93,  0, 62, 93, 102, 73, 93,  0, 86,  0, 92, 72, 62,
 73, 73, 73, 93, 102, 93, 73, 103, 93, 97, 97, 97, 86, 62, 102, 102,
 62, 73, 93, 103, 73, 73, 73, 62,  0, 93, 103, 93, 103, 73, 93,  0,
 73, 103,  0, 103, 62, 73, 93, 73, 103, 86, 102, 93, 73, 103, 73, 73,
 93, 93, 102, 93, 93,  0, 73, 97, 72, 86, 93, 73, 93, 102, 103, 62,
 73, 73,  0, 102, 103, 93, 92, 62, 93, 73, 92, 86, 72, 73, 103, 62,
  0, 103, 103, 73, 103, 73, 92, 103,  0, 97, 73, 93, 73, 73, 73, 93,
 103, 93,  0, 93, 70, 97, 97, 97, 97, 93, 73,  0, 102, 62, 62, 73,
  0, 93, 62, 102,  0, 73, 73, 73, 93, 73, 86, 73, 93,  0, 103, 93,
 93,  0,  0, 102, 62, 93,  0, 62, 62, 93, 62,  0,  0, 103, 73, 86,
 62, 97, 97, 73, 97, 92, 93, 73, 73, 73,  0,  0, 93,  0, 73,  0,
 93, 92, 73, 73, 103, 62, 93, 103, 103, 93, 72,  0, 103, 73,  0,  0,
 103, 73, 73, 73,  0, 102, 73, 73, 73,  0, 93, 73, 73, 73, 103, 73,
 73,  0, 93, 62, 73, 103, 92, 102,  0, 73, 93,  0, 92, 103,  0,  0,
 73,  0,  0,  0, 97, 97, 97, 102, 73,  0, 102, 103, 73, 73, 62, 93,
  0,  0,  0, 73, 73,  0,  0,  0,  0,  0, 73, 103, 73,  0, 73, 73,
 103,  0, 93, 103, 73, 73, 62, 73,  0, 62, 93, 93, 103, 73, 103, 103,
 62,  0, 103,  0,  0, 73, 73, 103,  0, 73, 97,  0, 103,  0, 73, 73,
 73, 103, 102, 102, 73, 102, 73, 73, 102, 73, 103, 103, 92, 92, 93, 103,
 73, 93, 93,  0, 103,  0, 103, 73, 103, 93, 73, 92, 93, 73,  0, 62,
 86,  0, 97,  0, 97, 73, 93, 92, 72, 73, 103, 73, 102, 73, 73, 73,
 102, 93, 73, 93,  0, 103, 93,  0, 73, 93, 103, 72, 73, 73, 103,  0,
  0, 97,  0, 73, 73, 103, 103, 73, 73, 73, 86, 92,  0, 103,  0, 73,
 62, 103, 73, 73,  0, 73,  0, 73, 103, 93,  0, 92, 92,  0,  0, 73,
 73,  0,  0, 73, 73,  0, 93, 102,  0, 103, 73, 103,  0, 103, 73,  0,
 73, 103, 86, 73, 73, 103, 73, 73, 73,  0, 92,  0, 92, 103, 73, 73,
 92,  0, 93,  0, 102,  0, 86, 97, 103,  0,  0,  0, 73, 73, 92, 73,
 93, 62,  0, 92,  0, 92,  0, 73, 73,  0,  0, 103, 103, 73, 73,  0,
 93, 93, 62, 72, 93, 93, 103, 93, 93, 97, 93, 93, 93, 93, 62, 93,
  0,  0, 72, 93, 93, 93, 88,  0, 62, 93, 97, 92, 72,  0, 103, 62,
 93, 93, 73, 93,  0, 93,  0, 73, 92,  0, 93, 73, 62, 102, 62, 103,
 88, 102,  0, 93, 102, 93, 62, 93, 93, 93, 62, 93, 93, 86, 103, 93,
 62, 62, 73, 102, 62, 93, 62, 93, 93, 93, 93, 93, 93, 88, 97, 86,
 97, 97, 93, 93, 93, 93, 93, 73, 103, 62, 97, 97, 103, 103, 92, 62,
 93, 62, 62, 93, 93, 93, 93, 62, 93, 93, 62,  0, 62, 97, 97, 93,
 103, 103, 93, 86, 93, 93, 93, 93,  0, 86, 73, 73, 93, 103, 73, 62,
 93, 73, 93, 93, 92,  0, 103, 62, 103, 103, 62, 86,  0, 88, 93, 93,
 103, 93, 92, 73, 93, 93, 92, 92, 93, 92, 73, 92, 73,  0, 93, 103,
 93, 103, 73, 86, 62, 92, 92,  0, 93, 97, 93, 97, 97, 62, 86, 88,
  0, 93, 86, 73, 93, 86, 88, 92, 92, 93, 93, 92, 103, 92, 92, 93,
 73, 93, 73, 86, 97, 72, 93, 62, 97,  0, 93,  0, 97, 97, 62, 103,
 86,  0, 93, 62, 93, 72, 62, 97, 92, 62, 73, 62, 102, 86, 62,  0,
 103, 93, 62, 73, 97, 62, 62, 73, 93, 93, 93, 93, 93, 88, 93, 93,
 93, 93, 97,  0, 73, 93, 92, 73, 93, 97, 88, 93, 73, 92, 93, 93,
 93, 93,  0, 86, 73, 93, 73,  0, 73, 102, 62,  0, 103, 73, 88,  0,
 93, 88, 103, 102, 92, 93, 97, 103, 103, 103, 73,  0, 92, 103, 93, 93,
 62, 93,  0, 73, 103, 62, 86,  0,  0, 93, 102, 103, 103, 62, 73, 97,
  0, 97, 97,  0,  0,  0, 73, 62, 102, 73, 103, 73, 93, 72,  0, 103,
 93, 93, 103, 73, 93, 73, 97, 97, 97, 97, 97, 97, 97, 103,  0, 103,
 103, 92, 102, 102, 73, 73, 103, 73, 92, 93, 103, 93, 93, 72, 73, 73,
 73, 93, 62, 93, 62, 102, 92, 93, 93,  0, 62, 86, 86, 97, 86, 97,
  0, 97,  0,  0, 97, 86, 73, 92, 73, 103, 73, 102, 73,  0, 73, 73,
 73,  0, 102, 73, 73,  0, 73, 103, 73, 93, 73, 73,  0, 62, 73, 73,
 86, 88,  0,  0, 97, 97, 97,  0, 93, 86, 93,  0, 73, 93, 103, 86,
 93, 103, 62,  0, 103,  0, 92, 73, 73, 73, 86, 93,  0, 92,  0, 73,
 73, 103, 97, 97,  0,  0, 102, 93,  0,  0,  0, 92, 73, 103, 93, 73,
  0, 92, 103,  0, 93, 86, 93, 92, 86, 92, 92, 93,  0, 73, 72, 92,
 73,  0, 92, 103, 102, 73, 102, 102, 73, 93,  0, 62,  0, 97, 72,  0,
 73, 103, 73, 73, 102, 73, 73, 73, 73, 103, 73,  0, 73, 102, 97, 103,
 73, 73, 103, 103,  0, 73, 62, 72, 62, 73, 102, 93, 93,  0, 92,  0,
 92, 103, 92,  0,  0, 103,  0,  0, 97, 103,  0, 97, 86, 97, 73, 62,
 62, 62, 103, 73, 62, 73,  0, 73, 73, 93, 62, 72, 93, 62,  0, 93,
 62, 73, 73, 86, 97,  0, 86, 73,  0, 103, 103,  0, 73, 73, 103, 103,
 73, 103, 93, 62, 92,  0, 73, 92, 103, 73, 103, 86, 86, 73,  0,  0,
 86,  0, 103, 103, 103, 103,  0, 73,  0, 102, 73, 62, 73, 93, 73, 103,
 103, 73, 92,  0,  0,  0,  0, 103, 73, 73, 73, 62, 92, 73, 92, 73,
 103, 73, 103,  0, 103, 73,  0, 93, 103, 62, 92,  0, 92, 92,  0,  0,
 73,  0, 73, 103,  0, 97, 73, 103,  0, 92,  0, 103, 86, 93, 62, 73,
 62, 73, 92, 86, 73, 73, 92,  0, 103, 62,  0, 88,  0, 93, 93, 73,
 103, 93, 72, 86, 62, 93, 93, 93, 93, 70,  0, 93,  0,  0, 93, 97,
 73, 93, 93, 93, 93, 86,  0, 93, 62, 103,  0, 86,  0, 93, 93, 73,
 62, 97, 93, 93, 73, 97, 93, 62, 97,  0, 73, 86, 93, 62, 73, 97,
 97, 93, 62,  0, 102, 102, 93, 73, 102, 93, 93, 93, 97, 93,  0, 103,
 103, 73, 73, 73, 73, 92, 97, 97, 103, 73,  0, 92,  0, 93, 70, 86,
 86, 97, 62, 92, 73, 62, 92, 93, 93,  0,  0, 97, 97, 93, 103,  0,
 92, 73, 97, 92, 93, 93,  0, 86,  0, 62, 73, 103, 93, 73, 92, 73,
 62, 62,  0, 73, 93, 93, 62, 92, 103, 73,  0, 102, 103, 73, 70, 92,
 73, 93, 93, 92, 86,  0, 73, 73, 103, 73, 103, 103, 103, 103, 103, 73,
 103,  0, 93, 93, 93, 92, 93,  0, 93, 92, 88, 93, 93, 93, 92, 88,
 102, 86, 73, 86, 93,  0, 97, 93, 73, 73, 93, 102, 73, 73, 62, 93,
 97, 97,  0, 97, 97, 93, 93, 93,  0, 97, 93, 73, 93,  0, 97, 97,
 93,  0, 103, 73, 103, 102, 93, 93, 103,  0, 103, 92, 103, 93, 73,  0,
 73, 103, 73, 102, 73, 93, 93, 93, 93, 72,  0,  0,  0, 62, 102, 62,
  0, 92, 92, 86, 73, 73, 103, 73, 92, 93, 93, 103, 103,  0, 103, 86,
 86, 102, 102, 93, 103, 103, 93, 73, 73, 73, 92, 93, 103, 92, 103, 92,
 92, 92, 92, 92,  0, 103, 73, 73, 93, 92, 97, 62, 92,  0, 73, 73,
 86, 92, 73, 92, 88,  0, 93, 93, 86,  0, 93, 86, 86,  0, 93, 93,
 97, 93, 102, 88, 93, 73, 62, 103, 102, 86, 93, 93, 86, 86, 62, 93,
 86, 88, 73, 93, 92, 93, 86, 93, 93, 62, 73, 93, 62, 103,  0, 93,
 97, 62, 103, 103, 103, 88, 93, 93, 103, 93, 97, 62, 62, 93, 103, 88,
 103, 93,  0, 73, 62, 92, 103, 92, 92, 97, 97, 62, 93, 62, 86, 62,
 102, 86,  0, 73, 103, 62, 73, 62, 92, 73, 92, 73, 92, 62, 92, 73,
 70, 86, 97, 88, 103, 97, 93, 93, 102, 92,  0, 62, 86, 93,  0,  0,
 62, 88, 93, 62, 102, 73, 88, 103,  0, 93, 93, 92, 93, 93,  0, 103,
 93, 93, 62, 93, 103, 62, 73, 93, 103, 93, 62, 97, 93, 103, 103, 92,
 93, 93, 93, 86, 88, 93, 73, 93, 93, 102, 93, 93, 93, 62,  0, 62,
 93, 92, 93, 86,  0, 97, 103, 93, 93, 93,  0, 73, 102, 62, 92, 73,
 92, 93, 62,  0, 62, 73, 73, 62, 93, 92, 93, 103, 103, 93, 93, 103,
 62, 62, 73, 86, 86, 72, 73, 72, 62, 92,  0, 73, 93, 93, 73, 73,
 73, 73,  0, 93, 70, 93, 97, 62, 62, 102,  0, 62, 93, 93,  0, 72,
 102, 102, 102, 62, 103, 73, 93, 93, 93, 93,  0,  0, 86, 93, 103,  0,
 93, 102, 62, 73, 93, 73,  0, 97, 103, 62, 102, 93, 62, 102, 102, 103,
 86, 93, 62, 103, 73, 93, 62, 73, 93,  0, 103, 93, 62, 93, 97, 93,
 72, 97, 97, 97, 97, 97, 97, 62,  0, 73, 102, 73, 73, 102, 93, 93,
 92, 73, 93, 103, 102, 93, 93, 103, 62, 93, 103, 93, 93, 93, 73, 62,
 93, 93, 73,  0, 103, 93, 93, 93, 93, 93, 93, 93, 73, 103, 73, 93,
  0, 86, 73, 103, 73, 102,  0, 73,  0, 73, 86, 97, 97,  0,  0, 97,
 103, 93, 93, 93, 73, 73, 92, 103, 62, 103, 86, 88, 103, 93,  0,  0,
 93, 62, 88, 73, 103, 93, 62, 62, 73, 93, 93, 73,  0, 102, 73, 92,
 86, 62, 93, 93, 93, 92, 73, 102, 93, 93, 93, 93, 93, 93, 73, 93,
 93, 62, 73, 97,  0, 86, 97, 86, 97, 97, 97, 97, 97, 97, 62, 102,
 73, 92, 62, 93, 93, 73, 103, 73, 103, 93, 103, 86, 93, 93, 103,  0,
 73, 62, 93, 62, 93, 103, 93, 92, 62,  0, 93, 93, 73, 102, 62, 93,
 93,  0, 103, 93, 62, 62, 88, 86, 102, 86, 86, 97, 97, 97,  0, 97,
 103, 102, 93, 86, 93, 92, 92, 103, 93, 73, 73, 102, 93, 92, 103, 73,
 73, 73, 62, 73, 103, 93, 93, 92, 103, 103, 102, 102, 73, 73, 103, 103,
  0, 93,  0, 92, 103, 102,  0,  0, 93, 103, 93, 103, 93, 102, 62, 93,
 93, 92, 103, 86, 73, 62, 72, 88, 88, 97,  0, 97, 97, 97, 97, 97,
 93, 92, 103, 93, 93, 103, 93, 92, 103, 93, 93, 92, 103, 62, 73, 73,
 93, 93, 62, 92, 73, 73, 93, 62, 93, 93, 103, 73, 62, 93, 93, 93,
 103, 62, 103, 103, 103, 93, 103, 62, 73, 62, 93, 92, 103, 73, 62, 93,
 97, 86, 62, 72, 97,  0, 97, 93, 92, 73, 62, 102, 92,  0, 73, 73,
 62, 62, 73,  0, 92, 62, 103, 103,  0, 62,  0, 73, 86, 86, 92, 93,
 73, 103, 86,  0, 92, 103, 103, 92, 93, 103, 93, 92, 93, 92, 93, 73,
  0, 97, 73, 92, 73, 93, 73,  0, 92, 86, 92, 73,  0, 93, 103, 92,
 62, 73, 93, 92,  0, 92, 73, 93, 93,  0, 73, 92, 103,  0, 92, 86,
 93, 92, 103, 92, 92, 93, 92, 93, 62, 73, 73, 62, 103,  0, 92, 62,
 103, 62, 92, 103, 62,  0,  0, 86,  0, 73, 92, 102, 73, 103, 93,  0,
 92, 92, 103, 103, 93,  0, 92, 62, 62, 86, 92, 73, 62, 102,  0, 103,
 62, 73, 73,  0, 92, 62,  0, 93, 102, 93, 103, 92, 93, 103, 92, 73,
 73, 73, 92, 73, 73, 73, 92, 97, 103, 62, 92,  0, 103,  0, 93, 73,
 62, 103, 102, 92,  0, 73, 92, 92, 93, 92, 93, 93, 92, 92, 62, 62,
 86, 97, 97,  0, 97, 62, 73,  0, 73,  0,  0,  0, 62, 62, 103, 103,
 73, 62, 62, 92, 73, 103, 93, 103, 73, 103, 73, 73, 62, 103, 73, 62,
 73, 73, 92,  0, 86, 72, 92, 92, 92, 73, 92, 73, 92, 92, 92, 93,
 92, 103,  0, 103, 103,  0, 97, 103, 93, 92, 93, 97, 93, 93, 93, 97,
 93, 93, 93, 62, 92, 102, 93, 97, 97, 73, 93, 93, 62, 86, 86, 93,
 103, 93, 102, 103, 72, 72, 86, 103,  0, 103, 93, 103, 97, 73, 93, 86,
 92,  0, 92, 93, 93,  0, 73, 97, 86, 62, 73, 86,  0, 102, 72, 93,
 93, 93, 103, 102, 62,  0, 103, 93, 93, 93, 73, 93, 70, 93, 93,  0,
 103, 102, 102, 93, 102, 86, 62,  0, 93, 73, 103, 93, 103,  0, 92,  0,
 92, 73, 73, 93, 103, 73, 72, 97, 86, 97, 97, 97, 97, 102, 93, 102,
 72, 92, 73, 102, 73,  0, 93, 73,  0, 93, 103, 73, 93, 103, 93, 93,
 93, 73, 86, 92, 93,  0, 73, 73, 73, 93, 93,  0, 73, 62, 103, 103,
 62, 93, 93, 93, 92, 93, 93, 93, 93,  0, 97, 88, 86,  0, 86, 97,
 97, 97, 97,  0, 97, 97, 62,  0, 102, 73, 73, 93, 93, 73, 73, 73,
 73, 93,  0, 103, 73, 93, 103, 62, 73, 93, 62, 93, 93, 93, 103, 102,
  0,  0, 93,  0, 102, 88, 93, 93, 93, 93, 93, 73, 93, 93, 102, 92,
 93, 92, 93, 93, 93, 62, 102, 93, 93, 93, 102, 93, 93, 86,  0, 97,
 86, 86, 97, 97,  0, 97, 97, 97, 97, 97, 62, 73, 93, 93, 93, 93,
 73, 93, 103, 93, 102, 92, 93, 93, 73, 73, 73, 73, 102, 102, 93, 93,
 73, 93, 93, 103, 62,  0,  0, 93, 93, 93, 62, 103, 92, 103, 72, 73,
 103, 93,  0, 103, 73, 73, 102,  0, 62, 86, 97, 97,  0, 97, 97, 88,
 97, 97, 97, 97, 97, 97,  0, 86, 93, 103, 102, 93, 73, 103,  0, 93,
  0,  0, 72, 73, 73, 62, 103,  0, 73, 102, 93, 73, 103, 93, 92, 86,
 73, 103, 102, 102, 103, 72, 102, 73, 73, 93, 103, 102, 93, 93, 102, 93,
 93, 73, 62, 62, 103, 93, 73, 92, 103, 73, 73, 62, 86,  0, 97, 97,
  0, 97, 97, 97,  0, 103, 62, 93, 92, 93,  0, 92, 62, 102, 93, 73,
 73, 102, 92,  0, 62, 103, 93, 93, 103,  0, 93, 93, 103, 103,  0, 62,
 93, 73, 102, 92, 103, 73,  0, 102, 93, 93, 102,  0, 93, 73, 93, 93,
 102, 73, 93,  0, 103, 62, 93, 73, 93, 103, 62, 92, 73, 73, 103, 92,
 93, 92, 93, 93, 103, 93, 62, 93, 93, 93, 93, 92, 93, 102, 102, 103,
 72, 73, 86, 97, 88, 86,  0, 97, 97,  0, 97, 86, 97, 103, 93,  0,
 92, 62, 73, 92, 93, 103, 93, 73, 103, 93, 73, 73, 73, 72, 102, 93,
 93, 62, 93, 103, 62, 103, 93, 73, 73, 73, 92, 92, 103, 73, 97, 73,
 102, 93,  0, 93, 73, 103,  0, 73, 73, 93, 102, 73, 62, 72, 92, 73,
 73, 73, 102, 103, 93, 103, 93,  0, 70, 103, 86,  0,  0, 97,  0, 97,
 97, 97, 97,  0,  0, 97, 92,  0,  0, 103, 103, 72, 72, 92, 73, 93,
 102,  0, 103, 93, 102, 73, 92, 92, 103,  0, 73, 72, 93,  0, 102, 73,
 102, 72, 103, 73, 103, 103, 93, 73, 92, 62, 102, 73, 93, 93, 73, 103,
 103,  0,  0, 73, 93, 103, 92, 73,  0, 73, 88,  0,  0, 102, 92, 102,
 73, 72, 86, 73, 97, 97, 97, 97, 97,  0, 97, 103,  0, 73, 92, 62,
 73, 103, 102, 103, 102,  0,  0,  0, 93, 73, 62, 103, 103, 103, 72, 103,
 103, 103,  0, 62,  0, 73, 73, 93, 73, 93,  0, 73, 73, 102, 73, 92,
 73,  0, 73, 103, 103, 73, 92, 73, 93, 72, 93, 103,  0, 103,  0, 73,
  0,  0, 72, 86, 97, 102,  0, 102, 92, 73, 73, 73, 73,  0,  0, 103,
 103, 70, 93, 92,  0, 93, 72, 73, 103, 102, 92, 62, 73, 103, 93, 103,
 73, 62, 73, 103, 93, 92, 103,  0, 62, 93,  0, 92, 102, 93, 93,  0,
 93, 73, 92, 103,  0, 97,  0, 97, 97, 86, 97, 92, 93, 103, 103, 103,
 97, 92, 93, 73, 103, 93,  0, 92,  0, 103, 103, 103, 62, 93, 102, 73,
 102, 62, 93,  0, 92, 62, 73, 102, 93, 73, 92, 73,  0,  0, 97,  0,
 92, 86, 93, 92, 102, 62, 93, 86, 73, 103, 62, 73, 92, 103,  0, 92,
 103, 92, 92, 73, 92, 62, 86, 103, 73,  0, 92, 103, 73, 92, 92, 103,
 93, 103,  0, 73, 103, 86, 73, 73, 62, 102, 62,  0, 73, 73, 73, 103,
 73,  0, 97, 103, 103, 73, 103, 73, 93, 103,  0, 103, 92, 92, 62, 62,
 73, 73, 103, 92, 92, 72, 103,  0,  0, 103, 92, 93, 92, 73, 102, 93,
  0, 62, 73, 73, 88, 88, 93, 92, 93, 93, 62, 93, 62, 103, 93, 93,
  0, 73,  0, 103,  0, 93, 73, 62, 93, 102, 73,  0, 97, 86,  0, 93,
 62, 93, 62, 73, 103, 93, 93, 92, 92, 93,  0, 97, 73, 93, 93, 62,
 62,  0, 93, 93, 73, 73, 93, 103, 73,  0, 73, 70, 93,  0,  0, 73,
 88,  0, 93, 73, 93, 92, 73, 93, 92, 73, 103, 73, 73, 62,  0, 73,
 73, 103, 92, 92, 73, 62,  0, 93, 86, 86, 62, 97, 93,  0, 86,  0,
 93, 93, 103, 97, 73, 103, 73, 93, 62, 93,  0, 93, 93, 103, 73, 93,
 103, 93, 73, 62, 93, 93, 62, 93, 73, 97, 73, 93, 92, 88, 103, 93,
 93,  0, 103, 103, 62,  0, 73, 92, 73, 93,  0, 73, 93, 93,  0, 103,
  0, 93, 103, 93, 93, 93, 93,  0, 62, 62,  0, 93, 93, 73, 102, 93,
 103,  0, 93, 73, 62,  0, 102, 93, 62, 86, 73, 92,  0, 73, 73, 103,
 88, 92, 93,  0,  0, 93, 93, 88, 93, 93,  0,  0, 93, 93, 72, 72,
 102, 93, 103, 73, 103, 103, 97, 97,  0, 62, 93, 92, 73, 73, 62, 62,
 102,  0, 93, 93, 103, 73, 93, 92, 103, 103, 93, 73, 93, 103, 93, 93,
 73, 103, 103, 93, 93, 102, 62,  0,  0, 97,  0,  0, 92, 102, 62, 93,
 93, 103, 103, 62, 103, 93, 103, 93, 93, 62, 62, 103, 62, 93, 103, 93,
 62, 102, 73, 103, 93, 93, 93, 62,  0, 103, 73,  0, 88,  0, 97, 86,
 62, 93, 92, 93, 86, 103, 62, 73,  0, 92, 103, 88, 102,  0, 62, 93,
  0, 103, 93, 97, 97, 97, 97, 70, 62, 103, 72, 103, 103, 92, 92, 93,
 62, 102, 92,  0, 93, 73, 93, 86, 93, 86, 103, 62, 103,  0, 93, 93,
 93, 73, 73, 62, 93, 62, 93, 102, 103, 103, 93, 103, 103,  0, 102, 62,
 103, 86, 97, 86, 93,  0, 73, 93, 92, 92, 73, 103, 102, 103, 86,  0,
 103, 93, 62,  0, 73, 73, 93, 93, 92, 103, 62, 62, 62, 93,  0, 103,
 103, 73, 92,  0, 62,  0, 86, 97, 72, 73, 73, 92,  0, 62, 93, 73,
 73, 103, 103,  0, 93, 103,  0, 73, 92, 93, 73, 103, 86, 73, 93, 62,
 103, 86, 62, 62, 92,  0, 73, 92, 103, 92, 73, 73, 103,  0, 62, 103,
  0,  0, 73,  0, 62,  0, 92,  0, 73, 93, 92, 102, 93, 93, 73, 62,
 92,  0,  0, 73, 73,  0, 93,  0, 103, 93,  0, 103, 103, 73, 103,  0,
 93,  0, 93, 93, 93, 86, 73, 93, 92, 93, 62, 62, 93, 86, 93, 93,
 93, 73,  0, 92, 73, 103,  0, 62, 93, 93, 72, 93,  0, 93, 62, 92,
 72,  0, 73, 103, 93, 93, 86, 93, 73, 62,  0, 93, 62, 93, 86, 93,
 103, 73, 103, 73,  0,  0, 93, 92, 93,  0, 93, 93, 93, 93, 92, 97,
  0, 93,  0, 103, 93, 72, 86, 86, 92, 73, 93, 73, 73, 93, 103, 92,
 97, 86, 97, 97,  0, 103, 93, 103, 102, 93,  0, 73, 102, 73, 93, 93,
 93, 93,  0, 93, 62, 103, 93, 73,  0, 92, 73,  0, 93, 103, 93, 93,
 93, 88, 86, 86, 86, 88, 62,  0, 97, 97, 93,  0, 103, 93, 62, 93,
 93, 92, 93, 93, 103, 93, 103, 93, 73, 73, 73, 103, 93, 73, 93, 93,
  0, 102,  0, 73, 102, 92, 73, 93,  0, 93,  0, 93, 92, 73, 103, 62,
 93, 103, 73, 103, 73, 93, 62, 93, 102, 103, 93, 62, 93, 93, 97, 73,
 86, 86, 88, 97,  0, 97, 86, 97, 97, 86, 97, 97,  0, 97, 73, 93,
 102, 62, 103, 93, 92, 102, 93, 93, 93, 92, 73, 103, 62, 62,  0,  0,
 103, 93, 103, 102, 93, 103, 92,  0, 103, 103, 92, 73, 73, 73, 92, 93,
 93, 93, 102, 93, 93,  0,  0, 62, 93, 102, 93, 73, 102, 93, 93, 73,
 97, 62, 93, 73, 92, 72, 103, 92,  0, 93, 73, 73, 93, 73, 92, 93,
 102, 93, 103, 93, 93, 92, 103, 103, 73, 62, 73, 86, 73, 97, 86, 93,
 97,  0, 86, 86, 86, 97,  0, 97, 97, 97, 97, 97, 97,  0, 97, 97,
  0, 97, 73, 93, 103,  0, 93, 93, 73, 62, 73,  0, 73, 102, 86, 103,
 73, 93, 86,  0,  0, 73, 73, 62, 103, 93, 93, 92, 62, 103, 73, 103,
 62, 103, 93, 102, 92, 73,  0, 97, 93, 93, 73, 103, 93, 93, 97, 62,
 93, 93, 93, 93, 102, 102, 93,  0, 93, 72, 70, 73, 102, 92, 93, 73,
 93, 93, 62, 93, 93, 70,  0, 62, 62, 86,  0, 62, 86, 86,  0, 86,
 97, 97, 97, 88, 97, 97, 97, 88, 97, 97,  0, 102,  0, 73, 103, 103,
 62, 103, 103,  0, 93, 103, 93, 93, 73, 103, 62, 103, 103, 73, 92, 92,
 73, 93, 103, 93, 62, 93, 102, 73, 62, 73, 73, 73, 73, 86,  0, 93,
 73, 73, 73, 93, 92,  0, 103, 93, 62,  0, 62, 92, 103, 92,  0, 92,
 92, 103, 93, 103, 73, 62, 88, 93, 93, 103, 103, 73, 73, 93, 103, 93,
 93, 92, 103, 93, 73, 93, 86,  0,  0, 86, 86, 62, 86,  0,  0,  0,
 97,  0, 97,  0, 92, 62, 92, 73, 103, 93, 86, 93, 103, 93, 73, 62,
 103, 103, 93, 103, 92, 93, 103, 92, 93, 62, 93,  0, 103, 103, 73, 92,
 93, 92,  0, 93, 73, 62, 73, 92, 103, 73, 103, 103, 103, 62, 93, 92,
 102, 102, 92, 73, 73, 102, 103, 73, 73, 93, 93, 103, 102, 103,  0,  0,
 86, 88,  0,  0, 92, 93, 103, 73, 92, 62, 103, 93, 92, 93, 93, 92,
 102, 103, 93, 103, 73, 73, 62, 103,  0, 86, 86, 86, 86,  0,  0, 97,
 97, 86, 86, 86, 97, 92, 86,  0, 86,  0, 92,  0,  0, 97,  0, 73,
 93, 62, 73, 103, 93, 103, 86, 73, 103, 93,  0, 103, 73, 93,  0, 93,
 73, 73, 102,  0, 73, 103,  0,  0, 73, 103, 92, 73, 73,  0, 103, 73,
  0, 73, 73, 92, 93, 86, 73, 102, 73, 92, 93, 103, 92, 93, 93, 73,
 93, 86, 92, 102, 62, 103, 102,  0, 103, 103, 92, 93, 103, 92, 93, 92,
 103, 102, 62, 86, 92, 92, 73, 93, 93, 93, 103, 103, 88, 86, 86, 62,
 70, 86, 93, 73, 97,  0, 72, 97, 97, 97, 86,  0,  0, 102, 92,  0,
 73, 92, 62, 73, 93, 93, 103, 73, 70, 73, 73, 93, 93,  0, 73,  0,
 92, 103,  0, 73, 73, 103, 103, 93, 102, 73, 73, 102, 73, 102, 92, 103,
 73, 93, 86, 73, 93, 73, 73, 102, 62, 73, 62, 93, 103, 73, 92, 92,
  0, 93, 73, 92, 73, 62, 73, 86, 62, 73, 93, 92, 93, 92, 93, 73,
 93, 62,  0, 92, 72,  0, 62, 62, 86, 92,  0, 97,  0, 86, 86, 97,
 97,  0, 103,  0, 73, 103, 73, 92, 92,  0,  0, 92, 73, 93, 103, 62,
  0, 103, 93, 103, 73, 62, 73, 73, 73, 86,  0, 92, 73, 93, 103, 93,
 103, 103, 92, 62, 73, 92, 73, 73, 73, 73, 93, 86, 86, 73,  0, 103,
  0, 103, 86, 92, 92, 103, 73, 93, 72, 92, 62, 92,  0, 103, 92, 93,
 103, 93, 86, 92, 62, 73, 73, 73, 102, 86, 88, 86,  0,  0, 86, 97,
 62, 97, 103,  0, 103, 93, 86, 62, 92, 92, 92, 103, 73, 93, 102, 103,
 73, 73,  0,  0, 93, 62, 103, 93, 92, 103, 62, 92,  0, 73, 103, 73,
 102, 103, 62,  0, 73, 103, 103,  0, 93, 93, 73, 102,  0, 73, 73, 92,
 73, 93, 92,  0, 103, 97, 92, 103, 73, 73, 103, 73,  0, 73,  0, 73,
  0, 70, 86, 62,  0,  0, 73,  0, 86, 97,  0,  0, 97,  0, 103, 92,
 93, 103,  0, 103, 93, 73, 62, 103,  0, 103,  0, 62, 73, 92, 93,  0,
 93, 102, 73, 73, 73, 73, 73, 93,  0,  0, 73, 103, 92, 62, 103, 103,
 93, 73, 92, 92, 73, 103, 73,  0, 73, 97, 86, 70, 93, 73, 92, 103,
 62, 62,  0, 92, 103,  0, 73, 73, 92, 73, 73, 92,  0, 103, 62, 62,
  0, 86, 92, 92,  0, 73, 103, 73, 62, 62,  0, 73, 103, 73,  0, 73,
 103, 92,  0, 92, 62, 62, 62,  0,  0, 73, 92, 92, 103, 103, 92, 92,
 73, 73,  0,  0, 62, 73,  0, 103, 92,  0, 92, 73, 103,  0, 73, 73,
 103, 103, 62, 73,  0,  0,  0,  0, 73, 73, 92, 92, 103, 62,  0,  0,
 73,  0, 103, 103, 92, 86, 62, 62, 73, 103, 92, 73,  0,  0,  0, 103,
 103, 103, 92, 73,  0,  0, 92, 103, 73, 73, 73, 62,  0, 86, 103, 86,
 93, 93, 97, 93, 70, 73,  0, 88, 103,  0,  0, 62, 103, 73,  0, 103,
  0, 73, 93, 73, 73, 62, 103, 93, 92, 93, 93, 103, 73, 92, 93, 103,
  0, 73, 73, 93,  0, 73, 102, 93, 73, 93, 103, 73, 93, 103, 92,  0,
 92, 73, 62, 86, 92, 73, 103,  0, 62, 93,  0, 92, 73, 62, 73, 92,
 103, 92, 93, 93, 93, 72, 93, 102,  0, 86, 93, 62,  0, 73, 62, 86,
 62,  0, 73, 86, 86, 62, 73, 73, 92, 93,  0, 93, 97, 62, 103, 92,
 92, 97, 102, 93, 93, 62, 93, 97, 73, 93, 93, 88, 73, 93, 73, 73,
  0, 73, 97, 97, 73, 92, 93, 103, 92, 73, 97, 102,  0,  0, 92, 103,
 103, 97, 103, 103, 92, 73, 73, 73, 62, 62, 93, 92, 62, 103, 103, 92,
 103, 86, 92, 93, 88, 93, 73, 93, 62, 62, 92, 86, 92, 103, 62, 93,
 92, 97, 97, 103, 103, 93, 92, 73, 73, 103, 73, 93, 103, 93, 86, 72,
 73,  0, 93, 93, 93, 97, 102, 72, 92, 97, 103, 93,  0,  0, 73, 86,
 73, 70, 73, 103, 73,  0, 103, 103, 73,  0, 97, 93, 92,  0, 62, 93,
 73, 62, 73, 93,  0, 97,  0, 103, 73, 102,  0, 73, 73, 72, 73, 103,
 73, 73, 103, 73, 103, 102, 72, 97, 92, 103,  0, 73, 73, 102, 62, 93,
 102, 93, 62, 93, 93, 72, 72, 86, 72, 102, 72, 93,  0, 73,  0, 102,
 73, 72, 97, 92, 93, 73, 102, 102, 102, 97, 72, 73, 103,  0, 102, 72,
 72,  0, 97, 103, 93, 70, 103, 86, 93,  0, 62, 103,  0, 97, 92, 103,
 93, 93, 93, 73,  0,  0, 72, 97,  0, 97, 102, 103, 73, 103, 92, 103,
 93,  0, 103,  0, 102, 93,  0, 93,  0, 103, 86, 102, 102, 93, 93, 93,
 93, 72, 86,  0, 97, 73, 73, 103, 93, 72, 93, 103,  0, 103,  0, 103,
 93, 73, 93, 92, 102,  0, 102,  0, 103, 70, 92, 103,  0, 93, 93,  0,
 73, 93, 93, 93, 73, 102, 102, 103, 93, 102, 73, 73, 93, 92, 73, 72,
 93,  0, 92, 93, 102, 103, 92, 62, 103, 93, 92, 93, 103, 73,  0, 70,
  0, 88, 86, 97, 97, 97, 97, 97,  0, 97, 97, 93, 73, 72, 93,  0,
 103, 93, 70, 93, 103,  0, 73, 73, 93, 93, 92, 93, 93, 93, 93, 93,
 73, 92, 103, 73, 93, 93, 103, 73,  0, 93, 93,  0, 93, 103,  0, 103,
 102, 103, 103, 93, 102, 93, 102, 93,  0, 92, 103, 93, 103, 92, 72,  0,
 102, 93, 93, 93,  0, 93,  0, 103, 93, 103, 88, 102, 103, 73, 102, 93,
 93, 93, 103, 93, 62, 72, 97, 97, 97, 73, 97, 97, 97, 97, 97,  0,
 73, 72,  0, 73, 102,  0,  0, 102, 73, 73, 103, 93, 93, 73, 102, 103,
 73, 103, 93, 62,  0,  0, 73, 93, 73, 93, 102, 93,  0, 73, 93, 92,
 73,  0, 73,  0,  0, 93, 62, 102, 103, 92, 93, 93, 73, 73, 102, 103,
 73, 102, 93, 93, 73, 93, 92, 73, 92, 102, 73, 93, 102, 93, 93, 103,
 73, 93, 73, 97, 86, 88, 97, 97, 97,  0, 97, 97,  0, 97, 97, 97,
  0, 97, 97, 97, 97,  0,  0, 62, 73, 93, 93,  0, 88,  0, 102, 103,
 72, 103, 73, 93, 92, 103, 93, 103, 73, 93, 93,  0, 92, 73, 93, 102,
 103,  0,  0,  0, 93, 73, 73, 93, 93, 92, 73, 73, 102, 73, 73, 73,
 73,  0, 102, 73, 73, 93, 73, 103, 93, 72, 73, 73, 93, 73, 93,  0,
 73, 102, 103, 93, 102, 93, 62, 103, 103, 86,  0, 88, 86, 97, 97, 97,
 97, 97,  0, 97, 97,  0, 97, 97, 97, 97, 102, 72, 103,  0, 72, 93,
  0,  0, 93, 73, 103, 93,  0, 103, 93, 62, 73, 73, 92, 103, 73, 102,
 93,  0, 73,  0, 102, 93, 93, 93, 103, 73, 103, 93, 93, 73, 62, 103,
 73, 93, 92, 73, 73, 92, 102, 73, 93, 93, 73, 103, 73, 102, 93, 103,
 102, 93, 103, 73, 93, 103, 93,  0, 92, 103, 92, 93, 93, 73, 93, 103,
 103, 93, 73, 93, 103, 92, 103, 93,  0, 93, 92, 93, 102, 73,  0,  0,
 103,  0,  0, 73, 62, 93,  0, 86, 86, 86, 88, 86, 97, 97, 97,  0,
 97, 97,  0, 86, 97, 86, 97, 97,  0, 92, 93, 92, 73, 93, 62, 92,
 93, 93, 103, 93, 93, 93, 92, 103, 73, 88,  0, 93, 92, 93, 92, 93,
 73, 73, 102, 73, 72, 73, 103,  0, 93, 103, 93, 103, 103, 73, 92, 73,
 73, 73,  0, 93, 102, 103, 73, 73, 62, 103, 92, 103,  0, 93, 93, 62,
  0, 103, 103, 102, 102, 73, 93, 62, 93,  0, 73, 93, 103, 103, 103, 93,
 73, 73, 103, 103, 73, 73, 73, 92, 103, 73,  0, 93,  0,  0, 93, 92,
  0, 73, 92, 103, 73,  0, 86, 73, 73, 73,  0, 62,  0, 62, 88, 88,
 86,  0, 86, 97,  0, 97, 97,  0, 73, 72,  0,  0, 86, 103, 73, 93,
 93,  0, 73, 103, 73,  0, 92, 73, 93, 103,  0, 73, 93, 92, 73, 93,
 103, 73, 93, 73, 73, 93, 73, 102,  0,  0, 93, 73,  0, 62, 103, 93,
 73, 102, 93, 103, 72,  0, 93, 93,  0, 73, 93, 70, 73, 93, 73, 103,
 103, 102, 93, 103, 92, 92, 73, 102, 103, 92, 103, 93, 92, 103, 103, 102,
 73, 93, 73, 93, 93, 93, 73, 97, 73,  0, 97,  0, 73, 86, 88, 97,
 97, 97, 97,  0, 97, 97, 97,  0, 97, 97,  0, 103, 92, 103, 103, 92,
  0, 73, 92,  0, 93, 73, 73, 92, 92, 102,  0, 103, 73, 103, 92, 92,
 73, 92, 93, 73, 62, 73, 93, 73, 103, 93, 103,  0, 62, 103, 73, 93,
  0, 86, 73, 93, 93, 93, 62,  0, 103, 73, 103, 62, 73,  0, 73, 73,
 93, 73, 92, 92, 97, 73, 103, 73,  0, 102, 102, 93, 92, 102, 73, 102,
 103, 93, 92, 102,  0, 73, 102, 73, 92, 73, 73, 103, 103,  0, 93, 92,
 73, 92,  0, 73,  0, 86, 97, 97,  0,  0,  0, 97,  0, 97, 73, 103,
 73, 103, 103, 103, 92, 73,  0, 103, 93, 62, 103, 92, 88, 103, 102, 92,
 73, 103, 102, 73, 92,  0, 93, 73, 62, 73, 73, 73, 103, 93, 93, 92,
 92,  0, 72, 73, 88,  0, 73, 73, 93,  0, 93, 73, 93, 103, 103, 73,
 92, 86, 92, 62, 93, 73, 92, 103, 102, 72,  0, 103, 102, 102, 93,  0,
 103, 86, 103, 103, 103, 73, 103, 92,  0,  0, 62,  0, 97,  0, 73, 62,
 103, 93, 73, 92, 92, 103, 103, 102, 103, 73, 92, 73, 73, 73, 103, 103,
 103, 92, 73, 93, 73, 62, 102,  0, 73, 93, 73,  0, 103, 73,  0, 73,
 93, 92, 93, 92, 73, 62, 92, 103, 103, 72, 103, 73, 73, 73, 73, 73,
  0, 97, 97,  0, 92, 92,  0,  0, 92,  0, 62, 92, 73, 73, 102, 92,
 93, 93, 73, 73, 92,  0, 73, 73, 103, 103,  0, 92, 92, 73, 93, 93,
 103, 92, 73, 86, 73, 62, 86, 73,  0, 62, 92, 73, 103, 62, 92, 73,
 103, 92,  0,  0, 73, 103, 103, 103,  0, 92, 73, 92, 73, 103, 73, 92,
  0, 93,  0,  0, 73, 92, 73, 103, 92, 73, 93, 93, 73, 92, 86, 92,
 103, 73, 73, 102, 73,  0, 92, 92, 73, 73, 73, 73, 86,  0,  0, 103,
 92, 73, 92, 73, 103, 72,  0, 103, 73, 102, 73, 73, 103,  0, 92, 73,
 73, 73, 73, 103, 103, 73, 73,  0, 103, 103, 103, 62, 93,  0, 62, 97,
  0, 92, 73,  0, 62, 103, 73, 73, 92,  0, 73, 73,  0, 103, 102, 73,
 73, 73, 73, 92, 103, 103, 73,  0, 73, 73, 73, 93, 70, 97, 62, 88,
 93, 73,  0,  0, 73, 70, 102,  0, 93,  0, 73,  0, 93, 92, 70, 97,
 97, 62, 73, 73, 73, 102, 103,  0,  0, 88, 93,  0,  0,  0, 93,  0,
  0, 73, 93, 73, 102, 102, 102, 62, 103, 93, 73, 62, 97, 97,  0, 73,
  0, 73,  0,  0, 103,  0,  0,  0,  0, 73,  0, 102, 93, 93, 93, 93,
 103, 102,  0, 93, 103, 73,  0, 102, 93, 88, 92, 97, 97, 97, 73,  0,
 97, 97, 97, 97,  0, 73, 73, 73, 93,  0, 102, 92,  0, 73, 73, 92,
  0, 103, 73, 103, 103, 62, 62, 73, 102, 93, 73, 97, 103, 92, 73, 88,
 73, 73, 73,  0, 102,  0, 97, 97, 97, 97,  0, 97, 97, 97,  0, 72,
 73, 86,  0, 73, 73,  0, 73, 72, 73, 93, 103, 73, 73, 93,  0, 73,
 73,  0, 73, 62, 103, 62, 103, 62,  0, 93, 72, 103, 103, 73, 73, 62,
 72,  0,  0, 72, 86, 97, 97, 73, 97, 93, 93, 73, 92,  0, 103, 73,
 103, 92, 73, 73,  0, 73, 93,  0, 73,  0,  0, 62,  0, 62, 73, 102,
 102, 102, 73,  0,  0,  0, 93,  0, 62,  0, 73,  0, 86,  0,  0,  0,
  0, 103, 73, 73, 73, 70, 103, 103,  0, 92, 70, 103, 93, 73, 93,  0,
 103,  0, 103, 73, 73, 86, 92, 62, 73, 92, 103,  0, 102, 73, 102, 73,
 103, 73, 92, 73, 93, 92, 93, 93, 102, 92, 73,  0, 92,  0, 93,  0,
 73,  0, 72, 97,  0,  0,  0,  0, 72, 62, 97, 73,  0, 93,  0,  0,
 103, 73, 73,  0, 93, 103, 73, 103, 86, 73, 93,  0, 62,  0,  0, 93,
 73,  0, 103,  0, 93, 86,  0, 73, 97, 93, 103, 103, 73, 73, 73, 93,
 102, 73, 62,  0, 73, 73,  0, 73, 93, 73, 73,  0, 93,  0,  0, 103,
 103, 92, 103, 102,  0, 72,  0,  0, 73, 93, 62,  0, 73, 73, 92, 103,
 103, 103, 73, 93, 103, 73, 73, 73, 92, 92, 73, 103, 62,  0, 93, 73,
 92,  0, 92, 62, 93, 93, 103, 86, 73, 103, 103, 73, 103,  0,  0, 92,
 93, 73, 73,  0, 73, 93, 92, 93, 73,  0,  0,  0, 92, 92, 93,  0,
 73, 73, 73,  0, 73, 86,  0,  0, 103, 93,  0, 92, 92, 73, 103, 92,
 62, 73, 73, 73,  0, 73, 93, 103, 62, 62, 73,  0, 73, 92,  0,  0,
 92,  0,  0, 103, 73,  0,  0, 62,  0, 73, 103, 92,  0, 102, 73, 103,
  0,  0, 73, 73, 62,  0, 73, 73, 93, 73, 93, 62, 93, 92,  0, 62,
 93, 97, 86,  0, 62, 93, 93, 97, 102, 102, 92, 93, 86, 93, 92, 93,
 86, 103, 103, 62, 73, 62, 92, 93, 93, 73, 73, 92, 93, 97, 62, 103,
 62,  0, 93, 103,  0, 62, 102,  0, 92, 93, 103, 93, 62, 93, 103, 93,
 103, 93, 93, 103,  0,  0, 97, 93, 62, 93, 73, 62, 73,  0, 102, 102,
 73, 62, 93, 73, 92, 97, 73, 103, 103, 93, 97, 103, 103, 92, 93, 102,
 93, 93, 86,  0, 102, 73, 73, 86, 73, 103, 97, 72, 73, 102, 103, 97,
 73, 73, 93, 103,  0, 73, 92, 73, 73,  0, 73, 103,  0, 73, 73, 97,
 86, 73, 92, 73, 73, 73, 73, 92, 103, 73, 73,  0, 93, 70, 103, 93,
 72, 62, 86,  0, 102, 73, 88, 97, 97, 88, 73,  0,  0, 73, 62, 73,
 73, 102, 93, 93, 93, 73, 92, 62, 97, 103, 73, 73, 103, 97, 93,  0,
 93, 73, 93,  0, 73, 62, 103, 93, 103, 93, 73, 86, 73,  0, 97, 103,
 93, 93, 86, 73, 73, 62, 73,  0, 72, 93, 73, 73, 88, 88, 97, 97,
 97, 97, 97, 102, 102,  0, 73, 93, 93, 92, 102, 102, 93, 92, 103, 73,
 73, 72, 62, 97, 62, 62,  0, 103, 73,  0, 93, 103, 73, 62, 97, 73,
  0, 73, 103, 102,  0, 97, 93, 93, 103, 103,  0, 93, 93, 93, 102, 86,
  0, 97, 102, 73, 62, 93, 73, 103, 62, 93, 88, 88, 70, 73, 88, 86,
 73, 102, 103, 73, 93, 103, 92, 93, 97, 97, 103, 103, 73, 62, 93, 93,
 73,  0, 73, 103, 92, 92,  0,  0,  0, 73, 73,  0, 73, 102, 92, 86,
 102, 73, 102,  0,  0,  0, 62, 93, 103, 73, 73, 73,  0, 103, 103, 103,
 102, 73, 73, 86,  0, 73, 103, 103, 92, 103, 92, 103, 102, 97, 103, 102,
 92, 62, 92, 73,  0, 92, 73, 103, 92, 62, 92, 92, 103, 73, 72, 73,
 103, 103, 73, 103, 93, 103, 103, 93, 73, 93, 73, 93,  0,  0, 102,  0,
 62, 97, 73, 103, 73, 103, 93, 103, 62,  0,  0, 97, 62, 73, 62, 102,
 103, 73, 102,  0, 73, 103, 103,  0, 73, 93, 62, 102, 73, 103, 97, 97,
 97,  0, 93, 93, 73, 103, 73, 102, 73, 103, 97, 93, 103, 62, 73, 103,
 93,  0, 93, 73,  0, 103, 103, 73, 93, 70, 93, 103, 103, 93, 86, 70,
 97, 97, 103, 103, 73,  0, 103, 73, 73, 102, 73, 73, 73, 103, 93,  0,
 93, 62,  0, 103,  0, 93, 62, 102, 73, 102, 92, 73,  0, 93, 92,  0,
  0, 86, 97,  0, 103, 103, 73, 62, 92, 62, 103, 62, 73, 103, 92, 103,
 103, 103,  0, 93, 103, 93, 93, 103, 73, 93, 102, 73, 73, 73,  0, 97,
 97, 62,  0,  0,  0,  0, 73,  0,  0,  0, 102, 102,  0, 73,  0,  0,
 73, 73, 93, 73, 103, 93, 102,  0, 102, 103, 102, 103, 102, 103, 102, 103,
 102, 103, 92, 93, 93, 93, 93,  0,  0, 62, 92,  0, 97,  0,  0, 92,
 103, 93, 73, 62, 103,  0, 103, 62,  0,  0, 73, 103,  0, 103, 73, 73,
 73, 103, 103,  0, 73, 93,  0, 102,  0, 93, 93, 93, 93, 62, 93, 93,
 86,  0, 103, 92, 92,  0, 62, 103, 62, 92, 92, 62,  0, 102, 103, 92,
 93, 103, 103, 92,  0, 73, 88, 97,  0, 73,  0,  0, 73, 73, 93, 73,
 102, 102,  0, 93,  0, 103, 103, 102, 73, 103, 73, 93,  0,  0, 97, 62,
 102, 62, 103,  0, 73, 73,  0, 73, 103, 62, 103,  0, 102,  0, 93, 103,
 103, 103, 86, 103,  0, 73, 103, 93, 102, 102, 103, 103,  0, 73, 62, 103,
 92, 103, 103,  0,  0, 103, 73, 73, 73, 62, 72, 103,  0, 92, 73, 103,
 73, 73, 73, 73,  0, 73,  0,  0, 62, 62, 92, 73, 62,  0,  0, 92,
 62,  0, 97, 62, 92, 73, 73, 73, 103, 73, 103, 103, 93, 73, 102, 103,
 93, 73, 93, 93, 102, 73, 93, 86, 103, 92, 62, 62, 73,  0, 93, 70,
 86, 86, 86,  0, 102, 73, 93, 93, 86,  0, 62, 103, 62, 73, 73, 102,
 73,  0, 73, 92, 93, 86, 62, 73, 73,  0,  0, 73, 92, 93, 86, 72,
 73, 93, 103, 93, 73, 92, 103, 103, 93, 97, 93,  0, 93, 73, 86, 93,
 62, 103, 73, 86, 62, 93, 92, 62, 93, 102, 103, 93, 93, 72, 73, 102,
 93, 93, 93, 93,  0, 97, 62, 93, 93, 103, 93, 88, 86, 103, 102, 103,
 102,  0,  0, 62, 86, 97, 86, 103, 102, 86, 86, 93, 93, 86, 102, 93,
 62, 86, 62,  0, 93,  0,  0, 62,  0, 93, 93, 93, 93, 92, 62, 103,
 86, 62, 92, 73, 92, 93, 93, 86,  0, 86, 93, 92, 73, 86,  0, 103,
 92, 62, 97, 86, 88,  0, 92, 92, 93, 102, 62, 62, 62, 103, 103, 93,
 73, 62, 86, 97, 73, 62, 93, 92,  0, 86, 92, 93, 73,  0, 86, 93,
 103, 93, 70, 62, 93, 103, 97, 97, 73, 102, 93,  0, 62, 93,  0, 97,
 97, 97, 103, 93, 102, 93,  0, 73,  0,  0, 73, 93, 97,  0, 97, 97,
 72, 88, 93, 93, 70, 93, 73,  0, 93, 93, 103, 73, 93, 93, 93, 103,
 103, 103, 93, 88, 102, 93, 62, 93, 97, 97, 93, 73, 103, 93, 103, 103,
 73, 73, 93,  0, 93, 93, 97, 103, 93, 92, 73, 93, 62, 73, 93, 103,
 103, 103, 93, 93, 102,  0, 72, 102, 97, 86, 97, 97, 62, 73, 62, 103,
 93, 102, 92, 92, 93, 73, 73, 73, 73, 102, 92, 73, 93, 73, 92, 93,
 102, 93, 62, 102, 62, 97,  0, 62, 103, 92, 102, 92, 102, 92,  0, 103,
 72, 73, 62, 103, 73, 102, 103, 97, 97, 102, 73, 102, 103, 103, 103, 93,
 93, 92, 93, 103, 93, 102, 102, 92, 73, 102, 97, 97,  0, 102,  0, 73,
 93, 73, 103, 102, 93, 102,  0,  0, 102, 62, 103, 86, 102, 73, 97, 97,
 70, 62, 92, 102, 62, 62, 92, 92, 92, 103, 62, 62, 93, 97,  0,  0,
 73,  0, 92, 73, 97, 62, 93, 73, 92, 103, 73,  0, 93,  0, 97, 103,
 73, 92, 92, 97, 103, 103,  0, 86, 86, 92, 92, 97, 92, 103, 103, 70,
 92, 103, 92,  0, 62, 73, 86,  0, 93, 73, 86, 93, 92, 93, 93, 73,
 86, 103, 72, 86, 93, 62, 93, 93, 93, 73, 73, 93, 62, 62, 93, 73,
 86, 97, 73, 93,  0, 103, 93,  0,  0, 93, 92, 103, 103, 103, 73, 62,
 62,  0, 62, 62, 102, 62, 103, 62, 62,  0, 103, 73,  0, 103, 93, 73,
 92, 97, 97,  0, 93, 73,  0, 86, 92, 86, 92, 73,  0, 103, 73, 93,
  0, 62, 93, 92, 73, 102, 93,  0, 93, 103, 93, 62, 62, 93, 102, 97,
 97, 97, 93, 73, 102,  0, 88, 88, 97, 62, 73, 93, 92, 73, 92, 93,
 62, 92,  0, 92, 92, 93, 103, 92, 62, 73, 92,  0, 103, 73, 93, 72,
 103, 102, 93, 73, 93, 73, 62, 73, 93, 102, 73, 92, 102,  0, 93,  0,
 62, 93,  0, 73, 93, 73, 62, 93, 93, 93, 103, 93, 86, 97, 62,  0,
 73, 73, 103, 73, 62, 103,  0, 62,  0, 102, 102, 92, 62, 73, 86, 93,
 93,  0, 102, 73, 86, 92, 88, 73, 102, 93,  0,  0,  0, 102, 62, 102,
  0, 73, 73, 73, 103, 102, 102, 93, 93, 103, 93, 73, 93, 103, 103,  0,
 88, 97, 62, 97, 73, 103, 103, 93,  0,  0, 103, 73, 73, 103, 103, 103,
 97, 97, 103,  0, 73, 73, 103, 62,  0, 73, 93, 93, 103,  0, 103, 103,
 103, 93, 102, 93, 62, 93, 93, 103, 93, 73, 103, 93, 102, 73, 73, 73,
 62,  0, 62, 62, 62,  0,  0,  0,  0, 93, 62,  0, 73, 102, 93, 93,
 102, 73, 73, 73, 102, 72,  0, 73, 73, 73,  0, 92, 102, 102, 93, 73,
  0, 93, 97,  0, 62, 103, 62, 73,  0, 73, 103, 73, 73, 73, 92, 102,
 93, 73, 102, 73,  0, 93,  0, 102, 73, 97, 102, 73, 93, 92, 62, 62,
 93, 103, 73, 93, 73, 102, 92, 73,  0, 86, 73, 93, 92, 93, 62, 93,
  0,  0, 73, 62, 73,  0,  0, 92,  0, 103, 73,  0, 73, 93, 73, 73,
 73, 62, 62, 73, 73, 103,  0, 93, 73, 103, 92, 93, 93,  0, 103, 62,
 103,  0, 93, 93, 62, 93, 62, 93, 73, 93, 62, 97, 102, 93, 93, 92,
 103, 103, 73, 93, 62,  0, 97, 73, 102, 73, 73, 103, 92, 72, 97, 97,
 97, 97, 93, 73,  0, 103, 103,  0,  0, 102,  0,  0, 93, 102, 103, 73,
 73, 102, 93, 73, 93, 86, 97, 97, 97,  0, 97,  0, 97, 102,  0, 72,
 92, 103, 103, 102,  0, 93, 93, 93, 73, 72, 73, 73, 72, 102, 103, 73,
 102, 73, 92, 73, 93, 103,  0, 102, 72, 97, 88, 97, 97,  0, 97, 86,
 97,  0,  0, 103, 62, 93,  0, 70, 103, 73, 73,  0, 102, 73, 102,  0,
 72,  0, 102,  0,  0, 97, 97, 97,  0,  0,  0,  0, 103, 93, 103,  0,
 103, 62, 73, 62, 103, 73,  0,  0, 103, 73, 102, 93, 93, 72, 102, 92,
 73, 73, 86,  0, 86,  0,  0, 97,  0, 73, 62, 73, 93,  0, 103, 73,
 73, 86,  0, 73, 73, 73, 92, 93,  0, 72, 62,  0, 93, 88, 93, 103,
  0, 93,  0, 93, 103, 92, 73, 93, 102, 73, 93, 97, 97, 62, 103, 102,
 73, 102, 73, 93, 103, 72,  0, 93, 103, 92, 92, 73, 103, 103,  0, 86,
 102, 70, 102, 102, 72, 86,  0,  0,  0, 97, 92, 103, 92, 62, 93, 62,
  0, 93,  0, 73, 73, 93, 86, 62, 103, 102, 93, 93, 103, 73, 103, 73,
 93, 92, 62, 62, 93, 102, 62,  0,  0, 97, 92, 103,  0, 73, 73, 103,
 103, 103, 73, 73, 62, 73, 62, 92, 93, 73, 103,  0, 93, 73,  0, 92,
  0,  0, 102, 103, 93,  0, 62, 102,  0, 73, 102, 103, 73, 92, 73, 103,
 62, 93, 73,  0, 73, 72, 62, 86,  0, 73,  0,  0, 103,  0, 92,  0,
 103, 92, 92, 72, 73,  0,  0, 73,  0, 92, 62, 73, 103, 73, 102, 62,
 62, 73,  0, 73, 72, 103, 92, 103, 73, 103, 92, 92, 92, 103,  0, 73,
  0, 103,  0,  0, 70, 103,  0,  0, 73, 73, 93, 70, 88, 103, 93, 103,
 93, 93, 73,  0, 103, 103, 102, 92, 93, 93, 103, 103, 73,  0,  0, 103,
 92, 103, 73, 93, 103, 92, 93, 93, 62,  0, 93, 102, 102, 93, 93, 93,
 93, 73, 88, 73, 73, 93,  0, 102, 93, 103, 73, 103,  0, 93,  0, 97,
 73,  0, 103, 73, 73,  0,  0, 88, 97, 103, 93, 62, 103, 73, 62, 92,
 88, 93, 73,  0, 88, 88,  0,  0, 73,  0, 93, 103, 62, 92, 92, 93,
 73, 62, 73, 103, 103, 103, 103, 73, 103,  0, 72, 103, 103, 86,  0,  0,
 73, 103, 73,  0, 73,  0, 92, 93, 103, 62, 92, 103, 73, 73, 92, 62,
 92, 103, 73, 93, 103,  0, 73, 73, 103, 93, 93, 102,  0, 93, 93, 92,
 93, 93, 62, 97, 62, 73, 97, 62, 103, 93, 62, 93,  0, 72, 73, 103,
  0, 93, 93,  0, 62, 93, 103,  0, 93,  0, 62,  0, 73, 103, 103, 93,
 103, 86, 62, 93, 93, 62, 93, 93,  0, 93, 103, 102, 92, 102, 73, 97,
 88, 62,  0,  0,  0,  0, 73, 73, 102,  0, 73, 93, 62, 97,  0,  0,
 93,  0, 102, 102, 73, 73, 97, 62, 92, 62, 103, 93, 103, 93, 88,  0,
 73, 103, 73, 73, 93, 103,  0, 93, 92, 92, 93, 103, 92,  0, 102, 92,
 93, 62, 73, 97,  0,  0, 73, 62, 73,  0,  0, 103,  0, 62, 92, 103,
 103, 92, 86, 97, 62, 62,  0, 93, 62, 102, 62, 93, 93, 93, 86, 93,
 92,  0, 86, 86, 103, 62, 93, 103, 103, 86, 73, 73, 103, 92, 92, 86,
 86, 97,  0,  0, 73, 62, 103, 93, 73, 62, 73, 73, 103, 62,  0, 103,
 103, 92, 92, 86,  0, 62,  0, 103, 73, 92, 62, 92, 73, 103, 73,  0,
 93, 73,  0,  0, 93, 103, 93, 97, 102, 93, 93, 73,  0, 86, 103, 93,
 102, 93, 62, 88, 93, 103, 102, 73, 93, 73, 103, 103, 73, 97,  0, 73,
 103, 70, 93, 86, 103, 93, 93, 93, 93, 73,  0,  0, 97, 97, 103, 93,
 102,  0, 73, 103,  0, 97, 97,  0, 72, 92, 92, 73, 102, 97, 92, 92,
 86, 73, 73, 102, 73, 103, 92, 73, 73, 62, 92, 62, 62,  0, 73, 93,
 73, 73,  0, 86, 92, 92, 62, 92, 86, 62, 92, 93, 62, 86, 62, 86,
  0, 103, 86, 86,  0, 86, 97,  0, 73, 93, 86, 62, 86, 86, 97, 93,
 93, 86, 86, 93, 73, 93, 93,  0, 62, 62, 86, 103, 62, 93, 73, 93,
 86, 62,  0,  0, 62,  0, 92, 73, 86, 93, 93, 103,  0, 102, 62, 93,
 73, 73, 86, 97, 93, 73, 93, 62, 93, 73, 93, 88,  0,  0, 73, 93,
 73, 93, 73, 73, 70, 97,  0,  0, 92, 93, 73, 93,  0, 73, 93, 62,
 93,  0, 73, 103, 72, 93, 93, 62, 93, 62, 102, 102, 93, 103, 102, 103,
 103, 102, 73, 93, 103, 92, 86,  0, 72, 86, 97, 73, 97, 62, 97, 62,
 103, 62,  0,  0, 73, 93, 92, 102, 92, 93, 73, 93, 93, 92, 103, 93,
 93, 93, 93,  0, 93, 62, 93,  0, 72,  0, 97, 97,  0, 88,  0,  0,
 102, 73, 97, 73, 103, 92, 103, 92,  0, 103, 62,  0, 86, 103, 93, 62,
 92, 93, 102, 103, 92, 93, 73, 102, 73, 97, 86, 97,  0,  0, 97,  0,
 97,  0, 73,  0, 103, 72, 86, 92, 73, 62, 73, 92, 73, 93, 103, 92,
 102, 103, 86,  0, 93, 93, 103, 93, 92, 92, 86, 103, 93, 93, 62, 86,
 103, 93, 97,  0, 73, 62, 97, 97, 97, 97, 88, 97, 102, 93,  0, 103,
 62, 93, 62,  0, 93, 103, 62, 73, 93, 73, 62, 62, 62, 62, 73,  0,
 92, 93, 62,  0, 92, 62, 93, 93, 62, 92, 103, 92, 93,  0, 73, 86,
  0, 97,  0, 97, 103, 73, 62, 62, 73, 102, 102, 103, 73, 93, 73, 73,
 92, 72, 73, 73, 92, 93, 93, 73, 103, 92, 102, 73,  0, 86, 97,  0,
 73, 72, 103, 92, 103, 62, 86, 93, 103, 103, 62, 73, 70, 73, 102, 73,
 92, 103, 103, 103, 62, 73, 103, 93,  0, 103, 73, 102, 102, 92, 103, 102,
 73, 92, 86, 86, 86,  0, 97, 86,  0, 103,  0, 62, 73, 73, 73, 93,
 103, 92, 73, 92,  0, 103, 102, 93, 103, 73, 93, 92, 103, 73,  0,  0,
 73, 62,  0, 103, 62,  0, 62, 92, 93, 103, 62, 73, 73, 92, 92, 93,
 93, 97,  0, 92,  0, 73, 62, 73, 73, 73, 103,  0, 92, 93,  0, 86,
 92, 62, 62, 103, 92, 62, 86, 73, 86, 103, 103, 103, 103, 62, 62, 92,
 92, 62,  0, 103, 92, 92, 73, 103,  0, 103, 73, 73, 92, 62, 103, 73,
 62,  0, 103, 93, 97, 92,  0,  0, 73, 103, 73, 97, 70, 102, 86, 73,
 73, 92, 86, 86, 73, 73, 62, 62, 73, 93, 73, 86, 73, 92,  0, 62,
 86, 72, 93,  0, 103, 93, 73, 93, 93,  0,  0, 86, 97, 97, 102, 93,
 62, 92, 93, 73, 88, 93, 62, 86, 92,  0, 97, 86,  0, 86, 88, 73,
 62, 93, 93, 93, 73, 73, 62, 62,  0, 93, 103, 103, 102, 93, 93, 103,
 86, 97, 86,  0, 62, 93,  0, 70, 102, 62, 93, 73, 72, 70, 92, 62,
 73, 73, 92, 62, 103, 102, 93, 102, 86, 102, 62,  0, 93, 103, 92, 93,
 93,  0, 92,  0,  0,  0, 62, 92, 72, 62, 73, 62, 73,  0, 73, 93,
 73, 73, 92,  0, 92, 62, 92, 73, 93,  0, 86, 93,  0, 73, 92,  0,
 92, 73, 92, 103, 92, 92, 92, 103, 103, 103, 93, 92, 73, 92, 73, 103,
 92, 103, 103, 103, 92, 92, 103, 92, 92, 92, 92, 92, 92, 103, 103, 73,
 93, 92, 93, 62,  0,  0, 62, 97, 73, 73, 62, 93, 92, 62, 92, 93,
 92, 103, 92, 92,  0, 92, 73,  0, 73, 92, 92, 73, 103, 103, 103, 92,
 103, 103, 92, 92, 92, 92, 92, 103, 62,  0, 73, 86, 86, 62, 92, 92,
 92, 103, 73, 103, 73, 73, 92, 62, 73, 62, 62, 92, 103, 62, 92, 73,
  0, 92, 92, 92,  0, 62, 92, 103, 92, 73, 103, 73,  0, 73, 93, 73,
 103, 92, 92, 92,  0, 86, 86, 97, 62, 92, 103, 103, 73, 92,  0, 103,
 73, 103, 62, 103, 73, 103, 103,  0, 103, 86,  0, 62, 103, 103, 73, 92,
  0, 103, 73, 92, 73,  0, 103, 62,  0, 86, 86, 86, 92, 103, 103, 92,
 73, 73, 92, 92,  0,  0, 102, 103,  0, 73, 103, 86, 92, 92, 93, 92,
 92, 92, 92, 62, 92, 92, 62, 103, 92, 103, 92, 92, 73, 92, 92, 92,
 73, 73, 103, 62, 103, 103, 103, 92,  0, 73, 92, 92, 103, 62, 103, 86,
  0, 86, 92,  0,  0, 86,  0, 103, 92, 103, 92, 73, 86, 92, 92, 73,
 92, 92, 62, 73, 86, 62, 103, 73, 92, 92, 103, 62, 92, 62, 73, 92,
 73, 103, 92, 73, 92, 62, 103, 73,  0, 103, 103, 92,  0,  0,  0,  0,
 62, 86,  0, 73, 86, 86,  0,  0, 103, 92, 92, 92, 73, 73, 73, 73,
 103, 103, 92, 73, 73, 103, 73, 103,  0,  0, 73, 92, 103, 103, 92, 92,
 103, 92, 92, 92, 73, 73, 86, 62, 62, 73, 73, 92, 62, 103, 92, 103,
 73, 92, 92, 103, 73, 92, 103, 92, 73, 92, 92, 93, 73, 92, 92, 103,
 73, 93, 73, 92, 103, 103, 92, 102, 73, 73, 86, 86, 73, 86, 62,  0,
 103, 73, 103, 73, 92, 92, 92, 73, 103, 92, 92,  0, 73, 86, 92, 103,
 73, 103, 103, 73,  0, 62, 86, 86, 73, 92, 92, 103,  0, 92, 62, 103,
 92,  0, 73, 103, 73, 73, 73, 73, 103, 92, 73, 92, 92, 92, 103, 86,
 73, 103, 93, 86,  0,  0, 103, 103, 92, 86, 103, 73, 92, 103, 86, 92,
 86, 103, 86, 92, 92, 103, 92, 73, 103, 73, 103, 93, 92, 62, 62, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,
 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,  0,  0, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 93,  0, 93, 73, 93, 62, 62, 103, 103, 103,
  0,  0, 97, 103, 102, 93,  0, 62, 73,  0, 73, 73, 92, 92, 86, 103,
 93, 93, 62, 62, 93, 93,  0, 97, 93,  0, 97, 103, 103, 103, 73, 93,
 92, 102, 97, 103, 62, 103, 103, 92, 93, 93, 93, 92, 73, 103, 93,  0,
 92, 70, 93, 73, 97, 92, 73, 92, 86, 93, 73, 73, 73, 103, 102, 103,
 62, 97, 86, 92,  0, 92, 92, 92, 92, 73, 93, 103, 93, 103, 93, 62,
 62, 103, 73,  0, 93, 73, 103, 62,  0,  0, 93, 73, 103, 93, 93, 97,
 73, 102, 103, 86, 93, 73, 103, 72, 92, 92, 62,  0, 73, 103, 86, 93,
 72, 73, 93, 73, 62, 73, 92, 73, 93, 93, 73, 73, 102, 93, 73, 102,
 103, 93, 73, 103,  0, 93, 86, 73, 62, 73, 93, 73, 93, 73, 102, 103,
 73, 73, 92,  0, 93, 93,  0, 73, 97,  0,  0, 103, 73,  0, 73, 102,
 93, 93, 73, 103,  0, 102, 93,  0, 103, 93, 73, 92, 103, 73, 102, 103,
 93, 72, 103, 93, 73, 73,  0, 73, 73, 92, 62, 93, 93, 103, 103, 103,
 93, 93,  0, 93, 93, 93, 93, 103, 62,  0, 62, 93, 93, 102, 103, 103,
 93, 103, 93, 62, 102, 93, 102, 93, 93, 93,  0, 73, 93, 62, 103, 103,
 70, 92, 97,  0, 103, 97, 102, 97, 93, 72, 72,  0, 103,  0, 62,  0,
 103, 97,  0, 93, 103, 102, 93, 102, 97, 103, 62, 88, 62, 93, 103, 93,
 62,  0, 97, 72, 62,  0, 93, 73, 73,  0, 93, 97, 97, 97,  0, 73,
 73, 73, 93,  0, 97,  0, 92,  0, 93,  0, 93,  0, 73, 73, 92, 86,
 62, 86, 86,  0, 103,  0, 62, 73, 86, 97, 97,  0, 73, 62,  0, 92,
 92, 102, 92, 92, 86, 103, 92, 92, 73, 92,  0,  0,  0, 92, 92, 93,
 97, 62, 73, 97, 93, 92, 93, 93, 62, 93, 73, 93, 93,  0, 62, 73,
 73,  0, 73, 93,  0, 73, 93,  0, 93, 73, 93, 93, 102, 93, 62, 97,
 97, 93, 93, 73, 97, 93, 62, 62,  0, 93, 93, 102, 86, 93, 72, 93,
  0, 93, 93,  0, 93, 73,  0, 97, 103, 62, 93,  0, 97, 97, 97, 97,
 97, 97, 72, 93, 93, 73, 88, 73, 103, 73, 73,  0, 93, 102, 93, 103,
 73, 73, 62,  0, 103, 103, 93, 102, 103, 93, 93, 93, 72, 93, 93,  0,
 103, 93,  0, 73, 93, 93, 73, 97, 97, 97, 97, 97, 97, 102, 62, 93,
 102, 93, 102, 102, 93, 73, 70,  0, 93, 103, 102, 73, 93, 93, 103,  0,
 73, 73, 93, 62,  0, 92, 93, 86, 92, 88, 93, 62,  0, 97, 97, 97,
 97, 97, 97, 97, 97, 73, 102, 62, 102, 73, 88, 92, 62, 73, 102, 73,
 62, 73, 73, 92, 103, 73,  0, 103,  0, 92,  0, 73, 102, 73,  0, 93,
 103, 88, 97, 86,  0, 62, 97,  0, 97, 92, 103,  0, 62, 73, 93,  0,
  0,  0,  0, 73, 73, 62, 93, 103, 97,  0, 102, 93, 102, 73, 92, 73,
 93, 93, 103, 93, 93, 93,  0, 62,  0, 97, 97, 73, 73,  0, 73, 86,
 102, 103, 73,  0, 73, 93, 92, 102, 62, 102,  0, 92,  0, 70, 93, 103,
 93, 93, 73, 73, 93,  0, 73, 103, 92, 93, 93, 97, 97, 97, 97, 93,
 93, 62, 93, 92, 62, 62, 103, 73, 93, 73, 93, 103, 73, 73, 62, 93,
 62, 97,  0, 86,  0, 92, 62, 73, 102, 73, 92, 102, 93, 93, 103, 73,
 92,  0, 103, 93, 86,  0, 72, 73, 93, 92, 97, 73, 73,  0, 103,  0,
 92, 73, 103, 93, 103, 92,  0, 73, 86, 73, 93, 102, 73, 92, 92, 92,
 93, 97, 93, 102, 73, 103, 93, 73, 86, 92, 102, 62, 72, 92, 62, 103,
 73, 92, 73, 86,  0, 103,  0, 103, 92, 92, 92, 103,  0, 103, 103, 92,
 92, 103, 73, 93, 62, 92, 73, 93, 92, 73, 93, 62, 102, 93, 73,  0,
 62, 62, 103, 93, 93, 62, 62, 73, 103, 103, 92, 93, 93, 62, 93, 103,
 102, 93, 93, 62, 72, 93, 97, 92, 92, 92, 92, 73, 93, 93, 86, 62,
 93, 73, 93, 62, 102, 73, 92, 86, 86, 62, 62, 93, 93, 103, 93, 93,
 73, 102, 102, 97,  0, 73,  0,  0, 102, 86, 93, 93, 93, 97, 86, 72,
 97, 97, 103, 93, 102, 93, 93, 93, 93, 93, 103, 97, 73, 73, 97, 73,
 92,  0, 73, 62, 102, 103, 62, 93,  0, 72,  0, 102,  0,  0, 103, 102,
 73, 103, 73, 73,  0, 73, 103, 73, 93, 92, 93, 73, 103, 86, 73, 93,
 62, 73, 86, 103, 92,  0, 92, 62, 93, 73, 86, 92, 73, 103, 93, 93,
 97, 92, 93, 97, 102, 73, 86, 92, 92, 97, 97, 62, 73, 102, 93, 102,
 103, 62, 97, 103, 102, 73,  0, 62, 97, 62, 102, 93,  0, 93, 102, 72,
 73, 102, 93, 73, 103,  0, 62, 97, 102, 93, 103, 103, 97, 93, 73, 93,
 103, 102, 73, 103, 102, 93, 88, 103, 102, 102, 70, 93, 93, 93, 102, 93,
 102, 93, 62, 93, 102, 73, 73, 102, 93, 93, 103, 92, 103, 93, 102, 62,
 73, 97, 73, 73, 97, 86, 62, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 62, 93, 93, 93, 93, 102, 73, 93, 97, 92, 62, 93, 93,  0, 93, 93,
 102, 93, 62, 93, 102, 93, 93, 92, 103,  0, 103, 93, 73, 103,  0, 102,
 73, 93, 73, 92, 93, 73, 103, 70,  0, 93, 92, 93,  0, 62, 103,  0,
 103, 102, 93, 93, 93, 93, 93, 102, 102, 93, 62, 62, 72, 73, 88, 97,
  0, 97,  0,  0, 97, 97, 92, 93, 86, 73, 97, 102, 93, 62, 103, 62,
 73, 62, 103, 86, 73, 73, 73, 72, 93, 73, 73, 93, 102, 102, 62, 93,
 62, 93, 92, 102, 93, 93, 93, 103, 93, 93, 102, 73, 102, 62,  0, 73,
 93, 73, 103, 102, 103, 92, 97, 102, 73, 93, 92, 73, 73, 103, 103, 93,
 93, 102, 93, 103, 102, 62, 103, 62, 86,  0, 97, 97, 97,  0, 97, 97,
 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 62,  0,  0, 92, 73, 92, 73, 93, 102,  0, 73, 93, 93, 102, 73, 103,
 62, 73, 62, 73, 62, 88, 102, 92, 73, 93, 92, 73, 73, 103, 93, 73,
 73,  0, 102, 93, 103, 103, 92, 73, 102, 103, 92, 102, 70, 103, 93, 86,
 93,  0, 92, 73, 73, 73, 103, 103, 93, 102, 93, 93, 62, 62, 73, 73,
 72, 88, 97, 97, 97, 86, 97, 97, 97, 97, 97,  0, 97, 93, 62, 103,
 102, 93, 73, 73, 73, 93, 73, 102, 73, 103, 93, 73, 93,  0, 92, 102,
 62, 103,  0, 86, 102, 73, 93, 73, 93, 73,  0, 73, 93, 102, 73, 93,
 93, 72, 73, 73, 73, 72,  0, 73, 103, 93, 102, 92, 73,  0, 73, 92,
 93, 93, 93, 73, 92, 73, 103, 86, 102, 102, 73, 92, 103, 93, 73, 73,
  0, 102,  0, 93, 93,  0, 102, 92,  0, 73, 103, 93, 93, 93, 93, 102,
 73, 102, 73, 92,  0, 62,  0,  0, 97, 62,  0, 73, 97, 97,  0,  0,
 86,  0, 86, 73, 97, 97, 97, 97, 97, 92, 86, 73, 92, 73,  0, 103,
 73, 93, 73, 73, 73, 92, 73, 73, 93, 103, 73, 73, 93, 93,  0, 73,
 73,  0, 73, 73, 73, 103, 93, 103, 62, 92, 62, 73, 73, 103, 92, 62,
 73, 102, 103,  0, 73,  0, 103, 93, 62, 102, 102, 93, 70, 73, 73, 73,
 103, 93, 86, 93, 62, 103, 92, 103, 73, 93, 62, 93, 93, 93, 92, 92,
 103, 88,  0, 102, 103, 93, 102, 92, 102, 92, 93,  0, 62, 103, 73,  0,
  0, 62, 93,  0, 86, 62, 73, 97, 97, 97,  0, 88, 97, 73, 72, 73,
 92, 73, 62, 62, 92, 62,  0, 72, 73, 93, 73, 73, 93, 73, 103, 92,
 73, 93, 73,  0, 73,  0, 62, 73, 103, 103, 103, 73, 73, 86, 73, 102,
 73, 103, 93,  0, 102,  0, 73,  0, 93, 93, 102, 92, 92, 70, 62, 93,
 103, 93, 103,  0, 93, 73, 92, 103, 62, 93, 93, 92, 103, 93, 73, 103,
 93, 93, 73, 102, 73,  0, 93, 73,  0, 86, 86, 73, 62, 97,  0, 97,
 97,  0,  0, 97,  0, 97, 97, 103, 73, 73, 103, 73, 93,  0, 92, 103,
 102, 103, 103, 73, 92,  0, 73, 103,  0, 73, 103, 103, 93, 103, 73, 93,
 92,  0, 103, 62,  0,  0, 92, 103, 73, 73, 73, 73, 102, 73, 103, 73,
 62, 93, 73, 93, 92, 92, 73, 93, 92, 73, 93,  0, 103, 73, 103, 93,
 73, 93, 62, 103, 103, 103, 92, 103, 73, 73, 103, 102, 93, 92, 73, 103,
 73, 73, 62, 62, 62, 86, 62, 97, 97, 97, 97, 72, 97, 93, 73, 62,
 92, 92,  0, 93, 73, 73, 103, 73, 93, 93, 93, 86,  0, 73, 92, 62,
 62, 103, 62, 103, 73, 92, 102, 92, 92, 102, 86, 73, 62, 103, 102, 62,
 103, 103, 103, 92, 102, 73, 73, 73, 93, 92, 92, 103, 73, 92, 73, 62,
  0, 73, 97,  0, 97, 73, 73, 92, 73, 102, 102, 102, 73, 62, 93, 62,
 92, 103, 73, 73, 93, 102, 103, 93, 92, 103, 92, 103, 103, 73, 73, 102,
 92, 92,  0, 62, 92, 73, 73, 86, 103, 92, 73, 93, 93, 103, 73, 103,
 103, 73, 103, 73, 93, 62, 92, 103, 93, 92, 93, 86, 86, 62, 88, 93,
 72, 73,  0, 73, 103, 73, 103, 102, 103, 93, 92,  0, 62, 103, 103, 103,
 73, 88, 103, 73, 73, 73, 73, 103, 73, 93, 62, 103,  0, 92, 103, 93,
 93, 73, 73, 97,  0, 93,  0, 73, 103, 73, 103,  0, 93, 92, 73, 103,
 62, 73, 73, 73, 93, 92, 103,  0, 103, 93, 92, 73, 73, 103,  0, 73,
 73, 73, 73, 62,  0,  0, 103, 92, 73, 92, 92, 93, 62, 73, 92, 102,
 103, 73, 86,  0, 103, 102, 92, 92,  0, 73, 92, 92, 73, 62, 62,  0,
 62, 102, 62, 86,  0,  0, 88, 92, 103, 103, 92, 103, 73,  0, 103, 73,
 73, 103, 92, 73, 73, 73, 73, 102,  0, 102, 73,  0, 73, 92, 73, 86,
 86, 73, 73, 73, 73, 73, 103,  0, 102, 73, 103, 73, 102, 62, 73, 92,
 103, 62, 62, 73,  0,  0, 103, 73, 73,  0,  0, 73, 73, 93, 93, 97,
 93, 97, 103, 103, 93, 92, 103, 62, 62, 103, 88, 73, 92, 62, 93, 92,
 62, 103, 102, 103, 103, 73,  0, 92, 73, 103, 73, 93, 70, 73, 72, 103,
 73, 93,  0, 73, 73, 62, 62, 103,  0, 93, 102, 93, 72, 97, 97, 97,
 97, 97, 97,  0,  0, 73, 73, 73, 62,  0, 93, 93, 93, 102, 73,  0,
 73, 103,  0, 93, 73, 93, 103, 73, 103, 73, 103,  0, 102, 72, 73,  0,
  0, 103, 73, 93, 93, 73, 62, 102, 102, 93, 93, 86, 97, 62,  0, 93,
 93, 102,  0, 103, 102, 102, 93, 103, 103, 103, 72, 73, 73, 73, 73, 103,
 102, 103, 73, 103, 93, 103, 93, 93, 73, 93, 97, 93, 73, 86, 88, 97,
 72, 102, 62, 73, 93, 62, 73, 103, 72, 93, 103, 93, 103, 73, 93, 93,
 62,  0, 73, 103, 93, 62, 73, 62, 73, 93, 73, 73, 92, 93, 88, 86,
 97, 97, 97, 97, 97, 73, 73, 73, 93, 93, 103, 92, 62, 62, 93,  0,
 93, 73, 93, 93, 103, 103, 92, 102, 93, 93, 93, 103, 73, 93, 103, 62,
 62, 92, 93, 102, 62, 97,  0, 97, 93, 103, 93, 73, 93,  0, 102, 62,
 73, 102, 72, 102, 73, 93, 73, 73, 103, 93, 73,  0, 73, 73, 102, 62,
 73, 102, 103, 73, 93, 73,  0, 93, 73, 62, 103, 93, 103, 62, 102, 93,
 103, 73, 73, 103,  0, 62, 73, 97, 97, 88,  0, 86, 93, 103, 93, 73,
 73, 73, 73, 93, 73, 92, 73, 93, 103, 93, 73, 73, 73, 103, 73, 92,
 93, 103, 73, 93, 102, 102, 92, 73, 92, 73, 92, 73, 73, 73, 93, 103,
 97, 62, 62, 73, 93, 73, 93, 73, 92, 73, 73, 102, 97, 97, 97, 86,
  0, 73, 93, 102, 103, 102, 62, 103, 102, 103,  0, 70, 62, 93,  0, 73,
 103, 73, 73, 102, 73, 62, 73, 102, 103, 62, 73, 73, 73, 73, 103, 93,
 62,  0, 92, 103, 73,  0,  0, 62, 97,  0, 73, 93, 102, 102, 103, 93,
 73, 62, 73, 93, 73, 102, 73, 73, 73, 73, 93, 92, 73, 93, 103, 103,
 93, 62, 73, 73, 92, 73, 93, 86, 103, 103, 102, 93, 73,  0, 62,  0,
 86, 72, 93, 72, 73, 62, 62, 73, 73, 103, 62, 72, 103, 73, 73, 103,
 93, 73, 103, 103, 103, 72, 73, 73, 73,  0, 102, 103, 73, 103, 97, 92,
  0, 62, 92, 103, 73,  0, 92, 92, 62, 93, 103, 92, 73,  0, 93, 103,
 73, 103, 73, 102,  0, 92, 103,  0, 73, 103, 102, 103, 73, 92, 86, 86,
 103, 92, 62, 102, 103, 93, 93, 73, 62, 103, 62, 102, 103, 73, 62, 103,
 73, 93, 93, 92, 73, 73, 73, 86, 103, 73, 73, 73, 73, 62, 103, 73,
 103, 92, 102, 73,  0, 103, 92, 73, 73, 93, 62, 92, 102, 73, 73, 73,
 93, 103, 86, 103, 93, 70, 86,  0, 103, 62, 103, 103, 93, 93, 103,  0,
  0, 62, 92, 92, 97, 103, 103, 93, 62, 93, 103, 92, 62, 92, 86, 62,
 62, 93, 93, 93, 70, 97,  0, 73, 93, 102, 73, 93, 97, 73, 97, 73,
 93, 103, 93,  0, 73, 92, 73, 93,  0, 103,  0, 62, 73, 93, 93, 93,
 103, 93, 93, 73, 97, 97,  0,  0, 93, 73,  0, 93, 73, 93, 73,  0,
  0, 73, 93, 73,  0, 73, 93, 92, 103, 92, 103, 103, 70,  0, 92, 103,
 62, 73, 93,  0, 93,  0,  0, 73, 103,  0, 103, 93, 73, 97, 86,  0,
 86, 93, 73,  0, 86, 86, 73, 93, 73, 73, 103,  0, 72, 103, 103, 86,
 103, 93, 93, 86, 86, 88, 97,  0,  0, 72, 103, 103, 103, 103, 102, 86,
 73, 62, 102, 62, 93, 93, 73, 73, 93, 93, 73, 103, 92, 92, 103, 93,
  0, 92, 97, 97, 97, 97,  0, 103, 93,  0,  0, 73, 73,  0, 73, 103,
 102, 102, 92, 93, 93, 62, 73, 103, 93, 93, 73, 73, 93, 92, 93,  0,
  0, 103, 93,  0, 86, 73, 103, 92,  0, 73, 93, 73, 92, 62, 103, 62,
 93, 73, 93, 93, 73, 103, 103, 73, 103, 102, 102, 97, 62, 86, 92, 73,
 62, 72, 73, 73,  0, 93, 103, 103, 62, 73, 93, 93, 73, 73, 73, 73,
 102, 103, 103, 73, 97, 103, 93, 73, 92, 62, 62, 92, 73, 73, 103,  0,
 62, 93, 103, 86, 93, 62, 103,  0,  0, 103,  0, 73, 92, 86,  0, 103,
 73, 73, 103, 73,  0,  0, 92, 103, 73, 73, 103, 103, 103, 73, 93, 93,
 92, 103, 103, 103, 92,  0, 93,  0,  0, 73, 92, 103, 73, 92, 103, 92,
 62, 73, 92, 103, 92, 62, 73, 86,  0, 73, 103, 102, 103, 62, 92, 93,
  0, 93, 73, 93,  0, 73, 93, 86, 92, 62, 86, 92,  0, 62,  0, 92,
 62,  0,  0, 92, 62, 103, 92, 92, 92,  0, 86, 103, 103, 73, 73, 103,
 62, 92, 73, 73, 73, 62, 92, 86,  0, 86, 92,  0, 92, 73, 73, 92,
 62,  0, 92, 86, 62, 62, 103, 103,  0, 73, 92,  0, 62, 92, 73, 92,
 92, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97,
 97, 97, 93, 73, 103, 103, 102, 62, 62, 73, 93, 73, 93, 92, 97, 73,
 73, 73, 73, 93, 73, 102, 93, 86, 73, 103,  0, 102, 73, 103,  0, 97,
 73, 103, 73, 102, 92,  0, 103, 73, 92, 62, 73, 73, 73, 62, 73, 103,
 93,  0, 92, 92, 103, 62,  0, 102, 92,  0, 92,  0, 92,  0, 92, 103,
 92, 103, 103, 92, 62, 103, 92, 92, 92,  0,  0, 92,  0, 92, 103, 92,
 62,  0, 103, 92, 62, 92, 62, 73,  0,  0, 92, 62, 103, 92,  0, 62,
 73, 92,  0, 86, 92, 62, 92, 62,  0, 73, 92, 92, 92, 62, 102, 73,
 103, 92,  0, 62, 73, 103, 92, 62, 93, 62, 73,  0, 73, 103, 103, 73,
 92, 92, 92, 62, 92, 92, 103, 103, 103, 73,  0, 92, 62, 62, 92,  0,
 92, 103, 92, 92,  0, 62, 92, 62, 73, 92,  0, 92, 92, 92, 92,  0,
 92, 92, 92, 92, 73, 103, 103, 103,  0, 102, 103, 103, 92,  0, 62, 103,
 62, 73, 92, 103, 92, 92, 103, 92,  0, 88, 97, 103, 92, 92,  0, 103,
 62, 92, 103, 93,  0, 92, 103, 62, 92, 103, 92,  0,  0,  0, 92, 62,
 92, 92,  0, 92, 92, 92, 92, 103, 92, 62, 73, 73, 86, 86, 62, 62,
 92,  0, 92, 62,  0,  0, 103, 62, 73, 92, 73, 103, 92, 73, 103, 92,
 73,  0, 92, 103, 92, 73, 103, 92, 103, 103, 62, 92, 86, 92,  0, 92,
  0, 103, 92, 103, 103, 103, 92, 103, 73, 73, 86, 92, 92, 103, 92, 103,
 92, 92, 92,  0, 92,  0, 92, 92, 73,  0,  0, 92, 62, 92, 92, 73,
 103, 92, 73, 92, 103, 103, 103, 92, 92,  0, 92, 73, 103,  0, 92, 103,
 92, 92, 92,  0, 92, 103, 103, 93, 73,  0, 103, 103, 86, 73, 92, 73,
 92, 103, 73, 73, 92, 73, 92, 92, 73, 92, 92, 92, 103, 92, 103, 62,
 92, 86, 73, 73, 73, 73, 93, 73, 92,  0, 73, 92, 92, 62, 73, 73,
 103, 73,  0, 92,  0, 73, 73, 103,  0, 92, 73, 73, 103, 73, 92,  0,
 73, 92, 103, 62, 62, 103, 103, 73, 103, 92, 73, 73, 86, 62, 92, 92,
 73, 73, 103, 103, 103, 73, 92, 73, 92, 103, 92, 86, 92, 73, 62, 92,
 73,  0,  0, 103,  0, 73, 93, 73, 73,  0, 73, 92, 93, 103,  0, 92,
 92, 86, 86,  0, 92,  0, 62, 92, 103, 103, 73, 73, 62, 92, 103, 73,
 92, 62, 73, 86, 103, 103, 73,  0, 73,  0, 92, 103, 92, 62, 92, 62,
 86,  0, 92, 92, 103, 103, 92,  0, 73, 92, 92,  0, 103,  0, 103, 103,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97,
 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 93, 62, 103, 86, 73, 73, 103, 103, 92,
  0, 93, 73, 73,  0, 103, 93, 102, 92, 102, 92, 103, 93, 73, 92, 103,
 92, 62,  0, 62, 103, 93, 73, 103, 62, 62, 93, 62, 73, 103,  0, 73,
  0, 93, 93, 62, 103, 73, 103,  0, 103, 103, 93, 93, 92, 103,  0, 73,
 73, 73, 73, 102,  0, 103, 103, 73, 93, 93, 93, 103, 86, 73, 62,  0,
 73, 73, 93,  0, 73, 93, 103, 62,  0, 93, 93, 62, 93, 92, 86, 73,
 103, 73, 103, 103, 93, 73,  0, 73, 93, 103, 73, 62, 103, 92, 92,  0,
 92, 92, 92, 73, 103, 73,  0, 92, 92, 92, 92, 92, 92, 86, 86, 92,
 92,  0, 92, 92, 92, 73, 92, 92, 92, 103, 103, 92, 92, 92, 73, 92,
 92, 92, 92, 92, 92, 103, 62, 92, 92, 62, 92, 62, 73, 86, 86, 103,
  0, 92, 73, 92,  0, 103, 62, 73,  0, 103, 92, 86, 92, 103, 92, 73,
 92, 103, 92, 92, 92, 73, 92, 73, 103,  0, 92,  0, 103, 92, 73, 62,
 103, 73, 62, 73, 73, 103,  0, 62, 103, 73, 92, 92, 92, 92, 103, 62,
 73, 62, 73, 62, 92, 92, 73, 92, 92, 103, 92, 86,  0, 92,  0, 92,
 92,  0, 62, 92, 92, 73, 92, 103,  0, 73,  0, 103,  0, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97,  0,  0, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97,  0,
 97, 97, 97, 97, 93, 62, 93, 93, 73, 103,  0, 93, 103, 93, 103, 73,
 93, 86, 73, 93, 93, 97, 72, 93, 73, 73,  0, 73,  0, 73,  0, 62,
 73, 93, 62,  0, 102, 93,  0,  0, 62, 73, 93, 97, 73, 103, 73, 73,
 103, 102, 73, 73, 72, 103, 73,  0,  0, 92,  0, 73, 73,  0, 62, 102,
 103, 73,  0, 93,  0, 73, 62, 73, 92,  0, 73, 103, 103, 73, 73, 103,
  0, 97, 103, 93, 72, 102, 73, 103, 97, 103, 93, 62, 102,  0, 93, 72,
 62, 73, 92, 97, 97, 103, 102, 103, 103,  0, 62, 93, 93, 73, 102, 93,
 73, 102,  0, 73, 62, 103, 93, 102, 73, 103, 93, 93, 73, 93, 97, 93,
 73, 92, 73, 93, 102, 62, 73, 103, 93, 73, 93, 93, 102,  0, 73, 93,
 103, 103, 103, 93, 103, 88,  0, 97, 97, 97, 72, 97, 92, 102, 73, 92,
 73, 62, 73, 73, 103, 102, 103, 73, 86, 93, 93, 62, 97, 73,  0, 93,
 92, 103, 73, 73, 102, 73, 103, 73, 73, 73, 73, 73, 73, 93, 93, 93,
 103, 103, 102, 102, 73, 73, 103, 103,  0, 72, 88, 73, 97,  0, 72, 97,
 92, 102,  0, 103, 92, 93, 103, 62, 103, 102, 97,  0, 73, 102, 73, 73,
 102, 102, 93,  0, 93, 73,  0, 93, 93, 93, 93, 102, 92, 103, 103, 62,
 92, 97, 97, 73, 103, 92, 73, 73,  0, 93, 73, 103, 103, 103, 103, 92,
 92, 103, 103, 92, 92, 73, 72, 73,  0, 102, 73,  0, 102, 102,  0, 102,
 70, 62, 93, 73, 93,  0, 93,  0, 73, 62, 103, 103, 93,  0,  0, 97,
  0, 93, 103, 62, 92, 93, 73, 93, 73, 103, 92, 92, 73, 92, 73, 97,
 102, 92, 103, 92, 93, 103, 73, 73, 73, 86, 103, 62, 97, 103, 102, 73,
 73, 92, 62, 73, 73, 73, 73, 62, 73, 103, 92, 93, 93, 62, 62, 88,
 86, 86, 72, 62,  0, 62,  0,  0,  0,  0, 102, 62,  0, 73, 86,  0,
 103, 62, 73, 62, 62, 86, 86, 62, 86, 73, 92, 92, 92, 92, 97, 103,
  0, 103, 92, 73, 103,  0,  0, 73, 73,  0,  0, 92, 103, 73, 73, 92,
 73, 73, 86, 86,  0, 73, 73, 73, 103, 73,  0, 92, 73, 62, 103, 73,
 62, 103,  0,  0, 73, 73, 73, 103, 92, 103, 103, 92, 92, 86, 92, 73,
 103, 73, 103, 92,  0, 92, 73, 103, 103, 92, 92, 73, 86, 73, 73, 62,
 103, 73, 92, 92, 92, 92, 103, 103, 103, 86, 73, 92, 92, 92, 103, 92,
 103, 62,  0, 103, 73, 103, 92, 62, 62, 92, 92,  0, 103, 62, 103, 92,
  0,  0, 73, 92, 103, 103, 103, 103, 92, 92, 62, 92,  0,  0, 92, 92,
 103, 62, 92, 103, 92, 92, 92, 103, 73, 92,  0, 73, 86, 92, 92, 103,
 73, 103, 103, 103, 103, 103, 73, 92, 103, 73, 73, 73, 86, 103, 103, 92,
 73, 92, 92, 92, 92, 62, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97,
 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 93, 93, 62, 88, 93,
 62, 62,  0, 93, 62, 62, 103, 86, 93, 97,  0, 97,  0, 92, 92, 92,
 93, 93, 92,  0, 73, 62, 70, 86, 62, 97, 86, 86, 86, 97, 70, 92,
 62, 70, 93,  0, 93, 93, 103, 97, 97, 73, 62, 103,  0, 103, 93,  0,
 70, 93, 103, 102, 93, 102, 73, 73, 97, 97, 86, 97, 97, 97, 97, 97,
 103, 73, 93, 103, 102, 93, 93,  0, 102, 88, 93, 93,  0, 93, 102, 86,
 93, 62,  0, 97, 92, 103, 103, 93, 93, 88, 92, 103, 73, 93, 103, 73,
 93, 93, 102, 93, 102, 93, 93,  0, 62, 97, 97, 93, 103, 93, 86, 93,
 93, 93, 97, 86, 93, 92, 93, 93, 62, 92, 93, 102, 73, 93, 93, 93,
 93, 93, 93, 92, 73,  0, 97, 86, 62, 62, 62,  0, 62, 102, 93, 102,
  0, 92, 92, 62, 103, 93, 93, 62, 93, 86,  0, 97, 93, 73, 93, 103,
  0, 93, 93, 62, 102, 86,  0, 93,  0, 92, 92, 92, 62, 93, 92, 93,
 93, 93, 93, 93, 92, 92, 86, 97, 93, 92,  0, 102, 92, 103, 92,  0,
 92, 86, 102, 93,  0, 88, 62, 103, 93, 92,  0, 73, 62, 93, 93, 92,
 103,  0, 92, 73, 102, 93, 92, 92, 92, 103, 92, 73, 92, 93, 73, 93,
 93, 92, 93, 93, 92, 103, 73, 92, 102, 86, 92, 102, 62, 73, 62, 92,
 103, 93,  0, 97, 73, 102,  0, 102, 103, 102,  0, 102,  0, 97, 73, 73,
 103, 102, 102, 93,  0, 103, 93, 73, 86,  0, 93,  0, 97,  0, 97, 93,
 102, 93, 103, 102, 102, 93, 102,  0, 93, 97, 97, 97,  0, 103, 102, 73,
  0, 93,  0, 103, 70, 102,  0, 102, 103,  0, 93, 73, 62,  0, 93, 97,
 97, 97, 62, 97, 73, 103, 73, 102, 103, 103, 73, 93, 102, 102,  0, 103,
 73, 93, 93, 73, 92, 103, 97, 97, 93, 73, 73, 102, 73, 93,  0, 102,
 103, 73, 73, 73, 102, 92, 62, 86, 97, 73, 73, 73, 73, 93, 102, 103,
 103, 73, 93, 73, 102, 103, 103, 73, 103, 73,  0, 73,  0, 103, 73, 73,
 103, 73, 92,  0, 103,  0, 103, 103, 103, 93, 103, 73, 103, 73, 102, 73,
 103, 73, 102, 102, 73, 62, 73, 103, 73, 103, 73, 73, 73, 92, 103, 102,
 92, 102, 92, 73, 103, 73, 103, 62, 73, 102, 103, 73, 62, 62, 73, 73,
 73, 73,  0, 102, 73, 73, 72, 103, 103, 93, 93, 93, 93, 93, 93, 102,
 72,  0, 93, 103, 86, 73, 92, 102, 92, 62, 102, 62,  0, 97, 97, 73,
 73, 102, 93, 93, 102, 93,  0, 62, 73, 93, 93,  0, 93, 62, 72, 72,
 97, 97, 93, 92, 102, 93, 97, 93, 93, 102, 103, 62,  0, 97, 97, 97,
 73, 103, 92, 103, 73, 102, 103, 93,  0, 93, 103, 93, 97, 93, 62, 73,
 93, 102, 93, 103, 62, 62,  0, 86, 62, 73, 72, 72, 92, 73, 103, 73,
 73, 103, 93, 72, 86, 73, 62, 73, 103,  0, 93, 92, 103, 102, 102, 93,
 103, 103, 103, 103, 93, 93, 62, 73, 86, 73, 93, 62, 103, 103, 73, 62,
 92, 92, 103, 103,  0, 103, 92, 93, 86, 93, 97, 92, 93, 93, 93, 93,
 92, 93,  0, 103, 103, 73, 86, 103, 92, 103, 103, 86, 93, 92, 62, 86,
  0, 86, 73, 92, 103, 62, 92, 92, 73, 103, 103, 73, 103, 103, 103, 62,
 62, 103,  0, 73, 73, 92, 86, 103, 73, 103,  0, 62, 86, 103,  0, 92,
 103, 103, 73, 73, 103, 103, 103, 103,  0, 103, 103,  0, 103, 92, 86, 73,
 103, 92, 103, 62, 92, 92, 103, 73, 62, 73, 73,  0, 103, 62, 92,  0,
  0,  0,  0, 103, 103, 103, 103, 73, 62, 86,  0,  0, 86, 73, 103, 62,
 103, 73, 73, 103, 92, 62, 103, 92, 103, 103, 103,  0, 62, 73, 103, 92,
 103,  0, 62, 62, 86, 92, 103, 62, 92, 92, 103, 92, 73, 103, 103, 103,
 92, 103, 73, 73, 73,  0, 73, 92, 62, 62, 92, 92, 62, 62, 92,  0,
 103, 103, 86, 73, 92, 103, 92, 103, 62, 62,  0,  0, 73, 73, 62, 103,
 103, 86, 73,  0, 97, 62, 103, 62, 103, 103, 73, 103, 103, 103, 92, 103,
 92,  0, 73, 92,  0, 92, 73, 73, 103, 62, 103, 73, 73, 103, 102,  0,
  0, 92, 62, 92, 73, 92, 92, 103, 92, 103, 92, 92, 92, 73,  0, 62,
 103, 73, 73, 73, 103, 103, 73, 103, 103, 73, 73, 103, 73, 86, 97, 62,
  0,  0, 103, 73, 73, 73, 103, 92, 62, 86, 62, 103, 103, 62,  0, 62,
 103, 103, 103, 103, 73, 103, 103, 103, 102, 73, 73, 103, 103, 103, 103, 92,
 103, 73, 92, 103,  0, 103,  0, 103, 103, 103,  0,  0, 62, 103, 73, 103,
 103, 103,  0, 62, 92, 62, 73, 103, 103, 92, 92,  0, 62, 86, 103, 73,
 103, 73, 86, 86,  0,  0,  0, 73, 92, 103, 92, 103, 92,  0, 73, 103,
 103, 73, 103,  0, 73,  0, 92,  0, 103, 73,  0, 73, 73, 103, 73, 92,
 92, 62, 73, 73, 103, 103, 73,  0, 92, 92, 92, 73, 62, 103, 103, 103,
 92, 103, 92, 92, 103, 103, 92, 103, 92, 103, 103, 92, 86, 73, 92, 92,
  0,  0, 86, 103, 103, 92, 103, 62, 73, 73, 86, 86, 73,  0, 97,  0,
  0,  0,  0,  0, 86,  0, 73, 103, 62, 103, 73, 92, 73, 92, 73, 73,
 103, 103, 103,  0, 92, 103, 92, 103, 103, 73, 103, 92, 92,  0, 103,  0,
 92, 73,  0, 73, 103, 103,  0, 103,  0, 62, 102,  0, 92, 103, 86, 62,
 103, 103,  0, 62, 62, 92, 103, 73,  0, 73, 103, 73, 92, 62, 92, 62,
 103, 62, 103, 73,  0,  0,  0,  0, 103, 73, 103, 62, 92, 103, 73, 102,
  0, 73, 103,  0, 92, 103, 92, 92, 103, 73, 92, 103,  0, 73, 103, 73,
  0, 103, 73, 103, 103, 73, 103, 92, 103, 103, 73, 62, 92, 86, 92, 73,
 92, 73, 73, 73, 103, 103, 62, 73,  0, 86, 62,  0,  0,  0,  0,  0,
 73, 62, 73, 92, 103, 62, 62, 103, 92, 62, 102, 62, 103, 103, 73, 73,
 92, 92, 73, 62, 73, 73, 93, 92, 92, 103, 73,  0, 103, 92, 103, 103,
  0, 92, 103, 73, 92, 86, 103, 103, 92,  0,  0,  0, 73,  0, 73,  0,
  0,  0,  0,  0,  0, 73, 73, 103, 103, 103, 103, 103, 73, 103, 73, 73,
 73, 62, 62, 92, 62,  0, 73, 92, 62, 103, 73, 73, 73, 103, 103, 103,
 92, 73, 73, 92, 92, 103, 103, 62, 92, 92, 86,  0,  0,  0,  0, 62,
 73, 86,  0,  0,  0,  0,  0,  0, 73, 73, 73, 92, 73,  0, 103, 62,
 73, 103, 103, 103, 62, 92, 92, 73, 92, 73, 92, 103, 73, 103, 97, 103,
 73, 86,  0, 62, 92, 103, 73, 73, 103, 73, 103, 73, 103,  0,  0, 73,
 73, 92, 92, 86,  0, 103,  0, 73,  0, 62, 86, 86, 62, 73, 92, 62,
 92, 62, 92, 103, 73,  0,  0,  0, 103, 73, 92, 102,  0, 103, 103, 103,
 92, 103, 103, 73, 73, 92, 73, 92, 73,  0,  0,  0, 92, 92, 92, 92,
 73, 92, 73, 103, 62, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97,  0, 97, 97, 97, 97,  0, 97,  0, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97,  0,
 97, 97, 97,  0,  0, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97,  0, 97, 97,  0, 97, 97, 97, 97,
 97, 97, 97, 97, 97,  0, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,
 97, 97, 97, 97,  0,  0, 97, 92, 62, 62, 73, 73, 73, 73, 62, 97,
 92,  0, 92, 92, 62,  0, 73, 86, 103, 92, 86, 92, 103, 103, 103, 92,
 73, 92, 73, 92, 92,  0, 86,  0, 92, 86,  0, 73, 73, 62, 103, 103,
 86, 103, 86, 92, 92, 92, 62, 86, 92, 103,  0, 103, 103, 92, 73,  0,
 73, 73, 86,  0, 62, 73, 103, 73,  0, 92, 103, 92, 92, 103, 92, 103,
 73,  0,  0, 92,  0, 73, 103, 92, 103, 103, 92, 103, 92, 92,  0,  0,
 103, 103, 103, 103, 92, 92, 92,  0, 86, 62, 103, 73, 92, 62, 103, 103,
 103, 92, 92, 73, 103, 92, 62,  0, 97, 97, 97, 97,  0, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0,
 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97,  0, 97, 97,  0, 93, 70, 103, 97,
 73, 93, 102, 73, 103, 62, 62,  0, 92,  0, 93,  0, 103, 73, 93, 92,
 73, 102, 93, 70, 97, 97, 97, 62, 62, 103, 103, 93, 102, 102,  0, 93,
 93, 62, 93, 73, 93, 97, 97, 97, 97, 97, 73, 93, 93, 93, 73, 92,
 93, 73, 62, 73, 102, 97, 62, 62, 103,  0,  0, 93, 92, 92, 92, 93,
  0, 102, 93, 92, 93, 86, 86, 97, 97, 97, 93, 73, 93, 73, 62, 73,
 92, 73, 93, 92, 102, 93, 93, 93, 92,  0, 86, 62, 103, 92, 103, 62,
 73, 62, 62, 103, 103, 93, 93, 73, 93, 103, 92, 93,  0, 93, 92, 88,
 97, 103, 73, 73, 93, 92, 62, 93, 93, 93, 62, 92, 93, 62, 73, 62,
 86, 73, 73, 86, 103, 62, 62, 93, 92, 103, 92,  0, 73,  0, 103, 62,
 93, 92, 86, 102, 92,  0, 88, 86, 92, 93, 62, 92, 93, 97, 97, 73,
 93, 93, 73, 73, 93, 93, 93, 93, 73, 93, 103, 92, 93, 93, 93, 97,
  0, 86, 102, 73, 73, 93, 92, 73, 103, 92, 103, 92, 92, 103, 103, 103,
 97, 73, 92, 92,  0, 73,  0,  0, 93, 102, 93, 86,  0,  0,  0, 102,
 92, 103, 92, 97,  0, 73, 93, 93, 73, 93, 103, 92,  0, 73, 97, 73,
 93, 97, 103, 62, 93, 103, 93, 93, 93, 102, 86, 73,  0, 93, 93, 93,
 73, 92, 73, 93,  0,  0, 93,  0, 73, 92, 62, 62, 93, 103, 93, 73,
 73, 62, 103, 103, 92, 73, 73, 92, 103, 73, 93, 73, 73, 97, 73, 73,
 93, 62, 93, 62,  0, 73,  0,  0, 93, 93, 73,  0,  0, 92, 93, 73,
  0, 62, 92, 103, 92,  0, 92, 73, 92, 92, 62, 73,  0,  0, 62, 62,
  0,  0, 93, 97,  0, 62, 93, 62, 103, 88, 103, 102, 92,  0, 93,  0,
 93, 93, 93, 62, 86, 97, 92, 62, 92, 93, 103, 86, 73, 86, 103,  0,
 73, 86, 73, 102, 93,  0, 102, 103, 103, 86, 92, 103, 93, 103, 73, 103,
 103, 92, 73, 73, 92, 93, 86,  0, 73, 62, 73, 93,  0, 93, 73, 92,
 86, 97, 97,  0, 72, 62, 62, 103, 93, 103, 103,  0, 92, 73, 103, 62,
 93, 73, 103, 93, 73, 73, 92,  0, 92,  0, 73, 93, 103, 93, 103, 97,
  0, 62, 70, 92, 88, 62, 103, 73, 62, 103, 62, 73, 62,  0, 62, 103,
  0, 103,  0, 92, 103, 103, 92, 103, 86, 103, 62, 92, 103, 103, 103, 73,
 103, 62,  0, 92, 103, 73, 73, 103, 103, 103,  0, 62, 92, 103, 103, 73,
 62, 103,  0, 73, 62, 73, 97, 97,  0, 97, 97, 97, 97, 93, 86, 62,
 73, 103, 86, 93, 62, 88, 93, 62, 103, 73, 103, 92,  0, 73, 73, 92,
 73, 92, 92, 92, 73, 92, 92, 103, 92,  0, 103,  0, 92, 103, 103, 92,
 92, 92, 92, 92, 62,  0, 103, 92, 92, 62, 86, 73, 103, 73, 103,  0,
 103, 92,  0, 62, 92, 62, 103, 73, 73, 73,  0, 103, 86, 92, 62, 103,
 103,  0, 103, 62, 86, 103,  0, 92, 92, 73,  0, 92, 86, 86, 62,  0,
  0, 73,  0, 73, 103, 73, 92, 62, 73, 73, 103, 86, 92, 92, 92, 92,
 73, 103, 103, 103, 86, 86, 62, 103, 92, 103, 62, 92, 73, 73, 92, 73,
 73,  0, 103, 103, 73, 103, 62, 92,  0, 73, 103, 92, 62,  0,  0, 92,
 92, 92, 73, 92, 92, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97,  0, 97,
 97, 97,  0, 97, 97,  0, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97, 92, 73, 86, 62, 73, 103, 103, 92,
 62, 92, 73, 73, 62,  0, 92, 62, 103,  0, 103, 103, 73, 73, 73, 103,
 73, 73, 103, 86, 92, 62, 92,  0, 62, 73,  0, 73, 103,  0, 97,  0,
  0, 97, 97, 97,  0, 97,  0,  0, 97, 97, 97, 92, 86,  0, 97, 93,
  0, 62, 92, 103,  0, 103, 62, 102, 97, 92, 103, 92,  0, 92, 86, 92,
  0,  0, 92, 62, 92,  0, 103,  0,  0, 73, 73,  0, 92, 92, 92,  0,
 73,  0, 103, 92,  0, 92,  0, 103, 103, 92, 92,  0, 92, 97,  0,  0,
 93, 103, 92, 92, 92, 103, 103, 103, 92,  0, 103, 103, 62, 86, 92, 103,
 86, 92, 62,  0, 92, 73, 62, 103, 92, 73, 73, 103, 92, 73, 93, 73,
 73, 103, 103, 103, 62, 103,  0,  0,  0, 62, 103, 62, 103, 92, 92, 73,
 62, 103, 86, 73,  0, 92, 62, 103, 103, 92,  0, 92, 92, 62, 103,  0,
 92, 92, 92, 73, 102, 93, 73, 92, 103, 103,  0, 103, 103,  0, 103, 103,
 62, 73,  0, 97,  0, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97,  0,  0, 97,  0, 97, 97,  0, 97,
 97, 97,  0,  0, 97, 97, 97, 97, 97,  0, 97, 97,  0, 97,  0, 97,
 97, 97, 97, 97, 97, 97, 93, 93, 93, 93,  0, 62, 73, 103, 73, 62,
  0, 73,  0, 73,  0, 93, 103, 73, 93,  0,  0, 73, 92, 92, 92, 73,
 103, 103, 103, 92, 92, 103,  0,  0,  0, 103, 103, 73, 86, 103,  0, 62,
  0, 92, 73, 103, 86, 86, 86, 73, 86, 103,  0, 73, 73, 73, 73, 73,
 92, 92, 92, 103, 103, 92, 73, 73, 92, 103, 62, 92, 103, 92, 62, 92,
  0,  0, 92, 73, 73, 73,  0, 103,  0, 73, 103, 62, 103, 92, 92,  0,
 103, 92, 86,  0, 103, 62, 73, 73, 92, 103, 73, 92, 73, 103, 103, 92,
  0, 92, 103, 103, 103, 92, 73, 73,  0, 73, 73, 103, 62, 73, 92, 92,
 62, 103, 86, 86, 73, 73, 103,  0,  0, 92, 73, 73, 73, 73, 103,  0,
 103,  0, 103, 103, 103, 73,  0, 103, 86, 73, 73, 92, 73, 103, 103,  0,
 92, 73, 73, 62, 73, 103, 103, 92, 103, 73, 73,  0,  0, 73, 92, 73,
 92, 103, 92, 92, 103, 92, 73, 62, 73, 73, 103, 62, 103, 92, 103, 73,
 73, 62, 73, 73, 103, 92, 103, 92,  0, 73, 92, 92,  0, 62, 73, 92,
 73,  0, 92,  0, 92, 92, 73, 73, 73, 92, 92, 92, 97, 97, 97, 97,
 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97, 97,  0, 97, 97, 97,  0,  0, 97,
 97, 97, 97, 97,  0,  0, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97,  0, 97, 93,  0, 62, 73, 62, 92, 62, 103,
 93, 72, 62, 73, 103, 62, 70, 72, 93, 103, 97, 103, 93,  0, 103, 103,
 93, 102, 72, 62, 86, 97, 103, 73, 62,  0, 73, 97, 97, 73, 62, 92,
 103, 93, 103, 93, 92, 103, 103, 62, 93,  0,  0, 62, 103,  0, 86, 93,
 62, 72, 86, 92, 62, 62, 93, 103,  0, 62, 86, 93, 103, 93, 92, 93,
  0, 92, 103, 103, 86, 62, 73, 92,  0, 102, 103, 93, 73, 103, 73, 62,
 62, 103, 62, 102, 103, 103, 92,  0, 102, 62, 73, 103, 103, 103, 103, 97,
 103, 73, 103, 97,  0, 73, 103, 73, 92, 103, 92, 62, 62,  0, 73, 93,
 103,  0, 92, 93, 73, 92, 62, 92, 92, 92, 86, 103,  0, 62, 92, 93,
  0, 92, 93, 103, 62, 103,  0, 103,  0, 62, 103, 93, 93, 62, 73, 73,
  0, 93, 93, 93, 93, 93, 73, 97, 102, 97, 73, 103, 103, 93, 92, 93,
  0, 93, 73,  0, 93, 103, 103, 62, 92, 73, 92, 103,  0,  0, 62, 73,
 73, 103,  0, 62, 73, 62, 103, 73, 103,  0, 62, 62, 103, 62, 62, 92,
 73, 73,  0, 62, 92, 103, 73, 103, 62, 62, 73, 73, 73, 73, 73, 62,
 103,  0, 73, 86, 62, 103, 103, 103, 73, 62, 62, 62,  0, 62, 86, 62,
 103, 92, 92, 92, 62, 73, 86, 86,  0,  0, 103, 73,  0, 62, 103, 86,
 92, 73, 73,  0, 73, 73, 103, 62, 92, 62, 92, 92, 62, 92, 92, 73,
 62, 62, 62,  0, 86, 73, 73, 62, 103, 92,  0, 62, 62, 73, 62, 103,
 92, 103,  0, 73, 73,  0, 92, 103, 103, 92, 92,  0,  0,  0, 62, 86,
 62, 86, 86, 73, 92, 73, 92, 103, 62, 73, 73, 92, 73, 62, 73, 62,
 73, 92, 92, 86, 92, 103, 73, 103, 92,  0, 103, 103, 73,  0,  0, 62,
 92, 86, 86, 62,  0, 86,  0, 103, 103, 62, 62,  0,  0, 103,  0, 62,
 62,  0, 62,  0, 86, 73, 92, 73, 92, 92, 86, 103, 86, 92, 73, 62,
 86, 62, 92, 92, 92, 86, 62, 73, 62, 62, 62, 86, 103, 73, 62,  0,
  0, 92, 62, 103, 92, 92, 62, 62, 103, 103, 62, 73, 73, 92, 86, 86,
 86, 103, 92, 73, 73, 62, 103, 103,  0, 92, 86, 92, 73, 103, 92, 73,
 73, 103,  0, 62, 103, 62, 92, 86, 92, 103, 103, 73, 73, 73, 103, 62,
 103,  0, 92, 62, 103, 73, 103, 92, 103, 73, 86, 62, 62, 62, 103, 103,
 92,  0, 73, 103,  0,  0, 73, 92, 103, 62, 62, 62,  0, 73, 103,  0,
 62, 73, 62, 73, 73, 103, 86, 103, 92, 73, 73, 62, 97,  0,  0, 97,
  0, 97, 97,  0,  0, 97, 97, 97, 97,  0,  0, 97,  0, 97, 97,  0,
 97, 97, 97,  0, 97, 97,  0,  0,  0,  0, 97, 97, 97,  0, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,  0, 97, 97,  0,
 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97,  0,  0,
  0,  0,  0, 97, 97, 97, 97, 97,  0,  0, 97, 97, 97, 97, 97, 97,
 97,  0,  0, 97, 97, 97, 97, 97, 97, 97,  0,  0, 97, 97, 97, 97,
  0,  0, 97,  0,  0, 92, 103, 92,  0, 92, 73, 86, 86, 73,  0,  0,
 86, 73, 103, 92, 92, 73, 92, 103,  0, 103, 73, 73, 73, 73,  0, 73,
 73,  0, 62, 92, 73, 73, 92, 92, 92, 92,  0, 62,  0,  0, 86,  0,
 73, 62, 92,  0, 73, 92,  0, 103, 103, 73,  0, 92, 62, 103, 103, 92,
 73,  0, 73, 92,  0, 73, 92,  0, 92, 73, 86, 86, 86, 73, 73, 103,
 103, 73, 62, 103, 62,  0, 73, 73, 73,  0, 62, 92, 62, 103, 92, 92,
 73, 92, 103, 103, 86, 103, 86, 62, 86,  0, 103, 73, 73,  0,  0, 73,
 86, 92, 73, 103, 103,  0, 73, 73, 73, 92, 73, 73, 92, 92, 86, 103,
 92, 92, 62, 62, 86, 62,  0, 73, 73, 103, 103, 103, 92,  0,  0, 92,
 103, 73, 92, 73, 73, 73, 62, 103, 73, 73, 86, 103, 62, 73, 62, 73,
 73, 73, 73, 62, 103, 73, 103, 92, 73, 92, 103, 73, 73, 62, 62, 86,
 73,  0, 103, 62, 73, 62, 103, 103, 103, 73, 92, 73, 73, 73, 73, 73,
 73, 103, 73, 73, 92,  0, 73, 73, 73, 92, 103, 86, 103, 73, 62, 92,
  0, 103, 92, 73, 92, 103, 73, 73, 92, 103, 92, 92, 103,  0, 73, 103,
  0, 92, 92, 103, 86, 73, 86, 103, 73, 62, 103, 73, 73, 73, 73, 92,
 73, 73, 73, 92, 62, 103, 103, 103, 73, 92, 103, 73, 73, 73, 103, 103,
 62, 73, 73, 73, 73, 103, 92, 62, 73, 103,  0, 103, 73, 92, 103, 92,
 103,  0, 92, 103, 103, 73, 73, 73, 92, 92, 92, 73,  0, 92, 103, 73,
 73, 73, 103, 73, 73, 73, 73, 103,  0, 73, 62, 73,  0, 73, 62, 73,
 103, 103, 103, 73, 73, 103, 62, 73,  0, 103, 92, 92, 62, 103, 92, 97,
 97, 97, 97, 97,  0, 97, 97,  0, 97, 97, 97, 97, 97, 97,  0, 97,
  0, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,  0,  0, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97,
  0, 97,  0,  0,  0, 97,  0, 97, 97,  0, 97, 97, 97,  0, 97,  0,
  0,  0,  0, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,  0,  0,
 97, 97,  0, 97,  0, 92,  0,  0, 86, 92, 103, 62, 103, 92, 97, 93,
 103, 86, 102, 103, 62, 62, 73, 102, 93, 73, 73, 93, 92, 73, 103, 62,
  0, 92, 93, 93, 73, 86, 62, 92, 62, 73, 73, 103, 73, 93, 62, 93,
 73, 73,  0,  0, 103, 92, 88, 73, 62, 92, 86,  0, 62, 92, 103, 62,
 103,  0,  0, 62, 102, 103, 73, 73, 88, 86, 86, 93, 92, 97, 93, 86,
 73,  0, 73, 73, 88,  0, 62,  0, 103, 97,  0, 62, 92, 93, 93, 93,
 92, 72, 86, 73, 93, 103, 73,  0, 93, 86, 73, 93, 93, 93, 92, 102,
 93,  0, 97,  0, 103, 93, 73, 102, 92, 97, 97, 73, 62, 103, 103, 93,
 103, 62, 103, 73, 92, 103, 92, 92, 62, 93, 73, 93, 93, 92, 97, 103,
 73, 73, 62, 62,  0,  0, 73, 92, 86, 103, 73, 97,  0, 97, 93, 103,
 102, 62, 103, 93, 62, 92, 103, 70, 73, 102, 103, 103, 73,  0, 73, 62,
 93, 86, 102, 73, 73, 73, 62,  0, 73, 73, 103, 103, 93, 73, 73, 102,
 73, 103, 103, 73, 103, 73, 73, 102, 73, 70, 62, 93, 62, 102, 93, 62,
 73, 103, 73, 103, 70, 62, 103, 103, 73, 73, 92, 92, 73, 73, 92, 92,
 97, 97, 92, 62, 92, 103, 103, 103, 103, 73, 62, 73, 73, 103, 103, 92,
 92, 92, 86, 92, 73, 73, 92, 92, 62, 62, 92, 73, 92, 62, 103, 103,
 103, 103, 92, 62, 73, 103, 92, 92, 73, 73, 103, 73,  0, 62, 73, 97,
 97,  0,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 92,  0, 62,
 103, 103, 103,  0, 103, 92, 62, 62, 73, 97, 97, 97, 92, 86, 62, 97,
 93, 62, 103, 62, 73, 62,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73, 73,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 73, 73,  0, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73,  0,  0,  0,  0, 73, 73, 73, 73, 73, 73, 73,
 73,  0, 73,  0, 73, 73, 73, 73,  0, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73,  0,  0, 73, 73, 73,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 93, 97, 93, 93, 93, 93, 97, 93, 93, 93, 93, 93, 72, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 88, 72, 88, 88, 93,
 88, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 97,  0,
  0, 104, 104, 104, 94, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 97, 97,  0, 88,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 105,
};
