# Note that this is NOT a relocatable package
%define name		nautilus
%define ver		1.1.1
%define RELEASE		0_cvs_0
%define rel		%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Name:		%name
Vendor:		GNOME
Distribution:	CVS
Summary:	Nautilus component for use with Mozilla
Version: 	%ver
Release: 	%rel
Copyright: 	GPL
Group:		User Interface/Desktop
Source: 	ftp://ftp.gnome.org/pub/GNOME/stable/sources/%{name}-%{ver}.tar.gz
URL: 		http://nautilus.eazel.com/
BuildRoot:	/var/tmp/%{name}-%{ver}-root

Requires:	GConf >= @GCONF_REQUIRED@
Requires:	bonobo-activation >= @BONOBO_ACTIVATION_REQUIRED@
Requires:	eel >= 1.1.1
Requires:	gdk-pixbuf >= @GDK_PIXBUF_REQUIRED@
Requires:	glib >= @GLIB_REQUIRED@
Requires:	gnome-vfs >= 1.1
Requires:	gtk+ >= @GTK_REQUIRED@
Requires:	mozilla >= 0.9.5
Conflicts:	mozilla = M18
Conflicts:	mozilla = M17

BuildRequires:	GConf-devel >= @GCONF_REQUIRED@
BuildRequires:	bonobo-activation-devel >= @BONOBO_ACTIVATION_REQUIRED@
BuildRequires:	eel-devel >= 1.1.1
BuildRequires:	gdk-pixbuf-devel >= @GDK_PIXBUF_REQUIRED@
BuildRequires:	glib-devel >= @GLIB_REQUIRED@
BuildRequires:	gnome-vfs-devel >= 1.1
BuildRequires:	gtk+-devel >= @GTK_REQUIRED@
BuildRequires:	mozilla-devel >= 0.9.5

%description
This enables the use of embedded Mozilla as a Nautilus component.

%prep
%setup

%build
%ifarch alpha
	MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

LC_ALL=""
LINGUAS=""
LANG=""
export LC_ALL LINGUAS LANG

## Warning!  Make sure there are no spaces or tabs after the \ 
## continuation character, or else the rpm demons will eat you.
CFLAGS="$RPM_OPT_FLAGS -DENABLE_SCROLLKEEPER_SUPPORT" ./configure \
    $MYARCH_FLAGS --enable-more-warnings \
    --prefix=%{_prefix} --datadir=%{_datadir} \
    --sysconfdir=%{_sysconfdir} --includedir=%{_includedir} \
    --libdir=%{_libdir} --bindir=%{_bindir}

make -k
make check

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make -k prefix=$RPM_BUILD_ROOT/%{_prefix} \
    sysconfdir=$RPM_BUILD_ROOT/%{_sysconfdir} \
    datadir=$RPM_BUILD_ROOT/%{_datadir} \
    includedir=$RPM_BUILD_ROOT/%{_includedir} \
    libdir=$RPM_BUILD_ROOT/%{_libdir} \
    bindir=$RPM_BUILD_ROOT/%{_bindir} install

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
if ! grep %{_libdir} /etc/ld.so.conf > /dev/null ; then
	echo "%{_libdir}" >> /etc/ld.so.conf
fi
/sbin/ldconfig

%postun -p /sbin/ldconfig

%files

%defattr(0555, bin, bin)
%{_bindir}/nautilus-mozilla-content-view

%defattr(0444, bin, bin)
%{_libdir}/bonobo/servers/Nautilus_View_mozilla.server
