/*
 * Nautilus Actions
 * A Nautilus extension which offers configurable context menu actions.
 *
 * Copyright (C) 2005 The GNOME Foundation
 * Copyright (C) 2006, 2007, 2008 Frederic Ruaudel and others (see AUTHORS)
 * Copyright (C) 2009, 2010 Pierre Wieser and others (see AUTHORS)
 *
 * This Program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This Program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this Library; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *   Frederic Ruaudel <grumz@grumz.net>
 *   Rodrigo Moya <rodrigo@gnome-db.org>
 *   Pierre Wieser <pwieser@trychlos.org>
 *   ... and many others (see AUTHORS)
 */

#ifndef __NAGP_GCONF_PROVIDER_H__
#define __NAGP_GCONF_PROVIDER_H__

/**
 * SECTION: nagp_gconf_provider
 * @short_description: #NagpGConfProvider class definition.
 * @include: na-gconf-provider.h
 *
 * This class manages the GConf I/O storage subsystem, or, in other words,
 * the GConf subsystem as an #NAIIOProvider. As this, it should only be
 * used through the #NAIIOProvider interface.
 *
 * #NagpGConfProvider uses #NAGConfMonitor to watch at the configuration
 * tree. Modifications are notified to the #NAIIOProvider interface.
 */

#include <glib-object.h>
#include <gconf/gconf-client.h>

G_BEGIN_DECLS

#define NAGP_GCONF_PROVIDER_TYPE				( nagp_gconf_provider_get_type())
#define NAGP_GCONF_PROVIDER( object )			( G_TYPE_CHECK_INSTANCE_CAST( object, NAGP_GCONF_PROVIDER_TYPE, NagpGConfProvider ))
#define NAGP_GCONF_PROVIDER_CLASS( klass )		( G_TYPE_CHECK_CLASS_CAST( klass, NAGP_GCONF_PROVIDER_TYPE, NagpGConfProviderClass ))
#define NAGP_IS_GCONF_PROVIDER( object )		( G_TYPE_CHECK_INSTANCE_TYPE( object, NAGP_GCONF_PROVIDER_TYPE ))
#define NAGP_IS_GCONF_PROVIDER_CLASS( klass )	( G_TYPE_CHECK_CLASS_TYPE(( klass ), NAGP_GCONF_PROVIDER_TYPE ))
#define NAGP_GCONF_PROVIDER_GET_CLASS( object )	( G_TYPE_INSTANCE_GET_CLASS(( object ), NAGP_GCONF_PROVIDER_TYPE, NagpGConfProviderClass ))

typedef struct NagpGConfProviderPrivate      NagpGConfProviderPrivate;

/* private instance data
 */
struct NagpGConfProviderPrivate {
	gboolean     dispose_has_run;
	GConfClient *gconf;
	GList       *monitors;
	guint        event_source_id;
	GTimeVal     last_event;
};

typedef struct {
	GObject                   parent;
	NagpGConfProviderPrivate *private;
}
	NagpGConfProvider;

typedef struct NagpGConfProviderClassPrivate NagpGConfProviderClassPrivate;

typedef struct {
	GObjectClass                   parent;
	NagpGConfProviderClassPrivate *private;
}
	NagpGConfProviderClass;

GType nagp_gconf_provider_get_type     ( void );
void  nagp_gconf_provider_register_type( GTypeModule *module );

G_END_DECLS

#endif /* __NAGP_GCONF_PROVIDER_H__ */
